<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'bigbluebuttonbn', language 'de', version '3.5'.
 *
 * @package     bigbluebuttonbn
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityoverview'] = 'Sie haben anstehende Meetings mit BigBlueButton.';
$string['bbbduetimeoverstartingtime'] = 'Die Endzeit muss später als die Anfangszeit sein.';
$string['bbbdurationwarning'] = 'Dieses Meeting dauert maximal %duration% Minuten.';
$string['bbbrecordallfromstartwarning'] = 'Dieses Meeting wird von Anfang an aufgezeichnet.';
$string['bbbrecordwarning'] = 'Dieses Meeting kann aufgezeichnet werden.';
$string['bigbluebuttonbn'] = 'BigBlueButton';
$string['bigbluebuttonbn:addinstance'] = 'Neues Meeting anlegen';
$string['bigbluebuttonbn:join'] = 'An einem Meeting teilnehmen';
$string['bigbluebuttonbn:managerecordings'] = 'Aufzeichnungen verwalten';
$string['bigbluebuttonbn:meeting'] = 'Instanzen mit Live-Meeting-Funktionen erstellen';
$string['bigbluebuttonbn:recording'] = 'Instanzen mit Aufzeichnungsfunktion erstellen';
$string['bigbluebuttonbn:view'] = 'Meeting anzeigen';
$string['calendarstarts'] = '{$a} ist vorgesehen für';
$string['completionattendance'] = 'Teilnehmer/innen müssen am Meeting teilnehmen für:';
$string['completionattendancedesc'] = 'Teilnehmer/innen müssen am Meeting teilnehmen und mindestens {$a} Minute(n) bleiben.';
$string['completionattendancegroup'] = 'Anwesenheit erforderlich';
$string['completionattendancegroup_help'] = 'Die Anwesenheit im Meeting für (n) Minuten ist für den Abschluss erforderlich.';
$string['completionengagementchats'] = 'Chatereignisse';
$string['completionengagementdesc'] = 'Teilnehmer/innen müssen während des Meetings an Aktivitäten teilnehmen';
$string['completionengagementemojis'] = 'Emojis';
$string['completionengagementgroup'] = 'Teilnahme erforderlich';
$string['completionengagementgroup_help'] = 'Aktive Teilnahme während der Sitzung ist für den Abschluss erforderlich.';
$string['completionengagementpollvotes'] = 'Abstimmungen';
$string['completionengagementraisehand'] = 'Zuwortmelde-Ereignisse';
$string['completionengagementtalks'] = 'Gesprächsereignisse';
$string['completionengagementtalktime'] = 'Redezeit';
$string['completionupdatestate'] = 'Status der Abschlussüberprüfung';
$string['completionvalidatestate'] = 'Abschluss überprüfen';
$string['completionvalidatestatetriggered'] = 'Die Abschlussüberprüfung wurde angestoßen.';
$string['config_clienttype'] = 'Einstellungen für den "WebClient"';
$string['config_clienttype_default'] = 'WebClient standardmäßig';
$string['config_clienttype_default_description'] = 'Wählen Sie den HTML5-Client oder den veralteten Adobe-Flash-Client.';
$string['config_clienttype_description'] = 'Diese Option legt fest, dass der WebClient für jedes Meeting festgelegt werden kann.';
$string['config_clienttype_editable'] = 'WebClient bearbeitbar';
$string['config_clienttype_editable_description'] = 'Diese Option legt fest, dass der WebClient in den Einstellungen ausgewählt werden kann.';
$string['config_default_messages'] = 'Standardmitteilungen';
$string['config_default_messages_description'] = 'Standardmitteilung für Aktivität festlegen';
$string['config_disablecam_default'] = '"Webcams sperren" standardmäßig aktiviert';
$string['config_disablecam_default_description'] = 'Diese Option "Webcams sperren" ist standardmäßig aktiviert.';
$string['config_disablecam_editable'] = '"Webcams sperren" bearbeitbar';
$string['config_disablecam_editable_description'] = 'Die Option "Webcams sperren" kann bearbeitet werden, wenn die Instanz angelegt oder aktualisiert wird.';
$string['config_disablemic_default'] = '"Mikrofone sperren" standardmäßig aktiviert';
$string['config_disablemic_default_description'] = 'Diese Option "Mikrofone sperren" ist standardmäßig aktiviert.';
$string['config_disablemic_editable'] = '"Mikrofone sperren" bearbeitbar';
$string['config_disablemic_editable_description'] = 'Die Option "Mikrofone sperren" kann bearbeitet werden, wenn die Instanz angelegt oder aktualisiert wird.';
$string['config_disablenote_default'] = '"Geteilte Notizen sperren" standardmäßig aktiviert';
$string['config_disablenote_default_description'] = 'Diese Option "Geteilte Notizen sperren" ist standardmäßig aktiviert.';
$string['config_disablenote_editable'] = '"Geteilte Notizen sperren" bearbeitbar';
$string['config_disablenote_editable_description'] = 'Die Option "Geteilte Notizen sperren" kann bearbeitet werden, wenn die Instanz angelegt oder aktualisiert wird.';
$string['config_disableprivatechat_default'] = '"Private Chats sperren" standardmäßig aktiviert';
$string['config_disableprivatechat_default_description'] = 'Diese Option "Private Chats sperren" ist standardmäßig aktiviert.';
$string['config_disableprivatechat_editable'] = '"Private Chats sperren" bearbeitbar';
$string['config_disableprivatechat_editable_description'] = 'Die Option "Private Chats sperren" kann bearbeitet werden, wenn die Instanz angelegt oder aktualisiert wird.';
$string['config_disablepublicchat_default'] = '"Öffentlichen Chat sperren" standardmäßig aktiviert';
$string['config_disablepublicchat_default_description'] = 'Diese Option "Öffentlichen Chat sperren" ist standardmäßig aktiviert.';
$string['config_disablepublicchat_editable'] = '"Öffentlichen Chat sperren" bearbeitbar';
$string['config_disablepublicchat_editable_description'] = 'Die Option "Öffentlichen Chat sperren" kann bearbeitet werden, wenn die Instanz angelegt oder aktualisiert wird.';
$string['config_experimental_features'] = 'Einstellungen für experimentelle Optionen';
$string['config_experimental_features_description'] = 'Einstellungen für experimentelle Optionen';
$string['config_extended_capabilities'] = 'Einstellungen für erweiterte Funktionen';
$string['config_extended_capabilities_description'] = 'Erweiterungen konfigurieren, falls der BigBlueButton-Server dies unterstützt.';
$string['config_general'] = 'Grundeinstellungen';
$string['config_general_description'] = 'Diese Einstellungen werden <b>immer</b> benutzt.';
$string['config_hideuserlist_default'] = '"Teilnehmerliste verbergen" standardmäßig aktiviert';
$string['config_hideuserlist_default_description'] = 'Diese Option "Teilnehmerliste verbergen" ist standardmäßig aktiviert.';
$string['config_hideuserlist_editable'] = '"Teilnehmerliste verbergen" bearbeitbar';
$string['config_hideuserlist_editable_description'] = 'Die Option "Teilnehmerliste verbergen" kann bearbeitet werden, wenn die Instanz angelegt oder aktualisiert wird.';
$string['config_importrecordings'] = 'Einstellungen für den Aufzeichnungsimport';
$string['config_importrecordings_description'] = 'Diese Einstellungen sind nur für den Aufzeichnungsimport relevant.';
$string['config_importrecordings_enabled'] = 'Aufzeichnungsimport einschalten';
$string['config_importrecordings_enabled_description'] = 'Wenn diese Option und die Aufzeichnungsfunktion eingeschaltet sind, können Sie Aufzeichnungen aus anderen Kursen importieren.';
$string['config_importrecordings_from_deleted_enabled'] = 'Aufzeichnungsimport aus gelöschten Aktivitäten';
$string['config_importrecordings_from_deleted_enabled_description'] = 'Wenn diese Option und die Aufzeichnungsimportfunktion eingeschaltet sind, können Sie Aufzeichnungen aus gelöschten Aktivitäten importieren.';
$string['config_lockedlayout_default'] = '"Sitzungslayout sperren" standardmäßig aktiviert';
$string['config_lockedlayout_default_description'] = 'Diese Option "Sitzungslayout sperren" ist standardmäßig aktiviert.';
$string['config_lockedlayout_editable'] = '"Sitzungslayout sperren" bearbeitbar';
$string['config_lockedlayout_editable_description'] = 'Die Option "Sitzungslayout sperren" kann bearbeitet werden, wenn die Instanz angelegt oder aktualisiert wird.';
$string['config_lockonjoin_default'] = '"lockOnJoin ignorieren" standardmäßig aktiviert';
$string['config_lockonjoin_default_description'] = 'Die Einstellung "lockOnJoin" wird ignoriert, wenn diese Option aktiviert ist.';
$string['config_lockonjoin_editable'] = '"lockOnJoin" bearbeitbar';
$string['config_lockonjoin_editable_description'] = 'Die Option "lockOnJoin" kann bearbeitet werden, wenn die Aktivität angelegt oder aktualisiert wird.';
$string['config_lockonjoinconfigurable_default'] = 'Sperreinstellungen standardmäßig aktiviert';
$string['config_lockonjoinconfigurable_default_description'] = 'Diese Option legt fest, dass die Sperreinstellungen über die vorherigen Kontrollfelder aktiviert oder deaktiviert werden können.';
$string['config_lockonjoinconfigurable_editable'] = 'Sperreinstellungen bearbeitbar';
$string['config_lockonjoinconfigurable_editable_description'] = 'Die standardmäßigen Sperreinstellungen können bearbeitet werden, wenn die Instanz angelegt oder aktualisiert wird.';
$string['config_locksettings'] = 'Einstellungen für Sperroptionen';
$string['config_locksettings_description'] = 'Diese Einstellungen aktivieren oder deaktivieren verschiedene Sperroptionen in der Nutzeroberfläche. Außerdem werden standardmäßige Werte für diese Sperroptionen festgelegt.';
$string['config_meetingevents_enabled'] = 'Registrieren von Meeting-Events';
$string['config_meetingevents_enabled_description'] = 'Aktivieren Sie das Plugin zum Akzeptieren und Verarbeiten von Live-Ereignissen nach Beendigung der Sitzung. Es muss für den "Aktivitätsabschluss" aktiviert sein und funktioniert nur, wenn der BigBlueButton-Server post_events-Skripte verarbeiten kann.';
$string['config_muteonstart'] = 'Einstellungen für "Beim Start stumm schalten "';
$string['config_muteonstart_default'] = '"Beim Start stummschalten " standardmäßig aktiviert';
$string['config_muteonstart_default_description'] = 'Diese Option legt fest, dass das Meeting standardmäßig mit ausgeschalteten Mikrofonen beginnt.';
$string['config_muteonstart_description'] = 'Diese Einstellungen aktivieren bzw. deaktivieren Optionen in der Nutzeroberfläche. Außerdem definieren sie Standardwerte für einige Optionen.';
$string['config_muteonstart_editable'] = '"Beim Start stummschalten" bearbeitbar';
$string['config_muteonstart_editable_description'] = 'Die Option "Beim Start stummschalten" kann bearbeitet werden, wenn die Aktivität angelegt oder aktualisiert wird.';
$string['config_participant'] = 'Teilnehmereinstellung';
$string['config_participant_description'] = 'Diese Einstellungen definieren die voreingestellte Rolle von Teilnehmer/innen im Meeting.';
$string['config_participant_moderator_default'] = 'Standardmäßige Moderator/innen';
$string['config_participant_moderator_default_description'] = 'Diese Voreinstellungen werden für neu eingerichtete Räume verwendet.';
$string['config_presentation_default'] = 'Standardmäßige Datei für die Funktion "Präsentation vorher hochladen"';
$string['config_presentation_default_description'] = 'Mit dieser Einstellung können Sie eine Datei festlegen, die in allen BBB-Instanzen als Standard verwendet werden soll, wenn die Option "Präsentation vorher hochladen" aktiviert ist.';
$string['config_preuploadpresentation'] = 'Einstellungen für das Vorabladen einer Präsentation';
$string['config_preuploadpresentation_description'] = 'Hier können Sie Einstellungen für die Darstellung hochgeladener Präsentationen vornehmen, wenn der Moodle-Server erreichbar ist.';
$string['config_preuploadpresentation_enabled'] = 'Vorabladen einer Präsentation aktiviert';
$string['config_preuploadpresentation_enabled_description'] = 'Das Vorabladen einer Präsentation wird aktiviert, sobald ein Raum oder eine Konferenz hinzugefügt oder geändert wird.';
$string['config_recording'] = 'Einstellungen für die Aufzeichnungsfunktion';
$string['config_recording_all_from_start_default'] = 'Von Anfang an aufzeichnen';
$string['config_recording_all_from_start_default_description'] = 'Wenn diese Option aktiviert ist, wird die Sitzung vollständig von Anfang an aufgezeichnet';
$string['config_recording_all_from_start_editable'] = '\'Von Anfang an aufzeichnen\' bearbeitbar';
$string['config_recording_all_from_start_editable_description'] = 'Wenn diese Option aktiviert ist, erhält die Oberfläche eine Option, um alles von Anfang an aufzeichnen zu aktivieren oder deaktivieren.';
$string['config_recording_default'] = 'Aufzeichnungsfunktion ist automatisch aktiviert';
$string['config_recording_default_description'] = 'Wenn diese Option aktiviert wird, steht die Aufzeichnungsfunktion in neuen Sessions zur Verfügung.';
$string['config_recording_description'] = 'Diese Einstellungen sind funktionsabhängig.';
$string['config_recording_editable'] = 'Aufzeichnungsfunktion bearbeitbar';
$string['config_recording_editable_description'] = 'Wenn diese Option aktiviert ist, kann die Aufzeichnungsfunktion aktiviert oder deaktiviert werden.';
$string['config_recording_hide_button_default'] = 'Aufzeichnungsbutton verbergen';
$string['config_recording_hide_button_default_description'] = 'Wenn diese Option aktiviert ist, wird der Aufzeichnungsbutton verborgen';
$string['config_recording_hide_button_editable'] = 'Aufzeichnungsbutton kann verborgen werden';
$string['config_recording_hide_button_editable_description'] = 'Wenn diese Option aktiviert ist, erhält die Oberfläche eine Option, um das Verbergen des Aufzeichnungsbuttons zu aktivieren oder deaktivieren.';
$string['config_recording_icons_enabled'] = 'Icons für das Aufzeichnungsmanagement';
$string['config_recording_icons_enabled_description'] = 'Wenn dies aktiviert wird, stellt BBB Icons zum Veröffentlichen, Zurückziehen und Löschen bereit.';
$string['config_recordingready_enabled'] = 'Systemnachrichten senden, wenn eine Aufzeichnung fertig ist.';
$string['config_recordingready_enabled_description'] = 'Ein Hinweis wird gesendet, wenn die Aufzeichnung fertig ist. Diese Option funktioniert nur, wenn das Script post_publish_recording_ready_callback auf dem Server aktiviert ist.';
$string['config_recordings'] = 'Einstellungen für "Aufzeichnungen anzeigen".';
$string['config_recordings_deleted_default'] = 'Das Anzeigen von Aufzeichnungen gelöschter Aktivitäten ist voreingestellt.';
$string['config_recordings_deleted_default_description'] = 'Wenn dies aktiviert ist, enthält die Tabelle Aufzeichnungen aus gelöschten Aktivitäten.';
$string['config_recordings_deleted_editable'] = 'Die Funktion zum Anzeigen von Aufzeichnungen gelöschter Aktivitäten kann bearbeitet werden.';
$string['config_recordings_deleted_editable_description'] = 'Die Funktion zum Anzeigen von Aufzeichnungen gelöschter Aktivitäten kann bearbeitet werden, wenn die Instanz angelegt oder aktualisiert wird.';
$string['config_recordings_description'] = 'Diese Einstellungen sind funktionsabhängig.';
$string['config_recordings_general'] = 'Aufzeichnungseinstellungen zeigen';
$string['config_recordings_general_description'] = 'Diese Einstellungen werden nur verwendet, wenn Aufzeichnungen angezeigt werden.';
$string['config_recordings_html_default'] = 'Die Anzeige als HTML ist voreingestellt.';
$string['config_recordings_html_default_description'] = 'Wenn dies aktiviert ist, werden die Aufzeichnungen als einfache HTML-Tabelle angezeigt.';
$string['config_recordings_html_editable'] = '"Anzeige als HTML" bearbeitbar';
$string['config_recordings_html_editable_description'] = 'Die Option "Anzeige als HTML" kann bearbeitet werden, wenn die Instanz angelegt oder aktualisiert wird.';
$string['config_recordings_imported_default'] = 'Nur importierte Links anzeigen, die standardmäßig aktiviert sind';
$string['config_recordings_imported_default_description'] = 'Wenn aktiviert, enthält die Tabelle nur die importierten Links zu Aufzeichnungen.';
$string['config_recordings_imported_editable'] = '"Nur importierte Links anzeigen" bearbeitbar';
$string['config_recordings_imported_editable_description'] = 'Die Option "Nur importierte Links standardmäßig anzeigen" kann bearbeitet werden, wenn eine Instanz angelegt oder aktualisiert wird.';
$string['config_recordings_preview_default'] = 'Vorschau standardmäßig aktiviert';
$string['config_recordings_preview_default_description'] = 'Die Option legt fest, ob eine Vorschau der Präsentation einbezogen wird.';
$string['config_recordings_preview_editable'] = 'Vorschau bearbeitbar';
$string['config_recordings_preview_editable_description'] = 'Die Vorschau kann bearbeitet werden, wenn die Instanz angelegt oder aktualisiert wird.';
$string['config_recordings_sortorder'] = 'Aufzeichnungen in aufsteigender Reihenfolge anordnen.';
$string['config_recordings_sortorder_description'] = 'Standardmäßig werden die Aufzeichnungen in absteigender Reihenfolge angezeigt. Wenn diese Option aktiviert ist, werden sie in aufsteigender Reihenfolge sortiert.';
$string['config_recordings_validate_url'] = 'URL prüfen';
$string['config_recordings_validate_url_description'] = 'Diese Option legt fest, dass die Wiedergabe-URL geprüft wird, bevor Nutzer/innen darauf zugreifen können.';
$string['config_scheduled'] = 'Einstellungen für "Terminierte Meetings"';
$string['config_scheduled_description'] = 'Diese Einstellungen legen Standardwerte für \'Terminierte Meetings\' fest.';
$string['config_scheduled_duration_compensation'] = 'Karenzzeit (Minuten)';
$string['config_scheduled_duration_compensation_description'] = 'Zeitdauer in Minuten, die dem festgelegten Endzeitpunkt hinzugefügt wird.';
$string['config_scheduled_duration_enabled'] = 'Dauer berechnen aktiviert';
$string['config_scheduled_duration_enabled_description'] = 'Die Dauer eines terminierten Meetings wird aus der Differenz zwischen Start- und Endzeit errechnet.';
$string['config_scheduled_pre_opening'] = 'Zugang möglich von der Startzeit (in Minuten)';
$string['config_scheduled_pre_opening_description'] = 'Zeit in Minuten vor Beginn der Session wenn die Session zugänglich ist';
$string['config_sendnotifications'] = 'Einstellungen für "Benachrichtigungen senden"';
$string['config_sendnotifications_description'] = 'Diese Einstellungen aktivieren bzw. deaktivieren Optionen in der Nutzeroberfläche. Außerdem definieren sie Standardwerte für einige Optionen.';
$string['config_sendnotifications_enabled'] = 'Benachrichtigungen senden aktiviert';
$string['config_sendnotifications_enabled_description'] = 'Die Funktion zum Senden von Benachrichtigungen ist aktiviert, wenn der Raum oder die Konferenz hinzugefügt oder aktualisiert wird.';
$string['config_server_url'] = 'URL des BigBlueButton-Server';
$string['config_server_url_description'] = 'Die URL des BigBlueButton-Servers muss mit /bigbluebutton/ enden.';
$string['config_shared_secret'] = 'BigBlueButton Shared Secret';
$string['config_shared_secret_description'] = '<p>Der Wert \'Shared Secret\' (=salt) sichert die Verbindung zu Ihrem BigBlueButton-Server ab. </p><p>Die standardmäßig eingetragenen Werte gehört zu einem Server, der von Blindside Networks zum Testen bereitgestellt wird. <a href="https://docs.moodle.org/en/BigBlueButtonBN" target="_blank">Weitere Informationen</a>.</p>';
$string['config_uidelegation_enabled'] = 'Die Weitergabe der Werkzeuge ist aktiviert';
$string['config_uidelegation_enabled_description'] = 'Diese Einstellungen aktivieren oder deaktivieren die Weitergabe der Werkzeuge.';
$string['config_userlimit'] = 'Einstellungen für das "Nutzer-Limit"';
$string['config_userlimit_default'] = 'Nutzer-Limit standardmäßig';
$string['config_userlimit_default_description'] = 'Die Option legt die Anzahl der Nutzer/innen fest, die standardmäßig in einem Meeting zugelassen werden, wenn ein neuer Raum bzw. eine neue Konferenz angelegt wird. Falls die Nummer auf 0 gesetzt ist, wird kein Limit festgelegt';
$string['config_userlimit_description'] = 'Diese Einstellungen aktivieren bzw. deaktivieren Optionen in der Nutzeroberfläche. Außerdem definieren sie Standardwerte für einige Optionen.';
$string['config_userlimit_editable'] = 'Nutzer-Limit bearbeitbar';
$string['config_userlimit_editable_description'] = 'Die maximale Anzahl von Nutzer/innen im Meeting kann geändert werden, wenn der Raum oder die Konferenz angelegt oder aktualisiert wird.';
$string['config_voicebridge'] = 'Einstellungen für "Voice Bridge"';
$string['config_voicebridge_description'] = 'Diese Einstellungen aktivieren bzw. deaktivieren Optionen in der Nutzeroberfläche. Außerdem definieren sie Standardwerte für einige Optionen.';
$string['config_voicebridge_editable'] = 'Konferenz-Voice-Bridge bearbeitbar';
$string['config_voicebridge_editable_description'] = 'Die Konferenznummer kann fest einer Raumkonferenz zugeordnet werden. Wenn zugewiesen, kann die Nummer von keinem anderen Raum oder Konferenz genutzt werden';
$string['config_waitformoderator'] = 'Einstellungen für "Warten auf Moderator/in"';
$string['config_waitformoderator_cache_ttl'] = 'Maximale Cache-Zeit (Sekunden)';
$string['config_waitformoderator_cache_ttl_description'] = 'Um eine große Anzahl von Clients zu unterstützen, verwendet dieses Plugin einen Cache. Dieser Parameter definiert die Zeit, die der Cache aufbewahrt wird, bevor die nächste Anforderung an den BigBlueButton-Server gesendet wird.';
$string['config_waitformoderator_default'] = '"Warten auf Moderator/in" ist standardmäßig aktiviert';
$string['config_waitformoderator_default_description'] = '"Warten auf Moderator/in" ist standardmäßig aktiviert, wenn ein neuer Raum oder eine Konferenz hinzugefügt wird.';
$string['config_waitformoderator_description'] = 'Diese Einstellungen sind funktionsabhängig.';
$string['config_waitformoderator_editable'] = '"Warten auf Moderator/in" bearbeitbar';
$string['config_waitformoderator_editable_description'] = 'Die Option "Warten auf Moderator/in" kann bearbeitet werden, wenn der Raum bzw. die Konferenz angelegt oder aktualisiert wird.';
$string['config_waitformoderator_ping_interval'] = '"Warten auf Moderator/in"-Ping (Sekunden)';
$string['config_waitformoderator_ping_interval_description'] = 'Wenn die Funktion "Warten auf Moderator/in" aktiviert ist, pingt der Client alle [number] Sekunden nach dem Status der Sitzung. Dieser Parameter definiert das Intervall für Anfragen an den Moodle-Server';
$string['config_warning_bigbluebuttonbn_cfg_deprecated'] = 'BigBlueButton verwendet config.php mit einer veralteten globalen Variable. Konvertieren Sie die Datei, da sie in künftigen Versionen nicht unterstützt wird.';
$string['config_warning_curl_not_installed'] = 'Die Funktion erfordert die CURL-Erweiterung für PHP. Diese muss installiert und aktiviert sein. Die Einstellungsoptionen stehen nur zur Verfügung wenn diese Voraussetzung erfüllt ist.';
$string['config_welcome_default'] = 'Begrüßungstext';
$string['config_welcome_default_description'] = 'Ersetzen Sie den standardmäßigen Begrüßungstext durch einen eigenen Text. Die Nachricht kann folgende Platzhalter enthalten (%%CONFNAME%%, %%DIALNUM%%, %%CONFNUM%%). Sie können auch HTML-Formatierungen verwenden wie z.B. &lt;b>...&lt;/b>, &lt;u>...&lt;/u> oder &lt;i>...&lt;/i>.';
$string['email_body_notification_meeting_by'] = 'von';
$string['email_body_notification_meeting_description'] = 'Beschreibung';
$string['email_body_notification_meeting_details'] = 'Details';
$string['email_body_notification_meeting_end_date'] = 'Endzeit';
$string['email_body_notification_meeting_has_been'] = 'war/wurde';
$string['email_body_notification_meeting_start_date'] = 'Anfangszeit';
$string['email_body_notification_meeting_title'] = 'Name';
$string['email_body_recording_ready_for'] = 'Aufzeichnung für';
$string['email_body_recording_ready_is_ready'] = 'ist fertig';
$string['email_footer_sent_by'] = 'Diese automatische Mitteilung wurde gesendet von';
$string['email_footer_sent_from'] = 'aus dem Kurs';
$string['ends_at'] = 'Beendet';
$string['event_activity_created'] = 'BigBlueButton angelegt';
$string['event_activity_deleted'] = 'BigBlueButton gelöscht';
$string['event_activity_updated'] = 'BigBlueButton aktualisiert';
$string['event_activity_viewed'] = 'BigBlueButton angezeigt';
$string['event_live_session'] = 'Live-Session-Veranstaltung';
$string['event_meeting_created'] = 'BigBlueButton-Meeting angelegt';
$string['event_meeting_ended'] = 'BigBlueButton-Meeting beendet';
$string['event_meeting_joined'] = 'BigBlueButton-Meeting beigetreten';
$string['event_meeting_left'] = 'BigBlueButton-Meeting verlassen';
$string['event_recording_deleted'] = 'Aufzeichnung gelöscht';
$string['event_recording_edited'] = 'Aufzeichnung bearbeitet';
$string['event_recording_imported'] = 'Aufnahme importiert';
$string['event_recording_protected'] = 'Aufzeichnung geschützt';
$string['event_recording_published'] = 'Aufzeichnung veröffentlicht';
$string['event_recording_unprotected'] = 'Schutz der Aufzeichnung entfernt';
$string['event_recording_unpublished'] = 'Aufzeichnung zurückgezogen';
$string['event_recording_viewed'] = 'Aufzeichnung angesehen';
$string['general_error_not_allowed_to_create_instances'] = 'Nutzer/in darf keine Art von Instanzen erstellen.';
$string['general_error_unable_connect'] = 'Das Verbinden ist nicht möglich. Prüfen Sie die URL des BigBlueButton-Servers. Prüfen Sie zusätzlich auch, ob der Server wirklich läuft.';
$string['index_confirm_end'] = 'Möchten Sie den virtuellen Klassenraum wirklich beenden?';
$string['index_disabled'] = 'deaktiviert';
$string['index_enabled'] = 'aktiviert';
$string['index_ending'] = 'Der virtuelle Klassenraum wird beendet ... warten Sie bitte.';
$string['index_error_bbtn'] = 'Die BigBlueButton-ID {$a} ist falsch.';
$string['index_error_checksum'] = 'Fehler: Prüfen Sie, ob Sie den richtigen Wert \'Shared Secret\' eingegeben haben.';
$string['index_error_forciblyended'] = 'Ein Beitreten zu diesem Meeting ist nicht mehr  möglich, weil es manuell beendet wurde.';
$string['index_error_noinstances'] = 'Es gibt keine BigBlueButton-Instanzen.';
$string['index_error_unable_display'] = 'Die Meetings können nicht angezeigt werden. Prüfen Sie die URL des BigBlueButton-Servers. Prüfen Sie zusätzlich, ob der Server wirklich läuft.';
$string['index_heading'] = 'BigBlueButton-Räume';
$string['index_heading_actions'] = 'Aktionen';
$string['index_heading_group'] = 'Gruppe';
$string['index_heading_moderator'] = 'Moderator/innen';
$string['index_heading_name'] = 'Raum';
$string['index_heading_recording'] = 'Aufzeichnung';
$string['index_heading_users'] = 'Nutzer/innen';
$string['index_heading_viewer'] = 'Zuschauer/innen';
$string['indicator:cognitivedepth'] = 'BigBlueButton kognitiv';
$string['indicator:cognitivedepth_help'] = 'Dieser Indikator basiert auf der kognitiven Tiefe, die der Schüler in einer BigBlueButton-Aktivität erreicht hat.';
$string['indicator:socialbreadth'] = 'BigBlueButton sozial';
$string['indicator:socialbreadth_help'] = 'Dieser Indikator basiert auf der sozialen Breite, die der Student in einer BigBlueButton-Aktivität erreicht hat.';
$string['instance_type_default'] = 'Raum/Aktivität mit Aufzeichnungen';
$string['instance_type_recording_only'] = 'Nur Aufzeichnungen';
$string['instance_type_room_only'] = 'Nur Raum/Aktivität';
$string['minute'] = 'Minute';
$string['minutes'] = 'Minuten';
$string['mod_form_block_clienttype'] = 'WebClient-Technologie';
$string['mod_form_block_clienttype_flash'] = 'WebClient mit Adobe Flash';
$string['mod_form_block_clienttype_html5'] = 'WebClient mit HTML5';
$string['mod_form_block_general'] = 'Grundeinstellungen';
$string['mod_form_block_participants'] = 'Zugewiesene Rolle während der Live-Sitzung';
$string['mod_form_block_presentation'] = 'Präsentationsinhalt';
$string['mod_form_block_presentation_default'] = 'Standardmäßiger Präsentationsinhalt';
$string['mod_form_block_record'] = 'Aufzeichnungseinstellungen';
$string['mod_form_block_recordings'] = 'Aufzeichnungseinstellungen';
$string['mod_form_block_room'] = 'Aktivitäts/Raum-Einstellungen';
$string['mod_form_block_schedule'] = 'Zeitplan';
$string['mod_form_field_block_clienttype'] = 'WebClient-Technologie';
$string['mod_form_field_closingtime'] = 'Zugang geschlossen';
$string['mod_form_field_conference_name'] = 'Name der Konferenz';
$string['mod_form_field_disablecam'] = 'Webcams sperren';
$string['mod_form_field_disablemic'] = 'Mikrofone sperren';
$string['mod_form_field_disablenote'] = 'Geteilte Notizen sperren';
$string['mod_form_field_disableprivatechat'] = 'Private Chats sperren';
$string['mod_form_field_disablepublicchat'] = 'Öffentlichen Chat sperren';
$string['mod_form_field_duration'] = 'Dauer';
$string['mod_form_field_duration_help'] = 'Wenn die Dauer für ein Meeting festgelegt ist, wird die Aufzeichnung automatisch beendet, sobald die Zeit abgelaufen ist.';
$string['mod_form_field_hideuserlist'] = 'Teilnehmerliste verbergen';
$string['mod_form_field_instanceprofiles'] = 'Instanztyp';
$string['mod_form_field_instanceprofiles_help'] = 'Wählen Sie den Typ für diese BigBlueButton-Instanz aus.';
$string['mod_form_field_intro'] = 'Beschreibung';
$string['mod_form_field_intro_help'] = 'Kurzbeschreibung des Raums oder der Konferenz';
$string['mod_form_field_lockedlayout'] = 'Sitzungslayout sperren';
$string['mod_form_field_lockonjoin'] = 'Sperreinstellungen ignorieren';
$string['mod_form_field_lockonjoinconfigurable'] = '"Sperreinstellungen ignorieren" erlauben';
$string['mod_form_field_muteonstart'] = 'Beim Start stumm schalten';
$string['mod_form_field_name'] = 'Name des virtuellen Klassenraumes';
$string['mod_form_field_nosettings'] = 'Es können keine Einstellungen bearbeitet werden.';
$string['mod_form_field_notification'] = 'Erinnerung versenden';
$string['mod_form_field_notification_created_help'] = 'Versenden Sie eine Nachricht, um alle eingeschriebenen Nutzer/innen zu informieren, dass diese Aktivität angelegt wurde.';
$string['mod_form_field_notification_help'] = 'Versenden Sie eine Nachricht, um alle eingeschriebenen Nutzer/innen zu informieren, dass diese Aktivität angelegt oder bearbeitet wurde.';
$string['mod_form_field_notification_modified_help'] = 'Versenden Sie eine Nachricht, um alle eingeschriebenen Nutzer/innen zu informieren, dass diese Aktivität bearbeitet wurde.';
$string['mod_form_field_notification_msg_at'] = 'um';
$string['mod_form_field_notification_msg_created'] = 'hinzugefügt';
$string['mod_form_field_notification_msg_modified'] = 'bearbeitet';
$string['mod_form_field_openingtime'] = 'Zutritt erlaubt';
$string['mod_form_field_participant_add'] = 'Teilnehmer/in hinzufügen';
$string['mod_form_field_participant_bbb_role_moderator'] = 'Moderator/in';
$string['mod_form_field_participant_bbb_role_viewer'] = 'Zuschauer/in';
$string['mod_form_field_participant_list'] = 'Teilnehmerliste';
$string['mod_form_field_participant_list_action_add'] = 'Hinzufügen';
$string['mod_form_field_participant_list_action_remove'] = 'Entfernen';
$string['mod_form_field_participant_list_text_as'] = 'beitreten als';
$string['mod_form_field_participant_list_type_all'] = 'Alle eingeschriebenen Teilnehmer/innen';
$string['mod_form_field_participant_list_type_owner'] = 'Eigentümer/in';
$string['mod_form_field_participant_list_type_role'] = 'Rolle';
$string['mod_form_field_participant_list_type_user'] = 'Nutzer/in';
$string['mod_form_field_record'] = 'Das Meeting kann aufgenommen werden.';
$string['mod_form_field_recordallfromstart'] = 'Alles von Anfang an aufzeichnen';
$string['mod_form_field_recordhidebutton'] = 'Aufzeichnungsbutton verbergen';
$string['mod_form_field_recordings_deleted'] = 'Aufzeichnungen von gelöschten Aktivitäten einbeziehen';
$string['mod_form_field_recordings_html'] = 'Zeigen Sie die Tabelle in einfachem HTML an';
$string['mod_form_field_recordings_imported'] = 'Nur importierte Links anzeigen';
$string['mod_form_field_recordings_preview'] = 'Aufzeichnungsvorschau anzeigen';
$string['mod_form_field_room_name'] = 'Name des Raums';
$string['mod_form_field_userlimit'] = 'Nutzer-Limit';
$string['mod_form_field_userlimit_help'] = 'Maximale Teilnehmerzahl in einem Meeting. Wenn die Option auf 0 gesetzt wird, ist die Teilnehmerzahl nicht begrenzt.';
$string['mod_form_field_voicebridge'] = 'Voice Bridge [####]';
$string['mod_form_field_voicebridge_format_error'] = 'Fehler: Sie müssen eine Zahl zwischen 1 und 9999 eingeben.';
$string['mod_form_field_voicebridge_help'] = 'Telefonkonferenznummer, die Nutzer/innen eingeben, um über Telefon an der Konferenz teilnehmen. Eine Nummer zwischen 1 und 9999 muss eingegeben werden. Wenn der Wert 0 eingegeben wird, wird die eine statische Voice Bridge-Nummer ignoriert und eine zufällige Rufnummer zugewiesen. Die Ziffer 7 wird der Nummer vorangestellt.';
$string['mod_form_field_voicebridge_notunique_error'] = 'Fehler: Diese Nummer wird bereits von einem anderen Raum oder einer anderen Konferenz benutzt.';
$string['mod_form_field_wait'] = 'Warten auf Moderator/in';
$string['mod_form_field_wait_help'] = 'Zuschauer/innen müssen warten, bis ein/e Moderator/in dem Meeting beitritt, bevor sie dies tun können.';
$string['mod_form_field_welcome'] = 'Begrüßungstext';
$string['mod_form_field_welcome_default'] = 'Willkommen bei <b>%%CONFNAME%%</b>!<br><br>Um zu zeigen, wie BigBlueButton arbeitet, haben wir diese <a href="event:http://www.bigbluebutton.org/content/videos"><u>Tutorials</u></a> bereitgestellt.<br><br><b>Verwenden Sie bitte ein Headset, um Störungen durch Geräusche zu vermeiden.</b>';
$string['mod_form_field_welcome_help'] = 'Ersetzen Sie den standardmäßigen Begrüßungstext durch einen eigenen Text. Die Nachricht kann folgende Platzhalter enthalten (%%CONFNAME%%, %%DIALNUM%%, %%CONFNUM%%). Sie können auch HTML-Formatierungen verwenden wie z.B. &lt;b>...&lt;/b>, &lt;u>...&lt;/u> oder &lt;i>...&lt;/i>.';
$string['mod_form_locksettings'] = 'Einstellungen sperren';
$string['modulename'] = 'BigBlueButton';
$string['modulename_help'] = 'BigBlueButton ermöglicht Ihnen, in Moodle Verbindungen zu LiveClassRoomMeetings anzulegen.

Mit BigBlueButton können Sie einen Titel und eine Beschreibung angeben, außerdem einen Kalendereintrag (mit Zeitraum für den Zugriff), Gruppen und Details zur Aufzeichnungen der Online-Sitzung festlegen.';
$string['modulenameplural'] = 'BigBlueButton';
$string['pluginadministration'] = 'BigBlueButton Administration';
$string['pluginname'] = 'BigBlueButton';
$string['privacy:metadata:bigbluebutton'] = 'Um Sessions mit BigBlueButton anzulegen und daran teilzunehmen, müssen Nutzerdaten mit dem Server ausgetauscht werden.';
$string['privacy:metadata:bigbluebutton:fullname'] = 'Vollständiger Name einer Person, die auf den BigBlueButton-Server zugegriffen hat.';
$string['privacy:metadata:bigbluebutton:userid'] = 'Nutzer-ID der Person, die auf dem BigBlueButton-Server zugegriffen hat.';
$string['privacy:metadata:bigbluebuttonbn'] = 'Einstellungen für das Meeting werden gespeichert, die die Optionen definieren und das allgemeine Erscheinungsbild festlegen.';
$string['privacy:metadata:bigbluebuttonbn:participants'] = 'Eine Liste von Regeln, die die Rolle definieren, die Personen im Live-Meeting übernehmen werden. Eine Nutzer-ID könnte gespeichert werden, da Berechtigungen pro Rolle oder pro Nutzer/in zugewiesen werden.';
$string['privacy:metadata:bigbluebuttonbn_logs'] = 'Angelegte Termine werden gespeichert, wenn das Plugin verwendet wird.';
$string['privacy:metadata:bigbluebuttonbn_logs:log'] = 'Die Art des Termins, der von der Person angelegt wurde.';
$string['privacy:metadata:bigbluebuttonbn_logs:meetingid'] = 'ID des Meetings, an dem Person teilnehmen konnte';
$string['privacy:metadata:bigbluebuttonbn_logs:meta'] = 'Es könnten zusätzliche Informationen enthalten sein, die sich auf das Meeting oder die beim Termin gespeicherte Aufzeichnung beziehen.';
$string['privacy:metadata:bigbluebuttonbn_logs:timecreated'] = 'Zeit, zu der die Logdaten angelegt wurden';
$string['privacy:metadata:bigbluebuttonbn_logs:userid'] = 'ID der Person, die den Termin eingerichtet hat';
$string['removedevents'] = 'Gelöschte Ereignisse';
$string['removedlogs'] = 'Nutzerdefinierte Protokolle gelöscht';
$string['removedrecordings'] = 'Gelöschte Aufzeichnungen';
$string['removedtags'] = 'Gelöschte Tags';
$string['resetevents'] = 'Ereignisse löschen';
$string['resetlogs'] = 'Nutzerdefinierte Protokolle löschen';
$string['resetlogs_help'] = 'Das Löschen der Protokolle führt zum Verlust der Verweise auf die Aufzeichnungen';
$string['resetrecordings'] = 'Aufzeichnungen löschen';
$string['resetrecordings_help'] = 'Das Löschen der Aufzeichnungen macht sie von überall her unzugänglich und kann nicht rückgängig gemacht werden.';
$string['resettags'] = 'Tags löschen';
$string['search:activity'] = 'BigBlueButton - Aktivitäteninformation';
$string['search:tags'] = 'BigBlueButton - Tagsinformation';
$string['sendnotification'] = 'Benachrichtigung senden';
$string['started_at'] = 'Gestartet';
$string['starts_at'] = 'Beginnt';
$string['view_conference_action_end'] = 'Meeting beenden';
$string['view_conference_action_join'] = 'Teilnehmen';
$string['view_error_action_not_completed'] = 'Aktion konnte nicht abgeschlossen werden';
$string['view_error_bigbluebutton'] = 'BigBlueButton zeigt Fehler an: {$a}';
$string['view_error_create'] = 'Der BigBlueButton-Server meldet einen Fehler. Das Meeting konnte nicht angelegt werden.';
$string['view_error_current_state_not_found'] = 'Der aktuelle Status wurde nicht gefunden. Die Aufzeichnung wurde möglicherweise gelöscht oder der BigBlueButton-Server ist nicht mit der ausgeführten Aktion kompatibel.';
$string['view_error_import_no_courses'] = 'Keine Kurse zum Suchen von Aufnahmen gefunden';
$string['view_error_import_no_recordings'] = 'Keine Aufnahmen für den Import im Kurs gefunden';
$string['view_error_invalid_session'] = 'Die Sitzung ist abgelaufen. Gehe zurück zur Aktivitätshauptseite.';
$string['view_error_max_concurrent'] = 'Die Anzahl der gleichzeitigen Meetings ist erreicht.';
$string['view_error_meeting_not_running'] = 'Es ist etwas schiefgelaufen, das Meeting läuft nicht.';
$string['view_error_no_group'] = 'Keine Gruppen verfügbar. Legen Sie Gruppen an, bevor Sie versuchen, dem Meeting beizutreten.';
$string['view_error_no_group_student'] = 'Sie sind in keiner Gruppe eingetragen. Wenden Sie sich an Ihre/n Trainer/in oder an den Administrator.';
$string['view_error_no_group_teacher'] = 'Keine Gruppen verfügbar. Legen Sie Gruppen an oder wenden Sie sich an den Administrator.';
$string['view_error_unable_join'] = 'Sie können auf das Meeting nicht zugreifen. Prüfen Sie die URL des BigBlueButton-Servers und außerdem, ob der Server läuft.';
$string['view_error_unable_join_student'] = 'Die Verbindung zum BigBlueButton-Server ist nicht möglich. Wenden Sie sich an Ihre Trainer/innen oder den Administrator.';
$string['view_error_unable_join_teacher'] = 'Die Verbindung zum BigBlueButton-Server ist nicht möglich. Wenden Sie sich an den Administrator.';
$string['view_error_url_missing_parameters'] = 'Fehlende Parameter in der URL';
$string['view_error_userlimit_reached'] = 'Die maximale Teilnehmerzahl für dieses Meeting ist erreicht.';
$string['view_groups_nogroups_warning'] = 'Das Meeting wurde für die Verwendung von Gruppen konfiguriert, aber im Kurs sind keine Gruppen angelegt.';
$string['view_groups_notenrolled_warning'] = 'Der Raum wurde für die Verwendung von Gruppen konfiguriert, aber Sie sind in keiner Gruppe angemeldet.';
$string['view_groups_selection'] = 'Wählen Sie die Gruppe, der Sie beitreten möchten, und bestätigen Sie die Aktion.';
$string['view_groups_selection_join'] = 'Beitreten';
$string['view_groups_selection_warning'] = 'Für jede Gruppe gibt es einen Konferenzraum. Falls Sie Zugriff auf mehrere Konferenzräume haben, wählen Sie den richtigen Raum aus.';
$string['view_login_moderator'] = 'Als Moderator/in anmelden...';
$string['view_login_viewer'] = 'Als Zuschauer/in anmelden...';
$string['view_message_and'] = 'und';
$string['view_message_conference_has_ended'] = 'Das Meeting ist beendet.';
$string['view_message_conference_in_progress'] = 'Das Meeting läuft gerade.';
$string['view_message_conference_not_started'] = 'Das Meeting hat noch nicht begonnen.';
$string['view_message_conference_room_ready'] = 'Der Raum ist fertig vorbereitet. Sie können jetzt an dem Meeting teilnehmen.';
$string['view_message_conference_wait_for_moderator'] = 'Sie können teilnehmen, wenn ein/e Moderator/in eingetroffen ist.';
$string['view_message_finished'] = 'Die Aktivität ist vorbei.';
$string['view_message_has_joined'] = 'hat teilgenommen';
$string['view_message_have_joined'] = 'nehmen teil';
$string['view_message_hour'] = 'Stunde';
$string['view_message_hours'] = 'Stunden';
$string['view_message_importrecordings_disabled'] = 'Die Möglichkeit, Aufzeichnungslinks zu importieren, ist für diesen Server deaktiviert.';
$string['view_message_minute'] = 'Minute';
$string['view_message_minutes'] = 'Minuten';
$string['view_message_moderator'] = 'Moderator/in';
$string['view_message_moderators'] = 'Moderator/innen';
$string['view_message_norecordings'] = 'Für dieses Meeting gibt es keine Aufzeichnungen.';
$string['view_message_notavailableyet'] = 'Das Meeting ist noch nicht verfügbar.';
$string['view_message_recordings_disabled'] = 'Aufzeichnungen wurden auf diesem Server deaktiviert. BigBlueButton-Instanzen vom Typ "Nur Aufzeichnungen" können nicht verwendet werden.';
$string['view_message_room_closed'] = 'Der Raum ist geschlossen.';
$string['view_message_room_open'] = 'Der Raum ist geöffnet.';
$string['view_message_room_ready'] = 'Der Raum ist fertig.';
$string['view_message_session_for'] = 'die Sitzung für';
$string['view_message_session_has_user'] = 'Es gibt';
$string['view_message_session_has_users'] = 'Es gibt';
$string['view_message_session_no_users'] = 'Niemand ist in diesem Meeting. :-(';
$string['view_message_session_running_for'] = 'Das Meeting lief';
$string['view_message_session_started_at'] = 'Das Meeting begann';
$string['view_message_tab_close'] = 'Dieses Fenster muss manuell geschlossen werden.';
$string['view_message_times'] = 'Mal';
$string['view_message_user'] = 'Nutzer/in';
$string['view_message_users'] = 'Nutzer/innen';
$string['view_message_viewer'] = 'Zuschauer/in';
$string['view_message_viewers'] = 'Zuschauer/innen';
$string['view_mobile_message_groups_not_supported'] = 'Diese Instanz ermöglicht die Arbeit mit Gruppen, aber die mobile Anwendung bietet dafür keine Unterstützung. Öffnen Sie diese Instanz bitte im Browser, wenn Sie die Gruppenunterstützung nutzen möchten.';
$string['view_mobile_message_reload_page_creation_time_meeting'] = 'Sie haben die 45 Sekunden auf dieser Seite überschritten. Bitte laden Sie die Seite neu, um korrekt an der Sitzung teilzunehmen.';
$string['view_noguests'] = 'BigBlueButton ist nicht für Gäste geöffnet.';
$string['view_nojoin'] = 'Mit Ihrer Rolle dürfen Sie an dem Meeting nicht teilnehmen.';
$string['view_recording'] = 'Aufnahme läuft ...';
$string['view_recording_actionbar'] = 'Werkzeuge';
$string['view_recording_activity'] = 'Aktivität';
$string['view_recording_button_import'] = 'Aufnahmelinks importieren';
$string['view_recording_button_return'] = 'Zurück';
$string['view_recording_course'] = 'Kurs';
$string['view_recording_date'] = 'Datum';
$string['view_recording_delete_confirmation'] = 'Möchten Sie die Aufzeichnung wirklich löschen? {$a}';
$string['view_recording_delete_confirmation_warning_p'] = 'Für diese Aufzeichnung {$a} wurden Links in mehreren Kursen und Aktivitäten angelegt. Wenn die Aufzeichnung gelöscht wird, weden diese ebenfalls entfernt.';
$string['view_recording_delete_confirmation_warning_s'] = 'Für diese Aufzeichnung {$a} wurde ein Link in einem anderen Kurs oder Aktivität angelegt. Wenn die Aufzeichnung gelöscht wird, wird dieser ebenfalls entfernt.';
$string['view_recording_description'] = 'Beschreibung';
$string['view_recording_duration'] = 'Dauer';
$string['view_recording_duration_min'] = 'min';
$string['view_recording_format_errror_unreachable'] = 'Die URL für dieses Aufzeichnungsformat ist nicht erreichbar.';
$string['view_recording_format_notes'] = 'Notizen';
$string['view_recording_format_podcast'] = 'Podcast';
$string['view_recording_format_presentation'] = 'Präsentation';
$string['view_recording_format_screenshare'] = 'Bildschirmfreigabe';
$string['view_recording_format_statistics'] = 'Statistiken';
$string['view_recording_format_video'] = 'Video';
$string['view_recording_import_confirmation'] = 'Möchten Sie diese Aufnahme wirklich importieren?';
$string['view_recording_length'] = 'Länge';
$string['view_recording_link_warning'] = 'Dieser Link zeigt auf eine Aufnahme aus einem anderen Kurs oder einer anderen Aktivität.';
$string['view_recording_list_action_delete'] = 'Wird gelöscht';
$string['view_recording_list_action_edit'] = 'Wird aktualisiert';
$string['view_recording_list_action_play'] = 'Abspielen';
$string['view_recording_list_action_process'] = 'In Bearbeitung';
$string['view_recording_list_action_protect'] = 'Wird geschützt';
$string['view_recording_list_action_publish'] = 'Wird veröffentlicht';
$string['view_recording_list_action_unprotect'] = 'Wird ungeschützt';
$string['view_recording_list_action_unpublish'] = 'Wird unveröffentlicht';
$string['view_recording_list_action_update'] = 'Wird aktualisiert';
$string['view_recording_list_actionbar'] = 'Werkzeugleiste';
$string['view_recording_list_actionbar_delete'] = 'Löschen';
$string['view_recording_list_actionbar_edit'] = 'Bearbeiten';
$string['view_recording_list_actionbar_hide'] = 'Verbergen';
$string['view_recording_list_actionbar_import'] = 'Importieren';
$string['view_recording_list_actionbar_protect'] = 'Als "privat" kennzeichnen';
$string['view_recording_list_actionbar_publish'] = 'Veröffentlichen';
$string['view_recording_list_actionbar_show'] = 'Anzeigen';
$string['view_recording_list_actionbar_unprotect'] = 'Öffentlich machen';
$string['view_recording_list_actionbar_unpublish'] = 'Zurückziehen';
$string['view_recording_list_activity'] = 'Aktivität';
$string['view_recording_list_course'] = 'Kurs';
$string['view_recording_list_date'] = 'Datum';
$string['view_recording_list_description'] = 'Beschreibung';
$string['view_recording_list_duration'] = 'Dauer';
$string['view_recording_list_recording'] = 'Aufzeichnung';
$string['view_recording_meeting'] = 'Meeting';
$string['view_recording_modal_button'] = 'Zustimmen';
$string['view_recording_modal_title'] = 'Einstellungen für die Aufzeichnung festlegen';
$string['view_recording_name'] = 'Name';
$string['view_recording_playback'] = 'Playback';
$string['view_recording_preview'] = 'Vorschau';
$string['view_recording_preview_help'] = 'Bewegen Sie die Maus über ein Bild, um es in voller Größe anzuzeigen';
$string['view_recording_publish_link_deleted'] = 'Dieser Link kann nicht neu veröffentlicht werden, da die aktuelle Aufzeichnung im aktuellen BigBlueButton-Server nicht vorhanden ist. Der Link sollte entfernt werden.';
$string['view_recording_publish_link_not_published'] = 'Dieser Link kann nicht erneut veröffentlicht werden, da die eigentliche Aufzeichnung noch nicht veröffentlicht ist.';
$string['view_recording_recording'] = 'Aufzeichnung';
$string['view_recording_tags'] = 'Schlagwörter';
$string['view_recording_unprotect_link_deleted'] = 'Dieser Link kann nicht ungeschützt sein, da die tatsächliche Aufzeichnung im aktuellen BigBlueButton-Server nicht vorhanden ist. Der Link sollte entfernt werden.';
$string['view_recording_unprotect_link_not_unprotected'] = 'Der Schutz dieses Links kann nicht aufgehoben werden, da die eigentliche Aufzeichnung geschützt ist.';
$string['view_recording_unpublish_confirmation'] = 'Möchten Sie diese Aufnahme wirklich zurückziehen? {$a}';
$string['view_recording_unpublish_confirmation_warning_p'] = 'Für diese Aufzeichnung {$a} wurden Links in mehreren Kursen oder Aktivitäten angelegt. Wenn die Aufzeichnung gelöscht wird, werden diese Links ebenfalls entfernt.';
$string['view_recording_unpublish_confirmation_warning_s'] = 'Für diese Aufzeichnung {$a} wurde ein Link in einem anderen Kurs oder in einer anderen Aktivität angelegt. Wenn die Aufzeichnung gelöscht wird, wird dieser Link ebenfalls entfernt.';
$string['view_recording_yui_first'] = 'Erste';
$string['view_recording_yui_go'] = 'Los';
$string['view_recording_yui_last'] = 'Letzte';
$string['view_recording_yui_next'] = 'Nächste';
$string['view_recording_yui_page'] = 'Seite';
$string['view_recording_yui_prev'] = 'Vorherige';
$string['view_recording_yui_rows'] = 'Zeilen';
$string['view_recording_yui_show_all'] = 'Alle anzeigen';
$string['view_room'] = 'Meeting anzeigen';
$string['view_section_title_presentation'] = 'Präsentationsdatei';
$string['view_section_title_recordings'] = 'Aufzeichnungen';
$string['view_warning_default_server'] = 'Dieses Moodle verwendet den standardmäßig konfigurierten BigBlueButton-Server. Dieser BigBlueButton-Server wird ausschließlich für Testzwecke bereitgestellt und sollte nicht für den produktiven Betrieb verwendet werden.';
