<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'lti', language 'no', version '3.5'.
 *
 * @package     lti
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accept'] = 'Godta';
$string['accept_grades'] = 'Godta karakterer fra verktøyet';
$string['accept_grades_admin'] = 'Godta karakterer fra verktøyet';
$string['accept_grades_admin_help'] = 'Angi hvorvidt verktøytilbyder kan legge til, oppdatere, lese og slette karakterer koblet med instanser av dette verktøyet.

Noen verktøytilbydere støtter tilbakerapportering av karakterer til Moodle basert på handlinger i verktøyet. Dette gjør det til en mer integrert læringsressurs.';
$string['accept_grades_help'] = 'Angi hvorvidt verktøytilbyder kan legge til, oppdatere, lese og slette karakterer koblet med instanser av denne eksterne verktøytypen.

Noen LTI-ilbydere støtter tilbakerapportering av karakterer til Moodle basert på handlinger i verktøyet. Dette gjør det til en mer integrert læringsressurs.

Merk at denne innstillngen kan overstyres i innstillingene til verktøyet.';
$string['accepted'] = 'Akseptert';
$string['action'] = 'Handling';
$string['activate'] = 'Aktiver';
$string['activatetoadddescription'] = 'Du må aktivere dette LTI-verktøyet før du kan legge inn en beskrivelse.';
$string['active'] = 'Aktiv';
$string['activity'] = 'Aktivitet';
$string['addnewapp'] = 'Aktiver ekstern applikasjon';
$string['addserver'] = 'Legg til ny klarert server';
$string['addtype'] = 'Legg til et forhåndsoppsatt LTI-verktøy';
$string['allow'] = 'Tillat';
$string['allowsetting'] = 'Tillat verktøy å lagre 8K av innstillingene i Moodle';
$string['always'] = 'Alltid';
$string['autoaddtype'] = 'Legg til LTI-verktøy';
$string['automatic'] = 'Automatisk, basert på LTI-verktøyets URL';
$string['baseurl'] = 'Base-URL/ verktøyets registreringsnavn';
$string['basiclti'] = 'LTI';
$string['basiclti_base_string'] = 'LTI OAuth Base-streng';
$string['basiclti_endpoint'] = 'LTI start sluttpunkt';
$string['basiclti_in_new_window'] = 'Din aktivitet har åpnet i et nytt vindu';
$string['basiclti_in_new_window_open'] = 'Åpne i nytt vindu';
$string['basiclti_parameters'] = 'LTI startparametere';
$string['basicltiactivities'] = 'LTI-aktiviteter';
$string['basicltifieldset'] = 'Egendefinert eksempel på feltsett';
$string['basicltiintro'] = 'Aktivitetsbeskrivelse';
$string['basicltiname'] = 'Aktivitetsnavn';
$string['basicltisettings'] = 'Standard læringsverktøy interoperabilitetsinnstillinger';
$string['cancel'] = 'Avbryt';
$string['cancelled'] = 'Avbrutt';
$string['cannot_delete'] = 'Du bør ikke slette dette verktøyoppsettet';
$string['cannot_edit'] = 'Du bør ikke endre dette verktøyoppsettet';
$string['capabilities'] = 'Egenskaper';
$string['capabilities_help'] = 'Velg de rettigheter som du ønsker å tilby verktøyleverandøren. Mer enn ett kan velges.';
$string['capabilitiesrequired'] = 'Dette LTI-verktøyer krever tilgang til følgende data for at det kan aktiveres:';
$string['click_to_continue'] = '<a href="{$a->link}" target="_top">Klikk for å fortsette</a>';
$string['comment'] = 'Kommentar';
$string['configpassword'] = 'Standard passord for eksternt verktøy';
$string['configpreferheight'] = 'Standardverdi for høyde';
$string['configpreferwidget'] = 'Angi widget som standard start';
$string['configpreferwidth'] = 'Standardverdi for bredde';
$string['configresourceurl'] = 'Standard URL for ressurs';
$string['configtoolurl'] = 'Standard URL for eksternt verktøy';
$string['configtypes'] = 'Aktivér LTI-applikasjoner';
$string['configured'] = 'Konfigurert';
$string['confirmtoolactivation'] = 'Er du sikker på at du ønsker å aktivere dette LTI-verktøyet?';
$string['contentitem'] = 'Innholdselementmelding';
$string['contentitem_help'] = 'Hvis huket av, vil valget "Velg innhold" være tilgjengelig når det legges til et nytt LTI-verktøy.';
$string['course_tool_types'] = 'LTI-verktøy i kurset';
$string['courseactivitiesorresources'] = 'Kursaktiviteter og ressurer';
$string['courseid'] = 'Kurs ID-nummer';
$string['courseinformation'] = 'Kursinformasjon';
$string['courselink'] = 'Gå til kurs';
$string['coursemisconf'] = 'Kurset er feilkonfigurert';
$string['createdon'] = 'Opprettet';
$string['curllibrarymissing'] = 'PHP Curl-biblioteket er påkrevd for å bruke det eksterne LTI-verktøyet.';
$string['custom'] = 'Egendefinerte parametere';
$string['custom_config'] = 'Bruker egendefinerte innstillinger for verktøy.';
$string['custom_help'] = 'Egendefinerte parametre er innstillinger som brukes av verktøytilbyderen. F.eks. kan en egendefinert parameter bli brukt til å vise en bestemt ressurs fra tilbyderen. Hver parameter skal skrives på en egen linje og på formen "navn=verdi", for eksempel "chapter=3".

Det er trygt å la feltet være uendret, så sant ikke verktøytibyderen anbefaler noe annet.';
$string['custominstr'] = 'Egendefinerte parametere';
$string['debuglaunch'] = 'Debug-valg';
$string['debuglaunchoff'] = 'Feilsøkingmodus av';
$string['debuglaunchon'] = 'Feilsøkingmodus på';
$string['default'] = 'Standard';
$string['default_launch_container'] = 'Standard oppstartsbeholder';
$string['default_launch_container_help'] = 'Oppstartsbeholderen har betydning for visningen av verktøyet når det startes fra kurset. Noen oppstartsbeholdere overfører mer av visningskontrollen til verktøyet, mens andre tilbyr en mer integrert visning i pakt med Moodles måte å vise kurs på.

* **Standard** - Bruk oppstartsbeholderen som angis i verktøyoppsettet.
* **Innebygget** - Verktøyet vises på Moodle-siden på samme måte som de fleste andre aktivitetstypene.
* **Innebygget - uten blokker** - Verktøyet vises på Moodle-siden og bare med  standard navigasjon i toppteksten.
* **Nytt vindu** - Verktøyet åpnes i et eget vindu og fyller skjermen. Avhengig av nettleseren vil vinduet åpnes enten i en ny fane eller et pop-up vindu. Det er også mulig at nettleseren vil forhindre  at et nytt vindu åpnes, så sjekk det.';
$string['delegate'] = 'Deleger til lærer';
$string['delete'] = 'Slett';
$string['delete_confirmation'] = 'Er du sikker på at du ønsker å slette dette forhåndsoppsatte LTI-verktøyet?';
$string['deletetype'] = 'Slett forhåndsoppsatt LTI-verktøy';
$string['display_description'] = 'Vis beskrivelsen av aktiviteten når den starter';
$string['display_description_help'] = 'Hvis denne funksjonen er valgt kommer beskrivelsen av aktiviteten (beskrevet over) til å vises over verktøytilbyderens innhold.

Beskrivelsen kan brukes til å skaffe ekstra instruksjoner for programmer som starter verktøyet, men det er ikke påkrevd.

Beskrivelsen blir aldri vist når verktøyets oppstartsbeholder er i et nytt vindu.';
$string['display_name'] = 'Vis navnet på aktiviteten når den starter';
$string['display_name_help'] = 'Hvis denne funksjonen er valgt kommer navnet på aktiviteten (angitt over) til å vises over verktøytilbyderens innhold.

Det er mulig at verktøytilbyderen også vil vise tittelen. Dette alternativet kan forhindre at tittelen på aktiviteten blir vist to ganger.

Tittelen blir aldri vist når verktøyets oppstartsbeholder er i et nytt vindu.';
$string['domain_mismatch'] = 'LTI-verktøyets URL-domene er ikke i samsvar med verktøyoppsettet.';
$string['donot'] = 'Ikke send';
$string['donotaccept'] = 'Ikke ta imot';
$string['donotallow'] = 'Ikke tillat';
$string['duplicateregurl'] = 'Denne URLen er allerede i bruk';
$string['editdescription'] = 'Klikk her for å legge inn en beskrivelse av dette LTI-verktøyet';
$string['edittype'] = 'Rediger forhåndsoppsatt LTI-verktøy';
$string['embed'] = 'Innebygg (embed)';
$string['embed_no_blocks'] = 'Innebygg (embed), uten blokker';
$string['enableemailnotification'] = 'Send epost-varsler';
$string['enableemailnotification_help'] = 'Hvis denne funksjonen er aktivert kommer studentene til å få epost-varsler når deres innleveringer til verktøyet er blitt karaktersatt.';
$string['enterkeyandsecret'] = 'Skriv inn forbrukernøkkelen og den delte hemmelige strengen';
$string['enterkeyandsecret_help'] = 'Hvis du har fått en forbrukernøkkel og/eller en delt hemmelig streng skal du skrive dem inn her';
$string['errorbadurl'] = 'URL\'en er ikke en gyldig URL eller pakkefil';
$string['errorincorrectconsumerkey'] = 'Feil i forbrukernøkkelen';
$string['errorinvaliddata'] = 'Ugyldig data: {$a}';
$string['errorinvalidmediatype'] = 'Ugyldig mediatype: {$a}';
$string['errorinvalidresponseformat'] = 'Ugyldig svarformat på innholdselementmelding';
$string['errormisconfig'] = 'Feilkonfigurert verktøy. Kontakt din Moodle-administrator for å rette opp innstillingene for verktøyet.';
$string['errortooltypenotfound'] = 'Fant ikke LTI-verktøytype.';
$string['existing_window'] = 'Eksisterende vindu';
$string['extensions'] = 'Tjenester for LTI-tillegget';
$string['external_tool_type'] = 'Forhåndsoppsatt LTI-verktøy';
$string['external_tool_type_help'] = '* **Automatisk, basert på LTI-verktøyets URL** - Den beste  LTI-verktøy-konfigursjonen velges automatsik. Dersom LTI-verktøyets URL ikke gjenkjennes kan det være at innstillingene må settes opp manuelt.
* **Et spesifisert forhåndskonfigurert LTI-verktøy** - Konfigurasjonen av det spesifiserte LTI-verktøyet vil bli brukt under kommunikasjonen med den eksterne verktøytilbyderen. Dersom LTI-verktøyets URL virker å ikke tilhøre tilbyderen vil det bli vist en advarsel. Det er ikke alltid nødvendig å skrive inn en URL.
* **Tilpasset oppsett** - Det kan være nødvendig å manuelt skrive inn en forbrukernøkkel og delt hemmelig streng. Disse kan skaffes fra verktøytilbyderen. Det er imidlertid ikke alle LTI-verktøy som krever en forbrukernøkkel eller delt hemmelig streng og i slike tilfeller kan feltene være tomme. kan være nødevendig å srkiFor å stille inn på tilpasset verktøyoppsett på bare dette tilfellet, vis Avanserte valg, og skriv inn forbrukerpassordet og den delte hemmelige strengen selv. Hvis du ikke har noen forbrukerpassord og delt hemmelig streng, kan det være at du kan få dem oppgitt av verktøytilbyderen. Ikke alle verktøy krever forbrukerpassord og delt hemmelig streng. I disse tilfellene kan feltene stå blanke.

 ### Redigering av verktøytype

Tre ikoner kan velges etter Nedtrekkslisten med eksterne verktøytyper:

* **Legg til** - Opprett en verktøyoppsett på kursnivå. Alle Eksterne verktøy i dette kurset kan bruke oppsettet.
* **Rediger** - Velg en verktøytype på kursnivå fra nedtrekksmenyen. Klikk så på dette ikonet. Detaljene i verktøyoppsettet kan redigeres.
* **Slett** - Fjern den valgte verktøytypen på kursnivå.';
$string['external_tool_types'] = 'Forhåndsoppsatte LTI-verktøy';
$string['failedtoconnect'] = 'Moodle kunne ikke kommunisere med "{$a}"systemet.';
$string['failedtocreatetooltype'] = 'Kunne ikke opprette nytt LTI-verktøy. Vennligst sjekk URLen og prøv på nytt';
$string['failedtodeletetoolproxy'] = 'Klarte ikke å slette LTI-verktøy registreringen. Du må gå til "Administrer eksterne LTI-verktøy registreringer" og slette den manuelt.';
$string['filter_basiclti_configlink'] = 'Konfigurer dine foretrukne portaler og tilhørende passord.';
$string['filter_basiclti_password'] = 'Passord er obligatorisk.';
$string['filterconfig'] = 'LTI-administrasjon';
$string['filtername'] = 'LTI';
$string['fixexistingconf'] = 'Bruk et eksisterende oppsett for det feilkonfigurerte tilfellet.';
$string['fixnew'] = 'Nytt oppsett';
$string['fixnewconf'] = 'Angi et nytt oppsett for det feilkonfigurerte tilfellet.';
$string['fixold'] = 'Bruk eksisterende';
$string['force_ssl'] = 'Tving SSL';
$string['force_ssl_help'] = 'Hvis du velger denne funksjonen, vil alle oppstarter til denne verktøytilbyderen bli tvunget til å bruke SSL.

I tillegg vil alle webtjeneste-forespørsler fra denne verktøytilbyderen bruke SSL.

Hvis du bruker denne funksjonen, vennligst bekreft at denne Moodleportalen og verktøytilbyderen støtter SSL.';
$string['forced_help'] = 'Denne innstillingen er satt som tvungen i et verktøyoppsett på kurs- eller portalnivå. Du kan ikke endre den fra dette grensesnittet.';
$string['generaltool'] = 'Generelt verktøy';
$string['global_tool_types'] = 'Globale forhåndsoppsatte LTI-verktøy';
$string['grading'] = 'Karakterruting';
$string['icon_url'] = 'Ikon-URL';
$string['icon_url_help'] = 'Ikon-URLen lar deg endre ikonet som vises i kurslisten for denne aktiviteten. I stedet for å bruke standard LTI-ikonet, kan et ikon som formidler typen aktivitet angis.';
$string['id'] = 'ID';
$string['indicator:cognitivedepth'] = 'Kognitivt LTI-verktøy';
$string['indicator:cognitivedepth_help'] = 'Denne indikatoren er basert på kognitiv dybde vist av studenten i en LTI-aktivitet.';
$string['indicator:socialbreadth'] = 'Sosialt LTI-verktøy';
$string['indicator:socialbreadth_help'] = 'Denne indikatoren er basert på sosial bredde vist av studenten i en LTI-aktivitet.';
$string['invalidid'] = 'LTI-IDen var feil';
$string['launch_in_moodle'] = 'Start LTI-verktøyet i moodle';
$string['launch_in_popup'] = 'Oppstartsverktøyet i en popup';
$string['launch_url'] = 'LTI-verktøyets URL';
$string['launch_url_help'] = 'Oppstarts-URLen viser nettadressen til det eksterne LTI-verktøyet, og kan inneholde tilleggsopplysninger, som for eksempel ressursen som skal vises. Hvis du er usikker på hva du skal skrive inn som oppstarts-URL, vennligst sjekk med verktøytilbyderen for mer informasjon.

Du kan også skrive inn en pakke-URL, om du har den, og da vil resten at innstillingene fylles ut automatisk.

Hvis du har valgt et bestemt forhåndsoppsatt LTI-verktøy, kan det hende at du ikke trenger å skrive inn noen oppstarts-URL. Dette er ofte tilfelle hvis verktøylenken er brukt til å starte inn i verktøytilbyderens system og ikke til å gå til en bestemt ressurs.';
$string['launchinpopup'] = 'Oppstartsbeholder';
$string['launchinpopup_help'] = 'Oppstartsbeholderen påvirker visningen av verktøyet når det blir åpnet fra kurset. Noen oppstartsbeholdere gir mer skjermplass til verktøyet, og andre gir en mer integrert opplevelse med Moodleomgivelsene.


* **Standard** - Bruk oppstartsbeholderen som er angitt i verktøyoppsettet. * **Innebygd** - Verktøyet vises inni Moodle-vinduet, på en måte som er lik de fleste andre aktivitetstyper. * **Innebygd, uten blokker** - Verktøyet vises inni Moodle-vinduet, med bare navigasjonskontrollen på toppen av siden. * **Nytt vindu** - Verktøyet åpnes i et nytt vindu som tar opp all tilgjengelig plass. Det vil åpnes i en ny fane eller et popup-vindu, avhengig av nettleseren. Det er mulig at noen nettlesere kan hindre det nye vinduet fra å åpne.';
$string['launchoptions'] = 'Oppstartsalternativer';
$string['leaveblank'] = 'La være tom hvis den ikke trengs';
$string['lti'] = 'LTI';
$string['lti:addcoursetool'] = 'Legg til kursspesifikke verktøykonfigurasjoner';
$string['lti:addinstance'] = 'Legg til ny LTI-aktivitet';
$string['lti:admin'] = 'Vær administrator når verktøyet starter';
$string['lti:grade'] = 'Vis karakterer returnert fra LTI-aktiviteter';
$string['lti:manage'] = 'Bli instruktør når verktøyet startes';
$string['lti:requesttooladd'] = 'Send et verktøy som skal konfigureres til administrator';
$string['lti:view'] = 'Start LTI-aktiviteter';
$string['lti_administration'] = 'Rediger forhåndsoppsatt LTI-verktøy';
$string['lti_errormsg'] = 'Verktøyet genererte følgende feilmelding: "{$a}"';
$string['lti_launch_error'] = 'En feil oppstod da det eksterne verktøyet ble startet:';
$string['lti_launch_error_tool_request'] = '<p>
For å sende en forespørsel til en administrator om å fullføre oppsettet av verktøyet, klikk <a href="{$a->admin_request_url}" target="_top">her</a>. </p>';
$string['lti_launch_error_unsigned_help'] = '<p> Denne feilen kan være et resultat av manglende forbrukernøkkel og delt hemmelig streng til verktøytilbyderen. </p> <p> Hvis du har en forbrukernøkkel og delt hemmelig streng, kan du skrive det inn når du redigerer tilfellet i det eksterne verktøyet (forsikre deg om at avanserte valg er synlige).<br /> En annen mulighet er å opprette et verktøytilbyderoppsett på kursnivå <a href="{$a->course_tool_editor}">her</a>. </p>';
$string['lti_tool_request_added'] = 'Forespørselen om verktøyinnstillinger er sendt. Det kan hende at du må kontakte en administrator for å fullføre verktøyoppsettet.';
$string['lti_tool_request_existing'] = 'En forespørsel om verktøyinnstillinger for verktøydomenet har allerede blitt sendt.';
$string['ltisettings'] = 'LTI-innstillinger';
$string['ltiunknownserviceapicall'] = 'LTI ukjent API-service kall';
$string['main_admin'] = 'Generell hjelp';
$string['main_admin_help'] = 'Eksterne verktøy gir Moodlebrukere muligheten til å kommunisere med og bruke læringsressurser som hostes eksternt. Gjennom en spesiell startprotokoll gis det eksterne verktøyet tilgang til generell informasjon om brukeren som starter det. Eksempler på informasjon som deles med verktøyet kan være navn på institusjon, kurs-ID, bruker-ID, og annen informasjon som for eksempel brukernavn eller epostadresse.

LTI-verktøyene som vises på denne siden kan deles opp i tre kategorier:

* **Aktive** - Disse verktøytilbyderne har blitt godkjent og konfigurert av en administrator. De kan brukes i hvilket som helst kurs på denne Moodleinstallasjonen. Hvis en forbrukernøkkel og delt hemmelig streng blir fastsatt, etablerer dette et tillitsforhold mellom denne Moodleinstallasjonen og det eksterne verktøyet, som igjen gir en sikker kanal for kommunikasjon.
* **På vent** - Disse verktøytilbyderne har blitt importert som en del av en pakke, men har ikke blitt konfigurert av noen administrator. Lærere kan fortsatt bruke verktøy fra disse tilbyderne hvis de har en forbrukernøkkel og delt hemmelig streng, eller hvis forbrukernøkkel/hemmelig streng ikke er påkrevd.
* **Avvist** - Disse verktøytilbyderne er merket som tilbydere som en administrator ikke har til hensikt å gjøre tilgjengelige for hele Moodleinstallasjonen. Lærere kan fortsatt bruke verktøy fra disse tilbyderne hvis de har en forbrukernøkkel og delt hemmelig streng, eller hvis forbrukernøkkel/hemmelig streng ikke er påkrevd.';
$string['manage_external_tools'] = 'Administrer LTI-verktøy';
$string['manage_tool_proxies'] = 'Administrer LTI-registreringer';
$string['manage_tools'] = 'Adminstrer forhåndsoppsatte LTI-verktøy';
$string['manuallyaddtype'] = 'Alternativt så kan du <a href="{$a}">konfigurere et LTI-verktøy manuelt.</a>.';
$string['miscellaneous'] = 'Diverse';
$string['misconfiguredtools'] = 'Feilkonfigurerte verktøy funnet';
$string['missingparameterserror'] = 'Denne siden er feilkonfigurert: "{$a}"';
$string['module_class_type'] = 'Modultype i Moodle';
$string['modulename'] = 'Eksternt verktøy';
$string['modulename_help'] = 'Aktivitetsmodulen Eksternt verktøy lar studenter være interaktive med læringsressurser og aktiviteter på andre nettsteder. F.eks. kan et eksternt verktøy gi tilgang til en ny aktivitetstype eller læringsmateriell fra en utgiver.

For å opprette en aktivitet knyttet til et eksternt verktøy kreves det en verktøytilbyder som støtter LTI (learning Tools Interoperability). Lærere kan opprette en aktivitet knyttet til et eksternt verktøy eller benytte seg av verktøy som er satt opp av portaladministrator.

Aktiviteter knyttet til eksterne verktøy skiller seg ut fra URL-ressurser på følgende måte:

*Eksterne verktøy har kjennskap til konteksten de blir brukt i. Dvs. at de har tilgang til informasjon om brukeren som startet verktøyet, som f.eks. institusjon, kurs og navn.
* Eksterne verktøy støtter lesing, oppdatering og sletting av karakterer som er knyttet til aktiviteten.
* Oppsett av eksterne verktøy skaper et tillitsforhold mellom din portal og verktøytilbyderen; sikker kommunikasjon mellom partene er mulig.';
$string['modulenameplural'] = 'Eksterne verktøy';
$string['modulenamepluralformatted'] = 'LTI-forekomster';
$string['name'] = 'Navn';
$string['never'] = 'Aldri';
$string['new_window'] = 'Nytt vindu';
$string['no_lti_configured'] = 'Det er ingen aktive konfigurasjoner for eksterne verktøy';
$string['no_lti_pending'] = 'Det er ingen eksterne verktøy på vent';
$string['no_lti_rejected'] = 'Det er ingen avviste eksterne verktøy';
$string['no_lti_tools'] = 'Det er ikke satt opp noen LTI-verktøy';
$string['no_tp_accepted'] = 'Det er ingen godkjente registreringer for eksterne verktøy.';
$string['no_tp_cancelled'] = 'Det er ingen kansellerte registreringer for eksterne verktøy.';
$string['no_tp_configured'] = 'Det finnes ingen uregistrerte LTI-verktøy som er konfigurert.';
$string['no_tp_pending'] = 'Det er ingen registreringer for eksterne verktøy som venter på godkjenning.';
$string['no_tp_rejected'] = 'Det er ingen avviste registreringer for eksterne verktøy.';
$string['noattempts'] = 'Ingen forsøk har blitt gjort på dette verktøyet.';
$string['noltis'] = 'Det er ingen forekomster av eksterne verktøy';
$string['noprofileservice'] = 'Fant ingen profilservice';
$string['noservers'] = 'Ingen servere funnet';
$string['notypes'] = 'Det er for øyeblikket ingen LTI-verktøyoppsett i Moodle. Klikk på Installer-lenken ovenfor for å legge til noen.';
$string['noviewusers'] = 'Ingen brukere med tillatelse til å bruke dette verkøyet ble funnet.';
$string['optionalsettings'] = 'Valgfrie innstillinger';
$string['organization'] = 'Informasjon om organisasjonen';
$string['organizationdescr'] = 'Beskrivelse av organisasjonen';
$string['organizationid'] = 'Organisasjonens ID';
$string['organizationid_help'] = 'En unik ID for denne Moodleinstallasjonen. Vanligvis brukes DNS-navnet til organisasjonen (domain name system).

Hvis du lar dette feltet stå tomt, vil vertsnavnet på Moodleportalen brukt som standardverdi.';
$string['organizationurl'] = 'Organisasjonens URL';
$string['organizationurl_help'] = 'Basis-URLen til denne Moodleinstallasjonen.

Hvis du lar dette feltet stå tomt, vil en standardverdi basert på portalinnstillingene bli brukt.';
$string['pagesize'] = 'Antall innleveringer som vises på hver side';
$string['parameter'] = 'Verktøyparameter';
$string['parameter_help'] = 'Verktøyparametrene er innstilinger som kreves av verktøytilbyderen som en del av oppkoblingen.';
$string['password'] = 'Delt hemmelig streng';
$string['password_admin'] = 'Delt hemmelig streng';
$string['password_admin_help'] = 'Den delte hemmelige strengen kan betraktes som et passord som skal brukes til å autentisere tilgang til verktøyet. Det skal oppgis sammen med forbrukernøkkelen fra verktøytilbyderen.

Det kan være at verktøy som ikke er avhengig av sikker kommunikasjon fra Moodle og som ikke gir tilleggstjenester (som for eksempel karakterrapportering) ikke krever en delt hemmelig streng.';
$string['password_help'] = 'For forhåndskonfigurerte verktøy er det ikke nødvendig å skrive inn noen delt hemmelig streng her, siden den delte hemmelige strengen vil bli oppgitt som en del av prosessen med å sette opp verktøyet.

Dette feltet skal fylles ut hvis du skal lage en lenke til en verktøytilbyder som ikke allerede er konfigurert.
Hvis verktøytilbyderen skal brukes mer enn en gang i dette kurset er det en god ide å legge til et verktøyoppsett.

Den delte hemmelige strengen kan betraktes som et passord som brukes til å autentisere tilgang til verktøyet. Det skal oppgis sammen med forbrukernøkkelen fra verktøytilbyderen.

Det kan være at verktøy som ikke trenger sikker kommunikasjon fra Moodle og som ikke tilbyr tilleggstjenester (som for eksempel karakterrapportering) ikke krever noen delt hemmelig streng.';
$string['pending'] = 'På vent';
$string['pluginadministration'] = 'Administrasjon av LTI-verktøy';
$string['pluginname'] = 'LTI-verktøy';
$string['preferheight'] = 'Standardverdi for høyde';
$string['preferwidget'] = 'Standardverdi for oppstart av Widget';
$string['preferwidth'] = 'Standardverdi for bredde';
$string['press_to_submit'] = 'Trykk for å starte denne aktiviteten';
$string['privacy'] = 'Personvern';
$string['privacy:metadata:coursefullname'] = 'Det fulle navnet til kurset brukeren får tilgang til LTI-forbrukeren fra';
$string['privacy:metadata:courseid'] = 'ID\'en til kurset brukeren får tilgang til LTI-forbrukeren fra';
$string['privacy:metadata:courseidnumber'] = 'ID nummeret til kurset brukeren får tilgang til LTI-forbrukeren fra';
$string['privacy:metadata:courseshortname'] = 'Knavnet til kurset brukeren får tilgang til LTI-forbrukeren fra';
$string['privacy:metadata:createdby'] = 'Brukeren som laget oppføringen';
$string['privacy:metadata:email'] = 'E-postadreesen til brukeren som åpner LTI-forbrukeren';
$string['privacy:metadata:externalpurpose'] = 'LTI-forbrukeren tilbyr brukerinformasjon og kontekst til LTI tilbyderen.';
$string['privacy:metadata:firstname'] = 'Fornavnet til brukeren som åpner LTI-forbrukeren';
$string['privacy:metadata:fullname'] = 'Hele navnet til brukeren som åpner LTI-forbrukeren';
$string['privacy:metadata:lastname'] = 'Etternavnet til brukeren som åpner LTI-forbrukeren';
$string['privacy:metadata:lti_submission'] = 'LTI innlevering';
$string['privacy:metadata:lti_submission:datesubmitted'] = 'Tidsstempelet som viser når innleveringen ble gjort';
$string['privacy:metadata:lti_submission:dateupdated'] = 'Tidsstempelet som viser når innleveringen ble endrer';
$string['privacy:metadata:lti_submission:gradepercent'] = 'Brukerens karakter vist som prosent';
$string['privacy:metadata:lti_submission:originalgrade'] = 'Brukerens opprinnelige karakter';
$string['privacy:metadata:lti_submission:userid'] = 'IDen til brukeren som leverte inn i LTI-aktiviteten.';
$string['privacy:metadata:lti_tool_proxies'] = 'LTI proxier';
$string['privacy:metadata:lti_tool_proxies:name'] = 'LTI proxynavn';
$string['privacy:metadata:lti_types'] = 'LTI-typer';
$string['privacy:metadata:lti_types:name'] = 'LTI typenavn';
$string['privacy:metadata:role'] = 'Kursrollen til brukeren som går inn i LTI konsumenten';
$string['privacy:metadata:timecreated'] = 'Tidsounktet oppføringen ble opprettet';
$string['privacy:metadata:timemodified'] = 'Tidspunktet oppføringen ble endret';
$string['privacy:metadata:userid'] = 'ID\'en til brukeren som åpner LTI-forbrukeren';
$string['privacy:metadata:useridnumber'] = 'ID-nummeret til brukeren som åpner LTI-forbrukeren';
$string['privacy:metadata:username'] = 'Brukernavnet til brukeren som åpner LTI-forbrukeren';
$string['quickgrade'] = 'Tillat hurtig karaktersetting';
$string['quickgrade_help'] = 'Hvis denne funksjonen er aktivert, kan det legges til karakter på flere verktøy på en side. Legg til karakterer og kommentarer og klikk så på knappen "Lagre alle mine tilbakemeldinger" for å lagre alle endringene på siden.';
$string['redirect'] = 'Om noen sekunder vil du bli omdirigert. Hvis ikke dette skjer, må du trykke på knappen.';
$string['register'] = 'Registrer';
$string['register_warning'] = 'Det ser ut til å ta tid før registreringssiden åpnes. Hvis den ikke vises bør du sjekke om du har lagt inn korrekt URL i konfigurasjonsinnstillingene. Dersom Moodle benytter https må du forsikre deg om at LTI-verktøyet støtter det og at du bruker https i URL\'en.';
$string['registertype'] = 'Sett opp en ny registrering av eksterne verktøy';
$string['registration_options'] = 'Registreringsvalg';
$string['registrationname'] = 'Navn på verktøyleverandør';
$string['registrationname_help'] = 'Legg inn navnet på verktøyleverandøren';
$string['registrationurl'] = 'RegistreringsURL';
$string['registrationurl_help'] = 'RegistreringsURLen skal være tilgjengelig via verktøyleverandøren.';
$string['reject'] = 'Avvis';
$string['rejected'] = 'Avvist';
$string['resource'] = 'Ressurs';
$string['resourcekey'] = 'Forbrukernøkkel';
$string['resourcekey_admin'] = 'Forbrukernøkkel';
$string['resourcekey_admin_help'] = 'Forbrukernøkkelen kan betraktes som et brukernavn som brukes til å autentisere tilgang til verktøyet. Det kan brukes av verktøytilbyderen for å identifisere Moodleportalen som brukerene starter verktøyet fra.

Forbrukernøkkelen får du oppgitt av verktøytilbyderen.Det varierer fra verktøytilbyder til verktøytilbyder hvordan du får tak i forbrukernøkkelen. Noen ganger kan det være en automatisk prosess, andre ganger er det nødvendig å opprette en dialog med verktøytilbyderen.

Det kan være at verktøy som ikke trenger sikker kommunikasjon fra Moodle og som ikke tilbyr tilleggstjenester (som for eksempel karakterrapportering) ikke krever noen ressursnøkkel.';
$string['resourcekey_help'] = 'For forhåndskonfigurerte verktøy er det ikke nødvendig å skrive inn noen forbrukernøkkel her, siden forbrukernøkkelen vil bli oppgitt som en del av prosessen med å sette opp verktøyet.

Dette feltet skal fylles ut hvis du skal lage en lenke til en verktøytilbyder som ikke allerede er konfigurert.
Hvis verktøytilbyderen skal brukes mer enn en gang i dette kurset er det en god ide å legge til et verktøyoppsett.

Forbrukernøkkelen kan betraktes som et brukernavn som brukes til å autentisere tilgang til verktøyet. Det kan brukes av verktøytilbyderen for å identifisere Moodleportalen som brukerene starter verktøyet fra.

Forbrukernøkkelen får du oppgitt av verktøytilbyderen. Det varierer fra verktøytilbyder til verktøytilbyder hvordan du får tak i forbrukernøkkelen. Noen ganger kan det være en automatisk prosess, andre ganger er det nødvendig å opprette en dialog med verktøytilbyderen.

Det kan være at verktøy som ikke trenger sikker kommunikasjon fra Moodle og som ikke tilbyr tilleggstjenester (som for eksempel karakterrapportering) ikke krever noen ressursnøkkel.';
$string['resourceurl'] = 'Ressurs-URL';
$string['return_to_course'] = 'Klikk <a href="{$a->link}" target="_top">her</a> for å gå tilbake til kurset.';
$string['saveallfeedback'] = 'Lagre alle tilbakemeldingene mine';
$string['search:activity'] = 'LTI-verktøy - aktivitetsinformasjon';
$string['secure_icon_url'] = 'Sikker ikon-URL';
$string['secure_icon_url_help'] = 'Likner på ikon-URL, men brukes når brukeren har sikker adgang gjennom SSL. Hovedhensikten med dette feltet er å forhindre nettleseren i vise et advarsel om et usikkert bilde.';
$string['secure_launch_url'] = 'Sikker URL for LTI-verktøyet';
$string['secure_launch_url_help'] = 'Veldig lik LTI-verktøyets URL, men brukes i stedet for hvis det er nødvendig med høy sikkerhet. Moodle bruker den sikre URLen i stedet hvis tilgangen til Moodleportalen er gjennom SSL, eller hvis verktøyoppsettet er satt til å alltid starte gjennom SSL.

LTI-verktøyets-URLen kan også settes til en https-adresse for å tvinge start gjennom SSL. Dette feltet kan også stå tomt.';
$string['selectcontent'] = 'Velg innhold';
$string['send'] = 'Send';
$string['services'] = 'Tjenester';
$string['services_help'] = 'Velg de tjenestene du ønsker å tilby verktøyleverandøren. Det kan velges mer enn en tjeneste.';
$string['setupoptions'] = 'Oppsettsvalg';
$string['share_email'] = 'Oppgi navnet til brukeren (som starter verktøyet) til verktøyet';
$string['share_email_admin'] = 'Oppgi navnet til brukeren (som starter verktøyet) til verktøyet';
$string['share_email_admin_help'] = 'Angi hvorvidt epostadressen til brukeren som starter verktøyet skal oppgis til verktøytilbyderen.
Det kan være at verktøytilbyderen trenger epostadressene til personene som starter verktøyet for å kunne skille mellom brukere med samme navn, eller sende eposter til brukere, basert på handlinger inne i verktøyet.';
$string['share_email_help'] = 'Angi hvorvidt epostadressen til brukeren som starter LTI-verktøyet skal oppgis til verktøytilbyderen.
Det kan være at verktøytilbyderen trenger epostadressene til personene som starter verktøyet for å kunne skille mellom brukere med samme navn, eller sende eposter til brukere, basert på handlinger inne i verktøyet.

Vær oppmerksom på at denne innstillingen kan overstyres i verktøyinnstillingene.';
$string['share_name'] = 'Oppgi navnet til personen som starter verktøyet til verktøyet.';
$string['share_name_admin'] = 'Oppgi navnet til personen som starter verktøyet til verktøyet.';
$string['share_name_admin_help'] = 'Angi hvorvidt det fulle navnet til brukeren som starter verktøyet skal oppgis til verktøytilbyderen.
Det kan være at verktøytilbyderen trenger navnene til personene som starter verktøyet for å kunne vise meningsfull informasjon inne i verktøyet.';
$string['share_name_help'] = 'Angi om det fulle navnet til brukeren som starter LTI-verktøyet skal oppgis til verktøytilbyderen.
Det kan være at verktøytilbyderen trenger navnene til personene som starter verktøyet for å kunne vise meningsfull informasjon inne i verktøyet.

Vær oppmerksom på at denne innstillingen kan overstyres i verktøyinnstillingene.';
$string['share_roster'] = 'Gi verktøyet tilgang til dette kursets liste over brukere';
$string['share_roster_admin'] = 'Verktøyet kan ha tilgang til listen over brukere';
$string['share_roster_admin_help'] = 'Angi om LTI-verktøyet skal få tilgang til listen over brukere som er påmeldt kurset.';
$string['share_roster_help'] = 'Angi om LTI-verktøyet skal få tilgang til listen over brukere som er påmeldt kurset.

Vær oppmerksom på at denne innstillingen kan overstyres i verktøyinnstillingene.';
$string['show_in_course_activity_chooser'] = 'Vis i aktivitetsvelger og som et forhåndsoppsatt LTI-verktøy';
$string['show_in_course_lti1'] = 'LTI-verktøy konfigurering bruk';
$string['show_in_course_lti1_help'] = 'Dette LTI-verktøyet kan vises i aktivitetsvelgeren slik at en lærer kan velge å legge det til i et kurs. Alternativt kan det vises i nedtrekssmenyen for forhåndsoppsatte LTI-verktøy når det legges til et LTI-verktøy i et kurs. Et siste valg er at verktøyoppsettet bare blir brukt dersom den eksakte verktøy-URLen skrives inn når det legges til et LTI-verktøy i et kurs.';
$string['show_in_course_lti2'] = 'LTI-verktøy konfigurering bruk';
$string['show_in_course_lti2_help'] = 'Dette LTI-verktøyet kan vises i aktivitetsvelgeren slik at en lærer kan velge å legge det til i et kurs, eller i nedtrekksmenyen over forhåndsoppsatte verktøy når et LTI-vertøy legges til et kurs.';
$string['show_in_course_no'] = 'Ikke vis; bruk kun når en matchende oppstarts-URL legges inn.';
$string['show_in_course_preconfigured'] = 'Vis som forhåndsoppsatt LTI-verktøy når det legges til et nytt LTI-verktøy';
$string['size'] = 'Størrelseparametere';
$string['submission'] = 'Innlevering';
$string['submissions'] = 'Innsendelser';
$string['submissionsfor'] = 'Innleveringer for {$a}';
$string['subplugintype_ltiresource'] = 'LTI tjenesteressurs';
$string['subplugintype_ltiresource_plural'] = 'LTI tjenesteressurser';
$string['subplugintype_ltiservice'] = 'LTI tjeneste';
$string['subplugintype_ltiservice_plural'] = 'LTI tjenester';
$string['subplugintype_ltisource'] = 'LTI-kilde';
$string['subplugintype_ltisource_plural'] = 'LTI-kilder';
$string['successfullycreatedtooltype'] = 'Vellykket opprettelse av nytt LTI-verktøy!';
$string['successfullyfetchedtoolconfigurationfromcontent'] = 'Vellyket henting av verktøykonfigurasjon fra det valgte innholdet.';
$string['toggle_debug_data'] = 'Bytte om på feilsøkingsdata';
$string['tool_config_not_found'] = 'Fant ingen verktøyoppsett for denne URL-en';
$string['tool_settings'] = 'LTI-innstillinger';
$string['tooldescription'] = 'Beskrivelse av LTI-verktøy';
$string['tooldescription_help'] = 'Beskrivelsen av LTI-verktøyet som vil vises i aktivitetslisten  til lærerne.

Dette bør si noe om hva verktøyet er for, hva det gjør og annen informasjon lærere bør vite.';
$string['toolisbeingused'] = 'Dette LTI-verktøyet er brukt {$a} ganger';
$string['toolisnotbeingused'] = 'Dette LTI-verktøyet har ennå ikke blitt brukt';
$string['toolproxy'] = 'Eksterne verktøyregistreringer';
$string['toolproxy_help'] = 'LTI-registreringer tillater Moodle administratorene å konfigurere LTI fra en verktøy proxy hentet fra en verktøyleverandør som støtter LTI 2.0. Registrerings-URL levert av verktøyleverandøren er alt som kreves for å starte prosessen. Muligheter og tjenester som tilbys til verktøyleverandør er valgt når du konfigurerer en ny registrering.

Verktøyregistreringer oppført på denne siden er delt inn i fire kategorier:

* ** Konfigurert ** - Disse verktøy registreringene er satt opp, men registreringsprosessen har ennå ikke startet.
* ** Venter ** - Registreringsprosessen for disse verktøy registreringer har blitt startet, men har ikke fullført. Åpne og lagre innstillingene for å flytte den tilbake til kategoriene "konfigurert".
* ** Akseptert ** - Disse verktøyregistreringene er godkjent; de ressurser som er spesifisert i verktøy proxy vil vises i listen med forhåndsoppsatte LTI-verktøy med statusen "Venter".
* ** Avvist ** - Disse verktøyregistreringer er de som ble avvist under registreringsprosessen. Åpne og lagre innstillingene for å flytte den tilbake til kategoriene "konfigurert" så registreringsprosessen kan startes igjen.';
$string['toolproxyregistration'] = 'Registrering av eksternt verktøy';
$string['toolregistration'] = 'Registrering av eksternt verktøy';
$string['toolsetup'] = 'LTI verktøyoppsett';
$string['tooltypeadded'] = 'La til forhåndsoppsatt LTI-verktøy';
$string['tooltypedeleted'] = 'Slettet forhåndsoppsatt LTI-verktøy';
$string['tooltypenotdeleted'] = 'Kunne ikke slette forhåndsoppsatt LTI-verktøy';
$string['tooltypes'] = 'LTI-verktøy';
$string['tooltypeupdated'] = 'Oppdaterte forhåndsoppsatt LTI-verktøy';
$string['toolurl'] = 'LTI-verktøyets URL';
$string['toolurl_contentitemselectionrequest'] = 'URL for innholdsvelging';
$string['toolurl_contentitemselectionrequest_help'] = 'InnholdsvelgerURLen vil brukes til å vise innholdsvalgsiden fra LTI tilbyderen. Dersom den  er tom vil Vertøy-URLen brukes i stedet.';
$string['toolurl_help'] = 'LTI-verktøyets URL brukes til å matche verktøyets oppstarts-URL med det rette verktøyoppsettet. Å sette http(s) foran URLen er valgfritt.

I tillegg brukes basis-URLen som start-URL hvis en start-URL ikke er angitt i den eksterne verktøyinstansen.

For eksempel vil en verktøy-URL på formen *tool.com* matche følgende:

* tool.com
* tool.com/quizzes
* tool.com/quizzes/quiz.php?id=10
* www.tool.com/quizzes

En verktøy-URL på formen *www.tool.com/quizzes* vil matche med følgende:

* www.tool.com/quizzes
* tool.com/quizzes/take.php?id=10
* www.tool.com/quizzes

En verktøy-URL på formen*quiz.tool.com* vil matche med følgende:

* quiz.tool.com
* quiz.tool.com/take.php?id=10

Hvis to forskjellige verktøyoppsett er for samme domene, brukes den som passer best.

Du kanogså sette inn en kapsel-URL dersom du har en og da vil LTI-verktøydetaljene automatisk fylles inn.';
$string['toolurlplaceholder'] = 'URL for LTI-verktøy';
$string['typename'] = 'Navn på LTI-ressursen';
$string['typename_help'] = 'Navnet på verktøyet brukes til å identifisere verktøytilbyderen inne i Moodle. Navnet som skrives inn kommer til å være synlig for lærere når eksterne verktøy blir lagt til inni kurs.';
$string['types'] = 'Typer';
$string['unabletocreatetooltype'] = 'Kunne ikke opprette LTI-verktøy';
$string['unabletofindtooltype'] = 'Kunne ikke finne LTI-verktøy for {$a->id}';
$string['unknownstate'] = 'Ukjent tilstand';
$string['update'] = 'Oppdatering';
$string['useraccountinformation'] = 'Brukerkontoinformasjon';
$string['userpersonalinformation'] = 'Personlig brukerinformasjon';
$string['using_tool_cartridge'] = 'Bruker LTI-verktøypakke';
$string['using_tool_configuration'] = 'Bruker verktøyoppsett:';
$string['validurl'] = 'Gyldig URL må starte med http(s)://';
$string['viewsubmissions'] = 'Vis innleveringer og karakterskjermbildet';
