<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'competency', language 'no', version '3.5'.
 *
 * @package     competency
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['allchildrenarecomplete'] = 'Alle underordnede elementer er fullført';
$string['competencies'] = 'Læringsmål';
$string['competenciesarenotenabled'] = 'Læringsmål er ikke aktivert';
$string['competenciessettings'] = 'Læringsmålinnstillinger';
$string['completeplanstask'] = 'Fullfør læreplaner som forfaller';
$string['coursecompetencyoutcome_complete'] = 'Fullfør læringsmålet';
$string['coursecompetencyoutcome_evidence'] = 'Legg ved bekreftelse/bevis';
$string['coursecompetencyoutcome_none'] = 'Ikke gjør noe';
$string['coursecompetencyoutcome_recommend'] = 'Send inn til godkjenning';
$string['coursemodulecompetencyoutcome_complete'] = 'Fullfør læringsmålet';
$string['coursemodulecompetencyoutcome_evidence'] = 'Legg ved bekreftelse/bevis';
$string['coursemodulecompetencyoutcome_none'] = 'Ikke gjør noe';
$string['coursemodulecompetencyoutcome_recommend'] = 'Send inn til godkjenning';
$string['deletecompetencyratings'] = 'Slett læringsmålvurderinger';
$string['duplicateditemname'] = '{$a} (kopi)';
$string['enablecompetencies'] = 'Aktiver læringsmål';
$string['enablecompetencies_desc'] = 'Læringsmål åpner for at brukere kan vurderes opp mot opplæringsplaner';
$string['errorcannotchangeapastduedate'] = 'Fristen er passert og kan ikke endres.';
$string['errorcannotsetduedateinthepast'] = 'Fristen kan ikke bli satt til fortiden';
$string['errorcannotsetduedatetoosoon'] = 'Fristen er for kort inn i framtiden.';
$string['errorcompetencyrule'] = 'Kurslæringsmålregelen \'{$a}\' er ukjent';
$string['errorcoursecompetencyrule'] = 'Kurslæringsmålregelen \'{$a}\' er ukjent';
$string['errorinvalidcourse'] = 'Ugyldig kurs';
$string['errornocompetency'] = '{$a} læringsmål finnes ikke';
$string['errorplanstatus'] = 'Opplæringsplanen \'{$a}\' sin status er ukjent';
$string['errorscalealreadyused'] = 'Skalaen kan ikke endres siden den allerede er i bruk.';
$string['errorscaleconfiguration'] = 'Skalaen må konfigureres ved å velge standard- og talentelementer.';
$string['errorusercomptencystatus'] = 'Brukerens læringsmålstatus for \'{$a}\' er ukjent';
$string['eventcompetencycreated'] = 'Læringsmål opprettet';
$string['eventcompetencydeleted'] = 'Læringsmål slettet';
$string['eventcompetencyframeworkcreated'] = 'Læringsmålrammeverk er opprettet.';
$string['eventcompetencyframeworkdeleted'] = 'Læringsmålrammeverk er slettet.';
$string['eventcompetencyframeworkupdated'] = 'Læringsmålrammeverk er oppdatert.';
$string['eventcompetencyframeworkviewed'] = 'Læringsmålrammeverk vist.';
$string['eventcompetencyupdated'] = 'Læringsmål oppdatert.';
$string['eventcompetencyviewed'] = 'Læringsmål vist.';
$string['eventevidencecreated'] = 'Bekreftelse opprettet.';
$string['eventplanapproved'] = 'Opplæringsplan godkjent.';
$string['eventplancompleted'] = 'Opplæringsplan fullført.';
$string['eventplancreated'] = 'Opplæringsplan opprettet.';
$string['eventplandeleted'] = 'Opplæringsplan slettet.';
$string['eventplanreopened'] = 'Opplæringsplan gjenåpnet.';
$string['eventplanreviewrequestcancelled'] = 'Forespørsel om gjennomgang av opplæringsplan er avbrutt.';
$string['eventplanreviewrequested'] = 'Forespørsel om gjennomgang av opplæringsplan.';
$string['eventplanreviewstarted'] = 'Gjennomgang av opplæringsplan startet.';
$string['eventplanreviewstopped'] = 'Gjennomgang av opplæringsplan stoppet.';
$string['eventplanunapproved'] = 'Opplæringsplan underkjent.';
$string['eventplanunlinked'] = 'Opplæringsplan er koblet fra.';
$string['eventplanupdated'] = 'Opplæringsplan oppdatert.';
$string['eventplanviewed'] = 'Opplæringsplan vist.';
$string['eventtemplatecreated'] = 'Opplæringsplanmal opprettet.';
$string['eventtemplatedeleted'] = 'Opplæringsplanmal slettet.';
$string['eventtemplateupdated'] = 'Opplæringsplanmal oppdatert.';
$string['eventtemplateviewed'] = 'Opplæringsplanmal vist.';
$string['eventusercompetencyplanviewed'] = 'Brukerkompetanseplan vist.';
$string['eventusercompetencyrated'] = 'Brukerkompetanse vurdert';
$string['eventusercompetencyratedincourse'] = 'Brukerkompetanse vurdert i kurs.';
$string['eventusercompetencyratedinplan'] = 'Brukerkompetanse vurdert i opplæringsplan.';
$string['eventusercompetencyreviewrequestcancelled'] = 'Forespørsel om gjennomgang av brukerkompetanse avbrutt.';
$string['eventusercompetencyreviewrequested'] = 'Forespørsel om gjennomgang av brukerkompetanse.';
$string['eventusercompetencyreviewstarted'] = 'Gjennomgang av brukerkompetanse startet.';
$string['eventusercompetencyreviewstopped'] = 'Gjennomgang av brukerkompetanse stoppet.';
$string['eventusercompetencyviewed'] = 'Brukerkompetanse vist.';
$string['eventusercompetencyviewedincourse'] = 'Brukers læringsmål vist i et kurs';
$string['eventusercompetencyviewedinplan'] = 'Brukers læringsmål vist i en opplæringsplan';
$string['eventuserevidencecreated'] = 'Bevis på tidligere læring opprettet';
$string['eventuserevidencedeleted'] = 'Bevis på tidligere læring slettet';
$string['eventuserevidenceupdated'] = 'Bevis på tidligere læring oppdatert';
$string['evidence_competencyrule'] = 'Læringsmålregelen ble møtt';
$string['evidence_coursecompleted'] = 'Kurset \'{$a}\' ble fullført.';
$string['evidence_coursemodulecompleted'] = 'Aktiviteten \'{$a}\' ble fullført.';
$string['evidence_courserestored'] = 'Vurderingen ble gjenopprettet sammen med kurset \'{$a}\'.';
$string['evidence_evidenceofpriorlearninglinked'] = 'Beviset \'{$a}\' på tidligere læring ble lenket.';
$string['evidence_evidenceofpriorlearningunlinked'] = 'Lenken til beviset \'{$a}\' på tidligere læring ble fjernet.';
$string['evidence_manualoverride'] = 'Læringsmålvurderingen ble satt manuelt.';
$string['evidence_manualoverrideincourse'] = 'Læringsmålvurderingen ble satt manuelt i kurset \'{$a}\'.';
$string['evidence_manualoverrideinplan'] = 'Læringsmålvurderingen ble satt manuelt i opplringsplanen \'{$a}\'.';
$string['invalidevidencedesc'] = 'Ugyldig bevisbeskrivelse';
$string['invalidgrade'] = 'Ugyldig vurdering';
$string['invalidpersistent'] = 'Vedvarende ugylidghet';
$string['invalidpersistenterror'] = 'Feil: {$a}';
$string['invalidplan'] = 'Individuell opplæringsplan';
$string['invalidtaxonomy'] = 'Ugyldig taksonomi: {$a}';
$string['invalidurl'] = 'URLen er ikke gyldig. Pass på at den starter \'med http://\' eller \'https://\'.';
$string['planstatusactive'] = 'Aktiv';
$string['planstatuscomplete'] = 'Fullført';
$string['planstatusdraft'] = 'Utkast';
$string['planstatusinreview'] = 'Under vurdering';
$string['planstatuswaitingforreview'] = 'Venter på vurdering';
$string['pointsrequiredaremet'] = 'Påkrevd poengsum er oppnådd';
$string['privacy:evidence:action:complete'] = 'Fullfør læringsmål dersom uvurdert';
$string['privacy:evidence:action:log'] = 'Logg handling';
$string['privacy:evidence:action:override'] = 'Overstyr læringsmålvurdering';
$string['privacy:metadata:competency'] = 'En oppføring med læringsmål';
$string['privacy:metadata:competency_coursecomp'] = 'En oppføring med læringsmål lenket til kurset';
$string['privacy:metadata:competency_coursecompsetting'] = 'En oppføring med læringsmål i et kurs';
$string['privacy:metadata:competency_evidence'] = 'En oppføring med bevis for læringsmålets status';
$string['privacy:metadata:competency_framework'] = 'En oppføring med læringsmålrammeverk';
$string['privacy:metadata:competency_modulecomp'] = 'En oppføring med læringsmål lenket til en modul.';
$string['privacy:metadata:competency_plan'] = 'En oppføring for opplæringsplaner';
$string['privacy:metadata:competency_plancomp'] = 'En oppføring med læringsmål i en opplæringsplan.';
$string['privacy:metadata:competency_relatedcomp'] = 'En oppføring med forholdet mellom læringsmål';
$string['privacy:metadata:competency_template'] = 'En oppføring med opplæringsplanmaler';
$string['privacy:metadata:competency_templatecohort'] = 'En oppføring med kohorter tilknyttet en opplæringsplanmal';
$string['privacy:metadata:competency_templatecomp'] = 'En oppføring med læringsmål i en opplæringsplanmal';
$string['privacy:metadata:competency_usercomp'] = 'En oppføring med en brukers læringsmålstatus';
$string['privacy:metadata:competency_usercompcourse'] = 'En oppføring med en brukers læringsmålstatus i et kurs';
$string['privacy:metadata:competency_usercompplan'] = 'En oppføring med læringsmålstatus i en opplæringsplan';
$string['privacy:metadata:competency_userevidence'] = 'En oppføring med bevis på tidligere læring';
$string['privacy:metadata:competency_userevidencecomp'] = 'En oppføring med læringsmål tilknyttet bevis på tidligere læring';
$string['privacy:metadata:core_comments'] = 'Kommentarer til læringsmål og opplæringsplaner';
$string['privacy:metadata:evidence:action'] = 'Handlingstypen for beviset';
$string['privacy:metadata:evidence:actionuserid'] = 'Brukeren som utfører handlingen';
$string['privacy:metadata:evidence:desca'] = 'De valgfre parametere i den oversatte bevisbeskrivelsen';
$string['privacy:metadata:evidence:desccomponent'] = 'Komponenten i den oversatte bevisbeskrivelsen';
$string['privacy:metadata:evidence:descidentifier'] = 'En identifikator for den oversatte bevisbeskrivelsen';
$string['privacy:metadata:evidence:grade'] = 'Karakteren tilknyttet beviset';
$string['privacy:metadata:evidence:note'] = 'Et ikke-lokalisert notat vedlagt beviset';
$string['privacy:metadata:evidence:url'] = 'En URL relatert til beviset';
$string['privacy:metadata:plan:description'] = 'Beskrivelse av opplæringsplan';
$string['privacy:metadata:plan:duedate'] = 'Firsten for opplæringsplanen';
$string['privacy:metadata:plan:name'] = 'Navn på opplæringsplan';
$string['privacy:metadata:plan:reviewerid'] = 'IDen til sensoren av læringsplanen';
$string['privacy:metadata:plan:status'] = 'Opplæringsplanens status';
$string['privacy:metadata:plan:userid'] = 'IDen til brukeren med denne opplæringsplanen';
$string['privacy:metadata:timecreated'] = 'Tidspunktet oppføringen ble opprettet';
$string['privacy:metadata:timemodified'] = 'Tidspunktet oppføringen ble endret';
$string['privacy:metadata:usercomp:grade'] = 'Karakteren for læringsmålet';
$string['privacy:metadata:usercomp:proficiency'] = 'Om ferdigheten er oppnådd';
$string['privacy:metadata:usercomp:reviewerid'] = 'IDen til sensoren';
$string['privacy:metadata:usercomp:status'] = 'Læringsmålets status';
$string['privacy:metadata:usercomp:userid'] = 'IDen til brukeren som har kompetansen';
$string['privacy:metadata:userevidence:description'] = 'Beskrivelsen av beviset';
$string['privacy:metadata:userevidence:name'] = 'Navnet på beviset på tidligere læring';
$string['privacy:metadata:userevidence:url'] = 'En URL tilknyttet beviset';
$string['privacy:metadata:usermodified'] = 'Brukeren som opprettet eller endret oppføringen';
$string['privacy:path:plans'] = 'Opplæringsplaner';
$string['privacy:path:relatedtome'] = 'Relatert til meg';
$string['privacy:path:userevidence'] = 'Bevis på tidligere læring';
$string['pushcourseratingstouserplans'] = 'Send kursvurderinger til individuelle opplæringsplaner';
$string['pushcourseratingstouserplans_desc'] = 'Standard verdi for kursinnstilling om å oppdatere opplæringsplaner når kurskompetanser blir vurdert.';
$string['syncplanscohorts'] = 'Synkroniser planer fra opplæringsplankohorter';
$string['taxonomy_behaviour'] = 'Oppførsel';
$string['taxonomy_competency'] = 'Læringsmål';
$string['taxonomy_concept'] = 'Konsept';
$string['taxonomy_domain'] = 'Domene';
$string['taxonomy_indicator'] = 'Indikator';
$string['taxonomy_level'] = 'Nivå';
$string['taxonomy_outcome'] = 'Resultat';
$string['taxonomy_practice'] = 'Praksis';
$string['taxonomy_proficiency'] = 'Kunnskaper';
$string['taxonomy_skill'] = 'Ferdighet';
$string['taxonomy_value'] = 'Verdi';
$string['usercommentedonacompetency'] = '{$a->fullname} kommenterte læringsmålet "{$a->competency}":

{$a->comment}

Se: {$a->url}';
$string['usercommentedonacompetencyhtml'] = '<p>{$a->fullname} kommenterte læringsmålet"{$a->competency}":</p>
<div>{$a->comment}</div>
<p>Se: <a href="{$a->url}">{$a->urlname}</a>.</p>';
$string['usercommentedonacompetencysmall'] = '{$a->fullname} kommenterte læringsmålet "{$a->competency}".';
$string['usercommentedonacompetencysubject'] = '{$a} kommenterte et læringsmål.';
$string['usercommentedonaplan'] = '{$a->fullname} kommenterte opplæringsplanen "{$a->plan}":

{$a->comment}

Se: {$a->url}';
$string['usercommentedonaplanhtml'] = '<p>{$a->fullname} kommenterte opplæringsplanen "{$a->plan}":</p>
<div>{$a->comment}</div>
<p>Se: <a href="{$a->url}">{$a->urlname}</a>.</p>';
$string['usercommentedonaplansmall'] = '{$a->fullname} kommenterte opplæringsplanen "{$a->plan}".';
$string['usercommentedonaplansubject'] = '{$a} kommenterte en opplæringsplan.';
$string['usercompetencystatus_idle'] = 'Uvirksom';
$string['usercompetencystatus_inreview'] = 'Under vurdering';
$string['usercompetencystatus_waitingforreview'] = 'Venter på vurdering';
$string['userplans'] = 'Opplæringsplaner';
