<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'reader', language 'fr', version '3.5'.
 *
 * @package     reader
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Action';
$string['actionblockquizzestext'] = 'Il vous sera interdit de répondre à d\'autres tests jusqu\'à ce que votre enseignant supprime le blocage';
$string['actiondelayquizzestext'] = 'Vous n\'aurez plus à répondre à des tests jusqu\'à ce que le temps d\'attente soit écoulé.';
$string['actionemailstudenttext'] = 'Un courriel vous sera envoyé.';
$string['actionemailteachertext'] = 'Un courriel sera envoyé au(x) professeur(s) de ce cours.';
$string['activemessages'] = 'Messages actifs';
$string['activityoverview'] = 'Cliquez ici pour afficher des informations sur votre activité de lecture intensive';
$string['add'] = 'Ajouter';
$string['add_phpdoc'] = 'Ajouter des commentaires PHP doc';
$string['add_phpdoc_desc'] = 'Ajouter des commentaires PHP doc aux fichiers php, js et css.';
$string['addbookinstance'] = 'Ajouter plus de livres à ce cours';
$string['addmoregoals'] = 'Ajouter {no} buts de plus';
$string['addmorerates'] = 'Ajouter {no} taux de plus';
$string['addonemorerate'] = 'Ajouter {no} taux de plus';
$string['addquiztoreader'] = 'Ajouter des tests de cours aux tests de reader';
$string['adjoiningcomputers'] = 'Sur des ordinateurs adjacents';
$string['adjustscores'] = 'Ajuster les scores';
$string['adminarea'] = 'Zone d\'administration';
$string['all'] = 'Tout';
$string['allbooks'] = 'Télécharger/réparer les couvertures pour TOUS les livres disponibles dans le module Reader';
$string['allcourses'] = 'Tous les cours';
$string['alldone'] = 'Terminé';
$string['allgroups'] = 'Tous les groupes';
$string['alllevels'] = 'Tous les niveaux';
$string['allowpromotion'] = 'Autoriser la promotion';
$string['allparticipants'] = 'Tous les participants';
$string['allterms'] = 'tous les termes';
$string['anytime'] = 'À tout moment';
$string['anywhere'] = 'Nulle part';
$string['arrange'] = 'Organiser';
$string['assignpointsbookshavenoquizzes'] = 'Attribuer des points aux livres qui n\'ont pas de tests';
$string['atlevel'] = 'au niveau';
$string['attemptedbooks'] = 'Télécharger/corriger uniquement les couvertures des livres qui ont été TENTÉS sur ce site';
$string['attempts'] = 'Tentatives';
$string['attemptsallowedn'] = 'Tentatives autorisées: {$a}';
$string['attemptscoremanagement'] = 'Gestion des tentatives et des scores';
$string['attemptsupdated'] = '{$a} tentatives ont été mises à jour';
$string['atttemptsgroupedbybook'] = 'Tentatives groupées par livre';
$string['atttemptsgroupedbyuser'] = 'Tentatives groupées par utilisateur';
$string['available'] = 'Disponible';
$string['availablefrom'] = 'Disponible depuis';
$string['availablefrom_help'] = 'Les étudiants ne peuvent accéder à cette activité qu\'après la date et l\'heure spécifiées ici. Avant cette date et heure, il ne sera pas disponible.';
$string['availableitems'] = 'Articles disponibles';
$string['availablenolonger'] = 'Désolé, cette activité n\'est plus disponible. Elle a fermée {$a}.';
$string['availablenotyet'] = 'Désolé, cette activité n\'est pas encore disponible. Elle ouvrira {$ a}.';
$string['availableuntil'] = 'Disponible jusqu\'au';
$string['availableuntil_help'] = 'Les étudiants ne peuvent accéder à cette activité que jusqu\'à la date et l\'heure spécifiées ici. Après cette date et heure, il ne sera plus disponible.';
$string['averageduration'] = 'Durée moyenne';
$string['averageduration_help'] = 'La durée moyenne des tentatives des tests de Reader';
$string['averagefailed'] = 'Moyenne des échecs';
$string['averagefailed_help'] = 'Le nombre moyen des tests de Reader échoué par étudiant';
$string['averagegrade'] = 'Note moyenne';
$string['averagegrade_help'] = 'La note moyenne obtenue sur les tests de Reader';
$string['averagepassed'] = 'Moyenne passée';
$string['averagepassed_help'] = 'Le nombre moyen des tests de Reader réussis par élève';
$string['averagepoints'] = 'Moyenne de points';
$string['averagepointsallterms'] = 'Moyenne des points (tous les termes)';
$string['averagepointsallterms_help'] = 'Nombre moyen de points gagnés par chaque étudiant de ce groupe, en tenant compte de tous les points jamais gagnés par aucun d\'entre eux dans aucune activité de lecture sur ce site Moodle';
$string['averagepointsthisterm'] = 'Moyenne de points (ce terme)';
$string['averagepointsthisterm_help'] = 'Nombre moyen de points obtenus par chaque étudiant de ce groupe, en considérant uniquement les points obtenus dans cette activité de lecture pendant le trimestre en cours';
$string['averagerating'] = 'Note moyenne';
$string['averagetaken_help'] = 'Le nombre moyen de tests de Reader fait par étudiant';
$string['averagewords'] = 'Moyenne des Mots';
$string['averagewordsallterms_help'] = 'Nombre moyen de mots gagnés par chaque élève de ce groupe, en tenant compte de tous les mots jamais gagnés par aucun d\'entre eux dans aucune activité de lecture sur ce site Moodle';
$string['averagewordsthisterm_help'] = 'Nombre moyen de mots gagnés par chaque élève de ce groupe, en considérant uniquement les mots gagnés dans cette activité de lecture pendant le trimestre en cours';
$string['awardbookpoints'] = 'Attribuer des crédits aux élèves sélectionnés';
$string['awardextrapoints'] = 'Attribuer des points supplémentaires aux étudiants sélectionnés';
$string['awardpointsmanually'] = 'Il n\'y a pas de test pour ce livre. Au lieu de cela, veuillez demander à votre enseignant d\'attribuer les mots/points manuellement.';
$string['best'] = 'Meilleur';
$string['blockquizattempts'] = 'Bloquer d\'autres tentatives de test';
$string['book'] = 'Livre';
$string['bookadded'] = 'Livre ajouté: {$a}';
$string['bookcovers'] = 'Afficher les couvertures';
$string['bookcovers_help'] = '**Oui**
: Afficher les couvertures de livre sur la page principale de cette activité Reader.

**Non**
: Ne pas afficher les couvertures de livre sur la page principale de cette activité de Reader';
$string['bookdifficulty'] = 'Difficulté du livre';
$string['bookeditdetails'] = 'Modifier les détails du livre';
$string['bookhasnoquiz'] = 'Ce livre n\'a pas de test.';
$string['bookinstances'] = 'Utiliser un sous-ensemble de tests';
$string['bookinstancesdisabled'] = 'Cette activité Reader n\'utilise pas un sous-ensemble de tests; elle ne nécessite donc pas d\'entrées dans la table book_instances.';
$string['booklevelmanagement'] = 'Gestion des livres et des niveaux';
$string['booknotadded'] = 'Livre NON ajouté: {$a}';
$string['booknotfound'] = 'Livre non trouvé {$a}';
$string['booknotupdated'] = 'Livre NON mis à jour: {$a}';
$string['bookquiznumber'] = 'Numéro de quiz du livre';
$string['bookrating'] = 'Note du livre';
$string['bookrating0'] = 'Je n\'aimais pas du tout';
$string['bookrating1'] = 'C\'était pas terrible';
$string['bookrating2'] = 'C\'était pas mal';
$string['bookrating3'] = 'C\'était super';
$string['bookratingslevel'] = 'Afficher les notes du livre de l\'élève pour chaque niveau de livre';
$string['books'] = 'Livres';
$string['booksaddbook'] = 'Ajouter un nouveau livre';
$string['booksallwith'] = 'n\'importe quel livre qui a été lu au moins une fois';
$string['booksavailable'] = '{$a} livre(s) disponible(s)';
$string['booksavailableall'] = 'tous les livres disponibles';
$string['booksavailablewith'] = 'livres disponibles qui ont été lus au moins une fois';
$string['booksavailablewithout'] = 'livres disponibles qui n\'ont pas encore été lus';
$string['bookseditcourse'] = 'Éditer des livres (cours)';
$string['bookseditcourse_help'] = 'Sur cette page, vous pouvez spécifier quels livres de Reader doivent être disponibles dans ce cours. De plus, vous spécifiez le niveau et le nombre de mots pour ces livres. Si le niveau ou le nombre de mots n\'est pas spécifié ici, la valeur par défaut de ce livre sur ce site Moodle sera utilisée.';
$string['bookseditsite'] = 'Modifier livres (Site)';
$string['bookseditsite_help'] = 'Sur cette page, vous pouvez définir l’ajout, la modification et la suppression d’informations sur les livres de Reader sur ce site. Notez que les valeurs définies ici pour tout livre seront remplacées si les données de ce livre sont à nouveau téléchargées depuis le site Web principal de Moodle Reader. Aussi, les valeurs peuvent être remplacées localement sur des cours individuels.';
$string['booksreadinpreviousterms'] = 'Livres lus dans les termes précédents';
$string['booksreadsincedate'] = 'Livres lus depuis {$a}';
$string['booksreadsincepromotion'] = 'Livres lus depuis votre promotion le {$a}';
$string['booksreadthisterm'] = 'Livres lire ce terme';
$string['booksviaapi'] = 'Données du livre (via API)';
$string['bookswithoutquizzes'] = 'Livres sans tests';
$string['bookswithquizzes'] = 'Livres avec tests';
$string['booktitle'] = 'Titre de livre';
$string['booktype'] = 'Livres à inclure';
$string['bookupdated'] = 'Livre mis à jour: {$a}';
$string['cannotaccesscourse'] = 'Désolé, vous n\'êtes pas autorisé à gérer des activités dans le cours « {$a} ».';
$string['cannotcreatecourse'] = 'Désolé, le téléchargement ne peut pas continuer car vous n\'êtes pas autorisé à créer un nouveau cours ou à modifier le cours actuel.';
$string['cannotdownloadata'] = 'Désolé, un problème est survenu lors du téléchargement des données pour le module Reader.';
$string['changeallstoplevelto'] = 'Changer tous les niveaux maximum en';
$string['changeallto'] = 'Changer tout en';
$string['changecurrentlevel'] = 'Changer tous les niveaux actuels en';
$string['changedifficultyfrom'] = 'Changer les niveaux de lecture de';
$string['changelevelfrom'] = 'Changer le nom de niveau de';
$string['changenumberofsectionsinquiz'] = 'Réinitialiser le nombre de sections dans la banque de question du cours';
$string['changepointsfrom'] = 'Changer les points de';
$string['changepublisherfrom'] = 'Changer le nom de l\'éditeur de';
$string['changequiz'] = 'Changer le test';
$string['changereaderlevel'] = 'Changer le niveau de lecture, la longueur ou le nombre de mots';
$string['changestartlevel'] = 'Changer tout niveau de début à';
$string['cheated'] = 'Triché';
$string['cheatedmessage'] = 'Message en cas de tricherie';
$string['cheatedmessage_help'] = 'Ce message sera envoyé aux étudiants jugés par le module Reader comme ayant triché.';
$string['cheatedmessagedefault'] = 'Nous sommes désolés de dire que le programme MoodleReader a découvert que vous avez probablement triché en répondant au test ci-dessus. « Tricher » signifie que vous avez aidé une autre personne à répondre au test ou que vous avez reçu l\'aide d\'une autre personne pour répondre au test. Les deux personnes ont été marquées « triché ».

Parfois, l\'ordinateur fait des erreurs. Si honnêtement, vous n\'avez pas reçu d\'aide et n\'avez aidé personne, veuillez en informer votre enseignant et vos points seront rétablis.

--Le gestionnaire du module MoodleReader';
$string['cheatedshort'] = 'C';
$string['cheatsheet'] = 'Aide-mémoire';
$string['check_email'] = 'Vérifier le courriel';
$string['check_email_desc'] = 'Envoyez deux courriels de test à l\'utilisateur invité, l\'un via Moodle et l\'autre via PHP.';
$string['checkbox'] = 'Afficher les cases à cocher';
$string['checkbox_help'] = '**Oui**
: Afficher les cases à cocher sur les pages de rapport de l\'enseignant dans la zone Admin.

**Non**
: N\'affichez PAS les cases à cocher sur les pages de rapports de l\'enseignant dans la zone Admin.

Ce paramètre sera supprimé à l\'avenir, une fois la zone d\'administration supprimée.';
$string['checkcheating'] = 'Vérifiez pour tricherie';
$string['checkcheating_help'] = 'Ce paramètre spécifie si l\'adresse IP doit être vérifiée ou non lorsque les étudiants tentent des tests Reader.

**Éteint**
: Les adresses IP ne seront pas vérifiées

**Nulle part**
: Si deux étudiants lancent le même test à la même heure et que tous les deux réussissent, ils seront jugés par le module Reader comme ayant triché.

** Sur les ordinateurs adjacents **
Si deux étudiants lancent le même test à une heure similaire à partir d\'une adresse IP similaire et que les deux réussissent, ils seront jugés par le module Reader comme ayant triché.';
$string['checkonlythiscourse'] = 'Vérifiez seulement ce cours';
$string['checksuspiciousactivity'] = 'Vérifier dans les logs s\'il y a des activités suspectes';
$string['chooseaction'] = 'Choisissez une action et cliquez sur « Partez »';
$string['choosedifficulty'] = 'Veuillez choisir le niveau de lecture';
$string['chooselevel'] = 'Veuillez choisir le niveau';
$string['choosepublisher'] = 'Veuillez choisir l\'éditeur';
$string['clearedmessage'] = 'Message effacé';
$string['clearedmessage_help'] = 'Ce message est envoyé aux étudiants qui ont été jugés par le module Lecteur comme ayant triché mais qui ont ensuite été effacés par l\'enseignant.';
$string['clearedmessagedefault'] = 'Nous sommes heureux de vous informer que vos points pour le test ci-dessus ont été restaurés. Nous nous excusons pour cette erreur!

--Le gestionnaire de modules MoodleReader';
$string['clicktocontinue'] = 'Clique ici pour continuer';
$string['complete'] = 'Achevé';
$string['completequizattempt'] = 'Avant de pouvoir répondre à de nouveaux test, vous devez terminer ce test pour « {$a} ». Cliquez sur le lien ci-dessous pour reprendre votre précédente tentative.';
$string['completionpass'] = 'Exige la note de passage';
$string['completiontotalwords'] = 'Exige la lecture totale';
$string['completiontotalwords_help'] = 'Le nombre total de lectures qu\'un élève doit réaliser dans le cadre de cette activité pour pouvoir la marquer comme étant terminée.';
$string['configintro'] = 'Les valeurs que vous définissez ici définissent les valeurs par défaut utilisées dans le formulaire de configuration lorsque vous créez une nouvelle activité Reader.

Vous pouvez également configurer quels paramètres de Reader sont considérés comme avancés.';
$string['configmreaderenable'] = 'Activer ou désactiver les paramètres pour mReader.org';
$string['configmreadersettings'] = 'Ces paramètres permettent aux étudiants de ce site Moodle d\'accéder aux tests sur mReader.org
Pour obtenir un identifiant de site et une clé, vous devez être inscrit au cours suivant:
: https://www.moodlereader.com/moodle4reader/course/view.php?id=2';
$string['configmreadersiteid'] = 'L\'identifiant numérique sous lequel ce site Moodle est enregistré sur mReader.org';
$string['configmreadersitekey'] = 'La clé secrète permettant aux étudiants de ce site Moodle d\'accéder aux tests sur mReader.org';
$string['configmreaderurl'] = 'L\'URL sur laquelle les étudiants peuvent accéder aux tests sur mReader.org';
$string['configserverpassword'] = 'Le mot de passe requis pour télécharger les tests Moodle Reader sur ce site Moodle.';
$string['configserversettings'] = 'Ces paramètres permettent à un enseignant ou à un administrateur de télécharger des tests Moodle Reader sur ce site Moodle.
Le nom d\'utilisateur et le mot de passe sont ceux que vous utilisez pour vous connecter à MoodleReader.org.
Le nom d\'utilisateur doit avoir été autorisé pour le téléchargement par le personnel de MoodleReader.org.';
$string['configserverurl'] = 'Le lien d\'où vous pouvez télécharger les tests de Moodle Reader sur ce site Moodle.';
$string['configserverusername'] = 'Le nom d\'utilisateur requis pour télécharger les tests Moodle Reader sur ce site Moodle.';
$string['confirmstartattemptlimit'] = 'Voulez-vous vraiment supprimer ces tentatives ?';
$string['confirmstartattempttimelimit'] = 'Ce test a une limite de temps et est limité à {$a} tentatives. Vous êtes sur le point de commencer une nouvelle tentative. Voulez-vous continuer ?';
$string['confirmstarttimelimit'] = 'Le test a une limite de temps. Voulez-vous vraiment commencer ?';
$string['countactive'] = 'Étudiants actifs';
$string['countactive_help'] = 'Le nombre d\'étudiants ayant répondu à au moins un test de Reader';
$string['countfailed'] = 'Échec des tests';
$string['countinactive'] = 'Étudiants inactifs';
$string['countinactive_help'] = 'Nombre d\'étudiants qui n\'ont pas répondu à des test de Reader';
$string['countpassed'] = 'Tests passés';
$string['countrating'] = 'Nombre d\'évaluations';
$string['courseid'] = 'Course ID';
$string['coursespecificquizselection'] = 'Sélection du test spécifique au cours à « Oui » dans l\'écran de configuration du module.';
$string['createcoversets_l'] = 'Créer des ensembles de couvertures par niveau & par éditeur';
$string['createcoversets_t'] = 'Créer des ensembles de couvertures par éditeur & niveau';
$string['credit'] = 'Crédit supplémentaire';
$string['creditshort'] = 'X';
$string['curlerror'] = 'Erreur CURL : {$a}';
$string['current'] = 'Actuel';
$string['currentcourse'] = 'Cours actuel';
$string['currentlevel'] = 'Niveau actuel';
$string['dataallavailable'] = 'les données pour tous les livres {$a} sont disponibles';
$string['dataalldownloaded'] = 'les données pour tous les livres {$a} ont été téléchargées';
$string['datasomeavailable'] = 'les données pour {$a->new} sur {$a->all} livre(s) sont disponibles';
$string['defaultcategoryname'] = 'Tests Reader';
$string['defaultcoursename'] = 'Tests Reader';
$string['defaultgoal'] = 'Objectif par défaut';
$string['defaultgoals'] = 'Objectifs par défaut';
$string['defaultquestioncategoryinfo'] = 'questions {$a->category} pour {$a->quiz}';
$string['defaultrates'] = 'Taux par défaut';
$string['definelogindetails'] = 'Veuillez définir les détails de votre identifiant : {$a}';
$string['delayineffect'] = 'Le retard du test est actuellement en vigueur';
$string['delayquizattempts'] = 'Retarder d\'autres tentatives du test';
$string['delete'] = 'Effacer';
$string['deleteallattempts'] = 'Supprimer toutes les tentatives de tests Reader';
$string['deleteallattempts_help'] = 'En règle générale, vous ne devez PAS supprimer les tentatives de tests Reader.

Vous ne devez supprimer les tentatives que si vous êtes absolument certain que les étudiants de ce cours ne répondront plus jamais aux tests Reader sur ce site Moodle.

En effet, en supprimant les tentatives de tests Reader, vous autorisez les étudiants à reprendre tous les tests Reader qu\'ils ont déjà effectués. Ce n’est PAS ainsi que le module Reader est censé fonctionner. Les étudiants ne devraient avoir qu\'une seule chance de répondre à un test Reader.

La suppression de tentatives de tests Reader remettra également à zéro les scores de lecture de tous les étudiants, ce qui n\'est probablement pas ce que vous, ou les étudiants, souhaitez.';
$string['deleteattempts'] = 'Supprimer les tentatives sélectionnées';
$string['deletecategories'] = 'Supprimer les catégories';
$string['deletecourses'] = 'Supprimer les cours';
$string['deleted'] = 'Supprimé';
$string['deletedshort'] = 'D';
$string['deletegoals'] = 'Supprimer les objectifs pour les groupes et les niveaux';
$string['deletegoals_help'] = 'Les objectifs de lecture par défaut pour des groupes ou des niveaux de lecture particuliers seront supprimés.';
$string['deletemessages'] = 'Supprimer les messages de Reader';
$string['deletemessages_help'] = 'Tous les messages qui apparaissent sur la page principale des étudiants pour les activités de Reader dans ce cours seront supprimés.';
$string['deleterates'] = 'Supprimer les taux pour les groupes et les niveaux';
$string['deleterates_help'] = 'Les taux entre les tests de Reader pour des groupes particuliers ou des niveaux de lecture seront supprimés.';
$string['detect_cheating'] = 'Détecter la triche';
$string['detect_cheating_desc'] = 'Analysez les journaux de tentatives et signalez les activités suspectes pouvant indiquer une triche.';
$string['difficulty'] = 'Difficulté';
$string['disallowpromotion'] = 'Ne PAS permettre la promotion';
$string['displayoptions'] = 'Option d\'affichage';
$string['downloadbooksviaapi'] = 'Télécharger les données du livre (via l\'API)';
$string['downloadbookswithoutquizzes'] = 'Télécharger les données du livre (pas des tests)';
$string['downloadbookswithquizzes'] = 'Télécharger les données du livre et les tests';
$string['downloadedbooks'] = 'Les données des livres suivants ont été téléchargées :';
$string['downloadexcel'] = 'Télécharger Excel';
$string['downloadextrapoints'] = 'Veuillez télécharger les tests « Points bonus »';
$string['downloadmode'] = 'Mode';
$string['downloadmode_help'] = 'Cette page peut être dans les deux modes suivants:

**Ordinaire**
: En mode normal, seuls les livres dont les données n\'ont pas encore été téléchargées, ou ceux dont les données ont été mises à jour, seront disponibles. Les livres pour lesquels les données les plus récentes ont déjà été téléchargées ne seront pas disponibles.

**Réparation**
: En mode réparation, tous les livres sont disponibles au téléchargement. Si des données ont déjà été téléchargées, elles seront écrasées par les données récemment téléchargées. Utilisez ce mode si vous souhaitez réparer des tests défectueux ou des données incorrectes. Notez que même si les tests sont écrasés, les données relatives aux tentatives des étudiants pour ces tests seront conservées.';
$string['downloads'] = 'Téléchargements';
$string['downloadsettings'] = 'Paramètres de téléchargement';
$string['duration'] = 'Durée';
$string['edit'] = 'Éditer';
$string['editquiztoreader'] = 'Supprimer les tests';
$string['err_regex_float'] = 'Ce paramètre doit être un nombre décimal compris entre 0.0 et 10.0.';
$string['err_regex_integer'] = 'Ce paramètre doit être un entier compris entre 0 et 100000';
$string['error'] = 'Erreur : {$a}';
$string['errorsfound'] = 'Erreurs trouvées';
$string['event_attempt_added'] = 'Test Reader tentative ajoutée';
$string['event_attempt_added_description'] = 'L\'utilisateur portant l\'id « {$a->userid} » a lancé une tentative de test pour l\'activité « reader » avec l\'id de module de cours « {$a->cmid} »';
$string['event_attempt_added_explanation'] = 'Un utilisateur vient de commencer une tentative de test Reader';
$string['event_attempt_deleted'] = 'Tentative de test Reader supprimée';
$string['event_attempt_deleted_description'] = 'L\'utilisateur avec l\'id « {$a->userid} » a supprimé une tentative de test pour l\'activité « Reader » avec l\'id de module de cours « {$a->cmid} »';
$string['event_attempt_deleted_explanation'] = 'Un utilisateur vient de supprimer une tentative de test Reader';
$string['event_attempt_edited'] = 'Tentative de test Reader modifiée';
$string['event_attempt_edited_description'] = 'L\'utilisateur portant l\'id « {$a->userid} » a édité une tentative de test pour l\'activité « reader » avec l\'id de module de cours « {$a->cmid} »';
$string['event_attempt_edited_explanation'] = 'Un utilisateur vient d\'éditer une tentative de test Reader';
$string['event_attempt_submitted'] = 'Tentative de test Reader soumise';
$string['event_attempt_submitted_description'] = 'L\'utilisateur portant l\'id « {$a->userid} » a soumis une tentative de test pour l\'activité « reader » avec l\'id de module de cours « {$a->cmid} »';
$string['event_attempt_submitted_explanation'] = 'Un utilisateur vient de soumettre une tentative de test Reader';
$string['event_base'] = 'Événement de Reader détecté';
$string['event_base_description'] = 'L\'utilisateur avec l\'id « {$a->userid} » a initié un événement dans l\'activité « reader » avec l\'id de module de cours « {$a->cmid} »';
$string['event_base_explanation'] = 'Un événement a été détecté par le module Reader';
$string['event_book_added'] = 'Livre de Reader ajouté';
$string['event_book_added_description'] = 'L\'utilisateur avec l\'id « {$a->userid} » a ajouté un livre pour l\'activité « reader » avec l\'id de module de cours « {$a->cmid} »';
$string['event_book_added_explanation'] = 'Un utilisateur vient d\'ajouter des données sur un livre Reader.';
$string['event_book_deleted'] = 'Livre de Reader supprimé';
$string['event_book_deleted_description'] = 'L\'utilisateur avec l\'id « {$a->userid} » a supprimé un livre pour l\'activité « reader » avec l\'id de module de cours « {$a->cmid} »';
$string['event_book_deleted_explanation'] = 'Un utilisateur vient de supprimer des données sur un livre Reader';
$string['event_book_edited'] = 'Livre de Reader édité';
$string['event_book_edited_description'] = 'L\'utilisateur avec l\'id « {$a->userid} » a édité un livre pour l\'activité « reader » avec l\'id de module de cours « {$a->cmid} »';
$string['event_book_edited_explanation'] = 'Un utilisateur vient de modifier des données sur un livre Reader.';
$string['event_books_downloaded'] = 'Les livres de Reader téléchargés';
$string['event_books_downloaded_description'] = 'L\'utilisateur avec l\'id « {$a->userid} » a téléchargé des livres pour l\'activité « reader » avec l\'id de module de cours « {$a->cmid} »';
$string['event_books_downloaded_explanation'] = 'Un utilisateur vient de télécharger des données sur les livres Reader';
$string['event_cron_run'] = 'Reader cron lancé';
$string['event_cron_run_description'] = 'La tâche cron de Reader a été exécutée';
$string['event_cron_run_explanation'] = 'Le Reader cron vient d\'être lancé';
$string['event_downloads_viewed'] = 'Reader téléchargements vus';
$string['event_downloads_viewed_description'] = 'L\'utilisateur avec l\'id « {$a->userid} » a visualisé les données sur les téléchargements pour l\'activité « reader » avec l\'id de module de cours « {$a->cmid} »';
$string['event_downloads_viewed_explanation'] = 'Un utilisateur vient de voir des données sur les téléchargements de Reader';
$string['event_message_added'] = 'Message de Reader ajouté';
$string['event_message_added_description'] = 'L\'utilisateur avec l\'id « {$a->userid} » a ajouté un message pour l\'activité « reader » avec l\'id de module de cours « {$a->cmid} »';
$string['event_message_added_explanation'] = 'Un utilisateur vient d\'ajouter un message à une activité Reader';
$string['event_message_deleted'] = 'Message de Reader supprimé';
$string['event_message_deleted_description'] = 'L\'utilisateur avec l\'id « {$a->userid} » a supprimé un message pour l\'activité « reader » avec l\'id de module de cours « {$a->cmid} »';
$string['event_message_deleted_explanation'] = 'Un utilisateur vient de supprimer un message d\'une activité Reader';
$string['event_message_edited'] = 'Message de Reader modifié';
$string['event_message_edited_description'] = 'L\'utilisateur portant l\'id « {$a->userid} » a modifié un message pour l\'activité « reader » avec l\'id de module de cours « {$a->cmid} »';
$string['event_message_edited_explanation'] = 'Un utilisateur vient de modifier un message pour une activité Reader';
$string['event_quiz_added'] = 'Test Reader ajouté';
$string['event_quiz_added_description'] = 'L\'utilisateur avec l\'id « {$a->userid} » a ajouté un test pour l\'activité « reader » avec l\'id de module de cours « {$a->cmid} »';
$string['event_quiz_added_explanation'] = 'Un utilisateur vient d\'ajouter un test à l\'activité de Reader';
$string['event_quiz_delay_set'] = 'Test Reader délai défini';
$string['event_quiz_delay_set_description'] = 'L\'utilisateur portant l\'id « {$a->userid} » a défini un délai de test pour l\'activité « reader » avec l\'id de module de cours « {$a->cmid} »';
$string['event_quiz_delay_set_explanation'] = 'Un utilisateur vient de définir un délai sur un test Reader';
$string['event_quiz_deleted'] = 'Test Reader supprimé';
$string['event_quiz_deleted_description'] = 'L\'utilisateur avec l\'id « {$a->userid} » a supprimé un test pour l\'activité « reader » avec l\'id de module de cours « {$a->cmid} »';
$string['event_quiz_deleted_explanation'] = 'Un utilisateur vient de supprimer un test Reader';
$string['event_quiz_edited'] = 'Test reader édité';
$string['event_quiz_edited_description'] = 'L\'utilisateur avec l\'id « {$a->userid} » a édité un test pour l\'activité « reader » avec l\'id de module de cours « {$a->cmid} »';
$string['event_quiz_edited_explanation'] = 'Un utilisateur vient de modifier un test Reader';
$string['event_quiz_finished'] = 'Test Reader terminé';
$string['event_quiz_finished_description'] = 'L\'utilisateur portant l\'id « {$a->userid} » a répondu à un test pour l\'activité « reader » avec l\'id de module de cours « {$a->cmid} »';
$string['event_quiz_finished_explanation'] = 'Un utilisateur vient de terminer un test Reader';
$string['event_quiz_selected'] = 'Test Reader sélectionné';
$string['event_quiz_selected_description'] = 'L\'utilisateur portant l\'id « {$a->userid} » a répondu à un test pour l\'activité « reader » avec l\'id de module de cours « {$a->cmid} »';
$string['event_quiz_selected_explanation'] = 'Un utilisateur vient de sélectionner un test Reader';
$string['event_quiz_started'] = 'Test Reader commencé';
$string['event_quiz_started_description'] = 'L\'utilisateur portant l\'id « {$a->userid} » a lancé un test pour l\'activité « reader » avec l\'id de module de cours « {$a->cmid} »';
$string['event_quiz_started_explanation'] = 'Un utilisateur vient de commencer un test Reader';
$string['event_report_bookdetailed_viewed'] = 'Rapport de Reader consulté : Livres (détaillé)';
$string['event_report_bookdetailed_viewed_description'] = 'L\'utilisateur portant l\'id « {$a->userid} » a affiché le rapport « Livres (détaillé) » pour l\'activité « reader » avec l\'id de module de cours « {$a->cmid} »';
$string['event_report_bookdetailed_viewed_explanation'] = 'Un utilisateur vient de consulter un rapport Reader : Livres (détaillé)';
$string['event_report_booksummary_viewed'] = 'Rapport de Reader consulté : Livres (résumé)';
$string['event_report_booksummary_viewed_description'] = 'L\'utilisateur portant l\'id « {$a->userid} » a affiché le rapport « Livres (résumé) » pour l\'activité « reader » avec l\'id de module de cours « {$a->cmid} »';
$string['event_report_booksummary_viewed_explanation'] = 'Un utilisateur vient de consulter un rapport Reader : Livres (résumé)';
$string['event_report_groups_viewed'] = 'Rapport de reader consulté : Groupes (résumé)';
$string['event_report_groups_viewed_description'] = 'L\'utilisateur portant l\'id « {$a->userid} » a affiché le rapport « Groupes (récapitulatif) » pour l\'activité « lecteur » avec l\'id de module de cours « {$a->cmid} ».';
$string['event_report_groups_viewed_explanation'] = 'Un utilisateur vient de consulter un rapport Reader : Groupes (résumé)';
$string['event_report_userdetailed_viewed'] = 'Rapport de Reader consulté : Utilisateurs (détaillé)';
$string['event_report_userdetailed_viewed_description'] = 'L\'utilisateur portant l\'id « {$a->userid} » a affiché le rapport « Utilisateurs (détaillé) » pour l\'activité « lecteur » avec l\'ID de module de cours « {$a->cmid} ».';
$string['event_report_userdetailed_viewed_explanation'] = 'Un utilisateur vient de consulter un rapport Reader : Utilisateurs (détaillé)';
$string['event_report_usersummary_viewed'] = 'Rapport de lecteur consulté : Utilisateurs (résumé)';
$string['event_report_usersummary_viewed_description'] = 'L\'utilisateur portant l\'id « {$a->userid} » a affiché le rapport « Utilisateurs (détaillé) » pour l\'activité « reader » avec l\'id de module de cours « {$a->cmid} ».';
$string['event_report_usersummary_viewed_explanation'] = 'Un utilisateur vient de consulter un rapport Reader : Utilisateurs (résumé)';
$string['event_tool_run'] = 'Exécution de l\'outil d\'administration Reader';
$string['event_tool_run_description'] = 'L\'utilisateur portant l\'id « {$a->userid} » a exécuté un outil d\'administration pour l\'activité « reader » avec l\'id de module de cours « {$a->cmid} »';
$string['event_tool_run_explanation'] = 'Un utilisateur vient de lancer un outil Reader : {$a}';
$string['event_user_goal_set'] = 'Objectif utilisateur de Reader';
$string['event_user_goal_set_description'] = 'L\'utilisateur portant l\'id « {$a->userid} » a défini un objectif de lecture de l\'étudiant pour l\'activité « reader » avec l\'id de module de cours « {$a->cmid} »';
$string['event_user_goal_set_explanation'] = 'Un utilisateur vient de définir un objectif de lecture sur une activité de Reader';
$string['event_user_level_set'] = 'Niveau utilisateur de Reader défini';
$string['event_user_level_set_description'] = 'L\'utilisateur avec l\'id « {$a->userid} » a défini un niveau de lecture de l\'étudiant pour l\'activité « reader » avec l\'id du module de cours « {$a->cmid} »';
$string['event_user_level_set_explanation'] = 'Un utilisateur vient de définir le niveau de lecture d\'un étudiant dans une activité de Reader.';
$string['event_users_exported'] = 'Utilisateurs de Reader exportés';
$string['event_users_exported_description'] = 'L\'utilisateur avec l\'id « {$a->userid} » a exporté les données de l\'étudiant pour l\'activité « reader » avec l\'id de module de cours « {$a->cmid} »';
$string['event_users_exported_explanation'] = 'Un utilisateur vient d\'exporter les données sur les étudiants d\'une activité Reader.';
$string['event_users_imported'] = 'Utilisateurs de Reader importés';
$string['event_users_imported_description'] = 'L\'utilisateur portant l\'id « {$a->userid} » a importé des données d\'étudiant pour l\'activité « reader » avec l\'id de module de cours « {$a->cmid} »';
$string['event_users_imported_explanation'] = 'Un utilisateur vient d\'importer des données d\'étudiant dans une activité Reader.';
$string['export'] = 'Exportation';
$string['export_reader_tables'] = 'Exporter des tables de reader';
$string['export_reader_tables_desc'] = 'Exporter les tables de la base de données Reader. Notez que les données exportées ne contiennent aucun nom de cours ou d\'utilisateur, mais uniquement des identifiants.';
$string['exportstudentrecords'] = 'Exporter les dossiers des étudiants';
$string['extrapoints'] = 'Points bonus';
$string['extrapoints0'] = '0.5 points';
$string['extrapoints1'] = '1 point';
$string['extrapoints2'] = '2 points';
$string['extrapoints3'] = '3 points';
$string['extrapoints4'] = '4 points';
$string['extrapoints5'] = '5 points';
$string['extrapoints6'] = '6 points';
$string['extrawords'] = '{$a} mots';
$string['failed'] = 'Échoué';
$string['failedshort'] = 'F';
$string['filename'] = 'Nom de fichier';
$string['fileuploaded'] = 'Le fichier a été téléchargé';
$string['find_faultyquizzes'] = 'Trouvez des tests défectueux';
$string['find_faultyquizzes_desc'] = 'Recherchez des tests comportant des questions sans réponse correcte ou des questions devenues orphelines.';
$string['finishreview'] = 'Termine l\'analyse';
$string['fix_bookcovers'] = 'Correction des couvertures de livre';
$string['fix_bookcovers_desc'] = 'Détectez les livres dont l\'image de couverture de livre manque et essayez de télécharger l\'image de couverture de livre.';
$string['fix_bookinstances'] = 'Correction des occurrences de livre';
$string['fix_bookinstances_desc'] = 'Assurez-vous que tous les livres ont un enregistrement associé dans la table reader_book_instances.';
$string['fix_coursesections'] = 'Correction des sections de cours';
$string['fix_coursesections_desc'] = 'Ranger la page principale des cours contenant des tests Reader.

* Ordonner les sections par nom d\'éditeur et niveau de difficulté
* assurez-vous que chaque section ne contient que des livres d\'un seul éditeur
* fusionner plusieurs sections pour le même éditeur
* supprimer les sections vides
* réinitialiser le nombre de sections de cours';
$string['fix_installxml'] = 'Réparer db/install.xml';
$string['fix_installxml_desc'] = 'Rendre les balises XML dans db/install.xml compatibles avec Moodle <= 2.5

* ajouter les attributs NEXT et PREVIOUS aux balises TABLE, FIELD, KEY et INDEX
* ajouter les attributs SEQUENCE aux balises FIELD avec TYPE = "int"';
$string['fix_missingquizzes'] = 'Correction des tests manquants';
$string['fix_missingquizzes_desc'] = 'Unifiez les livres et les tests en double de Reader.

* fusionner les livres en double
* corriger les livres qui partagent le même test
* fusionner les tests en double
* corriger les livres et les tentatives pour lesquelles le test est manquant';
$string['fix_questioncategories'] = 'Correction des catégories de questions';
$string['fix_questioncategories_desc'] = 'Rangez vos questions et catégories de questions.

* désélectionner tous les identifiants parents des questions non valides
* supprimer les questions Reader non utilisées dans les tests Reader
* déplacez les catégories de questions du cours Reader vers le test Reader approprié
* supprimer les barres obliques des noms de catégories et des descriptions
* normaliser les noms des catégories d\'Ordonnancement';
$string['fix_slashesinnames'] = 'Correction des barres obliques dans les noms';
$string['fix_slashesinnames_desc'] = 'Supprimez les barres obliques dans les noms des livres Reader et des catégories de questions.';
$string['fix_wrongattempts'] = 'Corriger les mauvaises tentatives';
$string['fix_wrongattempts_desc'] = 'Détectez et corrigez toutes tentatives de tests Reader où le nom du test ne correspond pas au nom du livre dans le journal de Reader.';
$string['fixattempts'] = 'Correction des tentatives dupliquées de Reader';
$string['fixcontexts'] = 'Correction des contextes défectueux dans les catégories de questions de Test';
$string['fixingsumgrades'] = 'Correction des notes sur les tentatives de tests Reader…';
$string['fixinstances'] = 'Vérification des instances de questions Reader';
$string['fixmissingquizzes'] = 'Correction des tests manquants';
$string['fixmissingquizzesinfo'] = 'La mise à niveau a été suspendue afin que vous puissiez décider si vous souhaitez télécharger et installer les tests du module Reader qui manquent sur ce site Moodle.

Si vous sélectionnez « Oui », les tests manquants seront téléchargés et installés.

Si vous sélectionnez « Non », tous les livres Reader dont le test est manquant seront marqués comme ne contenant aucune donnée.

Notez que même si vous choisissez « Non », le nombre de mots pour chaque étudiant participant aux activités de Reader ne sera pas affecté par cette opération.

Souhaitez-vous télécharger et installer les tests manquants du module Reader pour les livres sur ce site Moodle ?';
$string['fixmultichoice'] = 'Correction des questions à choix multiples de Reader';
$string['fixordering'] = 'Mise à jour des questions ordonnancement pour le module Reader';
$string['fixquestiontext'] = 'Correction des balises HTML dans les questions de Reader';
$string['fixquizslots'] = 'Correction des emplacements de questions défectueux dans les tentatives de Test';
$string['fixslashesinnames'] = 'Supprimer les barres obliques dans les titres de livre';
$string['fixwrongquizid'] = '« {$a->name} » (book id = {$a->id}) a un identifiant de test inattendu';
$string['fixwrongquizidinfo'] = 'La mise à niveau a été suspendue afin que vous puissiez choisir le test à associer à ce livre.

Veuillez consulter les informations ci-dessous et sélectionner le test que vous souhaitez associer à ce livre.';
$string['forcedownload'] = 'Forcer le téléchargement';
$string['forcedtimedelay'] = 'Définir le délai forcé';
$string['forcedtimerate'] = 'Définir le taux de lecture forcée';
$string['fromthistime'] = 'À partir de ce moment';
$string['fullreportbybooktitle'] = 'Rapport complet par titre de livre';
$string['fullreportquiztoreader'] = 'Rapport complet par étudiant';
$string['genre'] = 'Genre';
$string['getstarted'] = '**Commencer**

* Le but de cette activité est de lire beaucoup de livres et d’augmenter votre total de lecture.
* Votre total de lecture est le nombre total de mots dans tous les livres que vous avez lus.

** Choisissez un livre **

* Vous devriez choisir des livres que vous pouvez lire facilement sans utiliser de dictionnaire.
* Choisissez aussi les livres qui vous intéressent, car ils sont plus amusants à lire.

** Faites un test en ligne **

* Après avoir lu un livre, répondez à un test en ligne.
* Utilisez les champs de recherche sur cette page pour trouver le test souhaité. Lorsque vous avez trouvé votre test, cliquez sur le bouton pour le lancer.
* Chaque test a plusieurs questions sur le livre. Les questions sont différentes pour chaque élève.
* Si vous réussissez le quiz, le nombre de mots du livre sera ajouté à votre total de lecture. Si vous échouez, le total de vos lectures ne change pas.
* *** Vous ne pouvez pas repasser les tests ***, alors veuillez les faire attentivement.';
$string['goal'] = 'Objectif';
$string['groupgoals'] = 'Objectifs pour des groupes spécifiques';
$string['grouprates'] = 'Taux pour des groupes spécifiques';
$string['hidden'] = 'Caché';
$string['ifimagealreadyexists'] = 'Si une image existe déjà dans le dossier images (nom)';
$string['ignoredate'] = 'Date de début du terme';
$string['ignoredate_help'] = 'La date du début du terme actuel.

Toute tentative de test Reader effectuée avant cette date ne sera pas incluse dans les totaux du rapport pour ce terme.

Cependant, les tentatives précédentes ne sont pas complètement ignorées. Ils seront inclus dans les totaux du rapport pour « Tous les termes ».

De plus, veuillez noter que les étudiants ne peuvent jamais repasser les tests Reader, y compris ceux qui avaient été rédigés dans des termes précédents, à moins que l\'enseignant supprime la tentative précédente.';
$string['image'] = 'Image';
$string['imageadded'] = 'Image ajoutée : {$a}';
$string['import'] = 'Importation';
$string['import_reader_tables'] = 'Importer des tables Reader';
$string['import_reader_tables_desc'] = 'Recréez un site Moodle entier à partir des tables de la base de données Reader. Cet outil créera des cours, des utilisateurs, des groupes, des activités de Reader et des tests.';
$string['importreadertables'] = 'Importer des tables Reader';
$string['importstudentrecord'] = 'Importer un dossier étudiant';
$string['in1000sofwords'] = 'en milliers de mots';
$string['includepublishers'] = 'Rechercher des noms d\'éditeurs aussi ?';
$string['incorrect'] = '- Incorrect';
$string['incorrect2'] = '- Désolé, veuillez obtenir le mot de passe correct auprès du ou des éditeurs. Cliquez sur « Installer les tests » pour télécharger vos autres sélections.';
$string['incorrectbooksreadinpreviousterms'] = 'Afficher les tests échoués';
$string['induration'] = 'en';
$string['install_quizzes'] = 'Installer des tests';
$string['installedbooks'] = 'Téléchargez/corrigez uniquement les couvertures des livres déjà INSTALLÉS sur ce site';
$string['ipaddress'] = 'adresse IP';
$string['isgreaterthan'] = 'est supérieur à';
$string['islessthan'] = 'est inférieur à';
$string['itemsdownloaded'] = '{$a} éléments téléchargés';
$string['keeplocalbookdifficulty'] = 'Conserver les paramètres de difficulté de livre locaux';
$string['keepoldquizzes'] = 'Conserver les anciens tests';
$string['lastupdatedtime'] = 'Les tests de ce site ont été mis à jour pour la dernière fois le {$a}. Voulez-vous mettre à jour le site maintenant ?';
$string['level'] = 'Niveau';
$string['levelcheck'] = 'Limiter le niveau de lecture';
$string['levelcheck_help'] = '**Oui**
: Les étudiants ne seront autorisés à répondre aux tests Reader que pour des livres égaux ou proches de leur niveau de lecture actuel. Le nombre de test que les étudiants sont autorisés à poser est spécifié dans les paramètres de cette page pour « Tests au niveau actuel/précédent/suivant ».

**Non**
: Les étudiants seront toujours autorisés à répondre aux questions de Reader pour tous les niveaux de lecture.';
$string['levelgoal'] = 'Niveau {$a} objectif';
$string['levelgoals'] = 'Objectifs pour des niveaux spécifiques';
$string['leveli'] = 'Niveau {$a}';
$string['levelrate'] = 'Niveau {$a} taux';
$string['levelrates'] = 'Taux pour des niveaux spécifiques';
$string['levels'] = 'Niveaux';
$string['likebook'] = 'Comment avez-vous aimé ce livre ?';
$string['logoutrequired'] = 'Vous ne pouvez pas continuer car vous êtes actuellement connecté en tant que {$a}.

Pour continuer, veuillez cliquer sur le bouton « Déconnexion » ci-dessous, puis reconnectez-vous sous votre compte.';
$string['mainpagesettings'] = 'Paramètres de la page principale';
$string['makebookavailable'] = 'Rendre les livres disponibles';
$string['makebookavailableproblem'] = 'Oups, Il n\'est PAS possible de mettre le livre à disposition dans ce cours : {$a}';
$string['makebookavailablesuccess'] = 'Le livre est maintenant disponible dans ce cours : {$a}';
$string['makenewquizzesavailable'] = 'Rendre les nouveaux tests disponibles uniquement dans ce cours';
$string['makenewquizzesavailable2'] = 'Rendre les nouveaux tests disponibles dans tous les cours [par défaut]';
$string['massrename'] = 'Changements de masse';
$string['max'] = 'Inférieur ou égal à';
$string['maxgrade'] = 'Note maximale';
$string['maxgrade_help'] = 'La note maximale pour cette activité Reader.

Le nombre de mots lus, en tant que fraction de l\'objectif de lecture, sera ajusté à cette note maximale et transmis au carnet de notes.

En règle générale, la note maximale est de 100, mais si tous les élèves ont le même objectif de lecture, cela peut aider les élèves à comprendre leur note si ce paramètre est identique à l\'objectif de lecture.';
$string['maxquizattemptrate'] = 'Taux maximal de tentatives de test';
$string['maxquizattemptrate_help'] = 'Le taux maximum auquel les étudiants peuvent tenter des tests Reader. Si un élève essaie de tenter plus que le nombre spécifié de test pendant la durée spécifiée, l\'action spécifiée sera exécutée.';
$string['maxquizattemptratetext'] = 'Veuillez ne pas prendre plus de {$a}. Si vous dépassez ce taux, les actions suivantes seront entreprises :';
$string['maxquizfailurerate'] = 'Taux d’échec maximum du test';
$string['maxquizfailurerate_help'] = 'Le taux maximal auquel les étudiants peuvent échouer aux tests Reader. Si un étudiant échoue plus que le nombre spécifié de test dans la durée spécifiée, l\'action spécifiée sera exécutée.';
$string['maxquizfailureratetext'] = 'Si vous échouez plus de {$a}, les actions suivantes seront entreprises :';
$string['maxtimebetweenquizzes'] = 'Durée max entre les tests';
$string['menu'] = 'Menu';
$string['mergingtables'] = 'Fusion des tables : {$a->old} dans {$a->new}';
$string['messagefromyourteacher'] = 'Message de votre enseignant';
$string['migratinglogs'] = 'Migration des journaux de lecture';
$string['min'] = 'Supérieur ou égal à';
$string['minimumdelay'] = 'Délai maximum';
$string['minpassgrade'] = 'Note de passage du test';
$string['minpassgrade_help'] = 'La note de passage minimale, en pourcentage, des tests dans cette activité de Reader.

Les tentatives avec un pourcentage de notes inférieur à cette valeur seront marquées comme ayant échoué.';
$string['minquizattemptrate'] = 'Taux de tentative minimum de test';
$string['minquizattemptrate_help'] = 'Le taux minimum auquel les étudiants peuvent tenter des tests Reader. Si un étudiant ne continue pas à tenter au moins le nombre spécifié de test pendant la durée spécifiée, l\'action spécifiée sera exécutée.';
$string['minquizattemptratetext'] = 'Veuillez prendre au moins {$ a}. Si vous tombez en dessous de ce taux, les actions suivantes seront entreprises:';
$string['modulename'] = 'Reader';
$string['modulename_help'] = 'Le module Reader permet aux enseignants de définir des objectifs de lecture pour les élèves et de démontrer qu\'ils ont atteint les objectifs de lecture spécifiés.';
$string['modulenameplural'] = 'Reader';
$string['morenewattempts'] = '{$a} nouvelles tentatives…';
$string['move_quizzes'] = 'Déplacer des tests';
$string['move_quizzes_desc'] = 'Déplacez les tests Reader du cours actuel vers le cours principal pour les tests Reader.';
$string['movedquizzes'] = '{$a} tests déplacés avec succès';
$string['mreaderenable'] = 'Activer les paramètres mReader';
$string['mreadersettings'] = 'Accéder aux tests mReader';
$string['mreadersiteid'] = 'Identifiant du site pour les tests mReader';
$string['mreadersitekey'] = 'Clé pour les tests mReader';
$string['mreaderurl'] = 'Liens pour les tests mReader';
$string['needdeletethisattemptstoo'] = 'Il faut aussi supprimer cette tentative';
$string['needtocheckupdates'] = 'Ce site n\'a pas vérifié les mises à jour du test depuis ({$a} jours). Vérifier maintenant ?';
$string['newdate'] = 'Nouvelle date';
$string['newreaderattempts'] = 'Nouvelle tentative Reader';
$string['newreadinggoal'] = 'Nouvel objectif';
$string['newreadinglevel'] = 'nouveau niveau';
$string['newsetting'] = 'Nouvelle valeur pour ce paramètre';
$string['newtime'] = 'Nouvelle heure';
$string['nextlevel'] = 'Tests au prochain niveau';
$string['nextlevel_help'] = 'Nombre de tests qu\'un élève peut répondre au prochain niveau de lecture, c\'est-à-dire au niveau de lecture juste au-dessus de son niveau de lecture actuel. Notez que ces tests ne comptent PAS dans la promotion.';
$string['no_password'] = 'Aucun mot de passe requis';
$string['noaction'] = 'Ne pas agir';
$string['nobooksfound'] = 'Aucun livre trouvé';
$string['nobooksinlist'] = 'Aucun livre trouvé pour votre niveau de lecture';
$string['nodownloaditems'] = 'Aucun élément disponible pour le téléchargement';
$string['noemailever'] = 'L\'envoi d\'e-mail est désactivé en raison de la configuration de la variable $CFG->noemailever';
$string['noincorrectquizzes'] = 'Vous n\'avez échoué à aucun test';
$string['nomoreattempts'] = 'Plus aucune tentative n\'est permise';
$string['noquizzesfound'] = 'Aucun test trouvé';
$string['noreaders'] = 'Aucune activité Reader n\'a été trouvée dans ce cours';
$string['norecordsmatch'] = 'Aucun enregistrement n\'a été sélectionné à l\'aide des filtres et des options d\'affichage actuels.';
$string['noreview'] = 'Vous n\'êtes pas autorisé à commenter ce test';
$string['noreviewshort'] = 'Pas permis';
$string['normalmode'] = 'Normal';
$string['noscript'] = 'Le Javascript doit être activé pour continuer !';
$string['nosearchresults'] = 'Aucun livre correspondant à votre recherche n\'est disponible';
$string['notavailable'] = 'Ce test n\'est pas disponible actuellement';
$string['nothavepermissioncreateinstance'] = 'Désolé, vous n\'avez pas la permission de faire cela';
$string['notifycheating'] = 'Notifier les astuces';
$string['notifycheating_help'] = 'Si ces paramètres sont activés, le « message frauduleux » ci-dessous sera envoyé au candidat qui aura triché lors d\'une tentative de test Reader.';
$string['numattempts'] = '{$a} tentatives';
$string['numberofextrapoints'] = 'Nombre de points supplémentaires';
$string['oneattempt'] = '1 tentative';
$string['onlybookswithmorethan'] = 'Seuls les livres avec plus de';
$string['outputformat'] = 'Format de sortie';
$string['pagesettings'] = 'Réglages de la page';
$string['passed'] = 'Passé';
$string['passedshort'] = 'P';
$string['passworderror'] = 'Le mot de passe entré était incorrect';
$string['passwords_list'] = 'Liste des mots de passe';
$string['percentactive'] = 'Pourcentage d\'actif';
$string['percentactive_help'] = 'Pourcentage d’élèves ayant répondu à au moins un test Reader';
$string['percentinactive'] = 'Pourcentage d\'inactif';
$string['percentinactive_help'] = 'Pourcentage d’élèves n\'ayant répondu à aucun test Reader';
$string['pleaseaskyourinstructor'] = 'Si c\'est trop facile pour vous, veuillez demander à votre instructeur d\'augmenter votre niveau.';
$string['pleaseclose'] = 'Votre demande a été traitée. Vous pouvez maintenant fermer cette fenêtre';
$string['pleaseselectpublisher'] = 'Veuillez choisir un éditeur';
$string['pleasespecifyyourclassgroup'] = 'Veuillez spécifier votre groupe de classe ou rechercher un élève spécifique.';
$string['pleasewait'] = 'Veuillez attendre';
$string['pluginadministration'] = 'Administration de Reader';
$string['pluginname'] = 'Reader';
$string['points'] = 'Points';
$string['pointsex11'] = 'Longueur (par ex. 1.1)';
$string['popup'] = 'Utilisez la fenêtre « sécurisée »';
$string['popup_help'] = 'Si « Oui » est sélectionné,

* Le test ne commencera que si l\'étudiant dispose d\'un navigateur Web compatible JavaScript.
* Le test apparaît dans une fenêtre contextuelle plein écran qui couvre toutes les autres fenêtres et ne comporte pas de commandes de navigation.
* Les étudiants ne sont pas autorisés, dans la mesure du possible, à utiliser des fonctions telles que copier et coller.';
$string['prevlevel'] = 'Tests au niveau précédent';
$string['prevlevel_help'] = 'Le nombre de tests qu\'un élève peut effectuer à partir du niveau de lecture précédent, c\'est-à-dire le niveau de lecture qui se situe juste en dessous de leur niveau de lecture actuel. Notez que ces quiz ne comptent pas dans la progression.';
$string['print_cheatsheet'] = 'Imprimer la feuille de triche';
$string['print_cheatsheet_desc'] = 'Affichez les réponses à tous les tests Reader.';
$string['process_addquestion'] = '<b> Ajouter des questions au test {$a}. </b> <br />';
$string['process_courseadded'] = '<b>Cours ajouté.</b><br />';
$string['promotionnotallowed'] = 'Votre enseignant a arrêté votre progression automatique.';
$string['promotionsettings'] = 'Réglages de la progression';
$string['publisher'] = 'Éditeur';
$string['publishers'] = 'Éditeurs';
$string['questionscores'] = 'Afficher les scores de la question';
$string['questionscores_help'] = 'Les scores maximum pour chaque question doivent-ils être montrés aux étudiants lorsqu\'ils tentent un test Reader?

**Oui**
: Affiche les scores maximum pour les questions dans les tests Reader.

**Non**
: Masquer les scores maximum pour les questions dans les tests Reader.';
$string['quizadd'] = 'Ajouter des tests Reader';
$string['quizadded'] = 'Test ajouté  : {$a}';
$string['quizarrange'] = 'Organiser des tests Reader';
$string['quizattemptinprogress'] = 'Test en cours…';
$string['quizclosed'] = 'Ce test a été fermé le {$a}';
$string['quizcloseson'] = 'Ce test fermera à {$a}';
$string['quizdelete'] = 'Supprimer des tests Reader';
$string['quizfordays'] = 'Restriction de fréquence (jours)';
$string['quizhasnoquestions'] = 'Ce test n\'a pas de question';
$string['quizmanagement'] = 'Gérer les tests';
$string['quizname'] = 'Nom du test';
$string['quiznotavailable'] = 'Désolé, ce test n\'est pas disponible actuellement.';
$string['quiznotavailableuntil'] = 'Ce test n\'est pas disponible avant le {$a}';
$string['quizopenedon'] = 'Ce test a ouvert à {$a}';
$string['quizsetrate'] = 'Définir le taux des tests Reader';
$string['quizshowhide'] = 'Afficher / masquer les tests Reader';
$string['quiztimelimit'] = 'Limite de temps : {$a}';
$string['quizupdate'] = 'Mettre à jour les tests Reader';
$string['quizupdated'] = 'Test mis à jour : {$a}';
$string['quizupdateswillbeapplied'] = 'Les mises à jour du test seront appliquées à tous les cours utilisant actuellement le test.';
$string['quizzes'] = 'Tests';
$string['quizzesadd'] = 'Ajouter des tests';
$string['quizzesadded'] = 'Tests ajoutés';
$string['quizzesarrange'] = 'Organiser des tests';
$string['quizzesdelete'] = 'Supprimer des tests';
$string['quizzesmustbeinstalled'] = 'Les tests doivent être installés dans un cours distinct du cours auquel les étudiants se connecteront lorsqu\'ils répondront à des tests. Ce cours est caché des étudiants et n’est utilisé que comme zone de stockage pour les tests; il s’appelle normalement «Tous les tests». Le cours que vous avez établi à cet effet devrait être indiqué ci-dessous. Si vous n\'avez pas encore établi de cours, veuillez cliquer sur « Créer un nouveau cours ».';
$string['quizzespassedtable'] = 'Quiz passés à RL-{$a}';
$string['quizzessetrate'] = 'Définir le taux de lecture';
$string['quizzesshowhide'] = 'Afficher/cacher des tests';
$string['quizzesupdate'] = 'Mettre à jour des tests';
$string['rate'] = 'Taux';
$string['rate_help'] = 'Le taux de lecture est défini comme le nombre maximal de tentatives autorisées pour les tests Reader, ou le nombre minimal de tentatives requis, dans une durée spécifiée.';
$string['rateaction'] = 'Action';
$string['rateaction_help'] = 'C\'est l\'action qui sera entreprise si la restriction du taux de lecture est violée. Les actions suivantes sont disponibles:

** Retarder les autres tentatives de test **
: L\'étudiant ne pourra pas tenter un autre tests Reader jusqu\'à la fin de la période.

** Bloquer d\'autres tentatives de test **
: L\'étudiant ne pourra plus tenter de tests Reader jusqu\'à ce qu\'un enseignant supprime le blocage.

** Envoyer un courriel à l\'étudiant **
: Un courriel sera envoyé à l\'étudiant pour l\'informer de la violation du taux.

** Envoyer un courriel à l\'enseignant **
: Un courriel sera envoyé à l\'enseignant pour l\'informer de la violation de taux de l\'étudiant.';
$string['rategroup'] = 'Groupe';
$string['rategroup_help'] = 'le groupe auquel s\'applique ce taux de restriction';
$string['ratelevel'] = 'Niveau';
$string['ratelevel_help'] = 'le niveau de lecture auquel ce taux de restriction s\'applique';
$string['ratemanyconsecutively'] = '{$a->attempts} tests consécutifs';
$string['ratemanyinduration'] = '{$a->attempts} tests en {$a->duration}';
$string['rateoneinduration'] = '{$a->attempts} test en {$a->duration}';
$string['ratetype'] = 'Type';
$string['ratetype_help'] = 'Les types de taux de lecture suivants peuvent être spécifiés:

** Taux de tentative minimum du test **
: Le taux minimum auquel les étudiants peuvent tenter des tests Reader. Si un étudiant ne continue pas à tenter au moins le nombre spécifié de test pendant la durée spécifiée, l\'action spécifiée sera exécutée.

** Taux maximum de tentatives du test **
: Le taux maximum auquel les étudiants peuvent tenter des tests Reader. Si un étudiant essaie de tenter plus que le nombre spécifié de test pendant la durée spécifiée, l\'action spécifiée sera exécutée.

** Taux d\'échec maximum du test **
: Taux maximal auquel les étudiants peuvent échouer aux tests Reader. Si un étudiant échoue plus que le nombre spécifié de test dans la durée spécifiée, l\'action spécifiée sera exécutée.';
$string['ratings'] = 'taux';
$string['reader:addinstance'] = 'Ajouter une nouvelle activité Reader';
$string['reader:manageattempts'] = 'Gérer les tentatives';
$string['reader:managebooks'] = 'Gérer les livres';
$string['reader:manageremotesites'] = 'Gérer les sites distants';
$string['reader:managetools'] = 'Gérer les outils';
$string['reader:manageusers'] = 'Gérer les utilisateurs';
$string['reader:viewallbooks'] = 'Voir tous les livres';
$string['reader:viewbooks'] = 'Voir les livres';
$string['reader:viewreports'] = 'Voir les rapports';
$string['reader:viewversion'] = 'Voir la version';
$string['readerdownload'] = 'Téléchargez des livres de Reader (et des tests)';
$string['readerid'] = 'Reader ID';
$string['readerquizsettings'] = 'Paramètres des tests de Reader';
$string['readerreports'] = 'Rapports du module Reader';
$string['readinglevel'] = 'Niveau de lecture';
$string['readinglevelshort'] = 'RL {$a}';
$string['readingreportfor'] = 'Rapport de Reader pour {$a}';
$string['readonlyfrom'] = 'En lecture seule à partir de';
$string['readonlyfrom_help'] = 'Après cette date et cette heure, les étudiants peuvent afficher leur page principale de Reader, mais ils ne peuvent plus répondre à des tests via cette activité.';
$string['readonlymode'] = 'Mode lecture seule';
$string['readonlymode_desc'] = 'Cette activité est actuellement en lecture seule. Vous pouvez afficher les informations sur la première page de cette activité Reader, mais vous ne pouvez répondre à aucun test Reader.';
$string['readonlysincedate'] = 'Cette activité a été mise en mode lecture seulement depuis {$a}.';
$string['readonlyuntil'] = 'Lecture seule jusqu\'au';
$string['readonlyuntil_help'] = 'Avant cette date et cette heure, les étudiants peuvent consulter leur page principale Reader, mais ne peuvent répondre à aucun test via cette activité.';
$string['readonlyuntildate'] = 'Cette activité restera en mode lecture seulement jusqu\'au {$a}.';
$string['recommendedreadingrates'] = 'Recommander taux de lecture';
$string['redo_upgrade'] = 'Refaire la mise à niveau';
$string['redo_upgrade_desc'] = 'Refaire une mise à niveau du module Reader.';
$string['remotesitenotaccessible'] = 'Le site de téléchargement distant n\'est pas accessible';
$string['removebook'] = 'Retirer des livres';
$string['removebook_help'] = 'Les livres qui ont des tentatives « réelles » ne peuvent pas être supprimés. Pour supprimer de tels livres, vous devez d\'abord supprimer leurs tentatives « en direct ».';
$string['removebookerror'] = 'Le livre n\'a PAS été supprimé : {$a}';
$string['removebookinstance'] = 'Supprimer les livres sélectionnés de ce cours';
$string['removebooksuccess'] = 'Le livre a été supprimé : {$a}';
$string['repairmode'] = 'Réparation';
$string['reportbookdetailed'] = 'Livres (complet)';
$string['reportbookratings'] = 'Taux du livre';
$string['reportbooksummary'] = 'Livres (résumé)';
$string['reportgroupsummary'] = 'Groupes';
$string['reportquiztoreader'] = 'Rapport de synthèse par étudiant';
$string['reports'] = 'Rapports';
$string['reportsettings'] = 'Paramètres du rapport';
$string['reportuserdetailed'] = 'Étudiants (complet)';
$string['reportusersummary'] = 'Étudiants (résumé)';
$string['requirepasswordmessage'] = 'Pour tenter ce test, vous devez connaître le mot de passe du test.';
$string['requireqtypeordering'] = 'Le module d\'activité Reader ne peut pas être installé ou mis à jour car le type de question ordonnancement est manquant. Veuillez télécharger le type de question ordonnancement, la copier ici {$a}/question/type/ordering, et recharger cette page.';
$string['restoreattempts'] = 'Restaurer les tentatives sélectionnées';
$string['restoredeletedattempt'] = 'Restaurer la tentative supprimée';
$string['restrictlocalhost'] = 'Désolé, vous ne pouvez pas répondre à des tests sur mreader.org à partir de votre URL localhost actuelle. Veuillez basculer vers une <a href="{$a}">URL accessible globalement</a>.';
$string['returntocoursepage'] = 'Retour à la page du cours';
$string['returntoreports'] = 'Retour aux rapports';
$string['returntostudentlist'] = 'Retour à la liste des étudiants';
$string['review'] = 'Réviser';
$string['reviewthisattempt'] = 'Passez en revue vos réponses à cette tentative';
$string['rowsperpage'] = 'Lignes par page';
$string['run_readercron'] = 'Exécuter le cron de Reader';
$string['run_readercron_desc'] = 'Exécutez la tâche pour le module Reader.';
$string['safebrowsererror'] = 'Ce test a été configuré pour que vous ne puissiez le tenter qu\'avec Safe Exam Browser. Vous ne pouvez pas essayer à partir de ce navigateur Web.';
$string['safebrowsernotice'] = 'Ce test a été configuré pour que les étudiants ne puissent le tenter qu\'avec Safe Exam Browser.';
$string['scanningattempts'] = 'Tentatives de numérisation des tests Reader';
$string['search'] = 'Chercher';
$string['search_help'] = 'Pour rechercher un livre en particulier, entrez du texte contenu dans le titre du livre et cliquez sur le bouton « Allez »';
$string['searchforabook'] = 'Rechercher un livre';
$string['sectionname'] = 'Nom de la section';
$string['sectiontoseparate'] = 'ajouter des tests dans des sections distinctes pour l\'éditeur et le niveau, en ajoutant des tests aux sections existantes, le cas échéant';
$string['sectiontothebottom'] = 'ajouter tous les tests au bas du cours caché dans une nouvelle section';
$string['sectiontothissection'] = 'ajouter les tests sélectionnés à cette section';
$string['sectiontypedefault'] = 'La ou les sections par défaut';
$string['sectiontypehidden'] = 'Une section cachée';
$string['sectiontypelast'] = 'La dernière section';
$string['sectiontypenew'] = 'Une nouvelle section';
$string['sectiontypevisible'] = 'Une section visible';
$string['seedetailsbelow'] = 'voir les détails ci-dessous';
$string['select'] = 'Sélectionner';
$string['select_course'] = 'Sélectionnez un cours';
$string['select_help'] = 'Cliquez sur le type d\'éléments que vous souhaitez sélectionner dans la liste ci-dessous.';
$string['selectabook'] = 'Sélectionnez un livre';
$string['selectalreadyexist'] = 'Sélectionnez existe déjà';
$string['selectedbookname'] = 'Nom du livre sélectionné';
$string['selectipmask'] = 'Sélectionnez masque IP';
$string['selectlevel'] = 'Sélectionnez le niveau';
$string['selectpublisher'] = 'Sélectionner un éditeur';
$string['selectseries'] = 'Sélectionnez une série';
$string['selectsomeattempts'] = 'Sélectionnez une ou plusieurs tentatives';
$string['selectsomebooks'] = 'Sélectionnez un ou plusieurs livres';
$string['selectsomerows'] = 'Veuillez cocher certaines des cases de la colonne de sélection.';
$string['selectsomeusers'] = 'Sélectionnez un ou plusieurs utilisateurs';
$string['selectthisquiz'] = 'Sélectionnez ce test';
$string['sendemailtostudent'] = 'Envoyer un courriel à l\'étudiant';
$string['sendemailtoteacher'] = 'Envoyer un courriel à l\'enseignant';
$string['sendmessage'] = 'Envoyer un message aux étudiants sélectionnés';
$string['sentemailmoodle'] = 'Un courriel a été envoyé via Moodle à : {$a->email}';
$string['sentemailphp'] = 'Un courriel a été envoyé par PHP mail à : {$a->email}';
$string['sentmessage'] = 'Le message a été envoyé avec succès à {$a} utilisateur(s)';
$string['separategroups'] = 'Groupes séparés';
$string['separatelevels'] = 'Niveaux séparés';
$string['servererror'] = 'Message du serveur : {$a}';
$string['serverpassword'] = 'Mot de passe pour les tests Reader';
$string['serversettings'] = 'Téléchargez les tests de Moodle Reader';
$string['serverurl'] = 'URL pour les tests Reader';
$string['serverusername'] = 'Nom d\'utilisateur pour les tests Reader';
$string['setallowpromotion'] = 'Modifier le paramètre de promotion pour les étudiants sélectionnés';
$string['setbookinstances'] = 'Sélectionnez des tests à mettre à la disposition des étudiants';
$string['setcurrentlevel'] = 'Changer le niveau actuel pour les étudiants sélectionnés';
$string['setdifficulty'] = 'Définir la difficulté du livre';
$string['setgenre'] = 'Définir le genre';
$string['setgoal'] = 'Fixer un objectif';
$string['setgoals'] = 'Fixer des objectifs';
$string['setgoals_description'] = 'Sur cette page, vous pouvez définir les objectifs de lecture pour les étudiants à des niveaux de lecture spécifiques ou dans des groupes spécifiques. Notez que les paramètres des étudiants individuels sur les pages du rapport remplaceront ceux de cette page.';
$string['setlevel'] = 'Définir le niveau';
$string['setlevels'] = 'Définir les niveaux';
$string['setlevels_description'] = 'Sur cette page, vous pouvez définir les niveaux de lecture pour des groupes d’étudiants. Notez que ces paramètres écraseront ceux des étudiants individuels sur les pages du rapport.';
$string['setmessage'] = 'Définir le message';
$string['setmessagetext'] = 'Texte du message';
$string['setmessagetime'] = 'Afficher jusqu\'au';
$string['setname'] = 'Définir le titre du livre';
$string['setpoints'] = 'Définir la valeur en points';
$string['setpromotiontime'] = 'Changer la date et l\'heure de la promotion';
$string['setpublisher'] = 'Définir l\'éditeur';
$string['setrates'] = 'Définir les taux';
$string['setrates_description'] = 'Sur cette page, vous pouvez définir les taux de lecture des étudiants à des niveaux de lecture spécifiques ou dans des groupes spécifiques.';
$string['setreadinggoal'] = 'Définir un objectif de lecture';
$string['setreadinglevel'] = 'Définir le niveau de lecture';
$string['setstartlevel'] = 'Changer le niveau de départ pour les étudiants sélectionnés';
$string['setstoplevel'] = 'Changer le niveau maximum pour les étudiants sélectionnés';
$string['settings'] = 'Réglages';
$string['setuniformgoalinpoints'] = 'Définir un objectif en points';
$string['setuniformgoalinwords'] = 'Définir un objectif uniforme en mots';
$string['setwords'] = 'Définir le nombre de mots';
$string['show'] = 'Afficher';
$string['show_help'] = 'Cliquez sur le type d\'éléments que vous souhaitez voir apparaître dans la liste ci-dessous';
$string['showall'] = 'Afficher tous';
$string['showattempts'] = 'Afficher les tentatives correspondant à ces conditions';
$string['showdeleted'] = 'Afficher les tentatives supprimées';
$string['showhidden'] = 'Afficher les livres cachés';
$string['showhide'] = 'Afficher/Masquer';
$string['showhidebook'] = 'Afficher ou masquer';
$string['showhidebooks'] = 'Mettre à jour le paramètre afficher/masquer pour les livres sélectionnés';
$string['showlevel'] = 'Afficher le niveau';
$string['showpercentgrades'] = 'Afficher les notes en pourcentage';
$string['showpercentgrades_help'] = '**Oui**
: Affiche la note (en pourcentage) pour chaque tentative de test Reader

**Non**
: Ne PAS afficher les notes pour les tentatives individuelles de test Reader';
$string['showpoints'] = 'Montrer seulement les points';
$string['showpointsandwordcount'] = 'Afficher les points et le nombre de mots';
$string['showprogressbar'] = 'Afficher la barre de progression';
$string['showprogressbar_help'] = '**Oui**
: Affiche la barre de progression du nombre de mots sur la page principale de cette activité Reader

**Non**
: Ne pas afficher la barre de progression du nombre de mots sur la page principale de cette activité Reader';
$string['showreviewlinks'] = 'Afficher les liens d\'évaluation';
$string['showreviewlinks_help'] = '**Oui**
: Ajoutez des liens à partir des valeurs des pages de rapport de Reader vers des pages de révision de tests, illustrant exactement la réponse donnée à chaque question lors d’une tentative de test Reader.

**Non**
: N\'ajoutez PAS de liens à partir des valeurs des pages du rapport Reader aux pages de révision du quiz.

Ce paramètre concerne uniquement les enseignants. Cela affecte les étudiants car ils n\'ont pas accès aux pages de rapport de Reader.';
$string['showwordcount'] = 'Montrer seulement le nombre de mots';
$string['skipline'] = 'Ignorer la ligne : {$a}';
$string['skipped'] = 'Ignoré';
$string['skipquizdownload'] = 'Le test « {$a->quizname} » existe déjà dans la section {$a->sectionnum}, « {$a->sectionname} », de « {$a->coursename} » et a été ignoré';
$string['sofar'] = 'jusque là';
$string['sort_strings'] = 'Trier les chaînes';
$string['sort_strings_desc'] = 'Triez les chaînes utilisées par le module Reader.';
$string['sortfields'] = 'Champs de tri';
$string['startbookdetailed'] = 'Il n\'y a actuellement aucune donnée disponible pour ce rapport.';
$string['startbooksummary'] = 'Il n\'y a actuellement aucune donnée disponible pour ce rapport.';
$string['startdate'] = 'Date de début';
$string['starteditcourse'] = '**Commencer**

Sur cette page, vous pouvez modifier et supprimer des livres Reader disponibles dans ce cours. Vous pouvez également créer de nouveaux livres dans ce cours, à condition qu\'ils aient déjà été téléchargés sur ce site Moodle à l\'aide des pages de téléchargement.';
$string['starteditsite'] = '**Commencer**

Sur cette page, vous pouvez modifier et supprimer des livres Reader sur ce site Moodle. Pour ajouter de nouveaux livres Reader sur ce site, veuillez utiliser les pages de téléchargement.';
$string['startgroupsummary'] = 'Il n\'y a actuellement aucune donnée disponible pour ce rapport.';
$string['startlevel'] = 'Niveau de départ';
$string['startscan'] = 'Lancer l\'analyse';
$string['startuserdetailed'] = 'Il n\'y a actuellement aucune donnée disponible pour ce rapport.';
$string['startusersummary'] = 'Il n\'y a actuellement aucune donnée disponible pour ce rapport.';
$string['stoplevel'] = 'Niveau maximum';
$string['stoplevel_help'] = 'Les étudiants ne peuvent pas être promus automatiquement au-delà de ce niveau';
$string['stoplevelforce'] = 'Appliquer cette valeur à TOUS les utilisateurs actuels';
$string['strfattempttime'] = '%Y %b %d (%a) %H:%M';
$string['strfattempttimeshort'] = '%Y/%m/%d %H:%M';
$string['strfdateshort'] = '%Y %b %d (%a)';
$string['strfdatetimeshort'] = '%Y %b %d (%a) %H:%M';
$string['strftimeshort'] = '%H:%M';
$string['studentmanagement'] = 'Gestion des étudiants';
$string['studentslevels'] = 'Modifier les niveaux des étudiants, la politique de promotion et les objectifs';
$string['studentuserid'] = 'ID utilisateur de l\'étudiant';
$string['studentusername'] = 'Nom d\'utilisateur de l\'étudiant';
$string['studentview'] = 'Vue des étudiants';
$string['subnetlength'] = 'Masque IP';
$string['subnetwrong'] = 'Ce test n\'est accessible que depuis certains emplacements et cet ordinateur ne figure pas dans la liste autorisée.';
$string['summaryreportbybooktitle'] = 'Rapport de synthèse par titre de livre';
$string['summaryreportbyclassgroup'] = 'Rapport de synthèse par groupe de classe';
$string['takequizfor'] = 'Répondez au test « {$a} »';
$string['takethisquiz'] = 'Répondez à ce test';
$string['targetcategory'] = 'Catégorie cible';
$string['targetcategory_help'] = 'La catégorie de cours contenant le cours dans lequel vous souhaitez télécharger les tests des livres sélectionnés.';
$string['targetcourse'] = 'Cours ciblé';
$string['targetcourse_help'] = 'Sélectionnez le cours dans lequel vous souhaitez télécharger les tests pour les livres sélectionnés. Habituellement, vous devriez télécharger un cours caché utilisé uniquement pour stocker des tests utilisés par le module Reader.

Sélectionnez le type de cours parmi l’une des options suivantes:

**Tout**
: Choisissez parmi une liste de tous les cours sur ce site Moodle.

**Caché**
: Faites votre choix parmi une liste de cours visibles pour vous mais cachés aux étudiants. Habituellement, vous devriez choisir cette option.

**Visible**
: Choisissez parmi une liste de cours visibles pour vous et les étudiants inscrits.

**Actuel**
: Des tests reader seront téléchargés dans le cours actuel.

**Nouveau**
: Les tests Reader seront téléchargés dans un nouveau cours. Entrez un nom pour le nouveau cours dans la zone de texte.';
$string['targetsection'] = 'Section cible';
$string['targetsection_help'] = 'Spécifiez la section du cours, c\'est-à-dire la semaine ou le sujet dans lequel vous souhaitez télécharger les tests. Les types de section suivants sont disponibles:

**Les sections par défaut**
: Les tests seront regroupés et placés dans des sections en fonction du « Niveau - Éditeur » de leurs livres respectifs.

**Une section cachée**
: Les tests seront placés dans la section cachée sélectionnée du cours.

**Une section visible**
: Les tests seront placés dans la partie visible du cours sélectionnée.

**La dernière section**
: Les tests seront ajoutés à la dernière section du cours

**Une nouvelle section**
: Les tests seront ajoutés à une nouvelle section. Entrez un nom pour la nouvelle section dans la zone de texte.';
$string['termtype'] = 'Terme';
$string['therehavebeennonewquizzesorupdates'] = 'Aucun nouveau test ou mise à jour n\'a été ajouté à la banque de test MoodleReader depuis la dernière vérification.';
$string['thisattempt'] = 'cette tentative';
$string['thisblockunavailable'] = 'Ce bloc est actuellement indisponible pour cet étudiant';
$string['thislevel'] = 'Questkionnaires au niveau actuel';
$string['thislevel_help'] = 'Nombre de test au niveau de lecture actuel qu\'un étudiant doit réussir pour pouvoir passer au niveau de lecture suivant. Notez que seuls les tests passés depuis la dernière promotion comptent pour la promotion suivante.';
$string['thisterm'] = 'ce terme';
$string['timefinish'] = 'Temps écoulé';
$string['timeleft'] = 'Temps restant';
$string['timestart'] = 'Temps démarré';
$string['to'] = 'à';
$string['tools'] = 'Outils';
$string['totalpoints'] = 'Total des points';
$string['totalpointsallterms'] = 'Total des points (tous les termes)';
$string['totalpointsgoal'] = 'Mot/objectif point';
$string['totalpointsgoal_help'] = 'Le nombre total de mots/points que les étudiants sont supposés accumuler dans le terme actuel';
$string['totalpointsthisterm'] = 'Total des points (ce terme)';
$string['totalwords'] = 'Total des mots';
$string['totalwordsallterms'] = 'Total des mots (tous les termes)';
$string['totalwordsthisterm'] = 'Total des mots (ce terme)';
$string['transferfromcourse'] = 'Transfert de cours';
$string['type'] = 'Type';
$string['type_help'] = 'Sélectionnez le type de livre que vous souhaitez afficher dans la liste ci-dessous :

**Livres avec tests**
: La page affichera une liste de livres avec des tests pouvant être téléchargés.

**Livres sans tests**
: La page affichera une liste de livres pour lesquels des données telles que la difficulté et le nombre de mots existent, mais pour lesquels aucun test n\'a encore été créé.';
$string['uniqueip'] = 'Nécessite une adresse IP unique';
$string['update'] = 'Mettre à jour';
$string['updatecheated'] = 'Mettre à jour le paramètre triché pour les tentatives sélectionnées';
$string['updatedon'] = 'Mis à jour le {$a}';
$string['updatepassed'] = 'Mettre à jour le paramètre succès/échec pour les tentatives sélectionnées';
$string['updatequizzes'] = 'Mettre à jour des tests';
$string['updates'] = 'Mises à jour';
$string['updatesavailable'] = '{$a} mises à jour disponibles';
$string['updatinggrades'] = 'Mise à jour des notes Reader';
$string['upgradeoldquizzesinfo'] = 'La mise à niveau a été suspendue afin que vous puissiez décider si vous souhaitez conserver les anciennes versions des tests du module Reader sur ce site Moodle.

Si vous sélectionnez « Oui », tous les anciens tests Reader seront conservés. Choisissez cette option si vous souhaitez conserver toutes les statistiques sur les réponses aux questions individuelles des anciens tests Reader.

Si vous sélectionnez « Non », les anciennes versions en double des tests Reader seront supprimées, ne laissant que la version visible la plus récente de chaque test. Choisissez cette option si vous n\'êtes pas préoccupé par les statistiques concernant les réponses aux questions individuelles des anciens tests Reader et si vous souhaitez ranger la page du cours du test Reader.

Notez que même si vous choisissez « Non «, le nombre de mots dans les activités de Reader ne sera pas affecté par cette opération.

Souhaitez-vous conserver les anciennes versions des tests du module Reader ?';
$string['upgradestalefiles'] = 'Versions mixte du module Reader détectées, la mise à niveau ne peut pas continuer';
$string['upgradestalefilesinfo'] = 'Le processus de mise à jour de Moodle a été suspendu car des fichiers de versions précédentes du module Reader ont été détectés dans le répertoire « mod/reader ».

Cela peut poser des problèmes plus tard. Pour continuer, vous devez vous assurer que le répertoire « mod/reader » ne contient que les fichiers d’une version unique du module Reader.

La méthode recommandée pour nettoyer votre répertoire « mod/reader » est la suivante :

* supprimer le répertoire « mod/reader » actuel, ou au moins le sortir du répertoire « mod »
* créer un nouveau répertoire « mod/reader » contenant uniquement les fichiers d\'un téléchargement standard du module Reader ou du référentiel GIT

Sinon, si vous accordez un accès en écriture récursif au dossier « mod/reader » suivant, les fichiers peuvent être supprimés automatiquement lorsque vous reprenez la mise à niveau :

* {$a->dirpath}

Les fichiers du répertoire « mod/reader » qui bloquent actuellement la mise à niveau sont les suivants:
{$a->filelist}

Si vous préférez, vous pouvez également supprimer le(s) fichier(s) ci-dessus vous-même.

Cliquez sur le bouton ci-dessous pour reprendre le processus de mise à jour de Moodle.';
$string['uploaddatanoquizzes'] = 'Télécharger des données pour des livres qui n\'ont pas de tests';
$string['uploadquiztoreader'] = 'Téléchargez des tests à partir de la base de données de test de Reader';
$string['use_this_course'] = 'Utilisez ce cours';
$string['usecourse'] = 'Cours des tests Reader';
$string['usecourse_help'] = 'Un cours sur ce site Moodle contenant les tests Reader sur cette activité Reader. Ce cours devrait être caché aux étudiants. Il contient généralement des tests qui ont été téléchargés par le module Reader à partir d\'un référentiel de test Reader externe, par exemple moodlereader.net.';
$string['usedefaultquizid'] = 'Toujours utiliser le test par défaut';
$string['userexport'] = 'Exporter les données utilisateur';
$string['userimport'] = 'Importer des données utilisateur';
$string['userlevel'] = 'Niveau de l\'utilisateur';
$string['usernamenotfound'] = 'Nom d\'utilisateur non trouvé : {$a}';
$string['users'] = 'Utilisateurs';
$string['usersallwith'] = 'tous les utilisateurs qui ont tenté au moins un test';
$string['usersenrolledall'] = 'tous les utilisateurs inscrits';
$string['usersenrolledwith'] = 'utilisateurs inscrits ayant tenté au moins un quiz';
$string['usersenrolledwithout'] = 'utilisateurs inscrits qui n\'ont pas tenté de répondre à des tests';
$string['usersetgoals'] = 'Fixer les objectifs de l\'utilisateur';
$string['usersetlevels'] = 'Définir les niveaux d\'utilisateur';
$string['usersetmessage'] = 'Définir un message pour les utilisateurs';
$string['usersexport'] = 'Exporter des données';
$string['usersimport'] = 'Importer des données';
$string['userssetgoals'] = 'Définir des objectifs';
$string['userssetlevels'] = 'Définir les niveaux';
$string['userssetmessage'] = 'Définir le message';
$string['usertype'] = 'Utilisateurs à inclure';
$string['valueoutofrange'] = 'Cette valeur doit être comprise entre {$a->min} et {$a->max}';
$string['viewattempts'] = 'Afficher et supprimer des tentatives';
$string['viewlogsuspiciousactivity'] = 'Voir les logs des activités suspectes';
$string['windowclosing'] = 'Cette fenêtre se fermera sous peu.';
$string['withoutdayfilter'] = 'Sans filtre de jour';
$string['words'] = 'Mots';
$string['wordscount'] = 'Nombre de mots';
$string['wordsorpoints'] = 'Afficher les mots ou les points';
$string['wordsorpoints_help'] = '**Afficher seulement le nombre de mots**
: Sur les pages du rapport, affichez uniquement le nombre de mots des tentatives.

**Montrer seulement les points**
: Sur les pages du rapport, affichez uniquement les points gagnés pour les tentatives.

**Afficher les deux mots et les points**
: Sur les pages du rapport, affichez le nombre de mots et le nombre de points gagnés pour les tentatives.';
$string['youcannottake'] = 'Vous ne pouvez PAS prendre plus de test au niveau lecture {$a}';
$string['youcannotwait'] = 'Ce test se ferme avant que vous ne puissiez commencer une autre tentative.';
$string['youcantakeaquizafter'] = 'Vous pouvez répondre à votre prochain test après {$a}';
$string['youcantakeaquiznow'] = 'Maintenant, vous pouvez faire un test.';
$string['youcantakeasmanyquizzesasyouwant'] = 'Vous pouvez répondre à autant de tests que vous le souhaitez au niveau {$a}.';
$string['youcantakeplural'] = 'Vous pouvez prendre {$a->count} tests de plus au niveau de lecture {$a->level}. Ces livres compteront dans votre total de lecture, mais pas dans votre promotion.';
$string['youcantakesingle'] = 'Vous pouvez répondre à UN autre test au niveau de lecture {$a->level}. Ce livre comptera dans votre total de lecture, mais ne comptera pas dans votre promotion.';
$string['youcantakeunlimited'] = 'Vous pouvez répondre à autant de tests que vous le souhaitez au niveau lecture {$a}';
$string['youhavebeenpromoted'] = 'Toutes nos félicitations!! Vous avez été promu au niveau {$a}';
$string['youmustpassplural'] = 'Pour être promu, vous devez passer {$a->count} tests de plus au niveau de lecture {$a->level}.';
$string['youmustpasssingle'] = 'Pour être promu, vous devez passer UN autre test au niveau de lecture {$a->level}.';
$string['youmustwait'] = 'Vous devez attendre avant de pouvoir réessayer ce test. Vous pourrez commencer une nouvelle tentative après {$a}.';
$string['yourcurrentlevel'] = 'Votre niveau de lecture est actuellement défini au niveau {$a}';
$string['youwerepromoted'] = 'Vous avez été promu au niveau de lecture {$a->level} le {$a->date} à {$a->time}';
