<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_boostnavigation', language 'fr', version '3.5'.
 *
 * @package     local_boostnavigation
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['pluginname'] = 'Personnaliser le tiroir de navigation';
$string['privacy:metadata:preference:collapse'] = 'État (déplié/replié) d\'un nœud dépliable dans le tiroir de navigation';
$string['privacy:request:preference:collapse'] = 'L\'état du nœud « {$a->nodename} » dans le tiroir de navigation est {$a->collapse}';
$string['setting_collapseactivitiescoursenode'] = 'Replier le nœud « Activités »';
$string['setting_collapseactivitiescoursenode_desc'] = 'Si ce paramètre est activé, les utilisateurs pourront déplier/replier le nœud « Activités ».<br/><em>Ce paramètre n\'a d\'effet que si « Ajouter le nœud Activités » est activé.</em>';
$string['setting_collapseactivitiescoursenodedefault'] = 'Replier le nœud « Activités » par défaut';
$string['setting_collapseactivitiescoursenodedefault_desc'] = 'Si ce paramètre est activé, le nœud « Activités » sera replié par défaut. Dans le cas contraire, il sera déplié par défaut. Ce paramètre ne fait que gérer le premier affichage de ce nœud pour chaque utilisateur.<br/><em>Ce paramètre n\'a d\'effet que si la fonctionnalité « déplier/replier » est activée pour ce nœud.</em>';
$string['setting_collapsebottomnodesheading'] = 'Fonction déplier/replier pour les nœuds inférieurs du tiroir de navigation';
$string['setting_collapsecoursenodesheading'] = 'Fonction déplier/replier pour les nœuds du tiroir de navigation en contexte « cours »';
$string['setting_collapsecoursesectionscoursenode'] = 'Replier le nœud « Sections »';
$string['setting_collapsecoursesectionscoursenode_desc'] = 'Si ce paramètre est activé, les utilisateurs pourront déplier/replier le nœud « Sections ».<br/><em>Ce paramètre n\'a d\'effet que si « Ajouter le nœud Sections » est activé.</em>';
$string['setting_collapsecoursesectionscoursenodedefault'] = 'Replier le nœud « Sections » par défaut';
$string['setting_collapsecoursesectionscoursenodedefault_desc'] = 'Si ce paramètre est activé, le nœud « Sections » sera replié par défaut. Dans le cas contraire, il sera déplié par défaut. Ce paramètre ne fait que gérer le premier affichage de ce nœud pour chaque utilisateur.<br/><em>Ce paramètre n\'a d\'effet que si la fonctionnalité « déplier/replier » est activée pour ce nœud.</em>';
$string['setting_collapsecustombottomnodesadmins'] = 'Replier les nœuds inférieurs des administrateurs';
$string['setting_collapsecustombottomnodesadmins_desc'] = 'Si ce paramètre est activé, les administrateurs pourront déplier/replier leurs nœuds inférieurs.<br/><em>Ce paramètre n\'a d\'effet que si « Ajouter des nœuds en bas du tiroir pour les administrateurs » contient au moins un nœud contenant lui-même au moins un nœud enfant.</em>';
$string['setting_collapsecustombottomnodesadminsdefault'] = 'Replier par défaut les nœuds inférieurs des administrateurs';
$string['setting_collapsecustombottomnodesadminsdefault_desc'] = 'Si ce paramètre est activé, les nœuds inférieurs des administrateurs seront repliés par défaut. Dans le cas contraire, ils seront dépliés par défaut. Ce paramètre ne fait que gérer le premier affichage de ce nœud pour chaque utilisateur.<br/><em>Ce paramètre n\'a d\'effet que si la fonctionnalité « déplier/replier » est activée pour les nœuds inférieurs des administrateurs.</em>';
$string['setting_collapsecustombottomnodesusers'] = 'Replier les nœuds inférieurs des utilisateurs';
$string['setting_collapsecustombottomnodesusers_desc'] = 'Si ce paramètre est activé, les utilisateurs pourront déplier/replier leurs nœuds inférieurs.<br/><em>Ce paramètre n\'a d\'effet que si « Ajouter des nœuds en bas du tiroir pour les utilisateurs » contient au moins un nœud contenant lui-même au moins un nœud enfant.</em>';
$string['setting_collapsecustombottomnodesusersdefault'] = 'Replier par défaut les nœuds inférieurs des utilisateurs par défaut';
$string['setting_collapsecustombottomnodesusersdefault_desc'] = 'Si ce paramètre est activé, les nœuds inférieurs des utilisateurs seront repliés par défaut. Dans le cas contraire, ils seront dépliés par défaut. Ce paramètre ne fait que gérer le premier affichage de ce nœud pour chaque utilisateur.<br/><em>Ce paramètre n\'a d\'effet que si la fonctionnalité « déplier/replier » est activée pour les nœuds inférieurs des utilisateurs.</em>';
$string['setting_collapsecustomcoursenodesadmins'] = 'Replier les nœuds de cours personnalisés des administrateurs';
$string['setting_collapsecustomcoursenodesadmins_desc'] = 'Si ce paramètre est activé, les administrateurs pourront déplier/replier leurs nœuds de cours personnalisés.<br/><em>Ce paramètre n\'a d\'effet que si « Ajouter des nœuds de cours personnalisés pour les administrateurs » contient au moins un nœud contenant lui-même au moins un nœud enfant.</em>';
$string['setting_collapsecustomcoursenodesadminsdefault'] = 'Replier par défaut les nœuds de cours personnalisés des administrateurs';
$string['setting_collapsecustomcoursenodesadminsdefault_desc'] = 'Si ce paramètre est activé, les nœuds de cours personnalisés des administrateurs seront repliés par défaut. Dans le cas contraire, ils seront dépliés par défaut. Ce paramètre ne fait que gérer le premier affichage de ce nœud pour chaque utilisateur.<br/><em>Ce paramètre n\'a d\'effet que si la fonctionnalité « déplier/replier » est activée pour les nœuds de cours personnalisés des administrateurs.</em>';
$string['setting_collapsecustomcoursenodesusers'] = 'Replier les nœuds de cours personnalisés des utilisateurs';
$string['setting_collapsecustomcoursenodesusers_desc'] = 'Si ce paramètre est activé, les utilisateurs pourront déplier/replier leurs nœuds de cours personnalisés.<br/><em>Ce paramètre n\'a d\'effet que si « Ajouter des nœuds de cours personnalisés pour les utilisateurs » contient au moins un nœud contenant lui-même au moins un nœud enfant.</em>';
$string['setting_collapsecustomcoursenodesusersdefault'] = 'Replier par défaut les nœuds de cours personnalisés des utilisateurs';
$string['setting_collapsecustomcoursenodesusersdefault_desc'] = 'Si ce paramètre est activé, les nœuds de cours personnalisés des utilisateurs seront repliés par défaut. Dans le cas contraire, ils seront dépliés par défaut. Ce paramètre ne fait que gérer le premier affichage de ce nœud pour chaque utilisateur.<br/><em>Ce paramètre n\'a d\'effet que si la fonctionnalité « déplier/replier » est activée pour les nœuds de cours personnalisés des utilisateurs.</em>';
$string['setting_collapsecustomnodesadmins'] = 'Replier les nœuds globaux personnalisés des administrateurs';
$string['setting_collapsecustomnodesadmins_desc'] = 'Si ce paramètre est activé, les administrateurs pourront déplier/replier leurs nœuds globaux personnalisés.<br/><em>Ce paramètre n\'a d\'effet que si « Ajouter des nœuds globaux personnalisés pour les administrateurs » contient au moins un nœud contenant lui-même au moins un nœud enfant.</em>';
$string['setting_collapsecustomnodesadminsdefault'] = 'Replier par défaut les nœuds globaux personnalisés des administrateurs';
$string['setting_collapsecustomnodesadminsdefault_desc'] = 'Si ce paramètre est activé, les nœuds globaux personnalisés des administrateurs seront repliés par défaut. Dans le cas contraire, ils seront dépliés par défaut. Ce paramètre ne fait que gérer le premier affichage de ce nœud pour chaque utilisateur.<br/><em>Ce paramètre n\'a d\'effet que si la fonctionnalité « déplier/replier » est activée pour les nœuds globaux personnalisés des administrateurs.</em>';
$string['setting_collapsecustomnodesusers'] = 'Replier les nœuds globaux personnalisés des utilisateurs';
$string['setting_collapsecustomnodesusers_desc'] = 'Si ce paramètre est activé, les utilisateurs pourront déplier/replier leurs nœuds globaux personnalisés.<br/><em>Ce paramètre n\'a d\'effet que si « Ajouter des nœuds globaux personnalisés pour les utilisateurs » contient au moins un nœud contenant lui-même au moins un nœud enfant.</em>';
$string['setting_collapsecustomnodesusersdefault'] = 'Replier par défaut les nœuds globaux personnalisés des utilisateurs';
$string['setting_collapsecustomnodesusersdefault_desc'] = 'Si ce paramètre est activé, les nœuds globaux personnalisés des utilisateurs seront repliés par défaut. Dans le cas contraire, ils seront dépliés par défaut. Ce paramètre ne fait que gérer le premier affichage de ce nœud pour chaque utilisateur.<br/><em>Ce paramètre n\'a d\'effet que si la fonctionnalité « déplier/replier » est activée pour les nœuds globaux personnalisés des utilisateurs.</em>';
$string['setting_collapsemycoursesnode'] = 'Replier le nœud « Mes cours »';
$string['setting_collapsemycoursesnode_desc'] = 'Si ce paramètre est activé, les utilisateurs pourront déplier/replier le nœud « Mes cours ».';
$string['setting_collapsemycoursesnodedefault'] = 'Replier le nœud « Mes cours » par défaut';
$string['setting_collapsemycoursesnodedefault_desc'] = 'Si ce paramètre est activé, le nœud « Mes cours » sera replié par défaut. Dans le cas contraire, il sera déplié par défaut. Ce paramètre ne fait que gérer le premier affichage de ce nœud pour chaque utilisateur.<br/><em>Ce paramètre n\'a d\'effet que si la fonctionnalité « déplier/replier » est activée pour ce nœud.</em>';
$string['setting_collapsemycoursesnodeperformancehint'] = 'Attention: ceci ne fonctionnera que si le paramètre <a href="/admin/search.php?query=navshowmycoursecategories">Afficher les catégories de cours</a> est désactivé. Dans le cas contraire, ce paramètre sera ignoré.';
$string['setting_collapsenodesheading'] = 'Fonction déplier/replier pour les nœuds globaux';
$string['setting_collapsenodestechnicalhint'] = 'Aspect technique: du code JavaScript et CSS est ajouté à la page pour afficher/masquer les nœuds de second niveau lorsque l\'utilisateur clique sur ce nœud. L\'état (déplié/replié) du nœud est enregistré dans les préférences de l\'utilisateur. Ainsi, les nœuds ne seront masqués dans le tiroir de navigation qu\'à l\'exécution tout en restant dans l\'arbre de navigation et donc accessibles par d\'autres composants de Moodle.';
$string['setting_customnodesusageadmins'] = 'Chaque ligne est composée des paramètres suivants : titre, lien (URL) et langues supportées (facultatif), séparés par des « | ». Chaque nœud doit être écrit dans une nouvelle ligne.<br/>
Par exemple :<br/>
Moodle.org website|http://www.moodle.org|en,fr<br />
Liste des utilisateurs|/admin/user.php<br /><br/>
Détails des paramètres :<ul>
<li><b>Titre :</b>Texte du nœud personnalisé.</li>
<li><b>Lien :</b>Cible du nœud. Soit une URL absolue (ex. https://moodle.org) ou un chemin relatif dans votre instance de Moodle (ex. /login/logout.php).</li>
<li><b>Langue(s) (facultatif) :</b>Paramètre permettant de restreindre l\'affichage de ce nœud en fonction de la langue de l\'utilisateur. Pour spécifier plusieurs langues autorisées, séparez les identifiants de langue par des virgules. Pour afficher ce nœud quelle que soit la langue, laissez ce paramètre vide.</li>
</ul>
Attention :
<ul>
<li>Les nœuds personnalisés pour les administrateurs sont traités de la même manière que les nœuds personnalisés pour tous les utilisateurs. Par conséquent, en plus des paramètres décrits ci-dessus, les paramètres autorisés pour les nœuds à destination de tous les utilisateurs sont également disponibles ici. Vous pouvez donc les utiliser selon vos besoins même si ils ne sont pas à nouveau documentés ici par souci de simplicité
<li>
Le paramètre « Titre » peut contenir des variables prédéfinies, comme {coursefullname} pour ajouter un nœud dont le titre est le nom complet du cours affiché. Les variables prédéfinies doivent être entourées d\'accolades et seront remplacées automatiquement lorsque le nœud est créé.<br/>Variables prédéfinies disponibles :
<br/>Variables prédéfinies disponibles :
<ul>
<li>{coursefullname} : nom complet du cours</li>
<li>{courseshortname} : nom abrégé du cours</li>
<li>{editingtoggle} : « Activer le mode édition » ou « Quitter le mode édition »</li>
<li>{userfullname} : nom complet de l\'utilisateur connecté</li>
<li>{userusername} : nom d\'utilisateur de l\'utilisateur connecté</li>
</ul>
</li>
<li>
Le paramètre « Lien » peut contenir des variables prédéfinies, comme /course/edit.php?id={courseid} pour ajouter un nœud dirigeant vers les paramètres du cours affiché. Les variables prédéfinies doivent être entourées d\'accolades et seront remplacées automatiquement lorsque le nœud est créé.
<ul>
<li>{courseid} : identifiant (interne à Moodle) du cours affiché</li>
<li>{courseshortname}: nom abrégé du cours</li>
<li>{editingtoggle}: la valeur « on » ou « off » requise pour activer/désactiver le mode édition</li>
<li>{userid}: identifiant (interne à Moodle) de l\'utilisateur connecté</li>
<li>{userusername}: nom d\'utilisateur de l\'utilisateur connecté</li>
<li>{pagecontextid}: identifiant du contexte de la page courante</li>
<li>{pagepath}: URL de la page courante</li>
<li>{sesskey}: identifiant de session pour les URLs sécurisées</li>
</ul>
</li>
<li>
Si le noeud personnalisé ne s\'affiche pas dans le tiroir de navigation, vérifiez bien que tous les paramètres obligatoires ont été définis correctement et que votre langue actuelle est autorisée par le paramètre de langue (si spécifié).
</li>
<li>
Etant donné la méthode de génération du tiroir de navigation dans Moodle, tous les noeuds personnalisés seront affichés de la même manière. Leur ajouter des classes CSS, un attribut « id » personnalisé ou un attribut « target » pour ouvrir le lien dans un nouvel onglet n\'est pas possible.
</li>
</ul>';
$string['setting_customnodesusagechildnodes'] = 'Les noeuds personnalisés peuvent être définis sur deux niveaux, un noeud de premier niveau peut dont avoir des noeuds enfants. Pour ajouter un noeud enfant, il suffit de préfixer la ligne d\'un tiret.<br/>
Par exemple :<br/>
Administration|/admin/index.php<br/>
-Liste des utilisateurs|/admin/user.php<br/>
-Gestion des cours|/course/management.php<br/><br/>
Attention :
<ul>
<li>Pour des raisons techniques, un noeud parent doit obligatoirement être associé à une URL valide, même si on lui applique la fonctionnalité replier/déplier par la suite.</li>
<li>Si un noeud parent n\'est pas affiché à cause de restrictions (langue, cohorte, rôle), ses noeuds enfants ne seront pas non plus affichés</li>
</ul>';
$string['setting_customnodesusageusers'] = 'Chaque ligne est composée des paramètres suivants : titre, lien (URL), langues supportées (facultatif), cohorte(s) (facultatif), rôle(s) (facultatif), rôle(s) système (facultatif), opérateur logique (facultatif), icône (facultatif) et attribut ID (facultatif) séparés par des « | ». Chaque nœud doit être écrit dans une nouvelle ligne.<br/>
Par exemple :<br/>
Moodle.org website|http://www.moodle.org|en,fr<br />
Notre université|http://www.notre-university.edu<br />
Faculté des Sciences|http://www.our-universite.edu/sciences||sciences<br />
Manuel pour l\'enseignant|http://www.notre-universite.edu/manuel-enseignant|||editingteacher,teacher<br />
Espace étudiants|/course/view.php?id=1234||||||fa-graduation-cap<br />
{editingtoggle}|/course/view.php?id={courseid}&sesskey={sesskey}&edit={editingtoggle}|||editingteacher|admin,manager|OR|editing<br />
Détails des paramètres :<ul>
<li><b>Titre :</b>Texte du nœud personnalisé.</li>
<li><b>Lien :</b>Cible du nœud. Soit une URL absolue (ex. https://moodle.org) ou un chemin relatif dans votre instance de Moodle (ex. /login/logout.php).</li>
<li><b>Langue(s) (facultatif) :</b>Paramètre permettant de restreindre l\'affichage de ce nœud en fonction de la langue de l\'utilisateur. Pour spécifier plusieurs langues autorisées, séparez les identifiants de langue par des virgules. Pour afficher ce nœud quelle que soit la langue, laissez ce paramètre vide.</li>
<li><b>Cohorte(s) (facultatif) :</b>Paramètre permettant de restreindre l\'affichage de ce nœud en fonction de l\'appartenance à une cohorte (représentée ici par son ID, pas son nom). Pour spécifier plusieurs cohortes, séparez les IDs de cohortes par des virgules. Pour afficher ce nœud quelle que soit la cohorte, laissez ce paramètre vide.</li>
<li><b>Rôle(s) (facultatif) :</b>Paramètre permettant de restreindre l\'affichage de ce nœud en fonction de du rôle de l\'utilisateur (représenté ici par le nom abrégé du rôle) dans le contexte d\'affichage. Pour spécifier plusieurs rôles, séparez les noms abrégés de ces rôles par des virgules. Pour afficher ce nœud quelle que soit le rôle, laissez ce paramètre vide.</li>
<li><b>Rôle(s) système (facultatif) :</b>Paramètre permettant de restreindre l\'affichage de ce nœud en fonction de du rôle de l\'utilisateur (représenté ici par le nom abrégé du rôle) dans le contexte système. Pour spécifier plusieurs rôles, séparez les noms abrégés de ces rôles par des virgules. Pour afficher ce nœud quelle que soit le rôle, laissez ce paramètre vide.</li>
<li><b>Opérateur logique (facultatif) :</b>Paramètre permettant de modifier l\'opérateur logique pour la combinaison des paramètres facultatifs de restriction par cohorte, rôle et rôle système. Si vous spécifiez la valeur « AND » ou laissez le paramètre vide, les valeurs optionnelles pour les cohortes, rôles et rôles système seront combinées au moyen de l\'opérateur logique « ET », le nœud ne sera donc affiché que si l\'ensemble des conditions est respecté. Si vous spécifiez « OR », ces mêmes valeurs seront combinées au moyen de l\'opérateur logique « OU », le nœud sera donc affiché si au moins une des conditions est respectée. Cela vous permet par exemple de créer un nœud pour les utilisateurs d\'un certain rôle dans un cours ainsi que pour ceux disposant d\'un certain rôle système, comme le montre l\'exemple plus haut.</li>
<li><b>Icône (facultatif) :</b>Paramètre permettant d\'ajouter une icône pour le nœud. Utilisez un identifiant d\'icône Font Awesome (ex. fa-flag <a href="https://fontawesome.com/v4.7.0/icons/">Vous trouverez la liste sur fontawesome.com</a>) pour préciser l\'icône à utiliser. Font Awesome est inclus dans Boost. Les « pix icons » Moodle ne peuvent être utilisée ici. Si vous souhaitez attribuer une puce standard à votre nœud personnalisé, laissez ce champ vide. Les nœuds qui ne peuvent se voir attribuer une puce standard ne peuvent actuellement pas avoir d\'icône personnalisée non plus.</li>
<li><b>Attribut ID (facultatif) :</b>Paramètre permettant d\'attribuer un ID au nœud créé. La valeur donnée sera nettoyée de tout caractère non alphanumérique et préfixé par la zone du nœud. Par exemple si vous spécifiez « turlututu » comme ID pour un nœud global réservé aux administrateurs, l\'attribut ID généré sera « localboostnavigationcustomrootadminsturlututu »</li>. Ce paramètre vous permettra de référencer un nœud personnalisé dans des règles CSS ou du code JavaScript. Donner le même ID à plusieurs nœuds n\'est pas formellement interdit par HTML mais est déconseillé. Si vous n\'avez pas besoin de définir des règles CSS ou d\'associer du code JavaScript à ce nœud, vous pouvez laisser ce paramètre vide, ID lui sera attribué automatiquement.</li>
</ul>
Attention :
<ul>
<li>La séparation des paramètres au moyen du caractère « | » est obligatoire si le paramètre est situé entre d\'autres options définies. Cela signifie que vous devez rajouter un caractère « | » pour chaque paramètre vide si un paramètre après ceux-ci reçoit une valeur (voir l\'exemple <em>Espace étudiants</em>).</li>
<li>
Le paramètre « Titre » peut contenir des variables prédéfinies, comme {coursefullname} pour ajouter un nœud dont le titre est le nom complet du cours affiché. Les variables prédéfinies doivent être entourées d\'accolades et seront remplacées automatiquement lorsque le nœud est créé.<br/>Variables prédéfinies disponibles :
<br/>Variables prédéfinies disponibles :
<ul>
<li>{coursefullname} : nom complet du cours</li>
<li>{courseshortname} : nom abrégé du cours</li>
<li>{editingtoggle} : « Activer le mode édition » ou « Quitter le mode édition »</li>
<li>{userfullname} : nom complet de l\'utilisateur connecté</li>
<li>{userusername} : nom d\'utilisateur de l\'utilisateur connecté</li>
</ul>
</li>
<li>
Le paramètre « Lien » peut contenir des variables prédéfinies, comme /course/edit.php?id={courseid} pour ajouter un nœud dirigeant vers les paramètres du cours affiché. Les variables prédéfinies doivent être entourées d\'accolades et seront remplacées automatiquement lorsque le nœud est créé.
<ul>
<li>{courseid} : identifiant (interne à Moodle) du cours affiché</li>
<li>{courseshortname}: nom abrégé du cours</li>
<li>{editingtoggle}: la valeur « on » ou « off » requise pour activer/désactiver le mode édition</li>
<li>{userid}: identifiant (interne à Moodle) de l\'utilisateur connecté</li>
<li>{userusername}: nom d\'utilisateur de l\'utilisateur connecté</li>
<li>{pagecontextid}: identifiant du contexte de la page courante</li>
<li>{pagepath}: URL de la page courante</li>
<li>{sesskey}: identifiant de session pour les URLs sécurisées</li>
</ul>
</li>
<li>
Si le noeud personnalisé ne s\'affiche pas dans le tiroir de navigation, vérifiez bien que tous les paramètres obligatoires ont été définis correctement, que votre langue actuelle est autorisée par le paramètre de langue (si spécifié) et que les restrictions de cohorte, rôle et rôle système n\'empêchent pas son affichage.
</li>
<li>
Etant donné la méthode de génération du tiroir de navigation dans Moodle, tous les noeuds personnalisés seront affichés de la même manière. Leur ajouter des classes CSS, un attribut « id » personnalisé ou un attribut « target » pour ouvrir le lien dans un nouvel onglet n\'est pas possible.
</li>
</ul>';
$string['setting_insertactivitiescoursenode'] = 'Ajouter le nœud « Activités »';
$string['setting_insertactivitiescoursenode_desc'] = 'Activer ce paramètre ajoutera un nœud « Activités » au tiroir de navigation contenant des noeuds vers les pages d\'aperçu des activités. Il rajoute les fonctionnalités du bloc « Activités » au tiroir de navigation de Boost.';
$string['setting_insertbottomnodesheading'] = 'Ajouter des nœuds en bas du tiroir de navigation';
$string['setting_insertcoursenodesheading'] = 'Ajouter des nœuds en contexte de cours au tiroir de navigation';
$string['setting_insertcoursesectionscoursenode'] = 'Ajouter le nœud « Sections »';
$string['setting_insertcoursesectionscoursenode_desc'] = 'Activer ce paramètre ajoutera un nœud « Sections » au tiroir de navigation au-dessus de la première section du cours actif.';
$string['setting_insertcoursesectionscoursenodecorehint'] = 'Attention: ceci ne fonctionnera que si le paramètre <a href="/admin/search.php?query=linkcoursesections">Toujours lier les sections de cours</a> est activé. Dans le cas contraire, ce paramètre sera ignoré.';
$string['setting_insertcustombottomnodesadmins'] = 'Ajouter des nœuds pour les administrateurs';
$string['setting_insertcustombottomnodesadmins_desc'] = 'Ce paramètre vous permet d\'ajouter des nœuds personnalisés entre la section principale et le nœud « Administration du site » du tiroir de navigation. Ces nœuds ne seront accessibles qu\'aux administrateurs.';
$string['setting_insertcustombottomnodesusers'] = 'Ajouter des nœuds pour les utilisateurs';
$string['setting_insertcustombottomnodesusers_desc'] = 'Ce paramètre vous permet d\'ajouter des nœuds personnalisés en-dessous de la section principale du tiroir de navigation. Ces nœuds seront accessibles à tous les utilisateurs.';
$string['setting_insertcustomcoursenodesadmins'] = 'Ajouter des nœuds pour les administrateurs';
$string['setting_insertcustomcoursenodesadmins_desc'] = 'Ce paramètre vous permet d\'ajouter des nœuds personnalisés sous le dernier nœud de la section « cours » du tiroir de navigation. Ces nœuds ne seront accessibles qu\'aux administrateurs.';
$string['setting_insertcustomcoursenodesusers'] = 'Ajouter des nœuds pour les utilisateurs';
$string['setting_insertcustomcoursenodesusers_desc'] = 'Ce paramètre vous permet d\'ajouter des nœuds personnalisés sous le dernier nœud de la section « cours » du tiroir de navigation. Ces nœuds seront accessibles à tous les utilisateurs.';
$string['setting_insertcustomnodesadmins'] = 'Ajouter des nœuds pour les administrateurs';
$string['setting_insertcustomnodesadmins_desc'] = 'Ce paramètre vous permet d\'ajouter des nœuds personnalisés sous le dernier nœud de la section principale du tiroir de navigation. Ces nœuds ne seront accessibles qu\'aux administrateurs.';
$string['setting_insertcustomnodesusers'] = 'Ajouter des nœuds pour les utilisateurs';
$string['setting_insertcustomnodesusers_desc'] = 'Ce paramètre vous permet d\'ajouter des nœuds personnalisés sous le dernier nœud de la section principale du tiroir de navigation. Ces nœuds seront accessibles à tous les utilisateurs.';
$string['setting_insertnodescollapsehint'] = 'Notez bien que ce nœud renfermera un lien vers la page d\'accueil du cours étant donné que Boost n\'accepte pas les nouveaux nœuds dépourvus de lien. Ce lien sera désactivé si vous activez la fonctionnalité « replier/déplier » pour ce nœud.';
$string['setting_insertnodesheading'] = 'Ajouter des nœuds globaux au tiroir de navigation';
$string['setting_insertresourcescoursenode'] = 'Ajouter le nœud « Ressources »';
$string['setting_insertresourcescoursenode_desc'] = 'Activer ce paramètre ajoutera un nœud « Ressources » au tiroir de navigation. Ce nœud renverra vers la page d\'aperçu des ressources.<br/><em>Si « Ajouter le nœud Activités » est également activé, vous verrez toujours les deux nœuds en contexte de cours. Si vous n\'activez que le nœud des activités, ce dernier contiendra un nœud vers la page d\'aperçu des ressources, qui ne sera visible que si « Activités » est déplié</em>';
$string['setting_removebadgescoursenode'] = 'Supprimer « Badges »';
$string['setting_removebadgescoursenode_desc'] = 'Activer ce paramètre supprimera l\'entrée « Badges » du menu principal de Boost si il n\'y a aucun badge dans le cours. Les enseignants pourront toujours accéder à la page de gestion des badges via le menu d\'administration du cours.<br/><em>Ce paramètre n\'a d\'effet que si les badges sont activés dans la plateforme.</em>';
$string['setting_removecalendarnode'] = 'Supprimer "Calendrier"';
$string['setting_removecalendarnode_desc'] = 'Activer ce paramètre supprimera l\'entrée "Calendrier" du menu principal de Boost.';
$string['setting_removecompetenciescoursenode'] = 'Supprimer « Compétences »';
$string['setting_removecompetenciescoursenode_desc'] = 'Activer ce paramètre supprimera l\'entrée « Compétences » du menu principal de Boost si il n\'y a aucune compétence définie pour le cours. Pour les enseignants, un noeud sera ajouté dans le menu d\'administration du cours.<br/><em>Ce paramètre n\'a d\'effet que si les compétences sont activées dans la plateforme.</em>';
$string['setting_removecoursenodesheading'] = 'Supprimer des entrées du menu de cours';
$string['setting_removecoursenodestechnicalhint'] = 'Aspect technique: le nœud est supprimé de l\'arbre de navigation. Par conséquent il n\'est plus accessible par d\'autres composants de Moodle. Dans des configurations classiques de Moodle, cela ne devrait pas poser de problèmes.';
$string['setting_removedashboardnode'] = 'Supprimer "Tableaux de bord"';
$string['setting_removedashboardnode_desc'] = 'Activer ce paramètre supprimera l\'entrée "Tableaux de bord" du menu principal de Boost.';
$string['setting_removefirsthomenode'] = 'Supprimer le premier "Accueil du site" or "Tableau de bord"';
$string['setting_removefirsthomenode_desc'] = 'Activer ce paramètre supprimera l\'entrée "Accueil du site" ou "Tableau de bord", selon le choix de l\'utilisateur pour sa page d\'accueil du menu principal de Boost';
$string['setting_removegradescoursenode'] = 'Supprimer « Notes »';
$string['setting_removegradescoursenode_desc'] = 'Activer ce paramètre supprimera l\'entrée « Notes » du menu principal de Boost. Il sera supprimé, quel que soit les permissions de l\'utilisateur ou le statut de « Afficher le carnet de notes aux étudiants » dans les paramètres du cours.';
$string['setting_removehomenode'] = 'Supprimer "Page d\'accueil"';
$string['setting_removehomenode_desc'] = 'Activer ce paramètre supprimera l\'entrée "Page d\'accueil" du menu principal de Boost.';
$string['setting_removemycoursesnode'] = 'Supprimer "Mes cours"';
$string['setting_removemycoursesnode_desc'] = 'Activer ce paramètre supprimera l\'entrée "Mes cours" du menu principal de Boost.';
$string['setting_removemycoursesnodeperformancehint'] = 'A noter : Si vous activez ce paramètre ainsi que <a href="/admin/search.php?query=navshowmycoursecategories">navshowmycoursecategories</a>, supprimer "Mes cours" prend plus de temps et vous devriez peut-être désactiver le paramètre navshowmycoursecategories.';
$string['setting_removenodesheading'] = 'Supprimer les entrées racines du menu principal';
$string['setting_removenodestechnicalhint'] = 'Techniquement, ceci est fait en mettant l\'attribut showinflatnavigation à false. Ainsi le noeud ne sera caché que dans le menu principal, mais il sera toujours présent dans l\'arbre de navigation.';
$string['setting_removeparticipantscoursenode'] = 'Supprimer « Participants »';
$string['setting_removeparticipantscoursenode_desc'] = 'Activer ce paramètre supprimera l\'entrée « Participants » du menu principal de Boost. Il sera supprimé, quel que soit les permissions de l\'utilisateur.';
$string['setting_removeprivatefilesnode'] = 'Supprimer "Fichiers personnels"';
$string['setting_removeprivatefilesnode_desc'] = 'Activer ce paramètre supprimera l\'entrée "Fichiers personnels" du menu principal de Boost.';
$string['setting_removesecondhomenode'] = 'Supprimer le second "Accueil du site" or "Tableau de bord"';
$string['setting_removesecondhomenode_desc'] = 'Activer ce paramètre supprimera l\'entrée "Accueil du site" ou "Tableau de bord", selon le choix de l\'utilisateur pour sa page d\'accueil du menu principal de Boost.';
$string['settingspage_bottomnodes'] = 'Nœuds inférieurs';
$string['settingspage_coursenodes'] = 'Nœuds de cours';
$string['settingspage_rootnodes'] = 'Nœuds globaux';
