<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'error', language 'nl', version '3.5'.
 *
 * @package     error
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['TODO'] = 'TE DOEN';
$string['activityisscheduledfordeletion'] = 'Activiteit verwijderen bezig ...';
$string['agedigitalconsentmapinvalidage'] = '"{$a}" is geen geldige waarde voor leeftijd.';
$string['agedigitalconsentmapinvalidcomma'] = '"{$a}" heeft meer of minder dan één komma-scheidingsteken.';
$string['agedigitalconsentmapinvalidcountry'] = '"{$a}" is geen geldige waarde voor land.';
$string['agedigitalconsentmapinvaliddefault'] = 'Standaard(*) waarde ontbreekt.';
$string['agelocationverificationdisabled'] = 'Leeftijd- en locatieverificatie uitgeschakeld';
$string['alreadyloggedin'] = 'Je bent al aangemeld als {$a}, je moet afmelden voor je kunt aanmelden als een andere gebruiker.';
$string['authnotexisting'] = 'De authorisatieplugin bestaat niet';
$string['backupcontainexternal'] = 'Het back-upbestand bevat externe Moodle Hosts die lokaal niet geconfigureerd zijn.';
$string['backuptablefail'] = 'Back-uptabellen konden niet juist ingesteld worden';
$string['blockcannotconfig'] = 'Dit blok ondersteunt geen globale configuratie';
$string['blockcannotinistantiate'] = 'Probleem met het inistialiseren van het blok object';
$string['blockcannotread'] = 'Kon gegevens voor blokid={$a} niet lezen';
$string['blockdoesnotexist'] = 'Dit blok bestaat niet';
$string['blockdoesnotexistonpage'] = 'Dit blok (id={$a->instanceid}) bestaat niet op deze pagina ({$a->url}).';
$string['blocknameconflict'] = 'Naamconflikt: blok {$a->name} heeft dezelfde titel als een ander blok: {$a->conflict}!';
$string['callbackrejectcomment'] = 'Comment callback heeft deze opmerking verworpen.';
$string['cannotaddcoursemodule'] = 'Kon geen nieuwe cursusmodule toevoegen';
$string['cannotaddcoursemoduletosection'] = 'Kon geen nieuwe cursusmodule toevoegen in die sectie';
$string['cannotaddmodule'] = 'Module {$a} kon niet toegevoegd worden aan de modulelijst!';
$string['cannotaddnewmodule'] = 'Kon geen nieuwe {$a} module toevoegen';
$string['cannotaddrss'] = 'Je hebt geen toelating om een rss-feed toe te voegen';
$string['cannotaddthisblocktype'] = 'Je kunt blok {$a} niet toevoegen op deze pagina.';
$string['cannotassignrole'] = 'Kan rol niet toewijzen in cursus';
$string['cannotassignrolehere'] = 'Je mag deze rol (id={$a->roleid}) niet toewijzen in deze context ({$a->context})';
$string['cannotassignselfasparent'] = 'Kon mezelf niet als bovenliggend toewijzen!';
$string['cannotcallscript'] = 'Je kunt dit script op deze manier aanroepen';
$string['cannotcallusgetselecteduser'] = 'Je kunt user_selector:get_selected_user niet aanroepen als multiselect waar is';
$string['cannotcreatebackupdir'] = 'Kon back-upmap niet aanmaken. De beheerder moet de rechten op de mappen herstellen.';
$string['cannotcreatecategory'] = 'De categorie was niet toegevoegd';
$string['cannotcreatedboninstall'] = '<p>Kan databank niet maken.</p>
<p>De opgegeven databank bestaat niet en de opgegeven gebruiker heeft onvoldoende rechten om de databank te maken.</p>
<p>De site-beheerder moet de databankconfiguratie controleren.</p>';
$string['cannotcreategroup'] = 'Fout bij het maken van een groep';
$string['cannotcreatelangbase'] = 'Fout. Kon geen basis lang map maken';
$string['cannotcreatelangdir'] = 'Kan lang map niet maken';
$string['cannotcreateorfindstructs'] = 'Fout bij het vinden of maken van sectiestructuren voor deze cursus';
$string['cannotcreatepopupwin'] = 'Ongedefinieerd element - kan pop-upvenster niet maken';
$string['cannotcreatesitedir'] = 'Kan site map niet maken. De beheerder moet de rechten op de bestanden herstellen';
$string['cannotcreatetempdir'] = 'Kan tijdelijke map niet maken.';
$string['cannotcreateuploaddir'] = 'Kan uploadmap niet maken. De site-beheerder moet de rechten op de mappen herstellen';
$string['cannotcustomisefiltersblockuser'] = 'Je kunt filterinstellingen niet wijzigen in gebruiker- of blokcontexten';
$string['cannotdeletebackupids'] = 'Kon vorige back-upbestanden niet verwijderen.';
$string['cannotdeletecategorycourse'] = 'Cursus \'{$a}\' kon niet verwijderd worden.';
$string['cannotdeletecategoryquestions'] = 'Kon geen vragen verwijderen van categorie \'{$a}\'';
$string['cannotdeletecourse'] = 'Je hebt het recht niet om deze cursus te verwijderen';
$string['cannotdeletecustomfield'] = 'Fout bij het verwijderen van gegevens uit een aangepast veld';
$string['cannotdeletedir'] = 'Kan {$a} niet verwijderen';
$string['cannotdeletefile'] = 'Kan dit bestand niet verwijderen';
$string['cannotdeleterole'] = 'Het kan niet verwijderd worden wegens {$a}';
$string['cannotdeleterolewithid'] = 'Kon de rol met ID {$a} niet verwijderen';
$string['cannotdeletethisrole'] = 'Je kunt deze rol niet verwijderen want die is gebruikt door het systeem of omdat het de laatste rol is met beheerdersmogelijkheden.';
$string['cannotdisableformat'] = 'Je kunt het standaardformaat niet verwijderen';
$string['cannotdownloadcomponents'] = 'Kan componenten niet downloaden.';
$string['cannotdownloadlanguageupdatelist'] = 'Kan de lijst met updates voor taalpakketten niet downloaden van download.moodle.org';
$string['cannotdownloadzipfile'] = 'Kan ZIP-bestand niet downloaden.';
$string['cannoteditcomment'] = 'Je kunt alleen je eigen commentaren bewerken!';
$string['cannoteditcommentexpired'] = 'Je kunt dit niet bewerken. De bewerktijd is voorbij!';
$string['cannoteditpostorblog'] = 'Je kunt geen blogs posten of bewerken.';
$string['cannoteditsiteform'] = 'Je kunt de startpagina niet bewerken met dit formulier';
$string['cannotedituserpreferences'] = 'Kan de gebruikersvoorkeuren niet bewerken';
$string['cannotedityourprofile'] = 'Je kunt je eigen profiel niet bewerken.';
$string['cannotexecduringupgrade'] = 'Kan niet uitgevoerd worden tijdens upgrade';
$string['cannotfindcategory'] = 'Kan geen categorierecord vinden voor databank met ID - {$a}';
$string['cannotfindcomponent'] = 'Kan component niet vinden.';
$string['cannotfindcontext'] = 'Kon context niet vinden';
$string['cannotfindcourse'] = 'Kan cursus niet vinden';
$string['cannotfinddocs'] = 'Kan "{$a}" taal documentatie bestanden niet vinden';
$string['cannotfindgradeitem'] = 'Kan beoordelingsitem niet vinden';
$string['cannotfindgroup'] = 'Kon groep niet vinden';
$string['cannotfindhelp'] = 'Kan "{$a}" taal help bestanden niet vinden';
$string['cannotfindinfo'] = 'Kan geen informatie voor "{$a}" vinden';
$string['cannotfindlang'] = 'Kan taalpakket "{$a}" niet vinden';
$string['cannotfindteacher'] = 'Kon leraar niet vinden';
$string['cannotfinduser'] = 'Kan gebruiker {$a} niet vinden';
$string['cannotgeoplugin'] = 'Kan niet verbinden met de geoPlugin server op http://www.geoplugin.com. Controleer je proxy-instellingen of installeer het MaxMind GeoLite City gegevensbestand';
$string['cannotgetblock'] = 'Kon blokken niet vinden in de databank';
$string['cannotgetcats'] = 'fout bij het ophalen van het categorie record';
$string['cannotgetdata'] = 'Kan gegevens niet ophalen';
$string['cannotgradeuser'] = 'Kan deze gebruiker niet beoordelen';
$string['cannothaveparentcate'] = 'Cursuscategorie kan geen bovenliggende hebben!';
$string['cannotimport'] = 'Importeerfout';
$string['cannotimportformat'] = 'Sorry, het importeren van dit formaat is nog niet geïmplementeerd!';
$string['cannotimportgrade'] = 'Fout bij het importeren van cijfers';
$string['cannotinsertgrade'] = 'Kon geen cijfer toevoegen zonder cursus ID!';
$string['cannotinsertrate'] = 'Kon geen nieuwe beoordeling toevoegen ({$a->id} = {$a->rating})';
$string['cannotinsertrecord'] = 'Kon geen nieuw record ID {$a} toevoegen';
$string['cannotmailconfirm'] = 'Fout bij het versturen van de bevestigingsmail voor het wijzigen van het wachtwoord';
$string['cannotmanualctrack'] = 'Deze activiteit ondersteunt het manueel opvolgen van voltooien niet.';
$string['cannotmapfield'] = 'Koppeling mislukt: 2 velden koppelen naar hetzelfde beoordelingsitem {$a}';
$string['cannotmarktopic'] = 'Kon dat onderdeel voor die cursus niet beoordelen';
$string['cannotmigratedatacomments'] = 'Kan gegevens module notities niet verplaatsen';
$string['cannotmodulename'] = 'Kan de modulenaam niet aan de navigatie toevoegen.';
$string['cannotmoduletype'] = 'Kan het moduletype niet aan de navigatie toevoegen.';
$string['cannotmovecategory'] = 'Kan categorie niet verplaatsen';
$string['cannotmovecourses'] = 'Kan cursussen niet vanuit deze categorie naar een andere verplaatsen.';
$string['cannotmoverolewithid'] = 'Kan rol met ID {$a} niet verplaatsen';
$string['cannotopencsv'] = 'Kan CSV-bestand niet openen';
$string['cannotopenfile'] = 'Kan bestand {$a} niet openen';
$string['cannotopenforwrit'] = 'Kan {$a} niet openen om te schrijven';
$string['cannotopentemplate'] = 'Kan bestand {$a} voor sjabloon niet openen';
$string['cannotopenzip'] = 'kan zip-bestand niet openen - waarschijnlijk zipextentie-bug op 64bit OS';
$string['cannotoverridebaserole'] = 'Kan basis rolmogelijkheden (capabilities) niet overschrijven.';
$string['cannotoverriderolehere'] = 'Je mag deze rol niet overschrijven (id={$a->roleid}) in deze context ({$a->context})';
$string['cannotreadfile'] = 'Kan bestand niet lezen ({$a})';
$string['cannotreadtmpfile'] = 'Fout bij het lezen van het tijdelijk bestand';
$string['cannotreaduploadfile'] = 'Kon geüpload bestand niet lezen';
$string['cannotremovefrommeta'] = 'Kon geselecteerde cursus niet verwijderen uit deze koepelcursus';
$string['cannotreprocessgrades'] = 'Kon cijfers voor deze activiteit niet opnieuw berekenen {$a}';
$string['cannotresetguestpwd'] = 'Je kunt het wachtwoord voor de gast-account niet wijzigen';
$string['cannotresetmail'] = 'Fout bij het opnieuw instellen van je wachtwoord en bij het versturen van de bevestigingsmail daarvoor.';
$string['cannotresetthisrole'] = 'Kan deze rol niet terug op standaardinstellingen zetten';
$string['cannotrestore'] = 'Er is een fout opgetreden en het terugzetten kon niet voltooid worden';
$string['cannotrestoreadminorcreator'] = 'Je moet een cursusaanmaker of beheerder zijn om een back-up te kunnen terugzetten als nieuwe cursus!';
$string['cannotrestoreadminoredit'] = 'Je moet een leraar of beheerder zijn om een back-up te kunnen terugzetten in de gekozen cursus!';
$string['cannotsaveagreement'] = 'Kon je overeenkomst niet bewaren';
$string['cannotsaveblock'] = 'Fout bij het bewaren van de blokconfiguratie';
$string['cannotsavecomment'] = 'Fout bij het bewaren van de notitie';
$string['cannotsavedata'] = 'Kan gegevens niet bewaren';
$string['cannotsavefile'] = 'Kan bestand "{$a}" niet bewaren';
$string['cannotsavemd5file'] = 'Kan md5-bestand niet bewaren.';
$string['cannotsavezipfile'] = 'Kan ZIP-bestand niet bewaren.';
$string['cannotservefile'] = 'Kan bestand niet geven - server configuratieprobleem.';
$string['cannotsetparentforcatoritem'] = 'Kan bovenliggende niet instellen voor de categorie of cursusitem!';
$string['cannotsetpassword'] = 'Kon gebruikerswachtwoord niet instellen!';
$string['cannotsetprefgrade'] = 'Kon de instellingen voor het aggregatiescherm niet voor {$a} niet bewaren voor deze cijfercategorie';
$string['cannotsettheme'] = 'Kon thema niet instellen';
$string['cannotsetupblock'] = 'Bloktabellen konden niet ingesteld worden!';
$string['cannotsetupcapformod'] = 'Kon de mogelijkheden (capabilities) niet instellen voor {$a}';
$string['cannotsetupcapforplugin'] = 'Kon de mogelijkheden (capabilities) niet instellen voor {$a}';
$string['cannotshowhidecoursesincategory'] = 'Kan cursussen in categorie {$a} niet tonen/verbergen';
$string['cannotsignup'] = 'Je kunt geen nieuw account maken want je bent al aangemeld als {$a}.';
$string['cannotunassigncap'] = 'Kon ongebruikte mogelijkheid (capability) {$a->cap} niet wegnemen van rol {$a->role}';
$string['cannotunassignrolefrom'] = 'Kon rol id {$a} niet wegnemen van deze gebruiker';
$string['cannotunzipfile'] = 'Kon bestand niet unzippen';
$string['cannotupdatemod'] = 'Kon {$a} niet updaten';
$string['cannotupdatepasswordonextauth'] = 'Updaten van het wachtwoord op extern systeem {$a} mislukt. Bekijk de serverlogs voor meer details.';
$string['cannotupdateprofile'] = 'Fout bij het aanpassen van de gebruiker';
$string['cannotupdaterecord'] = 'Kon record ID {$a} niet updaten';
$string['cannotupdaterss'] = 'Kan RSS niet updaten';
$string['cannotupdatesubcourse'] = 'Kon onderliggende cursus niet updaten!';
$string['cannotupdateusermsgpref'] = 'Kan de voorkeursinstelligen voor berichten niet aanpassen';
$string['cannotupdateuseronexauth'] = 'Fout bij het updaten van de gebruikersgegeven op de externe authenticatie: {$a}. Zie serverlogs voor meer details.';
$string['cannotuploadfile'] = 'fout bij het verwerken van het geüploade bestand';
$string['cannotuseadmin'] = 'Je moet beheerder zijn om deze pagina te mogen gebruiken.';
$string['cannotuseadminadminorteacher'] = 'Je moet leraar of beheerder zijn om deze pagina te mogen gebruiken.';
$string['cannotusepage'] = 'Alleen leraren en beheerders mogen deze pagina gebruiken';
$string['cannotusepage2'] = 'Deze pagina mag jij niet gebruiken.';
$string['cannotviewprofile'] = 'Je kan het profiel van deze gebruiker niet bekijken.';
$string['cannotviewreport'] = 'Je kunt dit rapport niet zien';
$string['cannotwritefile'] = 'Kan bestand niet wegschrijven ({$a})';
$string['categoryerror'] = 'Categoriefout';
$string['categoryidnumbertaken'] = 'ID-nummer is al in gebruik voor een andere categorie';
$string['categorynamerequired'] = 'Categorienaam is vereist';
$string['categorytoolong'] = 'Categorienaam te lang';
$string['commentmisconf'] = 'Commentaar ID is slecht geconfigureerd';
$string['componentisuptodate'] = 'Component is up-to-date';
$string['confirmationnotenabled'] = 'Gebruiker bevestigen is niet ingeschakeld op deze site';
$string['confirmsesskeybad'] = 'Je sessiesleutel om deze actie uit te voeren kon niet bevestigd worden. Deze beveiligingsfunctie verhindert dat er per ongeluk of met verkeerde bedoelingen belangrijke functies in jouw naam uitgevoerd kunnen worden. Bedenk goed of je deze opdracht wel echt wou uitvoeren.';
$string['couldnotassignrole'] = 'Er gebeurde een ernstige maar niet gespecifieerde fout tijdens het proberen toewijzen van een rol aan jou.';
$string['couldnotupdatenoexistinguser'] = 'Kan deze gebruiker niet updaten - gebruiker bestaat niet';
$string['couldnotverifyagedigitalconsent'] = 'Er is een fout opgetreden bij het verifiëren van de digitale meerderjarigheid.<br />Neem contact op met de sitebeheerder.';
$string['countriesphpempty'] = 'Fout: Het bestand countries.php in taalpakket {$a} is leeg of ontbreekt.';
$string['coursedoesnotbelongtocategory'] = 'De cursus behoort niet tot deze categorie';
$string['courseformatnotfound'] = 'De cursusformat \'{$a}\' bestaat niet of wordt niet herkend';
$string['coursegroupunknown'] = 'De cursus die met groep {$a} overeenkomt is niet gespecifieerd';
$string['courseidnotfound'] = 'Cursus ID bestaat niet';
$string['courseidnumbertaken'] = 'IDnummer is al in gebruik voor een andere cursus: ({$a})';
$string['coursemisconf'] = 'Cursus isslecht geconfigureerd';
$string['courserequestdisabled'] = 'Het aanvragen van nieuwe cursussen is uitgeschakeld door de beheerder.';
$string['csvcolumnduplicates'] = 'Duplicate kolommen gevonden';
$string['csvemptyfile'] = 'Het CVS-bestand is leeg';
$string['csvfewcolumns'] = 'Onvoldoende kolommen. Controleer de instelling voor het scheidingsteken.';
$string['csvinvalidcols'] = '<b>ONGELDIG CSV BESTAND:</b> De eerste lijn moet de kolomkoppen bevatten en het bestand moet van het type <br />"Expanded Fields/Comma Separated"<br />of<br /> "Expanded Fields with CAVV Result Code/Comma Separated" zijn';
$string['csvinvalidcolsnum'] = 'ONGELDIG CSV BESTAND; Elke lijn moet 49 of 70 velden hebben';
$string['csvloaderror'] = 'Fout tijdens het laden van het CSV-bestand: {$a}';
$string['csvweirdcolumns'] = 'Ongeldige CSV bestandsopmaak - aantal kolommen is niet constant!';
$string['dbconnectionfailed'] = '<p>Fout: Databank connectie mislukt.</p>
<p>Het is mogelijk dat de databank overbelast is of niet goed loopt.</p>
<p>De site-beheerder zou ook moeten controleren of de databankgegevens correct staan ingevuld in config.php</p>';
$string['dbdriverproblem'] = '<p>Fout: een databank driver probleem detecteerd</p>
<p>De site beheerder zou de serverconfiguratie moeten controleren</p><p>{$a}</p>';
$string['dbsessionbroken'] = 'Ernstig databank sessieprobleem gevonden.<br /><br />Waarschuw de serverbeheerder.';
$string['dbsessionhandlerproblem'] = 'Het opzetten van je databanksessie is mislukt. Waarschuw de serverbeheerder';
$string['dbsessionmysqlpacketsize'] = 'Ernstigge sessiefout gedetecteerd. Waarschuw de beheerder. Dit probleem wordt waarschijnlijk veroorzaakt door een te kleine waarde in de max_allowed_packet MySQL-instelling.';
$string['dbupdatefailed'] = 'Update van de databank mislukt';
$string['ddldependencyerror'] = '{$a->targettype} "{$a->targetname}" kan niet gewijzigd worden. Afhankelijkheid gevonden van {$a->offendingtype} "{$a->offendingname}"';
$string['ddlexecuteerror'] = 'DDL sql uitvoeringsfout';
$string['ddlfieldalreadyexists'] = 'Veld "{$a}" bestaat al';
$string['ddlfieldnotexist'] = 'Veld "{$a->fieldname}" bestaat niet in tabel "{$a->tablename}"';
$string['ddltablealreadyexists'] = 'Tabel "{$a}" bestaat al';
$string['ddltablenotexist'] = 'Tabel "{$a}" bestaat niet';
$string['ddlunknownerror'] = 'Onbekende DLL-bibliotheekfout';
$string['ddlxmlfileerror'] = 'XML databankbestandsfouten gevonden';
$string['ddsequenceerror'] = 'Foute tabeldefinitie "{$a}"; er kan slechts één auto kolom zijn en die moet als sleutel gedefinieerd worden.';
$string['destinationcmnotexit'] = 'De bestemde cursusmodule bestaat niet';
$string['detectedbrokenplugin'] = 'Plugin "{$a}" werkt niet of is verouderd. Kan niet verder gaan.';
$string['dmlexceptiononinstall'] = '<p>Databankfout [{$a->errorcode}].<br />{$a->debuginfo}</p>';
$string['dmlreadexception'] = 'Fout bij het lezen van de databank';
$string['dmltransactionexception'] = 'Databank transactiefout';
$string['dmlwriteexception'] = 'Fout bij het schrijven van de databank';
$string['downgradedcore'] = 'Fout: de code die je gebruikt is ouder dan de versie die deze databank heeft gemaakt!';
$string['downloadedfilecheckfailed'] = 'Controle van het gedownloade bestand mislukt';
$string['duplicatefieldname'] = 'Dubbele veldnaam "{$a}" gevonden';
$string['duplicatenosupport'] = '\'{$a->modname}\' activiteit kon niet gekopieerd worden omdat de {$a->modtype} module geen back-up en restore ondersteunt.';
$string['duplicateparaminsql'] = 'FOUT: dubbele parameternaam in query';
$string['duplicaterolename'] = 'Er is al een rol met die naam!';
$string['duplicateroleshortname'] = 'Er is al een rol met deze korte naam!';
$string['duplicateusername'] = 'Gebruikersnaam bestaat al - record genegeerd';
$string['emailfail'] = 'E-mailen mislukt';
$string['enddatebeforestartdate'] = 'De cursuseinddatum moet later zijn de startdatum.';
$string['error'] = 'Er is een fout opgetreden';
$string['error_question_answers_missing_in_db'] = 'Kon geen antwoord vinden dat overeenkomt met "{$a->answer}" in de question_answers database tabel. Dit gebeurde tijdens het terugzetten van de vraag met ID  {$a->filequestionid}  in het back-upbestand, dat overeenkomt met de bestaande vraag met id {$a->dbquestionid} in de databank.';
$string['errorcleaningdirectory'] = 'Fout bij het opkuisen van map "{$a}"';
$string['errorcopyingfiles'] = 'Fout bij het kopiëren van bestanden';
$string['errorcreatingdirectory'] = 'Fout bij het maken van map "{$a}"';
$string['errorcreatingfile'] = 'Fout bij het maken van bestand "{$a}"';
$string['errorcreatingrole'] = 'Fout bij het aanmaken van de rol';
$string['errorfetchingrssfeed'] = 'RSS-feed ophalen mislukt';
$string['erroronline'] = 'Fout op lijn {$a}';
$string['erroroutput'] = 'Foute output, de automatische verwijzing wordt uitgeschakeld.';
$string['errorparsingxml'] = 'Fout bij het verwerken van XML: {$a->errorstring} op lijn {$a->errorline}, char {$a->errorchar}';
$string['errorprocessingarchive'] = 'Fout bij het verwerken van het archiefbestand';
$string['errorreadingfile'] = 'Fout bij het lezen van bestand "{$a}"';
$string['errorsavingrequest'] = 'Er is een fout opgetreden bij het bewaren van je vraag';
$string['errorsettinguserpref'] = 'Fout bij het instellen van gebruikersvoorkeuren';
$string['errorunzippingfiles'] = 'Fout bij het uitpakken van bestanden';
$string['expiredkey'] = 'Verlopen sleutel';
$string['externalauthpassworderror'] = 'Niet-blanco wachtwoord voor externe authenticatie';
$string['externalfilenolocation'] = 'Extern bestand heeft geen locatiepad';
$string['failtoloadblocks'] = 'Er zijn één of meer blokken geregistreerd in de databank, maar geen enkele kan geladen worden!';
$string['fieldrequired'] = '"{$a}" is een vereist veld';
$string['fileexists'] = 'Bestand bestaat';
$string['filemismatch'] = 'Non-core bestandsnaam fout. Het bestand "{$a->current}" zou {$a->file} moeten zijn';
$string['filenotfound'] = 'Het gevraagde bestand is niet gevonden';
$string['filenotreadable'] = 'Bestand niet leesbaar';
$string['filterdoesnothavelocalconfig'] = 'De filter {$a} kan niet lokaal geconfigureerd worden';
$string['filternotactive'] = 'Filter {$a} is momenteel niet actief';
$string['filternotenabled'] = 'Filter niet ingeschakeld!';
$string['filternotinstalled'] = 'Filter {$a} is momenteel niet geïnstalleerd';
$string['forumblockingtoomanyposts'] = 'Je hebt het maximale aantal berichten voor dit forum bereikt.';
$string['generalexceptionmessage'] = 'Uitzondering - {$a}';
$string['gradecantregrade'] = 'Er is een fout gebeurd tijdens het berekenen van de cijfers: {$a}';
$string['gradepubdisable'] = 'Het publiceren van cijfers is uitgeschakeld';
$string['gradesneedregrading'] = 'De cursuscijvers moeten herberekend worden';
$string['groupalready'] = 'Deze gebruiker behoort al tot groep {$a}';
$string['groupexistforcourse'] = 'Groep "{$a}" bestaat al in deze cursus';
$string['groupexistforcoursewithidnumber'] = '{$a->problemgroup}: Groep "{$a->name}" met ID number  "{$a->idnumber}" bestaat al in deze cursus';
$string['grouphasidnumber'] = 'Groep "{$a}" heeft een ID nummer en dat kan automatisch gegenereerd zijn door een extern systeem. Je hebt het recht niet om deze groep te verwijderen';
$string['groupinghasidnumber'] = 'Groepering "{$a}" heeft een ID nummer en dat kan automatisch gegenereerd zijn door een extern systeem. Je hebt het recht niet om deze groepering te verwijderen';
$string['groupingnotaddederror'] = 'Groupering "{$a}" niet toegevoegd';
$string['groupnotaddederror'] = 'Groep "{$a}" is niet toegevoegd';
$string['groupnotaddedtogroupingerror'] = 'Groep "{$a->groupname}" niet toegevoegd aan groepering "{$a->groupingname}"';
$string['groupunknown'] = 'Groep {$a} is niet geassocieerd met de gespecifieerde groep';
$string['groupusernotmember'] = 'Gebruiker is geen lid van deze groep.';
$string['guestcantaccessprofiles'] = 'Gasten hebben geen toegang tot gebruikersprofielen. Log in met een volwaardige gebruikersaccount om verder te gaan.';
$string['guestnocomment'] = 'Gasten mogen geen commentaren posten!';
$string['guestnoeditprofile'] = 'De gastgebruiker kan zijn profiel niet wijzigen';
$string['guestnoeditprofileother'] = 'Het profiel van de gastgebruiker kan niet gewijzigd worden';
$string['guestnorate'] = 'Gasten mogen geen items beoordelen.';
$string['guestsarenotallowed'] = 'Niet toegelaten voor de gastgebruiker';
$string['hackdetected'] = 'Hackersaanval gedetecteerd!';
$string['hashpoolproblem'] = 'Foute inhoud pool-bestand {$a}.';
$string['headersent'] = 'Headers al verzonden';
$string['idnumbertaken'] = 'Dit ID-nummer is al in gebruik';
$string['idnumbertoolong'] = 'ID nummer is te lang';
$string['importformatnotimplement'] = 'Het importeren van dit bestandsforaat is nog niet geïmplementeerd.';
$string['incorrectext'] = 'Bestand heeft een verkeerde extentie';
$string['inplaceeditableerror'] = 'Fout bij het updaten van de processor';
$string['installproblem'] = 'Het is gewoonlijk niet mogelijk om fouten te herstellend die tijdens een installatie opgetreden zijn. Je kunt best een nieuwe database maken of een ander tabelprefix gebruiken als je de installatie opnieuw wil proberen.';
$string['internalauthpassworderror'] = 'Ontbrekend wachtwoord of ongeldig wachtwoordbeleid voor interne authenticatie';
$string['invalidaccess'] = 'Deze pagina is niet correct opgevraagd';
$string['invalidaccessparameter'] = 'Foute toegangsparameter';
$string['invalidaction'] = 'Foute actieparameter';
$string['invalidactivityid'] = 'Ongeldig activiteits ID';
$string['invalidadminsettingname'] = 'Foute beheerinstelling ({$a})';
$string['invalidargorconf'] = 'Er werden geen geldige argumenten doorgegeven voor deze serverconfiguratie';
$string['invalidarguments'] = 'Geen geldige argumenten doorgegeven';
$string['invalidblockinstance'] = 'Ongeldige blokinstantie voor: {$a}';
$string['invalidbulkenrolop'] = 'Ongeldige bulk aanmeldingsoperatie gevraagd.';
$string['invalidcategory'] = 'Categorie ID fout';
$string['invalidcategoryid'] = 'Foute categorie ID';
$string['invalidcomment'] = 'Commentaar is fout';
$string['invalidcommentarea'] = 'Ongeldige commentaarzone';
$string['invalidcommentid'] = 'Ongeldige commentaarID';
$string['invalidcommentitemid'] = 'Ongeldig commentaar itemID';
$string['invalidcommentparam'] = 'Ongeldige commentaarparameters';
$string['invalidcomponent'] = 'Ongeldige componentnaam';
$string['invalidconfirmdata'] = 'Ongeldige bevestingingsgegevens';
$string['invalidcontext'] = 'Context is niet geldig';
$string['invalidcourse'] = 'Ongeldige cursus';
$string['invalidcourseformat'] = 'Ongeldig cursusformaat';
$string['invalidcourseid'] = 'Je probeert een ongeldig cursus ID te geven';
$string['invalidcourselevel'] = 'Contextniveau niet juist';
$string['invalidcoursemodule'] = 'Cursus module ID niet juist';
$string['invalidcoursenameshort'] = 'Korte cursusnaam niet geldig';
$string['invaliddata'] = 'Ingestuurde gegevens niet geldig.';
$string['invaliddatarootpermissions'] = 'Ongeldige rechten gevonden tijdens het maken van een map. Schakel foutopsporing aan om meer details te krijgen.';
$string['invaliddevicetype'] = 'Ongeldig toesteltype';
$string['invalidelementid'] = 'Element ID niet geldig';
$string['invalidentry'] = 'Dit is niet geldig';
$string['invalidevent'] = 'Ongeldige gebeurtenis';
$string['invalidfieldname'] = '"{$a}" is geen geldige veldnaam';
$string['invalidfiletype'] = '"{$a}" is geen geldig bestandstype';
$string['invalidformatpara'] = 'Verkeerde format voor gekozen parameter';
$string['invalidformdata'] = 'Foute formuliergegevens';
$string['invalidfunction'] = 'Foute functie';
$string['invalidgradeitemid'] = 'Fout cijferitem ID';
$string['invalidgroupid'] = 'Foute groep ID opgegeven.';
$string['invalidipformat'] = 'IP-adres heeft een ongeldige vorm';
$string['invaliditemid'] = 'Fout item ID';
$string['invalidkey'] = 'Foute sleutel';
$string['invalidlegacy'] = 'Ongeldige verouderde roldefinitie voor type :{$a}';
$string['invalidmd5'] = 'De controlevariable was fout - probeer nog eens';
$string['invalidmode'] = 'Ongeldige modus ({$a})';
$string['invalidmodule'] = 'Ongeldige module';
$string['invalidmoduleid'] = 'Ongeldige module ID: {$a}';
$string['invalidmodulename'] = 'Ongeldige modulenaam: {$a}';
$string['invalidnum'] = 'Ongeldige numerieke waarde';
$string['invalidnumkey'] = '$conditions array mag geen nummerieke sleutels bevatten. Verbeter de code!';
$string['invalidoutcome'] = 'Ongeldig competentie ID';
$string['invalidpagesize'] = 'Ongeldige paginagrootte';
$string['invalidpasswordpolicy'] = 'Ongeldig wachtwoordbeleid';
$string['invalidpaymentmethod'] = 'Ongeldige betalingsmetode: {$a}';
$string['invalidqueryparam'] = 'FOUT: Fout aantal queryparameters. Verwachte {$a->expected} en heb {$a->actual} gekregen';
$string['invalidratingarea'] = 'Ongeldige beoordelingszone';
$string['invalidrecord'] = 'Kan gegevensrecord niet vinden in databanktabel {$a}';
$string['invalidrecordunknown'] = 'Kan gegevensrecord niet vinden in de databank.';
$string['invalidrequest'] = 'Ongeldige vraag';
$string['invalidrole'] = 'Ongeldige rol';
$string['invalidroleid'] = 'Ongeldige rol ID';
$string['invalidscaleid'] = 'Ongeldige schaal ID';
$string['invalidsection'] = 'Cursusmodulerecord bevat ongeldige sectie';
$string['invalidsesskey'] = 'Je sessie is waarschijnlijk verlopen. Opnieuw inloggen aub.';
$string['invalidshortname'] = 'Dat is een ongeldig korte cursusnaam';
$string['invalidsourcefield'] = 'Het bronveld van het kladbestand is niet geldig';
$string['invalidstatedetected'] = 'Er ging wat fout: {$a}. Dit zou normaal niet mogen gebeuren';
$string['invalidurl'] = 'Ongeldige url';
$string['invaliduser'] = 'Ongeldige gebruiker';
$string['invaliduserdata'] = 'Ingeldige gebruikersgegevens: {$a}';
$string['invaliduserfield'] = 'Ongeldig gebruikersveld: {$a}';
$string['invaliduserid'] = 'Ongeldig gebruikersID';
$string['invalidusername'] = 'De opgegeven gebruikersnaam bevat ongeldige tekens.';
$string['invalidusernameblank'] = 'De gebruikersnaam mag niet leeg zijn';
$string['invalidxmlfile'] = '"{$a}" is geen geldig XML-bestand';
$string['iplookupfailed'] = 'Kan de geografische informatie voor het IP-adres {$a} niet vinden.';
$string['iplookupprivate'] = 'Over een privaat IP-adres kan geen informatie gevonden worden';
$string['ipmismatch'] = 'Client IP klopt niet';
$string['listcantmovedown'] = 'Kon het item niet naar omlaag verschuiven - het is het laatste item op hetzelfde niveau.';
$string['listcantmoveleft'] = 'Kon het item niet naar links verschuiven - het heeft geen bovenliggend item.';
$string['listcantmoveright'] = 'Kon het item niet naar rechts verschuiven - er is geen item op hetzelfde niveau om het ondergeschikt aan te maken. Verschuif het omlaag en probeer dan nogmaals naar rechts te verplaatsen.';
$string['listcantmoveup'] = 'Kon het item niet naar boven verplaatsen - het is het eerste item van dit niveau.';
$string['listnochildren'] = 'Geen onderliggende items gevonden.';
$string['listnoitem'] = 'Item niet gevonden.';
$string['listnopeers'] = 'Geen items op hetzelfde niveau gevonden';
$string['listupdatefail'] = 'Databankoperatie mislukt bij het aanpassen  van de hiërarchie van de lijst.';
$string['logfilenotavailable'] = 'Logs niet beschikbaar';
$string['loginasnoenrol'] = 'Je kunt aanmelden en afmelden bij een cursus niet gebruiken wanneer je met een "Login als"-sessie een cursus bekijkt.';
$string['loginasonecourse'] = 'Je kunt deze cursus niet openen.<br />Je moet je "Login als"-sessie beëindigen voor je een andere cursus opent.';
$string['maxareabytes'] = 'Het bestand is groter dan de beschikbare plaats.';
$string['maxbytesfile'] = 'Het bestand {$a->file} is te groot. De maximale grootte die je kunt uploaden is {$a->size}.';
$string['maxdraftitemids'] = 'Door het uploaden van een grote hoeveelheid bestanden, is je bestandsupload tijdelijk beperkt. Probeer opnieuw binnen enkele seconden.';
$string['messagingdisable'] = 'Berichten zijn uitgeschakeld op deze site';
$string['mimetexisnotexist'] = 'Je systeem is niet geconfigureerd om mimeTeX te gebruiken. Je moet de noodzakelijke C broncode downloaden van  <a href="http://www.forkosh.com/mimetex.zip">http://www.forkosh.com/mimetex.zip</a>, compileren en uit uitvoerbaar bestand zetten in je moodle/filter/tex/ map.';
$string['mimetexnotexecutable'] = 'Aangepast mimetex bestand is niet uitvoerbaar!';
$string['missing_moodle_backup_xml_file'] = 'Het XML-bestand {$a} ontbreekt in de back-up';
$string['missingfield'] = 'Veld "{$a}" ontbreekt';
$string['missingkeyinsql'] = 'FOUT: ontbrekende param "{$a}" in query';
$string['missingparam'] = 'Een vereiste parameter ({$a}) ontbreekt';
$string['missingparameter'] = 'Ontbrekende parameter';
$string['missingrequiredfield'] = 'Vereist veld ontbreekt';
$string['missinguseranditemid'] = 'Ontbrekende gebruikers ID en item ID';
$string['missingvarname'] = 'Vereiste variable ontbreekt!';
$string['mixedtypesqlparam'] = 'FOUT: gemengde types sql query parameters!';
$string['mnetdisable'] = 'MNET is uitgeschakeld';
$string['mnetlocal'] = 'Externe MNET gebruikers kunnen niet lokaal aanmelden.';
$string['moduledisable'] = 'Deze module ({$a}) is voor deze cursus uitgeschakeld';
$string['moduledoesnotexist'] = 'Deze module bestaat niet';
$string['moduleinstancedoesnotexist'] = 'De instantie van deze module bestaat niet';
$string['modulemissingcode'] = 'De code die nodig is om deze functie uit te voeren ontbreekt in module {$a}.';
$string['movecatcontentstoroot'] = 'De categorie-inhoud naar root verplaatsen is niet toegestaan. Je moet de inhoud naar een bestaande categorie verplaatsen!';
$string['movecategorynotpossible'] = 'Je kunt categorie \'{$a}\' niet naar de geselecteerde categorie verplaatsen.';
$string['movecategoryownparent'] = 'Je kunt categorie \'{$a}\' geen bovenliggende categorie van zichzelf maken.';
$string['movecategoryparentconflict'] = 'Je kunt categorie \'{$a}\' geen subcategorie maken van één van zijn eigen subcategorieën.';
$string['mssqlrcsmodemissing'] = 'De databank gebruikt de verwachte READ_COMMITTED_SNAPSHOT niet, wat kan leiden tot foute resultaten, zeker onder hoge belasting. Schakel het in om juist gedrag van de databank te verzekeren. Kijk voor meer informatie in de documentatie op <a href="https://docs.moodle.org/en/Installing_MSSQL_for_PHP">Installing MSSQL for PHP</a>.';
$string['multiplerecordsfound'] = 'Meerdere records gevonden, slechts één verwacht.';
$string['multiplerestorenotallow'] = 'Het meer dan eens uitvoeren van terugplaatsen is hier niet toegelaten!';
$string['mustbeloggedin'] = 'Je moet aangemeld zijn om dit te doen';
$string['mustbeteacher'] = 'Je moet leraar zijn om deze pagina te mogen bekijken.';
$string['myisamproblem'] = 'Je databanktabellen gebruiken MyISAM. Er wordt aangeraden om een ACID engine met transactie-ondersteuning te gebruiken, zoals InnoDB';
$string['needcopy'] = 'Je moet eerst iets kopiëren';
$string['needcoursecategroyid'] = 'Ofwel de cursus ID of de categorie moet opgegeven worden';
$string['needphpext'] = 'Je moet {$a} -ondersteuning toevoegen aan je PHP-installatie';
$string['noadmins'] = 'Geen beheerders!';
$string['noblocks'] = 'Geen blokken gevonden!';
$string['nocapabilitytousethisservice'] = 'De gebruiker heeft niet de juiste mogelijheden voor deze service';
$string['nocategorydelete'] = 'Categorie \'{$a}\' kan niet verwijderd worden!';
$string['nocontext'] = 'Sorry, maar deze cursus is geen geldige omgeving';
$string['nodata'] = 'Geen gegevens';
$string['noexistingcategory'] = 'Categorie bestaat niet';
$string['nofile'] = 'Bestand niet gespecifieerd';
$string['nofiltersenabled'] = 'Er zijn geen filters ingeschakeld';
$string['nofolder'] = 'De gevraagde map bestaat niet.';
$string['noformdesc'] = 'Geen formslib formulierbeschrijving gevonden voor deze activiteit.';
$string['noguest'] = 'Geen gasten hier!';
$string['noinstances'] = 'Er is niets te vinden van {$a} in deze cursus!';
$string['nologinas'] = 'Je hebt het recht niet om in te loggen als die gebruiker';
$string['nonmeaningfulcontent'] = 'Geen zinnige inhoud';
$string['noparticipants'] = 'Geen gebruikers gevonden in deze cursus';
$string['noparticipatorycms'] = 'Sorry, maar je hebt geen vereiste cursusmodules om over te rapporteren';
$string['nopermissions'] = 'Sorry, maar je hebt nu niet het recht om dat te doen ({$a}).';
$string['nopermissiontocomment'] = 'Je kunt geen commentaren toevoegen in deze woordenlijst';
$string['nopermissiontodelentry'] = 'Je kunt wat anderen ingevoerd hebben niet verwijderen!';
$string['nopermissiontoeditcomment'] = 'Je kunt de commentaren van anderen niet bewerken!';
$string['nopermissiontohide'] = 'Geen toelating om te verbergen';
$string['nopermissiontoimportact'] = 'Je hebt niet de juiste rechten om activiteiten in deze cursus te importeren';
$string['nopermissiontolock'] = 'Geen toelating om te blokkeren';
$string['nopermissiontomanagegroup'] = 'Je hebt niet de juiste rechten om groepen te beheren.';
$string['nopermissiontorate'] = 'Het beoordelen van items niet toegelaten!';
$string['nopermissiontoshow'] = 'Geen rechten om dit te zien!';
$string['nopermissiontounlock'] = 'Geen rechten om blokkering op te heffen!';
$string['nopermissiontoupdatecalendar'] = 'Je hebt niet het recht om kalenderactiviteiten aan te passen';
$string['nopermissiontoviewgrades'] = 'Kan cijfers niet zien';
$string['nopermissiontoviewletergrade'] = 'Geen rechten om letterbeoordelingen te zien';
$string['nopermissiontoviewpage'] = 'Je hebt niet het recht om deze pagina te bekijken';
$string['nosite'] = 'Kon geen topniveau cursus vinden';
$string['nositeid'] = 'Geen site ID';
$string['nostartdatenoenddate'] = 'Een cursuseinddatum kan alleen worden ingesteld als een begindatum ook is ingesteld.';
$string['nostatstodisplay'] = 'Er zijn geen gegevens om te tonen.';
$string['notallowedtoupdateprefremotely'] = 'Je mag deze gebruikersvoorkeuren niet van op afstand updaten';
$string['notavailable'] = 'Dat is nu niet beschikbaar';
$string['notlocalisederrormessage'] = '{$a}';
$string['notmemberofgroup'] = 'Je bent geen lid van deze cursusgroep';
$string['notownerofkey'] = 'Je bent niet de eigenaar van deze sleutel';
$string['nousers'] = 'Ken deze gebruiker niet!';
$string['oauth1accesstoken'] = 'OAuth 1.0-fout: we kregen geen "access stoken".';
$string['oauth1requesttoken'] = 'OAuth 1.0-fout: we kregen geen "request token". De serviceprovider zou kunnen tijdelijk onbereikbaar zijn.';
$string['onlyadmins'] = 'Enkel beheerders mogen dit doen.';
$string['onlyeditingteachers'] = 'Alleen leraren met het recht om te wijzigen kunnen dit doen';
$string['onlyeditown'] = 'Je kunt enkel je eigen informatie bewerken';
$string['orderidnotfound'] = 'Order ID {$a} niet gevonden';
$string['pagenotexist'] = 'Er is een ongewone fout gebeurd (het proberen te bereiken van een pagina die niet bestaat)';
$string['pathdoesnotstartslash'] = 'Geen geldig argumentenpad opgegeven, het pad begint niet met een schuine streep!';
$string['pleasereport'] = 'Probeer tijd te maken om ons te laten weten wat je probeerde te doen toen de fout gebeurde.';
$string['pluginrequirementsnotmet'] = 'Plugin "{$a->pluginname}" ({$a->pluginversion}) kon niet geïnstalleerd worden. Er is een nieuwere versie van Moodle nodig (je gebruikt nu {$a->currentmoodle} en je hebt {$a->requiremoodle} nodig).';
$string['prefixcannotbeempty'] = '<p>Fout: databank tabel prefix kan niet leeg zijn ({$a})</p>
<p>De site-beheerder moet dit probleem oplossen.</p>';
$string['prefixtoolong'] = '<p>Fout: databank tabel prefix is te lang ({$a->dbfamily})</p>
<p>De site-beheerder moet dit probleem oplossen. De maximale lengte voor de tabelprefix in {$a->dbfamily} is {$a->maxlength} tekens.</p>';
$string['privatefilesupload'] = 'Rechtstreeks uploaden naar privé-bestanden van een gebruiker wordt niet meer ondersteund. Upload naar een ontwerp-zone en verplaats de bestanden dan met core_user::add_user_private_files';
$string['processingstops'] = 'Verwerking stopt hier. De overgebleven records worden genegeerd';
$string['protected_cc_not_supported'] = 'Protected cartridge niet ondersteund.';
$string['querystringcannotbeempty'] = 'De query string kan niet leeg zijn.';
$string['redirecterrordetected'] = 'Niet-ondersteunde verwijzing gevonden. De uitvoering van het script is gestopt.';
$string['refoundto'] = 'Kan teruggegeven worden aan {$a}';
$string['refoundtoorigi'] = 'Teruggegeven op oorspronkelijke hoeveelheid: {$a}';
$string['registrationdisabled'] = 'Registratie is uitgeschakeld op deze site';
$string['remotedownloaderror'] = '<p>De download van de component naar jouw server is mislukt, controleer je proxy-instellingen, de PHP cURL-extentie wordt ten zeerste aanbevolen te installeren.</p><p>Je moet je <a href="{$a->url}">{$a->url}</a> bestand manueel downloaden , kopiëren naar de map "{$a->dest}" op je server en het daar unzippen.</p>';
$string['remotedownloadnotallowed'] = 'Het downloaden van componenten naar je server is niet toegelaten (allow_url_fopen is uitgeschakeld)<br /><br />Je moet het <a href="{$a->url}">{$a->url}</a>bestand manueel downloaden en het kopiëren naar "{$a->dest}" op je server en het daar unzippen.';
$string['reportnotavailable'] = 'Dit type rapport is alleen maar beschikbaar voor de site-cursus';
$string['requirecorrectaccess'] = 'Ongeldige URL of poort';
$string['requireloginerror'] = 'Geen toegang tot de cursus of activiteit';
$string['restore_path_element_missingmethod'] = 'De methode voor terugzetten {$a} ontbreekt. Die moet gedefinieerd worden door een ontwikkelaar.';
$string['restore_path_element_noobject'] = 'Het terug te zetten object {$a} is geen object';
$string['restorechecksumfailed'] = 'Er zijn problemen met de informatie over het terugzetten, bewaard in jouw sessie. Controleer je PHP geheugenlimiet en je DB pakketgroottelimiet. Terugzetten gestopt.';
$string['restrictedcontextexception'] = 'Het uitvoeren van externe functies schendt de beperkingen van de context';
$string['restricteduser'] = 'Sorry, maar je huidige account "{$a}" heeft onvoldoende rechten om dat te doen.';
$string['reverseproxyabused'] = 'Reverse proxy ingeschakeld. Er is geen rechtstreekse toegang tot de server mogelijlk. Contacteer de systeembeheerder.';
$string['rpcerror'] = 'Je MNET-communicatie is mislukt. Geef deze foutmelding door aan je site-beheerder:({$a})';
$string['scheduledbackupsdisabled'] = 'Automatische back-ups zijn uitgeschakeld door de site-beheerder';
$string['secretalreadyused'] = '"Wijzig wachtwoord bevestigingslink" is al gebruikt, het wachtwoord is niet gewijzigd';
$string['sectionnotexist'] = 'Deze sectie bestaat niet';
$string['sendmessage'] = 'Stuur bericht';
$string['serverconnection'] = 'Fout bij het verbinden met de server';
$string['servicedonotexist'] = 'De service bestaat niet';
$string['sessioncookiesdisable'] = 'Fout gebruik van require_key_login() - sessie cookies moet uitgeschakeld worden!';
$string['sessiondiskfull'] = 'De sessiepartitie is vol. Het is nu niet mogelijk om aan te melden. Waarschuw de systeembeheerder.';
$string['sessionerroruser'] = 'Je sessie bleef te lang zonder activiteit. Je moet opnieuw inloggen.';
$string['sessionerroruser2'] = 'Een serverfout die heeft Je loginsessie verknoeid. Meld je opnieuw aan of herstart je browser.';
$string['sessionhandlerproblem'] = 'Sessieafhandeling is fout geconfigureerd';
$string['sessionipnomatch'] = 'Sorry, maar je IP-adres is gewijzigd sinds je aangemeld bent. Deze beveiligingsmethode voorkomt dat crackers je identiteit stelen terwijl je aangemeld bent op deze site. Gewone gebruikers zouden deze melding niet mogen zien - vraag je sitebeheerder om hulp.';
$string['sessionipnomatch2'] = '<p>Je IP-nummer is blijkbaar gewijzigd sinds je login. Deze beveiligingsfunctie verhindert dat crackers je identiteit stelen terwijl je aangemeld bent bij deze site. Je kunt deze melding zien als je draadloze netwerken gebruikt of als je schakelt tussen verschillende netwerken. Vraag de sitebeheerder om hulp.</p><p>Als je wil verder gaan, klik dan op F5 om deze pagina te verversen.</p>';
$string['sessionwaiterr'] = 'Time out tijdens het wachten op sessie slot.<br />. Wacht tot je huidige aanvragen afgelopen zijn en probeer later opnieuw.';
$string['shortnametaken'] = 'Deze korte naam wordt al gebruikt voor een andere cursus ({$a})';
$string['sitepolicynotagreed'] = 'Niet eens met het website-beleid: <a href="{$a}" Klik hier om het website-beleid te openen </a>.';
$string['socksnotsupported'] = 'SOCKS5-proxy wordt niet ondersteund in PHP4';
$string['spellcheckernotconf'] = 'Spellingscontrole niet geconfigureerd';
$string['sslonlyaccess'] = 'Voor veiligheidsredenen zijn enkel https-connecties toegelaten.';
$string['statscatchupmode'] = 'De statistiekfunctie is nu wat achterstand aan het inhalen. Tot nu zijn al {$a->daysdone} dagen verwerkt en zijn er nog {$a->dayspending} dagen te doen. Kom later eens terug kijken!';
$string['statsdisable'] = 'Statistieken niet ingeschakeld.';
$string['statsnodata'] = 'Er zijn geen gegevens beschikbaar voor die combinatie van cursus en periode';
$string['storedfilecannotcreatefile'] = 'Kan geen lokaal bestandspoolbestand aanmaken, controleer of de rechten in dataroot juist staan en of er genoeg schijfruimte op de server is.';
$string['storedfilecannotcreatefiledirs'] = 'Kon geen locale bestandspoolmappen maken. Controleer de rechten in dataroot.';
$string['storedfilecannotread'] = 'Kan bestand niet lezen. Ofwel bestaat het bestand niet ofwel zijn er rechtenproblemen.';
$string['storedfilecannotreadfile'] = 'Kan bestand  \'{$a}\' niet lezen. Ofwel bestaat het bestand niet of er is een rechteprobleem.';
$string['storedfilenotcreated'] = 'Kon bestand"{$a->contextid}/{$a->component}/{$a->filearea}/{$a->itemid}{$a->filepath}{$a->filename}" niet maken';
$string['storedfileproblem'] = 'Onbekende uitzondering opgetreden in verband met lokale bestanden ({$a})';
$string['tagdisabled'] = 'Tags zijn uitgeschakeld!';
$string['tagnotfound'] = 'Die tag kon niet in de databank gevonden worden';
$string['targetdatabasenotempty'] = 'De doeldatabank is niet leeg. Transfer afgebroken om veiligheidsredenen.';
$string['textconditionsnotallowed'] = 'Vergelijking van tekst kolom condities niet toegestaan. Gebruik sql_compare_text() in je query.';
$string['themenotinstall'] = 'Dit thema is niet geïnstalleerd';
$string['tokengenerationfailed'] = 'Kan geen nieuw token genereren.';
$string['transactionvoid'] = 'Transactie kan niet geannuleerd worden omdat ze al geannuleerd is.';
$string['unenrolerror'] = 'Er is een fout opgetreden bij het afmelden van die gebruiker.';
$string['unicodeupgradeerror'] = 'Sorry, maar je databank is nog niet in Unicode en deze versie van Moodle kan je databank niet naar Unicode migreren.
Upgrade eerst naar Moodle 1.7.x en doe de Unicode migratie vanuit de Beheerpagina. Daarna zou je moeten kunnen upgraden naar Moodle {$a}';
$string['unknowaction'] = 'Onbekende actie!';
$string['unknowcategory'] = 'Onbekende categorie!';
$string['unknowcontext'] = 'Dit is een onbekende context ({$a}) in get_child_contexts!';
$string['unknowformat'] = 'Format niet gekend ({$a})';
$string['unknownbackupexporterror'] = 'Onbekende fout bij het voorbereiden van de informatie voor import';
$string['unknownblockregion'] = 'De blokplaats \'{$a}\' wordt niet herkend op deze pagina';
$string['unknowncontext'] = 'Dit is een onbekende context';
$string['unknowncourse'] = 'Onbekende cursus "{$a}"';
$string['unknowncourseidnumber'] = 'Onbekend cursusID "{$a}"';
$string['unknowncourserequest'] = 'Onbekende cursusaanvraag';
$string['unknowncoursesection'] = 'Onbekende cursus sectie in cursus "{$a}"';
$string['unknownevent'] = 'Onbekende gebeurtenis';
$string['unknownfiletype'] = 'Onbekend filtertype';
$string['unknowngroup'] = 'Onbekende groep "{$a}"';
$string['unknownhelp'] = 'Onbekend helponderwerp {$a}';
$string['unknownjsinrequirejs'] = 'Kan JS bibliotheek niet vinden: {$a}';
$string['unknownmodulename'] = 'Onbekende modulenaam voor formulier';
$string['unknownrole'] = 'Onbekende rol "{$a}"';
$string['unknownsortcolumn'] = 'Onbekende sorteerkolom {$a}';
$string['unknownuseraction'] = 'Sorry, Moodle begrijpt niet wat je wil';
$string['unknownuserselector'] = 'Onbekende gebruikersselector';
$string['unknoworder'] = 'Onbekende volgorde';
$string['unknowparamtype'] = 'Onbekend parametertype: {$a}';
$string['unknowquestiontype'] = 'Niet-ondersteund vraagtype {$a}';
$string['unknowuploadaction'] = 'Fout: onbekende uploadactie ({$a}).';
$string['unspecifycourseid'] = 'Je moet cursus ID, korte naam of ID nummer specifiëren';
$string['unsupportedevent'] = 'Gebeurtenistype niet ondersteund';
$string['unsupportedstate'] = 'status van voltooien niet ondersteund';
$string['unsupportedwebserver'] = 'De webserver software ({$a}) wordt niet ondersteund.';
$string['upgraderequires19'] = 'FOUT: er is een nieuwe Moodle versie geïnstalleerd op je server, maar upgrade vanaf je vorige versie is niet ondersteund.<br />Upgrade eerst naar de laatste 1.9.x-versie. Je kunt ook terug naar je vorige versie door de Moodle-bestanden van die versie terug te plaatsen.';
$string['upgraderunning'] = 'Site wordt geüpgraded. Probeer later nog eens.';
$string['urlnotdefinerss'] = 'URL voor rss feed niet gedefiniëerd';
$string['useradmineditadmin'] = 'Alleen beheerders mogen de account van andere beheerders aanpassen.';
$string['useradminodelete'] = 'Beheerderaccounts kunnen niet verwijderd worden';
$string['userautherror'] = 'Onbekende authenticatieplugin';
$string['userauthunsupported'] = 'Authenticatieplugin niet ondersteund';
$string['useremailduplicate'] = 'Duplicaat adres';
$string['usermustbemnet'] = 'De gebruikers in de MNET-toeganscontrolelijst moeten externe MNET-gebruikers zijn';
$string['usernamelowercase'] = 'De gebruikersnaam moet in kleine letters zijn';
$string['usernotaddederror'] = 'Gebruiker niet toegevoegd - fout';
$string['usernotaddedregistered'] = 'Gebruiker niet toegevoegd - gebruiker bestaat al';
$string['usernotavailable'] = 'Je hebt het recht niet om de detailgegevens van deze gebruiker te zien.';
$string['usernotdeletedadmin'] = 'Gebruiker niet verwijderd - kan geen beheerdersaccounts verwijderen';
$string['usernotdeleteddeleted'] = 'Deze gebruiker is al verwijderd';
$string['usernotdeletederror'] = 'Gebruiker niet verwijderd - onbekende fout';
$string['usernotdeletedmissing'] = 'Gebruiker niet verwijderd - kon gebruikersnaam niet vinden.';
$string['usernotdeletedoff'] = 'Gebruiker niet verwijderd - verwijderen niet toegestaan.';
$string['usernotfullysetup'] = 'Gebruiker niet volledig ingesteld';
$string['usernotincourse'] = 'Deze gebruiker zit niet in deze cursus!';
$string['usernotrenamedadmin'] = 'Kan beheerdersaccounts niet hernoemen';
$string['usernotrenamedexists'] = 'Gebruiker niet hernoemd -- de nieuwe gebruikersnaam bestaat al.';
$string['usernotrenamedmissing'] = 'Gebruiker niet hernoemd -- kon de oude gebruikersnaam niet vinden.';
$string['usernotrenamedoff'] = 'Gebruiker niet hernoemd - hernoemen niet toegestaan.';
$string['usernotupdatedadmin'] = 'Kan beheerdersaccounts niet aanpassen';
$string['usernotupdatederror'] = 'Gebruiker niet aangepast - onbekende fout';
$string['usernotupdatednotexists'] = 'Gebruiker niet aangepast - bestaat niet';
$string['userquotalimit'] = 'Je hebt je quotumlimiet bereikt';
$string['userselectortoomany'] = 'user_selector kreeg meer dan één geselecteerde gebruiker, ondanks dat multiselect op false staat.';
$string['verifyagedigitalconsentnotpossible'] = 'Verificatie van digitale meerderjarigheid is helaas niet mogelijk op dit moment.';
$string['wrongcall'] = 'Dit script is verkeerd opgeroepen';
$string['wrongcontextid'] = 'De context ID is fout (kan die niet vinden)';
$string['wrongdestpath'] = 'Fout pad voor bestemming';
$string['wrongroleid'] = 'Foute rol ID';
$string['wrongsourcebase'] = 'Foute URL voor de bron';
$string['wrongusernamepassword'] = 'Gebruikersnaam of wachtwoord fout';
$string['wrongzipfilename'] = 'Foute ZIP-bestandsnaam';
$string['wscouldnotcreateecoursenopermission'] = 'WS - kon cursus niet maken - Geen rechten';
$string['wwwrootmismatch'] = 'Foute toegang gedetecteerd. Deze server is enkel toegankelijk via het adres "{$a}". <br />Waarschuw je systeembeheerder.';
$string['wwwrootslash'] = 'Verkeerde $CFG->wwwroot in config.php gevonden. Er mag geen schuine streep aan het einde van de regel staan.<br /> Waarschuw je systeembeheerder.';
$string['xmldberror'] = 'XMLDB fout!';
$string['youcannotdeletecategory'] = 'Je kunt categorie \'{$a}\' niet verwijderen omdat je de inhoud niet kunt verwijderen, noch verplaatsen';
