
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `moodle3518`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]analytics_indicator_calc`
--

CREATE TABLE `[[dbprefix]]analytics_indicator_calc` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `starttime` bigint(10) NOT NULL,
  `endtime` bigint(10) NOT NULL,
  `contextid` bigint(10) NOT NULL,
  `sampleorigin` varchar(255) NOT NULL DEFAULT '',
  `sampleid` bigint(10) NOT NULL,
  `indicator` varchar(255) NOT NULL DEFAULT '',
  `value` decimal(10,2) DEFAULT NULL,
  `timecreated` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]analindicalc_staendco_ix` (`starttime`,`endtime`,`contextid`),
  KEY `[[dbprefix]]analindicalc_con_ix` (`contextid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Stored indicator calculations' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]analytics_models`
--

CREATE TABLE `[[dbprefix]]analytics_models` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `enabled` tinyint(1) NOT NULL DEFAULT '0',
  `trained` tinyint(1) NOT NULL DEFAULT '0',
  `target` varchar(255) NOT NULL DEFAULT '',
  `indicators` longtext NOT NULL,
  `timesplitting` varchar(255) DEFAULT NULL,
  `version` bigint(10) NOT NULL,
  `timecreated` bigint(10) DEFAULT NULL,
  `timemodified` bigint(10) NOT NULL,
  `usermodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]analmode_enatra_ix` (`enabled`,`trained`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Analytic models.' AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]analytics_models`
--

INSERT INTO `[[dbprefix]]analytics_models` VALUES
(1, 0, 0, '\\core\\analytics\\target\\course_dropout', '["\\\\mod_assign\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_assign\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_book\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_book\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_chat\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_chat\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_choice\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_choice\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_data\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_data\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_feedback\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_feedback\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_folder\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_folder\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_forum\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_forum\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_glossary\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_glossary\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_imscp\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_imscp\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_label\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_label\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_lesson\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_lesson\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_lti\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_lti\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_page\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_page\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_quiz\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_quiz\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_resource\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_resource\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_scorm\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_scorm\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_survey\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_survey\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_url\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_url\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_wiki\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_wiki\\\\analytics\\\\indicator\\\\social_breadth","\\\\mod_workshop\\\\analytics\\\\indicator\\\\cognitive_depth","\\\\mod_workshop\\\\analytics\\\\indicator\\\\social_breadth","\\\\core_course\\\\analytics\\\\indicator\\\\completion_enabled","\\\\core_course\\\\analytics\\\\indicator\\\\potential_cognitive_depth","\\\\core_course\\\\analytics\\\\indicator\\\\potential_social_breadth","\\\\core\\\\analytics\\\\indicator\\\\any_access_after_end","\\\\core\\\\analytics\\\\indicator\\\\any_access_before_start","\\\\core\\\\analytics\\\\indicator\\\\any_write_action_in_course","\\\\core\\\\analytics\\\\indicator\\\\read_actions"]', NULL, [[timestamp]], [[timestamp]], [[timestamp]], 0),
(2, 1, 1, '\\core\\analytics\\target\\no_teaching', '["\\\\core_course\\\\analytics\\\\indicator\\\\no_teacher","\\\\core_course\\\\analytics\\\\indicator\\\\no_student"]', '\\core\\analytics\\time_splitting\\single_range', [[timestamp]], [[timestamp]], [[timestamp]], 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]analytics_models_log`
--

CREATE TABLE `[[dbprefix]]analytics_models_log` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `modelid` bigint(10) NOT NULL,
  `version` bigint(10) NOT NULL,
  `target` varchar(255) NOT NULL DEFAULT '',
  `indicators` longtext NOT NULL,
  `timesplitting` varchar(255) DEFAULT NULL,
  `score` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `info` longtext,
  `dir` longtext NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  `usermodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]analmodelog_mod_ix` (`modelid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Analytic models changes during evaluation.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]analytics_predictions`
--

CREATE TABLE `[[dbprefix]]analytics_predictions` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `modelid` bigint(10) NOT NULL,
  `contextid` bigint(10) NOT NULL,
  `sampleid` bigint(10) NOT NULL,
  `rangeindex` mediumint(5) NOT NULL,
  `prediction` decimal(10,2) NOT NULL,
  `predictionscore` decimal(10,5) NOT NULL,
  `calculations` longtext NOT NULL,
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timestart` bigint(10) DEFAULT NULL,
  `timeend` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]analpred_modcon_ix` (`modelid`,`contextid`),
  KEY `[[dbprefix]]analpred_mod_ix` (`modelid`),
  KEY `[[dbprefix]]analpred_con_ix` (`contextid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Predictions' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]analytics_prediction_actions`
--

CREATE TABLE `[[dbprefix]]analytics_prediction_actions` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `predictionid` bigint(10) NOT NULL,
  `userid` bigint(10) NOT NULL,
  `actionname` varchar(255) NOT NULL DEFAULT '',
  `timecreated` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]analpredacti_preuseac_ix` (`predictionid`,`userid`,`actionname`),
  KEY `[[dbprefix]]analpredacti_pre_ix` (`predictionid`),
  KEY `[[dbprefix]]analpredacti_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Register of user actions over predictions.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]analytics_predict_samples`
--

CREATE TABLE `[[dbprefix]]analytics_predict_samples` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `modelid` bigint(10) NOT NULL,
  `analysableid` bigint(10) NOT NULL,
  `timesplitting` varchar(255) NOT NULL DEFAULT '',
  `rangeindex` bigint(10) NOT NULL,
  `sampleids` longtext NOT NULL,
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]analpredsamp_modanati_ix` (`modelid`,`analysableid`,`timesplitting`,`rangeindex`),
  KEY `[[dbprefix]]analpredsamp_mod_ix` (`modelid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Samples already used for predictions.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]analytics_train_samples`
--

CREATE TABLE `[[dbprefix]]analytics_train_samples` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `modelid` bigint(10) NOT NULL,
  `analysableid` bigint(10) NOT NULL,
  `timesplitting` varchar(255) NOT NULL DEFAULT '',
  `fileid` bigint(10) NOT NULL,
  `sampleids` longtext NOT NULL,
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]analtraisamp_modanati_ix` (`modelid`,`analysableid`,`timesplitting`),
  KEY `[[dbprefix]]analtraisamp_mod_ix` (`modelid`),
  KEY `[[dbprefix]]analtraisamp_fil_ix` (`fileid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Samples used for training' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]analytics_used_analysables`
--

CREATE TABLE `[[dbprefix]]analytics_used_analysables` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `modelid` bigint(10) NOT NULL,
  `action` varchar(50) NOT NULL DEFAULT '',
  `analysableid` bigint(10) NOT NULL,
  `timeanalysed` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]analusedanal_modact_ix` (`modelid`,`action`),
  KEY `[[dbprefix]]analusedanal_mod_ix` (`modelid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='List of analysables used by each model' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]analytics_used_files`
--

CREATE TABLE `[[dbprefix]]analytics_used_files` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `modelid` bigint(10) NOT NULL DEFAULT '0',
  `fileid` bigint(10) NOT NULL DEFAULT '0',
  `action` varchar(50) NOT NULL DEFAULT '',
  `time` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]analusedfile_modactfi_ix` (`modelid`,`action`,`fileid`),
  KEY `[[dbprefix]]analusedfile_mod_ix` (`modelid`),
  KEY `[[dbprefix]]analusedfile_fil_ix` (`fileid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Files that have already been used for training and predictio' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]assign`
--

CREATE TABLE `[[dbprefix]]assign` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `intro` longtext NOT NULL,
  `introformat` smallint(4) NOT NULL DEFAULT '0',
  `alwaysshowdescription` tinyint(2) NOT NULL DEFAULT '0',
  `nosubmissions` tinyint(2) NOT NULL DEFAULT '0',
  `submissiondrafts` tinyint(2) NOT NULL DEFAULT '0',
  `sendnotifications` tinyint(2) NOT NULL DEFAULT '0',
  `sendlatenotifications` tinyint(2) NOT NULL DEFAULT '0',
  `duedate` bigint(10) NOT NULL DEFAULT '0',
  `allowsubmissionsfromdate` bigint(10) NOT NULL DEFAULT '0',
  `grade` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `requiresubmissionstatement` tinyint(2) NOT NULL DEFAULT '0',
  `completionsubmit` tinyint(2) NOT NULL DEFAULT '0',
  `cutoffdate` bigint(10) NOT NULL DEFAULT '0',
  `gradingduedate` bigint(10) NOT NULL DEFAULT '0',
  `teamsubmission` tinyint(2) NOT NULL DEFAULT '0',
  `requireallteammemberssubmit` tinyint(2) NOT NULL DEFAULT '0',
  `teamsubmissiongroupingid` bigint(10) NOT NULL DEFAULT '0',
  `blindmarking` tinyint(2) NOT NULL DEFAULT '0',
  `revealidentities` tinyint(2) NOT NULL DEFAULT '0',
  `attemptreopenmethod` varchar(10) NOT NULL DEFAULT 'none',
  `maxattempts` mediumint(6) NOT NULL DEFAULT '-1',
  `markingworkflow` tinyint(2) NOT NULL DEFAULT '0',
  `markingallocation` tinyint(2) NOT NULL DEFAULT '0',
  `sendstudentnotifications` tinyint(2) NOT NULL DEFAULT '1',
  `preventsubmissionnotingroup` tinyint(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]assi_cou_ix` (`course`),
  KEY `[[dbprefix]]assi_tea_ix` (`teamsubmissiongroupingid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='This table saves information about an instance of mod_assign' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]assignfeedback_comments`
--

CREATE TABLE `[[dbprefix]]assignfeedback_comments` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `assignment` bigint(10) NOT NULL DEFAULT '0',
  `grade` bigint(10) NOT NULL DEFAULT '0',
  `commenttext` longtext,
  `commentformat` smallint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]assicomm_ass_ix` (`assignment`),
  KEY `[[dbprefix]]assicomm_gra_ix` (`grade`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Text feedback for submitted assignments' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]assignfeedback_editpdf_annot`
--

CREATE TABLE `[[dbprefix]]assignfeedback_editpdf_annot` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `gradeid` bigint(10) NOT NULL DEFAULT '0',
  `pageno` bigint(10) NOT NULL DEFAULT '0',
  `x` bigint(10) DEFAULT '0',
  `y` bigint(10) DEFAULT '0',
  `endx` bigint(10) DEFAULT '0',
  `endy` bigint(10) DEFAULT '0',
  `path` longtext,
  `type` varchar(10) DEFAULT 'line',
  `colour` varchar(10) DEFAULT 'black',
  `draft` tinyint(2) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]assieditanno_grapag_ix` (`gradeid`,`pageno`),
  KEY `[[dbprefix]]assieditanno_gra_ix` (`gradeid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='stores annotations added to pdfs submitted by students' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]assignfeedback_editpdf_cmnt`
--

CREATE TABLE `[[dbprefix]]assignfeedback_editpdf_cmnt` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `gradeid` bigint(10) NOT NULL DEFAULT '0',
  `x` bigint(10) DEFAULT '0',
  `y` bigint(10) DEFAULT '0',
  `width` bigint(10) DEFAULT '120',
  `rawtext` longtext,
  `pageno` bigint(10) NOT NULL DEFAULT '0',
  `colour` varchar(10) DEFAULT 'black',
  `draft` tinyint(2) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]assieditcmnt_grapag_ix` (`gradeid`,`pageno`),
  KEY `[[dbprefix]]assieditcmnt_gra_ix` (`gradeid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Stores comments added to pdfs' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]assignfeedback_editpdf_queue`
--

CREATE TABLE `[[dbprefix]]assignfeedback_editpdf_queue` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `submissionid` bigint(10) NOT NULL,
  `submissionattempt` bigint(10) NOT NULL,
  `attemptedconversions` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]assieditqueu_subsub_uix` (`submissionid`,`submissionattempt`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Queue for processing.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]assignfeedback_editpdf_quick`
--

CREATE TABLE `[[dbprefix]]assignfeedback_editpdf_quick` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `rawtext` longtext NOT NULL,
  `width` bigint(10) NOT NULL DEFAULT '120',
  `colour` varchar(10) DEFAULT 'yellow',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]assieditquic_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Stores teacher specified quicklist comments' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]assignfeedback_file`
--

CREATE TABLE `[[dbprefix]]assignfeedback_file` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `assignment` bigint(10) NOT NULL DEFAULT '0',
  `grade` bigint(10) NOT NULL DEFAULT '0',
  `numfiles` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]assifile_ass2_ix` (`assignment`),
  KEY `[[dbprefix]]assifile_gra_ix` (`grade`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Stores info about the number of files submitted by a student' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]assignment`
--

CREATE TABLE `[[dbprefix]]assignment` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `intro` longtext NOT NULL,
  `introformat` smallint(4) NOT NULL DEFAULT '0',
  `assignmenttype` varchar(50) NOT NULL DEFAULT '',
  `resubmit` tinyint(2) NOT NULL DEFAULT '0',
  `preventlate` tinyint(2) NOT NULL DEFAULT '0',
  `emailteachers` tinyint(2) NOT NULL DEFAULT '0',
  `var1` bigint(10) DEFAULT '0',
  `var2` bigint(10) DEFAULT '0',
  `var3` bigint(10) DEFAULT '0',
  `var4` bigint(10) DEFAULT '0',
  `var5` bigint(10) DEFAULT '0',
  `maxbytes` bigint(10) NOT NULL DEFAULT '100000',
  `timedue` bigint(10) NOT NULL DEFAULT '0',
  `timeavailable` bigint(10) NOT NULL DEFAULT '0',
  `grade` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]assi_cou2_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Defines assignments' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]assignment_submissions`
--

CREATE TABLE `[[dbprefix]]assignment_submissions` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `assignment` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `numfiles` bigint(10) NOT NULL DEFAULT '0',
  `data1` longtext,
  `data2` longtext,
  `grade` bigint(11) NOT NULL DEFAULT '0',
  `submissioncomment` longtext NOT NULL,
  `format` smallint(4) NOT NULL DEFAULT '0',
  `teacher` bigint(10) NOT NULL DEFAULT '0',
  `timemarked` bigint(10) NOT NULL DEFAULT '0',
  `mailed` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]assisubm_use2_ix` (`userid`),
  KEY `[[dbprefix]]assisubm_mai_ix` (`mailed`),
  KEY `[[dbprefix]]assisubm_tim_ix` (`timemarked`),
  KEY `[[dbprefix]]assisubm_ass2_ix` (`assignment`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Info about submitted assignments' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]assignment_upgrade`
--

CREATE TABLE `[[dbprefix]]assignment_upgrade` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `oldcmid` bigint(10) NOT NULL DEFAULT '0',
  `oldinstance` bigint(10) NOT NULL DEFAULT '0',
  `newcmid` bigint(10) NOT NULL DEFAULT '0',
  `newinstance` bigint(10) NOT NULL DEFAULT '0',
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]assiupgr_old_ix` (`oldcmid`),
  KEY `[[dbprefix]]assiupgr_old2_ix` (`oldinstance`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Info about upgraded assignments' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]assignsubmission_file`
--

CREATE TABLE `[[dbprefix]]assignsubmission_file` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `assignment` bigint(10) NOT NULL DEFAULT '0',
  `submission` bigint(10) NOT NULL DEFAULT '0',
  `numfiles` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]assifile_ass_ix` (`assignment`),
  KEY `[[dbprefix]]assifile_sub_ix` (`submission`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Info about file submissions for assignments' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]assignsubmission_onlinetext`
--

CREATE TABLE `[[dbprefix]]assignsubmission_onlinetext` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `assignment` bigint(10) NOT NULL DEFAULT '0',
  `submission` bigint(10) NOT NULL DEFAULT '0',
  `onlinetext` longtext,
  `onlineformat` smallint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]assionli_ass_ix` (`assignment`),
  KEY `[[dbprefix]]assionli_sub_ix` (`submission`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Info about onlinetext submission' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]assign_grades`
--

CREATE TABLE `[[dbprefix]]assign_grades` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `assignment` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `grader` bigint(10) NOT NULL DEFAULT '0',
  `grade` decimal(10,5) DEFAULT '0.00000',
  `attemptnumber` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]assigrad_assuseatt_uix` (`assignment`,`userid`,`attemptnumber`),
  KEY `[[dbprefix]]assigrad_use_ix` (`userid`),
  KEY `[[dbprefix]]assigrad_att_ix` (`attemptnumber`),
  KEY `[[dbprefix]]assigrad_ass_ix` (`assignment`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Grading information about a single assignment submission.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]assign_overrides`
--

CREATE TABLE `[[dbprefix]]assign_overrides` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `assignid` bigint(10) NOT NULL DEFAULT '0',
  `groupid` bigint(10) DEFAULT NULL,
  `userid` bigint(10) DEFAULT NULL,
  `sortorder` bigint(10) DEFAULT NULL,
  `allowsubmissionsfromdate` bigint(10) DEFAULT NULL,
  `duedate` bigint(10) DEFAULT NULL,
  `cutoffdate` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]assiover_ass_ix` (`assignid`),
  KEY `[[dbprefix]]assiover_gro_ix` (`groupid`),
  KEY `[[dbprefix]]assiover_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='The overrides to assign settings.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]assign_plugin_config`
--

CREATE TABLE `[[dbprefix]]assign_plugin_config` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `assignment` bigint(10) NOT NULL DEFAULT '0',
  `plugin` varchar(28) NOT NULL DEFAULT '',
  `subtype` varchar(28) NOT NULL DEFAULT '',
  `name` varchar(28) NOT NULL DEFAULT '',
  `value` longtext,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]assiplugconf_plu_ix` (`plugin`),
  KEY `[[dbprefix]]assiplugconf_sub_ix` (`subtype`),
  KEY `[[dbprefix]]assiplugconf_nam_ix` (`name`),
  KEY `[[dbprefix]]assiplugconf_ass_ix` (`assignment`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Config data for an instance of a plugin in an assignment.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]assign_submission`
--

CREATE TABLE `[[dbprefix]]assign_submission` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `assignment` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `status` varchar(10) DEFAULT NULL,
  `groupid` bigint(10) NOT NULL DEFAULT '0',
  `attemptnumber` bigint(10) NOT NULL DEFAULT '0',
  `latest` tinyint(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]assisubm_assusegroat_uix` (`assignment`,`userid`,`groupid`,`attemptnumber`),
  KEY `[[dbprefix]]assisubm_use_ix` (`userid`),
  KEY `[[dbprefix]]assisubm_att_ix` (`attemptnumber`),
  KEY `[[dbprefix]]assisubm_assusegrolat_ix` (`assignment`,`userid`,`groupid`,`latest`),
  KEY `[[dbprefix]]assisubm_ass_ix` (`assignment`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='This table keeps information about student interactions with' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]assign_user_flags`
--

CREATE TABLE `[[dbprefix]]assign_user_flags` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `assignment` bigint(10) NOT NULL DEFAULT '0',
  `locked` bigint(10) NOT NULL DEFAULT '0',
  `mailed` smallint(4) NOT NULL DEFAULT '0',
  `extensionduedate` bigint(10) NOT NULL DEFAULT '0',
  `workflowstate` varchar(20) DEFAULT NULL,
  `allocatedmarker` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]assiuserflag_mai_ix` (`mailed`),
  KEY `[[dbprefix]]assiuserflag_use_ix` (`userid`),
  KEY `[[dbprefix]]assiuserflag_ass_ix` (`assignment`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='List of flags that can be set for a single user in a single ' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]assign_user_mapping`
--

CREATE TABLE `[[dbprefix]]assign_user_mapping` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `assignment` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]assiusermapp_ass_ix` (`assignment`),
  KEY `[[dbprefix]]assiusermapp_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Map an assignment specific id number to a user' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]auth_oauth2_linked_login`
--

CREATE TABLE `[[dbprefix]]auth_oauth2_linked_login` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `usermodified` bigint(10) NOT NULL,
  `userid` bigint(10) NOT NULL,
  `issuerid` bigint(10) NOT NULL,
  `username` varchar(255) NOT NULL DEFAULT '',
  `email` longtext NOT NULL,
  `confirmtoken` varchar(64) NOT NULL DEFAULT '',
  `confirmtokenexpires` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]authoautlinklogi_use_uix` (`userid`,`issuerid`,`username`),
  KEY `[[dbprefix]]authoautlinklogi_issu_ix` (`issuerid`,`username`),
  KEY `[[dbprefix]]authoautlinklogi_use_ix` (`usermodified`),
  KEY `[[dbprefix]]authoautlinklogi_use2_ix` (`userid`),
  KEY `[[dbprefix]]authoautlinklogi_iss_ix` (`issuerid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Accounts linked to a users Moodle account.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]backup_controllers`
--

CREATE TABLE `[[dbprefix]]backup_controllers` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `backupid` varchar(32) NOT NULL DEFAULT '',
  `operation` varchar(20) NOT NULL DEFAULT 'backup',
  `type` varchar(10) NOT NULL DEFAULT '',
  `itemid` bigint(10) NOT NULL,
  `format` varchar(20) NOT NULL DEFAULT '',
  `interactive` smallint(4) NOT NULL,
  `purpose` smallint(4) NOT NULL,
  `userid` bigint(10) NOT NULL,
  `status` smallint(4) NOT NULL,
  `execution` smallint(4) NOT NULL,
  `executiontime` bigint(10) NOT NULL,
  `checksum` varchar(32) NOT NULL DEFAULT '',
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `controller` longtext NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]backcont_bac_uix` (`backupid`),
  KEY `[[dbprefix]]backcont_typite_ix` (`type`,`itemid`),
  KEY `[[dbprefix]]backcont_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='To store the backup_controllers as they are used' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]backup_courses`
--

CREATE TABLE `[[dbprefix]]backup_courses` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `courseid` bigint(10) NOT NULL DEFAULT '0',
  `laststarttime` bigint(10) NOT NULL DEFAULT '0',
  `lastendtime` bigint(10) NOT NULL DEFAULT '0',
  `laststatus` varchar(1) NOT NULL DEFAULT '5',
  `nextstarttime` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]backcour_cou_uix` (`courseid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='To store every course backup status' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]backup_logs`
--

CREATE TABLE `[[dbprefix]]backup_logs` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `backupid` varchar(32) NOT NULL DEFAULT '',
  `loglevel` smallint(4) NOT NULL,
  `message` longtext NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]backlogs_bacid_uix` (`backupid`,`id`),
  KEY `[[dbprefix]]backlogs_bac_ix` (`backupid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='To store all the logs from backup and restore operations (by' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]badge`
--

CREATE TABLE `[[dbprefix]]badge` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `description` longtext,
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `usercreated` bigint(10) NOT NULL,
  `usermodified` bigint(10) NOT NULL,
  `issuername` varchar(255) NOT NULL DEFAULT '',
  `issuerurl` varchar(255) NOT NULL DEFAULT '',
  `issuercontact` varchar(255) DEFAULT NULL,
  `expiredate` bigint(10) DEFAULT NULL,
  `expireperiod` bigint(10) DEFAULT NULL,
  `type` tinyint(1) NOT NULL DEFAULT '1',
  `courseid` bigint(10) DEFAULT NULL,
  `message` longtext NOT NULL,
  `messagesubject` longtext NOT NULL,
  `attachment` tinyint(1) NOT NULL DEFAULT '1',
  `notification` tinyint(1) NOT NULL DEFAULT '1',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `nextcron` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]badg_typ_ix` (`type`),
  KEY `[[dbprefix]]badg_cou_ix` (`courseid`),
  KEY `[[dbprefix]]badg_use_ix` (`usermodified`),
  KEY `[[dbprefix]]badg_use2_ix` (`usercreated`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Defines badge' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]badge_backpack`
--

CREATE TABLE `[[dbprefix]]badge_backpack` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `email` varchar(100) NOT NULL DEFAULT '',
  `backpackurl` varchar(255) NOT NULL DEFAULT '',
  `backpackuid` bigint(10) NOT NULL,
  `autosync` tinyint(1) NOT NULL DEFAULT '0',
  `password` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]badgback_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Defines settings for connecting external backpack' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]badge_criteria`
--

CREATE TABLE `[[dbprefix]]badge_criteria` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `badgeid` bigint(10) NOT NULL DEFAULT '0',
  `criteriatype` bigint(10) DEFAULT NULL,
  `method` tinyint(1) NOT NULL DEFAULT '1',
  `description` longtext,
  `descriptionformat` tinyint(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]badgcrit_badcri_uix` (`badgeid`,`criteriatype`),
  KEY `[[dbprefix]]badgcrit_cri_ix` (`criteriatype`),
  KEY `[[dbprefix]]badgcrit_bad_ix` (`badgeid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Defines criteria for issuing badges' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]badge_criteria_met`
--

CREATE TABLE `[[dbprefix]]badge_criteria_met` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `issuedid` bigint(10) DEFAULT NULL,
  `critid` bigint(10) NOT NULL,
  `userid` bigint(10) NOT NULL,
  `datemet` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]badgcritmet_cri_ix` (`critid`),
  KEY `[[dbprefix]]badgcritmet_use_ix` (`userid`),
  KEY `[[dbprefix]]badgcritmet_iss_ix` (`issuedid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Defines criteria that were met for an issued badge' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]badge_criteria_param`
--

CREATE TABLE `[[dbprefix]]badge_criteria_param` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `critid` bigint(10) NOT NULL,
  `name` varchar(255) NOT NULL DEFAULT '',
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]badgcritpara_cri_ix` (`critid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Defines parameters for badges criteria' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]badge_external`
--

CREATE TABLE `[[dbprefix]]badge_external` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `backpackid` bigint(10) NOT NULL,
  `collectionid` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]badgexte_bac_ix` (`backpackid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Setting for external badges display' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]badge_issued`
--

CREATE TABLE `[[dbprefix]]badge_issued` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `badgeid` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `uniquehash` longtext NOT NULL,
  `dateissued` bigint(10) NOT NULL DEFAULT '0',
  `dateexpire` bigint(10) DEFAULT NULL,
  `visible` tinyint(1) NOT NULL DEFAULT '0',
  `issuernotified` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]badgissu_baduse_uix` (`badgeid`,`userid`),
  KEY `[[dbprefix]]badgissu_bad_ix` (`badgeid`),
  KEY `[[dbprefix]]badgissu_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Defines issued badges' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]badge_manual_award`
--

CREATE TABLE `[[dbprefix]]badge_manual_award` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `badgeid` bigint(10) NOT NULL,
  `recipientid` bigint(10) NOT NULL,
  `issuerid` bigint(10) NOT NULL,
  `issuerrole` bigint(10) NOT NULL,
  `datemet` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]badgmanuawar_bad_ix` (`badgeid`),
  KEY `[[dbprefix]]badgmanuawar_rec_ix` (`recipientid`),
  KEY `[[dbprefix]]badgmanuawar_iss_ix` (`issuerid`),
  KEY `[[dbprefix]]badgmanuawar_iss2_ix` (`issuerrole`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Track manual award criteria for badges' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]block`
--

CREATE TABLE `[[dbprefix]]block` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(40) NOT NULL DEFAULT '',
  `cron` bigint(10) NOT NULL DEFAULT '0',
  `lastcron` bigint(10) NOT NULL DEFAULT '0',
  `visible` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]bloc_nam_uix` (`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='contains all installed blocks' AUTO_INCREMENT=42 ;

--
-- Dumping data for table `[[dbprefix]]block`
--

INSERT INTO `[[dbprefix]]block` VALUES
(1, 'activity_modules', 0, 0, 1),
(2, 'activity_results', 0, 0, 1),
(3, 'admin_bookmarks', 0, 0, 1),
(4, 'badges', 0, 0, 1),
(5, 'blog_menu', 0, 0, 1),
(6, 'blog_recent', 0, 0, 1),
(7, 'blog_tags', 0, 0, 1),
(8, 'calendar_month', 0, 0, 1),
(9, 'calendar_upcoming', 0, 0, 1),
(10, 'comments', 0, 0, 1),
(11, 'community', 0, 0, 1),
(12, 'completionstatus', 0, 0, 1),
(13, 'course_list', 0, 0, 1),
(14, 'course_summary', 0, 0, 1),
(15, 'feedback', 0, 0, 1),
(16, 'globalsearch', 0, 0, 1),
(17, 'glossary_random', 0, 0, 1),
(18, 'html', 0, 0, 1),
(19, 'login', 0, 0, 1),
(20, 'lp', 0, 0, 1),
(21, 'mentees', 0, 0, 1),
(22, 'mnet_hosts', 0, 0, 1),
(23, 'myoverview', 0, 0, 1),
(24, 'myprofile', 0, 0, 1),
(25, 'navigation', 0, 0, 1),
(26, 'news_items', 0, 0, 1),
(27, 'online_users', 0, 0, 1),
(28, 'participants', 0, 0, 1),
(29, 'private_files', 0, 0, 1),
(30, 'quiz_results', 0, 0, 0),
(31, 'recent_activity', 86400, 0, 1),
(32, 'rss_client', 300, 0, 1),
(33, 'search_forums', 0, 0, 1),
(34, 'section_links', 0, 0, 1),
(35, 'selfcompletion', 0, 0, 1),
(36, 'settings', 0, 0, 1),
(37, 'site_main_menu', 0, 0, 1),
(38, 'social_activities', 0, 0, 1),
(39, 'tag_flickr', 0, 0, 1),
(40, 'tag_youtube', 0, 0, 0),
(41, 'tags', 0, 0, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]block_community`
--

CREATE TABLE `[[dbprefix]]block_community` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL,
  `coursename` varchar(255) NOT NULL DEFAULT '',
  `coursedescription` longtext,
  `courseurl` varchar(255) NOT NULL DEFAULT '',
  `imageurl` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Community block' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]block_instances`
--

CREATE TABLE `[[dbprefix]]block_instances` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `blockname` varchar(40) NOT NULL DEFAULT '',
  `parentcontextid` bigint(10) NOT NULL,
  `showinsubcontexts` smallint(4) NOT NULL,
  `requiredbytheme` smallint(4) NOT NULL DEFAULT '0',
  `pagetypepattern` varchar(64) NOT NULL DEFAULT '',
  `subpagepattern` varchar(16) DEFAULT NULL,
  `defaultregion` varchar(16) NOT NULL DEFAULT '',
  `defaultweight` bigint(10) NOT NULL,
  `configdata` longtext,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]blocinst_parshopagsub_ix` (`parentcontextid`,`showinsubcontexts`,`pagetypepattern`,`subpagepattern`),
  KEY `[[dbprefix]]blocinst_tim_ix` (`timemodified`),
  KEY `[[dbprefix]]blocinst_par_ix` (`parentcontextid`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='This table stores block instances. The type of block this is' AUTO_INCREMENT=9 ;

--
-- Dumping data for table `[[dbprefix]]block_instances`
--

INSERT INTO `[[dbprefix]]block_instances` VALUES
(1, 'admin_bookmarks', 1, 0, 0, 'admin-*', NULL, 'side-pre', 2, '', [[timestamp]], [[timestamp]]),
(2, 'private_files', 1, 0, 0, 'my-index', '2', 'side-post', 0, '', [[timestamp]], [[timestamp]]),
(3, 'online_users', 1, 0, 0, 'my-index', '2', 'side-post', 1, '', [[timestamp]], [[timestamp]]),
(4, 'badges', 1, 0, 0, 'my-index', '2', 'side-post', 2, '', [[timestamp]], [[timestamp]]),
(5, 'calendar_month', 1, 0, 0, 'my-index', '2', 'side-post', 3, '', [[timestamp]], [[timestamp]]),
(6, 'calendar_upcoming', 1, 0, 0, 'my-index', '2', 'side-post', 4, '', [[timestamp]], [[timestamp]]),
(7, 'lp', 1, 0, 0, 'my-index', '2', 'content', 0, '', [[timestamp]], [[timestamp]]),
(8, 'myoverview', 1, 0, 0, 'my-index', '2', 'content', 1, '', [[timestamp]], [[timestamp]]);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]block_positions`
--

CREATE TABLE `[[dbprefix]]block_positions` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `blockinstanceid` bigint(10) NOT NULL,
  `contextid` bigint(10) NOT NULL,
  `pagetype` varchar(64) NOT NULL DEFAULT '',
  `subpage` varchar(16) NOT NULL DEFAULT '',
  `visible` smallint(4) NOT NULL,
  `region` varchar(16) NOT NULL DEFAULT '',
  `weight` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]blocposi_bloconpagsu_uix` (`blockinstanceid`,`contextid`,`pagetype`,`subpage`),
  KEY `[[dbprefix]]blocposi_blo_ix` (`blockinstanceid`),
  KEY `[[dbprefix]]blocposi_con_ix` (`contextid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Stores the position of a sticky block_instance on a another ' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]block_recent_activity`
--

CREATE TABLE `[[dbprefix]]block_recent_activity` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `courseid` bigint(10) NOT NULL,
  `cmid` bigint(10) NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  `userid` bigint(10) NOT NULL,
  `action` tinyint(1) NOT NULL,
  `modname` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]blocreceacti_coutim_ix` (`courseid`,`timecreated`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Recent activity block' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]block_rss_client`
--

CREATE TABLE `[[dbprefix]]block_rss_client` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `title` longtext NOT NULL,
  `preferredtitle` varchar(64) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `shared` tinyint(2) NOT NULL DEFAULT '0',
  `url` varchar(255) NOT NULL DEFAULT '',
  `skiptime` bigint(10) NOT NULL DEFAULT '0',
  `skipuntil` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Remote news feed information. Contains the news feed id, the' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]blog_association`
--

CREATE TABLE `[[dbprefix]]blog_association` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `contextid` bigint(10) NOT NULL,
  `blogid` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]blogasso_con_ix` (`contextid`),
  KEY `[[dbprefix]]blogasso_blo_ix` (`blogid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Associations of blog entries with courses and module instanc' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]blog_external`
--

CREATE TABLE `[[dbprefix]]blog_external` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL,
  `name` varchar(255) NOT NULL DEFAULT '',
  `description` longtext,
  `url` longtext NOT NULL,
  `filtertags` varchar(255) DEFAULT NULL,
  `failedlastsync` tinyint(1) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) DEFAULT NULL,
  `timefetched` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]blogexte_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='External blog links used for RSS copying of blog entries to ' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]book`
--

CREATE TABLE `[[dbprefix]]book` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `intro` longtext,
  `introformat` smallint(4) NOT NULL DEFAULT '0',
  `numbering` smallint(4) NOT NULL DEFAULT '0',
  `navstyle` smallint(4) NOT NULL DEFAULT '1',
  `customtitles` tinyint(2) NOT NULL DEFAULT '0',
  `revision` bigint(10) NOT NULL DEFAULT '0',
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Defines book' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]book_chapters`
--

CREATE TABLE `[[dbprefix]]book_chapters` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `bookid` bigint(10) NOT NULL DEFAULT '0',
  `pagenum` bigint(10) NOT NULL DEFAULT '0',
  `subchapter` bigint(10) NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `content` longtext NOT NULL,
  `contentformat` smallint(4) NOT NULL DEFAULT '0',
  `hidden` tinyint(2) NOT NULL DEFAULT '0',
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `importsrc` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Defines book_chapters' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cache_filters`
--

CREATE TABLE `[[dbprefix]]cache_filters` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `filter` varchar(32) NOT NULL DEFAULT '',
  `version` bigint(10) NOT NULL DEFAULT '0',
  `md5key` varchar(32) NOT NULL DEFAULT '',
  `rawtext` longtext NOT NULL,
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]cachfilt_filmd5_ix` (`filter`,`md5key`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='For keeping information about cached data' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cache_flags`
--

CREATE TABLE `[[dbprefix]]cache_flags` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `flagtype` varchar(255) NOT NULL DEFAULT '',
  `name` varchar(255) NOT NULL DEFAULT '',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `value` longtext NOT NULL,
  `expiry` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]cachflag_fla_ix` (`flagtype`),
  KEY `[[dbprefix]]cachflag_nam_ix` (`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Cache of time-sensitive flags' AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]cache_flags`
--

INSERT INTO `[[dbprefix]]cache_flags` VALUES
(1, 'userpreferenceschanged', '2', [[timestamp]], '1', [[timestamp]]);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]capabilities`
--

CREATE TABLE `[[dbprefix]]capabilities` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `captype` varchar(50) NOT NULL DEFAULT '',
  `contextlevel` bigint(10) NOT NULL DEFAULT '0',
  `component` varchar(100) NOT NULL DEFAULT '',
  `riskbitmask` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]capa_nam_uix` (`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='this defines all capabilities' AUTO_INCREMENT=604 ;

--
-- Dumping data for table `[[dbprefix]]capabilities`
--

INSERT INTO `[[dbprefix]]capabilities` VALUES
(1, 'moodle/site:config', 'write', 10, 'moodle', 62),
(2, 'moodle/site:configview', 'read', 10, 'moodle', 0),
(3, 'moodle/site:readallmessages', 'read', 10, 'moodle', 8),
(4, 'moodle/site:manageallmessaging', 'write', 10, 'moodle', 8),
(5, 'moodle/site:deleteanymessage', 'write', 10, 'moodle', 32),
(6, 'moodle/site:sendmessage', 'write', 10, 'moodle', 16),
(7, 'moodle/site:deleteownmessage', 'write', 10, 'moodle', 0),
(8, 'moodle/site:approvecourse', 'write', 10, 'moodle', 4),
(9, 'moodle/backup:backupcourse', 'write', 50, 'moodle', 28),
(10, 'moodle/backup:backupsection', 'write', 50, 'moodle', 28),
(11, 'moodle/backup:backupactivity', 'write', 70, 'moodle', 28),
(12, 'moodle/backup:backuptargethub', 'write', 50, 'moodle', 28),
(13, 'moodle/backup:backuptargetimport', 'write', 50, 'moodle', 28),
(14, 'moodle/backup:downloadfile', 'write', 50, 'moodle', 28),
(15, 'moodle/backup:configure', 'write', 50, 'moodle', 28),
(16, 'moodle/backup:userinfo', 'read', 50, 'moodle', 8),
(17, 'moodle/backup:anonymise', 'read', 50, 'moodle', 8),
(18, 'moodle/restore:restorecourse', 'write', 50, 'moodle', 28),
(19, 'moodle/restore:restoresection', 'write', 50, 'moodle', 28),
(20, 'moodle/restore:restoreactivity', 'write', 50, 'moodle', 28),
(21, 'moodle/restore:viewautomatedfilearea', 'write', 50, 'moodle', 28),
(22, 'moodle/restore:restoretargethub', 'write', 50, 'moodle', 28),
(23, 'moodle/restore:restoretargetimport', 'write', 50, 'moodle', 28),
(24, 'moodle/restore:uploadfile', 'write', 50, 'moodle', 28),
(25, 'moodle/restore:configure', 'write', 50, 'moodle', 28),
(26, 'moodle/restore:rolldates', 'write', 50, 'moodle', 0),
(27, 'moodle/restore:userinfo', 'write', 50, 'moodle', 30),
(28, 'moodle/restore:createuser', 'write', 10, 'moodle', 24),
(29, 'moodle/site:manageblocks', 'write', 80, 'moodle', 20),
(30, 'moodle/site:accessallgroups', 'read', 70, 'moodle', 0),
(31, 'moodle/site:viewfullnames', 'read', 70, 'moodle', 0),
(32, 'moodle/site:viewuseridentity', 'read', 70, 'moodle', 0),
(33, 'moodle/site:viewreports', 'read', 50, 'moodle', 8),
(34, 'moodle/site:trustcontent', 'write', 70, 'moodle', 4),
(35, 'moodle/site:uploadusers', 'write', 10, 'moodle', 24),
(36, 'moodle/filter:manage', 'write', 50, 'moodle', 0),
(37, 'moodle/user:create', 'write', 10, 'moodle', 24),
(38, 'moodle/user:delete', 'write', 10, 'moodle', 40),
(39, 'moodle/user:update', 'write', 10, 'moodle', 24),
(40, 'moodle/user:viewdetails', 'read', 50, 'moodle', 0),
(41, 'moodle/user:viewalldetails', 'read', 30, 'moodle', 8),
(42, 'moodle/user:viewlastip', 'read', 30, 'moodle', 8),
(43, 'moodle/user:viewhiddendetails', 'read', 50, 'moodle', 8),
(44, 'moodle/user:loginas', 'write', 50, 'moodle', 30),
(45, 'moodle/user:managesyspages', 'write', 10, 'moodle', 0),
(46, 'moodle/user:manageblocks', 'write', 30, 'moodle', 0),
(47, 'moodle/user:manageownblocks', 'write', 10, 'moodle', 0),
(48, 'moodle/user:manageownfiles', 'write', 10, 'moodle', 0),
(49, 'moodle/user:ignoreuserquota', 'write', 10, 'moodle', 0),
(50, 'moodle/my:configsyspages', 'write', 10, 'moodle', 0),
(51, 'moodle/role:assign', 'write', 50, 'moodle', 28),
(52, 'moodle/role:review', 'read', 50, 'moodle', 8),
(53, 'moodle/role:override', 'write', 50, 'moodle', 28),
(54, 'moodle/role:safeoverride', 'write', 50, 'moodle', 16),
(55, 'moodle/role:manage', 'write', 10, 'moodle', 28),
(56, 'moodle/role:switchroles', 'read', 50, 'moodle', 12),
(57, 'moodle/category:manage', 'write', 40, 'moodle', 4),
(58, 'moodle/category:viewhiddencategories', 'read', 40, 'moodle', 0),
(59, 'moodle/cohort:manage', 'write', 40, 'moodle', 0),
(60, 'moodle/cohort:assign', 'write', 40, 'moodle', 0),
(61, 'moodle/cohort:view', 'read', 50, 'moodle', 0),
(62, 'moodle/course:create', 'write', 40, 'moodle', 4),
(63, 'moodle/course:request', 'write', 10, 'moodle', 0),
(64, 'moodle/course:delete', 'write', 50, 'moodle', 32),
(65, 'moodle/course:update', 'write', 50, 'moodle', 4),
(66, 'moodle/course:view', 'read', 50, 'moodle', 0),
(67, 'moodle/course:enrolreview', 'read', 50, 'moodle', 8),
(68, 'moodle/course:enrolconfig', 'write', 50, 'moodle', 8),
(69, 'moodle/course:reviewotherusers', 'read', 50, 'moodle', 0),
(70, 'moodle/course:bulkmessaging', 'write', 50, 'moodle', 16),
(71, 'moodle/course:viewhiddenuserfields', 'read', 50, 'moodle', 8),
(72, 'moodle/course:viewhiddencourses', 'read', 50, 'moodle', 0),
(73, 'moodle/course:visibility', 'write', 50, 'moodle', 0),
(74, 'moodle/course:managefiles', 'write', 50, 'moodle', 4),
(75, 'moodle/course:ignoreavailabilityrestrictions', 'read', 70, 'moodle', 0),
(76, 'moodle/course:ignorefilesizelimits', 'write', 50, 'moodle', 0),
(77, 'moodle/course:manageactivities', 'write', 70, 'moodle', 4),
(78, 'moodle/course:activityvisibility', 'write', 70, 'moodle', 0),
(79, 'moodle/course:viewhiddenactivities', 'write', 70, 'moodle', 0),
(80, 'moodle/course:viewparticipants', 'read', 50, 'moodle', 0),
(81, 'moodle/course:changefullname', 'write', 50, 'moodle', 4),
(82, 'moodle/course:changeshortname', 'write', 50, 'moodle', 4),
(83, 'moodle/course:renameroles', 'write', 50, 'moodle', 0),
(84, 'moodle/course:changeidnumber', 'write', 50, 'moodle', 4),
(85, 'moodle/course:changecategory', 'write', 50, 'moodle', 4),
(86, 'moodle/course:changesummary', 'write', 50, 'moodle', 4),
(87, 'moodle/course:setforcedlanguage', 'write', 50, 'moodle', 0),
(88, 'moodle/site:viewparticipants', 'read', 10, 'moodle', 0),
(89, 'moodle/course:isincompletionreports', 'read', 50, 'moodle', 0),
(90, 'moodle/course:viewscales', 'read', 50, 'moodle', 0),
(91, 'moodle/course:managescales', 'write', 50, 'moodle', 0),
(92, 'moodle/course:managegroups', 'write', 50, 'moodle', 4),
(93, 'moodle/course:reset', 'write', 50, 'moodle', 32),
(94, 'moodle/course:viewsuspendedusers', 'read', 10, 'moodle', 0),
(95, 'moodle/course:tag', 'write', 50, 'moodle', 16),
(96, 'moodle/blog:view', 'read', 10, 'moodle', 0),
(97, 'moodle/blog:search', 'read', 10, 'moodle', 0),
(98, 'moodle/blog:viewdrafts', 'read', 10, 'moodle', 8),
(99, 'moodle/blog:create', 'write', 10, 'moodle', 16),
(100, 'moodle/blog:manageentries', 'write', 10, 'moodle', 16),
(101, 'moodle/blog:manageexternal', 'write', 10, 'moodle', 16),
(102, 'moodle/calendar:manageownentries', 'write', 50, 'moodle', 16),
(103, 'moodle/calendar:managegroupentries', 'write', 50, 'moodle', 16),
(104, 'moodle/calendar:manageentries', 'write', 50, 'moodle', 16),
(105, 'moodle/user:editprofile', 'write', 30, 'moodle', 24),
(106, 'moodle/user:editownprofile', 'write', 10, 'moodle', 16),
(107, 'moodle/user:changeownpassword', 'write', 10, 'moodle', 0),
(108, 'moodle/user:readuserposts', 'read', 30, 'moodle', 0),
(109, 'moodle/user:readuserblogs', 'read', 30, 'moodle', 0),
(110, 'moodle/user:viewuseractivitiesreport', 'read', 30, 'moodle', 8),
(111, 'moodle/user:editmessageprofile', 'write', 30, 'moodle', 16),
(112, 'moodle/user:editownmessageprofile', 'write', 10, 'moodle', 0),
(113, 'moodle/question:managecategory', 'write', 50, 'moodle', 20),
(114, 'moodle/question:add', 'write', 50, 'moodle', 20),
(115, 'moodle/question:editmine', 'write', 50, 'moodle', 20),
(116, 'moodle/question:editall', 'write', 50, 'moodle', 20),
(117, 'moodle/question:viewmine', 'read', 50, 'moodle', 0),
(118, 'moodle/question:viewall', 'read', 50, 'moodle', 0),
(119, 'moodle/question:usemine', 'read', 50, 'moodle', 0),
(120, 'moodle/question:useall', 'read', 50, 'moodle', 0),
(121, 'moodle/question:movemine', 'write', 50, 'moodle', 0),
(122, 'moodle/question:moveall', 'write', 50, 'moodle', 0),
(123, 'moodle/question:config', 'write', 10, 'moodle', 2),
(124, 'moodle/question:flag', 'write', 50, 'moodle', 0),
(125, 'moodle/question:tagmine', 'write', 50, 'moodle', 0),
(126, 'moodle/question:tagall', 'write', 50, 'moodle', 0),
(127, 'moodle/site:doclinks', 'read', 10, 'moodle', 0),
(128, 'moodle/course:sectionvisibility', 'write', 50, 'moodle', 0),
(129, 'moodle/course:useremail', 'write', 50, 'moodle', 0),
(130, 'moodle/course:viewhiddensections', 'write', 50, 'moodle', 0),
(131, 'moodle/course:setcurrentsection', 'write', 50, 'moodle', 0),
(132, 'moodle/course:movesections', 'write', 50, 'moodle', 0),
(133, 'moodle/site:mnetlogintoremote', 'read', 10, 'moodle', 0),
(134, 'moodle/grade:viewall', 'read', 50, 'moodle', 8),
(135, 'moodle/grade:view', 'read', 50, 'moodle', 0),
(136, 'moodle/grade:viewhidden', 'read', 50, 'moodle', 8),
(137, 'moodle/grade:import', 'write', 50, 'moodle', 12),
(138, 'moodle/grade:export', 'read', 50, 'moodle', 8),
(139, 'moodle/grade:manage', 'write', 50, 'moodle', 12),
(140, 'moodle/grade:edit', 'write', 50, 'moodle', 12),
(141, 'moodle/grade:managegradingforms', 'write', 50, 'moodle', 12),
(142, 'moodle/grade:sharegradingforms', 'write', 10, 'moodle', 4),
(143, 'moodle/grade:managesharedforms', 'write', 10, 'moodle', 4),
(144, 'moodle/grade:manageoutcomes', 'write', 50, 'moodle', 0),
(145, 'moodle/grade:manageletters', 'write', 50, 'moodle', 0),
(146, 'moodle/grade:hide', 'write', 50, 'moodle', 0),
(147, 'moodle/grade:lock', 'write', 50, 'moodle', 0),
(148, 'moodle/grade:unlock', 'write', 50, 'moodle', 0),
(149, 'moodle/my:manageblocks', 'write', 10, 'moodle', 0),
(150, 'moodle/notes:view', 'read', 50, 'moodle', 0),
(151, 'moodle/notes:manage', 'write', 50, 'moodle', 16),
(152, 'moodle/tag:manage', 'write', 10, 'moodle', 16),
(153, 'moodle/tag:edit', 'write', 10, 'moodle', 16),
(154, 'moodle/tag:flag', 'write', 10, 'moodle', 16),
(155, 'moodle/tag:editblocks', 'write', 10, 'moodle', 0),
(156, 'moodle/block:view', 'read', 80, 'moodle', 0),
(157, 'moodle/block:edit', 'write', 80, 'moodle', 20),
(158, 'moodle/portfolio:export', 'read', 10, 'moodle', 0),
(159, 'moodle/comment:view', 'read', 50, 'moodle', 0),
(160, 'moodle/comment:post', 'write', 50, 'moodle', 24),
(161, 'moodle/comment:delete', 'write', 50, 'moodle', 32),
(162, 'moodle/webservice:createtoken', 'write', 10, 'moodle', 62),
(163, 'moodle/webservice:managealltokens', 'write', 10, 'moodle', 42),
(164, 'moodle/webservice:createmobiletoken', 'write', 10, 'moodle', 24),
(165, 'moodle/rating:view', 'read', 50, 'moodle', 0),
(166, 'moodle/rating:viewany', 'read', 50, 'moodle', 8),
(167, 'moodle/rating:viewall', 'read', 50, 'moodle', 8),
(168, 'moodle/rating:rate', 'write', 50, 'moodle', 0),
(169, 'moodle/course:publish', 'write', 10, 'moodle', 24),
(170, 'moodle/course:markcomplete', 'write', 50, 'moodle', 0),
(171, 'moodle/course:overridecompletion', 'write', 50, 'moodle', 0),
(172, 'moodle/community:add', 'write', 10, 'moodle', 0),
(173, 'moodle/community:download', 'write', 10, 'moodle', 0),
(174, 'moodle/badges:manageglobalsettings', 'write', 10, 'moodle', 34),
(175, 'moodle/badges:viewbadges', 'read', 50, 'moodle', 0),
(176, 'moodle/badges:manageownbadges', 'write', 30, 'moodle', 0),
(177, 'moodle/badges:viewotherbadges', 'read', 30, 'moodle', 0),
(178, 'moodle/badges:earnbadge', 'write', 50, 'moodle', 0),
(179, 'moodle/badges:createbadge', 'write', 50, 'moodle', 16),
(180, 'moodle/badges:deletebadge', 'write', 50, 'moodle', 32),
(181, 'moodle/badges:configuredetails', 'write', 50, 'moodle', 16),
(182, 'moodle/badges:configurecriteria', 'write', 50, 'moodle', 4),
(183, 'moodle/badges:configuremessages', 'write', 50, 'moodle', 16),
(184, 'moodle/badges:awardbadge', 'write', 50, 'moodle', 16),
(185, 'moodle/badges:revokebadge', 'write', 50, 'moodle', 16),
(186, 'moodle/badges:viewawarded', 'read', 50, 'moodle', 8),
(187, 'moodle/site:forcelanguage', 'read', 10, 'moodle', 0),
(188, 'moodle/search:query', 'read', 10, 'moodle', 0),
(189, 'moodle/competency:competencymanage', 'write', 40, 'moodle', 0),
(190, 'moodle/competency:competencyview', 'read', 40, 'moodle', 0),
(191, 'moodle/competency:competencygrade', 'write', 50, 'moodle', 0),
(192, 'moodle/competency:coursecompetencymanage', 'write', 50, 'moodle', 0),
(193, 'moodle/competency:coursecompetencyconfigure', 'write', 70, 'moodle', 0),
(194, 'moodle/competency:coursecompetencygradable', 'read', 50, 'moodle', 0),
(195, 'moodle/competency:coursecompetencyview', 'read', 50, 'moodle', 0),
(196, 'moodle/competency:evidencedelete', 'write', 30, 'moodle', 0),
(197, 'moodle/competency:planmanage', 'write', 30, 'moodle', 0),
(198, 'moodle/competency:planmanagedraft', 'write', 30, 'moodle', 0),
(199, 'moodle/competency:planmanageown', 'write', 30, 'moodle', 0),
(200, 'moodle/competency:planmanageowndraft', 'write', 30, 'moodle', 0),
(201, 'moodle/competency:planview', 'read', 30, 'moodle', 0),
(202, 'moodle/competency:planviewdraft', 'read', 30, 'moodle', 0),
(203, 'moodle/competency:planviewown', 'read', 30, 'moodle', 0),
(204, 'moodle/competency:planviewowndraft', 'read', 30, 'moodle', 0),
(205, 'moodle/competency:planrequestreview', 'write', 30, 'moodle', 0),
(206, 'moodle/competency:planrequestreviewown', 'write', 30, 'moodle', 0),
(207, 'moodle/competency:planreview', 'write', 30, 'moodle', 0),
(208, 'moodle/competency:plancomment', 'write', 30, 'moodle', 0),
(209, 'moodle/competency:plancommentown', 'write', 30, 'moodle', 0),
(210, 'moodle/competency:usercompetencyview', 'read', 30, 'moodle', 0),
(211, 'moodle/competency:usercompetencyrequestreview', 'write', 30, 'moodle', 0),
(212, 'moodle/competency:usercompetencyrequestreviewown', 'write', 30, 'moodle', 0),
(213, 'moodle/competency:usercompetencyreview', 'write', 30, 'moodle', 0),
(214, 'moodle/competency:usercompetencycomment', 'write', 30, 'moodle', 0),
(215, 'moodle/competency:usercompetencycommentown', 'write', 30, 'moodle', 0),
(216, 'moodle/competency:templatemanage', 'write', 40, 'moodle', 0),
(217, 'moodle/analytics:listinsights', 'read', 50, 'moodle', 8),
(218, 'moodle/analytics:managemodels', 'write', 10, 'moodle', 2),
(219, 'moodle/competency:templateview', 'read', 40, 'moodle', 0),
(220, 'moodle/competency:userevidencemanage', 'write', 30, 'moodle', 0),
(221, 'moodle/competency:userevidencemanageown', 'write', 30, 'moodle', 0),
(222, 'moodle/competency:userevidenceview', 'read', 30, 'moodle', 0),
(223, 'moodle/site:maintenanceaccess', 'write', 10, 'moodle', 0),
(224, 'mod/assign:view', 'read', 70, 'mod_assign', 0),
(225, 'mod/assign:submit', 'write', 70, 'mod_assign', 0),
(226, 'mod/assign:grade', 'write', 70, 'mod_assign', 4),
(227, 'mod/assign:exportownsubmission', 'read', 70, 'mod_assign', 0),
(228, 'mod/assign:addinstance', 'write', 50, 'mod_assign', 4),
(229, 'mod/assign:editothersubmission', 'write', 70, 'mod_assign', 41),
(230, 'mod/assign:grantextension', 'write', 70, 'mod_assign', 0),
(231, 'mod/assign:revealidentities', 'write', 70, 'mod_assign', 0),
(232, 'mod/assign:reviewgrades', 'write', 70, 'mod_assign', 0),
(233, 'mod/assign:releasegrades', 'write', 70, 'mod_assign', 0),
(234, 'mod/assign:managegrades', 'write', 70, 'mod_assign', 0),
(235, 'mod/assign:manageallocations', 'write', 70, 'mod_assign', 0),
(236, 'mod/assign:viewgrades', 'read', 70, 'mod_assign', 0),
(237, 'mod/assign:viewblinddetails', 'write', 70, 'mod_assign', 8),
(238, 'mod/assign:receivegradernotifications', 'read', 70, 'mod_assign', 0),
(239, 'mod/assign:manageoverrides', 'write', 70, 'mod_assign', 0),
(240, 'mod/assignment:view', 'read', 70, 'mod_assignment', 0),
(241, 'mod/assignment:addinstance', 'write', 50, 'mod_assignment', 4),
(242, 'mod/assignment:submit', 'write', 70, 'mod_assignment', 0),
(243, 'mod/assignment:grade', 'write', 70, 'mod_assignment', 4),
(244, 'mod/assignment:exportownsubmission', 'read', 70, 'mod_assignment', 0),
(245, 'mod/book:addinstance', 'write', 50, 'mod_book', 4),
(246, 'mod/book:read', 'read', 70, 'mod_book', 0),
(247, 'mod/book:viewhiddenchapters', 'read', 70, 'mod_book', 0),
(248, 'mod/book:edit', 'write', 70, 'mod_book', 4),
(249, 'mod/chat:addinstance', 'write', 50, 'mod_chat', 4),
(250, 'mod/chat:chat', 'write', 70, 'mod_chat', 16),
(251, 'mod/chat:readlog', 'read', 70, 'mod_chat', 0),
(252, 'mod/chat:deletelog', 'write', 70, 'mod_chat', 0),
(253, 'mod/chat:exportparticipatedsession', 'read', 70, 'mod_chat', 8),
(254, 'mod/chat:exportsession', 'read', 70, 'mod_chat', 8),
(255, 'mod/chat:view', 'read', 70, 'mod_chat', 0),
(256, 'mod/choice:addinstance', 'write', 50, 'mod_choice', 4),
(257, 'mod/choice:choose', 'write', 70, 'mod_choice', 0),
(258, 'mod/choice:readresponses', 'read', 70, 'mod_choice', 0),
(259, 'mod/choice:deleteresponses', 'write', 70, 'mod_choice', 0),
(260, 'mod/choice:downloadresponses', 'read', 70, 'mod_choice', 0),
(261, 'mod/choice:view', 'read', 70, 'mod_choice', 0),
(262, 'mod/data:addinstance', 'write', 50, 'mod_data', 4),
(263, 'mod/data:viewentry', 'read', 70, 'mod_data', 0),
(264, 'mod/data:writeentry', 'write', 70, 'mod_data', 16),
(265, 'mod/data:comment', 'write', 70, 'mod_data', 16),
(266, 'mod/data:rate', 'write', 70, 'mod_data', 0),
(267, 'mod/data:viewrating', 'read', 70, 'mod_data', 0),
(268, 'mod/data:viewanyrating', 'read', 70, 'mod_data', 8),
(269, 'mod/data:viewallratings', 'read', 70, 'mod_data', 8),
(270, 'mod/data:approve', 'write', 70, 'mod_data', 16),
(271, 'mod/data:manageentries', 'write', 70, 'mod_data', 16),
(272, 'mod/data:managecomments', 'write', 70, 'mod_data', 16),
(273, 'mod/data:managetemplates', 'write', 70, 'mod_data', 20),
(274, 'mod/data:viewalluserpresets', 'read', 70, 'mod_data', 0),
(275, 'mod/data:manageuserpresets', 'write', 70, 'mod_data', 20),
(276, 'mod/data:exportentry', 'read', 70, 'mod_data', 8),
(277, 'mod/data:exportownentry', 'read', 70, 'mod_data', 0),
(278, 'mod/data:exportallentries', 'read', 70, 'mod_data', 8),
(279, 'mod/data:exportuserinfo', 'read', 70, 'mod_data', 8),
(280, 'mod/data:view', 'read', 70, 'mod_data', 0),
(281, 'mod/feedback:addinstance', 'write', 50, 'mod_feedback', 4),
(282, 'mod/feedback:view', 'read', 70, 'mod_feedback', 0),
(283, 'mod/feedback:complete', 'write', 70, 'mod_feedback', 16),
(284, 'mod/feedback:viewanalysepage', 'read', 70, 'mod_feedback', 8),
(285, 'mod/feedback:deletesubmissions', 'write', 70, 'mod_feedback', 0),
(286, 'mod/feedback:mapcourse', 'write', 70, 'mod_feedback', 0),
(287, 'mod/feedback:edititems', 'write', 70, 'mod_feedback', 20),
(288, 'mod/feedback:createprivatetemplate', 'write', 70, 'mod_feedback', 16),
(289, 'mod/feedback:createpublictemplate', 'write', 70, 'mod_feedback', 16),
(290, 'mod/feedback:deletetemplate', 'write', 70, 'mod_feedback', 0),
(291, 'mod/feedback:viewreports', 'read', 70, 'mod_feedback', 8),
(292, 'mod/feedback:receivemail', 'read', 70, 'mod_feedback', 8),
(293, 'mod/folder:addinstance', 'write', 50, 'mod_folder', 4),
(294, 'mod/folder:view', 'read', 70, 'mod_folder', 0),
(295, 'mod/folder:managefiles', 'write', 70, 'mod_folder', 16),
(296, 'mod/forum:addinstance', 'write', 50, 'mod_forum', 4),
(297, 'mod/forum:viewdiscussion', 'read', 70, 'mod_forum', 0),
(298, 'mod/forum:viewhiddentimedposts', 'read', 70, 'mod_forum', 0),
(299, 'mod/forum:startdiscussion', 'write', 70, 'mod_forum', 16),
(300, 'mod/forum:replypost', 'write', 70, 'mod_forum', 16),
(301, 'mod/forum:addnews', 'write', 70, 'mod_forum', 16),
(302, 'mod/forum:replynews', 'write', 70, 'mod_forum', 16),
(303, 'mod/forum:viewrating', 'read', 70, 'mod_forum', 0),
(304, 'mod/forum:viewanyrating', 'read', 70, 'mod_forum', 8),
(305, 'mod/forum:viewallratings', 'read', 70, 'mod_forum', 8),
(306, 'mod/forum:rate', 'write', 70, 'mod_forum', 0),
(307, 'mod/forum:createattachment', 'write', 70, 'mod_forum', 16),
(308, 'mod/forum:deleteownpost', 'read', 70, 'mod_forum', 0),
(309, 'mod/forum:deleteanypost', 'read', 70, 'mod_forum', 0),
(310, 'mod/forum:splitdiscussions', 'read', 70, 'mod_forum', 0),
(311, 'mod/forum:movediscussions', 'read', 70, 'mod_forum', 0),
(312, 'mod/forum:pindiscussions', 'write', 70, 'mod_forum', 0),
(313, 'mod/forum:editanypost', 'write', 70, 'mod_forum', 16),
(314, 'mod/forum:viewqandawithoutposting', 'read', 70, 'mod_forum', 0),
(315, 'mod/forum:viewsubscribers', 'read', 70, 'mod_forum', 0),
(316, 'mod/forum:managesubscriptions', 'read', 70, 'mod_forum', 16),
(317, 'mod/forum:postwithoutthrottling', 'write', 70, 'mod_forum', 16),
(318, 'mod/forum:exportdiscussion', 'read', 70, 'mod_forum', 8),
(319, 'mod/forum:exportpost', 'read', 70, 'mod_forum', 8),
(320, 'mod/forum:exportownpost', 'read', 70, 'mod_forum', 8),
(321, 'mod/forum:addquestion', 'write', 70, 'mod_forum', 16),
(322, 'mod/forum:allowforcesubscribe', 'read', 70, 'mod_forum', 0),
(323, 'mod/forum:canposttomygroups', 'write', 70, 'mod_forum', 0),
(324, 'mod/forum:canoverridediscussionlock', 'write', 70, 'mod_forum', 0),
(325, 'mod/glossary:addinstance', 'write', 50, 'mod_glossary', 4),
(326, 'mod/glossary:view', 'read', 70, 'mod_glossary', 0),
(327, 'mod/glossary:write', 'write', 70, 'mod_glossary', 16),
(328, 'mod/glossary:manageentries', 'write', 70, 'mod_glossary', 16),
(329, 'mod/glossary:managecategories', 'write', 70, 'mod_glossary', 16),
(330, 'mod/glossary:comment', 'write', 70, 'mod_glossary', 16),
(331, 'mod/glossary:managecomments', 'write', 70, 'mod_glossary', 16),
(332, 'mod/glossary:import', 'write', 70, 'mod_glossary', 16),
(333, 'mod/glossary:export', 'read', 70, 'mod_glossary', 0),
(334, 'mod/glossary:approve', 'write', 70, 'mod_glossary', 16),
(335, 'mod/glossary:rate', 'write', 70, 'mod_glossary', 0),
(336, 'mod/glossary:viewrating', 'read', 70, 'mod_glossary', 0),
(337, 'mod/glossary:viewanyrating', 'read', 70, 'mod_glossary', 8),
(338, 'mod/glossary:viewallratings', 'read', 70, 'mod_glossary', 8),
(339, 'mod/glossary:exportentry', 'read', 70, 'mod_glossary', 8),
(340, 'mod/glossary:exportownentry', 'read', 70, 'mod_glossary', 0),
(341, 'mod/imscp:view', 'read', 70, 'mod_imscp', 0),
(342, 'mod/imscp:addinstance', 'write', 50, 'mod_imscp', 4),
(343, 'mod/label:addinstance', 'write', 50, 'mod_label', 4),
(344, 'mod/label:view', 'read', 70, 'mod_label', 0),
(345, 'mod/lesson:addinstance', 'write', 50, 'mod_lesson', 4),
(346, 'mod/lesson:edit', 'write', 70, 'mod_lesson', 4),
(347, 'mod/lesson:grade', 'write', 70, 'mod_lesson', 20),
(348, 'mod/lesson:viewreports', 'read', 70, 'mod_lesson', 8),
(349, 'mod/lesson:manage', 'write', 70, 'mod_lesson', 0),
(350, 'mod/lesson:manageoverrides', 'write', 70, 'mod_lesson', 0),
(351, 'mod/lesson:view', 'read', 70, 'mod_lesson', 0),
(352, 'mod/lti:view', 'read', 70, 'mod_lti', 0),
(353, 'mod/lti:addinstance', 'write', 50, 'mod_lti', 4),
(354, 'mod/lti:manage', 'write', 70, 'mod_lti', 8),
(355, 'mod/lti:admin', 'write', 70, 'mod_lti', 8),
(356, 'mod/lti:addcoursetool', 'write', 50, 'mod_lti', 0),
(357, 'mod/lti:requesttooladd', 'write', 50, 'mod_lti', 0),
(358, 'mod/page:view', 'read', 70, 'mod_page', 0),
(359, 'mod/page:addinstance', 'write', 50, 'mod_page', 4),
(360, 'mod/quiz:view', 'read', 70, 'mod_quiz', 0),
(361, 'mod/quiz:addinstance', 'write', 50, 'mod_quiz', 4),
(362, 'mod/quiz:attempt', 'write', 70, 'mod_quiz', 16),
(363, 'mod/quiz:reviewmyattempts', 'read', 70, 'mod_quiz', 0),
(364, 'mod/quiz:manage', 'write', 70, 'mod_quiz', 16),
(365, 'mod/quiz:manageoverrides', 'write', 70, 'mod_quiz', 0),
(366, 'mod/quiz:preview', 'write', 70, 'mod_quiz', 0),
(367, 'mod/quiz:grade', 'write', 70, 'mod_quiz', 20),
(368, 'mod/quiz:regrade', 'write', 70, 'mod_quiz', 16),
(369, 'mod/quiz:viewreports', 'read', 70, 'mod_quiz', 8),
(370, 'mod/quiz:deleteattempts', 'write', 70, 'mod_quiz', 32),
(371, 'mod/quiz:ignoretimelimits', 'read', 70, 'mod_quiz', 0),
(372, 'mod/quiz:emailconfirmsubmission', 'read', 70, 'mod_quiz', 0),
(373, 'mod/quiz:emailnotifysubmission', 'read', 70, 'mod_quiz', 0),
(374, 'mod/quiz:emailwarnoverdue', 'read', 70, 'mod_quiz', 0),
(375, 'mod/resource:view', 'read', 70, 'mod_resource', 0),
(376, 'mod/resource:addinstance', 'write', 50, 'mod_resource', 4),
(377, 'mod/scorm:addinstance', 'write', 50, 'mod_scorm', 4),
(378, 'mod/scorm:viewreport', 'read', 70, 'mod_scorm', 0),
(379, 'mod/scorm:skipview', 'read', 70, 'mod_scorm', 0),
(380, 'mod/scorm:savetrack', 'write', 70, 'mod_scorm', 0),
(381, 'mod/scorm:viewscores', 'read', 70, 'mod_scorm', 0),
(382, 'mod/scorm:deleteresponses', 'write', 70, 'mod_scorm', 0),
(383, 'mod/scorm:deleteownresponses', 'write', 70, 'mod_scorm', 0),
(384, 'mod/survey:addinstance', 'write', 50, 'mod_survey', 4),
(385, 'mod/survey:participate', 'read', 70, 'mod_survey', 0),
(386, 'mod/survey:readresponses', 'read', 70, 'mod_survey', 0),
(387, 'mod/survey:download', 'read', 70, 'mod_survey', 0),
(388, 'mod/url:view', 'read', 70, 'mod_url', 0),
(389, 'mod/url:addinstance', 'write', 50, 'mod_url', 4),
(390, 'mod/wiki:addinstance', 'write', 50, 'mod_wiki', 4),
(391, 'mod/wiki:viewpage', 'read', 70, 'mod_wiki', 0),
(392, 'mod/wiki:editpage', 'write', 70, 'mod_wiki', 16),
(393, 'mod/wiki:createpage', 'write', 70, 'mod_wiki', 16),
(394, 'mod/wiki:viewcomment', 'read', 70, 'mod_wiki', 0),
(395, 'mod/wiki:editcomment', 'write', 70, 'mod_wiki', 16),
(396, 'mod/wiki:managecomment', 'write', 70, 'mod_wiki', 0),
(397, 'mod/wiki:managefiles', 'write', 70, 'mod_wiki', 0),
(398, 'mod/wiki:overridelock', 'write', 70, 'mod_wiki', 0),
(399, 'mod/wiki:managewiki', 'write', 70, 'mod_wiki', 0),
(400, 'mod/workshop:view', 'read', 70, 'mod_workshop', 0),
(401, 'mod/workshop:addinstance', 'write', 50, 'mod_workshop', 4),
(402, 'mod/workshop:switchphase', 'write', 70, 'mod_workshop', 0),
(403, 'mod/workshop:editdimensions', 'write', 70, 'mod_workshop', 4),
(404, 'mod/workshop:submit', 'write', 70, 'mod_workshop', 0),
(405, 'mod/workshop:peerassess', 'write', 70, 'mod_workshop', 0),
(406, 'mod/workshop:manageexamples', 'write', 70, 'mod_workshop', 0),
(407, 'mod/workshop:allocate', 'write', 70, 'mod_workshop', 0),
(408, 'mod/workshop:publishsubmissions', 'write', 70, 'mod_workshop', 0),
(409, 'mod/workshop:viewauthornames', 'read', 70, 'mod_workshop', 0),
(410, 'mod/workshop:viewreviewernames', 'read', 70, 'mod_workshop', 0),
(411, 'mod/workshop:viewallsubmissions', 'read', 70, 'mod_workshop', 0),
(412, 'mod/workshop:viewpublishedsubmissions', 'read', 70, 'mod_workshop', 0),
(413, 'mod/workshop:viewauthorpublished', 'read', 70, 'mod_workshop', 0),
(414, 'mod/workshop:viewallassessments', 'read', 70, 'mod_workshop', 0),
(415, 'mod/workshop:overridegrades', 'write', 70, 'mod_workshop', 0),
(416, 'mod/workshop:ignoredeadlines', 'write', 70, 'mod_workshop', 0),
(417, 'mod/workshop:deletesubmissions', 'write', 70, 'mod_workshop', 0),
(418, 'mod/workshop:exportsubmissions', 'read', 70, 'mod_workshop', 0),
(419, 'auth/oauth2:managelinkedlogins', 'write', 30, 'auth_oauth2', 0),
(420, 'enrol/category:synchronised', 'write', 10, 'enrol_category', 0),
(421, 'enrol/category:config', 'write', 50, 'enrol_category', 0),
(422, 'enrol/cohort:config', 'write', 50, 'enrol_cohort', 0),
(423, 'enrol/cohort:unenrol', 'write', 50, 'enrol_cohort', 0),
(424, 'enrol/database:unenrol', 'write', 50, 'enrol_database', 0),
(425, 'enrol/database:config', 'write', 50, 'enrol_database', 0),
(426, 'enrol/flatfile:manage', 'write', 50, 'enrol_flatfile', 0),
(427, 'enrol/flatfile:unenrol', 'write', 50, 'enrol_flatfile', 0),
(428, 'enrol/guest:config', 'write', 50, 'enrol_guest', 0),
(429, 'enrol/imsenterprise:config', 'write', 50, 'enrol_imsenterprise', 0),
(430, 'enrol/ldap:manage', 'write', 50, 'enrol_ldap', 0),
(431, 'enrol/lti:config', 'write', 50, 'enrol_lti', 0),
(432, 'enrol/lti:unenrol', 'write', 50, 'enrol_lti', 0),
(433, 'enrol/manual:config', 'write', 50, 'enrol_manual', 0),
(434, 'enrol/manual:enrol', 'write', 50, 'enrol_manual', 0),
(435, 'enrol/manual:manage', 'write', 50, 'enrol_manual', 0),
(436, 'enrol/manual:unenrol', 'write', 50, 'enrol_manual', 0),
(437, 'enrol/manual:unenrolself', 'write', 50, 'enrol_manual', 0),
(438, 'enrol/meta:config', 'write', 50, 'enrol_meta', 0),
(439, 'enrol/meta:selectaslinked', 'read', 50, 'enrol_meta', 0),
(440, 'enrol/meta:unenrol', 'write', 50, 'enrol_meta', 0),
(441, 'enrol/mnet:config', 'write', 50, 'enrol_mnet', 0),
(442, 'enrol/paypal:config', 'write', 50, 'enrol_paypal', 0),
(443, 'enrol/paypal:manage', 'write', 50, 'enrol_paypal', 0),
(444, 'enrol/paypal:unenrol', 'write', 50, 'enrol_paypal', 0),
(445, 'enrol/paypal:unenrolself', 'write', 50, 'enrol_paypal', 0),
(446, 'enrol/self:config', 'write', 50, 'enrol_self', 0),
(447, 'enrol/self:manage', 'write', 50, 'enrol_self', 0),
(448, 'enrol/self:holdkey', 'write', 50, 'enrol_self', 0),
(449, 'enrol/self:unenrolself', 'write', 50, 'enrol_self', 0),
(450, 'enrol/self:unenrol', 'write', 50, 'enrol_self', 0),
(451, 'message/airnotifier:managedevice', 'write', 10, 'message_airnotifier', 0),
(452, 'block/activity_modules:addinstance', 'write', 80, 'block_activity_modules', 20),
(453, 'block/activity_results:addinstance', 'write', 80, 'block_activity_results', 20),
(454, 'block/admin_bookmarks:myaddinstance', 'write', 10, 'block_admin_bookmarks', 0),
(455, 'block/admin_bookmarks:addinstance', 'write', 80, 'block_admin_bookmarks', 20),
(456, 'block/badges:addinstance', 'read', 80, 'block_badges', 0),
(457, 'block/badges:myaddinstance', 'read', 10, 'block_badges', 8),
(458, 'block/blog_menu:addinstance', 'write', 80, 'block_blog_menu', 20),
(459, 'block/blog_recent:addinstance', 'write', 80, 'block_blog_recent', 20),
(460, 'block/blog_tags:addinstance', 'write', 80, 'block_blog_tags', 20),
(461, 'block/calendar_month:myaddinstance', 'write', 10, 'block_calendar_month', 0),
(462, 'block/calendar_month:addinstance', 'write', 80, 'block_calendar_month', 20),
(463, 'block/calendar_upcoming:myaddinstance', 'write', 10, 'block_calendar_upcoming', 0),
(464, 'block/calendar_upcoming:addinstance', 'write', 80, 'block_calendar_upcoming', 20),
(465, 'block/comments:myaddinstance', 'write', 10, 'block_comments', 0),
(466, 'block/comments:addinstance', 'write', 80, 'block_comments', 20),
(467, 'block/community:myaddinstance', 'write', 10, 'block_community', 0),
(468, 'block/community:addinstance', 'write', 80, 'block_community', 20),
(469, 'block/completionstatus:addinstance', 'write', 80, 'block_completionstatus', 20),
(470, 'block/course_list:myaddinstance', 'write', 10, 'block_course_list', 0),
(471, 'block/course_list:addinstance', 'write', 80, 'block_course_list', 20),
(472, 'block/course_summary:addinstance', 'write', 80, 'block_course_summary', 20),
(473, 'block/feedback:addinstance', 'write', 80, 'block_feedback', 20),
(474, 'block/globalsearch:myaddinstance', 'write', 10, 'block_globalsearch', 0),
(475, 'block/globalsearch:addinstance', 'write', 80, 'block_globalsearch', 0),
(476, 'block/glossary_random:myaddinstance', 'write', 10, 'block_glossary_random', 0),
(477, 'block/glossary_random:addinstance', 'write', 80, 'block_glossary_random', 20),
(478, 'block/html:myaddinstance', 'write', 10, 'block_html', 0),
(479, 'block/html:addinstance', 'write', 80, 'block_html', 20),
(480, 'block/login:addinstance', 'write', 80, 'block_login', 20),
(481, 'block/lp:addinstance', 'write', 10, 'block_lp', 0),
(482, 'block/lp:myaddinstance', 'write', 10, 'block_lp', 0),
(483, 'block/lp:view', 'read', 10, 'block_lp', 0),
(484, 'block/mentees:myaddinstance', 'write', 10, 'block_mentees', 0),
(485, 'block/mentees:addinstance', 'write', 80, 'block_mentees', 20),
(486, 'block/mnet_hosts:myaddinstance', 'write', 10, 'block_mnet_hosts', 0),
(487, 'block/mnet_hosts:addinstance', 'write', 80, 'block_mnet_hosts', 20),
(488, 'block/myoverview:myaddinstance', 'write', 10, 'block_myoverview', 0),
(489, 'block/myoverview:addinstance', 'write', 80, 'block_myoverview', 20),
(490, 'block/myprofile:myaddinstance', 'write', 10, 'block_myprofile', 0),
(491, 'block/myprofile:addinstance', 'write', 80, 'block_myprofile', 20),
(492, 'block/navigation:myaddinstance', 'write', 10, 'block_navigation', 0),
(493, 'block/navigation:addinstance', 'write', 80, 'block_navigation', 20),
(494, 'block/news_items:myaddinstance', 'write', 10, 'block_news_items', 0),
(495, 'block/news_items:addinstance', 'write', 80, 'block_news_items', 20),
(496, 'block/online_users:myaddinstance', 'write', 10, 'block_online_users', 0),
(497, 'block/online_users:addinstance', 'write', 80, 'block_online_users', 20),
(498, 'block/online_users:viewlist', 'read', 80, 'block_online_users', 0),
(499, 'block/participants:addinstance', 'write', 80, 'block_participants', 20),
(500, 'block/private_files:myaddinstance', 'write', 10, 'block_private_files', 0),
(501, 'block/private_files:addinstance', 'write', 80, 'block_private_files', 20),
(502, 'block/quiz_results:addinstance', 'write', 80, 'block_quiz_results', 20),
(503, 'block/recent_activity:addinstance', 'write', 80, 'block_recent_activity', 20),
(504, 'block/recent_activity:viewaddupdatemodule', 'read', 50, 'block_recent_activity', 0),
(505, 'block/recent_activity:viewdeletemodule', 'read', 50, 'block_recent_activity', 0),
(506, 'block/rss_client:myaddinstance', 'write', 10, 'block_rss_client', 0),
(507, 'block/rss_client:addinstance', 'write', 80, 'block_rss_client', 20),
(508, 'block/rss_client:manageownfeeds', 'write', 80, 'block_rss_client', 0),
(509, 'block/rss_client:manageanyfeeds', 'write', 80, 'block_rss_client', 16),
(510, 'block/search_forums:addinstance', 'write', 80, 'block_search_forums', 20),
(511, 'block/section_links:addinstance', 'write', 80, 'block_section_links', 20),
(512, 'block/selfcompletion:addinstance', 'write', 80, 'block_selfcompletion', 20),
(513, 'block/settings:myaddinstance', 'write', 10, 'block_settings', 0),
(514, 'block/settings:addinstance', 'write', 80, 'block_settings', 20),
(515, 'block/site_main_menu:addinstance', 'write', 80, 'block_site_main_menu', 20),
(516, 'block/social_activities:addinstance', 'write', 80, 'block_social_activities', 20),
(517, 'block/tag_flickr:addinstance', 'write', 80, 'block_tag_flickr', 20),
(518, 'block/tag_youtube:addinstance', 'write', 80, 'block_tag_youtube', 20),
(519, 'block/tags:myaddinstance', 'write', 10, 'block_tags', 0),
(520, 'block/tags:addinstance', 'write', 80, 'block_tags', 20),
(521, 'report/completion:view', 'read', 50, 'report_completion', 8),
(522, 'report/courseoverview:view', 'read', 10, 'report_courseoverview', 8),
(523, 'report/log:view', 'read', 50, 'report_log', 8),
(524, 'report/log:viewtoday', 'read', 50, 'report_log', 8),
(525, 'report/loglive:view', 'read', 50, 'report_loglive', 8),
(526, 'report/outline:view', 'read', 50, 'report_outline', 8),
(527, 'report/outline:viewuserreport', 'read', 50, 'report_outline', 8),
(528, 'report/participation:view', 'read', 50, 'report_participation', 8),
(529, 'report/performance:view', 'read', 10, 'report_performance', 2),
(530, 'report/progress:view', 'read', 50, 'report_progress', 8),
(531, 'report/questioninstances:view', 'read', 10, 'report_questioninstances', 0),
(532, 'report/security:view', 'read', 10, 'report_security', 2),
(533, 'report/stats:view', 'read', 50, 'report_stats', 8),
(534, 'report/usersessions:manageownsessions', 'write', 30, 'report_usersessions', 0),
(535, 'gradeexport/ods:view', 'read', 50, 'gradeexport_ods', 8),
(536, 'gradeexport/ods:publish', 'read', 50, 'gradeexport_ods', 8),
(537, 'gradeexport/txt:view', 'read', 50, 'gradeexport_txt', 8),
(538, 'gradeexport/txt:publish', 'read', 50, 'gradeexport_txt', 8),
(539, 'gradeexport/xls:view', 'read', 50, 'gradeexport_xls', 8),
(540, 'gradeexport/xls:publish', 'read', 50, 'gradeexport_xls', 8),
(541, 'gradeexport/xml:view', 'read', 50, 'gradeexport_xml', 8),
(542, 'gradeexport/xml:publish', 'read', 50, 'gradeexport_xml', 8),
(543, 'gradeimport/csv:view', 'write', 50, 'gradeimport_csv', 0),
(544, 'gradeimport/direct:view', 'write', 50, 'gradeimport_direct', 0),
(545, 'gradeimport/xml:view', 'write', 50, 'gradeimport_xml', 0),
(546, 'gradeimport/xml:publish', 'write', 50, 'gradeimport_xml', 0),
(547, 'gradereport/grader:view', 'read', 50, 'gradereport_grader', 8),
(548, 'gradereport/history:view', 'read', 50, 'gradereport_history', 8),
(549, 'gradereport/outcomes:view', 'read', 50, 'gradereport_outcomes', 8),
(550, 'gradereport/overview:view', 'read', 50, 'gradereport_overview', 8),
(551, 'gradereport/singleview:view', 'read', 50, 'gradereport_singleview', 8),
(552, 'gradereport/user:view', 'read', 50, 'gradereport_user', 8),
(553, 'webservice/rest:use', 'read', 50, 'webservice_rest', 0),
(554, 'webservice/soap:use', 'read', 50, 'webservice_soap', 0),
(555, 'webservice/xmlrpc:use', 'read', 50, 'webservice_xmlrpc', 0),
(556, 'repository/areafiles:view', 'read', 70, 'repository_areafiles', 0),
(557, 'repository/boxnet:view', 'read', 70, 'repository_boxnet', 0),
(558, 'repository/coursefiles:view', 'read', 70, 'repository_coursefiles', 0),
(559, 'repository/dropbox:view', 'read', 70, 'repository_dropbox', 0),
(560, 'repository/equella:view', 'read', 70, 'repository_equella', 0),
(561, 'repository/filesystem:view', 'read', 70, 'repository_filesystem', 0),
(562, 'repository/flickr:view', 'read', 70, 'repository_flickr', 0),
(563, 'repository/flickr_public:view', 'read', 70, 'repository_flickr_public', 0),
(564, 'repository/googledocs:view', 'read', 70, 'repository_googledocs', 0),
(565, 'repository/local:view', 'read', 70, 'repository_local', 0),
(566, 'repository/merlot:view', 'read', 70, 'repository_merlot', 0),
(567, 'repository/onedrive:view', 'read', 70, 'repository_onedrive', 0),
(568, 'repository/picasa:view', 'read', 70, 'repository_picasa', 0),
(569, 'repository/recent:view', 'read', 70, 'repository_recent', 0),
(570, 'repository/s3:view', 'read', 70, 'repository_s3', 0),
(571, 'repository/skydrive:view', 'read', 70, 'repository_skydrive', 0),
(572, 'repository/upload:view', 'read', 70, 'repository_upload', 0),
(573, 'repository/url:view', 'read', 70, 'repository_url', 0),
(574, 'repository/user:view', 'read', 70, 'repository_user', 0),
(575, 'repository/webdav:view', 'read', 70, 'repository_webdav', 0),
(576, 'repository/wikimedia:view', 'read', 70, 'repository_wikimedia', 0),
(577, 'repository/youtube:view', 'read', 70, 'repository_youtube', 0),
(578, 'tool/customlang:view', 'read', 10, 'tool_customlang', 2),
(579, 'tool/customlang:edit', 'write', 10, 'tool_customlang', 6),
(580, 'tool/dataprivacy:managedatarequests', 'write', 10, 'tool_dataprivacy', 60),
(581, 'tool/dataprivacy:managedataregistry', 'write', 10, 'tool_dataprivacy', 60),
(582, 'tool/dataprivacy:makedatarequestsforchildren', 'write', 30, 'tool_dataprivacy', 24),
(583, 'tool/dataprivacy:downloadownrequest', 'read', 30, 'tool_dataprivacy', 0),
(584, 'tool/dataprivacy:downloadallrequests', 'read', 30, 'tool_dataprivacy', 8),
(585, 'tool/lpmigrate:frameworksmigrate', 'write', 10, 'tool_lpmigrate', 0),
(586, 'tool/monitor:subscribe', 'read', 50, 'tool_monitor', 8),
(587, 'tool/monitor:managerules', 'write', 50, 'tool_monitor', 4),
(588, 'tool/monitor:managetool', 'write', 10, 'tool_monitor', 4),
(589, 'tool/policy:accept', 'write', 10, 'tool_policy', 0),
(590, 'tool/policy:acceptbehalf', 'write', 30, 'tool_policy', 8),
(591, 'tool/policy:managedocs', 'write', 10, 'tool_policy', 0),
(592, 'tool/policy:viewacceptances', 'read', 10, 'tool_policy', 0),
(593, 'tool/recyclebin:deleteitems', 'write', 50, 'tool_recyclebin', 32),
(594, 'tool/recyclebin:restoreitems', 'write', 50, 'tool_recyclebin', 0),
(595, 'tool/recyclebin:viewitems', 'read', 50, 'tool_recyclebin', 0),
(596, 'tool/uploaduser:uploaduserpictures', 'write', 10, 'tool_uploaduser', 16),
(597, 'tool/usertours:managetours', 'write', 10, 'tool_usertours', 4),
(598, 'booktool/exportimscp:export', 'read', 70, 'booktool_exportimscp', 0),
(599, 'booktool/importhtml:import', 'write', 70, 'booktool_importhtml', 4),
(600, 'booktool/print:print', 'read', 70, 'booktool_print', 0),
(601, 'quiz/grading:viewstudentnames', 'read', 70, 'quiz_grading', 0),
(602, 'quiz/grading:viewidnumber', 'read', 70, 'quiz_grading', 0),
(603, 'quiz/statistics:view', 'read', 70, 'quiz_statistics', 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]chat`
--

CREATE TABLE `[[dbprefix]]chat` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `intro` longtext NOT NULL,
  `introformat` smallint(4) NOT NULL DEFAULT '0',
  `keepdays` bigint(11) NOT NULL DEFAULT '0',
  `studentlogs` smallint(4) NOT NULL DEFAULT '0',
  `chattime` bigint(10) NOT NULL DEFAULT '0',
  `schedule` smallint(4) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]chat_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Each of these is a chat room' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]chat_messages`
--

CREATE TABLE `[[dbprefix]]chat_messages` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `chatid` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `groupid` bigint(10) NOT NULL DEFAULT '0',
  `issystem` tinyint(1) NOT NULL DEFAULT '0',
  `message` longtext NOT NULL,
  `timestamp` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]chatmess_use_ix` (`userid`),
  KEY `[[dbprefix]]chatmess_gro_ix` (`groupid`),
  KEY `[[dbprefix]]chatmess_timcha_ix` (`timestamp`,`chatid`),
  KEY `[[dbprefix]]chatmess_cha_ix` (`chatid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Stores all the actual chat messages' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]chat_messages_current`
--

CREATE TABLE `[[dbprefix]]chat_messages_current` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `chatid` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `groupid` bigint(10) NOT NULL DEFAULT '0',
  `issystem` tinyint(1) NOT NULL DEFAULT '0',
  `message` longtext NOT NULL,
  `timestamp` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]chatmesscurr_use_ix` (`userid`),
  KEY `[[dbprefix]]chatmesscurr_gro_ix` (`groupid`),
  KEY `[[dbprefix]]chatmesscurr_timcha_ix` (`timestamp`,`chatid`),
  KEY `[[dbprefix]]chatmesscurr_cha_ix` (`chatid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Stores current session' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]chat_users`
--

CREATE TABLE `[[dbprefix]]chat_users` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `chatid` bigint(11) NOT NULL DEFAULT '0',
  `userid` bigint(11) NOT NULL DEFAULT '0',
  `groupid` bigint(11) NOT NULL DEFAULT '0',
  `version` varchar(16) NOT NULL DEFAULT '',
  `ip` varchar(45) NOT NULL DEFAULT '',
  `firstping` bigint(10) NOT NULL DEFAULT '0',
  `lastping` bigint(10) NOT NULL DEFAULT '0',
  `lastmessageping` bigint(10) NOT NULL DEFAULT '0',
  `sid` varchar(32) NOT NULL DEFAULT '',
  `course` bigint(10) NOT NULL DEFAULT '0',
  `lang` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]chatuser_use_ix` (`userid`),
  KEY `[[dbprefix]]chatuser_las_ix` (`lastping`),
  KEY `[[dbprefix]]chatuser_gro_ix` (`groupid`),
  KEY `[[dbprefix]]chatuser_cha_ix` (`chatid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Keeps track of which users are in which chat rooms' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]choice`
--

CREATE TABLE `[[dbprefix]]choice` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `intro` longtext NOT NULL,
  `introformat` smallint(4) NOT NULL DEFAULT '0',
  `publish` tinyint(2) NOT NULL DEFAULT '0',
  `showresults` tinyint(2) NOT NULL DEFAULT '0',
  `display` smallint(4) NOT NULL DEFAULT '0',
  `allowupdate` tinyint(2) NOT NULL DEFAULT '0',
  `allowmultiple` tinyint(2) NOT NULL DEFAULT '0',
  `showunanswered` tinyint(2) NOT NULL DEFAULT '0',
  `includeinactive` tinyint(2) NOT NULL DEFAULT '1',
  `limitanswers` tinyint(2) NOT NULL DEFAULT '0',
  `timeopen` bigint(10) NOT NULL DEFAULT '0',
  `timeclose` bigint(10) NOT NULL DEFAULT '0',
  `showpreview` tinyint(2) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `completionsubmit` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]choi_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Available choices are stored here' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]choice_answers`
--

CREATE TABLE `[[dbprefix]]choice_answers` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `choiceid` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `optionid` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]choiansw_use_ix` (`userid`),
  KEY `[[dbprefix]]choiansw_cho_ix` (`choiceid`),
  KEY `[[dbprefix]]choiansw_opt_ix` (`optionid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='choices performed by users' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]choice_options`
--

CREATE TABLE `[[dbprefix]]choice_options` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `choiceid` bigint(10) NOT NULL DEFAULT '0',
  `text` longtext,
  `maxanswers` bigint(10) DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]choiopti_cho_ix` (`choiceid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='available options to choice' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cohort`
--

CREATE TABLE `[[dbprefix]]cohort` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `contextid` bigint(10) NOT NULL,
  `name` varchar(254) NOT NULL DEFAULT '',
  `idnumber` varchar(100) DEFAULT NULL,
  `description` longtext,
  `descriptionformat` tinyint(2) NOT NULL,
  `visible` tinyint(1) NOT NULL DEFAULT '1',
  `component` varchar(100) NOT NULL DEFAULT '',
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `theme` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]coho_con_ix` (`contextid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Each record represents one cohort (aka site-wide group).' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cohort_members`
--

CREATE TABLE `[[dbprefix]]cohort_members` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `cohortid` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `timeadded` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]cohomemb_cohuse_uix` (`cohortid`,`userid`),
  KEY `[[dbprefix]]cohomemb_coh_ix` (`cohortid`),
  KEY `[[dbprefix]]cohomemb_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Link a user to a cohort.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]comments`
--

CREATE TABLE `[[dbprefix]]comments` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `contextid` bigint(10) NOT NULL,
  `component` varchar(255) DEFAULT NULL,
  `commentarea` varchar(255) NOT NULL DEFAULT '',
  `itemid` bigint(10) NOT NULL,
  `content` longtext NOT NULL,
  `format` tinyint(2) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]comm_concomite_ix` (`contextid`,`commentarea`,`itemid`),
  KEY `[[dbprefix]]comm_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='moodle comments module' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]competency`
--

CREATE TABLE `[[dbprefix]]competency` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `shortname` varchar(100) DEFAULT NULL,
  `description` longtext,
  `descriptionformat` smallint(4) NOT NULL DEFAULT '0',
  `idnumber` varchar(100) DEFAULT NULL,
  `competencyframeworkid` bigint(10) NOT NULL,
  `parentid` bigint(10) NOT NULL DEFAULT '0',
  `path` varchar(255) NOT NULL DEFAULT '',
  `sortorder` bigint(10) NOT NULL,
  `ruletype` varchar(100) DEFAULT NULL,
  `ruleoutcome` tinyint(2) NOT NULL DEFAULT '0',
  `ruleconfig` longtext,
  `scaleid` bigint(10) DEFAULT NULL,
  `scaleconfiguration` longtext,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `usermodified` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]comp_comidn_uix` (`competencyframeworkid`,`idnumber`),
  KEY `[[dbprefix]]comp_rul_ix` (`ruleoutcome`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='This table contains the master record of each competency in ' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]competency_coursecomp`
--

CREATE TABLE `[[dbprefix]]competency_coursecomp` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `courseid` bigint(10) NOT NULL,
  `competencyid` bigint(10) NOT NULL,
  `ruleoutcome` tinyint(2) NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `usermodified` bigint(10) NOT NULL,
  `sortorder` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]compcour_coucom_uix` (`courseid`,`competencyid`),
  KEY `[[dbprefix]]compcour_courul_ix` (`courseid`,`ruleoutcome`),
  KEY `[[dbprefix]]compcour_cou2_ix` (`courseid`),
  KEY `[[dbprefix]]compcour_com_ix` (`competencyid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Link a competency to a course.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]competency_coursecompsetting`
--

CREATE TABLE `[[dbprefix]]competency_coursecompsetting` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `courseid` bigint(10) NOT NULL,
  `pushratingstouserplans` tinyint(2) DEFAULT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `usermodified` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]compcour_cou_uix` (`courseid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='This table contains the course specific settings for compete' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]competency_evidence`
--

CREATE TABLE `[[dbprefix]]competency_evidence` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `usercompetencyid` bigint(10) NOT NULL,
  `contextid` bigint(10) NOT NULL,
  `action` tinyint(2) NOT NULL,
  `actionuserid` bigint(10) DEFAULT NULL,
  `descidentifier` varchar(255) NOT NULL DEFAULT '',
  `desccomponent` varchar(255) NOT NULL DEFAULT '',
  `desca` longtext,
  `url` varchar(255) DEFAULT NULL,
  `grade` bigint(10) DEFAULT NULL,
  `note` longtext,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `usermodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]compevid_use_ix` (`usercompetencyid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='The evidence linked to a user competency' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]competency_framework`
--

CREATE TABLE `[[dbprefix]]competency_framework` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `shortname` varchar(100) DEFAULT NULL,
  `contextid` bigint(10) NOT NULL,
  `idnumber` varchar(100) DEFAULT NULL,
  `description` longtext,
  `descriptionformat` smallint(4) NOT NULL DEFAULT '0',
  `scaleid` bigint(11) DEFAULT NULL,
  `scaleconfiguration` longtext NOT NULL,
  `visible` tinyint(2) NOT NULL DEFAULT '1',
  `taxonomies` varchar(255) NOT NULL DEFAULT '',
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `usermodified` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]compfram_idn_uix` (`idnumber`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='List of competency frameworks.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]competency_modulecomp`
--

CREATE TABLE `[[dbprefix]]competency_modulecomp` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `cmid` bigint(10) NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `usermodified` bigint(10) NOT NULL,
  `sortorder` bigint(10) NOT NULL,
  `competencyid` bigint(10) NOT NULL,
  `ruleoutcome` tinyint(2) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]compmodu_cmicom_uix` (`cmid`,`competencyid`),
  KEY `[[dbprefix]]compmodu_cmirul_ix` (`cmid`,`ruleoutcome`),
  KEY `[[dbprefix]]compmodu_cmi_ix` (`cmid`),
  KEY `[[dbprefix]]compmodu_com_ix` (`competencyid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Link a competency to a module.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]competency_plan`
--

CREATE TABLE `[[dbprefix]]competency_plan` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL DEFAULT '',
  `description` longtext,
  `descriptionformat` smallint(4) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL,
  `templateid` bigint(10) DEFAULT NULL,
  `origtemplateid` bigint(10) DEFAULT NULL,
  `status` tinyint(1) NOT NULL,
  `duedate` bigint(10) DEFAULT '0',
  `reviewerid` bigint(10) DEFAULT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `usermodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]compplan_usesta_ix` (`userid`,`status`),
  KEY `[[dbprefix]]compplan_tem_ix` (`templateid`),
  KEY `[[dbprefix]]compplan_stadue_ix` (`status`,`duedate`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Learning plans' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]competency_plancomp`
--

CREATE TABLE `[[dbprefix]]competency_plancomp` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `planid` bigint(10) NOT NULL,
  `competencyid` bigint(10) NOT NULL,
  `sortorder` bigint(10) DEFAULT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) DEFAULT NULL,
  `usermodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]compplan_placom_uix` (`planid`,`competencyid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Plan competencies' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]competency_relatedcomp`
--

CREATE TABLE `[[dbprefix]]competency_relatedcomp` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `competencyid` bigint(10) NOT NULL,
  `relatedcompetencyid` bigint(10) NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) DEFAULT NULL,
  `usermodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Related competencies' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]competency_template`
--

CREATE TABLE `[[dbprefix]]competency_template` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `shortname` varchar(100) DEFAULT NULL,
  `contextid` bigint(10) NOT NULL,
  `description` longtext,
  `descriptionformat` smallint(4) NOT NULL DEFAULT '0',
  `visible` tinyint(2) NOT NULL DEFAULT '1',
  `duedate` bigint(10) DEFAULT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `usermodified` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Learning plan templates.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]competency_templatecohort`
--

CREATE TABLE `[[dbprefix]]competency_templatecohort` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `templateid` bigint(10) NOT NULL,
  `cohortid` bigint(10) NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `usermodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]comptemp_temcoh_uix` (`templateid`,`cohortid`),
  KEY `[[dbprefix]]comptemp_tem2_ix` (`templateid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Default comment for the table, please edit me' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]competency_templatecomp`
--

CREATE TABLE `[[dbprefix]]competency_templatecomp` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `templateid` bigint(10) NOT NULL,
  `competencyid` bigint(10) NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `usermodified` bigint(10) NOT NULL,
  `sortorder` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]comptemp_tem_ix` (`templateid`),
  KEY `[[dbprefix]]comptemp_com_ix` (`competencyid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Link a competency to a learning plan template.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]competency_usercomp`
--

CREATE TABLE `[[dbprefix]]competency_usercomp` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL,
  `competencyid` bigint(10) NOT NULL,
  `status` tinyint(2) NOT NULL DEFAULT '0',
  `reviewerid` bigint(10) DEFAULT NULL,
  `proficiency` tinyint(2) DEFAULT NULL,
  `grade` bigint(10) DEFAULT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) DEFAULT NULL,
  `usermodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]compuser_usecom_uix` (`userid`,`competencyid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='User competencies' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]competency_usercompcourse`
--

CREATE TABLE `[[dbprefix]]competency_usercompcourse` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL,
  `courseid` bigint(10) NOT NULL,
  `competencyid` bigint(10) NOT NULL,
  `proficiency` tinyint(2) DEFAULT NULL,
  `grade` bigint(10) DEFAULT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) DEFAULT NULL,
  `usermodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]compuser_usecoucom_uix` (`userid`,`courseid`,`competencyid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='User competencies in a course' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]competency_usercompplan`
--

CREATE TABLE `[[dbprefix]]competency_usercompplan` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL,
  `competencyid` bigint(10) NOT NULL,
  `planid` bigint(10) NOT NULL,
  `proficiency` tinyint(2) DEFAULT NULL,
  `grade` bigint(10) DEFAULT NULL,
  `sortorder` bigint(10) DEFAULT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) DEFAULT NULL,
  `usermodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]compuser_usecompla_uix` (`userid`,`competencyid`,`planid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='User competencies plans' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]competency_userevidence`
--

CREATE TABLE `[[dbprefix]]competency_userevidence` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL,
  `name` varchar(100) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `descriptionformat` tinyint(1) NOT NULL,
  `url` longtext NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `usermodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]compuser_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='The evidence of prior learning' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]competency_userevidencecomp`
--

CREATE TABLE `[[dbprefix]]competency_userevidencecomp` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userevidenceid` bigint(10) NOT NULL,
  `competencyid` bigint(10) NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `usermodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]compuser_usecom2_uix` (`userevidenceid`,`competencyid`),
  KEY `[[dbprefix]]compuser_use2_ix` (`userevidenceid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Relationship between user evidence and competencies' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]config`
--

CREATE TABLE `[[dbprefix]]config` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `value` longtext NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]conf_nam_uix` (`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Moodle configuration variables' AUTO_INCREMENT=470 ;

--
-- Dumping data for table `[[dbprefix]]config`
--

INSERT INTO `[[dbprefix]]config` VALUES
(2, 'rolesactive', '1'),
(3, 'auth', 'email'),
(4, 'enrol_plugins_enabled', 'manual,guest,self,cohort'),
(5, 'theme', 'boost'),
(6, 'filter_multilang_converted', '1'),
(7, 'siteidentifier', '[[siteidentifier]][[domhost]]'),
(8, 'backup_version', '2008111700'),
(9, 'backup_release', '2.0 dev'),
(10, 'mnet_dispatcher_mode', 'off'),
(11, 'sessiontimeout', '7200'),
(12, 'stringfilters', ''),
(13, 'filterall', '0'),
(14, 'texteditors', 'atto,tinymce,textarea'),
(15, 'antiviruses', ''),
(16, 'media_plugins_sortorder', 'videojs,youtube,swf'),
(17, 'upgrade_extracreditweightsstepignored', '1'),
(18, 'upgrade_calculatedgradeitemsignored', '1'),
(19, 'upgrade_letterboundarycourses', '1'),
(20, 'mnet_localhost_id', '1'),
(21, 'mnet_all_hosts_id', '2'),
(22, 'siteguest', '1'),
(23, 'siteadmins', '2'),
(24, 'themerev', '[[timestamp]]'),
(25, 'jsrev', '[[timestamp]]'),
(26, 'gdversion', '2'),
(27, 'licenses', 'unknown,allrightsreserved,public,cc,cc-nd,cc-nc-nd,cc-nc,cc-nc-sa,cc-sa'),
(28, 'version', '2018051718'),
(29, 'enableoutcomes', '0'),
(30, 'usecomments', '1'),
(31, 'usetags', '1'),
(32, 'enablenotes', '1'),
(33, 'enableportfolios', '0'),
(34, 'enablewebservices', '0'),
(35, 'messaging', '1'),
(36, 'messagingdeletereadnotificationsdelay', '604800'),
(37, 'messagingdeleteallnotificationsdelay', '2620800'),
(38, 'messagingallowemailoverride', '0'),
(39, 'enablestats', '0'),
(40, 'enablerssfeeds', '0'),
(41, 'enableblogs', '1'),
(42, 'enablecompletion', '1'),
(43, 'completiondefault', '1'),
(44, 'enableavailability', '1'),
(45, 'enableplagiarism', '0'),
(46, 'enablebadges', '1'),
(47, 'enableglobalsearch', '0'),
(48, 'allowstealth', '0'),
(49, 'defaultpreference_maildisplay', '2'),
(50, 'defaultpreference_mailformat', '1'),
(51, 'defaultpreference_maildigest', '0'),
(52, 'defaultpreference_autosubscribe', '1'),
(53, 'defaultpreference_trackforums', '0'),
(54, 'autologinguests', '0'),
(55, 'hiddenuserfields', ''),
(56, 'showuseridentity', 'email'),
(57, 'fullnamedisplay', 'language'),
(58, 'alternativefullnameformat', 'language'),
(59, 'maxusersperpage', '100'),
(60, 'enablegravatar', '0'),
(61, 'gravatardefaulturl', 'mm'),
(62, 'agedigitalconsentverification', '0'),
(63, 'agedigitalconsentmap', '*, 16\nAT, 14\nES, 14\nUS, 13'),
(64, 'sitepolicy', ''),
(65, 'sitepolicyguest', ''),
(66, 'enablecourserequests', '0'),
(67, 'defaultrequestcategory', '1'),
(68, 'requestcategoryselection', '0'),
(69, 'courserequestnotify', ''),
(70, 'grade_profilereport', 'user'),
(71, 'grade_aggregationposition', '1'),
(72, 'grade_includescalesinaggregation', '1'),
(73, 'grade_hiddenasdate', '0'),
(74, 'gradepublishing', '0'),
(75, 'grade_export_exportfeedback', '0'),
(76, 'grade_export_displaytype', '1'),
(77, 'grade_export_decimalpoints', '2'),
(78, 'grade_navmethod', '1'),
(79, 'grade_export_userprofilefields', 'firstname,lastname,idnumber,institution,department,email'),
(80, 'grade_export_customprofilefields', ''),
(81, 'recovergradesdefault', '0'),
(82, 'gradeexport', ''),
(83, 'unlimitedgrades', '0'),
(84, 'grade_report_showmin', '1'),
(85, 'gradepointmax', '100'),
(86, 'gradepointdefault', '100'),
(87, 'grade_minmaxtouse', '1'),
(88, 'grade_mygrades_report', 'overview'),
(89, 'gradereport_mygradeurl', ''),
(90, 'grade_hideforcedsettings', '1'),
(91, 'grade_aggregation', '13'),
(92, 'grade_aggregation_flag', '0'),
(93, 'grade_aggregations_visible', '13'),
(94, 'grade_aggregateonlygraded', '1'),
(95, 'grade_aggregateonlygraded_flag', '2'),
(96, 'grade_aggregateoutcomes', '0'),
(97, 'grade_aggregateoutcomes_flag', '2'),
(98, 'grade_keephigh', '0'),
(99, 'grade_keephigh_flag', '3'),
(100, 'grade_droplow', '0'),
(101, 'grade_droplow_flag', '2'),
(102, 'grade_overridecat', '1'),
(103, 'grade_displaytype', '1'),
(104, 'grade_decimalpoints', '2'),
(105, 'grade_item_advanced', 'iteminfo,idnumber,gradepass,plusfactor,multfactor,display,decimals,hiddenuntil,locktime'),
(106, 'grade_report_studentsperpage', '100'),
(107, 'grade_report_showonlyactiveenrol', '1'),
(108, 'grade_report_quickgrading', '1'),
(109, 'grade_report_showquickfeedback', '0'),
(110, 'grade_report_meanselection', '1'),
(111, 'grade_report_enableajax', '0'),
(112, 'grade_report_showcalculations', '1'),
(113, 'grade_report_showeyecons', '0'),
(114, 'grade_report_showaverages', '1'),
(115, 'grade_report_showlocks', '0'),
(116, 'grade_report_showranges', '0'),
(117, 'grade_report_showanalysisicon', '1'),
(118, 'grade_report_showuserimage', '1'),
(119, 'grade_report_showactivityicons', '1'),
(120, 'grade_report_shownumberofgrades', '0'),
(121, 'grade_report_averagesdisplaytype', 'inherit'),
(122, 'grade_report_rangesdisplaytype', 'inherit'),
(123, 'grade_report_averagesdecimalpoints', 'inherit'),
(124, 'grade_report_rangesdecimalpoints', 'inherit'),
(125, 'grade_report_historyperpage', '50'),
(126, 'grade_report_overview_showrank', '0'),
(127, 'grade_report_overview_showtotalsifcontainhidden', '0'),
(128, 'grade_report_user_showrank', '0'),
(129, 'grade_report_user_showpercentage', '1'),
(130, 'grade_report_user_showgrade', '1'),
(131, 'grade_report_user_showfeedback', '1'),
(132, 'grade_report_user_showrange', '1'),
(133, 'grade_report_user_showweight', '1'),
(134, 'grade_report_user_showaverage', '0'),
(135, 'grade_report_user_showlettergrade', '0'),
(136, 'grade_report_user_rangedecimals', '0'),
(137, 'grade_report_user_showhiddenitems', '1'),
(138, 'grade_report_user_showtotalsifcontainhidden', '0'),
(139, 'grade_report_user_showcontributiontocoursetotal', '1'),
(140, 'badges_defaultissuername', ''),
(141, 'badges_defaultissuercontact', ''),
(142, 'badges_badgesalt', 'badges[[timestamp]]'),
(143, 'badges_allowexternalbackpack', '1'),
(144, 'badges_allowcoursebadges', '1'),
(146, 'forcetimezone', '99'),
(147, 'country', '0'),
(148, 'defaultcity', ''),
(149, 'geoip2file', '[[softdatadir]]/geoip/GeoLite2-City.mmdb'),
(150, 'googlemapkey3', ''),
(151, 'allcountrycodes', ''),
(152, 'autolang', '1'),
(153, 'lang', '[[language]]'),
(154, 'langmenu', '1'),
(155, 'langlist', ''),
(156, 'langrev', '[[timestamp]]'),
(157, 'langcache', '1'),
(158, 'langstringcache', '1'),
(159, 'locale', ''),
(160, 'latinexcelexport', '0'),
(161, 'requiremodintro', '0'),
(163, 'authloginviaemail', '0'),
(164, 'allowaccountssameemail', '0'),
(165, 'authpreventaccountcreation', '0'),
(166, 'loginpageautofocus', '0'),
(167, 'guestloginbutton', '1'),
(168, 'limitconcurrentlogins', '0'),
(169, 'alternateloginurl', ''),
(170, 'forgottenpasswordurl', ''),
(171, 'auth_instructions', ''),
(172, 'allowemailaddresses', ''),
(173, 'denyemailaddresses', ''),
(174, 'verifychangedemail', '1'),
(175, 'recaptchapublickey', ''),
(176, 'recaptchaprivatekey', ''),
(177, 'filteruploadedfiles', '0'),
(178, 'filtermatchoneperpage', '0'),
(179, 'filtermatchonepertext', '0'),
(180, 'sitedefaultlicense', 'allrightsreserved'),
(181, 'media_default_width', '400'),
(182, 'media_default_height', '300'),
(183, 'portfolio_moderate_filesize_threshold', '1048576'),
(184, 'portfolio_high_filesize_threshold', '5242880'),
(185, 'portfolio_moderate_db_threshold', '20'),
(186, 'portfolio_high_db_threshold', '50'),
(187, 'repositorycacheexpire', '120'),
(188, 'repositorygetfiletimeout', '30'),
(189, 'repositorysyncfiletimeout', '1'),
(190, 'repositorysyncimagetimeout', '3'),
(191, 'repositoryallowexternallinks', '1'),
(192, 'legacyfilesinnewcourses', '0'),
(193, 'legacyfilesaddallowed', '1'),
(194, 'searchengine', 'simpledb'),
(195, 'searchindexwhendisabled', '0'),
(196, 'searchindextime', '600'),
(197, 'searchallavailablecourses', '0'),
(198, 'enablewsdocumentation', '0'),
(199, 'allowbeforeblock', '0'),
(200, 'allowedip', ''),
(201, 'blockedip', ''),
(202, 'protectusernames', '1'),
(203, 'forcelogin', '0'),
(204, 'forceloginforprofiles', '1'),
(205, 'forceloginforprofileimage', '0'),
(206, 'opentogoogle', '0'),
(207, 'allowindexing', '0'),
(208, 'maxbytes', '0'),
(209, 'userquota', '104857600'),
(210, 'allowobjectembed', '0'),
(211, 'enabletrusttext', '0'),
(212, 'maxeditingtime', '1800'),
(213, 'extendedusernamechars', '0'),
(214, 'keeptagnamecase', '1'),
(215, 'profilesforenrolledusersonly', '1'),
(216, 'cronclionly', '1'),
(217, 'cronremotepassword', ''),
(218, 'lockoutthreshold', '0'),
(219, 'lockoutwindow', '1800'),
(220, 'lockoutduration', '1800'),
(221, 'passwordpolicy', '1'),
(222, 'minpasswordlength', '8'),
(223, 'minpassworddigits', '1'),
(224, 'minpasswordlower', '1'),
(225, 'minpasswordupper', '1'),
(226, 'minpasswordnonalphanum', '1'),
(227, 'maxconsecutiveidentchars', '0'),
(228, 'passwordreuselimit', '0'),
(229, 'pwresettime', '1800'),
(230, 'passwordchangelogout', '0'),
(231, 'passwordchangetokendeletion', '0'),
(232, 'tokenduration', '7257600'),
(233, 'groupenrolmentkeypolicy', '1'),
(234, 'disableuserimages', '0'),
(235, 'emailchangeconfirmation', '1'),
(236, 'rememberusername', '2'),
(237, 'strictformsrequired', '0'),
(238, 'cookiesecure', '1'),
(239, 'cookiehttponly', '0'),
(240, 'allowframembedding', '0'),
(241, 'curlsecurityblockedhosts', ''),
(242, 'curlsecurityallowedport', ''),
(243, 'displayloginfailures', '0'),
(244, 'notifyloginfailures', ''),
(245, 'notifyloginthreshold', '10'),
(246, 'themelist', ''),
(247, 'themedesignermode', '0'),
(248, 'allowuserthemes', '0'),
(249, 'allowcoursethemes', '0'),
(250, 'allowcategorythemes', '0'),
(251, 'allowcohortthemes', '0'),
(252, 'allowthemechangeonurl', '0'),
(253, 'allowuserblockhiding', '1'),
(254, 'allowblockstodock', '1'),
(255, 'custommenuitems', ''),
(256, 'customusermenuitems', 'grades,grades|/grade/report/mygrades.php|grades\nmessages,message|/message/index.php|message\npreferences,moodle|/user/preferences.php|preferences'),
(257, 'enabledevicedetection', '1'),
(258, 'devicedetectregex', '[]'),
(259, 'calendartype', 'gregorian'),
(260, 'calendar_adminseesall', '0'),
(261, 'calendar_site_timeformat', '0'),
(262, 'calendar_startwday', '1'),
(263, 'calendar_weekend', '65'),
(264, 'calendar_lookahead', '21'),
(265, 'calendar_maxevents', '10'),
(266, 'enablecalendarexport', '1'),
(267, 'calendar_customexport', '1'),
(268, 'calendar_exportlookahead', '365'),
(269, 'calendar_exportlookback', '5'),
(270, 'calendar_exportsalt', '[[export_salt]]'),
(271, 'calendar_showicalsource', '1'),
(272, 'useblogassociations', '1'),
(273, 'bloglevel', '4'),
(274, 'useexternalblogs', '1'),
(275, 'externalblogcrontime', '86400'),
(276, 'maxexternalblogsperuser', '1'),
(277, 'blogusecomments', '1'),
(278, 'blogshowcommentscount', '1'),
(279, 'defaulthomepage', '1'),
(280, 'allowguestmymoodle', '1'),
(281, 'navshowfullcoursenames', '0'),
(282, 'navshowcategories', '1'),
(283, 'navshowmycoursecategories', '0'),
(284, 'navshowallcourses', '0'),
(285, 'navsortmycoursessort', 'sortorder'),
(286, 'navcourselimit', '10'),
(287, 'usesitenameforsitepages', '0'),
(288, 'linkadmincategories', '1'),
(289, 'linkcoursesections', '1'),
(290, 'navshowfrontpagemods', '1'),
(291, 'navadduserpostslinks', '1'),
(292, 'formatstringstriptags', '1'),
(293, 'emoticons', '[{"text":":-)","imagename":"s\\/smiley","imagecomponent":"core","altidentifier":"smiley","altcomponent":"core_pix"},{"text":":)","imagename":"s\\/smiley","imagecomponent":"core","altidentifier":"smiley","altcomponent":"core_pix"},{"text":":-D","imagename":"s\\/biggrin","imagecomponent":"core","altidentifier":"biggrin","altcomponent":"core_pix"},{"text":";-)","imagename":"s\\/wink","imagecomponent":"core","altidentifier":"wink","altcomponent":"core_pix"},{"text":":-\\/","imagename":"s\\/mixed","imagecomponent":"core","altidentifier":"mixed","altcomponent":"core_pix"},{"text":"V-.","imagename":"s\\/thoughtful","imagecomponent":"core","altidentifier":"thoughtful","altcomponent":"core_pix"},{"text":":-P","imagename":"s\\/tongueout","imagecomponent":"core","altidentifier":"tongueout","altcomponent":"core_pix"},{"text":":-p","imagename":"s\\/tongueout","imagecomponent":"core","altidentifier":"tongueout","altcomponent":"core_pix"},{"text":"B-)","imagename":"s\\/cool","imagecomponent":"core","altidentifier":"cool","altcomponent":"core_pix"},{"text":"^-)","imagename":"s\\/approve","imagecomponent":"core","altidentifier":"approve","altcomponent":"core_pix"},{"text":"8-)","imagename":"s\\/wideeyes","imagecomponent":"core","altidentifier":"wideeyes","altcomponent":"core_pix"},{"text":":o)","imagename":"s\\/clown","imagecomponent":"core","altidentifier":"clown","altcomponent":"core_pix"},{"text":":-(","imagename":"s\\/sad","imagecomponent":"core","altidentifier":"sad","altcomponent":"core_pix"},{"text":":(","imagename":"s\\/sad","imagecomponent":"core","altidentifier":"sad","altcomponent":"core_pix"},{"text":"8-.","imagename":"s\\/shy","imagecomponent":"core","altidentifier":"shy","altcomponent":"core_pix"},{"text":":-I","imagename":"s\\/blush","imagecomponent":"core","altidentifier":"blush","altcomponent":"core_pix"},{"text":":-X","imagename":"s\\/kiss","imagecomponent":"core","altidentifier":"kiss","altcomponent":"core_pix"},{"text":"8-o","imagename":"s\\/surprise","imagecomponent":"core","altidentifier":"surprise","altcomponent":"core_pix"},{"text":"P-|","imagename":"s\\/blackeye","imagecomponent":"core","altidentifier":"blackeye","altcomponent":"core_pix"},{"text":"8-[","imagename":"s\\/angry","imagecomponent":"core","altidentifier":"angry","altcomponent":"core_pix"},{"text":"(grr)","imagename":"s\\/angry","imagecomponent":"core","altidentifier":"angry","altcomponent":"core_pix"},{"text":"xx-P","imagename":"s\\/dead","imagecomponent":"core","altidentifier":"dead","altcomponent":"core_pix"},{"text":"|-.","imagename":"s\\/sleepy","imagecomponent":"core","altidentifier":"sleepy","altcomponent":"core_pix"},{"text":"}-]","imagename":"s\\/evil","imagecomponent":"core","altidentifier":"evil","altcomponent":"core_pix"},{"text":"(h)","imagename":"s\\/heart","imagecomponent":"core","altidentifier":"heart","altcomponent":"core_pix"},{"text":"(heart)","imagename":"s\\/heart","imagecomponent":"core","altidentifier":"heart","altcomponent":"core_pix"},{"text":"(y)","imagename":"s\\/yes","imagecomponent":"core","altidentifier":"yes","altcomponent":"core"},{"text":"(n)","imagename":"s\\/no","imagecomponent":"core","altidentifier":"no","altcomponent":"core"},{"text":"(martin)","imagename":"s\\/martin","imagecomponent":"core","altidentifier":"martin","altcomponent":"core_pix"},{"text":"( )","imagename":"s\\/egg","imagecomponent":"core","altidentifier":"egg","altcomponent":"core_pix"}]'),
(294, 'docroot', 'https://docs.moodle.org'),
(295, 'doclang', ''),
(296, 'doctonewwindow', '0'),
(297, 'courselistshortnames', '0'),
(298, 'coursesperpage', '20'),
(299, 'courseswithsummarieslimit', '10'),
(300, 'courseoverviewfileslimit', '1'),
(301, 'courseoverviewfilesext', '.jpg,.gif,.png'),
(302, 'useexternalyui', '0'),
(303, 'yuicomboloading', '1'),
(304, 'cachejs', '1'),
(305, 'modchooserdefault', '1'),
(306, 'additionalhtmlhead', ''),
(307, 'additionalhtmltopofbody', ''),
(308, 'additionalhtmlfooter', ''),
(309, 'pathtophp', ''),
(310, 'pathtodu', ''),
(311, 'aspellpath', ''),
(312, 'pathtodot', ''),
(313, 'pathtogs', '/usr/bin/gs'),
(314, 'pathtopython', ''),
(315, 'supportname', 'Admin User'),
(316, 'supportemail', ''),
(317, 'supportpage', ''),
(318, 'dbsessions', '0'),
(319, 'sessioncookie', ''),
(320, 'sessioncookiepath', ''),
(321, 'sessioncookiedomain', ''),
(322, 'statsfirstrun', 'none'),
(323, 'statsmaxruntime', '0'),
(324, 'statsruntimedays', '31'),
(325, 'statsuserthreshold', '0'),
(326, 'slasharguments', '1'),
(327, 'getremoteaddrconf', '3'),
(328, 'reverseproxyignore', ''),
(329, 'proxyhost', ''),
(330, 'proxyport', '0'),
(331, 'proxytype', 'HTTP'),
(332, 'proxyuser', ''),
(333, 'proxypassword', ''),
(334, 'proxybypass', 'localhost, 127.0.0.1'),
(335, 'maintenance_enabled', '0'),
(336, 'maintenance_message', ''),
(337, 'deleteunconfirmed', '168'),
(338, 'deleteincompleteusers', '0'),
(339, 'disablegradehistory', '0'),
(340, 'gradehistorylifetime', '0'),
(341, 'tempdatafoldercleanup', '168'),
(342, 'extramemorylimit', '512M'),
(343, 'maxtimelimit', '0'),
(344, 'curlcache', '120'),
(345, 'curltimeoutkbitrate', '56'),
(346, 'smtphosts', ''),
(347, 'smtpsecure', ''),
(348, 'smtpauthtype', 'LOGIN'),
(349, 'smtpuser', ''),
(350, 'smtppass', ''),
(351, 'smtpmaxbulk', '1'),
(352, 'noreplyaddress', '[[admin_email]]'),
(353, 'allowedemaildomains', ''),
(354, 'sitemailcharset', '0'),
(355, 'allowusermailcharset', '0'),
(356, 'allowattachments', '1'),
(357, 'mailnewline', 'LF'),
(358, 'emailfromvia', '1'),
(359, 'updateautocheck', '1'),
(360, 'updateminmaturity', '200'),
(361, 'updatenotifybuilds', '0'),
(362, 'enablesafebrowserintegration', '0'),
(363, 'dndallowtextandlinks', '0'),
(364, 'pathtosassc', ''),
(365, 'forceclean', '0'),
(366, 'debug', '0'),
(367, 'debugdisplay', '1'),
(368, 'debugsmtp', '0'),
(369, 'perfdebug', '7'),
(370, 'debugstringids', '0'),
(371, 'debugvalidators', '0'),
(372, 'debugpageinfo', '0'),
(373, 'profilingenabled', '0'),
(374, 'profilingincluded', ''),
(375, 'profilingexcluded', ''),
(376, 'profilingautofrec', '0'),
(377, 'profilingallowme', '0'),
(378, 'profilingallowall', '0'),
(379, 'profilinglifetime', '1440'),
(380, 'profilingimportprefix', '(I)'),
(381, 'release', '3.5.18 (Build: 20210510)'),
(382, 'branch', '35'),
(383, 'localcachedirpurged', '[[timestamp]]'),
(384, 'scheduledtaskreset', '[[timestamp]]'),
(385, 'allversionshash', 'b7c70a43688450de1e6ffb84078d1f58b10867f3'),
(387, 'registrationpending', '0'),
(388, 'notloggedinroleid', '6'),
(389, 'guestroleid', '6'),
(390, 'defaultuserroleid', '7'),
(391, 'creatornewroleid', '3'),
(392, 'restorernewroleid', '3'),
(393, 'sitepolicyhandler', ''),
(394, 'gradebookroles', '5'),
(395, 'chat_method', 'ajax'),
(396, 'chat_refresh_userlist', '10'),
(397, 'chat_old_ping', '35'),
(398, 'chat_refresh_room', '5'),
(399, 'chat_normal_updatemode', 'jsupdate'),
(400, 'chat_serverhost', '[[domhost]]'),
(401, 'chat_serverip', '127.0.0.1'),
(402, 'chat_serverport', '9111'),
(403, 'chat_servermax', '100'),
(404, 'data_enablerssfeeds', '0'),
(405, 'feedback_allowfullanonymous', '0'),
(406, 'forum_displaymode', '3'),
(407, 'forum_shortpost', '300'),
(408, 'forum_longpost', '600'),
(409, 'forum_manydiscussions', '100'),
(410, 'forum_maxbytes', '512000'),
(411, 'forum_maxattachments', '9'),
(412, 'forum_subscription', '0'),
(413, 'forum_trackingtype', '1'),
(414, 'forum_trackreadposts', '1'),
(415, 'forum_allowforcedreadtracking', '0'),
(416, 'forum_oldpostdays', '14'),
(417, 'forum_usermarksread', '0'),
(418, 'forum_cleanreadtime', '2'),
(419, 'digestmailtime', '17'),
(420, 'forum_enablerssfeeds', '0'),
(421, 'forum_enabletimedposts', '1'),
(422, 'glossary_entbypage', '10'),
(423, 'glossary_dupentries', '0'),
(424, 'glossary_allowcomments', '0'),
(425, 'glossary_linkbydefault', '1'),
(426, 'glossary_defaultapproval', '1'),
(427, 'glossary_enablerssfeeds', '0'),
(428, 'glossary_linkentries', '0'),
(429, 'glossary_casesensitive', '0'),
(430, 'glossary_fullmatch', '0'),
(431, 'block_course_list_adminview', 'all'),
(432, 'block_course_list_hideallcourseslink', '0'),
(433, 'block_html_allowcssclasses', '0'),
(434, 'block_online_users_timetosee', '5'),
(435, 'block_rss_client_num_entries', '5'),
(436, 'block_rss_client_timeout', '30'),
(437, 'pathtounoconv', '/usr/bin/unoconv'),
(438, 'filter_multilang_force_old', '0'),
(439, 'filter_censor_badwords', ''),
(440, 'logguests', '1'),
(441, 'loglifetime', '0'),
(442, 'jabberhost', ''),
(443, 'jabberserver', ''),
(444, 'jabberusername', ''),
(445, 'jabberpassword', ''),
(446, 'jabberport', '5222'),
(447, 'airnotifierurl', 'https://messages.moodle.net'),
(448, 'airnotifierport', '443'),
(449, 'airnotifiermobileappname', 'com.moodle.moodlemobile'),
(450, 'airnotifierappname', 'commoodlemoodlemobile'),
(451, 'airnotifieraccesskey', ''),
(452, 'profileroles', '5,4,3'),
(453, 'coursecontact', '3'),
(454, 'frontpage', '6'),
(455, 'frontpageloggedin', '6'),
(456, 'maxcategorydepth', '2'),
(457, 'frontpagecourselimit', '200'),
(458, 'commentsperpage', '15'),
(459, 'defaultfrontpageroleid', '8'),
(460, 'messageinbound_enabled', '0'),
(461, 'messageinbound_mailbox', ''),
(462, 'messageinbound_domain', ''),
(463, 'messageinbound_host', ''),
(464, 'messageinbound_hostssl', 'ssl'),
(465, 'messageinbound_hostuser', ''),
(466, 'messageinbound_hostpass', ''),
(467, 'enablemobilewebservice', '0'),
(468, 'timezone', 'America/New_York'),
(469, 'registerauth', '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]config_log`
--

CREATE TABLE `[[dbprefix]]config_log` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `plugin` varchar(100) DEFAULT NULL,
  `name` varchar(100) NOT NULL DEFAULT '',
  `value` longtext,
  `oldvalue` longtext,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]conflog_tim_ix` (`timemodified`),
  KEY `[[dbprefix]]conflog_use_ix` (`userid`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Changes done in server configuration through admin UI' AUTO_INCREMENT=1590 ;

--
-- Dumping data for table `[[dbprefix]]config_log`
--

INSERT INTO `[[dbprefix]]config_log` VALUES
(1, 0, [[timestamp]], NULL, 'enableoutcomes', '0', NULL),
(2, 0, [[timestamp]], NULL, 'usecomments', '1', NULL),
(3, 0, [[timestamp]], NULL, 'usetags', '1', NULL),
(4, 0, [[timestamp]], NULL, 'enablenotes', '1', NULL),
(5, 0, [[timestamp]], NULL, 'enableportfolios', '0', NULL),
(6, 0, [[timestamp]], NULL, 'enablewebservices', '0', NULL),
(7, 0, [[timestamp]], NULL, 'messaging', '1', NULL),
(8, 0, [[timestamp]], NULL, 'messagingdeletereadnotificationsdelay', '604800', NULL),
(9, 0, [[timestamp]], NULL, 'messagingdeleteallnotificationsdelay', '2620800', NULL),
(10, 0, [[timestamp]], NULL, 'messagingallowemailoverride', '0', NULL),
(11, 0, [[timestamp]], NULL, 'enablestats', '0', NULL),
(12, 0, [[timestamp]], NULL, 'enablerssfeeds', '0', NULL),
(13, 0, [[timestamp]], NULL, 'enableblogs', '1', NULL),
(14, 0, [[timestamp]], NULL, 'enablecompletion', '1', NULL),
(15, 0, [[timestamp]], NULL, 'completiondefault', '1', NULL),
(16, 0, [[timestamp]], NULL, 'enableavailability', '1', NULL),
(17, 0, [[timestamp]], NULL, 'enableplagiarism', '0', NULL),
(18, 0, [[timestamp]], NULL, 'enablebadges', '1', NULL),
(19, 0, [[timestamp]], NULL, 'enableglobalsearch', '0', NULL),
(20, 0, [[timestamp]], NULL, 'allowstealth', '0', NULL),
(21, 0, [[timestamp]], NULL, 'defaultpreference_maildisplay', '2', NULL),
(22, 0, [[timestamp]], NULL, 'defaultpreference_mailformat', '1', NULL),
(23, 0, [[timestamp]], NULL, 'defaultpreference_maildigest', '0', NULL),
(24, 0, [[timestamp]], NULL, 'defaultpreference_autosubscribe', '1', NULL),
(25, 0, [[timestamp]], NULL, 'defaultpreference_trackforums', '0', NULL),
(26, 0, [[timestamp]], NULL, 'autologinguests', '0', NULL),
(27, 0, [[timestamp]], NULL, 'hiddenuserfields', '', NULL),
(28, 0, [[timestamp]], NULL, 'showuseridentity', 'email', NULL),
(29, 0, [[timestamp]], NULL, 'fullnamedisplay', 'language', NULL),
(30, 0, [[timestamp]], NULL, 'alternativefullnameformat', 'language', NULL),
(31, 0, [[timestamp]], NULL, 'maxusersperpage', '100', NULL),
(32, 0, [[timestamp]], NULL, 'enablegravatar', '0', NULL),
(33, 0, [[timestamp]], NULL, 'gravatardefaulturl', 'mm', NULL),
(34, 0, [[timestamp]], NULL, 'agedigitalconsentverification', '0', NULL),
(35, 0, [[timestamp]], NULL, 'agedigitalconsentmap', '*, 16\nAT, 14\nES, 14\nUS, 13', NULL),
(36, 0, [[timestamp]], NULL, 'sitepolicy', '', NULL),
(37, 0, [[timestamp]], NULL, 'sitepolicyguest', '', NULL),
(38, 0, [[timestamp]], 'moodlecourse', 'visible', '1', NULL),
(39, 0, [[timestamp]], 'moodlecourse', 'format', 'topics', NULL),
(40, 0, [[timestamp]], 'moodlecourse', 'maxsections', '52', NULL),
(41, 0, [[timestamp]], 'moodlecourse', 'numsections', '4', NULL),
(42, 0, [[timestamp]], 'moodlecourse', 'hiddensections', '0', NULL),
(43, 0, [[timestamp]], 'moodlecourse', 'coursedisplay', '0', NULL),
(44, 0, [[timestamp]], 'moodlecourse', 'courseenddateenabled', '1', NULL),
(45, 0, [[timestamp]], 'moodlecourse', 'courseduration', '31536000', NULL),
(46, 0, [[timestamp]], 'moodlecourse', 'lang', '', NULL),
(47, 0, [[timestamp]], 'moodlecourse', 'newsitems', '5', NULL),
(48, 0, [[timestamp]], 'moodlecourse', 'showgrades', '1', NULL),
(49, 0, [[timestamp]], 'moodlecourse', 'showreports', '0', NULL),
(50, 0, [[timestamp]], 'moodlecourse', 'maxbytes', '0', NULL),
(51, 0, [[timestamp]], 'moodlecourse', 'enablecompletion', '1', NULL),
(52, 0, [[timestamp]], 'moodlecourse', 'groupmode', '0', NULL),
(53, 0, [[timestamp]], 'moodlecourse', 'groupmodeforce', '0', NULL),
(54, 0, [[timestamp]], NULL, 'enablecourserequests', '0', NULL),
(55, 0, [[timestamp]], NULL, 'defaultrequestcategory', '1', NULL),
(56, 0, [[timestamp]], NULL, 'requestcategoryselection', '0', NULL),
(57, 0, [[timestamp]], NULL, 'courserequestnotify', '', NULL),
(58, 0, [[timestamp]], 'backup', 'loglifetime', '30', NULL),
(59, 0, [[timestamp]], 'backup', 'backup_general_users', '1', NULL),
(60, 0, [[timestamp]], 'backup', 'backup_general_users_locked', '', NULL),
(61, 0, [[timestamp]], 'backup', 'backup_general_anonymize', '0', NULL),
(62, 0, [[timestamp]], 'backup', 'backup_general_anonymize_locked', '', NULL),
(63, 0, [[timestamp]], 'backup', 'backup_general_role_assignments', '1', NULL),
(64, 0, [[timestamp]], 'backup', 'backup_general_role_assignments_locked', '', NULL),
(65, 0, [[timestamp]], 'backup', 'backup_general_activities', '1', NULL),
(66, 0, [[timestamp]], 'backup', 'backup_general_activities_locked', '', NULL),
(67, 0, [[timestamp]], 'backup', 'backup_general_blocks', '1', NULL),
(68, 0, [[timestamp]], 'backup', 'backup_general_blocks_locked', '', NULL),
(69, 0, [[timestamp]], 'backup', 'backup_general_filters', '1', NULL),
(70, 0, [[timestamp]], 'backup', 'backup_general_filters_locked', '', NULL),
(71, 0, [[timestamp]], 'backup', 'backup_general_comments', '1', NULL),
(72, 0, [[timestamp]], 'backup', 'backup_general_comments_locked', '', NULL),
(73, 0, [[timestamp]], 'backup', 'backup_general_badges', '1', NULL),
(74, 0, [[timestamp]], 'backup', 'backup_general_badges_locked', '', NULL),
(75, 0, [[timestamp]], 'backup', 'backup_general_calendarevents', '1', NULL),
(76, 0, [[timestamp]], 'backup', 'backup_general_calendarevents_locked', '', NULL),
(77, 0, [[timestamp]], 'backup', 'backup_general_userscompletion', '1', NULL),
(78, 0, [[timestamp]], 'backup', 'backup_general_userscompletion_locked', '', NULL),
(79, 0, [[timestamp]], 'backup', 'backup_general_logs', '0', NULL),
(80, 0, [[timestamp]], 'backup', 'backup_general_logs_locked', '', NULL),
(81, 0, [[timestamp]], 'backup', 'backup_general_histories', '0', NULL),
(82, 0, [[timestamp]], 'backup', 'backup_general_histories_locked', '', NULL),
(83, 0, [[timestamp]], 'backup', 'backup_general_questionbank', '1', NULL),
(84, 0, [[timestamp]], 'backup', 'backup_general_questionbank_locked', '', NULL),
(85, 0, [[timestamp]], 'backup', 'backup_general_groups', '1', NULL),
(86, 0, [[timestamp]], 'backup', 'backup_general_groups_locked', '', NULL),
(87, 0, [[timestamp]], 'backup', 'backup_general_competencies', '1', NULL),
(88, 0, [[timestamp]], 'backup', 'backup_general_competencies_locked', '', NULL),
(89, 0, [[timestamp]], 'backup', 'import_general_maxresults', '10', NULL),
(90, 0, [[timestamp]], 'backup', 'import_general_duplicate_admin_allowed', '0', NULL),
(91, 0, [[timestamp]], 'backup', 'backup_import_activities', '1', NULL),
(92, 0, [[timestamp]], 'backup', 'backup_import_activities_locked', '', NULL),
(93, 0, [[timestamp]], 'backup', 'backup_import_blocks', '1', NULL),
(94, 0, [[timestamp]], 'backup', 'backup_import_blocks_locked', '', NULL),
(95, 0, [[timestamp]], 'backup', 'backup_import_filters', '1', NULL),
(96, 0, [[timestamp]], 'backup', 'backup_import_filters_locked', '', NULL),
(97, 0, [[timestamp]], 'backup', 'backup_import_calendarevents', '1', NULL),
(98, 0, [[timestamp]], 'backup', 'backup_import_calendarevents_locked', '', NULL),
(99, 0, [[timestamp]], 'backup', 'backup_import_questionbank', '1', NULL),
(100, 0, [[timestamp]], 'backup', 'backup_import_questionbank_locked', '', NULL),
(101, 0, [[timestamp]], 'backup', 'backup_import_groups', '1', NULL),
(102, 0, [[timestamp]], 'backup', 'backup_import_groups_locked', '', NULL),
(103, 0, [[timestamp]], 'backup', 'backup_import_competencies', '1', NULL),
(104, 0, [[timestamp]], 'backup', 'backup_import_competencies_locked', '', NULL),
(105, 0, [[timestamp]], 'backup', 'backup_auto_active', '0', NULL),
(106, 0, [[timestamp]], 'backup', 'backup_auto_weekdays', '0000000', NULL),
(107, 0, [[timestamp]], 'backup', 'backup_auto_hour', '0', NULL),
(108, 0, [[timestamp]], 'backup', 'backup_auto_minute', '0', NULL),
(109, 0, [[timestamp]], 'backup', 'backup_auto_storage', '0', NULL),
(110, 0, [[timestamp]], 'backup', 'backup_auto_destination', '', NULL),
(111, 0, [[timestamp]], 'backup', 'backup_auto_max_kept', '1', NULL),
(112, 0, [[timestamp]], 'backup', 'backup_auto_delete_days', '0', NULL),
(113, 0, [[timestamp]], 'backup', 'backup_auto_min_kept', '0', NULL),
(114, 0, [[timestamp]], 'backup', 'backup_shortname', '0', NULL),
(115, 0, [[timestamp]], 'backup', 'backup_auto_skip_hidden', '1', NULL),
(116, 0, [[timestamp]], 'backup', 'backup_auto_skip_modif_days', '30', NULL),
(117, 0, [[timestamp]], 'backup', 'backup_auto_skip_modif_prev', '0', NULL),
(118, 0, [[timestamp]], 'backup', 'backup_auto_users', '1', NULL),
(119, 0, [[timestamp]], 'backup', 'backup_auto_role_assignments', '1', NULL),
(120, 0, [[timestamp]], 'backup', 'backup_auto_activities', '1', NULL),
(121, 0, [[timestamp]], 'backup', 'backup_auto_blocks', '1', NULL),
(122, 0, [[timestamp]], 'backup', 'backup_auto_filters', '1', NULL),
(123, 0, [[timestamp]], 'backup', 'backup_auto_comments', '1', NULL),
(124, 0, [[timestamp]], 'backup', 'backup_auto_badges', '1', NULL),
(125, 0, [[timestamp]], 'backup', 'backup_auto_calendarevents', '1', NULL),
(126, 0, [[timestamp]], 'backup', 'backup_auto_userscompletion', '1', NULL),
(127, 0, [[timestamp]], 'backup', 'backup_auto_logs', '0', NULL),
(128, 0, [[timestamp]], 'backup', 'backup_auto_histories', '0', NULL),
(129, 0, [[timestamp]], 'backup', 'backup_auto_questionbank', '1', NULL),
(130, 0, [[timestamp]], 'backup', 'backup_auto_groups', '1', NULL),
(131, 0, [[timestamp]], 'backup', 'backup_auto_competencies', '1', NULL),
(132, 0, [[timestamp]], 'restore', 'restore_general_users', '1', NULL),
(133, 0, [[timestamp]], 'restore', 'restore_general_users_locked', '', NULL),
(134, 0, [[timestamp]], 'restore', 'restore_general_enrolments', '1', NULL),
(135, 0, [[timestamp]], 'restore', 'restore_general_enrolments_locked', '', NULL),
(136, 0, [[timestamp]], 'restore', 'restore_general_role_assignments', '1', NULL),
(137, 0, [[timestamp]], 'restore', 'restore_general_role_assignments_locked', '', NULL),
(138, 0, [[timestamp]], 'restore', 'restore_general_activities', '1', NULL),
(139, 0, [[timestamp]], 'restore', 'restore_general_activities_locked', '', NULL),
(140, 0, [[timestamp]], 'restore', 'restore_general_blocks', '1', NULL),
(141, 0, [[timestamp]], 'restore', 'restore_general_blocks_locked', '', NULL),
(142, 0, [[timestamp]], 'restore', 'restore_general_filters', '1', NULL),
(143, 0, [[timestamp]], 'restore', 'restore_general_filters_locked', '', NULL),
(144, 0, [[timestamp]], 'restore', 'restore_general_comments', '1', NULL),
(145, 0, [[timestamp]], 'restore', 'restore_general_comments_locked', '', NULL),
(146, 0, [[timestamp]], 'restore', 'restore_general_badges', '1', NULL),
(147, 0, [[timestamp]], 'restore', 'restore_general_badges_locked', '', NULL),
(148, 0, [[timestamp]], 'restore', 'restore_general_calendarevents', '1', NULL),
(149, 0, [[timestamp]], 'restore', 'restore_general_calendarevents_locked', '', NULL),
(150, 0, [[timestamp]], 'restore', 'restore_general_userscompletion', '1', NULL),
(151, 0, [[timestamp]], 'restore', 'restore_general_userscompletion_locked', '', NULL),
(152, 0, [[timestamp]], 'restore', 'restore_general_logs', '1', NULL),
(153, 0, [[timestamp]], 'restore', 'restore_general_logs_locked', '', NULL),
(154, 0, [[timestamp]], 'restore', 'restore_general_histories', '1', NULL),
(155, 0, [[timestamp]], 'restore', 'restore_general_histories_locked', '', NULL),
(156, 0, [[timestamp]], 'restore', 'restore_general_groups', '1', NULL),
(157, 0, [[timestamp]], 'restore', 'restore_general_groups_locked', '', NULL),
(158, 0, [[timestamp]], 'restore', 'restore_general_competencies', '1', NULL),
(159, 0, [[timestamp]], 'restore', 'restore_general_competencies_locked', '', NULL),
(160, 0, [[timestamp]], 'restore', 'restore_merge_overwrite_conf', '0', NULL),
(161, 0, [[timestamp]], 'restore', 'restore_merge_overwrite_conf_locked', '', NULL),
(162, 0, [[timestamp]], 'restore', 'restore_merge_course_fullname', '1', NULL),
(163, 0, [[timestamp]], 'restore', 'restore_merge_course_fullname_locked', '', NULL),
(164, 0, [[timestamp]], 'restore', 'restore_merge_course_shortname', '1', NULL),
(165, 0, [[timestamp]], 'restore', 'restore_merge_course_shortname_locked', '', NULL),
(166, 0, [[timestamp]], 'restore', 'restore_merge_course_startdate', '1', NULL),
(167, 0, [[timestamp]], 'restore', 'restore_merge_course_startdate_locked', '', NULL),
(168, 0, [[timestamp]], 'restore', 'restore_replace_overwrite_conf', '0', NULL),
(169, 0, [[timestamp]], 'restore', 'restore_replace_overwrite_conf_locked', '', NULL),
(170, 0, [[timestamp]], 'restore', 'restore_replace_course_fullname', '1', NULL),
(171, 0, [[timestamp]], 'restore', 'restore_replace_course_fullname_locked', '', NULL),
(172, 0, [[timestamp]], 'restore', 'restore_replace_course_shortname', '1', NULL),
(173, 0, [[timestamp]], 'restore', 'restore_replace_course_shortname_locked', '', NULL),
(174, 0, [[timestamp]], 'restore', 'restore_replace_course_startdate', '1', NULL),
(175, 0, [[timestamp]], 'restore', 'restore_replace_course_startdate_locked', '', NULL),
(176, 0, [[timestamp]], 'restore', 'restore_replace_keep_roles_and_enrolments', '0', NULL),
(177, 0, [[timestamp]], 'restore', 'restore_replace_keep_roles_and_enrolments_locked', '', NULL),
(178, 0, [[timestamp]], 'restore', 'restore_replace_keep_groups_and_groupings', '0', NULL),
(179, 0, [[timestamp]], 'restore', 'restore_replace_keep_groups_and_groupings_locked', '', NULL),
(180, 0, [[timestamp]], NULL, 'grade_profilereport', 'user', NULL),
(181, 0, [[timestamp]], NULL, 'grade_aggregationposition', '1', NULL),
(182, 0, [[timestamp]], NULL, 'grade_includescalesinaggregation', '1', NULL),
(183, 0, [[timestamp]], NULL, 'grade_hiddenasdate', '0', NULL),
(184, 0, [[timestamp]], NULL, 'gradepublishing', '0', NULL),
(185, 0, [[timestamp]], NULL, 'grade_export_exportfeedback', '0', NULL),
(186, 0, [[timestamp]], NULL, 'grade_export_displaytype', '1', NULL),
(187, 0, [[timestamp]], NULL, 'grade_export_decimalpoints', '2', NULL),
(188, 0, [[timestamp]], NULL, 'grade_navmethod', '1', NULL),
(189, 0, [[timestamp]], NULL, 'grade_export_userprofilefields', 'firstname,lastname,idnumber,institution,department,email', NULL),
(190, 0, [[timestamp]], NULL, 'grade_export_customprofilefields', '', NULL),
(191, 0, [[timestamp]], NULL, 'recovergradesdefault', '0', NULL),
(192, 0, [[timestamp]], NULL, 'gradeexport', '', NULL),
(193, 0, [[timestamp]], NULL, 'unlimitedgrades', '0', NULL),
(194, 0, [[timestamp]], NULL, 'grade_report_showmin', '1', NULL),
(195, 0, [[timestamp]], NULL, 'gradepointmax', '100', NULL),
(196, 0, [[timestamp]], NULL, 'gradepointdefault', '100', NULL),
(197, 0, [[timestamp]], NULL, 'grade_minmaxtouse', '1', NULL),
(198, 0, [[timestamp]], NULL, 'grade_mygrades_report', 'overview', NULL),
(199, 0, [[timestamp]], NULL, 'gradereport_mygradeurl', '', NULL),
(200, 0, [[timestamp]], NULL, 'grade_hideforcedsettings', '1', NULL),
(201, 0, [[timestamp]], NULL, 'grade_aggregation', '13', NULL),
(202, 0, [[timestamp]], NULL, 'grade_aggregation_flag', '0', NULL),
(203, 0, [[timestamp]], NULL, 'grade_aggregations_visible', '13', NULL),
(204, 0, [[timestamp]], NULL, 'grade_aggregateonlygraded', '1', NULL),
(205, 0, [[timestamp]], NULL, 'grade_aggregateonlygraded_flag', '2', NULL),
(206, 0, [[timestamp]], NULL, 'grade_aggregateoutcomes', '0', NULL),
(207, 0, [[timestamp]], NULL, 'grade_aggregateoutcomes_flag', '2', NULL),
(208, 0, [[timestamp]], NULL, 'grade_keephigh', '0', NULL),
(209, 0, [[timestamp]], NULL, 'grade_keephigh_flag', '3', NULL),
(210, 0, [[timestamp]], NULL, 'grade_droplow', '0', NULL),
(211, 0, [[timestamp]], NULL, 'grade_droplow_flag', '2', NULL),
(212, 0, [[timestamp]], NULL, 'grade_overridecat', '1', NULL),
(213, 0, [[timestamp]], NULL, 'grade_displaytype', '1', NULL),
(214, 0, [[timestamp]], NULL, 'grade_decimalpoints', '2', NULL),
(215, 0, [[timestamp]], NULL, 'grade_item_advanced', 'iteminfo,idnumber,gradepass,plusfactor,multfactor,display,decimals,hiddenuntil,locktime', NULL),
(216, 0, [[timestamp]], NULL, 'grade_report_studentsperpage', '100', NULL),
(217, 0, [[timestamp]], NULL, 'grade_report_showonlyactiveenrol', '1', NULL),
(218, 0, [[timestamp]], NULL, 'grade_report_quickgrading', '1', NULL),
(219, 0, [[timestamp]], NULL, 'grade_report_showquickfeedback', '0', NULL),
(220, 0, [[timestamp]], NULL, 'grade_report_meanselection', '1', NULL),
(221, 0, [[timestamp]], NULL, 'grade_report_enableajax', '0', NULL),
(222, 0, [[timestamp]], NULL, 'grade_report_showcalculations', '1', NULL),
(223, 0, [[timestamp]], NULL, 'grade_report_showeyecons', '0', NULL),
(224, 0, [[timestamp]], NULL, 'grade_report_showaverages', '1', NULL),
(225, 0, [[timestamp]], NULL, 'grade_report_showlocks', '0', NULL),
(226, 0, [[timestamp]], NULL, 'grade_report_showranges', '0', NULL),
(227, 0, [[timestamp]], NULL, 'grade_report_showanalysisicon', '1', NULL),
(228, 0, [[timestamp]], NULL, 'grade_report_showuserimage', '1', NULL),
(229, 0, [[timestamp]], NULL, 'grade_report_showactivityicons', '1', NULL),
(230, 0, [[timestamp]], NULL, 'grade_report_shownumberofgrades', '0', NULL),
(231, 0, [[timestamp]], NULL, 'grade_report_averagesdisplaytype', 'inherit', NULL),
(232, 0, [[timestamp]], NULL, 'grade_report_rangesdisplaytype', 'inherit', NULL),
(233, 0, [[timestamp]], NULL, 'grade_report_averagesdecimalpoints', 'inherit', NULL),
(234, 0, [[timestamp]], NULL, 'grade_report_rangesdecimalpoints', 'inherit', NULL),
(235, 0, [[timestamp]], NULL, 'grade_report_historyperpage', '50', NULL),
(236, 0, [[timestamp]], NULL, 'grade_report_overview_showrank', '0', NULL),
(237, 0, [[timestamp]], NULL, 'grade_report_overview_showtotalsifcontainhidden', '0', NULL),
(238, 0, [[timestamp]], NULL, 'grade_report_user_showrank', '0', NULL),
(239, 0, [[timestamp]], NULL, 'grade_report_user_showpercentage', '1', NULL),
(240, 0, [[timestamp]], NULL, 'grade_report_user_showgrade', '1', NULL),
(241, 0, [[timestamp]], NULL, 'grade_report_user_showfeedback', '1', NULL),
(242, 0, [[timestamp]], NULL, 'grade_report_user_showrange', '1', NULL),
(243, 0, [[timestamp]], NULL, 'grade_report_user_showweight', '1', NULL),
(244, 0, [[timestamp]], NULL, 'grade_report_user_showaverage', '0', NULL),
(245, 0, [[timestamp]], NULL, 'grade_report_user_showlettergrade', '0', NULL),
(246, 0, [[timestamp]], NULL, 'grade_report_user_rangedecimals', '0', NULL),
(247, 0, [[timestamp]], NULL, 'grade_report_user_showhiddenitems', '1', NULL),
(248, 0, [[timestamp]], NULL, 'grade_report_user_showtotalsifcontainhidden', '0', NULL),
(249, 0, [[timestamp]], NULL, 'grade_report_user_showcontributiontocoursetotal', '1', NULL),
(250, 0, [[timestamp]], 'analytics', 'predictionsprocessor', '\\mlbackend_php\\processor', NULL),
(251, 0, [[timestamp]], 'analytics', 'timesplittings', '\\core\\analytics\\time_splitting\\quarters_accum,\\core\\analytics\\time_splitting\\quarters,\\core\\analytics\\time_splitting\\single_range', NULL),
(252, 0, [[timestamp]], 'analytics', 'modeloutputdir', '[[softdatadir]]/models', NULL),
(253, 0, [[timestamp]], 'analytics', 'onlycli', '1', NULL),
(254, 0, [[timestamp]], 'analytics', 'modeltimelimit', '1200', NULL),
(255, 0, [[timestamp]], 'core_competency', 'enabled', '1', NULL),
(256, 0, [[timestamp]], 'core_competency', 'pushcourseratingstouserplans', '1', NULL),
(257, 0, [[timestamp]], NULL, 'badges_defaultissuername', '', NULL),
(258, 0, [[timestamp]], NULL, 'badges_defaultissuercontact', '', NULL),
(259, 0, [[timestamp]], NULL, 'badges_badgesalt', 'badges[[timestamp]]', NULL),
(260, 0, [[timestamp]], NULL, 'badges_allowexternalbackpack', '1', NULL),
(261, 0, [[timestamp]], NULL, 'badges_allowcoursebadges', '1', NULL),
(262, 0, [[timestamp]], NULL, 'timezone', 'America/New_York', NULL),
(263, 0, [[timestamp]], NULL, 'forcetimezone', '99', NULL),
(264, 0, [[timestamp]], NULL, 'country', '0', NULL),
(265, 0, [[timestamp]], NULL, 'defaultcity', '', NULL),
(266, 0, [[timestamp]], NULL, 'geoip2file', '[[softdatadir]]/geoip/GeoLite2-City.mmdb', NULL),
(267, 0, [[timestamp]], NULL, 'googlemapkey3', '', NULL),
(268, 0, [[timestamp]], NULL, 'allcountrycodes', '', NULL),
(269, 0, [[timestamp]], NULL, 'autolang', '1', NULL),
(270, 0, [[timestamp]], NULL, 'lang', 'en', NULL),
(271, 0, [[timestamp]], NULL, 'langmenu', '1', NULL),
(272, 0, [[timestamp]], NULL, 'langlist', '', NULL),
(273, 0, [[timestamp]], NULL, 'langcache', '1', NULL),
(274, 0, [[timestamp]], NULL, 'langstringcache', '1', NULL),
(275, 0, [[timestamp]], NULL, 'locale', '', NULL),
(276, 0, [[timestamp]], NULL, 'latinexcelexport', '0', NULL),
(277, 0, [[timestamp]], NULL, 'requiremodintro', '0', NULL),
(278, 0, [[timestamp]], NULL, 'registerauth', '', NULL),
(279, 0, [[timestamp]], NULL, 'authloginviaemail', '0', NULL),
(280, 0, [[timestamp]], NULL, 'allowaccountssameemail', '0', NULL),
(281, 0, [[timestamp]], NULL, 'authpreventaccountcreation', '0', NULL),
(282, 0, [[timestamp]], NULL, 'loginpageautofocus', '0', NULL),
(283, 0, [[timestamp]], NULL, 'guestloginbutton', '1', NULL),
(284, 0, [[timestamp]], NULL, 'limitconcurrentlogins', '0', NULL),
(285, 0, [[timestamp]], NULL, 'alternateloginurl', '', NULL),
(286, 0, [[timestamp]], NULL, 'forgottenpasswordurl', '', NULL),
(287, 0, [[timestamp]], NULL, 'auth_instructions', '', NULL),
(288, 0, [[timestamp]], NULL, 'allowemailaddresses', '', NULL),
(289, 0, [[timestamp]], NULL, 'denyemailaddresses', '', NULL),
(290, 0, [[timestamp]], NULL, 'verifychangedemail', '1', NULL),
(291, 0, [[timestamp]], NULL, 'recaptchapublickey', '', NULL),
(292, 0, [[timestamp]], NULL, 'recaptchaprivatekey', '', NULL),
(293, 0, [[timestamp]], 'cachestore_apcu', 'testperformance', '0', NULL),
(294, 0, [[timestamp]], 'cachestore_memcache', 'testservers', '', NULL),
(295, 0, [[timestamp]], 'cachestore_memcached', 'testservers', '', NULL),
(296, 0, [[timestamp]], 'cachestore_mongodb', 'testserver', '', NULL),
(297, 0, [[timestamp]], 'cachestore_redis', 'test_server', '', NULL),
(298, 0, [[timestamp]], 'cachestore_redis', 'test_password', '', NULL),
(299, 0, [[timestamp]], NULL, 'filteruploadedfiles', '0', NULL),
(300, 0, [[timestamp]], NULL, 'filtermatchoneperpage', '0', NULL),
(301, 0, [[timestamp]], NULL, 'filtermatchonepertext', '0', NULL),
(302, 0, [[timestamp]], NULL, 'sitedefaultlicense', 'allrightsreserved', NULL),
(303, 0, [[timestamp]], NULL, 'media_default_width', '400', NULL),
(304, 0, [[timestamp]], NULL, 'media_default_height', '300', NULL),
(305, 0, [[timestamp]], NULL, 'portfolio_moderate_filesize_threshold', '1048576', NULL),
(306, 0, [[timestamp]], NULL, 'portfolio_high_filesize_threshold', '5242880', NULL),
(307, 0, [[timestamp]], NULL, 'portfolio_moderate_db_threshold', '20', NULL),
(308, 0, [[timestamp]], NULL, 'portfolio_high_db_threshold', '50', NULL),
(309, 0, [[timestamp]], 'question_preview', 'behaviour', 'deferredfeedback', NULL),
(310, 0, [[timestamp]], 'question_preview', 'correctness', '1', NULL),
(311, 0, [[timestamp]], 'question_preview', 'marks', '2', NULL),
(312, 0, [[timestamp]], 'question_preview', 'markdp', '2', NULL),
(313, 0, [[timestamp]], 'question_preview', 'feedback', '1', NULL),
(314, 0, [[timestamp]], 'question_preview', 'generalfeedback', '1', NULL),
(315, 0, [[timestamp]], 'question_preview', 'rightanswer', '1', NULL),
(316, 0, [[timestamp]], 'question_preview', 'history', '0', NULL),
(317, 0, [[timestamp]], NULL, 'repositorycacheexpire', '120', NULL),
(318, 0, [[timestamp]], NULL, 'repositorygetfiletimeout', '30', NULL),
(319, 0, [[timestamp]], NULL, 'repositorysyncfiletimeout', '1', NULL),
(320, 0, [[timestamp]], NULL, 'repositorysyncimagetimeout', '3', NULL),
(321, 0, [[timestamp]], NULL, 'repositoryallowexternallinks', '1', NULL),
(322, 0, [[timestamp]], NULL, 'legacyfilesinnewcourses', '0', NULL),
(323, 0, [[timestamp]], NULL, 'legacyfilesaddallowed', '1', NULL),
(324, 0, [[timestamp]], NULL, 'searchengine', 'simpledb', NULL),
(325, 0, [[timestamp]], NULL, 'searchindexwhendisabled', '0', NULL),
(326, 0, [[timestamp]], NULL, 'searchindextime', '600', NULL),
(327, 0, [[timestamp]], NULL, 'searchallavailablecourses', '0', NULL),
(328, 0, [[timestamp]], NULL, 'enablewsdocumentation', '0', NULL),
(329, 0, [[timestamp]], NULL, 'allowbeforeblock', '0', NULL),
(330, 0, [[timestamp]], NULL, 'allowedip', '', NULL),
(331, 0, [[timestamp]], NULL, 'blockedip', '', NULL),
(332, 0, [[timestamp]], NULL, 'protectusernames', '1', NULL),
(333, 0, [[timestamp]], NULL, 'forcelogin', '0', NULL),
(334, 0, [[timestamp]], NULL, 'forceloginforprofiles', '1', NULL),
(335, 0, [[timestamp]], NULL, 'forceloginforprofileimage', '0', NULL),
(336, 0, [[timestamp]], NULL, 'opentogoogle', '0', NULL),
(337, 0, [[timestamp]], NULL, 'allowindexing', '0', NULL),
(338, 0, [[timestamp]], NULL, 'maxbytes', '0', NULL),
(339, 0, [[timestamp]], NULL, 'userquota', '104857600', NULL),
(340, 0, [[timestamp]], NULL, 'allowobjectembed', '0', NULL),
(341, 0, [[timestamp]], NULL, 'enabletrusttext', '0', NULL),
(342, 0, [[timestamp]], NULL, 'maxeditingtime', '1800', NULL),
(343, 0, [[timestamp]], NULL, 'extendedusernamechars', '0', NULL),
(344, 0, [[timestamp]], NULL, 'keeptagnamecase', '1', NULL),
(345, 0, [[timestamp]], NULL, 'profilesforenrolledusersonly', '1', NULL),
(346, 0, [[timestamp]], NULL, 'cronclionly', '1', NULL),
(347, 0, [[timestamp]], NULL, 'cronremotepassword', '', NULL),
(348, 0, [[timestamp]], 'tool_task', 'enablerunnow', '1', NULL),
(349, 0, [[timestamp]], NULL, 'lockoutthreshold', '0', NULL),
(350, 0, [[timestamp]], NULL, 'lockoutwindow', '1800', NULL),
(351, 0, [[timestamp]], NULL, 'lockoutduration', '1800', NULL),
(352, 0, [[timestamp]], NULL, 'passwordpolicy', '1', NULL),
(353, 0, [[timestamp]], NULL, 'minpasswordlength', '8', NULL),
(354, 0, [[timestamp]], NULL, 'minpassworddigits', '1', NULL),
(355, 0, [[timestamp]], NULL, 'minpasswordlower', '1', NULL),
(356, 0, [[timestamp]], NULL, 'minpasswordupper', '1', NULL),
(357, 0, [[timestamp]], NULL, 'minpasswordnonalphanum', '1', NULL),
(358, 0, [[timestamp]], NULL, 'maxconsecutiveidentchars', '0', NULL),
(359, 0, [[timestamp]], NULL, 'passwordreuselimit', '0', NULL),
(360, 0, [[timestamp]], NULL, 'pwresettime', '1800', NULL),
(361, 0, [[timestamp]], NULL, 'passwordchangelogout', '0', NULL),
(362, 0, [[timestamp]], NULL, 'passwordchangetokendeletion', '0', NULL),
(363, 0, [[timestamp]], NULL, 'tokenduration', '7257600', NULL),
(364, 0, [[timestamp]], NULL, 'groupenrolmentkeypolicy', '1', NULL),
(365, 0, [[timestamp]], NULL, 'disableuserimages', '0', NULL),
(366, 0, [[timestamp]], NULL, 'emailchangeconfirmation', '1', NULL),
(367, 0, [[timestamp]], NULL, 'rememberusername', '2', NULL),
(368, 0, [[timestamp]], NULL, 'strictformsrequired', '0', NULL),
(369, 0, [[timestamp]], NULL, 'cookiesecure', '1', NULL),
(370, 0, [[timestamp]], NULL, 'cookiehttponly', '0', NULL),
(371, 0, [[timestamp]], NULL, 'allowframembedding', '0', NULL),
(372, 0, [[timestamp]], NULL, 'curlsecurityblockedhosts', '', NULL),
(373, 0, [[timestamp]], NULL, 'curlsecurityallowedport', '', NULL),
(374, 0, [[timestamp]], NULL, 'displayloginfailures', '0', NULL),
(375, 0, [[timestamp]], NULL, 'notifyloginfailures', '', NULL),
(376, 0, [[timestamp]], NULL, 'notifyloginthreshold', '10', NULL),
(377, 0, [[timestamp]], NULL, 'themelist', '', NULL),
(378, 0, [[timestamp]], NULL, 'themedesignermode', '0', NULL),
(379, 0, [[timestamp]], NULL, 'allowuserthemes', '0', NULL),
(380, 0, [[timestamp]], NULL, 'allowcoursethemes', '0', NULL),
(381, 0, [[timestamp]], NULL, 'allowcategorythemes', '0', NULL),
(382, 0, [[timestamp]], NULL, 'allowcohortthemes', '0', NULL),
(383, 0, [[timestamp]], NULL, 'allowthemechangeonurl', '0', NULL),
(384, 0, [[timestamp]], NULL, 'allowuserblockhiding', '1', NULL),
(385, 0, [[timestamp]], NULL, 'allowblockstodock', '1', NULL),
(386, 0, [[timestamp]], NULL, 'custommenuitems', '', NULL),
(387, 0, [[timestamp]], NULL, 'customusermenuitems', 'grades,grades|/grade/report/mygrades.php|grades\nmessages,message|/message/index.php|message\npreferences,moodle|/user/preferences.php|preferences', NULL),
(388, 0, [[timestamp]], NULL, 'enabledevicedetection', '1', NULL),
(389, 0, [[timestamp]], NULL, 'devicedetectregex', '[]', NULL),
(390, 0, [[timestamp]], 'theme_boost', 'preset', 'default.scss', NULL),
(391, 0, [[timestamp]], 'theme_boost', 'presetfiles', '', NULL),
(392, 0, [[timestamp]], 'theme_boost', 'backgroundimage', '', NULL),
(393, 0, [[timestamp]], 'theme_boost', 'brandcolor', '', NULL),
(394, 0, [[timestamp]], 'theme_boost', 'scsspre', '', NULL),
(395, 0, [[timestamp]], 'theme_boost', 'scss', '', NULL),
(396, 0, [[timestamp]], 'theme_clean', 'invert', '0', NULL),
(397, 0, [[timestamp]], 'theme_clean', 'logo', '', NULL),
(398, 0, [[timestamp]], 'theme_clean', 'smalllogo', '', NULL),
(399, 0, [[timestamp]], 'theme_clean', 'sitename', '1', NULL),
(400, 0, [[timestamp]], 'theme_clean', 'customcss', '', NULL),
(401, 0, [[timestamp]], 'theme_clean', 'footnote', '', NULL),
(402, 0, [[timestamp]], 'theme_more', 'textcolor', '#333366', NULL),
(403, 0, [[timestamp]], 'theme_more', 'linkcolor', '#FF6500', NULL),
(404, 0, [[timestamp]], 'theme_more', 'bodybackground', '', NULL),
(405, 0, [[timestamp]], 'theme_more', 'backgroundimage', '', NULL),
(406, 0, [[timestamp]], 'theme_more', 'backgroundrepeat', 'repeat', NULL),
(407, 0, [[timestamp]], 'theme_more', 'backgroundposition', '0', NULL),
(408, 0, [[timestamp]], 'theme_more', 'backgroundfixed', '0', NULL),
(409, 0, [[timestamp]], 'theme_more', 'contentbackground', '#FFFFFF', NULL),
(410, 0, [[timestamp]], 'theme_more', 'secondarybackground', '#FFFFFF', NULL),
(411, 0, [[timestamp]], 'theme_more', 'invert', '1', NULL),
(412, 0, [[timestamp]], 'theme_more', 'logo', '', NULL),
(413, 0, [[timestamp]], 'theme_more', 'smalllogo', '', NULL),
(414, 0, [[timestamp]], 'theme_more', 'sitename', '1', NULL),
(415, 0, [[timestamp]], 'theme_more', 'customcss', '', NULL),
(416, 0, [[timestamp]], 'theme_more', 'footnote', '', NULL),
(417, 0, [[timestamp]], 'core_admin', 'logo', '', NULL),
(418, 0, [[timestamp]], 'core_admin', 'logocompact', '', NULL),
(419, 0, [[timestamp]], NULL, 'calendartype', 'gregorian', NULL),
(420, 0, [[timestamp]], NULL, 'calendar_adminseesall', '0', NULL),
(421, 0, [[timestamp]], NULL, 'calendar_site_timeformat', '0', NULL),
(422, 0, [[timestamp]], NULL, 'calendar_startwday', '1', NULL),
(423, 0, [[timestamp]], NULL, 'calendar_weekend', '65', NULL),
(424, 0, [[timestamp]], NULL, 'calendar_lookahead', '21', NULL),
(425, 0, [[timestamp]], NULL, 'calendar_maxevents', '10', NULL),
(426, 0, [[timestamp]], NULL, 'enablecalendarexport', '1', NULL),
(427, 0, [[timestamp]], NULL, 'calendar_customexport', '1', NULL),
(428, 0, [[timestamp]], NULL, 'calendar_exportlookahead', '365', NULL),
(429, 0, [[timestamp]], NULL, 'calendar_exportlookback', '5', NULL),
(430, 0, [[timestamp]], NULL, 'calendar_exportsalt', '[[export_salt]]', NULL),
(431, 0, [[timestamp]], NULL, 'calendar_showicalsource', '1', NULL),
(432, 0, [[timestamp]], NULL, 'useblogassociations', '1', NULL),
(433, 0, [[timestamp]], NULL, 'bloglevel', '4', NULL),
(434, 0, [[timestamp]], NULL, 'useexternalblogs', '1', NULL),
(435, 0, [[timestamp]], NULL, 'externalblogcrontime', '86400', NULL),
(436, 0, [[timestamp]], NULL, 'maxexternalblogsperuser', '1', NULL),
(437, 0, [[timestamp]], NULL, 'blogusecomments', '1', NULL),
(438, 0, [[timestamp]], NULL, 'blogshowcommentscount', '1', NULL),
(439, 0, [[timestamp]], NULL, 'defaulthomepage', '1', NULL),
(440, 0, [[timestamp]], NULL, 'allowguestmymoodle', '1', NULL),
(441, 0, [[timestamp]], NULL, 'navshowfullcoursenames', '0', NULL),
(442, 0, [[timestamp]], NULL, 'navshowcategories', '1', NULL),
(443, 0, [[timestamp]], NULL, 'navshowmycoursecategories', '0', NULL),
(444, 0, [[timestamp]], NULL, 'navshowallcourses', '0', NULL),
(445, 0, [[timestamp]], NULL, 'navsortmycoursessort', 'sortorder', NULL),
(446, 0, [[timestamp]], NULL, 'navcourselimit', '10', NULL),
(447, 0, [[timestamp]], NULL, 'usesitenameforsitepages', '0', NULL),
(448, 0, [[timestamp]], NULL, 'linkadmincategories', '1', NULL),
(449, 0, [[timestamp]], NULL, 'linkcoursesections', '1', NULL),
(450, 0, [[timestamp]], NULL, 'navshowfrontpagemods', '1', NULL),
(451, 0, [[timestamp]], NULL, 'navadduserpostslinks', '1', NULL),
(452, 0, [[timestamp]], NULL, 'formatstringstriptags', '1', NULL),
(453, 0, [[timestamp]], NULL, 'emoticons', '[{"text":":-)","imagename":"s\\/smiley","imagecomponent":"core","altidentifier":"smiley","altcomponent":"core_pix"},{"text":":)","imagename":"s\\/smiley","imagecomponent":"core","altidentifier":"smiley","altcomponent":"core_pix"},{"text":":-D","imagename":"s\\/biggrin","imagecomponent":"core","altidentifier":"biggrin","altcomponent":"core_pix"},{"text":";-)","imagename":"s\\/wink","imagecomponent":"core","altidentifier":"wink","altcomponent":"core_pix"},{"text":":-\\/","imagename":"s\\/mixed","imagecomponent":"core","altidentifier":"mixed","altcomponent":"core_pix"},{"text":"V-.","imagename":"s\\/thoughtful","imagecomponent":"core","altidentifier":"thoughtful","altcomponent":"core_pix"},{"text":":-P","imagename":"s\\/tongueout","imagecomponent":"core","altidentifier":"tongueout","altcomponent":"core_pix"},{"text":":-p","imagename":"s\\/tongueout","imagecomponent":"core","altidentifier":"tongueout","altcomponent":"core_pix"},{"text":"B-)","imagename":"s\\/cool","imagecomponent":"core","altidentifier":"cool","altcomponent":"core_pix"},{"text":"^-)","imagename":"s\\/approve","imagecomponent":"core","altidentifier":"approve","altcomponent":"core_pix"},{"text":"8-)","imagename":"s\\/wideeyes","imagecomponent":"core","altidentifier":"wideeyes","altcomponent":"core_pix"},{"text":":o)","imagename":"s\\/clown","imagecomponent":"core","altidentifier":"clown","altcomponent":"core_pix"},{"text":":-(","imagename":"s\\/sad","imagecomponent":"core","altidentifier":"sad","altcomponent":"core_pix"},{"text":":(","imagename":"s\\/sad","imagecomponent":"core","altidentifier":"sad","altcomponent":"core_pix"},{"text":"8-.","imagename":"s\\/shy","imagecomponent":"core","altidentifier":"shy","altcomponent":"core_pix"},{"text":":-I","imagename":"s\\/blush","imagecomponent":"core","altidentifier":"blush","altcomponent":"core_pix"},{"text":":-X","imagename":"s\\/kiss","imagecomponent":"core","altidentifier":"kiss","altcomponent":"core_pix"},{"text":"8-o","imagename":"s\\/surprise","imagecomponent":"core","altidentifier":"surprise","altcomponent":"core_pix"},{"text":"P-|","imagename":"s\\/blackeye","imagecomponent":"core","altidentifier":"blackeye","altcomponent":"core_pix"},{"text":"8-[","imagename":"s\\/angry","imagecomponent":"core","altidentifier":"angry","altcomponent":"core_pix"},{"text":"(grr)","imagename":"s\\/angry","imagecomponent":"core","altidentifier":"angry","altcomponent":"core_pix"},{"text":"xx-P","imagename":"s\\/dead","imagecomponent":"core","altidentifier":"dead","altcomponent":"core_pix"},{"text":"|-.","imagename":"s\\/sleepy","imagecomponent":"core","altidentifier":"sleepy","altcomponent":"core_pix"},{"text":"}-]","imagename":"s\\/evil","imagecomponent":"core","altidentifier":"evil","altcomponent":"core_pix"},{"text":"(h)","imagename":"s\\/heart","imagecomponent":"core","altidentifier":"heart","altcomponent":"core_pix"},{"text":"(heart)","imagename":"s\\/heart","imagecomponent":"core","altidentifier":"heart","altcomponent":"core_pix"},{"text":"(y)","imagename":"s\\/yes","imagecomponent":"core","altidentifier":"yes","altcomponent":"core"},{"text":"(n)","imagename":"s\\/no","imagecomponent":"core","altidentifier":"no","altcomponent":"core"},{"text":"(martin)","imagename":"s\\/martin","imagecomponent":"core","altidentifier":"martin","altcomponent":"core_pix"},{"text":"( )","imagename":"s\\/egg","imagecomponent":"core","altidentifier":"egg","altcomponent":"core_pix"}]', NULL),
(454, 0, [[timestamp]], NULL, 'docroot', 'https://docs.moodle.org', NULL),
(455, 0, [[timestamp]], NULL, 'doclang', '', NULL),
(456, 0, [[timestamp]], NULL, 'doctonewwindow', '0', NULL),
(457, 0, [[timestamp]], NULL, 'courselistshortnames', '0', NULL),
(458, 0, [[timestamp]], NULL, 'coursesperpage', '20', NULL),
(459, 0, [[timestamp]], NULL, 'courseswithsummarieslimit', '10', NULL),
(460, 0, [[timestamp]], NULL, 'courseoverviewfileslimit', '1', NULL),
(461, 0, [[timestamp]], NULL, 'courseoverviewfilesext', '.jpg,.gif,.png', NULL),
(462, 0, [[timestamp]], NULL, 'useexternalyui', '0', NULL),
(463, 0, [[timestamp]], NULL, 'yuicomboloading', '1', NULL),
(464, 0, [[timestamp]], NULL, 'cachejs', '1', NULL),
(465, 0, [[timestamp]], NULL, 'modchooserdefault', '1', NULL),
(466, 0, [[timestamp]], NULL, 'additionalhtmlhead', '', NULL),
(467, 0, [[timestamp]], NULL, 'additionalhtmltopofbody', '', NULL),
(468, 0, [[timestamp]], NULL, 'additionalhtmlfooter', '', NULL),
(469, 0, [[timestamp]], NULL, 'pathtophp', '', NULL),
(470, 0, [[timestamp]], NULL, 'pathtodu', '', NULL),
(471, 0, [[timestamp]], NULL, 'aspellpath', '', NULL),
(472, 0, [[timestamp]], NULL, 'pathtodot', '', NULL),
(473, 0, [[timestamp]], NULL, 'pathtogs', '/usr/bin/gs', NULL),
(474, 0, [[timestamp]], NULL, 'pathtopython', '', NULL),
(475, 0, [[timestamp]], NULL, 'supportname', 'Admin User', NULL),
(476, 0, [[timestamp]], NULL, 'supportemail', '', NULL),
(477, 0, [[timestamp]], NULL, 'supportpage', '', NULL),
(478, 0, [[timestamp]], NULL, 'dbsessions', '0', NULL),
(479, 0, [[timestamp]], NULL, 'sessioncookie', '', NULL),
(480, 0, [[timestamp]], NULL, 'sessioncookiepath', '', NULL),
(481, 0, [[timestamp]], NULL, 'sessioncookiedomain', '', NULL),
(482, 0, [[timestamp]], NULL, 'statsfirstrun', 'none', NULL),
(483, 0, [[timestamp]], NULL, 'statsmaxruntime', '0', NULL),
(484, 0, [[timestamp]], NULL, 'statsruntimedays', '31', NULL),
(485, 0, [[timestamp]], NULL, 'statsuserthreshold', '0', NULL),
(486, 0, [[timestamp]], NULL, 'slasharguments', '1', NULL),
(487, 0, [[timestamp]], NULL, 'getremoteaddrconf', '3', NULL),
(488, 0, [[timestamp]], NULL, 'reverseproxyignore', '', NULL),
(489, 0, [[timestamp]], NULL, 'proxyhost', '', NULL),
(490, 0, [[timestamp]], NULL, 'proxyport', '0', NULL),
(491, 0, [[timestamp]], NULL, 'proxytype', 'HTTP', NULL),
(492, 0, [[timestamp]], NULL, 'proxyuser', '', NULL),
(493, 0, [[timestamp]], NULL, 'proxypassword', '', NULL),
(494, 0, [[timestamp]], NULL, 'proxybypass', 'localhost, 127.0.0.1', NULL),
(495, 0, [[timestamp]], NULL, 'maintenance_enabled', '0', NULL),
(496, 0, [[timestamp]], NULL, 'maintenance_message', '', NULL),
(497, 0, [[timestamp]], NULL, 'deleteunconfirmed', '168', NULL),
(498, 0, [[timestamp]], NULL, 'deleteincompleteusers', '0', NULL),
(499, 0, [[timestamp]], NULL, 'disablegradehistory', '0', NULL),
(500, 0, [[timestamp]], NULL, 'gradehistorylifetime', '0', NULL),
(501, 0, [[timestamp]], NULL, 'tempdatafoldercleanup', '168', NULL),
(502, 0, [[timestamp]], NULL, 'extramemorylimit', '512M', NULL),
(503, 0, [[timestamp]], NULL, 'maxtimelimit', '0', NULL),
(504, 0, [[timestamp]], NULL, 'curlcache', '120', NULL),
(505, 0, [[timestamp]], NULL, 'curltimeoutkbitrate', '56', NULL),
(506, 0, [[timestamp]], NULL, 'smtphosts', '', NULL),
(507, 0, [[timestamp]], NULL, 'smtpsecure', '', NULL),
(508, 0, [[timestamp]], NULL, 'smtpauthtype', 'LOGIN', NULL),
(509, 0, [[timestamp]], NULL, 'smtpuser', '', NULL),
(510, 0, [[timestamp]], NULL, 'smtppass', '', NULL),
(511, 0, [[timestamp]], NULL, 'smtpmaxbulk', '1', NULL),
(512, 0, [[timestamp]], NULL, 'noreplyaddress', '[[admin_email]]', NULL),
(513, 0, [[timestamp]], NULL, 'allowedemaildomains', '', NULL),
(514, 0, [[timestamp]], NULL, 'sitemailcharset', '0', NULL),
(515, 0, [[timestamp]], NULL, 'allowusermailcharset', '0', NULL),
(516, 0, [[timestamp]], NULL, 'allowattachments', '1', NULL),
(517, 0, [[timestamp]], NULL, 'mailnewline', 'LF', NULL),
(518, 0, [[timestamp]], NULL, 'emailfromvia', '1', NULL),
(519, 0, [[timestamp]], NULL, 'updateautocheck', '1', NULL),
(520, 0, [[timestamp]], NULL, 'updateminmaturity', '200', NULL),
(521, 0, [[timestamp]], NULL, 'updatenotifybuilds', '0', NULL),
(522, 0, [[timestamp]], NULL, 'enablesafebrowserintegration', '0', NULL),
(523, 0, [[timestamp]], NULL, 'dndallowtextandlinks', '0', NULL),
(524, 0, [[timestamp]], NULL, 'pathtosassc', '', NULL),
(525, 0, [[timestamp]], NULL, 'forceclean', '0', NULL),
(526, 0, [[timestamp]], NULL, 'debug', '0', NULL),
(527, 0, [[timestamp]], NULL, 'debugdisplay', '1', NULL),
(528, 0, [[timestamp]], NULL, 'debugsmtp', '0', NULL),
(529, 0, [[timestamp]], NULL, 'perfdebug', '7', NULL),
(530, 0, [[timestamp]], NULL, 'debugstringids', '0', NULL),
(531, 0, [[timestamp]], NULL, 'debugvalidators', '0', NULL),
(532, 0, [[timestamp]], NULL, 'debugpageinfo', '0', NULL),
(533, 0, [[timestamp]], NULL, 'profilingenabled', '0', NULL),
(534, 0, [[timestamp]], NULL, 'profilingincluded', '', NULL),
(535, 0, [[timestamp]], NULL, 'profilingexcluded', '', NULL),
(536, 0, [[timestamp]], NULL, 'profilingautofrec', '0', NULL),
(537, 0, [[timestamp]], NULL, 'profilingallowme', '0', NULL),
(538, 0, [[timestamp]], NULL, 'profilingallowall', '0', NULL),
(539, 0, [[timestamp]], NULL, 'profilinglifetime', '1440', NULL),
(540, 0, [[timestamp]], NULL, 'profilingimportprefix', '(I)', NULL),
(541, 0, [[timestamp]], 'activitynames', 'filter_active', '1', ''),
(542, 0, [[timestamp]], 'mathjaxloader', 'filter_active', '1', ''),
(543, 0, [[timestamp]], 'mediaplugin', 'filter_active', '1', ''),
(544, 2, [[timestamp]], NULL, 'notloggedinroleid', '6', NULL),
(545, 2, [[timestamp]], NULL, 'guestroleid', '6', NULL),
(546, 2, [[timestamp]], NULL, 'defaultuserroleid', '7', NULL),
(547, 2, [[timestamp]], NULL, 'creatornewroleid', '3', NULL),
(548, 2, [[timestamp]], NULL, 'restorernewroleid', '3', NULL),
(549, 2, [[timestamp]], 'tool_dataprivacy', 'contactdataprotectionofficer', '0', NULL),
(550, 2, [[timestamp]], 'tool_dataprivacy', 'automaticdeletionrequests', '0', NULL),
(551, 2, [[timestamp]], 'tool_dataprivacy', 'privacyrequestexpiry', '604800', NULL),
(552, 2, [[timestamp]], 'tool_dataprivacy', 'requireallenddatesforuserdeletion', '1', NULL),
(553, 2, [[timestamp]], 'tool_dataprivacy', 'showdataretentionsummary', '1', NULL),
(554, 2, [[timestamp]], 'tool_log', 'exportlog', '1', NULL),
(555, 2, [[timestamp]], NULL, 'sitepolicyhandler', '', NULL),
(556, 2, [[timestamp]], NULL, 'gradebookroles', '5', NULL),
(557, 2, [[timestamp]], 'analytics', 'logstore', 'logstore_standard', NULL),
(558, 2, [[timestamp]], 'assign', 'feedback_plugin_for_gradebook', 'assignfeedback_comments', NULL),
(559, 2, [[timestamp]], 'assign', 'showrecentsubmissions', '0', NULL),
(560, 2, [[timestamp]], 'assign', 'submissionreceipts', '1', NULL),
(561, 2, [[timestamp]], 'assign', 'submissionstatement', 'This assignment is my own work, except where I have acknowledged the use of the works of other people.', NULL),
(562, 2, [[timestamp]], 'assign', 'maxperpage', '-1', NULL),
(563, 2, [[timestamp]], 'assign', 'alwaysshowdescription', '1', NULL),
(564, 2, [[timestamp]], 'assign', 'alwaysshowdescription_adv', '', NULL),
(565, 2, [[timestamp]], 'assign', 'alwaysshowdescription_locked', '', NULL),
(566, 2, [[timestamp]], 'assign', 'allowsubmissionsfromdate', '0', NULL),
(567, 2, [[timestamp]], 'assign', 'allowsubmissionsfromdate_enabled', '1', NULL),
(568, 2, [[timestamp]], 'assign', 'allowsubmissionsfromdate_adv', '', NULL),
(569, 2, [[timestamp]], 'assign', 'duedate', '604800', NULL),
(570, 2, [[timestamp]], 'assign', 'duedate_enabled', '1', NULL),
(571, 2, [[timestamp]], 'assign', 'duedate_adv', '', NULL),
(572, 2, [[timestamp]], 'assign', 'cutoffdate', '1209600', NULL),
(573, 2, [[timestamp]], 'assign', 'cutoffdate_enabled', '', NULL),
(574, 2, [[timestamp]], 'assign', 'cutoffdate_adv', '', NULL),
(575, 2, [[timestamp]], 'assign', 'gradingduedate', '1209600', NULL),
(576, 2, [[timestamp]], 'assign', 'gradingduedate_enabled', '1', NULL),
(577, 2, [[timestamp]], 'assign', 'gradingduedate_adv', '', NULL),
(578, 2, [[timestamp]], 'assign', 'submissiondrafts', '0', NULL),
(579, 2, [[timestamp]], 'assign', 'submissiondrafts_adv', '', NULL),
(580, 2, [[timestamp]], 'assign', 'submissiondrafts_locked', '', NULL),
(581, 2, [[timestamp]], 'assign', 'requiresubmissionstatement', '0', NULL),
(582, 2, [[timestamp]], 'assign', 'requiresubmissionstatement_adv', '', NULL),
(583, 2, [[timestamp]], 'assign', 'requiresubmissionstatement_locked', '', NULL),
(584, 2, [[timestamp]], 'assign', 'attemptreopenmethod', 'none', NULL),
(585, 2, [[timestamp]], 'assign', 'attemptreopenmethod_adv', '', NULL),
(586, 2, [[timestamp]], 'assign', 'attemptreopenmethod_locked', '', NULL),
(587, 2, [[timestamp]], 'assign', 'maxattempts', '-1', NULL),
(588, 2, [[timestamp]], 'assign', 'maxattempts_adv', '', NULL),
(589, 2, [[timestamp]], 'assign', 'maxattempts_locked', '', NULL),
(590, 2, [[timestamp]], 'assign', 'teamsubmission', '0', NULL),
(591, 2, [[timestamp]], 'assign', 'teamsubmission_adv', '', NULL),
(592, 2, [[timestamp]], 'assign', 'teamsubmission_locked', '', NULL),
(593, 2, [[timestamp]], 'assign', 'preventsubmissionnotingroup', '0', NULL),
(594, 2, [[timestamp]], 'assign', 'preventsubmissionnotingroup_adv', '', NULL),
(595, 2, [[timestamp]], 'assign', 'preventsubmissionnotingroup_locked', '', NULL),
(596, 2, [[timestamp]], 'assign', 'requireallteammemberssubmit', '0', NULL),
(597, 2, [[timestamp]], 'assign', 'requireallteammemberssubmit_adv', '', NULL),
(598, 2, [[timestamp]], 'assign', 'requireallteammemberssubmit_locked', '', NULL),
(599, 2, [[timestamp]], 'assign', 'teamsubmissiongroupingid', '', NULL),
(600, 2, [[timestamp]], 'assign', 'teamsubmissiongroupingid_adv', '', NULL),
(601, 2, [[timestamp]], 'assign', 'sendnotifications', '0', NULL),
(602, 2, [[timestamp]], 'assign', 'sendnotifications_adv', '', NULL),
(603, 2, [[timestamp]], 'assign', 'sendnotifications_locked', '', NULL),
(604, 2, [[timestamp]], 'assign', 'sendlatenotifications', '0', NULL),
(605, 2, [[timestamp]], 'assign', 'sendlatenotifications_adv', '', NULL),
(606, 2, [[timestamp]], 'assign', 'sendlatenotifications_locked', '', NULL),
(607, 2, [[timestamp]], 'assign', 'sendstudentnotifications', '1', NULL),
(608, 2, [[timestamp]], 'assign', 'sendstudentnotifications_adv', '', NULL),
(609, 2, [[timestamp]], 'assign', 'sendstudentnotifications_locked', '', NULL),
(610, 2, [[timestamp]], 'assign', 'blindmarking', '0', NULL),
(611, 2, [[timestamp]], 'assign', 'blindmarking_adv', '', NULL),
(612, 2, [[timestamp]], 'assign', 'blindmarking_locked', '', NULL),
(613, 2, [[timestamp]], 'assign', 'markingworkflow', '0', NULL),
(614, 2, [[timestamp]], 'assign', 'markingworkflow_adv', '', NULL),
(615, 2, [[timestamp]], 'assign', 'markingworkflow_locked', '', NULL),
(616, 2, [[timestamp]], 'assign', 'markingallocation', '0', NULL),
(617, 2, [[timestamp]], 'assign', 'markingallocation_adv', '', NULL),
(618, 2, [[timestamp]], 'assign', 'markingallocation_locked', '', NULL),
(619, 2, [[timestamp]], 'assignsubmission_file', 'default', '1', NULL),
(620, 2, [[timestamp]], 'assignsubmission_file', 'maxfiles', '20', NULL),
(621, 2, [[timestamp]], 'assignsubmission_file', 'filetypes', '', NULL),
(622, 2, [[timestamp]], 'assignsubmission_file', 'maxbytes', '0', NULL),
(623, 2, [[timestamp]], 'assignsubmission_onlinetext', 'default', '0', NULL),
(624, 2, [[timestamp]], 'assignfeedback_comments', 'default', '1', NULL),
(625, 2, [[timestamp]], 'assignfeedback_comments', 'inline', '0', NULL),
(626, 2, [[timestamp]], 'assignfeedback_comments', 'inline_adv', '', NULL),
(627, 2, [[timestamp]], 'assignfeedback_comments', 'inline_locked', '', NULL),
(628, 2, [[timestamp]], 'assignfeedback_editpdf', 'default', '1', NULL),
(629, 2, [[timestamp]], 'assignfeedback_editpdf', 'stamps', '', NULL),
(630, 2, [[timestamp]], 'assignfeedback_file', 'default', '0', NULL),
(631, 2, [[timestamp]], 'assignfeedback_offline', 'default', '0', NULL),
(632, 2, [[timestamp]], 'book', 'numberingoptions', '0,1,2,3', NULL),
(633, 2, [[timestamp]], 'book', 'navoptions', '0,1,2', NULL),
(634, 2, [[timestamp]], 'book', 'numbering', '1', NULL),
(635, 2, [[timestamp]], 'book', 'navstyle', '1', NULL),
(636, 2, [[timestamp]], NULL, 'chat_method', 'ajax', NULL),
(637, 2, [[timestamp]], NULL, 'chat_refresh_userlist', '10', NULL),
(638, 2, [[timestamp]], NULL, 'chat_old_ping', '35', NULL),
(639, 2, [[timestamp]], NULL, 'chat_refresh_room', '5', NULL),
(640, 2, [[timestamp]], NULL, 'chat_normal_updatemode', 'jsupdate', NULL),
(641, 2, [[timestamp]], NULL, 'chat_serverhost', '[[domhost]]', NULL),
(642, 2, [[timestamp]], NULL, 'chat_serverip', '127.0.0.1', NULL),
(643, 2, [[timestamp]], NULL, 'chat_serverport', '9111', NULL),
(644, 2, [[timestamp]], NULL, 'chat_servermax', '100', NULL),
(645, 2, [[timestamp]], NULL, 'data_enablerssfeeds', '0', NULL),
(646, 2, [[timestamp]], NULL, 'feedback_allowfullanonymous', '0', NULL),
(647, 2, [[timestamp]], 'resource', 'framesize', '130', NULL),
(648, 2, [[timestamp]], 'resource', 'displayoptions', '0,1,4,5,6', NULL),
(649, 2, [[timestamp]], 'resource', 'printintro', '1', NULL),
(650, 2, [[timestamp]], 'resource', 'display', '0', NULL),
(651, 2, [[timestamp]], 'resource', 'showsize', '0', NULL),
(652, 2, [[timestamp]], 'resource', 'showtype', '0', NULL),
(653, 2, [[timestamp]], 'resource', 'showdate', '0', NULL),
(654, 2, [[timestamp]], 'resource', 'popupwidth', '620', NULL),
(655, 2, [[timestamp]], 'resource', 'popupheight', '450', NULL),
(656, 2, [[timestamp]], 'resource', 'filterfiles', '0', NULL),
(657, 2, [[timestamp]], 'folder', 'showexpanded', '1', NULL),
(658, 2, [[timestamp]], 'folder', 'maxsizetodownload', '0', NULL),
(659, 2, [[timestamp]], NULL, 'forum_displaymode', '3', NULL),
(660, 2, [[timestamp]], NULL, 'forum_shortpost', '300', NULL),
(661, 2, [[timestamp]], NULL, 'forum_longpost', '600', NULL),
(662, 2, [[timestamp]], NULL, 'forum_manydiscussions', '100', NULL),
(663, 2, [[timestamp]], NULL, 'forum_maxbytes', '512000', NULL),
(664, 2, [[timestamp]], NULL, 'forum_maxattachments', '9', NULL),
(665, 2, [[timestamp]], NULL, 'forum_subscription', '0', NULL),
(666, 2, [[timestamp]], NULL, 'forum_trackingtype', '1', NULL),
(667, 2, [[timestamp]], NULL, 'forum_trackreadposts', '1', NULL),
(668, 2, [[timestamp]], NULL, 'forum_allowforcedreadtracking', '0', NULL),
(669, 2, [[timestamp]], NULL, 'forum_oldpostdays', '14', NULL),
(670, 2, [[timestamp]], NULL, 'forum_usermarksread', '0', NULL),
(671, 2, [[timestamp]], NULL, 'forum_cleanreadtime', '2', NULL),
(672, 2, [[timestamp]], NULL, 'digestmailtime', '17', NULL),
(673, 2, [[timestamp]], NULL, 'forum_enablerssfeeds', '0', NULL),
(674, 2, [[timestamp]], NULL, 'forum_enabletimedposts', '1', NULL),
(675, 2, [[timestamp]], NULL, 'glossary_entbypage', '10', NULL),
(676, 2, [[timestamp]], NULL, 'glossary_dupentries', '0', NULL),
(677, 2, [[timestamp]], NULL, 'glossary_allowcomments', '0', NULL),
(678, 2, [[timestamp]], NULL, 'glossary_linkbydefault', '1', NULL),
(679, 2, [[timestamp]], NULL, 'glossary_defaultapproval', '1', NULL),
(680, 2, [[timestamp]], NULL, 'glossary_enablerssfeeds', '0', NULL),
(681, 2, [[timestamp]], NULL, 'glossary_linkentries', '0', NULL),
(682, 2, [[timestamp]], NULL, 'glossary_casesensitive', '0', NULL),
(683, 2, [[timestamp]], NULL, 'glossary_fullmatch', '0', NULL),
(684, 2, [[timestamp]], 'imscp', 'keepold', '1', NULL),
(685, 2, [[timestamp]], 'imscp', 'keepold_adv', '', NULL),
(686, 2, [[timestamp]], 'label', 'dndmedia', '1', NULL),
(687, 2, [[timestamp]], 'label', 'dndresizewidth', '400', NULL),
(688, 2, [[timestamp]], 'label', 'dndresizeheight', '400', NULL),
(689, 2, [[timestamp]], 'mod_lesson', 'mediafile', '', NULL),
(690, 2, [[timestamp]], 'mod_lesson', 'mediafile_adv', '1', NULL),
(691, 2, [[timestamp]], 'mod_lesson', 'mediawidth', '640', NULL),
(692, 2, [[timestamp]], 'mod_lesson', 'mediaheight', '480', NULL),
(693, 2, [[timestamp]], 'mod_lesson', 'mediaclose', '0', NULL),
(694, 2, [[timestamp]], 'mod_lesson', 'progressbar', '0', NULL),
(695, 2, [[timestamp]], 'mod_lesson', 'progressbar_adv', '', NULL),
(696, 2, [[timestamp]], 'mod_lesson', 'ongoing', '0', NULL),
(697, 2, [[timestamp]], 'mod_lesson', 'ongoing_adv', '1', NULL),
(698, 2, [[timestamp]], 'mod_lesson', 'displayleftmenu', '0', NULL),
(699, 2, [[timestamp]], 'mod_lesson', 'displayleftmenu_adv', '', NULL),
(700, 2, [[timestamp]], 'mod_lesson', 'displayleftif', '0', NULL),
(701, 2, [[timestamp]], 'mod_lesson', 'displayleftif_adv', '1', NULL),
(702, 2, [[timestamp]], 'mod_lesson', 'slideshow', '0', NULL),
(703, 2, [[timestamp]], 'mod_lesson', 'slideshow_adv', '1', NULL),
(704, 2, [[timestamp]], 'mod_lesson', 'slideshowwidth', '640', NULL),
(705, 2, [[timestamp]], 'mod_lesson', 'slideshowheight', '480', NULL),
(706, 2, [[timestamp]], 'mod_lesson', 'slideshowbgcolor', '#FFFFFF', NULL),
(707, 2, [[timestamp]], 'mod_lesson', 'maxanswers', '5', NULL),
(708, 2, [[timestamp]], 'mod_lesson', 'maxanswers_adv', '1', NULL),
(709, 2, [[timestamp]], 'mod_lesson', 'defaultfeedback', '0', NULL),
(710, 2, [[timestamp]], 'mod_lesson', 'defaultfeedback_adv', '1', NULL),
(711, 2, [[timestamp]], 'mod_lesson', 'activitylink', '', NULL),
(712, 2, [[timestamp]], 'mod_lesson', 'activitylink_adv', '1', NULL),
(713, 2, [[timestamp]], 'mod_lesson', 'timelimit', '0', NULL),
(714, 2, [[timestamp]], 'mod_lesson', 'timelimit_adv', '', NULL),
(715, 2, [[timestamp]], 'mod_lesson', 'password', '0', NULL),
(716, 2, [[timestamp]], 'mod_lesson', 'password_adv', '1', NULL),
(717, 2, [[timestamp]], 'mod_lesson', 'modattempts', '0', NULL),
(718, 2, [[timestamp]], 'mod_lesson', 'modattempts_adv', '', NULL),
(719, 2, [[timestamp]], 'mod_lesson', 'displayreview', '0', NULL),
(720, 2, [[timestamp]], 'mod_lesson', 'displayreview_adv', '', NULL),
(721, 2, [[timestamp]], 'mod_lesson', 'maximumnumberofattempts', '1', NULL),
(722, 2, [[timestamp]], 'mod_lesson', 'maximumnumberofattempts_adv', '', NULL);
INSERT INTO `[[dbprefix]]config_log` VALUES
(723, 2, [[timestamp]], 'mod_lesson', 'defaultnextpage', '0', NULL),
(724, 2, [[timestamp]], 'mod_lesson', 'defaultnextpage_adv', '1', NULL),
(725, 2, [[timestamp]], 'mod_lesson', 'numberofpagestoshow', '1', NULL),
(726, 2, [[timestamp]], 'mod_lesson', 'numberofpagestoshow_adv', '1', NULL),
(727, 2, [[timestamp]], 'mod_lesson', 'practice', '0', NULL),
(728, 2, [[timestamp]], 'mod_lesson', 'practice_adv', '', NULL),
(729, 2, [[timestamp]], 'mod_lesson', 'customscoring', '1', NULL),
(730, 2, [[timestamp]], 'mod_lesson', 'customscoring_adv', '1', NULL),
(731, 2, [[timestamp]], 'mod_lesson', 'retakesallowed', '0', NULL),
(732, 2, [[timestamp]], 'mod_lesson', 'retakesallowed_adv', '', NULL),
(733, 2, [[timestamp]], 'mod_lesson', 'handlingofretakes', '0', NULL),
(734, 2, [[timestamp]], 'mod_lesson', 'handlingofretakes_adv', '1', NULL),
(735, 2, [[timestamp]], 'mod_lesson', 'minimumnumberofquestions', '0', NULL),
(736, 2, [[timestamp]], 'mod_lesson', 'minimumnumberofquestions_adv', '1', NULL),
(737, 2, [[timestamp]], 'page', 'displayoptions', '5', NULL),
(738, 2, [[timestamp]], 'page', 'printheading', '1', NULL),
(739, 2, [[timestamp]], 'page', 'printintro', '0', NULL),
(740, 2, [[timestamp]], 'page', 'display', '5', NULL),
(741, 2, [[timestamp]], 'page', 'popupwidth', '620', NULL),
(742, 2, [[timestamp]], 'page', 'popupheight', '450', NULL),
(743, 2, [[timestamp]], 'quiz', 'timelimit', '0', NULL),
(744, 2, [[timestamp]], 'quiz', 'timelimit_adv', '', NULL),
(745, 2, [[timestamp]], 'quiz', 'overduehandling', 'autosubmit', NULL),
(746, 2, [[timestamp]], 'quiz', 'overduehandling_adv', '', NULL),
(747, 2, [[timestamp]], 'quiz', 'graceperiod', '86400', NULL),
(748, 2, [[timestamp]], 'quiz', 'graceperiod_adv', '', NULL),
(749, 2, [[timestamp]], 'quiz', 'graceperiodmin', '60', NULL),
(750, 2, [[timestamp]], 'quiz', 'attempts', '0', NULL),
(751, 2, [[timestamp]], 'quiz', 'attempts_adv', '', NULL),
(752, 2, [[timestamp]], 'quiz', 'grademethod', '1', NULL),
(753, 2, [[timestamp]], 'quiz', 'grademethod_adv', '', NULL),
(754, 2, [[timestamp]], 'quiz', 'maximumgrade', '10', NULL),
(755, 2, [[timestamp]], 'quiz', 'questionsperpage', '1', NULL),
(756, 2, [[timestamp]], 'quiz', 'questionsperpage_adv', '', NULL),
(757, 2, [[timestamp]], 'quiz', 'navmethod', 'free', NULL),
(758, 2, [[timestamp]], 'quiz', 'navmethod_adv', '1', NULL),
(759, 2, [[timestamp]], 'quiz', 'shuffleanswers', '1', NULL),
(760, 2, [[timestamp]], 'quiz', 'shuffleanswers_adv', '', NULL),
(761, 2, [[timestamp]], 'quiz', 'preferredbehaviour', 'deferredfeedback', NULL),
(762, 2, [[timestamp]], 'quiz', 'canredoquestions', '0', NULL),
(763, 2, [[timestamp]], 'quiz', 'canredoquestions_adv', '1', NULL),
(764, 2, [[timestamp]], 'quiz', 'attemptonlast', '0', NULL),
(765, 2, [[timestamp]], 'quiz', 'attemptonlast_adv', '1', NULL),
(766, 2, [[timestamp]], 'quiz', 'reviewattempt', '69904', NULL),
(767, 2, [[timestamp]], 'quiz', 'reviewcorrectness', '69904', NULL),
(768, 2, [[timestamp]], 'quiz', 'reviewmarks', '69904', NULL),
(769, 2, [[timestamp]], 'quiz', 'reviewspecificfeedback', '69904', NULL),
(770, 2, [[timestamp]], 'quiz', 'reviewgeneralfeedback', '69904', NULL),
(771, 2, [[timestamp]], 'quiz', 'reviewrightanswer', '69904', NULL),
(772, 2, [[timestamp]], 'quiz', 'reviewoverallfeedback', '4368', NULL),
(773, 2, [[timestamp]], 'quiz', 'showuserpicture', '0', NULL),
(774, 2, [[timestamp]], 'quiz', 'showuserpicture_adv', '', NULL),
(775, 2, [[timestamp]], 'quiz', 'decimalpoints', '2', NULL),
(776, 2, [[timestamp]], 'quiz', 'decimalpoints_adv', '', NULL),
(777, 2, [[timestamp]], 'quiz', 'questiondecimalpoints', '-1', NULL),
(778, 2, [[timestamp]], 'quiz', 'questiondecimalpoints_adv', '1', NULL),
(779, 2, [[timestamp]], 'quiz', 'showblocks', '0', NULL),
(780, 2, [[timestamp]], 'quiz', 'showblocks_adv', '1', NULL),
(781, 2, [[timestamp]], 'quiz', 'password', '', NULL),
(782, 2, [[timestamp]], 'quiz', 'password_adv', '', NULL),
(783, 2, [[timestamp]], 'quiz', 'subnet', '', NULL),
(784, 2, [[timestamp]], 'quiz', 'subnet_adv', '1', NULL),
(785, 2, [[timestamp]], 'quiz', 'delay1', '0', NULL),
(786, 2, [[timestamp]], 'quiz', 'delay1_adv', '1', NULL),
(787, 2, [[timestamp]], 'quiz', 'delay2', '0', NULL),
(788, 2, [[timestamp]], 'quiz', 'delay2_adv', '1', NULL),
(789, 2, [[timestamp]], 'quiz', 'browsersecurity', '-', NULL),
(790, 2, [[timestamp]], 'quiz', 'browsersecurity_adv', '1', NULL),
(791, 2, [[timestamp]], 'quiz', 'initialnumfeedbacks', '2', NULL),
(792, 2, [[timestamp]], 'quiz', 'autosaveperiod', '60', NULL),
(793, 2, [[timestamp]], 'scorm', 'displaycoursestructure', '0', NULL),
(794, 2, [[timestamp]], 'scorm', 'displaycoursestructure_adv', '', NULL),
(795, 2, [[timestamp]], 'scorm', 'popup', '0', NULL),
(796, 2, [[timestamp]], 'scorm', 'popup_adv', '', NULL),
(797, 2, [[timestamp]], 'scorm', 'displayactivityname', '1', NULL),
(798, 2, [[timestamp]], 'scorm', 'framewidth', '100', NULL),
(799, 2, [[timestamp]], 'scorm', 'framewidth_adv', '1', NULL),
(800, 2, [[timestamp]], 'scorm', 'frameheight', '500', NULL),
(801, 2, [[timestamp]], 'scorm', 'frameheight_adv', '1', NULL),
(802, 2, [[timestamp]], 'scorm', 'winoptgrp_adv', '1', NULL),
(803, 2, [[timestamp]], 'scorm', 'scrollbars', '0', NULL),
(804, 2, [[timestamp]], 'scorm', 'directories', '0', NULL),
(805, 2, [[timestamp]], 'scorm', 'location', '0', NULL),
(806, 2, [[timestamp]], 'scorm', 'menubar', '0', NULL),
(807, 2, [[timestamp]], 'scorm', 'toolbar', '0', NULL),
(808, 2, [[timestamp]], 'scorm', 'status', '0', NULL),
(809, 2, [[timestamp]], 'scorm', 'skipview', '0', NULL),
(810, 2, [[timestamp]], 'scorm', 'skipview_adv', '1', NULL),
(811, 2, [[timestamp]], 'scorm', 'hidebrowse', '0', NULL),
(812, 2, [[timestamp]], 'scorm', 'hidebrowse_adv', '1', NULL),
(813, 2, [[timestamp]], 'scorm', 'hidetoc', '0', NULL),
(814, 2, [[timestamp]], 'scorm', 'hidetoc_adv', '1', NULL),
(815, 2, [[timestamp]], 'scorm', 'nav', '1', NULL),
(816, 2, [[timestamp]], 'scorm', 'nav_adv', '1', NULL),
(817, 2, [[timestamp]], 'scorm', 'navpositionleft', '-100', NULL),
(818, 2, [[timestamp]], 'scorm', 'navpositionleft_adv', '1', NULL),
(819, 2, [[timestamp]], 'scorm', 'navpositiontop', '-100', NULL),
(820, 2, [[timestamp]], 'scorm', 'navpositiontop_adv', '1', NULL),
(821, 2, [[timestamp]], 'scorm', 'collapsetocwinsize', '767', NULL),
(822, 2, [[timestamp]], 'scorm', 'collapsetocwinsize_adv', '1', NULL),
(823, 2, [[timestamp]], 'scorm', 'displayattemptstatus', '1', NULL),
(824, 2, [[timestamp]], 'scorm', 'displayattemptstatus_adv', '', NULL),
(825, 2, [[timestamp]], 'scorm', 'grademethod', '1', NULL),
(826, 2, [[timestamp]], 'scorm', 'maxgrade', '100', NULL),
(827, 2, [[timestamp]], 'scorm', 'maxattempt', '0', NULL),
(828, 2, [[timestamp]], 'scorm', 'whatgrade', '0', NULL),
(829, 2, [[timestamp]], 'scorm', 'forcecompleted', '0', NULL),
(830, 2, [[timestamp]], 'scorm', 'forcenewattempt', '0', NULL),
(831, 2, [[timestamp]], 'scorm', 'autocommit', '0', NULL),
(832, 2, [[timestamp]], 'scorm', 'masteryoverride', '1', NULL),
(833, 2, [[timestamp]], 'scorm', 'lastattemptlock', '0', NULL),
(834, 2, [[timestamp]], 'scorm', 'auto', '0', NULL),
(835, 2, [[timestamp]], 'scorm', 'updatefreq', '0', NULL),
(836, 2, [[timestamp]], 'scorm', 'scormstandard', '0', NULL),
(837, 2, [[timestamp]], 'scorm', 'allowtypeexternal', '0', NULL),
(838, 2, [[timestamp]], 'scorm', 'allowtypelocalsync', '0', NULL),
(839, 2, [[timestamp]], 'scorm', 'allowtypeexternalaicc', '0', NULL),
(840, 2, [[timestamp]], 'scorm', 'allowaicchacp', '0', NULL),
(841, 2, [[timestamp]], 'scorm', 'aicchacptimeout', '30', NULL),
(842, 2, [[timestamp]], 'scorm', 'aicchacpkeepsessiondata', '1', NULL),
(843, 2, [[timestamp]], 'scorm', 'aiccuserid', '1', NULL),
(844, 2, [[timestamp]], 'scorm', 'forcejavascript', '1', NULL),
(845, 2, [[timestamp]], 'scorm', 'allowapidebug', '0', NULL),
(846, 2, [[timestamp]], 'scorm', 'apidebugmask', '.*', NULL),
(847, 2, [[timestamp]], 'scorm', 'protectpackagedownloads', '0', NULL),
(848, 2, [[timestamp]], 'url', 'framesize', '130', NULL),
(849, 2, [[timestamp]], 'url', 'secretphrase', '', NULL),
(850, 2, [[timestamp]], 'url', 'rolesinparams', '0', NULL),
(851, 2, [[timestamp]], 'url', 'displayoptions', '0,1,5,6', NULL),
(852, 2, [[timestamp]], 'url', 'printintro', '1', NULL),
(853, 2, [[timestamp]], 'url', 'display', '0', NULL),
(854, 2, [[timestamp]], 'url', 'popupwidth', '620', NULL),
(855, 2, [[timestamp]], 'url', 'popupheight', '450', NULL),
(856, 2, [[timestamp]], 'workshop', 'grade', '80', NULL),
(857, 2, [[timestamp]], 'workshop', 'gradinggrade', '20', NULL),
(858, 2, [[timestamp]], 'workshop', 'gradedecimals', '0', NULL),
(859, 2, [[timestamp]], 'workshop', 'maxbytes', '0', NULL),
(860, 2, [[timestamp]], 'workshop', 'strategy', 'accumulative', NULL),
(861, 2, [[timestamp]], 'workshop', 'examplesmode', '0', NULL),
(862, 2, [[timestamp]], 'workshopallocation_random', 'numofreviews', '5', NULL),
(863, 2, [[timestamp]], 'workshopform_numerrors', 'grade0', 'No', NULL),
(864, 2, [[timestamp]], 'workshopform_numerrors', 'grade1', 'Yes', NULL),
(865, 2, [[timestamp]], 'workshopeval_best', 'comparison', '5', NULL),
(866, 2, [[timestamp]], 'tool_recyclebin', 'coursebinenable', '1', NULL),
(867, 2, [[timestamp]], 'tool_recyclebin', 'coursebinexpiry', '604800', NULL),
(868, 2, [[timestamp]], 'tool_recyclebin', 'categorybinenable', '1', NULL),
(869, 2, [[timestamp]], 'tool_recyclebin', 'categorybinexpiry', '604800', NULL),
(870, 2, [[timestamp]], 'tool_recyclebin', 'autohide', '1', NULL),
(871, 2, [[timestamp]], 'antivirus_clamav', 'runningmethod', 'commandline', NULL),
(872, 2, [[timestamp]], 'antivirus_clamav', 'pathtoclam', '', NULL),
(873, 2, [[timestamp]], 'antivirus_clamav', 'pathtounixsocket', '', NULL),
(874, 2, [[timestamp]], 'antivirus_clamav', 'clamfailureonupload', 'donothing', NULL),
(875, 2, [[timestamp]], 'auth_cas', 'hostname', '', NULL),
(876, 2, [[timestamp]], 'auth_cas', 'baseuri', '', NULL),
(877, 2, [[timestamp]], 'auth_cas', 'port', '0', NULL),
(878, 2, [[timestamp]], 'auth_cas', 'casversion', '2.0', NULL),
(879, 2, [[timestamp]], 'auth_cas', 'language', 'CAS_Languages_English', NULL),
(880, 2, [[timestamp]], 'auth_cas', 'proxycas', '0', NULL),
(881, 2, [[timestamp]], 'auth_cas', 'logoutcas', '0', NULL),
(882, 2, [[timestamp]], 'auth_cas', 'multiauth', '0', NULL),
(883, 2, [[timestamp]], 'auth_cas', 'certificate_check', '0', NULL),
(884, 2, [[timestamp]], 'auth_cas', 'certificate_path', '', NULL),
(885, 2, [[timestamp]], 'auth_cas', 'curl_ssl_version', '', NULL),
(886, 2, [[timestamp]], 'auth_cas', 'logout_return_url', '', NULL),
(887, 2, [[timestamp]], 'auth_cas', 'host_url', '', NULL),
(888, 2, [[timestamp]], 'auth_cas', 'ldap_version', '3', NULL),
(889, 2, [[timestamp]], 'auth_cas', 'start_tls', '0', NULL),
(890, 2, [[timestamp]], 'auth_cas', 'ldapencoding', 'utf-8', NULL),
(891, 2, [[timestamp]], 'auth_cas', 'pagesize', '250', NULL),
(892, 2, [[timestamp]], 'auth_cas', 'bind_dn', '', NULL),
(893, 2, [[timestamp]], 'auth_cas', 'bind_pw', '', NULL),
(894, 2, [[timestamp]], 'auth_cas', 'user_type', 'default', NULL),
(895, 2, [[timestamp]], 'auth_cas', 'contexts', '', NULL),
(896, 2, [[timestamp]], 'auth_cas', 'search_sub', '0', NULL),
(897, 2, [[timestamp]], 'auth_cas', 'opt_deref', '0', NULL),
(898, 2, [[timestamp]], 'auth_cas', 'user_attribute', '', NULL),
(899, 2, [[timestamp]], 'auth_cas', 'memberattribute', '', NULL),
(900, 2, [[timestamp]], 'auth_cas', 'memberattribute_isdn', '', NULL),
(901, 2, [[timestamp]], 'auth_cas', 'objectclass', '', NULL),
(902, 2, [[timestamp]], 'auth_cas', 'attrcreators', '', NULL),
(903, 2, [[timestamp]], 'auth_cas', 'groupecreators', '', NULL),
(904, 2, [[timestamp]], 'auth_cas', 'removeuser', '0', NULL),
(905, 2, [[timestamp]], 'auth_cas', 'field_map_firstname', '', NULL),
(906, 2, [[timestamp]], 'auth_cas', 'field_updatelocal_firstname', 'oncreate', NULL),
(907, 2, [[timestamp]], 'auth_cas', 'field_updateremote_firstname', '0', NULL),
(908, 2, [[timestamp]], 'auth_cas', 'field_lock_firstname', 'unlocked', NULL),
(909, 2, [[timestamp]], 'auth_cas', 'field_map_lastname', '', NULL),
(910, 2, [[timestamp]], 'auth_cas', 'field_updatelocal_lastname', 'oncreate', NULL),
(911, 2, [[timestamp]], 'auth_cas', 'field_updateremote_lastname', '0', NULL),
(912, 2, [[timestamp]], 'auth_cas', 'field_lock_lastname', 'unlocked', NULL),
(913, 2, [[timestamp]], 'auth_cas', 'field_map_email', '', NULL),
(914, 2, [[timestamp]], 'auth_cas', 'field_updatelocal_email', 'oncreate', NULL),
(915, 2, [[timestamp]], 'auth_cas', 'field_updateremote_email', '0', NULL),
(916, 2, [[timestamp]], 'auth_cas', 'field_lock_email', 'unlocked', NULL),
(917, 2, [[timestamp]], 'auth_cas', 'field_map_city', '', NULL),
(918, 2, [[timestamp]], 'auth_cas', 'field_updatelocal_city', 'oncreate', NULL),
(919, 2, [[timestamp]], 'auth_cas', 'field_updateremote_city', '0', NULL),
(920, 2, [[timestamp]], 'auth_cas', 'field_lock_city', 'unlocked', NULL),
(921, 2, [[timestamp]], 'auth_cas', 'field_map_country', '', NULL),
(922, 2, [[timestamp]], 'auth_cas', 'field_updatelocal_country', 'oncreate', NULL),
(923, 2, [[timestamp]], 'auth_cas', 'field_updateremote_country', '0', NULL),
(924, 2, [[timestamp]], 'auth_cas', 'field_lock_country', 'unlocked', NULL),
(925, 2, [[timestamp]], 'auth_cas', 'field_map_lang', '', NULL),
(926, 2, [[timestamp]], 'auth_cas', 'field_updatelocal_lang', 'oncreate', NULL),
(927, 2, [[timestamp]], 'auth_cas', 'field_updateremote_lang', '0', NULL),
(928, 2, [[timestamp]], 'auth_cas', 'field_lock_lang', 'unlocked', NULL),
(929, 2, [[timestamp]], 'auth_cas', 'field_map_description', '', NULL),
(930, 2, [[timestamp]], 'auth_cas', 'field_updatelocal_description', 'oncreate', NULL),
(931, 2, [[timestamp]], 'auth_cas', 'field_updateremote_description', '0', NULL),
(932, 2, [[timestamp]], 'auth_cas', 'field_lock_description', 'unlocked', NULL),
(933, 2, [[timestamp]], 'auth_cas', 'field_map_url', '', NULL),
(934, 2, [[timestamp]], 'auth_cas', 'field_updatelocal_url', 'oncreate', NULL),
(935, 2, [[timestamp]], 'auth_cas', 'field_updateremote_url', '0', NULL),
(936, 2, [[timestamp]], 'auth_cas', 'field_lock_url', 'unlocked', NULL),
(937, 2, [[timestamp]], 'auth_cas', 'field_map_idnumber', '', NULL),
(938, 2, [[timestamp]], 'auth_cas', 'field_updatelocal_idnumber', 'oncreate', NULL),
(939, 2, [[timestamp]], 'auth_cas', 'field_updateremote_idnumber', '0', NULL),
(940, 2, [[timestamp]], 'auth_cas', 'field_lock_idnumber', 'unlocked', NULL),
(941, 2, [[timestamp]], 'auth_cas', 'field_map_institution', '', NULL),
(942, 2, [[timestamp]], 'auth_cas', 'field_updatelocal_institution', 'oncreate', NULL),
(943, 2, [[timestamp]], 'auth_cas', 'field_updateremote_institution', '0', NULL),
(944, 2, [[timestamp]], 'auth_cas', 'field_lock_institution', 'unlocked', NULL),
(945, 2, [[timestamp]], 'auth_cas', 'field_map_department', '', NULL),
(946, 2, [[timestamp]], 'auth_cas', 'field_updatelocal_department', 'oncreate', NULL),
(947, 2, [[timestamp]], 'auth_cas', 'field_updateremote_department', '0', NULL),
(948, 2, [[timestamp]], 'auth_cas', 'field_lock_department', 'unlocked', NULL),
(949, 2, [[timestamp]], 'auth_cas', 'field_map_phone1', '', NULL),
(950, 2, [[timestamp]], 'auth_cas', 'field_updatelocal_phone1', 'oncreate', NULL),
(951, 2, [[timestamp]], 'auth_cas', 'field_updateremote_phone1', '0', NULL),
(952, 2, [[timestamp]], 'auth_cas', 'field_lock_phone1', 'unlocked', NULL),
(953, 2, [[timestamp]], 'auth_cas', 'field_map_phone2', '', NULL),
(954, 2, [[timestamp]], 'auth_cas', 'field_updatelocal_phone2', 'oncreate', NULL),
(955, 2, [[timestamp]], 'auth_cas', 'field_updateremote_phone2', '0', NULL),
(956, 2, [[timestamp]], 'auth_cas', 'field_lock_phone2', 'unlocked', NULL),
(957, 2, [[timestamp]], 'auth_cas', 'field_map_address', '', NULL),
(958, 2, [[timestamp]], 'auth_cas', 'field_updatelocal_address', 'oncreate', NULL),
(959, 2, [[timestamp]], 'auth_cas', 'field_updateremote_address', '0', NULL),
(960, 2, [[timestamp]], 'auth_cas', 'field_lock_address', 'unlocked', NULL),
(961, 2, [[timestamp]], 'auth_cas', 'field_map_firstnamephonetic', '', NULL),
(962, 2, [[timestamp]], 'auth_cas', 'field_updatelocal_firstnamephonetic', 'oncreate', NULL),
(963, 2, [[timestamp]], 'auth_cas', 'field_updateremote_firstnamephonetic', '0', NULL),
(964, 2, [[timestamp]], 'auth_cas', 'field_lock_firstnamephonetic', 'unlocked', NULL),
(965, 2, [[timestamp]], 'auth_cas', 'field_map_lastnamephonetic', '', NULL),
(966, 2, [[timestamp]], 'auth_cas', 'field_updatelocal_lastnamephonetic', 'oncreate', NULL),
(967, 2, [[timestamp]], 'auth_cas', 'field_updateremote_lastnamephonetic', '0', NULL),
(968, 2, [[timestamp]], 'auth_cas', 'field_lock_lastnamephonetic', 'unlocked', NULL),
(969, 2, [[timestamp]], 'auth_cas', 'field_map_middlename', '', NULL),
(970, 2, [[timestamp]], 'auth_cas', 'field_updatelocal_middlename', 'oncreate', NULL),
(971, 2, [[timestamp]], 'auth_cas', 'field_updateremote_middlename', '0', NULL),
(972, 2, [[timestamp]], 'auth_cas', 'field_lock_middlename', 'unlocked', NULL),
(973, 2, [[timestamp]], 'auth_cas', 'field_map_alternatename', '', NULL),
(974, 2, [[timestamp]], 'auth_cas', 'field_updatelocal_alternatename', 'oncreate', NULL),
(975, 2, [[timestamp]], 'auth_cas', 'field_updateremote_alternatename', '0', NULL),
(976, 2, [[timestamp]], 'auth_cas', 'field_lock_alternatename', 'unlocked', NULL),
(977, 2, [[timestamp]], 'auth_email', 'recaptcha', '0', NULL),
(978, 2, [[timestamp]], 'auth_email', 'field_lock_firstname', 'unlocked', NULL),
(979, 2, [[timestamp]], 'auth_email', 'field_lock_lastname', 'unlocked', NULL),
(980, 2, [[timestamp]], 'auth_email', 'field_lock_email', 'unlocked', NULL),
(981, 2, [[timestamp]], 'auth_email', 'field_lock_city', 'unlocked', NULL),
(982, 2, [[timestamp]], 'auth_email', 'field_lock_country', 'unlocked', NULL),
(983, 2, [[timestamp]], 'auth_email', 'field_lock_lang', 'unlocked', NULL),
(984, 2, [[timestamp]], 'auth_email', 'field_lock_description', 'unlocked', NULL),
(985, 2, [[timestamp]], 'auth_email', 'field_lock_url', 'unlocked', NULL),
(986, 2, [[timestamp]], 'auth_email', 'field_lock_idnumber', 'unlocked', NULL),
(987, 2, [[timestamp]], 'auth_email', 'field_lock_institution', 'unlocked', NULL),
(988, 2, [[timestamp]], 'auth_email', 'field_lock_department', 'unlocked', NULL),
(989, 2, [[timestamp]], 'auth_email', 'field_lock_phone1', 'unlocked', NULL),
(990, 2, [[timestamp]], 'auth_email', 'field_lock_phone2', 'unlocked', NULL),
(991, 2, [[timestamp]], 'auth_email', 'field_lock_address', 'unlocked', NULL),
(992, 2, [[timestamp]], 'auth_email', 'field_lock_firstnamephonetic', 'unlocked', NULL),
(993, 2, [[timestamp]], 'auth_email', 'field_lock_lastnamephonetic', 'unlocked', NULL),
(994, 2, [[timestamp]], 'auth_email', 'field_lock_middlename', 'unlocked', NULL),
(995, 2, [[timestamp]], 'auth_email', 'field_lock_alternatename', 'unlocked', NULL),
(996, 2, [[timestamp]], 'auth_db', 'host', '127.0.0.1', NULL),
(997, 2, [[timestamp]], 'auth_db', 'type', 'mysqli', NULL),
(998, 2, [[timestamp]], 'auth_db', 'sybasequoting', '0', NULL),
(999, 2, [[timestamp]], 'auth_db', 'name', '', NULL),
(1000, 2, [[timestamp]], 'auth_db', 'user', '', NULL),
(1001, 2, [[timestamp]], 'auth_db', 'pass', '', NULL),
(1002, 2, [[timestamp]], 'auth_db', 'table', '', NULL),
(1003, 2, [[timestamp]], 'auth_db', 'fielduser', '', NULL),
(1004, 2, [[timestamp]], 'auth_db', 'fieldpass', '', NULL),
(1005, 2, [[timestamp]], 'auth_db', 'passtype', 'plaintext', NULL),
(1006, 2, [[timestamp]], 'auth_db', 'extencoding', 'utf-8', NULL),
(1007, 2, [[timestamp]], 'auth_db', 'setupsql', '', NULL),
(1008, 2, [[timestamp]], 'auth_db', 'debugauthdb', '0', NULL),
(1009, 2, [[timestamp]], 'auth_db', 'changepasswordurl', '', NULL),
(1010, 2, [[timestamp]], 'auth_db', 'removeuser', '0', NULL),
(1011, 2, [[timestamp]], 'auth_db', 'updateusers', '0', NULL),
(1012, 2, [[timestamp]], 'auth_db', 'field_map_firstname', '', NULL),
(1013, 2, [[timestamp]], 'auth_db', 'field_updatelocal_firstname', 'oncreate', NULL),
(1014, 2, [[timestamp]], 'auth_db', 'field_updateremote_firstname', '0', NULL),
(1015, 2, [[timestamp]], 'auth_db', 'field_lock_firstname', 'unlocked', NULL),
(1016, 2, [[timestamp]], 'auth_db', 'field_map_lastname', '', NULL),
(1017, 2, [[timestamp]], 'auth_db', 'field_updatelocal_lastname', 'oncreate', NULL),
(1018, 2, [[timestamp]], 'auth_db', 'field_updateremote_lastname', '0', NULL),
(1019, 2, [[timestamp]], 'auth_db', 'field_lock_lastname', 'unlocked', NULL),
(1020, 2, [[timestamp]], 'auth_db', 'field_map_email', '', NULL),
(1021, 2, [[timestamp]], 'auth_db', 'field_updatelocal_email', 'oncreate', NULL),
(1022, 2, [[timestamp]], 'auth_db', 'field_updateremote_email', '0', NULL),
(1023, 2, [[timestamp]], 'auth_db', 'field_lock_email', 'unlocked', NULL),
(1024, 2, [[timestamp]], 'auth_db', 'field_map_city', '', NULL),
(1025, 2, [[timestamp]], 'auth_db', 'field_updatelocal_city', 'oncreate', NULL),
(1026, 2, [[timestamp]], 'auth_db', 'field_updateremote_city', '0', NULL),
(1027, 2, [[timestamp]], 'auth_db', 'field_lock_city', 'unlocked', NULL),
(1028, 2, [[timestamp]], 'auth_db', 'field_map_country', '', NULL),
(1029, 2, [[timestamp]], 'auth_db', 'field_updatelocal_country', 'oncreate', NULL),
(1030, 2, [[timestamp]], 'auth_db', 'field_updateremote_country', '0', NULL),
(1031, 2, [[timestamp]], 'auth_db', 'field_lock_country', 'unlocked', NULL),
(1032, 2, [[timestamp]], 'auth_db', 'field_map_lang', '', NULL),
(1033, 2, [[timestamp]], 'auth_db', 'field_updatelocal_lang', 'oncreate', NULL),
(1034, 2, [[timestamp]], 'auth_db', 'field_updateremote_lang', '0', NULL),
(1035, 2, [[timestamp]], 'auth_db', 'field_lock_lang', 'unlocked', NULL),
(1036, 2, [[timestamp]], 'auth_db', 'field_map_description', '', NULL),
(1037, 2, [[timestamp]], 'auth_db', 'field_updatelocal_description', 'oncreate', NULL),
(1038, 2, [[timestamp]], 'auth_db', 'field_updateremote_description', '0', NULL),
(1039, 2, [[timestamp]], 'auth_db', 'field_lock_description', 'unlocked', NULL),
(1040, 2, [[timestamp]], 'auth_db', 'field_map_url', '', NULL),
(1041, 2, [[timestamp]], 'auth_db', 'field_updatelocal_url', 'oncreate', NULL),
(1042, 2, [[timestamp]], 'auth_db', 'field_updateremote_url', '0', NULL),
(1043, 2, [[timestamp]], 'auth_db', 'field_lock_url', 'unlocked', NULL),
(1044, 2, [[timestamp]], 'auth_db', 'field_map_idnumber', '', NULL),
(1045, 2, [[timestamp]], 'auth_db', 'field_updatelocal_idnumber', 'oncreate', NULL),
(1046, 2, [[timestamp]], 'auth_db', 'field_updateremote_idnumber', '0', NULL),
(1047, 2, [[timestamp]], 'auth_db', 'field_lock_idnumber', 'unlocked', NULL),
(1048, 2, [[timestamp]], 'auth_db', 'field_map_institution', '', NULL),
(1049, 2, [[timestamp]], 'auth_db', 'field_updatelocal_institution', 'oncreate', NULL),
(1050, 2, [[timestamp]], 'auth_db', 'field_updateremote_institution', '0', NULL),
(1051, 2, [[timestamp]], 'auth_db', 'field_lock_institution', 'unlocked', NULL),
(1052, 2, [[timestamp]], 'auth_db', 'field_map_department', '', NULL),
(1053, 2, [[timestamp]], 'auth_db', 'field_updatelocal_department', 'oncreate', NULL),
(1054, 2, [[timestamp]], 'auth_db', 'field_updateremote_department', '0', NULL),
(1055, 2, [[timestamp]], 'auth_db', 'field_lock_department', 'unlocked', NULL),
(1056, 2, [[timestamp]], 'auth_db', 'field_map_phone1', '', NULL),
(1057, 2, [[timestamp]], 'auth_db', 'field_updatelocal_phone1', 'oncreate', NULL),
(1058, 2, [[timestamp]], 'auth_db', 'field_updateremote_phone1', '0', NULL),
(1059, 2, [[timestamp]], 'auth_db', 'field_lock_phone1', 'unlocked', NULL),
(1060, 2, [[timestamp]], 'auth_db', 'field_map_phone2', '', NULL),
(1061, 2, [[timestamp]], 'auth_db', 'field_updatelocal_phone2', 'oncreate', NULL),
(1062, 2, [[timestamp]], 'auth_db', 'field_updateremote_phone2', '0', NULL),
(1063, 2, [[timestamp]], 'auth_db', 'field_lock_phone2', 'unlocked', NULL),
(1064, 2, [[timestamp]], 'auth_db', 'field_map_address', '', NULL),
(1065, 2, [[timestamp]], 'auth_db', 'field_updatelocal_address', 'oncreate', NULL),
(1066, 2, [[timestamp]], 'auth_db', 'field_updateremote_address', '0', NULL),
(1067, 2, [[timestamp]], 'auth_db', 'field_lock_address', 'unlocked', NULL),
(1068, 2, [[timestamp]], 'auth_db', 'field_map_firstnamephonetic', '', NULL),
(1069, 2, [[timestamp]], 'auth_db', 'field_updatelocal_firstnamephonetic', 'oncreate', NULL),
(1070, 2, [[timestamp]], 'auth_db', 'field_updateremote_firstnamephonetic', '0', NULL),
(1071, 2, [[timestamp]], 'auth_db', 'field_lock_firstnamephonetic', 'unlocked', NULL),
(1072, 2, [[timestamp]], 'auth_db', 'field_map_lastnamephonetic', '', NULL),
(1073, 2, [[timestamp]], 'auth_db', 'field_updatelocal_lastnamephonetic', 'oncreate', NULL),
(1074, 2, [[timestamp]], 'auth_db', 'field_updateremote_lastnamephonetic', '0', NULL),
(1075, 2, [[timestamp]], 'auth_db', 'field_lock_lastnamephonetic', 'unlocked', NULL),
(1076, 2, [[timestamp]], 'auth_db', 'field_map_middlename', '', NULL),
(1077, 2, [[timestamp]], 'auth_db', 'field_updatelocal_middlename', 'oncreate', NULL),
(1078, 2, [[timestamp]], 'auth_db', 'field_updateremote_middlename', '0', NULL),
(1079, 2, [[timestamp]], 'auth_db', 'field_lock_middlename', 'unlocked', NULL),
(1080, 2, [[timestamp]], 'auth_db', 'field_map_alternatename', '', NULL),
(1081, 2, [[timestamp]], 'auth_db', 'field_updatelocal_alternatename', 'oncreate', NULL),
(1082, 2, [[timestamp]], 'auth_db', 'field_updateremote_alternatename', '0', NULL),
(1083, 2, [[timestamp]], 'auth_db', 'field_lock_alternatename', 'unlocked', NULL),
(1084, 2, [[timestamp]], 'auth_ldap', 'host_url', '', NULL),
(1085, 2, [[timestamp]], 'auth_ldap', 'ldap_version', '3', NULL),
(1086, 2, [[timestamp]], 'auth_ldap', 'start_tls', '0', NULL),
(1087, 2, [[timestamp]], 'auth_ldap', 'ldapencoding', 'utf-8', NULL),
(1088, 2, [[timestamp]], 'auth_ldap', 'pagesize', '250', NULL),
(1089, 2, [[timestamp]], 'auth_ldap', 'preventpassindb', '0', NULL),
(1090, 2, [[timestamp]], 'auth_ldap', 'bind_dn', '', NULL),
(1091, 2, [[timestamp]], 'auth_ldap', 'bind_pw', '', NULL),
(1092, 2, [[timestamp]], 'auth_ldap', 'user_type', 'default', NULL),
(1093, 2, [[timestamp]], 'auth_ldap', 'contexts', '', NULL),
(1094, 2, [[timestamp]], 'auth_ldap', 'search_sub', '0', NULL),
(1095, 2, [[timestamp]], 'auth_ldap', 'opt_deref', '0', NULL),
(1096, 2, [[timestamp]], 'auth_ldap', 'user_attribute', '', NULL),
(1097, 2, [[timestamp]], 'auth_ldap', 'suspended_attribute', '', NULL),
(1098, 2, [[timestamp]], 'auth_ldap', 'memberattribute', '', NULL),
(1099, 2, [[timestamp]], 'auth_ldap', 'memberattribute_isdn', '', NULL),
(1100, 2, [[timestamp]], 'auth_ldap', 'objectclass', '', NULL),
(1101, 2, [[timestamp]], 'auth_ldap', 'forcechangepassword', '0', NULL),
(1102, 2, [[timestamp]], 'auth_ldap', 'stdchangepassword', '0', NULL),
(1103, 2, [[timestamp]], 'auth_ldap', 'passtype', 'plaintext', NULL),
(1104, 2, [[timestamp]], 'auth_ldap', 'changepasswordurl', '', NULL),
(1105, 2, [[timestamp]], 'auth_ldap', 'expiration', '0', NULL),
(1106, 2, [[timestamp]], 'auth_ldap', 'expiration_warning', '', NULL),
(1107, 2, [[timestamp]], 'auth_ldap', 'expireattr', '', NULL),
(1108, 2, [[timestamp]], 'auth_ldap', 'gracelogins', '0', NULL),
(1109, 2, [[timestamp]], 'auth_ldap', 'graceattr', '', NULL),
(1110, 2, [[timestamp]], 'auth_ldap', 'auth_user_create', '0', NULL),
(1111, 2, [[timestamp]], 'auth_ldap', 'create_context', '', NULL),
(1112, 2, [[timestamp]], 'auth_ldap', 'managercontext', '', NULL),
(1113, 2, [[timestamp]], 'auth_ldap', 'coursecreatorcontext', '', NULL),
(1114, 2, [[timestamp]], 'auth_ldap', 'removeuser', '0', NULL),
(1115, 2, [[timestamp]], 'auth_ldap', 'sync_suspended', '0', NULL),
(1116, 2, [[timestamp]], 'auth_ldap', 'ntlmsso_enabled', '0', NULL),
(1117, 2, [[timestamp]], 'auth_ldap', 'ntlmsso_subnet', '', NULL),
(1118, 2, [[timestamp]], 'auth_ldap', 'ntlmsso_ie_fastpath', '0', NULL),
(1119, 2, [[timestamp]], 'auth_ldap', 'ntlmsso_type', 'ntlm', NULL),
(1120, 2, [[timestamp]], 'auth_ldap', 'ntlmsso_remoteuserformat', '', NULL),
(1121, 2, [[timestamp]], 'auth_ldap', 'field_map_firstname', '', NULL),
(1122, 2, [[timestamp]], 'auth_ldap', 'field_updatelocal_firstname', 'oncreate', NULL),
(1123, 2, [[timestamp]], 'auth_ldap', 'field_updateremote_firstname', '0', NULL),
(1124, 2, [[timestamp]], 'auth_ldap', 'field_lock_firstname', 'unlocked', NULL),
(1125, 2, [[timestamp]], 'auth_ldap', 'field_map_lastname', '', NULL),
(1126, 2, [[timestamp]], 'auth_ldap', 'field_updatelocal_lastname', 'oncreate', NULL),
(1127, 2, [[timestamp]], 'auth_ldap', 'field_updateremote_lastname', '0', NULL),
(1128, 2, [[timestamp]], 'auth_ldap', 'field_lock_lastname', 'unlocked', NULL),
(1129, 2, [[timestamp]], 'auth_ldap', 'field_map_email', '', NULL),
(1130, 2, [[timestamp]], 'auth_ldap', 'field_updatelocal_email', 'oncreate', NULL),
(1131, 2, [[timestamp]], 'auth_ldap', 'field_updateremote_email', '0', NULL),
(1132, 2, [[timestamp]], 'auth_ldap', 'field_lock_email', 'unlocked', NULL),
(1133, 2, [[timestamp]], 'auth_ldap', 'field_map_city', '', NULL),
(1134, 2, [[timestamp]], 'auth_ldap', 'field_updatelocal_city', 'oncreate', NULL),
(1135, 2, [[timestamp]], 'auth_ldap', 'field_updateremote_city', '0', NULL),
(1136, 2, [[timestamp]], 'auth_ldap', 'field_lock_city', 'unlocked', NULL),
(1137, 2, [[timestamp]], 'auth_ldap', 'field_map_country', '', NULL),
(1138, 2, [[timestamp]], 'auth_ldap', 'field_updatelocal_country', 'oncreate', NULL),
(1139, 2, [[timestamp]], 'auth_ldap', 'field_updateremote_country', '0', NULL),
(1140, 2, [[timestamp]], 'auth_ldap', 'field_lock_country', 'unlocked', NULL),
(1141, 2, [[timestamp]], 'auth_ldap', 'field_map_lang', '', NULL),
(1142, 2, [[timestamp]], 'auth_ldap', 'field_updatelocal_lang', 'oncreate', NULL),
(1143, 2, [[timestamp]], 'auth_ldap', 'field_updateremote_lang', '0', NULL),
(1144, 2, [[timestamp]], 'auth_ldap', 'field_lock_lang', 'unlocked', NULL),
(1145, 2, [[timestamp]], 'auth_ldap', 'field_map_description', '', NULL),
(1146, 2, [[timestamp]], 'auth_ldap', 'field_updatelocal_description', 'oncreate', NULL),
(1147, 2, [[timestamp]], 'auth_ldap', 'field_updateremote_description', '0', NULL),
(1148, 2, [[timestamp]], 'auth_ldap', 'field_lock_description', 'unlocked', NULL),
(1149, 2, [[timestamp]], 'auth_ldap', 'field_map_url', '', NULL),
(1150, 2, [[timestamp]], 'auth_ldap', 'field_updatelocal_url', 'oncreate', NULL),
(1151, 2, [[timestamp]], 'auth_ldap', 'field_updateremote_url', '0', NULL),
(1152, 2, [[timestamp]], 'auth_ldap', 'field_lock_url', 'unlocked', NULL),
(1153, 2, [[timestamp]], 'auth_ldap', 'field_map_idnumber', '', NULL),
(1154, 2, [[timestamp]], 'auth_ldap', 'field_updatelocal_idnumber', 'oncreate', NULL),
(1155, 2, [[timestamp]], 'auth_ldap', 'field_updateremote_idnumber', '0', NULL),
(1156, 2, [[timestamp]], 'auth_ldap', 'field_lock_idnumber', 'unlocked', NULL),
(1157, 2, [[timestamp]], 'auth_ldap', 'field_map_institution', '', NULL),
(1158, 2, [[timestamp]], 'auth_ldap', 'field_updatelocal_institution', 'oncreate', NULL),
(1159, 2, [[timestamp]], 'auth_ldap', 'field_updateremote_institution', '0', NULL),
(1160, 2, [[timestamp]], 'auth_ldap', 'field_lock_institution', 'unlocked', NULL),
(1161, 2, [[timestamp]], 'auth_ldap', 'field_map_department', '', NULL),
(1162, 2, [[timestamp]], 'auth_ldap', 'field_updatelocal_department', 'oncreate', NULL),
(1163, 2, [[timestamp]], 'auth_ldap', 'field_updateremote_department', '0', NULL),
(1164, 2, [[timestamp]], 'auth_ldap', 'field_lock_department', 'unlocked', NULL),
(1165, 2, [[timestamp]], 'auth_ldap', 'field_map_phone1', '', NULL),
(1166, 2, [[timestamp]], 'auth_ldap', 'field_updatelocal_phone1', 'oncreate', NULL),
(1167, 2, [[timestamp]], 'auth_ldap', 'field_updateremote_phone1', '0', NULL),
(1168, 2, [[timestamp]], 'auth_ldap', 'field_lock_phone1', 'unlocked', NULL),
(1169, 2, [[timestamp]], 'auth_ldap', 'field_map_phone2', '', NULL),
(1170, 2, [[timestamp]], 'auth_ldap', 'field_updatelocal_phone2', 'oncreate', NULL),
(1171, 2, [[timestamp]], 'auth_ldap', 'field_updateremote_phone2', '0', NULL),
(1172, 2, [[timestamp]], 'auth_ldap', 'field_lock_phone2', 'unlocked', NULL),
(1173, 2, [[timestamp]], 'auth_ldap', 'field_map_address', '', NULL),
(1174, 2, [[timestamp]], 'auth_ldap', 'field_updatelocal_address', 'oncreate', NULL),
(1175, 2, [[timestamp]], 'auth_ldap', 'field_updateremote_address', '0', NULL),
(1176, 2, [[timestamp]], 'auth_ldap', 'field_lock_address', 'unlocked', NULL),
(1177, 2, [[timestamp]], 'auth_ldap', 'field_map_firstnamephonetic', '', NULL),
(1178, 2, [[timestamp]], 'auth_ldap', 'field_updatelocal_firstnamephonetic', 'oncreate', NULL),
(1179, 2, [[timestamp]], 'auth_ldap', 'field_updateremote_firstnamephonetic', '0', NULL),
(1180, 2, [[timestamp]], 'auth_ldap', 'field_lock_firstnamephonetic', 'unlocked', NULL),
(1181, 2, [[timestamp]], 'auth_ldap', 'field_map_lastnamephonetic', '', NULL),
(1182, 2, [[timestamp]], 'auth_ldap', 'field_updatelocal_lastnamephonetic', 'oncreate', NULL),
(1183, 2, [[timestamp]], 'auth_ldap', 'field_updateremote_lastnamephonetic', '0', NULL),
(1184, 2, [[timestamp]], 'auth_ldap', 'field_lock_lastnamephonetic', 'unlocked', NULL),
(1185, 2, [[timestamp]], 'auth_ldap', 'field_map_middlename', '', NULL),
(1186, 2, [[timestamp]], 'auth_ldap', 'field_updatelocal_middlename', 'oncreate', NULL),
(1187, 2, [[timestamp]], 'auth_ldap', 'field_updateremote_middlename', '0', NULL),
(1188, 2, [[timestamp]], 'auth_ldap', 'field_lock_middlename', 'unlocked', NULL),
(1189, 2, [[timestamp]], 'auth_ldap', 'field_map_alternatename', '', NULL),
(1190, 2, [[timestamp]], 'auth_ldap', 'field_updatelocal_alternatename', 'oncreate', NULL),
(1191, 2, [[timestamp]], 'auth_ldap', 'field_updateremote_alternatename', '0', NULL),
(1192, 2, [[timestamp]], 'auth_ldap', 'field_lock_alternatename', 'unlocked', NULL),
(1193, 2, [[timestamp]], 'auth_manual', 'expiration', '0', NULL),
(1194, 2, [[timestamp]], 'auth_manual', 'expirationtime', '30', NULL),
(1195, 2, [[timestamp]], 'auth_manual', 'expiration_warning', '0', NULL),
(1196, 2, [[timestamp]], 'auth_manual', 'field_lock_firstname', 'unlocked', NULL),
(1197, 2, [[timestamp]], 'auth_manual', 'field_lock_lastname', 'unlocked', NULL),
(1198, 2, [[timestamp]], 'auth_manual', 'field_lock_email', 'unlocked', NULL),
(1199, 2, [[timestamp]], 'auth_manual', 'field_lock_city', 'unlocked', NULL),
(1200, 2, [[timestamp]], 'auth_manual', 'field_lock_country', 'unlocked', NULL),
(1201, 2, [[timestamp]], 'auth_manual', 'field_lock_lang', 'unlocked', NULL),
(1202, 2, [[timestamp]], 'auth_manual', 'field_lock_description', 'unlocked', NULL),
(1203, 2, [[timestamp]], 'auth_manual', 'field_lock_url', 'unlocked', NULL),
(1204, 2, [[timestamp]], 'auth_manual', 'field_lock_idnumber', 'unlocked', NULL),
(1205, 2, [[timestamp]], 'auth_manual', 'field_lock_institution', 'unlocked', NULL),
(1206, 2, [[timestamp]], 'auth_manual', 'field_lock_department', 'unlocked', NULL),
(1207, 2, [[timestamp]], 'auth_manual', 'field_lock_phone1', 'unlocked', NULL),
(1208, 2, [[timestamp]], 'auth_manual', 'field_lock_phone2', 'unlocked', NULL),
(1209, 2, [[timestamp]], 'auth_manual', 'field_lock_address', 'unlocked', NULL),
(1210, 2, [[timestamp]], 'auth_manual', 'field_lock_firstnamephonetic', 'unlocked', NULL),
(1211, 2, [[timestamp]], 'auth_manual', 'field_lock_lastnamephonetic', 'unlocked', NULL),
(1212, 2, [[timestamp]], 'auth_manual', 'field_lock_middlename', 'unlocked', NULL),
(1213, 2, [[timestamp]], 'auth_manual', 'field_lock_alternatename', 'unlocked', NULL),
(1214, 2, [[timestamp]], 'auth_mnet', 'rpc_negotiation_timeout', '30', NULL),
(1215, 2, [[timestamp]], 'auth_none', 'field_lock_firstname', 'unlocked', NULL),
(1216, 2, [[timestamp]], 'auth_none', 'field_lock_lastname', 'unlocked', NULL),
(1217, 2, [[timestamp]], 'auth_none', 'field_lock_email', 'unlocked', NULL),
(1218, 2, [[timestamp]], 'auth_none', 'field_lock_city', 'unlocked', NULL),
(1219, 2, [[timestamp]], 'auth_none', 'field_lock_country', 'unlocked', NULL),
(1220, 2, [[timestamp]], 'auth_none', 'field_lock_lang', 'unlocked', NULL),
(1221, 2, [[timestamp]], 'auth_none', 'field_lock_description', 'unlocked', NULL),
(1222, 2, [[timestamp]], 'auth_none', 'field_lock_url', 'unlocked', NULL),
(1223, 2, [[timestamp]], 'auth_none', 'field_lock_idnumber', 'unlocked', NULL),
(1224, 2, [[timestamp]], 'auth_none', 'field_lock_institution', 'unlocked', NULL),
(1225, 2, [[timestamp]], 'auth_none', 'field_lock_department', 'unlocked', NULL),
(1226, 2, [[timestamp]], 'auth_none', 'field_lock_phone1', 'unlocked', NULL),
(1227, 2, [[timestamp]], 'auth_none', 'field_lock_phone2', 'unlocked', NULL),
(1228, 2, [[timestamp]], 'auth_none', 'field_lock_address', 'unlocked', NULL),
(1229, 2, [[timestamp]], 'auth_none', 'field_lock_firstnamephonetic', 'unlocked', NULL),
(1230, 2, [[timestamp]], 'auth_none', 'field_lock_lastnamephonetic', 'unlocked', NULL),
(1231, 2, [[timestamp]], 'auth_none', 'field_lock_middlename', 'unlocked', NULL),
(1232, 2, [[timestamp]], 'auth_none', 'field_lock_alternatename', 'unlocked', NULL),
(1233, 2, [[timestamp]], 'auth_oauth2', 'field_lock_firstname', 'unlocked', NULL),
(1234, 2, [[timestamp]], 'auth_oauth2', 'field_lock_lastname', 'unlocked', NULL),
(1235, 2, [[timestamp]], 'auth_oauth2', 'field_lock_email', 'unlocked', NULL),
(1236, 2, [[timestamp]], 'auth_oauth2', 'field_lock_city', 'unlocked', NULL),
(1237, 2, [[timestamp]], 'auth_oauth2', 'field_lock_country', 'unlocked', NULL),
(1238, 2, [[timestamp]], 'auth_oauth2', 'field_lock_lang', 'unlocked', NULL),
(1239, 2, [[timestamp]], 'auth_oauth2', 'field_lock_description', 'unlocked', NULL),
(1240, 2, [[timestamp]], 'auth_oauth2', 'field_lock_url', 'unlocked', NULL),
(1241, 2, [[timestamp]], 'auth_oauth2', 'field_lock_idnumber', 'unlocked', NULL),
(1242, 2, [[timestamp]], 'auth_oauth2', 'field_lock_institution', 'unlocked', NULL),
(1243, 2, [[timestamp]], 'auth_oauth2', 'field_lock_department', 'unlocked', NULL),
(1244, 2, [[timestamp]], 'auth_oauth2', 'field_lock_phone1', 'unlocked', NULL),
(1245, 2, [[timestamp]], 'auth_oauth2', 'field_lock_phone2', 'unlocked', NULL),
(1246, 2, [[timestamp]], 'auth_oauth2', 'field_lock_address', 'unlocked', NULL),
(1247, 2, [[timestamp]], 'auth_oauth2', 'field_lock_firstnamephonetic', 'unlocked', NULL),
(1248, 2, [[timestamp]], 'auth_oauth2', 'field_lock_lastnamephonetic', 'unlocked', NULL),
(1249, 2, [[timestamp]], 'auth_oauth2', 'field_lock_middlename', 'unlocked', NULL),
(1250, 2, [[timestamp]], 'auth_oauth2', 'field_lock_alternatename', 'unlocked', NULL),
(1251, 2, [[timestamp]], 'auth_shibboleth', 'user_attribute', '', NULL),
(1252, 2, [[timestamp]], 'auth_shibboleth', 'convert_data', '', NULL),
(1253, 2, [[timestamp]], 'auth_shibboleth', 'alt_login', 'off', NULL),
(1254, 2, [[timestamp]], 'auth_shibboleth', 'organization_selection', 'urn:mace:organization1:providerID, Example Organization 1\n        https://another.idp-id.com/shibboleth, Other Example Organization, /Shibboleth.sso/DS/SWITCHaai\n        urn:mace:organization2:providerID, Example Organization 2, /Shibboleth.sso/WAYF/SWITCHaai', NULL),
(1255, 2, [[timestamp]], 'auth_shibboleth', 'logout_handler', '', NULL),
(1256, 2, [[timestamp]], 'auth_shibboleth', 'logout_return_url', '', NULL),
(1257, 2, [[timestamp]], 'auth_shibboleth', 'login_name', 'Shibboleth Login', NULL),
(1258, 2, [[timestamp]], 'auth_shibboleth', 'auth_instructions', 'Use the <a href="[[softurl]]/auth/shibboleth/index.php">Shibboleth login</a> to get access via Shibboleth, if your institution supports it.<br />Otherwise, use the normal login form shown here.', NULL),
(1259, 2, [[timestamp]], 'auth_shibboleth', 'changepasswordurl', '', NULL),
(1260, 2, [[timestamp]], 'auth_shibboleth', 'field_map_firstname', '', NULL),
(1261, 2, [[timestamp]], 'auth_shibboleth', 'field_updatelocal_firstname', 'oncreate', NULL),
(1262, 2, [[timestamp]], 'auth_shibboleth', 'field_lock_firstname', 'unlocked', NULL),
(1263, 2, [[timestamp]], 'auth_shibboleth', 'field_map_lastname', '', NULL),
(1264, 2, [[timestamp]], 'auth_shibboleth', 'field_updatelocal_lastname', 'oncreate', NULL),
(1265, 2, [[timestamp]], 'auth_shibboleth', 'field_lock_lastname', 'unlocked', NULL),
(1266, 2, [[timestamp]], 'auth_shibboleth', 'field_map_email', '', NULL),
(1267, 2, [[timestamp]], 'auth_shibboleth', 'field_updatelocal_email', 'oncreate', NULL),
(1268, 2, [[timestamp]], 'auth_shibboleth', 'field_lock_email', 'unlocked', NULL),
(1269, 2, [[timestamp]], 'auth_shibboleth', 'field_map_city', '', NULL),
(1270, 2, [[timestamp]], 'auth_shibboleth', 'field_updatelocal_city', 'oncreate', NULL),
(1271, 2, [[timestamp]], 'auth_shibboleth', 'field_lock_city', 'unlocked', NULL),
(1272, 2, [[timestamp]], 'auth_shibboleth', 'field_map_country', '', NULL),
(1273, 2, [[timestamp]], 'auth_shibboleth', 'field_updatelocal_country', 'oncreate', NULL),
(1274, 2, [[timestamp]], 'auth_shibboleth', 'field_lock_country', 'unlocked', NULL),
(1275, 2, [[timestamp]], 'auth_shibboleth', 'field_map_lang', '', NULL),
(1276, 2, [[timestamp]], 'auth_shibboleth', 'field_updatelocal_lang', 'oncreate', NULL),
(1277, 2, [[timestamp]], 'auth_shibboleth', 'field_lock_lang', 'unlocked', NULL),
(1278, 2, [[timestamp]], 'auth_shibboleth', 'field_map_description', '', NULL),
(1279, 2, [[timestamp]], 'auth_shibboleth', 'field_updatelocal_description', 'oncreate', NULL),
(1280, 2, [[timestamp]], 'auth_shibboleth', 'field_lock_description', 'unlocked', NULL),
(1281, 2, [[timestamp]], 'auth_shibboleth', 'field_map_url', '', NULL),
(1282, 2, [[timestamp]], 'auth_shibboleth', 'field_updatelocal_url', 'oncreate', NULL),
(1283, 2, [[timestamp]], 'auth_shibboleth', 'field_lock_url', 'unlocked', NULL),
(1284, 2, [[timestamp]], 'auth_shibboleth', 'field_map_idnumber', '', NULL),
(1285, 2, [[timestamp]], 'auth_shibboleth', 'field_updatelocal_idnumber', 'oncreate', NULL),
(1286, 2, [[timestamp]], 'auth_shibboleth', 'field_lock_idnumber', 'unlocked', NULL),
(1287, 2, [[timestamp]], 'auth_shibboleth', 'field_map_institution', '', NULL),
(1288, 2, [[timestamp]], 'auth_shibboleth', 'field_updatelocal_institution', 'oncreate', NULL),
(1289, 2, [[timestamp]], 'auth_shibboleth', 'field_lock_institution', 'unlocked', NULL),
(1290, 2, [[timestamp]], 'auth_shibboleth', 'field_map_department', '', NULL),
(1291, 2, [[timestamp]], 'auth_shibboleth', 'field_updatelocal_department', 'oncreate', NULL),
(1292, 2, [[timestamp]], 'auth_shibboleth', 'field_lock_department', 'unlocked', NULL),
(1293, 2, [[timestamp]], 'auth_shibboleth', 'field_map_phone1', '', NULL),
(1294, 2, [[timestamp]], 'auth_shibboleth', 'field_updatelocal_phone1', 'oncreate', NULL),
(1295, 2, [[timestamp]], 'auth_shibboleth', 'field_lock_phone1', 'unlocked', NULL),
(1296, 2, [[timestamp]], 'auth_shibboleth', 'field_map_phone2', '', NULL),
(1297, 2, [[timestamp]], 'auth_shibboleth', 'field_updatelocal_phone2', 'oncreate', NULL),
(1298, 2, [[timestamp]], 'auth_shibboleth', 'field_lock_phone2', 'unlocked', NULL),
(1299, 2, [[timestamp]], 'auth_shibboleth', 'field_map_address', '', NULL),
(1300, 2, [[timestamp]], 'auth_shibboleth', 'field_updatelocal_address', 'oncreate', NULL),
(1301, 2, [[timestamp]], 'auth_shibboleth', 'field_lock_address', 'unlocked', NULL),
(1302, 2, [[timestamp]], 'auth_shibboleth', 'field_map_firstnamephonetic', '', NULL),
(1303, 2, [[timestamp]], 'auth_shibboleth', 'field_updatelocal_firstnamephonetic', 'oncreate', NULL),
(1304, 2, [[timestamp]], 'auth_shibboleth', 'field_lock_firstnamephonetic', 'unlocked', NULL),
(1305, 2, [[timestamp]], 'auth_shibboleth', 'field_map_lastnamephonetic', '', NULL),
(1306, 2, [[timestamp]], 'auth_shibboleth', 'field_updatelocal_lastnamephonetic', 'oncreate', NULL),
(1307, 2, [[timestamp]], 'auth_shibboleth', 'field_lock_lastnamephonetic', 'unlocked', NULL),
(1308, 2, [[timestamp]], 'auth_shibboleth', 'field_map_middlename', '', NULL),
(1309, 2, [[timestamp]], 'auth_shibboleth', 'field_updatelocal_middlename', 'oncreate', NULL),
(1310, 2, [[timestamp]], 'auth_shibboleth', 'field_lock_middlename', 'unlocked', NULL),
(1311, 2, [[timestamp]], 'auth_shibboleth', 'field_map_alternatename', '', NULL),
(1312, 2, [[timestamp]], 'auth_shibboleth', 'field_updatelocal_alternatename', 'oncreate', NULL),
(1313, 2, [[timestamp]], 'auth_shibboleth', 'field_lock_alternatename', 'unlocked', NULL),
(1314, 2, [[timestamp]], 'block_activity_results', 'config_showbest', '3', NULL),
(1315, 2, [[timestamp]], 'block_activity_results', 'config_showbest_locked', '', NULL),
(1316, 2, [[timestamp]], 'block_activity_results', 'config_showworst', '0', NULL),
(1317, 2, [[timestamp]], 'block_activity_results', 'config_showworst_locked', '', NULL),
(1318, 2, [[timestamp]], 'block_activity_results', 'config_usegroups', '0', NULL),
(1319, 2, [[timestamp]], 'block_activity_results', 'config_usegroups_locked', '', NULL),
(1320, 2, [[timestamp]], 'block_activity_results', 'config_nameformat', '1', NULL),
(1321, 2, [[timestamp]], 'block_activity_results', 'config_nameformat_locked', '', NULL),
(1322, 2, [[timestamp]], 'block_activity_results', 'config_gradeformat', '1', NULL),
(1323, 2, [[timestamp]], 'block_activity_results', 'config_gradeformat_locked', '', NULL),
(1324, 2, [[timestamp]], 'block_activity_results', 'config_decimalpoints', '2', NULL),
(1325, 2, [[timestamp]], 'block_activity_results', 'config_decimalpoints_locked', '', NULL),
(1326, 2, [[timestamp]], 'block_myoverview', 'defaulttab', 'timeline', NULL),
(1327, 2, [[timestamp]], NULL, 'block_course_list_adminview', 'all', NULL),
(1328, 2, [[timestamp]], NULL, 'block_course_list_hideallcourseslink', '0', NULL),
(1329, 2, [[timestamp]], NULL, 'block_html_allowcssclasses', '0', NULL),
(1330, 2, [[timestamp]], NULL, 'block_online_users_timetosee', '5', NULL),
(1331, 2, [[timestamp]], NULL, 'block_rss_client_num_entries', '5', NULL),
(1332, 2, [[timestamp]], NULL, 'block_rss_client_timeout', '30', NULL),
(1333, 2, [[timestamp]], 'block_section_links', 'numsections1', '22', NULL),
(1334, 2, [[timestamp]], 'block_section_links', 'incby1', '2', NULL),
(1335, 2, [[timestamp]], 'block_section_links', 'numsections2', '40', NULL),
(1336, 2, [[timestamp]], 'block_section_links', 'incby2', '5', NULL),
(1337, 2, [[timestamp]], 'block_tag_youtube', 'apikey', '', NULL),
(1338, 2, [[timestamp]], 'format_singleactivity', 'activitytype', 'forum', NULL),
(1339, 2, [[timestamp]], 'fileconverter_googledrive', 'issuerid', '', NULL),
(1340, 2, [[timestamp]], NULL, 'pathtounoconv', '/usr/bin/unoconv', NULL),
(1341, 2, [[timestamp]], 'enrol_cohort', 'roleid', '5', NULL),
(1342, 2, [[timestamp]], 'enrol_cohort', 'unenrolaction', '0', NULL),
(1343, 2, [[timestamp]], 'enrol_meta', 'nosyncroleids', '', NULL),
(1344, 2, [[timestamp]], 'enrol_meta', 'syncall', '1', NULL),
(1345, 2, [[timestamp]], 'enrol_meta', 'unenrolaction', '3', NULL),
(1346, 2, [[timestamp]], 'enrol_meta', 'coursesort', 'sortorder', NULL),
(1347, 2, [[timestamp]], 'enrol_database', 'dbtype', '', NULL),
(1348, 2, [[timestamp]], 'enrol_database', 'dbhost', 'localhost', NULL),
(1349, 2, [[timestamp]], 'enrol_database', 'dbuser', '', NULL),
(1350, 2, [[timestamp]], 'enrol_database', 'dbpass', '', NULL),
(1351, 2, [[timestamp]], 'enrol_database', 'dbname', '', NULL),
(1352, 2, [[timestamp]], 'enrol_database', 'dbencoding', 'utf-8', NULL),
(1353, 2, [[timestamp]], 'enrol_database', 'dbsetupsql', '', NULL),
(1354, 2, [[timestamp]], 'enrol_database', 'dbsybasequoting', '0', NULL),
(1355, 2, [[timestamp]], 'enrol_database', 'debugdb', '0', NULL),
(1356, 2, [[timestamp]], 'enrol_database', 'localcoursefield', 'idnumber', NULL),
(1357, 2, [[timestamp]], 'enrol_database', 'localuserfield', 'idnumber', NULL),
(1358, 2, [[timestamp]], 'enrol_database', 'localrolefield', 'shortname', NULL),
(1359, 2, [[timestamp]], 'enrol_database', 'localcategoryfield', 'id', NULL),
(1360, 2, [[timestamp]], 'enrol_database', 'remoteenroltable', '', NULL),
(1361, 2, [[timestamp]], 'enrol_database', 'remotecoursefield', '', NULL),
(1362, 2, [[timestamp]], 'enrol_database', 'remoteuserfield', '', NULL),
(1363, 2, [[timestamp]], 'enrol_database', 'remoterolefield', '', NULL),
(1364, 2, [[timestamp]], 'enrol_database', 'remoteotheruserfield', '', NULL),
(1365, 2, [[timestamp]], 'enrol_database', 'defaultrole', '5', NULL),
(1366, 2, [[timestamp]], 'enrol_database', 'ignorehiddencourses', '0', NULL),
(1367, 2, [[timestamp]], 'enrol_database', 'unenrolaction', '0', NULL),
(1368, 2, [[timestamp]], 'enrol_database', 'newcoursetable', '', NULL),
(1369, 2, [[timestamp]], 'enrol_database', 'newcoursefullname', 'fullname', NULL),
(1370, 2, [[timestamp]], 'enrol_database', 'newcourseshortname', 'shortname', NULL),
(1371, 2, [[timestamp]], 'enrol_database', 'newcourseidnumber', 'idnumber', NULL),
(1372, 2, [[timestamp]], 'enrol_database', 'newcoursecategory', '', NULL),
(1373, 2, [[timestamp]], 'enrol_database', 'defaultcategory', '1', NULL),
(1374, 2, [[timestamp]], 'enrol_database', 'templatecourse', '', NULL),
(1375, 2, [[timestamp]], 'enrol_flatfile', 'location', '', NULL),
(1376, 2, [[timestamp]], 'enrol_flatfile', 'encoding', 'UTF-8', NULL),
(1377, 2, [[timestamp]], 'enrol_flatfile', 'mailstudents', '0', NULL),
(1378, 2, [[timestamp]], 'enrol_flatfile', 'mailteachers', '0', NULL),
(1379, 2, [[timestamp]], 'enrol_flatfile', 'mailadmins', '0', NULL),
(1380, 2, [[timestamp]], 'enrol_flatfile', 'unenrolaction', '3', NULL),
(1381, 2, [[timestamp]], 'enrol_flatfile', 'expiredaction', '3', NULL),
(1382, 2, [[timestamp]], 'enrol_guest', 'requirepassword', '0', NULL),
(1383, 2, [[timestamp]], 'enrol_guest', 'usepasswordpolicy', '0', NULL),
(1384, 2, [[timestamp]], 'enrol_guest', 'showhint', '0', NULL),
(1385, 2, [[timestamp]], 'enrol_guest', 'defaultenrol', '1', NULL),
(1386, 2, [[timestamp]], 'enrol_guest', 'status', '1', NULL),
(1387, 2, [[timestamp]], 'enrol_guest', 'status_adv', '', NULL),
(1388, 2, [[timestamp]], 'enrol_imsenterprise', 'imsfilelocation', '', NULL),
(1389, 2, [[timestamp]], 'enrol_imsenterprise', 'logtolocation', '', NULL),
(1390, 2, [[timestamp]], 'enrol_imsenterprise', 'mailadmins', '0', NULL),
(1391, 2, [[timestamp]], 'enrol_imsenterprise', 'createnewusers', '0', NULL),
(1392, 2, [[timestamp]], 'enrol_imsenterprise', 'imsupdateusers', '0', NULL),
(1393, 2, [[timestamp]], 'enrol_imsenterprise', 'imsdeleteusers', '0', NULL),
(1394, 2, [[timestamp]], 'enrol_imsenterprise', 'fixcaseusernames', '0', NULL),
(1395, 2, [[timestamp]], 'enrol_imsenterprise', 'fixcasepersonalnames', '0', NULL),
(1396, 2, [[timestamp]], 'enrol_imsenterprise', 'imssourcedidfallback', '0', NULL),
(1397, 2, [[timestamp]], 'enrol_imsenterprise', 'imsrolemap01', '5', NULL),
(1398, 2, [[timestamp]], 'enrol_imsenterprise', 'imsrolemap02', '3', NULL),
(1399, 2, [[timestamp]], 'enrol_imsenterprise', 'imsrolemap03', '3', NULL),
(1400, 2, [[timestamp]], 'enrol_imsenterprise', 'imsrolemap04', '5', NULL),
(1401, 2, [[timestamp]], 'enrol_imsenterprise', 'imsrolemap05', '0', NULL),
(1402, 2, [[timestamp]], 'enrol_imsenterprise', 'imsrolemap06', '4', NULL),
(1403, 2, [[timestamp]], 'enrol_imsenterprise', 'imsrolemap07', '0', NULL),
(1404, 2, [[timestamp]], 'enrol_imsenterprise', 'imsrolemap08', '4', NULL),
(1405, 2, [[timestamp]], 'enrol_imsenterprise', 'truncatecoursecodes', '0', NULL),
(1406, 2, [[timestamp]], 'enrol_imsenterprise', 'createnewcourses', '0', NULL),
(1407, 2, [[timestamp]], 'enrol_imsenterprise', 'updatecourses', '0', NULL),
(1408, 2, [[timestamp]], 'enrol_imsenterprise', 'createnewcategories', '0', NULL),
(1409, 2, [[timestamp]], 'enrol_imsenterprise', 'nestedcategories', '0', NULL),
(1410, 2, [[timestamp]], 'enrol_imsenterprise', 'categoryidnumber', '0', NULL),
(1411, 2, [[timestamp]], 'enrol_imsenterprise', 'categoryseparator', '', NULL),
(1412, 2, [[timestamp]], 'enrol_imsenterprise', 'imsunenrol', '0', NULL),
(1413, 2, [[timestamp]], 'enrol_imsenterprise', 'imscoursemapshortname', 'coursecode', NULL),
(1414, 2, [[timestamp]], 'enrol_imsenterprise', 'imscoursemapfullname', 'short', NULL),
(1415, 2, [[timestamp]], 'enrol_imsenterprise', 'imscoursemapsummary', 'ignore', NULL),
(1416, 2, [[timestamp]], 'enrol_imsenterprise', 'imsrestricttarget', '', NULL),
(1417, 2, [[timestamp]], 'enrol_imsenterprise', 'imscapitafix', '0', NULL),
(1418, 2, [[timestamp]], 'enrol_ldap', 'host_url', '', NULL),
(1419, 2, [[timestamp]], 'enrol_ldap', 'start_tls', '0', NULL),
(1420, 2, [[timestamp]], 'enrol_ldap', 'ldap_version', '3', NULL),
(1421, 2, [[timestamp]], 'enrol_ldap', 'ldapencoding', 'utf-8', NULL),
(1422, 2, [[timestamp]], 'enrol_ldap', 'pagesize', '250', NULL),
(1423, 2, [[timestamp]], 'enrol_ldap', 'bind_dn', '', NULL),
(1424, 2, [[timestamp]], 'enrol_ldap', 'bind_pw', '', NULL),
(1425, 2, [[timestamp]], 'enrol_ldap', 'course_search_sub', '0', NULL),
(1426, 2, [[timestamp]], 'enrol_ldap', 'memberattribute_isdn', '0', NULL),
(1427, 2, [[timestamp]], 'enrol_ldap', 'user_contexts', '', NULL),
(1428, 2, [[timestamp]], 'enrol_ldap', 'user_search_sub', '0', NULL),
(1429, 2, [[timestamp]], 'enrol_ldap', 'user_type', 'default', NULL),
(1430, 2, [[timestamp]], 'enrol_ldap', 'opt_deref', '0', NULL),
(1431, 2, [[timestamp]], 'enrol_ldap', 'idnumber_attribute', '', NULL),
(1432, 2, [[timestamp]], 'enrol_ldap', 'objectclass', '', NULL),
(1433, 2, [[timestamp]], 'enrol_ldap', 'course_idnumber', '', NULL),
(1434, 2, [[timestamp]], 'enrol_ldap', 'course_shortname', '', NULL),
(1435, 2, [[timestamp]], 'enrol_ldap', 'course_fullname', '', NULL),
(1436, 2, [[timestamp]], 'enrol_ldap', 'course_summary', '', NULL);
INSERT INTO `[[dbprefix]]config_log` VALUES
(1437, 2, [[timestamp]], 'enrol_ldap', 'ignorehiddencourses', '0', NULL),
(1438, 2, [[timestamp]], 'enrol_ldap', 'unenrolaction', '0', NULL),
(1439, 2, [[timestamp]], 'enrol_ldap', 'autocreate', '0', NULL),
(1440, 2, [[timestamp]], 'enrol_ldap', 'category', '1', NULL),
(1441, 2, [[timestamp]], 'enrol_ldap', 'template', '', NULL),
(1442, 2, [[timestamp]], 'enrol_ldap', 'course_shortname_updateonsync', '0', NULL),
(1443, 2, [[timestamp]], 'enrol_ldap', 'course_fullname_updateonsync', '0', NULL),
(1444, 2, [[timestamp]], 'enrol_ldap', 'course_summary_updateonsync', '0', NULL),
(1445, 2, [[timestamp]], 'enrol_ldap', 'nested_groups', '0', NULL),
(1446, 2, [[timestamp]], 'enrol_ldap', 'group_memberofattribute', '', NULL),
(1447, 2, [[timestamp]], 'enrol_manual', 'expiredaction', '1', NULL),
(1448, 2, [[timestamp]], 'enrol_manual', 'expirynotifyhour', '6', NULL),
(1449, 2, [[timestamp]], 'enrol_manual', 'defaultenrol', '1', NULL),
(1450, 2, [[timestamp]], 'enrol_manual', 'status', '0', NULL),
(1451, 2, [[timestamp]], 'enrol_manual', 'roleid', '5', NULL),
(1452, 2, [[timestamp]], 'enrol_manual', 'enrolstart', '4', NULL),
(1453, 2, [[timestamp]], 'enrol_manual', 'enrolperiod', '0', NULL),
(1454, 2, [[timestamp]], 'enrol_manual', 'expirynotify', '0', NULL),
(1455, 2, [[timestamp]], 'enrol_manual', 'expirythreshold', '86400', NULL),
(1456, 2, [[timestamp]], 'enrol_mnet', 'roleid', '5', NULL),
(1457, 2, [[timestamp]], 'enrol_mnet', 'roleid_adv', '1', NULL),
(1458, 2, [[timestamp]], 'enrol_paypal', 'paypalbusiness', '', NULL),
(1459, 2, [[timestamp]], 'enrol_paypal', 'mailstudents', '0', NULL),
(1460, 2, [[timestamp]], 'enrol_paypal', 'mailteachers', '0', NULL),
(1461, 2, [[timestamp]], 'enrol_paypal', 'mailadmins', '0', NULL),
(1462, 2, [[timestamp]], 'enrol_paypal', 'expiredaction', '3', NULL),
(1463, 2, [[timestamp]], 'enrol_paypal', 'status', '1', NULL),
(1464, 2, [[timestamp]], 'enrol_paypal', 'cost', '0', NULL),
(1465, 2, [[timestamp]], 'enrol_paypal', 'currency', 'USD', NULL),
(1466, 2, [[timestamp]], 'enrol_paypal', 'roleid', '5', NULL),
(1467, 2, [[timestamp]], 'enrol_paypal', 'enrolperiod', '0', NULL),
(1468, 2, [[timestamp]], 'enrol_lti', 'emaildisplay', '2', NULL),
(1469, 2, [[timestamp]], 'enrol_lti', 'city', '', NULL),
(1470, 2, [[timestamp]], 'enrol_lti', 'country', '', NULL),
(1471, 2, [[timestamp]], 'enrol_lti', 'timezone', '99', NULL),
(1472, 2, [[timestamp]], 'enrol_lti', 'lang', 'en', NULL),
(1473, 2, [[timestamp]], 'enrol_lti', 'institution', '', NULL),
(1474, 2, [[timestamp]], 'enrol_self', 'requirepassword', '0', NULL),
(1475, 2, [[timestamp]], 'enrol_self', 'usepasswordpolicy', '0', NULL),
(1476, 2, [[timestamp]], 'enrol_self', 'showhint', '0', NULL),
(1477, 2, [[timestamp]], 'enrol_self', 'expiredaction', '1', NULL),
(1478, 2, [[timestamp]], 'enrol_self', 'expirynotifyhour', '6', NULL),
(1479, 2, [[timestamp]], 'enrol_self', 'defaultenrol', '1', NULL),
(1480, 2, [[timestamp]], 'enrol_self', 'status', '1', NULL),
(1481, 2, [[timestamp]], 'enrol_self', 'newenrols', '1', NULL),
(1482, 2, [[timestamp]], 'enrol_self', 'groupkey', '0', NULL),
(1483, 2, [[timestamp]], 'enrol_self', 'roleid', '5', NULL),
(1484, 2, [[timestamp]], 'enrol_self', 'enrolperiod', '0', NULL),
(1485, 2, [[timestamp]], 'enrol_self', 'expirynotify', '0', NULL),
(1486, 2, [[timestamp]], 'enrol_self', 'expirythreshold', '86400', NULL),
(1487, 2, [[timestamp]], 'enrol_self', 'longtimenosee', '0', NULL),
(1488, 2, [[timestamp]], 'enrol_self', 'maxenrolled', '0', NULL),
(1489, 2, [[timestamp]], 'enrol_self', 'sendcoursewelcomemessage', '1', NULL),
(1490, 2, [[timestamp]], 'filter_urltolink', 'formats', '0', NULL),
(1491, 2, [[timestamp]], 'filter_urltolink', 'embedimages', '1', NULL),
(1492, 2, [[timestamp]], 'filter_emoticon', 'formats', '1,4,0', NULL),
(1493, 2, [[timestamp]], 'filter_mathjaxloader', 'httpsurl', 'https://cdn.jsdelivr.net/npm/mathjax@2.7.8/MathJax.js', NULL),
(1494, 2, [[timestamp]], 'filter_mathjaxloader', 'texfiltercompatibility', '0', NULL),
(1495, 2, [[timestamp]], 'filter_mathjaxloader', 'mathjaxconfig', '\nMathJax.Hub.Config({\n    config: ["Accessible.js", "Safe.js"],\n    errorSettings: { message: ["!"] },\n    skipStartupTypeset: true,\n    messageStyle: "none"\n});\n', NULL),
(1496, 2, [[timestamp]], 'filter_mathjaxloader', 'additionaldelimiters', '', NULL),
(1497, 2, [[timestamp]], NULL, 'filter_multilang_force_old', '0', NULL),
(1498, 2, [[timestamp]], 'filter_tex', 'latexpreamble', '\\usepackage[latin1]{inputenc}\n\\usepackage{amsmath}\n\\usepackage{amsfonts}\n\\RequirePackage{amsmath,amssymb,latexsym}\n', NULL),
(1499, 2, [[timestamp]], 'filter_tex', 'latexbackground', '#FFFFFF', NULL),
(1500, 2, [[timestamp]], 'filter_tex', 'density', '120', NULL),
(1501, 2, [[timestamp]], 'filter_tex', 'pathlatex', '[[default_filter_tex_pathlatex]]', NULL),
(1502, 2, [[timestamp]], 'filter_tex', 'pathdvips', '[[default_filter_tex_pathdvips]]', NULL),
(1503, 2, [[timestamp]], 'filter_tex', 'pathconvert', '[[default_filter_tex_pathconvert]]', NULL),
(1504, 2, [[timestamp]], 'filter_tex', 'pathdvisvgm', '[[default_filter_tex_dvisvgm]]', NULL),
(1505, 2, [[timestamp]], 'filter_tex', 'pathmimetex', '', NULL),
(1506, 2, [[timestamp]], 'filter_tex', 'convertformat', 'gif', NULL),
(1507, 2, [[timestamp]], NULL, 'filter_censor_badwords', '', NULL),
(1508, 2, [[timestamp]], 'logstore_database', 'dbdriver', '', NULL),
(1509, 2, [[timestamp]], 'logstore_database', 'dbhost', '', NULL),
(1510, 2, [[timestamp]], 'logstore_database', 'dbuser', '', NULL),
(1511, 2, [[timestamp]], 'logstore_database', 'dbpass', '', NULL),
(1512, 2, [[timestamp]], 'logstore_database', 'dbname', '', NULL),
(1513, 2, [[timestamp]], 'logstore_database', 'dbtable', '', NULL),
(1514, 2, [[timestamp]], 'logstore_database', 'dbpersist', '0', NULL),
(1515, 2, [[timestamp]], 'logstore_database', 'dbsocket', '', NULL),
(1516, 2, [[timestamp]], 'logstore_database', 'dbport', '', NULL),
(1517, 2, [[timestamp]], 'logstore_database', 'dbschema', '', NULL),
(1518, 2, [[timestamp]], 'logstore_database', 'dbcollation', '', NULL),
(1519, 2, [[timestamp]], 'logstore_database', 'dbhandlesoptions', '0', NULL),
(1520, 2, [[timestamp]], 'logstore_database', 'buffersize', '50', NULL),
(1521, 2, [[timestamp]], 'logstore_database', 'logguests', '0', NULL),
(1522, 2, [[timestamp]], 'logstore_database', 'includelevels', '1,2,0', NULL),
(1523, 2, [[timestamp]], 'logstore_database', 'includeactions', 'c,r,u,d', NULL),
(1524, 2, [[timestamp]], 'logstore_legacy', 'loglegacy', '0', NULL),
(1525, 2, [[timestamp]], NULL, 'logguests', '1', NULL),
(1526, 2, [[timestamp]], NULL, 'loglifetime', '0', NULL),
(1527, 2, [[timestamp]], 'logstore_standard', 'logguests', '1', NULL),
(1528, 2, [[timestamp]], 'logstore_standard', 'loglifetime', '0', NULL),
(1529, 2, [[timestamp]], 'logstore_standard', 'buffersize', '50', NULL),
(1530, 2, [[timestamp]], 'media_videojs', 'videoextensions', 'html_video,.f4v,.flv', NULL),
(1531, 2, [[timestamp]], 'media_videojs', 'audioextensions', 'html_audio', NULL),
(1532, 2, [[timestamp]], 'media_videojs', 'rtmp', '0', NULL),
(1533, 2, [[timestamp]], 'media_videojs', 'useflash', '0', NULL),
(1534, 2, [[timestamp]], 'media_videojs', 'youtube', '1', NULL),
(1535, 2, [[timestamp]], 'media_videojs', 'videocssclass', 'video-js', NULL),
(1536, 2, [[timestamp]], 'media_videojs', 'audiocssclass', 'video-js', NULL),
(1537, 2, [[timestamp]], 'media_videojs', 'limitsize', '1', NULL),
(1538, 2, [[timestamp]], NULL, 'jabberhost', '', NULL),
(1539, 2, [[timestamp]], NULL, 'jabberserver', '', NULL),
(1540, 2, [[timestamp]], NULL, 'jabberusername', '', NULL),
(1541, 2, [[timestamp]], NULL, 'jabberpassword', '', NULL),
(1542, 2, [[timestamp]], NULL, 'jabberport', '5222', NULL),
(1543, 2, [[timestamp]], NULL, 'airnotifierurl', 'https://messages.moodle.net', NULL),
(1544, 2, [[timestamp]], NULL, 'airnotifierport', '443', NULL),
(1545, 2, [[timestamp]], NULL, 'airnotifiermobileappname', 'com.moodle.moodlemobile', NULL),
(1546, 2, [[timestamp]], NULL, 'airnotifierappname', 'commoodlemoodlemobile', NULL),
(1547, 2, [[timestamp]], NULL, 'airnotifieraccesskey', '', NULL),
(1548, 2, [[timestamp]], 'qtype_multichoice', 'answerhowmany', '1', NULL),
(1549, 2, [[timestamp]], 'qtype_multichoice', 'shuffleanswers', '1', NULL),
(1550, 2, [[timestamp]], 'qtype_multichoice', 'answernumbering', 'abc', NULL),
(1551, 2, [[timestamp]], 'editor_atto', 'toolbar', 'collapse = collapse\nstyle1 = title, bold, italic\nlist = unorderedlist, orderedlist\nlinks = link\nfiles = image, media, recordrtc, managefiles\nstyle2 = underline, strike, subscript, superscript\nalign = align\nindent = indent\ninsert = equation, charmap, table, clear\nundo = undo\naccessibility = accessibilitychecker, accessibilityhelper\nother = html', NULL),
(1552, 2, [[timestamp]], 'editor_atto', 'autosavefrequency', '60', NULL),
(1553, 2, [[timestamp]], 'atto_collapse', 'showgroups', '5', NULL),
(1554, 2, [[timestamp]], 'atto_equation', 'librarygroup1', '\n\\cdot\n\\times\n\\ast\n\\div\n\\diamond\n\\pm\n\\mp\n\\oplus\n\\ominus\n\\otimes\n\\oslash\n\\odot\n\\circ\n\\bullet\n\\asymp\n\\equiv\n\\subseteq\n\\supseteq\n\\leq\n\\geq\n\\preceq\n\\succeq\n\\sim\n\\simeq\n\\approx\n\\subset\n\\supset\n\\ll\n\\gg\n\\prec\n\\succ\n\\infty\n\\in\n\\ni\n\\forall\n\\exists\n\\neq\n', NULL),
(1555, 2, [[timestamp]], 'atto_equation', 'librarygroup2', '\n\\leftarrow\n\\rightarrow\n\\uparrow\n\\downarrow\n\\leftrightarrow\n\\nearrow\n\\searrow\n\\swarrow\n\\nwarrow\n\\Leftarrow\n\\Rightarrow\n\\Uparrow\n\\Downarrow\n\\Leftrightarrow\n', NULL),
(1556, 2, [[timestamp]], 'atto_equation', 'librarygroup3', '\n\\alpha\n\\beta\n\\gamma\n\\delta\n\\epsilon\n\\zeta\n\\eta\n\\theta\n\\iota\n\\kappa\n\\lambda\n\\mu\n\\nu\n\\xi\n\\pi\n\\rho\n\\sigma\n\\tau\n\\upsilon\n\\phi\n\\chi\n\\psi\n\\omega\n\\Gamma\n\\Delta\n\\Theta\n\\Lambda\n\\Xi\n\\Pi\n\\Sigma\n\\Upsilon\n\\Phi\n\\Psi\n\\Omega\n', NULL),
(1557, 2, [[timestamp]], 'atto_equation', 'librarygroup4', '\n\\sum{a,b}\n\\sqrt[a]{b+c}\n\\int_{a}^{b}{c}\n\\iint_{a}^{b}{c}\n\\iiint_{a}^{b}{c}\n\\oint{a}\n(a)\n[a]\n\\lbrace{a}\\rbrace\n\\left| \\begin{matrix} a_1 & a_2 \\ a_3 & a_4 \\end{matrix} \\right|\n\\frac{a}{b+c}\n\\vec{a}\n\\binom {a} {b}\n{a \\brack b}\n{a \\brace b}\n', NULL),
(1558, 2, [[timestamp]], 'atto_recordrtc', 'allowedtypes', 'both', NULL),
(1559, 2, [[timestamp]], 'atto_recordrtc', 'audiobitrate', '128000', NULL),
(1560, 2, [[timestamp]], 'atto_recordrtc', 'videobitrate', '2500000', NULL),
(1561, 2, [[timestamp]], 'atto_recordrtc', 'timelimit', '120', NULL),
(1562, 2, [[timestamp]], 'atto_table', 'allowborders', '0', NULL),
(1563, 2, [[timestamp]], 'atto_table', 'allowbackgroundcolour', '0', NULL),
(1564, 2, [[timestamp]], 'atto_table', 'allowwidth', '0', NULL),
(1565, 2, [[timestamp]], 'editor_tinymce', 'customtoolbar', 'wrap,formatselect,wrap,bold,italic,wrap,bullist,numlist,wrap,link,unlink,wrap,image\n\nundo,redo,wrap,underline,strikethrough,sub,sup,wrap,justifyleft,justifycenter,justifyright,wrap,outdent,indent,wrap,forecolor,backcolor,wrap,ltr,rtl\n\nfontselect,fontsizeselect,wrap,code,search,replace,wrap,nonbreaking,charmap,table,wrap,cleanup,removeformat,pastetext,pasteword,wrap,fullscreen', NULL),
(1566, 2, [[timestamp]], 'editor_tinymce', 'fontselectlist', 'Trebuchet=Trebuchet MS,Verdana,Arial,Helvetica,sans-serif;Arial=arial,helvetica,sans-serif;Courier New=courier new,courier,monospace;Georgia=georgia,times new roman,times,serif;Tahoma=tahoma,arial,helvetica,sans-serif;Times New Roman=times new roman,times,serif;Verdana=verdana,arial,helvetica,sans-serif;Impact=impact;Wingdings=wingdings', NULL),
(1567, 2, [[timestamp]], 'editor_tinymce', 'customconfig', '', NULL),
(1568, 2, [[timestamp]], 'tinymce_moodleemoticon', 'requireemoticon', '1', NULL),
(1569, 2, [[timestamp]], 'tinymce_spellchecker', 'spellengine', '', NULL),
(1570, 2, [[timestamp]], 'tinymce_spellchecker', 'spelllanguagelist', '+English=en,Danish=da,Dutch=nl,Finnish=fi,French=fr,German=de,Italian=it,Polish=pl,Portuguese=pt,Spanish=es,Swedish=sv', NULL),
(1571, 2, [[timestamp]], NULL, 'profileroles', '5,4,3', NULL),
(1572, 2, [[timestamp]], NULL, 'coursecontact', '3', NULL),
(1573, 2, [[timestamp]], NULL, 'frontpage', '6', NULL),
(1574, 2, [[timestamp]], NULL, 'frontpageloggedin', '6', NULL),
(1575, 2, [[timestamp]], NULL, 'maxcategorydepth', '2', NULL),
(1576, 2, [[timestamp]], NULL, 'frontpagecourselimit', '200', NULL),
(1577, 2, [[timestamp]], NULL, 'commentsperpage', '15', NULL),
(1578, 2, [[timestamp]], NULL, 'defaultfrontpageroleid', '8', NULL),
(1579, 2, [[timestamp]], NULL, 'messageinbound_enabled', '0', NULL),
(1580, 2, [[timestamp]], NULL, 'messageinbound_mailbox', '', NULL),
(1581, 2, [[timestamp]], NULL, 'messageinbound_domain', '', NULL),
(1582, 2, [[timestamp]], NULL, 'messageinbound_host', '', NULL),
(1583, 2, [[timestamp]], NULL, 'messageinbound_hostssl', 'ssl', NULL),
(1584, 2, [[timestamp]], NULL, 'messageinbound_hostuser', '', NULL),
(1585, 2, [[timestamp]], NULL, 'messageinbound_hostpass', '', NULL),
(1586, 2, [[timestamp]], NULL, 'enablemobilewebservice', '0', NULL),
(1587, 2, [[timestamp]], 'tool_mobile', 'apppolicy', '', NULL),
(1588, 2, [[timestamp]], NULL, 'timezone', 'America/New_York', NULL),
(1589, 2, [[timestamp]], NULL, 'registerauth', '', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]config_plugins`
--

CREATE TABLE `[[dbprefix]]config_plugins` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `plugin` varchar(100) NOT NULL DEFAULT 'core',
  `name` varchar(100) NOT NULL DEFAULT '',
  `value` longtext NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]confplug_plunam_uix` (`plugin`,`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Moodle modules and plugins configuration variables' AUTO_INCREMENT=1865 ;

--
-- Dumping data for table `[[dbprefix]]config_plugins`
--

INSERT INTO `[[dbprefix]]config_plugins` VALUES
(1, 'question', 'multichoice_sortorder', '1'),
(2, 'question', 'truefalse_sortorder', '2'),
(3, 'question', 'match_sortorder', '3'),
(4, 'question', 'shortanswer_sortorder', '4'),
(5, 'question', 'numerical_sortorder', '5'),
(6, 'question', 'essay_sortorder', '6'),
(7, 'moodlecourse', 'visible', '1'),
(8, 'moodlecourse', 'format', 'topics'),
(9, 'moodlecourse', 'maxsections', '52'),
(10, 'moodlecourse', 'numsections', '4'),
(11, 'moodlecourse', 'hiddensections', '0'),
(12, 'moodlecourse', 'coursedisplay', '0'),
(13, 'moodlecourse', 'courseenddateenabled', '1'),
(14, 'moodlecourse', 'courseduration', '31536000'),
(15, 'moodlecourse', 'lang', ''),
(16, 'moodlecourse', 'newsitems', '5'),
(17, 'moodlecourse', 'showgrades', '1'),
(18, 'moodlecourse', 'showreports', '0'),
(19, 'moodlecourse', 'maxbytes', '0'),
(20, 'moodlecourse', 'enablecompletion', '1'),
(21, 'moodlecourse', 'groupmode', '0'),
(22, 'moodlecourse', 'groupmodeforce', '0'),
(23, 'backup', 'loglifetime', '30'),
(24, 'backup', 'backup_general_users', '1'),
(25, 'backup', 'backup_general_users_locked', ''),
(26, 'backup', 'backup_general_anonymize', '0'),
(27, 'backup', 'backup_general_anonymize_locked', ''),
(28, 'backup', 'backup_general_role_assignments', '1'),
(29, 'backup', 'backup_general_role_assignments_locked', ''),
(30, 'backup', 'backup_general_activities', '1'),
(31, 'backup', 'backup_general_activities_locked', ''),
(32, 'backup', 'backup_general_blocks', '1'),
(33, 'backup', 'backup_general_blocks_locked', ''),
(34, 'backup', 'backup_general_filters', '1'),
(35, 'backup', 'backup_general_filters_locked', ''),
(36, 'backup', 'backup_general_comments', '1'),
(37, 'backup', 'backup_general_comments_locked', ''),
(38, 'backup', 'backup_general_badges', '1'),
(39, 'backup', 'backup_general_badges_locked', ''),
(40, 'backup', 'backup_general_calendarevents', '1'),
(41, 'backup', 'backup_general_calendarevents_locked', ''),
(42, 'backup', 'backup_general_userscompletion', '1'),
(43, 'backup', 'backup_general_userscompletion_locked', ''),
(44, 'backup', 'backup_general_logs', '0'),
(45, 'backup', 'backup_general_logs_locked', ''),
(46, 'backup', 'backup_general_histories', '0'),
(47, 'backup', 'backup_general_histories_locked', ''),
(48, 'backup', 'backup_general_questionbank', '1'),
(49, 'backup', 'backup_general_questionbank_locked', ''),
(50, 'backup', 'backup_general_groups', '1'),
(51, 'backup', 'backup_general_groups_locked', ''),
(52, 'backup', 'backup_general_competencies', '1'),
(53, 'backup', 'backup_general_competencies_locked', ''),
(54, 'backup', 'import_general_maxresults', '10'),
(55, 'backup', 'import_general_duplicate_admin_allowed', '0'),
(56, 'backup', 'backup_import_activities', '1'),
(57, 'backup', 'backup_import_activities_locked', ''),
(58, 'backup', 'backup_import_blocks', '1'),
(59, 'backup', 'backup_import_blocks_locked', ''),
(60, 'backup', 'backup_import_filters', '1'),
(61, 'backup', 'backup_import_filters_locked', ''),
(62, 'backup', 'backup_import_calendarevents', '1'),
(63, 'backup', 'backup_import_calendarevents_locked', ''),
(64, 'backup', 'backup_import_questionbank', '1'),
(65, 'backup', 'backup_import_questionbank_locked', ''),
(66, 'backup', 'backup_import_groups', '1'),
(67, 'backup', 'backup_import_groups_locked', ''),
(68, 'backup', 'backup_import_competencies', '1'),
(69, 'backup', 'backup_import_competencies_locked', ''),
(70, 'backup', 'backup_auto_active', '0'),
(71, 'backup', 'backup_auto_weekdays', '0000000'),
(72, 'backup', 'backup_auto_hour', '0'),
(73, 'backup', 'backup_auto_minute', '0'),
(74, 'backup', 'backup_auto_storage', '0'),
(75, 'backup', 'backup_auto_destination', ''),
(76, 'backup', 'backup_auto_max_kept', '1'),
(77, 'backup', 'backup_auto_delete_days', '0'),
(78, 'backup', 'backup_auto_min_kept', '0'),
(79, 'backup', 'backup_shortname', '0'),
(80, 'backup', 'backup_auto_skip_hidden', '1'),
(81, 'backup', 'backup_auto_skip_modif_days', '30'),
(82, 'backup', 'backup_auto_skip_modif_prev', '0'),
(83, 'backup', 'backup_auto_users', '1'),
(84, 'backup', 'backup_auto_role_assignments', '1'),
(85, 'backup', 'backup_auto_activities', '1'),
(86, 'backup', 'backup_auto_blocks', '1'),
(87, 'backup', 'backup_auto_filters', '1'),
(88, 'backup', 'backup_auto_comments', '1'),
(89, 'backup', 'backup_auto_badges', '1'),
(90, 'backup', 'backup_auto_calendarevents', '1'),
(91, 'backup', 'backup_auto_userscompletion', '1'),
(92, 'backup', 'backup_auto_logs', '0'),
(93, 'backup', 'backup_auto_histories', '0'),
(94, 'backup', 'backup_auto_questionbank', '1'),
(95, 'backup', 'backup_auto_groups', '1'),
(96, 'backup', 'backup_auto_competencies', '1'),
(97, 'restore', 'restore_general_users', '1'),
(98, 'restore', 'restore_general_users_locked', ''),
(99, 'restore', 'restore_general_enrolments', '1'),
(100, 'restore', 'restore_general_enrolments_locked', ''),
(101, 'restore', 'restore_general_role_assignments', '1'),
(102, 'restore', 'restore_general_role_assignments_locked', ''),
(103, 'restore', 'restore_general_activities', '1'),
(104, 'restore', 'restore_general_activities_locked', ''),
(105, 'restore', 'restore_general_blocks', '1'),
(106, 'restore', 'restore_general_blocks_locked', ''),
(107, 'restore', 'restore_general_filters', '1'),
(108, 'restore', 'restore_general_filters_locked', ''),
(109, 'restore', 'restore_general_comments', '1'),
(110, 'restore', 'restore_general_comments_locked', ''),
(111, 'restore', 'restore_general_badges', '1'),
(112, 'restore', 'restore_general_badges_locked', ''),
(113, 'restore', 'restore_general_calendarevents', '1'),
(114, 'restore', 'restore_general_calendarevents_locked', ''),
(115, 'restore', 'restore_general_userscompletion', '1'),
(116, 'restore', 'restore_general_userscompletion_locked', ''),
(117, 'restore', 'restore_general_logs', '1'),
(118, 'restore', 'restore_general_logs_locked', ''),
(119, 'restore', 'restore_general_histories', '1'),
(120, 'restore', 'restore_general_histories_locked', ''),
(121, 'restore', 'restore_general_groups', '1'),
(122, 'restore', 'restore_general_groups_locked', ''),
(123, 'restore', 'restore_general_competencies', '1'),
(124, 'restore', 'restore_general_competencies_locked', ''),
(125, 'restore', 'restore_merge_overwrite_conf', '0'),
(126, 'restore', 'restore_merge_overwrite_conf_locked', ''),
(127, 'restore', 'restore_merge_course_fullname', '1'),
(128, 'restore', 'restore_merge_course_fullname_locked', ''),
(129, 'restore', 'restore_merge_course_shortname', '1'),
(130, 'restore', 'restore_merge_course_shortname_locked', ''),
(131, 'restore', 'restore_merge_course_startdate', '1'),
(132, 'restore', 'restore_merge_course_startdate_locked', ''),
(133, 'restore', 'restore_replace_overwrite_conf', '0'),
(134, 'restore', 'restore_replace_overwrite_conf_locked', ''),
(135, 'restore', 'restore_replace_course_fullname', '1'),
(136, 'restore', 'restore_replace_course_fullname_locked', ''),
(137, 'restore', 'restore_replace_course_shortname', '1'),
(138, 'restore', 'restore_replace_course_shortname_locked', ''),
(139, 'restore', 'restore_replace_course_startdate', '1'),
(140, 'restore', 'restore_replace_course_startdate_locked', ''),
(141, 'restore', 'restore_replace_keep_roles_and_enrolments', '0'),
(142, 'restore', 'restore_replace_keep_roles_and_enrolments_locked', ''),
(143, 'restore', 'restore_replace_keep_groups_and_groupings', '0'),
(144, 'restore', 'restore_replace_keep_groups_and_groupings_locked', ''),
(145, 'analytics', 'predictionsprocessor', '\\mlbackend_php\\processor'),
(146, 'analytics', 'timesplittings', '\\core\\analytics\\time_splitting\\quarters_accum,\\core\\analytics\\time_splitting\\quarters,\\core\\analytics\\time_splitting\\single_range'),
(147, 'analytics', 'modeloutputdir', '[[softdatadir]]/models'),
(148, 'analytics', 'onlycli', '1'),
(149, 'analytics', 'modeltimelimit', '1200'),
(150, 'core_competency', 'enabled', '1'),
(151, 'core_competency', 'pushcourseratingstouserplans', '1'),
(152, 'cachestore_apcu', 'testperformance', '0'),
(153, 'cachestore_memcache', 'testservers', ''),
(154, 'cachestore_memcached', 'testservers', ''),
(155, 'cachestore_mongodb', 'testserver', ''),
(156, 'cachestore_redis', 'test_server', ''),
(157, 'cachestore_redis', 'test_password', ''),
(158, 'question_preview', 'behaviour', 'deferredfeedback'),
(159, 'question_preview', 'correctness', '1'),
(160, 'question_preview', 'marks', '2'),
(161, 'question_preview', 'markdp', '2'),
(162, 'question_preview', 'feedback', '1'),
(163, 'question_preview', 'generalfeedback', '1'),
(164, 'question_preview', 'rightanswer', '1'),
(165, 'question_preview', 'history', '0'),
(166, 'tool_task', 'enablerunnow', '1'),
(167, 'theme_boost', 'preset', 'default.scss'),
(168, 'theme_boost', 'presetfiles', ''),
(169, 'theme_boost', 'backgroundimage', ''),
(170, 'theme_boost', 'brandcolor', ''),
(171, 'theme_boost', 'scsspre', ''),
(172, 'theme_boost', 'scss', ''),
(173, 'theme_clean', 'invert', '0'),
(174, 'theme_clean', 'logo', ''),
(175, 'theme_clean', 'smalllogo', ''),
(176, 'theme_clean', 'sitename', '1'),
(177, 'theme_clean', 'customcss', ''),
(178, 'theme_clean', 'footnote', ''),
(179, 'theme_more', 'textcolor', '#333366'),
(180, 'theme_more', 'linkcolor', '#FF6500'),
(181, 'theme_more', 'bodybackground', ''),
(182, 'theme_more', 'backgroundimage', ''),
(183, 'theme_more', 'backgroundrepeat', 'repeat'),
(184, 'theme_more', 'backgroundposition', '0'),
(185, 'theme_more', 'backgroundfixed', '0'),
(186, 'theme_more', 'contentbackground', '#FFFFFF'),
(187, 'theme_more', 'secondarybackground', '#FFFFFF'),
(188, 'theme_more', 'invert', '1'),
(189, 'theme_more', 'logo', ''),
(190, 'theme_more', 'smalllogo', ''),
(191, 'theme_more', 'sitename', '1'),
(192, 'theme_more', 'customcss', ''),
(193, 'theme_more', 'footnote', ''),
(194, 'core_admin', 'logo', ''),
(195, 'core_admin', 'logocompact', ''),
(196, 'antivirus_clamav', 'version', '2018051400'),
(197, 'availability_completion', 'version', '2018051400'),
(198, 'availability_date', 'version', '2018051400'),
(199, 'availability_grade', 'version', '2018051400'),
(200, 'availability_group', 'version', '2018051400'),
(201, 'availability_grouping', 'version', '2018051400'),
(202, 'availability_profile', 'version', '2018051400'),
(203, 'qtype_calculated', 'version', '2018051400'),
(204, 'qtype_calculatedmulti', 'version', '2018051400'),
(205, 'qtype_calculatedsimple', 'version', '2018051400'),
(206, 'qtype_ddimageortext', 'version', '2018051400'),
(207, 'qtype_ddmarker', 'version', '2018051400'),
(208, 'qtype_ddwtos', 'version', '2018051400'),
(209, 'qtype_description', 'version', '2018051400'),
(210, 'qtype_essay', 'version', '2018051400'),
(211, 'qtype_gapselect', 'version', '2018051400'),
(212, 'qtype_match', 'version', '2018051400'),
(213, 'qtype_missingtype', 'version', '2018051400'),
(214, 'qtype_multianswer', 'version', '2018051401'),
(215, 'qtype_multichoice', 'version', '2018051400'),
(216, 'qtype_numerical', 'version', '2018051400'),
(217, 'qtype_random', 'version', '2018051401'),
(218, 'qtype_randomsamatch', 'version', '2018051400'),
(219, 'qtype_shortanswer', 'version', '2018051400'),
(220, 'qtype_truefalse', 'version', '2018051400'),
(221, 'mod_assign', 'version', '2018051400'),
(222, 'mod_assignment', 'version', '2018051400'),
(224, 'mod_book', 'version', '2018051400'),
(225, 'mod_chat', 'version', '2018051400'),
(226, 'mod_choice', 'version', '2018051400'),
(227, 'mod_data', 'version', '2018051400'),
(228, 'mod_feedback', 'version', '2018051400'),
(230, 'mod_folder', 'version', '2018051400'),
(232, 'mod_forum', 'version', '2018051400'),
(233, 'mod_glossary', 'version', '2018051401'),
(234, 'mod_imscp', 'version', '2018051400'),
(236, 'mod_label', 'version', '2018051400'),
(237, 'mod_lesson', 'version', '2018051400'),
(238, 'mod_lti', 'version', '2018051400'),
(239, 'mod_page', 'version', '2018051400'),
(241, 'mod_quiz', 'version', '2018051400'),
(242, 'mod_resource', 'version', '2018051400'),
(243, 'mod_scorm', 'version', '2018051400'),
(244, 'mod_survey', 'version', '2018051400'),
(246, 'mod_url', 'version', '2018051400'),
(248, 'mod_wiki', 'version', '2018051400'),
(250, 'mod_workshop', 'version', '2018051400'),
(251, 'auth_cas', 'version', '2018051400'),
(253, 'auth_db', 'version', '2018051400'),
(255, 'auth_email', 'version', '2018051400'),
(256, 'auth_ldap', 'version', '2018051400'),
(258, 'auth_lti', 'version', '2018051400'),
(259, 'auth_manual', 'version', '2018051400'),
(260, 'auth_mnet', 'version', '2018051400'),
(262, 'auth_nologin', 'version', '2018051400'),
(263, 'auth_none', 'version', '2018051400'),
(264, 'auth_oauth2', 'version', '2018051401'),
(265, 'auth_shibboleth', 'version', '2018051401'),
(267, 'auth_webservice', 'version', '2018051400'),
(268, 'calendartype_gregorian', 'version', '2018051400'),
(269, 'enrol_category', 'version', '2018051400'),
(271, 'enrol_cohort', 'version', '2018051400'),
(272, 'enrol_database', 'version', '2018051400'),
(274, 'enrol_flatfile', 'version', '2018051400'),
(276, 'enrol_flatfile', 'map_1', 'manager'),
(277, 'enrol_flatfile', 'map_2', 'coursecreator'),
(278, 'enrol_flatfile', 'map_3', 'editingteacher'),
(279, 'enrol_flatfile', 'map_4', 'teacher'),
(280, 'enrol_flatfile', 'map_5', 'student'),
(281, 'enrol_flatfile', 'map_6', 'guest'),
(282, 'enrol_flatfile', 'map_7', 'user'),
(283, 'enrol_flatfile', 'map_8', 'frontpage'),
(284, 'enrol_guest', 'version', '2018051400'),
(285, 'enrol_imsenterprise', 'version', '2018051400'),
(287, 'enrol_ldap', 'version', '2018051400'),
(289, 'enrol_lti', 'version', '2018051400'),
(290, 'enrol_manual', 'version', '2018051400'),
(292, 'enrol_meta', 'version', '2018051400'),
(294, 'enrol_mnet', 'version', '2018051400'),
(295, 'enrol_paypal', 'version', '2018051405'),
(296, 'enrol_self', 'version', '2018051400'),
(298, 'message_airnotifier', 'version', '2018051400'),
(300, 'message', 'airnotifier_provider_enrol_flatfile_flatfile_enrolment_permitted', 'permitted'),
(301, 'message', 'airnotifier_provider_enrol_imsenterprise_imsenterprise_enrolment_permitted', 'permitted'),
(302, 'message', 'airnotifier_provider_enrol_manual_expiry_notification_permitted', 'permitted'),
(303, 'message', 'airnotifier_provider_enrol_paypal_paypal_enrolment_permitted', 'permitted'),
(304, 'message', 'airnotifier_provider_enrol_self_expiry_notification_permitted', 'permitted'),
(305, 'message', 'airnotifier_provider_mod_assign_assign_notification_permitted', 'permitted'),
(306, 'message', 'airnotifier_provider_mod_assignment_assignment_updates_permitted', 'permitted'),
(307, 'message', 'airnotifier_provider_mod_feedback_submission_permitted', 'permitted'),
(308, 'message', 'airnotifier_provider_mod_feedback_message_permitted', 'permitted'),
(309, 'message', 'airnotifier_provider_mod_forum_posts_permitted', 'permitted'),
(310, 'message', 'airnotifier_provider_mod_forum_digests_permitted', 'permitted'),
(311, 'message', 'airnotifier_provider_mod_lesson_graded_essay_permitted', 'permitted'),
(312, 'message', 'airnotifier_provider_mod_quiz_submission_permitted', 'permitted'),
(313, 'message', 'airnotifier_provider_mod_quiz_confirmation_permitted', 'permitted'),
(314, 'message', 'airnotifier_provider_mod_quiz_attempt_overdue_permitted', 'permitted'),
(315, 'message', 'airnotifier_provider_moodle_notices_permitted', 'permitted'),
(316, 'message', 'airnotifier_provider_moodle_errors_permitted', 'permitted'),
(317, 'message', 'airnotifier_provider_moodle_availableupdate_permitted', 'permitted'),
(318, 'message', 'airnotifier_provider_moodle_instantmessage_permitted', 'permitted'),
(319, 'message', 'airnotifier_provider_moodle_backup_permitted', 'permitted'),
(320, 'message', 'airnotifier_provider_moodle_courserequested_permitted', 'permitted'),
(321, 'message', 'airnotifier_provider_moodle_courserequestapproved_permitted', 'permitted'),
(322, 'message', 'airnotifier_provider_moodle_courserequestrejected_permitted', 'permitted'),
(323, 'message', 'airnotifier_provider_moodle_badgerecipientnotice_permitted', 'permitted'),
(324, 'message', 'airnotifier_provider_moodle_badgecreatornotice_permitted', 'permitted'),
(325, 'message', 'airnotifier_provider_moodle_competencyplancomment_permitted', 'permitted'),
(326, 'message', 'airnotifier_provider_moodle_competencyusercompcomment_permitted', 'permitted'),
(327, 'message', 'airnotifier_provider_moodle_insights_permitted', 'permitted'),
(328, 'message_email', 'version', '2018051400'),
(330, 'message', 'email_provider_enrol_flatfile_flatfile_enrolment_permitted', 'permitted'),
(331, 'message', 'message_provider_enrol_flatfile_flatfile_enrolment_loggedin', 'email'),
(332, 'message', 'message_provider_enrol_flatfile_flatfile_enrolment_loggedoff', 'email'),
(333, 'message', 'email_provider_enrol_imsenterprise_imsenterprise_enrolment_permitted', 'permitted'),
(334, 'message', 'message_provider_enrol_imsenterprise_imsenterprise_enrolment_loggedin', 'email'),
(335, 'message', 'message_provider_enrol_imsenterprise_imsenterprise_enrolment_loggedoff', 'email'),
(336, 'message', 'email_provider_enrol_manual_expiry_notification_permitted', 'permitted'),
(337, 'message', 'message_provider_enrol_manual_expiry_notification_loggedin', 'email'),
(338, 'message', 'message_provider_enrol_manual_expiry_notification_loggedoff', 'email'),
(339, 'message', 'email_provider_enrol_paypal_paypal_enrolment_permitted', 'permitted'),
(340, 'message', 'message_provider_enrol_paypal_paypal_enrolment_loggedin', 'email'),
(341, 'message', 'message_provider_enrol_paypal_paypal_enrolment_loggedoff', 'email'),
(342, 'message', 'email_provider_enrol_self_expiry_notification_permitted', 'permitted'),
(343, 'message', 'message_provider_enrol_self_expiry_notification_loggedin', 'email'),
(344, 'message', 'message_provider_enrol_self_expiry_notification_loggedoff', 'email'),
(345, 'message', 'email_provider_mod_assign_assign_notification_permitted', 'permitted'),
(346, 'message', 'message_provider_mod_assign_assign_notification_loggedin', 'email'),
(347, 'message', 'message_provider_mod_assign_assign_notification_loggedoff', 'email'),
(348, 'message', 'email_provider_mod_assignment_assignment_updates_permitted', 'permitted'),
(349, 'message', 'message_provider_mod_assignment_assignment_updates_loggedin', 'email'),
(350, 'message', 'message_provider_mod_assignment_assignment_updates_loggedoff', 'email'),
(351, 'message', 'email_provider_mod_feedback_submission_permitted', 'permitted'),
(352, 'message', 'message_provider_mod_feedback_submission_loggedin', 'email'),
(353, 'message', 'message_provider_mod_feedback_submission_loggedoff', 'email'),
(354, 'message', 'email_provider_mod_feedback_message_permitted', 'permitted'),
(355, 'message', 'message_provider_mod_feedback_message_loggedin', 'email'),
(356, 'message', 'message_provider_mod_feedback_message_loggedoff', 'email'),
(357, 'message', 'email_provider_mod_forum_posts_permitted', 'permitted'),
(358, 'message', 'message_provider_mod_forum_posts_loggedin', 'email'),
(359, 'message', 'message_provider_mod_forum_posts_loggedoff', 'email'),
(360, 'message', 'email_provider_mod_forum_digests_permitted', 'permitted'),
(361, 'message', 'message_provider_mod_forum_digests_loggedin', 'email'),
(362, 'message', 'message_provider_mod_forum_digests_loggedoff', 'email'),
(363, 'message', 'email_provider_mod_lesson_graded_essay_permitted', 'permitted'),
(364, 'message', 'message_provider_mod_lesson_graded_essay_loggedin', 'email'),
(365, 'message', 'message_provider_mod_lesson_graded_essay_loggedoff', 'email'),
(366, 'message', 'email_provider_mod_quiz_submission_permitted', 'permitted'),
(367, 'message', 'message_provider_mod_quiz_submission_loggedin', 'email'),
(368, 'message', 'message_provider_mod_quiz_submission_loggedoff', 'email'),
(369, 'message', 'email_provider_mod_quiz_confirmation_permitted', 'permitted'),
(370, 'message', 'message_provider_mod_quiz_confirmation_loggedin', 'email'),
(371, 'message', 'message_provider_mod_quiz_confirmation_loggedoff', 'email'),
(372, 'message', 'email_provider_mod_quiz_attempt_overdue_permitted', 'permitted'),
(373, 'message', 'message_provider_mod_quiz_attempt_overdue_loggedin', 'email'),
(374, 'message', 'message_provider_mod_quiz_attempt_overdue_loggedoff', 'email'),
(375, 'message', 'email_provider_moodle_notices_permitted', 'permitted'),
(376, 'message', 'message_provider_moodle_notices_loggedin', 'email'),
(377, 'message', 'message_provider_moodle_notices_loggedoff', 'email'),
(378, 'message', 'email_provider_moodle_errors_permitted', 'permitted'),
(379, 'message', 'message_provider_moodle_errors_loggedin', 'email'),
(380, 'message', 'message_provider_moodle_errors_loggedoff', 'email'),
(381, 'message', 'email_provider_moodle_availableupdate_permitted', 'permitted'),
(382, 'message', 'message_provider_moodle_availableupdate_loggedin', 'email'),
(383, 'message', 'message_provider_moodle_availableupdate_loggedoff', 'email'),
(384, 'message', 'email_provider_moodle_instantmessage_permitted', 'permitted'),
(385, 'message', 'message_provider_moodle_instantmessage_loggedoff', 'popup,email'),
(386, 'message', 'email_provider_moodle_backup_permitted', 'permitted'),
(387, 'message', 'message_provider_moodle_backup_loggedin', 'email'),
(388, 'message', 'message_provider_moodle_backup_loggedoff', 'email'),
(389, 'message', 'email_provider_moodle_courserequested_permitted', 'permitted'),
(390, 'message', 'message_provider_moodle_courserequested_loggedin', 'email'),
(391, 'message', 'message_provider_moodle_courserequested_loggedoff', 'email'),
(392, 'message', 'email_provider_moodle_courserequestapproved_permitted', 'permitted'),
(393, 'message', 'message_provider_moodle_courserequestapproved_loggedin', 'email'),
(394, 'message', 'message_provider_moodle_courserequestapproved_loggedoff', 'email'),
(395, 'message', 'email_provider_moodle_courserequestrejected_permitted', 'permitted'),
(396, 'message', 'message_provider_moodle_courserequestrejected_loggedin', 'email'),
(397, 'message', 'message_provider_moodle_courserequestrejected_loggedoff', 'email'),
(398, 'message', 'email_provider_moodle_badgerecipientnotice_permitted', 'permitted'),
(399, 'message', 'message_provider_moodle_badgerecipientnotice_loggedoff', 'popup,email'),
(400, 'message', 'email_provider_moodle_badgecreatornotice_permitted', 'permitted'),
(401, 'message', 'message_provider_moodle_badgecreatornotice_loggedoff', 'email'),
(402, 'message', 'email_provider_moodle_competencyplancomment_permitted', 'permitted'),
(403, 'message', 'message_provider_moodle_competencyplancomment_loggedin', 'email'),
(404, 'message', 'message_provider_moodle_competencyplancomment_loggedoff', 'email'),
(405, 'message', 'email_provider_moodle_competencyusercompcomment_permitted', 'permitted'),
(406, 'message', 'message_provider_moodle_competencyusercompcomment_loggedin', 'email'),
(407, 'message', 'message_provider_moodle_competencyusercompcomment_loggedoff', 'email'),
(408, 'message', 'email_provider_moodle_insights_permitted', 'permitted'),
(409, 'message', 'message_provider_moodle_insights_loggedin', 'email'),
(410, 'message', 'message_provider_moodle_insights_loggedoff', 'email'),
(411, 'message_jabber', 'version', '2018051400'),
(413, 'message', 'jabber_provider_enrol_flatfile_flatfile_enrolment_permitted', 'permitted'),
(414, 'message', 'jabber_provider_enrol_imsenterprise_imsenterprise_enrolment_permitted', 'permitted'),
(415, 'message', 'jabber_provider_enrol_manual_expiry_notification_permitted', 'permitted'),
(416, 'message', 'jabber_provider_enrol_paypal_paypal_enrolment_permitted', 'permitted'),
(417, 'message', 'jabber_provider_enrol_self_expiry_notification_permitted', 'permitted'),
(418, 'message', 'jabber_provider_mod_assign_assign_notification_permitted', 'permitted'),
(419, 'message', 'jabber_provider_mod_assignment_assignment_updates_permitted', 'permitted'),
(420, 'message', 'jabber_provider_mod_feedback_submission_permitted', 'permitted'),
(421, 'message', 'jabber_provider_mod_feedback_message_permitted', 'permitted'),
(422, 'message', 'jabber_provider_mod_forum_posts_permitted', 'permitted'),
(423, 'message', 'jabber_provider_mod_forum_digests_permitted', 'permitted'),
(424, 'message', 'jabber_provider_mod_lesson_graded_essay_permitted', 'permitted'),
(425, 'message', 'jabber_provider_mod_quiz_submission_permitted', 'permitted'),
(426, 'message', 'jabber_provider_mod_quiz_confirmation_permitted', 'permitted'),
(427, 'message', 'jabber_provider_mod_quiz_attempt_overdue_permitted', 'permitted'),
(428, 'message', 'jabber_provider_moodle_notices_permitted', 'permitted'),
(429, 'message', 'jabber_provider_moodle_errors_permitted', 'permitted'),
(430, 'message', 'jabber_provider_moodle_availableupdate_permitted', 'permitted'),
(431, 'message', 'jabber_provider_moodle_instantmessage_permitted', 'permitted'),
(432, 'message', 'jabber_provider_moodle_backup_permitted', 'permitted'),
(433, 'message', 'jabber_provider_moodle_courserequested_permitted', 'permitted'),
(434, 'message', 'jabber_provider_moodle_courserequestapproved_permitted', 'permitted'),
(435, 'message', 'jabber_provider_moodle_courserequestrejected_permitted', 'permitted'),
(436, 'message', 'jabber_provider_moodle_badgerecipientnotice_permitted', 'permitted'),
(437, 'message', 'jabber_provider_moodle_badgecreatornotice_permitted', 'permitted'),
(438, 'message', 'jabber_provider_moodle_competencyplancomment_permitted', 'permitted'),
(439, 'message', 'jabber_provider_moodle_competencyusercompcomment_permitted', 'permitted'),
(440, 'message', 'jabber_provider_moodle_insights_permitted', 'permitted'),
(441, 'message_popup', 'version', '2018051400'),
(443, 'message', 'popup_provider_enrol_flatfile_flatfile_enrolment_permitted', 'permitted'),
(444, 'message', 'popup_provider_enrol_imsenterprise_imsenterprise_enrolment_permitted', 'permitted'),
(445, 'message', 'popup_provider_enrol_manual_expiry_notification_permitted', 'permitted'),
(446, 'message', 'popup_provider_enrol_paypal_paypal_enrolment_permitted', 'permitted'),
(447, 'message', 'popup_provider_enrol_self_expiry_notification_permitted', 'permitted'),
(448, 'message', 'popup_provider_mod_assign_assign_notification_permitted', 'permitted'),
(449, 'message', 'popup_provider_mod_assignment_assignment_updates_permitted', 'permitted'),
(450, 'message', 'popup_provider_mod_feedback_submission_permitted', 'permitted'),
(451, 'message', 'popup_provider_mod_feedback_message_permitted', 'permitted'),
(452, 'message', 'popup_provider_mod_forum_posts_permitted', 'permitted'),
(453, 'message', 'popup_provider_mod_forum_digests_permitted', 'permitted'),
(454, 'message', 'popup_provider_mod_lesson_graded_essay_permitted', 'permitted'),
(455, 'message', 'popup_provider_mod_quiz_submission_permitted', 'permitted'),
(456, 'message', 'popup_provider_mod_quiz_confirmation_permitted', 'permitted'),
(457, 'message', 'popup_provider_mod_quiz_attempt_overdue_permitted', 'permitted'),
(458, 'message', 'popup_provider_moodle_notices_permitted', 'permitted'),
(459, 'message', 'popup_provider_moodle_errors_permitted', 'permitted'),
(460, 'message', 'popup_provider_moodle_availableupdate_permitted', 'permitted'),
(461, 'message', 'popup_provider_moodle_instantmessage_permitted', 'permitted'),
(462, 'message', 'message_provider_moodle_instantmessage_loggedin', 'popup'),
(463, 'message', 'popup_provider_moodle_backup_permitted', 'permitted'),
(464, 'message', 'popup_provider_moodle_courserequested_permitted', 'permitted'),
(465, 'message', 'popup_provider_moodle_courserequestapproved_permitted', 'permitted'),
(466, 'message', 'popup_provider_moodle_courserequestrejected_permitted', 'permitted'),
(467, 'message', 'popup_provider_moodle_badgerecipientnotice_permitted', 'permitted'),
(468, 'message', 'message_provider_moodle_badgerecipientnotice_loggedin', 'popup'),
(469, 'message', 'popup_provider_moodle_badgecreatornotice_permitted', 'permitted'),
(470, 'message', 'popup_provider_moodle_competencyplancomment_permitted', 'permitted'),
(471, 'message', 'popup_provider_moodle_competencyusercompcomment_permitted', 'permitted'),
(472, 'message', 'popup_provider_moodle_insights_permitted', 'permitted'),
(473, 'block_activity_modules', 'version', '2018051400'),
(474, 'block_activity_results', 'version', '2018051400'),
(475, 'block_admin_bookmarks', 'version', '2018051400'),
(476, 'block_badges', 'version', '2018051400'),
(477, 'block_blog_menu', 'version', '2018051400'),
(478, 'block_blog_recent', 'version', '2018051400'),
(479, 'block_blog_tags', 'version', '2018051400'),
(480, 'block_calendar_month', 'version', '2018051400'),
(481, 'block_calendar_upcoming', 'version', '2018051400'),
(482, 'block_comments', 'version', '2018051400'),
(483, 'block_community', 'version', '2018051400'),
(484, 'block_completionstatus', 'version', '2018051400'),
(485, 'block_course_list', 'version', '2018051400'),
(486, 'block_course_summary', 'version', '2018051400'),
(487, 'block_feedback', 'version', '2018051400'),
(489, 'block_globalsearch', 'version', '2018051400'),
(490, 'block_glossary_random', 'version', '2018051400'),
(491, 'block_html', 'version', '2018051400'),
(492, 'block_login', 'version', '2018051400'),
(493, 'block_lp', 'version', '2018051400'),
(494, 'block_mentees', 'version', '2018051400'),
(495, 'block_mnet_hosts', 'version', '2018051400'),
(496, 'block_myoverview', 'version', '2018051400'),
(497, 'block_myprofile', 'version', '2018051400'),
(498, 'block_navigation', 'version', '2018051400'),
(499, 'block_news_items', 'version', '2018051400'),
(500, 'block_online_users', 'version', '2018051401'),
(501, 'block_participants', 'version', '2018051400'),
(502, 'block_private_files', 'version', '2018051400'),
(503, 'block_quiz_results', 'version', '2018051400'),
(505, 'block_recent_activity', 'version', '2018051400'),
(506, 'block_rss_client', 'version', '2018051400'),
(507, 'block_search_forums', 'version', '2018051400'),
(508, 'block_section_links', 'version', '2018051400'),
(509, 'block_selfcompletion', 'version', '2018051400'),
(510, 'block_settings', 'version', '2018051400'),
(511, 'block_site_main_menu', 'version', '2018051400'),
(512, 'block_social_activities', 'version', '2018051400'),
(513, 'block_tag_flickr', 'version', '2018051400'),
(514, 'block_tag_youtube', 'version', '2018051400'),
(516, 'block_tags', 'version', '2018051400'),
(517, 'media_html5audio', 'version', '2018051400'),
(518, 'media_html5video', 'version', '2018051400'),
(519, 'media_swf', 'version', '2018051400'),
(520, 'media_videojs', 'version', '2018051400'),
(521, 'media_vimeo', 'version', '2018051400'),
(522, 'media_youtube', 'version', '2018051400'),
(523, 'filter_activitynames', 'version', '2018051400'),
(525, 'filter_algebra', 'version', '2018051400'),
(526, 'filter_censor', 'version', '2018051400'),
(527, 'filter_data', 'version', '2018051400'),
(529, 'filter_emailprotect', 'version', '2018051400'),
(530, 'filter_emoticon', 'version', '2018051400'),
(531, 'filter_glossary', 'version', '2018051400'),
(533, 'filter_mathjaxloader', 'version', '2018051401'),
(535, 'filter_mediaplugin', 'version', '2018051400'),
(537, 'filter_multilang', 'version', '2018051400'),
(538, 'filter_tex', 'version', '2018051400'),
(540, 'filter_tidy', 'version', '2018051400'),
(541, 'filter_urltolink', 'version', '2018051400'),
(542, 'editor_atto', 'version', '2018051401'),
(544, 'editor_textarea', 'version', '2018051400'),
(545, 'editor_tinymce', 'version', '2018051400'),
(546, 'format_singleactivity', 'version', '2018051400'),
(547, 'format_social', 'version', '2018051400'),
(548, 'format_topics', 'version', '2018051400'),
(549, 'format_weeks', 'version', '2018051400'),
(550, 'dataformat_csv', 'version', '2018051400'),
(551, 'dataformat_excel', 'version', '2018051400'),
(552, 'dataformat_html', 'version', '2018051400'),
(553, 'dataformat_json', 'version', '2018051400'),
(554, 'dataformat_ods', 'version', '2018051400'),
(555, 'profilefield_checkbox', 'version', '2018051400'),
(556, 'profilefield_datetime', 'version', '2018051400'),
(557, 'profilefield_menu', 'version', '2018051400'),
(558, 'profilefield_text', 'version', '2018051400'),
(559, 'profilefield_textarea', 'version', '2018051400'),
(560, 'report_backups', 'version', '2018051400'),
(561, 'report_competency', 'version', '2018051400'),
(562, 'report_completion', 'version', '2018051400'),
(564, 'report_configlog', 'version', '2018051400'),
(565, 'report_courseoverview', 'version', '2018051400'),
(566, 'report_eventlist', 'version', '2018051400'),
(567, 'report_insights', 'version', '2018051400'),
(568, 'report_log', 'version', '2018051400'),
(570, 'report_loglive', 'version', '2018051400'),
(571, 'report_outline', 'version', '2018051400'),
(573, 'report_participation', 'version', '2018051400'),
(575, 'report_performance', 'version', '2018051400'),
(576, 'report_progress', 'version', '2018051400'),
(578, 'report_questioninstances', 'version', '2018051400'),
(579, 'report_security', 'version', '2018051400'),
(580, 'report_stats', 'version', '2018051400'),
(582, 'report_usersessions', 'version', '2018051400'),
(583, 'gradeexport_ods', 'version', '2018051400'),
(584, 'gradeexport_txt', 'version', '2018051400'),
(585, 'gradeexport_xls', 'version', '2018051400'),
(586, 'gradeexport_xml', 'version', '2018051400'),
(587, 'gradeimport_csv', 'version', '2018051400'),
(588, 'gradeimport_direct', 'version', '2018051400'),
(589, 'gradeimport_xml', 'version', '2018051400'),
(590, 'gradereport_grader', 'version', '2018051400'),
(591, 'gradereport_history', 'version', '2018051400'),
(592, 'gradereport_outcomes', 'version', '2018051400'),
(593, 'gradereport_overview', 'version', '2018051400'),
(594, 'gradereport_singleview', 'version', '2018051400'),
(595, 'gradereport_user', 'version', '2018051400'),
(596, 'gradingform_guide', 'version', '2018051400'),
(597, 'gradingform_rubric', 'version', '2018051400'),
(598, 'mlbackend_php', 'version', '2018051400'),
(599, 'mlbackend_python', 'version', '2018051400'),
(600, 'mnetservice_enrol', 'version', '2018051400'),
(601, 'webservice_rest', 'version', '2018051400'),
(602, 'webservice_soap', 'version', '2018051400'),
(603, 'webservice_xmlrpc', 'version', '2018051400'),
(604, 'repository_areafiles', 'version', '2018051400'),
(606, 'areafiles', 'enablecourseinstances', '0'),
(607, 'areafiles', 'enableuserinstances', '0'),
(608, 'repository_boxnet', 'version', '2018051400'),
(609, 'repository_coursefiles', 'version', '2018051400'),
(610, 'repository_dropbox', 'version', '2018051400'),
(611, 'repository_equella', 'version', '2018051400'),
(612, 'repository_filesystem', 'version', '2018051400'),
(613, 'repository_flickr', 'version', '2018051400'),
(614, 'repository_flickr_public', 'version', '2018051400'),
(615, 'repository_googledocs', 'version', '2018051400'),
(616, 'repository_local', 'version', '2018051400'),
(618, 'local', 'enablecourseinstances', '0'),
(619, 'local', 'enableuserinstances', '0'),
(620, 'repository_merlot', 'version', '2018051400'),
(621, 'repository_onedrive', 'version', '2018051400'),
(622, 'repository_picasa', 'version', '2018051400'),
(623, 'repository_recent', 'version', '2018051400'),
(625, 'recent', 'enablecourseinstances', '0'),
(626, 'recent', 'enableuserinstances', '0'),
(627, 'repository_s3', 'version', '2018051400'),
(628, 'repository_skydrive', 'version', '2018051400'),
(629, 'repository_upload', 'version', '2018051400'),
(631, 'upload', 'enablecourseinstances', '0'),
(632, 'upload', 'enableuserinstances', '0'),
(633, 'repository_url', 'version', '2018051400'),
(635, 'url', 'enablecourseinstances', '0'),
(636, 'url', 'enableuserinstances', '0'),
(637, 'repository_user', 'version', '2018051400'),
(639, 'user', 'enablecourseinstances', '0'),
(640, 'user', 'enableuserinstances', '0'),
(641, 'repository_webdav', 'version', '2018051400'),
(642, 'repository_wikimedia', 'version', '2018051400'),
(644, 'wikimedia', 'enablecourseinstances', '0'),
(645, 'wikimedia', 'enableuserinstances', '0'),
(646, 'repository_youtube', 'version', '2018051400'),
(648, 'portfolio_boxnet', 'version', '2018051400'),
(649, 'portfolio_download', 'version', '2018051400'),
(650, 'portfolio_flickr', 'version', '2018051400'),
(651, 'portfolio_googledocs', 'version', '2018051400'),
(652, 'portfolio_mahara', 'version', '2018051400'),
(653, 'portfolio_picasa', 'version', '2018051400'),
(654, 'search_simpledb', 'version', '2018051400'),
(656, 'search_solr', 'version', '2018051400'),
(657, 'qbehaviour_adaptive', 'version', '2018051400'),
(658, 'qbehaviour_adaptivenopenalty', 'version', '2018051400'),
(659, 'qbehaviour_deferredcbm', 'version', '2018051400'),
(660, 'qbehaviour_deferredfeedback', 'version', '2018051400'),
(661, 'qbehaviour_immediatecbm', 'version', '2018051400'),
(662, 'qbehaviour_immediatefeedback', 'version', '2018051400'),
(663, 'qbehaviour_informationitem', 'version', '2018051400'),
(664, 'qbehaviour_interactive', 'version', '2018051400'),
(665, 'qbehaviour_interactivecountback', 'version', '2018051400'),
(666, 'qbehaviour_manualgraded', 'version', '2018051400'),
(668, 'question', 'disabledbehaviours', 'manualgraded'),
(669, 'qbehaviour_missing', 'version', '2018051400'),
(670, 'qformat_aiken', 'version', '2018051400'),
(671, 'qformat_blackboard_six', 'version', '2018051400'),
(672, 'qformat_examview', 'version', '2018051400'),
(673, 'qformat_gift', 'version', '2018051400'),
(674, 'qformat_missingword', 'version', '2018051400'),
(675, 'qformat_multianswer', 'version', '2018051400'),
(676, 'qformat_webct', 'version', '2018051400'),
(677, 'qformat_xhtml', 'version', '2018051400'),
(678, 'qformat_xml', 'version', '2018051400'),
(679, 'tool_analytics', 'version', '2018051400'),
(680, 'tool_assignmentupgrade', 'version', '2018051400'),
(681, 'tool_availabilityconditions', 'version', '2018051400'),
(682, 'tool_behat', 'version', '2018051400'),
(683, 'tool_capability', 'version', '2018051400'),
(684, 'tool_cohortroles', 'version', '2018051400'),
(685, 'tool_customlang', 'version', '2018051400'),
(687, 'tool_dataprivacy', 'version', '2018051416'),
(688, 'message', 'airnotifier_provider_tool_dataprivacy_contactdataprotectionofficer_permitted', 'permitted'),
(689, 'message', 'email_provider_tool_dataprivacy_contactdataprotectionofficer_permitted', 'permitted'),
(690, 'message', 'jabber_provider_tool_dataprivacy_contactdataprotectionofficer_permitted', 'permitted'),
(691, 'message', 'popup_provider_tool_dataprivacy_contactdataprotectionofficer_permitted', 'permitted'),
(692, 'message', 'message_provider_tool_dataprivacy_contactdataprotectionofficer_loggedin', 'email,popup'),
(693, 'message', 'message_provider_tool_dataprivacy_contactdataprotectionofficer_loggedoff', 'email,popup'),
(694, 'message', 'airnotifier_provider_tool_dataprivacy_datarequestprocessingresults_permitted', 'permitted'),
(695, 'message', 'email_provider_tool_dataprivacy_datarequestprocessingresults_permitted', 'permitted'),
(696, 'message', 'jabber_provider_tool_dataprivacy_datarequestprocessingresults_permitted', 'permitted'),
(697, 'message', 'popup_provider_tool_dataprivacy_datarequestprocessingresults_permitted', 'permitted'),
(698, 'message', 'message_provider_tool_dataprivacy_datarequestprocessingresults_loggedin', 'email,popup'),
(699, 'message', 'message_provider_tool_dataprivacy_datarequestprocessingresults_loggedoff', 'email,popup'),
(700, 'message', 'airnotifier_provider_tool_dataprivacy_notifyexceptions_permitted', 'permitted'),
(701, 'message', 'email_provider_tool_dataprivacy_notifyexceptions_permitted', 'permitted'),
(702, 'message', 'jabber_provider_tool_dataprivacy_notifyexceptions_permitted', 'permitted'),
(703, 'message', 'popup_provider_tool_dataprivacy_notifyexceptions_permitted', 'permitted'),
(704, 'message', 'message_provider_tool_dataprivacy_notifyexceptions_loggedin', 'email'),
(705, 'message', 'message_provider_tool_dataprivacy_notifyexceptions_loggedoff', 'email'),
(706, 'tool_dbtransfer', 'version', '2018051400'),
(707, 'tool_filetypes', 'version', '2018051400'),
(708, 'tool_generator', 'version', '2018051400'),
(709, 'tool_health', 'version', '2018051400'),
(710, 'tool_httpsreplace', 'version', '2018051400'),
(711, 'tool_innodb', 'version', '2018051400'),
(712, 'tool_installaddon', 'version', '2018051400'),
(713, 'tool_langimport', 'version', '2018051400'),
(714, 'tool_log', 'version', '2018051401'),
(716, 'tool_log', 'enabled_stores', 'logstore_standard'),
(717, 'tool_lp', 'version', '2018051400'),
(718, 'tool_lpimportcsv', 'version', '2018051400'),
(719, 'tool_lpmigrate', 'version', '2018051400'),
(720, 'tool_messageinbound', 'version', '2018051400'),
(721, 'message', 'airnotifier_provider_tool_messageinbound_invalidrecipienthandler_permitted', 'permitted'),
(722, 'message', 'email_provider_tool_messageinbound_invalidrecipienthandler_permitted', 'permitted'),
(723, 'message', 'jabber_provider_tool_messageinbound_invalidrecipienthandler_permitted', 'permitted'),
(724, 'message', 'popup_provider_tool_messageinbound_invalidrecipienthandler_permitted', 'permitted'),
(725, 'message', 'message_provider_tool_messageinbound_invalidrecipienthandler_loggedin', 'email'),
(726, 'message', 'message_provider_tool_messageinbound_invalidrecipienthandler_loggedoff', 'email'),
(727, 'message', 'airnotifier_provider_tool_messageinbound_messageprocessingerror_permitted', 'permitted'),
(728, 'message', 'email_provider_tool_messageinbound_messageprocessingerror_permitted', 'permitted'),
(729, 'message', 'jabber_provider_tool_messageinbound_messageprocessingerror_permitted', 'permitted'),
(730, 'message', 'popup_provider_tool_messageinbound_messageprocessingerror_permitted', 'permitted'),
(731, 'message', 'message_provider_tool_messageinbound_messageprocessingerror_loggedin', 'email'),
(732, 'message', 'message_provider_tool_messageinbound_messageprocessingerror_loggedoff', 'email'),
(733, 'message', 'airnotifier_provider_tool_messageinbound_messageprocessingsuccess_permitted', 'permitted'),
(734, 'message', 'email_provider_tool_messageinbound_messageprocessingsuccess_permitted', 'permitted'),
(735, 'message', 'jabber_provider_tool_messageinbound_messageprocessingsuccess_permitted', 'permitted'),
(736, 'message', 'popup_provider_tool_messageinbound_messageprocessingsuccess_permitted', 'permitted'),
(737, 'message', 'message_provider_tool_messageinbound_messageprocessingsuccess_loggedin', 'email'),
(738, 'message', 'message_provider_tool_messageinbound_messageprocessingsuccess_loggedoff', 'email'),
(739, 'tool_mobile', 'version', '2018051400'),
(740, 'tool_monitor', 'version', '2018051400'),
(741, 'message', 'airnotifier_provider_tool_monitor_notification_permitted', 'permitted'),
(742, 'message', 'email_provider_tool_monitor_notification_permitted', 'permitted'),
(743, 'message', 'jabber_provider_tool_monitor_notification_permitted', 'permitted'),
(744, 'message', 'popup_provider_tool_monitor_notification_permitted', 'permitted'),
(745, 'message', 'message_provider_tool_monitor_notification_loggedin', 'email'),
(746, 'message', 'message_provider_tool_monitor_notification_loggedoff', 'email'),
(747, 'tool_multilangupgrade', 'version', '2018051400'),
(748, 'tool_oauth2', 'version', '2018051400'),
(749, 'tool_phpunit', 'version', '2018051400'),
(750, 'tool_policy', 'version', '2018051400'),
(751, 'tool_profiling', 'version', '2018051400'),
(752, 'tool_recyclebin', 'version', '2018051400'),
(753, 'tool_replace', 'version', '2018051400'),
(754, 'tool_spamcleaner', 'version', '2018051400'),
(755, 'tool_task', 'version', '2018051400'),
(756, 'tool_templatelibrary', 'version', '2018051400'),
(757, 'tool_unsuproles', 'version', '2018051400'),
(759, 'tool_uploadcourse', 'version', '2018051400'),
(760, 'tool_uploaduser', 'version', '2018051400'),
(761, 'tool_usertours', 'version', '2018051400'),
(763, 'tool_xmldb', 'version', '2018051400'),
(764, 'cachestore_apcu', 'version', '2018051400'),
(765, 'cachestore_file', 'version', '2018051400'),
(766, 'cachestore_memcache', 'version', '2018051400'),
(767, 'cachestore_memcached', 'version', '2018051400'),
(768, 'cachestore_mongodb', 'version', '2018051400'),
(769, 'cachestore_redis', 'version', '2018051400'),
(770, 'cachestore_session', 'version', '2018051400'),
(771, 'cachestore_static', 'version', '2018051400'),
(772, 'cachelock_file', 'version', '2018051400'),
(773, 'fileconverter_googledrive', 'version', '2018051400'),
(774, 'fileconverter_unoconv', 'version', '2018051400'),
(776, 'theme_boost', 'version', '2018051400'),
(777, 'theme_bootstrapbase', 'version', '2018051400'),
(778, 'theme_clean', 'version', '2018051400'),
(779, 'theme_more', 'version', '2018051400'),
(781, 'assignsubmission_comments', 'version', '2018051400'),
(783, 'assignsubmission_file', 'sortorder', '1'),
(784, 'assignsubmission_comments', 'sortorder', '2'),
(785, 'assignsubmission_onlinetext', 'sortorder', '0'),
(786, 'assignsubmission_file', 'version', '2018051400'),
(787, 'assignsubmission_onlinetext', 'version', '2018051400'),
(789, 'assignfeedback_comments', 'version', '2018051400'),
(791, 'assignfeedback_comments', 'sortorder', '0'),
(792, 'assignfeedback_editpdf', 'sortorder', '1'),
(793, 'assignfeedback_file', 'sortorder', '3'),
(794, 'assignfeedback_offline', 'sortorder', '2'),
(795, 'assignfeedback_editpdf', 'version', '2018051401'),
(797, 'assignfeedback_file', 'version', '2018051400'),
(799, 'assignfeedback_offline', 'version', '2018051400'),
(800, 'assignment_offline', 'version', '2018051400'),
(801, 'assignment_online', 'version', '2018051400'),
(802, 'assignment_upload', 'version', '2018051400'),
(803, 'assignment_uploadsingle', 'version', '2018051400'),
(804, 'booktool_exportimscp', 'version', '2018051400'),
(805, 'booktool_importhtml', 'version', '2018051400'),
(806, 'booktool_print', 'version', '2018051400'),
(807, 'datafield_checkbox', 'version', '2018051400'),
(808, 'datafield_date', 'version', '2018051400'),
(809, 'datafield_file', 'version', '2018051400'),
(810, 'datafield_latlong', 'version', '2018051400'),
(811, 'datafield_menu', 'version', '2018051400'),
(812, 'datafield_multimenu', 'version', '2018051400'),
(813, 'datafield_number', 'version', '2018051400'),
(814, 'datafield_picture', 'version', '2018051400'),
(815, 'datafield_radiobutton', 'version', '2018051400'),
(816, 'datafield_text', 'version', '2018051400'),
(817, 'datafield_textarea', 'version', '2018051400'),
(818, 'datafield_url', 'version', '2018051400'),
(819, 'datapreset_imagegallery', 'version', '2018051400'),
(820, 'ltiservice_gradebookservices', 'version', '2018051400'),
(821, 'ltiservice_memberships', 'version', '2018051400'),
(822, 'ltiservice_profile', 'version', '2018051400'),
(823, 'ltiservice_toolproxy', 'version', '2018051400'),
(824, 'ltiservice_toolsettings', 'version', '2018051400'),
(825, 'quiz_grading', 'version', '2018051400'),
(827, 'quiz_overview', 'version', '2018061801'),
(829, 'quiz_responses', 'version', '2018051400'),
(831, 'quiz_statistics', 'version', '2018051400'),
(833, 'quizaccess_delaybetweenattempts', 'version', '2018051400'),
(834, 'quizaccess_ipaddress', 'version', '2018051400'),
(835, 'quizaccess_numattempts', 'version', '2018051400'),
(836, 'quizaccess_offlineattempts', 'version', '2018051400'),
(837, 'quizaccess_openclosedate', 'version', '2018051400'),
(838, 'quizaccess_password', 'version', '2018051400'),
(839, 'quizaccess_safebrowser', 'version', '2018051400'),
(840, 'quizaccess_securewindow', 'version', '2018051400'),
(841, 'quizaccess_timelimit', 'version', '2018051400'),
(842, 'scormreport_basic', 'version', '2018051400'),
(843, 'scormreport_graphs', 'version', '2018051400'),
(844, 'scormreport_interactions', 'version', '2018051400'),
(845, 'scormreport_objectives', 'version', '2018051400'),
(846, 'workshopform_accumulative', 'version', '2018051400'),
(848, 'workshopform_comments', 'version', '2018051400'),
(850, 'workshopform_numerrors', 'version', '2018051400'),
(852, 'workshopform_rubric', 'version', '2018051400'),
(854, 'workshopallocation_manual', 'version', '2018051400'),
(855, 'workshopallocation_random', 'version', '2018051400'),
(856, 'workshopallocation_scheduled', 'version', '2018051400'),
(857, 'workshopeval_best', 'version', '2018051400'),
(858, 'atto_accessibilitychecker', 'version', '2018051400'),
(859, 'atto_accessibilityhelper', 'version', '2018051400'),
(860, 'atto_align', 'version', '2018051400'),
(861, 'atto_backcolor', 'version', '2018051400'),
(862, 'atto_bold', 'version', '2018051400'),
(863, 'atto_charmap', 'version', '2018051400'),
(864, 'atto_clear', 'version', '2018051400'),
(865, 'atto_collapse', 'version', '2018051400'),
(866, 'atto_emoticon', 'version', '2018051400'),
(867, 'atto_equation', 'version', '2018051400'),
(868, 'atto_fontcolor', 'version', '2018051400'),
(869, 'atto_html', 'version', '2018051400'),
(870, 'atto_image', 'version', '2018051400'),
(871, 'atto_indent', 'version', '2018051400'),
(872, 'atto_italic', 'version', '2018051400'),
(873, 'atto_link', 'version', '2018051400'),
(874, 'atto_managefiles', 'version', '2018051400'),
(875, 'atto_media', 'version', '2018051400'),
(876, 'atto_noautolink', 'version', '2018051400'),
(877, 'atto_orderedlist', 'version', '2018051400'),
(878, 'atto_recordrtc', 'version', '2018051400'),
(879, 'atto_rtl', 'version', '2018051400'),
(880, 'atto_strike', 'version', '2018051400'),
(881, 'atto_subscript', 'version', '2018051400'),
(882, 'atto_superscript', 'version', '2018051400'),
(883, 'atto_table', 'version', '2018051400'),
(884, 'atto_title', 'version', '2018051400'),
(885, 'atto_underline', 'version', '2018051400'),
(886, 'atto_undo', 'version', '2018051400'),
(887, 'atto_unorderedlist', 'version', '2018051400'),
(888, 'tinymce_ctrlhelp', 'version', '2018051400'),
(889, 'tinymce_managefiles', 'version', '2018051400'),
(890, 'tinymce_moodleemoticon', 'version', '2018051400'),
(891, 'tinymce_moodleimage', 'version', '2018051400'),
(892, 'tinymce_moodlemedia', 'version', '2018051400'),
(893, 'tinymce_moodlenolink', 'version', '2018051400'),
(894, 'tinymce_pdw', 'version', '2018051400'),
(895, 'tinymce_spellchecker', 'version', '2018051400'),
(897, 'tinymce_wrap', 'version', '2018051400'),
(898, 'logstore_database', 'version', '2018051400'),
(899, 'logstore_legacy', 'version', '2018051400'),
(900, 'logstore_standard', 'version', '2018051400'),
(901, 'tool_dataprivacy', 'contactdataprotectionofficer', '0'),
(902, 'tool_dataprivacy', 'automaticdeletionrequests', '0'),
(903, 'tool_dataprivacy', 'privacyrequestexpiry', '604800'),
(904, 'tool_dataprivacy', 'requireallenddatesforuserdeletion', '1'),
(905, 'tool_dataprivacy', 'showdataretentionsummary', '1'),
(906, 'tool_log', 'exportlog', '1'),
(907, 'analytics', 'logstore', 'logstore_standard'),
(908, 'assign', 'feedback_plugin_for_gradebook', 'assignfeedback_comments'),
(909, 'assign', 'showrecentsubmissions', '0'),
(910, 'assign', 'submissionreceipts', '1'),
(911, 'assign', 'submissionstatement', 'This assignment is my own work, except where I have acknowledged the use of the works of other people.'),
(912, 'assign', 'maxperpage', '-1'),
(913, 'assign', 'alwaysshowdescription', '1'),
(914, 'assign', 'alwaysshowdescription_adv', ''),
(915, 'assign', 'alwaysshowdescription_locked', ''),
(916, 'assign', 'allowsubmissionsfromdate', '0'),
(917, 'assign', 'allowsubmissionsfromdate_enabled', '1'),
(918, 'assign', 'allowsubmissionsfromdate_adv', ''),
(919, 'assign', 'duedate', '604800'),
(920, 'assign', 'duedate_enabled', '1'),
(921, 'assign', 'duedate_adv', ''),
(922, 'assign', 'cutoffdate', '1209600'),
(923, 'assign', 'cutoffdate_enabled', ''),
(924, 'assign', 'cutoffdate_adv', ''),
(925, 'assign', 'gradingduedate', '1209600'),
(926, 'assign', 'gradingduedate_enabled', '1'),
(927, 'assign', 'gradingduedate_adv', '');
INSERT INTO `[[dbprefix]]config_plugins` VALUES
(928, 'assign', 'submissiondrafts', '0'),
(929, 'assign', 'submissiondrafts_adv', ''),
(930, 'assign', 'submissiondrafts_locked', ''),
(931, 'assign', 'requiresubmissionstatement', '0'),
(932, 'assign', 'requiresubmissionstatement_adv', ''),
(933, 'assign', 'requiresubmissionstatement_locked', ''),
(934, 'assign', 'attemptreopenmethod', 'none'),
(935, 'assign', 'attemptreopenmethod_adv', ''),
(936, 'assign', 'attemptreopenmethod_locked', ''),
(937, 'assign', 'maxattempts', '-1'),
(938, 'assign', 'maxattempts_adv', ''),
(939, 'assign', 'maxattempts_locked', ''),
(940, 'assign', 'teamsubmission', '0'),
(941, 'assign', 'teamsubmission_adv', ''),
(942, 'assign', 'teamsubmission_locked', ''),
(943, 'assign', 'preventsubmissionnotingroup', '0'),
(944, 'assign', 'preventsubmissionnotingroup_adv', ''),
(945, 'assign', 'preventsubmissionnotingroup_locked', ''),
(946, 'assign', 'requireallteammemberssubmit', '0'),
(947, 'assign', 'requireallteammemberssubmit_adv', ''),
(948, 'assign', 'requireallteammemberssubmit_locked', ''),
(949, 'assign', 'teamsubmissiongroupingid', ''),
(950, 'assign', 'teamsubmissiongroupingid_adv', ''),
(951, 'assign', 'sendnotifications', '0'),
(952, 'assign', 'sendnotifications_adv', ''),
(953, 'assign', 'sendnotifications_locked', ''),
(954, 'assign', 'sendlatenotifications', '0'),
(955, 'assign', 'sendlatenotifications_adv', ''),
(956, 'assign', 'sendlatenotifications_locked', ''),
(957, 'assign', 'sendstudentnotifications', '1'),
(958, 'assign', 'sendstudentnotifications_adv', ''),
(959, 'assign', 'sendstudentnotifications_locked', ''),
(960, 'assign', 'blindmarking', '0'),
(961, 'assign', 'blindmarking_adv', ''),
(962, 'assign', 'blindmarking_locked', ''),
(963, 'assign', 'markingworkflow', '0'),
(964, 'assign', 'markingworkflow_adv', ''),
(965, 'assign', 'markingworkflow_locked', ''),
(966, 'assign', 'markingallocation', '0'),
(967, 'assign', 'markingallocation_adv', ''),
(968, 'assign', 'markingallocation_locked', ''),
(969, 'assignsubmission_file', 'default', '1'),
(970, 'assignsubmission_file', 'maxfiles', '20'),
(971, 'assignsubmission_file', 'filetypes', ''),
(972, 'assignsubmission_file', 'maxbytes', '0'),
(973, 'assignsubmission_onlinetext', 'default', '0'),
(974, 'assignfeedback_comments', 'default', '1'),
(975, 'assignfeedback_comments', 'inline', '0'),
(976, 'assignfeedback_comments', 'inline_adv', ''),
(977, 'assignfeedback_comments', 'inline_locked', ''),
(978, 'assignfeedback_editpdf', 'default', '1'),
(979, 'assignfeedback_editpdf', 'stamps', ''),
(980, 'assignfeedback_file', 'default', '0'),
(981, 'assignfeedback_offline', 'default', '0'),
(982, 'book', 'numberingoptions', '0,1,2,3'),
(983, 'book', 'navoptions', '0,1,2'),
(984, 'book', 'numbering', '1'),
(985, 'book', 'navstyle', '1'),
(986, 'resource', 'framesize', '130'),
(987, 'resource', 'displayoptions', '0,1,4,5,6'),
(988, 'resource', 'printintro', '1'),
(989, 'resource', 'display', '0'),
(990, 'resource', 'showsize', '0'),
(991, 'resource', 'showtype', '0'),
(992, 'resource', 'showdate', '0'),
(993, 'resource', 'popupwidth', '620'),
(994, 'resource', 'popupheight', '450'),
(995, 'resource', 'filterfiles', '0'),
(996, 'folder', 'showexpanded', '1'),
(997, 'folder', 'maxsizetodownload', '0'),
(998, 'imscp', 'keepold', '1'),
(999, 'imscp', 'keepold_adv', ''),
(1000, 'label', 'dndmedia', '1'),
(1001, 'label', 'dndresizewidth', '400'),
(1002, 'label', 'dndresizeheight', '400'),
(1003, 'mod_lesson', 'mediafile', ''),
(1004, 'mod_lesson', 'mediafile_adv', '1'),
(1005, 'mod_lesson', 'mediawidth', '640'),
(1006, 'mod_lesson', 'mediaheight', '480'),
(1007, 'mod_lesson', 'mediaclose', '0'),
(1008, 'mod_lesson', 'progressbar', '0'),
(1009, 'mod_lesson', 'progressbar_adv', ''),
(1010, 'mod_lesson', 'ongoing', '0'),
(1011, 'mod_lesson', 'ongoing_adv', '1'),
(1012, 'mod_lesson', 'displayleftmenu', '0'),
(1013, 'mod_lesson', 'displayleftmenu_adv', ''),
(1014, 'mod_lesson', 'displayleftif', '0'),
(1015, 'mod_lesson', 'displayleftif_adv', '1'),
(1016, 'mod_lesson', 'slideshow', '0'),
(1017, 'mod_lesson', 'slideshow_adv', '1'),
(1018, 'mod_lesson', 'slideshowwidth', '640'),
(1019, 'mod_lesson', 'slideshowheight', '480'),
(1020, 'mod_lesson', 'slideshowbgcolor', '#FFFFFF'),
(1021, 'mod_lesson', 'maxanswers', '5'),
(1022, 'mod_lesson', 'maxanswers_adv', '1'),
(1023, 'mod_lesson', 'defaultfeedback', '0'),
(1024, 'mod_lesson', 'defaultfeedback_adv', '1'),
(1025, 'mod_lesson', 'activitylink', ''),
(1026, 'mod_lesson', 'activitylink_adv', '1'),
(1027, 'mod_lesson', 'timelimit', '0'),
(1028, 'mod_lesson', 'timelimit_adv', ''),
(1029, 'mod_lesson', 'password', '0'),
(1030, 'mod_lesson', 'password_adv', '1'),
(1031, 'mod_lesson', 'modattempts', '0'),
(1032, 'mod_lesson', 'modattempts_adv', ''),
(1033, 'mod_lesson', 'displayreview', '0'),
(1034, 'mod_lesson', 'displayreview_adv', ''),
(1035, 'mod_lesson', 'maximumnumberofattempts', '1'),
(1036, 'mod_lesson', 'maximumnumberofattempts_adv', ''),
(1037, 'mod_lesson', 'defaultnextpage', '0'),
(1038, 'mod_lesson', 'defaultnextpage_adv', '1'),
(1039, 'mod_lesson', 'numberofpagestoshow', '1'),
(1040, 'mod_lesson', 'numberofpagestoshow_adv', '1'),
(1041, 'mod_lesson', 'practice', '0'),
(1042, 'mod_lesson', 'practice_adv', ''),
(1043, 'mod_lesson', 'customscoring', '1'),
(1044, 'mod_lesson', 'customscoring_adv', '1'),
(1045, 'mod_lesson', 'retakesallowed', '0'),
(1046, 'mod_lesson', 'retakesallowed_adv', ''),
(1047, 'mod_lesson', 'handlingofretakes', '0'),
(1048, 'mod_lesson', 'handlingofretakes_adv', '1'),
(1049, 'mod_lesson', 'minimumnumberofquestions', '0'),
(1050, 'mod_lesson', 'minimumnumberofquestions_adv', '1'),
(1051, 'page', 'displayoptions', '5'),
(1052, 'page', 'printheading', '1'),
(1053, 'page', 'printintro', '0'),
(1054, 'page', 'display', '5'),
(1055, 'page', 'popupwidth', '620'),
(1056, 'page', 'popupheight', '450'),
(1057, 'quiz', 'timelimit', '0'),
(1058, 'quiz', 'timelimit_adv', ''),
(1059, 'quiz', 'overduehandling', 'autosubmit'),
(1060, 'quiz', 'overduehandling_adv', ''),
(1061, 'quiz', 'graceperiod', '86400'),
(1062, 'quiz', 'graceperiod_adv', ''),
(1063, 'quiz', 'graceperiodmin', '60'),
(1064, 'quiz', 'attempts', '0'),
(1065, 'quiz', 'attempts_adv', ''),
(1066, 'quiz', 'grademethod', '1'),
(1067, 'quiz', 'grademethod_adv', ''),
(1068, 'quiz', 'maximumgrade', '10'),
(1069, 'quiz', 'questionsperpage', '1'),
(1070, 'quiz', 'questionsperpage_adv', ''),
(1071, 'quiz', 'navmethod', 'free'),
(1072, 'quiz', 'navmethod_adv', '1'),
(1073, 'quiz', 'shuffleanswers', '1'),
(1074, 'quiz', 'shuffleanswers_adv', ''),
(1075, 'quiz', 'preferredbehaviour', 'deferredfeedback'),
(1076, 'quiz', 'canredoquestions', '0'),
(1077, 'quiz', 'canredoquestions_adv', '1'),
(1078, 'quiz', 'attemptonlast', '0'),
(1079, 'quiz', 'attemptonlast_adv', '1'),
(1080, 'quiz', 'reviewattempt', '69904'),
(1081, 'quiz', 'reviewcorrectness', '69904'),
(1082, 'quiz', 'reviewmarks', '69904'),
(1083, 'quiz', 'reviewspecificfeedback', '69904'),
(1084, 'quiz', 'reviewgeneralfeedback', '69904'),
(1085, 'quiz', 'reviewrightanswer', '69904'),
(1086, 'quiz', 'reviewoverallfeedback', '4368'),
(1087, 'quiz', 'showuserpicture', '0'),
(1088, 'quiz', 'showuserpicture_adv', ''),
(1089, 'quiz', 'decimalpoints', '2'),
(1090, 'quiz', 'decimalpoints_adv', ''),
(1091, 'quiz', 'questiondecimalpoints', '-1'),
(1092, 'quiz', 'questiondecimalpoints_adv', '1'),
(1093, 'quiz', 'showblocks', '0'),
(1094, 'quiz', 'showblocks_adv', '1'),
(1095, 'quiz', 'password', ''),
(1096, 'quiz', 'password_adv', ''),
(1097, 'quiz', 'subnet', ''),
(1098, 'quiz', 'subnet_adv', '1'),
(1099, 'quiz', 'delay1', '0'),
(1100, 'quiz', 'delay1_adv', '1'),
(1101, 'quiz', 'delay2', '0'),
(1102, 'quiz', 'delay2_adv', '1'),
(1103, 'quiz', 'browsersecurity', '-'),
(1104, 'quiz', 'browsersecurity_adv', '1'),
(1105, 'quiz', 'initialnumfeedbacks', '2'),
(1106, 'quiz', 'autosaveperiod', '60'),
(1107, 'scorm', 'displaycoursestructure', '0'),
(1108, 'scorm', 'displaycoursestructure_adv', ''),
(1109, 'scorm', 'popup', '0'),
(1110, 'scorm', 'popup_adv', ''),
(1111, 'scorm', 'displayactivityname', '1'),
(1112, 'scorm', 'framewidth', '100'),
(1113, 'scorm', 'framewidth_adv', '1'),
(1114, 'scorm', 'frameheight', '500'),
(1115, 'scorm', 'frameheight_adv', '1'),
(1116, 'scorm', 'winoptgrp_adv', '1'),
(1117, 'scorm', 'scrollbars', '0'),
(1118, 'scorm', 'directories', '0'),
(1119, 'scorm', 'location', '0'),
(1120, 'scorm', 'menubar', '0'),
(1121, 'scorm', 'toolbar', '0'),
(1122, 'scorm', 'status', '0'),
(1123, 'scorm', 'skipview', '0'),
(1124, 'scorm', 'skipview_adv', '1'),
(1125, 'scorm', 'hidebrowse', '0'),
(1126, 'scorm', 'hidebrowse_adv', '1'),
(1127, 'scorm', 'hidetoc', '0'),
(1128, 'scorm', 'hidetoc_adv', '1'),
(1129, 'scorm', 'nav', '1'),
(1130, 'scorm', 'nav_adv', '1'),
(1131, 'scorm', 'navpositionleft', '-100'),
(1132, 'scorm', 'navpositionleft_adv', '1'),
(1133, 'scorm', 'navpositiontop', '-100'),
(1134, 'scorm', 'navpositiontop_adv', '1'),
(1135, 'scorm', 'collapsetocwinsize', '767'),
(1136, 'scorm', 'collapsetocwinsize_adv', '1'),
(1137, 'scorm', 'displayattemptstatus', '1'),
(1138, 'scorm', 'displayattemptstatus_adv', ''),
(1139, 'scorm', 'grademethod', '1'),
(1140, 'scorm', 'maxgrade', '100'),
(1141, 'scorm', 'maxattempt', '0'),
(1142, 'scorm', 'whatgrade', '0'),
(1143, 'scorm', 'forcecompleted', '0'),
(1144, 'scorm', 'forcenewattempt', '0'),
(1145, 'scorm', 'autocommit', '0'),
(1146, 'scorm', 'masteryoverride', '1'),
(1147, 'scorm', 'lastattemptlock', '0'),
(1148, 'scorm', 'auto', '0'),
(1149, 'scorm', 'updatefreq', '0'),
(1150, 'scorm', 'scormstandard', '0'),
(1151, 'scorm', 'allowtypeexternal', '0'),
(1152, 'scorm', 'allowtypelocalsync', '0'),
(1153, 'scorm', 'allowtypeexternalaicc', '0'),
(1154, 'scorm', 'allowaicchacp', '0'),
(1155, 'scorm', 'aicchacptimeout', '30'),
(1156, 'scorm', 'aicchacpkeepsessiondata', '1'),
(1157, 'scorm', 'aiccuserid', '1'),
(1158, 'scorm', 'forcejavascript', '1'),
(1159, 'scorm', 'allowapidebug', '0'),
(1160, 'scorm', 'apidebugmask', '.*'),
(1161, 'scorm', 'protectpackagedownloads', '0'),
(1162, 'url', 'framesize', '130'),
(1163, 'url', 'secretphrase', ''),
(1164, 'url', 'rolesinparams', '0'),
(1165, 'url', 'displayoptions', '0,1,5,6'),
(1166, 'url', 'printintro', '1'),
(1167, 'url', 'display', '0'),
(1168, 'url', 'popupwidth', '620'),
(1169, 'url', 'popupheight', '450'),
(1170, 'workshop', 'grade', '80'),
(1171, 'workshop', 'gradinggrade', '20'),
(1172, 'workshop', 'gradedecimals', '0'),
(1173, 'workshop', 'maxbytes', '0'),
(1174, 'workshop', 'strategy', 'accumulative'),
(1175, 'workshop', 'examplesmode', '0'),
(1176, 'workshopallocation_random', 'numofreviews', '5'),
(1177, 'workshopform_numerrors', 'grade0', 'No'),
(1178, 'workshopform_numerrors', 'grade1', 'Yes'),
(1179, 'workshopeval_best', 'comparison', '5'),
(1180, 'tool_recyclebin', 'coursebinenable', '1'),
(1181, 'tool_recyclebin', 'coursebinexpiry', '604800'),
(1182, 'tool_recyclebin', 'categorybinenable', '1'),
(1183, 'tool_recyclebin', 'categorybinexpiry', '604800'),
(1184, 'tool_recyclebin', 'autohide', '1'),
(1185, 'antivirus_clamav', 'runningmethod', 'commandline'),
(1186, 'antivirus_clamav', 'pathtoclam', ''),
(1187, 'antivirus_clamav', 'pathtounixsocket', ''),
(1188, 'antivirus_clamav', 'clamfailureonupload', 'donothing'),
(1189, 'auth_cas', 'hostname', ''),
(1190, 'auth_cas', 'baseuri', ''),
(1191, 'auth_cas', 'port', '0'),
(1192, 'auth_cas', 'casversion', '2.0'),
(1193, 'auth_cas', 'language', 'CAS_Languages_English'),
(1194, 'auth_cas', 'proxycas', '0'),
(1195, 'auth_cas', 'logoutcas', '0'),
(1196, 'auth_cas', 'multiauth', '0'),
(1197, 'auth_cas', 'certificate_check', '0'),
(1198, 'auth_cas', 'certificate_path', ''),
(1199, 'auth_cas', 'curl_ssl_version', ''),
(1200, 'auth_cas', 'logout_return_url', ''),
(1201, 'auth_cas', 'host_url', ''),
(1202, 'auth_cas', 'ldap_version', '3'),
(1203, 'auth_cas', 'start_tls', '0'),
(1204, 'auth_cas', 'ldapencoding', 'utf-8'),
(1205, 'auth_cas', 'pagesize', '250'),
(1206, 'auth_cas', 'bind_dn', ''),
(1207, 'auth_cas', 'bind_pw', ''),
(1208, 'auth_cas', 'user_type', 'default'),
(1209, 'auth_cas', 'contexts', ''),
(1210, 'auth_cas', 'search_sub', '0'),
(1211, 'auth_cas', 'opt_deref', '0'),
(1212, 'auth_cas', 'user_attribute', ''),
(1213, 'auth_cas', 'memberattribute', ''),
(1214, 'auth_cas', 'memberattribute_isdn', ''),
(1215, 'auth_cas', 'objectclass', ''),
(1216, 'auth_cas', 'attrcreators', ''),
(1217, 'auth_cas', 'groupecreators', ''),
(1218, 'auth_cas', 'removeuser', '0'),
(1219, 'auth_cas', 'field_map_firstname', ''),
(1220, 'auth_cas', 'field_updatelocal_firstname', 'oncreate'),
(1221, 'auth_cas', 'field_updateremote_firstname', '0'),
(1222, 'auth_cas', 'field_lock_firstname', 'unlocked'),
(1223, 'auth_cas', 'field_map_lastname', ''),
(1224, 'auth_cas', 'field_updatelocal_lastname', 'oncreate'),
(1225, 'auth_cas', 'field_updateremote_lastname', '0'),
(1226, 'auth_cas', 'field_lock_lastname', 'unlocked'),
(1227, 'auth_cas', 'field_map_email', ''),
(1228, 'auth_cas', 'field_updatelocal_email', 'oncreate'),
(1229, 'auth_cas', 'field_updateremote_email', '0'),
(1230, 'auth_cas', 'field_lock_email', 'unlocked'),
(1231, 'auth_cas', 'field_map_city', ''),
(1232, 'auth_cas', 'field_updatelocal_city', 'oncreate'),
(1233, 'auth_cas', 'field_updateremote_city', '0'),
(1234, 'auth_cas', 'field_lock_city', 'unlocked'),
(1235, 'auth_cas', 'field_map_country', ''),
(1236, 'auth_cas', 'field_updatelocal_country', 'oncreate'),
(1237, 'auth_cas', 'field_updateremote_country', '0'),
(1238, 'auth_cas', 'field_lock_country', 'unlocked'),
(1239, 'auth_cas', 'field_map_lang', ''),
(1240, 'auth_cas', 'field_updatelocal_lang', 'oncreate'),
(1241, 'auth_cas', 'field_updateremote_lang', '0'),
(1242, 'auth_cas', 'field_lock_lang', 'unlocked'),
(1243, 'auth_cas', 'field_map_description', ''),
(1244, 'auth_cas', 'field_updatelocal_description', 'oncreate'),
(1245, 'auth_cas', 'field_updateremote_description', '0'),
(1246, 'auth_cas', 'field_lock_description', 'unlocked'),
(1247, 'auth_cas', 'field_map_url', ''),
(1248, 'auth_cas', 'field_updatelocal_url', 'oncreate'),
(1249, 'auth_cas', 'field_updateremote_url', '0'),
(1250, 'auth_cas', 'field_lock_url', 'unlocked'),
(1251, 'auth_cas', 'field_map_idnumber', ''),
(1252, 'auth_cas', 'field_updatelocal_idnumber', 'oncreate'),
(1253, 'auth_cas', 'field_updateremote_idnumber', '0'),
(1254, 'auth_cas', 'field_lock_idnumber', 'unlocked'),
(1255, 'auth_cas', 'field_map_institution', ''),
(1256, 'auth_cas', 'field_updatelocal_institution', 'oncreate'),
(1257, 'auth_cas', 'field_updateremote_institution', '0'),
(1258, 'auth_cas', 'field_lock_institution', 'unlocked'),
(1259, 'auth_cas', 'field_map_department', ''),
(1260, 'auth_cas', 'field_updatelocal_department', 'oncreate'),
(1261, 'auth_cas', 'field_updateremote_department', '0'),
(1262, 'auth_cas', 'field_lock_department', 'unlocked'),
(1263, 'auth_cas', 'field_map_phone1', ''),
(1264, 'auth_cas', 'field_updatelocal_phone1', 'oncreate'),
(1265, 'auth_cas', 'field_updateremote_phone1', '0'),
(1266, 'auth_cas', 'field_lock_phone1', 'unlocked'),
(1267, 'auth_cas', 'field_map_phone2', ''),
(1268, 'auth_cas', 'field_updatelocal_phone2', 'oncreate'),
(1269, 'auth_cas', 'field_updateremote_phone2', '0'),
(1270, 'auth_cas', 'field_lock_phone2', 'unlocked'),
(1271, 'auth_cas', 'field_map_address', ''),
(1272, 'auth_cas', 'field_updatelocal_address', 'oncreate'),
(1273, 'auth_cas', 'field_updateremote_address', '0'),
(1274, 'auth_cas', 'field_lock_address', 'unlocked'),
(1275, 'auth_cas', 'field_map_firstnamephonetic', ''),
(1276, 'auth_cas', 'field_updatelocal_firstnamephonetic', 'oncreate'),
(1277, 'auth_cas', 'field_updateremote_firstnamephonetic', '0'),
(1278, 'auth_cas', 'field_lock_firstnamephonetic', 'unlocked'),
(1279, 'auth_cas', 'field_map_lastnamephonetic', ''),
(1280, 'auth_cas', 'field_updatelocal_lastnamephonetic', 'oncreate'),
(1281, 'auth_cas', 'field_updateremote_lastnamephonetic', '0'),
(1282, 'auth_cas', 'field_lock_lastnamephonetic', 'unlocked'),
(1283, 'auth_cas', 'field_map_middlename', ''),
(1284, 'auth_cas', 'field_updatelocal_middlename', 'oncreate'),
(1285, 'auth_cas', 'field_updateremote_middlename', '0'),
(1286, 'auth_cas', 'field_lock_middlename', 'unlocked'),
(1287, 'auth_cas', 'field_map_alternatename', ''),
(1288, 'auth_cas', 'field_updatelocal_alternatename', 'oncreate'),
(1289, 'auth_cas', 'field_updateremote_alternatename', '0'),
(1290, 'auth_cas', 'field_lock_alternatename', 'unlocked'),
(1291, 'auth_email', 'recaptcha', '0'),
(1292, 'auth_email', 'field_lock_firstname', 'unlocked'),
(1293, 'auth_email', 'field_lock_lastname', 'unlocked'),
(1294, 'auth_email', 'field_lock_email', 'unlocked'),
(1295, 'auth_email', 'field_lock_city', 'unlocked'),
(1296, 'auth_email', 'field_lock_country', 'unlocked'),
(1297, 'auth_email', 'field_lock_lang', 'unlocked'),
(1298, 'auth_email', 'field_lock_description', 'unlocked'),
(1299, 'auth_email', 'field_lock_url', 'unlocked'),
(1300, 'auth_email', 'field_lock_idnumber', 'unlocked'),
(1301, 'auth_email', 'field_lock_institution', 'unlocked'),
(1302, 'auth_email', 'field_lock_department', 'unlocked'),
(1303, 'auth_email', 'field_lock_phone1', 'unlocked'),
(1304, 'auth_email', 'field_lock_phone2', 'unlocked'),
(1305, 'auth_email', 'field_lock_address', 'unlocked'),
(1306, 'auth_email', 'field_lock_firstnamephonetic', 'unlocked'),
(1307, 'auth_email', 'field_lock_lastnamephonetic', 'unlocked'),
(1308, 'auth_email', 'field_lock_middlename', 'unlocked'),
(1309, 'auth_email', 'field_lock_alternatename', 'unlocked'),
(1310, 'auth_db', 'host', '127.0.0.1'),
(1311, 'auth_db', 'type', 'mysqli'),
(1312, 'auth_db', 'sybasequoting', '0'),
(1313, 'auth_db', 'name', ''),
(1314, 'auth_db', 'user', ''),
(1315, 'auth_db', 'pass', ''),
(1316, 'auth_db', 'table', ''),
(1317, 'auth_db', 'fielduser', ''),
(1318, 'auth_db', 'fieldpass', ''),
(1319, 'auth_db', 'passtype', 'plaintext'),
(1320, 'auth_db', 'extencoding', 'utf-8'),
(1321, 'auth_db', 'setupsql', ''),
(1322, 'auth_db', 'debugauthdb', '0'),
(1323, 'auth_db', 'changepasswordurl', ''),
(1324, 'auth_db', 'removeuser', '0'),
(1325, 'auth_db', 'updateusers', '0'),
(1326, 'auth_db', 'field_map_firstname', ''),
(1327, 'auth_db', 'field_updatelocal_firstname', 'oncreate'),
(1328, 'auth_db', 'field_updateremote_firstname', '0'),
(1329, 'auth_db', 'field_lock_firstname', 'unlocked'),
(1330, 'auth_db', 'field_map_lastname', ''),
(1331, 'auth_db', 'field_updatelocal_lastname', 'oncreate'),
(1332, 'auth_db', 'field_updateremote_lastname', '0'),
(1333, 'auth_db', 'field_lock_lastname', 'unlocked'),
(1334, 'auth_db', 'field_map_email', ''),
(1335, 'auth_db', 'field_updatelocal_email', 'oncreate'),
(1336, 'auth_db', 'field_updateremote_email', '0'),
(1337, 'auth_db', 'field_lock_email', 'unlocked'),
(1338, 'auth_db', 'field_map_city', ''),
(1339, 'auth_db', 'field_updatelocal_city', 'oncreate'),
(1340, 'auth_db', 'field_updateremote_city', '0'),
(1341, 'auth_db', 'field_lock_city', 'unlocked'),
(1342, 'auth_db', 'field_map_country', ''),
(1343, 'auth_db', 'field_updatelocal_country', 'oncreate'),
(1344, 'auth_db', 'field_updateremote_country', '0'),
(1345, 'auth_db', 'field_lock_country', 'unlocked'),
(1346, 'auth_db', 'field_map_lang', ''),
(1347, 'auth_db', 'field_updatelocal_lang', 'oncreate'),
(1348, 'auth_db', 'field_updateremote_lang', '0'),
(1349, 'auth_db', 'field_lock_lang', 'unlocked'),
(1350, 'auth_db', 'field_map_description', ''),
(1351, 'auth_db', 'field_updatelocal_description', 'oncreate'),
(1352, 'auth_db', 'field_updateremote_description', '0'),
(1353, 'auth_db', 'field_lock_description', 'unlocked'),
(1354, 'auth_db', 'field_map_url', ''),
(1355, 'auth_db', 'field_updatelocal_url', 'oncreate'),
(1356, 'auth_db', 'field_updateremote_url', '0'),
(1357, 'auth_db', 'field_lock_url', 'unlocked'),
(1358, 'auth_db', 'field_map_idnumber', ''),
(1359, 'auth_db', 'field_updatelocal_idnumber', 'oncreate'),
(1360, 'auth_db', 'field_updateremote_idnumber', '0'),
(1361, 'auth_db', 'field_lock_idnumber', 'unlocked'),
(1362, 'auth_db', 'field_map_institution', ''),
(1363, 'auth_db', 'field_updatelocal_institution', 'oncreate'),
(1364, 'auth_db', 'field_updateremote_institution', '0'),
(1365, 'auth_db', 'field_lock_institution', 'unlocked'),
(1366, 'auth_db', 'field_map_department', ''),
(1367, 'auth_db', 'field_updatelocal_department', 'oncreate'),
(1368, 'auth_db', 'field_updateremote_department', '0'),
(1369, 'auth_db', 'field_lock_department', 'unlocked'),
(1370, 'auth_db', 'field_map_phone1', ''),
(1371, 'auth_db', 'field_updatelocal_phone1', 'oncreate'),
(1372, 'auth_db', 'field_updateremote_phone1', '0'),
(1373, 'auth_db', 'field_lock_phone1', 'unlocked'),
(1374, 'auth_db', 'field_map_phone2', ''),
(1375, 'auth_db', 'field_updatelocal_phone2', 'oncreate'),
(1376, 'auth_db', 'field_updateremote_phone2', '0'),
(1377, 'auth_db', 'field_lock_phone2', 'unlocked'),
(1378, 'auth_db', 'field_map_address', ''),
(1379, 'auth_db', 'field_updatelocal_address', 'oncreate'),
(1380, 'auth_db', 'field_updateremote_address', '0'),
(1381, 'auth_db', 'field_lock_address', 'unlocked'),
(1382, 'auth_db', 'field_map_firstnamephonetic', ''),
(1383, 'auth_db', 'field_updatelocal_firstnamephonetic', 'oncreate'),
(1384, 'auth_db', 'field_updateremote_firstnamephonetic', '0'),
(1385, 'auth_db', 'field_lock_firstnamephonetic', 'unlocked'),
(1386, 'auth_db', 'field_map_lastnamephonetic', ''),
(1387, 'auth_db', 'field_updatelocal_lastnamephonetic', 'oncreate'),
(1388, 'auth_db', 'field_updateremote_lastnamephonetic', '0'),
(1389, 'auth_db', 'field_lock_lastnamephonetic', 'unlocked'),
(1390, 'auth_db', 'field_map_middlename', ''),
(1391, 'auth_db', 'field_updatelocal_middlename', 'oncreate'),
(1392, 'auth_db', 'field_updateremote_middlename', '0'),
(1393, 'auth_db', 'field_lock_middlename', 'unlocked'),
(1394, 'auth_db', 'field_map_alternatename', ''),
(1395, 'auth_db', 'field_updatelocal_alternatename', 'oncreate'),
(1396, 'auth_db', 'field_updateremote_alternatename', '0'),
(1397, 'auth_db', 'field_lock_alternatename', 'unlocked'),
(1398, 'auth_ldap', 'host_url', ''),
(1399, 'auth_ldap', 'ldap_version', '3'),
(1400, 'auth_ldap', 'start_tls', '0'),
(1401, 'auth_ldap', 'ldapencoding', 'utf-8'),
(1402, 'auth_ldap', 'pagesize', '250'),
(1403, 'auth_ldap', 'preventpassindb', '0'),
(1404, 'auth_ldap', 'bind_dn', ''),
(1405, 'auth_ldap', 'bind_pw', ''),
(1406, 'auth_ldap', 'user_type', 'default'),
(1407, 'auth_ldap', 'contexts', ''),
(1408, 'auth_ldap', 'search_sub', '0'),
(1409, 'auth_ldap', 'opt_deref', '0'),
(1410, 'auth_ldap', 'user_attribute', ''),
(1411, 'auth_ldap', 'suspended_attribute', ''),
(1412, 'auth_ldap', 'memberattribute', ''),
(1413, 'auth_ldap', 'memberattribute_isdn', ''),
(1414, 'auth_ldap', 'objectclass', ''),
(1415, 'auth_ldap', 'forcechangepassword', '0'),
(1416, 'auth_ldap', 'stdchangepassword', '0'),
(1417, 'auth_ldap', 'passtype', 'plaintext'),
(1418, 'auth_ldap', 'changepasswordurl', ''),
(1419, 'auth_ldap', 'expiration', '0'),
(1420, 'auth_ldap', 'expiration_warning', ''),
(1421, 'auth_ldap', 'expireattr', ''),
(1422, 'auth_ldap', 'gracelogins', '0'),
(1423, 'auth_ldap', 'graceattr', ''),
(1424, 'auth_ldap', 'auth_user_create', '0'),
(1425, 'auth_ldap', 'create_context', ''),
(1426, 'auth_ldap', 'managercontext', ''),
(1427, 'auth_ldap', 'coursecreatorcontext', ''),
(1428, 'auth_ldap', 'removeuser', '0'),
(1429, 'auth_ldap', 'sync_suspended', '0'),
(1430, 'auth_ldap', 'ntlmsso_enabled', '0'),
(1431, 'auth_ldap', 'ntlmsso_subnet', ''),
(1432, 'auth_ldap', 'ntlmsso_ie_fastpath', '0'),
(1433, 'auth_ldap', 'ntlmsso_type', 'ntlm'),
(1434, 'auth_ldap', 'ntlmsso_remoteuserformat', ''),
(1435, 'auth_ldap', 'field_map_firstname', ''),
(1436, 'auth_ldap', 'field_updatelocal_firstname', 'oncreate'),
(1437, 'auth_ldap', 'field_updateremote_firstname', '0'),
(1438, 'auth_ldap', 'field_lock_firstname', 'unlocked'),
(1439, 'auth_ldap', 'field_map_lastname', ''),
(1440, 'auth_ldap', 'field_updatelocal_lastname', 'oncreate'),
(1441, 'auth_ldap', 'field_updateremote_lastname', '0'),
(1442, 'auth_ldap', 'field_lock_lastname', 'unlocked'),
(1443, 'auth_ldap', 'field_map_email', ''),
(1444, 'auth_ldap', 'field_updatelocal_email', 'oncreate'),
(1445, 'auth_ldap', 'field_updateremote_email', '0'),
(1446, 'auth_ldap', 'field_lock_email', 'unlocked'),
(1447, 'auth_ldap', 'field_map_city', ''),
(1448, 'auth_ldap', 'field_updatelocal_city', 'oncreate'),
(1449, 'auth_ldap', 'field_updateremote_city', '0'),
(1450, 'auth_ldap', 'field_lock_city', 'unlocked'),
(1451, 'auth_ldap', 'field_map_country', ''),
(1452, 'auth_ldap', 'field_updatelocal_country', 'oncreate'),
(1453, 'auth_ldap', 'field_updateremote_country', '0'),
(1454, 'auth_ldap', 'field_lock_country', 'unlocked'),
(1455, 'auth_ldap', 'field_map_lang', ''),
(1456, 'auth_ldap', 'field_updatelocal_lang', 'oncreate'),
(1457, 'auth_ldap', 'field_updateremote_lang', '0'),
(1458, 'auth_ldap', 'field_lock_lang', 'unlocked'),
(1459, 'auth_ldap', 'field_map_description', ''),
(1460, 'auth_ldap', 'field_updatelocal_description', 'oncreate'),
(1461, 'auth_ldap', 'field_updateremote_description', '0'),
(1462, 'auth_ldap', 'field_lock_description', 'unlocked'),
(1463, 'auth_ldap', 'field_map_url', ''),
(1464, 'auth_ldap', 'field_updatelocal_url', 'oncreate'),
(1465, 'auth_ldap', 'field_updateremote_url', '0'),
(1466, 'auth_ldap', 'field_lock_url', 'unlocked'),
(1467, 'auth_ldap', 'field_map_idnumber', ''),
(1468, 'auth_ldap', 'field_updatelocal_idnumber', 'oncreate'),
(1469, 'auth_ldap', 'field_updateremote_idnumber', '0'),
(1470, 'auth_ldap', 'field_lock_idnumber', 'unlocked'),
(1471, 'auth_ldap', 'field_map_institution', ''),
(1472, 'auth_ldap', 'field_updatelocal_institution', 'oncreate'),
(1473, 'auth_ldap', 'field_updateremote_institution', '0'),
(1474, 'auth_ldap', 'field_lock_institution', 'unlocked'),
(1475, 'auth_ldap', 'field_map_department', ''),
(1476, 'auth_ldap', 'field_updatelocal_department', 'oncreate'),
(1477, 'auth_ldap', 'field_updateremote_department', '0'),
(1478, 'auth_ldap', 'field_lock_department', 'unlocked'),
(1479, 'auth_ldap', 'field_map_phone1', ''),
(1480, 'auth_ldap', 'field_updatelocal_phone1', 'oncreate'),
(1481, 'auth_ldap', 'field_updateremote_phone1', '0'),
(1482, 'auth_ldap', 'field_lock_phone1', 'unlocked'),
(1483, 'auth_ldap', 'field_map_phone2', ''),
(1484, 'auth_ldap', 'field_updatelocal_phone2', 'oncreate'),
(1485, 'auth_ldap', 'field_updateremote_phone2', '0'),
(1486, 'auth_ldap', 'field_lock_phone2', 'unlocked'),
(1487, 'auth_ldap', 'field_map_address', ''),
(1488, 'auth_ldap', 'field_updatelocal_address', 'oncreate'),
(1489, 'auth_ldap', 'field_updateremote_address', '0'),
(1490, 'auth_ldap', 'field_lock_address', 'unlocked'),
(1491, 'auth_ldap', 'field_map_firstnamephonetic', ''),
(1492, 'auth_ldap', 'field_updatelocal_firstnamephonetic', 'oncreate'),
(1493, 'auth_ldap', 'field_updateremote_firstnamephonetic', '0'),
(1494, 'auth_ldap', 'field_lock_firstnamephonetic', 'unlocked'),
(1495, 'auth_ldap', 'field_map_lastnamephonetic', ''),
(1496, 'auth_ldap', 'field_updatelocal_lastnamephonetic', 'oncreate'),
(1497, 'auth_ldap', 'field_updateremote_lastnamephonetic', '0'),
(1498, 'auth_ldap', 'field_lock_lastnamephonetic', 'unlocked'),
(1499, 'auth_ldap', 'field_map_middlename', ''),
(1500, 'auth_ldap', 'field_updatelocal_middlename', 'oncreate'),
(1501, 'auth_ldap', 'field_updateremote_middlename', '0'),
(1502, 'auth_ldap', 'field_lock_middlename', 'unlocked'),
(1503, 'auth_ldap', 'field_map_alternatename', ''),
(1504, 'auth_ldap', 'field_updatelocal_alternatename', 'oncreate'),
(1505, 'auth_ldap', 'field_updateremote_alternatename', '0'),
(1506, 'auth_ldap', 'field_lock_alternatename', 'unlocked'),
(1507, 'auth_manual', 'expiration', '0'),
(1508, 'auth_manual', 'expirationtime', '30'),
(1509, 'auth_manual', 'expiration_warning', '0'),
(1510, 'auth_manual', 'field_lock_firstname', 'unlocked'),
(1511, 'auth_manual', 'field_lock_lastname', 'unlocked'),
(1512, 'auth_manual', 'field_lock_email', 'unlocked'),
(1513, 'auth_manual', 'field_lock_city', 'unlocked'),
(1514, 'auth_manual', 'field_lock_country', 'unlocked'),
(1515, 'auth_manual', 'field_lock_lang', 'unlocked'),
(1516, 'auth_manual', 'field_lock_description', 'unlocked'),
(1517, 'auth_manual', 'field_lock_url', 'unlocked'),
(1518, 'auth_manual', 'field_lock_idnumber', 'unlocked'),
(1519, 'auth_manual', 'field_lock_institution', 'unlocked'),
(1520, 'auth_manual', 'field_lock_department', 'unlocked'),
(1521, 'auth_manual', 'field_lock_phone1', 'unlocked'),
(1522, 'auth_manual', 'field_lock_phone2', 'unlocked'),
(1523, 'auth_manual', 'field_lock_address', 'unlocked'),
(1524, 'auth_manual', 'field_lock_firstnamephonetic', 'unlocked'),
(1525, 'auth_manual', 'field_lock_lastnamephonetic', 'unlocked'),
(1526, 'auth_manual', 'field_lock_middlename', 'unlocked'),
(1527, 'auth_manual', 'field_lock_alternatename', 'unlocked'),
(1528, 'auth_mnet', 'rpc_negotiation_timeout', '30'),
(1529, 'auth_none', 'field_lock_firstname', 'unlocked'),
(1530, 'auth_none', 'field_lock_lastname', 'unlocked'),
(1531, 'auth_none', 'field_lock_email', 'unlocked'),
(1532, 'auth_none', 'field_lock_city', 'unlocked'),
(1533, 'auth_none', 'field_lock_country', 'unlocked'),
(1534, 'auth_none', 'field_lock_lang', 'unlocked'),
(1535, 'auth_none', 'field_lock_description', 'unlocked'),
(1536, 'auth_none', 'field_lock_url', 'unlocked'),
(1537, 'auth_none', 'field_lock_idnumber', 'unlocked'),
(1538, 'auth_none', 'field_lock_institution', 'unlocked'),
(1539, 'auth_none', 'field_lock_department', 'unlocked'),
(1540, 'auth_none', 'field_lock_phone1', 'unlocked'),
(1541, 'auth_none', 'field_lock_phone2', 'unlocked'),
(1542, 'auth_none', 'field_lock_address', 'unlocked'),
(1543, 'auth_none', 'field_lock_firstnamephonetic', 'unlocked'),
(1544, 'auth_none', 'field_lock_lastnamephonetic', 'unlocked'),
(1545, 'auth_none', 'field_lock_middlename', 'unlocked'),
(1546, 'auth_none', 'field_lock_alternatename', 'unlocked'),
(1547, 'auth_oauth2', 'field_lock_firstname', 'unlocked'),
(1548, 'auth_oauth2', 'field_lock_lastname', 'unlocked'),
(1549, 'auth_oauth2', 'field_lock_email', 'unlocked'),
(1550, 'auth_oauth2', 'field_lock_city', 'unlocked'),
(1551, 'auth_oauth2', 'field_lock_country', 'unlocked'),
(1552, 'auth_oauth2', 'field_lock_lang', 'unlocked'),
(1553, 'auth_oauth2', 'field_lock_description', 'unlocked'),
(1554, 'auth_oauth2', 'field_lock_url', 'unlocked'),
(1555, 'auth_oauth2', 'field_lock_idnumber', 'unlocked'),
(1556, 'auth_oauth2', 'field_lock_institution', 'unlocked'),
(1557, 'auth_oauth2', 'field_lock_department', 'unlocked'),
(1558, 'auth_oauth2', 'field_lock_phone1', 'unlocked'),
(1559, 'auth_oauth2', 'field_lock_phone2', 'unlocked'),
(1560, 'auth_oauth2', 'field_lock_address', 'unlocked'),
(1561, 'auth_oauth2', 'field_lock_firstnamephonetic', 'unlocked'),
(1562, 'auth_oauth2', 'field_lock_lastnamephonetic', 'unlocked'),
(1563, 'auth_oauth2', 'field_lock_middlename', 'unlocked'),
(1564, 'auth_oauth2', 'field_lock_alternatename', 'unlocked'),
(1565, 'auth_shibboleth', 'user_attribute', ''),
(1566, 'auth_shibboleth', 'convert_data', ''),
(1567, 'auth_shibboleth', 'alt_login', 'off'),
(1568, 'auth_shibboleth', 'organization_selection', 'urn:mace:organization1:providerID, Example Organization 1\n        https://another.idp-id.com/shibboleth, Other Example Organization, /Shibboleth.sso/DS/SWITCHaai\n        urn:mace:organization2:providerID, Example Organization 2, /Shibboleth.sso/WAYF/SWITCHaai'),
(1569, 'auth_shibboleth', 'logout_handler', ''),
(1570, 'auth_shibboleth', 'logout_return_url', ''),
(1571, 'auth_shibboleth', 'login_name', 'Shibboleth Login'),
(1572, 'auth_shibboleth', 'auth_instructions', 'Use the <a href="[[softurl]]/auth/shibboleth/index.php">Shibboleth login</a> to get access via Shibboleth, if your institution supports it.<br />Otherwise, use the normal login form shown here.'),
(1573, 'auth_shibboleth', 'changepasswordurl', ''),
(1574, 'auth_shibboleth', 'field_map_firstname', ''),
(1575, 'auth_shibboleth', 'field_updatelocal_firstname', 'oncreate'),
(1576, 'auth_shibboleth', 'field_lock_firstname', 'unlocked'),
(1577, 'auth_shibboleth', 'field_map_lastname', ''),
(1578, 'auth_shibboleth', 'field_updatelocal_lastname', 'oncreate'),
(1579, 'auth_shibboleth', 'field_lock_lastname', 'unlocked'),
(1580, 'auth_shibboleth', 'field_map_email', ''),
(1581, 'auth_shibboleth', 'field_updatelocal_email', 'oncreate'),
(1582, 'auth_shibboleth', 'field_lock_email', 'unlocked'),
(1583, 'auth_shibboleth', 'field_map_city', ''),
(1584, 'auth_shibboleth', 'field_updatelocal_city', 'oncreate'),
(1585, 'auth_shibboleth', 'field_lock_city', 'unlocked'),
(1586, 'auth_shibboleth', 'field_map_country', ''),
(1587, 'auth_shibboleth', 'field_updatelocal_country', 'oncreate'),
(1588, 'auth_shibboleth', 'field_lock_country', 'unlocked'),
(1589, 'auth_shibboleth', 'field_map_lang', ''),
(1590, 'auth_shibboleth', 'field_updatelocal_lang', 'oncreate'),
(1591, 'auth_shibboleth', 'field_lock_lang', 'unlocked'),
(1592, 'auth_shibboleth', 'field_map_description', ''),
(1593, 'auth_shibboleth', 'field_updatelocal_description', 'oncreate'),
(1594, 'auth_shibboleth', 'field_lock_description', 'unlocked'),
(1595, 'auth_shibboleth', 'field_map_url', ''),
(1596, 'auth_shibboleth', 'field_updatelocal_url', 'oncreate'),
(1597, 'auth_shibboleth', 'field_lock_url', 'unlocked'),
(1598, 'auth_shibboleth', 'field_map_idnumber', ''),
(1599, 'auth_shibboleth', 'field_updatelocal_idnumber', 'oncreate'),
(1600, 'auth_shibboleth', 'field_lock_idnumber', 'unlocked'),
(1601, 'auth_shibboleth', 'field_map_institution', ''),
(1602, 'auth_shibboleth', 'field_updatelocal_institution', 'oncreate'),
(1603, 'auth_shibboleth', 'field_lock_institution', 'unlocked'),
(1604, 'auth_shibboleth', 'field_map_department', ''),
(1605, 'auth_shibboleth', 'field_updatelocal_department', 'oncreate'),
(1606, 'auth_shibboleth', 'field_lock_department', 'unlocked'),
(1607, 'auth_shibboleth', 'field_map_phone1', ''),
(1608, 'auth_shibboleth', 'field_updatelocal_phone1', 'oncreate'),
(1609, 'auth_shibboleth', 'field_lock_phone1', 'unlocked'),
(1610, 'auth_shibboleth', 'field_map_phone2', ''),
(1611, 'auth_shibboleth', 'field_updatelocal_phone2', 'oncreate'),
(1612, 'auth_shibboleth', 'field_lock_phone2', 'unlocked'),
(1613, 'auth_shibboleth', 'field_map_address', ''),
(1614, 'auth_shibboleth', 'field_updatelocal_address', 'oncreate'),
(1615, 'auth_shibboleth', 'field_lock_address', 'unlocked'),
(1616, 'auth_shibboleth', 'field_map_firstnamephonetic', ''),
(1617, 'auth_shibboleth', 'field_updatelocal_firstnamephonetic', 'oncreate'),
(1618, 'auth_shibboleth', 'field_lock_firstnamephonetic', 'unlocked'),
(1619, 'auth_shibboleth', 'field_map_lastnamephonetic', ''),
(1620, 'auth_shibboleth', 'field_updatelocal_lastnamephonetic', 'oncreate'),
(1621, 'auth_shibboleth', 'field_lock_lastnamephonetic', 'unlocked'),
(1622, 'auth_shibboleth', 'field_map_middlename', ''),
(1623, 'auth_shibboleth', 'field_updatelocal_middlename', 'oncreate'),
(1624, 'auth_shibboleth', 'field_lock_middlename', 'unlocked'),
(1625, 'auth_shibboleth', 'field_map_alternatename', ''),
(1626, 'auth_shibboleth', 'field_updatelocal_alternatename', 'oncreate'),
(1627, 'auth_shibboleth', 'field_lock_alternatename', 'unlocked'),
(1628, 'block_activity_results', 'config_showbest', '3'),
(1629, 'block_activity_results', 'config_showbest_locked', ''),
(1630, 'block_activity_results', 'config_showworst', '0'),
(1631, 'block_activity_results', 'config_showworst_locked', ''),
(1632, 'block_activity_results', 'config_usegroups', '0'),
(1633, 'block_activity_results', 'config_usegroups_locked', ''),
(1634, 'block_activity_results', 'config_nameformat', '1'),
(1635, 'block_activity_results', 'config_nameformat_locked', ''),
(1636, 'block_activity_results', 'config_gradeformat', '1'),
(1637, 'block_activity_results', 'config_gradeformat_locked', ''),
(1638, 'block_activity_results', 'config_decimalpoints', '2'),
(1639, 'block_activity_results', 'config_decimalpoints_locked', ''),
(1640, 'block_myoverview', 'defaulttab', 'timeline'),
(1641, 'block_section_links', 'numsections1', '22'),
(1642, 'block_section_links', 'incby1', '2'),
(1643, 'block_section_links', 'numsections2', '40'),
(1644, 'block_section_links', 'incby2', '5'),
(1645, 'block_tag_youtube', 'apikey', ''),
(1646, 'format_singleactivity', 'activitytype', 'forum'),
(1647, 'fileconverter_googledrive', 'issuerid', ''),
(1648, 'enrol_cohort', 'roleid', '5'),
(1649, 'enrol_cohort', 'unenrolaction', '0'),
(1650, 'enrol_meta', 'nosyncroleids', ''),
(1651, 'enrol_meta', 'syncall', '1'),
(1652, 'enrol_meta', 'unenrolaction', '3'),
(1653, 'enrol_meta', 'coursesort', 'sortorder'),
(1654, 'enrol_database', 'dbtype', ''),
(1655, 'enrol_database', 'dbhost', 'localhost'),
(1656, 'enrol_database', 'dbuser', ''),
(1657, 'enrol_database', 'dbpass', ''),
(1658, 'enrol_database', 'dbname', ''),
(1659, 'enrol_database', 'dbencoding', 'utf-8'),
(1660, 'enrol_database', 'dbsetupsql', ''),
(1661, 'enrol_database', 'dbsybasequoting', '0'),
(1662, 'enrol_database', 'debugdb', '0'),
(1663, 'enrol_database', 'localcoursefield', 'idnumber'),
(1664, 'enrol_database', 'localuserfield', 'idnumber'),
(1665, 'enrol_database', 'localrolefield', 'shortname'),
(1666, 'enrol_database', 'localcategoryfield', 'id'),
(1667, 'enrol_database', 'remoteenroltable', ''),
(1668, 'enrol_database', 'remotecoursefield', ''),
(1669, 'enrol_database', 'remoteuserfield', ''),
(1670, 'enrol_database', 'remoterolefield', ''),
(1671, 'enrol_database', 'remoteotheruserfield', ''),
(1672, 'enrol_database', 'defaultrole', '5'),
(1673, 'enrol_database', 'ignorehiddencourses', '0'),
(1674, 'enrol_database', 'unenrolaction', '0'),
(1675, 'enrol_database', 'newcoursetable', ''),
(1676, 'enrol_database', 'newcoursefullname', 'fullname'),
(1677, 'enrol_database', 'newcourseshortname', 'shortname'),
(1678, 'enrol_database', 'newcourseidnumber', 'idnumber'),
(1679, 'enrol_database', 'newcoursecategory', ''),
(1680, 'enrol_database', 'defaultcategory', '1'),
(1681, 'enrol_database', 'templatecourse', ''),
(1682, 'enrol_flatfile', 'location', ''),
(1683, 'enrol_flatfile', 'encoding', 'UTF-8'),
(1684, 'enrol_flatfile', 'mailstudents', '0'),
(1685, 'enrol_flatfile', 'mailteachers', '0'),
(1686, 'enrol_flatfile', 'mailadmins', '0'),
(1687, 'enrol_flatfile', 'unenrolaction', '3'),
(1688, 'enrol_flatfile', 'expiredaction', '3'),
(1689, 'enrol_guest', 'requirepassword', '0'),
(1690, 'enrol_guest', 'usepasswordpolicy', '0'),
(1691, 'enrol_guest', 'showhint', '0'),
(1692, 'enrol_guest', 'defaultenrol', '1'),
(1693, 'enrol_guest', 'status', '1'),
(1694, 'enrol_guest', 'status_adv', ''),
(1695, 'enrol_imsenterprise', 'imsfilelocation', ''),
(1696, 'enrol_imsenterprise', 'logtolocation', ''),
(1697, 'enrol_imsenterprise', 'mailadmins', '0'),
(1698, 'enrol_imsenterprise', 'createnewusers', '0'),
(1699, 'enrol_imsenterprise', 'imsupdateusers', '0'),
(1700, 'enrol_imsenterprise', 'imsdeleteusers', '0'),
(1701, 'enrol_imsenterprise', 'fixcaseusernames', '0'),
(1702, 'enrol_imsenterprise', 'fixcasepersonalnames', '0'),
(1703, 'enrol_imsenterprise', 'imssourcedidfallback', '0'),
(1704, 'enrol_imsenterprise', 'imsrolemap01', '5'),
(1705, 'enrol_imsenterprise', 'imsrolemap02', '3'),
(1706, 'enrol_imsenterprise', 'imsrolemap03', '3'),
(1707, 'enrol_imsenterprise', 'imsrolemap04', '5'),
(1708, 'enrol_imsenterprise', 'imsrolemap05', '0'),
(1709, 'enrol_imsenterprise', 'imsrolemap06', '4'),
(1710, 'enrol_imsenterprise', 'imsrolemap07', '0'),
(1711, 'enrol_imsenterprise', 'imsrolemap08', '4'),
(1712, 'enrol_imsenterprise', 'truncatecoursecodes', '0'),
(1713, 'enrol_imsenterprise', 'createnewcourses', '0'),
(1714, 'enrol_imsenterprise', 'updatecourses', '0'),
(1715, 'enrol_imsenterprise', 'createnewcategories', '0'),
(1716, 'enrol_imsenterprise', 'nestedcategories', '0'),
(1717, 'enrol_imsenterprise', 'categoryidnumber', '0'),
(1718, 'enrol_imsenterprise', 'categoryseparator', ''),
(1719, 'enrol_imsenterprise', 'imsunenrol', '0'),
(1720, 'enrol_imsenterprise', 'imscoursemapshortname', 'coursecode'),
(1721, 'enrol_imsenterprise', 'imscoursemapfullname', 'short'),
(1722, 'enrol_imsenterprise', 'imscoursemapsummary', 'ignore'),
(1723, 'enrol_imsenterprise', 'imsrestricttarget', ''),
(1724, 'enrol_imsenterprise', 'imscapitafix', '0'),
(1725, 'enrol_ldap', 'host_url', ''),
(1726, 'enrol_ldap', 'start_tls', '0'),
(1727, 'enrol_ldap', 'ldap_version', '3'),
(1728, 'enrol_ldap', 'ldapencoding', 'utf-8'),
(1729, 'enrol_ldap', 'pagesize', '250'),
(1730, 'enrol_ldap', 'bind_dn', ''),
(1731, 'enrol_ldap', 'bind_pw', ''),
(1732, 'enrol_ldap', 'course_search_sub', '0'),
(1733, 'enrol_ldap', 'memberattribute_isdn', '0'),
(1734, 'enrol_ldap', 'user_contexts', ''),
(1735, 'enrol_ldap', 'user_search_sub', '0'),
(1736, 'enrol_ldap', 'user_type', 'default'),
(1737, 'enrol_ldap', 'opt_deref', '0'),
(1738, 'enrol_ldap', 'idnumber_attribute', ''),
(1739, 'enrol_ldap', 'objectclass', ''),
(1740, 'enrol_ldap', 'course_idnumber', ''),
(1741, 'enrol_ldap', 'course_shortname', ''),
(1742, 'enrol_ldap', 'course_fullname', ''),
(1743, 'enrol_ldap', 'course_summary', ''),
(1744, 'enrol_ldap', 'ignorehiddencourses', '0'),
(1745, 'enrol_ldap', 'unenrolaction', '0'),
(1746, 'enrol_ldap', 'autocreate', '0'),
(1747, 'enrol_ldap', 'category', '1'),
(1748, 'enrol_ldap', 'template', ''),
(1749, 'enrol_ldap', 'course_shortname_updateonsync', '0'),
(1750, 'enrol_ldap', 'course_fullname_updateonsync', '0'),
(1751, 'enrol_ldap', 'course_summary_updateonsync', '0'),
(1752, 'enrol_ldap', 'nested_groups', '0'),
(1753, 'enrol_ldap', 'group_memberofattribute', ''),
(1754, 'enrol_manual', 'expiredaction', '1'),
(1755, 'enrol_manual', 'expirynotifyhour', '6'),
(1756, 'enrol_manual', 'defaultenrol', '1'),
(1757, 'enrol_manual', 'status', '0'),
(1758, 'enrol_manual', 'roleid', '5'),
(1759, 'enrol_manual', 'enrolstart', '4'),
(1760, 'enrol_manual', 'enrolperiod', '0'),
(1761, 'enrol_manual', 'expirynotify', '0'),
(1762, 'enrol_manual', 'expirythreshold', '86400'),
(1763, 'enrol_mnet', 'roleid', '5'),
(1764, 'enrol_mnet', 'roleid_adv', '1'),
(1765, 'enrol_paypal', 'paypalbusiness', ''),
(1766, 'enrol_paypal', 'mailstudents', '0'),
(1767, 'enrol_paypal', 'mailteachers', '0'),
(1768, 'enrol_paypal', 'mailadmins', '0'),
(1769, 'enrol_paypal', 'expiredaction', '3'),
(1770, 'enrol_paypal', 'status', '1'),
(1771, 'enrol_paypal', 'cost', '0'),
(1772, 'enrol_paypal', 'currency', 'USD'),
(1773, 'enrol_paypal', 'roleid', '5'),
(1774, 'enrol_paypal', 'enrolperiod', '0'),
(1775, 'enrol_lti', 'emaildisplay', '2'),
(1776, 'enrol_lti', 'city', ''),
(1777, 'enrol_lti', 'country', ''),
(1778, 'enrol_lti', 'timezone', '99'),
(1779, 'enrol_lti', 'lang', 'en'),
(1780, 'enrol_lti', 'institution', ''),
(1781, 'enrol_self', 'requirepassword', '0'),
(1782, 'enrol_self', 'usepasswordpolicy', '0'),
(1783, 'enrol_self', 'showhint', '0'),
(1784, 'enrol_self', 'expiredaction', '1'),
(1785, 'enrol_self', 'expirynotifyhour', '6'),
(1786, 'enrol_self', 'defaultenrol', '1'),
(1787, 'enrol_self', 'status', '1'),
(1788, 'enrol_self', 'newenrols', '1'),
(1789, 'enrol_self', 'groupkey', '0'),
(1790, 'enrol_self', 'roleid', '5'),
(1791, 'enrol_self', 'enrolperiod', '0'),
(1792, 'enrol_self', 'expirynotify', '0'),
(1793, 'enrol_self', 'expirythreshold', '86400'),
(1794, 'enrol_self', 'longtimenosee', '0'),
(1795, 'enrol_self', 'maxenrolled', '0'),
(1796, 'enrol_self', 'sendcoursewelcomemessage', '1'),
(1797, 'filter_urltolink', 'formats', '0'),
(1798, 'filter_urltolink', 'embedimages', '1'),
(1799, 'filter_emoticon', 'formats', '1,4,0'),
(1800, 'filter_mathjaxloader', 'httpsurl', 'https://cdn.jsdelivr.net/npm/mathjax@2.7.8/MathJax.js'),
(1801, 'filter_mathjaxloader', 'texfiltercompatibility', '0'),
(1802, 'filter_mathjaxloader', 'mathjaxconfig', '\nMathJax.Hub.Config({\n    config: ["Accessible.js", "Safe.js"],\n    errorSettings: { message: ["!"] },\n    skipStartupTypeset: true,\n    messageStyle: "none"\n});\n'),
(1803, 'filter_mathjaxloader', 'additionaldelimiters', ''),
(1804, 'filter_tex', 'latexpreamble', '\\usepackage[latin1]{inputenc}\n\\usepackage{amsmath}\n\\usepackage{amsfonts}\n\\RequirePackage{amsmath,amssymb,latexsym}\n'),
(1805, 'filter_tex', 'latexbackground', '#FFFFFF'),
(1806, 'filter_tex', 'density', '120'),
(1807, 'filter_tex', 'pathlatex', '[[default_filter_tex_pathlatex]]'),
(1808, 'filter_tex', 'pathdvips', '[[default_filter_tex_pathdvips]]'),
(1809, 'filter_tex', 'pathconvert', '[[default_filter_tex_pathconvert]]'),
(1810, 'filter_tex', 'pathdvisvgm', '[[default_filter_tex_dvisvgm]]'),
(1811, 'filter_tex', 'pathmimetex', ''),
(1812, 'filter_tex', 'convertformat', 'gif'),
(1813, 'logstore_database', 'dbdriver', ''),
(1814, 'logstore_database', 'dbhost', ''),
(1815, 'logstore_database', 'dbuser', ''),
(1816, 'logstore_database', 'dbpass', ''),
(1817, 'logstore_database', 'dbname', ''),
(1818, 'logstore_database', 'dbtable', ''),
(1819, 'logstore_database', 'dbpersist', '0'),
(1820, 'logstore_database', 'dbsocket', ''),
(1821, 'logstore_database', 'dbport', ''),
(1822, 'logstore_database', 'dbschema', ''),
(1823, 'logstore_database', 'dbcollation', ''),
(1824, 'logstore_database', 'dbhandlesoptions', '0'),
(1825, 'logstore_database', 'buffersize', '50'),
(1826, 'logstore_database', 'logguests', '0'),
(1827, 'logstore_database', 'includelevels', '1,2,0'),
(1828, 'logstore_database', 'includeactions', 'c,r,u,d'),
(1829, 'logstore_legacy', 'loglegacy', '0'),
(1830, 'logstore_standard', 'logguests', '1'),
(1831, 'logstore_standard', 'loglifetime', '0'),
(1832, 'logstore_standard', 'buffersize', '50'),
(1833, 'media_videojs', 'videoextensions', 'html_video,.f4v,.flv'),
(1834, 'media_videojs', 'audioextensions', 'html_audio'),
(1835, 'media_videojs', 'rtmp', '0'),
(1836, 'media_videojs', 'useflash', '0'),
(1837, 'media_videojs', 'youtube', '1'),
(1838, 'media_videojs', 'videocssclass', 'video-js'),
(1839, 'media_videojs', 'audiocssclass', 'video-js'),
(1840, 'media_videojs', 'limitsize', '1'),
(1841, 'qtype_multichoice', 'answerhowmany', '1'),
(1842, 'qtype_multichoice', 'shuffleanswers', '1'),
(1843, 'qtype_multichoice', 'answernumbering', 'abc'),
(1844, 'editor_atto', 'toolbar', 'collapse = collapse\nstyle1 = title, bold, italic\nlist = unorderedlist, orderedlist\nlinks = link\nfiles = image, media, recordrtc, managefiles\nstyle2 = underline, strike, subscript, superscript\nalign = align\nindent = indent\ninsert = equation, charmap, table, clear\nundo = undo\naccessibility = accessibilitychecker, accessibilityhelper\nother = html'),
(1845, 'editor_atto', 'autosavefrequency', '60'),
(1846, 'atto_collapse', 'showgroups', '5'),
(1847, 'atto_equation', 'librarygroup1', '\n\\cdot\n\\times\n\\ast\n\\div\n\\diamond\n\\pm\n\\mp\n\\oplus\n\\ominus\n\\otimes\n\\oslash\n\\odot\n\\circ\n\\bullet\n\\asymp\n\\equiv\n\\subseteq\n\\supseteq\n\\leq\n\\geq\n\\preceq\n\\succeq\n\\sim\n\\simeq\n\\approx\n\\subset\n\\supset\n\\ll\n\\gg\n\\prec\n\\succ\n\\infty\n\\in\n\\ni\n\\forall\n\\exists\n\\neq\n'),
(1848, 'atto_equation', 'librarygroup2', '\n\\leftarrow\n\\rightarrow\n\\uparrow\n\\downarrow\n\\leftrightarrow\n\\nearrow\n\\searrow\n\\swarrow\n\\nwarrow\n\\Leftarrow\n\\Rightarrow\n\\Uparrow\n\\Downarrow\n\\Leftrightarrow\n'),
(1849, 'atto_equation', 'librarygroup3', '\n\\alpha\n\\beta\n\\gamma\n\\delta\n\\epsilon\n\\zeta\n\\eta\n\\theta\n\\iota\n\\kappa\n\\lambda\n\\mu\n\\nu\n\\xi\n\\pi\n\\rho\n\\sigma\n\\tau\n\\upsilon\n\\phi\n\\chi\n\\psi\n\\omega\n\\Gamma\n\\Delta\n\\Theta\n\\Lambda\n\\Xi\n\\Pi\n\\Sigma\n\\Upsilon\n\\Phi\n\\Psi\n\\Omega\n'),
(1850, 'atto_equation', 'librarygroup4', '\n\\sum{a,b}\n\\sqrt[a]{b+c}\n\\int_{a}^{b}{c}\n\\iint_{a}^{b}{c}\n\\iiint_{a}^{b}{c}\n\\oint{a}\n(a)\n[a]\n\\lbrace{a}\\rbrace\n\\left| \\begin{matrix} a_1 & a_2 \\ a_3 & a_4 \\end{matrix} \\right|\n\\frac{a}{b+c}\n\\vec{a}\n\\binom {a} {b}\n{a \\brack b}\n{a \\brace b}\n'),
(1851, 'atto_recordrtc', 'allowedtypes', 'both'),
(1852, 'atto_recordrtc', 'audiobitrate', '128000'),
(1853, 'atto_recordrtc', 'videobitrate', '2500000'),
(1854, 'atto_recordrtc', 'timelimit', '120'),
(1855, 'atto_table', 'allowborders', '0'),
(1856, 'atto_table', 'allowbackgroundcolour', '0'),
(1857, 'atto_table', 'allowwidth', '0'),
(1858, 'editor_tinymce', 'customtoolbar', 'wrap,formatselect,wrap,bold,italic,wrap,bullist,numlist,wrap,link,unlink,wrap,image\n\nundo,redo,wrap,underline,strikethrough,sub,sup,wrap,justifyleft,justifycenter,justifyright,wrap,outdent,indent,wrap,forecolor,backcolor,wrap,ltr,rtl\n\nfontselect,fontsizeselect,wrap,code,search,replace,wrap,nonbreaking,charmap,table,wrap,cleanup,removeformat,pastetext,pasteword,wrap,fullscreen'),
(1859, 'editor_tinymce', 'fontselectlist', 'Trebuchet=Trebuchet MS,Verdana,Arial,Helvetica,sans-serif;Arial=arial,helvetica,sans-serif;Courier New=courier new,courier,monospace;Georgia=georgia,times new roman,times,serif;Tahoma=tahoma,arial,helvetica,sans-serif;Times New Roman=times new roman,times,serif;Verdana=verdana,arial,helvetica,sans-serif;Impact=impact;Wingdings=wingdings'),
(1860, 'editor_tinymce', 'customconfig', ''),
(1861, 'tinymce_moodleemoticon', 'requireemoticon', '1'),
(1862, 'tinymce_spellchecker', 'spellengine', ''),
(1863, 'tinymce_spellchecker', 'spelllanguagelist', '+English=en,Danish=da,Dutch=nl,Finnish=fi,French=fr,German=de,Italian=it,Polish=pl,Portuguese=pt,Spanish=es,Swedish=sv'),
(1864, 'tool_mobile', 'apppolicy', '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]context`
--

CREATE TABLE `[[dbprefix]]context` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `contextlevel` bigint(10) NOT NULL DEFAULT '0',
  `instanceid` bigint(10) NOT NULL DEFAULT '0',
  `path` varchar(255) DEFAULT NULL,
  `depth` tinyint(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]cont_conins_uix` (`contextlevel`,`instanceid`),
  KEY `[[dbprefix]]cont_ins_ix` (`instanceid`),
  KEY `[[dbprefix]]cont_pat_ix` (`path`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='one of these must be set' AUTO_INCREMENT=14 ;

--
-- Dumping data for table `[[dbprefix]]context`
--

INSERT INTO `[[dbprefix]]context` VALUES
(1, 10, 0, '/1', 1),
(2, 50, 1, '/1/2', 2),
(3, 40, 1, '/1/3', 2),
(4, 30, 1, '/1/4', 2),
(5, 30, 2, '/1/5', 2),
(6, 80, 1, '/1/6', 2),
(7, 80, 2, '/1/7', 2),
(8, 80, 3, '/1/8', 2),
(9, 80, 4, '/1/9', 2),
(10, 80, 5, '/1/10', 2),
(11, 80, 6, '/1/11', 2),
(12, 80, 7, '/1/12', 2),
(13, 80, 8, '/1/13', 2);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]context_temp`
--

CREATE TABLE `[[dbprefix]]context_temp` (
  `id` bigint(10) NOT NULL,
  `path` varchar(255) NOT NULL DEFAULT '',
  `depth` tinyint(2) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Used by build_context_path() in upgrade and cron to keep con';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]course`
--

CREATE TABLE `[[dbprefix]]course` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `category` bigint(10) NOT NULL DEFAULT '0',
  `sortorder` bigint(10) NOT NULL DEFAULT '0',
  `fullname` varchar(254) NOT NULL DEFAULT '',
  `shortname` varchar(255) NOT NULL DEFAULT '',
  `idnumber` varchar(100) NOT NULL DEFAULT '',
  `summary` longtext,
  `summaryformat` tinyint(2) NOT NULL DEFAULT '0',
  `format` varchar(21) NOT NULL DEFAULT 'topics',
  `showgrades` tinyint(2) NOT NULL DEFAULT '1',
  `newsitems` mediumint(5) NOT NULL DEFAULT '1',
  `startdate` bigint(10) NOT NULL DEFAULT '0',
  `enddate` bigint(10) NOT NULL DEFAULT '0',
  `marker` bigint(10) NOT NULL DEFAULT '0',
  `maxbytes` bigint(10) NOT NULL DEFAULT '0',
  `legacyfiles` smallint(4) NOT NULL DEFAULT '0',
  `showreports` smallint(4) NOT NULL DEFAULT '0',
  `visible` tinyint(1) NOT NULL DEFAULT '1',
  `visibleold` tinyint(1) NOT NULL DEFAULT '1',
  `groupmode` smallint(4) NOT NULL DEFAULT '0',
  `groupmodeforce` smallint(4) NOT NULL DEFAULT '0',
  `defaultgroupingid` bigint(10) NOT NULL DEFAULT '0',
  `lang` varchar(30) NOT NULL DEFAULT '',
  `calendartype` varchar(30) NOT NULL DEFAULT '',
  `theme` varchar(50) NOT NULL DEFAULT '',
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `requested` tinyint(1) NOT NULL DEFAULT '0',
  `enablecompletion` tinyint(1) NOT NULL DEFAULT '0',
  `completionnotify` tinyint(1) NOT NULL DEFAULT '0',
  `cacherev` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]cour_cat_ix` (`category`),
  KEY `[[dbprefix]]cour_idn_ix` (`idnumber`),
  KEY `[[dbprefix]]cour_sho_ix` (`shortname`),
  KEY `[[dbprefix]]cour_sor_ix` (`sortorder`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Central course table' AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]course`
--

INSERT INTO `[[dbprefix]]course` VALUES
(1, 0, 0, '[[site_name]]', '[[site_desc]]', '', '', 0, 'site', 1, 3, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, '', '', '', [[timestamp]], [[timestamp]], 0, 0, 0, [[timestamp]]);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]course_categories`
--

CREATE TABLE `[[dbprefix]]course_categories` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `idnumber` varchar(100) DEFAULT NULL,
  `description` longtext,
  `descriptionformat` tinyint(2) NOT NULL DEFAULT '0',
  `parent` bigint(10) NOT NULL DEFAULT '0',
  `sortorder` bigint(10) NOT NULL DEFAULT '0',
  `coursecount` bigint(10) NOT NULL DEFAULT '0',
  `visible` tinyint(1) NOT NULL DEFAULT '1',
  `visibleold` tinyint(1) NOT NULL DEFAULT '1',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `depth` bigint(10) NOT NULL DEFAULT '0',
  `path` varchar(255) NOT NULL DEFAULT '',
  `theme` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]courcate_par_ix` (`parent`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Course categories' AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]course_categories`
--

INSERT INTO `[[dbprefix]]course_categories` VALUES
(1, 'Miscellaneous', NULL, NULL, 0, 0, 10000, 0, 1, 1, [[timestamp]], 1, '/1', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]course_completions`
--

CREATE TABLE `[[dbprefix]]course_completions` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `course` bigint(10) NOT NULL DEFAULT '0',
  `timeenrolled` bigint(10) NOT NULL DEFAULT '0',
  `timestarted` bigint(10) NOT NULL DEFAULT '0',
  `timecompleted` bigint(10) DEFAULT NULL,
  `reaggregate` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]courcomp_usecou_uix` (`userid`,`course`),
  KEY `[[dbprefix]]courcomp_use_ix` (`userid`),
  KEY `[[dbprefix]]courcomp_cou_ix` (`course`),
  KEY `[[dbprefix]]courcomp_tim_ix` (`timecompleted`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Course completion records' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]course_completion_aggr_methd`
--

CREATE TABLE `[[dbprefix]]course_completion_aggr_methd` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `criteriatype` bigint(10) DEFAULT NULL,
  `method` tinyint(1) NOT NULL DEFAULT '0',
  `value` decimal(10,5) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]courcompaggrmeth_cou_uix` (`course`,`criteriatype`),
  KEY `[[dbprefix]]courcompaggrmeth_cou_ix` (`course`),
  KEY `[[dbprefix]]courcompaggrmeth_cri_ix` (`criteriatype`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Course completion aggregation methods for criteria' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]course_completion_criteria`
--

CREATE TABLE `[[dbprefix]]course_completion_criteria` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `criteriatype` bigint(10) NOT NULL DEFAULT '0',
  `module` varchar(100) DEFAULT NULL,
  `moduleinstance` bigint(10) DEFAULT NULL,
  `courseinstance` bigint(10) DEFAULT NULL,
  `enrolperiod` bigint(10) DEFAULT NULL,
  `timeend` bigint(10) DEFAULT NULL,
  `gradepass` decimal(10,5) DEFAULT NULL,
  `role` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]courcompcrit_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Course completion criteria' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]course_completion_crit_compl`
--

CREATE TABLE `[[dbprefix]]course_completion_crit_compl` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `course` bigint(10) NOT NULL DEFAULT '0',
  `criteriaid` bigint(10) NOT NULL DEFAULT '0',
  `gradefinal` decimal(10,5) DEFAULT NULL,
  `unenroled` bigint(10) DEFAULT NULL,
  `timecompleted` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]courcompcritcomp_use_uix` (`userid`,`course`,`criteriaid`),
  KEY `[[dbprefix]]courcompcritcomp_use_ix` (`userid`),
  KEY `[[dbprefix]]courcompcritcomp_cou_ix` (`course`),
  KEY `[[dbprefix]]courcompcritcomp_cri_ix` (`criteriaid`),
  KEY `[[dbprefix]]courcompcritcomp_tim_ix` (`timecompleted`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Course completion user records' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]course_completion_defaults`
--

CREATE TABLE `[[dbprefix]]course_completion_defaults` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL,
  `module` bigint(10) NOT NULL,
  `completion` tinyint(1) NOT NULL DEFAULT '0',
  `completionview` tinyint(1) NOT NULL DEFAULT '0',
  `completionusegrade` tinyint(1) NOT NULL DEFAULT '0',
  `completionexpected` bigint(10) NOT NULL DEFAULT '0',
  `customrules` longtext,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]courcompdefa_coumod_uix` (`course`,`module`),
  KEY `[[dbprefix]]courcompdefa_mod_ix` (`module`),
  KEY `[[dbprefix]]courcompdefa_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Default settings for activities completion' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]course_format_options`
--

CREATE TABLE `[[dbprefix]]course_format_options` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `courseid` bigint(10) NOT NULL,
  `format` varchar(21) NOT NULL DEFAULT '',
  `sectionid` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(100) NOT NULL DEFAULT '',
  `value` longtext,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]courformopti_coufors_uix` (`courseid`,`format`,`sectionid`,`name`),
  KEY `[[dbprefix]]courformopti_cou_ix` (`courseid`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Stores format-specific options for the course or course sect' AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]course_format_options`
--

INSERT INTO `[[dbprefix]]course_format_options` VALUES
(1, 1, 'site', 0, 'numsections', '1');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]course_modules`
--

CREATE TABLE `[[dbprefix]]course_modules` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `module` bigint(10) NOT NULL DEFAULT '0',
  `instance` bigint(10) NOT NULL DEFAULT '0',
  `section` bigint(10) NOT NULL DEFAULT '0',
  `idnumber` varchar(100) DEFAULT NULL,
  `added` bigint(10) NOT NULL DEFAULT '0',
  `score` smallint(4) NOT NULL DEFAULT '0',
  `indent` mediumint(5) NOT NULL DEFAULT '0',
  `visible` tinyint(1) NOT NULL DEFAULT '1',
  `visibleoncoursepage` tinyint(1) NOT NULL DEFAULT '1',
  `visibleold` tinyint(1) NOT NULL DEFAULT '1',
  `groupmode` smallint(4) NOT NULL DEFAULT '0',
  `groupingid` bigint(10) NOT NULL DEFAULT '0',
  `completion` tinyint(1) NOT NULL DEFAULT '0',
  `completiongradeitemnumber` bigint(10) DEFAULT NULL,
  `completionview` tinyint(1) NOT NULL DEFAULT '0',
  `completionexpected` bigint(10) NOT NULL DEFAULT '0',
  `showdescription` tinyint(1) NOT NULL DEFAULT '0',
  `availability` longtext,
  `deletioninprogress` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]courmodu_vis_ix` (`visible`),
  KEY `[[dbprefix]]courmodu_cou_ix` (`course`),
  KEY `[[dbprefix]]courmodu_mod_ix` (`module`),
  KEY `[[dbprefix]]courmodu_ins_ix` (`instance`),
  KEY `[[dbprefix]]courmodu_idncou_ix` (`idnumber`,`course`),
  KEY `[[dbprefix]]courmodu_gro_ix` (`groupingid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='course_modules table retrofitted from MySQL' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]course_modules_completion`
--

CREATE TABLE `[[dbprefix]]course_modules_completion` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `coursemoduleid` bigint(10) NOT NULL,
  `userid` bigint(10) NOT NULL,
  `completionstate` tinyint(1) NOT NULL,
  `viewed` tinyint(1) DEFAULT NULL,
  `overrideby` bigint(10) DEFAULT NULL,
  `timemodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]courmoducomp_usecou_uix` (`userid`,`coursemoduleid`),
  KEY `[[dbprefix]]courmoducomp_cou_ix` (`coursemoduleid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Stores the completion state (completed or not completed, etc' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]course_published`
--

CREATE TABLE `[[dbprefix]]course_published` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `huburl` varchar(255) DEFAULT NULL,
  `courseid` bigint(10) NOT NULL,
  `timepublished` bigint(10) NOT NULL,
  `enrollable` tinyint(1) NOT NULL DEFAULT '1',
  `hubcourseid` bigint(10) NOT NULL,
  `status` tinyint(1) DEFAULT '0',
  `timechecked` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Information about how and when an local courses were publish' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]course_request`
--

CREATE TABLE `[[dbprefix]]course_request` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `fullname` varchar(254) NOT NULL DEFAULT '',
  `shortname` varchar(100) NOT NULL DEFAULT '',
  `summary` longtext NOT NULL,
  `summaryformat` tinyint(2) NOT NULL DEFAULT '0',
  `category` bigint(10) NOT NULL DEFAULT '0',
  `reason` longtext NOT NULL,
  `requester` bigint(10) NOT NULL DEFAULT '0',
  `password` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]courrequ_sho_ix` (`shortname`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='course requests' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]course_sections`
--

CREATE TABLE `[[dbprefix]]course_sections` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `section` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) DEFAULT NULL,
  `summary` longtext,
  `summaryformat` tinyint(2) NOT NULL DEFAULT '0',
  `sequence` longtext,
  `visible` tinyint(1) NOT NULL DEFAULT '1',
  `availability` longtext,
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]coursect_cousec_uix` (`course`,`section`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='to define the sections for each course' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]data`
--

CREATE TABLE `[[dbprefix]]data` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `intro` longtext NOT NULL,
  `introformat` smallint(4) NOT NULL DEFAULT '0',
  `comments` smallint(4) NOT NULL DEFAULT '0',
  `timeavailablefrom` bigint(10) NOT NULL DEFAULT '0',
  `timeavailableto` bigint(10) NOT NULL DEFAULT '0',
  `timeviewfrom` bigint(10) NOT NULL DEFAULT '0',
  `timeviewto` bigint(10) NOT NULL DEFAULT '0',
  `requiredentries` int(8) NOT NULL DEFAULT '0',
  `requiredentriestoview` int(8) NOT NULL DEFAULT '0',
  `maxentries` int(8) NOT NULL DEFAULT '0',
  `rssarticles` smallint(4) NOT NULL DEFAULT '0',
  `singletemplate` longtext,
  `listtemplate` longtext,
  `listtemplateheader` longtext,
  `listtemplatefooter` longtext,
  `addtemplate` longtext,
  `rsstemplate` longtext,
  `rsstitletemplate` longtext,
  `csstemplate` longtext,
  `jstemplate` longtext,
  `asearchtemplate` longtext,
  `approval` smallint(4) NOT NULL DEFAULT '0',
  `manageapproved` smallint(4) NOT NULL DEFAULT '1',
  `scale` bigint(10) NOT NULL DEFAULT '0',
  `assessed` bigint(10) NOT NULL DEFAULT '0',
  `assesstimestart` bigint(10) NOT NULL DEFAULT '0',
  `assesstimefinish` bigint(10) NOT NULL DEFAULT '0',
  `defaultsort` bigint(10) NOT NULL DEFAULT '0',
  `defaultsortdir` smallint(4) NOT NULL DEFAULT '0',
  `editany` smallint(4) NOT NULL DEFAULT '0',
  `notification` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `config` longtext,
  `completionentries` bigint(10) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]data_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='all database activities' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]data_content`
--

CREATE TABLE `[[dbprefix]]data_content` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `fieldid` bigint(10) NOT NULL DEFAULT '0',
  `recordid` bigint(10) NOT NULL DEFAULT '0',
  `content` longtext,
  `content1` longtext,
  `content2` longtext,
  `content3` longtext,
  `content4` longtext,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]datacont_rec_ix` (`recordid`),
  KEY `[[dbprefix]]datacont_fie_ix` (`fieldid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='the content introduced in each record/fields' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]data_fields`
--

CREATE TABLE `[[dbprefix]]data_fields` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `dataid` bigint(10) NOT NULL DEFAULT '0',
  `type` varchar(255) NOT NULL DEFAULT '',
  `name` varchar(255) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `required` tinyint(1) NOT NULL DEFAULT '0',
  `param1` longtext,
  `param2` longtext,
  `param3` longtext,
  `param4` longtext,
  `param5` longtext,
  `param6` longtext,
  `param7` longtext,
  `param8` longtext,
  `param9` longtext,
  `param10` longtext,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]datafiel_typdat_ix` (`type`,`dataid`),
  KEY `[[dbprefix]]datafiel_dat_ix` (`dataid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='every field available' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]data_records`
--

CREATE TABLE `[[dbprefix]]data_records` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `groupid` bigint(10) NOT NULL DEFAULT '0',
  `dataid` bigint(10) NOT NULL DEFAULT '0',
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `approved` smallint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]datareco_dat_ix` (`dataid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='every record introduced' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]editor_atto_autosave`
--

CREATE TABLE `[[dbprefix]]editor_atto_autosave` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `elementid` varchar(255) NOT NULL DEFAULT '',
  `contextid` bigint(10) NOT NULL,
  `pagehash` varchar(64) NOT NULL DEFAULT '',
  `userid` bigint(10) NOT NULL,
  `drafttext` longtext NOT NULL,
  `draftid` bigint(10) DEFAULT NULL,
  `pageinstance` varchar(64) NOT NULL DEFAULT '',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]editattoauto_eleconu_uix` (`elementid`,`contextid`,`userid`,`pagehash`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Draft text that is auto-saved every 5 seconds while an edito' AUTO_INCREMENT=2 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]enrol`
--

CREATE TABLE `[[dbprefix]]enrol` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `enrol` varchar(20) NOT NULL DEFAULT '',
  `status` bigint(10) NOT NULL DEFAULT '0',
  `courseid` bigint(10) NOT NULL,
  `sortorder` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) DEFAULT NULL,
  `enrolperiod` bigint(10) DEFAULT '0',
  `enrolstartdate` bigint(10) DEFAULT '0',
  `enrolenddate` bigint(10) DEFAULT '0',
  `expirynotify` tinyint(1) DEFAULT '0',
  `expirythreshold` bigint(10) DEFAULT '0',
  `notifyall` tinyint(1) DEFAULT '0',
  `password` varchar(50) DEFAULT NULL,
  `cost` varchar(20) DEFAULT NULL,
  `currency` varchar(3) DEFAULT NULL,
  `roleid` bigint(10) DEFAULT '0',
  `customint1` bigint(10) DEFAULT NULL,
  `customint2` bigint(10) DEFAULT NULL,
  `customint3` bigint(10) DEFAULT NULL,
  `customint4` bigint(10) DEFAULT NULL,
  `customint5` bigint(10) DEFAULT NULL,
  `customint6` bigint(10) DEFAULT NULL,
  `customint7` bigint(10) DEFAULT NULL,
  `customint8` bigint(10) DEFAULT NULL,
  `customchar1` varchar(255) DEFAULT NULL,
  `customchar2` varchar(255) DEFAULT NULL,
  `customchar3` varchar(1333) DEFAULT NULL,
  `customdec1` decimal(12,7) DEFAULT NULL,
  `customdec2` decimal(12,7) DEFAULT NULL,
  `customtext1` longtext,
  `customtext2` longtext,
  `customtext3` longtext,
  `customtext4` longtext,
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]enro_enr_ix` (`enrol`),
  KEY `[[dbprefix]]enro_cou_ix` (`courseid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Instances of enrolment plugins used in courses, fields marke' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]enrol_flatfile`
--

CREATE TABLE `[[dbprefix]]enrol_flatfile` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `action` varchar(30) NOT NULL DEFAULT '',
  `roleid` bigint(10) NOT NULL,
  `userid` bigint(10) NOT NULL,
  `courseid` bigint(10) NOT NULL,
  `timestart` bigint(10) NOT NULL DEFAULT '0',
  `timeend` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]enroflat_cou_ix` (`courseid`),
  KEY `[[dbprefix]]enroflat_use_ix` (`userid`),
  KEY `[[dbprefix]]enroflat_rol_ix` (`roleid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='enrol_flatfile table retrofitted from MySQL' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]enrol_lti_lti2_consumer`
--

CREATE TABLE `[[dbprefix]]enrol_lti_lti2_consumer` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL DEFAULT '',
  `consumerkey256` varchar(255) NOT NULL DEFAULT '',
  `consumerkey` longtext,
  `secret` varchar(1024) NOT NULL DEFAULT '',
  `ltiversion` varchar(10) DEFAULT NULL,
  `consumername` varchar(255) DEFAULT NULL,
  `consumerversion` varchar(255) DEFAULT NULL,
  `consumerguid` varchar(1024) DEFAULT NULL,
  `profile` longtext,
  `toolproxy` longtext,
  `settings` longtext,
  `protected` tinyint(1) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `enablefrom` bigint(10) DEFAULT NULL,
  `enableuntil` bigint(10) DEFAULT NULL,
  `lastaccess` bigint(10) DEFAULT NULL,
  `created` bigint(10) NOT NULL,
  `updated` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]enroltilti2cons_con_uix` (`consumerkey256`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='LTI consumers interacting with moodle' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]enrol_lti_lti2_context`
--

CREATE TABLE `[[dbprefix]]enrol_lti_lti2_context` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT,
  `consumerid` bigint(11) NOT NULL,
  `lticontextkey` varchar(255) NOT NULL DEFAULT '',
  `type` varchar(100) DEFAULT NULL,
  `settings` longtext,
  `created` bigint(10) NOT NULL,
  `updated` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]enroltilti2cont_con_ix` (`consumerid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Information about a specific LTI contexts from the consumers' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]enrol_lti_lti2_nonce`
--

CREATE TABLE `[[dbprefix]]enrol_lti_lti2_nonce` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT,
  `consumerid` bigint(11) NOT NULL,
  `value` varchar(64) NOT NULL DEFAULT '',
  `expires` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]enroltilti2nonc_con_ix` (`consumerid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Nonce used for authentication between moodle and a consumer' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]enrol_lti_lti2_resource_link`
--

CREATE TABLE `[[dbprefix]]enrol_lti_lti2_resource_link` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT,
  `contextid` bigint(11) DEFAULT NULL,
  `consumerid` bigint(11) DEFAULT NULL,
  `ltiresourcelinkkey` varchar(255) NOT NULL DEFAULT '',
  `settings` longtext,
  `primaryresourcelinkid` bigint(11) DEFAULT NULL,
  `shareapproved` tinyint(1) DEFAULT NULL,
  `created` bigint(10) NOT NULL,
  `updated` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]enroltilti2resolink_c_ix` (`contextid`),
  KEY `[[dbprefix]]enroltilti2resolink_p_ix` (`primaryresourcelinkid`),
  KEY `[[dbprefix]]enroltilti2resolink_2_ix` (`consumerid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Link from the consumer to the tool' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]enrol_lti_lti2_share_key`
--

CREATE TABLE `[[dbprefix]]enrol_lti_lti2_share_key` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT,
  `sharekey` varchar(32) NOT NULL DEFAULT '',
  `resourcelinkid` bigint(11) NOT NULL,
  `autoapprove` tinyint(1) NOT NULL,
  `expires` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]enroltilti2sharkey_s_uix` (`sharekey`),
  UNIQUE KEY `[[dbprefix]]enroltilti2sharkey_r_uix` (`resourcelinkid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Resource link share key' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]enrol_lti_lti2_tool_proxy`
--

CREATE TABLE `[[dbprefix]]enrol_lti_lti2_tool_proxy` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT,
  `toolproxykey` varchar(32) NOT NULL DEFAULT '',
  `consumerid` bigint(11) NOT NULL,
  `toolproxy` longtext NOT NULL,
  `created` bigint(10) NOT NULL,
  `updated` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]enroltilti2toolprox__uix` (`toolproxykey`),
  KEY `[[dbprefix]]enroltilti2toolprox_c_ix` (`consumerid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='A tool proxy between moodle and a consumer' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]enrol_lti_lti2_user_result`
--

CREATE TABLE `[[dbprefix]]enrol_lti_lti2_user_result` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT,
  `resourcelinkid` bigint(11) NOT NULL,
  `ltiuserkey` varchar(255) NOT NULL DEFAULT '',
  `ltiresultsourcedid` varchar(1024) NOT NULL DEFAULT '',
  `created` bigint(10) NOT NULL,
  `updated` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]enroltilti2userresu_r_ix` (`resourcelinkid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Results for each user for each resource link' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]enrol_lti_tools`
--

CREATE TABLE `[[dbprefix]]enrol_lti_tools` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `enrolid` bigint(10) NOT NULL,
  `contextid` bigint(10) NOT NULL,
  `institution` varchar(40) NOT NULL DEFAULT '',
  `lang` varchar(30) NOT NULL DEFAULT 'en',
  `timezone` varchar(100) NOT NULL DEFAULT '99',
  `maxenrolled` bigint(10) NOT NULL DEFAULT '0',
  `maildisplay` tinyint(2) NOT NULL DEFAULT '2',
  `city` varchar(120) NOT NULL DEFAULT '',
  `country` varchar(2) NOT NULL DEFAULT '',
  `gradesync` tinyint(1) NOT NULL DEFAULT '0',
  `gradesynccompletion` tinyint(1) NOT NULL DEFAULT '0',
  `membersync` tinyint(1) NOT NULL DEFAULT '0',
  `membersyncmode` tinyint(1) NOT NULL DEFAULT '0',
  `roleinstructor` bigint(10) NOT NULL,
  `rolelearner` bigint(10) NOT NULL,
  `secret` longtext,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]enroltitool_enr_ix` (`enrolid`),
  KEY `[[dbprefix]]enroltitool_con_ix` (`contextid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='List of tools provided to the remote system' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]enrol_lti_tool_consumer_map`
--

CREATE TABLE `[[dbprefix]]enrol_lti_tool_consumer_map` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `toolid` bigint(11) NOT NULL,
  `consumerid` bigint(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]enroltitoolconsmap_to_ix` (`toolid`),
  KEY `[[dbprefix]]enroltitoolconsmap_co_ix` (`consumerid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Table that maps the published tool to tool consumers.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]enrol_lti_users`
--

CREATE TABLE `[[dbprefix]]enrol_lti_users` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL,
  `toolid` bigint(10) NOT NULL,
  `serviceurl` longtext,
  `sourceid` longtext,
  `consumerkey` longtext,
  `consumersecret` longtext,
  `membershipsurl` longtext,
  `membershipsid` longtext,
  `lastgrade` decimal(10,5) DEFAULT NULL,
  `lastaccess` bigint(10) DEFAULT NULL,
  `timecreated` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]enroltiuser_use_ix` (`userid`),
  KEY `[[dbprefix]]enroltiuser_too_ix` (`toolid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='User access log and gradeback data' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]enrol_paypal`
--

CREATE TABLE `[[dbprefix]]enrol_paypal` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `business` varchar(255) NOT NULL DEFAULT '',
  `receiver_email` varchar(255) NOT NULL DEFAULT '',
  `receiver_id` varchar(255) NOT NULL DEFAULT '',
  `item_name` varchar(255) NOT NULL DEFAULT '',
  `courseid` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `instanceid` bigint(10) NOT NULL DEFAULT '0',
  `memo` varchar(255) NOT NULL DEFAULT '',
  `tax` varchar(255) NOT NULL DEFAULT '',
  `option_name1` varchar(255) NOT NULL DEFAULT '',
  `option_selection1_x` varchar(255) NOT NULL DEFAULT '',
  `option_name2` varchar(255) NOT NULL DEFAULT '',
  `option_selection2_x` varchar(255) NOT NULL DEFAULT '',
  `payment_status` varchar(255) NOT NULL DEFAULT '',
  `pending_reason` varchar(255) NOT NULL DEFAULT '',
  `reason_code` varchar(30) NOT NULL DEFAULT '',
  `txn_id` varchar(255) NOT NULL DEFAULT '',
  `parent_txn_id` varchar(255) NOT NULL DEFAULT '',
  `payment_type` varchar(30) NOT NULL DEFAULT '',
  `timeupdated` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]enropayp_bus_ix` (`business`),
  KEY `[[dbprefix]]enropayp_rec_ix` (`receiver_email`),
  KEY `[[dbprefix]]enropayp_cou_ix` (`courseid`),
  KEY `[[dbprefix]]enropayp_use_ix` (`userid`),
  KEY `[[dbprefix]]enropayp_ins_ix` (`instanceid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Holds all known information about PayPal transactions' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]event`
--

CREATE TABLE `[[dbprefix]]event` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` longtext NOT NULL,
  `description` longtext NOT NULL,
  `format` smallint(4) NOT NULL DEFAULT '0',
  `categoryid` bigint(10) NOT NULL DEFAULT '0',
  `courseid` bigint(10) NOT NULL DEFAULT '0',
  `groupid` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `repeatid` bigint(10) NOT NULL DEFAULT '0',
  `modulename` varchar(20) NOT NULL DEFAULT '',
  `instance` bigint(10) NOT NULL DEFAULT '0',
  `type` smallint(4) NOT NULL DEFAULT '0',
  `eventtype` varchar(20) NOT NULL DEFAULT '',
  `timestart` bigint(10) NOT NULL DEFAULT '0',
  `timeduration` bigint(10) NOT NULL DEFAULT '0',
  `timesort` bigint(10) DEFAULT NULL,
  `visible` smallint(4) NOT NULL DEFAULT '1',
  `uuid` varchar(255) NOT NULL DEFAULT '',
  `sequence` bigint(10) NOT NULL DEFAULT '1',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `subscriptionid` bigint(10) DEFAULT NULL,
  `priority` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]even_cou_ix` (`courseid`),
  KEY `[[dbprefix]]even_use_ix` (`userid`),
  KEY `[[dbprefix]]even_tim_ix` (`timestart`),
  KEY `[[dbprefix]]even_tim2_ix` (`timeduration`),
  KEY `[[dbprefix]]even_uui_ix` (`uuid`),
  KEY `[[dbprefix]]even_typtim_ix` (`type`,`timesort`),
  KEY `[[dbprefix]]even_grocoucatvisuse_ix` (`groupid`,`courseid`,`categoryid`,`visible`,`userid`),
  KEY `[[dbprefix]]even_cat_ix` (`categoryid`),
  KEY `[[dbprefix]]even_sub_ix` (`subscriptionid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='For everything with a time associated to it' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]events_handlers`
--

CREATE TABLE `[[dbprefix]]events_handlers` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `eventname` varchar(166) NOT NULL DEFAULT '',
  `component` varchar(166) NOT NULL DEFAULT '',
  `handlerfile` varchar(255) NOT NULL DEFAULT '',
  `handlerfunction` longtext,
  `schedule` varchar(255) DEFAULT NULL,
  `status` bigint(10) NOT NULL DEFAULT '0',
  `internal` tinyint(2) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]evenhand_evecom_uix` (`eventname`,`component`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='This table is for storing which components requests what typ' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]events_queue`
--

CREATE TABLE `[[dbprefix]]events_queue` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `eventdata` longtext NOT NULL,
  `stackdump` longtext,
  `userid` bigint(10) DEFAULT NULL,
  `timecreated` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]evenqueu_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='This table is for storing queued events. It stores only one ' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]events_queue_handlers`
--

CREATE TABLE `[[dbprefix]]events_queue_handlers` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `queuedeventid` bigint(10) NOT NULL,
  `handlerid` bigint(10) NOT NULL,
  `status` bigint(10) DEFAULT NULL,
  `errormessage` longtext,
  `timemodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]evenqueuhand_que_ix` (`queuedeventid`),
  KEY `[[dbprefix]]evenqueuhand_han_ix` (`handlerid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='This is the list of queued handlers for processing. The even' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]event_subscriptions`
--

CREATE TABLE `[[dbprefix]]event_subscriptions` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `url` varchar(255) NOT NULL DEFAULT '',
  `categoryid` bigint(10) NOT NULL DEFAULT '0',
  `courseid` bigint(10) NOT NULL DEFAULT '0',
  `groupid` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `eventtype` varchar(20) NOT NULL DEFAULT '',
  `pollinterval` bigint(10) NOT NULL DEFAULT '0',
  `lastupdated` bigint(10) DEFAULT NULL,
  `name` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Tracks subscriptions to remote calendars.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]external_functions`
--

CREATE TABLE `[[dbprefix]]external_functions` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `classname` varchar(100) NOT NULL DEFAULT '',
  `methodname` varchar(100) NOT NULL DEFAULT '',
  `classpath` varchar(255) DEFAULT NULL,
  `component` varchar(100) NOT NULL DEFAULT '',
  `capabilities` varchar(255) DEFAULT NULL,
  `services` varchar(1333) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]extefunc_nam_uix` (`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='list of all external functions' AUTO_INCREMENT=502 ;

--
-- Dumping data for table `[[dbprefix]]external_functions`
--

INSERT INTO `[[dbprefix]]external_functions` VALUES
(1, 'core_auth_confirm_user', 'core_auth_external', 'confirm_user', NULL, 'moodle', '', NULL),
(2, 'core_auth_request_password_reset', 'core_auth_external', 'request_password_reset', NULL, 'moodle', '', NULL),
(3, 'core_auth_is_minor', 'core_auth_external', 'is_minor', NULL, 'moodle', '', NULL),
(4, 'core_auth_is_age_digital_consent_verification_enabled', 'core_auth_external', 'is_age_digital_consent_verification_enabled', NULL, 'moodle', '', NULL),
(5, 'core_badges_get_user_badges', 'core_badges_external', 'get_user_badges', NULL, 'moodle', 'moodle/badges:viewotherbadges', 'moodle_mobile_app'),
(6, 'core_calendar_get_calendar_monthly_view', 'core_calendar_external', 'get_calendar_monthly_view', 'calendar/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(7, 'core_calendar_get_calendar_day_view', 'core_calendar_external', 'get_calendar_day_view', 'calendar/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(8, 'core_calendar_get_calendar_upcoming_view', 'core_calendar_external', 'get_calendar_upcoming_view', 'calendar/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(9, 'core_calendar_update_event_start_day', 'core_calendar_external', 'update_event_start_day', 'calendar/externallib.php', 'moodle', 'moodle/calendar:manageentries, moodle/calendar:manageownentries, moodle/calendar:managegroupentries', NULL),
(10, 'core_calendar_create_calendar_events', 'core_calendar_external', 'create_calendar_events', 'calendar/externallib.php', 'moodle', 'moodle/calendar:manageentries, moodle/calendar:manageownentries, moodle/calendar:managegroupentries', 'moodle_mobile_app'),
(11, 'core_calendar_delete_calendar_events', 'core_calendar_external', 'delete_calendar_events', 'calendar/externallib.php', 'moodle', 'moodle/calendar:manageentries, moodle/calendar:manageownentries, moodle/calendar:managegroupentries', 'moodle_mobile_app'),
(12, 'core_calendar_get_calendar_events', 'core_calendar_external', 'get_calendar_events', 'calendar/externallib.php', 'moodle', 'moodle/calendar:manageentries, moodle/calendar:manageownentries, moodle/calendar:managegroupentries', 'moodle_mobile_app'),
(13, 'core_calendar_get_action_events_by_timesort', 'core_calendar_external', 'get_calendar_action_events_by_timesort', 'calendar/externallib.php', 'moodle', 'moodle/calendar:manageentries, moodle/calendar:manageownentries, moodle/calendar:managegroupentries', 'moodle_mobile_app'),
(14, 'core_calendar_get_action_events_by_course', 'core_calendar_external', 'get_calendar_action_events_by_course', 'calendar/externallib.php', 'moodle', 'moodle/calendar:manageentries, moodle/calendar:manageownentries, moodle/calendar:managegroupentries', 'moodle_mobile_app'),
(15, 'core_calendar_get_action_events_by_courses', 'core_calendar_external', 'get_calendar_action_events_by_courses', 'calendar/externallib.php', 'moodle', 'moodle/calendar:manageentries, moodle/calendar:manageownentries, moodle/calendar:managegroupentries', 'moodle_mobile_app'),
(16, 'core_calendar_get_calendar_event_by_id', 'core_calendar_external', 'get_calendar_event_by_id', 'calendar/externallib.php', 'moodle', 'moodle/calendar:manageentries, moodle/calendar:manageownentries, moodle/calendar:managegroupentries', 'moodle_mobile_app'),
(17, 'core_calendar_submit_create_update_form', 'core_calendar_external', 'submit_create_update_form', 'calendar/externallib.php', 'moodle', 'moodle/calendar:manageentries, moodle/calendar:manageownentries, moodle/calendar:managegroupentries', NULL),
(18, 'core_cohort_add_cohort_members', 'core_cohort_external', 'add_cohort_members', 'cohort/externallib.php', 'moodle', 'moodle/cohort:assign', NULL),
(19, 'core_cohort_create_cohorts', 'core_cohort_external', 'create_cohorts', 'cohort/externallib.php', 'moodle', 'moodle/cohort:manage', NULL),
(20, 'core_cohort_delete_cohort_members', 'core_cohort_external', 'delete_cohort_members', 'cohort/externallib.php', 'moodle', 'moodle/cohort:assign', NULL),
(21, 'core_cohort_delete_cohorts', 'core_cohort_external', 'delete_cohorts', 'cohort/externallib.php', 'moodle', 'moodle/cohort:manage', NULL),
(22, 'core_cohort_get_cohort_members', 'core_cohort_external', 'get_cohort_members', 'cohort/externallib.php', 'moodle', 'moodle/cohort:view', NULL),
(23, 'core_cohort_search_cohorts', 'core_cohort_external', 'search_cohorts', 'cohort/externallib.php', 'moodle', 'moodle/cohort:view', NULL),
(24, 'core_cohort_get_cohorts', 'core_cohort_external', 'get_cohorts', 'cohort/externallib.php', 'moodle', 'moodle/cohort:view', NULL),
(25, 'core_cohort_update_cohorts', 'core_cohort_external', 'update_cohorts', 'cohort/externallib.php', 'moodle', 'moodle/cohort:manage', NULL),
(26, 'core_comment_get_comments', 'core_comment_external', 'get_comments', NULL, 'moodle', 'moodle/comment:view', 'moodle_mobile_app'),
(27, 'core_completion_get_activities_completion_status', 'core_completion_external', 'get_activities_completion_status', NULL, 'moodle', '', 'moodle_mobile_app'),
(28, 'core_completion_get_course_completion_status', 'core_completion_external', 'get_course_completion_status', NULL, 'moodle', 'report/completion:view', 'moodle_mobile_app'),
(29, 'core_completion_mark_course_self_completed', 'core_completion_external', 'mark_course_self_completed', NULL, 'moodle', '', 'moodle_mobile_app'),
(30, 'core_completion_update_activity_completion_status_manually', 'core_completion_external', 'update_activity_completion_status_manually', NULL, 'moodle', '', 'moodle_mobile_app'),
(31, 'core_completion_override_activity_completion_status', 'core_completion_external', 'override_activity_completion_status', NULL, 'moodle', 'moodle/course:overridecompletion', NULL),
(32, 'core_course_create_categories', 'core_course_external', 'create_categories', 'course/externallib.php', 'moodle', 'moodle/category:manage', NULL),
(33, 'core_course_create_courses', 'core_course_external', 'create_courses', 'course/externallib.php', 'moodle', 'moodle/course:create, moodle/course:visibility', NULL),
(34, 'core_course_delete_categories', 'core_course_external', 'delete_categories', 'course/externallib.php', 'moodle', 'moodle/category:manage', NULL),
(35, 'core_course_delete_courses', 'core_course_external', 'delete_courses', 'course/externallib.php', 'moodle', 'moodle/course:delete', NULL),
(36, 'core_course_delete_modules', 'core_course_external', 'delete_modules', 'course/externallib.php', 'moodle', 'moodle/course:manageactivities', NULL),
(37, 'core_course_duplicate_course', 'core_course_external', 'duplicate_course', 'course/externallib.php', 'moodle', 'moodle/backup:backupcourse, moodle/restore:restorecourse, moodle/course:create', NULL),
(38, 'core_course_get_categories', 'core_course_external', 'get_categories', 'course/externallib.php', 'moodle', 'moodle/category:viewhiddencategories', 'moodle_mobile_app'),
(39, 'core_course_get_contents', 'core_course_external', 'get_course_contents', 'course/externallib.php', 'moodle', 'moodle/course:update, moodle/course:viewhiddencourses', 'moodle_mobile_app'),
(40, 'core_course_get_course_module', 'core_course_external', 'get_course_module', 'course/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(41, 'core_course_get_course_module_by_instance', 'core_course_external', 'get_course_module_by_instance', 'course/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(42, 'core_course_get_module', 'core_course_external', 'get_module', 'course/externallib.php', 'moodle', '', NULL),
(43, 'core_course_edit_module', 'core_course_external', 'edit_module', 'course/externallib.php', 'moodle', '', NULL),
(44, 'core_course_edit_section', 'core_course_external', 'edit_section', 'course/externallib.php', 'moodle', '', NULL),
(45, 'core_course_get_courses', 'core_course_external', 'get_courses', 'course/externallib.php', 'moodle', 'moodle/course:view, moodle/course:update, moodle/course:viewhiddencourses', 'moodle_mobile_app'),
(46, 'core_course_import_course', 'core_course_external', 'import_course', 'course/externallib.php', 'moodle', 'moodle/backup:backuptargetimport, moodle/restore:restoretargetimport', NULL),
(47, 'core_course_search_courses', 'core_course_external', 'search_courses', 'course/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(48, 'core_course_update_categories', 'core_course_external', 'update_categories', 'course/externallib.php', 'moodle', 'moodle/category:manage', NULL),
(49, 'core_course_update_courses', 'core_course_external', 'update_courses', 'course/externallib.php', 'moodle', 'moodle/course:update, moodle/course:changecategory, moodle/course:changefullname, moodle/course:changeshortname, moodle/course:changeidnumber, moodle/course:changesummary, moodle/course:visibility', NULL),
(50, 'core_course_view_course', 'core_course_external', 'view_course', 'course/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(51, 'core_course_get_activities_overview', 'core_course_external', 'get_activities_overview', 'course/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(52, 'core_course_get_user_navigation_options', 'core_course_external', 'get_user_navigation_options', 'course/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(53, 'core_course_get_user_administration_options', 'core_course_external', 'get_user_administration_options', 'course/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(54, 'core_course_get_courses_by_field', 'core_course_external', 'get_courses_by_field', 'course/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(55, 'core_course_check_updates', 'core_course_external', 'check_updates', 'course/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(56, 'core_course_get_updates_since', 'core_course_external', 'get_updates_since', 'course/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(57, 'core_enrol_get_course_enrolment_methods', 'core_enrol_external', 'get_course_enrolment_methods', 'enrol/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(58, 'core_enrol_get_enrolled_users', 'core_enrol_external', 'get_enrolled_users', 'enrol/externallib.php', 'moodle', 'moodle/user:viewdetails, moodle/user:viewhiddendetails, moodle/course:useremail, moodle/user:update, moodle/site:accessallgroups', 'moodle_mobile_app'),
(59, 'core_enrol_get_enrolled_users_with_capability', 'core_enrol_external', 'get_enrolled_users_with_capability', 'enrol/externallib.php', 'moodle', '', NULL),
(60, 'core_enrol_get_potential_users', 'core_enrol_external', 'get_potential_users', 'enrol/externallib.php', 'moodle', 'moodle/course:enrolreview', NULL),
(61, 'core_enrol_get_users_courses', 'core_enrol_external', 'get_users_courses', 'enrol/externallib.php', 'moodle', 'moodle/course:viewparticipants', 'moodle_mobile_app'),
(62, 'core_enrol_edit_user_enrolment', 'core_enrol_external', 'edit_user_enrolment', 'enrol/externallib.php', 'moodle', '', NULL),
(63, 'core_enrol_unenrol_user_enrolment', 'core_enrol_external', 'unenrol_user_enrolment', 'enrol/externallib.php', 'moodle', '', NULL),
(64, 'core_fetch_notifications', 'core_external', 'fetch_notifications', 'lib/external/externallib.php', 'moodle', '', NULL),
(65, 'core_files_get_files', 'core_files_external', 'get_files', 'files/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(66, 'core_files_upload', 'core_files_external', 'upload', 'files/externallib.php', 'moodle', '', NULL),
(67, 'core_form_get_filetypes_browser_data', 'core_form\\external', 'get_filetypes_browser_data', NULL, 'moodle', '', NULL),
(68, 'core_get_component_strings', 'core_external', 'get_component_strings', 'lib/external/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(69, 'core_get_fragment', 'core_external', 'get_fragment', 'lib/external/externallib.php', 'moodle', '', NULL),
(70, 'core_get_string', 'core_external', 'get_string', 'lib/external/externallib.php', 'moodle', '', NULL),
(71, 'core_get_strings', 'core_external', 'get_strings', 'lib/external/externallib.php', 'moodle', '', NULL),
(72, 'core_get_user_dates', 'core_external', 'get_user_dates', 'lib/external/externallib.php', 'moodle', '', NULL),
(73, 'core_grades_get_grades', 'core_grades_external', 'get_grades', NULL, 'moodle', 'moodle/grade:view, moodle/grade:viewall, moodle/grade:viewhidden', NULL),
(74, 'core_grades_update_grades', 'core_grades_external', 'update_grades', NULL, 'moodle', '', NULL),
(75, 'core_grading_get_definitions', 'core_grading_external', 'get_definitions', NULL, 'moodle', '', NULL),
(76, 'core_grading_get_gradingform_instances', 'core_grading_external', 'get_gradingform_instances', NULL, 'moodle', '', NULL),
(77, 'core_grading_save_definitions', 'core_grading_external', 'save_definitions', NULL, 'moodle', '', NULL),
(78, 'core_group_add_group_members', 'core_group_external', 'add_group_members', 'group/externallib.php', 'moodle', 'moodle/course:managegroups', NULL),
(79, 'core_group_assign_grouping', 'core_group_external', 'assign_grouping', 'group/externallib.php', 'moodle', '', NULL),
(80, 'core_group_create_groupings', 'core_group_external', 'create_groupings', 'group/externallib.php', 'moodle', '', NULL),
(81, 'core_group_create_groups', 'core_group_external', 'create_groups', 'group/externallib.php', 'moodle', 'moodle/course:managegroups', NULL),
(82, 'core_group_delete_group_members', 'core_group_external', 'delete_group_members', 'group/externallib.php', 'moodle', 'moodle/course:managegroups', NULL),
(83, 'core_group_delete_groupings', 'core_group_external', 'delete_groupings', 'group/externallib.php', 'moodle', '', NULL),
(84, 'core_group_delete_groups', 'core_group_external', 'delete_groups', 'group/externallib.php', 'moodle', 'moodle/course:managegroups', NULL),
(85, 'core_group_get_activity_allowed_groups', 'core_group_external', 'get_activity_allowed_groups', 'group/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(86, 'core_group_get_activity_groupmode', 'core_group_external', 'get_activity_groupmode', 'group/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(87, 'core_group_get_course_groupings', 'core_group_external', 'get_course_groupings', 'group/externallib.php', 'moodle', '', NULL),
(88, 'core_group_get_course_groups', 'core_group_external', 'get_course_groups', 'group/externallib.php', 'moodle', 'moodle/course:managegroups', NULL),
(89, 'core_group_get_course_user_groups', 'core_group_external', 'get_course_user_groups', 'group/externallib.php', 'moodle', 'moodle/course:managegroups', 'moodle_mobile_app'),
(90, 'core_group_get_group_members', 'core_group_external', 'get_group_members', 'group/externallib.php', 'moodle', 'moodle/course:managegroups', NULL),
(91, 'core_group_get_groupings', 'core_group_external', 'get_groupings', 'group/externallib.php', 'moodle', '', NULL),
(92, 'core_group_get_groups', 'core_group_external', 'get_groups', 'group/externallib.php', 'moodle', 'moodle/course:managegroups', NULL),
(93, 'core_group_unassign_grouping', 'core_group_external', 'unassign_grouping', 'group/externallib.php', 'moodle', '', NULL),
(94, 'core_group_update_groupings', 'core_group_external', 'update_groupings', 'group/externallib.php', 'moodle', '', NULL),
(95, 'core_message_block_contacts', 'core_message_external', 'block_contacts', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(96, 'core_message_create_contacts', 'core_message_external', 'create_contacts', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(97, 'core_message_delete_contacts', 'core_message_external', 'delete_contacts', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(98, 'core_message_delete_conversation', 'core_message_external', 'delete_conversation', 'message/externallib.php', 'moodle', 'moodle/site:deleteownmessage', 'moodle_mobile_app'),
(99, 'core_message_delete_message', 'core_message_external', 'delete_message', 'message/externallib.php', 'moodle', 'moodle/site:deleteownmessage', 'moodle_mobile_app'),
(100, 'core_message_get_blocked_users', 'core_message_external', 'get_blocked_users', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(101, 'core_message_data_for_messagearea_search_messages', 'core_message_external', 'data_for_messagearea_search_messages', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(102, 'core_message_data_for_messagearea_search_users', 'core_message_external', 'data_for_messagearea_search_users', 'message/externallib.php', 'moodle', '', NULL),
(103, 'core_message_data_for_messagearea_search_users_in_course', 'core_message_external', 'data_for_messagearea_search_users_in_course', 'message/externallib.php', 'moodle', '', NULL),
(104, 'core_message_data_for_messagearea_conversations', 'core_message_external', 'data_for_messagearea_conversations', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(105, 'core_message_data_for_messagearea_contacts', 'core_message_external', 'data_for_messagearea_contacts', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(106, 'core_message_data_for_messagearea_messages', 'core_message_external', 'data_for_messagearea_messages', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(107, 'core_message_data_for_messagearea_get_most_recent_message', 'core_message_external', 'data_for_messagearea_get_most_recent_message', 'message/externallib.php', 'moodle', '', NULL),
(108, 'core_message_data_for_messagearea_get_profile', 'core_message_external', 'data_for_messagearea_get_profile', 'message/externallib.php', 'moodle', '', NULL),
(109, 'core_message_get_contacts', 'core_message_external', 'get_contacts', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(110, 'core_message_get_messages', 'core_message_external', 'get_messages', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(111, 'core_message_get_unread_conversations_count', 'core_message_external', 'get_unread_conversations_count', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(112, 'core_message_mark_all_notifications_as_read', 'core_message_external', 'mark_all_notifications_as_read', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(113, 'core_message_mark_all_messages_as_read', 'core_message_external', 'mark_all_messages_as_read', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(114, 'core_message_mark_message_read', 'core_message_external', 'mark_message_read', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(115, 'core_message_mark_notification_read', 'core_message_external', 'mark_notification_read', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(116, 'core_message_message_processor_config_form', 'core_message_external', 'message_processor_config_form', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(117, 'core_message_get_message_processor', 'core_message_external', 'get_message_processor', 'message/externallib.php', 'moodle', '', NULL),
(118, 'core_message_search_contacts', 'core_message_external', 'search_contacts', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(119, 'core_message_send_instant_messages', 'core_message_external', 'send_instant_messages', 'message/externallib.php', 'moodle', 'moodle/site:sendmessage', 'moodle_mobile_app'),
(120, 'core_message_unblock_contacts', 'core_message_external', 'unblock_contacts', 'message/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(121, 'core_message_get_user_notification_preferences', 'core_message_external', 'get_user_notification_preferences', 'message/externallib.php', 'moodle', 'moodle/user:editownmessageprofile', 'moodle_mobile_app'),
(122, 'core_message_get_user_message_preferences', 'core_message_external', 'get_user_message_preferences', 'message/externallib.php', 'moodle', 'moodle/user:editownmessageprofile', 'moodle_mobile_app'),
(123, 'core_notes_create_notes', 'core_notes_external', 'create_notes', 'notes/externallib.php', 'moodle', 'moodle/notes:manage', 'moodle_mobile_app'),
(124, 'core_notes_delete_notes', 'core_notes_external', 'delete_notes', 'notes/externallib.php', 'moodle', 'moodle/notes:manage', 'moodle_mobile_app'),
(125, 'core_notes_get_course_notes', 'core_notes_external', 'get_course_notes', 'notes/externallib.php', 'moodle', 'moodle/notes:view', 'moodle_mobile_app'),
(126, 'core_notes_get_notes', 'core_notes_external', 'get_notes', 'notes/externallib.php', 'moodle', 'moodle/notes:view', NULL),
(127, 'core_notes_update_notes', 'core_notes_external', 'update_notes', 'notes/externallib.php', 'moodle', 'moodle/notes:manage', NULL),
(128, 'core_notes_view_notes', 'core_notes_external', 'view_notes', 'notes/externallib.php', 'moodle', 'moodle/notes:view', 'moodle_mobile_app'),
(129, 'core_output_load_template', 'core\\output\\external', 'load_template', NULL, 'moodle', '', NULL),
(130, 'core_output_load_fontawesome_icon_map', 'core\\output\\external', 'load_fontawesome_icon_map', NULL, 'moodle', '', NULL),
(131, 'core_question_update_flag', 'core_question_external', 'update_flag', NULL, 'moodle', 'moodle/question:flag', 'moodle_mobile_app'),
(132, 'core_question_submit_tags_form', 'core_question_external', 'submit_tags_form', NULL, 'moodle', '', NULL),
(133, 'core_question_get_random_question_summaries', 'core_question_external', 'get_random_question_summaries', NULL, 'moodle', '', NULL),
(134, 'core_rating_get_item_ratings', 'core_rating_external', 'get_item_ratings', NULL, 'moodle', 'moodle/rating:view', 'moodle_mobile_app'),
(135, 'core_rating_add_rating', 'core_rating_external', 'add_rating', NULL, 'moodle', 'moodle/rating:rate', 'moodle_mobile_app'),
(136, 'core_role_assign_roles', 'core_role_external', 'assign_roles', 'enrol/externallib.php', 'moodle', 'moodle/role:assign', NULL),
(137, 'core_role_unassign_roles', 'core_role_external', 'unassign_roles', 'enrol/externallib.php', 'moodle', 'moodle/role:assign', NULL),
(138, 'core_search_get_relevant_users', '\\core_search\\external', 'get_relevant_users', NULL, 'moodle', '', NULL),
(139, 'core_tag_get_tagindex', 'core_tag_external', 'get_tagindex', NULL, 'moodle', '', NULL),
(140, 'core_tag_get_tags', 'core_tag_external', 'get_tags', NULL, 'moodle', '', NULL),
(141, 'core_tag_update_tags', 'core_tag_external', 'update_tags', NULL, 'moodle', '', NULL),
(142, 'core_update_inplace_editable', 'core_external', 'update_inplace_editable', 'lib/external/externallib.php', 'moodle', '', NULL),
(143, 'core_user_add_user_device', 'core_user_external', 'add_user_device', 'user/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(144, 'core_user_add_user_private_files', 'core_user_external', 'add_user_private_files', 'user/externallib.php', 'moodle', 'moodle/user:manageownfiles', 'moodle_mobile_app'),
(145, 'core_user_create_users', 'core_user_external', 'create_users', 'user/externallib.php', 'moodle', 'moodle/user:create', NULL),
(146, 'core_user_delete_users', 'core_user_external', 'delete_users', 'user/externallib.php', 'moodle', 'moodle/user:delete', NULL),
(147, 'core_user_get_course_user_profiles', 'core_user_external', 'get_course_user_profiles', 'user/externallib.php', 'moodle', 'moodle/user:viewdetails, moodle/user:viewhiddendetails, moodle/course:useremail, moodle/user:update, moodle/site:accessallgroups', 'moodle_mobile_app'),
(148, 'core_user_get_users', 'core_user_external', 'get_users', 'user/externallib.php', 'moodle', 'moodle/user:viewdetails, moodle/user:viewhiddendetails, moodle/course:useremail, moodle/user:update', NULL),
(149, 'core_user_get_users_by_field', 'core_user_external', 'get_users_by_field', 'user/externallib.php', 'moodle', 'moodle/user:viewdetails, moodle/user:viewhiddendetails, moodle/course:useremail, moodle/user:update', 'moodle_mobile_app'),
(150, 'core_user_remove_user_device', 'core_user_external', 'remove_user_device', 'user/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(151, 'core_user_update_users', 'core_user_external', 'update_users', 'user/externallib.php', 'moodle', 'moodle/user:update', NULL),
(152, 'core_user_update_user_preferences', 'core_user_external', 'update_user_preferences', 'user/externallib.php', 'moodle', 'moodle/user:editownmessageprofile, moodle/user:editmessageprofile', 'moodle_mobile_app'),
(153, 'core_user_view_user_list', 'core_user_external', 'view_user_list', 'user/externallib.php', 'moodle', 'moodle/course:viewparticipants', 'moodle_mobile_app'),
(154, 'core_user_view_user_profile', 'core_user_external', 'view_user_profile', 'user/externallib.php', 'moodle', 'moodle/user:viewdetails', 'moodle_mobile_app'),
(155, 'core_user_get_user_preferences', 'core_user_external', 'get_user_preferences', 'user/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(156, 'core_user_update_picture', 'core_user_external', 'update_picture', 'user/externallib.php', 'moodle', 'moodle/user:editownprofile, moodle/user:editprofile', 'moodle_mobile_app'),
(157, 'core_user_set_user_preferences', 'core_user_external', 'set_user_preferences', 'user/externallib.php', 'moodle', 'moodle/site:config', NULL),
(158, 'core_user_agree_site_policy', 'core_user_external', 'agree_site_policy', 'user/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(159, 'core_user_get_private_files_info', 'core_user_external', 'get_private_files_info', 'user/externallib.php', 'moodle', 'moodle/user:manageownfiles', 'moodle_mobile_app'),
(160, 'core_competency_create_competency_framework', 'core_competency\\external', 'create_competency_framework', NULL, 'moodle', 'moodle/competency:competencymanage', NULL),
(161, 'core_competency_read_competency_framework', 'core_competency\\external', 'read_competency_framework', NULL, 'moodle', 'moodle/competency:competencyview', NULL),
(162, 'core_competency_duplicate_competency_framework', 'core_competency\\external', 'duplicate_competency_framework', NULL, 'moodle', 'moodle/competency:competencymanage', NULL),
(163, 'core_competency_delete_competency_framework', 'core_competency\\external', 'delete_competency_framework', NULL, 'moodle', 'moodle/competency:competencymanage', NULL),
(164, 'core_competency_update_competency_framework', 'core_competency\\external', 'update_competency_framework', NULL, 'moodle', 'moodle/competency:competencymanage', NULL),
(165, 'core_competency_list_competency_frameworks', 'core_competency\\external', 'list_competency_frameworks', NULL, 'moodle', 'moodle/competency:competencyview', NULL),
(166, 'core_competency_count_competency_frameworks', 'core_competency\\external', 'count_competency_frameworks', NULL, 'moodle', 'moodle/competency:competencyview', NULL),
(167, 'core_competency_competency_framework_viewed', 'core_competency\\external', 'competency_framework_viewed', NULL, 'moodle', 'moodle/competency:competencyview', NULL),
(168, 'core_competency_create_competency', 'core_competency\\external', 'create_competency', NULL, 'moodle', 'moodle/competency:competencymanage', NULL),
(169, 'core_competency_read_competency', 'core_competency\\external', 'read_competency', NULL, 'moodle', 'moodle/competency:competencyview', NULL),
(170, 'core_competency_competency_viewed', 'core_competency\\external', 'competency_viewed', NULL, 'moodle', 'moodle/competency:competencyview', 'moodle_mobile_app'),
(171, 'core_competency_delete_competency', 'core_competency\\external', 'delete_competency', NULL, 'moodle', 'moodle/competency:competencymanage', NULL),
(172, 'core_competency_update_competency', 'core_competency\\external', 'update_competency', NULL, 'moodle', 'moodle/competency:competencymanage', NULL),
(173, 'core_competency_list_competencies', 'core_competency\\external', 'list_competencies', NULL, 'moodle', 'moodle/competency:competencyview', NULL),
(174, 'core_competency_list_competencies_in_template', 'core_competency\\external', 'list_competencies_in_template', NULL, 'moodle', 'moodle/competency:competencyview', NULL),
(175, 'core_competency_count_competencies', 'core_competency\\external', 'count_competencies', NULL, 'moodle', 'moodle/competency:competencyview', NULL),
(176, 'core_competency_count_competencies_in_template', 'core_competency\\external', 'count_competencies_in_template', NULL, 'moodle', 'moodle/competency:competencyview', NULL),
(177, 'core_competency_search_competencies', 'core_competency\\external', 'search_competencies', NULL, 'moodle', 'moodle/competency:competencyview', NULL),
(178, 'core_competency_set_parent_competency', 'core_competency\\external', 'set_parent_competency', NULL, 'moodle', 'moodle/competency:competencymanage', NULL),
(179, 'core_competency_move_up_competency', 'core_competency\\external', 'move_up_competency', NULL, 'moodle', 'moodle/competency:competencymanage', NULL),
(180, 'core_competency_move_down_competency', 'core_competency\\external', 'move_down_competency', NULL, 'moodle', 'moodle/competency:competencymanage', NULL),
(181, 'core_competency_list_course_competencies', 'core_competency\\external', 'list_course_competencies', NULL, 'moodle', 'moodle/competency:coursecompetencyview', 'moodle_mobile_app'),
(182, 'core_competency_count_competencies_in_course', 'core_competency\\external', 'count_competencies_in_course', NULL, 'moodle', 'moodle/competency:coursecompetencyview', NULL),
(183, 'core_competency_count_courses_using_competency', 'core_competency\\external', 'count_courses_using_competency', NULL, 'moodle', 'moodle/competency:coursecompetencyview', NULL),
(184, 'core_competency_add_competency_to_course', 'core_competency\\external', 'add_competency_to_course', NULL, 'moodle', 'moodle/competency:coursecompetencymanage', NULL),
(185, 'core_competency_add_competency_to_template', 'core_competency\\external', 'add_competency_to_template', NULL, 'moodle', 'moodle/competency:templatemanage', NULL),
(186, 'core_competency_remove_competency_from_course', 'core_competency\\external', 'remove_competency_from_course', NULL, 'moodle', 'moodle/competency:coursecompetencymanage', NULL),
(187, 'core_competency_set_course_competency_ruleoutcome', 'core_competency\\external', 'set_course_competency_ruleoutcome', NULL, 'moodle', 'moodle/competency:coursecompetencymanage', NULL),
(188, 'core_competency_remove_competency_from_template', 'core_competency\\external', 'remove_competency_from_template', NULL, 'moodle', 'moodle/competency:templatemanage', NULL),
(189, 'core_competency_reorder_course_competency', 'core_competency\\external', 'reorder_course_competency', NULL, 'moodle', 'moodle/competency:coursecompetencymanage', NULL),
(190, 'core_competency_reorder_template_competency', 'core_competency\\external', 'reorder_template_competency', NULL, 'moodle', 'moodle/competency:templatemanage', NULL),
(191, 'core_competency_create_template', 'core_competency\\external', 'create_template', NULL, 'moodle', 'moodle/competency:templatemanage', NULL),
(192, 'core_competency_duplicate_template', 'core_competency\\external', 'duplicate_template', NULL, 'moodle', 'moodle/competency:templatemanage', NULL),
(193, 'core_competency_read_template', 'core_competency\\external', 'read_template', NULL, 'moodle', 'moodle/competency:templateview', NULL),
(194, 'core_competency_delete_template', 'core_competency\\external', 'delete_template', NULL, 'moodle', 'moodle/competency:templatemanage', NULL),
(195, 'core_competency_update_template', 'core_competency\\external', 'update_template', NULL, 'moodle', 'moodle/competency:templatemanage', NULL),
(196, 'core_competency_list_templates', 'core_competency\\external', 'list_templates', NULL, 'moodle', 'moodle/competency:templateview', NULL),
(197, 'core_competency_list_templates_using_competency', 'core_competency\\external', 'list_templates_using_competency', NULL, 'moodle', 'moodle/competency:templateview', NULL),
(198, 'core_competency_count_templates', 'core_competency\\external', 'count_templates', NULL, 'moodle', 'moodle/competency:templateview', NULL),
(199, 'core_competency_count_templates_using_competency', 'core_competency\\external', 'count_templates_using_competency', NULL, 'moodle', 'moodle/competency:templateview', NULL),
(200, 'core_competency_create_plan', 'core_competency\\external', 'create_plan', NULL, 'moodle', 'moodle/competency:planmanage', NULL),
(201, 'core_competency_update_plan', 'core_competency\\external', 'update_plan', NULL, 'moodle', 'moodle/competency:planmanage', NULL),
(202, 'core_competency_complete_plan', 'core_competency\\external', 'complete_plan', NULL, 'moodle', 'moodle/competency:planmanage', NULL),
(203, 'core_competency_reopen_plan', 'core_competency\\external', 'reopen_plan', NULL, 'moodle', 'moodle/competency:planmanage', NULL),
(204, 'core_competency_read_plan', 'core_competency\\external', 'read_plan', NULL, 'moodle', 'moodle/competency:planviewown', NULL),
(205, 'core_competency_delete_plan', 'core_competency\\external', 'delete_plan', NULL, 'moodle', 'moodle/competency:planmanage', NULL),
(206, 'core_competency_list_user_plans', 'core_competency\\external', 'list_user_plans', NULL, 'moodle', 'moodle/competency:planviewown', NULL),
(207, 'core_competency_list_plan_competencies', 'core_competency\\external', 'list_plan_competencies', NULL, 'moodle', 'moodle/competency:planviewown', NULL),
(208, 'core_competency_add_competency_to_plan', 'core_competency\\external', 'add_competency_to_plan', NULL, 'moodle', 'moodle/competency:planmanage', NULL),
(209, 'core_competency_remove_competency_from_plan', 'core_competency\\external', 'remove_competency_from_plan', NULL, 'moodle', 'moodle/competency:planmanage', NULL),
(210, 'core_competency_reorder_plan_competency', 'core_competency\\external', 'reorder_plan_competency', NULL, 'moodle', 'moodle/competency:planmanage', NULL),
(211, 'core_competency_plan_request_review', 'core_competency\\external', 'plan_request_review', NULL, 'moodle', 'moodle/competency:planmanagedraft', NULL),
(212, 'core_competency_plan_start_review', 'core_competency\\external', 'plan_start_review', NULL, 'moodle', 'moodle/competency:planmanage', NULL),
(213, 'core_competency_plan_stop_review', 'core_competency\\external', 'plan_stop_review', NULL, 'moodle', 'moodle/competency:planmanage', NULL),
(214, 'core_competency_plan_cancel_review_request', 'core_competency\\external', 'plan_cancel_review_request', NULL, 'moodle', 'moodle/competency:planmanagedraft', NULL),
(215, 'core_competency_approve_plan', 'core_competency\\external', 'approve_plan', NULL, 'moodle', 'moodle/competency:planmanage', NULL),
(216, 'core_competency_unapprove_plan', 'core_competency\\external', 'unapprove_plan', NULL, 'moodle', 'moodle/competency:planmanage', NULL),
(217, 'core_competency_template_has_related_data', 'core_competency\\external', 'template_has_related_data', NULL, 'moodle', 'moodle/competency:templateview', NULL),
(218, 'core_competency_get_scale_values', 'core_competency\\external', 'get_scale_values', NULL, 'moodle', 'moodle/competency:competencymanage', 'moodle_mobile_app'),
(219, 'core_competency_add_related_competency', 'core_competency\\external', 'add_related_competency', NULL, 'moodle', 'moodle/competency:competencymanage', NULL),
(220, 'core_competency_remove_related_competency', 'core_competency\\external', 'remove_related_competency', NULL, 'moodle', 'moodle/competency:competencymanage', NULL),
(221, 'core_competency_read_user_evidence', 'core_competency\\external', 'read_user_evidence', NULL, 'moodle', 'moodle/competency:userevidenceview', NULL),
(222, 'core_competency_delete_user_evidence', 'core_competency\\external', 'delete_user_evidence', NULL, 'moodle', 'moodle/competency:userevidencemanageown', NULL),
(223, 'core_competency_create_user_evidence_competency', 'core_competency\\external', 'create_user_evidence_competency', NULL, 'moodle', 'moodle/competency:userevidencemanageown, moodle/competency:competencyview', NULL),
(224, 'core_competency_delete_user_evidence_competency', 'core_competency\\external', 'delete_user_evidence_competency', NULL, 'moodle', 'moodle/competency:userevidencemanageown', NULL),
(225, 'core_competency_user_competency_cancel_review_request', 'core_competency\\external', 'user_competency_cancel_review_request', NULL, 'moodle', 'moodle/competency:userevidencemanageown', NULL),
(226, 'core_competency_user_competency_request_review', 'core_competency\\external', 'user_competency_request_review', NULL, 'moodle', 'moodle/competency:userevidencemanageown', NULL),
(227, 'core_competency_user_competency_start_review', 'core_competency\\external', 'user_competency_start_review', NULL, 'moodle', 'moodle/competency:competencygrade', NULL),
(228, 'core_competency_user_competency_stop_review', 'core_competency\\external', 'user_competency_stop_review', NULL, 'moodle', 'moodle/competency:competencygrade', NULL),
(229, 'core_competency_user_competency_viewed', 'core_competency\\external', 'user_competency_viewed', NULL, 'moodle', 'moodle/competency:usercompetencyview', 'moodle_mobile_app'),
(230, 'core_competency_user_competency_viewed_in_plan', 'core_competency\\external', 'user_competency_viewed_in_plan', NULL, 'moodle', 'moodle/competency:usercompetencyview', 'moodle_mobile_app'),
(231, 'core_competency_user_competency_viewed_in_course', 'core_competency\\external', 'user_competency_viewed_in_course', NULL, 'moodle', 'moodle/competency:usercompetencyview', 'moodle_mobile_app'),
(232, 'core_competency_user_competency_plan_viewed', 'core_competency\\external', 'user_competency_plan_viewed', NULL, 'moodle', 'moodle/competency:usercompetencyview', 'moodle_mobile_app'),
(233, 'core_competency_grade_competency', 'core_competency\\external', 'grade_competency', NULL, 'moodle', 'moodle/competency:competencygrade', NULL),
(234, 'core_competency_grade_competency_in_plan', 'core_competency\\external', 'grade_competency_in_plan', NULL, 'moodle', 'moodle/competency:competencygrade', NULL),
(235, 'core_competency_grade_competency_in_course', 'core_competency\\external', 'grade_competency_in_course', NULL, 'moodle', 'moodle/competency:competencygrade', 'moodle_mobile_app'),
(236, 'core_competency_unlink_plan_from_template', 'core_competency\\external', 'unlink_plan_from_template', NULL, 'moodle', 'moodle/competency:planmanage', NULL),
(237, 'core_competency_template_viewed', 'core_competency\\external', 'template_viewed', NULL, 'moodle', 'moodle/competency:templateview', NULL),
(238, 'core_competency_request_review_of_user_evidence_linked_competencies', 'core_competency\\external', 'request_review_of_user_evidence_linked_competencies', NULL, 'moodle', 'moodle/competency:userevidencemanageown', NULL),
(239, 'core_competency_update_course_competency_settings', 'core_competency\\external', 'update_course_competency_settings', NULL, 'moodle', 'moodle/competency:coursecompetencyconfigure', NULL),
(240, 'core_competency_delete_evidence', 'core_competency\\external', 'delete_evidence', NULL, 'moodle', 'moodle/competency:evidencedelete', 'moodle_mobile_app'),
(241, 'core_webservice_get_site_info', 'core_webservice_external', 'get_site_info', 'webservice/externallib.php', 'moodle', '', 'moodle_mobile_app'),
(242, 'core_block_get_course_blocks', 'core_block_external', 'get_course_blocks', NULL, 'moodle', '', 'moodle_mobile_app'),
(243, 'core_filters_get_available_in_context', 'core_filters\\external', 'get_available_in_context', NULL, 'moodle', '', 'moodle_mobile_app'),
(244, 'mod_assign_copy_previous_attempt', 'mod_assign_external', 'copy_previous_attempt', 'mod/assign/externallib.php', 'mod_assign', 'mod/assign:view, mod/assign:submit', NULL),
(245, 'mod_assign_get_grades', 'mod_assign_external', 'get_grades', 'mod/assign/externallib.php', 'mod_assign', '', 'moodle_mobile_app'),
(246, 'mod_assign_get_assignments', 'mod_assign_external', 'get_assignments', 'mod/assign/externallib.php', 'mod_assign', '', 'moodle_mobile_app'),
(247, 'mod_assign_get_submissions', 'mod_assign_external', 'get_submissions', 'mod/assign/externallib.php', 'mod_assign', '', 'moodle_mobile_app'),
(248, 'mod_assign_get_user_flags', 'mod_assign_external', 'get_user_flags', 'mod/assign/externallib.php', 'mod_assign', '', 'moodle_mobile_app'),
(249, 'mod_assign_set_user_flags', 'mod_assign_external', 'set_user_flags', 'mod/assign/externallib.php', 'mod_assign', 'mod/assign:grade', 'moodle_mobile_app'),
(250, 'mod_assign_get_user_mappings', 'mod_assign_external', 'get_user_mappings', 'mod/assign/externallib.php', 'mod_assign', '', 'moodle_mobile_app'),
(251, 'mod_assign_revert_submissions_to_draft', 'mod_assign_external', 'revert_submissions_to_draft', 'mod/assign/externallib.php', 'mod_assign', '', 'moodle_mobile_app'),
(252, 'mod_assign_lock_submissions', 'mod_assign_external', 'lock_submissions', 'mod/assign/externallib.php', 'mod_assign', '', 'moodle_mobile_app'),
(253, 'mod_assign_unlock_submissions', 'mod_assign_external', 'unlock_submissions', 'mod/assign/externallib.php', 'mod_assign', '', 'moodle_mobile_app'),
(254, 'mod_assign_save_submission', 'mod_assign_external', 'save_submission', 'mod/assign/externallib.php', 'mod_assign', '', 'moodle_mobile_app'),
(255, 'mod_assign_submit_for_grading', 'mod_assign_external', 'submit_for_grading', 'mod/assign/externallib.php', 'mod_assign', '', 'moodle_mobile_app'),
(256, 'mod_assign_save_grade', 'mod_assign_external', 'save_grade', 'mod/assign/externallib.php', 'mod_assign', '', 'moodle_mobile_app'),
(257, 'mod_assign_save_grades', 'mod_assign_external', 'save_grades', 'mod/assign/externallib.php', 'mod_assign', '', 'moodle_mobile_app'),
(258, 'mod_assign_save_user_extensions', 'mod_assign_external', 'save_user_extensions', 'mod/assign/externallib.php', 'mod_assign', '', 'moodle_mobile_app'),
(259, 'mod_assign_reveal_identities', 'mod_assign_external', 'reveal_identities', 'mod/assign/externallib.php', 'mod_assign', '', 'moodle_mobile_app'),
(260, 'mod_assign_view_grading_table', 'mod_assign_external', 'view_grading_table', 'mod/assign/externallib.php', 'mod_assign', 'mod/assign:view, mod/assign:viewgrades', 'moodle_mobile_app'),
(261, 'mod_assign_view_submission_status', 'mod_assign_external', 'view_submission_status', 'mod/assign/externallib.php', 'mod_assign', 'mod/assign:view', 'moodle_mobile_app'),
(262, 'mod_assign_get_submission_status', 'mod_assign_external', 'get_submission_status', 'mod/assign/externallib.php', 'mod_assign', 'mod/assign:view', 'moodle_mobile_app'),
(263, 'mod_assign_list_participants', 'mod_assign_external', 'list_participants', 'mod/assign/externallib.php', 'mod_assign', 'mod/assign:view, mod/assign:viewgrades', 'moodle_mobile_app'),
(264, 'mod_assign_submit_grading_form', 'mod_assign_external', 'submit_grading_form', 'mod/assign/externallib.php', 'mod_assign', 'mod/assign:grade', 'moodle_mobile_app'),
(265, 'mod_assign_get_participant', 'mod_assign_external', 'get_participant', 'mod/assign/externallib.php', 'mod_assign', 'mod/assign:view, mod/assign:viewgrades', 'moodle_mobile_app'),
(266, 'mod_assign_view_assign', 'mod_assign_external', 'view_assign', 'mod/assign/externallib.php', 'mod_assign', 'mod/assign:view', 'moodle_mobile_app'),
(267, 'mod_book_view_book', 'mod_book_external', 'view_book', NULL, 'mod_book', 'mod/book:read', 'moodle_mobile_app'),
(268, 'mod_book_get_books_by_courses', 'mod_book_external', 'get_books_by_courses', NULL, 'mod_book', '', 'moodle_mobile_app'),
(269, 'mod_chat_login_user', 'mod_chat_external', 'login_user', NULL, 'mod_chat', 'mod/chat:chat', 'moodle_mobile_app'),
(270, 'mod_chat_get_chat_users', 'mod_chat_external', 'get_chat_users', NULL, 'mod_chat', 'mod/chat:chat', 'moodle_mobile_app'),
(271, 'mod_chat_send_chat_message', 'mod_chat_external', 'send_chat_message', NULL, 'mod_chat', 'mod/chat:chat', 'moodle_mobile_app'),
(272, 'mod_chat_get_chat_latest_messages', 'mod_chat_external', 'get_chat_latest_messages', NULL, 'mod_chat', 'mod/chat:chat', 'moodle_mobile_app'),
(273, 'mod_chat_view_chat', 'mod_chat_external', 'view_chat', NULL, 'mod_chat', 'mod/chat:chat', 'moodle_mobile_app'),
(274, 'mod_chat_get_chats_by_courses', 'mod_chat_external', 'get_chats_by_courses', NULL, 'mod_chat', '', 'moodle_mobile_app'),
(275, 'mod_chat_get_sessions', 'mod_chat_external', 'get_sessions', NULL, 'mod_chat', '', 'moodle_mobile_app'),
(276, 'mod_chat_get_session_messages', 'mod_chat_external', 'get_session_messages', NULL, 'mod_chat', '', 'moodle_mobile_app'),
(277, 'mod_choice_get_choice_results', 'mod_choice_external', 'get_choice_results', NULL, 'mod_choice', '', 'moodle_mobile_app'),
(278, 'mod_choice_get_choice_options', 'mod_choice_external', 'get_choice_options', NULL, 'mod_choice', 'mod/choice:choose', 'moodle_mobile_app'),
(279, 'mod_choice_submit_choice_response', 'mod_choice_external', 'submit_choice_response', NULL, 'mod_choice', 'mod/choice:choose', 'moodle_mobile_app'),
(280, 'mod_choice_view_choice', 'mod_choice_external', 'view_choice', NULL, 'mod_choice', '', 'moodle_mobile_app'),
(281, 'mod_choice_get_choices_by_courses', 'mod_choice_external', 'get_choices_by_courses', NULL, 'mod_choice', '', 'moodle_mobile_app'),
(282, 'mod_choice_delete_choice_responses', 'mod_choice_external', 'delete_choice_responses', NULL, 'mod_choice', 'mod/choice:choose', 'moodle_mobile_app'),
(283, 'mod_data_get_databases_by_courses', 'mod_data_external', 'get_databases_by_courses', NULL, 'mod_data', 'mod/data:viewentry', 'moodle_mobile_app'),
(284, 'mod_data_view_database', 'mod_data_external', 'view_database', NULL, 'mod_data', 'mod/data:viewentry', 'moodle_mobile_app'),
(285, 'mod_data_get_data_access_information', 'mod_data_external', 'get_data_access_information', NULL, 'mod_data', 'mod/data:viewentry', 'moodle_mobile_app'),
(286, 'mod_data_get_entries', 'mod_data_external', 'get_entries', NULL, 'mod_data', 'mod/data:viewentry', 'moodle_mobile_app'),
(287, 'mod_data_get_entry', 'mod_data_external', 'get_entry', NULL, 'mod_data', 'mod/data:viewentry', 'moodle_mobile_app'),
(288, 'mod_data_get_fields', 'mod_data_external', 'get_fields', NULL, 'mod_data', 'mod/data:viewentry', 'moodle_mobile_app'),
(289, 'mod_data_search_entries', 'mod_data_external', 'search_entries', NULL, 'mod_data', 'mod/data:viewentry', 'moodle_mobile_app'),
(290, 'mod_data_approve_entry', 'mod_data_external', 'approve_entry', NULL, 'mod_data', 'mod/data:approve', 'moodle_mobile_app'),
(291, 'mod_data_delete_entry', 'mod_data_external', 'delete_entry', NULL, 'mod_data', 'mod/data:manageentries', 'moodle_mobile_app'),
(292, 'mod_data_add_entry', 'mod_data_external', 'add_entry', NULL, 'mod_data', 'mod/data:writeentry', 'moodle_mobile_app'),
(293, 'mod_data_update_entry', 'mod_data_external', 'update_entry', NULL, 'mod_data', 'mod/data:writeentry', 'moodle_mobile_app'),
(294, 'mod_feedback_get_feedbacks_by_courses', 'mod_feedback_external', 'get_feedbacks_by_courses', NULL, 'mod_feedback', 'mod/feedback:view', 'moodle_mobile_app'),
(295, 'mod_feedback_get_feedback_access_information', 'mod_feedback_external', 'get_feedback_access_information', NULL, 'mod_feedback', 'mod/feedback:view', 'moodle_mobile_app'),
(296, 'mod_feedback_view_feedback', 'mod_feedback_external', 'view_feedback', NULL, 'mod_feedback', 'mod/feedback:view', 'moodle_mobile_app'),
(297, 'mod_feedback_get_current_completed_tmp', 'mod_feedback_external', 'get_current_completed_tmp', NULL, 'mod_feedback', 'mod/feedback:view', 'moodle_mobile_app'),
(298, 'mod_feedback_get_items', 'mod_feedback_external', 'get_items', NULL, 'mod_feedback', 'mod/feedback:view', 'moodle_mobile_app'),
(299, 'mod_feedback_launch_feedback', 'mod_feedback_external', 'launch_feedback', NULL, 'mod_feedback', 'mod/feedback:complete', 'moodle_mobile_app'),
(300, 'mod_feedback_get_page_items', 'mod_feedback_external', 'get_page_items', NULL, 'mod_feedback', 'mod/feedback:complete', 'moodle_mobile_app'),
(301, 'mod_feedback_process_page', 'mod_feedback_external', 'process_page', NULL, 'mod_feedback', 'mod/feedback:complete', 'moodle_mobile_app'),
(302, 'mod_feedback_get_analysis', 'mod_feedback_external', 'get_analysis', NULL, 'mod_feedback', 'mod/feedback:viewanalysepage', 'moodle_mobile_app'),
(303, 'mod_feedback_get_unfinished_responses', 'mod_feedback_external', 'get_unfinished_responses', NULL, 'mod_feedback', 'mod/feedback:view', 'moodle_mobile_app'),
(304, 'mod_feedback_get_finished_responses', 'mod_feedback_external', 'get_finished_responses', NULL, 'mod_feedback', 'mod/feedback:view', 'moodle_mobile_app'),
(305, 'mod_feedback_get_non_respondents', 'mod_feedback_external', 'get_non_respondents', NULL, 'mod_feedback', 'mod/feedback:viewreports', 'moodle_mobile_app'),
(306, 'mod_feedback_get_responses_analysis', 'mod_feedback_external', 'get_responses_analysis', NULL, 'mod_feedback', 'mod/feedback:viewreports', 'moodle_mobile_app'),
(307, 'mod_feedback_get_last_completed', 'mod_feedback_external', 'get_last_completed', NULL, 'mod_feedback', 'mod/feedback:view', 'moodle_mobile_app'),
(308, 'mod_folder_view_folder', 'mod_folder_external', 'view_folder', NULL, 'mod_folder', 'mod/folder:view', 'moodle_mobile_app'),
(309, 'mod_folder_get_folders_by_courses', 'mod_folder_external', 'get_folders_by_courses', NULL, 'mod_folder', 'mod/folder:view', 'moodle_mobile_app'),
(310, 'mod_forum_get_forums_by_courses', 'mod_forum_external', 'get_forums_by_courses', 'mod/forum/externallib.php', 'mod_forum', 'mod/forum:viewdiscussion', 'moodle_mobile_app'),
(311, 'mod_forum_get_forum_discussion_posts', 'mod_forum_external', 'get_forum_discussion_posts', 'mod/forum/externallib.php', 'mod_forum', 'mod/forum:viewdiscussion, mod/forum:viewqandawithoutposting', 'moodle_mobile_app'),
(312, 'mod_forum_get_forum_discussions_paginated', 'mod_forum_external', 'get_forum_discussions_paginated', 'mod/forum/externallib.php', 'mod_forum', 'mod/forum:viewdiscussion, mod/forum:viewqandawithoutposting', 'moodle_mobile_app'),
(313, 'mod_forum_view_forum', 'mod_forum_external', 'view_forum', 'mod/forum/externallib.php', 'mod_forum', 'mod/forum:viewdiscussion', 'moodle_mobile_app'),
(314, 'mod_forum_view_forum_discussion', 'mod_forum_external', 'view_forum_discussion', 'mod/forum/externallib.php', 'mod_forum', 'mod/forum:viewdiscussion', 'moodle_mobile_app'),
(315, 'mod_forum_add_discussion_post', 'mod_forum_external', 'add_discussion_post', 'mod/forum/externallib.php', 'mod_forum', 'mod/forum:replypost', 'moodle_mobile_app'),
(316, 'mod_forum_add_discussion', 'mod_forum_external', 'add_discussion', 'mod/forum/externallib.php', 'mod_forum', 'mod/forum:startdiscussion', 'moodle_mobile_app'),
(317, 'mod_forum_can_add_discussion', 'mod_forum_external', 'can_add_discussion', 'mod/forum/externallib.php', 'mod_forum', '', 'moodle_mobile_app'),
(318, 'mod_glossary_get_glossaries_by_courses', 'mod_glossary_external', 'get_glossaries_by_courses', NULL, 'mod_glossary', 'mod/glossary:view', 'moodle_mobile_app'),
(319, 'mod_glossary_view_glossary', 'mod_glossary_external', 'view_glossary', NULL, 'mod_glossary', 'mod/glossary:view', 'moodle_mobile_app');
INSERT INTO `[[dbprefix]]external_functions` VALUES
(320, 'mod_glossary_view_entry', 'mod_glossary_external', 'view_entry', NULL, 'mod_glossary', 'mod/glossary:view', 'moodle_mobile_app'),
(321, 'mod_glossary_get_entries_by_letter', 'mod_glossary_external', 'get_entries_by_letter', NULL, 'mod_glossary', 'mod/glossary:view', 'moodle_mobile_app'),
(322, 'mod_glossary_get_entries_by_date', 'mod_glossary_external', 'get_entries_by_date', NULL, 'mod_glossary', 'mod/glossary:view', 'moodle_mobile_app'),
(323, 'mod_glossary_get_categories', 'mod_glossary_external', 'get_categories', NULL, 'mod_glossary', 'mod/glossary:view', 'moodle_mobile_app'),
(324, 'mod_glossary_get_entries_by_category', 'mod_glossary_external', 'get_entries_by_category', NULL, 'mod_glossary', 'mod/glossary:view', 'moodle_mobile_app'),
(325, 'mod_glossary_get_authors', 'mod_glossary_external', 'get_authors', NULL, 'mod_glossary', 'mod/glossary:view', 'moodle_mobile_app'),
(326, 'mod_glossary_get_entries_by_author', 'mod_glossary_external', 'get_entries_by_author', NULL, 'mod_glossary', 'mod/glossary:view', 'moodle_mobile_app'),
(327, 'mod_glossary_get_entries_by_author_id', 'mod_glossary_external', 'get_entries_by_author_id', NULL, 'mod_glossary', 'mod/glossary:view', 'moodle_mobile_app'),
(328, 'mod_glossary_get_entries_by_search', 'mod_glossary_external', 'get_entries_by_search', NULL, 'mod_glossary', 'mod/glossary:view', 'moodle_mobile_app'),
(329, 'mod_glossary_get_entries_by_term', 'mod_glossary_external', 'get_entries_by_term', NULL, 'mod_glossary', 'mod/glossary:view', 'moodle_mobile_app'),
(330, 'mod_glossary_get_entries_to_approve', 'mod_glossary_external', 'get_entries_to_approve', NULL, 'mod_glossary', 'mod/glossary:approve', 'moodle_mobile_app'),
(331, 'mod_glossary_get_entry_by_id', 'mod_glossary_external', 'get_entry_by_id', NULL, 'mod_glossary', 'mod/glossary:view', 'moodle_mobile_app'),
(332, 'mod_glossary_add_entry', 'mod_glossary_external', 'add_entry', NULL, 'mod_glossary', 'mod/glossary:write', 'moodle_mobile_app'),
(333, 'mod_imscp_view_imscp', 'mod_imscp_external', 'view_imscp', NULL, 'mod_imscp', 'mod/imscp:view', 'moodle_mobile_app'),
(334, 'mod_imscp_get_imscps_by_courses', 'mod_imscp_external', 'get_imscps_by_courses', NULL, 'mod_imscp', 'mod/imscp:view', 'moodle_mobile_app'),
(335, 'mod_label_get_labels_by_courses', 'mod_label_external', 'get_labels_by_courses', NULL, 'mod_label', 'mod/label:view', 'moodle_mobile_app'),
(336, 'mod_lesson_get_lessons_by_courses', 'mod_lesson_external', 'get_lessons_by_courses', NULL, 'mod_lesson', 'mod/lesson:view', 'moodle_mobile_app'),
(337, 'mod_lesson_get_lesson_access_information', 'mod_lesson_external', 'get_lesson_access_information', NULL, 'mod_lesson', 'mod/lesson:view', 'moodle_mobile_app'),
(338, 'mod_lesson_view_lesson', 'mod_lesson_external', 'view_lesson', NULL, 'mod_lesson', 'mod/lesson:view', 'moodle_mobile_app'),
(339, 'mod_lesson_get_questions_attempts', 'mod_lesson_external', 'get_questions_attempts', NULL, 'mod_lesson', 'mod/lesson:view', 'moodle_mobile_app'),
(340, 'mod_lesson_get_user_grade', 'mod_lesson_external', 'get_user_grade', NULL, 'mod_lesson', 'mod/lesson:view', 'moodle_mobile_app'),
(341, 'mod_lesson_get_user_attempt_grade', 'mod_lesson_external', 'get_user_attempt_grade', NULL, 'mod_lesson', 'mod/lesson:view', 'moodle_mobile_app'),
(342, 'mod_lesson_get_content_pages_viewed', 'mod_lesson_external', 'get_content_pages_viewed', NULL, 'mod_lesson', 'mod/lesson:view', 'moodle_mobile_app'),
(343, 'mod_lesson_get_user_timers', 'mod_lesson_external', 'get_user_timers', NULL, 'mod_lesson', 'mod/lesson:view', 'moodle_mobile_app'),
(344, 'mod_lesson_get_pages', 'mod_lesson_external', 'get_pages', NULL, 'mod_lesson', 'mod/lesson:view', 'moodle_mobile_app'),
(345, 'mod_lesson_launch_attempt', 'mod_lesson_external', 'launch_attempt', NULL, 'mod_lesson', 'mod/lesson:view', 'moodle_mobile_app'),
(346, 'mod_lesson_get_page_data', 'mod_lesson_external', 'get_page_data', NULL, 'mod_lesson', 'mod/lesson:view', 'moodle_mobile_app'),
(347, 'mod_lesson_process_page', 'mod_lesson_external', 'process_page', NULL, 'mod_lesson', 'mod/lesson:view', 'moodle_mobile_app'),
(348, 'mod_lesson_finish_attempt', 'mod_lesson_external', 'finish_attempt', NULL, 'mod_lesson', 'mod/lesson:view', 'moodle_mobile_app'),
(349, 'mod_lesson_get_attempts_overview', 'mod_lesson_external', 'get_attempts_overview', NULL, 'mod_lesson', 'mod/lesson:viewreports', 'moodle_mobile_app'),
(350, 'mod_lesson_get_user_attempt', 'mod_lesson_external', 'get_user_attempt', NULL, 'mod_lesson', 'mod/lesson:viewreports', 'moodle_mobile_app'),
(351, 'mod_lesson_get_pages_possible_jumps', 'mod_lesson_external', 'get_pages_possible_jumps', NULL, 'mod_lesson', 'mod/lesson:view', 'moodle_mobile_app'),
(352, 'mod_lesson_get_lesson', 'mod_lesson_external', 'get_lesson', NULL, 'mod_lesson', 'mod/lesson:view', 'moodle_mobile_app'),
(353, 'mod_lti_get_tool_launch_data', 'mod_lti_external', 'get_tool_launch_data', NULL, 'mod_lti', 'mod/lti:view', 'moodle_mobile_app'),
(354, 'mod_lti_get_ltis_by_courses', 'mod_lti_external', 'get_ltis_by_courses', NULL, 'mod_lti', 'mod/lti:view', 'moodle_mobile_app'),
(355, 'mod_lti_view_lti', 'mod_lti_external', 'view_lti', NULL, 'mod_lti', 'mod/lti:view', 'moodle_mobile_app'),
(356, 'mod_lti_get_tool_proxies', 'mod_lti_external', 'get_tool_proxies', NULL, 'mod_lti', 'moodle/site:config', NULL),
(357, 'mod_lti_create_tool_proxy', 'mod_lti_external', 'create_tool_proxy', NULL, 'mod_lti', 'moodle/site:config', NULL),
(358, 'mod_lti_delete_tool_proxy', 'mod_lti_external', 'delete_tool_proxy', NULL, 'mod_lti', 'moodle/site:config', NULL),
(359, 'mod_lti_get_tool_proxy_registration_request', 'mod_lti_external', 'get_tool_proxy_registration_request', NULL, 'mod_lti', 'moodle/site:config', NULL),
(360, 'mod_lti_get_tool_types', 'mod_lti_external', 'get_tool_types', NULL, 'mod_lti', 'moodle/site:config', NULL),
(361, 'mod_lti_create_tool_type', 'mod_lti_external', 'create_tool_type', NULL, 'mod_lti', 'moodle/site:config', NULL),
(362, 'mod_lti_update_tool_type', 'mod_lti_external', 'update_tool_type', NULL, 'mod_lti', 'moodle/site:config', NULL),
(363, 'mod_lti_delete_tool_type', 'mod_lti_external', 'delete_tool_type', NULL, 'mod_lti', 'moodle/site:config', NULL),
(364, 'mod_lti_is_cartridge', 'mod_lti_external', 'is_cartridge', NULL, 'mod_lti', 'moodle/site:config', NULL),
(365, 'mod_page_view_page', 'mod_page_external', 'view_page', NULL, 'mod_page', 'mod/page:view', 'moodle_mobile_app'),
(366, 'mod_page_get_pages_by_courses', 'mod_page_external', 'get_pages_by_courses', NULL, 'mod_page', 'mod/page:view', 'moodle_mobile_app'),
(367, 'mod_quiz_get_quizzes_by_courses', 'mod_quiz_external', 'get_quizzes_by_courses', NULL, 'mod_quiz', 'mod/quiz:view', 'moodle_mobile_app'),
(368, 'mod_quiz_view_quiz', 'mod_quiz_external', 'view_quiz', NULL, 'mod_quiz', 'mod/quiz:view', 'moodle_mobile_app'),
(369, 'mod_quiz_get_user_attempts', 'mod_quiz_external', 'get_user_attempts', NULL, 'mod_quiz', 'mod/quiz:view', 'moodle_mobile_app'),
(370, 'mod_quiz_get_user_best_grade', 'mod_quiz_external', 'get_user_best_grade', NULL, 'mod_quiz', 'mod/quiz:view', 'moodle_mobile_app'),
(371, 'mod_quiz_get_combined_review_options', 'mod_quiz_external', 'get_combined_review_options', NULL, 'mod_quiz', 'mod/quiz:view', 'moodle_mobile_app'),
(372, 'mod_quiz_start_attempt', 'mod_quiz_external', 'start_attempt', NULL, 'mod_quiz', 'mod/quiz:attempt', 'moodle_mobile_app'),
(373, 'mod_quiz_get_attempt_data', 'mod_quiz_external', 'get_attempt_data', NULL, 'mod_quiz', 'mod/quiz:attempt', 'moodle_mobile_app'),
(374, 'mod_quiz_get_attempt_summary', 'mod_quiz_external', 'get_attempt_summary', NULL, 'mod_quiz', 'mod/quiz:attempt', 'moodle_mobile_app'),
(375, 'mod_quiz_save_attempt', 'mod_quiz_external', 'save_attempt', NULL, 'mod_quiz', 'mod/quiz:attempt', 'moodle_mobile_app'),
(376, 'mod_quiz_process_attempt', 'mod_quiz_external', 'process_attempt', NULL, 'mod_quiz', 'mod/quiz:attempt', 'moodle_mobile_app'),
(377, 'mod_quiz_get_attempt_review', 'mod_quiz_external', 'get_attempt_review', NULL, 'mod_quiz', 'mod/quiz:reviewmyattempts', 'moodle_mobile_app'),
(378, 'mod_quiz_view_attempt', 'mod_quiz_external', 'view_attempt', NULL, 'mod_quiz', 'mod/quiz:attempt', 'moodle_mobile_app'),
(379, 'mod_quiz_view_attempt_summary', 'mod_quiz_external', 'view_attempt_summary', NULL, 'mod_quiz', 'mod/quiz:attempt', 'moodle_mobile_app'),
(380, 'mod_quiz_view_attempt_review', 'mod_quiz_external', 'view_attempt_review', NULL, 'mod_quiz', 'mod/quiz:reviewmyattempts', 'moodle_mobile_app'),
(381, 'mod_quiz_get_quiz_feedback_for_grade', 'mod_quiz_external', 'get_quiz_feedback_for_grade', NULL, 'mod_quiz', 'mod/quiz:view', 'moodle_mobile_app'),
(382, 'mod_quiz_get_quiz_access_information', 'mod_quiz_external', 'get_quiz_access_information', NULL, 'mod_quiz', 'mod/quiz:view', 'moodle_mobile_app'),
(383, 'mod_quiz_get_attempt_access_information', 'mod_quiz_external', 'get_attempt_access_information', NULL, 'mod_quiz', 'mod/quiz:view', 'moodle_mobile_app'),
(384, 'mod_quiz_get_quiz_required_qtypes', 'mod_quiz_external', 'get_quiz_required_qtypes', NULL, 'mod_quiz', 'mod/quiz:view', 'moodle_mobile_app'),
(385, 'mod_resource_view_resource', 'mod_resource_external', 'view_resource', NULL, 'mod_resource', 'mod/resource:view', 'moodle_mobile_app'),
(386, 'mod_resource_get_resources_by_courses', 'mod_resource_external', 'get_resources_by_courses', NULL, 'mod_resource', 'mod/resource:view', 'moodle_mobile_app'),
(387, 'mod_scorm_view_scorm', 'mod_scorm_external', 'view_scorm', NULL, 'mod_scorm', '', 'moodle_mobile_app'),
(388, 'mod_scorm_get_scorm_attempt_count', 'mod_scorm_external', 'get_scorm_attempt_count', NULL, 'mod_scorm', '', 'moodle_mobile_app'),
(389, 'mod_scorm_get_scorm_scoes', 'mod_scorm_external', 'get_scorm_scoes', NULL, 'mod_scorm', '', 'moodle_mobile_app'),
(390, 'mod_scorm_get_scorm_user_data', 'mod_scorm_external', 'get_scorm_user_data', NULL, 'mod_scorm', '', 'moodle_mobile_app'),
(391, 'mod_scorm_insert_scorm_tracks', 'mod_scorm_external', 'insert_scorm_tracks', NULL, 'mod_scorm', 'mod/scorm:savetrack', 'moodle_mobile_app'),
(392, 'mod_scorm_get_scorm_sco_tracks', 'mod_scorm_external', 'get_scorm_sco_tracks', NULL, 'mod_scorm', '', 'moodle_mobile_app'),
(393, 'mod_scorm_get_scorms_by_courses', 'mod_scorm_external', 'get_scorms_by_courses', NULL, 'mod_scorm', '', 'moodle_mobile_app'),
(394, 'mod_scorm_launch_sco', 'mod_scorm_external', 'launch_sco', NULL, 'mod_scorm', '', 'moodle_mobile_app'),
(395, 'mod_survey_get_surveys_by_courses', 'mod_survey_external', 'get_surveys_by_courses', NULL, 'mod_survey', '', 'moodle_mobile_app'),
(396, 'mod_survey_view_survey', 'mod_survey_external', 'view_survey', NULL, 'mod_survey', 'mod/survey:participate', 'moodle_mobile_app'),
(397, 'mod_survey_get_questions', 'mod_survey_external', 'get_questions', NULL, 'mod_survey', 'mod/survey:participate', 'moodle_mobile_app'),
(398, 'mod_survey_submit_answers', 'mod_survey_external', 'submit_answers', NULL, 'mod_survey', 'mod/survey:participate', 'moodle_mobile_app'),
(399, 'mod_url_view_url', 'mod_url_external', 'view_url', NULL, 'mod_url', 'mod/url:view', 'moodle_mobile_app'),
(400, 'mod_url_get_urls_by_courses', 'mod_url_external', 'get_urls_by_courses', NULL, 'mod_url', 'mod/url:view', 'moodle_mobile_app'),
(401, 'mod_wiki_get_wikis_by_courses', 'mod_wiki_external', 'get_wikis_by_courses', NULL, 'mod_wiki', 'mod/wiki:viewpage', 'moodle_mobile_app'),
(402, 'mod_wiki_view_wiki', 'mod_wiki_external', 'view_wiki', NULL, 'mod_wiki', 'mod/wiki:viewpage', 'moodle_mobile_app'),
(403, 'mod_wiki_view_page', 'mod_wiki_external', 'view_page', NULL, 'mod_wiki', 'mod/wiki:viewpage', 'moodle_mobile_app'),
(404, 'mod_wiki_get_subwikis', 'mod_wiki_external', 'get_subwikis', NULL, 'mod_wiki', 'mod/wiki:viewpage', 'moodle_mobile_app'),
(405, 'mod_wiki_get_subwiki_pages', 'mod_wiki_external', 'get_subwiki_pages', NULL, 'mod_wiki', 'mod/wiki:viewpage', 'moodle_mobile_app'),
(406, 'mod_wiki_get_subwiki_files', 'mod_wiki_external', 'get_subwiki_files', NULL, 'mod_wiki', 'mod/wiki:viewpage', 'moodle_mobile_app'),
(407, 'mod_wiki_get_page_contents', 'mod_wiki_external', 'get_page_contents', NULL, 'mod_wiki', 'mod/wiki:viewpage', 'moodle_mobile_app'),
(408, 'mod_wiki_get_page_for_editing', 'mod_wiki_external', 'get_page_for_editing', NULL, 'mod_wiki', 'mod/wiki:editpage', 'moodle_mobile_app'),
(409, 'mod_wiki_new_page', 'mod_wiki_external', 'new_page', NULL, 'mod_wiki', 'mod/wiki:editpage', 'moodle_mobile_app'),
(410, 'mod_wiki_edit_page', 'mod_wiki_external', 'edit_page', NULL, 'mod_wiki', 'mod/wiki:editpage', 'moodle_mobile_app'),
(411, 'mod_workshop_get_workshops_by_courses', 'mod_workshop_external', 'get_workshops_by_courses', NULL, 'mod_workshop', 'mod/workshop:view', 'moodle_mobile_app'),
(412, 'mod_workshop_get_workshop_access_information', 'mod_workshop_external', 'get_workshop_access_information', NULL, 'mod_workshop', 'mod/workshop:view', 'moodle_mobile_app'),
(413, 'mod_workshop_get_user_plan', 'mod_workshop_external', 'get_user_plan', NULL, 'mod_workshop', 'mod/workshop:view', 'moodle_mobile_app'),
(414, 'mod_workshop_view_workshop', 'mod_workshop_external', 'view_workshop', NULL, 'mod_workshop', 'mod/workshop:view', 'moodle_mobile_app'),
(415, 'mod_workshop_add_submission', 'mod_workshop_external', 'add_submission', NULL, 'mod_workshop', 'mod/workshop:submit', 'moodle_mobile_app'),
(416, 'mod_workshop_update_submission', 'mod_workshop_external', 'update_submission', NULL, 'mod_workshop', 'mod/workshop:submit', 'moodle_mobile_app'),
(417, 'mod_workshop_delete_submission', 'mod_workshop_external', 'delete_submission', NULL, 'mod_workshop', 'mod/workshop:submit', 'moodle_mobile_app'),
(418, 'mod_workshop_get_submissions', 'mod_workshop_external', 'get_submissions', NULL, 'mod_workshop', '', 'moodle_mobile_app'),
(419, 'mod_workshop_get_submission', 'mod_workshop_external', 'get_submission', NULL, 'mod_workshop', '', 'moodle_mobile_app'),
(420, 'mod_workshop_get_submission_assessments', 'mod_workshop_external', 'get_submission_assessments', NULL, 'mod_workshop', '', 'moodle_mobile_app'),
(421, 'mod_workshop_get_assessment', 'mod_workshop_external', 'get_assessment', NULL, 'mod_workshop', '', 'moodle_mobile_app'),
(422, 'mod_workshop_get_assessment_form_definition', 'mod_workshop_external', 'get_assessment_form_definition', NULL, 'mod_workshop', '', 'moodle_mobile_app'),
(423, 'mod_workshop_get_reviewer_assessments', 'mod_workshop_external', 'get_reviewer_assessments', NULL, 'mod_workshop', '', 'moodle_mobile_app'),
(424, 'mod_workshop_update_assessment', 'mod_workshop_external', 'update_assessment', NULL, 'mod_workshop', '', 'moodle_mobile_app'),
(425, 'mod_workshop_get_grades', 'mod_workshop_external', 'get_grades', NULL, 'mod_workshop', '', 'moodle_mobile_app'),
(426, 'mod_workshop_evaluate_assessment', 'mod_workshop_external', 'evaluate_assessment', NULL, 'mod_workshop', '', 'moodle_mobile_app'),
(427, 'mod_workshop_get_grades_report', 'mod_workshop_external', 'get_grades_report', NULL, 'mod_workshop', '', 'moodle_mobile_app'),
(428, 'mod_workshop_view_submission', 'mod_workshop_external', 'view_submission', NULL, 'mod_workshop', 'mod/workshop:view', 'moodle_mobile_app'),
(429, 'mod_workshop_evaluate_submission', 'mod_workshop_external', 'evaluate_submission', NULL, 'mod_workshop', '', 'moodle_mobile_app'),
(430, 'auth_email_get_signup_settings', 'auth_email_external', 'get_signup_settings', NULL, 'auth_email', '', NULL),
(431, 'auth_email_signup_user', 'auth_email_external', 'signup_user', NULL, 'auth_email', '', NULL),
(432, 'enrol_guest_get_instance_info', 'enrol_guest_external', 'get_instance_info', NULL, 'enrol_guest', '', 'moodle_mobile_app'),
(433, 'enrol_manual_enrol_users', 'enrol_manual_external', 'enrol_users', 'enrol/manual/externallib.php', 'enrol_manual', 'enrol/manual:enrol', NULL),
(434, 'enrol_manual_unenrol_users', 'enrol_manual_external', 'unenrol_users', 'enrol/manual/externallib.php', 'enrol_manual', 'enrol/manual:unenrol', NULL),
(435, 'enrol_self_get_instance_info', 'enrol_self_external', 'get_instance_info', 'enrol/self/externallib.php', 'enrol_self', '', 'moodle_mobile_app'),
(436, 'enrol_self_enrol_user', 'enrol_self_external', 'enrol_user', 'enrol/self/externallib.php', 'enrol_self', '', 'moodle_mobile_app'),
(437, 'message_airnotifier_is_system_configured', 'message_airnotifier_external', 'is_system_configured', 'message/output/airnotifier/externallib.php', 'message_airnotifier', '', 'moodle_mobile_app'),
(438, 'message_airnotifier_are_notification_preferences_configured', 'message_airnotifier_external', 'are_notification_preferences_configured', 'message/output/airnotifier/externallib.php', 'message_airnotifier', '', 'moodle_mobile_app'),
(439, 'message_airnotifier_get_user_devices', 'message_airnotifier_external', 'get_user_devices', 'message/output/airnotifier/externallib.php', 'message_airnotifier', '', 'moodle_mobile_app'),
(440, 'message_airnotifier_enable_device', 'message_airnotifier_external', 'enable_device', 'message/output/airnotifier/externallib.php', 'message_airnotifier', 'message/airnotifier:managedevice', 'moodle_mobile_app'),
(441, 'message_popup_get_popup_notifications', 'message_popup_external', 'get_popup_notifications', 'message/output/popup/externallib.php', 'message_popup', '', 'moodle_mobile_app'),
(442, 'message_popup_get_unread_popup_notification_count', 'message_popup_external', 'get_unread_popup_notification_count', 'message/output/popup/externallib.php', 'message_popup', '', 'moodle_mobile_app'),
(443, 'report_competency_data_for_report', 'report_competency\\external', 'data_for_report', NULL, 'report_competency', 'moodle/competency:coursecompetencyview', NULL),
(444, 'report_insights_set_notuseful_prediction', 'report_insights\\external', 'set_notuseful_prediction', NULL, 'report_insights', '', 'moodle_mobile_app'),
(445, 'report_insights_set_fixed_prediction', 'report_insights\\external', 'set_fixed_prediction', NULL, 'report_insights', '', 'moodle_mobile_app'),
(446, 'gradereport_overview_get_course_grades', 'gradereport_overview_external', 'get_course_grades', NULL, 'gradereport_overview', '', 'moodle_mobile_app'),
(447, 'gradereport_overview_view_grade_report', 'gradereport_overview_external', 'view_grade_report', NULL, 'gradereport_overview', 'gradereport/overview:view', 'moodle_mobile_app'),
(448, 'gradereport_user_get_grades_table', 'gradereport_user_external', 'get_grades_table', 'grade/report/user/externallib.php', 'gradereport_user', 'gradereport/user:view', 'moodle_mobile_app'),
(449, 'gradereport_user_view_grade_report', 'gradereport_user_external', 'view_grade_report', 'grade/report/user/externallib.php', 'gradereport_user', 'gradereport/user:view', 'moodle_mobile_app'),
(450, 'gradereport_user_get_grade_items', 'gradereport_user_external', 'get_grade_items', 'grade/report/user/externallib.php', 'gradereport_user', 'gradereport/user:view', 'moodle_mobile_app'),
(451, 'tool_dataprivacy_cancel_data_request', 'tool_dataprivacy\\external', 'cancel_data_request', NULL, 'tool_dataprivacy', '', NULL),
(452, 'tool_dataprivacy_contact_dpo', 'tool_dataprivacy\\external', 'contact_dpo', NULL, 'tool_dataprivacy', '', NULL),
(453, 'tool_dataprivacy_mark_complete', 'tool_dataprivacy\\external', 'mark_complete', NULL, 'tool_dataprivacy', 'tool/dataprivacy:managedatarequests', NULL),
(454, 'tool_dataprivacy_get_data_request', 'tool_dataprivacy\\external', 'get_data_request', NULL, 'tool_dataprivacy', 'tool/dataprivacy:managedatarequests', NULL),
(455, 'tool_dataprivacy_approve_data_request', 'tool_dataprivacy\\external', 'approve_data_request', NULL, 'tool_dataprivacy', 'tool/dataprivacy:managedatarequests', NULL),
(456, 'tool_dataprivacy_bulk_approve_data_requests', 'tool_dataprivacy\\external', 'bulk_approve_data_requests', NULL, 'tool_dataprivacy', 'tool/dataprivacy:managedatarequests', NULL),
(457, 'tool_dataprivacy_deny_data_request', 'tool_dataprivacy\\external', 'deny_data_request', NULL, 'tool_dataprivacy', 'tool/dataprivacy:managedatarequests', NULL),
(458, 'tool_dataprivacy_bulk_deny_data_requests', 'tool_dataprivacy\\external', 'bulk_deny_data_requests', NULL, 'tool_dataprivacy', 'tool/dataprivacy:managedatarequests', NULL),
(459, 'tool_dataprivacy_get_users', 'tool_dataprivacy\\external', 'get_users', NULL, 'tool_dataprivacy', 'tool/dataprivacy:managedatarequests', NULL),
(460, 'tool_dataprivacy_create_purpose_form', 'tool_dataprivacy\\external', 'create_purpose_form', NULL, 'tool_dataprivacy', '', NULL),
(461, 'tool_dataprivacy_create_category_form', 'tool_dataprivacy\\external', 'create_category_form', NULL, 'tool_dataprivacy', '', NULL),
(462, 'tool_dataprivacy_delete_purpose', 'tool_dataprivacy\\external', 'delete_purpose', NULL, 'tool_dataprivacy', '', NULL),
(463, 'tool_dataprivacy_delete_category', 'tool_dataprivacy\\external', 'delete_category', NULL, 'tool_dataprivacy', '', NULL),
(464, 'tool_dataprivacy_set_contextlevel_form', 'tool_dataprivacy\\external', 'set_contextlevel_form', NULL, 'tool_dataprivacy', '', NULL),
(465, 'tool_dataprivacy_set_context_form', 'tool_dataprivacy\\external', 'set_context_form', NULL, 'tool_dataprivacy', '', NULL),
(466, 'tool_dataprivacy_tree_extra_branches', 'tool_dataprivacy\\external', 'tree_extra_branches', NULL, 'tool_dataprivacy', '', NULL),
(467, 'tool_dataprivacy_confirm_contexts_for_deletion', 'tool_dataprivacy\\external', 'confirm_contexts_for_deletion', NULL, 'tool_dataprivacy', '', NULL),
(468, 'tool_dataprivacy_set_context_defaults', 'tool_dataprivacy\\external', 'set_context_defaults', NULL, 'tool_dataprivacy', 'tool/dataprivacy:managedataregistry', NULL),
(469, 'tool_dataprivacy_get_category_options', 'tool_dataprivacy\\external', 'get_category_options', NULL, 'tool_dataprivacy', 'tool/dataprivacy:managedataregistry', NULL),
(470, 'tool_dataprivacy_get_purpose_options', 'tool_dataprivacy\\external', 'get_purpose_options', NULL, 'tool_dataprivacy', 'tool/dataprivacy:managedataregistry', NULL),
(471, 'tool_dataprivacy_get_activity_options', 'tool_dataprivacy\\external', 'get_activity_options', NULL, 'tool_dataprivacy', 'tool/dataprivacy:managedataregistry', NULL),
(472, 'tool_lp_data_for_competency_frameworks_manage_page', 'tool_lp\\external', 'data_for_competency_frameworks_manage_page', NULL, 'tool_lp', 'moodle/competency:competencyview', NULL),
(473, 'tool_lp_data_for_competency_summary', 'tool_lp\\external', 'data_for_competency_summary', NULL, 'tool_lp', 'moodle/competency:competencyview', NULL),
(474, 'tool_lp_data_for_competencies_manage_page', 'tool_lp\\external', 'data_for_competencies_manage_page', NULL, 'tool_lp', 'moodle/competency:competencyview', NULL),
(475, 'tool_lp_list_courses_using_competency', 'tool_lp\\external', 'list_courses_using_competency', NULL, 'tool_lp', 'moodle/competency:coursecompetencyview', NULL),
(476, 'tool_lp_data_for_course_competencies_page', 'tool_lp\\external', 'data_for_course_competencies_page', NULL, 'tool_lp', 'moodle/competency:coursecompetencyview', 'moodle_mobile_app'),
(477, 'tool_lp_data_for_template_competencies_page', 'tool_lp\\external', 'data_for_template_competencies_page', NULL, 'tool_lp', 'moodle/competency:templateview', NULL),
(478, 'tool_lp_data_for_templates_manage_page', 'tool_lp\\external', 'data_for_templates_manage_page', NULL, 'tool_lp', 'moodle/competency:templateview', NULL),
(479, 'tool_lp_data_for_plans_page', 'tool_lp\\external', 'data_for_plans_page', NULL, 'tool_lp', 'moodle/competency:planviewown', 'moodle_mobile_app'),
(480, 'tool_lp_data_for_plan_page', 'tool_lp\\external', 'data_for_plan_page', NULL, 'tool_lp', 'moodle/competency:planview', 'moodle_mobile_app'),
(481, 'tool_lp_data_for_related_competencies_section', 'tool_lp\\external', 'data_for_related_competencies_section', NULL, 'tool_lp', 'moodle/competency:competencyview', NULL),
(482, 'tool_lp_search_users', 'tool_lp\\external', 'search_users', NULL, 'tool_lp', '', NULL),
(483, 'tool_lp_search_cohorts', 'core_cohort_external', 'search_cohorts', 'cohort/externallib.php', 'tool_lp', 'moodle/cohort:view', NULL),
(484, 'tool_lp_data_for_user_evidence_list_page', 'tool_lp\\external', 'data_for_user_evidence_list_page', NULL, 'tool_lp', 'moodle/competency:userevidenceview', 'moodle_mobile_app'),
(485, 'tool_lp_data_for_user_evidence_page', 'tool_lp\\external', 'data_for_user_evidence_page', NULL, 'tool_lp', 'moodle/competency:userevidenceview', 'moodle_mobile_app'),
(486, 'tool_lp_data_for_user_competency_summary', 'tool_lp\\external', 'data_for_user_competency_summary', NULL, 'tool_lp', 'moodle/competency:planview', 'moodle_mobile_app'),
(487, 'tool_lp_data_for_user_competency_summary_in_plan', 'tool_lp\\external', 'data_for_user_competency_summary_in_plan', NULL, 'tool_lp', 'moodle/competency:planview', 'moodle_mobile_app'),
(488, 'tool_lp_data_for_user_competency_summary_in_course', 'tool_lp\\external', 'data_for_user_competency_summary_in_course', NULL, 'tool_lp', 'moodle/competency:coursecompetencyview', 'moodle_mobile_app'),
(489, 'tool_mobile_get_plugins_supporting_mobile', 'tool_mobile\\external', 'get_plugins_supporting_mobile', NULL, 'tool_mobile', '', 'moodle_mobile_app'),
(490, 'tool_mobile_get_public_config', 'tool_mobile\\external', 'get_public_config', NULL, 'tool_mobile', '', 'moodle_mobile_app'),
(491, 'tool_mobile_get_config', 'tool_mobile\\external', 'get_config', NULL, 'tool_mobile', '', 'moodle_mobile_app'),
(492, 'tool_mobile_get_autologin_key', 'tool_mobile\\external', 'get_autologin_key', NULL, 'tool_mobile', '', 'moodle_mobile_app'),
(493, 'tool_mobile_get_content', 'tool_mobile\\external', 'get_content', NULL, 'tool_mobile', '', 'moodle_mobile_app'),
(494, 'tool_policy_get_policy_version', 'tool_policy\\external', 'get_policy_version', NULL, 'tool_policy', '', NULL),
(495, 'tool_policy_submit_accept_on_behalf', 'tool_policy\\external', 'submit_accept_on_behalf', NULL, 'tool_policy', '', NULL),
(496, 'tool_templatelibrary_list_templates', 'tool_templatelibrary\\external', 'list_templates', NULL, 'tool_templatelibrary', '', NULL),
(497, 'tool_templatelibrary_load_canonical_template', 'tool_templatelibrary\\external', 'load_canonical_template', NULL, 'tool_templatelibrary', '', NULL),
(498, 'tool_usertours_fetch_and_start_tour', 'tool_usertours\\external\\tour', 'fetch_and_start_tour', NULL, 'tool_usertours', '', NULL),
(499, 'tool_usertours_step_shown', 'tool_usertours\\external\\tour', 'step_shown', NULL, 'tool_usertours', '', NULL),
(500, 'tool_usertours_complete_tour', 'tool_usertours\\external\\tour', 'complete_tour', NULL, 'tool_usertours', '', NULL),
(501, 'tool_usertours_reset_tour', 'tool_usertours\\external\\tour', 'reset_tour', NULL, 'tool_usertours', '', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]external_services`
--

CREATE TABLE `[[dbprefix]]external_services` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `enabled` tinyint(1) NOT NULL,
  `requiredcapability` varchar(150) DEFAULT NULL,
  `restrictedusers` tinyint(1) NOT NULL,
  `component` varchar(100) DEFAULT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) DEFAULT NULL,
  `shortname` varchar(255) DEFAULT NULL,
  `downloadfiles` tinyint(1) NOT NULL DEFAULT '0',
  `uploadfiles` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]exteserv_nam_uix` (`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='built in and custom external services' AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]external_services`
--

INSERT INTO `[[dbprefix]]external_services` VALUES
(1, 'Moodle mobile web service', 0, NULL, 0, 'moodle', [[timestamp]], [[timestamp]], 'moodle_mobile_app', 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]external_services_functions`
--

CREATE TABLE `[[dbprefix]]external_services_functions` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `externalserviceid` bigint(10) NOT NULL,
  `functionname` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]exteservfunc_ext_ix` (`externalserviceid`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='lists functions available in each service group' AUTO_INCREMENT=297 ;

--
-- Dumping data for table `[[dbprefix]]external_services_functions`
--

INSERT INTO `[[dbprefix]]external_services_functions` VALUES
(1, 1, 'core_badges_get_user_badges'),
(2, 1, 'core_calendar_get_calendar_monthly_view'),
(3, 1, 'core_calendar_get_calendar_day_view'),
(4, 1, 'core_calendar_get_calendar_upcoming_view'),
(5, 1, 'core_calendar_create_calendar_events'),
(6, 1, 'core_calendar_delete_calendar_events'),
(7, 1, 'core_calendar_get_calendar_events'),
(8, 1, 'core_calendar_get_action_events_by_timesort'),
(9, 1, 'core_calendar_get_action_events_by_course'),
(10, 1, 'core_calendar_get_action_events_by_courses'),
(11, 1, 'core_calendar_get_calendar_event_by_id'),
(12, 1, 'core_comment_get_comments'),
(13, 1, 'core_completion_get_activities_completion_status'),
(14, 1, 'core_completion_get_course_completion_status'),
(15, 1, 'core_completion_mark_course_self_completed'),
(16, 1, 'core_completion_update_activity_completion_status_manually'),
(17, 1, 'core_course_get_categories'),
(18, 1, 'core_course_get_contents'),
(19, 1, 'core_course_get_course_module'),
(20, 1, 'core_course_get_course_module_by_instance'),
(21, 1, 'core_course_get_courses'),
(22, 1, 'core_course_search_courses'),
(23, 1, 'core_course_view_course'),
(24, 1, 'core_course_get_activities_overview'),
(25, 1, 'core_course_get_user_navigation_options'),
(26, 1, 'core_course_get_user_administration_options'),
(27, 1, 'core_course_get_courses_by_field'),
(28, 1, 'core_course_check_updates'),
(29, 1, 'core_course_get_updates_since'),
(30, 1, 'core_enrol_get_course_enrolment_methods'),
(31, 1, 'core_enrol_get_enrolled_users'),
(32, 1, 'core_enrol_get_users_courses'),
(33, 1, 'core_files_get_files'),
(34, 1, 'core_get_component_strings'),
(35, 1, 'core_group_get_activity_allowed_groups'),
(36, 1, 'core_group_get_activity_groupmode'),
(37, 1, 'core_group_get_course_user_groups'),
(38, 1, 'core_message_block_contacts'),
(39, 1, 'core_message_create_contacts'),
(40, 1, 'core_message_delete_contacts'),
(41, 1, 'core_message_delete_conversation'),
(42, 1, 'core_message_delete_message'),
(43, 1, 'core_message_get_blocked_users'),
(44, 1, 'core_message_data_for_messagearea_search_messages'),
(45, 1, 'core_message_data_for_messagearea_conversations'),
(46, 1, 'core_message_data_for_messagearea_contacts'),
(47, 1, 'core_message_data_for_messagearea_messages'),
(48, 1, 'core_message_get_contacts'),
(49, 1, 'core_message_get_messages'),
(50, 1, 'core_message_get_unread_conversations_count'),
(51, 1, 'core_message_mark_all_notifications_as_read'),
(52, 1, 'core_message_mark_all_messages_as_read'),
(53, 1, 'core_message_mark_message_read'),
(54, 1, 'core_message_mark_notification_read'),
(55, 1, 'core_message_message_processor_config_form'),
(56, 1, 'core_message_search_contacts'),
(57, 1, 'core_message_send_instant_messages'),
(58, 1, 'core_message_unblock_contacts'),
(59, 1, 'core_message_get_user_notification_preferences'),
(60, 1, 'core_message_get_user_message_preferences'),
(61, 1, 'core_notes_create_notes'),
(62, 1, 'core_notes_delete_notes'),
(63, 1, 'core_notes_get_course_notes'),
(64, 1, 'core_notes_view_notes'),
(65, 1, 'core_question_update_flag'),
(66, 1, 'core_rating_get_item_ratings'),
(67, 1, 'core_rating_add_rating'),
(68, 1, 'core_user_add_user_device'),
(69, 1, 'core_user_add_user_private_files'),
(70, 1, 'core_user_get_course_user_profiles'),
(71, 1, 'core_user_get_users_by_field'),
(72, 1, 'core_user_remove_user_device'),
(73, 1, 'core_user_update_user_preferences'),
(74, 1, 'core_user_view_user_list'),
(75, 1, 'core_user_view_user_profile'),
(76, 1, 'core_user_get_user_preferences'),
(77, 1, 'core_user_update_picture'),
(78, 1, 'core_user_agree_site_policy'),
(79, 1, 'core_user_get_private_files_info'),
(80, 1, 'core_competency_competency_viewed'),
(81, 1, 'core_competency_list_course_competencies'),
(82, 1, 'core_competency_get_scale_values'),
(83, 1, 'core_competency_user_competency_viewed'),
(84, 1, 'core_competency_user_competency_viewed_in_plan'),
(85, 1, 'core_competency_user_competency_viewed_in_course'),
(86, 1, 'core_competency_user_competency_plan_viewed'),
(87, 1, 'core_competency_grade_competency_in_course'),
(88, 1, 'core_competency_delete_evidence'),
(89, 1, 'core_webservice_get_site_info'),
(90, 1, 'core_block_get_course_blocks'),
(91, 1, 'core_filters_get_available_in_context'),
(92, 1, 'mod_assign_get_grades'),
(93, 1, 'mod_assign_get_assignments'),
(94, 1, 'mod_assign_get_submissions'),
(95, 1, 'mod_assign_get_user_flags'),
(96, 1, 'mod_assign_set_user_flags'),
(97, 1, 'mod_assign_get_user_mappings'),
(98, 1, 'mod_assign_revert_submissions_to_draft'),
(99, 1, 'mod_assign_lock_submissions'),
(100, 1, 'mod_assign_unlock_submissions'),
(101, 1, 'mod_assign_save_submission'),
(102, 1, 'mod_assign_submit_for_grading'),
(103, 1, 'mod_assign_save_grade'),
(104, 1, 'mod_assign_save_grades'),
(105, 1, 'mod_assign_save_user_extensions'),
(106, 1, 'mod_assign_reveal_identities'),
(107, 1, 'mod_assign_view_grading_table'),
(108, 1, 'mod_assign_view_submission_status'),
(109, 1, 'mod_assign_get_submission_status'),
(110, 1, 'mod_assign_list_participants'),
(111, 1, 'mod_assign_submit_grading_form'),
(112, 1, 'mod_assign_get_participant'),
(113, 1, 'mod_assign_view_assign'),
(114, 1, 'mod_book_view_book'),
(115, 1, 'mod_book_get_books_by_courses'),
(116, 1, 'mod_chat_login_user'),
(117, 1, 'mod_chat_get_chat_users'),
(118, 1, 'mod_chat_send_chat_message'),
(119, 1, 'mod_chat_get_chat_latest_messages'),
(120, 1, 'mod_chat_view_chat'),
(121, 1, 'mod_chat_get_chats_by_courses'),
(122, 1, 'mod_chat_get_sessions'),
(123, 1, 'mod_chat_get_session_messages'),
(124, 1, 'mod_choice_get_choice_results'),
(125, 1, 'mod_choice_get_choice_options'),
(126, 1, 'mod_choice_submit_choice_response'),
(127, 1, 'mod_choice_view_choice'),
(128, 1, 'mod_choice_get_choices_by_courses'),
(129, 1, 'mod_choice_delete_choice_responses'),
(130, 1, 'mod_data_get_databases_by_courses'),
(131, 1, 'mod_data_view_database'),
(132, 1, 'mod_data_get_data_access_information'),
(133, 1, 'mod_data_get_entries'),
(134, 1, 'mod_data_get_entry'),
(135, 1, 'mod_data_get_fields'),
(136, 1, 'mod_data_search_entries'),
(137, 1, 'mod_data_approve_entry'),
(138, 1, 'mod_data_delete_entry'),
(139, 1, 'mod_data_add_entry'),
(140, 1, 'mod_data_update_entry'),
(141, 1, 'mod_feedback_get_feedbacks_by_courses'),
(142, 1, 'mod_feedback_get_feedback_access_information'),
(143, 1, 'mod_feedback_view_feedback'),
(144, 1, 'mod_feedback_get_current_completed_tmp'),
(145, 1, 'mod_feedback_get_items'),
(146, 1, 'mod_feedback_launch_feedback'),
(147, 1, 'mod_feedback_get_page_items'),
(148, 1, 'mod_feedback_process_page'),
(149, 1, 'mod_feedback_get_analysis'),
(150, 1, 'mod_feedback_get_unfinished_responses'),
(151, 1, 'mod_feedback_get_finished_responses'),
(152, 1, 'mod_feedback_get_non_respondents'),
(153, 1, 'mod_feedback_get_responses_analysis'),
(154, 1, 'mod_feedback_get_last_completed'),
(155, 1, 'mod_folder_view_folder'),
(156, 1, 'mod_folder_get_folders_by_courses'),
(157, 1, 'mod_forum_get_forums_by_courses'),
(158, 1, 'mod_forum_get_forum_discussion_posts'),
(159, 1, 'mod_forum_get_forum_discussions_paginated'),
(160, 1, 'mod_forum_view_forum'),
(161, 1, 'mod_forum_view_forum_discussion'),
(162, 1, 'mod_forum_add_discussion_post'),
(163, 1, 'mod_forum_add_discussion'),
(164, 1, 'mod_forum_can_add_discussion'),
(165, 1, 'mod_glossary_get_glossaries_by_courses'),
(166, 1, 'mod_glossary_view_glossary'),
(167, 1, 'mod_glossary_view_entry'),
(168, 1, 'mod_glossary_get_entries_by_letter'),
(169, 1, 'mod_glossary_get_entries_by_date'),
(170, 1, 'mod_glossary_get_categories'),
(171, 1, 'mod_glossary_get_entries_by_category'),
(172, 1, 'mod_glossary_get_authors'),
(173, 1, 'mod_glossary_get_entries_by_author'),
(174, 1, 'mod_glossary_get_entries_by_author_id'),
(175, 1, 'mod_glossary_get_entries_by_search'),
(176, 1, 'mod_glossary_get_entries_by_term'),
(177, 1, 'mod_glossary_get_entries_to_approve'),
(178, 1, 'mod_glossary_get_entry_by_id'),
(179, 1, 'mod_glossary_add_entry'),
(180, 1, 'mod_imscp_view_imscp'),
(181, 1, 'mod_imscp_get_imscps_by_courses'),
(182, 1, 'mod_label_get_labels_by_courses'),
(183, 1, 'mod_lesson_get_lessons_by_courses'),
(184, 1, 'mod_lesson_get_lesson_access_information'),
(185, 1, 'mod_lesson_view_lesson'),
(186, 1, 'mod_lesson_get_questions_attempts'),
(187, 1, 'mod_lesson_get_user_grade'),
(188, 1, 'mod_lesson_get_user_attempt_grade'),
(189, 1, 'mod_lesson_get_content_pages_viewed'),
(190, 1, 'mod_lesson_get_user_timers'),
(191, 1, 'mod_lesson_get_pages'),
(192, 1, 'mod_lesson_launch_attempt'),
(193, 1, 'mod_lesson_get_page_data'),
(194, 1, 'mod_lesson_process_page'),
(195, 1, 'mod_lesson_finish_attempt'),
(196, 1, 'mod_lesson_get_attempts_overview'),
(197, 1, 'mod_lesson_get_user_attempt'),
(198, 1, 'mod_lesson_get_pages_possible_jumps'),
(199, 1, 'mod_lesson_get_lesson'),
(200, 1, 'mod_lti_get_tool_launch_data'),
(201, 1, 'mod_lti_get_ltis_by_courses'),
(202, 1, 'mod_lti_view_lti'),
(203, 1, 'mod_page_view_page'),
(204, 1, 'mod_page_get_pages_by_courses'),
(205, 1, 'mod_quiz_get_quizzes_by_courses'),
(206, 1, 'mod_quiz_view_quiz'),
(207, 1, 'mod_quiz_get_user_attempts'),
(208, 1, 'mod_quiz_get_user_best_grade'),
(209, 1, 'mod_quiz_get_combined_review_options'),
(210, 1, 'mod_quiz_start_attempt'),
(211, 1, 'mod_quiz_get_attempt_data'),
(212, 1, 'mod_quiz_get_attempt_summary'),
(213, 1, 'mod_quiz_save_attempt'),
(214, 1, 'mod_quiz_process_attempt'),
(215, 1, 'mod_quiz_get_attempt_review'),
(216, 1, 'mod_quiz_view_attempt'),
(217, 1, 'mod_quiz_view_attempt_summary'),
(218, 1, 'mod_quiz_view_attempt_review'),
(219, 1, 'mod_quiz_get_quiz_feedback_for_grade'),
(220, 1, 'mod_quiz_get_quiz_access_information'),
(221, 1, 'mod_quiz_get_attempt_access_information'),
(222, 1, 'mod_quiz_get_quiz_required_qtypes'),
(223, 1, 'mod_resource_view_resource'),
(224, 1, 'mod_resource_get_resources_by_courses'),
(225, 1, 'mod_scorm_view_scorm'),
(226, 1, 'mod_scorm_get_scorm_attempt_count'),
(227, 1, 'mod_scorm_get_scorm_scoes'),
(228, 1, 'mod_scorm_get_scorm_user_data'),
(229, 1, 'mod_scorm_insert_scorm_tracks'),
(230, 1, 'mod_scorm_get_scorm_sco_tracks'),
(231, 1, 'mod_scorm_get_scorms_by_courses'),
(232, 1, 'mod_scorm_launch_sco'),
(233, 1, 'mod_survey_get_surveys_by_courses'),
(234, 1, 'mod_survey_view_survey'),
(235, 1, 'mod_survey_get_questions'),
(236, 1, 'mod_survey_submit_answers'),
(237, 1, 'mod_url_view_url'),
(238, 1, 'mod_url_get_urls_by_courses'),
(239, 1, 'mod_wiki_get_wikis_by_courses'),
(240, 1, 'mod_wiki_view_wiki'),
(241, 1, 'mod_wiki_view_page'),
(242, 1, 'mod_wiki_get_subwikis'),
(243, 1, 'mod_wiki_get_subwiki_pages'),
(244, 1, 'mod_wiki_get_subwiki_files'),
(245, 1, 'mod_wiki_get_page_contents'),
(246, 1, 'mod_wiki_get_page_for_editing'),
(247, 1, 'mod_wiki_new_page'),
(248, 1, 'mod_wiki_edit_page'),
(249, 1, 'mod_workshop_get_workshops_by_courses'),
(250, 1, 'mod_workshop_get_workshop_access_information'),
(251, 1, 'mod_workshop_get_user_plan'),
(252, 1, 'mod_workshop_view_workshop'),
(253, 1, 'mod_workshop_add_submission'),
(254, 1, 'mod_workshop_update_submission'),
(255, 1, 'mod_workshop_delete_submission'),
(256, 1, 'mod_workshop_get_submissions'),
(257, 1, 'mod_workshop_get_submission'),
(258, 1, 'mod_workshop_get_submission_assessments'),
(259, 1, 'mod_workshop_get_assessment'),
(260, 1, 'mod_workshop_get_assessment_form_definition'),
(261, 1, 'mod_workshop_get_reviewer_assessments'),
(262, 1, 'mod_workshop_update_assessment'),
(263, 1, 'mod_workshop_get_grades'),
(264, 1, 'mod_workshop_evaluate_assessment'),
(265, 1, 'mod_workshop_get_grades_report'),
(266, 1, 'mod_workshop_view_submission'),
(267, 1, 'mod_workshop_evaluate_submission'),
(268, 1, 'enrol_guest_get_instance_info'),
(269, 1, 'enrol_self_get_instance_info'),
(270, 1, 'enrol_self_enrol_user'),
(271, 1, 'message_airnotifier_is_system_configured'),
(272, 1, 'message_airnotifier_are_notification_preferences_configured'),
(273, 1, 'message_airnotifier_get_user_devices'),
(274, 1, 'message_airnotifier_enable_device'),
(275, 1, 'message_popup_get_popup_notifications'),
(276, 1, 'message_popup_get_unread_popup_notification_count'),
(277, 1, 'report_insights_set_notuseful_prediction'),
(278, 1, 'report_insights_set_fixed_prediction'),
(279, 1, 'gradereport_overview_get_course_grades'),
(280, 1, 'gradereport_overview_view_grade_report'),
(281, 1, 'gradereport_user_get_grades_table'),
(282, 1, 'gradereport_user_view_grade_report'),
(283, 1, 'gradereport_user_get_grade_items'),
(284, 1, 'tool_lp_data_for_course_competencies_page'),
(285, 1, 'tool_lp_data_for_plans_page'),
(286, 1, 'tool_lp_data_for_plan_page'),
(287, 1, 'tool_lp_data_for_user_evidence_list_page'),
(288, 1, 'tool_lp_data_for_user_evidence_page'),
(289, 1, 'tool_lp_data_for_user_competency_summary'),
(290, 1, 'tool_lp_data_for_user_competency_summary_in_plan'),
(291, 1, 'tool_lp_data_for_user_competency_summary_in_course'),
(292, 1, 'tool_mobile_get_plugins_supporting_mobile'),
(293, 1, 'tool_mobile_get_public_config'),
(294, 1, 'tool_mobile_get_config'),
(295, 1, 'tool_mobile_get_autologin_key'),
(296, 1, 'tool_mobile_get_content');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]external_services_users`
--

CREATE TABLE `[[dbprefix]]external_services_users` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `externalserviceid` bigint(10) NOT NULL,
  `userid` bigint(10) NOT NULL,
  `iprestriction` varchar(255) DEFAULT NULL,
  `validuntil` bigint(10) DEFAULT NULL,
  `timecreated` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]exteservuser_ext_ix` (`externalserviceid`),
  KEY `[[dbprefix]]exteservuser_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='users allowed to use services with restricted users flag' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]external_tokens`
--

CREATE TABLE `[[dbprefix]]external_tokens` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `token` varchar(128) NOT NULL DEFAULT '',
  `privatetoken` varchar(64) DEFAULT NULL,
  `tokentype` smallint(4) NOT NULL,
  `userid` bigint(10) NOT NULL,
  `externalserviceid` bigint(10) NOT NULL,
  `sid` varchar(128) DEFAULT NULL,
  `contextid` bigint(10) NOT NULL,
  `creatorid` bigint(10) NOT NULL DEFAULT '1',
  `iprestriction` varchar(255) DEFAULT NULL,
  `validuntil` bigint(10) DEFAULT NULL,
  `timecreated` bigint(10) NOT NULL,
  `lastaccess` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]extetoke_use_ix` (`userid`),
  KEY `[[dbprefix]]extetoke_ext_ix` (`externalserviceid`),
  KEY `[[dbprefix]]extetoke_con_ix` (`contextid`),
  KEY `[[dbprefix]]extetoke_cre_ix` (`creatorid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Security tokens for accessing of external services' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]feedback`
--

CREATE TABLE `[[dbprefix]]feedback` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `intro` longtext NOT NULL,
  `introformat` smallint(4) NOT NULL DEFAULT '0',
  `anonymous` tinyint(1) NOT NULL DEFAULT '1',
  `email_notification` tinyint(1) NOT NULL DEFAULT '1',
  `multiple_submit` tinyint(1) NOT NULL DEFAULT '1',
  `autonumbering` tinyint(1) NOT NULL DEFAULT '1',
  `site_after_submit` varchar(255) NOT NULL DEFAULT '',
  `page_after_submit` longtext NOT NULL,
  `page_after_submitformat` tinyint(2) NOT NULL DEFAULT '0',
  `publish_stats` tinyint(1) NOT NULL DEFAULT '0',
  `timeopen` bigint(10) NOT NULL DEFAULT '0',
  `timeclose` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `completionsubmit` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]feed_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='all feedbacks' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]feedback_completed`
--

CREATE TABLE `[[dbprefix]]feedback_completed` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `feedback` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `random_response` bigint(10) NOT NULL DEFAULT '0',
  `anonymous_response` tinyint(1) NOT NULL DEFAULT '0',
  `courseid` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]feedcomp_use_ix` (`userid`),
  KEY `[[dbprefix]]feedcomp_fee_ix` (`feedback`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='filled out feedback' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]feedback_completedtmp`
--

CREATE TABLE `[[dbprefix]]feedback_completedtmp` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `feedback` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `guestid` varchar(255) NOT NULL DEFAULT '',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `random_response` bigint(10) NOT NULL DEFAULT '0',
  `anonymous_response` tinyint(1) NOT NULL DEFAULT '0',
  `courseid` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]feedcomp_use2_ix` (`userid`),
  KEY `[[dbprefix]]feedcomp_fee2_ix` (`feedback`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='filled out feedback' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]feedback_item`
--

CREATE TABLE `[[dbprefix]]feedback_item` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `feedback` bigint(10) NOT NULL DEFAULT '0',
  `template` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `label` varchar(255) NOT NULL DEFAULT '',
  `presentation` longtext NOT NULL,
  `typ` varchar(255) NOT NULL DEFAULT '',
  `hasvalue` tinyint(1) NOT NULL DEFAULT '0',
  `position` smallint(3) NOT NULL DEFAULT '0',
  `required` tinyint(1) NOT NULL DEFAULT '0',
  `dependitem` bigint(10) NOT NULL DEFAULT '0',
  `dependvalue` varchar(255) NOT NULL DEFAULT '',
  `options` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]feeditem_fee_ix` (`feedback`),
  KEY `[[dbprefix]]feeditem_tem_ix` (`template`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='feedback_items' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]feedback_sitecourse_map`
--

CREATE TABLE `[[dbprefix]]feedback_sitecourse_map` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `feedbackid` bigint(10) NOT NULL DEFAULT '0',
  `courseid` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]feedsitemap_cou_ix` (`courseid`),
  KEY `[[dbprefix]]feedsitemap_fee_ix` (`feedbackid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='feedback sitecourse map' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]feedback_template`
--

CREATE TABLE `[[dbprefix]]feedback_template` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `ispublic` tinyint(1) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]feedtemp_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='templates of feedbackstructures' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]feedback_value`
--

CREATE TABLE `[[dbprefix]]feedback_value` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course_id` bigint(10) NOT NULL DEFAULT '0',
  `item` bigint(10) NOT NULL DEFAULT '0',
  `completed` bigint(10) NOT NULL DEFAULT '0',
  `tmp_completed` bigint(10) NOT NULL DEFAULT '0',
  `value` longtext NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]feedvalu_comitecou_uix` (`completed`,`item`,`course_id`),
  KEY `[[dbprefix]]feedvalu_cou_ix` (`course_id`),
  KEY `[[dbprefix]]feedvalu_ite_ix` (`item`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='values of the completeds' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]feedback_valuetmp`
--

CREATE TABLE `[[dbprefix]]feedback_valuetmp` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course_id` bigint(10) NOT NULL DEFAULT '0',
  `item` bigint(10) NOT NULL DEFAULT '0',
  `completed` bigint(10) NOT NULL DEFAULT '0',
  `tmp_completed` bigint(10) NOT NULL DEFAULT '0',
  `value` longtext NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]feedvalu_comitecou2_uix` (`completed`,`item`,`course_id`),
  KEY `[[dbprefix]]feedvalu_cou2_ix` (`course_id`),
  KEY `[[dbprefix]]feedvalu_ite2_ix` (`item`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='values of the completedstmp' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]files`
--

CREATE TABLE `[[dbprefix]]files` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `contenthash` varchar(40) NOT NULL DEFAULT '',
  `pathnamehash` varchar(40) NOT NULL DEFAULT '',
  `contextid` bigint(10) NOT NULL,
  `component` varchar(100) NOT NULL DEFAULT '',
  `filearea` varchar(50) NOT NULL DEFAULT '',
  `itemid` bigint(10) NOT NULL,
  `filepath` varchar(255) NOT NULL DEFAULT '',
  `filename` varchar(255) NOT NULL DEFAULT '',
  `userid` bigint(10) DEFAULT NULL,
  `filesize` bigint(10) NOT NULL,
  `mimetype` varchar(100) DEFAULT NULL,
  `status` bigint(10) NOT NULL DEFAULT '0',
  `source` longtext,
  `author` varchar(255) DEFAULT NULL,
  `license` varchar(255) DEFAULT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `sortorder` bigint(10) NOT NULL DEFAULT '0',
  `referencefileid` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]file_pat_uix` (`pathnamehash`),
  KEY `[[dbprefix]]file_comfilconite_ix` (`component`,`filearea`,`contextid`,`itemid`),
  KEY `[[dbprefix]]file_con_ix` (`contenthash`),
  KEY `[[dbprefix]]file_con2_ix` (`contextid`),
  KEY `[[dbprefix]]file_use_ix` (`userid`),
  KEY `[[dbprefix]]file_ref_ix` (`referencefileid`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='description of files, content is stored in sha1 file pool' AUTO_INCREMENT=8 ;

--
-- Dumping data for table `[[dbprefix]]files`
--

INSERT INTO `[[dbprefix]]files` VALUES
(1, '41cfeee5884a43a4650a851f4f85e7b28316fcc9', 'a48e186a2cc853a9e94e9305f4e9bc086391212d', 1, 'theme_more', 'backgroundimage', 0, '/', 'background.jpg', 2, 4451, 'image/jpeg', 0, NULL, NULL, NULL, [[timestamp]], [[timestamp]], 0, NULL),
(2, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', 'd1da7ab1bb9c08a926037367bf8ce9a838034ead', 1, 'theme_more', 'backgroundimage', 0, '/', '.', 2, 0, NULL, 0, NULL, NULL, NULL, [[timestamp]], [[timestamp]], 0, NULL),
(3, '5f8e911d0da441e36f47c5c46f4393269211ca56', '508e674d49c30d4fde325fe6c7f6fd3d56b247e1', 1, 'assignfeedback_editpdf', 'stamps', 0, '/', 'smile.png', 2, 1085, 'image/png', 0, NULL, NULL, NULL, [[timestamp]], [[timestamp]], 0, NULL),
(4, 'da39a3ee5e6b4b0d3255bfef95601890afd80709', '70b7cdade7b4e27d4e83f0cdaad10d6a3c0cccb5', 1, 'assignfeedback_editpdf', 'stamps', 0, '/', '.', 2, 0, NULL, 0, NULL, NULL, NULL, [[timestamp]], [[timestamp]], 0, NULL),
(5, '75c101cb8cb34ea573cd25ac38f8157b1de901b8', '68317eab56c67d32aeaee5acf509a0c4aa828b6b', 1, 'assignfeedback_editpdf', 'stamps', 0, '/', 'sad.png', 2, 966, 'image/png', 0, NULL, NULL, NULL, [[timestamp]], [[timestamp]], 0, NULL),
(6, '0c5190a24c3943966541401c883eacaa20ca20cb', '695a55ff780e61c9e59428aa425430b0d6bde53b', 1, 'assignfeedback_editpdf', 'stamps', 0, '/', 'tick.png', 2, 1039, 'image/png', 0, NULL, NULL, NULL, [[timestamp]], [[timestamp]], 0, NULL),
(7, '8c96a486d5801e0f4ab8c411f561f1c687e1f865', '373e63af262a9b8466ba8632551520be793c37ff', 1, 'assignfeedback_editpdf', 'stamps', 0, '/', 'cross.png', 2, 861, 'image/png', 0, NULL, NULL, NULL, [[timestamp]], [[timestamp]], 0, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]files_reference`
--

CREATE TABLE `[[dbprefix]]files_reference` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `repositoryid` bigint(10) NOT NULL,
  `lastsync` bigint(10) DEFAULT NULL,
  `reference` longtext,
  `referencehash` varchar(40) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]filerefe_refrep_uix` (`referencehash`,`repositoryid`),
  KEY `[[dbprefix]]filerefe_rep_ix` (`repositoryid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Store files references' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]file_conversion`
--

CREATE TABLE `[[dbprefix]]file_conversion` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `usermodified` bigint(10) NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `sourcefileid` bigint(10) NOT NULL,
  `targetformat` varchar(100) NOT NULL DEFAULT '',
  `status` bigint(10) DEFAULT '0',
  `statusmessage` longtext,
  `converter` varchar(255) DEFAULT NULL,
  `destfileid` bigint(10) DEFAULT NULL,
  `data` longtext,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]fileconv_sou_ix` (`sourcefileid`),
  KEY `[[dbprefix]]fileconv_des_ix` (`destfileid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Table to track file conversions.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]filter_active`
--

CREATE TABLE `[[dbprefix]]filter_active` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `filter` varchar(32) NOT NULL DEFAULT '',
  `contextid` bigint(10) NOT NULL,
  `active` smallint(4) NOT NULL,
  `sortorder` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]filtacti_confil_uix` (`contextid`,`filter`),
  KEY `[[dbprefix]]filtacti_con_ix` (`contextid`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Stores information about which filters are active in which c' AUTO_INCREMENT=4 ;

--
-- Dumping data for table `[[dbprefix]]filter_active`
--

INSERT INTO `[[dbprefix]]filter_active` VALUES
(1, 'activitynames', 1, 1, 2),
(2, 'mathjaxloader', 1, 1, 1),
(3, 'mediaplugin', 1, 1, 3);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]filter_config`
--

CREATE TABLE `[[dbprefix]]filter_config` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `filter` varchar(32) NOT NULL DEFAULT '',
  `contextid` bigint(10) NOT NULL,
  `name` varchar(255) NOT NULL DEFAULT '',
  `value` longtext,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]filtconf_confilnam_uix` (`contextid`,`filter`,`name`),
  KEY `[[dbprefix]]filtconf_con_ix` (`contextid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Stores per-context configuration settings for filters which ' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]folder`
--

CREATE TABLE `[[dbprefix]]folder` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `intro` longtext,
  `introformat` smallint(4) NOT NULL DEFAULT '0',
  `revision` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `display` smallint(4) NOT NULL DEFAULT '0',
  `showexpanded` tinyint(1) NOT NULL DEFAULT '1',
  `showdownloadfolder` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]fold_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='each record is one folder resource' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]forum`
--

CREATE TABLE `[[dbprefix]]forum` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `type` varchar(20) NOT NULL DEFAULT 'general',
  `name` varchar(255) NOT NULL DEFAULT '',
  `intro` longtext NOT NULL,
  `introformat` smallint(4) NOT NULL DEFAULT '0',
  `assessed` bigint(10) NOT NULL DEFAULT '0',
  `assesstimestart` bigint(10) NOT NULL DEFAULT '0',
  `assesstimefinish` bigint(10) NOT NULL DEFAULT '0',
  `scale` bigint(10) NOT NULL DEFAULT '0',
  `maxbytes` bigint(10) NOT NULL DEFAULT '0',
  `maxattachments` bigint(10) NOT NULL DEFAULT '1',
  `forcesubscribe` tinyint(1) NOT NULL DEFAULT '0',
  `trackingtype` tinyint(2) NOT NULL DEFAULT '1',
  `rsstype` tinyint(2) NOT NULL DEFAULT '0',
  `rssarticles` tinyint(2) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `warnafter` bigint(10) NOT NULL DEFAULT '0',
  `blockafter` bigint(10) NOT NULL DEFAULT '0',
  `blockperiod` bigint(10) NOT NULL DEFAULT '0',
  `completiondiscussions` int(9) NOT NULL DEFAULT '0',
  `completionreplies` int(9) NOT NULL DEFAULT '0',
  `completionposts` int(9) NOT NULL DEFAULT '0',
  `displaywordcount` tinyint(1) NOT NULL DEFAULT '0',
  `lockdiscussionafter` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]foru_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Forums contain and structure discussion' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]forum_digests`
--

CREATE TABLE `[[dbprefix]]forum_digests` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL,
  `forum` bigint(10) NOT NULL,
  `maildigest` tinyint(1) NOT NULL DEFAULT '-1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]forudige_forusemai_uix` (`forum`,`userid`,`maildigest`),
  KEY `[[dbprefix]]forudige_use_ix` (`userid`),
  KEY `[[dbprefix]]forudige_for_ix` (`forum`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Keeps track of user mail delivery preferences for each forum' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]forum_discussions`
--

CREATE TABLE `[[dbprefix]]forum_discussions` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `forum` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `firstpost` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `groupid` bigint(10) NOT NULL DEFAULT '-1',
  `assessed` tinyint(1) NOT NULL DEFAULT '1',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `usermodified` bigint(10) NOT NULL DEFAULT '0',
  `timestart` bigint(10) NOT NULL DEFAULT '0',
  `timeend` bigint(10) NOT NULL DEFAULT '0',
  `pinned` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]forudisc_use_ix` (`userid`),
  KEY `[[dbprefix]]forudisc_cou_ix` (`course`),
  KEY `[[dbprefix]]forudisc_for_ix` (`forum`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Forums are composed of discussions' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]forum_discussion_subs`
--

CREATE TABLE `[[dbprefix]]forum_discussion_subs` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `forum` bigint(10) NOT NULL,
  `userid` bigint(10) NOT NULL,
  `discussion` bigint(10) NOT NULL,
  `preference` bigint(10) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]forudiscsubs_usedis_uix` (`userid`,`discussion`),
  KEY `[[dbprefix]]forudiscsubs_for_ix` (`forum`),
  KEY `[[dbprefix]]forudiscsubs_use_ix` (`userid`),
  KEY `[[dbprefix]]forudiscsubs_dis_ix` (`discussion`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Users may choose to subscribe and unsubscribe from specific ' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]forum_posts`
--

CREATE TABLE `[[dbprefix]]forum_posts` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `discussion` bigint(10) NOT NULL DEFAULT '0',
  `parent` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `created` bigint(10) NOT NULL DEFAULT '0',
  `modified` bigint(10) NOT NULL DEFAULT '0',
  `mailed` tinyint(2) NOT NULL DEFAULT '0',
  `subject` varchar(255) NOT NULL DEFAULT '',
  `message` longtext NOT NULL,
  `messageformat` tinyint(2) NOT NULL DEFAULT '0',
  `messagetrust` tinyint(2) NOT NULL DEFAULT '0',
  `attachment` varchar(100) NOT NULL DEFAULT '',
  `totalscore` smallint(4) NOT NULL DEFAULT '0',
  `mailnow` bigint(10) NOT NULL DEFAULT '0',
  `deleted` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]forupost_use_ix` (`userid`),
  KEY `[[dbprefix]]forupost_cre_ix` (`created`),
  KEY `[[dbprefix]]forupost_mai_ix` (`mailed`),
  KEY `[[dbprefix]]forupost_dis_ix` (`discussion`),
  KEY `[[dbprefix]]forupost_par_ix` (`parent`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='All posts are stored in this table' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]forum_queue`
--

CREATE TABLE `[[dbprefix]]forum_queue` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `discussionid` bigint(10) NOT NULL DEFAULT '0',
  `postid` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]foruqueu_use_ix` (`userid`),
  KEY `[[dbprefix]]foruqueu_dis_ix` (`discussionid`),
  KEY `[[dbprefix]]foruqueu_pos_ix` (`postid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='For keeping track of posts that will be mailed in digest for' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]forum_read`
--

CREATE TABLE `[[dbprefix]]forum_read` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `forumid` bigint(10) NOT NULL DEFAULT '0',
  `discussionid` bigint(10) NOT NULL DEFAULT '0',
  `postid` bigint(10) NOT NULL DEFAULT '0',
  `firstread` bigint(10) NOT NULL DEFAULT '0',
  `lastread` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]foruread_usefor_ix` (`userid`,`forumid`),
  KEY `[[dbprefix]]foruread_usedis_ix` (`userid`,`discussionid`),
  KEY `[[dbprefix]]foruread_posuse_ix` (`postid`,`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Tracks each users read posts' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]forum_subscriptions`
--

CREATE TABLE `[[dbprefix]]forum_subscriptions` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `forum` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]forusubs_usefor_uix` (`userid`,`forum`),
  KEY `[[dbprefix]]forusubs_use_ix` (`userid`),
  KEY `[[dbprefix]]forusubs_for_ix` (`forum`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Keeps track of who is subscribed to what forum' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]forum_track_prefs`
--

CREATE TABLE `[[dbprefix]]forum_track_prefs` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `forumid` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]forutracpref_usefor_ix` (`userid`,`forumid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Tracks each users untracked forums' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]glossary`
--

CREATE TABLE `[[dbprefix]]glossary` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `intro` longtext NOT NULL,
  `introformat` smallint(4) NOT NULL DEFAULT '0',
  `allowduplicatedentries` tinyint(2) NOT NULL DEFAULT '0',
  `displayformat` varchar(50) NOT NULL DEFAULT 'dictionary',
  `mainglossary` tinyint(2) NOT NULL DEFAULT '0',
  `showspecial` tinyint(2) NOT NULL DEFAULT '1',
  `showalphabet` tinyint(2) NOT NULL DEFAULT '1',
  `showall` tinyint(2) NOT NULL DEFAULT '1',
  `allowcomments` tinyint(2) NOT NULL DEFAULT '0',
  `allowprintview` tinyint(2) NOT NULL DEFAULT '1',
  `usedynalink` tinyint(2) NOT NULL DEFAULT '1',
  `defaultapproval` tinyint(2) NOT NULL DEFAULT '1',
  `approvaldisplayformat` varchar(50) NOT NULL DEFAULT 'default',
  `globalglossary` tinyint(2) NOT NULL DEFAULT '0',
  `entbypage` smallint(3) NOT NULL DEFAULT '10',
  `editalways` tinyint(2) NOT NULL DEFAULT '0',
  `rsstype` tinyint(2) NOT NULL DEFAULT '0',
  `rssarticles` tinyint(2) NOT NULL DEFAULT '0',
  `assessed` bigint(10) NOT NULL DEFAULT '0',
  `assesstimestart` bigint(10) NOT NULL DEFAULT '0',
  `assesstimefinish` bigint(10) NOT NULL DEFAULT '0',
  `scale` bigint(10) NOT NULL DEFAULT '0',
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `completionentries` int(9) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]glos_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='all glossaries' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]glossary_alias`
--

CREATE TABLE `[[dbprefix]]glossary_alias` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `entryid` bigint(10) NOT NULL DEFAULT '0',
  `alias` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]glosalia_ent_ix` (`entryid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='entries alias' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]glossary_categories`
--

CREATE TABLE `[[dbprefix]]glossary_categories` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `glossaryid` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `usedynalink` tinyint(2) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]gloscate_glo_ix` (`glossaryid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='all categories for glossary entries' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]glossary_entries`
--

CREATE TABLE `[[dbprefix]]glossary_entries` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `glossaryid` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `concept` varchar(255) NOT NULL DEFAULT '',
  `definition` longtext NOT NULL,
  `definitionformat` tinyint(2) NOT NULL DEFAULT '0',
  `definitiontrust` tinyint(2) NOT NULL DEFAULT '0',
  `attachment` varchar(100) NOT NULL DEFAULT '',
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `teacherentry` tinyint(2) NOT NULL DEFAULT '0',
  `sourceglossaryid` bigint(10) NOT NULL DEFAULT '0',
  `usedynalink` tinyint(2) NOT NULL DEFAULT '1',
  `casesensitive` tinyint(2) NOT NULL DEFAULT '0',
  `fullmatch` tinyint(2) NOT NULL DEFAULT '1',
  `approved` tinyint(2) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]glosentr_use_ix` (`userid`),
  KEY `[[dbprefix]]glosentr_con_ix` (`concept`),
  KEY `[[dbprefix]]glosentr_glo_ix` (`glossaryid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='all glossary entries' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]glossary_entries_categories`
--

CREATE TABLE `[[dbprefix]]glossary_entries_categories` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `categoryid` bigint(10) NOT NULL DEFAULT '0',
  `entryid` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]glosentrcate_cat_ix` (`categoryid`),
  KEY `[[dbprefix]]glosentrcate_ent_ix` (`entryid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='categories of each glossary entry' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]glossary_formats`
--

CREATE TABLE `[[dbprefix]]glossary_formats` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL DEFAULT '',
  `popupformatname` varchar(50) NOT NULL DEFAULT '',
  `visible` tinyint(2) NOT NULL DEFAULT '1',
  `showgroup` tinyint(2) NOT NULL DEFAULT '1',
  `showtabs` varchar(100) DEFAULT NULL,
  `defaultmode` varchar(50) NOT NULL DEFAULT '',
  `defaulthook` varchar(50) NOT NULL DEFAULT '',
  `sortkey` varchar(50) NOT NULL DEFAULT '',
  `sortorder` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Setting of the display formats' AUTO_INCREMENT=8 ;

--
-- Dumping data for table `[[dbprefix]]glossary_formats`
--

INSERT INTO `[[dbprefix]]glossary_formats` VALUES
(1, 'continuous', 'continuous', 1, 1, 'standard,category,date', '', '', '', ''),
(2, 'dictionary', 'dictionary', 1, 1, 'standard', '', '', '', ''),
(3, 'encyclopedia', 'encyclopedia', 1, 1, 'standard,category,date,author', '', '', '', ''),
(4, 'entrylist', 'entrylist', 1, 1, 'standard,category,date,author', '', '', '', ''),
(5, 'faq', 'faq', 1, 1, 'standard,category,date,author', '', '', '', ''),
(6, 'fullwithauthor', 'fullwithauthor', 1, 1, 'standard,category,date,author', '', '', '', ''),
(7, 'fullwithoutauthor', 'fullwithoutauthor', 1, 1, 'standard,category,date', '', '', '', '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]grade_categories`
--

CREATE TABLE `[[dbprefix]]grade_categories` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `courseid` bigint(10) NOT NULL,
  `parent` bigint(10) DEFAULT NULL,
  `depth` bigint(10) NOT NULL DEFAULT '0',
  `path` varchar(255) DEFAULT NULL,
  `fullname` varchar(255) NOT NULL DEFAULT '',
  `aggregation` bigint(10) NOT NULL DEFAULT '0',
  `keephigh` bigint(10) NOT NULL DEFAULT '0',
  `droplow` bigint(10) NOT NULL DEFAULT '0',
  `aggregateonlygraded` tinyint(1) NOT NULL DEFAULT '0',
  `aggregateoutcomes` tinyint(1) NOT NULL DEFAULT '0',
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `hidden` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]gradcate_cou_ix` (`courseid`),
  KEY `[[dbprefix]]gradcate_par_ix` (`parent`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='This table keeps information about categories, used for grou' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]grade_categories_history`
--

CREATE TABLE `[[dbprefix]]grade_categories_history` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `action` bigint(10) NOT NULL DEFAULT '0',
  `oldid` bigint(10) NOT NULL,
  `source` varchar(255) DEFAULT NULL,
  `timemodified` bigint(10) DEFAULT NULL,
  `loggeduser` bigint(10) DEFAULT NULL,
  `courseid` bigint(10) NOT NULL,
  `parent` bigint(10) DEFAULT NULL,
  `depth` bigint(10) NOT NULL DEFAULT '0',
  `path` varchar(255) DEFAULT NULL,
  `fullname` varchar(255) NOT NULL DEFAULT '',
  `aggregation` bigint(10) NOT NULL DEFAULT '0',
  `keephigh` bigint(10) NOT NULL DEFAULT '0',
  `droplow` bigint(10) NOT NULL DEFAULT '0',
  `aggregateonlygraded` tinyint(1) NOT NULL DEFAULT '0',
  `aggregateoutcomes` tinyint(1) NOT NULL DEFAULT '0',
  `aggregatesubcats` tinyint(1) NOT NULL DEFAULT '0',
  `hidden` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]gradcatehist_act_ix` (`action`),
  KEY `[[dbprefix]]gradcatehist_tim_ix` (`timemodified`),
  KEY `[[dbprefix]]gradcatehist_old_ix` (`oldid`),
  KEY `[[dbprefix]]gradcatehist_cou_ix` (`courseid`),
  KEY `[[dbprefix]]gradcatehist_par_ix` (`parent`),
  KEY `[[dbprefix]]gradcatehist_log_ix` (`loggeduser`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='History of grade_categories' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]grade_grades`
--

CREATE TABLE `[[dbprefix]]grade_grades` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `itemid` bigint(10) NOT NULL,
  `userid` bigint(10) NOT NULL,
  `rawgrade` decimal(10,5) DEFAULT NULL,
  `rawgrademax` decimal(10,5) NOT NULL DEFAULT '100.00000',
  `rawgrademin` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `rawscaleid` bigint(10) DEFAULT NULL,
  `usermodified` bigint(10) DEFAULT NULL,
  `finalgrade` decimal(10,5) DEFAULT NULL,
  `hidden` bigint(10) NOT NULL DEFAULT '0',
  `locked` bigint(10) NOT NULL DEFAULT '0',
  `locktime` bigint(10) NOT NULL DEFAULT '0',
  `exported` bigint(10) NOT NULL DEFAULT '0',
  `overridden` bigint(10) NOT NULL DEFAULT '0',
  `excluded` bigint(10) NOT NULL DEFAULT '0',
  `feedback` longtext,
  `feedbackformat` bigint(10) NOT NULL DEFAULT '0',
  `information` longtext,
  `informationformat` bigint(10) NOT NULL DEFAULT '0',
  `timecreated` bigint(10) DEFAULT NULL,
  `timemodified` bigint(10) DEFAULT NULL,
  `aggregationstatus` varchar(10) NOT NULL DEFAULT 'unknown',
  `aggregationweight` decimal(10,5) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]gradgrad_useite_uix` (`userid`,`itemid`),
  KEY `[[dbprefix]]gradgrad_locloc_ix` (`locked`,`locktime`),
  KEY `[[dbprefix]]gradgrad_ite_ix` (`itemid`),
  KEY `[[dbprefix]]gradgrad_use_ix` (`userid`),
  KEY `[[dbprefix]]gradgrad_raw_ix` (`rawscaleid`),
  KEY `[[dbprefix]]gradgrad_use2_ix` (`usermodified`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='grade_grades  This table keeps individual grades for each us' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]grade_grades_history`
--

CREATE TABLE `[[dbprefix]]grade_grades_history` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `action` bigint(10) NOT NULL DEFAULT '0',
  `oldid` bigint(10) NOT NULL,
  `source` varchar(255) DEFAULT NULL,
  `timemodified` bigint(10) DEFAULT NULL,
  `loggeduser` bigint(10) DEFAULT NULL,
  `itemid` bigint(10) NOT NULL,
  `userid` bigint(10) NOT NULL,
  `rawgrade` decimal(10,5) DEFAULT NULL,
  `rawgrademax` decimal(10,5) NOT NULL DEFAULT '100.00000',
  `rawgrademin` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `rawscaleid` bigint(10) DEFAULT NULL,
  `usermodified` bigint(10) DEFAULT NULL,
  `finalgrade` decimal(10,5) DEFAULT NULL,
  `hidden` bigint(10) NOT NULL DEFAULT '0',
  `locked` bigint(10) NOT NULL DEFAULT '0',
  `locktime` bigint(10) NOT NULL DEFAULT '0',
  `exported` bigint(10) NOT NULL DEFAULT '0',
  `overridden` bigint(10) NOT NULL DEFAULT '0',
  `excluded` bigint(10) NOT NULL DEFAULT '0',
  `feedback` longtext,
  `feedbackformat` bigint(10) NOT NULL DEFAULT '0',
  `information` longtext,
  `informationformat` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]gradgradhist_act_ix` (`action`),
  KEY `[[dbprefix]]gradgradhist_tim_ix` (`timemodified`),
  KEY `[[dbprefix]]gradgradhist_useiteti_ix` (`userid`,`itemid`,`timemodified`),
  KEY `[[dbprefix]]gradgradhist_old_ix` (`oldid`),
  KEY `[[dbprefix]]gradgradhist_ite_ix` (`itemid`),
  KEY `[[dbprefix]]gradgradhist_use_ix` (`userid`),
  KEY `[[dbprefix]]gradgradhist_raw_ix` (`rawscaleid`),
  KEY `[[dbprefix]]gradgradhist_use2_ix` (`usermodified`),
  KEY `[[dbprefix]]gradgradhist_log_ix` (`loggeduser`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='History table' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]grade_import_newitem`
--

CREATE TABLE `[[dbprefix]]grade_import_newitem` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `itemname` varchar(255) NOT NULL DEFAULT '',
  `importcode` bigint(10) NOT NULL,
  `importer` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]gradimponewi_imp_ix` (`importer`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='temporary table for storing new grade_item names from grade ' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]grade_import_values`
--

CREATE TABLE `[[dbprefix]]grade_import_values` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `itemid` bigint(10) DEFAULT NULL,
  `newgradeitem` bigint(10) DEFAULT NULL,
  `userid` bigint(10) NOT NULL,
  `finalgrade` decimal(10,5) DEFAULT NULL,
  `feedback` longtext,
  `importcode` bigint(10) NOT NULL,
  `importer` bigint(10) DEFAULT NULL,
  `importonlyfeedback` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]gradimpovalu_ite_ix` (`itemid`),
  KEY `[[dbprefix]]gradimpovalu_new_ix` (`newgradeitem`),
  KEY `[[dbprefix]]gradimpovalu_imp_ix` (`importer`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Temporary table for importing grades' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]grade_items`
--

CREATE TABLE `[[dbprefix]]grade_items` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `courseid` bigint(10) DEFAULT NULL,
  `categoryid` bigint(10) DEFAULT NULL,
  `itemname` varchar(255) DEFAULT NULL,
  `itemtype` varchar(30) NOT NULL DEFAULT '',
  `itemmodule` varchar(30) DEFAULT NULL,
  `iteminstance` bigint(10) DEFAULT NULL,
  `itemnumber` bigint(10) DEFAULT NULL,
  `iteminfo` longtext,
  `idnumber` varchar(255) DEFAULT NULL,
  `calculation` longtext,
  `gradetype` smallint(4) NOT NULL DEFAULT '1',
  `grademax` decimal(10,5) NOT NULL DEFAULT '100.00000',
  `grademin` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `scaleid` bigint(10) DEFAULT NULL,
  `outcomeid` bigint(10) DEFAULT NULL,
  `gradepass` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `multfactor` decimal(10,5) NOT NULL DEFAULT '1.00000',
  `plusfactor` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `aggregationcoef` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `aggregationcoef2` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `sortorder` bigint(10) NOT NULL DEFAULT '0',
  `display` bigint(10) NOT NULL DEFAULT '0',
  `decimals` tinyint(1) DEFAULT NULL,
  `hidden` bigint(10) NOT NULL DEFAULT '0',
  `locked` bigint(10) NOT NULL DEFAULT '0',
  `locktime` bigint(10) NOT NULL DEFAULT '0',
  `needsupdate` bigint(10) NOT NULL DEFAULT '0',
  `weightoverride` tinyint(1) NOT NULL DEFAULT '0',
  `timecreated` bigint(10) DEFAULT NULL,
  `timemodified` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]graditem_locloc_ix` (`locked`,`locktime`),
  KEY `[[dbprefix]]graditem_itenee_ix` (`itemtype`,`needsupdate`),
  KEY `[[dbprefix]]graditem_gra_ix` (`gradetype`),
  KEY `[[dbprefix]]graditem_idncou_ix` (`idnumber`,`courseid`),
  KEY `[[dbprefix]]graditem_cou_ix` (`courseid`),
  KEY `[[dbprefix]]graditem_cat_ix` (`categoryid`),
  KEY `[[dbprefix]]graditem_sca_ix` (`scaleid`),
  KEY `[[dbprefix]]graditem_out_ix` (`outcomeid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='This table keeps information about gradeable items (ie colum' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]grade_items_history`
--

CREATE TABLE `[[dbprefix]]grade_items_history` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `action` bigint(10) NOT NULL DEFAULT '0',
  `oldid` bigint(10) NOT NULL,
  `source` varchar(255) DEFAULT NULL,
  `timemodified` bigint(10) DEFAULT NULL,
  `loggeduser` bigint(10) DEFAULT NULL,
  `courseid` bigint(10) DEFAULT NULL,
  `categoryid` bigint(10) DEFAULT NULL,
  `itemname` varchar(255) DEFAULT NULL,
  `itemtype` varchar(30) NOT NULL DEFAULT '',
  `itemmodule` varchar(30) DEFAULT NULL,
  `iteminstance` bigint(10) DEFAULT NULL,
  `itemnumber` bigint(10) DEFAULT NULL,
  `iteminfo` longtext,
  `idnumber` varchar(255) DEFAULT NULL,
  `calculation` longtext,
  `gradetype` smallint(4) NOT NULL DEFAULT '1',
  `grademax` decimal(10,5) NOT NULL DEFAULT '100.00000',
  `grademin` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `scaleid` bigint(10) DEFAULT NULL,
  `outcomeid` bigint(10) DEFAULT NULL,
  `gradepass` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `multfactor` decimal(10,5) NOT NULL DEFAULT '1.00000',
  `plusfactor` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `aggregationcoef` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `aggregationcoef2` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `sortorder` bigint(10) NOT NULL DEFAULT '0',
  `hidden` bigint(10) NOT NULL DEFAULT '0',
  `locked` bigint(10) NOT NULL DEFAULT '0',
  `locktime` bigint(10) NOT NULL DEFAULT '0',
  `needsupdate` bigint(10) NOT NULL DEFAULT '0',
  `display` bigint(10) NOT NULL DEFAULT '0',
  `decimals` tinyint(1) DEFAULT NULL,
  `weightoverride` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]graditemhist_act_ix` (`action`),
  KEY `[[dbprefix]]graditemhist_tim_ix` (`timemodified`),
  KEY `[[dbprefix]]graditemhist_old_ix` (`oldid`),
  KEY `[[dbprefix]]graditemhist_cou_ix` (`courseid`),
  KEY `[[dbprefix]]graditemhist_cat_ix` (`categoryid`),
  KEY `[[dbprefix]]graditemhist_sca_ix` (`scaleid`),
  KEY `[[dbprefix]]graditemhist_out_ix` (`outcomeid`),
  KEY `[[dbprefix]]graditemhist_log_ix` (`loggeduser`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='History of grade_items' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]grade_letters`
--

CREATE TABLE `[[dbprefix]]grade_letters` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `contextid` bigint(10) NOT NULL,
  `lowerboundary` decimal(10,5) NOT NULL,
  `letter` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]gradlett_conlowlet_uix` (`contextid`,`lowerboundary`,`letter`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Repository for grade letters, for courses and other moodle e' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]grade_outcomes`
--

CREATE TABLE `[[dbprefix]]grade_outcomes` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `courseid` bigint(10) DEFAULT NULL,
  `shortname` varchar(255) NOT NULL DEFAULT '',
  `fullname` longtext NOT NULL,
  `scaleid` bigint(10) DEFAULT NULL,
  `description` longtext,
  `descriptionformat` tinyint(2) NOT NULL DEFAULT '0',
  `timecreated` bigint(10) DEFAULT NULL,
  `timemodified` bigint(10) DEFAULT NULL,
  `usermodified` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]gradoutc_cousho_uix` (`courseid`,`shortname`),
  KEY `[[dbprefix]]gradoutc_cou_ix` (`courseid`),
  KEY `[[dbprefix]]gradoutc_sca_ix` (`scaleid`),
  KEY `[[dbprefix]]gradoutc_use_ix` (`usermodified`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='This table describes the outcomes used in the system. An out' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]grade_outcomes_courses`
--

CREATE TABLE `[[dbprefix]]grade_outcomes_courses` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `courseid` bigint(10) NOT NULL,
  `outcomeid` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]gradoutccour_couout_uix` (`courseid`,`outcomeid`),
  KEY `[[dbprefix]]gradoutccour_cou_ix` (`courseid`),
  KEY `[[dbprefix]]gradoutccour_out_ix` (`outcomeid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='stores what outcomes are used in what courses.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]grade_outcomes_history`
--

CREATE TABLE `[[dbprefix]]grade_outcomes_history` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `action` bigint(10) NOT NULL DEFAULT '0',
  `oldid` bigint(10) NOT NULL,
  `source` varchar(255) DEFAULT NULL,
  `timemodified` bigint(10) DEFAULT NULL,
  `loggeduser` bigint(10) DEFAULT NULL,
  `courseid` bigint(10) DEFAULT NULL,
  `shortname` varchar(255) NOT NULL DEFAULT '',
  `fullname` longtext NOT NULL,
  `scaleid` bigint(10) DEFAULT NULL,
  `description` longtext,
  `descriptionformat` tinyint(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]gradoutchist_act_ix` (`action`),
  KEY `[[dbprefix]]gradoutchist_tim_ix` (`timemodified`),
  KEY `[[dbprefix]]gradoutchist_old_ix` (`oldid`),
  KEY `[[dbprefix]]gradoutchist_cou_ix` (`courseid`),
  KEY `[[dbprefix]]gradoutchist_sca_ix` (`scaleid`),
  KEY `[[dbprefix]]gradoutchist_log_ix` (`loggeduser`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='History table' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]grade_settings`
--

CREATE TABLE `[[dbprefix]]grade_settings` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `courseid` bigint(10) NOT NULL,
  `name` varchar(255) NOT NULL DEFAULT '',
  `value` longtext,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]gradsett_counam_uix` (`courseid`,`name`),
  KEY `[[dbprefix]]gradsett_cou_ix` (`courseid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='gradebook settings' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]gradingform_guide_comments`
--

CREATE TABLE `[[dbprefix]]gradingform_guide_comments` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `definitionid` bigint(10) NOT NULL,
  `sortorder` bigint(10) NOT NULL,
  `description` longtext,
  `descriptionformat` tinyint(2) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]gradguidcomm_def_ix` (`definitionid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='frequently used comments used in marking guide' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]gradingform_guide_criteria`
--

CREATE TABLE `[[dbprefix]]gradingform_guide_criteria` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `definitionid` bigint(10) NOT NULL,
  `sortorder` bigint(10) NOT NULL,
  `shortname` varchar(255) NOT NULL DEFAULT '',
  `description` longtext,
  `descriptionformat` tinyint(2) DEFAULT NULL,
  `descriptionmarkers` longtext,
  `descriptionmarkersformat` tinyint(2) DEFAULT NULL,
  `maxscore` decimal(10,5) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]gradguidcrit_def_ix` (`definitionid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Stores the rows of the criteria grid.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]gradingform_guide_fillings`
--

CREATE TABLE `[[dbprefix]]gradingform_guide_fillings` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `instanceid` bigint(10) NOT NULL,
  `criterionid` bigint(10) NOT NULL,
  `remark` longtext,
  `remarkformat` tinyint(2) DEFAULT NULL,
  `score` decimal(10,5) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]gradguidfill_inscri_uix` (`instanceid`,`criterionid`),
  KEY `[[dbprefix]]gradguidfill_ins_ix` (`instanceid`),
  KEY `[[dbprefix]]gradguidfill_cri_ix` (`criterionid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Stores the data of how the guide is filled by a particular r' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]gradingform_rubric_criteria`
--

CREATE TABLE `[[dbprefix]]gradingform_rubric_criteria` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `definitionid` bigint(10) NOT NULL,
  `sortorder` bigint(10) NOT NULL,
  `description` longtext,
  `descriptionformat` tinyint(2) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]gradrubrcrit_def_ix` (`definitionid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Stores the rows of the rubric grid.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]gradingform_rubric_fillings`
--

CREATE TABLE `[[dbprefix]]gradingform_rubric_fillings` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `instanceid` bigint(10) NOT NULL,
  `criterionid` bigint(10) NOT NULL,
  `levelid` bigint(10) DEFAULT NULL,
  `remark` longtext,
  `remarkformat` tinyint(2) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]gradrubrfill_inscri_uix` (`instanceid`,`criterionid`),
  KEY `[[dbprefix]]gradrubrfill_lev_ix` (`levelid`),
  KEY `[[dbprefix]]gradrubrfill_ins_ix` (`instanceid`),
  KEY `[[dbprefix]]gradrubrfill_cri_ix` (`criterionid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Stores the data of how the rubric is filled by a particular ' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]gradingform_rubric_levels`
--

CREATE TABLE `[[dbprefix]]gradingform_rubric_levels` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `criterionid` bigint(10) NOT NULL,
  `score` decimal(10,5) NOT NULL,
  `definition` longtext,
  `definitionformat` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]gradrubrleve_cri_ix` (`criterionid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Stores the columns of the rubric grid.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]grading_areas`
--

CREATE TABLE `[[dbprefix]]grading_areas` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `contextid` bigint(10) NOT NULL,
  `component` varchar(100) NOT NULL DEFAULT '',
  `areaname` varchar(100) NOT NULL DEFAULT '',
  `activemethod` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]gradarea_concomare_uix` (`contextid`,`component`,`areaname`),
  KEY `[[dbprefix]]gradarea_con_ix` (`contextid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Identifies gradable areas where advanced grading can happen.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]grading_definitions`
--

CREATE TABLE `[[dbprefix]]grading_definitions` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `areaid` bigint(10) NOT NULL,
  `method` varchar(100) NOT NULL DEFAULT '',
  `name` varchar(255) NOT NULL DEFAULT '',
  `description` longtext,
  `descriptionformat` tinyint(2) DEFAULT NULL,
  `status` bigint(10) NOT NULL DEFAULT '0',
  `copiedfromid` bigint(10) DEFAULT NULL,
  `timecreated` bigint(10) NOT NULL,
  `usercreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `usermodified` bigint(10) NOT NULL,
  `timecopied` bigint(10) DEFAULT '0',
  `options` longtext,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]graddefi_aremet_uix` (`areaid`,`method`),
  KEY `[[dbprefix]]graddefi_are_ix` (`areaid`),
  KEY `[[dbprefix]]graddefi_use_ix` (`usermodified`),
  KEY `[[dbprefix]]graddefi_use2_ix` (`usercreated`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Contains the basic information about an advanced grading for' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]grading_instances`
--

CREATE TABLE `[[dbprefix]]grading_instances` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `definitionid` bigint(10) NOT NULL,
  `raterid` bigint(10) NOT NULL,
  `itemid` bigint(10) DEFAULT NULL,
  `rawgrade` decimal(10,5) DEFAULT NULL,
  `status` bigint(10) NOT NULL DEFAULT '0',
  `feedback` longtext,
  `feedbackformat` tinyint(2) DEFAULT NULL,
  `timemodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]gradinst_def_ix` (`definitionid`),
  KEY `[[dbprefix]]gradinst_rat_ix` (`raterid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Grading form instance is an assessment record for one gradab' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]groupings`
--

CREATE TABLE `[[dbprefix]]groupings` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `courseid` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `idnumber` varchar(100) NOT NULL DEFAULT '',
  `description` longtext,
  `descriptionformat` tinyint(2) NOT NULL DEFAULT '0',
  `configdata` longtext,
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]grou_idn2_ix` (`idnumber`),
  KEY `[[dbprefix]]grou_cou2_ix` (`courseid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='A grouping is a collection of groups. WAS: groups_groupings' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]groupings_groups`
--

CREATE TABLE `[[dbprefix]]groupings_groups` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `groupingid` bigint(10) NOT NULL DEFAULT '0',
  `groupid` bigint(10) NOT NULL DEFAULT '0',
  `timeadded` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]grougrou_gro_ix` (`groupingid`),
  KEY `[[dbprefix]]grougrou_gro2_ix` (`groupid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Link a grouping to a group (note, groups can be in multiple ' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]groups`
--

CREATE TABLE `[[dbprefix]]groups` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `courseid` bigint(10) NOT NULL,
  `idnumber` varchar(100) NOT NULL DEFAULT '',
  `name` varchar(254) NOT NULL DEFAULT '',
  `description` longtext,
  `descriptionformat` tinyint(2) NOT NULL DEFAULT '0',
  `enrolmentkey` varchar(50) DEFAULT NULL,
  `picture` bigint(10) NOT NULL DEFAULT '0',
  `hidepicture` tinyint(1) NOT NULL DEFAULT '0',
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]grou_idn_ix` (`idnumber`),
  KEY `[[dbprefix]]grou_cou_ix` (`courseid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Each record represents a group.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]groups_members`
--

CREATE TABLE `[[dbprefix]]groups_members` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `groupid` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `timeadded` bigint(10) NOT NULL DEFAULT '0',
  `component` varchar(100) NOT NULL DEFAULT '',
  `itemid` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]groumemb_usegro_uix` (`userid`,`groupid`),
  KEY `[[dbprefix]]groumemb_gro_ix` (`groupid`),
  KEY `[[dbprefix]]groumemb_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Link a user to a group.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]imscp`
--

CREATE TABLE `[[dbprefix]]imscp` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `intro` longtext,
  `introformat` smallint(4) NOT NULL DEFAULT '0',
  `revision` bigint(10) NOT NULL DEFAULT '0',
  `keepold` bigint(10) NOT NULL DEFAULT '-1',
  `structure` longtext,
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]imsc_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='each record is one imscp resource' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]label`
--

CREATE TABLE `[[dbprefix]]label` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `intro` longtext NOT NULL,
  `introformat` smallint(4) DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]labe_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Defines labels' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]lesson`
--

CREATE TABLE `[[dbprefix]]lesson` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `intro` longtext,
  `introformat` smallint(4) NOT NULL DEFAULT '0',
  `practice` smallint(3) NOT NULL DEFAULT '0',
  `modattempts` smallint(3) NOT NULL DEFAULT '0',
  `usepassword` smallint(3) NOT NULL DEFAULT '0',
  `password` varchar(32) NOT NULL DEFAULT '',
  `dependency` bigint(10) NOT NULL DEFAULT '0',
  `conditions` longtext NOT NULL,
  `grade` bigint(10) NOT NULL DEFAULT '0',
  `custom` smallint(3) NOT NULL DEFAULT '0',
  `ongoing` smallint(3) NOT NULL DEFAULT '0',
  `usemaxgrade` smallint(3) NOT NULL DEFAULT '0',
  `maxanswers` smallint(3) NOT NULL DEFAULT '4',
  `maxattempts` smallint(3) NOT NULL DEFAULT '5',
  `review` smallint(3) NOT NULL DEFAULT '0',
  `nextpagedefault` smallint(3) NOT NULL DEFAULT '0',
  `feedback` smallint(3) NOT NULL DEFAULT '1',
  `minquestions` smallint(3) NOT NULL DEFAULT '0',
  `maxpages` smallint(3) NOT NULL DEFAULT '0',
  `timelimit` bigint(10) NOT NULL DEFAULT '0',
  `retake` smallint(3) NOT NULL DEFAULT '1',
  `activitylink` bigint(10) NOT NULL DEFAULT '0',
  `mediafile` varchar(255) NOT NULL DEFAULT '',
  `mediaheight` bigint(10) NOT NULL DEFAULT '100',
  `mediawidth` bigint(10) NOT NULL DEFAULT '650',
  `mediaclose` smallint(3) NOT NULL DEFAULT '0',
  `slideshow` smallint(3) NOT NULL DEFAULT '0',
  `width` bigint(10) NOT NULL DEFAULT '640',
  `height` bigint(10) NOT NULL DEFAULT '480',
  `bgcolor` varchar(7) NOT NULL DEFAULT '#FFFFFF',
  `displayleft` smallint(3) NOT NULL DEFAULT '0',
  `displayleftif` smallint(3) NOT NULL DEFAULT '0',
  `progressbar` smallint(3) NOT NULL DEFAULT '0',
  `available` bigint(10) NOT NULL DEFAULT '0',
  `deadline` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `completionendreached` tinyint(1) DEFAULT '0',
  `completiontimespent` bigint(11) DEFAULT '0',
  `allowofflineattempts` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]less_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Defines lesson' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]lesson_answers`
--

CREATE TABLE `[[dbprefix]]lesson_answers` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `lessonid` bigint(10) NOT NULL DEFAULT '0',
  `pageid` bigint(10) NOT NULL DEFAULT '0',
  `jumpto` bigint(11) NOT NULL DEFAULT '0',
  `grade` smallint(4) NOT NULL DEFAULT '0',
  `score` bigint(10) NOT NULL DEFAULT '0',
  `flags` smallint(3) NOT NULL DEFAULT '0',
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `answer` longtext,
  `answerformat` tinyint(2) NOT NULL DEFAULT '0',
  `response` longtext,
  `responseformat` tinyint(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]lessansw_les_ix` (`lessonid`),
  KEY `[[dbprefix]]lessansw_pag_ix` (`pageid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Defines lesson_answers' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]lesson_attempts`
--

CREATE TABLE `[[dbprefix]]lesson_attempts` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `lessonid` bigint(10) NOT NULL DEFAULT '0',
  `pageid` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `answerid` bigint(10) NOT NULL DEFAULT '0',
  `retry` smallint(3) NOT NULL DEFAULT '0',
  `correct` bigint(10) NOT NULL DEFAULT '0',
  `useranswer` longtext,
  `timeseen` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]lessatte_use_ix` (`userid`),
  KEY `[[dbprefix]]lessatte_les_ix` (`lessonid`),
  KEY `[[dbprefix]]lessatte_pag_ix` (`pageid`),
  KEY `[[dbprefix]]lessatte_ans_ix` (`answerid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Defines lesson_attempts' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]lesson_branch`
--

CREATE TABLE `[[dbprefix]]lesson_branch` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `lessonid` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `pageid` bigint(10) NOT NULL DEFAULT '0',
  `retry` bigint(10) NOT NULL DEFAULT '0',
  `flag` smallint(3) NOT NULL DEFAULT '0',
  `timeseen` bigint(10) NOT NULL DEFAULT '0',
  `nextpageid` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]lessbran_use_ix` (`userid`),
  KEY `[[dbprefix]]lessbran_les_ix` (`lessonid`),
  KEY `[[dbprefix]]lessbran_pag_ix` (`pageid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='branches for each lesson/user' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]lesson_grades`
--

CREATE TABLE `[[dbprefix]]lesson_grades` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `lessonid` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `grade` double NOT NULL DEFAULT '0',
  `late` smallint(3) NOT NULL DEFAULT '0',
  `completed` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]lessgrad_use_ix` (`userid`),
  KEY `[[dbprefix]]lessgrad_les_ix` (`lessonid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Defines lesson_grades' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]lesson_overrides`
--

CREATE TABLE `[[dbprefix]]lesson_overrides` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `lessonid` bigint(10) NOT NULL DEFAULT '0',
  `groupid` bigint(10) DEFAULT NULL,
  `userid` bigint(10) DEFAULT NULL,
  `available` bigint(10) DEFAULT NULL,
  `deadline` bigint(10) DEFAULT NULL,
  `timelimit` bigint(10) DEFAULT NULL,
  `review` smallint(3) DEFAULT NULL,
  `maxattempts` smallint(3) DEFAULT NULL,
  `retake` smallint(3) DEFAULT NULL,
  `password` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]lessover_les_ix` (`lessonid`),
  KEY `[[dbprefix]]lessover_gro_ix` (`groupid`),
  KEY `[[dbprefix]]lessover_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='The overrides to lesson settings.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]lesson_pages`
--

CREATE TABLE `[[dbprefix]]lesson_pages` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `lessonid` bigint(10) NOT NULL DEFAULT '0',
  `prevpageid` bigint(10) NOT NULL DEFAULT '0',
  `nextpageid` bigint(10) NOT NULL DEFAULT '0',
  `qtype` smallint(3) NOT NULL DEFAULT '0',
  `qoption` smallint(3) NOT NULL DEFAULT '0',
  `layout` smallint(3) NOT NULL DEFAULT '1',
  `display` smallint(3) NOT NULL DEFAULT '1',
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `contents` longtext NOT NULL,
  `contentsformat` tinyint(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]lesspage_les_ix` (`lessonid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Defines lesson_pages' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]lesson_timer`
--

CREATE TABLE `[[dbprefix]]lesson_timer` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `lessonid` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `starttime` bigint(10) NOT NULL DEFAULT '0',
  `lessontime` bigint(10) NOT NULL DEFAULT '0',
  `completed` tinyint(1) DEFAULT '0',
  `timemodifiedoffline` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]lesstime_use_ix` (`userid`),
  KEY `[[dbprefix]]lesstime_les_ix` (`lessonid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='lesson timer for each lesson' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]license`
--

CREATE TABLE `[[dbprefix]]license` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `shortname` varchar(255) DEFAULT NULL,
  `fullname` longtext,
  `source` varchar(255) DEFAULT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT '1',
  `version` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='store licenses used by moodle' AUTO_INCREMENT=10 ;

--
-- Dumping data for table `[[dbprefix]]license`
--

INSERT INTO `[[dbprefix]]license` VALUES
(1, 'unknown', 'Unknown license', '', 1, 2010033100),
(2, 'allrightsreserved', 'All rights reserved', 'http://en.wikipedia.org/wiki/All_rights_reserved', 1, 2010033100),
(3, 'public', 'Public Domain', 'http://creativecommons.org/licenses/publicdomain/', 1, 2010033100),
(4, 'cc', 'Creative Commons', 'http://creativecommons.org/licenses/by/3.0/', 1, 2010033100),
(5, 'cc-nd', 'Creative Commons - NoDerivs', 'http://creativecommons.org/licenses/by-nd/3.0/', 1, 2010033100),
(6, 'cc-nc-nd', 'Creative Commons - No Commercial NoDerivs', 'http://creativecommons.org/licenses/by-nc-nd/3.0/', 1, 2010033100),
(7, 'cc-nc', 'Creative Commons - No Commercial', 'http://creativecommons.org/licenses/by-nc/3.0/', 1, 2013051500),
(8, 'cc-nc-sa', 'Creative Commons - No Commercial ShareAlike', 'http://creativecommons.org/licenses/by-nc-sa/3.0/', 1, 2010033100),
(9, 'cc-sa', 'Creative Commons - ShareAlike', 'http://creativecommons.org/licenses/by-sa/3.0/', 1, 2010033100);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]lock_db`
--

CREATE TABLE `[[dbprefix]]lock_db` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `resourcekey` varchar(255) NOT NULL DEFAULT '',
  `expires` bigint(10) DEFAULT NULL,
  `owner` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]lockdb_res_uix` (`resourcekey`),
  KEY `[[dbprefix]]lockdb_exp_ix` (`expires`),
  KEY `[[dbprefix]]lockdb_own_ix` (`owner`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Stores active and inactive lock types for db locking method.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]log`
--

CREATE TABLE `[[dbprefix]]log` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `time` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `ip` varchar(45) NOT NULL DEFAULT '',
  `course` bigint(10) NOT NULL DEFAULT '0',
  `module` varchar(20) NOT NULL DEFAULT '',
  `cmid` bigint(10) NOT NULL DEFAULT '0',
  `action` varchar(40) NOT NULL DEFAULT '',
  `url` varchar(100) NOT NULL DEFAULT '',
  `info` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]log_coumodact_ix` (`course`,`module`,`action`),
  KEY `[[dbprefix]]log_tim_ix` (`time`),
  KEY `[[dbprefix]]log_act_ix` (`action`),
  KEY `[[dbprefix]]log_usecou_ix` (`userid`,`course`),
  KEY `[[dbprefix]]log_cmi_ix` (`cmid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Every action is logged as far as possible' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]logstore_standard_log`
--

CREATE TABLE `[[dbprefix]]logstore_standard_log` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `eventname` varchar(255) NOT NULL DEFAULT '',
  `component` varchar(100) NOT NULL DEFAULT '',
  `action` varchar(100) NOT NULL DEFAULT '',
  `target` varchar(100) NOT NULL DEFAULT '',
  `objecttable` varchar(50) DEFAULT NULL,
  `objectid` bigint(10) DEFAULT NULL,
  `crud` varchar(1) NOT NULL DEFAULT '',
  `edulevel` tinyint(1) NOT NULL,
  `contextid` bigint(10) NOT NULL,
  `contextlevel` bigint(10) NOT NULL,
  `contextinstanceid` bigint(10) NOT NULL,
  `userid` bigint(10) NOT NULL,
  `courseid` bigint(10) DEFAULT NULL,
  `relateduserid` bigint(10) DEFAULT NULL,
  `anonymous` tinyint(1) NOT NULL DEFAULT '0',
  `other` longtext,
  `timecreated` bigint(10) NOT NULL,
  `origin` varchar(10) DEFAULT NULL,
  `ip` varchar(45) DEFAULT NULL,
  `realuserid` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]logsstanlog_tim_ix` (`timecreated`),
  KEY `[[dbprefix]]logsstanlog_couanotim_ix` (`courseid`,`anonymous`,`timecreated`),
  KEY `[[dbprefix]]logsstanlog_useconcon_ix` (`userid`,`contextlevel`,`contextinstanceid`,`crud`,`edulevel`,`timecreated`),
  KEY `[[dbprefix]]logsstanlog_con_ix` (`contextid`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Standard log table' AUTO_INCREMENT=1 ;

--
-- Dumping data for table `[[dbprefix]]logstore_standard_log`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]log_display`
--

CREATE TABLE `[[dbprefix]]log_display` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `module` varchar(20) NOT NULL DEFAULT '',
  `action` varchar(40) NOT NULL DEFAULT '',
  `mtable` varchar(30) NOT NULL DEFAULT '',
  `field` varchar(200) NOT NULL DEFAULT '',
  `component` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]logdisp_modact_uix` (`module`,`action`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='For a particular module/action, specifies a moodle table/fie' AUTO_INCREMENT=190 ;

--
-- Dumping data for table `[[dbprefix]]log_display`
--

INSERT INTO `[[dbprefix]]log_display` VALUES
(1, 'course', 'user report', 'user', 'CONCAT(firstname, '' '', lastname)', 'moodle'),
(2, 'course', 'view', 'course', 'fullname', 'moodle'),
(3, 'course', 'view section', 'course_sections', 'name', 'moodle'),
(4, 'course', 'update', 'course', 'fullname', 'moodle'),
(5, 'course', 'hide', 'course', 'fullname', 'moodle'),
(6, 'course', 'show', 'course', 'fullname', 'moodle'),
(7, 'course', 'move', 'course', 'fullname', 'moodle'),
(8, 'course', 'enrol', 'course', 'fullname', 'moodle'),
(9, 'course', 'unenrol', 'course', 'fullname', 'moodle'),
(10, 'course', 'report log', 'course', 'fullname', 'moodle'),
(11, 'course', 'report live', 'course', 'fullname', 'moodle'),
(12, 'course', 'report outline', 'course', 'fullname', 'moodle'),
(13, 'course', 'report participation', 'course', 'fullname', 'moodle'),
(14, 'course', 'report stats', 'course', 'fullname', 'moodle'),
(15, 'category', 'add', 'course_categories', 'name', 'moodle'),
(16, 'category', 'hide', 'course_categories', 'name', 'moodle'),
(17, 'category', 'move', 'course_categories', 'name', 'moodle'),
(18, 'category', 'show', 'course_categories', 'name', 'moodle'),
(19, 'category', 'update', 'course_categories', 'name', 'moodle'),
(20, 'message', 'write', 'user', 'CONCAT(firstname, '' '', lastname)', 'moodle'),
(21, 'message', 'read', 'user', 'CONCAT(firstname, '' '', lastname)', 'moodle'),
(22, 'message', 'add contact', 'user', 'CONCAT(firstname, '' '', lastname)', 'moodle'),
(23, 'message', 'remove contact', 'user', 'CONCAT(firstname, '' '', lastname)', 'moodle'),
(24, 'message', 'block contact', 'user', 'CONCAT(firstname, '' '', lastname)', 'moodle'),
(25, 'message', 'unblock contact', 'user', 'CONCAT(firstname, '' '', lastname)', 'moodle'),
(26, 'group', 'view', 'groups', 'name', 'moodle'),
(27, 'tag', 'update', 'tag', 'name', 'moodle'),
(28, 'tag', 'flag', 'tag', 'name', 'moodle'),
(29, 'user', 'view', 'user', 'CONCAT(firstname, '' '', lastname)', 'moodle'),
(30, 'assign', 'add', 'assign', 'name', 'mod_assign'),
(31, 'assign', 'delete mod', 'assign', 'name', 'mod_assign'),
(32, 'assign', 'download all submissions', 'assign', 'name', 'mod_assign'),
(33, 'assign', 'grade submission', 'assign', 'name', 'mod_assign'),
(34, 'assign', 'lock submission', 'assign', 'name', 'mod_assign'),
(35, 'assign', 'reveal identities', 'assign', 'name', 'mod_assign'),
(36, 'assign', 'revert submission to draft', 'assign', 'name', 'mod_assign'),
(37, 'assign', 'set marking workflow state', 'assign', 'name', 'mod_assign'),
(38, 'assign', 'submission statement accepted', 'assign', 'name', 'mod_assign'),
(39, 'assign', 'submit', 'assign', 'name', 'mod_assign'),
(40, 'assign', 'submit for grading', 'assign', 'name', 'mod_assign'),
(41, 'assign', 'unlock submission', 'assign', 'name', 'mod_assign'),
(42, 'assign', 'update', 'assign', 'name', 'mod_assign'),
(43, 'assign', 'upload', 'assign', 'name', 'mod_assign'),
(44, 'assign', 'view', 'assign', 'name', 'mod_assign'),
(45, 'assign', 'view all', 'course', 'fullname', 'mod_assign'),
(46, 'assign', 'view confirm submit assignment form', 'assign', 'name', 'mod_assign'),
(47, 'assign', 'view grading form', 'assign', 'name', 'mod_assign'),
(48, 'assign', 'view submission', 'assign', 'name', 'mod_assign'),
(49, 'assign', 'view submission grading table', 'assign', 'name', 'mod_assign'),
(50, 'assign', 'view submit assignment form', 'assign', 'name', 'mod_assign'),
(51, 'assign', 'view feedback', 'assign', 'name', 'mod_assign'),
(52, 'assign', 'view batch set marking workflow state', 'assign', 'name', 'mod_assign'),
(53, 'assignment', 'view', 'assignment', 'name', 'mod_assignment'),
(54, 'assignment', 'add', 'assignment', 'name', 'mod_assignment'),
(55, 'assignment', 'update', 'assignment', 'name', 'mod_assignment'),
(56, 'assignment', 'view submission', 'assignment', 'name', 'mod_assignment'),
(57, 'assignment', 'upload', 'assignment', 'name', 'mod_assignment'),
(58, 'book', 'add', 'book', 'name', 'mod_book'),
(59, 'book', 'update', 'book', 'name', 'mod_book'),
(60, 'book', 'view', 'book', 'name', 'mod_book'),
(61, 'book', 'add chapter', 'book_chapters', 'title', 'mod_book'),
(62, 'book', 'update chapter', 'book_chapters', 'title', 'mod_book'),
(63, 'book', 'view chapter', 'book_chapters', 'title', 'mod_book'),
(64, 'chat', 'view', 'chat', 'name', 'mod_chat'),
(65, 'chat', 'add', 'chat', 'name', 'mod_chat'),
(66, 'chat', 'update', 'chat', 'name', 'mod_chat'),
(67, 'chat', 'report', 'chat', 'name', 'mod_chat'),
(68, 'chat', 'talk', 'chat', 'name', 'mod_chat'),
(69, 'choice', 'view', 'choice', 'name', 'mod_choice'),
(70, 'choice', 'update', 'choice', 'name', 'mod_choice'),
(71, 'choice', 'add', 'choice', 'name', 'mod_choice'),
(72, 'choice', 'report', 'choice', 'name', 'mod_choice'),
(73, 'choice', 'choose', 'choice', 'name', 'mod_choice'),
(74, 'choice', 'choose again', 'choice', 'name', 'mod_choice'),
(75, 'data', 'view', 'data', 'name', 'mod_data'),
(76, 'data', 'add', 'data', 'name', 'mod_data'),
(77, 'data', 'update', 'data', 'name', 'mod_data'),
(78, 'data', 'record delete', 'data', 'name', 'mod_data'),
(79, 'data', 'fields add', 'data_fields', 'name', 'mod_data'),
(80, 'data', 'fields update', 'data_fields', 'name', 'mod_data'),
(81, 'data', 'templates saved', 'data', 'name', 'mod_data'),
(82, 'data', 'templates def', 'data', 'name', 'mod_data'),
(83, 'feedback', 'startcomplete', 'feedback', 'name', 'mod_feedback'),
(84, 'feedback', 'submit', 'feedback', 'name', 'mod_feedback'),
(85, 'feedback', 'delete', 'feedback', 'name', 'mod_feedback'),
(86, 'feedback', 'view', 'feedback', 'name', 'mod_feedback'),
(87, 'feedback', 'view all', 'course', 'shortname', 'mod_feedback'),
(88, 'folder', 'view', 'folder', 'name', 'mod_folder'),
(89, 'folder', 'view all', 'folder', 'name', 'mod_folder'),
(90, 'folder', 'update', 'folder', 'name', 'mod_folder'),
(91, 'folder', 'add', 'folder', 'name', 'mod_folder'),
(92, 'forum', 'add', 'forum', 'name', 'mod_forum'),
(93, 'forum', 'update', 'forum', 'name', 'mod_forum'),
(94, 'forum', 'add discussion', 'forum_discussions', 'name', 'mod_forum'),
(95, 'forum', 'add post', 'forum_posts', 'subject', 'mod_forum'),
(96, 'forum', 'update post', 'forum_posts', 'subject', 'mod_forum'),
(97, 'forum', 'user report', 'user', 'CONCAT(firstname, '' '', lastname)', 'mod_forum'),
(98, 'forum', 'move discussion', 'forum_discussions', 'name', 'mod_forum'),
(99, 'forum', 'view subscribers', 'forum', 'name', 'mod_forum'),
(100, 'forum', 'view discussion', 'forum_discussions', 'name', 'mod_forum'),
(101, 'forum', 'view forum', 'forum', 'name', 'mod_forum'),
(102, 'forum', 'subscribe', 'forum', 'name', 'mod_forum'),
(103, 'forum', 'unsubscribe', 'forum', 'name', 'mod_forum'),
(104, 'forum', 'pin discussion', 'forum_discussions', 'name', 'mod_forum'),
(105, 'forum', 'unpin discussion', 'forum_discussions', 'name', 'mod_forum'),
(106, 'glossary', 'add', 'glossary', 'name', 'mod_glossary'),
(107, 'glossary', 'update', 'glossary', 'name', 'mod_glossary'),
(108, 'glossary', 'view', 'glossary', 'name', 'mod_glossary'),
(109, 'glossary', 'view all', 'glossary', 'name', 'mod_glossary'),
(110, 'glossary', 'add entry', 'glossary', 'name', 'mod_glossary'),
(111, 'glossary', 'update entry', 'glossary', 'name', 'mod_glossary'),
(112, 'glossary', 'add category', 'glossary', 'name', 'mod_glossary'),
(113, 'glossary', 'update category', 'glossary', 'name', 'mod_glossary'),
(114, 'glossary', 'delete category', 'glossary', 'name', 'mod_glossary'),
(115, 'glossary', 'approve entry', 'glossary', 'name', 'mod_glossary'),
(116, 'glossary', 'disapprove entry', 'glossary', 'name', 'mod_glossary'),
(117, 'glossary', 'view entry', 'glossary_entries', 'concept', 'mod_glossary'),
(118, 'imscp', 'view', 'imscp', 'name', 'mod_imscp'),
(119, 'imscp', 'view all', 'imscp', 'name', 'mod_imscp'),
(120, 'imscp', 'update', 'imscp', 'name', 'mod_imscp'),
(121, 'imscp', 'add', 'imscp', 'name', 'mod_imscp'),
(122, 'label', 'add', 'label', 'name', 'mod_label'),
(123, 'label', 'update', 'label', 'name', 'mod_label'),
(124, 'lesson', 'start', 'lesson', 'name', 'mod_lesson'),
(125, 'lesson', 'end', 'lesson', 'name', 'mod_lesson'),
(126, 'lesson', 'view', 'lesson_pages', 'title', 'mod_lesson'),
(127, 'lti', 'view', 'lti', 'name', 'mod_lti'),
(128, 'lti', 'launch', 'lti', 'name', 'mod_lti'),
(129, 'lti', 'view all', 'lti', 'name', 'mod_lti'),
(130, 'page', 'view', 'page', 'name', 'mod_page'),
(131, 'page', 'view all', 'page', 'name', 'mod_page'),
(132, 'page', 'update', 'page', 'name', 'mod_page'),
(133, 'page', 'add', 'page', 'name', 'mod_page'),
(134, 'quiz', 'add', 'quiz', 'name', 'mod_quiz'),
(135, 'quiz', 'update', 'quiz', 'name', 'mod_quiz'),
(136, 'quiz', 'view', 'quiz', 'name', 'mod_quiz'),
(137, 'quiz', 'report', 'quiz', 'name', 'mod_quiz'),
(138, 'quiz', 'attempt', 'quiz', 'name', 'mod_quiz'),
(139, 'quiz', 'submit', 'quiz', 'name', 'mod_quiz'),
(140, 'quiz', 'review', 'quiz', 'name', 'mod_quiz'),
(141, 'quiz', 'editquestions', 'quiz', 'name', 'mod_quiz'),
(142, 'quiz', 'preview', 'quiz', 'name', 'mod_quiz'),
(143, 'quiz', 'start attempt', 'quiz', 'name', 'mod_quiz'),
(144, 'quiz', 'close attempt', 'quiz', 'name', 'mod_quiz'),
(145, 'quiz', 'continue attempt', 'quiz', 'name', 'mod_quiz'),
(146, 'quiz', 'edit override', 'quiz', 'name', 'mod_quiz'),
(147, 'quiz', 'delete override', 'quiz', 'name', 'mod_quiz'),
(148, 'quiz', 'view summary', 'quiz', 'name', 'mod_quiz'),
(149, 'resource', 'view', 'resource', 'name', 'mod_resource'),
(150, 'resource', 'view all', 'resource', 'name', 'mod_resource'),
(151, 'resource', 'update', 'resource', 'name', 'mod_resource'),
(152, 'resource', 'add', 'resource', 'name', 'mod_resource'),
(153, 'scorm', 'view', 'scorm', 'name', 'mod_scorm'),
(154, 'scorm', 'review', 'scorm', 'name', 'mod_scorm'),
(155, 'scorm', 'update', 'scorm', 'name', 'mod_scorm'),
(156, 'scorm', 'add', 'scorm', 'name', 'mod_scorm'),
(157, 'survey', 'add', 'survey', 'name', 'mod_survey'),
(158, 'survey', 'update', 'survey', 'name', 'mod_survey'),
(159, 'survey', 'download', 'survey', 'name', 'mod_survey'),
(160, 'survey', 'view form', 'survey', 'name', 'mod_survey'),
(161, 'survey', 'view graph', 'survey', 'name', 'mod_survey'),
(162, 'survey', 'view report', 'survey', 'name', 'mod_survey'),
(163, 'survey', 'submit', 'survey', 'name', 'mod_survey'),
(164, 'url', 'view', 'url', 'name', 'mod_url'),
(165, 'url', 'view all', 'url', 'name', 'mod_url'),
(166, 'url', 'update', 'url', 'name', 'mod_url'),
(167, 'url', 'add', 'url', 'name', 'mod_url'),
(168, 'workshop', 'add', 'workshop', 'name', 'mod_workshop'),
(169, 'workshop', 'update', 'workshop', 'name', 'mod_workshop'),
(170, 'workshop', 'view', 'workshop', 'name', 'mod_workshop'),
(171, 'workshop', 'view all', 'workshop', 'name', 'mod_workshop'),
(172, 'workshop', 'add submission', 'workshop_submissions', 'title', 'mod_workshop'),
(173, 'workshop', 'update submission', 'workshop_submissions', 'title', 'mod_workshop'),
(174, 'workshop', 'view submission', 'workshop_submissions', 'title', 'mod_workshop'),
(175, 'workshop', 'add assessment', 'workshop_submissions', 'title', 'mod_workshop'),
(176, 'workshop', 'update assessment', 'workshop_submissions', 'title', 'mod_workshop'),
(177, 'workshop', 'add example', 'workshop_submissions', 'title', 'mod_workshop'),
(178, 'workshop', 'update example', 'workshop_submissions', 'title', 'mod_workshop'),
(179, 'workshop', 'view example', 'workshop_submissions', 'title', 'mod_workshop'),
(180, 'workshop', 'add reference assessment', 'workshop_submissions', 'title', 'mod_workshop'),
(181, 'workshop', 'update reference assessment', 'workshop_submissions', 'title', 'mod_workshop'),
(182, 'workshop', 'add example assessment', 'workshop_submissions', 'title', 'mod_workshop'),
(183, 'workshop', 'update example assessment', 'workshop_submissions', 'title', 'mod_workshop'),
(184, 'workshop', 'update aggregate grades', 'workshop', 'name', 'mod_workshop'),
(185, 'workshop', 'update clear aggregated grades', 'workshop', 'name', 'mod_workshop'),
(186, 'workshop', 'update clear assessments', 'workshop', 'name', 'mod_workshop'),
(187, 'book', 'exportimscp', 'book', 'name', 'booktool_exportimscp'),
(188, 'book', 'print', 'book', 'name', 'booktool_print'),
(189, 'book', 'print chapter', 'book_chapters', 'title', 'booktool_print');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]log_queries`
--

CREATE TABLE `[[dbprefix]]log_queries` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `qtype` mediumint(5) NOT NULL,
  `sqltext` longtext NOT NULL,
  `sqlparams` longtext,
  `error` mediumint(5) NOT NULL DEFAULT '0',
  `info` longtext,
  `backtrace` longtext,
  `exectime` decimal(10,5) NOT NULL,
  `timelogged` bigint(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Logged database queries.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]lti`
--

CREATE TABLE `[[dbprefix]]lti` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `intro` longtext,
  `introformat` smallint(4) DEFAULT '0',
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `typeid` bigint(10) DEFAULT NULL,
  `toolurl` longtext NOT NULL,
  `securetoolurl` longtext,
  `instructorchoicesendname` tinyint(1) DEFAULT NULL,
  `instructorchoicesendemailaddr` tinyint(1) DEFAULT NULL,
  `instructorchoiceallowroster` tinyint(1) DEFAULT NULL,
  `instructorchoiceallowsetting` tinyint(1) DEFAULT NULL,
  `instructorcustomparameters` varchar(255) DEFAULT NULL,
  `instructorchoiceacceptgrades` tinyint(1) DEFAULT NULL,
  `grade` bigint(10) NOT NULL DEFAULT '100',
  `launchcontainer` tinyint(2) NOT NULL DEFAULT '1',
  `resourcekey` varchar(255) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  `debuglaunch` tinyint(1) NOT NULL DEFAULT '0',
  `showtitlelaunch` tinyint(1) NOT NULL DEFAULT '0',
  `showdescriptionlaunch` tinyint(1) NOT NULL DEFAULT '0',
  `servicesalt` varchar(40) DEFAULT NULL,
  `icon` longtext,
  `secureicon` longtext,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]lti_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='This table contains Basic LTI activities instances' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]ltiservice_gradebookservices`
--

CREATE TABLE `[[dbprefix]]ltiservice_gradebookservices` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `gradeitemid` bigint(10) NOT NULL,
  `courseid` bigint(10) NOT NULL,
  `toolproxyid` bigint(10) DEFAULT NULL,
  `typeid` bigint(10) DEFAULT NULL,
  `baseurl` longtext,
  `ltilinkid` bigint(10) DEFAULT NULL,
  `tag` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]ltisgrad_lti_ix` (`ltilinkid`),
  KEY `[[dbprefix]]ltisgrad_gracou_ix` (`gradeitemid`,`courseid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='This file records the grade items created by the LTI Gradebo' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]lti_submission`
--

CREATE TABLE `[[dbprefix]]lti_submission` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `ltiid` bigint(10) NOT NULL,
  `userid` bigint(10) NOT NULL,
  `datesubmitted` bigint(10) NOT NULL,
  `dateupdated` bigint(10) NOT NULL,
  `gradepercent` decimal(10,5) NOT NULL,
  `originalgrade` decimal(10,5) NOT NULL,
  `launchid` bigint(10) NOT NULL,
  `state` tinyint(2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]ltisubm_lti_ix` (`ltiid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Keeps track of individual submissions for LTI activities.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]lti_tool_proxies`
--

CREATE TABLE `[[dbprefix]]lti_tool_proxies` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT 'Tool Provider',
  `regurl` longtext,
  `state` tinyint(2) NOT NULL DEFAULT '1',
  `guid` varchar(255) DEFAULT NULL,
  `secret` varchar(255) DEFAULT NULL,
  `vendorcode` varchar(255) DEFAULT NULL,
  `capabilityoffered` longtext NOT NULL,
  `serviceoffered` longtext NOT NULL,
  `toolproxy` longtext,
  `createdby` bigint(10) NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]ltitoolprox_gui_uix` (`guid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='LTI tool proxy registrations' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]lti_tool_settings`
--

CREATE TABLE `[[dbprefix]]lti_tool_settings` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `toolproxyid` bigint(10) NOT NULL,
  `course` bigint(10) DEFAULT NULL,
  `coursemoduleid` bigint(10) DEFAULT NULL,
  `settings` longtext NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]ltitoolsett_too_ix` (`toolproxyid`),
  KEY `[[dbprefix]]ltitoolsett_cou_ix` (`course`),
  KEY `[[dbprefix]]ltitoolsett_cou2_ix` (`coursemoduleid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='LTI tool setting values' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]lti_types`
--

CREATE TABLE `[[dbprefix]]lti_types` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT 'basiclti Activity',
  `baseurl` longtext NOT NULL,
  `tooldomain` varchar(255) NOT NULL DEFAULT '',
  `state` tinyint(2) NOT NULL DEFAULT '2',
  `course` bigint(10) NOT NULL,
  `coursevisible` tinyint(1) NOT NULL DEFAULT '0',
  `toolproxyid` bigint(10) DEFAULT NULL,
  `enabledcapability` longtext,
  `parameter` longtext,
  `icon` longtext,
  `secureicon` longtext,
  `createdby` bigint(10) NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `description` longtext,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]ltitype_cou_ix` (`course`),
  KEY `[[dbprefix]]ltitype_too_ix` (`tooldomain`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Basic LTI pre-configured activities' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]lti_types_config`
--

CREATE TABLE `[[dbprefix]]lti_types_config` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `typeid` bigint(10) NOT NULL,
  `name` varchar(100) NOT NULL DEFAULT '',
  `value` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]ltitypeconf_typ_ix` (`typeid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Basic LTI types configuration' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]message`
--

CREATE TABLE `[[dbprefix]]message` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `useridfrom` bigint(10) NOT NULL DEFAULT '0',
  `useridto` bigint(10) NOT NULL DEFAULT '0',
  `subject` longtext,
  `fullmessage` longtext,
  `fullmessageformat` smallint(4) DEFAULT '0',
  `fullmessagehtml` longtext,
  `smallmessage` longtext,
  `notification` tinyint(1) DEFAULT '0',
  `contexturl` longtext,
  `contexturlname` longtext,
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timeuserfromdeleted` bigint(10) NOT NULL DEFAULT '0',
  `timeusertodeleted` bigint(10) NOT NULL DEFAULT '0',
  `component` varchar(100) DEFAULT NULL,
  `eventtype` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]mess_useusetimtim_ix` (`useridfrom`,`useridto`,`timeuserfromdeleted`,`timeusertodeleted`),
  KEY `[[dbprefix]]mess_usetimnot_ix` (`useridfrom`,`timeuserfromdeleted`,`notification`),
  KEY `[[dbprefix]]mess_usetimnot2_ix` (`useridto`,`timeusertodeleted`,`notification`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Stores all unread messages' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]messageinbound_datakeys`
--

CREATE TABLE `[[dbprefix]]messageinbound_datakeys` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `handler` bigint(10) NOT NULL,
  `datavalue` bigint(10) NOT NULL,
  `datakey` varchar(64) DEFAULT NULL,
  `timecreated` bigint(10) NOT NULL,
  `expires` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]messdata_handat_uix` (`handler`,`datavalue`),
  KEY `[[dbprefix]]messdata_han_ix` (`handler`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Inbound Message data item secret keys.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]messageinbound_handlers`
--

CREATE TABLE `[[dbprefix]]messageinbound_handlers` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `component` varchar(100) NOT NULL DEFAULT '',
  `classname` varchar(255) NOT NULL DEFAULT '',
  `defaultexpiration` bigint(10) NOT NULL DEFAULT '86400',
  `validateaddress` tinyint(1) NOT NULL DEFAULT '1',
  `enabled` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]messhand_cla_uix` (`classname`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Inbound Message Handler definitions.' AUTO_INCREMENT=4 ;

--
-- Dumping data for table `[[dbprefix]]messageinbound_handlers`
--

INSERT INTO `[[dbprefix]]messageinbound_handlers` VALUES
(1, 'core', '\\core\\message\\inbound\\private_files_handler', 0, 1, 0),
(2, 'mod_forum', '\\mod_forum\\message\\inbound\\reply_handler', 604800, 1, 0),
(3, 'tool_messageinbound', '\\tool_messageinbound\\message\\inbound\\invalid_recipient_handler', 604800, 0, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]messageinbound_messagelist`
--

CREATE TABLE `[[dbprefix]]messageinbound_messagelist` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `messageid` longtext NOT NULL,
  `userid` bigint(10) NOT NULL,
  `address` longtext NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]messmess_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='A list of message IDs for existing replies' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]messages`
--

CREATE TABLE `[[dbprefix]]messages` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `useridfrom` bigint(10) NOT NULL,
  `conversationid` bigint(10) NOT NULL,
  `subject` longtext,
  `fullmessage` longtext,
  `fullmessageformat` tinyint(1) NOT NULL DEFAULT '0',
  `fullmessagehtml` longtext,
  `smallmessage` longtext,
  `timecreated` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]mess_contim_ix` (`conversationid`,`timecreated`),
  KEY `[[dbprefix]]mess_use_ix` (`useridfrom`),
  KEY `[[dbprefix]]mess_con_ix` (`conversationid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Stores all messages' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]message_airnotifier_devices`
--

CREATE TABLE `[[dbprefix]]message_airnotifier_devices` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userdeviceid` bigint(10) NOT NULL,
  `enable` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]messairndevi_use_uix` (`userdeviceid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Store information about the devices registered in Airnotifie' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]message_contacts`
--

CREATE TABLE `[[dbprefix]]message_contacts` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `contactid` bigint(10) NOT NULL DEFAULT '0',
  `blocked` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]messcont_usecon_uix` (`userid`,`contactid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Maintains lists of relationships between users' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]message_conversations`
--

CREATE TABLE `[[dbprefix]]message_conversations` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `convhash` varchar(40) NOT NULL DEFAULT '',
  `timecreated` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]messconv_con_uix` (`convhash`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Stores all message conversations' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]message_conversation_members`
--

CREATE TABLE `[[dbprefix]]message_conversation_members` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `conversationid` bigint(10) NOT NULL,
  `userid` bigint(10) NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]messconvmemb_con_ix` (`conversationid`),
  KEY `[[dbprefix]]messconvmemb_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Stores all members in a conversations' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]message_popup`
--

CREATE TABLE `[[dbprefix]]message_popup` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `messageid` bigint(10) NOT NULL,
  `isread` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]messpopu_mesisr_uix` (`messageid`,`isread`),
  KEY `[[dbprefix]]messpopu_isr_ix` (`isread`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Keep state of notifications for the popup message processor' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]message_popup_notifications`
--

CREATE TABLE `[[dbprefix]]message_popup_notifications` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `notificationid` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]messpopunoti_not_ix` (`notificationid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='List of notifications to display in the message output popup' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]message_processors`
--

CREATE TABLE `[[dbprefix]]message_processors` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(166) NOT NULL DEFAULT '',
  `enabled` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='List of message output plugins' AUTO_INCREMENT=5 ;

--
-- Dumping data for table `[[dbprefix]]message_processors`
--

INSERT INTO `[[dbprefix]]message_processors` VALUES
(1, 'airnotifier', 0),
(2, 'email', 1),
(3, 'jabber', 1),
(4, 'popup', 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]message_providers`
--

CREATE TABLE `[[dbprefix]]message_providers` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL DEFAULT '',
  `component` varchar(200) NOT NULL DEFAULT '',
  `capability` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]messprov_comnam_uix` (`component`,`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='This table stores the message providers (modules and core sy' AUTO_INCREMENT=36 ;

--
-- Dumping data for table `[[dbprefix]]message_providers`
--

INSERT INTO `[[dbprefix]]message_providers` VALUES
(1, 'notices', 'moodle', 'moodle/site:config'),
(2, 'errors', 'moodle', 'moodle/site:config'),
(3, 'availableupdate', 'moodle', 'moodle/site:config'),
(4, 'instantmessage', 'moodle', NULL),
(5, 'backup', 'moodle', 'moodle/site:config'),
(6, 'courserequested', 'moodle', 'moodle/site:approvecourse'),
(7, 'courserequestapproved', 'moodle', 'moodle/course:request'),
(8, 'courserequestrejected', 'moodle', 'moodle/course:request'),
(9, 'badgerecipientnotice', 'moodle', 'moodle/badges:earnbadge'),
(10, 'badgecreatornotice', 'moodle', NULL),
(11, 'competencyplancomment', 'moodle', NULL),
(12, 'competencyusercompcomment', 'moodle', NULL),
(13, 'insights', 'moodle', 'moodle/analytics:listinsights'),
(14, 'assign_notification', 'mod_assign', NULL),
(15, 'assignment_updates', 'mod_assignment', NULL),
(16, 'submission', 'mod_feedback', NULL),
(17, 'message', 'mod_feedback', NULL),
(18, 'posts', 'mod_forum', NULL),
(19, 'digests', 'mod_forum', NULL),
(20, 'graded_essay', 'mod_lesson', NULL),
(21, 'submission', 'mod_quiz', 'mod/quiz:emailnotifysubmission'),
(22, 'confirmation', 'mod_quiz', 'mod/quiz:emailconfirmsubmission'),
(23, 'attempt_overdue', 'mod_quiz', 'mod/quiz:emailwarnoverdue'),
(24, 'flatfile_enrolment', 'enrol_flatfile', NULL),
(25, 'imsenterprise_enrolment', 'enrol_imsenterprise', NULL),
(26, 'expiry_notification', 'enrol_manual', NULL),
(27, 'paypal_enrolment', 'enrol_paypal', NULL),
(28, 'expiry_notification', 'enrol_self', NULL),
(29, 'contactdataprotectionofficer', 'tool_dataprivacy', 'tool/dataprivacy:managedatarequests'),
(30, 'datarequestprocessingresults', 'tool_dataprivacy', NULL),
(31, 'notifyexceptions', 'tool_dataprivacy', 'tool/dataprivacy:managedatarequests'),
(32, 'invalidrecipienthandler', 'tool_messageinbound', NULL),
(33, 'messageprocessingerror', 'tool_messageinbound', NULL),
(34, 'messageprocessingsuccess', 'tool_messageinbound', NULL),
(35, 'notification', 'tool_monitor', 'tool/monitor:subscribe');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]message_read`
--

CREATE TABLE `[[dbprefix]]message_read` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `useridfrom` bigint(10) NOT NULL DEFAULT '0',
  `useridto` bigint(10) NOT NULL DEFAULT '0',
  `subject` longtext,
  `fullmessage` longtext,
  `fullmessageformat` smallint(4) DEFAULT '0',
  `fullmessagehtml` longtext,
  `smallmessage` longtext,
  `notification` tinyint(1) DEFAULT '0',
  `contexturl` longtext,
  `contexturlname` longtext,
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timeread` bigint(10) NOT NULL DEFAULT '0',
  `timeuserfromdeleted` bigint(10) NOT NULL DEFAULT '0',
  `timeusertodeleted` bigint(10) NOT NULL DEFAULT '0',
  `component` varchar(100) DEFAULT NULL,
  `eventtype` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]messread_useusetimtim_ix` (`useridfrom`,`useridto`,`timeuserfromdeleted`,`timeusertodeleted`),
  KEY `[[dbprefix]]messread_nottim_ix` (`notification`,`timeread`),
  KEY `[[dbprefix]]messread_usetimnot_ix` (`useridfrom`,`timeuserfromdeleted`,`notification`),
  KEY `[[dbprefix]]messread_usetimnot2_ix` (`useridto`,`timeusertodeleted`,`notification`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Stores all messages that have been read' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]message_user_actions`
--

CREATE TABLE `[[dbprefix]]message_user_actions` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL,
  `messageid` bigint(10) NOT NULL,
  `action` bigint(10) NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]messuseracti_usemesa_uix` (`userid`,`messageid`,`action`),
  KEY `[[dbprefix]]messuseracti_use_ix` (`userid`),
  KEY `[[dbprefix]]messuseracti_mes_ix` (`messageid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Stores all per-user actions on individual messages' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mnetservice_enrol_courses`
--

CREATE TABLE `[[dbprefix]]mnetservice_enrol_courses` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `hostid` bigint(10) NOT NULL,
  `remoteid` bigint(10) NOT NULL,
  `categoryid` bigint(10) NOT NULL,
  `categoryname` varchar(255) NOT NULL DEFAULT '',
  `sortorder` bigint(10) NOT NULL DEFAULT '0',
  `fullname` varchar(254) NOT NULL DEFAULT '',
  `shortname` varchar(100) NOT NULL DEFAULT '',
  `idnumber` varchar(100) NOT NULL DEFAULT '',
  `summary` longtext NOT NULL,
  `summaryformat` smallint(3) DEFAULT '0',
  `startdate` bigint(10) NOT NULL,
  `roleid` bigint(10) NOT NULL,
  `rolename` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]mnetenrocour_hosrem_uix` (`hostid`,`remoteid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Caches the information fetched via XML-RPC about courses on ' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mnetservice_enrol_enrolments`
--

CREATE TABLE `[[dbprefix]]mnetservice_enrol_enrolments` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `hostid` bigint(10) NOT NULL,
  `userid` bigint(10) NOT NULL,
  `remotecourseid` bigint(10) NOT NULL,
  `rolename` varchar(255) NOT NULL DEFAULT '',
  `enroltime` bigint(10) NOT NULL DEFAULT '0',
  `enroltype` varchar(20) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]mnetenroenro_use_ix` (`userid`),
  KEY `[[dbprefix]]mnetenroenro_hos_ix` (`hostid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Caches the information about enrolments of our local users i' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mnet_application`
--

CREATE TABLE `[[dbprefix]]mnet_application` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL DEFAULT '',
  `display_name` varchar(50) NOT NULL DEFAULT '',
  `xmlrpc_server_url` varchar(255) NOT NULL DEFAULT '',
  `sso_land_url` varchar(255) NOT NULL DEFAULT '',
  `sso_jump_url` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Information about applications on remote hosts' AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]mnet_application`
--

INSERT INTO `[[dbprefix]]mnet_application` VALUES
(1, 'moodle', 'Moodle', '/mnet/xmlrpc/server.php', '/auth/mnet/land.php', '/auth/mnet/jump.php'),
(2, 'mahara', 'Mahara', '/api/xmlrpc/server.php', '/auth/xmlrpc/land.php', '/auth/xmlrpc/jump.php');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mnet_host`
--

CREATE TABLE `[[dbprefix]]mnet_host` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `deleted` tinyint(1) NOT NULL DEFAULT '0',
  `wwwroot` varchar(255) NOT NULL DEFAULT '',
  `ip_address` varchar(45) NOT NULL DEFAULT '',
  `name` varchar(80) NOT NULL DEFAULT '',
  `public_key` longtext NOT NULL,
  `public_key_expires` bigint(10) NOT NULL DEFAULT '0',
  `transport` tinyint(2) NOT NULL DEFAULT '0',
  `portno` mediumint(5) NOT NULL DEFAULT '0',
  `last_connect_time` bigint(10) NOT NULL DEFAULT '0',
  `last_log_id` bigint(10) NOT NULL DEFAULT '0',
  `force_theme` tinyint(1) NOT NULL DEFAULT '0',
  `theme` varchar(100) DEFAULT NULL,
  `applicationid` bigint(10) NOT NULL DEFAULT '1',
  `sslverification` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]mnethost_app_ix` (`applicationid`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Information about the local and remote hosts for RPC' AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]mnet_host`
--

INSERT INTO `[[dbprefix]]mnet_host` VALUES
(1, 0, '[[softurl]]', '[[serverip]]', '', '', 0, 0, 0, 0, 0, 0, NULL, 1, 0),
(2, 0, '', '', 'All Hosts', '', 0, 0, 0, 0, 0, 0, NULL, 1, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mnet_host2service`
--

CREATE TABLE `[[dbprefix]]mnet_host2service` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `hostid` bigint(10) NOT NULL DEFAULT '0',
  `serviceid` bigint(10) NOT NULL DEFAULT '0',
  `publish` tinyint(1) NOT NULL DEFAULT '0',
  `subscribe` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]mnethost_hosser_uix` (`hostid`,`serviceid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Information about the services for a given host' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mnet_log`
--

CREATE TABLE `[[dbprefix]]mnet_log` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `hostid` bigint(10) NOT NULL DEFAULT '0',
  `remoteid` bigint(10) NOT NULL DEFAULT '0',
  `time` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `ip` varchar(45) NOT NULL DEFAULT '',
  `course` bigint(10) NOT NULL DEFAULT '0',
  `coursename` varchar(40) NOT NULL DEFAULT '',
  `module` varchar(20) NOT NULL DEFAULT '',
  `cmid` bigint(10) NOT NULL DEFAULT '0',
  `action` varchar(40) NOT NULL DEFAULT '',
  `url` varchar(100) NOT NULL DEFAULT '',
  `info` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]mnetlog_hosusecou_ix` (`hostid`,`userid`,`course`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Store session data from users migrating to other sites' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mnet_remote_rpc`
--

CREATE TABLE `[[dbprefix]]mnet_remote_rpc` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `functionname` varchar(40) NOT NULL DEFAULT '',
  `xmlrpcpath` varchar(80) NOT NULL DEFAULT '',
  `plugintype` varchar(20) NOT NULL DEFAULT '',
  `pluginname` varchar(20) NOT NULL DEFAULT '',
  `enabled` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='This table describes functions that might be called remotely' AUTO_INCREMENT=17 ;

--
-- Dumping data for table `[[dbprefix]]mnet_remote_rpc`
--

INSERT INTO `[[dbprefix]]mnet_remote_rpc` VALUES
(1, 'user_authorise', 'auth/mnet/auth.php/user_authorise', 'auth', 'mnet', 1),
(2, 'keepalive_server', 'auth/mnet/auth.php/keepalive_server', 'auth', 'mnet', 1),
(3, 'kill_children', 'auth/mnet/auth.php/kill_children', 'auth', 'mnet', 1),
(4, 'refresh_log', 'auth/mnet/auth.php/refresh_log', 'auth', 'mnet', 1),
(5, 'fetch_user_image', 'auth/mnet/auth.php/fetch_user_image', 'auth', 'mnet', 1),
(6, 'fetch_theme_info', 'auth/mnet/auth.php/fetch_theme_info', 'auth', 'mnet', 1),
(7, 'update_enrolments', 'auth/mnet/auth.php/update_enrolments', 'auth', 'mnet', 1),
(8, 'keepalive_client', 'auth/mnet/auth.php/keepalive_client', 'auth', 'mnet', 1),
(9, 'kill_child', 'auth/mnet/auth.php/kill_child', 'auth', 'mnet', 1),
(10, 'available_courses', 'enrol/mnet/enrol.php/available_courses', 'enrol', 'mnet', 1),
(11, 'user_enrolments', 'enrol/mnet/enrol.php/user_enrolments', 'enrol', 'mnet', 1),
(12, 'enrol_user', 'enrol/mnet/enrol.php/enrol_user', 'enrol', 'mnet', 1),
(13, 'unenrol_user', 'enrol/mnet/enrol.php/unenrol_user', 'enrol', 'mnet', 1),
(14, 'course_enrolments', 'enrol/mnet/enrol.php/course_enrolments', 'enrol', 'mnet', 1),
(15, 'send_content_intent', 'portfolio/mahara/lib.php/send_content_intent', 'portfolio', 'mahara', 1),
(16, 'send_content_ready', 'portfolio/mahara/lib.php/send_content_ready', 'portfolio', 'mahara', 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mnet_remote_service2rpc`
--

CREATE TABLE `[[dbprefix]]mnet_remote_service2rpc` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `serviceid` bigint(10) NOT NULL DEFAULT '0',
  `rpcid` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]mnetremoserv_rpcser_uix` (`rpcid`,`serviceid`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Group functions or methods under a service' AUTO_INCREMENT=17 ;

--
-- Dumping data for table `[[dbprefix]]mnet_remote_service2rpc`
--

INSERT INTO `[[dbprefix]]mnet_remote_service2rpc` VALUES
(1, 1, 1),
(2, 1, 2),
(3, 1, 3),
(4, 1, 4),
(5, 1, 5),
(6, 1, 6),
(7, 1, 7),
(8, 2, 8),
(9, 2, 9),
(10, 3, 10),
(11, 3, 11),
(12, 3, 12),
(13, 3, 13),
(14, 3, 14),
(15, 4, 15),
(16, 4, 16);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mnet_rpc`
--

CREATE TABLE `[[dbprefix]]mnet_rpc` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `functionname` varchar(40) NOT NULL DEFAULT '',
  `xmlrpcpath` varchar(80) NOT NULL DEFAULT '',
  `plugintype` varchar(20) NOT NULL DEFAULT '',
  `pluginname` varchar(20) NOT NULL DEFAULT '',
  `enabled` tinyint(1) NOT NULL DEFAULT '0',
  `help` longtext NOT NULL,
  `profile` longtext NOT NULL,
  `filename` varchar(100) NOT NULL DEFAULT '',
  `classname` varchar(150) DEFAULT NULL,
  `static` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]mnetrpc_enaxml_ix` (`enabled`,`xmlrpcpath`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Functions or methods that we may publish or subscribe to' AUTO_INCREMENT=16 ;

--
-- Dumping data for table `[[dbprefix]]mnet_rpc`
--

INSERT INTO `[[dbprefix]]mnet_rpc` VALUES
(1, 'user_authorise', 'auth/mnet/auth.php/user_authorise', 'auth', 'mnet', 1, 'Return user data for the provided token, compare with user_agent string.', 'a:2:{s:10:"parameters";a:2:{i:0;a:3:{s:4:"name";s:5:"token";s:4:"type";s:6:"string";s:11:"description";s:37:"The unique ID provided by remotehost.";}i:1;a:3:{s:4:"name";s:9:"useragent";s:4:"type";s:6:"string";s:11:"description";s:18:"User Agent string.";}}s:6:"return";a:2:{s:4:"type";s:5:"array";s:11:"description";s:44:"$userdata Array of user info for remote host";}}', 'auth.php', 'auth_plugin_mnet', 0),
(2, 'keepalive_server', 'auth/mnet/auth.php/keepalive_server', 'auth', 'mnet', 1, 'Receives an array of usernames from a remote machine and prods their\nsessions to keep them alive', 'a:2:{s:10:"parameters";a:1:{i:0;a:3:{s:4:"name";s:5:"array";s:4:"type";s:5:"array";s:11:"description";s:21:"An array of usernames";}}s:6:"return";a:2:{s:4:"type";s:6:"string";s:11:"description";s:28:""All ok" or an error message";}}', 'auth.php', 'auth_plugin_mnet', 0),
(3, 'kill_children', 'auth/mnet/auth.php/kill_children', 'auth', 'mnet', 1, 'The IdP uses this function to kill child sessions on other hosts', 'a:2:{s:10:"parameters";a:2:{i:0;a:3:{s:4:"name";s:8:"username";s:4:"type";s:6:"string";s:11:"description";s:28:"Username for session to kill";}i:1;a:3:{s:4:"name";s:9:"useragent";s:4:"type";s:6:"string";s:11:"description";s:35:"SHA1 hash of user agent to look for";}}s:6:"return";a:2:{s:4:"type";s:6:"string";s:11:"description";s:39:"A plaintext report of what has happened";}}', 'auth.php', 'auth_plugin_mnet', 0),
(4, 'refresh_log', 'auth/mnet/auth.php/refresh_log', 'auth', 'mnet', 1, 'Receives an array of log entries from an SP and adds them to the mnet_log\ntable', 'a:2:{s:10:"parameters";a:1:{i:0;a:3:{s:4:"name";s:5:"array";s:4:"type";s:5:"array";s:11:"description";s:21:"An array of usernames";}}s:6:"return";a:2:{s:4:"type";s:6:"string";s:11:"description";s:28:""All ok" or an error message";}}', 'auth.php', 'auth_plugin_mnet', 0),
(5, 'fetch_user_image', 'auth/mnet/auth.php/fetch_user_image', 'auth', 'mnet', 1, 'Returns the user''s profile image info\nIf the user exists and has a profile picture, the returned array will contain keys:\nf1          - the content of the default 100x100px image\nf1_mimetype - the mimetype of the f1 file\nf2          - the content of the 35x35px variant of the image\nf2_mimetype - the mimetype of the f2 file\nThe mimetype information was added in Moodle 2.0. In Moodle 1.x, images are always jpegs.', 'a:2:{s:10:"parameters";a:1:{i:0;a:3:{s:4:"name";s:8:"username";s:4:"type";s:3:"int";s:11:"description";s:18:"The id of the user";}}s:6:"return";a:2:{s:4:"type";s:11:"false|array";s:11:"description";s:84:"false if user not found, empty array if no picture exists, array with data otherwise";}}', 'auth.php', 'auth_plugin_mnet', 0),
(6, 'fetch_theme_info', 'auth/mnet/auth.php/fetch_theme_info', 'auth', 'mnet', 1, 'Returns the theme information and logo url as strings.', 'a:2:{s:10:"parameters";a:0:{}s:6:"return";a:2:{s:4:"type";s:6:"string";s:11:"description";s:14:"The theme info";}}', 'auth.php', 'auth_plugin_mnet', 0),
(7, 'update_enrolments', 'auth/mnet/auth.php/update_enrolments', 'auth', 'mnet', 1, 'Invoke this function _on_ the IDP to update it with enrolment info local to\nthe SP right after calling user_authorise()\nNormally called by the SP after calling user_authorise()', 'a:2:{s:10:"parameters";a:2:{i:0;a:3:{s:4:"name";s:8:"username";s:4:"type";s:6:"string";s:11:"description";s:12:"The username";}i:1;a:3:{s:4:"name";s:7:"courses";s:4:"type";s:5:"array";s:11:"description";s:75:"Assoc array of courses following the structure of mnetservice_enrol_courses";}}s:6:"return";a:2:{s:4:"type";s:4:"bool";s:11:"description";s:0:"";}}', 'auth.php', 'auth_plugin_mnet', 0),
(8, 'keepalive_client', 'auth/mnet/auth.php/keepalive_client', 'auth', 'mnet', 1, 'Poll the IdP server to let it know that a user it has authenticated is still\nonline', 'a:2:{s:10:"parameters";a:0:{}s:6:"return";a:2:{s:4:"type";s:4:"void";s:11:"description";s:0:"";}}', 'auth.php', 'auth_plugin_mnet', 0),
(9, 'kill_child', 'auth/mnet/auth.php/kill_child', 'auth', 'mnet', 1, 'When the IdP requests that child sessions are terminated,\nthis function will be called on each of the child hosts. The machine that\ncalls the function (over xmlrpc) provides us with the mnethostid we need.', 'a:2:{s:10:"parameters";a:2:{i:0;a:3:{s:4:"name";s:8:"username";s:4:"type";s:6:"string";s:11:"description";s:28:"Username for session to kill";}i:1;a:3:{s:4:"name";s:9:"useragent";s:4:"type";s:6:"string";s:11:"description";s:35:"SHA1 hash of user agent to look for";}}s:6:"return";a:2:{s:4:"type";s:4:"bool";s:11:"description";s:15:"True on success";}}', 'auth.php', 'auth_plugin_mnet', 0),
(10, 'available_courses', 'enrol/mnet/enrol.php/available_courses', 'enrol', 'mnet', 1, 'Returns list of courses that we offer to the caller for remote enrolment of their users\nSince Moodle 2.0, courses are made available for MNet peers by creating an instance\nof enrol_mnet plugin for the course. Hidden courses are not returned. If there are two\ninstances - one specific for the host and one for ''All hosts'', the setting of the specific\none is used. The id of the peer is kept in customint1, no other custom fields are used.', 'a:2:{s:10:"parameters";a:0:{}s:6:"return";a:2:{s:4:"type";s:5:"array";s:11:"description";s:0:"";}}', 'enrol.php', 'enrol_mnet_mnetservice_enrol', 0),
(11, 'user_enrolments', 'enrol/mnet/enrol.php/user_enrolments', 'enrol', 'mnet', 1, 'This method has never been implemented in Moodle MNet API', 'a:2:{s:10:"parameters";a:0:{}s:6:"return";a:2:{s:4:"type";s:5:"array";s:11:"description";s:11:"empty array";}}', 'enrol.php', 'enrol_mnet_mnetservice_enrol', 0),
(12, 'enrol_user', 'enrol/mnet/enrol.php/enrol_user', 'enrol', 'mnet', 1, 'Enrol remote user to our course\nIf we do not have local record for the remote user in our database,\nit gets created here.', 'a:2:{s:10:"parameters";a:2:{i:0;a:3:{s:4:"name";s:8:"userdata";s:4:"type";s:5:"array";s:11:"description";s:43:"user details {@see mnet_fields_to_import()}";}i:1;a:3:{s:4:"name";s:8:"courseid";s:4:"type";s:3:"int";s:11:"description";s:19:"our local course id";}}s:6:"return";a:2:{s:4:"type";s:4:"bool";s:11:"description";s:69:"true if the enrolment has been successful, throws exception otherwise";}}', 'enrol.php', 'enrol_mnet_mnetservice_enrol', 0),
(13, 'unenrol_user', 'enrol/mnet/enrol.php/unenrol_user', 'enrol', 'mnet', 1, 'Unenrol remote user from our course\nOnly users enrolled via enrol_mnet plugin can be unenrolled remotely. If the\nremote user is enrolled into the local course via some other enrol plugin\n(enrol_manual for example), the remote host can''t touch such enrolment. Please\ndo not report this behaviour as bug, it is a feature ;-)', 'a:2:{s:10:"parameters";a:2:{i:0;a:3:{s:4:"name";s:8:"username";s:4:"type";s:6:"string";s:11:"description";s:18:"of the remote user";}i:1;a:3:{s:4:"name";s:8:"courseid";s:4:"type";s:3:"int";s:11:"description";s:19:"of our local course";}}s:6:"return";a:2:{s:4:"type";s:4:"bool";s:11:"description";s:71:"true if the unenrolment has been successful, throws exception otherwise";}}', 'enrol.php', 'enrol_mnet_mnetservice_enrol', 0),
(14, 'course_enrolments', 'enrol/mnet/enrol.php/course_enrolments', 'enrol', 'mnet', 1, 'Returns a list of users from the client server who are enrolled in our course\nSuitable instance of enrol_mnet must be created in the course. This method will not\nreturn any information about the enrolments in courses that are not available for\nremote enrolment, even if their users are enrolled into them via other plugin\n(note the difference from {@link self::user_enrolments()}).\nThis method will return enrolment information for users from hosts regardless\nthe enrolment plugin. It does not matter if the user was enrolled remotely by\ntheir admin or locally. Once the course is available for remote enrolments, we\nwill tell them everything about their users.\nIn Moodle 1.x the returned array used to be indexed by username. The side effect\nof MDL-19219 fix is that we do not need to use such index and therefore we can\nreturn all enrolment records. MNet clients 1.x will only use the last record for\nthe student, if she is enrolled via multiple plugins.', 'a:2:{s:10:"parameters";a:2:{i:0;a:3:{s:4:"name";s:8:"courseid";s:4:"type";s:3:"int";s:11:"description";s:16:"ID of our course";}i:1;a:3:{s:4:"name";s:5:"roles";s:4:"type";s:12:"string|array";s:11:"description";s:58:"comma separated list of role shortnames (or array of them)";}}s:6:"return";a:2:{s:4:"type";s:5:"array";s:11:"description";s:0:"";}}', 'enrol.php', 'enrol_mnet_mnetservice_enrol', 0),
(15, 'fetch_file', 'portfolio/mahara/lib.php/fetch_file', 'portfolio', 'mahara', 1, 'xmlrpc (mnet) function to get the file.\nreads in the file and returns it base_64 encoded\nso that it can be enrypted by mnet.', 'a:2:{s:10:"parameters";a:1:{i:0;a:3:{s:4:"name";s:5:"token";s:4:"type";s:6:"string";s:11:"description";s:56:"the token recieved previously during send_content_intent";}}s:6:"return";a:2:{s:4:"type";s:4:"void";s:11:"description";s:0:"";}}', 'lib.php', 'portfolio_plugin_mahara', 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mnet_service`
--

CREATE TABLE `[[dbprefix]]mnet_service` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(40) NOT NULL DEFAULT '',
  `description` varchar(40) NOT NULL DEFAULT '',
  `apiversion` varchar(10) NOT NULL DEFAULT '',
  `offer` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='A service is a group of functions' AUTO_INCREMENT=5 ;

--
-- Dumping data for table `[[dbprefix]]mnet_service`
--

INSERT INTO `[[dbprefix]]mnet_service` VALUES
(1, 'sso_idp', '', '1', 1),
(2, 'sso_sp', '', '1', 1),
(3, 'mnet_enrol', '', '1', 1),
(4, 'pf', '', '1', 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mnet_service2rpc`
--

CREATE TABLE `[[dbprefix]]mnet_service2rpc` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `serviceid` bigint(10) NOT NULL DEFAULT '0',
  `rpcid` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]mnetserv_rpcser_uix` (`rpcid`,`serviceid`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Group functions or methods under a service' AUTO_INCREMENT=16 ;

--
-- Dumping data for table `[[dbprefix]]mnet_service2rpc`
--

INSERT INTO `[[dbprefix]]mnet_service2rpc` VALUES
(1, 1, 1),
(2, 1, 2),
(3, 1, 3),
(4, 1, 4),
(5, 1, 5),
(6, 1, 6),
(7, 1, 7),
(8, 2, 8),
(9, 2, 9),
(10, 3, 10),
(11, 3, 11),
(12, 3, 12),
(13, 3, 13),
(14, 3, 14),
(15, 4, 15);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mnet_session`
--

CREATE TABLE `[[dbprefix]]mnet_session` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `username` varchar(100) NOT NULL DEFAULT '',
  `token` varchar(40) NOT NULL DEFAULT '',
  `mnethostid` bigint(10) NOT NULL DEFAULT '0',
  `useragent` varchar(40) NOT NULL DEFAULT '',
  `confirm_timeout` bigint(10) NOT NULL DEFAULT '0',
  `session_id` varchar(40) NOT NULL DEFAULT '',
  `expires` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]mnetsess_tok_uix` (`token`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Store session data from users migrating to other sites' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mnet_sso_access_control`
--

CREATE TABLE `[[dbprefix]]mnet_sso_access_control` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `username` varchar(100) NOT NULL DEFAULT '',
  `mnet_host_id` bigint(10) NOT NULL DEFAULT '0',
  `accessctrl` varchar(20) NOT NULL DEFAULT 'allow',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]mnetssoaccecont_mneu_uix` (`mnet_host_id`,`username`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Users by host permitted (or not) to login from a remote prov' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]modules`
--

CREATE TABLE `[[dbprefix]]modules` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(20) NOT NULL DEFAULT '',
  `cron` bigint(10) NOT NULL DEFAULT '0',
  `lastcron` bigint(10) NOT NULL DEFAULT '0',
  `search` varchar(255) NOT NULL DEFAULT '',
  `visible` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]modu_nam_ix` (`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='modules available in the site' AUTO_INCREMENT=23 ;

--
-- Dumping data for table `[[dbprefix]]modules`
--

INSERT INTO `[[dbprefix]]modules` VALUES
(1, 'assign', 60, 0, '', 1),
(2, 'assignment', 60, 0, '', 0),
(3, 'book', 0, 0, '', 1),
(4, 'chat', 300, 0, '', 1),
(5, 'choice', 0, 0, '', 1),
(6, 'data', 0, 0, '', 1),
(7, 'feedback', 0, 0, '', 1),
(8, 'folder', 0, 0, '', 1),
(9, 'forum', 0, 0, '', 1),
(10, 'glossary', 0, 0, '', 1),
(11, 'imscp', 0, 0, '', 1),
(12, 'label', 0, 0, '', 1),
(13, 'lesson', 0, 0, '', 1),
(14, 'lti', 0, 0, '', 1),
(15, 'page', 0, 0, '', 1),
(16, 'quiz', 60, 0, '', 1),
(17, 'resource', 0, 0, '', 1),
(18, 'scorm', 0, 0, '', 1),
(19, 'survey', 0, 0, '', 1),
(20, 'url', 0, 0, '', 1),
(21, 'wiki', 0, 0, '', 1),
(22, 'workshop', 60, 0, '', 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]my_pages`
--

CREATE TABLE `[[dbprefix]]my_pages` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) DEFAULT '0',
  `name` varchar(200) NOT NULL DEFAULT '',
  `private` tinyint(1) NOT NULL DEFAULT '1',
  `sortorder` mediumint(6) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]mypage_usepri_ix` (`userid`,`private`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Extra user pages for the My Moodle system' AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]my_pages`
--

INSERT INTO `[[dbprefix]]my_pages` VALUES
(1, NULL, '__default', 0, 0),
(2, NULL, '__default', 1, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]notifications`
--

CREATE TABLE `[[dbprefix]]notifications` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `useridfrom` bigint(10) NOT NULL,
  `useridto` bigint(10) NOT NULL,
  `subject` longtext,
  `fullmessage` longtext,
  `fullmessageformat` tinyint(1) NOT NULL DEFAULT '0',
  `fullmessagehtml` longtext,
  `smallmessage` longtext,
  `component` varchar(100) DEFAULT NULL,
  `eventtype` varchar(100) DEFAULT NULL,
  `contexturl` longtext,
  `contexturlname` longtext,
  `timeread` bigint(10) DEFAULT NULL,
  `timecreated` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]noti_use_ix` (`useridfrom`),
  KEY `[[dbprefix]]noti_use2_ix` (`useridto`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Stores all notifications' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]oauth2_endpoint`
--

CREATE TABLE `[[dbprefix]]oauth2_endpoint` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `usermodified` bigint(10) NOT NULL,
  `name` varchar(255) NOT NULL DEFAULT '',
  `url` longtext NOT NULL,
  `issuerid` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]oautendp_iss_ix` (`issuerid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Describes the named endpoint for an oauth2 service.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]oauth2_issuer`
--

CREATE TABLE `[[dbprefix]]oauth2_issuer` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `usermodified` bigint(10) NOT NULL,
  `name` varchar(255) NOT NULL DEFAULT '',
  `image` longtext NOT NULL,
  `baseurl` longtext NOT NULL,
  `clientid` longtext NOT NULL,
  `clientsecret` longtext NOT NULL,
  `loginscopes` longtext NOT NULL,
  `loginscopesoffline` longtext NOT NULL,
  `loginparams` longtext NOT NULL,
  `loginparamsoffline` longtext NOT NULL,
  `alloweddomains` longtext NOT NULL,
  `scopessupported` longtext,
  `enabled` tinyint(2) NOT NULL DEFAULT '1',
  `showonloginpage` tinyint(2) NOT NULL DEFAULT '1',
  `basicauth` tinyint(2) NOT NULL DEFAULT '0',
  `sortorder` bigint(10) NOT NULL,
  `requireconfirmation` tinyint(2) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Details for an oauth 2 connect identity issuer.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]oauth2_system_account`
--

CREATE TABLE `[[dbprefix]]oauth2_system_account` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `usermodified` bigint(10) NOT NULL,
  `issuerid` bigint(10) NOT NULL,
  `refreshtoken` longtext NOT NULL,
  `grantedscopes` longtext NOT NULL,
  `email` longtext,
  `username` longtext NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]oautsystacco_iss_uix` (`issuerid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Stored details used to get an access token as a system user ' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]oauth2_user_field_mapping`
--

CREATE TABLE `[[dbprefix]]oauth2_user_field_mapping` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `timemodified` bigint(10) NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  `usermodified` bigint(10) NOT NULL,
  `issuerid` bigint(10) NOT NULL,
  `externalfield` varchar(64) NOT NULL DEFAULT '',
  `internalfield` varchar(64) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]oautuserfielmapp_iss_uix` (`issuerid`,`internalfield`),
  KEY `[[dbprefix]]oautuserfielmapp_iss_ix` (`issuerid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Mapping of oauth user fields to moodle fields.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]page`
--

CREATE TABLE `[[dbprefix]]page` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `intro` longtext,
  `introformat` smallint(4) NOT NULL DEFAULT '0',
  `content` longtext,
  `contentformat` smallint(4) NOT NULL DEFAULT '0',
  `legacyfiles` smallint(4) NOT NULL DEFAULT '0',
  `legacyfileslast` bigint(10) DEFAULT NULL,
  `display` smallint(4) NOT NULL DEFAULT '0',
  `displayoptions` longtext,
  `revision` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]page_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Each record is one page and its config data' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]portfolio_instance`
--

CREATE TABLE `[[dbprefix]]portfolio_instance` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `plugin` varchar(50) NOT NULL DEFAULT '',
  `name` varchar(255) NOT NULL DEFAULT '',
  `visible` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='base table (not including config data) for instances of port' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]portfolio_instance_config`
--

CREATE TABLE `[[dbprefix]]portfolio_instance_config` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `instance` bigint(10) NOT NULL,
  `name` varchar(255) NOT NULL DEFAULT '',
  `value` longtext,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]portinstconf_nam_ix` (`name`),
  KEY `[[dbprefix]]portinstconf_ins_ix` (`instance`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='config for portfolio plugin instances' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]portfolio_instance_user`
--

CREATE TABLE `[[dbprefix]]portfolio_instance_user` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `instance` bigint(10) NOT NULL,
  `userid` bigint(10) NOT NULL,
  `name` varchar(255) NOT NULL DEFAULT '',
  `value` longtext,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]portinstuser_ins_ix` (`instance`),
  KEY `[[dbprefix]]portinstuser_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='user data for portfolio instances.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]portfolio_log`
--

CREATE TABLE `[[dbprefix]]portfolio_log` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL,
  `time` bigint(10) NOT NULL,
  `portfolio` bigint(10) NOT NULL,
  `caller_class` varchar(150) NOT NULL DEFAULT '',
  `caller_file` varchar(255) NOT NULL DEFAULT '',
  `caller_component` varchar(255) DEFAULT NULL,
  `caller_sha1` varchar(255) NOT NULL DEFAULT '',
  `tempdataid` bigint(10) NOT NULL DEFAULT '0',
  `returnurl` varchar(255) NOT NULL DEFAULT '',
  `continueurl` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]portlog_use_ix` (`userid`),
  KEY `[[dbprefix]]portlog_por_ix` (`portfolio`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='log of portfolio transfers (used to later check for duplicat' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]portfolio_mahara_queue`
--

CREATE TABLE `[[dbprefix]]portfolio_mahara_queue` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `transferid` bigint(10) NOT NULL,
  `token` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]portmahaqueu_tok_ix` (`token`),
  KEY `[[dbprefix]]portmahaqueu_tra_ix` (`transferid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='maps mahara tokens to transfer ids' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]portfolio_tempdata`
--

CREATE TABLE `[[dbprefix]]portfolio_tempdata` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `data` longtext,
  `expirytime` bigint(10) NOT NULL,
  `userid` bigint(10) NOT NULL,
  `instance` bigint(10) DEFAULT '0',
  `queued` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]porttemp_use_ix` (`userid`),
  KEY `[[dbprefix]]porttemp_ins_ix` (`instance`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='stores temporary data for portfolio exports. the id of this ' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]post`
--

CREATE TABLE `[[dbprefix]]post` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `module` varchar(20) NOT NULL DEFAULT '',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `courseid` bigint(10) NOT NULL DEFAULT '0',
  `groupid` bigint(10) NOT NULL DEFAULT '0',
  `moduleid` bigint(10) NOT NULL DEFAULT '0',
  `coursemoduleid` bigint(10) NOT NULL DEFAULT '0',
  `subject` varchar(128) NOT NULL DEFAULT '',
  `summary` longtext,
  `content` longtext,
  `uniquehash` varchar(255) NOT NULL DEFAULT '',
  `rating` bigint(10) NOT NULL DEFAULT '0',
  `format` bigint(10) NOT NULL DEFAULT '0',
  `summaryformat` tinyint(2) NOT NULL DEFAULT '0',
  `attachment` varchar(100) DEFAULT NULL,
  `publishstate` varchar(20) NOT NULL DEFAULT 'draft',
  `lastmodified` bigint(10) NOT NULL DEFAULT '0',
  `created` bigint(10) NOT NULL DEFAULT '0',
  `usermodified` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]post_iduse_uix` (`id`,`userid`),
  KEY `[[dbprefix]]post_las_ix` (`lastmodified`),
  KEY `[[dbprefix]]post_mod_ix` (`module`),
  KEY `[[dbprefix]]post_sub_ix` (`subject`),
  KEY `[[dbprefix]]post_use_ix` (`usermodified`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Generic post table to hold data blog entries etc in differen' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]profiling`
--

CREATE TABLE `[[dbprefix]]profiling` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `runid` varchar(32) NOT NULL DEFAULT '',
  `url` varchar(255) NOT NULL DEFAULT '',
  `data` longtext NOT NULL,
  `totalexecutiontime` bigint(10) NOT NULL,
  `totalcputime` bigint(10) NOT NULL,
  `totalcalls` bigint(10) NOT NULL,
  `totalmemory` bigint(10) NOT NULL,
  `runreference` tinyint(2) NOT NULL DEFAULT '0',
  `runcomment` varchar(255) NOT NULL DEFAULT '',
  `timecreated` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]prof_run_uix` (`runid`),
  KEY `[[dbprefix]]prof_urlrun_ix` (`url`,`runreference`),
  KEY `[[dbprefix]]prof_timrun_ix` (`timecreated`,`runreference`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Stores the results of all the profiling runs' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]qtype_ddimageortext`
--

CREATE TABLE `[[dbprefix]]qtype_ddimageortext` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `questionid` bigint(10) NOT NULL DEFAULT '0',
  `shuffleanswers` smallint(4) NOT NULL DEFAULT '1',
  `correctfeedback` longtext NOT NULL,
  `correctfeedbackformat` tinyint(2) NOT NULL DEFAULT '0',
  `partiallycorrectfeedback` longtext NOT NULL,
  `partiallycorrectfeedbackformat` tinyint(2) NOT NULL DEFAULT '0',
  `incorrectfeedback` longtext NOT NULL,
  `incorrectfeedbackformat` tinyint(2) NOT NULL DEFAULT '0',
  `shownumcorrect` tinyint(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]qtypddim_que_ix` (`questionid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Defines drag and drop (text or images onto a background imag' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]qtype_ddimageortext_drags`
--

CREATE TABLE `[[dbprefix]]qtype_ddimageortext_drags` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `questionid` bigint(10) NOT NULL DEFAULT '0',
  `no` bigint(10) NOT NULL DEFAULT '0',
  `draggroup` bigint(10) NOT NULL DEFAULT '0',
  `infinite` smallint(4) NOT NULL DEFAULT '0',
  `label` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]qtypddimdrag_que_ix` (`questionid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Images to drag. Actual file names are not stored here we use' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]qtype_ddimageortext_drops`
--

CREATE TABLE `[[dbprefix]]qtype_ddimageortext_drops` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `questionid` bigint(10) NOT NULL DEFAULT '0',
  `no` bigint(10) NOT NULL DEFAULT '0',
  `xleft` bigint(10) NOT NULL DEFAULT '0',
  `ytop` bigint(10) NOT NULL DEFAULT '0',
  `choice` bigint(10) NOT NULL DEFAULT '0',
  `label` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]qtypddimdrop_que_ix` (`questionid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Drop boxes' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]qtype_ddmarker`
--

CREATE TABLE `[[dbprefix]]qtype_ddmarker` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `questionid` bigint(10) NOT NULL DEFAULT '0',
  `shuffleanswers` smallint(4) NOT NULL DEFAULT '1',
  `correctfeedback` longtext NOT NULL,
  `correctfeedbackformat` tinyint(2) NOT NULL DEFAULT '0',
  `partiallycorrectfeedback` longtext NOT NULL,
  `partiallycorrectfeedbackformat` tinyint(2) NOT NULL DEFAULT '0',
  `incorrectfeedback` longtext NOT NULL,
  `incorrectfeedbackformat` tinyint(2) NOT NULL DEFAULT '0',
  `shownumcorrect` tinyint(2) NOT NULL DEFAULT '0',
  `showmisplaced` smallint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]qtypddma_que_ix` (`questionid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Defines drag and drop (text or images onto a background imag' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]qtype_ddmarker_drags`
--

CREATE TABLE `[[dbprefix]]qtype_ddmarker_drags` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `questionid` bigint(10) NOT NULL DEFAULT '0',
  `no` bigint(10) NOT NULL DEFAULT '0',
  `label` longtext NOT NULL,
  `infinite` smallint(4) NOT NULL DEFAULT '0',
  `noofdrags` bigint(10) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]qtypddmadrag_que_ix` (`questionid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Labels for markers to drag.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]qtype_ddmarker_drops`
--

CREATE TABLE `[[dbprefix]]qtype_ddmarker_drops` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `questionid` bigint(10) NOT NULL DEFAULT '0',
  `no` bigint(10) NOT NULL DEFAULT '0',
  `shape` varchar(255) DEFAULT NULL,
  `coords` longtext NOT NULL,
  `choice` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]qtypddmadrop_que_ix` (`questionid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='drop regions' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]qtype_essay_options`
--

CREATE TABLE `[[dbprefix]]qtype_essay_options` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `questionid` bigint(10) NOT NULL,
  `responseformat` varchar(16) NOT NULL DEFAULT 'editor',
  `responserequired` tinyint(2) NOT NULL DEFAULT '1',
  `responsefieldlines` smallint(4) NOT NULL DEFAULT '15',
  `attachments` smallint(4) NOT NULL DEFAULT '0',
  `attachmentsrequired` smallint(4) NOT NULL DEFAULT '0',
  `graderinfo` longtext,
  `graderinfoformat` smallint(4) NOT NULL DEFAULT '0',
  `responsetemplate` longtext,
  `responsetemplateformat` smallint(4) NOT NULL DEFAULT '0',
  `filetypeslist` longtext,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]qtypessaopti_que_uix` (`questionid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Extra options for essay questions.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]qtype_match_options`
--

CREATE TABLE `[[dbprefix]]qtype_match_options` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `questionid` bigint(10) NOT NULL DEFAULT '0',
  `shuffleanswers` smallint(4) NOT NULL DEFAULT '1',
  `correctfeedback` longtext NOT NULL,
  `correctfeedbackformat` tinyint(2) NOT NULL DEFAULT '0',
  `partiallycorrectfeedback` longtext NOT NULL,
  `partiallycorrectfeedbackformat` tinyint(2) NOT NULL DEFAULT '0',
  `incorrectfeedback` longtext NOT NULL,
  `incorrectfeedbackformat` tinyint(2) NOT NULL DEFAULT '0',
  `shownumcorrect` tinyint(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]qtypmatcopti_que_uix` (`questionid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Defines the question-type specific options for matching ques' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]qtype_match_subquestions`
--

CREATE TABLE `[[dbprefix]]qtype_match_subquestions` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `questionid` bigint(10) NOT NULL DEFAULT '0',
  `questiontext` longtext NOT NULL,
  `questiontextformat` tinyint(2) NOT NULL DEFAULT '0',
  `answertext` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]qtypmatcsubq_que_ix` (`questionid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='The subquestions that make up a matching question' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]qtype_multichoice_options`
--

CREATE TABLE `[[dbprefix]]qtype_multichoice_options` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `questionid` bigint(10) NOT NULL DEFAULT '0',
  `layout` smallint(4) NOT NULL DEFAULT '0',
  `single` smallint(4) NOT NULL DEFAULT '0',
  `shuffleanswers` smallint(4) NOT NULL DEFAULT '1',
  `correctfeedback` longtext NOT NULL,
  `correctfeedbackformat` tinyint(2) NOT NULL DEFAULT '0',
  `partiallycorrectfeedback` longtext NOT NULL,
  `partiallycorrectfeedbackformat` tinyint(2) NOT NULL DEFAULT '0',
  `incorrectfeedback` longtext NOT NULL,
  `incorrectfeedbackformat` tinyint(2) NOT NULL DEFAULT '0',
  `answernumbering` varchar(10) NOT NULL DEFAULT 'abc',
  `shownumcorrect` tinyint(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]qtypmultopti_que_uix` (`questionid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Options for multiple choice questions' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]qtype_randomsamatch_options`
--

CREATE TABLE `[[dbprefix]]qtype_randomsamatch_options` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `questionid` bigint(10) NOT NULL DEFAULT '0',
  `choose` bigint(10) NOT NULL DEFAULT '4',
  `subcats` tinyint(2) NOT NULL DEFAULT '1',
  `correctfeedback` longtext NOT NULL,
  `correctfeedbackformat` tinyint(2) NOT NULL DEFAULT '0',
  `partiallycorrectfeedback` longtext NOT NULL,
  `partiallycorrectfeedbackformat` tinyint(2) NOT NULL DEFAULT '0',
  `incorrectfeedback` longtext NOT NULL,
  `incorrectfeedbackformat` tinyint(2) NOT NULL DEFAULT '0',
  `shownumcorrect` tinyint(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]qtyprandopti_que_uix` (`questionid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Info about a random short-answer matching question' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]qtype_shortanswer_options`
--

CREATE TABLE `[[dbprefix]]qtype_shortanswer_options` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `questionid` bigint(10) NOT NULL DEFAULT '0',
  `usecase` tinyint(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]qtypshoropti_que_uix` (`questionid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Options for short answer questions' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question`
--

CREATE TABLE `[[dbprefix]]question` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `category` bigint(10) NOT NULL DEFAULT '0',
  `parent` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `questiontext` longtext NOT NULL,
  `questiontextformat` tinyint(2) NOT NULL DEFAULT '0',
  `generalfeedback` longtext NOT NULL,
  `generalfeedbackformat` tinyint(2) NOT NULL DEFAULT '0',
  `defaultmark` decimal(12,7) NOT NULL DEFAULT '1.0000000',
  `penalty` decimal(12,7) NOT NULL DEFAULT '0.3333333',
  `qtype` varchar(20) NOT NULL DEFAULT '',
  `length` bigint(10) NOT NULL DEFAULT '1',
  `stamp` varchar(255) NOT NULL DEFAULT '',
  `version` varchar(255) NOT NULL DEFAULT '',
  `hidden` tinyint(1) NOT NULL DEFAULT '0',
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `createdby` bigint(10) DEFAULT NULL,
  `modifiedby` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]ques_qty_ix` (`qtype`),
  KEY `[[dbprefix]]ques_cat_ix` (`category`),
  KEY `[[dbprefix]]ques_par_ix` (`parent`),
  KEY `[[dbprefix]]ques_cre_ix` (`createdby`),
  KEY `[[dbprefix]]ques_mod_ix` (`modifiedby`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='The questions themselves' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question_answers`
--

CREATE TABLE `[[dbprefix]]question_answers` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `question` bigint(10) NOT NULL DEFAULT '0',
  `answer` longtext NOT NULL,
  `answerformat` tinyint(2) NOT NULL DEFAULT '0',
  `fraction` decimal(12,7) NOT NULL DEFAULT '0.0000000',
  `feedback` longtext NOT NULL,
  `feedbackformat` tinyint(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]quesansw_que_ix` (`question`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Answers, with a fractional grade (0-1) and feedback' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question_attempts`
--

CREATE TABLE `[[dbprefix]]question_attempts` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `questionusageid` bigint(10) NOT NULL,
  `slot` bigint(10) NOT NULL,
  `behaviour` varchar(32) NOT NULL DEFAULT '',
  `questionid` bigint(10) NOT NULL,
  `variant` bigint(10) NOT NULL DEFAULT '1',
  `maxmark` decimal(12,7) NOT NULL,
  `minfraction` decimal(12,7) NOT NULL,
  `maxfraction` decimal(12,7) NOT NULL DEFAULT '1.0000000',
  `flagged` tinyint(1) NOT NULL DEFAULT '0',
  `questionsummary` longtext,
  `rightanswer` longtext,
  `responsesummary` longtext,
  `timemodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]quesatte_queslo_uix` (`questionusageid`,`slot`),
  KEY `[[dbprefix]]quesatte_beh_ix` (`behaviour`),
  KEY `[[dbprefix]]quesatte_que_ix` (`questionid`),
  KEY `[[dbprefix]]quesatte_que2_ix` (`questionusageid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Each row here corresponds to an attempt at one question, as ' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question_attempt_steps`
--

CREATE TABLE `[[dbprefix]]question_attempt_steps` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `questionattemptid` bigint(10) NOT NULL,
  `sequencenumber` bigint(10) NOT NULL,
  `state` varchar(13) NOT NULL DEFAULT '',
  `fraction` decimal(12,7) DEFAULT NULL,
  `timecreated` bigint(10) NOT NULL,
  `userid` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]quesattestep_queseq_uix` (`questionattemptid`,`sequencenumber`),
  KEY `[[dbprefix]]quesattestep_que_ix` (`questionattemptid`),
  KEY `[[dbprefix]]quesattestep_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Stores one step in in a question attempt. As well as the dat' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question_attempt_step_data`
--

CREATE TABLE `[[dbprefix]]question_attempt_step_data` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `attemptstepid` bigint(10) NOT NULL,
  `name` varchar(32) NOT NULL DEFAULT '',
  `value` longtext,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]quesattestepdata_att_ix` (`attemptstepid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Each question_attempt_step has an associative array of the d' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question_calculated`
--

CREATE TABLE `[[dbprefix]]question_calculated` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `question` bigint(10) NOT NULL DEFAULT '0',
  `answer` bigint(10) NOT NULL DEFAULT '0',
  `tolerance` varchar(20) NOT NULL DEFAULT '0.0',
  `tolerancetype` bigint(10) NOT NULL DEFAULT '1',
  `correctanswerlength` bigint(10) NOT NULL DEFAULT '2',
  `correctanswerformat` bigint(10) NOT NULL DEFAULT '2',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]quescalc_ans_ix` (`answer`),
  KEY `[[dbprefix]]quescalc_que_ix` (`question`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Options for questions of type calculated' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question_calculated_options`
--

CREATE TABLE `[[dbprefix]]question_calculated_options` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `question` bigint(10) NOT NULL DEFAULT '0',
  `synchronize` tinyint(2) NOT NULL DEFAULT '0',
  `single` smallint(4) NOT NULL DEFAULT '0',
  `shuffleanswers` smallint(4) NOT NULL DEFAULT '0',
  `correctfeedback` longtext,
  `correctfeedbackformat` tinyint(2) NOT NULL DEFAULT '0',
  `partiallycorrectfeedback` longtext,
  `partiallycorrectfeedbackformat` tinyint(2) NOT NULL DEFAULT '0',
  `incorrectfeedback` longtext,
  `incorrectfeedbackformat` tinyint(2) NOT NULL DEFAULT '0',
  `answernumbering` varchar(10) NOT NULL DEFAULT 'abc',
  `shownumcorrect` tinyint(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]quescalcopti_que_ix` (`question`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Options for questions of type calculated' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question_categories`
--

CREATE TABLE `[[dbprefix]]question_categories` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `contextid` bigint(10) NOT NULL DEFAULT '0',
  `info` longtext NOT NULL,
  `infoformat` tinyint(2) NOT NULL DEFAULT '0',
  `stamp` varchar(255) NOT NULL DEFAULT '',
  `parent` bigint(10) NOT NULL DEFAULT '0',
  `sortorder` bigint(10) NOT NULL DEFAULT '999',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]quescate_consta_uix` (`contextid`,`stamp`),
  KEY `[[dbprefix]]quescate_con_ix` (`contextid`),
  KEY `[[dbprefix]]quescate_par_ix` (`parent`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Categories are for grouping questions' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question_datasets`
--

CREATE TABLE `[[dbprefix]]question_datasets` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `question` bigint(10) NOT NULL DEFAULT '0',
  `datasetdefinition` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]quesdata_quedat_ix` (`question`,`datasetdefinition`),
  KEY `[[dbprefix]]quesdata_que_ix` (`question`),
  KEY `[[dbprefix]]quesdata_dat_ix` (`datasetdefinition`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Many-many relation between questions and dataset definitions' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question_dataset_definitions`
--

CREATE TABLE `[[dbprefix]]question_dataset_definitions` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `category` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `type` bigint(10) NOT NULL DEFAULT '0',
  `options` varchar(255) NOT NULL DEFAULT '',
  `itemcount` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]quesdatadefi_cat_ix` (`category`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Organises and stores properties for dataset items' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question_dataset_items`
--

CREATE TABLE `[[dbprefix]]question_dataset_items` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `definition` bigint(10) NOT NULL DEFAULT '0',
  `itemnumber` bigint(10) NOT NULL DEFAULT '0',
  `value` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]quesdataitem_def_ix` (`definition`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Individual dataset items' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question_ddwtos`
--

CREATE TABLE `[[dbprefix]]question_ddwtos` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `questionid` bigint(10) NOT NULL DEFAULT '0',
  `shuffleanswers` smallint(4) NOT NULL DEFAULT '1',
  `correctfeedback` longtext NOT NULL,
  `correctfeedbackformat` tinyint(2) NOT NULL DEFAULT '0',
  `partiallycorrectfeedback` longtext NOT NULL,
  `partiallycorrectfeedbackformat` tinyint(2) NOT NULL DEFAULT '0',
  `incorrectfeedback` longtext NOT NULL,
  `incorrectfeedbackformat` tinyint(2) NOT NULL DEFAULT '0',
  `shownumcorrect` tinyint(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]quesddwt_que_ix` (`questionid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Defines drag and drop (words into sentences) questions' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question_gapselect`
--

CREATE TABLE `[[dbprefix]]question_gapselect` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `questionid` bigint(10) NOT NULL DEFAULT '0',
  `shuffleanswers` smallint(4) NOT NULL DEFAULT '1',
  `correctfeedback` longtext NOT NULL,
  `correctfeedbackformat` tinyint(2) NOT NULL DEFAULT '0',
  `partiallycorrectfeedback` longtext NOT NULL,
  `partiallycorrectfeedbackformat` tinyint(2) NOT NULL DEFAULT '0',
  `incorrectfeedback` longtext NOT NULL,
  `incorrectfeedbackformat` tinyint(2) NOT NULL DEFAULT '0',
  `shownumcorrect` tinyint(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]quesgaps_que_ix` (`questionid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Defines select missing words questions' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question_hints`
--

CREATE TABLE `[[dbprefix]]question_hints` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `questionid` bigint(10) NOT NULL,
  `hint` longtext NOT NULL,
  `hintformat` smallint(4) NOT NULL DEFAULT '0',
  `shownumcorrect` tinyint(1) DEFAULT NULL,
  `clearwrong` tinyint(1) DEFAULT NULL,
  `options` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]queshint_que_ix` (`questionid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Stores the the part of the question definition that gives di' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question_multianswer`
--

CREATE TABLE `[[dbprefix]]question_multianswer` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `question` bigint(10) NOT NULL DEFAULT '0',
  `sequence` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]quesmult_que_ix` (`question`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Options for multianswer questions' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question_numerical`
--

CREATE TABLE `[[dbprefix]]question_numerical` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `question` bigint(10) NOT NULL DEFAULT '0',
  `answer` bigint(10) NOT NULL DEFAULT '0',
  `tolerance` varchar(255) NOT NULL DEFAULT '0.0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]quesnume_ans_ix` (`answer`),
  KEY `[[dbprefix]]quesnume_que_ix` (`question`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Options for numerical questions.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question_numerical_options`
--

CREATE TABLE `[[dbprefix]]question_numerical_options` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `question` bigint(10) NOT NULL DEFAULT '0',
  `showunits` smallint(4) NOT NULL DEFAULT '0',
  `unitsleft` smallint(4) NOT NULL DEFAULT '0',
  `unitgradingtype` smallint(4) NOT NULL DEFAULT '0',
  `unitpenalty` decimal(12,7) NOT NULL DEFAULT '0.1000000',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]quesnumeopti_que_ix` (`question`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Options for questions of type numerical This table is also u' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question_numerical_units`
--

CREATE TABLE `[[dbprefix]]question_numerical_units` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `question` bigint(10) NOT NULL DEFAULT '0',
  `multiplier` decimal(38,19) NOT NULL DEFAULT '1.0000000000000000000',
  `unit` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]quesnumeunit_queuni_uix` (`question`,`unit`),
  KEY `[[dbprefix]]quesnumeunit_que_ix` (`question`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Optional unit options for numerical questions. This table is' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question_response_analysis`
--

CREATE TABLE `[[dbprefix]]question_response_analysis` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `hashcode` varchar(40) NOT NULL DEFAULT '',
  `whichtries` varchar(255) NOT NULL DEFAULT '',
  `timemodified` bigint(10) NOT NULL,
  `questionid` bigint(10) NOT NULL,
  `variant` bigint(10) DEFAULT NULL,
  `subqid` varchar(100) NOT NULL DEFAULT '',
  `aid` varchar(100) DEFAULT NULL,
  `response` longtext,
  `credit` decimal(15,5) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Analysis of student responses given to questions.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question_response_count`
--

CREATE TABLE `[[dbprefix]]question_response_count` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `analysisid` bigint(10) NOT NULL,
  `try` bigint(10) NOT NULL,
  `rcount` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]quesrespcoun_ana_ix` (`analysisid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Count for each responses for each try at a question.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question_statistics`
--

CREATE TABLE `[[dbprefix]]question_statistics` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `hashcode` varchar(40) NOT NULL DEFAULT '',
  `timemodified` bigint(10) NOT NULL,
  `questionid` bigint(10) NOT NULL,
  `slot` bigint(10) DEFAULT NULL,
  `subquestion` smallint(4) NOT NULL,
  `variant` bigint(10) DEFAULT NULL,
  `s` bigint(10) NOT NULL DEFAULT '0',
  `effectiveweight` decimal(15,5) DEFAULT NULL,
  `negcovar` tinyint(2) NOT NULL DEFAULT '0',
  `discriminationindex` decimal(15,5) DEFAULT NULL,
  `discriminativeefficiency` decimal(15,5) DEFAULT NULL,
  `sd` decimal(15,10) DEFAULT NULL,
  `facility` decimal(15,10) DEFAULT NULL,
  `subquestions` longtext,
  `maxmark` decimal(12,7) DEFAULT NULL,
  `positions` longtext,
  `randomguessscore` decimal(12,7) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Statistics for individual questions used in an activity.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question_truefalse`
--

CREATE TABLE `[[dbprefix]]question_truefalse` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `question` bigint(10) NOT NULL DEFAULT '0',
  `trueanswer` bigint(10) NOT NULL DEFAULT '0',
  `falseanswer` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]questrue_que_ix` (`question`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Options for True-False questions' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]question_usages`
--

CREATE TABLE `[[dbprefix]]question_usages` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `contextid` bigint(10) NOT NULL,
  `component` varchar(255) NOT NULL DEFAULT '',
  `preferredbehaviour` varchar(32) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]quesusag_con_ix` (`contextid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='This table''s main purpose it to assign a unique id to each a' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]quiz`
--

CREATE TABLE `[[dbprefix]]quiz` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `intro` longtext NOT NULL,
  `introformat` smallint(4) NOT NULL DEFAULT '0',
  `timeopen` bigint(10) NOT NULL DEFAULT '0',
  `timeclose` bigint(10) NOT NULL DEFAULT '0',
  `timelimit` bigint(10) NOT NULL DEFAULT '0',
  `overduehandling` varchar(16) NOT NULL DEFAULT 'autoabandon',
  `graceperiod` bigint(10) NOT NULL DEFAULT '0',
  `preferredbehaviour` varchar(32) NOT NULL DEFAULT '',
  `canredoquestions` smallint(4) NOT NULL DEFAULT '0',
  `attempts` mediumint(6) NOT NULL DEFAULT '0',
  `attemptonlast` smallint(4) NOT NULL DEFAULT '0',
  `grademethod` smallint(4) NOT NULL DEFAULT '1',
  `decimalpoints` smallint(4) NOT NULL DEFAULT '2',
  `questiondecimalpoints` smallint(4) NOT NULL DEFAULT '-1',
  `reviewattempt` mediumint(6) NOT NULL DEFAULT '0',
  `reviewcorrectness` mediumint(6) NOT NULL DEFAULT '0',
  `reviewmarks` mediumint(6) NOT NULL DEFAULT '0',
  `reviewspecificfeedback` mediumint(6) NOT NULL DEFAULT '0',
  `reviewgeneralfeedback` mediumint(6) NOT NULL DEFAULT '0',
  `reviewrightanswer` mediumint(6) NOT NULL DEFAULT '0',
  `reviewoverallfeedback` mediumint(6) NOT NULL DEFAULT '0',
  `questionsperpage` bigint(10) NOT NULL DEFAULT '0',
  `navmethod` varchar(16) NOT NULL DEFAULT 'free',
  `shuffleanswers` smallint(4) NOT NULL DEFAULT '0',
  `sumgrades` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `grade` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `password` varchar(255) NOT NULL DEFAULT '',
  `subnet` varchar(255) NOT NULL DEFAULT '',
  `browsersecurity` varchar(32) NOT NULL DEFAULT '',
  `delay1` bigint(10) NOT NULL DEFAULT '0',
  `delay2` bigint(10) NOT NULL DEFAULT '0',
  `showuserpicture` smallint(4) NOT NULL DEFAULT '0',
  `showblocks` smallint(4) NOT NULL DEFAULT '0',
  `completionattemptsexhausted` tinyint(1) DEFAULT '0',
  `completionpass` tinyint(1) DEFAULT '0',
  `allowofflineattempts` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]quiz_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='The settings for each quiz.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]quiz_attempts`
--

CREATE TABLE `[[dbprefix]]quiz_attempts` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `quiz` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `attempt` mediumint(6) NOT NULL DEFAULT '0',
  `uniqueid` bigint(10) NOT NULL DEFAULT '0',
  `layout` longtext NOT NULL,
  `currentpage` bigint(10) NOT NULL DEFAULT '0',
  `preview` smallint(3) NOT NULL DEFAULT '0',
  `state` varchar(16) NOT NULL DEFAULT 'inprogress',
  `timestart` bigint(10) NOT NULL DEFAULT '0',
  `timefinish` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `timemodifiedoffline` bigint(10) NOT NULL DEFAULT '0',
  `timecheckstate` bigint(10) DEFAULT '0',
  `sumgrades` decimal(10,5) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]quizatte_quiuseatt_uix` (`quiz`,`userid`,`attempt`),
  UNIQUE KEY `[[dbprefix]]quizatte_uni_uix` (`uniqueid`),
  KEY `[[dbprefix]]quizatte_statim_ix` (`state`,`timecheckstate`),
  KEY `[[dbprefix]]quizatte_qui_ix` (`quiz`),
  KEY `[[dbprefix]]quizatte_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Stores users attempts at quizzes.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]quiz_feedback`
--

CREATE TABLE `[[dbprefix]]quiz_feedback` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `quizid` bigint(10) NOT NULL DEFAULT '0',
  `feedbacktext` longtext NOT NULL,
  `feedbacktextformat` tinyint(2) NOT NULL DEFAULT '0',
  `mingrade` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `maxgrade` decimal(10,5) NOT NULL DEFAULT '0.00000',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]quizfeed_qui_ix` (`quizid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Feedback given to students based on which grade band their o' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]quiz_grades`
--

CREATE TABLE `[[dbprefix]]quiz_grades` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `quiz` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `grade` decimal(10,5) NOT NULL DEFAULT '0.00000',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]quizgrad_use_ix` (`userid`),
  KEY `[[dbprefix]]quizgrad_qui_ix` (`quiz`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Stores the overall grade for each user on the quiz, based on' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]quiz_overrides`
--

CREATE TABLE `[[dbprefix]]quiz_overrides` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `quiz` bigint(10) NOT NULL DEFAULT '0',
  `groupid` bigint(10) DEFAULT NULL,
  `userid` bigint(10) DEFAULT NULL,
  `timeopen` bigint(10) DEFAULT NULL,
  `timeclose` bigint(10) DEFAULT NULL,
  `timelimit` bigint(10) DEFAULT NULL,
  `attempts` mediumint(6) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]quizover_qui_ix` (`quiz`),
  KEY `[[dbprefix]]quizover_gro_ix` (`groupid`),
  KEY `[[dbprefix]]quizover_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='The overrides to quiz settings on a per-user and per-group b' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]quiz_overview_regrades`
--

CREATE TABLE `[[dbprefix]]quiz_overview_regrades` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `questionusageid` bigint(10) NOT NULL,
  `slot` bigint(10) NOT NULL,
  `newfraction` decimal(12,7) DEFAULT NULL,
  `oldfraction` decimal(12,7) DEFAULT NULL,
  `regraded` smallint(4) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]quizoverregr_queslo_ix` (`questionusageid`,`slot`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='This table records which question attempts need regrading an' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]quiz_reports`
--

CREATE TABLE `[[dbprefix]]quiz_reports` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `displayorder` bigint(10) NOT NULL,
  `capability` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]quizrepo_nam_uix` (`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Lists all the installed quiz reports and their display order' AUTO_INCREMENT=5 ;

--
-- Dumping data for table `[[dbprefix]]quiz_reports`
--

INSERT INTO `[[dbprefix]]quiz_reports` VALUES
(1, 'grading', 6000, 'mod/quiz:grade'),
(2, 'overview', 10000, NULL),
(3, 'responses', 9000, NULL),
(4, 'statistics', 8000, 'quiz/statistics:view');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]quiz_sections`
--

CREATE TABLE `[[dbprefix]]quiz_sections` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `quizid` bigint(10) NOT NULL,
  `firstslot` bigint(10) NOT NULL,
  `heading` varchar(1333) DEFAULT NULL,
  `shufflequestions` smallint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]quizsect_quifir_uix` (`quizid`,`firstslot`),
  KEY `[[dbprefix]]quizsect_qui_ix` (`quizid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Stores sections of a quiz with section name (heading), from ' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]quiz_slots`
--

CREATE TABLE `[[dbprefix]]quiz_slots` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `slot` bigint(10) NOT NULL,
  `quizid` bigint(10) NOT NULL DEFAULT '0',
  `page` bigint(10) NOT NULL,
  `requireprevious` smallint(4) NOT NULL DEFAULT '0',
  `questionid` bigint(10) NOT NULL DEFAULT '0',
  `questioncategoryid` bigint(10) DEFAULT NULL,
  `includingsubcategories` smallint(4) DEFAULT NULL,
  `maxmark` decimal(12,7) NOT NULL DEFAULT '0.0000000',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]quizslot_quislo_uix` (`quizid`,`slot`),
  KEY `[[dbprefix]]quizslot_qui_ix` (`quizid`),
  KEY `[[dbprefix]]quizslot_que_ix` (`questionid`),
  KEY `[[dbprefix]]quizslot_que2_ix` (`questioncategoryid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Stores the question used in a quiz, with the order, and for ' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]quiz_slot_tags`
--

CREATE TABLE `[[dbprefix]]quiz_slot_tags` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `slotid` bigint(10) DEFAULT NULL,
  `tagid` bigint(10) DEFAULT NULL,
  `tagname` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]quizslottags_slo_ix` (`slotid`),
  KEY `[[dbprefix]]quizslottags_tag_ix` (`tagid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Stores data about the tags that a question must have so that' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]quiz_statistics`
--

CREATE TABLE `[[dbprefix]]quiz_statistics` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `hashcode` varchar(40) NOT NULL DEFAULT '',
  `whichattempts` smallint(4) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `firstattemptscount` bigint(10) NOT NULL,
  `highestattemptscount` bigint(10) NOT NULL,
  `lastattemptscount` bigint(10) NOT NULL,
  `allattemptscount` bigint(10) NOT NULL,
  `firstattemptsavg` decimal(15,5) DEFAULT NULL,
  `highestattemptsavg` decimal(15,5) DEFAULT NULL,
  `lastattemptsavg` decimal(15,5) DEFAULT NULL,
  `allattemptsavg` decimal(15,5) DEFAULT NULL,
  `median` decimal(15,5) DEFAULT NULL,
  `standarddeviation` decimal(15,5) DEFAULT NULL,
  `skewness` decimal(15,10) DEFAULT NULL,
  `kurtosis` decimal(15,5) DEFAULT NULL,
  `cic` decimal(15,10) DEFAULT NULL,
  `errorratio` decimal(15,10) DEFAULT NULL,
  `standarderror` decimal(15,10) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='table to cache results from analysis done in statistics repo' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]rating`
--

CREATE TABLE `[[dbprefix]]rating` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `contextid` bigint(10) NOT NULL,
  `component` varchar(100) NOT NULL DEFAULT '',
  `ratingarea` varchar(50) NOT NULL DEFAULT '',
  `itemid` bigint(10) NOT NULL,
  `scaleid` bigint(10) NOT NULL,
  `rating` bigint(10) NOT NULL,
  `userid` bigint(10) NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]rati_comratconite_ix` (`component`,`ratingarea`,`contextid`,`itemid`),
  KEY `[[dbprefix]]rati_con_ix` (`contextid`),
  KEY `[[dbprefix]]rati_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='moodle ratings' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]registration_hubs`
--

CREATE TABLE `[[dbprefix]]registration_hubs` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `token` varchar(255) NOT NULL DEFAULT '',
  `hubname` varchar(255) NOT NULL DEFAULT '',
  `huburl` varchar(255) NOT NULL DEFAULT '',
  `confirmed` tinyint(1) NOT NULL DEFAULT '0',
  `secret` varchar(255) DEFAULT NULL,
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='hub where the site is registered on with their associated to' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]repository`
--

CREATE TABLE `[[dbprefix]]repository` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `type` varchar(255) NOT NULL DEFAULT '',
  `visible` tinyint(1) DEFAULT '1',
  `sortorder` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='This table contains one entry for every configured external ' AUTO_INCREMENT=8 ;

--
-- Dumping data for table `[[dbprefix]]repository`
--

INSERT INTO `[[dbprefix]]repository` VALUES
(1, 'areafiles', 1, 1),
(2, 'local', 1, 2),
(3, 'recent', 1, 3),
(4, 'upload', 1, 4),
(5, 'url', 1, 5),
(6, 'user', 1, 6),
(7, 'wikimedia', 1, 7);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]repository_instances`
--

CREATE TABLE `[[dbprefix]]repository_instances` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `typeid` bigint(10) NOT NULL,
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `contextid` bigint(10) NOT NULL,
  `username` varchar(255) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  `timecreated` bigint(10) DEFAULT NULL,
  `timemodified` bigint(10) DEFAULT NULL,
  `readonly` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='This table contains one entry for every configured external ' AUTO_INCREMENT=8 ;

--
-- Dumping data for table `[[dbprefix]]repository_instances`
--

INSERT INTO `[[dbprefix]]repository_instances` VALUES
(1, '', 1, 0, 1, NULL, NULL, [[timestamp]], [[timestamp]], 0),
(2, '', 2, 0, 1, NULL, NULL, [[timestamp]], [[timestamp]], 0),
(3, '', 3, 0, 1, NULL, NULL, [[timestamp]], [[timestamp]], 0),
(4, '', 4, 0, 1, NULL, NULL, [[timestamp]], [[timestamp]], 0),
(5, '', 5, 0, 1, NULL, NULL, [[timestamp]], [[timestamp]], 0),
(6, '', 6, 0, 1, NULL, NULL, [[timestamp]], [[timestamp]], 0),
(7, '', 7, 0, 1, NULL, NULL, [[timestamp]], [[timestamp]], 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]repository_instance_config`
--

CREATE TABLE `[[dbprefix]]repository_instance_config` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `instanceid` bigint(10) NOT NULL,
  `name` varchar(255) NOT NULL DEFAULT '',
  `value` longtext,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='The config for intances' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]repository_onedrive_access`
--

CREATE TABLE `[[dbprefix]]repository_onedrive_access` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `timemodified` bigint(10) NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  `usermodified` bigint(10) NOT NULL,
  `permissionid` varchar(255) NOT NULL DEFAULT '',
  `itemid` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]repoonedacce_use_ix` (`usermodified`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='List of temporary access grants.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]resource`
--

CREATE TABLE `[[dbprefix]]resource` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `intro` longtext,
  `introformat` smallint(4) NOT NULL DEFAULT '0',
  `tobemigrated` smallint(4) NOT NULL DEFAULT '0',
  `legacyfiles` smallint(4) NOT NULL DEFAULT '0',
  `legacyfileslast` bigint(10) DEFAULT NULL,
  `display` smallint(4) NOT NULL DEFAULT '0',
  `displayoptions` longtext,
  `filterfiles` smallint(4) NOT NULL DEFAULT '0',
  `revision` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]reso_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Each record is one resource and its config data' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]resource_old`
--

CREATE TABLE `[[dbprefix]]resource_old` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `type` varchar(30) NOT NULL DEFAULT '',
  `reference` varchar(255) NOT NULL DEFAULT '',
  `intro` longtext,
  `introformat` smallint(4) NOT NULL DEFAULT '0',
  `alltext` longtext NOT NULL,
  `popup` longtext NOT NULL,
  `options` varchar(255) NOT NULL DEFAULT '',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `oldid` bigint(10) NOT NULL,
  `cmid` bigint(10) DEFAULT NULL,
  `newmodule` varchar(50) DEFAULT NULL,
  `newid` bigint(10) DEFAULT NULL,
  `migrated` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]resoold_old_uix` (`oldid`),
  KEY `[[dbprefix]]resoold_cmi_ix` (`cmid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='backup of all old resource instances from 1.9' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]role`
--

CREATE TABLE `[[dbprefix]]role` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `shortname` varchar(100) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `sortorder` bigint(10) NOT NULL DEFAULT '0',
  `archetype` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]role_sor_uix` (`sortorder`),
  UNIQUE KEY `[[dbprefix]]role_sho_uix` (`shortname`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='moodle roles' AUTO_INCREMENT=9 ;

--
-- Dumping data for table `[[dbprefix]]role`
--

INSERT INTO `[[dbprefix]]role` VALUES
(1, '', 'manager', '', 1, 'manager'),
(2, '', 'coursecreator', '', 2, 'coursecreator'),
(3, '', 'editingteacher', '', 3, 'editingteacher'),
(4, '', 'teacher', '', 4, 'teacher'),
(5, '', 'student', '', 5, 'student'),
(6, '', 'guest', '', 6, 'guest'),
(7, '', 'user', '', 7, 'user'),
(8, '', 'frontpage', '', 8, 'frontpage');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]role_allow_assign`
--

CREATE TABLE `[[dbprefix]]role_allow_assign` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `roleid` bigint(10) NOT NULL DEFAULT '0',
  `allowassign` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]rolealloassi_rolall_uix` (`roleid`,`allowassign`),
  KEY `[[dbprefix]]rolealloassi_rol_ix` (`roleid`),
  KEY `[[dbprefix]]rolealloassi_all_ix` (`allowassign`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='this defines what role can assign what role' AUTO_INCREMENT=8 ;

--
-- Dumping data for table `[[dbprefix]]role_allow_assign`
--

INSERT INTO `[[dbprefix]]role_allow_assign` VALUES
(1, 1, 1),
(2, 1, 2),
(3, 1, 3),
(4, 1, 4),
(5, 1, 5),
(6, 3, 4),
(7, 3, 5);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]role_allow_override`
--

CREATE TABLE `[[dbprefix]]role_allow_override` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `roleid` bigint(10) NOT NULL DEFAULT '0',
  `allowoverride` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]rolealloover_rolall_uix` (`roleid`,`allowoverride`),
  KEY `[[dbprefix]]rolealloover_rol_ix` (`roleid`),
  KEY `[[dbprefix]]rolealloover_all_ix` (`allowoverride`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='this defines what role can override what role' AUTO_INCREMENT=12 ;

--
-- Dumping data for table `[[dbprefix]]role_allow_override`
--

INSERT INTO `[[dbprefix]]role_allow_override` VALUES
(1, 1, 1),
(2, 1, 2),
(3, 1, 3),
(4, 1, 4),
(5, 1, 5),
(6, 1, 6),
(7, 1, 7),
(8, 1, 8),
(9, 3, 4),
(10, 3, 5),
(11, 3, 6);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]role_allow_switch`
--

CREATE TABLE `[[dbprefix]]role_allow_switch` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `roleid` bigint(10) NOT NULL,
  `allowswitch` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]rolealloswit_rolall_uix` (`roleid`,`allowswitch`),
  KEY `[[dbprefix]]rolealloswit_rol_ix` (`roleid`),
  KEY `[[dbprefix]]rolealloswit_all_ix` (`allowswitch`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='This table stores which which other roles a user is allowed ' AUTO_INCREMENT=10 ;

--
-- Dumping data for table `[[dbprefix]]role_allow_switch`
--

INSERT INTO `[[dbprefix]]role_allow_switch` VALUES
(1, 1, 3),
(2, 1, 4),
(3, 1, 5),
(4, 1, 6),
(5, 3, 4),
(6, 3, 5),
(7, 3, 6),
(8, 4, 5),
(9, 4, 6);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]role_allow_view`
--

CREATE TABLE `[[dbprefix]]role_allow_view` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `roleid` bigint(10) NOT NULL,
  `allowview` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]rolealloview_rolall_uix` (`roleid`,`allowview`),
  KEY `[[dbprefix]]rolealloview_rol_ix` (`roleid`),
  KEY `[[dbprefix]]rolealloview_all_ix` (`allowview`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='This table stores which which other roles a user is allowed ' AUTO_INCREMENT=25 ;

--
-- Dumping data for table `[[dbprefix]]role_allow_view`
--

INSERT INTO `[[dbprefix]]role_allow_view` VALUES
(1, 1, 1),
(2, 1, 2),
(3, 1, 3),
(4, 1, 4),
(5, 1, 5),
(6, 1, 6),
(7, 1, 7),
(8, 1, 8),
(9, 2, 2),
(10, 2, 3),
(11, 2, 4),
(12, 2, 5),
(13, 3, 2),
(14, 3, 3),
(15, 3, 4),
(16, 3, 5),
(17, 4, 2),
(18, 4, 3),
(19, 4, 4),
(20, 4, 5),
(21, 5, 2),
(22, 5, 3),
(23, 5, 4),
(24, 5, 5);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]role_assignments`
--

CREATE TABLE `[[dbprefix]]role_assignments` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `roleid` bigint(10) NOT NULL DEFAULT '0',
  `contextid` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `modifierid` bigint(10) NOT NULL DEFAULT '0',
  `component` varchar(100) NOT NULL DEFAULT '',
  `itemid` bigint(10) NOT NULL DEFAULT '0',
  `sortorder` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]roleassi_sor_ix` (`sortorder`),
  KEY `[[dbprefix]]roleassi_rolcon_ix` (`roleid`,`contextid`),
  KEY `[[dbprefix]]roleassi_useconrol_ix` (`userid`,`contextid`,`roleid`),
  KEY `[[dbprefix]]roleassi_comiteuse_ix` (`component`,`itemid`,`userid`),
  KEY `[[dbprefix]]roleassi_rol_ix` (`roleid`),
  KEY `[[dbprefix]]roleassi_con_ix` (`contextid`),
  KEY `[[dbprefix]]roleassi_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='assigning roles in different context' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]role_capabilities`
--

CREATE TABLE `[[dbprefix]]role_capabilities` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `contextid` bigint(10) NOT NULL DEFAULT '0',
  `roleid` bigint(10) NOT NULL DEFAULT '0',
  `capability` varchar(255) NOT NULL DEFAULT '',
  `permission` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `modifierid` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]rolecapa_rolconcap_uix` (`roleid`,`contextid`,`capability`),
  KEY `[[dbprefix]]rolecapa_rol_ix` (`roleid`),
  KEY `[[dbprefix]]rolecapa_con_ix` (`contextid`),
  KEY `[[dbprefix]]rolecapa_mod_ix` (`modifierid`),
  KEY `[[dbprefix]]rolecapa_cap_ix` (`capability`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='permission has to be signed, overriding a capability for a p' AUTO_INCREMENT=1286 ;

--
-- Dumping data for table `[[dbprefix]]role_capabilities`
--

INSERT INTO `[[dbprefix]]role_capabilities` VALUES
(1, 1, 1, 'moodle/site:configview', 1, [[timestamp]], 0),
(2, 1, 2, 'moodle/site:configview', 1, [[timestamp]], 0),
(3, 1, 1, 'moodle/site:readallmessages', 1, [[timestamp]], 0),
(4, 1, 3, 'moodle/site:readallmessages', 1, [[timestamp]], 0),
(5, 1, 1, 'moodle/site:manageallmessaging', 1, [[timestamp]], 0),
(6, 1, 1, 'moodle/site:deleteanymessage', 1, [[timestamp]], 0),
(7, 1, 1, 'moodle/site:sendmessage', 1, [[timestamp]], 0),
(8, 1, 7, 'moodle/site:sendmessage', 1, [[timestamp]], 0),
(9, 1, 7, 'moodle/site:deleteownmessage', 1, [[timestamp]], 0),
(10, 1, 1, 'moodle/site:approvecourse', 1, [[timestamp]], 0),
(11, 1, 3, 'moodle/backup:backupcourse', 1, [[timestamp]], 0),
(12, 1, 1, 'moodle/backup:backupcourse', 1, [[timestamp]], 0),
(13, 1, 3, 'moodle/backup:backupsection', 1, [[timestamp]], 0),
(14, 1, 1, 'moodle/backup:backupsection', 1, [[timestamp]], 0),
(15, 1, 3, 'moodle/backup:backupactivity', 1, [[timestamp]], 0),
(16, 1, 1, 'moodle/backup:backupactivity', 1, [[timestamp]], 0),
(17, 1, 3, 'moodle/backup:backuptargethub', 1, [[timestamp]], 0),
(18, 1, 1, 'moodle/backup:backuptargethub', 1, [[timestamp]], 0),
(19, 1, 3, 'moodle/backup:backuptargetimport', 1, [[timestamp]], 0),
(20, 1, 1, 'moodle/backup:backuptargetimport', 1, [[timestamp]], 0),
(21, 1, 3, 'moodle/backup:downloadfile', 1, [[timestamp]], 0),
(22, 1, 1, 'moodle/backup:downloadfile', 1, [[timestamp]], 0),
(23, 1, 3, 'moodle/backup:configure', 1, [[timestamp]], 0),
(24, 1, 1, 'moodle/backup:configure', 1, [[timestamp]], 0),
(25, 1, 1, 'moodle/backup:userinfo', 1, [[timestamp]], 0),
(26, 1, 1, 'moodle/backup:anonymise', 1, [[timestamp]], 0),
(27, 1, 3, 'moodle/restore:restorecourse', 1, [[timestamp]], 0),
(28, 1, 1, 'moodle/restore:restorecourse', 1, [[timestamp]], 0),
(29, 1, 3, 'moodle/restore:restoresection', 1, [[timestamp]], 0),
(30, 1, 1, 'moodle/restore:restoresection', 1, [[timestamp]], 0),
(31, 1, 3, 'moodle/restore:restoreactivity', 1, [[timestamp]], 0),
(32, 1, 1, 'moodle/restore:restoreactivity', 1, [[timestamp]], 0),
(33, 1, 3, 'moodle/restore:viewautomatedfilearea', 1, [[timestamp]], 0),
(34, 1, 1, 'moodle/restore:viewautomatedfilearea', 1, [[timestamp]], 0),
(35, 1, 3, 'moodle/restore:restoretargethub', 1, [[timestamp]], 0),
(36, 1, 1, 'moodle/restore:restoretargethub', 1, [[timestamp]], 0),
(37, 1, 3, 'moodle/restore:restoretargetimport', 1, [[timestamp]], 0),
(38, 1, 1, 'moodle/restore:restoretargetimport', 1, [[timestamp]], 0),
(39, 1, 3, 'moodle/restore:uploadfile', 1, [[timestamp]], 0),
(40, 1, 1, 'moodle/restore:uploadfile', 1, [[timestamp]], 0),
(41, 1, 3, 'moodle/restore:configure', 1, [[timestamp]], 0),
(42, 1, 1, 'moodle/restore:configure', 1, [[timestamp]], 0),
(43, 1, 2, 'moodle/restore:rolldates', 1, [[timestamp]], 0),
(44, 1, 1, 'moodle/restore:rolldates', 1, [[timestamp]], 0),
(45, 1, 1, 'moodle/restore:userinfo', 1, [[timestamp]], 0),
(46, 1, 1, 'moodle/restore:createuser', 1, [[timestamp]], 0),
(47, 1, 3, 'moodle/site:manageblocks', 1, [[timestamp]], 0),
(48, 1, 1, 'moodle/site:manageblocks', 1, [[timestamp]], 0),
(49, 1, 3, 'moodle/site:accessallgroups', 1, [[timestamp]], 0),
(50, 1, 1, 'moodle/site:accessallgroups', 1, [[timestamp]], 0),
(51, 1, 4, 'moodle/site:viewfullnames', 1, [[timestamp]], 0),
(52, 1, 3, 'moodle/site:viewfullnames', 1, [[timestamp]], 0),
(53, 1, 1, 'moodle/site:viewfullnames', 1, [[timestamp]], 0),
(54, 1, 4, 'moodle/site:viewuseridentity', 1, [[timestamp]], 0),
(55, 1, 3, 'moodle/site:viewuseridentity', 1, [[timestamp]], 0),
(56, 1, 1, 'moodle/site:viewuseridentity', 1, [[timestamp]], 0),
(57, 1, 4, 'moodle/site:viewreports', 1, [[timestamp]], 0),
(58, 1, 3, 'moodle/site:viewreports', 1, [[timestamp]], 0),
(59, 1, 1, 'moodle/site:viewreports', 1, [[timestamp]], 0),
(60, 1, 3, 'moodle/site:trustcontent', 1, [[timestamp]], 0),
(61, 1, 1, 'moodle/site:trustcontent', 1, [[timestamp]], 0),
(62, 1, 1, 'moodle/site:uploadusers', 1, [[timestamp]], 0),
(63, 1, 3, 'moodle/filter:manage', 1, [[timestamp]], 0),
(64, 1, 1, 'moodle/filter:manage', 1, [[timestamp]], 0),
(65, 1, 1, 'moodle/user:create', 1, [[timestamp]], 0),
(66, 1, 1, 'moodle/user:delete', 1, [[timestamp]], 0),
(67, 1, 1, 'moodle/user:update', 1, [[timestamp]], 0),
(68, 1, 6, 'moodle/user:viewdetails', 1, [[timestamp]], 0),
(69, 1, 5, 'moodle/user:viewdetails', 1, [[timestamp]], 0),
(70, 1, 4, 'moodle/user:viewdetails', 1, [[timestamp]], 0),
(71, 1, 3, 'moodle/user:viewdetails', 1, [[timestamp]], 0),
(72, 1, 1, 'moodle/user:viewdetails', 1, [[timestamp]], 0),
(73, 1, 1, 'moodle/user:viewalldetails', 1, [[timestamp]], 0),
(74, 1, 1, 'moodle/user:viewlastip', 1, [[timestamp]], 0),
(75, 1, 4, 'moodle/user:viewhiddendetails', 1, [[timestamp]], 0),
(76, 1, 3, 'moodle/user:viewhiddendetails', 1, [[timestamp]], 0),
(77, 1, 1, 'moodle/user:viewhiddendetails', 1, [[timestamp]], 0),
(78, 1, 1, 'moodle/user:loginas', 1, [[timestamp]], 0),
(79, 1, 1, 'moodle/user:managesyspages', 1, [[timestamp]], 0),
(80, 1, 7, 'moodle/user:manageownblocks', 1, [[timestamp]], 0),
(81, 1, 7, 'moodle/user:manageownfiles', 1, [[timestamp]], 0),
(82, 1, 1, 'moodle/my:configsyspages', 1, [[timestamp]], 0),
(83, 1, 3, 'moodle/role:assign', 1, [[timestamp]], 0),
(84, 1, 1, 'moodle/role:assign', 1, [[timestamp]], 0),
(85, 1, 4, 'moodle/role:review', 1, [[timestamp]], 0),
(86, 1, 3, 'moodle/role:review', 1, [[timestamp]], 0),
(87, 1, 1, 'moodle/role:review', 1, [[timestamp]], 0),
(88, 1, 1, 'moodle/role:override', 1, [[timestamp]], 0),
(89, 1, 3, 'moodle/role:safeoverride', 1, [[timestamp]], 0),
(90, 1, 1, 'moodle/role:manage', 1, [[timestamp]], 0),
(91, 1, 3, 'moodle/role:switchroles', 1, [[timestamp]], 0),
(92, 1, 1, 'moodle/role:switchroles', 1, [[timestamp]], 0),
(93, 1, 1, 'moodle/category:manage', 1, [[timestamp]], 0),
(94, 1, 2, 'moodle/category:viewhiddencategories', 1, [[timestamp]], 0),
(95, 1, 1, 'moodle/category:viewhiddencategories', 1, [[timestamp]], 0),
(96, 1, 1, 'moodle/cohort:manage', 1, [[timestamp]], 0),
(97, 1, 1, 'moodle/cohort:assign', 1, [[timestamp]], 0),
(98, 1, 3, 'moodle/cohort:view', 1, [[timestamp]], 0),
(99, 1, 1, 'moodle/cohort:view', 1, [[timestamp]], 0),
(100, 1, 2, 'moodle/course:create', 1, [[timestamp]], 0),
(101, 1, 1, 'moodle/course:create', 1, [[timestamp]], 0),
(102, 1, 7, 'moodle/course:request', 1, [[timestamp]], 0),
(103, 1, 1, 'moodle/course:delete', 1, [[timestamp]], 0),
(104, 1, 3, 'moodle/course:update', 1, [[timestamp]], 0),
(105, 1, 1, 'moodle/course:update', 1, [[timestamp]], 0),
(106, 1, 1, 'moodle/course:view', 1, [[timestamp]], 0),
(107, 1, 3, 'moodle/course:enrolreview', 1, [[timestamp]], 0),
(108, 1, 1, 'moodle/course:enrolreview', 1, [[timestamp]], 0),
(109, 1, 3, 'moodle/course:enrolconfig', 1, [[timestamp]], 0),
(110, 1, 1, 'moodle/course:enrolconfig', 1, [[timestamp]], 0),
(111, 1, 3, 'moodle/course:reviewotherusers', 1, [[timestamp]], 0),
(112, 1, 1, 'moodle/course:reviewotherusers', 1, [[timestamp]], 0),
(113, 1, 4, 'moodle/course:bulkmessaging', 1, [[timestamp]], 0),
(114, 1, 3, 'moodle/course:bulkmessaging', 1, [[timestamp]], 0),
(115, 1, 1, 'moodle/course:bulkmessaging', 1, [[timestamp]], 0),
(116, 1, 4, 'moodle/course:viewhiddenuserfields', 1, [[timestamp]], 0),
(117, 1, 3, 'moodle/course:viewhiddenuserfields', 1, [[timestamp]], 0),
(118, 1, 1, 'moodle/course:viewhiddenuserfields', 1, [[timestamp]], 0),
(119, 1, 2, 'moodle/course:viewhiddencourses', 1, [[timestamp]], 0),
(120, 1, 4, 'moodle/course:viewhiddencourses', 1, [[timestamp]], 0),
(121, 1, 3, 'moodle/course:viewhiddencourses', 1, [[timestamp]], 0),
(122, 1, 1, 'moodle/course:viewhiddencourses', 1, [[timestamp]], 0),
(123, 1, 3, 'moodle/course:visibility', 1, [[timestamp]], 0),
(124, 1, 1, 'moodle/course:visibility', 1, [[timestamp]], 0),
(125, 1, 3, 'moodle/course:managefiles', 1, [[timestamp]], 0),
(126, 1, 1, 'moodle/course:managefiles', 1, [[timestamp]], 0),
(127, 1, 1, 'moodle/course:ignoreavailabilityrestrictions', 1, [[timestamp]], 0),
(128, 1, 2, 'moodle/course:ignoreavailabilityrestrictions', 1, [[timestamp]], 0),
(129, 1, 3, 'moodle/course:ignoreavailabilityrestrictions', 1, [[timestamp]], 0),
(130, 1, 4, 'moodle/course:ignoreavailabilityrestrictions', 1, [[timestamp]], 0),
(131, 1, 3, 'moodle/course:manageactivities', 1, [[timestamp]], 0),
(132, 1, 1, 'moodle/course:manageactivities', 1, [[timestamp]], 0),
(133, 1, 3, 'moodle/course:activityvisibility', 1, [[timestamp]], 0),
(134, 1, 1, 'moodle/course:activityvisibility', 1, [[timestamp]], 0),
(135, 1, 4, 'moodle/course:viewhiddenactivities', 1, [[timestamp]], 0),
(136, 1, 3, 'moodle/course:viewhiddenactivities', 1, [[timestamp]], 0),
(137, 1, 1, 'moodle/course:viewhiddenactivities', 1, [[timestamp]], 0),
(138, 1, 5, 'moodle/course:viewparticipants', 1, [[timestamp]], 0),
(139, 1, 4, 'moodle/course:viewparticipants', 1, [[timestamp]], 0),
(140, 1, 3, 'moodle/course:viewparticipants', 1, [[timestamp]], 0),
(141, 1, 1, 'moodle/course:viewparticipants', 1, [[timestamp]], 0),
(142, 1, 3, 'moodle/course:changefullname', 1, [[timestamp]], 0),
(143, 1, 1, 'moodle/course:changefullname', 1, [[timestamp]], 0),
(144, 1, 3, 'moodle/course:changeshortname', 1, [[timestamp]], 0),
(145, 1, 1, 'moodle/course:changeshortname', 1, [[timestamp]], 0),
(146, 1, 3, 'moodle/course:renameroles', 1, [[timestamp]], 0),
(147, 1, 1, 'moodle/course:renameroles', 1, [[timestamp]], 0),
(148, 1, 3, 'moodle/course:changeidnumber', 1, [[timestamp]], 0),
(149, 1, 1, 'moodle/course:changeidnumber', 1, [[timestamp]], 0),
(150, 1, 3, 'moodle/course:changecategory', 1, [[timestamp]], 0),
(151, 1, 1, 'moodle/course:changecategory', 1, [[timestamp]], 0),
(152, 1, 3, 'moodle/course:changesummary', 1, [[timestamp]], 0),
(153, 1, 1, 'moodle/course:changesummary', 1, [[timestamp]], 0),
(154, 1, 3, 'moodle/course:setforcedlanguage', 1, [[timestamp]], 0),
(155, 1, 1, 'moodle/course:setforcedlanguage', 1, [[timestamp]], 0),
(156, 1, 1, 'moodle/site:viewparticipants', 1, [[timestamp]], 0),
(157, 1, 5, 'moodle/course:isincompletionreports', 1, [[timestamp]], 0),
(158, 1, 5, 'moodle/course:viewscales', 1, [[timestamp]], 0),
(159, 1, 4, 'moodle/course:viewscales', 1, [[timestamp]], 0),
(160, 1, 3, 'moodle/course:viewscales', 1, [[timestamp]], 0),
(161, 1, 1, 'moodle/course:viewscales', 1, [[timestamp]], 0),
(162, 1, 3, 'moodle/course:managescales', 1, [[timestamp]], 0),
(163, 1, 1, 'moodle/course:managescales', 1, [[timestamp]], 0),
(164, 1, 3, 'moodle/course:managegroups', 1, [[timestamp]], 0),
(165, 1, 1, 'moodle/course:managegroups', 1, [[timestamp]], 0),
(166, 1, 3, 'moodle/course:reset', 1, [[timestamp]], 0),
(167, 1, 1, 'moodle/course:reset', 1, [[timestamp]], 0),
(168, 1, 3, 'moodle/course:viewsuspendedusers', 1, [[timestamp]], 0),
(169, 1, 1, 'moodle/course:viewsuspendedusers', 1, [[timestamp]], 0),
(170, 1, 1, 'moodle/course:tag', 1, [[timestamp]], 0),
(171, 1, 3, 'moodle/course:tag', 1, [[timestamp]], 0),
(172, 1, 6, 'moodle/blog:view', 1, [[timestamp]], 0),
(173, 1, 7, 'moodle/blog:view', 1, [[timestamp]], 0),
(174, 1, 5, 'moodle/blog:view', 1, [[timestamp]], 0),
(175, 1, 4, 'moodle/blog:view', 1, [[timestamp]], 0),
(176, 1, 3, 'moodle/blog:view', 1, [[timestamp]], 0),
(177, 1, 1, 'moodle/blog:view', 1, [[timestamp]], 0),
(178, 1, 6, 'moodle/blog:search', 1, [[timestamp]], 0),
(179, 1, 7, 'moodle/blog:search', 1, [[timestamp]], 0),
(180, 1, 5, 'moodle/blog:search', 1, [[timestamp]], 0),
(181, 1, 4, 'moodle/blog:search', 1, [[timestamp]], 0),
(182, 1, 3, 'moodle/blog:search', 1, [[timestamp]], 0),
(183, 1, 1, 'moodle/blog:search', 1, [[timestamp]], 0),
(184, 1, 1, 'moodle/blog:viewdrafts', 1, [[timestamp]], 0),
(185, 1, 7, 'moodle/blog:create', 1, [[timestamp]], 0),
(186, 1, 1, 'moodle/blog:create', 1, [[timestamp]], 0),
(187, 1, 4, 'moodle/blog:manageentries', 1, [[timestamp]], 0),
(188, 1, 3, 'moodle/blog:manageentries', 1, [[timestamp]], 0),
(189, 1, 1, 'moodle/blog:manageentries', 1, [[timestamp]], 0),
(190, 1, 5, 'moodle/blog:manageexternal', 1, [[timestamp]], 0),
(191, 1, 7, 'moodle/blog:manageexternal', 1, [[timestamp]], 0),
(192, 1, 4, 'moodle/blog:manageexternal', 1, [[timestamp]], 0),
(193, 1, 3, 'moodle/blog:manageexternal', 1, [[timestamp]], 0),
(194, 1, 1, 'moodle/blog:manageexternal', 1, [[timestamp]], 0),
(195, 1, 7, 'moodle/calendar:manageownentries', 1, [[timestamp]], 0),
(196, 1, 1, 'moodle/calendar:manageownentries', 1, [[timestamp]], 0),
(197, 1, 4, 'moodle/calendar:managegroupentries', 1, [[timestamp]], 0),
(198, 1, 3, 'moodle/calendar:managegroupentries', 1, [[timestamp]], 0),
(199, 1, 1, 'moodle/calendar:managegroupentries', 1, [[timestamp]], 0),
(200, 1, 4, 'moodle/calendar:manageentries', 1, [[timestamp]], 0),
(201, 1, 3, 'moodle/calendar:manageentries', 1, [[timestamp]], 0),
(202, 1, 1, 'moodle/calendar:manageentries', 1, [[timestamp]], 0),
(203, 1, 1, 'moodle/user:editprofile', 1, [[timestamp]], 0),
(204, 1, 6, 'moodle/user:editownprofile', -1000, [[timestamp]], 0),
(205, 1, 7, 'moodle/user:editownprofile', 1, [[timestamp]], 0),
(206, 1, 1, 'moodle/user:editownprofile', 1, [[timestamp]], 0),
(207, 1, 6, 'moodle/user:changeownpassword', -1000, [[timestamp]], 0),
(208, 1, 7, 'moodle/user:changeownpassword', 1, [[timestamp]], 0),
(209, 1, 1, 'moodle/user:changeownpassword', 1, [[timestamp]], 0),
(210, 1, 5, 'moodle/user:readuserposts', 1, [[timestamp]], 0),
(211, 1, 4, 'moodle/user:readuserposts', 1, [[timestamp]], 0),
(212, 1, 3, 'moodle/user:readuserposts', 1, [[timestamp]], 0),
(213, 1, 1, 'moodle/user:readuserposts', 1, [[timestamp]], 0),
(214, 1, 5, 'moodle/user:readuserblogs', 1, [[timestamp]], 0),
(215, 1, 4, 'moodle/user:readuserblogs', 1, [[timestamp]], 0),
(216, 1, 3, 'moodle/user:readuserblogs', 1, [[timestamp]], 0),
(217, 1, 1, 'moodle/user:readuserblogs', 1, [[timestamp]], 0),
(218, 1, 1, 'moodle/user:editmessageprofile', 1, [[timestamp]], 0),
(219, 1, 6, 'moodle/user:editownmessageprofile', -1000, [[timestamp]], 0),
(220, 1, 7, 'moodle/user:editownmessageprofile', 1, [[timestamp]], 0),
(221, 1, 1, 'moodle/user:editownmessageprofile', 1, [[timestamp]], 0),
(222, 1, 3, 'moodle/question:managecategory', 1, [[timestamp]], 0),
(223, 1, 1, 'moodle/question:managecategory', 1, [[timestamp]], 0),
(224, 1, 3, 'moodle/question:add', 1, [[timestamp]], 0),
(225, 1, 1, 'moodle/question:add', 1, [[timestamp]], 0),
(226, 1, 3, 'moodle/question:editmine', 1, [[timestamp]], 0),
(227, 1, 1, 'moodle/question:editmine', 1, [[timestamp]], 0),
(228, 1, 3, 'moodle/question:editall', 1, [[timestamp]], 0),
(229, 1, 1, 'moodle/question:editall', 1, [[timestamp]], 0),
(230, 1, 3, 'moodle/question:viewmine', 1, [[timestamp]], 0),
(231, 1, 1, 'moodle/question:viewmine', 1, [[timestamp]], 0),
(232, 1, 3, 'moodle/question:viewall', 1, [[timestamp]], 0),
(233, 1, 1, 'moodle/question:viewall', 1, [[timestamp]], 0),
(234, 1, 3, 'moodle/question:usemine', 1, [[timestamp]], 0),
(235, 1, 1, 'moodle/question:usemine', 1, [[timestamp]], 0),
(236, 1, 3, 'moodle/question:useall', 1, [[timestamp]], 0),
(237, 1, 1, 'moodle/question:useall', 1, [[timestamp]], 0),
(238, 1, 3, 'moodle/question:movemine', 1, [[timestamp]], 0),
(239, 1, 1, 'moodle/question:movemine', 1, [[timestamp]], 0),
(240, 1, 3, 'moodle/question:moveall', 1, [[timestamp]], 0),
(241, 1, 1, 'moodle/question:moveall', 1, [[timestamp]], 0),
(242, 1, 1, 'moodle/question:config', 1, [[timestamp]], 0),
(243, 1, 5, 'moodle/question:flag', 1, [[timestamp]], 0),
(244, 1, 4, 'moodle/question:flag', 1, [[timestamp]], 0),
(245, 1, 3, 'moodle/question:flag', 1, [[timestamp]], 0),
(246, 1, 1, 'moodle/question:flag', 1, [[timestamp]], 0),
(247, 1, 3, 'moodle/question:tagmine', 1, [[timestamp]], 0),
(248, 1, 1, 'moodle/question:tagmine', 1, [[timestamp]], 0),
(249, 1, 3, 'moodle/question:tagall', 1, [[timestamp]], 0),
(250, 1, 1, 'moodle/question:tagall', 1, [[timestamp]], 0),
(251, 1, 4, 'moodle/site:doclinks', 1, [[timestamp]], 0),
(252, 1, 3, 'moodle/site:doclinks', 1, [[timestamp]], 0),
(253, 1, 1, 'moodle/site:doclinks', 1, [[timestamp]], 0),
(254, 1, 3, 'moodle/course:sectionvisibility', 1, [[timestamp]], 0),
(255, 1, 1, 'moodle/course:sectionvisibility', 1, [[timestamp]], 0),
(256, 1, 3, 'moodle/course:useremail', 1, [[timestamp]], 0),
(257, 1, 1, 'moodle/course:useremail', 1, [[timestamp]], 0),
(258, 1, 3, 'moodle/course:viewhiddensections', 1, [[timestamp]], 0),
(259, 1, 1, 'moodle/course:viewhiddensections', 1, [[timestamp]], 0),
(260, 1, 3, 'moodle/course:setcurrentsection', 1, [[timestamp]], 0),
(261, 1, 1, 'moodle/course:setcurrentsection', 1, [[timestamp]], 0),
(262, 1, 3, 'moodle/course:movesections', 1, [[timestamp]], 0),
(263, 1, 1, 'moodle/course:movesections', 1, [[timestamp]], 0),
(264, 1, 4, 'moodle/grade:viewall', 1, [[timestamp]], 0),
(265, 1, 3, 'moodle/grade:viewall', 1, [[timestamp]], 0),
(266, 1, 1, 'moodle/grade:viewall', 1, [[timestamp]], 0),
(267, 1, 5, 'moodle/grade:view', 1, [[timestamp]], 0),
(268, 1, 4, 'moodle/grade:viewhidden', 1, [[timestamp]], 0),
(269, 1, 3, 'moodle/grade:viewhidden', 1, [[timestamp]], 0),
(270, 1, 1, 'moodle/grade:viewhidden', 1, [[timestamp]], 0),
(271, 1, 3, 'moodle/grade:import', 1, [[timestamp]], 0),
(272, 1, 1, 'moodle/grade:import', 1, [[timestamp]], 0),
(273, 1, 4, 'moodle/grade:export', 1, [[timestamp]], 0),
(274, 1, 3, 'moodle/grade:export', 1, [[timestamp]], 0),
(275, 1, 1, 'moodle/grade:export', 1, [[timestamp]], 0),
(276, 1, 3, 'moodle/grade:manage', 1, [[timestamp]], 0),
(277, 1, 1, 'moodle/grade:manage', 1, [[timestamp]], 0),
(278, 1, 3, 'moodle/grade:edit', 1, [[timestamp]], 0),
(279, 1, 1, 'moodle/grade:edit', 1, [[timestamp]], 0),
(280, 1, 3, 'moodle/grade:managegradingforms', 1, [[timestamp]], 0),
(281, 1, 1, 'moodle/grade:managegradingforms', 1, [[timestamp]], 0),
(282, 1, 1, 'moodle/grade:sharegradingforms', 1, [[timestamp]], 0),
(283, 1, 1, 'moodle/grade:managesharedforms', 1, [[timestamp]], 0),
(284, 1, 3, 'moodle/grade:manageoutcomes', 1, [[timestamp]], 0),
(285, 1, 1, 'moodle/grade:manageoutcomes', 1, [[timestamp]], 0),
(286, 1, 3, 'moodle/grade:manageletters', 1, [[timestamp]], 0),
(287, 1, 1, 'moodle/grade:manageletters', 1, [[timestamp]], 0),
(288, 1, 3, 'moodle/grade:hide', 1, [[timestamp]], 0),
(289, 1, 1, 'moodle/grade:hide', 1, [[timestamp]], 0),
(290, 1, 3, 'moodle/grade:lock', 1, [[timestamp]], 0),
(291, 1, 1, 'moodle/grade:lock', 1, [[timestamp]], 0),
(292, 1, 3, 'moodle/grade:unlock', 1, [[timestamp]], 0),
(293, 1, 1, 'moodle/grade:unlock', 1, [[timestamp]], 0),
(294, 1, 7, 'moodle/my:manageblocks', 1, [[timestamp]], 0),
(295, 1, 4, 'moodle/notes:view', 1, [[timestamp]], 0),
(296, 1, 3, 'moodle/notes:view', 1, [[timestamp]], 0),
(297, 1, 1, 'moodle/notes:view', 1, [[timestamp]], 0),
(298, 1, 4, 'moodle/notes:manage', 1, [[timestamp]], 0),
(299, 1, 3, 'moodle/notes:manage', 1, [[timestamp]], 0),
(300, 1, 1, 'moodle/notes:manage', 1, [[timestamp]], 0),
(301, 1, 1, 'moodle/tag:manage', 1, [[timestamp]], 0),
(302, 1, 1, 'moodle/tag:edit', 1, [[timestamp]], 0),
(303, 1, 7, 'moodle/tag:flag', 1, [[timestamp]], 0),
(304, 1, 4, 'moodle/tag:editblocks', 1, [[timestamp]], 0),
(305, 1, 3, 'moodle/tag:editblocks', 1, [[timestamp]], 0),
(306, 1, 1, 'moodle/tag:editblocks', 1, [[timestamp]], 0),
(307, 1, 6, 'moodle/block:view', 1, [[timestamp]], 0),
(308, 1, 7, 'moodle/block:view', 1, [[timestamp]], 0),
(309, 1, 5, 'moodle/block:view', 1, [[timestamp]], 0),
(310, 1, 4, 'moodle/block:view', 1, [[timestamp]], 0),
(311, 1, 3, 'moodle/block:view', 1, [[timestamp]], 0),
(312, 1, 3, 'moodle/block:edit', 1, [[timestamp]], 0),
(313, 1, 1, 'moodle/block:edit', 1, [[timestamp]], 0),
(314, 1, 7, 'moodle/portfolio:export', 1, [[timestamp]], 0),
(315, 1, 5, 'moodle/portfolio:export', 1, [[timestamp]], 0),
(316, 1, 4, 'moodle/portfolio:export', 1, [[timestamp]], 0),
(317, 1, 3, 'moodle/portfolio:export', 1, [[timestamp]], 0),
(318, 1, 8, 'moodle/comment:view', 1, [[timestamp]], 0),
(319, 1, 6, 'moodle/comment:view', 1, [[timestamp]], 0),
(320, 1, 7, 'moodle/comment:view', 1, [[timestamp]], 0),
(321, 1, 5, 'moodle/comment:view', 1, [[timestamp]], 0),
(322, 1, 4, 'moodle/comment:view', 1, [[timestamp]], 0),
(323, 1, 3, 'moodle/comment:view', 1, [[timestamp]], 0),
(324, 1, 1, 'moodle/comment:view', 1, [[timestamp]], 0),
(325, 1, 7, 'moodle/comment:post', 1, [[timestamp]], 0),
(326, 1, 5, 'moodle/comment:post', 1, [[timestamp]], 0),
(327, 1, 4, 'moodle/comment:post', 1, [[timestamp]], 0),
(328, 1, 3, 'moodle/comment:post', 1, [[timestamp]], 0),
(329, 1, 1, 'moodle/comment:post', 1, [[timestamp]], 0),
(330, 1, 3, 'moodle/comment:delete', 1, [[timestamp]], 0),
(331, 1, 1, 'moodle/comment:delete', 1, [[timestamp]], 0),
(332, 1, 1, 'moodle/webservice:createtoken', 1, [[timestamp]], 0),
(333, 1, 7, 'moodle/webservice:createmobiletoken', 1, [[timestamp]], 0),
(334, 1, 7, 'moodle/rating:view', 1, [[timestamp]], 0),
(335, 1, 5, 'moodle/rating:view', 1, [[timestamp]], 0),
(336, 1, 4, 'moodle/rating:view', 1, [[timestamp]], 0),
(337, 1, 3, 'moodle/rating:view', 1, [[timestamp]], 0),
(338, 1, 1, 'moodle/rating:view', 1, [[timestamp]], 0),
(339, 1, 7, 'moodle/rating:viewany', 1, [[timestamp]], 0),
(340, 1, 5, 'moodle/rating:viewany', 1, [[timestamp]], 0),
(341, 1, 4, 'moodle/rating:viewany', 1, [[timestamp]], 0),
(342, 1, 3, 'moodle/rating:viewany', 1, [[timestamp]], 0),
(343, 1, 1, 'moodle/rating:viewany', 1, [[timestamp]], 0),
(344, 1, 7, 'moodle/rating:viewall', 1, [[timestamp]], 0),
(345, 1, 5, 'moodle/rating:viewall', 1, [[timestamp]], 0),
(346, 1, 4, 'moodle/rating:viewall', 1, [[timestamp]], 0),
(347, 1, 3, 'moodle/rating:viewall', 1, [[timestamp]], 0),
(348, 1, 1, 'moodle/rating:viewall', 1, [[timestamp]], 0),
(349, 1, 7, 'moodle/rating:rate', 1, [[timestamp]], 0),
(350, 1, 5, 'moodle/rating:rate', 1, [[timestamp]], 0),
(351, 1, 4, 'moodle/rating:rate', 1, [[timestamp]], 0),
(352, 1, 3, 'moodle/rating:rate', 1, [[timestamp]], 0),
(353, 1, 1, 'moodle/rating:rate', 1, [[timestamp]], 0),
(354, 1, 1, 'moodle/course:publish', 1, [[timestamp]], 0),
(355, 1, 4, 'moodle/course:markcomplete', 1, [[timestamp]], 0),
(356, 1, 3, 'moodle/course:markcomplete', 1, [[timestamp]], 0),
(357, 1, 1, 'moodle/course:markcomplete', 1, [[timestamp]], 0),
(358, 1, 4, 'moodle/course:overridecompletion', 1, [[timestamp]], 0),
(359, 1, 3, 'moodle/course:overridecompletion', 1, [[timestamp]], 0),
(360, 1, 1, 'moodle/course:overridecompletion', 1, [[timestamp]], 0),
(361, 1, 1, 'moodle/community:add', 1, [[timestamp]], 0),
(362, 1, 4, 'moodle/community:add', 1, [[timestamp]], 0),
(363, 1, 3, 'moodle/community:add', 1, [[timestamp]], 0),
(364, 1, 1, 'moodle/community:download', 1, [[timestamp]], 0),
(365, 1, 3, 'moodle/community:download', 1, [[timestamp]], 0),
(366, 1, 1, 'moodle/badges:manageglobalsettings', 1, [[timestamp]], 0),
(367, 1, 7, 'moodle/badges:viewbadges', 1, [[timestamp]], 0),
(368, 1, 7, 'moodle/badges:manageownbadges', 1, [[timestamp]], 0),
(369, 1, 7, 'moodle/badges:viewotherbadges', 1, [[timestamp]], 0),
(370, 1, 7, 'moodle/badges:earnbadge', 1, [[timestamp]], 0),
(371, 1, 1, 'moodle/badges:createbadge', 1, [[timestamp]], 0),
(372, 1, 3, 'moodle/badges:createbadge', 1, [[timestamp]], 0),
(373, 1, 1, 'moodle/badges:deletebadge', 1, [[timestamp]], 0),
(374, 1, 3, 'moodle/badges:deletebadge', 1, [[timestamp]], 0),
(375, 1, 1, 'moodle/badges:configuredetails', 1, [[timestamp]], 0),
(376, 1, 3, 'moodle/badges:configuredetails', 1, [[timestamp]], 0),
(377, 1, 1, 'moodle/badges:configurecriteria', 1, [[timestamp]], 0),
(378, 1, 3, 'moodle/badges:configurecriteria', 1, [[timestamp]], 0),
(379, 1, 1, 'moodle/badges:configuremessages', 1, [[timestamp]], 0),
(380, 1, 3, 'moodle/badges:configuremessages', 1, [[timestamp]], 0),
(381, 1, 1, 'moodle/badges:awardbadge', 1, [[timestamp]], 0),
(382, 1, 4, 'moodle/badges:awardbadge', 1, [[timestamp]], 0),
(383, 1, 3, 'moodle/badges:awardbadge', 1, [[timestamp]], 0),
(384, 1, 1, 'moodle/badges:revokebadge', 1, [[timestamp]], 0),
(385, 1, 4, 'moodle/badges:revokebadge', 1, [[timestamp]], 0),
(386, 1, 3, 'moodle/badges:revokebadge', 1, [[timestamp]], 0),
(387, 1, 1, 'moodle/badges:viewawarded', 1, [[timestamp]], 0),
(388, 1, 4, 'moodle/badges:viewawarded', 1, [[timestamp]], 0),
(389, 1, 3, 'moodle/badges:viewawarded', 1, [[timestamp]], 0),
(390, 1, 6, 'moodle/search:query', 1, [[timestamp]], 0),
(391, 1, 7, 'moodle/search:query', 1, [[timestamp]], 0),
(392, 1, 5, 'moodle/search:query', 1, [[timestamp]], 0),
(393, 1, 4, 'moodle/search:query', 1, [[timestamp]], 0),
(394, 1, 3, 'moodle/search:query', 1, [[timestamp]], 0),
(395, 1, 1, 'moodle/search:query', 1, [[timestamp]], 0),
(396, 1, 1, 'moodle/competency:competencymanage', 1, [[timestamp]], 0),
(397, 1, 7, 'moodle/competency:competencyview', 1, [[timestamp]], 0),
(398, 1, 3, 'moodle/competency:competencygrade', 1, [[timestamp]], 0),
(399, 1, 4, 'moodle/competency:competencygrade', 1, [[timestamp]], 0),
(400, 1, 1, 'moodle/competency:competencygrade', 1, [[timestamp]], 0),
(401, 1, 3, 'moodle/competency:coursecompetencymanage', 1, [[timestamp]], 0),
(402, 1, 1, 'moodle/competency:coursecompetencymanage', 1, [[timestamp]], 0),
(403, 1, 1, 'moodle/competency:coursecompetencyconfigure', 1, [[timestamp]], 0),
(404, 1, 5, 'moodle/competency:coursecompetencygradable', 1, [[timestamp]], 0),
(405, 1, 7, 'moodle/competency:coursecompetencyview', 1, [[timestamp]], 0),
(406, 1, 1, 'moodle/competency:planmanage', 1, [[timestamp]], 0),
(407, 1, 1, 'moodle/competency:planmanagedraft', 1, [[timestamp]], 0),
(408, 1, 1, 'moodle/competency:planview', 1, [[timestamp]], 0),
(409, 1, 1, 'moodle/competency:planviewdraft', 1, [[timestamp]], 0),
(410, 1, 7, 'moodle/competency:planviewown', 1, [[timestamp]], 0),
(411, 1, 1, 'moodle/competency:planrequestreview', 1, [[timestamp]], 0),
(412, 1, 7, 'moodle/competency:planrequestreviewown', 1, [[timestamp]], 0),
(413, 1, 1, 'moodle/competency:planreview', 1, [[timestamp]], 0),
(414, 1, 1, 'moodle/competency:plancomment', 1, [[timestamp]], 0),
(415, 1, 7, 'moodle/competency:plancommentown', 1, [[timestamp]], 0),
(416, 1, 1, 'moodle/competency:usercompetencyview', 1, [[timestamp]], 0),
(417, 1, 3, 'moodle/competency:usercompetencyview', 1, [[timestamp]], 0),
(418, 1, 4, 'moodle/competency:usercompetencyview', 1, [[timestamp]], 0),
(419, 1, 1, 'moodle/competency:usercompetencyrequestreview', 1, [[timestamp]], 0),
(420, 1, 7, 'moodle/competency:usercompetencyrequestreviewown', 1, [[timestamp]], 0),
(421, 1, 1, 'moodle/competency:usercompetencyreview', 1, [[timestamp]], 0),
(422, 1, 1, 'moodle/competency:usercompetencycomment', 1, [[timestamp]], 0),
(423, 1, 7, 'moodle/competency:usercompetencycommentown', 1, [[timestamp]], 0),
(424, 1, 1, 'moodle/competency:templatemanage', 1, [[timestamp]], 0),
(425, 1, 4, 'moodle/analytics:listinsights', 1, [[timestamp]], 0),
(426, 1, 3, 'moodle/analytics:listinsights', 1, [[timestamp]], 0),
(427, 1, 1, 'moodle/analytics:listinsights', 1, [[timestamp]], 0),
(428, 1, 1, 'moodle/analytics:managemodels', 1, [[timestamp]], 0),
(429, 1, 1, 'moodle/competency:templateview', 1, [[timestamp]], 0),
(430, 1, 1, 'moodle/competency:userevidencemanage', 1, [[timestamp]], 0),
(431, 1, 7, 'moodle/competency:userevidencemanageown', 1, [[timestamp]], 0),
(432, 1, 1, 'moodle/competency:userevidenceview', 1, [[timestamp]], 0),
(433, 1, 6, 'mod/assign:view', 1, [[timestamp]], 0),
(434, 1, 5, 'mod/assign:view', 1, [[timestamp]], 0),
(435, 1, 4, 'mod/assign:view', 1, [[timestamp]], 0),
(436, 1, 3, 'mod/assign:view', 1, [[timestamp]], 0),
(437, 1, 1, 'mod/assign:view', 1, [[timestamp]], 0),
(438, 1, 5, 'mod/assign:submit', 1, [[timestamp]], 0),
(439, 1, 4, 'mod/assign:grade', 1, [[timestamp]], 0),
(440, 1, 3, 'mod/assign:grade', 1, [[timestamp]], 0),
(441, 1, 1, 'mod/assign:grade', 1, [[timestamp]], 0),
(442, 1, 4, 'mod/assign:exportownsubmission', 1, [[timestamp]], 0),
(443, 1, 3, 'mod/assign:exportownsubmission', 1, [[timestamp]], 0),
(444, 1, 1, 'mod/assign:exportownsubmission', 1, [[timestamp]], 0),
(445, 1, 5, 'mod/assign:exportownsubmission', 1, [[timestamp]], 0),
(446, 1, 3, 'mod/assign:addinstance', 1, [[timestamp]], 0),
(447, 1, 1, 'mod/assign:addinstance', 1, [[timestamp]], 0),
(448, 1, 4, 'mod/assign:grantextension', 1, [[timestamp]], 0),
(449, 1, 3, 'mod/assign:grantextension', 1, [[timestamp]], 0),
(450, 1, 1, 'mod/assign:grantextension', 1, [[timestamp]], 0),
(451, 1, 3, 'mod/assign:revealidentities', 1, [[timestamp]], 0),
(452, 1, 1, 'mod/assign:revealidentities', 1, [[timestamp]], 0),
(453, 1, 3, 'mod/assign:reviewgrades', 1, [[timestamp]], 0),
(454, 1, 1, 'mod/assign:reviewgrades', 1, [[timestamp]], 0),
(455, 1, 3, 'mod/assign:releasegrades', 1, [[timestamp]], 0),
(456, 1, 1, 'mod/assign:releasegrades', 1, [[timestamp]], 0),
(457, 1, 3, 'mod/assign:managegrades', 1, [[timestamp]], 0),
(458, 1, 1, 'mod/assign:managegrades', 1, [[timestamp]], 0),
(459, 1, 3, 'mod/assign:manageallocations', 1, [[timestamp]], 0),
(460, 1, 1, 'mod/assign:manageallocations', 1, [[timestamp]], 0),
(461, 1, 3, 'mod/assign:viewgrades', 1, [[timestamp]], 0),
(462, 1, 1, 'mod/assign:viewgrades', 1, [[timestamp]], 0),
(463, 1, 4, 'mod/assign:viewgrades', 1, [[timestamp]], 0),
(464, 1, 1, 'mod/assign:viewblinddetails', 1, [[timestamp]], 0),
(465, 1, 4, 'mod/assign:receivegradernotifications', 1, [[timestamp]], 0),
(466, 1, 3, 'mod/assign:receivegradernotifications', 1, [[timestamp]], 0),
(467, 1, 1, 'mod/assign:receivegradernotifications', 1, [[timestamp]], 0),
(468, 1, 3, 'mod/assign:manageoverrides', 1, [[timestamp]], 0),
(469, 1, 1, 'mod/assign:manageoverrides', 1, [[timestamp]], 0),
(470, 1, 6, 'mod/assignment:view', 1, [[timestamp]], 0),
(471, 1, 5, 'mod/assignment:view', 1, [[timestamp]], 0),
(472, 1, 4, 'mod/assignment:view', 1, [[timestamp]], 0),
(473, 1, 3, 'mod/assignment:view', 1, [[timestamp]], 0),
(474, 1, 1, 'mod/assignment:view', 1, [[timestamp]], 0),
(475, 1, 3, 'mod/assignment:addinstance', 1, [[timestamp]], 0),
(476, 1, 1, 'mod/assignment:addinstance', 1, [[timestamp]], 0),
(477, 1, 5, 'mod/assignment:submit', 1, [[timestamp]], 0),
(478, 1, 4, 'mod/assignment:grade', 1, [[timestamp]], 0),
(479, 1, 3, 'mod/assignment:grade', 1, [[timestamp]], 0),
(480, 1, 1, 'mod/assignment:grade', 1, [[timestamp]], 0),
(481, 1, 4, 'mod/assignment:exportownsubmission', 1, [[timestamp]], 0),
(482, 1, 3, 'mod/assignment:exportownsubmission', 1, [[timestamp]], 0),
(483, 1, 1, 'mod/assignment:exportownsubmission', 1, [[timestamp]], 0),
(484, 1, 5, 'mod/assignment:exportownsubmission', 1, [[timestamp]], 0),
(485, 1, 3, 'mod/book:addinstance', 1, [[timestamp]], 0),
(486, 1, 1, 'mod/book:addinstance', 1, [[timestamp]], 0),
(487, 1, 6, 'mod/book:read', 1, [[timestamp]], 0),
(488, 1, 8, 'mod/book:read', 1, [[timestamp]], 0),
(489, 1, 5, 'mod/book:read', 1, [[timestamp]], 0),
(490, 1, 4, 'mod/book:read', 1, [[timestamp]], 0),
(491, 1, 3, 'mod/book:read', 1, [[timestamp]], 0),
(492, 1, 1, 'mod/book:read', 1, [[timestamp]], 0),
(493, 1, 4, 'mod/book:viewhiddenchapters', 1, [[timestamp]], 0),
(494, 1, 3, 'mod/book:viewhiddenchapters', 1, [[timestamp]], 0),
(495, 1, 1, 'mod/book:viewhiddenchapters', 1, [[timestamp]], 0),
(496, 1, 3, 'mod/book:edit', 1, [[timestamp]], 0),
(497, 1, 1, 'mod/book:edit', 1, [[timestamp]], 0),
(498, 1, 3, 'mod/chat:addinstance', 1, [[timestamp]], 0),
(499, 1, 1, 'mod/chat:addinstance', 1, [[timestamp]], 0),
(500, 1, 5, 'mod/chat:chat', 1, [[timestamp]], 0),
(501, 1, 4, 'mod/chat:chat', 1, [[timestamp]], 0),
(502, 1, 3, 'mod/chat:chat', 1, [[timestamp]], 0),
(503, 1, 1, 'mod/chat:chat', 1, [[timestamp]], 0),
(504, 1, 5, 'mod/chat:readlog', 1, [[timestamp]], 0),
(505, 1, 4, 'mod/chat:readlog', 1, [[timestamp]], 0),
(506, 1, 3, 'mod/chat:readlog', 1, [[timestamp]], 0),
(507, 1, 1, 'mod/chat:readlog', 1, [[timestamp]], 0),
(508, 1, 4, 'mod/chat:deletelog', 1, [[timestamp]], 0),
(509, 1, 3, 'mod/chat:deletelog', 1, [[timestamp]], 0),
(510, 1, 1, 'mod/chat:deletelog', 1, [[timestamp]], 0),
(511, 1, 4, 'mod/chat:exportparticipatedsession', 1, [[timestamp]], 0),
(512, 1, 3, 'mod/chat:exportparticipatedsession', 1, [[timestamp]], 0),
(513, 1, 1, 'mod/chat:exportparticipatedsession', 1, [[timestamp]], 0),
(514, 1, 4, 'mod/chat:exportsession', 1, [[timestamp]], 0),
(515, 1, 3, 'mod/chat:exportsession', 1, [[timestamp]], 0),
(516, 1, 1, 'mod/chat:exportsession', 1, [[timestamp]], 0),
(517, 1, 7, 'mod/chat:view', 1, [[timestamp]], 0),
(518, 1, 6, 'mod/chat:view', 1, [[timestamp]], 0),
(519, 1, 3, 'mod/choice:addinstance', 1, [[timestamp]], 0),
(520, 1, 1, 'mod/choice:addinstance', 1, [[timestamp]], 0),
(521, 1, 5, 'mod/choice:choose', 1, [[timestamp]], 0),
(522, 1, 4, 'mod/choice:choose', 1, [[timestamp]], 0),
(523, 1, 3, 'mod/choice:choose', 1, [[timestamp]], 0),
(524, 1, 4, 'mod/choice:readresponses', 1, [[timestamp]], 0),
(525, 1, 3, 'mod/choice:readresponses', 1, [[timestamp]], 0),
(526, 1, 1, 'mod/choice:readresponses', 1, [[timestamp]], 0),
(527, 1, 4, 'mod/choice:deleteresponses', 1, [[timestamp]], 0),
(528, 1, 3, 'mod/choice:deleteresponses', 1, [[timestamp]], 0),
(529, 1, 1, 'mod/choice:deleteresponses', 1, [[timestamp]], 0),
(530, 1, 4, 'mod/choice:downloadresponses', 1, [[timestamp]], 0),
(531, 1, 3, 'mod/choice:downloadresponses', 1, [[timestamp]], 0),
(532, 1, 1, 'mod/choice:downloadresponses', 1, [[timestamp]], 0),
(533, 1, 7, 'mod/choice:view', 1, [[timestamp]], 0),
(534, 1, 6, 'mod/choice:view', 1, [[timestamp]], 0),
(535, 1, 3, 'mod/data:addinstance', 1, [[timestamp]], 0),
(536, 1, 1, 'mod/data:addinstance', 1, [[timestamp]], 0),
(537, 1, 8, 'mod/data:viewentry', 1, [[timestamp]], 0),
(538, 1, 6, 'mod/data:viewentry', 1, [[timestamp]], 0),
(539, 1, 5, 'mod/data:viewentry', 1, [[timestamp]], 0),
(540, 1, 4, 'mod/data:viewentry', 1, [[timestamp]], 0),
(541, 1, 3, 'mod/data:viewentry', 1, [[timestamp]], 0),
(542, 1, 1, 'mod/data:viewentry', 1, [[timestamp]], 0),
(543, 1, 5, 'mod/data:writeentry', 1, [[timestamp]], 0),
(544, 1, 4, 'mod/data:writeentry', 1, [[timestamp]], 0),
(545, 1, 3, 'mod/data:writeentry', 1, [[timestamp]], 0),
(546, 1, 1, 'mod/data:writeentry', 1, [[timestamp]], 0),
(547, 1, 5, 'mod/data:comment', 1, [[timestamp]], 0),
(548, 1, 4, 'mod/data:comment', 1, [[timestamp]], 0),
(549, 1, 3, 'mod/data:comment', 1, [[timestamp]], 0),
(550, 1, 1, 'mod/data:comment', 1, [[timestamp]], 0),
(551, 1, 4, 'mod/data:rate', 1, [[timestamp]], 0),
(552, 1, 3, 'mod/data:rate', 1, [[timestamp]], 0),
(553, 1, 1, 'mod/data:rate', 1, [[timestamp]], 0),
(554, 1, 4, 'mod/data:viewrating', 1, [[timestamp]], 0),
(555, 1, 3, 'mod/data:viewrating', 1, [[timestamp]], 0),
(556, 1, 1, 'mod/data:viewrating', 1, [[timestamp]], 0),
(557, 1, 4, 'mod/data:viewanyrating', 1, [[timestamp]], 0),
(558, 1, 3, 'mod/data:viewanyrating', 1, [[timestamp]], 0),
(559, 1, 1, 'mod/data:viewanyrating', 1, [[timestamp]], 0),
(560, 1, 4, 'mod/data:viewallratings', 1, [[timestamp]], 0),
(561, 1, 3, 'mod/data:viewallratings', 1, [[timestamp]], 0),
(562, 1, 1, 'mod/data:viewallratings', 1, [[timestamp]], 0),
(563, 1, 4, 'mod/data:approve', 1, [[timestamp]], 0),
(564, 1, 3, 'mod/data:approve', 1, [[timestamp]], 0),
(565, 1, 1, 'mod/data:approve', 1, [[timestamp]], 0),
(566, 1, 4, 'mod/data:manageentries', 1, [[timestamp]], 0),
(567, 1, 3, 'mod/data:manageentries', 1, [[timestamp]], 0),
(568, 1, 1, 'mod/data:manageentries', 1, [[timestamp]], 0),
(569, 1, 4, 'mod/data:managecomments', 1, [[timestamp]], 0),
(570, 1, 3, 'mod/data:managecomments', 1, [[timestamp]], 0),
(571, 1, 1, 'mod/data:managecomments', 1, [[timestamp]], 0),
(572, 1, 3, 'mod/data:managetemplates', 1, [[timestamp]], 0),
(573, 1, 1, 'mod/data:managetemplates', 1, [[timestamp]], 0),
(574, 1, 4, 'mod/data:viewalluserpresets', 1, [[timestamp]], 0),
(575, 1, 3, 'mod/data:viewalluserpresets', 1, [[timestamp]], 0),
(576, 1, 1, 'mod/data:viewalluserpresets', 1, [[timestamp]], 0),
(577, 1, 1, 'mod/data:manageuserpresets', 1, [[timestamp]], 0),
(578, 1, 1, 'mod/data:exportentry', 1, [[timestamp]], 0),
(579, 1, 4, 'mod/data:exportentry', 1, [[timestamp]], 0),
(580, 1, 3, 'mod/data:exportentry', 1, [[timestamp]], 0),
(581, 1, 1, 'mod/data:exportownentry', 1, [[timestamp]], 0),
(582, 1, 4, 'mod/data:exportownentry', 1, [[timestamp]], 0),
(583, 1, 3, 'mod/data:exportownentry', 1, [[timestamp]], 0),
(584, 1, 5, 'mod/data:exportownentry', 1, [[timestamp]], 0),
(585, 1, 1, 'mod/data:exportallentries', 1, [[timestamp]], 0),
(586, 1, 4, 'mod/data:exportallentries', 1, [[timestamp]], 0),
(587, 1, 3, 'mod/data:exportallentries', 1, [[timestamp]], 0),
(588, 1, 1, 'mod/data:exportuserinfo', 1, [[timestamp]], 0),
(589, 1, 4, 'mod/data:exportuserinfo', 1, [[timestamp]], 0),
(590, 1, 3, 'mod/data:exportuserinfo', 1, [[timestamp]], 0),
(591, 1, 6, 'mod/data:view', 1, [[timestamp]], 0),
(592, 1, 5, 'mod/data:view', 1, [[timestamp]], 0),
(593, 1, 4, 'mod/data:view', 1, [[timestamp]], 0),
(594, 1, 3, 'mod/data:view', 1, [[timestamp]], 0),
(595, 1, 1, 'mod/data:view', 1, [[timestamp]], 0),
(596, 1, 3, 'mod/feedback:addinstance', 1, [[timestamp]], 0),
(597, 1, 1, 'mod/feedback:addinstance', 1, [[timestamp]], 0),
(598, 1, 6, 'mod/feedback:view', 1, [[timestamp]], 0),
(599, 1, 8, 'mod/feedback:view', 1, [[timestamp]], 0),
(600, 1, 5, 'mod/feedback:view', 1, [[timestamp]], 0),
(601, 1, 4, 'mod/feedback:view', 1, [[timestamp]], 0),
(602, 1, 3, 'mod/feedback:view', 1, [[timestamp]], 0),
(603, 1, 1, 'mod/feedback:view', 1, [[timestamp]], 0),
(604, 1, 8, 'mod/feedback:complete', 1, [[timestamp]], 0),
(605, 1, 5, 'mod/feedback:complete', 1, [[timestamp]], 0),
(606, 1, 5, 'mod/feedback:viewanalysepage', 1, [[timestamp]], 0),
(607, 1, 3, 'mod/feedback:viewanalysepage', 1, [[timestamp]], 0),
(608, 1, 1, 'mod/feedback:viewanalysepage', 1, [[timestamp]], 0),
(609, 1, 3, 'mod/feedback:deletesubmissions', 1, [[timestamp]], 0),
(610, 1, 1, 'mod/feedback:deletesubmissions', 1, [[timestamp]], 0),
(611, 1, 1, 'mod/feedback:mapcourse', 1, [[timestamp]], 0),
(612, 1, 3, 'mod/feedback:edititems', 1, [[timestamp]], 0),
(613, 1, 1, 'mod/feedback:edititems', 1, [[timestamp]], 0),
(614, 1, 3, 'mod/feedback:createprivatetemplate', 1, [[timestamp]], 0),
(615, 1, 1, 'mod/feedback:createprivatetemplate', 1, [[timestamp]], 0),
(616, 1, 3, 'mod/feedback:createpublictemplate', 1, [[timestamp]], 0),
(617, 1, 1, 'mod/feedback:createpublictemplate', 1, [[timestamp]], 0),
(618, 1, 3, 'mod/feedback:deletetemplate', 1, [[timestamp]], 0),
(619, 1, 1, 'mod/feedback:deletetemplate', 1, [[timestamp]], 0),
(620, 1, 4, 'mod/feedback:viewreports', 1, [[timestamp]], 0),
(621, 1, 3, 'mod/feedback:viewreports', 1, [[timestamp]], 0),
(622, 1, 1, 'mod/feedback:viewreports', 1, [[timestamp]], 0),
(623, 1, 4, 'mod/feedback:receivemail', 1, [[timestamp]], 0),
(624, 1, 3, 'mod/feedback:receivemail', 1, [[timestamp]], 0),
(625, 1, 3, 'mod/folder:addinstance', 1, [[timestamp]], 0),
(626, 1, 1, 'mod/folder:addinstance', 1, [[timestamp]], 0),
(627, 1, 6, 'mod/folder:view', 1, [[timestamp]], 0),
(628, 1, 7, 'mod/folder:view', 1, [[timestamp]], 0),
(629, 1, 3, 'mod/folder:managefiles', 1, [[timestamp]], 0),
(630, 1, 3, 'mod/forum:addinstance', 1, [[timestamp]], 0),
(631, 1, 1, 'mod/forum:addinstance', 1, [[timestamp]], 0),
(632, 1, 8, 'mod/forum:viewdiscussion', 1, [[timestamp]], 0),
(633, 1, 6, 'mod/forum:viewdiscussion', 1, [[timestamp]], 0),
(634, 1, 5, 'mod/forum:viewdiscussion', 1, [[timestamp]], 0),
(635, 1, 4, 'mod/forum:viewdiscussion', 1, [[timestamp]], 0),
(636, 1, 3, 'mod/forum:viewdiscussion', 1, [[timestamp]], 0),
(637, 1, 1, 'mod/forum:viewdiscussion', 1, [[timestamp]], 0),
(638, 1, 4, 'mod/forum:viewhiddentimedposts', 1, [[timestamp]], 0),
(639, 1, 3, 'mod/forum:viewhiddentimedposts', 1, [[timestamp]], 0),
(640, 1, 1, 'mod/forum:viewhiddentimedposts', 1, [[timestamp]], 0),
(641, 1, 5, 'mod/forum:startdiscussion', 1, [[timestamp]], 0),
(642, 1, 4, 'mod/forum:startdiscussion', 1, [[timestamp]], 0),
(643, 1, 3, 'mod/forum:startdiscussion', 1, [[timestamp]], 0),
(644, 1, 1, 'mod/forum:startdiscussion', 1, [[timestamp]], 0),
(645, 1, 5, 'mod/forum:replypost', 1, [[timestamp]], 0),
(646, 1, 4, 'mod/forum:replypost', 1, [[timestamp]], 0),
(647, 1, 3, 'mod/forum:replypost', 1, [[timestamp]], 0),
(648, 1, 1, 'mod/forum:replypost', 1, [[timestamp]], 0),
(649, 1, 4, 'mod/forum:addnews', 1, [[timestamp]], 0),
(650, 1, 3, 'mod/forum:addnews', 1, [[timestamp]], 0),
(651, 1, 1, 'mod/forum:addnews', 1, [[timestamp]], 0),
(652, 1, 4, 'mod/forum:replynews', 1, [[timestamp]], 0),
(653, 1, 3, 'mod/forum:replynews', 1, [[timestamp]], 0),
(654, 1, 1, 'mod/forum:replynews', 1, [[timestamp]], 0),
(655, 1, 5, 'mod/forum:viewrating', 1, [[timestamp]], 0),
(656, 1, 4, 'mod/forum:viewrating', 1, [[timestamp]], 0),
(657, 1, 3, 'mod/forum:viewrating', 1, [[timestamp]], 0),
(658, 1, 1, 'mod/forum:viewrating', 1, [[timestamp]], 0),
(659, 1, 4, 'mod/forum:viewanyrating', 1, [[timestamp]], 0),
(660, 1, 3, 'mod/forum:viewanyrating', 1, [[timestamp]], 0),
(661, 1, 1, 'mod/forum:viewanyrating', 1, [[timestamp]], 0),
(662, 1, 4, 'mod/forum:viewallratings', 1, [[timestamp]], 0),
(663, 1, 3, 'mod/forum:viewallratings', 1, [[timestamp]], 0),
(664, 1, 1, 'mod/forum:viewallratings', 1, [[timestamp]], 0),
(665, 1, 4, 'mod/forum:rate', 1, [[timestamp]], 0),
(666, 1, 3, 'mod/forum:rate', 1, [[timestamp]], 0),
(667, 1, 1, 'mod/forum:rate', 1, [[timestamp]], 0),
(668, 1, 5, 'mod/forum:createattachment', 1, [[timestamp]], 0),
(669, 1, 4, 'mod/forum:createattachment', 1, [[timestamp]], 0),
(670, 1, 3, 'mod/forum:createattachment', 1, [[timestamp]], 0),
(671, 1, 1, 'mod/forum:createattachment', 1, [[timestamp]], 0),
(672, 1, 5, 'mod/forum:deleteownpost', 1, [[timestamp]], 0),
(673, 1, 4, 'mod/forum:deleteownpost', 1, [[timestamp]], 0),
(674, 1, 3, 'mod/forum:deleteownpost', 1, [[timestamp]], 0),
(675, 1, 1, 'mod/forum:deleteownpost', 1, [[timestamp]], 0),
(676, 1, 4, 'mod/forum:deleteanypost', 1, [[timestamp]], 0),
(677, 1, 3, 'mod/forum:deleteanypost', 1, [[timestamp]], 0),
(678, 1, 1, 'mod/forum:deleteanypost', 1, [[timestamp]], 0),
(679, 1, 4, 'mod/forum:splitdiscussions', 1, [[timestamp]], 0),
(680, 1, 3, 'mod/forum:splitdiscussions', 1, [[timestamp]], 0),
(681, 1, 1, 'mod/forum:splitdiscussions', 1, [[timestamp]], 0),
(682, 1, 4, 'mod/forum:movediscussions', 1, [[timestamp]], 0),
(683, 1, 3, 'mod/forum:movediscussions', 1, [[timestamp]], 0),
(684, 1, 1, 'mod/forum:movediscussions', 1, [[timestamp]], 0),
(685, 1, 4, 'mod/forum:pindiscussions', 1, [[timestamp]], 0),
(686, 1, 3, 'mod/forum:pindiscussions', 1, [[timestamp]], 0),
(687, 1, 1, 'mod/forum:pindiscussions', 1, [[timestamp]], 0),
(688, 1, 4, 'mod/forum:editanypost', 1, [[timestamp]], 0),
(689, 1, 3, 'mod/forum:editanypost', 1, [[timestamp]], 0),
(690, 1, 1, 'mod/forum:editanypost', 1, [[timestamp]], 0),
(691, 1, 4, 'mod/forum:viewqandawithoutposting', 1, [[timestamp]], 0),
(692, 1, 3, 'mod/forum:viewqandawithoutposting', 1, [[timestamp]], 0),
(693, 1, 1, 'mod/forum:viewqandawithoutposting', 1, [[timestamp]], 0),
(694, 1, 4, 'mod/forum:viewsubscribers', 1, [[timestamp]], 0),
(695, 1, 3, 'mod/forum:viewsubscribers', 1, [[timestamp]], 0),
(696, 1, 1, 'mod/forum:viewsubscribers', 1, [[timestamp]], 0),
(697, 1, 4, 'mod/forum:managesubscriptions', 1, [[timestamp]], 0),
(698, 1, 3, 'mod/forum:managesubscriptions', 1, [[timestamp]], 0),
(699, 1, 1, 'mod/forum:managesubscriptions', 1, [[timestamp]], 0),
(700, 1, 4, 'mod/forum:postwithoutthrottling', 1, [[timestamp]], 0),
(701, 1, 3, 'mod/forum:postwithoutthrottling', 1, [[timestamp]], 0),
(702, 1, 1, 'mod/forum:postwithoutthrottling', 1, [[timestamp]], 0),
(703, 1, 4, 'mod/forum:exportdiscussion', 1, [[timestamp]], 0),
(704, 1, 3, 'mod/forum:exportdiscussion', 1, [[timestamp]], 0),
(705, 1, 1, 'mod/forum:exportdiscussion', 1, [[timestamp]], 0),
(706, 1, 4, 'mod/forum:exportpost', 1, [[timestamp]], 0),
(707, 1, 3, 'mod/forum:exportpost', 1, [[timestamp]], 0),
(708, 1, 1, 'mod/forum:exportpost', 1, [[timestamp]], 0),
(709, 1, 4, 'mod/forum:exportownpost', 1, [[timestamp]], 0),
(710, 1, 3, 'mod/forum:exportownpost', 1, [[timestamp]], 0),
(711, 1, 1, 'mod/forum:exportownpost', 1, [[timestamp]], 0),
(712, 1, 5, 'mod/forum:exportownpost', 1, [[timestamp]], 0),
(713, 1, 4, 'mod/forum:addquestion', 1, [[timestamp]], 0),
(714, 1, 3, 'mod/forum:addquestion', 1, [[timestamp]], 0),
(715, 1, 1, 'mod/forum:addquestion', 1, [[timestamp]], 0),
(716, 1, 5, 'mod/forum:allowforcesubscribe', 1, [[timestamp]], 0),
(717, 1, 4, 'mod/forum:allowforcesubscribe', 1, [[timestamp]], 0),
(718, 1, 3, 'mod/forum:allowforcesubscribe', 1, [[timestamp]], 0),
(719, 1, 8, 'mod/forum:allowforcesubscribe', 1, [[timestamp]], 0),
(720, 1, 4, 'mod/forum:canposttomygroups', 1, [[timestamp]], 0),
(721, 1, 3, 'mod/forum:canposttomygroups', 1, [[timestamp]], 0),
(722, 1, 1, 'mod/forum:canposttomygroups', 1, [[timestamp]], 0),
(723, 1, 4, 'mod/forum:canoverridediscussionlock', 1, [[timestamp]], 0),
(724, 1, 3, 'mod/forum:canoverridediscussionlock', 1, [[timestamp]], 0),
(725, 1, 1, 'mod/forum:canoverridediscussionlock', 1, [[timestamp]], 0),
(726, 1, 3, 'mod/glossary:addinstance', 1, [[timestamp]], 0),
(727, 1, 1, 'mod/glossary:addinstance', 1, [[timestamp]], 0),
(728, 1, 8, 'mod/glossary:view', 1, [[timestamp]], 0),
(729, 1, 6, 'mod/glossary:view', 1, [[timestamp]], 0),
(730, 1, 5, 'mod/glossary:view', 1, [[timestamp]], 0),
(731, 1, 4, 'mod/glossary:view', 1, [[timestamp]], 0),
(732, 1, 3, 'mod/glossary:view', 1, [[timestamp]], 0),
(733, 1, 1, 'mod/glossary:view', 1, [[timestamp]], 0),
(734, 1, 5, 'mod/glossary:write', 1, [[timestamp]], 0),
(735, 1, 4, 'mod/glossary:write', 1, [[timestamp]], 0),
(736, 1, 3, 'mod/glossary:write', 1, [[timestamp]], 0),
(737, 1, 1, 'mod/glossary:write', 1, [[timestamp]], 0),
(738, 1, 4, 'mod/glossary:manageentries', 1, [[timestamp]], 0),
(739, 1, 3, 'mod/glossary:manageentries', 1, [[timestamp]], 0),
(740, 1, 1, 'mod/glossary:manageentries', 1, [[timestamp]], 0),
(741, 1, 4, 'mod/glossary:managecategories', 1, [[timestamp]], 0),
(742, 1, 3, 'mod/glossary:managecategories', 1, [[timestamp]], 0),
(743, 1, 1, 'mod/glossary:managecategories', 1, [[timestamp]], 0),
(744, 1, 5, 'mod/glossary:comment', 1, [[timestamp]], 0),
(745, 1, 4, 'mod/glossary:comment', 1, [[timestamp]], 0),
(746, 1, 3, 'mod/glossary:comment', 1, [[timestamp]], 0),
(747, 1, 1, 'mod/glossary:comment', 1, [[timestamp]], 0),
(748, 1, 4, 'mod/glossary:managecomments', 1, [[timestamp]], 0),
(749, 1, 3, 'mod/glossary:managecomments', 1, [[timestamp]], 0),
(750, 1, 1, 'mod/glossary:managecomments', 1, [[timestamp]], 0),
(751, 1, 4, 'mod/glossary:import', 1, [[timestamp]], 0),
(752, 1, 3, 'mod/glossary:import', 1, [[timestamp]], 0),
(753, 1, 1, 'mod/glossary:import', 1, [[timestamp]], 0),
(754, 1, 4, 'mod/glossary:export', 1, [[timestamp]], 0),
(755, 1, 3, 'mod/glossary:export', 1, [[timestamp]], 0),
(756, 1, 1, 'mod/glossary:export', 1, [[timestamp]], 0),
(757, 1, 4, 'mod/glossary:approve', 1, [[timestamp]], 0),
(758, 1, 3, 'mod/glossary:approve', 1, [[timestamp]], 0),
(759, 1, 1, 'mod/glossary:approve', 1, [[timestamp]], 0),
(760, 1, 4, 'mod/glossary:rate', 1, [[timestamp]], 0),
(761, 1, 3, 'mod/glossary:rate', 1, [[timestamp]], 0),
(762, 1, 1, 'mod/glossary:rate', 1, [[timestamp]], 0),
(763, 1, 4, 'mod/glossary:viewrating', 1, [[timestamp]], 0),
(764, 1, 3, 'mod/glossary:viewrating', 1, [[timestamp]], 0),
(765, 1, 1, 'mod/glossary:viewrating', 1, [[timestamp]], 0),
(766, 1, 4, 'mod/glossary:viewanyrating', 1, [[timestamp]], 0),
(767, 1, 3, 'mod/glossary:viewanyrating', 1, [[timestamp]], 0),
(768, 1, 1, 'mod/glossary:viewanyrating', 1, [[timestamp]], 0),
(769, 1, 4, 'mod/glossary:viewallratings', 1, [[timestamp]], 0),
(770, 1, 3, 'mod/glossary:viewallratings', 1, [[timestamp]], 0),
(771, 1, 1, 'mod/glossary:viewallratings', 1, [[timestamp]], 0),
(772, 1, 4, 'mod/glossary:exportentry', 1, [[timestamp]], 0),
(773, 1, 3, 'mod/glossary:exportentry', 1, [[timestamp]], 0),
(774, 1, 1, 'mod/glossary:exportentry', 1, [[timestamp]], 0),
(775, 1, 4, 'mod/glossary:exportownentry', 1, [[timestamp]], 0),
(776, 1, 3, 'mod/glossary:exportownentry', 1, [[timestamp]], 0),
(777, 1, 1, 'mod/glossary:exportownentry', 1, [[timestamp]], 0),
(778, 1, 5, 'mod/glossary:exportownentry', 1, [[timestamp]], 0),
(779, 1, 6, 'mod/imscp:view', 1, [[timestamp]], 0),
(780, 1, 7, 'mod/imscp:view', 1, [[timestamp]], 0),
(781, 1, 3, 'mod/imscp:addinstance', 1, [[timestamp]], 0),
(782, 1, 1, 'mod/imscp:addinstance', 1, [[timestamp]], 0),
(783, 1, 3, 'mod/label:addinstance', 1, [[timestamp]], 0),
(784, 1, 1, 'mod/label:addinstance', 1, [[timestamp]], 0),
(785, 1, 7, 'mod/label:view', 1, [[timestamp]], 0),
(786, 1, 6, 'mod/label:view', 1, [[timestamp]], 0),
(787, 1, 3, 'mod/lesson:addinstance', 1, [[timestamp]], 0),
(788, 1, 1, 'mod/lesson:addinstance', 1, [[timestamp]], 0),
(789, 1, 3, 'mod/lesson:edit', 1, [[timestamp]], 0),
(790, 1, 1, 'mod/lesson:edit', 1, [[timestamp]], 0),
(791, 1, 4, 'mod/lesson:grade', 1, [[timestamp]], 0),
(792, 1, 3, 'mod/lesson:grade', 1, [[timestamp]], 0),
(793, 1, 1, 'mod/lesson:grade', 1, [[timestamp]], 0),
(794, 1, 4, 'mod/lesson:viewreports', 1, [[timestamp]], 0),
(795, 1, 3, 'mod/lesson:viewreports', 1, [[timestamp]], 0),
(796, 1, 1, 'mod/lesson:viewreports', 1, [[timestamp]], 0),
(797, 1, 4, 'mod/lesson:manage', 1, [[timestamp]], 0),
(798, 1, 3, 'mod/lesson:manage', 1, [[timestamp]], 0),
(799, 1, 1, 'mod/lesson:manage', 1, [[timestamp]], 0),
(800, 1, 3, 'mod/lesson:manageoverrides', 1, [[timestamp]], 0),
(801, 1, 1, 'mod/lesson:manageoverrides', 1, [[timestamp]], 0),
(802, 1, 7, 'mod/lesson:view', 1, [[timestamp]], 0),
(803, 1, 6, 'mod/lesson:view', 1, [[timestamp]], 0),
(804, 1, 5, 'mod/lti:view', 1, [[timestamp]], 0),
(805, 1, 4, 'mod/lti:view', 1, [[timestamp]], 0),
(806, 1, 3, 'mod/lti:view', 1, [[timestamp]], 0),
(807, 1, 1, 'mod/lti:view', 1, [[timestamp]], 0),
(808, 1, 3, 'mod/lti:addinstance', 1, [[timestamp]], 0),
(809, 1, 1, 'mod/lti:addinstance', 1, [[timestamp]], 0),
(810, 1, 4, 'mod/lti:manage', 1, [[timestamp]], 0),
(811, 1, 3, 'mod/lti:manage', 1, [[timestamp]], 0),
(812, 1, 1, 'mod/lti:manage', 1, [[timestamp]], 0),
(813, 1, 3, 'mod/lti:addcoursetool', 1, [[timestamp]], 0),
(814, 1, 1, 'mod/lti:addcoursetool', 1, [[timestamp]], 0),
(815, 1, 3, 'mod/lti:requesttooladd', 1, [[timestamp]], 0),
(816, 1, 1, 'mod/lti:requesttooladd', 1, [[timestamp]], 0),
(817, 1, 6, 'mod/page:view', 1, [[timestamp]], 0),
(818, 1, 7, 'mod/page:view', 1, [[timestamp]], 0),
(819, 1, 3, 'mod/page:addinstance', 1, [[timestamp]], 0),
(820, 1, 1, 'mod/page:addinstance', 1, [[timestamp]], 0),
(821, 1, 6, 'mod/quiz:view', 1, [[timestamp]], 0),
(822, 1, 5, 'mod/quiz:view', 1, [[timestamp]], 0),
(823, 1, 4, 'mod/quiz:view', 1, [[timestamp]], 0),
(824, 1, 3, 'mod/quiz:view', 1, [[timestamp]], 0),
(825, 1, 1, 'mod/quiz:view', 1, [[timestamp]], 0),
(826, 1, 3, 'mod/quiz:addinstance', 1, [[timestamp]], 0),
(827, 1, 1, 'mod/quiz:addinstance', 1, [[timestamp]], 0),
(828, 1, 5, 'mod/quiz:attempt', 1, [[timestamp]], 0),
(829, 1, 5, 'mod/quiz:reviewmyattempts', 1, [[timestamp]], 0),
(830, 1, 3, 'mod/quiz:manage', 1, [[timestamp]], 0),
(831, 1, 1, 'mod/quiz:manage', 1, [[timestamp]], 0),
(832, 1, 3, 'mod/quiz:manageoverrides', 1, [[timestamp]], 0),
(833, 1, 1, 'mod/quiz:manageoverrides', 1, [[timestamp]], 0),
(834, 1, 4, 'mod/quiz:preview', 1, [[timestamp]], 0),
(835, 1, 3, 'mod/quiz:preview', 1, [[timestamp]], 0),
(836, 1, 1, 'mod/quiz:preview', 1, [[timestamp]], 0),
(837, 1, 4, 'mod/quiz:grade', 1, [[timestamp]], 0),
(838, 1, 3, 'mod/quiz:grade', 1, [[timestamp]], 0),
(839, 1, 1, 'mod/quiz:grade', 1, [[timestamp]], 0),
(840, 1, 4, 'mod/quiz:regrade', 1, [[timestamp]], 0),
(841, 1, 3, 'mod/quiz:regrade', 1, [[timestamp]], 0),
(842, 1, 1, 'mod/quiz:regrade', 1, [[timestamp]], 0),
(843, 1, 4, 'mod/quiz:viewreports', 1, [[timestamp]], 0),
(844, 1, 3, 'mod/quiz:viewreports', 1, [[timestamp]], 0),
(845, 1, 1, 'mod/quiz:viewreports', 1, [[timestamp]], 0),
(846, 1, 3, 'mod/quiz:deleteattempts', 1, [[timestamp]], 0),
(847, 1, 1, 'mod/quiz:deleteattempts', 1, [[timestamp]], 0),
(848, 1, 6, 'mod/resource:view', 1, [[timestamp]], 0),
(849, 1, 7, 'mod/resource:view', 1, [[timestamp]], 0),
(850, 1, 3, 'mod/resource:addinstance', 1, [[timestamp]], 0),
(851, 1, 1, 'mod/resource:addinstance', 1, [[timestamp]], 0),
(852, 1, 3, 'mod/scorm:addinstance', 1, [[timestamp]], 0),
(853, 1, 1, 'mod/scorm:addinstance', 1, [[timestamp]], 0),
(854, 1, 4, 'mod/scorm:viewreport', 1, [[timestamp]], 0),
(855, 1, 3, 'mod/scorm:viewreport', 1, [[timestamp]], 0),
(856, 1, 1, 'mod/scorm:viewreport', 1, [[timestamp]], 0),
(857, 1, 5, 'mod/scorm:skipview', 1, [[timestamp]], 0),
(858, 1, 5, 'mod/scorm:savetrack', 1, [[timestamp]], 0),
(859, 1, 4, 'mod/scorm:savetrack', 1, [[timestamp]], 0),
(860, 1, 3, 'mod/scorm:savetrack', 1, [[timestamp]], 0),
(861, 1, 1, 'mod/scorm:savetrack', 1, [[timestamp]], 0),
(862, 1, 5, 'mod/scorm:viewscores', 1, [[timestamp]], 0),
(863, 1, 4, 'mod/scorm:viewscores', 1, [[timestamp]], 0),
(864, 1, 3, 'mod/scorm:viewscores', 1, [[timestamp]], 0),
(865, 1, 1, 'mod/scorm:viewscores', 1, [[timestamp]], 0),
(866, 1, 4, 'mod/scorm:deleteresponses', 1, [[timestamp]], 0),
(867, 1, 3, 'mod/scorm:deleteresponses', 1, [[timestamp]], 0),
(868, 1, 1, 'mod/scorm:deleteresponses', 1, [[timestamp]], 0),
(869, 1, 3, 'mod/survey:addinstance', 1, [[timestamp]], 0),
(870, 1, 1, 'mod/survey:addinstance', 1, [[timestamp]], 0),
(871, 1, 5, 'mod/survey:participate', 1, [[timestamp]], 0),
(872, 1, 4, 'mod/survey:participate', 1, [[timestamp]], 0),
(873, 1, 3, 'mod/survey:participate', 1, [[timestamp]], 0),
(874, 1, 1, 'mod/survey:participate', 1, [[timestamp]], 0),
(875, 1, 4, 'mod/survey:readresponses', 1, [[timestamp]], 0),
(876, 1, 3, 'mod/survey:readresponses', 1, [[timestamp]], 0),
(877, 1, 1, 'mod/survey:readresponses', 1, [[timestamp]], 0),
(878, 1, 4, 'mod/survey:download', 1, [[timestamp]], 0),
(879, 1, 3, 'mod/survey:download', 1, [[timestamp]], 0),
(880, 1, 1, 'mod/survey:download', 1, [[timestamp]], 0),
(881, 1, 6, 'mod/url:view', 1, [[timestamp]], 0),
(882, 1, 7, 'mod/url:view', 1, [[timestamp]], 0),
(883, 1, 3, 'mod/url:addinstance', 1, [[timestamp]], 0),
(884, 1, 1, 'mod/url:addinstance', 1, [[timestamp]], 0),
(885, 1, 3, 'mod/wiki:addinstance', 1, [[timestamp]], 0),
(886, 1, 1, 'mod/wiki:addinstance', 1, [[timestamp]], 0),
(887, 1, 6, 'mod/wiki:viewpage', 1, [[timestamp]], 0),
(888, 1, 8, 'mod/wiki:viewpage', 1, [[timestamp]], 0);
INSERT INTO `[[dbprefix]]role_capabilities` VALUES
(889, 1, 5, 'mod/wiki:viewpage', 1, [[timestamp]], 0),
(890, 1, 4, 'mod/wiki:viewpage', 1, [[timestamp]], 0),
(891, 1, 3, 'mod/wiki:viewpage', 1, [[timestamp]], 0),
(892, 1, 1, 'mod/wiki:viewpage', 1, [[timestamp]], 0),
(893, 1, 5, 'mod/wiki:editpage', 1, [[timestamp]], 0),
(894, 1, 4, 'mod/wiki:editpage', 1, [[timestamp]], 0),
(895, 1, 3, 'mod/wiki:editpage', 1, [[timestamp]], 0),
(896, 1, 1, 'mod/wiki:editpage', 1, [[timestamp]], 0),
(897, 1, 5, 'mod/wiki:createpage', 1, [[timestamp]], 0),
(898, 1, 4, 'mod/wiki:createpage', 1, [[timestamp]], 0),
(899, 1, 3, 'mod/wiki:createpage', 1, [[timestamp]], 0),
(900, 1, 1, 'mod/wiki:createpage', 1, [[timestamp]], 0),
(901, 1, 5, 'mod/wiki:viewcomment', 1, [[timestamp]], 0),
(902, 1, 4, 'mod/wiki:viewcomment', 1, [[timestamp]], 0),
(903, 1, 3, 'mod/wiki:viewcomment', 1, [[timestamp]], 0),
(904, 1, 1, 'mod/wiki:viewcomment', 1, [[timestamp]], 0),
(905, 1, 5, 'mod/wiki:editcomment', 1, [[timestamp]], 0),
(906, 1, 4, 'mod/wiki:editcomment', 1, [[timestamp]], 0),
(907, 1, 3, 'mod/wiki:editcomment', 1, [[timestamp]], 0),
(908, 1, 1, 'mod/wiki:editcomment', 1, [[timestamp]], 0),
(909, 1, 4, 'mod/wiki:managecomment', 1, [[timestamp]], 0),
(910, 1, 3, 'mod/wiki:managecomment', 1, [[timestamp]], 0),
(911, 1, 1, 'mod/wiki:managecomment', 1, [[timestamp]], 0),
(912, 1, 4, 'mod/wiki:managefiles', 1, [[timestamp]], 0),
(913, 1, 3, 'mod/wiki:managefiles', 1, [[timestamp]], 0),
(914, 1, 1, 'mod/wiki:managefiles', 1, [[timestamp]], 0),
(915, 1, 4, 'mod/wiki:overridelock', 1, [[timestamp]], 0),
(916, 1, 3, 'mod/wiki:overridelock', 1, [[timestamp]], 0),
(917, 1, 1, 'mod/wiki:overridelock', 1, [[timestamp]], 0),
(918, 1, 4, 'mod/wiki:managewiki', 1, [[timestamp]], 0),
(919, 1, 3, 'mod/wiki:managewiki', 1, [[timestamp]], 0),
(920, 1, 1, 'mod/wiki:managewiki', 1, [[timestamp]], 0),
(921, 1, 6, 'mod/workshop:view', 1, [[timestamp]], 0),
(922, 1, 5, 'mod/workshop:view', 1, [[timestamp]], 0),
(923, 1, 4, 'mod/workshop:view', 1, [[timestamp]], 0),
(924, 1, 3, 'mod/workshop:view', 1, [[timestamp]], 0),
(925, 1, 1, 'mod/workshop:view', 1, [[timestamp]], 0),
(926, 1, 3, 'mod/workshop:addinstance', 1, [[timestamp]], 0),
(927, 1, 1, 'mod/workshop:addinstance', 1, [[timestamp]], 0),
(928, 1, 4, 'mod/workshop:switchphase', 1, [[timestamp]], 0),
(929, 1, 3, 'mod/workshop:switchphase', 1, [[timestamp]], 0),
(930, 1, 1, 'mod/workshop:switchphase', 1, [[timestamp]], 0),
(931, 1, 3, 'mod/workshop:editdimensions', 1, [[timestamp]], 0),
(932, 1, 1, 'mod/workshop:editdimensions', 1, [[timestamp]], 0),
(933, 1, 5, 'mod/workshop:submit', 1, [[timestamp]], 0),
(934, 1, 5, 'mod/workshop:peerassess', 1, [[timestamp]], 0),
(935, 1, 4, 'mod/workshop:manageexamples', 1, [[timestamp]], 0),
(936, 1, 3, 'mod/workshop:manageexamples', 1, [[timestamp]], 0),
(937, 1, 1, 'mod/workshop:manageexamples', 1, [[timestamp]], 0),
(938, 1, 4, 'mod/workshop:allocate', 1, [[timestamp]], 0),
(939, 1, 3, 'mod/workshop:allocate', 1, [[timestamp]], 0),
(940, 1, 1, 'mod/workshop:allocate', 1, [[timestamp]], 0),
(941, 1, 4, 'mod/workshop:publishsubmissions', 1, [[timestamp]], 0),
(942, 1, 3, 'mod/workshop:publishsubmissions', 1, [[timestamp]], 0),
(943, 1, 1, 'mod/workshop:publishsubmissions', 1, [[timestamp]], 0),
(944, 1, 5, 'mod/workshop:viewauthornames', 1, [[timestamp]], 0),
(945, 1, 4, 'mod/workshop:viewauthornames', 1, [[timestamp]], 0),
(946, 1, 3, 'mod/workshop:viewauthornames', 1, [[timestamp]], 0),
(947, 1, 1, 'mod/workshop:viewauthornames', 1, [[timestamp]], 0),
(948, 1, 4, 'mod/workshop:viewreviewernames', 1, [[timestamp]], 0),
(949, 1, 3, 'mod/workshop:viewreviewernames', 1, [[timestamp]], 0),
(950, 1, 1, 'mod/workshop:viewreviewernames', 1, [[timestamp]], 0),
(951, 1, 4, 'mod/workshop:viewallsubmissions', 1, [[timestamp]], 0),
(952, 1, 3, 'mod/workshop:viewallsubmissions', 1, [[timestamp]], 0),
(953, 1, 1, 'mod/workshop:viewallsubmissions', 1, [[timestamp]], 0),
(954, 1, 5, 'mod/workshop:viewpublishedsubmissions', 1, [[timestamp]], 0),
(955, 1, 4, 'mod/workshop:viewpublishedsubmissions', 1, [[timestamp]], 0),
(956, 1, 3, 'mod/workshop:viewpublishedsubmissions', 1, [[timestamp]], 0),
(957, 1, 1, 'mod/workshop:viewpublishedsubmissions', 1, [[timestamp]], 0),
(958, 1, 5, 'mod/workshop:viewauthorpublished', 1, [[timestamp]], 0),
(959, 1, 4, 'mod/workshop:viewauthorpublished', 1, [[timestamp]], 0),
(960, 1, 3, 'mod/workshop:viewauthorpublished', 1, [[timestamp]], 0),
(961, 1, 1, 'mod/workshop:viewauthorpublished', 1, [[timestamp]], 0),
(962, 1, 4, 'mod/workshop:viewallassessments', 1, [[timestamp]], 0),
(963, 1, 3, 'mod/workshop:viewallassessments', 1, [[timestamp]], 0),
(964, 1, 1, 'mod/workshop:viewallassessments', 1, [[timestamp]], 0),
(965, 1, 4, 'mod/workshop:overridegrades', 1, [[timestamp]], 0),
(966, 1, 3, 'mod/workshop:overridegrades', 1, [[timestamp]], 0),
(967, 1, 1, 'mod/workshop:overridegrades', 1, [[timestamp]], 0),
(968, 1, 4, 'mod/workshop:ignoredeadlines', 1, [[timestamp]], 0),
(969, 1, 3, 'mod/workshop:ignoredeadlines', 1, [[timestamp]], 0),
(970, 1, 1, 'mod/workshop:ignoredeadlines', 1, [[timestamp]], 0),
(971, 1, 4, 'mod/workshop:deletesubmissions', 1, [[timestamp]], 0),
(972, 1, 3, 'mod/workshop:deletesubmissions', 1, [[timestamp]], 0),
(973, 1, 1, 'mod/workshop:deletesubmissions', 1, [[timestamp]], 0),
(974, 1, 1, 'mod/workshop:exportsubmissions', 1, [[timestamp]], 0),
(975, 1, 4, 'mod/workshop:exportsubmissions', 1, [[timestamp]], 0),
(976, 1, 3, 'mod/workshop:exportsubmissions', 1, [[timestamp]], 0),
(977, 1, 5, 'mod/workshop:exportsubmissions', 1, [[timestamp]], 0),
(978, 1, 7, 'auth/oauth2:managelinkedlogins', 1, [[timestamp]], 0),
(979, 1, 1, 'enrol/category:config', 1, [[timestamp]], 0),
(980, 1, 3, 'enrol/category:config', 1, [[timestamp]], 0),
(981, 1, 3, 'enrol/cohort:config', 1, [[timestamp]], 0),
(982, 1, 1, 'enrol/cohort:config', 1, [[timestamp]], 0),
(983, 1, 1, 'enrol/cohort:unenrol', 1, [[timestamp]], 0),
(984, 1, 1, 'enrol/database:unenrol', 1, [[timestamp]], 0),
(985, 1, 1, 'enrol/database:config', 1, [[timestamp]], 0),
(986, 1, 3, 'enrol/database:config', 1, [[timestamp]], 0),
(987, 1, 1, 'enrol/guest:config', 1, [[timestamp]], 0),
(988, 1, 3, 'enrol/guest:config', 1, [[timestamp]], 0),
(989, 1, 1, 'enrol/imsenterprise:config', 1, [[timestamp]], 0),
(990, 1, 3, 'enrol/imsenterprise:config', 1, [[timestamp]], 0),
(991, 1, 1, 'enrol/ldap:manage', 1, [[timestamp]], 0),
(992, 1, 1, 'enrol/lti:config', 1, [[timestamp]], 0),
(993, 1, 3, 'enrol/lti:config', 1, [[timestamp]], 0),
(994, 1, 1, 'enrol/lti:unenrol', 1, [[timestamp]], 0),
(995, 1, 3, 'enrol/lti:unenrol', 1, [[timestamp]], 0),
(996, 1, 1, 'enrol/manual:config', 1, [[timestamp]], 0),
(997, 1, 1, 'enrol/manual:enrol', 1, [[timestamp]], 0),
(998, 1, 3, 'enrol/manual:enrol', 1, [[timestamp]], 0),
(999, 1, 1, 'enrol/manual:manage', 1, [[timestamp]], 0),
(1000, 1, 3, 'enrol/manual:manage', 1, [[timestamp]], 0),
(1001, 1, 1, 'enrol/manual:unenrol', 1, [[timestamp]], 0),
(1002, 1, 3, 'enrol/manual:unenrol', 1, [[timestamp]], 0),
(1003, 1, 1, 'enrol/meta:config', 1, [[timestamp]], 0),
(1004, 1, 3, 'enrol/meta:config', 1, [[timestamp]], 0),
(1005, 1, 1, 'enrol/meta:selectaslinked', 1, [[timestamp]], 0),
(1006, 1, 1, 'enrol/meta:unenrol', 1, [[timestamp]], 0),
(1007, 1, 1, 'enrol/mnet:config', 1, [[timestamp]], 0),
(1008, 1, 3, 'enrol/mnet:config', 1, [[timestamp]], 0),
(1009, 1, 1, 'enrol/paypal:config', 1, [[timestamp]], 0),
(1010, 1, 1, 'enrol/paypal:manage', 1, [[timestamp]], 0),
(1011, 1, 3, 'enrol/paypal:manage', 1, [[timestamp]], 0),
(1012, 1, 1, 'enrol/paypal:unenrol', 1, [[timestamp]], 0),
(1013, 1, 3, 'enrol/self:config', 1, [[timestamp]], 0),
(1014, 1, 1, 'enrol/self:config', 1, [[timestamp]], 0),
(1015, 1, 3, 'enrol/self:manage', 1, [[timestamp]], 0),
(1016, 1, 1, 'enrol/self:manage', 1, [[timestamp]], 0),
(1017, 1, 5, 'enrol/self:unenrolself', 1, [[timestamp]], 0),
(1018, 1, 3, 'enrol/self:unenrol', 1, [[timestamp]], 0),
(1019, 1, 1, 'enrol/self:unenrol', 1, [[timestamp]], 0),
(1020, 1, 7, 'message/airnotifier:managedevice', 1, [[timestamp]], 0),
(1021, 1, 3, 'block/activity_modules:addinstance', 1, [[timestamp]], 0),
(1022, 1, 1, 'block/activity_modules:addinstance', 1, [[timestamp]], 0),
(1023, 1, 3, 'block/activity_results:addinstance', 1, [[timestamp]], 0),
(1024, 1, 1, 'block/activity_results:addinstance', 1, [[timestamp]], 0),
(1025, 1, 7, 'block/admin_bookmarks:myaddinstance', 1, [[timestamp]], 0),
(1026, 1, 3, 'block/admin_bookmarks:addinstance', 1, [[timestamp]], 0),
(1027, 1, 1, 'block/admin_bookmarks:addinstance', 1, [[timestamp]], 0),
(1028, 1, 3, 'block/badges:addinstance', 1, [[timestamp]], 0),
(1029, 1, 1, 'block/badges:addinstance', 1, [[timestamp]], 0),
(1030, 1, 7, 'block/badges:myaddinstance', 1, [[timestamp]], 0),
(1031, 1, 3, 'block/blog_menu:addinstance', 1, [[timestamp]], 0),
(1032, 1, 1, 'block/blog_menu:addinstance', 1, [[timestamp]], 0),
(1033, 1, 3, 'block/blog_recent:addinstance', 1, [[timestamp]], 0),
(1034, 1, 1, 'block/blog_recent:addinstance', 1, [[timestamp]], 0),
(1035, 1, 3, 'block/blog_tags:addinstance', 1, [[timestamp]], 0),
(1036, 1, 1, 'block/blog_tags:addinstance', 1, [[timestamp]], 0),
(1037, 1, 7, 'block/calendar_month:myaddinstance', 1, [[timestamp]], 0),
(1038, 1, 3, 'block/calendar_month:addinstance', 1, [[timestamp]], 0),
(1039, 1, 1, 'block/calendar_month:addinstance', 1, [[timestamp]], 0),
(1040, 1, 7, 'block/calendar_upcoming:myaddinstance', 1, [[timestamp]], 0),
(1041, 1, 3, 'block/calendar_upcoming:addinstance', 1, [[timestamp]], 0),
(1042, 1, 1, 'block/calendar_upcoming:addinstance', 1, [[timestamp]], 0),
(1043, 1, 7, 'block/comments:myaddinstance', 1, [[timestamp]], 0),
(1044, 1, 3, 'block/comments:addinstance', 1, [[timestamp]], 0),
(1045, 1, 1, 'block/comments:addinstance', 1, [[timestamp]], 0),
(1046, 1, 7, 'block/community:myaddinstance', 1, [[timestamp]], 0),
(1047, 1, 3, 'block/community:addinstance', 1, [[timestamp]], 0),
(1048, 1, 1, 'block/community:addinstance', 1, [[timestamp]], 0),
(1049, 1, 3, 'block/completionstatus:addinstance', 1, [[timestamp]], 0),
(1050, 1, 1, 'block/completionstatus:addinstance', 1, [[timestamp]], 0),
(1051, 1, 7, 'block/course_list:myaddinstance', 1, [[timestamp]], 0),
(1052, 1, 3, 'block/course_list:addinstance', 1, [[timestamp]], 0),
(1053, 1, 1, 'block/course_list:addinstance', 1, [[timestamp]], 0),
(1054, 1, 3, 'block/course_summary:addinstance', 1, [[timestamp]], 0),
(1055, 1, 1, 'block/course_summary:addinstance', 1, [[timestamp]], 0),
(1056, 1, 3, 'block/feedback:addinstance', 1, [[timestamp]], 0),
(1057, 1, 1, 'block/feedback:addinstance', 1, [[timestamp]], 0),
(1058, 1, 7, 'block/globalsearch:myaddinstance', 1, [[timestamp]], 0),
(1059, 1, 3, 'block/globalsearch:addinstance', 1, [[timestamp]], 0),
(1060, 1, 1, 'block/globalsearch:addinstance', 1, [[timestamp]], 0),
(1061, 1, 7, 'block/glossary_random:myaddinstance', 1, [[timestamp]], 0),
(1062, 1, 3, 'block/glossary_random:addinstance', 1, [[timestamp]], 0),
(1063, 1, 1, 'block/glossary_random:addinstance', 1, [[timestamp]], 0),
(1064, 1, 7, 'block/html:myaddinstance', 1, [[timestamp]], 0),
(1065, 1, 3, 'block/html:addinstance', 1, [[timestamp]], 0),
(1066, 1, 1, 'block/html:addinstance', 1, [[timestamp]], 0),
(1067, 1, 3, 'block/login:addinstance', 1, [[timestamp]], 0),
(1068, 1, 1, 'block/login:addinstance', 1, [[timestamp]], 0),
(1069, 1, 3, 'block/lp:addinstance', 1, [[timestamp]], 0),
(1070, 1, 1, 'block/lp:addinstance', 1, [[timestamp]], 0),
(1071, 1, 7, 'block/lp:myaddinstance', 1, [[timestamp]], 0),
(1072, 1, 7, 'block/lp:view', 1, [[timestamp]], 0),
(1073, 1, 7, 'block/mentees:myaddinstance', 1, [[timestamp]], 0),
(1074, 1, 3, 'block/mentees:addinstance', 1, [[timestamp]], 0),
(1075, 1, 1, 'block/mentees:addinstance', 1, [[timestamp]], 0),
(1076, 1, 7, 'block/mnet_hosts:myaddinstance', 1, [[timestamp]], 0),
(1077, 1, 3, 'block/mnet_hosts:addinstance', 1, [[timestamp]], 0),
(1078, 1, 1, 'block/mnet_hosts:addinstance', 1, [[timestamp]], 0),
(1079, 1, 7, 'block/myoverview:myaddinstance', 1, [[timestamp]], 0),
(1080, 1, 3, 'block/myoverview:addinstance', 1, [[timestamp]], 0),
(1081, 1, 1, 'block/myoverview:addinstance', 1, [[timestamp]], 0),
(1082, 1, 7, 'block/myprofile:myaddinstance', 1, [[timestamp]], 0),
(1083, 1, 3, 'block/myprofile:addinstance', 1, [[timestamp]], 0),
(1084, 1, 1, 'block/myprofile:addinstance', 1, [[timestamp]], 0),
(1085, 1, 7, 'block/navigation:myaddinstance', 1, [[timestamp]], 0),
(1086, 1, 3, 'block/navigation:addinstance', 1, [[timestamp]], 0),
(1087, 1, 1, 'block/navigation:addinstance', 1, [[timestamp]], 0),
(1088, 1, 7, 'block/news_items:myaddinstance', 1, [[timestamp]], 0),
(1089, 1, 3, 'block/news_items:addinstance', 1, [[timestamp]], 0),
(1090, 1, 1, 'block/news_items:addinstance', 1, [[timestamp]], 0),
(1091, 1, 7, 'block/online_users:myaddinstance', 1, [[timestamp]], 0),
(1092, 1, 3, 'block/online_users:addinstance', 1, [[timestamp]], 0),
(1093, 1, 1, 'block/online_users:addinstance', 1, [[timestamp]], 0),
(1094, 1, 7, 'block/online_users:viewlist', 1, [[timestamp]], 0),
(1095, 1, 6, 'block/online_users:viewlist', -1, [[timestamp]], 0),
(1096, 1, 5, 'block/online_users:viewlist', 1, [[timestamp]], 0),
(1097, 1, 4, 'block/online_users:viewlist', 1, [[timestamp]], 0),
(1098, 1, 3, 'block/online_users:viewlist', 1, [[timestamp]], 0),
(1099, 1, 1, 'block/online_users:viewlist', 1, [[timestamp]], 0),
(1100, 1, 3, 'block/participants:addinstance', 1, [[timestamp]], 0),
(1101, 1, 1, 'block/participants:addinstance', 1, [[timestamp]], 0),
(1102, 1, 7, 'block/private_files:myaddinstance', 1, [[timestamp]], 0),
(1103, 1, 3, 'block/private_files:addinstance', 1, [[timestamp]], 0),
(1104, 1, 1, 'block/private_files:addinstance', 1, [[timestamp]], 0),
(1105, 1, 3, 'block/quiz_results:addinstance', 1, [[timestamp]], 0),
(1106, 1, 1, 'block/quiz_results:addinstance', 1, [[timestamp]], 0),
(1107, 1, 3, 'block/recent_activity:addinstance', 1, [[timestamp]], 0),
(1108, 1, 1, 'block/recent_activity:addinstance', 1, [[timestamp]], 0),
(1109, 1, 7, 'block/recent_activity:viewaddupdatemodule', 1, [[timestamp]], 0),
(1110, 1, 7, 'block/recent_activity:viewdeletemodule', 1, [[timestamp]], 0),
(1111, 1, 7, 'block/rss_client:myaddinstance', 1, [[timestamp]], 0),
(1112, 1, 3, 'block/rss_client:addinstance', 1, [[timestamp]], 0),
(1113, 1, 1, 'block/rss_client:addinstance', 1, [[timestamp]], 0),
(1114, 1, 4, 'block/rss_client:manageownfeeds', 1, [[timestamp]], 0),
(1115, 1, 3, 'block/rss_client:manageownfeeds', 1, [[timestamp]], 0),
(1116, 1, 1, 'block/rss_client:manageownfeeds', 1, [[timestamp]], 0),
(1117, 1, 1, 'block/rss_client:manageanyfeeds', 1, [[timestamp]], 0),
(1118, 1, 3, 'block/search_forums:addinstance', 1, [[timestamp]], 0),
(1119, 1, 1, 'block/search_forums:addinstance', 1, [[timestamp]], 0),
(1120, 1, 3, 'block/section_links:addinstance', 1, [[timestamp]], 0),
(1121, 1, 1, 'block/section_links:addinstance', 1, [[timestamp]], 0),
(1122, 1, 3, 'block/selfcompletion:addinstance', 1, [[timestamp]], 0),
(1123, 1, 1, 'block/selfcompletion:addinstance', 1, [[timestamp]], 0),
(1124, 1, 7, 'block/settings:myaddinstance', 1, [[timestamp]], 0),
(1125, 1, 3, 'block/settings:addinstance', 1, [[timestamp]], 0),
(1126, 1, 1, 'block/settings:addinstance', 1, [[timestamp]], 0),
(1127, 1, 3, 'block/site_main_menu:addinstance', 1, [[timestamp]], 0),
(1128, 1, 1, 'block/site_main_menu:addinstance', 1, [[timestamp]], 0),
(1129, 1, 3, 'block/social_activities:addinstance', 1, [[timestamp]], 0),
(1130, 1, 1, 'block/social_activities:addinstance', 1, [[timestamp]], 0),
(1131, 1, 3, 'block/tag_flickr:addinstance', 1, [[timestamp]], 0),
(1132, 1, 1, 'block/tag_flickr:addinstance', 1, [[timestamp]], 0),
(1133, 1, 3, 'block/tag_youtube:addinstance', 1, [[timestamp]], 0),
(1134, 1, 1, 'block/tag_youtube:addinstance', 1, [[timestamp]], 0),
(1135, 1, 7, 'block/tags:myaddinstance', 1, [[timestamp]], 0),
(1136, 1, 3, 'block/tags:addinstance', 1, [[timestamp]], 0),
(1137, 1, 1, 'block/tags:addinstance', 1, [[timestamp]], 0),
(1138, 1, 4, 'report/completion:view', 1, [[timestamp]], 0),
(1139, 1, 3, 'report/completion:view', 1, [[timestamp]], 0),
(1140, 1, 1, 'report/completion:view', 1, [[timestamp]], 0),
(1141, 1, 4, 'report/courseoverview:view', 1, [[timestamp]], 0),
(1142, 1, 3, 'report/courseoverview:view', 1, [[timestamp]], 0),
(1143, 1, 1, 'report/courseoverview:view', 1, [[timestamp]], 0),
(1144, 1, 4, 'report/log:view', 1, [[timestamp]], 0),
(1145, 1, 3, 'report/log:view', 1, [[timestamp]], 0),
(1146, 1, 1, 'report/log:view', 1, [[timestamp]], 0),
(1147, 1, 4, 'report/log:viewtoday', 1, [[timestamp]], 0),
(1148, 1, 3, 'report/log:viewtoday', 1, [[timestamp]], 0),
(1149, 1, 1, 'report/log:viewtoday', 1, [[timestamp]], 0),
(1150, 1, 4, 'report/loglive:view', 1, [[timestamp]], 0),
(1151, 1, 3, 'report/loglive:view', 1, [[timestamp]], 0),
(1152, 1, 1, 'report/loglive:view', 1, [[timestamp]], 0),
(1153, 1, 4, 'report/outline:view', 1, [[timestamp]], 0),
(1154, 1, 3, 'report/outline:view', 1, [[timestamp]], 0),
(1155, 1, 1, 'report/outline:view', 1, [[timestamp]], 0),
(1156, 1, 4, 'report/outline:viewuserreport', 1, [[timestamp]], 0),
(1157, 1, 3, 'report/outline:viewuserreport', 1, [[timestamp]], 0),
(1158, 1, 1, 'report/outline:viewuserreport', 1, [[timestamp]], 0),
(1159, 1, 4, 'report/participation:view', 1, [[timestamp]], 0),
(1160, 1, 3, 'report/participation:view', 1, [[timestamp]], 0),
(1161, 1, 1, 'report/participation:view', 1, [[timestamp]], 0),
(1162, 1, 1, 'report/performance:view', 1, [[timestamp]], 0),
(1163, 1, 4, 'report/progress:view', 1, [[timestamp]], 0),
(1164, 1, 3, 'report/progress:view', 1, [[timestamp]], 0),
(1165, 1, 1, 'report/progress:view', 1, [[timestamp]], 0),
(1166, 1, 1, 'report/security:view', 1, [[timestamp]], 0),
(1167, 1, 4, 'report/stats:view', 1, [[timestamp]], 0),
(1168, 1, 3, 'report/stats:view', 1, [[timestamp]], 0),
(1169, 1, 1, 'report/stats:view', 1, [[timestamp]], 0),
(1170, 1, 6, 'report/usersessions:manageownsessions', -1000, [[timestamp]], 0),
(1171, 1, 7, 'report/usersessions:manageownsessions', 1, [[timestamp]], 0),
(1172, 1, 1, 'report/usersessions:manageownsessions', 1, [[timestamp]], 0),
(1173, 1, 4, 'gradeexport/ods:view', 1, [[timestamp]], 0),
(1174, 1, 3, 'gradeexport/ods:view', 1, [[timestamp]], 0),
(1175, 1, 1, 'gradeexport/ods:view', 1, [[timestamp]], 0),
(1176, 1, 1, 'gradeexport/ods:publish', 1, [[timestamp]], 0),
(1177, 1, 4, 'gradeexport/txt:view', 1, [[timestamp]], 0),
(1178, 1, 3, 'gradeexport/txt:view', 1, [[timestamp]], 0),
(1179, 1, 1, 'gradeexport/txt:view', 1, [[timestamp]], 0),
(1180, 1, 1, 'gradeexport/txt:publish', 1, [[timestamp]], 0),
(1181, 1, 4, 'gradeexport/xls:view', 1, [[timestamp]], 0),
(1182, 1, 3, 'gradeexport/xls:view', 1, [[timestamp]], 0),
(1183, 1, 1, 'gradeexport/xls:view', 1, [[timestamp]], 0),
(1184, 1, 1, 'gradeexport/xls:publish', 1, [[timestamp]], 0),
(1185, 1, 4, 'gradeexport/xml:view', 1, [[timestamp]], 0),
(1186, 1, 3, 'gradeexport/xml:view', 1, [[timestamp]], 0),
(1187, 1, 1, 'gradeexport/xml:view', 1, [[timestamp]], 0),
(1188, 1, 1, 'gradeexport/xml:publish', 1, [[timestamp]], 0),
(1189, 1, 3, 'gradeimport/csv:view', 1, [[timestamp]], 0),
(1190, 1, 1, 'gradeimport/csv:view', 1, [[timestamp]], 0),
(1191, 1, 3, 'gradeimport/direct:view', 1, [[timestamp]], 0),
(1192, 1, 1, 'gradeimport/direct:view', 1, [[timestamp]], 0),
(1193, 1, 3, 'gradeimport/xml:view', 1, [[timestamp]], 0),
(1194, 1, 1, 'gradeimport/xml:view', 1, [[timestamp]], 0),
(1195, 1, 1, 'gradeimport/xml:publish', 1, [[timestamp]], 0),
(1196, 1, 4, 'gradereport/grader:view', 1, [[timestamp]], 0),
(1197, 1, 3, 'gradereport/grader:view', 1, [[timestamp]], 0),
(1198, 1, 1, 'gradereport/grader:view', 1, [[timestamp]], 0),
(1199, 1, 4, 'gradereport/history:view', 1, [[timestamp]], 0),
(1200, 1, 3, 'gradereport/history:view', 1, [[timestamp]], 0),
(1201, 1, 1, 'gradereport/history:view', 1, [[timestamp]], 0),
(1202, 1, 4, 'gradereport/outcomes:view', 1, [[timestamp]], 0),
(1203, 1, 3, 'gradereport/outcomes:view', 1, [[timestamp]], 0),
(1204, 1, 1, 'gradereport/outcomes:view', 1, [[timestamp]], 0),
(1205, 1, 7, 'gradereport/overview:view', 1, [[timestamp]], 0),
(1206, 1, 3, 'gradereport/singleview:view', 1, [[timestamp]], 0),
(1207, 1, 1, 'gradereport/singleview:view', 1, [[timestamp]], 0),
(1208, 1, 5, 'gradereport/user:view', 1, [[timestamp]], 0),
(1209, 1, 4, 'gradereport/user:view', 1, [[timestamp]], 0),
(1210, 1, 3, 'gradereport/user:view', 1, [[timestamp]], 0),
(1211, 1, 1, 'gradereport/user:view', 1, [[timestamp]], 0),
(1212, 1, 7, 'repository/areafiles:view', 1, [[timestamp]], 0),
(1213, 1, 7, 'repository/boxnet:view', 1, [[timestamp]], 0),
(1214, 1, 2, 'repository/coursefiles:view', 1, [[timestamp]], 0),
(1215, 1, 4, 'repository/coursefiles:view', 1, [[timestamp]], 0),
(1216, 1, 3, 'repository/coursefiles:view', 1, [[timestamp]], 0),
(1217, 1, 1, 'repository/coursefiles:view', 1, [[timestamp]], 0),
(1218, 1, 7, 'repository/dropbox:view', 1, [[timestamp]], 0),
(1219, 1, 7, 'repository/equella:view', 1, [[timestamp]], 0),
(1220, 1, 2, 'repository/filesystem:view', 1, [[timestamp]], 0),
(1221, 1, 4, 'repository/filesystem:view', 1, [[timestamp]], 0),
(1222, 1, 3, 'repository/filesystem:view', 1, [[timestamp]], 0),
(1223, 1, 1, 'repository/filesystem:view', 1, [[timestamp]], 0),
(1224, 1, 7, 'repository/flickr:view', 1, [[timestamp]], 0),
(1225, 1, 7, 'repository/flickr_public:view', 1, [[timestamp]], 0),
(1226, 1, 7, 'repository/googledocs:view', 1, [[timestamp]], 0),
(1227, 1, 2, 'repository/local:view', 1, [[timestamp]], 0),
(1228, 1, 4, 'repository/local:view', 1, [[timestamp]], 0),
(1229, 1, 3, 'repository/local:view', 1, [[timestamp]], 0),
(1230, 1, 1, 'repository/local:view', 1, [[timestamp]], 0),
(1231, 1, 7, 'repository/merlot:view', 1, [[timestamp]], 0),
(1232, 1, 7, 'repository/onedrive:view', 1, [[timestamp]], 0),
(1233, 1, 7, 'repository/picasa:view', 1, [[timestamp]], 0),
(1234, 1, 7, 'repository/recent:view', 1, [[timestamp]], 0),
(1235, 1, 7, 'repository/s3:view', 1, [[timestamp]], 0),
(1236, 1, 7, 'repository/skydrive:view', 1, [[timestamp]], 0),
(1237, 1, 7, 'repository/upload:view', 1, [[timestamp]], 0),
(1238, 1, 7, 'repository/url:view', 1, [[timestamp]], 0),
(1239, 1, 7, 'repository/user:view', 1, [[timestamp]], 0),
(1240, 1, 2, 'repository/webdav:view', 1, [[timestamp]], 0),
(1241, 1, 4, 'repository/webdav:view', 1, [[timestamp]], 0),
(1242, 1, 3, 'repository/webdav:view', 1, [[timestamp]], 0),
(1243, 1, 1, 'repository/webdav:view', 1, [[timestamp]], 0),
(1244, 1, 7, 'repository/wikimedia:view', 1, [[timestamp]], 0),
(1245, 1, 7, 'repository/youtube:view', 1, [[timestamp]], 0),
(1246, 1, 1, 'tool/customlang:view', 1, [[timestamp]], 0),
(1247, 1, 1, 'tool/customlang:edit', 1, [[timestamp]], 0),
(1248, 1, 7, 'tool/dataprivacy:downloadownrequest', 1, [[timestamp]], 0),
(1249, 1, 1, 'tool/lpmigrate:frameworksmigrate', 1, [[timestamp]], 0),
(1250, 1, 4, 'tool/monitor:subscribe', 1, [[timestamp]], 0),
(1251, 1, 3, 'tool/monitor:subscribe', 1, [[timestamp]], 0),
(1252, 1, 1, 'tool/monitor:subscribe', 1, [[timestamp]], 0),
(1253, 1, 4, 'tool/monitor:managerules', 1, [[timestamp]], 0),
(1254, 1, 3, 'tool/monitor:managerules', 1, [[timestamp]], 0),
(1255, 1, 1, 'tool/monitor:managerules', 1, [[timestamp]], 0),
(1256, 1, 1, 'tool/monitor:managetool', 1, [[timestamp]], 0),
(1257, 1, 7, 'tool/policy:accept', 1, [[timestamp]], 0),
(1258, 1, 1, 'tool/policy:managedocs', 1, [[timestamp]], 0),
(1259, 1, 1, 'tool/policy:viewacceptances', 1, [[timestamp]], 0),
(1260, 1, 3, 'tool/recyclebin:deleteitems', 1, [[timestamp]], 0),
(1261, 1, 1, 'tool/recyclebin:deleteitems', 1, [[timestamp]], 0),
(1262, 1, 3, 'tool/recyclebin:restoreitems', 1, [[timestamp]], 0),
(1263, 1, 1, 'tool/recyclebin:restoreitems', 1, [[timestamp]], 0),
(1264, 1, 4, 'tool/recyclebin:viewitems', 1, [[timestamp]], 0),
(1265, 1, 3, 'tool/recyclebin:viewitems', 1, [[timestamp]], 0),
(1266, 1, 1, 'tool/recyclebin:viewitems', 1, [[timestamp]], 0),
(1267, 1, 1, 'tool/uploaduser:uploaduserpictures', 1, [[timestamp]], 0),
(1268, 1, 1, 'tool/usertours:managetours', 1, [[timestamp]], 0),
(1269, 1, 3, 'booktool/importhtml:import', 1, [[timestamp]], 0),
(1270, 1, 1, 'booktool/importhtml:import', 1, [[timestamp]], 0),
(1271, 1, 6, 'booktool/print:print', 1, [[timestamp]], 0),
(1272, 1, 8, 'booktool/print:print', 1, [[timestamp]], 0),
(1273, 1, 5, 'booktool/print:print', 1, [[timestamp]], 0),
(1274, 1, 4, 'booktool/print:print', 1, [[timestamp]], 0),
(1275, 1, 3, 'booktool/print:print', 1, [[timestamp]], 0),
(1276, 1, 1, 'booktool/print:print', 1, [[timestamp]], 0),
(1277, 1, 4, 'quiz/grading:viewstudentnames', 1, [[timestamp]], 0),
(1278, 1, 3, 'quiz/grading:viewstudentnames', 1, [[timestamp]], 0),
(1279, 1, 1, 'quiz/grading:viewstudentnames', 1, [[timestamp]], 0),
(1280, 1, 4, 'quiz/grading:viewidnumber', 1, [[timestamp]], 0),
(1281, 1, 3, 'quiz/grading:viewidnumber', 1, [[timestamp]], 0),
(1282, 1, 1, 'quiz/grading:viewidnumber', 1, [[timestamp]], 0),
(1283, 1, 4, 'quiz/statistics:view', 1, [[timestamp]], 0),
(1284, 1, 3, 'quiz/statistics:view', 1, [[timestamp]], 0),
(1285, 1, 1, 'quiz/statistics:view', 1, [[timestamp]], 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]role_context_levels`
--

CREATE TABLE `[[dbprefix]]role_context_levels` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `roleid` bigint(10) NOT NULL,
  `contextlevel` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]rolecontleve_conrol_uix` (`contextlevel`,`roleid`),
  KEY `[[dbprefix]]rolecontleve_rol_ix` (`roleid`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Lists which roles can be assigned at which context levels. T' AUTO_INCREMENT=12 ;

--
-- Dumping data for table `[[dbprefix]]role_context_levels`
--

INSERT INTO `[[dbprefix]]role_context_levels` VALUES
(1, 1, 10),
(4, 2, 10),
(2, 1, 40),
(5, 2, 40),
(3, 1, 50),
(6, 3, 50),
(8, 4, 50),
(10, 5, 50),
(7, 3, 70),
(9, 4, 70),
(11, 5, 70);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]role_names`
--

CREATE TABLE `[[dbprefix]]role_names` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `roleid` bigint(10) NOT NULL DEFAULT '0',
  `contextid` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]rolename_rolcon_uix` (`roleid`,`contextid`),
  KEY `[[dbprefix]]rolename_rol_ix` (`roleid`),
  KEY `[[dbprefix]]rolename_con_ix` (`contextid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='role names in native strings' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]role_sortorder`
--

CREATE TABLE `[[dbprefix]]role_sortorder` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL,
  `roleid` bigint(10) NOT NULL,
  `contextid` bigint(10) NOT NULL,
  `sortoder` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]rolesort_userolcon_uix` (`userid`,`roleid`,`contextid`),
  KEY `[[dbprefix]]rolesort_use_ix` (`userid`),
  KEY `[[dbprefix]]rolesort_rol_ix` (`roleid`),
  KEY `[[dbprefix]]rolesort_con_ix` (`contextid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='sort order of course managers in a course' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]scale`
--

CREATE TABLE `[[dbprefix]]scale` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `courseid` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `scale` longtext NOT NULL,
  `description` longtext NOT NULL,
  `descriptionformat` tinyint(2) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]scal_cou_ix` (`courseid`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Defines grading scales' AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]scale`
--

INSERT INTO `[[dbprefix]]scale` VALUES
(1, 0, 0, 'Separate and Connected ways of knowing', 'Mostly separate knowing,Separate and connected,Mostly connected knowing', 'The scale based on the theory of separate and connected knowing. This theory describes two different ways that we can evaluate and learn about the things we see and hear.<ul><li><strong>Separate knowers</strong> remain as objective as possible without including feelings and emotions. In a discussion with other people, they like to defend their own ideas, using logic to find holes in opponent''s ideas.</li><li><strong>Connected knowers</strong> are more sensitive to other people. They are skilled at empathy and tend to listen and ask questions until they feel they can connect and "understand things from their point of view". They learn by trying to share the experiences that led to the knowledge they find in other people.</li></ul>', 0, [[timestamp]]),
(2, 0, 0, 'Default competence scale', 'Not yet competent,Competent', 'A binary rating scale that provides no further information beyond whether someone has demonstrated proficiency or not.', 0, [[timestamp]]);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]scale_history`
--

CREATE TABLE `[[dbprefix]]scale_history` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `action` bigint(10) NOT NULL DEFAULT '0',
  `oldid` bigint(10) NOT NULL,
  `source` varchar(255) DEFAULT NULL,
  `timemodified` bigint(10) DEFAULT NULL,
  `loggeduser` bigint(10) DEFAULT NULL,
  `courseid` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `scale` longtext NOT NULL,
  `description` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]scalhist_act_ix` (`action`),
  KEY `[[dbprefix]]scalhist_tim_ix` (`timemodified`),
  KEY `[[dbprefix]]scalhist_old_ix` (`oldid`),
  KEY `[[dbprefix]]scalhist_cou_ix` (`courseid`),
  KEY `[[dbprefix]]scalhist_log_ix` (`loggeduser`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='History table' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]scorm`
--

CREATE TABLE `[[dbprefix]]scorm` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `scormtype` varchar(50) NOT NULL DEFAULT 'local',
  `reference` varchar(255) NOT NULL DEFAULT '',
  `intro` longtext NOT NULL,
  `introformat` smallint(4) NOT NULL DEFAULT '0',
  `version` varchar(9) NOT NULL DEFAULT '',
  `maxgrade` double NOT NULL DEFAULT '0',
  `grademethod` tinyint(2) NOT NULL DEFAULT '0',
  `whatgrade` bigint(10) NOT NULL DEFAULT '0',
  `maxattempt` bigint(10) NOT NULL DEFAULT '1',
  `forcecompleted` tinyint(1) NOT NULL DEFAULT '0',
  `forcenewattempt` tinyint(1) NOT NULL DEFAULT '0',
  `lastattemptlock` tinyint(1) NOT NULL DEFAULT '0',
  `masteryoverride` tinyint(1) NOT NULL DEFAULT '1',
  `displayattemptstatus` tinyint(1) NOT NULL DEFAULT '1',
  `displaycoursestructure` tinyint(1) NOT NULL DEFAULT '0',
  `updatefreq` tinyint(1) NOT NULL DEFAULT '0',
  `sha1hash` varchar(40) DEFAULT NULL,
  `md5hash` varchar(32) NOT NULL DEFAULT '',
  `revision` bigint(10) NOT NULL DEFAULT '0',
  `launch` bigint(10) NOT NULL DEFAULT '0',
  `skipview` tinyint(1) NOT NULL DEFAULT '1',
  `hidebrowse` tinyint(1) NOT NULL DEFAULT '0',
  `hidetoc` tinyint(1) NOT NULL DEFAULT '0',
  `nav` tinyint(1) NOT NULL DEFAULT '1',
  `navpositionleft` bigint(10) DEFAULT '-100',
  `navpositiontop` bigint(10) DEFAULT '-100',
  `auto` tinyint(1) NOT NULL DEFAULT '0',
  `popup` tinyint(1) NOT NULL DEFAULT '0',
  `options` varchar(255) NOT NULL DEFAULT '',
  `width` bigint(10) NOT NULL DEFAULT '100',
  `height` bigint(10) NOT NULL DEFAULT '600',
  `timeopen` bigint(10) NOT NULL DEFAULT '0',
  `timeclose` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `completionstatusrequired` tinyint(1) DEFAULT NULL,
  `completionscorerequired` bigint(10) DEFAULT NULL,
  `completionstatusallscos` tinyint(1) DEFAULT NULL,
  `displayactivityname` smallint(4) NOT NULL DEFAULT '1',
  `autocommit` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]scor_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='each table is one SCORM module and its configuration' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]scorm_aicc_session`
--

CREATE TABLE `[[dbprefix]]scorm_aicc_session` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `scormid` bigint(10) NOT NULL DEFAULT '0',
  `hacpsession` varchar(255) NOT NULL DEFAULT '',
  `scoid` bigint(10) DEFAULT '0',
  `scormmode` varchar(50) DEFAULT NULL,
  `scormstatus` varchar(255) DEFAULT NULL,
  `attempt` bigint(10) DEFAULT NULL,
  `lessonstatus` varchar(255) DEFAULT NULL,
  `sessiontime` varchar(255) DEFAULT NULL,
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]scoraiccsess_sco_ix` (`scormid`),
  KEY `[[dbprefix]]scoraiccsess_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Used by AICC HACP to store session information' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]scorm_scoes`
--

CREATE TABLE `[[dbprefix]]scorm_scoes` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `scorm` bigint(10) NOT NULL DEFAULT '0',
  `manifest` varchar(255) NOT NULL DEFAULT '',
  `organization` varchar(255) NOT NULL DEFAULT '',
  `parent` varchar(255) NOT NULL DEFAULT '',
  `identifier` varchar(255) NOT NULL DEFAULT '',
  `launch` longtext NOT NULL,
  `scormtype` varchar(5) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `sortorder` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]scorscoe_sco_ix` (`scorm`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='each SCO part of the SCORM module' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]scorm_scoes_data`
--

CREATE TABLE `[[dbprefix]]scorm_scoes_data` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `scoid` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `value` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]scorscoedata_sco_ix` (`scoid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Contains variable data get from packages' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]scorm_scoes_track`
--

CREATE TABLE `[[dbprefix]]scorm_scoes_track` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `scormid` bigint(10) NOT NULL DEFAULT '0',
  `scoid` bigint(10) NOT NULL DEFAULT '0',
  `attempt` bigint(10) NOT NULL DEFAULT '1',
  `element` varchar(255) NOT NULL DEFAULT '',
  `value` longtext NOT NULL,
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]scorscoetrac_usescos_uix` (`userid`,`scormid`,`scoid`,`attempt`,`element`),
  KEY `[[dbprefix]]scorscoetrac_use_ix` (`userid`),
  KEY `[[dbprefix]]scorscoetrac_ele_ix` (`element`),
  KEY `[[dbprefix]]scorscoetrac_sco_ix` (`scormid`),
  KEY `[[dbprefix]]scorscoetrac_sco2_ix` (`scoid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='to track SCOes' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]scorm_seq_mapinfo`
--

CREATE TABLE `[[dbprefix]]scorm_seq_mapinfo` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `scoid` bigint(10) NOT NULL DEFAULT '0',
  `objectiveid` bigint(10) NOT NULL DEFAULT '0',
  `targetobjectiveid` bigint(10) NOT NULL DEFAULT '0',
  `readsatisfiedstatus` tinyint(1) NOT NULL DEFAULT '1',
  `readnormalizedmeasure` tinyint(1) NOT NULL DEFAULT '1',
  `writesatisfiedstatus` tinyint(1) NOT NULL DEFAULT '0',
  `writenormalizedmeasure` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]scorseqmapi_scoidobj_uix` (`scoid`,`id`,`objectiveid`),
  KEY `[[dbprefix]]scorseqmapi_sco_ix` (`scoid`),
  KEY `[[dbprefix]]scorseqmapi_obj_ix` (`objectiveid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='SCORM2004 objective mapinfo description' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]scorm_seq_objective`
--

CREATE TABLE `[[dbprefix]]scorm_seq_objective` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `scoid` bigint(10) NOT NULL DEFAULT '0',
  `primaryobj` tinyint(1) NOT NULL DEFAULT '0',
  `objectiveid` varchar(255) NOT NULL DEFAULT '',
  `satisfiedbymeasure` tinyint(1) NOT NULL DEFAULT '1',
  `minnormalizedmeasure` float(11,4) NOT NULL DEFAULT '0.0000',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]scorseqobje_scoid_uix` (`scoid`,`id`),
  KEY `[[dbprefix]]scorseqobje_sco_ix` (`scoid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='SCORM2004 objective description' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]scorm_seq_rolluprule`
--

CREATE TABLE `[[dbprefix]]scorm_seq_rolluprule` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `scoid` bigint(10) NOT NULL DEFAULT '0',
  `childactivityset` varchar(15) NOT NULL DEFAULT '',
  `minimumcount` bigint(10) NOT NULL DEFAULT '0',
  `minimumpercent` float(11,4) NOT NULL DEFAULT '0.0000',
  `conditioncombination` varchar(3) NOT NULL DEFAULT 'all',
  `action` varchar(15) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]scorseqroll_scoid_uix` (`scoid`,`id`),
  KEY `[[dbprefix]]scorseqroll_sco_ix` (`scoid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='SCORM2004 sequencing rule' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]scorm_seq_rolluprulecond`
--

CREATE TABLE `[[dbprefix]]scorm_seq_rolluprulecond` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `scoid` bigint(10) NOT NULL DEFAULT '0',
  `rollupruleid` bigint(10) NOT NULL DEFAULT '0',
  `operator` varchar(5) NOT NULL DEFAULT 'noOp',
  `cond` varchar(25) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]scorseqroll_scorolid_uix` (`scoid`,`rollupruleid`,`id`),
  KEY `[[dbprefix]]scorseqroll_sco2_ix` (`scoid`),
  KEY `[[dbprefix]]scorseqroll_rol_ix` (`rollupruleid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='SCORM2004 sequencing rule' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]scorm_seq_rulecond`
--

CREATE TABLE `[[dbprefix]]scorm_seq_rulecond` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `scoid` bigint(10) NOT NULL DEFAULT '0',
  `ruleconditionsid` bigint(10) NOT NULL DEFAULT '0',
  `refrencedobjective` varchar(255) NOT NULL DEFAULT '',
  `measurethreshold` float(11,4) NOT NULL DEFAULT '0.0000',
  `operator` varchar(5) NOT NULL DEFAULT 'noOp',
  `cond` varchar(30) NOT NULL DEFAULT 'always',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]scorseqrule_idscorul_uix` (`id`,`scoid`,`ruleconditionsid`),
  KEY `[[dbprefix]]scorseqrule_sco2_ix` (`scoid`),
  KEY `[[dbprefix]]scorseqrule_rul_ix` (`ruleconditionsid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='SCORM2004 rule condition' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]scorm_seq_ruleconds`
--

CREATE TABLE `[[dbprefix]]scorm_seq_ruleconds` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `scoid` bigint(10) NOT NULL DEFAULT '0',
  `conditioncombination` varchar(3) NOT NULL DEFAULT 'all',
  `ruletype` tinyint(2) NOT NULL DEFAULT '0',
  `action` varchar(25) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]scorseqrule_scoid_uix` (`scoid`,`id`),
  KEY `[[dbprefix]]scorseqrule_sco_ix` (`scoid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='SCORM2004 rule conditions' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]search_index_requests`
--

CREATE TABLE `[[dbprefix]]search_index_requests` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `contextid` bigint(10) NOT NULL,
  `searcharea` varchar(255) NOT NULL DEFAULT '',
  `timerequested` bigint(10) NOT NULL,
  `partialarea` varchar(255) NOT NULL DEFAULT '',
  `partialtime` bigint(10) NOT NULL,
  `indexpriority` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]searinderequ_indtim_ix` (`indexpriority`,`timerequested`),
  KEY `[[dbprefix]]searinderequ_con_ix` (`contextid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Records requests for (re)indexing of specific contexts. Entr' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]search_simpledb_index`
--

CREATE TABLE `[[dbprefix]]search_simpledb_index` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `docid` varchar(255) NOT NULL DEFAULT '',
  `itemid` bigint(10) NOT NULL,
  `title` longtext,
  `content` longtext,
  `contextid` bigint(10) NOT NULL,
  `areaid` varchar(255) NOT NULL DEFAULT '',
  `type` tinyint(1) NOT NULL,
  `courseid` bigint(10) NOT NULL,
  `owneruserid` bigint(10) DEFAULT NULL,
  `modified` bigint(10) NOT NULL,
  `userid` bigint(10) DEFAULT NULL,
  `description1` longtext,
  `description2` longtext,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]searsimpinde_doc_uix` (`docid`),
  KEY `[[dbprefix]]searsimpinde_owncon_ix` (`owneruserid`,`contextid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='search_simpledb table containing the index data.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]sessions`
--

CREATE TABLE `[[dbprefix]]sessions` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `state` bigint(10) NOT NULL DEFAULT '0',
  `sid` varchar(128) NOT NULL DEFAULT '',
  `userid` bigint(10) NOT NULL,
  `sessdata` longtext,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `firstip` varchar(45) DEFAULT NULL,
  `lastip` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]sess_sid_uix` (`sid`),
  KEY `[[dbprefix]]sess_sta_ix` (`state`),
  KEY `[[dbprefix]]sess_tim_ix` (`timecreated`),
  KEY `[[dbprefix]]sess_tim2_ix` (`timemodified`),
  KEY `[[dbprefix]]sess_use_ix` (`userid`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Database based session storage - now recommended' AUTO_INCREMENT=1 ;

--
-- Dumping data for table `[[dbprefix]]sessions`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]stats_daily`
--

CREATE TABLE `[[dbprefix]]stats_daily` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `courseid` bigint(10) NOT NULL DEFAULT '0',
  `timeend` bigint(10) NOT NULL DEFAULT '0',
  `roleid` bigint(10) NOT NULL DEFAULT '0',
  `stattype` varchar(20) NOT NULL DEFAULT 'activity',
  `stat1` bigint(10) NOT NULL DEFAULT '0',
  `stat2` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]statdail_cou_ix` (`courseid`),
  KEY `[[dbprefix]]statdail_tim_ix` (`timeend`),
  KEY `[[dbprefix]]statdail_rol_ix` (`roleid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='to accumulate daily stats' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]stats_monthly`
--

CREATE TABLE `[[dbprefix]]stats_monthly` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `courseid` bigint(10) NOT NULL DEFAULT '0',
  `timeend` bigint(10) NOT NULL DEFAULT '0',
  `roleid` bigint(10) NOT NULL DEFAULT '0',
  `stattype` varchar(20) NOT NULL DEFAULT 'activity',
  `stat1` bigint(10) NOT NULL DEFAULT '0',
  `stat2` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]statmont_cou_ix` (`courseid`),
  KEY `[[dbprefix]]statmont_tim_ix` (`timeend`),
  KEY `[[dbprefix]]statmont_rol_ix` (`roleid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='To accumulate monthly stats' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]stats_user_daily`
--

CREATE TABLE `[[dbprefix]]stats_user_daily` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `courseid` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `roleid` bigint(10) NOT NULL DEFAULT '0',
  `timeend` bigint(10) NOT NULL DEFAULT '0',
  `statsreads` bigint(10) NOT NULL DEFAULT '0',
  `statswrites` bigint(10) NOT NULL DEFAULT '0',
  `stattype` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]statuserdail_cou_ix` (`courseid`),
  KEY `[[dbprefix]]statuserdail_use_ix` (`userid`),
  KEY `[[dbprefix]]statuserdail_rol_ix` (`roleid`),
  KEY `[[dbprefix]]statuserdail_tim_ix` (`timeend`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='To accumulate daily stats per course/user' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]stats_user_monthly`
--

CREATE TABLE `[[dbprefix]]stats_user_monthly` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `courseid` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `roleid` bigint(10) NOT NULL DEFAULT '0',
  `timeend` bigint(10) NOT NULL DEFAULT '0',
  `statsreads` bigint(10) NOT NULL DEFAULT '0',
  `statswrites` bigint(10) NOT NULL DEFAULT '0',
  `stattype` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]statusermont_cou_ix` (`courseid`),
  KEY `[[dbprefix]]statusermont_use_ix` (`userid`),
  KEY `[[dbprefix]]statusermont_rol_ix` (`roleid`),
  KEY `[[dbprefix]]statusermont_tim_ix` (`timeend`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='To accumulate monthly stats per course/user' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]stats_user_weekly`
--

CREATE TABLE `[[dbprefix]]stats_user_weekly` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `courseid` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `roleid` bigint(10) NOT NULL DEFAULT '0',
  `timeend` bigint(10) NOT NULL DEFAULT '0',
  `statsreads` bigint(10) NOT NULL DEFAULT '0',
  `statswrites` bigint(10) NOT NULL DEFAULT '0',
  `stattype` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]statuserweek_cou_ix` (`courseid`),
  KEY `[[dbprefix]]statuserweek_use_ix` (`userid`),
  KEY `[[dbprefix]]statuserweek_rol_ix` (`roleid`),
  KEY `[[dbprefix]]statuserweek_tim_ix` (`timeend`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='To accumulate weekly stats per course/user' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]stats_weekly`
--

CREATE TABLE `[[dbprefix]]stats_weekly` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `courseid` bigint(10) NOT NULL DEFAULT '0',
  `timeend` bigint(10) NOT NULL DEFAULT '0',
  `roleid` bigint(10) NOT NULL DEFAULT '0',
  `stattype` varchar(20) NOT NULL DEFAULT 'activity',
  `stat1` bigint(10) NOT NULL DEFAULT '0',
  `stat2` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]statweek_cou_ix` (`courseid`),
  KEY `[[dbprefix]]statweek_tim_ix` (`timeend`),
  KEY `[[dbprefix]]statweek_rol_ix` (`roleid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='To accumulate weekly stats' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]survey`
--

CREATE TABLE `[[dbprefix]]survey` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `template` bigint(10) NOT NULL DEFAULT '0',
  `days` mediumint(6) NOT NULL DEFAULT '0',
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `intro` longtext NOT NULL,
  `introformat` smallint(4) NOT NULL DEFAULT '0',
  `questions` varchar(255) NOT NULL DEFAULT '',
  `completionsubmit` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]surv_cou_ix` (`course`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Each record is one SURVEY module with its configuration' AUTO_INCREMENT=6 ;

--
-- Dumping data for table `[[dbprefix]]survey`
--

INSERT INTO `[[dbprefix]]survey` VALUES
(1, 0, 0, 0, 985017600, 985017600, 'collesaname', 'collesaintro', 0, '25,26,27,28,29,30,43,44', 0),
(2, 0, 0, 0, 985017600, 985017600, 'collespname', 'collespintro', 0, '31,32,33,34,35,36,43,44', 0),
(3, 0, 0, 0, 985017600, 985017600, 'collesapname', 'collesapintro', 0, '37,38,39,40,41,42,43,44', 0),
(4, 0, 0, 0, 985017600, 985017600, 'attlsname', 'attlsintro', 0, '65,67,68', 0),
(5, 0, 0, 0, 985017600, 985017600, 'ciqname', 'ciqintro', 0, '69,70,71,72,73', 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]survey_analysis`
--

CREATE TABLE `[[dbprefix]]survey_analysis` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `survey` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `notes` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]survanal_use_ix` (`userid`),
  KEY `[[dbprefix]]survanal_sur_ix` (`survey`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='text about each survey submission' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]survey_answers`
--

CREATE TABLE `[[dbprefix]]survey_answers` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `survey` bigint(10) NOT NULL DEFAULT '0',
  `question` bigint(10) NOT NULL DEFAULT '0',
  `time` bigint(10) NOT NULL DEFAULT '0',
  `answer1` longtext NOT NULL,
  `answer2` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]survansw_use_ix` (`userid`),
  KEY `[[dbprefix]]survansw_sur_ix` (`survey`),
  KEY `[[dbprefix]]survansw_que_ix` (`question`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='the answers to each questions filled by the users' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]survey_questions`
--

CREATE TABLE `[[dbprefix]]survey_questions` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `text` varchar(255) NOT NULL DEFAULT '',
  `shorttext` varchar(30) NOT NULL DEFAULT '',
  `multi` varchar(100) NOT NULL DEFAULT '',
  `intro` varchar(50) NOT NULL DEFAULT '',
  `type` smallint(3) NOT NULL DEFAULT '0',
  `options` longtext,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='the questions conforming one survey' AUTO_INCREMENT=74 ;

--
-- Dumping data for table `[[dbprefix]]survey_questions`
--

INSERT INTO `[[dbprefix]]survey_questions` VALUES
(1, 'colles1', 'colles1short', '', '', 1, 'scaletimes5'),
(2, 'colles2', 'colles2short', '', '', 1, 'scaletimes5'),
(3, 'colles3', 'colles3short', '', '', 1, 'scaletimes5'),
(4, 'colles4', 'colles4short', '', '', 1, 'scaletimes5'),
(5, 'colles5', 'colles5short', '', '', 1, 'scaletimes5'),
(6, 'colles6', 'colles6short', '', '', 1, 'scaletimes5'),
(7, 'colles7', 'colles7short', '', '', 1, 'scaletimes5'),
(8, 'colles8', 'colles8short', '', '', 1, 'scaletimes5'),
(9, 'colles9', 'colles9short', '', '', 1, 'scaletimes5'),
(10, 'colles10', 'colles10short', '', '', 1, 'scaletimes5'),
(11, 'colles11', 'colles11short', '', '', 1, 'scaletimes5'),
(12, 'colles12', 'colles12short', '', '', 1, 'scaletimes5'),
(13, 'colles13', 'colles13short', '', '', 1, 'scaletimes5'),
(14, 'colles14', 'colles14short', '', '', 1, 'scaletimes5'),
(15, 'colles15', 'colles15short', '', '', 1, 'scaletimes5'),
(16, 'colles16', 'colles16short', '', '', 1, 'scaletimes5'),
(17, 'colles17', 'colles17short', '', '', 1, 'scaletimes5'),
(18, 'colles18', 'colles18short', '', '', 1, 'scaletimes5'),
(19, 'colles19', 'colles19short', '', '', 1, 'scaletimes5'),
(20, 'colles20', 'colles20short', '', '', 1, 'scaletimes5'),
(21, 'colles21', 'colles21short', '', '', 1, 'scaletimes5'),
(22, 'colles22', 'colles22short', '', '', 1, 'scaletimes5'),
(23, 'colles23', 'colles23short', '', '', 1, 'scaletimes5'),
(24, 'colles24', 'colles24short', '', '', 1, 'scaletimes5'),
(25, 'collesm1', 'collesm1short', '1,2,3,4', 'collesmintro', 1, 'scaletimes5'),
(26, 'collesm2', 'collesm2short', '5,6,7,8', 'collesmintro', 1, 'scaletimes5'),
(27, 'collesm3', 'collesm3short', '9,10,11,12', 'collesmintro', 1, 'scaletimes5'),
(28, 'collesm4', 'collesm4short', '13,14,15,16', 'collesmintro', 1, 'scaletimes5'),
(29, 'collesm5', 'collesm5short', '17,18,19,20', 'collesmintro', 1, 'scaletimes5'),
(30, 'collesm6', 'collesm6short', '21,22,23,24', 'collesmintro', 1, 'scaletimes5'),
(31, 'collesm1', 'collesm1short', '1,2,3,4', 'collesmintro', 2, 'scaletimes5'),
(32, 'collesm2', 'collesm2short', '5,6,7,8', 'collesmintro', 2, 'scaletimes5'),
(33, 'collesm3', 'collesm3short', '9,10,11,12', 'collesmintro', 2, 'scaletimes5'),
(34, 'collesm4', 'collesm4short', '13,14,15,16', 'collesmintro', 2, 'scaletimes5'),
(35, 'collesm5', 'collesm5short', '17,18,19,20', 'collesmintro', 2, 'scaletimes5'),
(36, 'collesm6', 'collesm6short', '21,22,23,24', 'collesmintro', 2, 'scaletimes5'),
(37, 'collesm1', 'collesm1short', '1,2,3,4', 'collesmintro', 3, 'scaletimes5'),
(38, 'collesm2', 'collesm2short', '5,6,7,8', 'collesmintro', 3, 'scaletimes5'),
(39, 'collesm3', 'collesm3short', '9,10,11,12', 'collesmintro', 3, 'scaletimes5'),
(40, 'collesm4', 'collesm4short', '13,14,15,16', 'collesmintro', 3, 'scaletimes5'),
(41, 'collesm5', 'collesm5short', '17,18,19,20', 'collesmintro', 3, 'scaletimes5'),
(42, 'collesm6', 'collesm6short', '21,22,23,24', 'collesmintro', 3, 'scaletimes5'),
(43, 'howlong', '', '', '', 1, 'howlongoptions'),
(44, 'othercomments', '', '', '', 0, NULL),
(45, 'attls1', 'attls1short', '', '', 1, 'scaleagree5'),
(46, 'attls2', 'attls2short', '', '', 1, 'scaleagree5'),
(47, 'attls3', 'attls3short', '', '', 1, 'scaleagree5'),
(48, 'attls4', 'attls4short', '', '', 1, 'scaleagree5'),
(49, 'attls5', 'attls5short', '', '', 1, 'scaleagree5'),
(50, 'attls6', 'attls6short', '', '', 1, 'scaleagree5'),
(51, 'attls7', 'attls7short', '', '', 1, 'scaleagree5'),
(52, 'attls8', 'attls8short', '', '', 1, 'scaleagree5'),
(53, 'attls9', 'attls9short', '', '', 1, 'scaleagree5'),
(54, 'attls10', 'attls10short', '', '', 1, 'scaleagree5'),
(55, 'attls11', 'attls11short', '', '', 1, 'scaleagree5'),
(56, 'attls12', 'attls12short', '', '', 1, 'scaleagree5'),
(57, 'attls13', 'attls13short', '', '', 1, 'scaleagree5'),
(58, 'attls14', 'attls14short', '', '', 1, 'scaleagree5'),
(59, 'attls15', 'attls15short', '', '', 1, 'scaleagree5'),
(60, 'attls16', 'attls16short', '', '', 1, 'scaleagree5'),
(61, 'attls17', 'attls17short', '', '', 1, 'scaleagree5'),
(62, 'attls18', 'attls18short', '', '', 1, 'scaleagree5'),
(63, 'attls19', 'attls19short', '', '', 1, 'scaleagree5'),
(64, 'attls20', 'attls20short', '', '', 1, 'scaleagree5'),
(65, 'attlsm1', 'attlsm1', '45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64', 'attlsmintro', 1, 'scaleagree5'),
(66, '-', '-', '-', '-', 0, '-'),
(67, 'attlsm2', 'attlsm2', '63,62,59,57,55,49,52,50,48,47', 'attlsmintro', -1, 'scaleagree5'),
(68, 'attlsm3', 'attlsm3', '46,54,45,51,60,53,56,58,61,64', 'attlsmintro', -1, 'scaleagree5'),
(69, 'ciq1', 'ciq1short', '', '', 0, NULL),
(70, 'ciq2', 'ciq2short', '', '', 0, NULL),
(71, 'ciq3', 'ciq3short', '', '', 0, NULL),
(72, 'ciq4', 'ciq4short', '', '', 0, NULL),
(73, 'ciq5', 'ciq5short', '', '', 0, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tag`
--

CREATE TABLE `[[dbprefix]]tag` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL,
  `tagcollid` bigint(10) NOT NULL,
  `name` varchar(255) NOT NULL DEFAULT '',
  `rawname` varchar(255) NOT NULL DEFAULT '',
  `isstandard` tinyint(1) NOT NULL DEFAULT '0',
  `description` longtext,
  `descriptionformat` tinyint(2) NOT NULL DEFAULT '0',
  `flag` smallint(4) DEFAULT '0',
  `timemodified` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]tag_tagnam_uix` (`tagcollid`,`name`),
  KEY `[[dbprefix]]tag_tagiss_ix` (`tagcollid`,`isstandard`),
  KEY `[[dbprefix]]tag_use_ix` (`userid`),
  KEY `[[dbprefix]]tag_tag_ix` (`tagcollid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Tag table - this generic table will replace the old "tags" t' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tag_area`
--

CREATE TABLE `[[dbprefix]]tag_area` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `component` varchar(100) NOT NULL DEFAULT '',
  `itemtype` varchar(100) NOT NULL DEFAULT '',
  `enabled` tinyint(1) NOT NULL DEFAULT '1',
  `tagcollid` bigint(10) NOT NULL,
  `callback` varchar(100) DEFAULT NULL,
  `callbackfile` varchar(100) DEFAULT NULL,
  `showstandard` tinyint(1) NOT NULL DEFAULT '0',
  `multiplecontexts` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]tagarea_comite_uix` (`component`,`itemtype`),
  KEY `[[dbprefix]]tagarea_tag_ix` (`tagcollid`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Defines various tag areas, one area is identified by compone' AUTO_INCREMENT=12 ;

--
-- Dumping data for table `[[dbprefix]]tag_area`
--

INSERT INTO `[[dbprefix]]tag_area` VALUES
(1, 'core', 'user', 1, 1, 'user_get_tagged_users', '/user/lib.php', 2, 0),
(2, 'core', 'course', 1, 1, 'course_get_tagged_courses', '/course/lib.php', 0, 0),
(3, 'core_question', 'question', 1, 1, NULL, NULL, 0, 1),
(4, 'core', 'post', 1, 1, 'blog_get_tagged_posts', '/blog/lib.php', 0, 0),
(5, 'core', 'blog_external', 1, 1, NULL, NULL, 0, 0),
(6, 'core', 'course_modules', 1, 1, 'course_get_tagged_course_modules', '/course/lib.php', 0, 0),
(7, 'mod_book', 'book_chapters', 1, 1, 'mod_book_get_tagged_chapters', '/mod/book/locallib.php', 0, 0),
(8, 'mod_data', 'data_records', 1, 1, 'mod_data_get_tagged_records', '/mod/data/locallib.php', 0, 0),
(9, 'mod_forum', 'forum_posts', 1, 1, 'mod_forum_get_tagged_posts', '/mod/forum/locallib.php', 0, 0),
(10, 'mod_glossary', 'glossary_entries', 1, 1, 'mod_glossary_get_tagged_entries', '/mod/glossary/locallib.php', 0, 0),
(11, 'mod_wiki', 'wiki_pages', 1, 1, 'mod_wiki_get_tagged_pages', '/mod/wiki/locallib.php', 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tag_coll`
--

CREATE TABLE `[[dbprefix]]tag_coll` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `isdefault` tinyint(2) NOT NULL DEFAULT '0',
  `component` varchar(100) DEFAULT NULL,
  `sortorder` mediumint(5) NOT NULL DEFAULT '0',
  `searchable` tinyint(2) NOT NULL DEFAULT '1',
  `customurl` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Defines different set of tags' AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]tag_coll`
--

INSERT INTO `[[dbprefix]]tag_coll` VALUES
(1, NULL, 1, NULL, 0, 1, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tag_correlation`
--

CREATE TABLE `[[dbprefix]]tag_correlation` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `tagid` bigint(10) NOT NULL,
  `correlatedtags` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]tagcorr_tag_ix` (`tagid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='The rationale for the ''tag_correlation'' table is performance' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tag_instance`
--

CREATE TABLE `[[dbprefix]]tag_instance` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `tagid` bigint(10) NOT NULL,
  `component` varchar(100) NOT NULL DEFAULT '',
  `itemtype` varchar(100) NOT NULL DEFAULT '',
  `itemid` bigint(10) NOT NULL,
  `contextid` bigint(10) DEFAULT NULL,
  `tiuserid` bigint(10) NOT NULL DEFAULT '0',
  `ordering` bigint(10) DEFAULT NULL,
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]taginst_comiteitecon_uix` (`component`,`itemtype`,`itemid`,`contextid`,`tiuserid`,`tagid`),
  KEY `[[dbprefix]]taginst_itecomtagcon_ix` (`itemtype`,`component`,`tagid`,`contextid`),
  KEY `[[dbprefix]]taginst_tag_ix` (`tagid`),
  KEY `[[dbprefix]]taginst_con_ix` (`contextid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='tag_instance table holds the information of associations bet' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]task_adhoc`
--

CREATE TABLE `[[dbprefix]]task_adhoc` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `component` varchar(255) NOT NULL DEFAULT '',
  `classname` varchar(255) NOT NULL DEFAULT '',
  `nextruntime` bigint(10) NOT NULL,
  `faildelay` bigint(10) DEFAULT NULL,
  `customdata` longtext,
  `userid` bigint(10) DEFAULT NULL,
  `blocking` tinyint(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]taskadho_nex_ix` (`nextruntime`),
  KEY `[[dbprefix]]taskadho_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='List of adhoc tasks waiting to run.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]task_scheduled`
--

CREATE TABLE `[[dbprefix]]task_scheduled` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `component` varchar(255) NOT NULL DEFAULT '',
  `classname` varchar(255) NOT NULL DEFAULT '',
  `lastruntime` bigint(10) DEFAULT NULL,
  `nextruntime` bigint(10) DEFAULT NULL,
  `blocking` tinyint(2) NOT NULL DEFAULT '0',
  `minute` varchar(25) NOT NULL DEFAULT '',
  `hour` varchar(25) NOT NULL DEFAULT '',
  `day` varchar(25) NOT NULL DEFAULT '',
  `month` varchar(25) NOT NULL DEFAULT '',
  `dayofweek` varchar(25) NOT NULL DEFAULT '',
  `faildelay` bigint(10) DEFAULT NULL,
  `customised` tinyint(2) NOT NULL DEFAULT '0',
  `disabled` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]tasksche_cla_uix` (`classname`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='List of scheduled tasks to be run by cron.' AUTO_INCREMENT=78 ;

--
-- Dumping data for table `[[dbprefix]]task_scheduled`
--

INSERT INTO `[[dbprefix]]task_scheduled` VALUES
(1, 'moodle', '\\core\\task\\session_cleanup_task', 0, [[timestamp]], 0, '*', '*', '*', '*', '*', 0, 0, 0),
(2, 'moodle', '\\core\\task\\delete_unconfirmed_users_task', 0, [[timestamp]], 0, '0', '*', '*', '*', '*', 0, 0, 0),
(3, 'moodle', '\\core\\task\\delete_incomplete_users_task', 0, [[timestamp]], 0, '5', '*', '*', '*', '*', 0, 0, 0),
(4, 'moodle', '\\core\\task\\backup_cleanup_task', 0, [[timestamp]], 0, '10', '*', '*', '*', '*', 0, 0, 0),
(5, 'moodle', '\\core\\task\\tag_cron_task', 0, [[timestamp_nextday]], 0, '3', '3', '*', '*', '*', 0, 0, 0),
(6, 'moodle', '\\core\\task\\context_cleanup_task', 0, [[timestamp]], 0, '25', '*', '*', '*', '*', 0, 0, 0),
(7, 'moodle', '\\core\\task\\cache_cleanup_task', 0, [[timestamp]], 0, '30', '*', '*', '*', '*', 0, 0, 0),
(8, 'moodle', '\\core\\task\\messaging_cleanup_task', 0, [[timestamp]], 0, '35', '*', '*', '*', '*', 0, 0, 0),
(9, 'moodle', '\\core\\task\\send_new_user_passwords_task', 0, [[timestamp]], 0, '*', '*', '*', '*', '*', 0, 0, 0),
(10, 'moodle', '\\core\\task\\send_failed_login_notifications_task', 0, [[timestamp]], 0, '*', '*', '*', '*', '*', 0, 0, 0),
(11, 'moodle', '\\core\\task\\create_contexts_task', 0, [[timestamp_nextday]], 1, '0', '0', '*', '*', '*', 0, 0, 0),
(12, 'moodle', '\\core\\task\\legacy_plugin_cron_task', 0, [[timestamp]], 0, '*', '*', '*', '*', '*', 0, 0, 0),
(13, 'moodle', '\\core\\task\\grade_cron_task', 0, [[timestamp]], 0, '*', '*', '*', '*', '*', 0, 0, 0),
(14, 'moodle', '\\core\\task\\events_cron_task', 0, [[timestamp]], 0, '*', '*', '*', '*', '*', 0, 0, 0),
(15, 'moodle', '\\core\\task\\completion_regular_task', 0, [[timestamp]], 0, '*', '*', '*', '*', '*', 0, 0, 0),
(16, 'moodle', '\\core\\task\\completion_daily_task', 0, [[timestamp]], 0, '20', '13', '*', '*', '*', 0, 0, 0),
(17, 'moodle', '\\core\\task\\portfolio_cron_task', 0, [[timestamp]], 0, '*', '*', '*', '*', '*', 0, 0, 0),
(18, 'moodle', '\\core\\task\\plagiarism_cron_task', 0, [[timestamp]], 0, '*', '*', '*', '*', '*', 0, 0, 0),
(19, 'moodle', '\\core\\task\\calendar_cron_task', 0, [[timestamp]], 0, '*', '*', '*', '*', '*', 0, 0, 0),
(20, 'moodle', '\\core\\task\\blog_cron_task', 0, [[timestamp]], 0, '*', '*', '*', '*', '*', 0, 0, 0),
(21, 'moodle', '\\core\\task\\question_cron_task', 0, [[timestamp]], 0, '*', '*', '*', '*', '*', 0, 0, 0),
(22, 'moodle', '\\core\\task\\registration_cron_task', 0, [[timestamp]], 0, '12', '8', '*', '*', '4', 0, 0, 0),
(23, 'moodle', '\\core\\task\\check_for_updates_task', 0, [[timestamp]], 0, '0', '*/2', '*', '*', '*', 0, 0, 0),
(24, 'moodle', '\\core\\task\\cache_cron_task', 0, [[timestamp]], 0, '50', '*', '*', '*', '*', 0, 0, 0),
(25, 'moodle', '\\core\\task\\automated_backup_task', 0, [[timestamp]], 0, '50', '*', '*', '*', '*', 0, 0, 0),
(26, 'moodle', '\\core\\task\\badges_cron_task', 0, [[timestamp]], 0, '*/5', '*', '*', '*', '*', 0, 0, 0),
(27, 'moodle', '\\core\\task\\file_temp_cleanup_task', 0, [[timestamp]], 0, '55', '*/6', '*', '*', '*', 0, 0, 0),
(28, 'moodle', '\\core\\task\\file_trash_cleanup_task', 0, [[timestamp]], 0, '55', '*/6', '*', '*', '*', 0, 0, 0),
(29, 'moodle', '\\core\\task\\search_index_task', 0, [[timestamp]], 0, '*/30', '*', '*', '*', '*', 0, 0, 0),
(30, 'moodle', '\\core\\task\\search_optimize_task', 0, [[timestamp]], 0, '15', '*/12', '*', '*', '*', 0, 0, 0),
(31, 'moodle', '\\core\\task\\stats_cron_task', 0, [[timestamp_nextday]], 0, '0', '0', '*', '*', '*', 0, 0, 0),
(32, 'moodle', '\\core\\task\\password_reset_cleanup_task', 0, [[timestamp]], 0, '0', '*/6', '*', '*', '*', 0, 0, 0),
(33, 'moodle', '\\core\\task\\complete_plans_task', 0, [[timestamp]], 0, '6', '*', '*', '*', '*', 0, 0, 0),
(34, 'moodle', '\\core\\task\\sync_plans_from_template_cohorts_task', 0, [[timestamp]], 0, '12', '*', '*', '*', '*', 0, 0, 0),
(35, 'moodle', '\\core_files\\task\\conversion_cleanup_task', 0, [[timestamp_nextday]], 0, '18', '2', '*', '*', '*', 0, 0, 0),
(36, 'moodle', '\\core\\oauth2\\refresh_system_tokens_task', 0, [[timestamp]], 0, '30', '*', '*', '*', '*', 0, 0, 0),
(37, 'moodle', '\\core\\task\\analytics_cleanup_task', 0, [[timestamp]], 0, '42', '*', '*', '*', '*', 0, 0, 0),
(38, 'qtype_random', '\\qtype_random\\task\\remove_unused_questions', 0, [[timestamp]], 0, '7', '*', '*', '*', '*', 0, 0, 0),
(39, 'mod_forum', '\\mod_forum\\task\\cron_task', 0, [[timestamp]], 0, '*', '*', '*', '*', '*', 0, 0, 0),
(40, 'mod_scorm', '\\mod_scorm\\task\\cron_task', 0, [[timestamp]], 0, '*/5', '*', '*', '*', '*', 0, 0, 0),
(41, 'auth_cas', '\\auth_cas\\task\\sync_task', 0, [[timestamp]], 0, '0', '0', '*', '*', '*', 0, 0, 1),
(42, 'auth_db', '\\auth_db\\task\\sync_users', 0, [[timestamp]], 0, '0', '12', '*', '*', '*', 0, 0, 1),
(43, 'auth_ldap', '\\auth_ldap\\task\\sync_roles', 0, [[timestamp_nextday]], 0, '0', '0', '*', '*', '*', 0, 0, 1),
(44, 'auth_ldap', '\\auth_ldap\\task\\sync_task', 0, [[timestamp_nextday]], 0, '0', '0', '*', '*', '*', 0, 0, 1),
(45, 'enrol_category', '\\enrol_category\\task\\enrol_category_sync', 0, [[timestamp]], 0, '*', '*', '*', '*', '*', 0, 0, 0),
(46, 'enrol_cohort', '\\enrol_cohort\\task\\enrol_cohort_sync', 0, [[timestamp]], 0, '20', '*', '*', '*', '*', 0, 0, 0),
(47, 'enrol_flatfile', '\\enrol_flatfile\\task\\flatfile_sync_task', 0, [[timestamp]], 0, '15', '*', '*', '*', '*', 0, 0, 0),
(48, 'enrol_imsenterprise', '\\enrol_imsenterprise\\task\\cron_task', 0, [[timestamp]], 0, '10', '*', '*', '*', '*', 0, 0, 0),
(49, 'enrol_ldap', '\\enrol_ldap\\task\\sync_enrolments', 0, [[timestamp_nextday]], 0, '4', '23', '*', '*', '*', 0, 0, 1),
(50, 'enrol_lti', '\\enrol_lti\\task\\sync_grades', 0, [[timestamp]], 0, '*/30', '*', '*', '*', '*', 0, 0, 0),
(51, 'enrol_lti', '\\enrol_lti\\task\\sync_members', 0, [[timestamp]], 0, '*/30', '*', '*', '*', '*', 0, 0, 0),
(52, 'enrol_manual', '\\enrol_manual\\task\\sync_enrolments', 0, [[timestamp]], 0, '*/10', '*', '*', '*', '*', 0, 0, 0),
(53, 'enrol_manual', '\\enrol_manual\\task\\send_expiry_notifications', 0, [[timestamp]], 0, '*/10', '*', '*', '*', '*', 0, 0, 0),
(54, 'enrol_meta', '\\enrol_meta\\task\\enrol_meta_sync', 0, [[timestamp]], 0, '18', '*', '*', '*', '*', 0, 0, 0),
(55, 'enrol_paypal', '\\enrol_paypal\\task\\process_expirations', 0, [[timestamp]], 0, '*', '*', '*', '*', '*', 0, 0, 0),
(56, 'enrol_self', '\\enrol_self\\task\\sync_enrolments', 0, [[timestamp]], 0, '*/10', '*', '*', '*', '*', 0, 0, 0),
(57, 'enrol_self', '\\enrol_self\\task\\send_expiry_notifications', 0, [[timestamp]], 0, '*/10', '*', '*', '*', '*', 0, 0, 0),
(58, 'editor_atto', '\\editor_atto\\task\\autosave_cleanup_task', 0, [[timestamp]], 0, '0', '12', '*', '*', '1', 0, 0, 0),
(59, 'repository_onedrive', '\\repository_onedrive\\remove_temp_access_task', 0, [[timestamp_nextday]], 0, '2', '2', '*', '*', '6', 0, 0, 0),
(60, 'tool_analytics', '\\tool_analytics\\task\\train_models', 0, [[timestamp]], 0, '0', '11', '*', '*', '*', 0, 0, 0),
(61, 'tool_analytics', '\\tool_analytics\\task\\predict_models', 0, [[timestamp]], 0, '0', '12', '*', '*', '*', 0, 0, 0),
(62, 'tool_cohortroles', '\\tool_cohortroles\\task\\cohort_role_sync', 0, [[timestamp]], 0, '15', '*', '*', '*', '*', 0, 0, 0),
(63, 'tool_dataprivacy', '\\tool_dataprivacy\\task\\expired_retention_period', 0, [[timestamp]], 0, '0', '12', '*', '*', '*', 0, 0, 0),
(64, 'tool_dataprivacy', '\\tool_dataprivacy\\task\\delete_expired_contexts', 0, [[timestamp_nextday]], 0, '0', '9', '*', '*', '*', 0, 0, 0),
(65, 'tool_dataprivacy', '\\tool_dataprivacy\\task\\delete_expired_requests', 0, [[timestamp_nextday]], 0, '9', '8', '*', '*', '*', 0, 0, 0),
(66, 'tool_dataprivacy', '\\tool_dataprivacy\\task\\delete_existing_deleted_users', 0, [[timestamp_nextday]], 0, '19', '0', '*', '*', '*', 0, 0, 1),
(67, 'tool_langimport', '\\tool_langimport\\task\\update_langpacks_task', 0, [[timestamp_nextday]], 0, '23', '4', '*', '*', '*', 0, 0, 0),
(68, 'tool_messageinbound', '\\tool_messageinbound\\task\\pickup_task', 0, [[timestamp]], 0, '*', '*', '*', '*', '*', 0, 0, 0),
(69, 'tool_messageinbound', '\\tool_messageinbound\\task\\cleanup_task', 0, [[timestamp_nextday]], 0, '55', '1', '*', '*', '*', 0, 0, 0),
(70, 'tool_monitor', '\\tool_monitor\\task\\clean_events', 0, [[timestamp]], 0, '*', '*', '*', '*', '*', 0, 0, 0),
(71, 'tool_monitor', '\\tool_monitor\\task\\check_subscriptions', 0, [[timestamp_nextday]], 0, '3', '8', '*', '*', '*', 0, 0, 0),
(72, 'tool_recyclebin', '\\tool_recyclebin\\task\\cleanup_course_bin', 0, [[timestamp]], 0, '*/30', '*', '*', '*', '*', 0, 0, 0),
(73, 'tool_recyclebin', '\\tool_recyclebin\\task\\cleanup_category_bin', 0, [[timestamp]], 0, '*/30', '*', '*', '*', '*', 0, 0, 0),
(74, 'assignfeedback_editpdf', '\\assignfeedback_editpdf\\task\\convert_submissions', 0, [[timestamp]], 0, '*/15', '*', '*', '*', '*', 0, 0, 0),
(75, 'ltiservice_gradebookservices', '\\ltiservice_gradebookservices\\task\\cleanup_task', 0, [[timestamp_nextday]], 0, '18', '6', '*', '*', '*', 0, 0, 0),
(76, 'logstore_legacy', '\\logstore_legacy\\task\\cleanup_task', 0, [[timestamp_nextday]], 0, '11', '5', '*', '*', '*', 0, 0, 0),
(77, 'logstore_standard', '\\logstore_standard\\task\\cleanup_task', 0, [[timestamp_nextday]], 0, '14', '4', '*', '*', '*', 0, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tool_cohortroles`
--

CREATE TABLE `[[dbprefix]]tool_cohortroles` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `cohortid` bigint(10) NOT NULL,
  `roleid` bigint(10) NOT NULL,
  `userid` bigint(10) NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `usermodified` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]toolcoho_cohroluse_uix` (`cohortid`,`roleid`,`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Mapping of users to cohort role assignments.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tool_customlang`
--

CREATE TABLE `[[dbprefix]]tool_customlang` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `lang` varchar(20) NOT NULL DEFAULT '',
  `componentid` bigint(10) NOT NULL,
  `stringid` varchar(255) NOT NULL DEFAULT '',
  `original` longtext NOT NULL,
  `master` longtext,
  `local` longtext,
  `timemodified` bigint(10) NOT NULL,
  `timecustomized` bigint(10) DEFAULT NULL,
  `outdated` smallint(3) DEFAULT '0',
  `modified` smallint(3) DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]toolcust_lancomstr_uix` (`lang`,`componentid`,`stringid`),
  KEY `[[dbprefix]]toolcust_com_ix` (`componentid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Contains the working checkout of all strings and their custo' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tool_customlang_components`
--

CREATE TABLE `[[dbprefix]]tool_customlang_components` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `version` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Contains the list of all installed plugins that provide thei' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tool_dataprivacy_category`
--

CREATE TABLE `[[dbprefix]]tool_dataprivacy_category` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL DEFAULT '',
  `description` longtext,
  `descriptionformat` tinyint(1) DEFAULT NULL,
  `usermodified` bigint(10) NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Data categories' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tool_dataprivacy_contextlist`
--

CREATE TABLE `[[dbprefix]]tool_dataprivacy_contextlist` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `component` varchar(255) NOT NULL DEFAULT '',
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='List of contexts for a component' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tool_dataprivacy_ctxexpired`
--

CREATE TABLE `[[dbprefix]]tool_dataprivacy_ctxexpired` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `contextid` bigint(10) NOT NULL,
  `unexpiredroles` longtext,
  `expiredroles` longtext,
  `defaultexpired` tinyint(1) NOT NULL,
  `status` tinyint(2) NOT NULL DEFAULT '0',
  `usermodified` bigint(10) NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]tooldatactxe_con_uix` (`contextid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Default comment for the table, please edit me' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tool_dataprivacy_ctxinstance`
--

CREATE TABLE `[[dbprefix]]tool_dataprivacy_ctxinstance` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `contextid` bigint(10) NOT NULL,
  `purposeid` bigint(10) DEFAULT NULL,
  `categoryid` bigint(10) DEFAULT NULL,
  `usermodified` bigint(10) NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]tooldatactxi_con_uix` (`contextid`),
  KEY `[[dbprefix]]tooldatactxi_pur_ix` (`purposeid`),
  KEY `[[dbprefix]]tooldatactxi_cat_ix` (`categoryid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Default comment for the table, please edit me' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tool_dataprivacy_ctxlevel`
--

CREATE TABLE `[[dbprefix]]tool_dataprivacy_ctxlevel` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `contextlevel` smallint(3) NOT NULL,
  `purposeid` bigint(10) DEFAULT NULL,
  `categoryid` bigint(10) DEFAULT NULL,
  `usermodified` bigint(10) NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]tooldatactxl_con_uix` (`contextlevel`),
  KEY `[[dbprefix]]tooldatactxl_cat_ix` (`categoryid`),
  KEY `[[dbprefix]]tooldatactxl_pur_ix` (`purposeid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Default comment for the table, please edit me' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tool_dataprivacy_ctxlst_ctx`
--

CREATE TABLE `[[dbprefix]]tool_dataprivacy_ctxlst_ctx` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `contextid` bigint(10) NOT NULL,
  `contextlistid` bigint(10) NOT NULL,
  `status` tinyint(2) NOT NULL DEFAULT '0',
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]tooldatactxlctx_con_ix` (`contextlistid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='A contextlist context item' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tool_dataprivacy_purpose`
--

CREATE TABLE `[[dbprefix]]tool_dataprivacy_purpose` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL DEFAULT '',
  `description` longtext,
  `descriptionformat` tinyint(1) DEFAULT NULL,
  `lawfulbases` longtext NOT NULL,
  `sensitivedatareasons` longtext,
  `retentionperiod` varchar(255) NOT NULL DEFAULT '',
  `protected` tinyint(1) DEFAULT NULL,
  `usermodified` bigint(10) NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Data purposes' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tool_dataprivacy_purposerole`
--

CREATE TABLE `[[dbprefix]]tool_dataprivacy_purposerole` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `purposeid` bigint(10) NOT NULL,
  `roleid` bigint(10) NOT NULL,
  `lawfulbases` longtext,
  `sensitivedatareasons` longtext,
  `retentionperiod` varchar(255) NOT NULL DEFAULT '',
  `protected` tinyint(1) DEFAULT NULL,
  `usermodified` bigint(10) NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]tooldatapurp_purrol_uix` (`purposeid`,`roleid`),
  KEY `[[dbprefix]]tooldatapurp_pur_ix` (`purposeid`),
  KEY `[[dbprefix]]tooldatapurp_rol_ix` (`roleid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Data purpose overrides for a specific role' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tool_dataprivacy_request`
--

CREATE TABLE `[[dbprefix]]tool_dataprivacy_request` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `type` bigint(10) NOT NULL DEFAULT '0',
  `comments` longtext,
  `commentsformat` tinyint(2) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `requestedby` bigint(10) NOT NULL DEFAULT '0',
  `status` tinyint(2) NOT NULL DEFAULT '0',
  `dpo` bigint(10) DEFAULT '0',
  `dpocomment` longtext,
  `dpocommentformat` tinyint(2) NOT NULL DEFAULT '0',
  `usermodified` bigint(10) NOT NULL DEFAULT '0',
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `creationmethod` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]tooldatarequ_use_ix` (`userid`),
  KEY `[[dbprefix]]tooldatarequ_req_ix` (`requestedby`),
  KEY `[[dbprefix]]tooldatarequ_dpo_ix` (`dpo`),
  KEY `[[dbprefix]]tooldatarequ_use2_ix` (`usermodified`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Table for data requests' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tool_dataprivacy_rqst_ctxlst`
--

CREATE TABLE `[[dbprefix]]tool_dataprivacy_rqst_ctxlst` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `requestid` bigint(10) NOT NULL,
  `contextlistid` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]tooldatarqstctxl_req_uix` (`requestid`,`contextlistid`),
  KEY `[[dbprefix]]tooldatarqstctxl_req_ix` (`requestid`),
  KEY `[[dbprefix]]tooldatarqstctxl_con_ix` (`contextlistid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Association table joining requests and contextlists' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tool_monitor_events`
--

CREATE TABLE `[[dbprefix]]tool_monitor_events` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `eventname` varchar(254) NOT NULL DEFAULT '',
  `contextid` bigint(10) NOT NULL,
  `contextlevel` bigint(10) NOT NULL,
  `contextinstanceid` bigint(10) NOT NULL,
  `link` varchar(254) NOT NULL DEFAULT '',
  `courseid` bigint(10) NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='A table that keeps a log of events related to subscriptions' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tool_monitor_history`
--

CREATE TABLE `[[dbprefix]]tool_monitor_history` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `sid` bigint(10) NOT NULL,
  `userid` bigint(10) NOT NULL,
  `timesent` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]toolmonihist_siduset_uix` (`sid`,`userid`,`timesent`),
  KEY `[[dbprefix]]toolmonihist_sid_ix` (`sid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Table to store history of message notifications sent' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tool_monitor_rules`
--

CREATE TABLE `[[dbprefix]]tool_monitor_rules` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `description` longtext,
  `descriptionformat` tinyint(1) NOT NULL,
  `name` varchar(254) NOT NULL DEFAULT '',
  `userid` bigint(10) NOT NULL,
  `courseid` bigint(10) NOT NULL,
  `plugin` varchar(254) NOT NULL DEFAULT '',
  `eventname` varchar(254) NOT NULL DEFAULT '',
  `template` longtext NOT NULL,
  `templateformat` tinyint(1) NOT NULL,
  `frequency` smallint(4) NOT NULL,
  `timewindow` mediumint(5) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]toolmonirule_couuse_ix` (`courseid`,`userid`),
  KEY `[[dbprefix]]toolmonirule_eve_ix` (`eventname`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Table to store rules' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tool_monitor_subscriptions`
--

CREATE TABLE `[[dbprefix]]tool_monitor_subscriptions` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `courseid` bigint(10) NOT NULL,
  `ruleid` bigint(10) NOT NULL,
  `cmid` bigint(10) NOT NULL,
  `userid` bigint(10) NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  `lastnotificationsent` bigint(10) NOT NULL DEFAULT '0',
  `inactivedate` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]toolmonisubs_couuse_ix` (`courseid`,`userid`),
  KEY `[[dbprefix]]toolmonisubs_rul_ix` (`ruleid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Table to store user subscriptions to various rules' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tool_policy`
--

CREATE TABLE `[[dbprefix]]tool_policy` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `sortorder` mediumint(5) NOT NULL DEFAULT '999',
  `currentversionid` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]toolpoli_cur_ix` (`currentversionid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Contains the list of policy documents defined on the site.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tool_policy_acceptances`
--

CREATE TABLE `[[dbprefix]]tool_policy_acceptances` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `policyversionid` bigint(10) NOT NULL,
  `userid` bigint(10) NOT NULL,
  `status` tinyint(1) DEFAULT NULL,
  `lang` varchar(30) NOT NULL DEFAULT '',
  `usermodified` bigint(10) NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `note` longtext,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]toolpoliacce_poluse_uix` (`policyversionid`,`userid`),
  KEY `[[dbprefix]]toolpoliacce_pol_ix` (`policyversionid`),
  KEY `[[dbprefix]]toolpoliacce_use_ix` (`userid`),
  KEY `[[dbprefix]]toolpoliacce_use2_ix` (`usermodified`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Tracks users accepting the policy versions' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tool_policy_versions`
--

CREATE TABLE `[[dbprefix]]tool_policy_versions` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(1333) NOT NULL DEFAULT '',
  `type` smallint(3) NOT NULL DEFAULT '0',
  `audience` smallint(3) NOT NULL DEFAULT '0',
  `archived` smallint(3) NOT NULL DEFAULT '0',
  `usermodified` bigint(10) NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `policyid` bigint(10) NOT NULL,
  `revision` varchar(1333) NOT NULL DEFAULT '',
  `summary` longtext NOT NULL,
  `summaryformat` smallint(3) NOT NULL,
  `content` longtext NOT NULL,
  `contentformat` smallint(3) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]toolpolivers_use_ix` (`usermodified`),
  KEY `[[dbprefix]]toolpolivers_pol_ix` (`policyid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Holds versions of the policy documents' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tool_recyclebin_category`
--

CREATE TABLE `[[dbprefix]]tool_recyclebin_category` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `categoryid` bigint(10) NOT NULL,
  `shortname` varchar(255) NOT NULL DEFAULT '',
  `fullname` varchar(255) NOT NULL DEFAULT '',
  `timecreated` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]toolrecycate_tim_ix` (`timecreated`),
  KEY `[[dbprefix]]toolrecycate_cat_ix` (`categoryid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='A list of items in the category recycle bin' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tool_recyclebin_course`
--

CREATE TABLE `[[dbprefix]]tool_recyclebin_course` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `courseid` bigint(10) NOT NULL,
  `section` bigint(10) NOT NULL,
  `module` bigint(10) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]toolrecycour_tim_ix` (`timecreated`),
  KEY `[[dbprefix]]toolrecycour_cou_ix` (`courseid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='A list of items in the course recycle bin' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tool_usertours_steps`
--

CREATE TABLE `[[dbprefix]]tool_usertours_steps` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `tourid` bigint(10) NOT NULL,
  `title` longtext,
  `content` longtext,
  `targettype` tinyint(2) NOT NULL,
  `targetvalue` longtext NOT NULL,
  `sortorder` bigint(10) NOT NULL DEFAULT '0',
  `configdata` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]tooluserstep_tousor_ix` (`tourid`,`sortorder`),
  KEY `[[dbprefix]]tooluserstep_tou_ix` (`tourid`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Steps in an tour' AUTO_INCREMENT=15 ;

--
-- Dumping data for table `[[dbprefix]]tool_usertours_steps`
--

INSERT INTO `[[dbprefix]]tool_usertours_steps` VALUES
(1, 1, 'tour1_title_welcome,tool_usertours', 'tour1_content_welcome,tool_usertours', 2, '', 0, '{}'),
(2, 1, 'tour1_title_navigation,tool_usertours', 'tour1_content_navigation,tool_usertours', 0, '[data-region="drawer-toggle"] button[data-action="toggle-drawer"]', 1, '{}'),
(3, 1, 'tour1_title_customisation,tool_usertours', 'tour1_content_customisation,tool_usertours', 0, 'body:not(.editing) #page-header .card-block', 2, '{"placement":"bottom"}'),
(4, 1, 'tour1_title_blockregion,tool_usertours', 'tour1_content_blockregion,tool_usertours', 0, 'body.editing [data-region="blocks-column"]', 3, '{}'),
(5, 1, 'tour1_title_addingblocks,tool_usertours', 'tour1_content_addingblocks,tool_usertours', 0, 'body.editing [data-region="blocks-column"]', 4, '{"placement":"bottom"}'),
(6, 1, 'tour1_title_end,tool_usertours', 'tour1_content_end,tool_usertours', 2, '', 5, '{}'),
(7, 2, 'tour2_title_welcome,tool_usertours', 'tour2_content_welcome,tool_usertours', 2, '', 0, '{}'),
(8, 2, 'tour2_title_customisation,tool_usertours', 'tour2_content_customisation,tool_usertours', 0, 'body:not(.editing) #page-header .card-block', 1, '{}'),
(9, 2, 'tour2_title_navigation,tool_usertours', 'tour2_content_navigation,tool_usertours', 0, '[data-region="drawer-toggle"] button[data-action="toggle-drawer"]', 2, '{}'),
(10, 2, 'tour2_title_opendrawer,tool_usertours', 'tour2_content_opendrawer,tool_usertours', 0, 'body:not(.drawer-open-left) [data-region="drawer-toggle"] button[data-action="toggle-drawer"]', 3, '{}'),
(11, 2, 'tour2_title_participants,tool_usertours', 'tour2_content_participants,tool_usertours', 0, 'body.drawer-open-left [data-region="drawer"] [data-key="participants"]', 4, '{"placement":"bottom","backdrop":"0"}'),
(12, 2, 'tour2_title_addblock,tool_usertours', 'tour2_content_addblock,tool_usertours', 0, 'body.drawer-open-left:not(.editing) [data-region="drawer"]', 5, '{"placement":"right","orphan":"0","backdrop":"0","reflex":"0"}'),
(13, 2, 'tour2_title_addingblocks,tool_usertours', 'tour2_content_addingblocks,tool_usertours', 0, 'body.drawer-open-left.editing [data-region="drawer"] [data-key="addblock"]', 6, '{"backdrop":"0","placement":"top"}'),
(14, 2, 'tour2_title_end,tool_usertours', 'tour2_content_end,tool_usertours', 2, '', 7, '{}');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tool_usertours_tours`
--

CREATE TABLE `[[dbprefix]]tool_usertours_tours` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `description` longtext,
  `pathmatch` varchar(255) DEFAULT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT '0',
  `sortorder` bigint(10) NOT NULL DEFAULT '0',
  `configdata` longtext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='List of tours' AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]tool_usertours_tours`
--

INSERT INTO `[[dbprefix]]tool_usertours_tours` VALUES
(1, 'Boost - administrator', 'A tour of some new features in the Boost theme, for administrators', 'FRONTPAGE', 1, 0, '{"placement":"bottom","orphan":"0","backdrop":"1","reflex":"0","filtervalues":{"role":["-1"],"theme":["boost"]},"majorupdatetime":1479366244,"default_tour":true,"filename":"boost_administrator.json","version":1,"shipped_tour":true,"shipped_filename":"boost_administrator.json","shipped_version":1}'),
(2, 'Boost - course view', 'A tour for introducing administrators and teachers to courses in the Boost theme', '/course/view.php%', 1, 1, '{"placement":"bottom","orphan":"0","backdrop":"1","reflex":"0","filtervalues":{"role":["-1","editingteacher"],"theme":["boost"]},"majorupdatetime":1480050104,"shipped_tour":true,"shipped_filename":"boost_course_view.json","shipped_version":1}');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]upgrade_log`
--

CREATE TABLE `[[dbprefix]]upgrade_log` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `type` bigint(10) NOT NULL,
  `plugin` varchar(100) DEFAULT NULL,
  `version` varchar(100) DEFAULT NULL,
  `targetversion` varchar(100) DEFAULT NULL,
  `info` varchar(255) NOT NULL DEFAULT '',
  `details` longtext,
  `backtrace` longtext,
  `userid` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]upgrlog_tim_ix` (`timemodified`),
  KEY `[[dbprefix]]upgrlog_typtim_ix` (`type`,`timemodified`),
  KEY `[[dbprefix]]upgrlog_use_ix` (`userid`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Upgrade logging' AUTO_INCREMENT=1185 ;

--
-- Dumping data for table `[[dbprefix]]upgrade_log`
--

INSERT INTO `[[dbprefix]]upgrade_log` VALUES
(1, 0, 'core', '2018051718', '2018051718', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(2, 0, 'core', '2018051718', '2018051718', 'Core installed', NULL, '', 0, [[timestamp]]),
(3, 0, 'antivirus_clamav', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(4, 0, 'antivirus_clamav', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(5, 0, 'antivirus_clamav', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(6, 0, 'availability_completion', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(7, 0, 'availability_completion', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(8, 0, 'availability_completion', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(9, 0, 'availability_date', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(10, 0, 'availability_date', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(11, 0, 'availability_date', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(12, 0, 'availability_grade', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(13, 0, 'availability_grade', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(14, 0, 'availability_grade', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(15, 0, 'availability_group', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(16, 0, 'availability_group', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(17, 0, 'availability_group', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(18, 0, 'availability_grouping', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(19, 0, 'availability_grouping', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(20, 0, 'availability_grouping', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(21, 0, 'availability_profile', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(22, 0, 'availability_profile', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(23, 0, 'availability_profile', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(24, 0, 'qtype_calculated', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(25, 0, 'qtype_calculated', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(26, 0, 'qtype_calculated', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(27, 0, 'qtype_calculatedmulti', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(28, 0, 'qtype_calculatedmulti', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(29, 0, 'qtype_calculatedmulti', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(30, 0, 'qtype_calculatedsimple', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(31, 0, 'qtype_calculatedsimple', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(32, 0, 'qtype_calculatedsimple', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(33, 0, 'qtype_ddimageortext', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(34, 0, 'qtype_ddimageortext', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(35, 0, 'qtype_ddimageortext', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(36, 0, 'qtype_ddmarker', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(37, 0, 'qtype_ddmarker', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(38, 0, 'qtype_ddmarker', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(39, 0, 'qtype_ddwtos', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(40, 0, 'qtype_ddwtos', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(41, 0, 'qtype_ddwtos', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(42, 0, 'qtype_description', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(43, 0, 'qtype_description', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(44, 0, 'qtype_description', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(45, 0, 'qtype_essay', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(46, 0, 'qtype_essay', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(47, 0, 'qtype_essay', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(48, 0, 'qtype_gapselect', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(49, 0, 'qtype_gapselect', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(50, 0, 'qtype_gapselect', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(51, 0, 'qtype_match', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(52, 0, 'qtype_match', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(53, 0, 'qtype_match', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(54, 0, 'qtype_missingtype', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(55, 0, 'qtype_missingtype', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(56, 0, 'qtype_missingtype', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(57, 0, 'qtype_multianswer', NULL, '2018051401', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(58, 0, 'qtype_multianswer', '2018051401', '2018051401', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(59, 0, 'qtype_multianswer', '2018051401', '2018051401', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(60, 0, 'qtype_multichoice', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(61, 0, 'qtype_multichoice', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(62, 0, 'qtype_multichoice', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(63, 0, 'qtype_numerical', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(64, 0, 'qtype_numerical', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(65, 0, 'qtype_numerical', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(66, 0, 'qtype_random', NULL, '2018051401', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(67, 0, 'qtype_random', '2018051401', '2018051401', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(68, 0, 'qtype_random', '2018051401', '2018051401', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(69, 0, 'qtype_randomsamatch', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(70, 0, 'qtype_randomsamatch', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(71, 0, 'qtype_randomsamatch', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(72, 0, 'qtype_shortanswer', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(73, 0, 'qtype_shortanswer', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(74, 0, 'qtype_shortanswer', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(75, 0, 'qtype_truefalse', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(76, 0, 'qtype_truefalse', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(77, 0, 'qtype_truefalse', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(78, 0, 'mod_assign', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(79, 0, 'mod_assign', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(80, 0, 'mod_assign', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(81, 0, 'mod_assignment', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(82, 0, 'mod_assignment', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(83, 0, 'mod_assignment', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(84, 0, 'mod_book', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(85, 0, 'mod_book', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(86, 0, 'mod_book', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(87, 0, 'mod_chat', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(88, 0, 'mod_chat', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(89, 0, 'mod_chat', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(90, 0, 'mod_choice', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(91, 0, 'mod_choice', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(92, 0, 'mod_choice', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(93, 0, 'mod_data', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(94, 0, 'mod_data', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(95, 0, 'mod_data', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(96, 0, 'mod_feedback', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(97, 0, 'mod_feedback', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(98, 0, 'mod_feedback', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(99, 0, 'mod_folder', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(100, 0, 'mod_folder', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(101, 0, 'mod_folder', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(102, 0, 'mod_forum', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(103, 0, 'mod_forum', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(104, 0, 'mod_forum', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(105, 0, 'mod_glossary', NULL, '2018051401', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(106, 0, 'mod_glossary', '2018051401', '2018051401', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(107, 0, 'mod_glossary', '2018051401', '2018051401', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(108, 0, 'mod_imscp', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(109, 0, 'mod_imscp', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(110, 0, 'mod_imscp', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(111, 0, 'mod_label', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(112, 0, 'mod_label', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(113, 0, 'mod_label', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(114, 0, 'mod_lesson', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(115, 0, 'mod_lesson', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(116, 0, 'mod_lesson', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(117, 0, 'mod_lti', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(118, 0, 'mod_lti', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(119, 0, 'mod_lti', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(120, 0, 'mod_page', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(121, 0, 'mod_page', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(122, 0, 'mod_page', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(123, 0, 'mod_quiz', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(124, 0, 'mod_quiz', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(125, 0, 'mod_quiz', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(126, 0, 'mod_resource', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(127, 0, 'mod_resource', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(128, 0, 'mod_resource', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(129, 0, 'mod_scorm', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(130, 0, 'mod_scorm', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(131, 0, 'mod_scorm', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(132, 0, 'mod_survey', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(133, 0, 'mod_survey', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(134, 0, 'mod_survey', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(135, 0, 'mod_url', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(136, 0, 'mod_url', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(137, 0, 'mod_url', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(138, 0, 'mod_wiki', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(139, 0, 'mod_wiki', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(140, 0, 'mod_wiki', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(141, 0, 'mod_workshop', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(142, 0, 'mod_workshop', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(143, 0, 'mod_workshop', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(144, 0, 'auth_cas', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(145, 0, 'auth_cas', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(146, 0, 'auth_cas', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(147, 0, 'auth_db', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(148, 0, 'auth_db', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(149, 0, 'auth_db', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(150, 0, 'auth_email', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(151, 0, 'auth_email', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(152, 0, 'auth_email', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(153, 0, 'auth_ldap', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(154, 0, 'auth_ldap', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(155, 0, 'auth_ldap', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(156, 0, 'auth_lti', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(157, 0, 'auth_lti', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(158, 0, 'auth_lti', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(159, 0, 'auth_manual', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(160, 0, 'auth_manual', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(161, 0, 'auth_manual', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(162, 0, 'auth_mnet', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(163, 0, 'auth_mnet', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(164, 0, 'auth_mnet', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(165, 0, 'auth_nologin', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(166, 0, 'auth_nologin', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(167, 0, 'auth_nologin', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(168, 0, 'auth_none', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(169, 0, 'auth_none', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(170, 0, 'auth_none', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(171, 0, 'auth_oauth2', NULL, '2018051401', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(172, 0, 'auth_oauth2', '2018051401', '2018051401', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(173, 0, 'auth_oauth2', '2018051401', '2018051401', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(174, 0, 'auth_shibboleth', NULL, '2018051401', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(175, 0, 'auth_shibboleth', '2018051401', '2018051401', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(176, 0, 'auth_shibboleth', '2018051401', '2018051401', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(177, 0, 'auth_webservice', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(178, 0, 'auth_webservice', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(179, 0, 'auth_webservice', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(180, 0, 'calendartype_gregorian', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(181, 0, 'calendartype_gregorian', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(182, 0, 'calendartype_gregorian', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(183, 0, 'enrol_category', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(184, 0, 'enrol_category', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(185, 0, 'enrol_category', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(186, 0, 'enrol_cohort', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(187, 0, 'enrol_cohort', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(188, 0, 'enrol_cohort', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(189, 0, 'enrol_database', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(190, 0, 'enrol_database', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(191, 0, 'enrol_database', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(192, 0, 'enrol_flatfile', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(193, 0, 'enrol_flatfile', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(194, 0, 'enrol_flatfile', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(195, 0, 'enrol_guest', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(196, 0, 'enrol_guest', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(197, 0, 'enrol_guest', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(198, 0, 'enrol_imsenterprise', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(199, 0, 'enrol_imsenterprise', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(200, 0, 'enrol_imsenterprise', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(201, 0, 'enrol_ldap', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(202, 0, 'enrol_ldap', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(203, 0, 'enrol_ldap', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(204, 0, 'enrol_lti', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(205, 0, 'enrol_lti', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(206, 0, 'enrol_lti', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(207, 0, 'enrol_manual', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(208, 0, 'enrol_manual', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(209, 0, 'enrol_manual', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(210, 0, 'enrol_meta', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(211, 0, 'enrol_meta', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(212, 0, 'enrol_meta', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(213, 0, 'enrol_mnet', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(214, 0, 'enrol_mnet', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(215, 0, 'enrol_mnet', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(216, 0, 'enrol_paypal', NULL, '2018051405', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(217, 0, 'enrol_paypal', '2018051405', '2018051405', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(218, 0, 'enrol_paypal', '2018051405', '2018051405', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(219, 0, 'enrol_self', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(220, 0, 'enrol_self', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(221, 0, 'enrol_self', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(222, 0, 'message_airnotifier', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(223, 0, 'message_airnotifier', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(224, 0, 'message_airnotifier', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(225, 0, 'message_email', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(226, 0, 'message_email', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(227, 0, 'message_email', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(228, 0, 'message_jabber', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(229, 0, 'message_jabber', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(230, 0, 'message_jabber', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(231, 0, 'message_popup', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(232, 0, 'message_popup', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(233, 0, 'message_popup', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(234, 0, 'block_activity_modules', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(235, 0, 'block_activity_modules', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(236, 0, 'block_activity_modules', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(237, 0, 'block_activity_results', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(238, 0, 'block_activity_results', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(239, 0, 'block_activity_results', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(240, 0, 'block_admin_bookmarks', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(241, 0, 'block_admin_bookmarks', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(242, 0, 'block_admin_bookmarks', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(243, 0, 'block_badges', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(244, 0, 'block_badges', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(245, 0, 'block_badges', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(246, 0, 'block_blog_menu', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(247, 0, 'block_blog_menu', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(248, 0, 'block_blog_menu', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(249, 0, 'block_blog_recent', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(250, 0, 'block_blog_recent', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(251, 0, 'block_blog_recent', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(252, 0, 'block_blog_tags', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(253, 0, 'block_blog_tags', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(254, 0, 'block_blog_tags', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(255, 0, 'block_calendar_month', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(256, 0, 'block_calendar_month', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(257, 0, 'block_calendar_month', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(258, 0, 'block_calendar_upcoming', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(259, 0, 'block_calendar_upcoming', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(260, 0, 'block_calendar_upcoming', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(261, 0, 'block_comments', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(262, 0, 'block_comments', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(263, 0, 'block_comments', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(264, 0, 'block_community', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(265, 0, 'block_community', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(266, 0, 'block_community', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(267, 0, 'block_completionstatus', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(268, 0, 'block_completionstatus', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(269, 0, 'block_completionstatus', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(270, 0, 'block_course_list', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(271, 0, 'block_course_list', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(272, 0, 'block_course_list', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(273, 0, 'block_course_summary', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(274, 0, 'block_course_summary', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(275, 0, 'block_course_summary', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(276, 0, 'block_feedback', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(277, 0, 'block_feedback', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(278, 0, 'block_feedback', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(279, 0, 'block_globalsearch', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(280, 0, 'block_globalsearch', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(281, 0, 'block_globalsearch', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(282, 0, 'block_glossary_random', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(283, 0, 'block_glossary_random', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(284, 0, 'block_glossary_random', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(285, 0, 'block_html', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(286, 0, 'block_html', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(287, 0, 'block_html', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(288, 0, 'block_login', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(289, 0, 'block_login', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(290, 0, 'block_login', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(291, 0, 'block_lp', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(292, 0, 'block_lp', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(293, 0, 'block_lp', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(294, 0, 'block_mentees', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(295, 0, 'block_mentees', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(296, 0, 'block_mentees', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(297, 0, 'block_mnet_hosts', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(298, 0, 'block_mnet_hosts', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(299, 0, 'block_mnet_hosts', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(300, 0, 'block_myoverview', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(301, 0, 'block_myoverview', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(302, 0, 'block_myoverview', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(303, 0, 'block_myprofile', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(304, 0, 'block_myprofile', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(305, 0, 'block_myprofile', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(306, 0, 'block_navigation', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(307, 0, 'block_navigation', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(308, 0, 'block_navigation', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(309, 0, 'block_news_items', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(310, 0, 'block_news_items', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(311, 0, 'block_news_items', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(312, 0, 'block_online_users', NULL, '2018051401', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(313, 0, 'block_online_users', '2018051401', '2018051401', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(314, 0, 'block_online_users', '2018051401', '2018051401', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(315, 0, 'block_participants', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(316, 0, 'block_participants', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(317, 0, 'block_participants', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(318, 0, 'block_private_files', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(319, 0, 'block_private_files', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(320, 0, 'block_private_files', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(321, 0, 'block_quiz_results', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(322, 0, 'block_quiz_results', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(323, 0, 'block_quiz_results', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(324, 0, 'block_recent_activity', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(325, 0, 'block_recent_activity', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(326, 0, 'block_recent_activity', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(327, 0, 'block_rss_client', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(328, 0, 'block_rss_client', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(329, 0, 'block_rss_client', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(330, 0, 'block_search_forums', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(331, 0, 'block_search_forums', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(332, 0, 'block_search_forums', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(333, 0, 'block_section_links', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(334, 0, 'block_section_links', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(335, 0, 'block_section_links', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(336, 0, 'block_selfcompletion', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(337, 0, 'block_selfcompletion', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(338, 0, 'block_selfcompletion', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(339, 0, 'block_settings', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(340, 0, 'block_settings', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(341, 0, 'block_settings', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(342, 0, 'block_site_main_menu', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(343, 0, 'block_site_main_menu', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(344, 0, 'block_site_main_menu', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(345, 0, 'block_social_activities', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(346, 0, 'block_social_activities', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(347, 0, 'block_social_activities', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(348, 0, 'block_tag_flickr', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(349, 0, 'block_tag_flickr', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(350, 0, 'block_tag_flickr', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(351, 0, 'block_tag_youtube', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(352, 0, 'block_tag_youtube', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(353, 0, 'block_tag_youtube', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(354, 0, 'block_tags', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(355, 0, 'block_tags', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(356, 0, 'block_tags', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(357, 0, 'media_html5audio', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(358, 0, 'media_html5audio', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(359, 0, 'media_html5audio', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(360, 0, 'media_html5video', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(361, 0, 'media_html5video', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(362, 0, 'media_html5video', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(363, 0, 'media_swf', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(364, 0, 'media_swf', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(365, 0, 'media_swf', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(366, 0, 'media_videojs', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(367, 0, 'media_videojs', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(368, 0, 'media_videojs', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(369, 0, 'media_vimeo', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(370, 0, 'media_vimeo', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(371, 0, 'media_vimeo', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(372, 0, 'media_youtube', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(373, 0, 'media_youtube', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(374, 0, 'media_youtube', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(375, 0, 'filter_activitynames', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(376, 0, 'filter_activitynames', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(377, 0, 'filter_activitynames', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(378, 0, 'filter_algebra', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(379, 0, 'filter_algebra', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(380, 0, 'filter_algebra', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(381, 0, 'filter_censor', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(382, 0, 'filter_censor', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(383, 0, 'filter_censor', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(384, 0, 'filter_data', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(385, 0, 'filter_data', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(386, 0, 'filter_data', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(387, 0, 'filter_emailprotect', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(388, 0, 'filter_emailprotect', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(389, 0, 'filter_emailprotect', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(390, 0, 'filter_emoticon', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(391, 0, 'filter_emoticon', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(392, 0, 'filter_emoticon', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(393, 0, 'filter_glossary', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(394, 0, 'filter_glossary', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(395, 0, 'filter_glossary', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(396, 0, 'filter_mathjaxloader', NULL, '2018051401', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(397, 0, 'filter_mathjaxloader', '2018051401', '2018051401', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(398, 0, 'filter_mathjaxloader', '2018051401', '2018051401', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(399, 0, 'filter_mediaplugin', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(400, 0, 'filter_mediaplugin', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(401, 0, 'filter_mediaplugin', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(402, 0, 'filter_multilang', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(403, 0, 'filter_multilang', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(404, 0, 'filter_multilang', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(405, 0, 'filter_tex', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(406, 0, 'filter_tex', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(407, 0, 'filter_tex', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(408, 0, 'filter_tidy', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(409, 0, 'filter_tidy', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(410, 0, 'filter_tidy', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(411, 0, 'filter_urltolink', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(412, 0, 'filter_urltolink', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(413, 0, 'filter_urltolink', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(414, 0, 'editor_atto', NULL, '2018051401', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(415, 0, 'editor_atto', '2018051401', '2018051401', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(416, 0, 'editor_atto', '2018051401', '2018051401', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(417, 0, 'editor_textarea', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(418, 0, 'editor_textarea', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(419, 0, 'editor_textarea', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(420, 0, 'editor_tinymce', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(421, 0, 'editor_tinymce', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(422, 0, 'editor_tinymce', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(423, 0, 'format_singleactivity', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(424, 0, 'format_singleactivity', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(425, 0, 'format_singleactivity', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(426, 0, 'format_social', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(427, 0, 'format_social', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(428, 0, 'format_social', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(429, 0, 'format_topics', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(430, 0, 'format_topics', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(431, 0, 'format_topics', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(432, 0, 'format_weeks', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(433, 0, 'format_weeks', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(434, 0, 'format_weeks', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(435, 0, 'dataformat_csv', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(436, 0, 'dataformat_csv', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(437, 0, 'dataformat_csv', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(438, 0, 'dataformat_excel', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(439, 0, 'dataformat_excel', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(440, 0, 'dataformat_excel', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(441, 0, 'dataformat_html', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(442, 0, 'dataformat_html', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(443, 0, 'dataformat_html', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(444, 0, 'dataformat_json', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(445, 0, 'dataformat_json', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(446, 0, 'dataformat_json', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(447, 0, 'dataformat_ods', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(448, 0, 'dataformat_ods', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(449, 0, 'dataformat_ods', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(450, 0, 'profilefield_checkbox', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(451, 0, 'profilefield_checkbox', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(452, 0, 'profilefield_checkbox', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(453, 0, 'profilefield_datetime', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(454, 0, 'profilefield_datetime', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(455, 0, 'profilefield_datetime', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(456, 0, 'profilefield_menu', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(457, 0, 'profilefield_menu', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(458, 0, 'profilefield_menu', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(459, 0, 'profilefield_text', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(460, 0, 'profilefield_text', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(461, 0, 'profilefield_text', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(462, 0, 'profilefield_textarea', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(463, 0, 'profilefield_textarea', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(464, 0, 'profilefield_textarea', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(465, 0, 'report_backups', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(466, 0, 'report_backups', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(467, 0, 'report_backups', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(468, 0, 'report_competency', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(469, 0, 'report_competency', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(470, 0, 'report_competency', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(471, 0, 'report_completion', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(472, 0, 'report_completion', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(473, 0, 'report_completion', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(474, 0, 'report_configlog', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(475, 0, 'report_configlog', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(476, 0, 'report_configlog', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(477, 0, 'report_courseoverview', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(478, 0, 'report_courseoverview', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(479, 0, 'report_courseoverview', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(480, 0, 'report_eventlist', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(481, 0, 'report_eventlist', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]);
INSERT INTO `[[dbprefix]]upgrade_log` VALUES
(482, 0, 'report_eventlist', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(483, 0, 'report_insights', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(484, 0, 'report_insights', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(485, 0, 'report_insights', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(486, 0, 'report_log', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(487, 0, 'report_log', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(488, 0, 'report_log', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(489, 0, 'report_loglive', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(490, 0, 'report_loglive', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(491, 0, 'report_loglive', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(492, 0, 'report_outline', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(493, 0, 'report_outline', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(494, 0, 'report_outline', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(495, 0, 'report_participation', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(496, 0, 'report_participation', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(497, 0, 'report_participation', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(498, 0, 'report_performance', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(499, 0, 'report_performance', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(500, 0, 'report_performance', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(501, 0, 'report_progress', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(502, 0, 'report_progress', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(503, 0, 'report_progress', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(504, 0, 'report_questioninstances', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(505, 0, 'report_questioninstances', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(506, 0, 'report_questioninstances', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(507, 0, 'report_security', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(508, 0, 'report_security', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(509, 0, 'report_security', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(510, 0, 'report_stats', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(511, 0, 'report_stats', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(512, 0, 'report_stats', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(513, 0, 'report_usersessions', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(514, 0, 'report_usersessions', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(515, 0, 'report_usersessions', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(516, 0, 'gradeexport_ods', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(517, 0, 'gradeexport_ods', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(518, 0, 'gradeexport_ods', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(519, 0, 'gradeexport_txt', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(520, 0, 'gradeexport_txt', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(521, 0, 'gradeexport_txt', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(522, 0, 'gradeexport_xls', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(523, 0, 'gradeexport_xls', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(524, 0, 'gradeexport_xls', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(525, 0, 'gradeexport_xml', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(526, 0, 'gradeexport_xml', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(527, 0, 'gradeexport_xml', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(528, 0, 'gradeimport_csv', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(529, 0, 'gradeimport_csv', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(530, 0, 'gradeimport_csv', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(531, 0, 'gradeimport_direct', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(532, 0, 'gradeimport_direct', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(533, 0, 'gradeimport_direct', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(534, 0, 'gradeimport_xml', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(535, 0, 'gradeimport_xml', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(536, 0, 'gradeimport_xml', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(537, 0, 'gradereport_grader', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(538, 0, 'gradereport_grader', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(539, 0, 'gradereport_grader', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(540, 0, 'gradereport_history', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(541, 0, 'gradereport_history', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(542, 0, 'gradereport_history', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(543, 0, 'gradereport_outcomes', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(544, 0, 'gradereport_outcomes', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(545, 0, 'gradereport_outcomes', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(546, 0, 'gradereport_overview', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(547, 0, 'gradereport_overview', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(548, 0, 'gradereport_overview', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(549, 0, 'gradereport_singleview', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(550, 0, 'gradereport_singleview', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(551, 0, 'gradereport_singleview', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(552, 0, 'gradereport_user', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(553, 0, 'gradereport_user', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(554, 0, 'gradereport_user', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(555, 0, 'gradingform_guide', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(556, 0, 'gradingform_guide', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(557, 0, 'gradingform_guide', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(558, 0, 'gradingform_rubric', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(559, 0, 'gradingform_rubric', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(560, 0, 'gradingform_rubric', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(561, 0, 'mlbackend_php', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(562, 0, 'mlbackend_php', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(563, 0, 'mlbackend_php', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(564, 0, 'mlbackend_python', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(565, 0, 'mlbackend_python', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(566, 0, 'mlbackend_python', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(567, 0, 'mnetservice_enrol', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(568, 0, 'mnetservice_enrol', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(569, 0, 'mnetservice_enrol', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(570, 0, 'webservice_rest', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(571, 0, 'webservice_rest', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(572, 0, 'webservice_rest', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(573, 0, 'webservice_soap', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(574, 0, 'webservice_soap', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(575, 0, 'webservice_soap', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(576, 0, 'webservice_xmlrpc', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(577, 0, 'webservice_xmlrpc', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(578, 0, 'webservice_xmlrpc', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(579, 0, 'repository_areafiles', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(580, 0, 'repository_areafiles', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(581, 0, 'repository_areafiles', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(582, 0, 'repository_boxnet', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(583, 0, 'repository_boxnet', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(584, 0, 'repository_boxnet', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(585, 0, 'repository_coursefiles', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(586, 0, 'repository_coursefiles', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(587, 0, 'repository_coursefiles', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(588, 0, 'repository_dropbox', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(589, 0, 'repository_dropbox', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(590, 0, 'repository_dropbox', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(591, 0, 'repository_equella', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(592, 0, 'repository_equella', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(593, 0, 'repository_equella', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(594, 0, 'repository_filesystem', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(595, 0, 'repository_filesystem', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(596, 0, 'repository_filesystem', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(597, 0, 'repository_flickr', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(598, 0, 'repository_flickr', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(599, 0, 'repository_flickr', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(600, 0, 'repository_flickr_public', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(601, 0, 'repository_flickr_public', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(602, 0, 'repository_flickr_public', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(603, 0, 'repository_googledocs', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(604, 0, 'repository_googledocs', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(605, 0, 'repository_googledocs', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(606, 0, 'repository_local', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(607, 0, 'repository_local', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(608, 0, 'repository_local', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(609, 0, 'repository_merlot', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(610, 0, 'repository_merlot', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(611, 0, 'repository_merlot', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(612, 0, 'repository_onedrive', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(613, 0, 'repository_onedrive', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(614, 0, 'repository_onedrive', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(615, 0, 'repository_picasa', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(616, 0, 'repository_picasa', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(617, 0, 'repository_picasa', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(618, 0, 'repository_recent', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(619, 0, 'repository_recent', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(620, 0, 'repository_recent', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(621, 0, 'repository_s3', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(622, 0, 'repository_s3', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(623, 0, 'repository_s3', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(624, 0, 'repository_skydrive', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(625, 0, 'repository_skydrive', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(626, 0, 'repository_skydrive', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(627, 0, 'repository_upload', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(628, 0, 'repository_upload', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(629, 0, 'repository_upload', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(630, 0, 'repository_url', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(631, 0, 'repository_url', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(632, 0, 'repository_url', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(633, 0, 'repository_user', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(634, 0, 'repository_user', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(635, 0, 'repository_user', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(636, 0, 'repository_webdav', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(637, 0, 'repository_webdav', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(638, 0, 'repository_webdav', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(639, 0, 'repository_wikimedia', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(640, 0, 'repository_wikimedia', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(641, 0, 'repository_wikimedia', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(642, 0, 'repository_youtube', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(643, 0, 'repository_youtube', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(644, 0, 'repository_youtube', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(645, 0, 'portfolio_boxnet', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(646, 0, 'portfolio_boxnet', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(647, 0, 'portfolio_boxnet', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(648, 0, 'portfolio_download', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(649, 0, 'portfolio_download', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(650, 0, 'portfolio_download', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(651, 0, 'portfolio_flickr', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(652, 0, 'portfolio_flickr', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(653, 0, 'portfolio_flickr', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(654, 0, 'portfolio_googledocs', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(655, 0, 'portfolio_googledocs', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(656, 0, 'portfolio_googledocs', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(657, 0, 'portfolio_mahara', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(658, 0, 'portfolio_mahara', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(659, 0, 'portfolio_mahara', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(660, 0, 'portfolio_picasa', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(661, 0, 'portfolio_picasa', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(662, 0, 'portfolio_picasa', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(663, 0, 'search_simpledb', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(664, 0, 'search_simpledb', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(665, 0, 'search_simpledb', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(666, 0, 'search_solr', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(667, 0, 'search_solr', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(668, 0, 'search_solr', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(669, 0, 'qbehaviour_adaptive', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(670, 0, 'qbehaviour_adaptive', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(671, 0, 'qbehaviour_adaptive', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(672, 0, 'qbehaviour_adaptivenopenalty', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(673, 0, 'qbehaviour_adaptivenopenalty', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(674, 0, 'qbehaviour_adaptivenopenalty', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(675, 0, 'qbehaviour_deferredcbm', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(676, 0, 'qbehaviour_deferredcbm', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(677, 0, 'qbehaviour_deferredcbm', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(678, 0, 'qbehaviour_deferredfeedback', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(679, 0, 'qbehaviour_deferredfeedback', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(680, 0, 'qbehaviour_deferredfeedback', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(681, 0, 'qbehaviour_immediatecbm', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(682, 0, 'qbehaviour_immediatecbm', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(683, 0, 'qbehaviour_immediatecbm', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(684, 0, 'qbehaviour_immediatefeedback', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(685, 0, 'qbehaviour_immediatefeedback', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(686, 0, 'qbehaviour_immediatefeedback', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(687, 0, 'qbehaviour_informationitem', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(688, 0, 'qbehaviour_informationitem', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(689, 0, 'qbehaviour_informationitem', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(690, 0, 'qbehaviour_interactive', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(691, 0, 'qbehaviour_interactive', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(692, 0, 'qbehaviour_interactive', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(693, 0, 'qbehaviour_interactivecountback', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(694, 0, 'qbehaviour_interactivecountback', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(695, 0, 'qbehaviour_interactivecountback', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(696, 0, 'qbehaviour_manualgraded', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(697, 0, 'qbehaviour_manualgraded', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(698, 0, 'qbehaviour_manualgraded', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(699, 0, 'qbehaviour_missing', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(700, 0, 'qbehaviour_missing', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(701, 0, 'qbehaviour_missing', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(702, 0, 'qformat_aiken', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(703, 0, 'qformat_aiken', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(704, 0, 'qformat_aiken', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(705, 0, 'qformat_blackboard_six', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(706, 0, 'qformat_blackboard_six', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(707, 0, 'qformat_blackboard_six', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(708, 0, 'qformat_examview', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(709, 0, 'qformat_examview', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(710, 0, 'qformat_examview', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(711, 0, 'qformat_gift', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(712, 0, 'qformat_gift', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(713, 0, 'qformat_gift', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(714, 0, 'qformat_missingword', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(715, 0, 'qformat_missingword', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(716, 0, 'qformat_missingword', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(717, 0, 'qformat_multianswer', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(718, 0, 'qformat_multianswer', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(719, 0, 'qformat_multianswer', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(720, 0, 'qformat_webct', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(721, 0, 'qformat_webct', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(722, 0, 'qformat_webct', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(723, 0, 'qformat_xhtml', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(724, 0, 'qformat_xhtml', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(725, 0, 'qformat_xhtml', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(726, 0, 'qformat_xml', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(727, 0, 'qformat_xml', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(728, 0, 'qformat_xml', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(729, 0, 'tool_analytics', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(730, 0, 'tool_analytics', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(731, 0, 'tool_analytics', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(732, 0, 'tool_assignmentupgrade', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(733, 0, 'tool_assignmentupgrade', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(734, 0, 'tool_assignmentupgrade', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(735, 0, 'tool_availabilityconditions', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(736, 0, 'tool_availabilityconditions', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(737, 0, 'tool_availabilityconditions', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(738, 0, 'tool_behat', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(739, 0, 'tool_behat', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(740, 0, 'tool_behat', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(741, 0, 'tool_capability', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(742, 0, 'tool_capability', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(743, 0, 'tool_capability', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(744, 0, 'tool_cohortroles', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(745, 0, 'tool_cohortroles', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(746, 0, 'tool_cohortroles', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(747, 0, 'tool_customlang', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(748, 0, 'tool_customlang', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(749, 0, 'tool_customlang', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(750, 0, 'tool_dataprivacy', NULL, '2018051416', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(751, 0, 'tool_dataprivacy', '2018051416', '2018051416', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(752, 0, 'tool_dataprivacy', '2018051416', '2018051416', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(753, 0, 'tool_dbtransfer', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(754, 0, 'tool_dbtransfer', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(755, 0, 'tool_dbtransfer', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(756, 0, 'tool_filetypes', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(757, 0, 'tool_filetypes', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(758, 0, 'tool_filetypes', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(759, 0, 'tool_generator', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(760, 0, 'tool_generator', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(761, 0, 'tool_generator', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(762, 0, 'tool_health', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(763, 0, 'tool_health', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(764, 0, 'tool_health', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(765, 0, 'tool_httpsreplace', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(766, 0, 'tool_httpsreplace', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(767, 0, 'tool_httpsreplace', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(768, 0, 'tool_innodb', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(769, 0, 'tool_innodb', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(770, 0, 'tool_innodb', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(771, 0, 'tool_installaddon', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(772, 0, 'tool_installaddon', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(773, 0, 'tool_installaddon', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(774, 0, 'tool_langimport', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(775, 0, 'tool_langimport', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(776, 0, 'tool_langimport', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(777, 0, 'tool_log', NULL, '2018051401', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(778, 0, 'tool_log', '2018051401', '2018051401', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(779, 0, 'tool_log', '2018051401', '2018051401', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(780, 0, 'tool_lp', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(781, 0, 'tool_lp', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(782, 0, 'tool_lp', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(783, 0, 'tool_lpimportcsv', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(784, 0, 'tool_lpimportcsv', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(785, 0, 'tool_lpimportcsv', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(786, 0, 'tool_lpmigrate', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(787, 0, 'tool_lpmigrate', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(788, 0, 'tool_lpmigrate', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(789, 0, 'tool_messageinbound', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(790, 0, 'tool_messageinbound', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(791, 0, 'tool_messageinbound', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(792, 0, 'tool_mobile', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(793, 0, 'tool_mobile', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(794, 0, 'tool_mobile', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(795, 0, 'tool_monitor', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(796, 0, 'tool_monitor', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(797, 0, 'tool_monitor', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(798, 0, 'tool_multilangupgrade', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(799, 0, 'tool_multilangupgrade', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(800, 0, 'tool_multilangupgrade', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(801, 0, 'tool_oauth2', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(802, 0, 'tool_oauth2', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(803, 0, 'tool_oauth2', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(804, 0, 'tool_phpunit', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(805, 0, 'tool_phpunit', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(806, 0, 'tool_phpunit', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(807, 0, 'tool_policy', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(808, 0, 'tool_policy', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(809, 0, 'tool_policy', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(810, 0, 'tool_profiling', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(811, 0, 'tool_profiling', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(812, 0, 'tool_profiling', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(813, 0, 'tool_recyclebin', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(814, 0, 'tool_recyclebin', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(815, 0, 'tool_recyclebin', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(816, 0, 'tool_replace', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(817, 0, 'tool_replace', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(818, 0, 'tool_replace', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(819, 0, 'tool_spamcleaner', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(820, 0, 'tool_spamcleaner', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(821, 0, 'tool_spamcleaner', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(822, 0, 'tool_task', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(823, 0, 'tool_task', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(824, 0, 'tool_task', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(825, 0, 'tool_templatelibrary', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(826, 0, 'tool_templatelibrary', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(827, 0, 'tool_templatelibrary', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(828, 0, 'tool_unsuproles', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(829, 0, 'tool_unsuproles', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(830, 0, 'tool_unsuproles', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(831, 0, 'tool_uploadcourse', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(832, 0, 'tool_uploadcourse', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(833, 0, 'tool_uploadcourse', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(834, 0, 'tool_uploaduser', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(835, 0, 'tool_uploaduser', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(836, 0, 'tool_uploaduser', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(837, 0, 'tool_usertours', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(838, 0, 'tool_usertours', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(839, 0, 'tool_usertours', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(840, 0, 'tool_xmldb', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(841, 0, 'tool_xmldb', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(842, 0, 'tool_xmldb', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(843, 0, 'cachestore_apcu', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(844, 0, 'cachestore_apcu', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(845, 0, 'cachestore_apcu', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(846, 0, 'cachestore_file', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(847, 0, 'cachestore_file', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(848, 0, 'cachestore_file', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(849, 0, 'cachestore_memcache', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(850, 0, 'cachestore_memcache', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(851, 0, 'cachestore_memcache', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(852, 0, 'cachestore_memcached', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(853, 0, 'cachestore_memcached', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(854, 0, 'cachestore_memcached', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(855, 0, 'cachestore_mongodb', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(856, 0, 'cachestore_mongodb', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(857, 0, 'cachestore_mongodb', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(858, 0, 'cachestore_redis', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(859, 0, 'cachestore_redis', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(860, 0, 'cachestore_redis', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(861, 0, 'cachestore_session', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(862, 0, 'cachestore_session', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(863, 0, 'cachestore_session', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(864, 0, 'cachestore_static', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(865, 0, 'cachestore_static', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(866, 0, 'cachestore_static', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(867, 0, 'cachelock_file', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(868, 0, 'cachelock_file', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(869, 0, 'cachelock_file', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(870, 0, 'fileconverter_googledrive', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(871, 0, 'fileconverter_googledrive', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(872, 0, 'fileconverter_googledrive', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(873, 0, 'fileconverter_unoconv', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(874, 0, 'fileconverter_unoconv', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(875, 0, 'fileconverter_unoconv', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(876, 0, 'theme_boost', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(877, 0, 'theme_boost', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(878, 0, 'theme_boost', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(879, 0, 'theme_bootstrapbase', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(880, 0, 'theme_bootstrapbase', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(881, 0, 'theme_bootstrapbase', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(882, 0, 'theme_clean', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(883, 0, 'theme_clean', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(884, 0, 'theme_clean', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(885, 0, 'theme_more', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(886, 0, 'theme_more', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(887, 0, 'theme_more', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(888, 0, 'assignsubmission_comments', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(889, 0, 'assignsubmission_comments', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(890, 0, 'assignsubmission_comments', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(891, 0, 'assignsubmission_file', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(892, 0, 'assignsubmission_file', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(893, 0, 'assignsubmission_file', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(894, 0, 'assignsubmission_onlinetext', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(895, 0, 'assignsubmission_onlinetext', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(896, 0, 'assignsubmission_onlinetext', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(897, 0, 'assignfeedback_comments', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(898, 0, 'assignfeedback_comments', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(899, 0, 'assignfeedback_comments', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(900, 0, 'assignfeedback_editpdf', NULL, '2018051401', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(901, 0, 'assignfeedback_editpdf', '2018051401', '2018051401', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(902, 0, 'assignfeedback_editpdf', '2018051401', '2018051401', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(903, 0, 'assignfeedback_file', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(904, 0, 'assignfeedback_file', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(905, 0, 'assignfeedback_file', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(906, 0, 'assignfeedback_offline', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(907, 0, 'assignfeedback_offline', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(908, 0, 'assignfeedback_offline', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(909, 0, 'assignment_offline', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(910, 0, 'assignment_offline', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(911, 0, 'assignment_offline', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(912, 0, 'assignment_online', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(913, 0, 'assignment_online', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(914, 0, 'assignment_online', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(915, 0, 'assignment_upload', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(916, 0, 'assignment_upload', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(917, 0, 'assignment_upload', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(918, 0, 'assignment_uploadsingle', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(919, 0, 'assignment_uploadsingle', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(920, 0, 'assignment_uploadsingle', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(921, 0, 'booktool_exportimscp', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(922, 0, 'booktool_exportimscp', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(923, 0, 'booktool_exportimscp', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(924, 0, 'booktool_importhtml', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(925, 0, 'booktool_importhtml', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(926, 0, 'booktool_importhtml', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(927, 0, 'booktool_print', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(928, 0, 'booktool_print', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(929, 0, 'booktool_print', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(930, 0, 'datafield_checkbox', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(931, 0, 'datafield_checkbox', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(932, 0, 'datafield_checkbox', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(933, 0, 'datafield_date', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(934, 0, 'datafield_date', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(935, 0, 'datafield_date', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(936, 0, 'datafield_file', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(937, 0, 'datafield_file', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(938, 0, 'datafield_file', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(939, 0, 'datafield_latlong', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(940, 0, 'datafield_latlong', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(941, 0, 'datafield_latlong', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(942, 0, 'datafield_menu', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(943, 0, 'datafield_menu', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(944, 0, 'datafield_menu', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(945, 0, 'datafield_multimenu', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(946, 0, 'datafield_multimenu', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(947, 0, 'datafield_multimenu', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(948, 0, 'datafield_number', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(949, 0, 'datafield_number', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(950, 0, 'datafield_number', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]);
INSERT INTO `[[dbprefix]]upgrade_log` VALUES
(951, 0, 'datafield_picture', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(952, 0, 'datafield_picture', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(953, 0, 'datafield_picture', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(954, 0, 'datafield_radiobutton', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(955, 0, 'datafield_radiobutton', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(956, 0, 'datafield_radiobutton', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(957, 0, 'datafield_text', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(958, 0, 'datafield_text', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(959, 0, 'datafield_text', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(960, 0, 'datafield_textarea', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(961, 0, 'datafield_textarea', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(962, 0, 'datafield_textarea', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(963, 0, 'datafield_url', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(964, 0, 'datafield_url', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(965, 0, 'datafield_url', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(966, 0, 'datapreset_imagegallery', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(967, 0, 'datapreset_imagegallery', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(968, 0, 'datapreset_imagegallery', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(969, 0, 'ltiservice_gradebookservices', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(970, 0, 'ltiservice_gradebookservices', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(971, 0, 'ltiservice_gradebookservices', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(972, 0, 'ltiservice_memberships', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(973, 0, 'ltiservice_memberships', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(974, 0, 'ltiservice_memberships', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(975, 0, 'ltiservice_profile', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(976, 0, 'ltiservice_profile', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(977, 0, 'ltiservice_profile', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(978, 0, 'ltiservice_toolproxy', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(979, 0, 'ltiservice_toolproxy', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(980, 0, 'ltiservice_toolproxy', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(981, 0, 'ltiservice_toolsettings', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(982, 0, 'ltiservice_toolsettings', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(983, 0, 'ltiservice_toolsettings', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(984, 0, 'quiz_grading', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(985, 0, 'quiz_grading', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(986, 0, 'quiz_grading', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(987, 0, 'quiz_overview', NULL, '2018061801', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(988, 0, 'quiz_overview', '2018061801', '2018061801', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(989, 0, 'quiz_overview', '2018061801', '2018061801', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(990, 0, 'quiz_responses', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(991, 0, 'quiz_responses', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(992, 0, 'quiz_responses', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(993, 0, 'quiz_statistics', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(994, 0, 'quiz_statistics', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(995, 0, 'quiz_statistics', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(996, 0, 'quizaccess_delaybetweenattempts', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(997, 0, 'quizaccess_delaybetweenattempts', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(998, 0, 'quizaccess_delaybetweenattempts', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(999, 0, 'quizaccess_ipaddress', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(1000, 0, 'quizaccess_ipaddress', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(1001, 0, 'quizaccess_ipaddress', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(1002, 0, 'quizaccess_numattempts', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(1003, 0, 'quizaccess_numattempts', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(1004, 0, 'quizaccess_numattempts', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(1005, 0, 'quizaccess_offlineattempts', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(1006, 0, 'quizaccess_offlineattempts', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(1007, 0, 'quizaccess_offlineattempts', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(1008, 0, 'quizaccess_openclosedate', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(1009, 0, 'quizaccess_openclosedate', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(1010, 0, 'quizaccess_openclosedate', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(1011, 0, 'quizaccess_password', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(1012, 0, 'quizaccess_password', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(1013, 0, 'quizaccess_password', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(1014, 0, 'quizaccess_safebrowser', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(1015, 0, 'quizaccess_safebrowser', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(1016, 0, 'quizaccess_safebrowser', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(1017, 0, 'quizaccess_securewindow', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(1018, 0, 'quizaccess_securewindow', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(1019, 0, 'quizaccess_securewindow', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(1020, 0, 'quizaccess_timelimit', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(1021, 0, 'quizaccess_timelimit', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(1022, 0, 'quizaccess_timelimit', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(1023, 0, 'scormreport_basic', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(1024, 0, 'scormreport_basic', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(1025, 0, 'scormreport_basic', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(1026, 0, 'scormreport_graphs', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(1027, 0, 'scormreport_graphs', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(1028, 0, 'scormreport_graphs', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(1029, 0, 'scormreport_interactions', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(1030, 0, 'scormreport_interactions', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(1031, 0, 'scormreport_interactions', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(1032, 0, 'scormreport_objectives', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(1033, 0, 'scormreport_objectives', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(1034, 0, 'scormreport_objectives', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(1035, 0, 'workshopform_accumulative', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(1036, 0, 'workshopform_accumulative', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(1037, 0, 'workshopform_accumulative', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(1038, 0, 'workshopform_comments', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(1039, 0, 'workshopform_comments', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(1040, 0, 'workshopform_comments', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(1041, 0, 'workshopform_numerrors', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(1042, 0, 'workshopform_numerrors', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(1043, 0, 'workshopform_numerrors', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(1044, 0, 'workshopform_rubric', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(1045, 0, 'workshopform_rubric', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(1046, 0, 'workshopform_rubric', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(1047, 0, 'workshopallocation_manual', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(1048, 0, 'workshopallocation_manual', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(1049, 0, 'workshopallocation_manual', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(1050, 0, 'workshopallocation_random', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(1051, 0, 'workshopallocation_random', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(1052, 0, 'workshopallocation_random', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(1053, 0, 'workshopallocation_scheduled', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(1054, 0, 'workshopallocation_scheduled', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(1055, 0, 'workshopallocation_scheduled', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(1056, 0, 'workshopeval_best', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(1057, 0, 'workshopeval_best', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(1058, 0, 'workshopeval_best', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(1059, 0, 'atto_accessibilitychecker', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(1060, 0, 'atto_accessibilitychecker', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(1061, 0, 'atto_accessibilitychecker', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(1062, 0, 'atto_accessibilityhelper', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(1063, 0, 'atto_accessibilityhelper', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(1064, 0, 'atto_accessibilityhelper', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(1065, 0, 'atto_align', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(1066, 0, 'atto_align', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(1067, 0, 'atto_align', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(1068, 0, 'atto_backcolor', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(1069, 0, 'atto_backcolor', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(1070, 0, 'atto_backcolor', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(1071, 0, 'atto_bold', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(1072, 0, 'atto_bold', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(1073, 0, 'atto_bold', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(1074, 0, 'atto_charmap', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(1075, 0, 'atto_charmap', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(1076, 0, 'atto_charmap', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(1077, 0, 'atto_clear', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(1078, 0, 'atto_clear', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(1079, 0, 'atto_clear', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(1080, 0, 'atto_collapse', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(1081, 0, 'atto_collapse', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(1082, 0, 'atto_collapse', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(1083, 0, 'atto_emoticon', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(1084, 0, 'atto_emoticon', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(1085, 0, 'atto_emoticon', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(1086, 0, 'atto_equation', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(1087, 0, 'atto_equation', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(1088, 0, 'atto_equation', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(1089, 0, 'atto_fontcolor', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(1090, 0, 'atto_fontcolor', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(1091, 0, 'atto_fontcolor', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(1092, 0, 'atto_html', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(1093, 0, 'atto_html', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(1094, 0, 'atto_html', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(1095, 0, 'atto_image', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(1096, 0, 'atto_image', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(1097, 0, 'atto_image', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(1098, 0, 'atto_indent', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(1099, 0, 'atto_indent', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(1100, 0, 'atto_indent', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(1101, 0, 'atto_italic', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(1102, 0, 'atto_italic', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(1103, 0, 'atto_italic', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(1104, 0, 'atto_link', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(1105, 0, 'atto_link', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(1106, 0, 'atto_link', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(1107, 0, 'atto_managefiles', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(1108, 0, 'atto_managefiles', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(1109, 0, 'atto_managefiles', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(1110, 0, 'atto_media', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(1111, 0, 'atto_media', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(1112, 0, 'atto_media', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(1113, 0, 'atto_noautolink', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(1114, 0, 'atto_noautolink', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(1115, 0, 'atto_noautolink', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(1116, 0, 'atto_orderedlist', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(1117, 0, 'atto_orderedlist', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(1118, 0, 'atto_orderedlist', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(1119, 0, 'atto_recordrtc', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(1120, 0, 'atto_recordrtc', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(1121, 0, 'atto_recordrtc', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(1122, 0, 'atto_rtl', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(1123, 0, 'atto_rtl', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(1124, 0, 'atto_rtl', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(1125, 0, 'atto_strike', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(1126, 0, 'atto_strike', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(1127, 0, 'atto_strike', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(1128, 0, 'atto_subscript', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(1129, 0, 'atto_subscript', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(1130, 0, 'atto_subscript', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(1131, 0, 'atto_superscript', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(1132, 0, 'atto_superscript', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(1133, 0, 'atto_superscript', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(1134, 0, 'atto_table', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(1135, 0, 'atto_table', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(1136, 0, 'atto_table', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(1137, 0, 'atto_title', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(1138, 0, 'atto_title', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(1139, 0, 'atto_title', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(1140, 0, 'atto_underline', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(1141, 0, 'atto_underline', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(1142, 0, 'atto_underline', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(1143, 0, 'atto_undo', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(1144, 0, 'atto_undo', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(1145, 0, 'atto_undo', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(1146, 0, 'atto_unorderedlist', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(1147, 0, 'atto_unorderedlist', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(1148, 0, 'atto_unorderedlist', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(1149, 0, 'tinymce_ctrlhelp', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(1150, 0, 'tinymce_ctrlhelp', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(1151, 0, 'tinymce_ctrlhelp', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(1152, 0, 'tinymce_managefiles', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(1153, 0, 'tinymce_managefiles', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(1154, 0, 'tinymce_managefiles', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(1155, 0, 'tinymce_moodleemoticon', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(1156, 0, 'tinymce_moodleemoticon', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(1157, 0, 'tinymce_moodleemoticon', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(1158, 0, 'tinymce_moodleimage', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(1159, 0, 'tinymce_moodleimage', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(1160, 0, 'tinymce_moodleimage', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(1161, 0, 'tinymce_moodlemedia', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(1162, 0, 'tinymce_moodlemedia', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(1163, 0, 'tinymce_moodlemedia', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(1164, 0, 'tinymce_moodlenolink', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(1165, 0, 'tinymce_moodlenolink', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(1166, 0, 'tinymce_moodlenolink', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(1167, 0, 'tinymce_pdw', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(1168, 0, 'tinymce_pdw', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(1169, 0, 'tinymce_pdw', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(1170, 0, 'tinymce_spellchecker', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(1171, 0, 'tinymce_spellchecker', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(1172, 0, 'tinymce_spellchecker', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(1173, 0, 'tinymce_wrap', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(1174, 0, 'tinymce_wrap', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(1175, 0, 'tinymce_wrap', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(1176, 0, 'logstore_database', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(1177, 0, 'logstore_database', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(1178, 0, 'logstore_database', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(1179, 0, 'logstore_legacy', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(1180, 0, 'logstore_legacy', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(1181, 0, 'logstore_legacy', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]),
(1182, 0, 'logstore_standard', NULL, '2018051400', 'Starting plugin installation', NULL, '', 0, [[timestamp]]),
(1183, 0, 'logstore_standard', '2018051400', '2018051400', 'Upgrade savepoint reached', NULL, '', 0, [[timestamp]]),
(1184, 0, 'logstore_standard', '2018051400', '2018051400', 'Plugin installed', NULL, '', 0, [[timestamp]]);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]url`
--

CREATE TABLE `[[dbprefix]]url` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `intro` longtext,
  `introformat` smallint(4) NOT NULL DEFAULT '0',
  `externalurl` longtext NOT NULL,
  `display` smallint(4) NOT NULL DEFAULT '0',
  `displayoptions` longtext,
  `parameters` longtext,
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]url_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='each record is one url resource' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]user`
--

CREATE TABLE `[[dbprefix]]user` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `auth` varchar(20) NOT NULL DEFAULT 'manual',
  `confirmed` tinyint(1) NOT NULL DEFAULT '0',
  `policyagreed` tinyint(1) NOT NULL DEFAULT '0',
  `deleted` tinyint(1) NOT NULL DEFAULT '0',
  `suspended` tinyint(1) NOT NULL DEFAULT '0',
  `mnethostid` bigint(10) NOT NULL DEFAULT '0',
  `username` varchar(100) NOT NULL DEFAULT '',
  `password` varchar(255) NOT NULL DEFAULT '',
  `idnumber` varchar(255) NOT NULL DEFAULT '',
  `firstname` varchar(100) NOT NULL DEFAULT '',
  `lastname` varchar(100) NOT NULL DEFAULT '',
  `email` varchar(100) NOT NULL DEFAULT '',
  `emailstop` tinyint(1) NOT NULL DEFAULT '0',
  `icq` varchar(15) NOT NULL DEFAULT '',
  `skype` varchar(50) NOT NULL DEFAULT '',
  `yahoo` varchar(50) NOT NULL DEFAULT '',
  `aim` varchar(50) NOT NULL DEFAULT '',
  `msn` varchar(50) NOT NULL DEFAULT '',
  `phone1` varchar(20) NOT NULL DEFAULT '',
  `phone2` varchar(20) NOT NULL DEFAULT '',
  `institution` varchar(255) NOT NULL DEFAULT '',
  `department` varchar(255) NOT NULL DEFAULT '',
  `address` varchar(255) NOT NULL DEFAULT '',
  `city` varchar(120) NOT NULL DEFAULT '',
  `country` varchar(2) NOT NULL DEFAULT '',
  `lang` varchar(30) NOT NULL DEFAULT 'en',
  `calendartype` varchar(30) NOT NULL DEFAULT 'gregorian',
  `theme` varchar(50) NOT NULL DEFAULT '',
  `timezone` varchar(100) NOT NULL DEFAULT '99',
  `firstaccess` bigint(10) NOT NULL DEFAULT '0',
  `lastaccess` bigint(10) NOT NULL DEFAULT '0',
  `lastlogin` bigint(10) NOT NULL DEFAULT '0',
  `currentlogin` bigint(10) NOT NULL DEFAULT '0',
  `lastip` varchar(45) NOT NULL DEFAULT '',
  `secret` varchar(15) NOT NULL DEFAULT '',
  `picture` bigint(10) NOT NULL DEFAULT '0',
  `url` varchar(255) NOT NULL DEFAULT '',
  `description` longtext,
  `descriptionformat` tinyint(2) NOT NULL DEFAULT '1',
  `mailformat` tinyint(1) NOT NULL DEFAULT '1',
  `maildigest` tinyint(1) NOT NULL DEFAULT '0',
  `maildisplay` tinyint(2) NOT NULL DEFAULT '2',
  `autosubscribe` tinyint(1) NOT NULL DEFAULT '1',
  `trackforums` tinyint(1) NOT NULL DEFAULT '0',
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `trustbitmask` bigint(10) NOT NULL DEFAULT '0',
  `imagealt` varchar(255) DEFAULT NULL,
  `lastnamephonetic` varchar(255) DEFAULT NULL,
  `firstnamephonetic` varchar(255) DEFAULT NULL,
  `middlename` varchar(255) DEFAULT NULL,
  `alternatename` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]user_mneuse_uix` (`mnethostid`,`username`),
  KEY `[[dbprefix]]user_del_ix` (`deleted`),
  KEY `[[dbprefix]]user_con_ix` (`confirmed`),
  KEY `[[dbprefix]]user_fir_ix` (`firstname`),
  KEY `[[dbprefix]]user_las_ix` (`lastname`),
  KEY `[[dbprefix]]user_cit_ix` (`city`),
  KEY `[[dbprefix]]user_cou_ix` (`country`),
  KEY `[[dbprefix]]user_las2_ix` (`lastaccess`),
  KEY `[[dbprefix]]user_ema_ix` (`email`),
  KEY `[[dbprefix]]user_aut_ix` (`auth`),
  KEY `[[dbprefix]]user_idn_ix` (`idnumber`),
  KEY `[[dbprefix]]user_fir2_ix` (`firstnamephonetic`),
  KEY `[[dbprefix]]user_las3_ix` (`lastnamephonetic`),
  KEY `[[dbprefix]]user_mid_ix` (`middlename`),
  KEY `[[dbprefix]]user_alt_ix` (`alternatename`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='One record for each person' AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]user`
--

INSERT INTO `[[dbprefix]]user` VALUES
(1, 'manual', 1, 0, 0, 0, 1, 'guest', '$2y$10$X9eg.ij1Uo2jbYN0Xdl5Ae3zTY81PVsNHB5Ao2fQPaUadW1pb8.Ce', '', 'Guest user', ' ', 'root@localhost', 0, '', '', '', '', '', '', '', '', '', '', '', '', 'en', 'gregorian', '', '99', 0, 0, 0, 0, '', '', 0, '', 'This user is a special user that allows read-only access to some courses.', 1, 1, 0, 2, 1, 0, 0, [[timestamp]], 0, NULL, NULL, NULL, NULL, NULL),
(2, 'manual', 1, 0, 0, 0, 1, '[[admin_username]]', '[[admin_pass]]', '', '[[admin_fname]]', '[[admin_lname]]', '[[admin_email]]', 0, '', '', '', '', '', '', '', '', '', '', 'defaultcity', 'US', '[[language]]', 'gregorian', '', 'America/New_York', [[timestamp]], [[timestamp]], 0, [[timestamp]], '[[clientip]]', '', 0, '', '', 1, 1, 0, 1, 1, 0, 0, [[timestamp]], 0, NULL, '', '', '', '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]user_devices`
--

CREATE TABLE `[[dbprefix]]user_devices` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `appid` varchar(128) NOT NULL DEFAULT '',
  `name` varchar(32) NOT NULL DEFAULT '',
  `model` varchar(32) NOT NULL DEFAULT '',
  `platform` varchar(32) NOT NULL DEFAULT '',
  `version` varchar(32) NOT NULL DEFAULT '',
  `pushid` varchar(255) NOT NULL DEFAULT '',
  `uuid` varchar(255) NOT NULL DEFAULT '',
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]userdevi_pususe_uix` (`pushid`,`userid`),
  KEY `[[dbprefix]]userdevi_uuiuse_ix` (`uuid`,`userid`),
  KEY `[[dbprefix]]userdevi_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='This table stores user''s mobile devices information in order' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]user_enrolments`
--

CREATE TABLE `[[dbprefix]]user_enrolments` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `status` bigint(10) NOT NULL DEFAULT '0',
  `enrolid` bigint(10) NOT NULL,
  `userid` bigint(10) NOT NULL,
  `timestart` bigint(10) NOT NULL DEFAULT '0',
  `timeend` bigint(10) NOT NULL DEFAULT '2147483647',
  `modifierid` bigint(10) NOT NULL DEFAULT '0',
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]userenro_enruse_uix` (`enrolid`,`userid`),
  KEY `[[dbprefix]]userenro_enr_ix` (`enrolid`),
  KEY `[[dbprefix]]userenro_use_ix` (`userid`),
  KEY `[[dbprefix]]userenro_mod_ix` (`modifierid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Users participating in courses (aka enrolled users) - everyb' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]user_info_category`
--

CREATE TABLE `[[dbprefix]]user_info_category` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `sortorder` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Customisable fields categories' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]user_info_data`
--

CREATE TABLE `[[dbprefix]]user_info_data` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `fieldid` bigint(10) NOT NULL DEFAULT '0',
  `data` longtext NOT NULL,
  `dataformat` tinyint(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]userinfodata_usefie_uix` (`userid`,`fieldid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Data for the customisable user fields' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]user_info_field`
--

CREATE TABLE `[[dbprefix]]user_info_field` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `shortname` varchar(255) NOT NULL DEFAULT 'shortname',
  `name` longtext NOT NULL,
  `datatype` varchar(255) NOT NULL DEFAULT '',
  `description` longtext,
  `descriptionformat` tinyint(2) NOT NULL DEFAULT '0',
  `categoryid` bigint(10) NOT NULL DEFAULT '0',
  `sortorder` bigint(10) NOT NULL DEFAULT '0',
  `required` tinyint(2) NOT NULL DEFAULT '0',
  `locked` tinyint(2) NOT NULL DEFAULT '0',
  `visible` smallint(4) NOT NULL DEFAULT '0',
  `forceunique` tinyint(2) NOT NULL DEFAULT '0',
  `signup` tinyint(2) NOT NULL DEFAULT '0',
  `defaultdata` longtext,
  `defaultdataformat` tinyint(2) NOT NULL DEFAULT '0',
  `param1` longtext,
  `param2` longtext,
  `param3` longtext,
  `param4` longtext,
  `param5` longtext,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Customisable user profile fields' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]user_lastaccess`
--

CREATE TABLE `[[dbprefix]]user_lastaccess` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `courseid` bigint(10) NOT NULL DEFAULT '0',
  `timeaccess` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]userlast_usecou_uix` (`userid`,`courseid`),
  KEY `[[dbprefix]]userlast_use_ix` (`userid`),
  KEY `[[dbprefix]]userlast_cou_ix` (`courseid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='To keep track of course page access times, used in online pa' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]user_password_history`
--

CREATE TABLE `[[dbprefix]]user_password_history` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL,
  `hash` varchar(255) NOT NULL DEFAULT '',
  `timecreated` bigint(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]userpasshist_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='A rotating log of hashes of previously used passwords for ea' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]user_password_resets`
--

CREATE TABLE `[[dbprefix]]user_password_resets` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL,
  `timerequested` bigint(10) NOT NULL,
  `timererequested` bigint(10) NOT NULL DEFAULT '0',
  `token` varchar(32) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]userpassrese_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='table tracking password reset confirmation tokens' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]user_preferences`
--

CREATE TABLE `[[dbprefix]]user_preferences` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `value` varchar(1333) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]userpref_usenam_uix` (`userid`,`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Allows modules to store arbitrary user preferences' AUTO_INCREMENT=5 ;

--
-- Dumping data for table `[[dbprefix]]user_preferences`
--

INSERT INTO `[[dbprefix]]user_preferences` VALUES
(1, 2, 'core_message_migrate_data', '1'),
(2, 2, 'auth_manual_passwordupdatetime', '[[timestamp]]'),
(3, 2, 'email_bounce_count', '1'),
(4, 2, 'email_send_count', '1');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]user_private_key`
--

CREATE TABLE `[[dbprefix]]user_private_key` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `script` varchar(128) NOT NULL DEFAULT '',
  `value` varchar(128) NOT NULL DEFAULT '',
  `userid` bigint(10) NOT NULL,
  `instance` bigint(10) DEFAULT NULL,
  `iprestriction` varchar(255) DEFAULT NULL,
  `validuntil` bigint(10) DEFAULT NULL,
  `timecreated` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]userprivkey_scrval_ix` (`script`,`value`),
  KEY `[[dbprefix]]userprivkey_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='access keys used in cookieless scripts - rss, etc.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]wiki`
--

CREATE TABLE `[[dbprefix]]wiki` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT 'Wiki',
  `intro` longtext,
  `introformat` smallint(4) NOT NULL DEFAULT '0',
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `firstpagetitle` varchar(255) NOT NULL DEFAULT 'First Page',
  `wikimode` varchar(20) NOT NULL DEFAULT 'collaborative',
  `defaultformat` varchar(20) NOT NULL DEFAULT 'creole',
  `forceformat` tinyint(1) NOT NULL DEFAULT '1',
  `editbegin` bigint(10) NOT NULL DEFAULT '0',
  `editend` bigint(10) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]wiki_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Stores Wiki activity configuration' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]wiki_links`
--

CREATE TABLE `[[dbprefix]]wiki_links` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `subwikiid` bigint(10) NOT NULL DEFAULT '0',
  `frompageid` bigint(10) NOT NULL DEFAULT '0',
  `topageid` bigint(10) NOT NULL DEFAULT '0',
  `tomissingpage` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]wikilink_fro_ix` (`frompageid`),
  KEY `[[dbprefix]]wikilink_sub_ix` (`subwikiid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Page wiki links' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]wiki_locks`
--

CREATE TABLE `[[dbprefix]]wiki_locks` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `pageid` bigint(10) NOT NULL DEFAULT '0',
  `sectionname` varchar(255) DEFAULT NULL,
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `lockedat` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Manages page locks' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]wiki_pages`
--

CREATE TABLE `[[dbprefix]]wiki_pages` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `subwikiid` bigint(10) NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT 'title',
  `cachedcontent` longtext NOT NULL,
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL DEFAULT '0',
  `timerendered` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  `pageviews` bigint(10) NOT NULL DEFAULT '0',
  `readonly` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]wikipage_subtituse_uix` (`subwikiid`,`title`,`userid`),
  KEY `[[dbprefix]]wikipage_sub_ix` (`subwikiid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Stores wiki pages' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]wiki_subwikis`
--

CREATE TABLE `[[dbprefix]]wiki_subwikis` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `wikiid` bigint(10) NOT NULL DEFAULT '0',
  `groupid` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]wikisubw_wikgrouse_uix` (`wikiid`,`groupid`,`userid`),
  KEY `[[dbprefix]]wikisubw_wik_ix` (`wikiid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Stores subwiki instances' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]wiki_synonyms`
--

CREATE TABLE `[[dbprefix]]wiki_synonyms` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `subwikiid` bigint(10) NOT NULL DEFAULT '0',
  `pageid` bigint(10) NOT NULL DEFAULT '0',
  `pagesynonym` varchar(255) NOT NULL DEFAULT 'Pagesynonym',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]wikisyno_pagpag_uix` (`pageid`,`pagesynonym`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Stores wiki pages synonyms' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]wiki_versions`
--

CREATE TABLE `[[dbprefix]]wiki_versions` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `pageid` bigint(10) NOT NULL DEFAULT '0',
  `content` longtext NOT NULL,
  `contentformat` varchar(20) NOT NULL DEFAULT 'creole',
  `version` mediumint(5) NOT NULL DEFAULT '0',
  `timecreated` bigint(10) NOT NULL DEFAULT '0',
  `userid` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]wikivers_pag_ix` (`pageid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Stores wiki page history' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]workshop`
--

CREATE TABLE `[[dbprefix]]workshop` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `course` bigint(10) NOT NULL,
  `name` varchar(255) NOT NULL DEFAULT '',
  `intro` longtext,
  `introformat` smallint(3) NOT NULL DEFAULT '0',
  `instructauthors` longtext,
  `instructauthorsformat` smallint(3) NOT NULL DEFAULT '0',
  `instructreviewers` longtext,
  `instructreviewersformat` smallint(3) NOT NULL DEFAULT '0',
  `timemodified` bigint(10) NOT NULL,
  `phase` smallint(3) DEFAULT '0',
  `useexamples` tinyint(2) DEFAULT '0',
  `usepeerassessment` tinyint(2) DEFAULT '0',
  `useselfassessment` tinyint(2) DEFAULT '0',
  `grade` decimal(10,5) DEFAULT '80.00000',
  `gradinggrade` decimal(10,5) DEFAULT '20.00000',
  `strategy` varchar(30) NOT NULL DEFAULT '',
  `evaluation` varchar(30) NOT NULL DEFAULT '',
  `gradedecimals` smallint(3) DEFAULT '0',
  `nattachments` smallint(3) DEFAULT '0',
  `submissionfiletypes` varchar(255) DEFAULT NULL,
  `latesubmissions` tinyint(2) DEFAULT '0',
  `maxbytes` bigint(10) DEFAULT '100000',
  `examplesmode` smallint(3) DEFAULT '0',
  `submissionstart` bigint(10) DEFAULT '0',
  `submissionend` bigint(10) DEFAULT '0',
  `assessmentstart` bigint(10) DEFAULT '0',
  `assessmentend` bigint(10) DEFAULT '0',
  `phaseswitchassessment` tinyint(2) NOT NULL DEFAULT '0',
  `conclusion` longtext,
  `conclusionformat` smallint(3) NOT NULL DEFAULT '1',
  `overallfeedbackmode` smallint(3) DEFAULT '1',
  `overallfeedbackfiles` smallint(3) DEFAULT '0',
  `overallfeedbackfiletypes` varchar(255) DEFAULT NULL,
  `overallfeedbackmaxbytes` bigint(10) DEFAULT '100000',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]work_cou_ix` (`course`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='This table keeps information about the module instances and ' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]workshopallocation_scheduled`
--

CREATE TABLE `[[dbprefix]]workshopallocation_scheduled` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `workshopid` bigint(10) NOT NULL,
  `enabled` tinyint(2) NOT NULL DEFAULT '0',
  `submissionend` bigint(10) NOT NULL,
  `timeallocated` bigint(10) DEFAULT NULL,
  `settings` longtext,
  `resultstatus` bigint(10) DEFAULT NULL,
  `resultmessage` varchar(1333) DEFAULT NULL,
  `resultlog` longtext,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]worksche_wor_uix` (`workshopid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Stores the allocation settings for the scheduled allocator' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]workshopeval_best_settings`
--

CREATE TABLE `[[dbprefix]]workshopeval_best_settings` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `workshopid` bigint(10) NOT NULL,
  `comparison` smallint(3) DEFAULT '5',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]workbestsett_wor_uix` (`workshopid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Settings for the grading evaluation subplugin Comparison wit' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]workshopform_accumulative`
--

CREATE TABLE `[[dbprefix]]workshopform_accumulative` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `workshopid` bigint(10) NOT NULL,
  `sort` bigint(10) DEFAULT '0',
  `description` longtext,
  `descriptionformat` smallint(3) DEFAULT '0',
  `grade` bigint(10) NOT NULL,
  `weight` mediumint(5) DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]workaccu_wor_ix` (`workshopid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='The assessment dimensions definitions of Accumulative gradin' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]workshopform_comments`
--

CREATE TABLE `[[dbprefix]]workshopform_comments` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `workshopid` bigint(10) NOT NULL,
  `sort` bigint(10) DEFAULT '0',
  `description` longtext,
  `descriptionformat` smallint(3) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]workcomm_wor_ix` (`workshopid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='The assessment dimensions definitions of Comments strategy f' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]workshopform_numerrors`
--

CREATE TABLE `[[dbprefix]]workshopform_numerrors` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `workshopid` bigint(10) NOT NULL,
  `sort` bigint(10) DEFAULT '0',
  `description` longtext,
  `descriptionformat` smallint(3) DEFAULT '0',
  `descriptiontrust` bigint(10) DEFAULT NULL,
  `grade0` varchar(50) DEFAULT NULL,
  `grade1` varchar(50) DEFAULT NULL,
  `weight` mediumint(5) DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]worknume_wor_ix` (`workshopid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='The assessment dimensions definitions of Number of errors gr' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]workshopform_numerrors_map`
--

CREATE TABLE `[[dbprefix]]workshopform_numerrors_map` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `workshopid` bigint(10) NOT NULL,
  `nonegative` bigint(10) NOT NULL,
  `grade` decimal(10,5) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]worknumemap_wornon_uix` (`workshopid`,`nonegative`),
  KEY `[[dbprefix]]worknumemap_wor_ix` (`workshopid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='This maps the number of errors to a percentual grade for sub' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]workshopform_rubric`
--

CREATE TABLE `[[dbprefix]]workshopform_rubric` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `workshopid` bigint(10) NOT NULL,
  `sort` bigint(10) DEFAULT '0',
  `description` longtext,
  `descriptionformat` smallint(3) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]workrubr_wor_ix` (`workshopid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='The assessment dimensions definitions of Rubric grading stra' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]workshopform_rubric_config`
--

CREATE TABLE `[[dbprefix]]workshopform_rubric_config` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `workshopid` bigint(10) NOT NULL,
  `layout` varchar(30) DEFAULT 'list',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]workrubrconf_wor_uix` (`workshopid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Configuration table for the Rubric grading strategy' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]workshopform_rubric_levels`
--

CREATE TABLE `[[dbprefix]]workshopform_rubric_levels` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `dimensionid` bigint(10) NOT NULL,
  `grade` decimal(10,5) NOT NULL,
  `definition` longtext,
  `definitionformat` smallint(3) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]workrubrleve_dim_ix` (`dimensionid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='The definition of rubric rating scales' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]workshop_aggregations`
--

CREATE TABLE `[[dbprefix]]workshop_aggregations` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `workshopid` bigint(10) NOT NULL,
  `userid` bigint(10) NOT NULL,
  `gradinggrade` decimal(10,5) DEFAULT NULL,
  `timegraded` bigint(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]workaggr_woruse_uix` (`workshopid`,`userid`),
  KEY `[[dbprefix]]workaggr_wor_ix` (`workshopid`),
  KEY `[[dbprefix]]workaggr_use_ix` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Aggregated grades for assessment are stored here. The aggreg' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]workshop_assessments`
--

CREATE TABLE `[[dbprefix]]workshop_assessments` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `submissionid` bigint(10) NOT NULL,
  `reviewerid` bigint(10) NOT NULL,
  `weight` bigint(10) NOT NULL DEFAULT '1',
  `timecreated` bigint(10) DEFAULT '0',
  `timemodified` bigint(10) DEFAULT '0',
  `grade` decimal(10,5) DEFAULT NULL,
  `gradinggrade` decimal(10,5) DEFAULT NULL,
  `gradinggradeover` decimal(10,5) DEFAULT NULL,
  `gradinggradeoverby` bigint(10) DEFAULT NULL,
  `feedbackauthor` longtext,
  `feedbackauthorformat` smallint(3) DEFAULT '0',
  `feedbackauthorattachment` smallint(3) DEFAULT '0',
  `feedbackreviewer` longtext,
  `feedbackreviewerformat` smallint(3) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]workasse_sub_ix` (`submissionid`),
  KEY `[[dbprefix]]workasse_gra_ix` (`gradinggradeoverby`),
  KEY `[[dbprefix]]workasse_rev_ix` (`reviewerid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Info about the made assessment and automatically calculated ' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]workshop_grades`
--

CREATE TABLE `[[dbprefix]]workshop_grades` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `assessmentid` bigint(10) NOT NULL,
  `strategy` varchar(30) NOT NULL DEFAULT '',
  `dimensionid` bigint(10) NOT NULL,
  `grade` decimal(10,5) NOT NULL,
  `peercomment` longtext,
  `peercommentformat` smallint(3) DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]workgrad_assstrdim_uix` (`assessmentid`,`strategy`,`dimensionid`),
  KEY `[[dbprefix]]workgrad_ass_ix` (`assessmentid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='How the reviewers filled-up the grading forms, given grades ' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]workshop_submissions`
--

CREATE TABLE `[[dbprefix]]workshop_submissions` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `workshopid` bigint(10) NOT NULL,
  `example` tinyint(2) DEFAULT '0',
  `authorid` bigint(10) NOT NULL,
  `timecreated` bigint(10) NOT NULL,
  `timemodified` bigint(10) NOT NULL,
  `title` varchar(255) NOT NULL DEFAULT '',
  `content` longtext,
  `contentformat` smallint(3) NOT NULL DEFAULT '0',
  `contenttrust` smallint(3) NOT NULL DEFAULT '0',
  `attachment` tinyint(2) DEFAULT '0',
  `grade` decimal(10,5) DEFAULT NULL,
  `gradeover` decimal(10,5) DEFAULT NULL,
  `gradeoverby` bigint(10) DEFAULT NULL,
  `feedbackauthor` longtext,
  `feedbackauthorformat` smallint(3) DEFAULT '0',
  `timegraded` bigint(10) DEFAULT NULL,
  `published` tinyint(2) DEFAULT '0',
  `late` tinyint(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]worksubm_wor_ix` (`workshopid`),
  KEY `[[dbprefix]]worksubm_gra_ix` (`gradeoverby`),
  KEY `[[dbprefix]]worksubm_aut_ix` (`authorid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]][[row_format]] COMMENT='Info about the submission and the aggregation of the grade f' AUTO_INCREMENT=1 ;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
