<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'lesson', language 'cs', version '3.5'.
 *
 * @package     lesson
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accesscontrol'] = 'Řízení přístupu';
$string['actionaftercorrectanswer'] = 'Akce po správné odpovědi';
$string['actionaftercorrectanswer_help'] = 'Umožňuje nastavit, kam bude student přesměrován, pokud odpoví správně na otázky v přednášce. Výchozí možností je "Normální – následuj plán přednášky", kdy student přednáškou prochází v takovém sledu, jak nastavil učitel.

Modul Přednáška lze však použít i jako zadání typu Flash Card. Studentovi se zobrazí úvodní informace (není povinné) a poté náhodně vybraná stránka. Neexistuje zde pevně stanovený začátek ani konec.

K dispozici jsou dvě velmi podobné varianty takovéhoto chování. Volba "Ukázat neprohlédnutou stránku" nezobrazí nikdy tutéž stránku dvakrát (ani v případě, že student otázku, která je na ní uvedena, nezodpověděl správně). Druhá možnost, "Ukázat nezodpovězenou stránku", umožňuje opakované zobrazení stránky, kterou student již viděl, avšak pouze v případě, že na její závěrečnou otázku odpověděl nesprávně.

V obou těchto režimech může učitel rozhodnout, zda se použijí všechny stránky přednášky, nebo jen jejich (náhodná) podmnožina. Toto nastavení se provádí pomocí parametru "Počet stránek k zobrazení".';
$string['actions'] = 'Akce';
$string['activitylink'] = 'Odkaz na další činnost v kurzu';
$string['activitylink_help'] = 'Chcete-li na konci lekce poskytnout odkaz na jinou aktivitu v kurzu, vyberte aktivitu z rozbalovací nabídky.';
$string['activitylinkname'] = 'Přejít na {$a}';
$string['activityoverview'] = 'Máte přednášky ve zpoždění';
$string['addabranchtable'] = 'Přidat stránku';
$string['addanendofbranch'] = 'Přidat konec větve';
$string['addanewpage'] = 'Přidat novou stránku';
$string['addaquestionpage'] = 'Přidat stránku s otázkou';
$string['addaquestionpagehere'] = 'Zde vložit stránku s otázkou';
$string['addbranchtable'] = 'Přidat stránku s obsahem';
$string['addcluster'] = 'Přidat svazek stránek';
$string['addedabranchtable'] = 'Přidána stránka';
$string['addedanendofbranch'] = 'Přidán konec větve';
$string['addedaquestionpage'] = 'Stránka s otázkou byla přidána';
$string['addedcluster'] = 'Přidán svazek stránek';
$string['addedendofcluster'] = 'Přidán konec svazku';
$string['addendofbranch'] = 'Přidat konec větve';
$string['addendofcluster'] = 'Přidat konec svazku stránek';
$string['addessay'] = 'Vytvořit stránku s tvořenou odpovědí';
$string['additionalattemptsremaining'] = 'Dokončeno, tuto přednášku můžete znovu začít studovat';
$string['addmatching'] = 'Vytvořit stránku s Přiřazovací  úlohou';
$string['addmultichoice'] = 'Vytvořit stránku s úlohou s více možnostmi';
$string['addnewgroupoverride'] = 'Přidat přenastavení skupiny';
$string['addnewuseroverride'] = 'Přidat přenastavení uživatele';
$string['addnumerical'] = 'Vytvořit stránku s Číselnou odpovědí';
$string['addpage'] = 'Přidat stránku';
$string['addshortanswer'] = 'Vytvořit stránku s krátkou tvořenou odpovědí';
$string['addtruefalse'] = 'Úprava krátké tvořené odpovědi';
$string['allowofflineattempts'] = 'Povolit offline spuštění Přednášky pomocí mobilní aplikace';
$string['allowofflineattempts_help'] = 'Je-li povoleno, mobilní uživatel aplikace si můžete stáhnout přednášku a spustit ji v režimu offline. Všechny možné a správné odpovědi budou staženy také. Poznámka: Není možné spustit přednáškul v režimu offline, pokud má časový limit.';
$string['anchortitle'] = 'Začátek obsahu stránky';
$string['and'] = 'A';
$string['answer'] = 'Odpověď';
$string['answeredcorrectly'] = 'zodpovězeno správně.';
$string['answersfornumerical'] = 'Odpovědi na numerickou otázku by měly být tvořeny dvojicemi čísel udávajících dolní a horní hranici požadovaného intervalu';
$string['arrangebuttonshorizontally'] = 'Tlačítka obsahu zobrazit vodorovně';
$string['attempt'] = 'Pokus: {$a}';
$string['attemptheader'] = 'Pokus';
$string['attempts'] = 'Pokusy';
$string['attemptsdeleted'] = 'Pokusy odstraněny';
$string['attemptsremaining'] = 'Zbývající počet pokusů: {$a}';
$string['available'] = 'Datum a čas zpřístupnění';
$string['averagescore'] = 'Průměrná známka';
$string['averagetime'] = 'Průměrný čas';
$string['branch'] = 'Větev';
$string['branchtable'] = 'Obsahová stránka';
$string['cancel'] = 'Přerušit';
$string['cannotfindanswer'] = 'Chyba: nelze najít odpověď';
$string['cannotfindattempt'] = 'Chyba: nelze najít pokus';
$string['cannotfindessay'] = 'Chyba: nemohu najít tvořenou odpověď';
$string['cannotfindfirstgrade'] = 'Chyba: nelze najít hodnocení';
$string['cannotfindfirstpage'] = 'Nelze najít první stránku';
$string['cannotfindgrade'] = 'Chyba: nelze najít hodnocení';
$string['cannotfindnewestgrade'] = 'Chyba: nelze najít nejnovější hodnocení';
$string['cannotfindnextpage'] = 'Zálohování přednášky: Další stránka nebyla nalezena!';
$string['cannotfindpagerecord'] = 'Přidání na konci větve: stránka nebyla nalezena';
$string['cannotfindpages'] = 'Nepodařilo se najít stránku přednášky';
$string['cannotfindpagetitle'] = 'Potvrzení odstranění: nadpis stránky nenalezen';
$string['cannotfindpreattempt'] = 'Předchozí pokus nebyl nalezen!';
$string['cannotfindrecords'] = 'Chyba: nelze najít záznamy přednášky';
$string['cannotfindtimer'] = 'Chyba: nelze najít časové záznamy přednášky';
$string['cannotfinduser'] = 'Chyba: nelze najít uživatele';
$string['canretake'] = '{$a} může projít přednášku znovu';
$string['casesensitive'] = 'Používat regulární výrazy';
$string['casesensitive_help'] = '<p>Některé typy otázek využívají volby, která se aktivuje zatržením políčka v
záhlaví otázky. Význam této volby u jednotlivých typů otázek je uveden
níže.</p>

<ol>
  <li>
    <p><b>Otázka s výběrem odpovědí</b><br>
    Podtypem otázky s výběrem odpovědí je <b>"Otázka s výběrem více správných
    odpovědí"</b>. U tohoto typu otázky musí student vybrat všechny správné
    odpovědi. Součástí textu otázky může (ale nemusí) být informace o
    <i>celkovém počtu</i> správných odpovědí. Například otázka "Která z
    následujících osobností byla prezidentem USA?" tuto informaci neobsahuje,
    kdežto otázka "Vyberte ze seznamu dva prezidenty USA" ano. Počet správných
    odpovědí může sahat od <b>1</b> až do celkového počtu variant odpovědí. I
    při jedné správné odpovědi se však "otázka s výběrem více správných
    odpovědí" liší od "otázky s výběrem odpovědí", protože studentovi dovoluje
    vybrat více než jednu odpověď (a dopustit se tak chyby).</p>
  </li>

  <li>
    <p><b>Krátká tvořená odpověď</b><br>
    Pro tento typ otázky existují dva porovnávací systémy: jednoduchý systém,
    používaný jako výchozí, a systém "regulárních výrazů", který se aktivuje
    volbou "Používat regulární výrazy". Více informací najdete v souboru
    nápovědy "Typ otázky".</p>
  </li>
</ol>

<p>U ostatních typů otázek se volba "Nastavení otázky" nepoužívá.</p>';
$string['checkbranchtable'] = 'Zkontrolovat obsahovou stránku';
$string['checkedthisone'] = 'Odpovědělo takto';
$string['checknavigation'] = 'Zkontrolovat navigaci';
$string['checkquestion'] = 'Zkontrolovat otázku';
$string['classstats'] = 'Statistika kurzu';
$string['clicktodownload'] = 'Klikněte sem, chcete-li stáhnout soubor.';
$string['closebeforeopen'] = 'Tuto přednášku nelze aktualizovat. Specifikovali jste dřívější datum uzávěrky, než otevření přednášky.';
$string['cluster'] = 'Svazek stránek';
$string['clusterjump'] = 'Neprohlédnutá otázka v rámci svazku';
$string['clustertitle'] = 'Svazek';
$string['collapsed'] = 'Seznam stránek';
$string['comments'] = 'Váš komentář';
$string['completed'] = 'Dokončeno';
$string['completederror'] = 'Projít přednášku';
$string['completethefollowingconditions'] = 'Chcete-li pokračovat, musíte nejprve splnit následující podmínku/-y u přednášky <b>{$a}</b>:';
$string['completionendreached'] = 'Vyžadovat dokončení';
$string['completionendreached_desc'] = 'K dokončení této činnosti musí student dosáhnout konce přednášky';
$string['completiontimespent'] = 'Student musí tuto činnost splnit alespoň na';
$string['completiontimespentdesc'] = 'Student musí tuto činnost studovat nejméně  {$a}';
$string['completiontimespentgroup'] = 'Vyžadovaný čas studia';
$string['conditionsfordependency'] = 'Kritéria splnění předpokladu';
$string['configintro'] = 'Hodnoty, které zde nastavíte jako výchozí hodnoty, jsou používány ve formě výchozího nastavení při vytváření nové přednášky. Nastavení specifikovaná jako pokročilá jsou zobrazena pouze tehdy, když kliknete na odkaz "Zobrazit více ...".';
$string['configmaxanswers'] = 'Výchozí maximální počet odpovědi na stránku';
$string['configmediaclose'] = 'Zobrazuje tlačítko Zavřít jako část vyskakovacího okna vytvořeného pro odkazovaný mediální soubor';
$string['configmediaheight'] = 'Nastavuje výšku vyskakovacího okna pro odkazovaný mediální soubor';
$string['configmediawidth'] = 'Nastavuje šířku vyskakovacího okna pro odkazovaný mediální soubor';
$string['configpassword_desc'] = 'Zda je pro přístup do přednášky vyžadováno heslo.';
$string['configslideshowbgcolor'] = 'Barva pozadí plochy prezentace, pokud je povolena';
$string['configslideshowheight'] = 'Nastavení výšky plochy prezentace, pokud je povolena';
$string['configslideshowwidth'] = 'Nastavení šířky plochy prezentace, pokud je povolena';
$string['configtimelimit_desc'] = 'Pokud je nastavena lhůta,  zobrazí se na začátku přednášky a začne odpočítávání času. Pokud je nastaveno na nulu, pak neexistuje žádný časový limit.';
$string['confirmdelete'] = 'Odstranit stránku';
$string['confirmdeletionofthispage'] = 'Potvrďte odstranění této stránky';
$string['congratulations'] = 'Gratulujeme – dosáhli jste konce přednášky';
$string['continue'] = 'Pokračovat';
$string['continuetoanswer'] = 'Pokračovat – změnit odpovědi';
$string['continuetonextpage'] = 'Pokračovat na následující stránku';
$string['correctanswerjump'] = 'Skok při správné odpovědi';
$string['correctanswerscore'] = 'Bodový zisk za správnou odpověď';
$string['correctresponse'] = 'Reakce při správné odpovědi';
$string['createaquestionpage'] = 'Vytvořit stránku s úlohou';
$string['credit'] = 'Kredit';
$string['customscoring'] = 'Uživatelské bodování';
$string['customscoring_help'] = 'Po povolením uživatelského bodování je možné přiřadit ke každé odpovědi na otázky v přednášce libovolný počet bodů. Body přiřazené k odpovědím mohou mít jak kladnou, tak zápornou hodnotu. Importovaným otázkám se automaticky přiřazuje 1 bod za správnou odpověď a 0 bodů za nesprávnou odpověď. Pokud je uživatelské bodování povoleno, je možné toto nastavení po importu změnit.

Pozor! U otázek s více správnými odpověďmi je nutné Uživatelské bodování povolit aby bylo možné u jednotlivých možností bodování nastavit podle potřeby.';
$string['deadline'] = 'Termín uzavření';
$string['defaultessayresponse'] = 'Vaše tvořená odpověď bude ohodnocena vaším vyučujícím v kurzu.';
$string['deleteallattempts'] = 'Odstranit všechny pokusy o absolvování přednášky';
$string['deletedefaults'] = 'Odstraněna výchozí nastavení přednášky (počet odstraněných nastavení: {$a})';
$string['deletedpage'] = 'Stránka odstraněna';
$string['deletepagenamed'] = 'Odstranit stránku: {$a}';
$string['deleting'] = 'Odstraňování';
$string['deletingpage'] = 'Odstranění stránky: {$a}';
$string['dependencyon'] = 'Předpoklad pro zpřístupnění';
$string['dependencyon_help'] = 'Toto nastavení umožňuje, aby byla přednáška studentům přístupná podle toho, jakých výsledků dosáhli v jiné přednášce, která je součástí téhož kurzu. Rozbalovací nabídka obsahuje všechny přednášky, existující v rámci tohoto kurzu. Pokud student nesplní předpoklad pro zpřístupnění, nebude mu umožněn přístup k této přednášce.

Po výběru jedné z přednášek z rozbalovací nabídky bude aktivována možnost nastavení kritérií pro zpřístupnění, kterými jsou:

* Strávený čas (v min.): student musí strávit studiem přednášky minimálně určenou dobu.
* Dokončeno: zaškrtnutím políčka musí student stanovenou přednášku dokončit.
* Známka lepší než (%): student musí dosáhnout ve stanovené přednášce lepší známky, než která je nastavena zde.';
$string['description'] = 'Popis';
$string['detailedstats'] = 'Podrobné statistiky';
$string['didnotanswerquestion'] = 'Tuto otázku student(ka) nezodpověděl(a)';
$string['didnotreceivecredit'] = 'Odpověď nezapočtena jako správná';
$string['disabled'] = 'Vypnuto';
$string['displaydefaultfeedback'] = 'Zobrazit výchozí reakci';
$string['displaydefaultfeedback_help'] = 'Zvolte možnost "Ano" chcete-li, aby se studentům po odpovědích na otázky zobrazovaly přednastavené reakce. Pokud poté při nastavení otázek na některou zadáte vlastní reakci, bude studentům zobrazena. Ponecháte-li pole Reakce prázdné, bude studentovi zobrazena přednastavená reakce v podobě "Správná odpověď" nebo "Chybná odpověď".';
$string['displayinleftmenu'] = 'Zobrazit v levé nabídce';
$string['displayleftif'] = 'Minimální známka pro zobrazení nabídky';
$string['displayleftif_help'] = 'Umožňuje nastavit minimální hodnotu průchodu, které student musí dosáhnout při prvním procházení přednášky, aby mu při revizi bylo umožněno vidět levou nabídku se seznamem rozcestníků v přednášce.

Tato podmínka může dobře sloužit jako motivace, aby studenti při prvním pokusu prošli celou přednášku a dosáhli tak potřebného procenta průchodu přednáškou. Zejména u obsáhlejších přednášek totiž levá nabídka velmi usnadňuje následnou revizi. Je-li totiž nastavena jakákoliv minimální hodnota průchodu, student poprvé přednáškou projde v předdefinované posloupnosti a při její revizi se díky levé nabídce již může přednáškou pohybovat volně.';
$string['displayleftmenu'] = 'Zobrazit nabídku';
$string['displayleftmenu_help'] = 'Vyberete-li možnost "Ano", bude v levé části přednášky studentovi zobrazena Nabídka přednášky, tedy seznam stránek (rozcestníků) v přednášce. Zejména u obsáhlejších přednášek může levá nabídka velmi dobře sloužit pro snadnější orientaci v přednášce.

Učitel má také možnost nastavit podmíněné zobrazení levé nabídky. Student musí při prvním procházení přednášky dosáhnout minimální známky dle nastavení učitelem a až poté může při revizi přednášky levou nabídku vidět.';
$string['displayofgrade'] = 'Zobrazení známky (pouze pro studenty)';
$string['displayreview'] = 'Povolit opakování pokusu otázky';
$string['displayreview_help'] = '<p>Toto nastavení zobrazí tlačítko, které má studentům umožnit zkusit znovu
odpovědět na špatně zodpovězenou otázku. Nefunguje pro otázky typu tvořená
odpověď – pokud používáte tyto otázky, vyberte možnost "Ne".</p>
 Student je dána možnost pokusit se odpovědět znovu bez hodnocení známkou nebo pokračovat v přednášce.';
$string['displayscorewithessays'] = 'Váš bodový zisk za automaticky hodnocené odpovědi je {$a->score} z {$a->tempmaxgrade}.<br />Vaše tvořené odpovědi (v počtu {$a->essayquestions}) budou ohodnoceny a zahrnuty<br />do vašeho konečného počtu bodů později.<br /><br />Váš současný bodový zisk bez tvořených odpovědí je {$a->score} z {$a->grade}.';
$string['displayscorewithoutessays'] = 'Váš bodový zisk je {$a->score} (z {$a->grade}).';
$string['duplicatepagenamed'] = 'Duplikovat stránku: {$a}';
$string['edit'] = 'Upravit';
$string['editbranchtable'] = 'Upravit  stránku s obsahem';
$string['editcluster'] = 'Upravit svazek stránek';
$string['editendofbranch'] = 'Upravit stránku konec větve';
$string['editendofcluster'] = 'Upravit konec svazku stránek';
$string['editessay'] = 'Úprava stránky s tvořenou odpovědí';
$string['editingquestionpage'] = 'Úprava stránky s otázkou {$a}';
$string['editlessonsettings'] = 'Upravit nastavení této přednášky';
$string['editmatching'] = 'Úprava stránky s Přiřazovací  úlohou';
$string['editmultichoice'] = 'Úprava stránky s úlohou s více možnostmi';
$string['editnumerical'] = 'Úprava stránky s Číselnou odpovědí';
$string['editoverride'] = 'Upravit přenastavení';
$string['editpage'] = 'Upravit obsah této stránky';
$string['editpagecontent'] = 'Upravit obsah této stránky';
$string['editquestion'] = 'Úprava stránky s úlohou';
$string['editshortanswer'] = 'Úprava stránky s krátkou tvořenou odpovědí';
$string['edittruefalse'] = 'Úprava stránky s úlohou pravda/nepravda';
$string['email'] = 'Poslat e-mailem';
$string['emailallgradedessays'] = 'Poslat VŠECHNY oznámkované tvořené odpovědi';
$string['emailgradedessays'] = 'Poslat oznámkované tvořené odpovědi';
$string['emailsuccess'] = 'E-maily úspěšné odeslány';
$string['emptypassword'] = 'Heslo nemůže být prázdné';
$string['enabled'] = 'Povoleno';
$string['endofbranch'] = 'Konec větve';
$string['endofcluster'] = 'Konec svazku';
$string['endofclustertitle'] = 'Konec svazku';
$string['endoflesson'] = 'Konec přednášky';
$string['enteredthis'] = 'odpovědělo takto';
$string['enterpassword'] = 'Zadejte prosím heslo:';
$string['eolstudentoutoftime'] = 'Upozornění: překročili jste čas určený pro tuto přednášku. Vaše poslední odpověď nebude započítána, pokud byla odeslána až po vypršení časového limitu.';
$string['eolstudentoutoftimenoanswers'] = 'Nezodpověděli jste žádnou otázku. Za tuto přednášku nezískáváte žádný bod.';
$string['essay'] = 'Dlouhá tvořená odpověď';
$string['essayemailmessage2'] = '<p>Výzva pro tvořenou odpověď:{$a->question}</p><p>Vaše odpověď:<em>{$a->response}</em></p><p>Připomínky učitele:<em>{$a->comment}</em></p><p>obdrželi jste {$a->earned} z {$a->outof} bodů za tuto odpověď.</p><p>Vaše hodnocení se změnilo na {$a->newgrade}%.</p>';
$string['essayemailsubject'] = 'Známka za otázku přednášky';
$string['essaynotgradedyet'] = 'Tato tvořená odpověď nebyla dosud hodnocena';
$string['essayresponses'] = 'Odevzdané eseje';
$string['essays'] = 'Tvořené odpovědi';
$string['essayscore'] = 'Bodový zisk za tvořené odpovědi';
$string['eventcontentpageviewed'] = 'Zobrazena stránka obsahu';
$string['eventessayassessed'] = 'Hodnocena tvořená odpověď';
$string['eventessayattemptviewed'] = 'Zobrazeny pokusy tvořených odpovědí';
$string['eventlessonended'] = 'Přednáška skončila';
$string['eventlessonrestarted'] = 'Přednáška znovu začala';
$string['eventlessonresumed'] = 'Přednáška pokračuje';
$string['eventlessonstarted'] = 'Přednáška začala';
$string['eventoverridecreated'] = 'Vytvořeno přenastavení přednášky';
$string['eventoverridedeleted'] = 'Odstraněno přenastavení přednášky';
$string['eventoverrideupdated'] = 'Aktualizováno přenastavení přednášky';
$string['eventpagecreated'] = 'Stránka vytvořena';
$string['eventpagedeleted'] = 'Stránka odstraněna';
$string['eventpagemoved'] = 'Stránka přesunuta';
$string['eventpageupdated'] = 'Stránka aktualizována';
$string['eventquestionanswered'] = 'Otázka odpovězena';
$string['eventquestionviewed'] = 'Otázka zobrazena';
$string['false'] = 'Nepravda';
$string['fileformat'] = 'Formát souboru';
$string['finalwrong'] = 'Ne tak docela.';
$string['finish'] = 'Skončit';
$string['firstanswershould'] = 'První odpověď by měla skočit na "správnou" stránku';
$string['firstwrong'] = 'Bohužel, vaše odpověď není správná. Chcete to zkusit ještě jednou? (ovšem již bez bodového zisku)';
$string['flowcontrol'] = 'Řízení průchodu';
$string['fractionsaddwrong'] = 'Součet kladných hodnocení není roven 100 %, nýbrž činí {$a} %. <br />Chcete se vrátit a opravit tuto úlohu?';
$string['fractionsnomax'] = 'Jedna z odpovědí by měla být ohodnocena 100 %, aby bylo možné <br />získat plný počet bodů. <br />Chcete se vrátit a opravit tuto úlohu?';
$string['full'] = 'Obsah stránek';
$string['general'] = 'Obecně';
$string['gotoendoflesson'] = 'Přejít na konec přednášky';
$string['grade'] = 'Známka';
$string['gradebetterthan'] = 'Známka lepší než (%)';
$string['gradebetterthanerror'] = 'Dosáhnout více než {$a} % celkové známky';
$string['graded'] = 'Udělena známka';
$string['gradeessay'] = 'Hodnotit tvořené odpovědi (zatím nehodnoceno {$a->notgradedcount} a neodesláno {$a->notsentcount})';
$string['gradeis'] = 'Známka: {$a}';
$string['gradeoptions'] = 'Nastavení známkování';
$string['groupoverrides'] = 'Skupinová přenastavení';
$string['groupoverridesdeleted'] = 'Přenastavení skupiny odstraněna';
$string['groupsnone'] = 'V tomto kurzu nejsou žádné skupiny, ke kterým máte přístup.';
$string['handlingofretakes'] = 'Zpracování opakovaného průchodu';
$string['handlingofretakes_help'] = '<p>Jestliže je studentům povoleno procházet přednášku opakovaně, umožňuje tato
volba určit, zda bude výslednou známkou za přednášku <b>průměr</b> získaných
známek, nebo <b>nejlepší</b> získaná známka.</p>

<p>Tuto volbu lze kdykoliv změnit.</p>';
$string['havenotgradedyet'] = 'Ještě neznámkováno';
$string['here'] = 'zde';
$string['highscore'] = 'Nejlepší známka';
$string['hightime'] = 'Nejdelší čas';
$string['importcount'] = 'Importuji {$a} otázek';
$string['importquestions'] = 'Importovat otázky';
$string['importquestions_help'] = '<p>Tato funkce umožňuje importování úloh z externích textových souborů.</p>

<p>Moodle podporuje několik formátů:</p>

<p><b>Formát GIFT</b></p>

<div style="margin-left: 2em">
  <p>GIFT je nejkomplexnější dostupný formát pro importování testových otázek z
  textového souboru do Moodlu. Byl navržen pro snadný textový zápis testových
  otázek. Podporuje různé typy úloh: úlohy s výběrem odpovědí, s krátkou
  odpovědí, s odpovědí pravda/nepravda, numerické úlohy, přiřazování, a také
  vložení _______ pro formát "vynechané slovo". V jednom textovém souboru lze
  použít více typů úloh. Formát GIFT dále umožňuje zadávat jméno otázky,
  komentář k odpovědím a jejich hodnocení v procentech; pro interní potřebu lze
  text také opatřovat poznámkami, které se v otázkách nezobrazí. Zde je několik
  příkladů:</p>
  <pre>
Kdo je pohřben v památníku na Vítkově?{~T.G.M. ~Klement Gottwald =nikdo}

V památníku na Vítkově byl {~otráven =pohřben ~oddán} Klement Gottwald.

V památníku na Vítkově je pohřben Klement Gottwald.{FALSE}

Kdo je pohřben v památníku na Vítkově?{=nyní již nikdo =nikdo}

Kdy se narodil Klement Gottwald?{#1896}
</pre>

  <p align="right"><a href="help.php?file=formatgift.html&module=quiz">Více o
  formátu "GIFT"</a></p>
</div>

<p><b>Formát Aiken</b></p>

<div style="margin-left: 2em">
  <p>Formát Aiken umožňuje snadnou tvorbu úloh s výběrem odpovědí. Používá
  jednoduchou syntaxi srozumitelnou i pro člověka. Např:</p>
  <pre>
Co je cílem první pomoci?
A. Zachránit život, zabránit dalšímu zranění, chránit zdraví B. Poskytnout lékařské ošetření zraněnému C. Zabránit dalšímu zranění D. Pomoci obětem v nouzi ODPOVĚĎ: A
</pre>

  <p align="right"><a href="help.php?file=formataiken.html&module=quiz">Více o
  formátu "AIKEN"</a></p>
</div>

<p><b>Vynechané slovo</b></p>

<div style="margin-left: 2em">
  <p>Tento formát podporuje pouze úlohy s výběrem odpovědí. Chybné varianty
  odpovědi se uvozují vlnovkou (~), správná odpověď rovnítkem (=). Např.:</p>

  <blockquote>
    Již v raném věku, kdy začínáme zkoumat své tělo, se z nás stávají studenti
    {=anatomie a fyziologie ~mechaniky ~teologie ~botaniky}, a studenty v
    jistém smyslu zůstáváme až do konce života.
  </blockquote>

  <p align="right"><a href=
  "help.php?file=formatmissingword.html&module=quiz">Více o formátu "Vynechané
  slovo"</a></p>
</div>

<p><b>AON</b></p>

<div style="margin-left: 2em">
  <p>Tento formát se od předchozího liší pouze tím, že po provedení importu se
  všechny úlohy s krátkou odpovědí po čtveřicích převedou na přiřazovací
  úlohy.</p>

  <p>Kromě toho se u úloh s výběrem odpovědí během vkládání náhodně změní
  pořadí odpovědí.</p>

  <p>Formát je pojmenován podle organizace, která sponzorovala vývoj
  testovacích nástrojů.</p>
</div>

<p><b>Blackboard</b></p>

<div style="margin-left: 2em">
  <p>Importovat lze i úlohy z exportního formátu systému Blackboard. Tento
  formát využívá funkcí PHP určených pro práci s jazykem XML.</p>

  <p align="right"><a href=
  "help.php?file=formatblackboard.html&module=quiz">Více o formátu
  "Blackboard"</a></p>
</div>

<p><b>Course Test Manager</b></p>

<div style="margin-left: 2em">
  <p>Do Moodlu lze importovat úlohy z databáze testovacích otázek systému
  Course Test Manager (CTM). Pro přístup k testovacím otázkám (uloženým v
  databázi Microsoft Access) se používají různé postupy v závislosti na tom,
  zda je Moodle provozován v operačním systému Windows nebo Linux.</p>

  <p>Ve Windows můžete importovat databázi formátu Microsoft Access běžným
  způsobem.</p>

  <p>V případě Linuxu potřebujete počítač s Windows umístěný na stejné síti. Na
  něj zkopírujte databázi CTM a spusťte ODBC Socket Server, který pro převod
  dat do Moodlu na serveru Linux použije jazyka XML.</p>

  <p>Před použitím tohoto importního filtru si prosím přečtěte podrobnější
  nápovědu.</p>

  <p align="right"><a href="help.php?file=formatctm.html&module=quiz">Více o
  formátu "CTM"</a></p>
</div>

<p><b>Uživatelský formát</b></p>

<div style="margin-left: 2em">
  <p>Pokud máte vlastní formát, který potřebujete importovat, upravte podle
  potřeby soubor mod/quiz/format/custom.php.</p>

  <p>Rozsah nutných změn v kódu je opravdu malý &ndash; nový kód je potřeba pouze pro
  rozpoznání jedné úlohy ve výchozím textu.</p>

  <p align="right"><a href="help.php?file=formatcustom.html&module=quiz">Více o
  uživatelském formátu</a></p>
</div>

<p>Postupně budou přibývat další formáty, např. WebCT, IMS QTI a jakékoliv
jiné, kterými přispějí uživatelé Moodlu.</p>';
$string['inactiveoverridehelp'] = '* Student není ve správné skupině nebo nemá správnou roli pro přístup do přednášky';
$string['indicator:cognitivedepth'] = 'Kognitivní Přednáška';
$string['indicator:cognitivedepth_help'] = 'Tento ukazatel je založen na studentem získané kognitivní hloubce v aktivitě Přednáška.';
$string['indicator:socialbreadth'] = 'Sociální Přednáška';
$string['indicator:socialbreadth_help'] = 'Tento ukazatel je založen na studentem získané sociální šířce v aktivitě Přednáška.';
$string['insertedpage'] = 'Stránka přidána';
$string['invalidfile'] = 'Chybný soubor';
$string['invalidid'] = 'Skript neobdržel identifikátor modulu nebo identifikátor přednášky.';
$string['invalidlessonid'] = 'Neplatný identifikátor přednášky';
$string['invalidoverrideid'] = 'Neplatný identifikátor přenastavení';
$string['invalidpageid'] = 'Neplatný identifikátor stránky';
$string['jump'] = 'Skočit na';
$string['jumps'] = 'Skok';
$string['jumps_help'] = 'Každá odpověď (u otázek) nebo popis (u rozcestníků) má odpovídající skok. Skok může být relativní, jako je tato stránka nebo následující stránka, nebo absolutní, s uvedením kterékoli ze stránek v lekci.
<p>
Relativními skoky jsou <b>Tato stránka</b> a <b>Další stránka</b>. <b>Tato
stránka</b> vede studenta zpět na aktuální stránku, <b>Další stránka</b> jej
vede na následující stránku v lineární posloupnosti přednášky. Absolutní skok
se určuje výběrem <b>názvu</b> konkrétní stránky.</p>

<p>Upozornění: relativní skok <b>Další stránka</b> může po změně pořadí stránek
vést k jiné cílové stránce, zatímco absolutní skok, označený názvem cílové
stránky, vede vždy k téže cílové stránce.</p>

<p><b>Zvláštní skoky</b></p>

<p><b>Neprohlédnutá stránka v rámci větve</b><br>
Toto je odkaz na náhodně vybranou stránku, kterou student dosud v tomto pokusu
neviděl a která se nachází mezi aktuálním rozcestníkem a koncem přednášky nebo
nejbližším koncem větve.</p>

<p><b>Náhodná stránka v rámci větve</b><br>
Toto je odkaz na náhodně vybranou stránku mezi aktuálním rozcestníkem a koncem
přednášky nebo nejbližším koncem větve. Pokud student už stránku viděl a počet
pokusů je nastaven na hodnotu vyšší než 1, dostane další příležitost získat
bod(y) za odpověď na připojenou otázku. Pokud je počet pokusů nastaven na 1,
stránka se přeskočí a ukáže se jiná náhodná stránka.</p>

<p><b>Náhodný rozcestník</b><br>
Toto je skok na náhodně vybraný rozcestník mezi aktuálním rozcestníkem a koncem
přednášky nebo nejbližším koncem větve.</p>';
$string['jumpsto'] = 'Skok na <em>{$a}</em>';
$string['leftduringtimed'] = 'Opustili jste přednášku s časovým limitem.<br />Chcete-li přednášku začít znovu, stiskněte Pokračovat.';
$string['leftduringtimednoretake'] = 'Opustili jste přednášku s časovým limitem a není<br />vám povoleno začít znovu nebo pokračovat.';
$string['leftduringtimedsession'] = 'Opustili jste přednášku s časovým limitem';
$string['lesson:addinstance'] = 'Přidat novou přednášku';
$string['lesson:edit'] = 'Upravit přednášku';
$string['lesson:grade'] = 'Hodnotit tvořené odpovědi přednášky';
$string['lesson:manage'] = 'Správa činnosti přednáška';
$string['lesson:manageoverrides'] = 'Správa přenastavení přednášky';
$string['lesson:view'] = 'Zobrazit činnost přednáška';
$string['lesson:viewreports'] = 'Zobrazit sestavu přednášky';
$string['lessonclosed'] = 'Tato přednáška byla uzavřena k datu {$a}.';
$string['lessoncloses'] = 'Přednáška není přístupná';
$string['lessoncloseson'] = 'Přednáška se uzavírá: {$a}';
$string['lessoneventcloses'] = '{$a} - uzavřeno';
$string['lessoneventopens'] = '{$a} - otevřeno';
$string['lessonformating'] = 'Uspořádání přednášky';
$string['lessonmenu'] = 'Nabídka přednášky';
$string['lessonname'] = 'Přednáška: {$a}';
$string['lessonnotready'] = 'Tato přednáška ještě není hotová. Obraťte se na svého učitele.';
$string['lessonnotready2'] = 'Tato přednáška ještě není hotová.';
$string['lessonopen'] = 'Tato přednáška bude přístupná od {$a}.';
$string['lessonopens'] = 'Přednáška je přístupná';
$string['lessonpagelinkingbroken'] = 'Nenalezena první stránka přednášky. Vnitří odkazy mezi stránkami jsou zřejmě porušeny. Obraťte se na správce Moodlu.';
$string['lessonstats'] = 'Statistiky přednášky';
$string['linkedmedia'] = 'Odkaz na média';
$string['loginfail'] = 'Nesprávné heslo. Zkuste to prosím znovu.';
$string['lowscore'] = 'Nejhorší známka';
$string['lowtime'] = 'Nejkratší čas';
$string['manualgrading'] = 'Hodnotit tvořené odpovědi';
$string['matchesanswer'] = 'Odpovídá odpovědi';
$string['matching'] = 'Přiřazování';
$string['matchingpair'] = 'Přiřazování odpovídající dvojice {$a}';
$string['maxgrade'] = 'Nejvyšší možné hodnocení';
$string['maxgrade_help'] = '<p>Tato hodnota udává maximální počet bodů, které lze udělit za absolvování
přednášky. Rozsah je 0 až 100. Tuto hodnotu lze později kdykoliv změnit. Každá
změna se ihned projeví v přehledu známek kurzu a také v různých seznamech
výsledků zobrazovaných studentům. Jestliže je známka stanovena na 0, přednáška
se v přehledu známek neobjeví.</p>';
$string['maximumnumberofanswersbranches'] = 'Největší možný počet odpovědí';
$string['maximumnumberofanswersbranches_help'] = '<p>Tato hodnota udává největší možný počet odpovědí, které lze zadat ke
kterékoli otázce přednášky.  Pokud v přednášce používáte
výhradně otázky typu Pravda/Nepravda, je vhodné nastavit tuto hodnotu na 2.</p>';
$string['maximumnumberofattempts'] = 'Největší možný počet pokusů';
$string['maximumnumberofattempts_help'] = 'Tato hodnota určuje nejvyšší možný počet pokusů, který má každý student k dispozici pro zodpovězení každé otázky v přednášce. V případě otázek, u nichž se studentovi nenabízejí varianty odpovědi (dlouhá tvořená odpověď, krátká tvořená odpověď), představuje tato hodnota nezbytný "záchranný prostředek" zajišťující přechod na další stránku přednášky. Tato hodnota se nevztahuje na učitele, který provádí kontrolu otázek nebo navigace v přednášce.

Výchozí hodnota je 1. Ponecháte-li toto nastavení, student bude mít na zodpovězení každé otázky pouze 1 pokus. Vzniká tak podobný režim jako u modulu Test, s tím rozdílem, že každá otázka je studentům nabízena na zvláštní stránce.

Pozor! Nastavená hodnota se uplatní u všech otázek přednášky.';
$string['maximumnumberofattemptsreached'] = 'Vyčerpali jste maximální počet pokusů – následuje další stránka přednášky';
$string['mediaclose'] = 'Zobrazit tlačítko \'Zavřít okno\'';
$string['mediafile'] = 'Odkaz na soubor ve vyskakovacím okně';
$string['mediafile_help'] = 'Toto nastavení vytvoří v přednášce odkaz na vyskakovací okno se souborem (například mp3 souborem, obrázkem apod.) nebo odkazem na webovou stránku. Odkaz na vyskakovací okno bude zobrazen na každé stránce přednášky, takže jej bude možné kdykoliv podle potřeby otevřít.';
$string['mediafilepopup'] = 'Klikněte sem pro zobrazení souboru';
$string['mediaheight'] = 'výška okna';
$string['mediawidth'] = 'šířka okna';
$string['messageprovider:graded_essay'] = 'Oznámení o hodnocení tvořené odpovědi';
$string['minimumnumberofquestions'] = 'Minimální počet otázek';
$string['minimumnumberofquestions_help'] = 'Slouží k nastavení minimálního počtu otázek, ze kterých bude následně vypočtena studentova známka za přednášku. Toto nastavení nevytváří studentovi povinnost odpovědět nastavené množství otázek. Pokud zde však učitel nastaví nějakou hodnotu a student jí při procházení přednášky nedosáhne, bude jeho výsledná známka snížena, protože nastavení předpokládá, že odpověděl minimálně na tolik otázek, kolik je zde nastaveno (viz příklad níže).

Příklad: Student absolvuje pouze jednu pětistránkovou větev přednášky a všechny otázky zodpoví správně. Poté se rozhodne přednášku opustit (za předpokladu, že to nastavení přednášky umožňuje, tedy některý z větvících bodů, kterými student prochází, nabízí možnost "Skočit na konec přednášky"). Pokud je parametr Minimální počet otázek nastaven na 0, hodnocení studenta by bylo "pět správných odpovědí z pěti", tedy 100 %. Je-li však Minimální počet otázek nastaven například na hodnotu 20, celkové hodnocení bude sníženo na "pět správných odpovědí z dvaceti", tedy 25 %. Jiný student, který prošel všechny větve přednášky, zhlédl například 25 stránek a zodpověděl správně všechny otázky až na dvě, získá hodnocení "23 z 25", tedy 92 %.

Jestliže je nějaký minimální počet otázek pro získání známky v přednášce nastaven, student by o tom v úvodu přednášky měl být informován.';
$string['missingname'] = 'Prosím vložte přezdívku';
$string['modattempts'] = 'Povolit studentům pozdější revizi';
$string['modattempts_help'] = 'Nastavením možnosti "Ano" bude na poslední stránku přednášky přidáno tlačítko "Revize přednášky", které studentům umožní opětovné prohlédnutí přednášky a odpovědí, které do ní zadali.';
$string['modattemptsnoteacher'] = 'Revize funguje pouze studentům';
$string['modulename'] = 'Přednáška';
$string['modulename_help'] = 'Modul Přednáška umožňuje vytvářet adaptivní a interaktivní výkladový materiál. Učitel může využít Přednášku pro vytvoření posloupnosti stránek nebo vzdělávacích aktivit, které nabízejí studentovi celou řadu cest a možností procházení.

Jednotlivé stránky lze doplnit o kontrolní otázky (např. výběr z možností, párování a krátké odpovědi). V závislosti na odpovědi a nastavení Přednášky mohou studenti postupit na další stránku, jít zpět na předchozí nebo pokračovat zcela jinou cestou.

Přednáška může být hodnocena, výsledná známka je součástí klasifikace v kurzu.

Modul Přednáška může být použit:

* pro samostudium nových témat
* pro rozvoj schopnosti rozhodovat se v simulovaných podmínkách
* pro adaptivní testování se sadami úloh v závislosti na odpovědi na úvodní úlohu';
$string['modulenameplural'] = 'Přednášky';
$string['move'] = 'Přesunout stránku';
$string['movedpage'] = 'Stránka přesunuta';
$string['movepagehere'] = 'Přesunout stránku sem';
$string['movepagenamed'] = 'Přesunout stránku: {$a}';
$string['moving'] = 'Přesun stránky: {$a}';
$string['multianswer'] = 'Více správných odpovědí';
$string['multianswer_help'] = '<p>Některé typy otázek využívají volby, která se aktivuje zatržením políčka v
záhlaví otázky. Význam této volby u jednotlivých typů otázek je uveden
níže.</p>

<ol>
  <li>
    <p><b>Otázka s výběrem odpovědí</b><br>
    Podtypem otázky s výběrem odpovědí je <b>"Otázka s výběrem více správných
    odpovědí"</b>. U tohoto typu otázky musí student vybrat všechny správné
    odpovědi. Součástí textu otázky může (ale nemusí) být informace o
    <i>celkovém počtu</i> správných odpovědí. Například otázka "Která z
    následujících osobností byla prezidentem USA?" tuto informaci neobsahuje,
    kdežto otázka "Vyberte ze seznamu dva prezidenty USA" ano. Počet správných
    odpovědí může sahat od <b>1</b> až do celkového počtu variant odpovědí. I
    při jedné správné odpovědi se však "otázka s výběrem více správných
    odpovědí" liší od "otázky s výběrem odpovědí", protože studentovi dovoluje
    vybrat více než jednu odpověď (a dopustit se tak chyby).</p>
  </li>

  <li>
    <p><b>Krátká tvořená odpověď</b><br>
    Pro tento typ otázky existují dva porovnávací systémy: jednoduchý systém,
    používaný jako výchozí, a systém "regulárních výrazů", který se aktivuje
    volbou "Používat regulární výrazy". Více informací najdete v souboru
    nápovědy "Typ otázky".</p>
  </li>
</ol>

<p>U ostatních typů otázek se volba "Nastavení otázky" nepoužívá.</p>';
$string['multichoice'] = 'Více možností';
$string['multipleanswer'] = 'Více odpovědí';
$string['nameapproved'] = 'Přezdívka schválena';
$string['namereject'] = 'Přezdívka byla zamítnuta filtrem.<br />Zkuste prosím jinou.';
$string['new'] = 'nový';
$string['nextpage'] = 'Další stránka';
$string['noanswer'] = 'Neodpověděli jste jednu nebo více otázek. Prosím, vraťte se zpět a zadejte odpověď.';
$string['noattemptrecordsfound'] = 'Nenalezeny žádné záznamy o pokusech: neznámkováno';
$string['nobranchtablefound'] = 'Nebyla nalezena stránka';
$string['noclose'] = 'Neexistuje datum uzavření';
$string['nocommentyet'] = 'Zatím bez komentářů.';
$string['nocoursemods'] = 'Nenalezeny žádné činnosti';
$string['nocredit'] = 'Není kredit';
$string['nodeadline'] = 'Bez termínu';
$string['noessayquestionsfound'] = 'Nebyly nalezeny žádné otázky typu tvořená odpověď';
$string['nohighscores'] = 'Nebyly nalezeny žádné položky seznamu nejlepších známek';
$string['nolessonattempts'] = 'O zodpovězení otázek v této přednášce se ještě nikdo nepokusil.';
$string['nolessonattemptsgroup'] = 'Někteří ({$a}) členové skupiny se dosud nepokusili o absolvování této přednášky.';
$string['none'] = 'Nikdo';
$string['nooneansweredcorrectly'] = 'Nikdo neodpověděl správně.';
$string['nooneansweredthisquestion'] = 'Nikdo nezodpověděl tuto otázku.';
$string['noonecheckedthis'] = 'Tuto možnost nikdo nevybral.';
$string['nooneenteredthis'] = 'Takto nikdo neodpověděl.';
$string['noonehasanswered'] = 'Nikdo ještě nevložil tvořenou odpověď.';
$string['noonehasansweredgroup'] = 'Dosud nikdo z {$a} neodpověděl na otázku typu textová odpověď.';
$string['noopen'] = 'Není datum zpřístunění';
$string['nooverridedata'] = 'Musíte přepsat alespoň jeden parametr nastavení lekce.';
$string['noretake'] = 'Není vám povoleno opakovat tuto přednášku.';
$string['normal'] = 'Normální - následuj plán přednášky';
$string['notcompleted'] = 'Nedokončeno';
$string['notdefined'] = 'Není definováno';
$string['notenoughsubquestions'] = 'Není definováno dost podotázek!<br />Chcete se vrátit zpět a opravit tuto úlohu?';
$string['notenoughtimespent'] = 'Přednášku jste dokončili za {$a->timespent}, což je méně, než požadovaný čas {$a->timerequired}. Možná budete muset přednášku studovat znovu.';
$string['notgraded'] = 'Nehodnoceno';
$string['notitle'] = 'Bez názvu';
$string['notyetcompleted'] = 'Přednáška byla zahájena, ale doposud není dokončena';
$string['numberofcorrectanswers'] = 'Počet správných odpovědí: {$a}';
$string['numberofcorrectanswersheader'] = 'Počet správných odpovědí';
$string['numberofcorrectmatches'] = 'Počet správných přiřazení: {$a}';
$string['numberofpagestoshow'] = 'Počet stránek k zobrazení';
$string['numberofpagestoshow_help'] = 'Pokud jste v nastavení Akce po správné odpovědi nastavili možnost ’’Ukázat neprohlédnutou stránku’’ či ’’Ukázat nezodpovězenou stránku’’, zde je možné nastavit, jaký maximální počet stránek bude při náhodném procházení přednáškou studentovi zobrazen. Výchoz je hodnota 0, kterou když ponecháte, budou studentovi zobrazeny všechny stránky přednášky.

Pokud je hodnota parametru vyšší než celkový počet stránek přednášky, dosáhne student konce přednášky po prostudování všech stránek.';
$string['numberofpagesviewed'] = 'Počet prohlédnutých stránek: {$a}';
$string['numberofpagesviewedheader'] = 'Počet zodpovězených dotazů';
$string['numberofpagesviewednotice'] = 'Máte {$a->nquestions} zodpovězených otázek; (Máte jich zodpovědět alespoň: {$a->minquestions})';
$string['numerical'] = 'Numerická';
$string['offlinedatamessage'] = 'Pokus jste spustili pomocí mobilního zařízení. Data byla naposledy uložena na tomto webu před {$a}. Zkontrolujte, zda nemáte nějaké neuložené práce.';
$string['ongoing'] = 'Zobrazovat průběžný bodový zisk';
$string['ongoing_help'] = '<p>Jestliže aktivujete tuto možnost, bude se studentům na každé stránce
přednášky zobrazovat aktuální počet bodů, které dosud získali z celkového
počtu. Příklad: Student zodpověděl čtyři 5bodové otázky, a z nich jednu
nezodpověděl správně. Průběžný bodový zisk tohoto studenta je 15/20.</p>';
$string['ongoingcustom'] = 'Váš dosavadní bodový zisk: {$a->score} z {$a->currenthigh}.';
$string['ongoingnormal'] = 'Zatím jste správně zodpověděli {$a->correct} z {$a->viewed} otázek.';
$string['onpostperpage'] = 'Pro jednotlivé hodnocení je povolen jen jeden pokus';
$string['openafterclose'] = 'Zadali jste datum otevření po datu uzavření';
$string['options'] = 'Možnosti';
$string['or'] = 'NEBO';
$string['ordered'] = 'Seřazeno';
$string['other'] = 'Další';
$string['outof'] = 'z {$a}';
$string['override'] = 'Přenastavení';
$string['overridedeletegroupsure'] = 'Skutečně chcete odstranit přenastavení skupiny {$a}?';
$string['overridedeleteusersure'] = 'Skutečně chcete odstranit přenastavení uživatele {$a}?';
$string['overridegroup'] = 'Přenastavit skupinu';
$string['overridegroupeventname'] = '{$a->lesson} - {$a->group}';
$string['overrides'] = 'Přenastavení';
$string['overrideuser'] = 'Přenastavit uživatele';
$string['overrideusereventname'] = '{$a->lesson} - přenastavení';
$string['overview'] = 'Přehled';
$string['overview_help'] = '<ol>
  <li>Přednáška sestává z určitého počtu <b>stránek</b> a případně také z
  <b>rozcestníků</b>.</li>

  <li>Stánky podávají vlastní <b>obsah</b> přednášky a jsou obvykle zakončeny
  <b>otázkou</b>. Odtud termín <b>Stránka s otázkou</b>, označující běžnou
  stránku přednášky.</li>

  <li>Otázkám typu tvořená odpověď nejsou přiřazeny odpovědi, pouze počet bodů,
  komentář a skok na stránku.</li>

  <li>Ke každé odpovědi je přiřazen krátký text, který se zobrazí, jestliže
  student danou odpověď zvolí. Tento krátký text se nazývá <b>reakce</b>.</li>

  <li>K odpovědi je také přiřazen <b>skok</b>. Skok může být relativní (tato
  stránka, následující stránka), nebo absolutní (konkrétní stránka nebo konec
  přednášky).</li>

  <li>Ve výchozím nastavení je s první odpovědí spojen skok na <b>následující
  stránku</b> přednášky. Ostatní odpovědi vedou zpět na aktuální stránku. Pokud
  student zvolí jinou odpověď než tu, která je v nastavení uvedena na prvním
  místě (tj. pokud odpoví nesprávně), je mu zobrazena tatáž stránka. Pokud jste
  již vytvořili seskupení s koncem seskupení, a otázka je jeho součástí, můžete
  také zvolit skok na neprohlédnutou otázku v rámci seskupení. Tato možnost se
  vám nenabídne, pokud se nenacházíte uvnitř seskupení. Z vybrané sady otázek
  můžete kdykoli vytvořit seskupení tak, že před ni vložíte začátek seskupení a
  za ni konec seskupení.</li>

  <li>"Následující stránka" je určena <b>lineární posloupností</b> stránek
  přednášky. To je pořadí, ve kterém jednotlivé stránky vidí učitel. Lze je
  kdykoliv změnit přesunutím stránek v rámci přednášky.</li>

  <li>Přednáška má dále <b>navigační posloupnost</b>. To je pořadí, ve kterém
  jednotlivé stránky vidí student. Je definováno skoky nastavenými u
  jednotlivých odpovědí a od lineární posloupnosti se může značně lišit. (Pokud
  jste výchozí nastavení skoků neměnili, jsou si ovšem obě posloupnosti velmi
  podobné.) Učitel má možnost navigační posloupnost kontrolovat a
  upravovat.</li>

  <li>Při zobrazování studentům jsou varianty odpovědi obvykle zamíchány.
  Odpověď, kterou učitel vidí jako první, není tedy nutně uvedena jako první
  odpověď nabízená studentovi. (Navíc se odpovědi při každém pokusu velmi
  pravděpodobně zobrazí v jiném pořadí.) Výjimku tvoří sada odpovědí u
  přiřazovacích otázek, zde se odpovědi zobrazují v pořadí, které zadá
  učitel.</li>

  <li>Počet odpovědí může být na každé stránce přednášky jiný. Některé otázky
  tak mohou například končit otázkou typu Pravda/Nepravda, a jiné zase např.
  obsahovat jednu správnou odpověď a tři distraktory.</li>

  <li>Do přednášky lze zařadit také stránku bez otázky. Studentům se místo
  variant odpovědí zobrazí jen odkaz <b>Pokračovat</b>.</li>

  <li>Pokud je uživatelské bodování <i>vypnuto</i>, pak se pro účely hodnocení
  považují za <b>správné</b> ty odpovědi, z nichž vede skok na stránku
  umístěnou <i>níže</i> v lineární posloupnosti stránek. <b>Chybné</b> jsou
  naopak odpovědi, z nichž vede skok na tutéž stránku nebo stránku umístěnou v
  lineární posloupnosti výše. Pokud jste neměnili výchozí nastavení, první
  odpověď bude chápána jako správná a ostatní jako chybné.<br>
  Pokud je uživatelské bodování <i>zapnuto</i>, je bodový zisk za odpověď určen
  bodovou hodnotou odpovědi; celkový počet získaných bodů je uváděn jako
  procentní podíl z nejvyšší možné známky, kterou lze za přednášku získat,
  maximální hodnotou je 100 %.</li>

  <li>Otázky mohou mít více než jednu správnou odpověď. Vedou-li například dvě
  z odpovědí na stránku umístěnou v lineární posloupnosti níže, považují se za
  správné obě dvě. (Je však možné pro každou ze správných odpovědí nastavit
  různé reakce, i když obě vedou na stejnou stránku.)</li>

  <li>V pohledu učitele jsou popisky u správných odpovědí podtrženy (např.:
  <u>Odpověď 1</u>).</li>

  <li><b>Rozcestníky</b> jsou stránky, které obasahují odkazy na jiné stránky v
  přednášce. Přednáška může typicky začínat rozcestníkem, který slouží jako
  obsah.</li>

  <li>Všechny odkazy v rozcestníku mají dvě části – popis a název stránky, na
  kterou odkazují.</li>

  <li>Rozcestník ve skutečnosti rozděluje přednášku na několik <b>větví</b>
  (nebo sekcí). Každá větev může obsahovat libovolný počet stránek
  (vztahujících se obvykle k témuž tématu). Konec větve je obvykle označen
  stránkou <b>konec větve</b>. Jde o zvláštní stránku, která studenta
  automaticky vrací na předcházející rozcestník. ("Zpětný" skok na stránce
  konce větve je možno změnit v nastavení stránky, pokud je to třeba.)</li>

  <li>Přednáška může obsahovat více než jeden rozcestník. Je například možné
  strukturovat přednášku tak, že podrobné informace jsou umístěny v podřazených
  větvích několika hlavních tematických větví.</li>

  <li>Je důležité poskytnout studentům možnost ukončení přednášky. Odkaz na
  "Konec přednášky" je možno uvést v hlavním rozcestníku. Je to skok na
  (imaginární) stránku <b>Konec přednášky</b>. Jinou možností je, aby poslední
  větev v přednášce ("poslední" se zde chápe jako poslední v lineární
  posloupnosti) prostě pokračovala na konec přednášky, tj. aby <i>nebyla</i>
  ukončena stránkou konce větve.</li>

  <li>Jestliže je uživatelské bodování <i>vypnuto</i>, je vhodné, v případě, že
  přednáška obsahuje jeden nebo více rozcestníků, nastavit "Minimální počet
  otázek" na nějakou rozumnou hodnotu. Tímto nastavením zadáme dolní limit
  počtu prohlédnutých stránek pro výpočet známky. Bez tohoto parametru by
  student mohl navštívit jen jednu větev přednášky, odpovědět správně na
  všechny otázky a opustit přednášku s plným počtem bodů.<br>
  Jestliže je uživatelské bodování <i>zapnuto</i>, je známka studenta založena
  na poměru počtu získaných bodů vůči celkovému počtu bodů, které lze v
  přednášce získat.</li>

  <li>Kromě toho má student při vypnutém uživatelském bodování možnost, je-li k
  dispozici rozcestník, znovu navštívit tutéž větev víckrát než jednou. Známka
  se ovšem počítá podle počtu zodpovězených <i>jedinečných</i> otázek.
  Opakované odpovědi na tutéž skupinu otázek tak výslednou známku
  <i>nezlepší</i>. (Ve skutečnosti je tomu právě naopak – tento postup známku
  snižuje, neboť jako jmenovatel se při výpočtu známky používá počet
  prohlédnutých stránek, a ten opakovaná prohlížení zahrnuje.) Aby měli
  studenti představu o tom, jak postupují ve studiu přednášky, zobrazují se jim
  na každé stránce rozcestníku podrobnosti o tom, kolik otázek odpověděli
  správně, kolik stránek prohlédli a jakou mají v daném okamžiku známku.<br>
  Je-li uživatelské bodování zapnuto, může student znovu odpovídat na otázku,
  pokud mu to umožní navigační cesta, a znovu za tuto otázku získat bod(y),
  jestliže je počet pokusů nastaven na hodnotu vyšší než 1. Abyste tomu
  zabránili, stanovte počet pokusů na 1.</li>

  <li>Na <b>konec přednášky</b> student dojde buď explicitně (přímým skokem),
  nebo implicitně, tj. skokem na následující stránku z poslední stránky v
  lineární posloupnosti přednášky. Je-li uživatelské bodování <i>vypnuto</i>,
  zobrazí se studentovi po dosažení konce přednášky blahopřání a známka, které
  dosáhl. Tato známka vznikne vyhodnocením výrazu (počet správných odpovědí /
  počet navštívených stránek) * nejlepší možná známka za přednášku. Je-li
  uživatelské bodování <i>zapnuto</i>, známka se stanoví jako procentní poměr
  nejlepší možné známky (např. 3 body získané za 3bodovou přednášku = 100 % ze
  3 bodů).</li>

  <li>Pokud student nedospěl na konec přednášky, dostane při příští návštěvě
  přednášky na výběr, zda chce začít od začátku, nebo zda chce do přednášky
  vstoupit v místě poslední správně zodpovězené otázky.</li>

  <li>Je-li u přednášky povoleno její opakované prohlížení, má učitel možnost
  volby, zda použije nejlepší známku nebo průměr známek jako "konečnou" známku
  za přednášku. Tato známka se pak zobrazí mj. na stránce Známky.</li>

  <li><b>Seskupení</b>: Seskupení představuje sadu otázek, z nichž lze
  studentům náhodně vybírat a nabízet jednu nebo více stránek. Seskupení by
  měla být ideálně ukončena stránkou "konec seskupení" (pokud tomu tak není, je
  za konec seskupení považován konec přednášky). Otázky v rámci seskupení jsou
  náhodně vybírány, jestliže jako skok vybereme možnost "Neprohlédnutá otázka v
  rámci seskupení". Otázky v rámci seskupení mohou buď odkazovat na konec
  seskupení (a tak seskupení opustit), nebo na neprohlédnutou otázku v rámci
  seskupení, nebo na jakoukoli jinou stránku v přednášce. Toto nastavení také
  umožňuje použít modulu Přednáška k vytvoření různých studijních scénářů
  obsahujících náhodný prvek.</li>
</ol>';
$string['page'] = 'Stránka: {$a}';
$string['page-mod-lesson-edit'] = 'Stránka pro úpravu přednášky';
$string['page-mod-lesson-view'] = 'Stránka pr prohlížení či náhled přednášky';
$string['page-mod-lesson-x'] = 'Jakákoliv stránka přednášky';
$string['pageanswers'] = 'Stránka odpovědí';
$string['pagecontents'] = 'Obsah stránky';
$string['pageresponses'] = 'Stránka reakcí';
$string['pages'] = 'Stránky';
$string['pagetitle'] = 'Název stránky';
$string['password'] = 'Heslo';
$string['passwordprotectedlesson'] = 'Přednáška {$a} je chráněna heslem.';
$string['pleasecheckoneanswer'] = 'Zvolte prosím jednu odpověď';
$string['pleasecheckoneormoreanswers'] = 'Zvolte prosím jednu nebo více odpovědí';
$string['pleaseenteryouranswerinthebox'] = 'Vložte prosím svou odpověď';
$string['pleasematchtheabovepairs'] = 'Přiřaďte prosím odpovídající páry';
$string['pluginadministration'] = 'Správa přednášky';
$string['pluginname'] = 'Přednáška';
$string['pointsearned'] = 'Počet získaných bodů';
$string['postprocesserror'] = 'Došlo k chybě po zpracování!';
$string['postsuccess'] = 'Údaje byly úspěšně odeslány';
$string['practice'] = 'Cvičná přednáška';
$string['practice_help'] = '<p>Cvičná přednáška nebude započítána do známek kurzu (neobjeví se na stránce
Známky).</p>';
$string['preprocesserror'] = 'Došlo k chybě při předzpracování!';
$string['prerequisiteisobsolete'] = 'Volba Požadované předpoklady přednášky je odstraněna. Místo toho použijte prosím omezení přístupu.';
$string['prerequisitelesson'] = 'Požadované předpoklady pro zpřístupnění';
$string['preview'] = 'Náhled';
$string['previewlesson'] = 'Náhled: {$a}';
$string['previewpagenamed'] = 'Náhled stránky: {$a}';
$string['previouspage'] = 'Předchozí stránka';
$string['privacy:metadata:attempts'] = 'Záznam pokusů na stránce';
$string['privacy:metadata:attempts:answerid'] = 'ID odpovědi';
$string['privacy:metadata:attempts:correct'] = 'Zda byl pokus správný';
$string['privacy:metadata:attempts:pageid'] = 'ID stránky';
$string['privacy:metadata:attempts:retry'] = 'Číslo pokusu';
$string['privacy:metadata:attempts:timeseen'] = 'Čas provedení pokusu';
$string['privacy:metadata:attempts:useranswer'] = 'Podrobnosti o odpovědi uživatele';
$string['privacy:metadata:attempts:userid'] = 'ID uživatele';
$string['privacy:metadata:branch'] = 'Záznam zobrazených stránek';
$string['privacy:metadata:branch:flag'] = 'Zda byla další stránka vypočtena náhodně';
$string['privacy:metadata:branch:nextpageid'] = 'ID další stránky';
$string['privacy:metadata:branch:pageid'] = 'ID stránky';
$string['privacy:metadata:branch:retry'] = 'Číslo pokusu';
$string['privacy:metadata:branch:timeseen'] = 'Čas, kdy byla stránka zobrazena';
$string['privacy:metadata:branch:userid'] = 'ID uživatele';
$string['privacy:metadata:grades'] = 'Záznam o známkách pro každou přednášku';
$string['privacy:metadata:grades:completed'] = 'Datum, kdy byla známka udělena';
$string['privacy:metadata:grades:grade'] = 'Udělená známka';
$string['privacy:metadata:grades:userid'] = 'ID uživatele';
$string['privacy:metadata:overrides'] = 'Záznam přepsání v přednášce';
$string['privacy:metadata:overrides:available'] = 'Čas, od kdy mohou studenti začít pokusy v přednášce';
$string['privacy:metadata:overrides:deadline'] = 'Termín dokončení přednášky.';
$string['privacy:metadata:overrides:maxattempts'] = 'Maximální počet pokusů';
$string['privacy:metadata:overrides:password'] = 'Heslo pro přístup k přednášce';
$string['privacy:metadata:overrides:retake'] = 'Zda je povoleno opakování';
$string['privacy:metadata:overrides:review'] = 'Zda je povoleno, aby se otázka opakovala';
$string['privacy:metadata:overrides:timelimit'] = 'Časový limit pro dokončení přednášky v sekundách.';
$string['privacy:metadata:overrides:userid'] = 'ID uživatele';
$string['privacy:metadata:timer'] = 'Záznam pokusu v přednášce';
$string['privacy:metadata:timer:completed'] = 'Zda je pokus dokončen';
$string['privacy:metadata:timer:lessontime'] = 'Poslední okamžik, kdy jsme zaznamenali činnost';
$string['privacy:metadata:timer:starttime'] = 'Datum, kdy byl pokus zahájen';
$string['privacy:metadata:timer:timemodifiedoffline'] = 'Poslední okamžik, kdy jsme zaznamenali aktivitu z mobilní aplikace';
$string['privacy:metadata:timer:userid'] = 'ID uživatele';
$string['privacy:metadata:userpref:lessonview'] = 'Preferovaný režim zobrazení při editaci přednášky';
$string['privacy:path:essayresponses'] = 'Odpovědi na otázku tvořené odpovědi';
$string['privacy:path:pages'] = 'Stránky';
$string['processerror'] = 'Došlo k chybě při zpracování!';
$string['progressbar'] = 'Zobrazit ukazatel průchodu';
$string['progressbar_help'] = 'Zobrazí ukazatel průchodu v dolní části stránek přednášky. Student uvidí procentuální hodnotu, která ho informuje o tom, jak daleko se již v přednášce dostal.

Mezi dokončené části přednášky se započítávají rozcestníky a stránky s otázkou, na kterou student odpověděl správně. Do celkového počtu stránek v přednášce se započítávají seskupení a stránky v rámci seskupení pouze jako jedna stránka, stránky "konec seskupení" a "konec větve" se nezapočítávají vůbec. Všechny ostatní stránky jsou do celkového počtu stránek přednášky započítány.';
$string['progressbarteacherwarning'] = 'Ukazatel průchodu přednáškou se nezobrazuje  {$a}';
$string['progressbarteacherwarning2'] = 'Ukazatel průchodu se zobrazuje pouze studentům. Chcete-li si jej ověřit, přihlaste se jako student.';
$string['progresscompleted'] = 'Dokončili jste {$a} % přednášky';
$string['qtype'] = 'Typ stránky';
$string['question'] = 'Otázka';
$string['questionoption'] = 'Rozšířené nastavení otázky';
$string['questiontype'] = 'Typ otázky';
$string['randombranch'] = 'Náhodná stránka z větve';
$string['randompageinbranch'] = 'Náhodná otázka v rámci stránky';
$string['rank'] = 'Pořadí';
$string['rawgrade'] = 'Hrubá známka';
$string['receivedcredit'] = 'Odpověď započtena jako správná';
$string['redisplaypage'] = 'Obnovit stránku';
$string['removeallgroupoverrides'] = 'Odstranit všechna přenastavení skupiny';
$string['removealluseroverrides'] = 'Odstranit všechna přenastavení uživatelů';
$string['report'] = 'Zpráva';
$string['reports'] = 'Výsledky';
$string['response'] = 'Reakce';
$string['retakesallowed'] = 'Je povolen opakovaný pokus';
$string['retakesallowed_help'] = 'Toto nastavení určuje, zda student může projít přednášku víckrát než jednou. Zvolíte-li možnost "Ano", student bude moci přednášku procházet opakovaně, včetně odpovídání na otázky. Na stránce Známky se pak zobrazí buď průměrná známka ze všech průchodů přednáškou, nebo známka za nejlepší průchod přednáškou (podle toho, jak učitel nastaví ve Zpracování opakovaného průchodu).

Učitel může usoudit, že přednáška obsahuje materiály, které by měli studenti prostudovat obzvláště pečlivě. V tom případě povolí opakované procházení přednášky. Pokud má přednáška naopak spíše povahu zkoušky, opětovné procházení by nemělo být povoleno.';
$string['returnto'] = 'Návrat na {$a}';
$string['returntocourse'] = 'Zpět do kurzu';
$string['reverttodefaults'] = 'Vrátit se k výchozímu nastavení přednášky';
$string['review'] = 'Revize';
$string['reviewlesson'] = 'Revize přednášky';
$string['reviewquestionback'] = 'Ano, chci to zkusit ještě jednou';
$string['reviewquestioncontinue'] = 'Ne, chci pokračovat dál';
$string['sanitycheckfailed'] = 'Selhala kontrola: Tento pokus byl odstraněn';
$string['save'] = 'Uložit';
$string['savechanges'] = 'Uložit změny';
$string['savechangesandeol'] = 'Ulož všechny změny a jdi na konec přednášky.';
$string['saveoverrideandstay'] = 'Uložit a zadat další přenastavení';
$string['savepage'] = 'Uložit stránku';
$string['score'] = 'Bodový zisk';
$string['score_help'] = 'Skóre se používá pouze tehdy, když je aktivováno vlastní bodování. Každá odpověď pak může mít číselnou bodovou hodnotu (kladnou nebo zápornou).';
$string['scores'] = 'Známky';
$string['search:activity'] = 'Přednáška - informace';
$string['secondpluswrong'] = 'Tato odpověď není správná. Chcete to zkusit ještě jednou?';
$string['selectaqtype'] = 'Vyberte typ otázky';
$string['sent'] = 'Odesláno';
$string['shortanswer'] = 'Krátká tvořená odpověď';
$string['showanunansweredpage'] = 'Ukázat nezodpovězenou stránku';
$string['showanunseenpage'] = 'Ukázat neprohlédnutou stránku';
$string['singleanswer'] = 'Jediná odpověď';
$string['skip'] = 'Přeskočit navigaci';
$string['slideshow'] = 'Prezentace';
$string['slideshow_help'] = '<p>Toto nastavení umožňuje zobrazit přednášku jako prezentaci se stanovenou
šířkou, výškou a volitelnou barvou plátna. Jestliže obsah stránky překročí
stanovenou šířku nebo výšku plátna, zobrazí se na okraji plátna posuvník, jehož
vzhled je definován pomocí kaskádových stylů CSS. Otázky z prezentace
\'vybočují\', ve výchozím nastavení se na plátně zobrazují pouze stránky a
rozcestníky. Na plátně se vpravo a vlevo zobrazí tlačítka označená "Další" a
"Předcházející", pokud si tuto možnost zvolíte. Další tlačítka se zobrazují
uprostřed pod plátnem.</p>';
$string['slideshowbgcolor'] = 'Barva plátna';
$string['slideshowheight'] = 'Výška plátna';
$string['slideshowwidth'] = 'Šířka plátna';
$string['startlesson'] = 'Začít přednášku';
$string['studentattemptlesson'] = '{$a->firstname} {$a->lastname} – pokus číslo {$a->attempt}';
$string['studentname'] = '{$a} – jméno';
$string['studentoneminwarning'] = 'Varování: Máte méně než jednu minutu na dokončení přednášky.';
$string['studentoutoftimeforreview'] = 'Upozornění: Této přednášce jste věnovali méně času';
$string['studentresponse'] = 'Odpověď studenta {$a}';
$string['submit'] = 'Odeslat';
$string['submitname'] = 'Odeslat přezdívku';
$string['teacherjumpwarning'] = 'Tato přednáška obsahuje skok typu "{$a->cluster}" nebo "{$a->unseen}". Namísto něj bude použit skok na další stránku. Přihlaste se jako student a zkontrolujte tyto skoky.';
$string['teacherongoingwarning'] = 'Průběžný bodový zisk se zobrazuje pouze studentům. Chcete-li si jej ověřit, přihlaste se jako student.';
$string['teachertimerwarning'] = 'Stopky fungují pouze studentům. Chcete-li si je vyzkoušet, přihlaste se jako student.';
$string['thatsthecorrectanswer'] = 'Tato odpověď je správná.';
$string['thatsthewronganswer'] = 'Tato odpověď není správná.';
$string['thefollowingpagesjumptothispage'] = 'Následující stránky směřují na tuto stránku';
$string['thispage'] = 'Tato stránka';
$string['timeisup'] = 'Konec';
$string['timelimit'] = 'Časový limit';
$string['timelimit_help'] = 'Je-li povoleno, je zobrazen na začátku přednášky časový limit a  je odpočítáván zbývající čas. Odpovědi odevzdané po limitu nejsou hodnoceny.';
$string['timelimitwarning'] = 'Přednášku musíte dokončit za {$a} .';
$string['timeremaining'] = 'Zbývající čas';
$string['timespenterror'] = 'Strávit procházením přednášky více než {$a} minut';
$string['timespentminutes'] = 'Strávený čas (v min.)';
$string['timetaken'] = 'Doba průchodu';
$string['totalpagesviewedheader'] = 'Počet zobrazených stránek';
$string['true'] = 'Pravda';
$string['truefalse'] = 'Pravda / Nepravda';
$string['unabledtosavefile'] = 'Nahraný soubor nelze uložit';
$string['unknownqtypesnotimported'] = '{$a} úloh nepodporovaného typu nebylo naimportováno';
$string['unseenpageinbranch'] = 'Nezobrazená otázka v rámci stránky';
$string['unsupportedqtype'] = 'Nepodporovaný typ otázky ({$a})!';
$string['updatedpage'] = 'Stránka aktualizována';
$string['updatefailed'] = 'Aktualizace selhala';
$string['updatepagenamed'] = 'Aktualizace stránky: {$a}';
$string['usemaximum'] = 'Nejlepší pokus';
$string['usemean'] = 'Průměr ze všech pokusů';
$string['usepassword'] = 'Přednáška chráněná heslem';
$string['usepassword_help'] = '<p>Toto nastavení umožní studentům přístup k přednášce pouze v případě, že
zadají heslo.</p>';
$string['useroverrides'] = 'Uživatelské přenastavení';
$string['useroverridesdeleted'] = 'Přenastavení uživatele odstraněno';
$string['usersnone'] = 'K této přednášce nemá přístup žádný student.';
$string['viewessayanswers'] = 'Zobrazit  tvořenou odpověď';
$string['viewgrades'] = 'Zobrazit známky';
$string['viewreports'] = 'Zobrazit {$a->attempts} dokončených pokusů';
$string['viewreports2'] = 'Zobrazit {$a} dokončených pokusů';
$string['warning'] = 'Varování';
$string['welldone'] = 'Výborně!';
$string['whatdofirst'] = 'Co chcete udělat nejdříve?';
$string['wronganswerjump'] = 'Skok při nesprávné odpovědi';
$string['wronganswerscore'] = 'Bodový zisk za nesprávnou odpověď';
$string['wrongresponse'] = 'Reakce při nesprávné odpovědi';
$string['xattempts'] = 'Počet pokusů: {$a}';
$string['youhaveseen'] = 'Některé ze stránek této přednášky jste již viděli.<br />Chcete začít na poslední stránce, kterou jste navštívili?';
$string['youranswer'] = 'Vaše odpověď';
$string['yourcurrentgradeis'] = 'Stávající známka: {$a}';
$string['yourcurrentgradeisoutof'] = 'Vaše známka nyní je {$a->grade} z možných {$a->total}';
$string['youshouldview'] = 'Měli byste zodpovědět nejméně {$a} otázek.';
