<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'format_tiles', language 'de', version '3.5'.
 *
 * @package     format_tiles
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addsections'] = 'Kachel hinzufügen';
$string['admintools'] = 'Administratortools';
$string['all'] = 'Alle';
$string['allcomplete'] = 'Alle erledigt';
$string['allcoursescomplypalette'] = 'Alle Kurse haben bereits passende Kachelfarben. Es gibt nichts zurückzusetzen. Speichern Sie alle Änderungen zu den erlaubten Farben, bevor Sie zurücksetzen klicken.';
$string['allowlabelconversion'] = 'Umwandlung von Textfeldern in Textseiten (experimentell)';
$string['allowlabelconversion_desc'] = 'Wenn aktiviert, wird Trainer/innen in den Einstellungen zu jedem Textfeld ein Menü angeboten, um das Textfeld in eine Textseite zu konvertieren. Dies ist eine experimentelle Einstellung.';
$string['allowphototiles'] = 'Fotokacheln erlauben';
$string['allowphototiles_desc'] = 'Wenn diese Option ausgewählt ist, können Trainer/innen ein Foto hochladen, das als Kachelhintergrund dient. Im selben Kurs können sie auch weiterhin Standard-Kachelsymbole verwenden. (Wenn nicht ausgewählt, sind nur Kachelsymbole zulässig, und andere Einstellungen für Fotokacheln unten werden ignoriert.)';
$string['allowsubtilesview'] = 'Ansicht von Unterkacheln zulassen';
$string['allowsubtilesview_desc'] = 'Erlaubt das Verwenden einer Kurseinstellung, die, wenn sie ausgewählt ist, innerhalb einer Kachel Aktivitäten (außer Labels) als Unterkacheln anstelle der Standardliste anzeigt';
$string['alternativelink'] = 'Alternativer Link';
$string['asfraction'] = 'Als Balken anzeigen';
$string['aspectratiotootallorwide'] = 'Das hochgeladene Bild wurde gespeichert, aber es könnte <strong>{$a->tallorwide}</strong> sein. Wenn es nicht richtig aussieht, sollten Sie schneiden Sie es auf die Standardgröße (z.B. 200 x 300) zuschneiden und es erneut hochladen.';
$string['aspercentagedial'] = 'Mit % im Kreis anzeigen';
$string['assumedatastoreconsent'] = 'Automatische Zustimmung zur lokalen Datenspeicherung';
$string['assumedatastoreconsent_desc'] = 'Wenn diese Option ausgewählt ist, wird die Zustimmung zur lokalen Datenspeicherung im Browser automatisch gegeben. Den Nutzer/innen  wird <b>kein Dialog</b> angezeigt, in dem um eine Zustimmung zur Datenspeicherung gebeten wird.';
$string['basecolour'] = 'Kachelfarbe';
$string['basecolour_help'] = 'Die hier festgelegte Farbe wird für alle Kacheln im Kurs angewendet. Die verfügbaren Farben werden von Ihrem Administrator in den Einstellungen des Kachelformats festgelegt.';
$string['blockedpopup'] = 'Ihr Browser hat ein Popup-Fenster blockiert. Erlauben Sie bitte Popups für diese Website, oder klicken Sie auf den untenstehenden Link, um die Website in diesem Fenster zu öffnen.';
$string['blockedpopuptitle'] = 'Blockiertes Popup-Fenster';
$string['brandcolour'] = 'Markenfarbe';
$string['browserstorage'] = 'Browserspeicher';
$string['changedcolour'] = 'Kachelfarbe, die im Kurs zurückzusetzen ist {$a}';
$string['clickiffailstoload'] = 'Klicken, falls die Seite nicht lädt';
$string['close'] = 'Schließen';
$string['collapse'] = 'Abschnitt einklappen';
$string['collapsesections'] = 'Alles einklappen';
$string['colourblue'] = 'Blau';
$string['colourdarkgreen'] = 'Dunkelgrün';
$string['colourgreen'] = 'Grün';
$string['colourlightblue'] = 'Hellblau';
$string['colourname_descr'] = 'Anzeigename für die Farbe. Farbnamen werden normalerweise nicht von Nutzer/innen gesehen - sie sehen stattdessen ein farbiges Feld.';
$string['colournamegeneral'] = 'Anzeigename für die obige Farbe';
$string['colourpurple'] = 'Violett';
$string['colourred'] = 'Rot';
$string['colours'] = 'Farben';
$string['complete'] = 'abgeschlossen';
$string['complete-n-auto'] = 'Element nicht abgeschlossen. Es wird als abgeschlossen markiert, wenn Sie die Abschlusskriterien erfüllen. Sie können dies nicht manuell ändern.';
$string['complete-y-auto'] = 'Element abgeschlossen. Es wurde als abgeschlossen markiert, da Sie die Abschlusskriterien erfüllt haben. Sie können dies nicht manuell ändern.';
$string['completion_help'] = 'Ein Häkchen rechts neben einer Aktivität kann verwendet werden, um anzuzeigen, dass die Aktivität abgeschlossen ist (ein leerer Kreis wird angezeigt, wenn nicht).
Je nach Einstellung kann automatisch ein Häkchen erscheinen, wenn die Voraussetzungen für den Abschlussbedingung erfüllt sind.
In anderen Fällen können Sie auf den leeren Kreis klicken, wenn Sie denken, dass Sie die Aktivität abgeschlossen haben. Im Anschluss wird ein durchgehendes grünen Häkchen angezeigt. (Ein erneuter Klick entfernt das Häkchen wieder)';
$string['completionswitchhelp'] = '<p>Sie haben ausgewählt, dass die Fertigstellung auf jeder Kachel angezeigt wird. Daher wurde weiter unten die <i>Abschlussverfolgung</i> aktiviert.</p>
<p>Zusätzlich müssen Sie bei <b>jeder</b> zu verfolgenden Aktivität die Abschlussverfolgung konfigurieren, z.B. bei einer PDF-Datei, auf "Einstellungen bearbeiten" klicken, und unter Aktivitätsabschluss die gewünschte Einstellung vornehmen.</p>
<p>Sie können dies auch in einer <b>Stapelverarbeitung</b> tun. Details hierzu unter <a href="https://docs.moodle.org/de/Einstellungen_zum_Aktivit%C3%A4tsabschluss" target="_blank">docs.moodle.org</a></p>';
$string['completionwarning'] = 'Sie haben die Abschlussverfolgung auf Kursebene eingeschaltet, aber auf der Ebene der einzelnen Aktivitäten haben keine Elemente die Abschlussverfolgung aktiviert, so dass es nichts zu verfolgen gibt.';
$string['completionwarning_changeinbulk'] = 'Bulk-Veränderung';
$string['completionwarning_help'] = 'Sie müssen die Aktivitäten (unter Aktivitätsabschluss - Abschlussverfolgung) einzeln konfigurieren oder Sie können dies für mehrere unter Kurseinstellungen - Kursabschluss -  Bulk-Bearbeitung von Aktivitätsabschlüssen tun';
$string['contact'] = 'Kontakt';
$string['contactdeveloper'] = 'Entwickler/in kontaktieren';
$string['contents'] = 'Inhalte';
$string['converttopage'] = 'In Seite umwandeln';
$string['converttopage_confirm'] = 'Sind Sie sicher?.... Dies kann nicht rückgängig gemacht werden (Sie müssten das Label bei Bedarf manuell neu erstellen).';
$string['courseshowtileprogress'] = 'Fortschrittsanzeige auf jeder Kachel';
$string['courseshowtileprogress_error'] = 'Sie haben \'Aktivitätsabschluss > Abschlussverfolgung\' auf \'Nein\' gesetzt (siehe weiter unten auf dieser Seite), was mit dieser Einstellung nicht übereinstimmt. Wenn Sie den Fortschritt der Kacheln anzeigen möchten, stellen Sie bitte \'Aktivitätsabschluss > Abschlussverfolgung\' auf \'Ja\'. Andernfalls verwenden Sie für diese Einstellung \'Nein\'.';
$string['courseshowtileprogress_help'] = '<p>Wenn ausgewählt, wird der Teilnehmerfortschritt mit den Aktivitäten in jeder Kachel angezeigt, entweder als <em>Fraktion</em> (z.B. \'Fortschritt 2/10\' bedeutet 2 von 10 abgeschlossenen Aktivitäten) oder als <em>Prozentsatz</em> in einem Kreis.</p><p>Dies kann nur verwendet werden, wenn  \'Aktivitätsabschluss - Abschlussverfolgung\' eingeschaltet ist.</p><p>Wenn es keine Aktivitätsabschlüsse innerhalb einer bestimmten Kachel gibt, wird der Indikator für diese Kachel nicht angezeigt.</p>';
$string['courseusebarforheadings'] = 'Hervorheben von Überschriften durch farbige Registerkarte';
$string['courseusebarforheadings_help'] = 'Eine farbige Registerkarte links neben der Überschrift im Kurs anzeigen, wenn ein Überschriftsstil im Texteditor ausgewählt ist';
$string['courseusesubtiles'] = 'Unterkacheln für Aktivitäten verwenden';
$string['courseusesubtiles_help'] = 'Zeigen Sie innerhalb jeder Kachel jede Aktivität als Unterkachel an, anstatt als Liste der Aktivitäten unten auf der Seite. Dies gilt nicht für Labels, die nicht als Unterkacheln angezeigt werden und somit als Überschriften zwischen den Kacheln verwendet werden können.';
$string['currentsection'] = 'Diese Kachel';
$string['customcss'] = 'Angepasstes CSS';
$string['customcssdesc'] = 'Angepasstes CSS, dass auf der Kursseite mit diesem Kursformat verwendet wird. Das CSS wird nicht überprüft. Achten Sie deswegen darauf, gültigen Code einzugeben, z.B.: <p>.section { color: red; }</p><p>li.activity.subtile.resource.pdf { background-color: orange !important; }</p>';
$string['datapref'] = 'Datenpräferenz';
$string['datapreferror'] = 'Die Datenpräferenz-Funktion ist nur verfügbar, wenn Sie JavaScript in Ihrem Browser verfügbar haben. Andernfalls kann die Datenspeicherung nicht aktiviert werden.';
$string['dataprefquestion'] = '<p>Um die Nutzung dieser Seite zu erleichtern, werden funktionale Informationen in Ihrem Browser, wie z.B. den Inhalt der zuletzt geöffneten Kachel gespeichert. Diese bleiben für kurze Zeit auf Ihrem Computer, und werden verwendet, wenn Sie diese Seite erneut besuchen. Die Informationen werden nicht zur Verfolgung verwendet. Ist das okay?</p><p>Wenn Sie den Browser-Cache / die History löschen, werden auch diese Informationen gelöscht.  Wenn Sie "Nein" auswählen, kann dies zu einer Verlangsamung der Darstellung führen.</p>';
$string['defaultthiscourse'] = 'Standard für diesen Kurs';
$string['defaulttilecolour'] = 'Standardfarbe für Kacheln';
$string['defaulttileicon'] = 'Kachel-Symbol';
$string['defaulttileicon_help'] = 'Das ausgewählte Symbol erscheint in diesem Kurs auf <em>allen</em> Kacheln. Einzelne Kacheln können anschließend in den Kacheleinstellungen mit einem anderen Symbol versehen werden.';
$string['deleteimage'] = 'Bild löschen';
$string['deletesection'] = 'Kachel löschen';
$string['developedby'] = '"Kachelformat", entwickelt von {$a}';
$string['developer'] = 'Entwickler/in';
$string['disabledbyadmin'] = 'Von Administrator/in deaktiviert';
$string['displayfilterbar'] = 'Filterleiste';
$string['displayfilterbar_error'] = 'Wenn Sie keine Ergebnisse für diesen Kurs eingerichtet haben, können Sie eine Filterleiste nur nach Kachelnummern und nicht nach Ergebnissen anzeigen. Erstellen Sie zuerst einige Ergebnisse, dann kommen Sie hierher zurück. Siehe';
$string['displayfilterbar_help'] = '<p>Wenn ausgewählt, wird automatisch eine Reihe von Schaltflächen vor dem Kacheln im Kurs angezeigt. Diese können Nutzer/innen anklicken, um Kacheln zu filtern </p><p>Wurde \'basierend auf Kachelnummern\' ausgewählt, wird eine Reihe von Schaltflächen angezeigt, z.B. eine Schaltfläche für Kacheln 1-4, eine Schaltfläche für Kacheln 5-8 usw. </p><p>Wurde \'basierend auf Kursergebnissen\' ausgewählt, gibt es eine Schaltfläche pro Kursergebnis. Jede Kachel kann auf der Einstellungsseite der jeweiligen Kachel einem bestimmten Ergebnis (und damit einer bestimmten Schaltfläche) zugeordnet werden.</p>';
$string['displaytitle_mod_doc'] = 'Word-Dokument';
$string['displaytitle_mod_html'] = 'Website';
$string['displaytitle_mod_jpeg'] = 'Bild';
$string['displaytitle_mod_mp3'] = 'Audio';
$string['displaytitle_mod_mp4'] = 'Video';
$string['displaytitle_mod_pdf'] = 'PDF';
$string['displaytitle_mod_ppt'] = 'PowerPoint-Präsentation';
$string['displaytitle_mod_txt'] = 'Text';
$string['displaytitle_mod_xls'] = 'Tabellenkalkulation';
$string['displaytitle_mod_zip'] = 'Zip-Datei';
$string['documentation'] = 'Dokumentation';
$string['documentationurl'] = 'Link zur Dokumentation';
$string['documentationurl_descr'] = 'Link zur Dokumentation des Kachelformats';
$string['download'] = 'Download';
$string['editsectionname'] = 'Kachelname bearbeiten';
$string['embeddedurlerror'] = 'Falls die externe Website nicht erreichbar ist, verwenden Sie diesen Link:';
$string['entersection'] = 'Zugang zum Abschnitt';
$string['existingimage'] = 'Existierendes Bild für diese Kachel';
$string['expand'] = 'Aufklappen';
$string['expandall'] = 'Alles aufklappen';
$string['expandsections'] = 'Alle Aktivitäten anzeigen (alle Abschnitte)';
$string['experimentalsetting'] = '(experimentelle Einstellungen)';
$string['fileaddedtobottom'] = 'Datei am Abschnittsende hinzugefügt';
$string['filenoshowtext'] = 'Wenn die Datei hier nicht angezeigt wird, verwenden Sie bitte die Schaltflächen auf der rechten Seite zum Herunterladen oder Anzeigen in einem neuen Fenster';
$string['filterboth'] = 'Schaltflächen basierend auf Kachelnummern und Kursergebnissen anzeigen';
$string['filternumbers'] = 'Schaltflächen basierend auf Kachelnummern anzeigen';
$string['filteroutcomes'] = 'Schaltflächen basierend auf den Kursergebnissen anzeigen';
$string['filteroutcomesrestore'] = 'Der ursprüngliche Kurs verwendete Ergebnisse in der Filterleiste, die während des Wiederherstellungsprozesses noch nicht unterstützt werden. Die Einstellung der Filterleiste wurde daher im wiederhergestellten Verlauf geändert. Wenn Sie Ergebnisse verwenden möchten, um Kacheln im wiederhergestellten Kurs zu filtern, richten Sie die Ergebnisse bitte erneut ein. Der ursprüngliche Kurs wurde nicht geändert.';
$string['fittilestowidth'] = 'Kacheln an die Bildschirmbreite anpassen';
$string['fittilestowidth_desc'] = 'Wenn diese Option aktiviert ist und mit einem nicht mobilen Gerät zugegriffen wird, verzögern Kacheln das Laden, während eine Berechnung des besten Layouts durchgeführt wird. Z.B. Vermeiden Sie eine Kachel pro Reihe und zentrieren Sie die Kacheln auf dem Bildschirm. Dies geschieht nur, wenn sie den Kurs zum ersten Mal in einer bestimmten Sitzung betreten, und wird dann für die Sitzung oder bis zur Anpassung der Bildschirmgröße gespeichert.';
$string['folderdisplayerror'] = 'Verzeichnisse, die so eingestellt sind, dass sie Inhalte inline anzeigen, sind nicht mit dem Unterkachel-Format kompatibel. Dieses <a href="{$a}">Verzeichnis</a> wurde daher geändert, um auf einer separaten Seite angezeigt zu werden';
$string['followthemecolour'] = 'Erzwingen der folgenden Themenfarbe';
$string['followthemecolour_desc'] = 'Wenn auf Ja gesetzt, können Trainer/innen nicht die Kachelfarben auswählen. Stattdessen wird versucht, die Hauptmarkenfarbe des Theme beizuhalten und diese stattdessen zu verwenden';
$string['guidance'] = 'Orientierungshilfe';
$string['height'] = 'Höhe';
$string['hidden'] = 'Verborgen';
$string['hide'] = 'Verbergen';
$string['hidefromothers'] = 'Kachel verbergen';
$string['highlightoff'] = 'Hervorheben entfernen';
$string['home'] = 'Kursbeginn';
$string['hovercolour'] = 'Kachelfarbe für Hover-Effekt';
$string['hovercolour_descr'] = 'Farbe, mit der Kacheln beim Überfahren mit der Maus angezeigt werden.';
$string['icontitle-address-book-o'] = 'Adressbuch';
$string['icontitle-assessment_graded'] = 'Bewertung A+';
$string['icontitle-assessment_timer'] = 'Bewertungszeitgeber';
$string['icontitle-asterisk'] = 'Sternchen';
$string['icontitle-award-solid'] = 'Auszeichnung';
$string['icontitle-balance-scale'] = 'Waage';
$string['icontitle-bar-chart'] = 'Balkendiagramm';
$string['icontitle-bell-o'] = 'Glocke';
$string['icontitle-binoculars'] = 'Fernglas';
$string['icontitle-bitcoin'] = 'Bitcoin';
$string['icontitle-book'] = 'Buch';
$string['icontitle-bookmark-o'] = 'Lesezeichen';
$string['icontitle-briefcase'] = 'Aktentasche';
$string['icontitle-building'] = 'Gebäude';
$string['icontitle-bullhorn'] = 'Megaphon';
$string['icontitle-bullseye'] = 'Zielscheibe';
$string['icontitle-calculator'] = 'Rechner';
$string['icontitle-calendar'] = 'Kalender';
$string['icontitle-calendar-check-o'] = 'Kalender mit Haken';
$string['icontitle-check'] = 'Haken';
$string['icontitle-child'] = 'Kind';
$string['icontitle-clock-o'] = 'Uhr';
$string['icontitle-clone'] = 'Kopie';
$string['icontitle-cloud-download'] = 'Cloud (herunterladen)';
$string['icontitle-cloud-upload'] = 'Cloud (hochladen)';
$string['icontitle-comment-o'] = 'Kommentar';
$string['icontitle-comments-o'] = 'Kommentare';
$string['icontitle-compass'] = 'Kompass';
$string['icontitle-diamond'] = 'Diamant';
$string['icontitle-dollar'] = 'Dollar';
$string['icontitle-euro'] = 'Euro';
$string['icontitle-exclamation-triangle'] = 'Ausrufezeichen im Dreieck';
$string['icontitle-feed'] = 'Feed';
$string['icontitle-file-text-o'] = 'Textdatei';
$string['icontitle-film'] = 'Film';
$string['icontitle-flag-checkered'] = 'Markierung (kariert)';
$string['icontitle-flag-o'] = 'Markierung';
$string['icontitle-flash'] = 'Blitzlicht';
$string['icontitle-flask'] = 'Kolben';
$string['icontitle-flipchart'] = 'Präsentation';
$string['icontitle-frown-o'] = 'Traurig';
$string['icontitle-gavel'] = 'Hammer';
$string['icontitle-gbp'] = 'Britisches Pfund';
$string['icontitle-globe'] = 'Globus';
$string['icontitle-handshake-o'] = 'Handschlag';
$string['icontitle-headphones'] = 'Kopfhörer';
$string['icontitle-heartbeat'] = 'Herzschlag';
$string['icontitle-history'] = 'Verlaufsuhr';
$string['icontitle-home'] = 'Zuhause';
$string['icontitle-id-card-o'] = 'Personalausweis';
$string['icontitle-info'] = 'Info';
$string['icontitle-jigsaw'] = 'Puzzle';
$string['icontitle-key'] = 'Schlüssel';
$string['icontitle-laptop'] = 'Laptop';
$string['icontitle-life-buoy'] = 'Rettungsring';
$string['icontitle-lightbulb-o'] = 'Leuchtmittel';
$string['icontitle-line-chart'] = 'Liniendiagramm';
$string['icontitle-list'] = 'Liste (Aufzählungspunkte)';
$string['icontitle-list-ol'] = 'Liste (nummeriert)';
$string['icontitle-location-arrow'] = 'Positionspfeil';
$string['icontitle-map-marker'] = 'Kartenmarkierung';
$string['icontitle-map-o'] = 'Karte';
$string['icontitle-map-signs'] = 'Wegweiser';
$string['icontitle-microphone'] = 'Mikrofon';
$string['icontitle-mobile-phone'] = 'Smartphone';
$string['icontitle-mortar-board'] = 'Hut';
$string['icontitle-music'] = 'Musik';
$string['icontitle-newspaper-o'] = 'Zeitung';
$string['icontitle-number_1'] = 'Nummer 1';
$string['icontitle-number_10'] = 'Nummer 10';
$string['icontitle-number_2'] = 'Nummer 2';
$string['icontitle-number_3'] = 'Nummer 3';
$string['icontitle-number_4'] = 'Nummer 4';
$string['icontitle-number_5'] = 'Nummer 5';
$string['icontitle-number_6'] = 'Nummer 6';
$string['icontitle-number_7'] = 'Nummer 7';
$string['icontitle-number_8'] = 'Nummer 8';
$string['icontitle-number_9'] = 'Nummer 9';
$string['icontitle-pencil-square-o'] = 'Bleistift im Quadrat';
$string['icontitle-person'] = 'Person';
$string['icontitle-pie-chart'] = 'Kreisdiagramm';
$string['icontitle-podcast'] = 'Podcast';
$string['icontitle-puzzle-piece'] = 'Puzzleteil';
$string['icontitle-question-circle'] = 'Fragezeichen im Kreis';
$string['icontitle-random'] = 'Zufällig';
$string['icontitle-refresh'] = 'Aktualisieren';
$string['icontitle-road'] = 'Straße';
$string['icontitle-search'] = 'Lupe';
$string['icontitle-sliders'] = 'Schieberegler';
$string['icontitle-smile-o'] = 'Lächeln';
$string['icontitle-star'] = 'Stern (gefült)';
$string['icontitle-star-half-o'] = 'Stern (halb gefüllt)';
$string['icontitle-star-o'] = 'Stern (nicht gefüllt)';
$string['icontitle-survey'] = 'Umfrage';
$string['icontitle-tags'] = 'Tags';
$string['icontitle-tasks'] = 'Aufgaben';
$string['icontitle-television'] = 'Monitor';
$string['icontitle-thinking-person'] = 'Person mit Leuchtmittel';
$string['icontitle-thumbs-o-down'] = 'Daumen nach unten';
$string['icontitle-thumbs-o-up'] = 'Daumen nach oben';
$string['icontitle-trophy'] = 'Trophäe';
$string['icontitle-umbrella'] = 'Regenschirm';
$string['icontitle-university'] = 'Universität';
$string['icontitle-user-o'] = 'Person (ungefüllt)';
$string['icontitle-users'] = 'Personen';
$string['icontitle-volume-up'] = 'Lautsprecher';
$string['icontitle-wrench'] = 'Schraubenschlüssel';
$string['imagecannotbeused'] = 'Bild kann nicht verwendet werden';
$string['imagedeletedfrom'] = 'Bild gelöscht von "{$a}"';
$string['imagesavedfor'] = 'Bild gesichert für Kachel "{$a}"';
$string['imagesize'] = 'Bildgröße';
$string['items'] = 'Elemente';
$string['jsactivate'] = 'Animierte Navigation an';
$string['jsdeactivate'] = 'Animierte Navigation aus';
$string['jsdeactivated'] = 'Sie haben die animierte Navigation in Ihrem Konto deaktiviert';
$string['jsmaxstoreditems'] = 'Maximale Inhaltselemente im Browser-Sitzungsspeicher';
$string['jsmaxstoreditems_desc'] = 'Wenn Nutzer/innen auf dem Hauptkachelbildschirm (Kurs) navigieren, speichert der Browser das HTML für diese Seite und den Inhalt jeder Kachel bis zur maximalen Anzahl der hier ausgewählten Elemente. Dies ermöglicht eine sehr schnelle Reaktion, wenn auf eine neue Kachel geklickt wird. Eine zu hohe Einstellung kann dazu führen, dass die Browser-Speicher nicht ausreicht (obwohl dies im Test bisher kein Problem war)';
$string['jsnavsettings'] = 'Navigation';
$string['jsreactivated'] = 'Sie haben die animierte Navigation in Ihrem Konto aktiviert. Dies kann zu einer schnelleren Verwendung führen. Es muss JavaScript aktiviert sein.';
$string['jsstoredcontentdeletemins'] = 'Löschen von Inhalten, die in der Sitzung gespeichert sind, nach (Minuten)';
$string['jsstoredcontentdeletemins_desc'] = 'Um Platz für das aktuelle HTML frei zu halten, führt der Browser nach jedem Klick eine Bereinigung durch und <em>löscht</em> alle gespeicherten Inhalte aus dem Sitzungsspeicher, die älter sind als dieser Wert (basierend darauf, dass sie nicht mehr zuverlässig sind und dass sowieso eine neue Kopie vom Server benötigt wird).';
$string['jsstoredcontentexpirysecs'] = 'Der gespeicherte Inhalt der Sitzung verfällt nach (Sekunden).';
$string['jsstoredcontentexpirysecs_desc'] = 'Wenn eine Person auf eine Kachel klickt und der Kachelinhalt im Sitzungsspeicher des Browsers älter ist als dieser Wert, bleibt die Anzeige bestehen. Im Hintergrund wird aber eine Serveranfrage gestellt, ob eine neue Version dies ersetzen soll. Nachträgliche Aktualisierungen des Kurses sind möglich, nachdem der Browser seine Kopie gespeichert hat. Wenn der gespeicherte Inhalt jünger ist, scheint er aktuell zu sein und wird ohne Serveranfrage angezeigt.';
$string['labelconverted'] = 'Konvertiertes Label';
$string['links'] = 'Links';
$string['loading'] = 'Laden';
$string['modalmodules'] = 'Modale Module';
$string['modalmodules_desc'] = 'Diese Kursmodule in einem Modal-Fenster starten. (Weitere Module könnten in einer zukünftigen Version dazukommen.)';
$string['modalresources'] = 'Modale Ressourcen';
$string['modalresources_desc'] = 'Starten Sie diese Ressourcen in einem Modal-Fenster starten.
<br>Hinweis: Wenn dies hier erlaubt ist, werden URL-Ressourcen nur in einem modalen Fenster geöffnet, wenn sie auf Aktivitätsebene auf {$a->displayembed} eingestellt sind (z.B. YouTube- oder Vimeo-Videos). Und selbst dann könnte vom originalen Websitebesitzer verhindert worden sein, URL-Ressourcen eingebettet anzuzeigen - siehe {$a->link}';
$string['modalwindows'] = 'Modale Fenster';
$string['newsectionname'] = 'Neuer Name für Abschnitt {$a}';
$string['nexttopic'] = 'Nächster Abschnitt';
$string['noconnectionerror'] = 'Es ist nicht möglich, Inhalte zu laden. Überprüfen Sie Ihre Internet-Verbindung';
$string['nojswarning'] = 'Ihr Browser scheint kein JavaScript zu unterstützen, oder JavaScript ist deaktiviert. Eine erweiterte Nutzerführung ist verfügbar, wenn Sie JavaScript aktivieren.';
$string['none'] = 'Keine';
$string['notcomplete'] = 'Nicht abgeschlossen';
$string['notrecommended'] = 'Nicht empfohlen';
$string['notregistered'] = 'Das Plugin "Kachelformat" ist noch nicht bei den Entwickler/innen registriert.';
$string['novaliddefaultcolour'] = 'Keine gültige Farbe für die unten stehende Standardkachelfarbe festgelegt';
$string['ok'] = 'OK';
$string['other'] = 'Sonstiges';
$string['outcomes'] = 'Ergebnisse';
$string['outcomesunavailable'] = 'Ergebnisse nicht verfügbar';
$string['overall'] = 'Insgesamt';
$string['overallprogress'] = 'Aktivitätsabschluss - Fortschritt insgesamt';
$string['overallprogressshort'] = 'Fortschritt insgesamt';
$string['photoguidance_desc'] = '<p>Laden Sie ein Foto im <strong>Querformat</strong> hoch. Die Breite sollte etwa das 1,35-fache der Höhe betragen, z.B. 270 Breite x 200 Höhe. Sie müssen nicht genau sein. </p>
<p>Fotos im Hochformat passen nicht zur Form der Kacheln. Große Bilder oder Dateien werden nach dem Hochladen verkleinert und bei Bedarf komprimiert.</p>';
$string['photolibrary'] = 'Fotobibliothek';
$string['photolibrary_desc'] = 'Diese Fotos haben Sie kürzlich hochgeladen oder verwendet. Klicken Sie darauf, um ein Foto als Hintergrund für diese Kachel zu verwenden. Verwenden Sie die Registerkarte "Hochladen", um neue Fotos hochzuladen.';
$string['phototilesaltstyle'] = 'Alternativer Stil für Fotokacheln';
$string['phototilesaltstyle_desc'] = 'Wenn diese Option nicht ausgewählt (Standardeinstellung) ist, wird auf den Fotokacheln der Titel oben auf der Kachel angezeigt. Der alternative Stil zeigt den Titel unten.';
$string['phototilesettings'] = 'Fotokacheln';
$string['phototiletitletransarency'] = 'Transparenz für Titel';
$string['phototiletitletransarency_desc'] = 'Das Titeloverlay auf einer Fotokachel kann einen leicht transparenten Hintergrund (standard 30%) oder einen einfarbigen Hintergrund (0%) haben.';
$string['phototitletitlelineheight'] = 'Zeilenhöhe für Titel';
$string['phototitletitlepadding'] = 'Vertikaler Seitenabstand für Titel';
$string['picknewicon'] = 'Neues Icon auswählen';
$string['picknewiconphoto'] = 'Neues Icon oder Hintergrundfoto auswählen';
$string['pluginname'] = 'Kachelformat';
$string['previoustopic'] = 'Vorheriger Abschnitt';
$string['privacy:metadata:preference:format_tiles_stopjsnav'] = 'Unabhängig davon, ob die animierte JavaScript-Navigation deaktiviert ist.';
$string['privacypolicy'] = 'Datenschutzrichtlinie';
$string['progress'] = 'Fortschritt';
$string['reactivate'] = 'reaktivieren';
$string['register'] = 'Registrieren';
$string['registeragreeprivacy'] = 'Ich stimme der {$a->privacypolicylink} der Plugin-Entwickler/innen zu';
$string['registerclicktocomplete'] = 'Klicken Sie auf OK, um den Vorgang abzuschließen.';
$string['registeredthanks'] = 'Das Plugin ist registriert. Danke!';
$string['registeremailno'] = 'Nein, ich möchte keine E-Mails empfangen';
$string['registeremailyes'] = 'Ja, ich möchte Mitteilungen zu Aktualisierungen und andere Informationen zum Kachelformat empfangen';
$string['registerintro1'] = 'Wir möchten mit Ihnen in Verbindung bleiben. Mit der Registrierung';
$string['registerintro2'] = 'unterstützen Sie die zukünftige Entwicklung des Plugins';
$string['registerintro3'] = 'informieren wie Sie über wichtige Aktualisierungen und zukünftige Pläne';
$string['registerintro4'] = 'erfahren wir mehr über Ihren Einsatz des Plugins';
$string['registerintro5'] = 'Ihre Daten werden von den Entwickler/innen vertraulich behandelt, so wie es in der Datenschutzrichtlinie angegeben ist. Danke für Ihre Unterstützung!';
$string['registermissingemail'] = 'Geben Sie bitte Ihre E-Mail-Adresse ein (Sie haben unten für den Empfang von E-Mails "Ja" ausgewählt).';
$string['registerpickemailpref'] = 'Wählen Sie bitte Ihre E-Mail-Präferenz';
$string['registerpolicyagreedlinktext'] = 'Datenschutzrichtlinie und Datenverarbeitungsvereinbarung';
$string['registrationdeferred'] = 'Danke! Wir versuchen Ihr Plugin zu registrieren (dies ist noch nicht vollständig).';
$string['reopenlastsection'] = 'Zuletzt besuchte Kachel wieder öffnen';
$string['reopenlastsection_desc'] = 'Wenn diese Option aktiviert ist, wird der letzte Abschnitt, den der Nutzer/in geöffnet hatte, bei seinem nächsten Besuch wieder geöffnet';
$string['resetallcoursecolours'] = 'Alle Kursfarben zurücksetzen';
$string['resetcolours'] = 'Farben zurücksetzen';
$string['resetcolours_desc'] = 'Drücken Sie diese Taste, um die Kachelfarbe für alle Kurse zurückzusetzen, die die folgenden Farben nicht haben. Die Kurse werden in die angegebene Standardfarbe für Kacheln geändert. Sie können diese Option verwenden, nachdem Sie die Farbpalette geändert haben. Stellen Sie jedoch sicher, dass Sie alle Änderungen an den Farben gespeichert haben, bevor Sie auf die Taste klicken. Seien Sie vorsichtig, da dies die Farben vieler Kurse verändern kann!';
$string['revealcontents'] = 'Kachelinhalt aufdecken';
$string['section0name'] = 'Allgemeines';
$string['sectionerrorstring'] = 'Ihre Sitzung ist möglicherweise abgelaufen. Versuchen Sie, diese Seite zu aktualisieren.';
$string['sectionerrortitle'] = 'Fehler beim Laden von Inhalten';
$string['sectionname'] = 'Kachel';
$string['sectionnumber'] = 'Abschnitts-/Kachelnummer';
$string['selected'] = 'Ausgewählt';
$string['setavailabletilecolours'] = 'Zulässige Kachelfarben (für die Website)';
$string['settings'] = 'Einstellungen zum Kursformat';
$string['show'] = 'Anzeigen';
$string['showalltiles'] = 'Alle Kacheln anzeigen';
$string['showfromothers'] = 'Kachel anzeigen';
$string['showoverallprogress'] = 'Gesamtfortschritt anzeigen';
$string['showoverallprogress_desc'] = 'Zeigen Sie oben rechts im Kurs den Indikator "Gesamtfortschritt %" an. Der angezeigte Wert ist der Gesamtwert in %, basierend auf den Aktivitätsabschlüssen und nicht auf dem Kursabschluss.';
$string['showprogresssphototiles_desc'] = 'Wenn diese Option ausgewählt ist, wird der Teilnehmerfortschritt (z.B. Fortschritt 2/5) auf den Fotokacheln angezeigt';
$string['showseczerocoursewide'] = 'Anzeige des Abschnittes "Allgemeines" in allen Abschnitten';
$string['showseczerocoursewide_desc'] = 'Wenn diese Option aktiviert ist, wird der Abschnitt Null (der oberste Abschnitt) auf der Kursseite und oben auf jeder Seite des Kurses angezeigt (d.h. oben über dem Inhalt jeder Kachel). Wenn nicht angekreuzt (empfohlen), wird es nur auf der Kursseite angezeigt';
$string['showseparatewin'] = 'Datei in einem separaten Fenster anzeigen';
$string['sitename'] = 'Name der Website';
$string['snapwarning'] = 'Es ist möglich, Ihren Kurs im Kachelformat mit einem anderen Design zu bearbeiten und dann nach der Bearbeitung wieder zum \'Snap-Design\' zurückzukehren.';
$string['snapwarning_help'] = 'Designs > Einstellungen > Designwechsel für Nutzer/innen erlauben';
$string['subtileszeczerotoggled'] = 'Der obere Abschnitt wird zwischen Listen- und Unterkachelformat umgeschaltet';
$string['sureresetcolours'] = 'Möchten Sie die Kachelfarben wirklich für alle Kurse zurücksetzen? Dies betrifft insgesamt {$a} Kurse.';
$string['tilecolourgeneral'] = 'Farbpalette - optionale Farbe';
$string['tilecolourgeneral_descr'] = 'Mit diesen Einstellungen wird festgelegt, welche Farben den Trainer/innen in ihren Kursen zur Verfügung stehen. Stellen Sie die Farbe auf Schwarz (#000000) ein, um diese Farbe zu deaktivieren. Wenn Sie die Farben nachträglich hier ändern, werden keine Änderungen an vorhandenen Kursen vorgenommen. Für die nächste Kursbearbeitung stehen den Trainer/innen aber dann nur die Farben zur Verfügung, die Sie hier festgelegt haben.';
$string['tilecolourschanged'] = 'Die Kachelfarben wurden zurückgesetzt. Alle Kacheln haben jetzt Farben aus den angegebenen Bereich.';
$string['tileicon'] = 'Symbol, dass nur auf dieser Kachel angezeigt wird';
$string['tileicon_help'] = 'Das hier ausgewählte Element überschreibt nur für diese Kachel das Kachelsymbol, dass auf der Kursebene festgelegt wurde.';
$string['tileicons'] = 'Kachelicons';
$string['tileoutcome'] = 'Ergebnis für diese Kachel';
$string['tileoutcome_help'] = 'Wenn Sie ein Ergebnis für diese Kachel auswählen, können Sie dann unter Kurseinstellungen eine Reihe von <em>Filtertasten</em> anzeigen, eine für jedes Ergebnis, die beim Drücken die angezeigten Kacheln nach dem Ergebnis filtern, die ihnen zugewiesen wurde';
$string['tileselecttip'] = 'Es gibt eine einfache Möglichkeit, ein Kachelsymbol oder Foto zu ändern: Klicken Sie bei aktiviertem Bearbeitungsmodus einfach auf das Symbol oder Foto, das Sie ändern möchten. Die Symbolauswahl wird angezeigt.';
$string['tilesformatregistration'] = 'Registrierung für Kachelformat';
$string['tip'] = 'Hinweis';
$string['togglecompletion'] = 'Klicken Sie zum Umschalten vom Abschlussstatus';
$string['tootall'] = 'zu klein für die Kachel';
$string['toowide'] = 'zu groß für die Kachel';
$string['transparenttitleadjustments'] = 'Einstellungen für die Titeltransparenz';
$string['transparenttitleadjustments_desc'] = 'Bei Fotokacheln mit transparentem Titelhintergrund können Sie diese je nach Thema anpassen, damit sich z.B. die transparenten Zeilen des Titels beim Umbrechen nicht überlappen.
Beachten Sie, dass die Darstellung in unterschiedlichen Browsern leicht variiert. Vorgeschlagene Werte für Chrome: Boost- und Clean-basierte Designs: 30.5 und 4 | Adaptable: 32 und 4 | Moove: 32 und 2 | Remui: 32 und 2,5';
$string['uploadnewphoto'] = 'Neues Foto hochladen';
$string['uploadnewphoto_help'] = 'Neues Foto hochladen, um es für die Kachel zu verwenden';
$string['usejavascriptnav'] = 'JavaScript-Navigation auf der Kachelhauptseite verwenden';
$string['usejavascriptnav_desc'] = 'Wenn diese Option aktiviert ist und Nutzer/innen in der Kursübersicht auf eine Kachel klickt, wird JavaScript für den Übergang zum Kachelinhalt verwendet. Der Kachelinhalt wird gemäß der anderen Einstellungen lokal im Browser gespeichert. Wenn diese Option nicht aktiviert ist, wird JavaScript nicht verwendet. Stattdessen wird die Legacy-Navigation verwendet und weiteren JavaScript-Einstellungen werden ignoriert.';
$string['usejseditingexpandcollapse'] = 'Bearbeitungsmodus - JavaScript verwenden, um Kacheln auf- und zuzuklappen';
$string['usejseditingexpandcollapse_desc'] = 'Wenn diese Option ausgewählt ist, können die Kacheln mit animierten Übergängen auf- und zugeklappt werden. Der Kachelinhalt wird beim Aufklappen ohne Neuladen der Seite angezeigt.';
$string['usejsnavforsinglesection'] = 'JavaScript-Navigation für einzelne Abschnittsseiten verwenden';
$string['usejsnavforsinglesection_desc'] = 'Wenn diese Option aktiviert ist, wird jeder Abschnittsaufruf (&section=xx) mithilfe von JavaScript verarbeitet. Die Kurshauptseite wird gestartet, um anschließend über JavaScript animiert den angeforderten Abschnitt zu öffnen.';
$string['usesubtilesseczero'] = 'Unterkacheln im oberen Bereich verwenden';
$string['usesubtilesseczero_help'] = 'Wenn dies ausgewählt ist, werden die Unterkacheln im oberen Bereich sowie in allen Kacheln verwendet. Nachteil: Die Subkacheln nehmen viel Raum ganz oben ein. Damit Elemente im oberen Bereich stattdessen im Standardlistenformat angezeigt werden kann es kann besser sein, dies nicht zu auszuwählen.';
$string['width'] = 'Breite';
