<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'data', language 'de', version '3.5'.
 *
 * @package     data
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Aktion';
$string['add'] = 'Eintrag hinzufügen';
$string['addcomment'] = 'Kommentar hinzufügen';
$string['addentries'] = 'Einträge hinzufügen';
$string['addtemplate'] = 'Vorlage für neue Einträge';
$string['advancedsearch'] = 'Erweiterte Suche';
$string['allowcomments'] = 'Kommentare';
$string['alttext'] = 'Alternativer Text';
$string['approvalstatus'] = 'Prüfstatus';
$string['approve'] = 'Zulassen';
$string['approved'] = 'Bestätigt';
$string['areacontent'] = 'Felder';
$string['ascending'] = 'Aufsteigend';
$string['asearchtemplate'] = 'Vorlage zur erweiterten Suche';
$string['atmaxentry'] = 'Sie haben die Höchstzahl zulässiger Einträge erreicht!';
$string['authorfirstname'] = 'Vorname (Autor/in)';
$string['authorlastname'] = 'Nachname (Autor/in)';
$string['autogenallforms'] = 'Alle Basisvorlagen anlegen';
$string['autolinkurl'] = 'URL automatisch verlinken';
$string['availablefromdate'] = 'Verfügbar ab';
$string['availabletags'] = 'Verfügbare Elemente';
$string['availabletags_help'] = 'Die Elemente sind Platzhalter in einer Vorlage, die durch Daten oder Icons (z.B. das Icon zum Bearbeiten) ersetzt werden, sobald Einträge in der Datenbank aufgelistet werden.

Nutzerdefinierte Felder haben das Format [[feldname]]. Alle anderen Elemente haben das Format ##tag##.

Nur die Elemente, die unter \'Verfügbare Elemente\' aufgeführt sind, können in der Vorlage verwendet werden.';
$string['availabletodate'] = 'Verfügbar bis';
$string['availabletodatevalidation'] = 'Das Datum \'Verfügbar bis\' kann nicht vor dem Datum \'Verfügbar ab\' liegen.';
$string['blank'] = 'Leer';
$string['buttons'] = 'Aktionen';
$string['bynameondate'] = 'von {$a->name} - {$a->date}';
$string['calendarend'] = '{$a} endet';
$string['calendarstart'] = '{$a} beginnt';
$string['cancel'] = 'Abbrechen';
$string['cannotaccesspresentsother'] = 'Sie können nicht auf die Vorlagen anderer Nutzer/innen zugreifen.';
$string['cannotadd'] = 'Einträge können nicht hinzugefügt werden!';
$string['cannotdeletepreset'] = 'Fehler beim Löschen der Vorlage';
$string['cannotoverwritepreset'] = 'Fehler beim Überschreiben der Vorgabe';
$string['cannotunziptopreset'] = 'Fehler beim Entpacken im Vorlagenverzeichnis';
$string['checkbox'] = 'Mehrfachauswahl';
$string['chooseexportfields'] = 'Felder für Export auswählen:';
$string['chooseexportformat'] = 'Exportformat auswählen:';
$string['chooseorupload'] = 'Datei wählen';
$string['closebeforeopen'] = 'Das Enddatum kann nicht vor dem Startdatum liegen.';
$string['columns'] = 'Spalten';
$string['comment'] = 'Kommentar';
$string['commentdeleted'] = 'Kommentar gelöscht';
$string['commentempty'] = 'Kommentar war leer';
$string['comments'] = 'Kommentare';
$string['commentsaved'] = 'Kommentare gesichert';
$string['commentsn'] = '{$a} Kommentare';
$string['commentsoff'] = 'Kommentare sind nicht aktiviert';
$string['completionentries'] = 'Einträge notwendig';
$string['completionentriescount'] = 'Anzahl der Einträge';
$string['completionentriesdesc'] = 'Minimale Anzahl von erforderlichen Einträgen: {$a}';
$string['configenablerssfeeds'] = 'Mit dieser Funktion aktivieren Sie RSS-Feeds für alle Datenbanken. Nach der Aktivierung an dieser Stelle ist zusätzlich die Aktivierung in jeder einzelnen Datenbank innerhalb der Kursräume erforderlich.';
$string['confirmdeletefield'] = 'Möchten Sie dieses Feld in der Datenbank wirklich löschen?';
$string['confirmdeleterecord'] = 'Möchten Sie diesen Datensatz in der Datenbank wirklich löschen?';
$string['confirmdeleterecords'] = 'Möchten Sie diese Einträge wirklich löschen?';
$string['csstemplate'] = 'CSS-Vorlage';
$string['csvfailed'] = 'Aus der CSV-Datei konnten keine Daten gelesen werden';
$string['csvfile'] = 'CSV-Datei';
$string['csvimport'] = 'CSV-Dateiimport';
$string['csvimport_help'] = 'Daten können über eine CSV-Datei importiert werden, wobei die erste Zeile eine Liste von Feldnamen enthalten muss, gefolgt von den Daten mit jeweils einem Datensatz pro Zeile.';
$string['csvwithselecteddelimiter'] = '<acronym title="Komma getrennte Werte">CSV</acronym> mit diesem Trennzeichen:';
$string['data:addinstance'] = 'Neue Datenbank hinzufügen';
$string['data:approve'] = 'Einträge freigeben oder sperren';
$string['data:comment'] = 'Kommentare schreiben';
$string['data:exportallentries'] = 'Alle Datenbankeinträge exportieren';
$string['data:exportentry'] = 'Datenbankeintrag exportieren';
$string['data:exportownentry'] = 'Eigenen Datenbankeintrag exportieren';
$string['data:exportuserinfo'] = 'Nutzerinformationen exportieren';
$string['data:managecomments'] = 'Kommentare verwalten';
$string['data:manageentries'] = 'Einträge verwalten';
$string['data:managetemplates'] = 'Vorlagen verwalten';
$string['data:manageuserpresets'] = 'Vorlagensätze verwalten';
$string['data:rate'] = 'Einträge bewerten';
$string['data:readentry'] = 'Einträge lesen';
$string['data:view'] = 'Datenbankaktivität anzeigen';
$string['data:viewallratings'] = 'Alle Einzelwertungen anzeigen';
$string['data:viewalluserpresets'] = 'Alle Vorlagensätze anzeigen';
$string['data:viewanyrating'] = 'Alle Gesamtwertungen anzeigen';
$string['data:viewentry'] = 'Einträge anzeigen';
$string['data:viewrating'] = 'Eigene Gesamtwertung anzeigen';
$string['data:writeentry'] = 'Einträge schreiben';
$string['date'] = 'Datum';
$string['dateentered'] = 'Datum eingetragen';
$string['defaultfielddelimiter'] = '(Vorgabe: Komma)';
$string['defaultfieldenclosure'] = '(Vorgabe: kein Zeichen)';
$string['defaultsortfield'] = 'Standard-Sortierfeld';
$string['delcheck'] = 'Checkbox zum Löschen (Bulk)';
$string['delete'] = 'Löschen';
$string['deleteallentries'] = 'Alle Einträge löschen';
$string['deletecomment'] = 'Möchten Sie diesen Kommentar wirklich löschen?';
$string['deleted'] = 'gelöscht';
$string['deletefield'] = 'Bestehendes Feld löschen';
$string['deletenotenrolled'] = 'Einträge von abgemeldeten Nutzer/innen löschen';
$string['deletewarning'] = 'Möchten Sie diese Vorlage wirklich löschen?';
$string['descending'] = 'Absteigend';
$string['directorynotapreset'] = '{$a->directory} ist kein Vorlagensatz. Fehlende Dateien: {$a->missing_files}';
$string['disapprove'] = 'Eintrag nicht freigegeben';
$string['download'] = 'Herunterladen';
$string['edit'] = 'Bearbeiten';
$string['editcomment'] = 'Kommentar bearbeiten';
$string['editentry'] = 'Eintrag bearbeiten';
$string['editordisable'] = 'Editor ausschalten';
$string['editorenable'] = 'Editor einschalten';
$string['emptyadd'] = 'Eine Vorlage für das Eintragen neuer Daten ist noch nicht vorhanden. Es wird ein Basisformular erstellt...';
$string['emptyaddform'] = 'Sie haben keine Einträge vorgenommen!';
$string['enabletemplateeditorcheck'] = 'Möchten Sie den Bearbeitungsmodus wirklich aktivieren? Dies könnte dazu führen, dass Inhalte beim Speichern der Vorlage verändert werden.';
$string['entries'] = 'Einträge';
$string['entrieslefttoadd'] = 'Sie müssen {$a->entriesleft} (weitere) Einträge vornehmen, um diese Aktivität zu beenden.';
$string['entrieslefttoaddtoview'] = 'Sie müssen {$a->entrieslefttoview} (weitere) Einträge vornehmen, bevor Sie andere Teilnehmerbeiträge betrachten können.';
$string['entry'] = 'Eintrag';
$string['entrysaved'] = 'Ihr Eintrag wurde gesichert';
$string['errormustbeteacher'] = 'Diese Seite können nur Trainer/innen verwenden!';
$string['errormustsupplyvalue'] = 'Sie müssen hier einen Wert eintragen.';
$string['errorpresetexists'] = 'Es gibt bereits eine Vorlage mit dem gewählten Namen';
$string['eventfieldcreated'] = 'Feld angelegt';
$string['eventfielddeleted'] = 'Feld gelöscht';
$string['eventfieldupdated'] = 'Feld aktualisiert';
$string['eventrecordcreated'] = 'Datensatz angelegt';
$string['eventrecorddeleted'] = 'Datensatz gelöscht';
$string['eventrecordupdated'] = 'Datensatz aktualisiert';
$string['eventtemplateupdated'] = 'Vorlage aktualisiert';
$string['eventtemplateviewed'] = 'Vorlagen angezeigt';
$string['example'] = 'Datenbankbeispiel';
$string['excel'] = 'Excel';
$string['expired'] = 'Die Aktivität wurde am {$a} abgeschlossen und ist nicht mehr verfügbar.';
$string['export'] = 'Export';
$string['exportaszip'] = 'Export als ZIP-Datei';
$string['exportaszip_help'] = 'Mit dem Export als ZIP-Datei können Sie einen Vorlagensatz herunterladen, der Felder und Vorlagen enthält. Die ZIP-Datei kann in einem anderen Kurs wieder importiert werden.';
$string['exportedtozip'] = 'In eine temporäre ZIP-Datei exportiert...';
$string['exportentries'] = 'Einträge exportieren';
$string['exportownentries'] = 'Nur eigene Einträge exportieren? ({$a->mine}/{$a->all})';
$string['failedpresetdelete'] = 'Fehler beim Löschen eines Vorlagensatzes';
$string['fieldadded'] = 'Feld hinzugefügt';
$string['fieldallowautolink'] = 'Autolink erlauben';
$string['fielddeleted'] = 'Feld gelöscht';
$string['fielddelimiter'] = 'Feldtrennzeichen';
$string['fielddescription'] = 'Feldbeschreibung';
$string['fieldenclosure'] = 'Feldbegrenzung';
$string['fieldheight'] = 'Höhe';
$string['fieldheightlistview'] = 'Höhe in Listenansicht';
$string['fieldheightsingleview'] = 'Höhe in Einzelansicht';
$string['fieldids'] = 'Feldnummern';
$string['fieldmappings'] = 'Feldzuordnungen';
$string['fieldmappings_help'] = 'Dieses Menü erlaubt Ihnen, die Daten einer bestehenden Datenbank zu erhalten. Um die Daten in einem Feld zu behalten, müssen Sie das alte Feld einem neuen Feld zuordnen ("mappen"), in dem die Daten dann erscheinen. Felder können dabei auch leer gelassen werden.  Jedes alte Feld, das keinem neuen Feld zugeordnet ist, geht verloren und die enthaltenen Daten werden gelöscht.
Sie können nur Felder gleichen Typs einander zuordnen, sodass jedes Dropdown-Menü unterschiedlich aussieht. Versuchen Sie bitte auch nicht, ein altes Feld mehr als einem neuen Feld zuzuordnen.';
$string['fieldname'] = 'Feldname';
$string['fieldnotmatched'] = 'Die folgenden Felder in Ihrer Datei sind in der Datenbank nicht bekannt: {$a}';
$string['fieldoptions'] = 'Optionen (eine pro Zeile)';
$string['fields'] = 'Felder';
$string['fieldupdated'] = 'Feld wurde aktualisiert';
$string['fieldwidth'] = 'Breite';
$string['fieldwidthlistview'] = 'Breite in Listenansicht';
$string['fieldwidthsingleview'] = 'Breite in Einzelansicht';
$string['file'] = 'Datei';
$string['fileencoding'] = 'Encoding';
$string['filesnotgenerated'] = 'Es wurden nicht alle Dateien erzeugt: {$a}';
$string['filtername'] = 'Autoverlinkung zur Datenbank';
$string['footer'] = 'Fußzeile';
$string['forcelinkname'] = 'Vorgegebener Anzeigename für den Link';
$string['foundnorecords'] = 'Keine Einträge gefunden (<a href="{$a->reseturl}">Filter zurücksetzen</a>)';
$string['foundrecords'] = 'Einträge gefunden: {$a->num}/{$a->max} (<a href="{$a->reseturl}">Filter zurücksetzen</a>)';
$string['fromfile'] = 'Import aus ZIP-Datei';
$string['fromfile_help'] = 'Mit dem Import aus einer ZIP-Datei können Sie einen Vorlagensatz hochladen, der Felder Vorlagen enthält.';
$string['generateerror'] = 'Mehrere Dateien wurden nicht angelegt!';
$string['header'] = 'Kopfzeile';
$string['headeraddtemplate'] = 'Definiert Formular zum Anlegen neuer Einträge';
$string['headerasearchtemplate'] = 'Definiert das Interface zur erweiterten Suche';
$string['headercsstemplate'] = 'Definiert lokale CSS-Styles für die anderen Vorlagen';
$string['headerjstemplate'] = 'Definiert angepasstes JavaScript für alle anderen Vorlagen';
$string['headerlisttemplate'] = 'Definiert Übersichtsansicht für mehrere Einträge';
$string['headerrsstemplate'] = 'Definiert Darstellung der Einträge in RSS Feeds';
$string['headersingletemplate'] = 'Definiert Darstellung für die Einzelansicht';
$string['importentries'] = 'Einträge importieren';
$string['importsuccess'] = 'Die Vorlagensatz wurde erfolgreich übernommen.';
$string['includeapproval'] = 'Bestätigungsstatus einfügen';
$string['includetags'] = 'Schlagwörter einbinden';
$string['includetime'] = 'Zeitpunkt hinzugefügt/geändert einfügen';
$string['includeuserdetails'] = 'Nutzerdetails einfügen';
$string['indicator:cognitivedepth'] = 'Datenbank kognitiv';
$string['indicator:cognitivedepth_help'] = 'Dieser Indikator basiert auf der kognitiven Tiefe, die eine Person in einer Datenbankaktivität erreicht hat.';
$string['indicator:socialbreadth'] = 'Datenbank sozial';
$string['indicator:socialbreadth_help'] = 'Dieser Indikator basiert auf der sozialen Breite, die eine Person in einer Datenbankaktivität erreicht hat.';
$string['insufficiententries'] = 'Weitere Einträge sind erforderlich, um die Datenbank einzusehen.';
$string['intro'] = 'Beschreibung';
$string['invalidaccess'] = 'Seite wurde nicht richtig aufgerufen';
$string['invalidfieldid'] = 'Feld-ID ist falsch';
$string['invalidfieldname'] = 'Wählen Sie bitte einen anderen Namen für dieses Feld.';
$string['invalidfieldtype'] = 'Ungültiger Feldtyp
';
$string['invalidid'] = 'Falsche Daten-ID';
$string['invalidpreset'] = '{$a} ist kein Vorlagensatz.';
$string['invalidrecord'] = 'Falscher Eintrag';
$string['invalidurl'] = 'Die eingegebene URL ist nicht gültig.';
$string['jstemplate'] = 'JavaScript für Vorlagen';
$string['latitude'] = 'Breitengrad';
$string['latlong'] = 'Geografische Breite und Länge';
$string['latlongboth'] = 'Längen- und Breitengrad müssen eingetragen werden.';
$string['latlongdownloadallhint'] = 'Download aller Einträge als KML';
$string['latlongkmllabelling'] = 'Wie sollen Ziele in KML-Dateien bezeichnet werden? (Google Earth)';
$string['latlonglinkservicesdisplayed'] = 'Links zum Anzeigen geografischer Daten';
$string['latlongotherfields'] = 'Weitere Felder';
$string['list'] = 'Listenansicht';
$string['listtemplate'] = 'Vorlage für Liste';
$string['longitude'] = 'Längengrad';
$string['manageapproved'] = 'Änderung von freigegebenen Einträgen erlauben';
$string['manageapproved_help'] = 'Diese Option legt fest, ob freigegebene Einträge weiter von deren Autor/in bearbeitet oder gelöscht werden dürfen. Die Einstellung ist nur wirksam, wenn eine Freigabe von Einträgen notwendig ist.';
$string['mapexistingfield'] = 'Verknüpfen mit {$a}';
$string['mapnewfield'] = 'Neues Feld anlegen';
$string['mappingwarning'] = 'Alle alten Felder, die keinem neuen Feld zugeordnet wurden, werden zusammen mit allen Daten aus diesen Feldern gelöscht.';
$string['maxentries'] = 'Maximal mögliche Einträge';
$string['maxentries_help'] = 'Die maximale Zahl der Einträge begrenzt die Einträge, die ein/e Teilnehmer/in bei dieser Aktivität vornehmen darf.';
$string['maxsize'] = 'Größe (max)';
$string['menu'] = 'Menü';
$string['menuchoose'] = 'Auswählen ...';
$string['missingdata'] = 'Daten-ID bzw. Datenobjekt müssen zur Feldklasse passen';
$string['missingfield'] = 'Programmierfehler: Sie müssen Feld und Daten angeben, wenn Sie eine Feldklasse definieren.';
$string['modulename'] = 'Datenbank';
$string['modulename_help'] = 'Sammeln Sie mit Ihren Teilnehmer/innen Informationen in einer Datenbank. Legen Sie eine Struktur für die Felder der Datenbank fest und definieren Sie, was später in der Übersicht (Listenansicht) oder einer Detailansicht angezeigt werden soll.

Wählen Sie flexibel zwischen verschiedenen Feldtypen wie Checkbox, Radiobutton, Dropdownmenü, Texteinträgen, Link, Bild und hochgeladenen Dateien.

Sie können die Datenbank so einstellen, dass Einträge zuerst geprüft werden müssen. Außerdem können Sie Kommentare zu den Einträgen zulassen.';
$string['modulenameplural'] = 'Datenbanken';
$string['more'] = 'Einzelansicht';
$string['moreurl'] = 'Weitere URL';
$string['movezipfailed'] = 'Kann ZIP nicht bewegen';
$string['multientry'] = 'Wiederholter Eintrag';
$string['multimenu'] = 'Menü (Mehrfachauswahl)';
$string['multipletags'] = 'Elemente mehrfach gefunden! Keine Vorlage gespeichert.';
$string['namecheckbox'] = 'Ankreuzfeld';
$string['namedate'] = 'Datumsfeld';
$string['namefile'] = 'Dateifeld';
$string['namelatlong'] = 'Latitude/Longitude Feld';
$string['namemenu'] = 'Menüfeld';
$string['namemultimenu'] = 'Menüfeld mit Mehrfachauswahl';
$string['namenumber'] = 'Zahlenfeld';
$string['namepicture'] = 'Bildfeld';
$string['nameradiobutton'] = 'Radioknopffeld';
$string['nametext'] = 'Textfeld';
$string['nametextarea'] = 'Textbereichsfeld';
$string['nameurl'] = 'URL-Feld';
$string['newentry'] = 'Neuer Eintrag';
$string['newfield'] = 'Neues Feld erstellen';
$string['newfield_help'] = 'Ein Feld ermöglicht die Eingabe von Daten. Jeder Eintrag in einer Datenbankaktivität kann mehrere Felder verschiedener Typen enthalten, z.B. ein Datumsfeld zur Angabe von Tag, Monat und Jahr, ein Bildfeld zum Hochladen einer Bilddatei oder ein Kontrollkästchen zur Auswahl einer oder mehrerer Optionen.

Jedes Feld muss einen eindeutigen Feldnamen haben. Die Feldbeschreibung ist optional.';
$string['noaccess'] = 'Sie haben keinen Zugriff auf diese Seite.';
$string['nodefinedfields'] = 'Neuer Vorlagensatz besitzt keine definierten Felder!';
$string['nofieldcontent'] = 'Feldinhalt nicht gefunden';
$string['nofieldindatabase'] = 'In dieser Datenbank sind noch keine Felder definiert.';
$string['nolisttemplate'] = 'Die Listenansicht wurde noch nicht definiert';
$string['nomatch'] = 'Keine passenden Einträge gefunden';
$string['nomaximum'] = 'Keine Höchstzahl';
$string['norecords'] = 'Keine Einträge in der Datenbank';
$string['nosingletemplate'] = 'Einzelansicht wurde noch nicht definiert';
$string['notapproved'] = 'Der Eintrag wurde bisher nicht freigegeben';
$string['notinjectivemap'] = 'Keine injektive Abbildung';
$string['notopenyet'] = 'Die Aktivität ist nicht verfügbar bis {$a}.';
$string['number'] = 'Zahl';
$string['numberrssarticles'] = 'RSS Beiträge';
$string['numnotapproved'] = 'Wartend';
$string['numrecords'] = '{$a} Datensätze';
$string['ods'] = '<acronym title="OpenDocument Spreadsheet">ODS</acronym> (OpenOffice)';
$string['openafterclose'] = 'Das Enddatum kann nicht vor dem Startdatum liegen.';
$string['optionaldescription'] = 'Beschreibung (optional)';
$string['optionalfilename'] = 'Dateiname (optional)';
$string['other'] = 'Andere';
$string['overrwritedesc'] = 'Vorlage überschreiben, falls sie bereits existiert';
$string['overwrite'] = 'Überschreiben';
$string['overwritesettings'] = 'Bisherige Einträge überschreiben';
$string['page-mod-data-x'] = 'Jede Datenbankseite';
$string['pagesize'] = 'Einträge pro Seite';
$string['participants'] = 'Teilnehmer/innen';
$string['picture'] = 'Bild';
$string['pleaseaddsome'] = 'Bitte erzeugen Sie ein Feld oder <a href="{$a}">wählen Sie einen Vorlagensatz</a>, um zu beginnen.';
$string['pluginadministration'] = 'Datenbank-Administration';
$string['pluginname'] = 'Datenbank';
$string['portfolionotfile'] = 'In ein Portfolio und nicht als Datei exportieren (nur csv und leap2a)';
$string['presetinfo'] = 'Durch das Sichern als Vorlagensatz wird Ihre Datenbank-Gestaltung für die gesamte Moodle-Installation veröffentlicht. Andere Nutzer/innen können dann diesen Vorlagensatz für ihre Datenbank nutzen.';
$string['presets'] = 'Vorlagensätze';
$string['privacy:metadata:commentpurpose'] = 'Kommentar zum Datenbankeintrag';
$string['privacy:metadata:data_content'] = 'Steht für eine Antwort in einem Feld in der Datenbankaktivität';
$string['privacy:metadata:data_content:content'] = 'Inhalt';
$string['privacy:metadata:data_content:content1'] = 'Zusätzlicher Inhalt 1';
$string['privacy:metadata:data_content:content2'] = 'Zusätzlicher Inhalt 2';
$string['privacy:metadata:data_content:content3'] = 'Zusätzlicher Inhalt 3';
$string['privacy:metadata:data_content:content4'] = 'Zusätzlicher Inhalt 4';
$string['privacy:metadata:data_content:fieldid'] = 'Felddefinitons-ID';
$string['privacy:metadata:data_records'] = 'Steht für Einträge in der Datenbank';
$string['privacy:metadata:data_records:approved'] = 'Bestätigungsstatus';
$string['privacy:metadata:data_records:groupid'] = 'Gruppe';
$string['privacy:metadata:data_records:timecreated'] = 'Zeitpunkt, an dem Eintrag erstellt wurde';
$string['privacy:metadata:data_records:timemodified'] = 'Zeitpunkt, zu dem Eintrag verändert wurde';
$string['privacy:metadata:data_records:userid'] = 'Nutzer, der den Eintrag erstellt hat';
$string['privacy:metadata:datafieldnpluginsummary'] = 'Felder der Datenbankaktivität';
$string['privacy:metadata:filepurpose'] = 'Datei, die Datenbankeintrag zugeordnet wurde';
$string['privacy:metadata:ratingpurpose'] = 'Bewertung für Datenbankeintrag';
$string['privacy:metadata:tagpurpose'] = 'Tags für Datenbankeintrag';
$string['radiobutton'] = 'Einfachauswahl';
$string['recordapproved'] = 'Datensatz wurde angenommen';
$string['recorddeleted'] = 'Datensatz gelöscht';
$string['recorddisapproved'] = 'Eintrag nicht freigegeben';
$string['recordsnotsaved'] = 'Kein Eintrag wurde gespeichert. Prüfen Sie bitte das Format der hochgeladenen Datei.';
$string['recordssaved'] = 'Einträge gespeichert';
$string['removealldatatags'] = 'Alle Datenbank-Tags entfernen';
$string['requireapproval'] = 'Freigabe erforderlich';
$string['requireapproval_help'] = 'Wenn diese Option aktiviert ist, müssen die Einträge von Trainer/innen erst bestätigt werden, bevor sie für alle anderen angezeigt werden?';
$string['required'] = 'Notwendig';
$string['requiredentries'] = 'Erforderliche Einträge für den Abschluss (alt)';
$string['requiredentries_help'] = 'Bei Aktivierung wird eine Nachricht angezeigt, welche die erforderliche Anzahl von Beiträgen angibt, die zum Abschluss notwendig sind. Beachten Sie, dass dies nicht mit Akivitätsabschluss verbunden ist.

Für erforderliche Beiträge zum Akivitätabschluss sollte die neue Einstellung "Beiträge erforderlich" in den Einstellungen für Aktivitätsabschlüsse verwendet werden. Um diese Einstellung vollständig zu entfernen setzten Sie sie auf "Keine" und klicken auf "Änderungen speichern".
Bitte wählen Sie stattdessen "Beiträge erforderlich" in den Einstellungen für Akivitätsabschlüsse aus.';
$string['requiredentriestoview'] = 'Erforderliche Einträge vor der Ansicht aller Daten';
$string['requiredentriestoview_help'] = 'Die erforderliche Zahl der Einträge gibt die Zahl der eigenen Einträge an, die Teilnehmer/innen liefern müssen, bevor sie Einträge anderer Teilnehmer/innen einsehen dürfen.

Hinweis: Falls Einträge vor der Ansicht notwendig sind, sollte die Autoverlinkung für die Datenbank deaktiviert sein. Die Autoverlinkung kann nämlich nicht entscheiden, ob jemand die erforderliche Anzahl von Einträgen bereits geliefert hat.';
$string['requiredentrieswarning'] = 'Diese Einstellung wurde durch die Abschlussbedingung \'Einträge erforderlich\' ersetzt.';
$string['requiredfield'] = 'Pflichtfeld';
$string['resetsettings'] = 'Filter zurücksetzen';
$string['resettemplate'] = 'Vorlage zurücksetzen';
$string['resizingimages'] = 'Vorschaubilder anpassen...';
$string['rows'] = 'Zeilen';
$string['rssglobaldisabled'] = 'Deaktiviert. Beachten Sie die Einstellungsseite für die Variablen.';
$string['rsstemplate'] = 'Vorlage für RSS-Feed';
$string['rsstitletemplate'] = 'Vorlage für RSS-Titelzeile';
$string['save'] = 'Sichern';
$string['saveandadd'] = 'Sichern und weitere hinzufügen';
$string['saveandview'] = 'Sichern und anzeigen';
$string['saveaspreset'] = 'Als Vorlagensatz sichern';
$string['saveaspreset_help'] = 'Die Option \'Als Vorlagensatz speichern\' veröffentlicht die Vorlagen und Felder als Vorlagensatz in einer Liste. Andere auf der Website können Ihren Vorlagensatz benutzen, wobei Sie jederzeit den Vorlagensatz wieder entfernen dürfen.';
$string['savesettings'] = 'Einstellungen speichern';
$string['savesuccess'] = 'Erfolgreich gespeichert. Ihr Vorlagensatz wird ab sofort überall in diesem Moodle nutzbar sein.';
$string['savetemplate'] = 'Vorlage speichern';
$string['search'] = 'Suche';
$string['search:activity'] = 'Datenbank - Beschreibung';
$string['search:entry'] = 'Datenbank - Einträge';
$string['selectedrequired'] = 'Gesamte Auswahl ist erforderlich';
$string['showall'] = 'Alle Einträge anzeigen';
$string['single'] = 'Einzelansicht';
$string['singletemplate'] = 'Vorlage für Einzelansicht';
$string['subplugintype_datafield'] = 'Datenbank-Feldtyp';
$string['subplugintype_datafield_plural'] = 'Datenbank-Feldtypen';
$string['subplugintype_datapreset'] = 'Vorlagensatz';
$string['subplugintype_datapreset_plural'] = 'Vorlagensätze';
$string['tagarea_data_records'] = 'Datensätze';
$string['tags'] = 'Schlagwörter';
$string['tagsdeleted'] = 'Datenbank-Tags wurden entfernt';
$string['teachersandstudents'] = '{$a->teachers} und {$a->students}';
$string['templates'] = 'Vorlagen';
$string['templatesaved'] = 'Vorlage wurde gespeichert';
$string['text'] = 'Text';
$string['textarea'] = 'Textbereich';
$string['timeadded'] = 'Zeit erstellt';
$string['timemodified'] = 'Zuletzt geändert';
$string['todatabase'] = 'in diese Datenbank';
$string['type'] = 'Feld-Typ';
$string['undefinedprocessactionmethod'] = 'In Data_Preset wurde keine Verarbeitungsmethode definiert für: "{$a}".';
$string['unsupportedexport'] = '({$a->fieldtype}) kann nicht exportiert werden';
$string['updatefield'] = 'Bestehendes Feld aktualisieren';
$string['uploadfile'] = 'Datei hochladen';
$string['uploadrecords'] = 'Datensätze als Datei hochladen';
$string['uploadrecords_help'] = 'Einträge können als Textdatei hochgeladen werden, wobei das Dateiformat folgendermaßen strukturiert sein muss:

* Jede Zeile der Datei beinhaltet einen neuen Datensatz
* Jeder Datensatz besteht aus einer Reihe von Daten, die durch Kommas (oder andere Trennzeichen) getrennt sind
* Der erste Datensatz enthält eine Liste von Feldnamen, die das Format der restlichen Datei festlegen

Die Feldbegrenzung ist ein Zeichen, dass jedes Feld im jedem Datensatz zusätzlich abgrenzt. Normalerweise ist es nicht gesetzt.';
$string['url'] = 'URL';
$string['usedate'] = 'In Suche einbeziehen';
$string['usestandard'] = 'Vorlage benutzen';
$string['usestandard_help'] = 'Um einen auf der gesamten Website verfügbaren Vorlagensatz zu benutzen, wählen Sie ihn aus der Liste aus. Wenn Sie selbst einen Vorlagensatz zur Liste hinzugefügt haben, können Sie ihn hier auch wieder löschen.';
$string['viewfromdate'] = 'Bearbeiten sperren ab';
$string['viewtodate'] = 'Bearbeiten sperren bis';
$string['viewtodatevalidation'] = 'Das Datum \'Bearbeiten sperren bis\' kann nicht vor dem Datum \'Bearbeiten sperren ab\' liegen.';
$string['wrongdataid'] = 'Falsche Daten-ID bereitgestellt';
