<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_moodlemobileapp', language 'ja', version '3.5'.
 *
 * @package     local_moodlemobileapp
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addon.calendar.calendarevents'] = 'カレンダーイベント';
$string['addon.calendar.defaultnotificationtime'] = 'デフォルト通知時間';
$string['addon.calendar.errorloadevent'] = 'イベントの読み込み時にエラーがありました。';
$string['addon.calendar.errorloadevents'] = 'イベントの読み込み時にエラーがありました。';
$string['addon.calendar.noevents'] = 'イベントはありません';
$string['addon.competency.errornocompetenciesfound'] = 'コンピテンシーが見つかりません';
$string['addon.competency.nocompetencies'] = 'コンピテンシーなし';
$string['addon.coursecompletion.complete'] = '完了';
$string['addon.coursecompletion.couldnotloadreport'] = 'コース完了の読み込みができませんでした。後でもう一度試してください。';
$string['addon.files.couldnotloadfiles'] = '以下のファイルが読み込みできませんでした。';
$string['addon.files.emptyfilelist'] = '表示するファイルがありません。';
$string['addon.files.erroruploadnotworking'] = '残念ながら、現在、あなたのサイトにファイルをアップロードすることはできません。';
$string['addon.messageoutput_airnotifier.processorsettingsdesc'] = 'デバイスの設定';
$string['addon.messages.contactlistempty'] = '連絡先リストが空';
$string['addon.messages.contactname'] = '連絡先名称';
$string['addon.messages.errordeletemessage'] = 'メッセージ消去中にエラーが発生しました。';
$string['addon.messages.errorwhileretrievingcontacts'] = 'サーバから連絡先を取得中にエラーが発生しました。';
$string['addon.messages.errorwhileretrievingdiscussions'] = 'サーバからディスカッションを受信中にエラーが発生しました。';
$string['addon.messages.errorwhileretrievingmessages'] = 'サーバからメッセージを受信中にエラーが発生しました。';
$string['addon.messages.messagenotsent'] = 'メッセージは送信されませんでした。後で再び試みてください。';
$string['addon.messages.newmessages'] = '新規メッセージ...';
$string['addon.messages.nousersfound'] = 'ユーザが見つかりません';
$string['addon.messages.type_blocked'] = 'ブロックされています';
$string['addon.messages.type_offline'] = 'オフライン';
$string['addon.messages.type_online'] = 'オンライン';
$string['addon.messages.type_search'] = '結果の検索';
$string['addon.messages.type_strangers'] = 'その他';
$string['addon.messages.warningmessagenotsent'] = 'ユーザ {{user}} へのメッセージ送信ができませんでした。 {{error}}';
$string['addon.mod_assign.acceptsubmissionstatement'] = '提出時宣誓文を受諾してください。';
$string['addon.mod_assign.cannoteditduetostatementsubmission'] = 'サイトから提出時宣誓文を取得することができなかったため、アプリでは提出物の追加や編集ができません。';
$string['addon.mod_assign.cannotgradefromapp'] = '評定方法にアプリでは未サポートあるいは変更できないものがあります。';
$string['addon.mod_assign.cannotsubmitduetostatementsubmission'] = 'サイトから提出時宣誓文が取得できなかったため、アプリから評定を提出することができませんでした。';
$string['addon.mod_assign.erroreditpluginsnotsupported'] = '提出物の編集がサポートされていないプラグインがあるため、アプリから提出物の追加や編集ができませんでした。';
$string['addon.mod_assign.errorshowinginformation'] = '提出物の情報を表示できません。';
$string['addon.mod_assign.feedbacknotsupported'] = 'このフィードバックはアプリでは未サポートのため、すべての情報が含まれていない可能性があります';
$string['addon.mod_assign.gradenotsynced'] = '評定が同期できませんでした';
$string['addon.mod_assign.notallparticipantsareshown'] = '提出物のない参加者は表示されていません';
$string['addon.mod_assign.submissionnotsupported'] = 'この提出物はアプリでは未サポートのため、すべての情報が含まれていない可能性があります';
$string['addon.mod_assign.userwithid'] = 'ID {{id}} を持つユーザ';
$string['addon.mod_assign.warningsubmissiongrademodified'] = '提出物の評定がサイト上で変更されました。';
$string['addon.mod_assign.warningsubmissionmodified'] = 'ユーザの提出物がサイト上で変更されました。';
$string['addon.mod_chat.errorwhileconnecting'] = 'チャットに接続する際にエラーが発生しました。';
$string['addon.mod_chat.errorwhilegettingchatdata'] = 'チャットのデータを取得中にエラーが発生しました。';
$string['addon.mod_chat.errorwhilegettingchatusers'] = 'チャットのユーザを取得中にエラーが発生しました。';
$string['addon.mod_chat.errorwhileretrievingmessages'] = 'サーバからメッセージを取得中にエラーが発生しました。';
$string['addon.mod_chat.errorwhilesendingmessage'] = 'メッセージ送信中にエラーが発生しました。';
$string['addon.mod_chat.mustbeonlinetosendmessages'] = 'メッセージを送信するにはオンラインでなければなりません。';
$string['addon.mod_choice.errorgetchoice'] = '選択データの取得中にエラーが発生しました。';
$string['addon.mod_choice.responsesresultgraphdescription'] = '{{number}}% のユーザが選択肢: {{text}} を選択しました。';
$string['addon.mod_choice.resultsnotsynced'] = '結果にあなたの最後のレスポンスが含まれていません。更新のため、同期を行ってください。';
$string['addon.mod_feedback.captchaofflinewarning'] = 'Capchaつきのフィードバックは、未設定の場合、オフラインモードの場合、サーバがダウンしている場合には完了できません。';
$string['addon.mod_feedback.feedback_submitted_offline'] = 'このフィードバックを、あとで提出するために保存しました。';
$string['addon.mod_folder.emptyfilelist'] = '表示するファイルがありません。';
$string['addon.mod_forum.errorgetforum'] = 'フォーラムのデータ取得中にエラーが発生しました。';
$string['addon.mod_forum.errorgetgroups'] = 'グループ設定の取得中にエラーが発生しました。';
$string['addon.mod_forum.forumnodiscussionsyet'] = 'このフォーラムにはまだディスカッショントピックがありません';
$string['addon.mod_forum.group'] = 'グループ';
$string['addon.mod_forum.numdiscussions'] = 'ディスカッション数 {{numdiscussions}}';
$string['addon.mod_forum.numreplies'] = '返信数 {{numreplies}}';
$string['addon.mod_forum.refreshdiscussions'] = 'ディスカッションをリフレッシュ';
$string['addon.mod_forum.refreshposts'] = 'ディスカッション投稿をリフレッシュ';
$string['addon.mod_glossary.browsemode'] = 'エントリをブラウズ';
$string['addon.mod_glossary.byalphabet'] = 'アルファベット順';
$string['addon.mod_glossary.byauthor'] = '著者でグループ';
$string['addon.mod_glossary.bycategory'] = 'カテゴリでグループ';
$string['addon.mod_glossary.bynewestfirst'] = '新規順';
$string['addon.mod_glossary.byrecentlyupdated'] = '最近の更新';
$string['addon.mod_glossary.bysearch'] = '検索';
$string['addon.mod_glossary.cannoteditentry'] = 'エントリの編集ができませんでした';
$string['addon.mod_glossary.entriestobesynced'] = 'エントリの同期ができませんでした';
$string['addon.mod_glossary.entrypendingapproval'] = 'このエントリは承認待ちです。';
$string['addon.mod_glossary.errorloadingentries'] = 'エントリ読み込み中にエラーが発生しました。';
$string['addon.mod_glossary.errorloadingentry'] = 'エントリ読み込み中にエラーが発生しました。';
$string['addon.mod_glossary.errorloadingglossary'] = '用語集を読み込み中にエラーが発生しました。';
$string['addon.mod_glossary.noentriesfound'] = 'エントリが見つかりませんでした。';
$string['addon.mod_glossary.searchquery'] = '検索内容';
$string['addon.mod_imscp.showmoduledescription'] = '説明の表示';
$string['addon.mod_lesson.errorreviewretakenotlast'] = 'この回答は、別の回答が完了しているため評価できません。';
$string['addon.mod_lesson.finishretakeoffline'] = 'この回答はオフライン状態で完了しました。';
$string['addon.mod_lesson.retakefinishedinsync'] = 'オフラインの回答が同期されました。評価しますか？';
$string['addon.mod_lesson.retakelabelfull'] = '{{retake}}: {{grade}} {{timestart}} ({{duration}})';
$string['addon.mod_lesson.retakelabelshort'] = '{{retake}}: {{grade}} {{timestart}}';
$string['addon.mod_lesson.warningretakefinished'] = '回答はサイト内で完了しました。';
$string['addon.mod_lti.errorgetlti'] = 'モジュールデータ取得中にエラーが発生しました。';
$string['addon.mod_lti.errorinvalidlaunchurl'] = '起動するURLが不正です。';
$string['addon.mod_lti.launchactivity'] = 'アクティビティを起動';
$string['addon.mod_page.errorwhileloadingthepage'] = 'ページ内容を読み込み中にエラーが発生しました。';
$string['addon.mod_quiz.cannotsubmitquizdueto'] = 'このクイズの回答は、以下の理由で提出できませんでした：';
$string['addon.mod_quiz.confirmcontinueoffline'] = 'この回答は、理由「 {{$a}} 」により、同期できませんでした。もしあなたが別のデバイスで回答を続けていた場合、データが失われている可能性があります。';
$string['addon.mod_quiz.confirmleavequizonerror'] = '回答の保存中にエラーが発生しました。クイズを終了してもよいですか？';
$string['addon.mod_quiz.errorbehaviournotsupported'] = 'このクイズは、アプリでサポートされていない動作が含まれているため回答することができません。';
$string['addon.mod_quiz.errordownloading'] = '必要なデータのダウンロード中にエラーが発生しました。';
$string['addon.mod_quiz.errorgetattempt'] = '回答データの取得中にエラーが発生しました。';
$string['addon.mod_quiz.errorgetquestions'] = '質問の取得中にエラーが発生しました。';
$string['addon.mod_quiz.errorgetquiz'] = 'クイズデータの取得中にエラーが発生しました。';
$string['addon.mod_quiz.errorparsequestions'] = '質問の読み込み中にエラーが発生しました。Webブラウザからこのクイズに回答してください。';
$string['addon.mod_quiz.errorquestionsnotsupported'] = 'このクイズは、アプリでサポートされていない質問を含む可能性があるため回答することができません。';
$string['addon.mod_quiz.errorrulesnotsupported'] = 'このクイズは、アプリでサポートされていないアクセスルールがあるため回答することができません。';
$string['addon.mod_quiz.errorsaveattempt'] = '回答データの保存中にエラーが発生しました。';
$string['addon.mod_quiz.finishnotsynced'] = '完了しましたが同期されていません。';
$string['addon.mod_quiz.opentoc'] = 'ナビゲーションポップオーバーを開いてください。';
$string['addon.mod_quiz.warningattemptfinished'] = 'オフラインの回答は、サイト上で完了していた、もしくは見当たらなかったため廃棄されました。';
$string['addon.mod_quiz.warningdatadiscarded'] = '質問文がオンラインで変更されたため、一部のオフライン回答が廃棄されました。';
$string['addon.mod_quiz.warningdatadiscardedfromfinished'] = 'オフライン回答が廃棄されたため、回答が完了していません。回答内容を確認し、回答を再度提出してください。';
$string['addon.mod_resource.errorwhileloadingthecontent'] = '内容を読み込み中にエラーが発生しました。';
$string['addon.mod_resource.openthefile'] = 'ファイルを開く';
$string['addon.mod_scorm.cannotcalculategrade'] = '評定が計算できませんでした。';
$string['addon.mod_scorm.dataattemptshown'] = 'このデータは回答番号 {{number}} に該当します。';
$string['addon.mod_scorm.errorcreateofflineattempt'] = '新たなオフライン回答の作成中にエラーが発生しました。再度実行してください。';
$string['addon.mod_scorm.errordownloadscorm'] = 'SCORM "{{name}}" のダウンロード中にエラーが発生しました。';
$string['addon.mod_scorm.errorgetscorm'] = 'SCORMデータの取得中にエラーが発生しました。';
$string['addon.mod_scorm.errorinvalidversion'] = '申し訳ありません。アプリケーションはSCORM 1.2のみをサポートしています。';
$string['addon.mod_scorm.errornotdownloadable'] = 'あなたのMoodleサイトではSCORMパッケージのダウンロードができません。Moodleサイト管理者に連絡してください。';
$string['addon.mod_scorm.errornovalidsco'] = 'このSCORMはロードに必要な表示できるSCOがありません。';
$string['addon.mod_scorm.errorpackagefile'] = '申し訳ありません。アプリケーションはZIPパッケージのみをサポートしています。';
$string['addon.mod_scorm.errorsyncscorm'] = '同期中にエラーが発生しました。再度実行してください。';
$string['addon.mod_scorm.offlineattemptnote'] = 'この回答には動悸されなかったデータがあります。';
$string['addon.mod_scorm.offlineattemptovermax'] = '受験可能回数を超えたため、この回答を送信できません。';
$string['addon.mod_scorm.scormstatusnotdownloaded'] = 'このSCORMはダウンロードされていません。これを開くときに、自動的にダウンロードされます。';
$string['addon.mod_scorm.scormstatusoutdated'] = 'このSCORMは最後にダウンロードされた後に更新されています。開くときに、自動的に新しいものがダウンロードされます。';
$string['addon.mod_scorm.warningofflinedatadeleted'] = '回答番号 {{number}} を新しい回答として作成することができなかったため、オフラインデータの一部が消去されました。';
$string['addon.mod_scorm.warningsynconlineincomplete'] = '最終のオンライン回答が完了していないため、一部の回答が同期できませんでした。先にオンライン回答を完了してください。';
$string['addon.mod_survey.cannotsubmitsurvey'] = '申し訳ありません。あなたの調査提出で問題が発生しました。再度提出を実行してください。';
$string['addon.mod_survey.errorgetsurvey'] = '調査データの取得中にエラーが発生しました。';
$string['addon.mod_survey.results'] = '結果';
$string['addon.mod_url.accessurl'] = 'URLへのアクセス';
$string['addon.mod_url.pointingtourl'] = 'このリソースを示すURL';
$string['addon.mod_wiki.errorloadingpage'] = 'ページの読み込み中にエラーが発生しました。';
$string['addon.mod_wiki.errornowikiavailable'] = 'このwikiにはまだ内容がありません。';
$string['addon.mod_wiki.gowikihome'] = 'Wikiのホームへ移動';
$string['addon.mod_wiki.subwiki'] = 'サブwiki';
$string['addon.mod_wiki.titleshouldnotbeempty'] = '空のタイトルは受け付けられません';
$string['addon.mod_wiki.viewpage'] = 'ページを表示';
$string['addon.mod_wiki.wikipage'] = 'Wikiページ';
$string['addon.notes.userwithid'] = 'ID {{id}} のユーザ';
$string['addon.notes.warningnotenotsent'] = 'コース {{course}} にノートを追加することができません。 {{error}}';
$string['addon.notifications.errorgetnotifications'] = '通知の取得中にエラーが発生しました。';
$string['addon.notifications.notifications'] = '通知';
$string['addon.notifications.playsound'] = '音を出力';
$string['addon.notifications.therearentnotificationsyet'] = '通知はありません';
$string['appstoredescription'] = '注意：本オフィシャルMoodleモバイルアプリは、その利用許可を設定されたMoodleサイトで「のみ」利用可能です。接続に問題がある場合には、あなたのMoodle管理者に問い合わせてください。

あなたのMoodleサイトがすでに正しくその設定がなされていれば、本アプリから、以下のことができます：

 - あなたのコースコンテンツのブラウズ（オフラインからも）
 - メッセージその他のイベントの即座の通知を受ける
 - あなたのコースに参加している他の人を即座に検索して連絡をとる
 - 画像、オーディオ、動画その他のファイルをあなたのモバイルデバイスからアップロード
 - あなたのコース成績の閲覧
 - その他、もっと多くのこと

最新情報は、 http://docs.moodle.org/en/Mobile_app を参照してください。

私たちは、本アプリの機能その他についての建設的なレビューを心から歓迎します。また、本アプリでできたらよいと思うことがあれば、ぜひ提案してください。

本アプリは、あなたのデバイスに以下の権限を要求します：
オーディオの録音 - オーディオを録音してMoodleへアップロードするため
SDカードの内容の読み取りと変更 - コンテンツをオフラインで閲覧する際に、コンテンツはSDカードにダウンロードされます
ネットワークアクセス - Moodleサイトへ接続できるようにするため、またあなたがサイトへ接続している、あるいはオフラインモードに切り替えていないことを確かめるため
起動時の実行 - アプリがバックグランド動作している間のローカル通知を受信するため
デバイスのスリープ禁止 - いつでもプッシュ通知を受信できるようにするため';
$string['core.cannotconnect'] = '接続できません：正しいURLを入力しているか、サイトのMoodleが{{$a}}以降であることを確認してください。';
$string['core.cannotdownloadfiles'] = 'ダウンロードしようとしているファイルは、あなたのモバイルサービスでは無効になっています。あなたのサイト管理者に連絡してください。';
$string['core.clearsearch'] = '検索のクリア';
$string['core.clicktoseefull'] = 'クリックで全てのコンテンツを見る';
$string['core.confirmcanceledit'] = '本当にこのページを離れますか？　全ての変更が失われます。';
$string['core.confirmloss'] = '本当ですか？　すべての変更が失われます。';
$string['core.confirmopeninbrowser'] = 'これをブラウザで開きますか？';
$string['core.contenteditingsynced'] = '編集中のコンテンツが同期されました。';
$string['core.contentlinks.chooseaccount'] = 'アカウントの選択';
$string['core.contentlinks.chooseaccounttoopenlink'] = 'リンクを開くアカウントを選択してください。';
$string['core.contentlinks.confirmurlothersite'] = 'このリンクは別のサイトに属しています。本当に開きますか？';
$string['core.contentlinks.errornoactions'] = 'このリンクを実行するためのアクションが見つかりませんでした。';
$string['core.contentlinks.errornosites'] = 'このリンクをもつサイトが見つかりませんでした。';
$string['core.copiedtoclipboard'] = 'クリップボードにコピーされたテキスト';
$string['core.course.allsections'] = '全てのセクション';
$string['core.course.contents'] = 'コンテンツ';
$string['core.currentdevice'] = '現在のデバイス';
$string['core.datastoredoffline'] = '送信できなかったため、データはデバイスに保存されました。後で自動的に送信されます。';
$string['core.deleting'] = '消去中';
$string['core.dfdaymonthyear'] = 'YYYY/MM/DD';
$string['core.dfdayweekmonth'] = 'MMM月D日（ddd）';
$string['core.dffulldate'] = 'YYYY年MMMM月D日（dddd） h[:]mm A';
$string['core.dflastweekdate'] = 'ddd';
$string['core.dfmediumdate'] = 'LLL';
$string['core.dftimedate'] = 'h[:]mm A';
$string['core.discard'] = '無視';
$string['core.dismiss'] = '取消';
$string['core.downloading'] = 'ダウンロード中';
$string['core.emptysplit'] = '左パネルが空またはロード中のため本ページは空白';
$string['core.errorchangecompletion'] = '完了状態の変更中にエラーが発生しました。再度実行してください。';
$string['core.errordeletefile'] = 'ファイル消去中にエラーが発生しました。再度実行してください。';
$string['core.errordownloading'] = 'ファイルダウンロードのエラー';
$string['core.errordownloadingsomefiles'] = 'モジュールファイルのダウンロード中にエラーが発生しました。欠落しているファイルがあるかもしれません。';
$string['core.errorfileexistssamename'] = '同じ名前のファイルがあります。';
$string['core.errorinvalidform'] = 'フォームに不正なデータが含まれています。必須フィールドすべてが記入され、データが正しいことを確認してください。';
$string['core.errorinvalidresponse'] = '不正な返信を受信しました。エラーが連続する場合、あなたのMoodleサイト管理者に連絡をとってください。';
$string['core.errorloadingcontent'] = 'コンテンツのロード中にエラーが発生しました。';
$string['core.erroropenfilenoapp'] = 'ファイルを開く際にエラーが発生しました。この種のファイルを開くアプリが見つかりません。';
$string['core.erroropenfilenoextension'] = 'ファイルを開く際にエラーが発生しました。ファイルに拡張子がありません。';
$string['core.erroropenpopup'] = 'このアクティビティはポップアップを開こうとしています。本アプリではサポートされていません。';
$string['core.errorrenamefile'] = 'ファイル名変更でエラーが発生しました。再度実行してください。';
$string['core.errorsync'] = '同期中にエラーが発生しました。再度実行してください。';
$string['core.errorsyncblocked'] = '実行中のプロセスがあったため、この {{$a}} はすぐに同期できませんでした。再度実行してください。問題が継続する場合、アプリを再起動してください。';
$string['core.filenameexist'] = 'ファイル名がすでに存在しています：{{$a}}';
$string['core.fileuploader.confirmuploadfile'] = '{$a}をアップロードしようとしています。続けますか？';
$string['core.fileuploader.errorcapturingaudio'] = '音声キャプチャーのエラー';
$string['core.fileuploader.errorcapturingvideo'] = 'ビデオキャプチャーのエラー';
$string['core.fileuploader.errorreadingfile'] = 'ファイル"{$a}"の読み取りエラー';
$string['core.fileuploader.file'] = 'ファイル';
$string['core.fileuploader.fileuploaded'] = 'アップロードしたファイル';
$string['core.fileuploader.readingfile'] = 'ファイル読み取り';
$string['core.fileuploader.uploading'] = 'アップロード中';
$string['core.fileuploader.video'] = 'ビデオ';
$string['core.fullnameandsitename'] = '{{fullname}} ({{sitename}})';
$string['core.hasdatatosync'] = 'この {{$a}} には同期すべきオフラインデータがあります。';
$string['core.humanreadablesize'] = '{{size}} {{unit}}';
$string['core.image'] = '画像';
$string['core.imageviewer'] = '画像ビューア';
$string['core.lastsync'] = '最後の同期';
$string['core.loadmore'] = '続きを読み込む';
$string['core.login.authenticating'] = '認証中';
$string['core.login.invalidaccount'] = 'あなたがログインするのに必要な情報を再確認し、サイト管理者にサイトの設定と合致しているか確認するよう依頼してください。';
$string['core.login.invalidmoodleversion'] = '<p>無効なMoodleサイトバージョンです。MoodleアプリはMoodleシステム {{$a}} 以降のみサポートします。</p>
<p>あなたのサイト管理者に連絡してMoodleシステムの更新を依頼できます。</p>
<p>「サイト管理者」はあなたの学校/大学/法人または教育機関でMoodleを管理する人です。サイト管理者への連絡方法が分からない場合、あなたの教師/指導者にご連絡ください。</p>';
$string['core.login.invalidsite'] = 'サイトURLが正しくありません。';
$string['core.login.loginbutton'] = 'ログイン';
$string['core.login.logininsiterequired'] = 'ブラウザウインドウからサイトにログインする必要があります。';
$string['core.login.mobileservicesnotenabled'] = 'あなたのサイトではモバイルサービスが有効になっていません。モバイルアクセスが必要と思うなら、あなたのMoodleサイト管理者にその相談をしてください。';
$string['core.login.passwordrequired'] = 'パスワードがありません';
$string['core.login.siteinmaintenance'] = 'このサイトはメンテナンス中です';
$string['core.login.siteurl'] = 'サイトURL';
$string['core.login.siteurlrequired'] = 'サイトURLがありません。書き方は、例えば次の通りです：<i>http://www.yourmoodlesite.abc あるいは https://www.yourmoodlesite.efg</i>';
$string['core.login.usernamerequired'] = 'ユーザー名がありません';
$string['core.login.webservicesnotenabled'] = 'あなたのサイトでWebサービスが有効になっていません。モバイルアクセスが必要と思うなら、あなたのMoodleサイト管理者に相談してください。';
$string['core.lostconnection'] = 'あなたのトークンが無効になったため、再接続に必要な情報がサーバにはありません。';
$string['core.mainmenu.website'] = 'ウェブサイト';
$string['core.networkerrormsg'] = 'ネットワークが無効もしくは機能していません';
$string['core.nopasswordchangeforced'] = 'パスワードを変更するまで続きを実行できません。';
$string['core.notapplicable'] = 'なし';
$string['core.notsent'] = '未送信';
$string['core.openfullimage'] = 'クリックしてフルサイズの画像を表示';
$string['core.openinbrowser'] = 'ブラウザで開く';
$string['core.percentagenumber'] = '{{$a}}%';
$string['core.pulltorefresh'] = '引いて更新';
$string['core.question.howtodraganddrop'] = '選んだものをタッチして、あてはまる所にタッチして入れましょう。';
$string['core.question.questionmessage'] = '問題 {{$a}}: {{$b}}';
$string['core.redirectingtosite'] = 'サイトにリダイレクトされます。';
$string['core.requireduserdatamissing'] = 'このユーザは必須のプロフィールデータが欠けています。Moodleでデータを補い、再度開いてください。<br>{{$a}}';
$string['core.retry'] = '再実行';
$string['core.searching'] = '検索中';
$string['core.settings.about'] = '本アプリについて';
$string['core.settings.deletesitefiles'] = '本当にこのサイトからダウンロードしたファイルを消去しますか？';
$string['core.settings.estimatedfreespace'] = '概算の空き容量';
$string['core.settings.spaceusage'] = '保存領域使用量';
$string['core.settings.synchronization'] = '同期';
$string['core.sizetb'] = 'TB';
$string['core.sorry'] = 'すみません...';
$string['core.tablet'] = 'タブレット';
$string['core.thereisdatatosync'] = '同期が必要なオフライン {{$a}} があります。';
$string['core.tryagain'] = '再実行';
$string['core.twoparagraphs'] = '{{p1}}<br><br>{{p2}}';
$string['core.uhoh'] = 'おおっと!';
$string['core.unexpectederror'] = '不明なエラー。アプリを閉じて再起動してみてください。';
$string['core.unicodenotsupported'] = '本サイトでは一部の絵文字がサポートされていません。それらは送信されたメッセージから削除されます。';
$string['core.unicodenotsupportedcleanerror'] = 'Unicode文字をクリアする際に空のテキストがありました。';
$string['core.unknown'] = '不明な';
$string['core.unzipping'] = '未展開の';
$string['core.user.contact'] = 'コンタクト';
$string['core.whoops'] = 'しまった！';
$string['pluginname'] = 'Moodle Mobile言語文字列';
