<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'hvp', language 'ja', version '3.5'.
 *
 * @package     hvp
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = '操作';
$string['addednewlibraries'] = '新しい {$a->%new} 個のH5Pライブラリが追加されました。';
$string['addlibraries'] = 'ライブラリを追加';
$string['ajaxfailed'] = 'データの読み込みに失敗しました。';
$string['attribution'] = '表示 4.0';
$string['attributionnc'] = '表示 - 非営利 4.0';
$string['attributionncnd'] = '表示 - 改変禁止 - 非営利  4.0';
$string['attributionncsa'] = '表示 - 非営利 - 継承 4.0';
$string['attributionnd'] = '表示 - 改変禁止 4.0';
$string['attributionsa'] = '表示 - 継承 4.0';
$string['author'] = '作者';
$string['cancellabel'] = 'キャンセル';
$string['close'] = '閉じる';
$string['confirmdialogbody'] = '本当に続けても良ろしいですか? この操作は取り消せません。';
$string['confirmdialogheader'] = '操作の確認';
$string['confirmlabel'] = '確認';
$string['contentchanged'] = 'このコンテンツは、最後に使用してから変更されています。';
$string['contentstatefrequency'] = 'コンテンツの状態を保存する頻度';
$string['contentstatefrequency_help'] = '何秒ほどの間隔でユーザの進捗を自動保存させますか。もしajaxの要求が多すぎて問題があるのであれば、この数値を増やしてください。';
$string['contenttypecacheheader'] = 'コンテンツタイプキャッシュ';
$string['copyright'] = '著作権';
$string['copyrightinfo'] = '著作権情報';
$string['copyrightstring'] = '著作権';
$string['copyrighttitle'] = 'このコンテンツの著作権情報をみる。';
$string['couldnotcopy'] = 'ファイルをコピーできませんでした。';
$string['couldnotsave'] = 'ファイルを保存できませんでした。';
$string['create'] = '作成';
$string['ctcachebuttonlabel'] = 'コンテンツタイプのキャッシュを更新';
$string['ctcacheconnectionfailed'] = 'H5Pハブと通信できませんでした。後でもう一度お試しください。';
$string['ctcachedescription'] = 'コンテンツタイプのキャッシュが最新であることを確認することで、最新のライブラリを表示、ダウンロード、使用できるようになります。これは、ライブラリ自体の更新とは異なります。';
$string['ctcachelastupdatelabel'] = '最後の更新';
$string['ctcacheneverupdated'] = '未更新';
$string['ctcachenolibraries'] = 'H5Pハブから受信したコンテンツタイプはありません。後でもう一度お試しください。';
$string['ctcachesuccess'] = 'ライブラリキャッシュが正常に更新されました。';
$string['ctcachetaskname'] = 'コンテンツタイプのキャッシュを更新';
$string['currentpage'] = '$current ページ,  全 $total ページ中';
$string['disablefileextensioncheck'] = 'ファイル拡張子のチェックを無効にする';
$string['disablefileextensioncheckwarning'] = '警告! ファイル拡張子のチェックを無効にすると、phpファイルのアップロードを許可するセキュリティ上の影響があります。 その結果、攻撃者があなたのサイト上で悪意のあるコードを実行することが可能になります。 あなたがアップロードするものが何かを確実に確認するよう心がけてください。';
$string['disablefullscreen'] = 'フルスクリーンを無効にする';
$string['disablehubconfirmationmsg'] = 'ハブを有効にしたいですか？';
$string['disablehubdescription'] = 'このオプションを有効にしておくことを強くお勧めします。 H5Pハブは、新しいコンテンツタイプを取得し、既存のコンテンツタイプを最新の状態に保つための簡単なインターフェイスを提供します。将来的には、コンテンツの共有や再利用も容易になります。このオプションを無効にすると、ファイルアップロードフォームを通じてコンテンツタイプをインストールして更新する必要があります。';
$string['displayoptionalwaysshow'] = '常に表示';
$string['displayoptionauthoroff'] = '作者により操作される, デフォルトはoff';
$string['displayoptionauthoron'] = '作者により操作される, デフォルトはon';
$string['displayoptionnevershow'] = '常に非表示';
$string['displayoptionpermissions'] = 'ユーザがH5Pのエクスポートを許可した場合にのみ表示';
$string['displayoptions'] = '表示オプション';
$string['download'] = 'ダウンロード';
$string['downloadfailed'] = '要求されたライブラリのダウンロードに失敗しました。';
$string['downloadtitle'] = 'このコンテンツをH5Pファイルとしてダウンロード。';
$string['editor'] = 'エディタ';
$string['embed'] = '埋め込み';
$string['embedtitle'] = 'このコンテンツの埋め込みコードをみる。';
$string['empty'] = '結果がありません';
$string['enableabout'] = 'H5Pボタンについて';
$string['enablecopyright'] = '著作権ボタン';
$string['enabledlrscontenttypes'] = 'LRSに依存するコンテンツタイプを有効にする';
$string['enabledlrscontenttypes_help'] = 'アンケート(Questionnaire）コンテンツタイプのように、Learning Record Storeの機能に正しく依存するコンテンツタイプを利用可能にする。';
$string['enabledownload'] = 'ダウンロードボタン';
$string['enableembed'] = '埋め込みボタン';
$string['enableframe'] = '操作バーと枠を表示';
$string['enablehublabel'] = 'H5Pハブを使用する';
$string['enablejavascript'] = 'javascriptを有効にしてください。';
$string['enablesavecontentstate'] = 'コンテンツの状態を保存';
$string['enablesavecontentstate_help'] = 'それぞれのユーザのインタラクティブコンテンツの、現在のコンテンツの状態を自動的に保存します。 これによりユーザは中断したところから再開できます。';
$string['failedtodownloadh5p'] = '要求されたH5Pをダウンロードできませんでした。';
$string['filenotfoundonserver'] = 'サーバ上にファイルが見つかりません。ファイルのアップロード設定を確認してください。';
$string['filenotimage'] = 'ファイルは画像ではありません。';
$string['filetypenotallowed'] = 'ファイルタイプが許可されていません。';
$string['finished'] = '完了';
$string['fullscreen'] = 'フルスクリーン';
$string['gpl'] = '一般公衆利用許諾書 v3';
$string['h5pfile'] = 'H5Pファイル';
$string['h5ptitle'] = 'よりクールなコンテンツをみつけるためにH5P.orgにアクセスする。';
$string['hide'] = '隠す';
$string['hideadvanced'] = '拡張要素を隠す';
$string['hubcommunicationdisabled'] = '1つ以上のH5P要件が失敗したため、H5Pハブ通信が無効になっています。';
$string['hubisdisabled'] = 'ハブは無効です。 H5Pの設定で再度有効にすることができます。';
$string['hubisdisableduploadlibraries'] = 'この問題が解決されるまで、H5Pハブは無効になっています。 "H5P ライブラリ"ページからライブラリをアップロードすることができます。';
$string['hubsettingsheader'] = 'コンテンツタイプ';
$string['hvp:addinstance'] = '新しいH5P活動を追加';
$string['hvp:getcachedassets'] = 'キャシュされたH5Pコンテンツアセットを取得';
$string['hvp:getexport'] = 'コース内のH5Pから出力ファイルを取得';
$string['hvp:installrecommendedh5plibraries'] = '推奨されるH5Pライブラリをインストール';
$string['hvp:restrictlibraries'] = 'H5Pライブラリを制限';
$string['hvp:savecontentuserdata'] = 'H5Pコンテンツのユーザデータを保存';
$string['hvp:saveresults'] = 'H5Pコンテンツの結果を保存';
$string['hvp:updatelibraries'] = 'H5Pライブラリのバージョンを更新';
$string['hvp:userestrictedlibraries'] = '制限されたH5Pライブラリを使用';
$string['hvp:viewresults'] = 'H5Pコンテンツの結果を表示';
$string['installdenied'] = 'コンテンツタイプをインストールする権限がありません。サイトの管理者に連絡してください。';
$string['installedlibraries'] = 'インストールされたライブラリ';
$string['intro'] = '説明';
$string['invalidaudioformat'] = '無効なオーディオファイル形式です。 mp3またはwavを使用してください。';
$string['invalidcontentfolder'] = '無効なコンテンツフォルダ';
$string['invalidcontenttype'] = '選択したコンテンツタイプは無効です。';
$string['invalidfieldtype'] = '無効なフィールドタイプ';
$string['invalidfile'] = 'ファイル "{$a->%filename}" は許可されていません。以下の拡張子のファイルのみ許可されています: {$a->%files-allowed} 。';
$string['invalidh5ppost'] = '投稿されたH5Pを取得できませんでした。';
$string['invalidimageformat'] = '無効な画像ファイル形式です。 jpg, pngまたはgifを使用してください。';
$string['invalidlanguagefile'] = 'ライブラリ {$a->%library} 内の無効な言語ファイル {$a->%file}';
$string['invalidlanguagefile2'] = '無効な言語ファイル {$a->%languageFile} が、ライブラリ {$a->%name} に含まれています。';
$string['invalidlibrary'] = '無効なライブラリ';
$string['invalidlibrarydata'] = '{$a->%library} 内の {$a->%property} 用に提供された無効なデータ';
$string['invalidlibrarydataboolean'] = '{$a->%library} 内の {$a->%property} 用に提供された無効なデータ。 ブーリアンである必要があります。';
$string['invalidlibraryname'] = '無効なライブラリ名: {$a->%name}';
$string['invalidlibraryoption'] = '{$a->%library} 内の不正なオプション {$a->%option}';
$string['invalidlibraryproperty'] = '{$a->%library} 内のプロパティ {$a->%property} が読み取りできません。';
$string['invalidmainjson'] = '有効なメインのh5p.jsonファイルがありません';
$string['invalidmultiselectoption'] = '多肢選択での無効な選択オプションです。';
$string['invalidparameters'] = '無効なパラメータ';
$string['invalidselectoption'] = '選択中の無効な選択オプション。';
$string['invalidsemanticsjson'] = '無効なsemantics.jsonファイルがライブラリ {$a->%name} に含まれています。';
$string['invalidsemanticstype'] = 'H5P 内部エラー: セマンティックス内の不明なコンテンツタイプ "{$a->@type}" 。 コンテンツを削除中!';
$string['invalidstring'] = '与えられた文字列はセマンティックス内の正規表現に照らして有効ではありません: (値: "{$a->%value}", 正規表現: "{$a->%regexp}")';
$string['invalidtoken'] = '無効なセキュリティトークン。';
$string['invalidvideoformat'] = '無効なビデオファイル形式です。 mp4またはwebmを使用してください。';
$string['javascriptloading'] = 'JavaScriptを待っています...';
$string['libraries'] = 'H5Pライブラリ';
$string['librarydirectoryerror'] = 'ライブラリのディレクトリ名は machineName または machineName-majorVersion.minorVersion (library.jsonから)に一致しなければなりません。 (Directory: {$a->%directoryName} , machineName: {$a->%machineName}, majorVersion: {$a->%majorVersion}, minorVersion: {$a->%minorVersion})';
$string['librarylistactions'] = '操作';
$string['librarylistinstancedependencies'] = 'インスタンス依存';
$string['librarylistinstances'] = 'インスタンス';
$string['librarylistlibrarydependencies'] = 'ライブラリ依存';
$string['librarylistrestricted'] = '制限付き';
$string['librarylisttitle'] = 'タイトル';
$string['license'] = 'ライセンス';
$string['loadingdata'] = 'データの読み込み中。';
$string['lookforupdates'] = 'H5Pアップデートを探す';
$string['maximumgrade'] = '最大評点';
$string['maximumgradeerror'] = 'この活動用に用いられる最大評点として、有効な正の整数を入力してください。';
$string['maxpostsizetoosmall'] = 'あなたのPHPのmax post sizeは非常に小さいです。現在の設定では、{$a->%number} MBを超えるファイルはアップロードできません。これは、H5P、画像、動画をアップロードしようとすると問題になる可能性があります。5MB以上に増やすことを検討してください。';
$string['maxscore'] = '最大評点';
$string['maxuploadsizetoosmall'] = 'あなたのPHPのmax upload sizeは非常に小さいです。現在の設定では、{$a->%number} MBを超えるファイルはアップロードできません。これは、H5P、画像、動画をアップロードしようとすると問題になる可能性があります。5MB以上に増やすことを検討してください。';
$string['missingcontentfolder'] = '有効なコンテンツのフォルダがありません。';
$string['missingcontentuserdata'] = 'エラー: コンテンツのユーザデータが見つかりません';
$string['missingcoreversion'] = 'システムは <em>{$a->%component}</em> コンポーネントをパッケージからインストールできませんでした。 新しいバージョンのH5Pプラグラインが必要です。 このサイトは現在バージョン {$a->%current} が動作中です。 一方、必要なバージョンは {$a->%required} 以上です。 アップグレードし、再度お試しください。';
$string['missingdependency'] = '{$a->@lib} に必要な依存 {$a->@dep} が不足。';
$string['missinglibrary'] = '必要なライブラリ {$a->@library} が不足';
$string['missinglibraryfile'] = 'ライブラリ: "{$a->%name}" でファイル"{$a->%file}"が不足';
$string['missinglibraryjson'] = 'ライブラリ {$a->%name} 用の有効なjsonフォーマットのlibrary.json ファイルが見つかりませんでした';
$string['missinglibraryproperty'] = '必要なプロパティプロパティ {$a->%property} が {$a->%library}にありません';
$string['missingmbstring'] = 'mbstring PHP拡張が読み込めません。H5Pはこれが正しく機能する必要があります。';
$string['missingparameters'] = 'パラメータ不足';
$string['missinguploadpermissions'] = 'アップロードしたファイル内にライブラリが存在していることに注意してください。';
$string['modulename'] = 'インタラクティブコンテンツ';
$string['modulename_help'] = 'H5P活動モジュールでは、インタラクティブビデオ, 問題集, ドラッグ＆ドロップの問題, 多肢選択の問題, プレゼンテーションなどの、インタラクティブなコンテンツを作成することが可能です。

さらに、リッチコンテンツの編集ツールとして、H5Pファイルをインポートしたりエクスポートしたりして、コンテンツの効果的な再利用と共有を可能にします。

ユーザのインタラクションと点数はxAPIをつかって追跡され、Moodleの評定表を通して利用可能です。

.h5pファイルをアップロードすることでインタラクティブなH5Pコンテンツを 追加することができます。 h5p.orgのサイト上で作成して .h5pファイルをダウンロードすることができます。';
$string['modulenameplural'] = 'インタラクティブコンテンツ';
$string['nextpage'] = '次のページ';
$string['nocontent'] = 'content.jsonファイルを見つけたり解析したりできませんでした';
$string['nocontenttype'] = 'コンテンツタイプが指定されていません。';
$string['nocopyright'] = 'このコンテンツの著作権情報がありません。';
$string['nodata'] = 'あなたのクライテリアに一致するデータがありません。';
$string['noextension'] = 'あなたがアップロードしたファイルは有効なHTML5パッケージではありません（.h5pファイル拡張子がありません）';
$string['noh5ps'] = 'このコースにはインタラクティブコンテンツがありません。';
$string['nojson'] = 'メインのh5p.jsonファイルが有効ではありません';
$string['noparameters'] = 'パラメータがありません';
$string['noparse'] = 'メインのh5p.jsonファイルを解析できませんでした。';
$string['nopermissiontorestrict'] = 'あなたにはライブラリを制限するパーミッションがありません。';
$string['nopermissiontosavecontentuserdata'] = 'あなたにはコンテンツのユーザデータを保存するパーミッションがありません。';
$string['nopermissiontosaveresult'] = 'あなたにはこのコンテンツの結果を保存するパーミッションがありません。';
$string['nopermissiontoupgrade'] = 'あなたにはライブラリをアップグレードするパーミッションがありません。';
$string['nopermissiontoviewresult'] = 'あなたにはこのコンテンツの結果を見るパーミッションがありません。';
$string['nosuchlibrary'] = 'そのようなライブラリはありません';
$string['notapplicable'] = 'N/A';
$string['nounzip'] = 'あなたがアップロードしたファイルは有効なHTML5パッケージではありません（ZIPファイルを解凍できません）';
$string['nowriteaccess'] = 'サーバ書き込みアクセスの問題が検出されました。あなたのサーバがあなたのデータフォルダに書き込むことができることを確認してください。';
$string['noziparchive'] = 'あなたのPHP のバージョンでは、Zipアーカイブをサポートしていません。';
$string['oldphpversion'] = 'あなたのPHPバージョンは古くなっています。 H5Pでは、バージョン5.2が正しく機能することが必要です。バージョン5.6以降が推奨されます。';
$string['onlyupdate'] = '既存のライブラリのみを更新';
$string['options'] = 'オプション';
$string['pd'] = 'パブリックドメイン';
$string['pddl'] = 'Public Domain Dedication and Licence';
$string['pdm'] = 'パブリックドメインマーク';
$string['pluginadministration'] = 'H5P';
$string['pluginname'] = 'H5P';
$string['postmessagerequired'] = '指定されたエンドポイントにアクセスするには投稿メッセージが必要です';
$string['previouspage'] = '前のページ';
$string['removeoldlogentries'] = '古いH5Pのログエントリを削除';
$string['removetmpfiles'] = '古いH5Pの一時ファイルを削除';
$string['resizescript'] = 'もし、埋め込みコンテンツに対して、動的なサイズ変更をしたい場合には、あなたのウェブサイト上にこのスクリプトを含めてください:';
$string['reveal'] = '公開';
$string['reviseserversetupandretry'] = 'サーバの設定を変更したら、H5Pの設定でH5Pハブ通信を再度有効にすることができます。';
$string['score'] = '点数';
$string['search'] = '検索';
$string['sendusagestatistics'] = '使用統計に貢献する';
$string['sendusagestatistics_help'] = '使用統計値は自動的に報告され、開発者がH5Pの使用方法をよりよく理解し、潜在的な改善領域を特定するのに役立ちます。';
$string['settings'] = 'H5P設定';
$string['showadvanced'] = '拡張要素を表示する';
$string['sitecouldnotberegistered'] = 'サイトをハブに登録できませんでした。サイト管理者に連絡してください。';
$string['sitekey'] = 'サイトキー';
$string['sitekeydescription'] = 'サイトキーは、このサイトをハブで一意に識別する秘密です。';
$string['sitekeyregistered'] = '新しい更新を受け取ったときに、ハブであなたを識別させるユニークなキーが提供されています。キーは「H5P設定」ページで表示できます。';
$string['size'] = 'サイズ';
$string['source'] = 'ソース';
$string['sslnotenabled'] = 'サーバでSSLが有効になっていません。 SSLを有効にして、H5Pハブとの安全な接続を確保する必要があります。';
$string['startingover'] = '最初からやり直す。';
$string['successfullyregisteredwithhub'] = 'サイトがH5Pハブに登録されました。';
$string['thumbnail'] = 'サムネール';
$string['title'] = 'タイトル';
$string['unabletocreatedir'] = 'ディレクトリの作成ができません。';
$string['unabletogetfieldtype'] = 'フィールドタイプが取得できません。';
$string['undisclosed'] = '未公開';
$string['updatedlibraries'] = '{$a->%old} H5P ライブラリが更新されました。';
$string['updatelibraries'] = 'すべてのライブラリが更新されました。';
$string['upgrade'] = 'H5Pをアップグレード';
$string['upgradebuttonlabel'] = 'アップグレード';
$string['upgradedone'] = '{$a} 個のコンテンツインスタンスのアップグレードに成功しました。';
$string['upgradeerror'] = 'パラメータを処理中にエラーが発生しました:';
$string['upgradeerrorcontent'] = 'コンテンツ %id をアップグレードできませんでした。:';
$string['upgradeerrordata'] = 'ライブラリ %lib のデータを読み込めませんでした。';
$string['upgradeerrorparamsbroken'] = 'パラメータが壊れています。';
$string['upgradeerrorscript'] = '%lib 用のアップグレードスクリプトを読み込めませんでした。';
$string['upgradeheading'] = '{$a} 個のコンテンツをアップグレード';
$string['upgradeinprogress'] = '%ver にアップグレード中...';
$string['upgradeinvalidtoken'] = 'エラー: 無効なセキュリティトークン!';
$string['upgradelibrarycontent'] = 'ライブラリコンテンツをアップグレード';
$string['upgradelibrarymissing'] = 'エラー: あなたのライブラリがありません!';
$string['upgrademessage'] = '{$a} 個のコンテンツインスタンスをアップグレードしようとしています。 アップグレードのバージョンを選択してください。';
$string['upgradenoavailableupgrades'] = 'このライブラリ用のアップグレードがありません。';
$string['upgradenothingtodo'] = 'アップグレードするコンテンツインスタンスがありません。';
$string['upgradereturn'] = '戻る';
$string['upload'] = 'アップロード';
$string['uploadlibraries'] = 'ライブラリをアップロード';
$string['uploadsizelargerthanpostsize'] = 'PHPのmax upload size が max post sizeを超えています。これは、一部のインストールで問題を引き起こすことが知られています。';
$string['user'] = 'ユーザ';
$string['validatingh5pfailed'] = 'h5pパッケージの検証に失敗しました';
$string['validationfailed'] = '要求されたH5Pが有効ではありませんでした';
$string['welcomecommunity'] = 'H5Pをお楽しみいただき、<a {$a->forums}>フォーラム</a> やチャットルーム <a {$a->gitter}>H5P at Gitter</a> を通して、成長を続けるコミュニティに寄与されることを願っています。';
$string['welcomecontactus'] = '何かフィードバックがありましたら、お気軽に <a {$a}>お問い合わせください</a>。私たちはフィードバックを非常に真剣に受け止め、毎日H5Pをより良くすることに専念しています!';
$string['welcomegettingstarted'] = 'H5PとMoodleを使い始めるには、 <a {$a->moodle_tutorial}>チュートリアル</a> をご覧ください。そして、インスピレーションを得るために H5P.orgの <a {$a->example_content}>コンテンツ例</a> をご覧ください。 <br> 人気のあるコンテンツタイプを簡単にインストールすることができます。';
$string['welcomeheader'] = 'H5Pの正解へようこそ!';
$string['wrongversion'] = 'このコンテンツで使用されているH5Pライブラリ  {$a->%machineName}  のバージョンは無効です。コンテンツには {$a->%contentLibrary} が含まれていますが、 {$a->%semanticsLibrary} である必要があります。';
$string['year'] = '年';
$string['years'] = '年(間)';
