<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_moodlemobileapp', language 'pt_br', version '3.5'.
 *
 * @package     local_moodlemobileapp
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addon.blog.errorloadentries'] = 'Erro ao carregar registros do blog';
$string['addon.blog.showonlyyourentries'] = 'Mostrar somente seus registros';
$string['addon.calendar.calendarevents'] = 'Eventos do calendário';
$string['addon.calendar.calendarreminders'] = 'Lembretes do calendário';
$string['addon.calendar.defaultnotificationtime'] = 'Tempo padrão de notificação';
$string['addon.calendar.errorloadevent'] = 'Erro ao carregar evento.';
$string['addon.calendar.errorloadevents'] = 'Erro ao carregar eventos.';
$string['addon.calendar.noevents'] = 'Sem eventos';
$string['addon.calendar.reminders'] = 'Lembretes';
$string['addon.calendar.setnewreminder'] = 'Definir um novo lembrete';
$string['addon.competency.errornocompetenciesfound'] = 'Nenhuma competência encontrada';
$string['addon.competency.nocompetencies'] = 'Nenhuma competência';
$string['addon.coursecompletion.complete'] = 'Concluído';
$string['addon.coursecompletion.couldnotloadreport'] = 'Não foi possível carregar o relatório de conclusão do curso, por favor tente novamente mais tarde.';
$string['addon.files.couldnotloadfiles'] = 'A lista de arquivos não pode ser carregada.';
$string['addon.files.emptyfilelist'] = 'Não há arquivos para mostrar.';
$string['addon.files.erroruploadnotworking'] = 'Infelizmente é impossível enviar arquivos para o seu site.';
$string['addon.messageoutput_airnotifier.processorsettingsdesc'] = 'Configurar dispositivos';
$string['addon.messages.contactlistempty'] = 'A lista de contatos está vaiza';
$string['addon.messages.contactname'] = 'Nome do contato';
$string['addon.messages.deletemessage'] = 'Excluir mensagem';
$string['addon.messages.deletemessageconfirmation'] = 'Você tem certeza que quer excluir esta mensagem? Ela será excluída somente do seu histórico de mensagens, mas ainda poderá ser visualizada pelo usuário que enviou ou recebeu a mensagem.';
$string['addon.messages.errordeletemessage'] = 'Erro enquanto excluía a mensagem.';
$string['addon.messages.errorwhileretrievingcontacts'] = 'Erro ao recuperar contatos a partir do servidor.';
$string['addon.messages.errorwhileretrievingdiscussions'] = 'Erro ao recuperar discussão do servidor.';
$string['addon.messages.errorwhileretrievingmessages'] = 'Erro ao recuperar as mensagens do servidor.';
$string['addon.messages.errorwhileretrievingusers'] = 'Erro ao recuperar usuários do servidor.';
$string['addon.messages.messagenotsent'] = 'A mensagem não foi enviada. Por favor tente novamente mais tarde.';
$string['addon.messages.newmessages'] = 'Novas mensagens';
$string['addon.messages.nousersfound'] = 'Nenhum usuário encontrado';
$string['addon.messages.showdeletemessages'] = 'Mostrar as mensagens excluídas';
$string['addon.messages.type_blocked'] = 'Bloqueado';
$string['addon.messages.type_offline'] = 'Offline';
$string['addon.messages.type_online'] = 'Online';
$string['addon.messages.type_search'] = 'Resultados de busca';
$string['addon.messages.type_strangers'] = 'Outros';
$string['addon.messages.useentertosenddescdesktop'] = 'Se desabilitado, Você pode utilizar Ctrl+Enter para enviar a mensagem.';
$string['addon.messages.useentertosenddescmac'] = 'Se desabilitado, Você pode utilizar Command+Enter para enviar a mensagem.';
$string['addon.messages.warningconversationmessagenotsent'] = 'Não foi possível enviar as mensagens para a conversa {{conversation}}. {{erro}}';
$string['addon.messages.warningmessagenotsent'] = 'Não pode enviar mensagem(s) para o usuário {{user}}. {{error}}';
$string['addon.mod_assign.acceptsubmissionstatement'] = 'Por favor aceite a declaração do envio.';
$string['addon.mod_assign.cannoteditduetostatementsubmission'] = 'Você não pode adicionar ou editar um envio no aplicativo porque nós não conseguimos receber a declaração de envio do site.';
$string['addon.mod_assign.cannotgradefromapp'] = 'Alguns métodos de avaliação ainda não são suportadas pelo aplicativo e não podem ser modificadas.';
$string['addon.mod_assign.cannotsubmitduetostatementsubmission'] = 'Você não pode enviar para avaliação pelo aplicativo porque nós não conseguimos receber a declaração de envio do site.';
$string['addon.mod_assign.erroreditpluginsnotsupported'] = 'Você não pode adicionar ou editar um envio no aplicativo por causa que alguns plugins não são suportados para edição:';
$string['addon.mod_assign.errorshowinginformation'] = 'Nós não podemos exibir as informações do envio';
$string['addon.mod_assign.feedbacknotsupported'] = 'Esse feedback não é suportado pelo aplicativo e pode não conter todas as informações';
$string['addon.mod_assign.gradenotsynced'] = 'Avaliação não sincronizada';
$string['addon.mod_assign.notallparticipantsareshown'] = 'Participantes sem permissão não são exibidos';
$string['addon.mod_assign.submissionnotsupported'] = 'Esse envio não é suportado pelo aplicativo e pode não conter todas as informações';
$string['addon.mod_assign.userwithid'] = 'Usuário com id {{id}}';
$string['addon.mod_assign.warningsubmissiongrademodified'] = 'A nota do envio foi modificada no site.';
$string['addon.mod_assign.warningsubmissionmodified'] = 'O envio do usuário foi modificado no site.';
$string['addon.mod_chat.errorwhileconnecting'] = 'Erro ao se conectar.';
$string['addon.mod_chat.errorwhilegettingchatdata'] = 'Erro ao se conectar ao chat.';
$string['addon.mod_chat.errorwhilegettingchatusers'] = 'Erro ao obter os usuários de bate-papo.';
$string['addon.mod_chat.errorwhileretrievingmessages'] = 'Erro ao recuperar as mensagens do servidor.';
$string['addon.mod_chat.errorwhilesendingmessage'] = 'Erro ao enviar a mensagem.';
$string['addon.mod_chat.mustbeonlinetosendmessages'] = 'Você deve estar online para enviar mensagens';
$string['addon.mod_chat.nosessionsfound'] = 'Nenhuma sessão encontrada';
$string['addon.mod_chat.showincompletesessions'] = 'Mostrar sessões não concluídas';
$string['addon.mod_choice.errorgetchoice'] = 'Erro ao obter dados do escolha.';
$string['addon.mod_choice.responsesresultgraphdescription'] = '{{number}}% de usuários que escolheram a opção: {{text}}.';
$string['addon.mod_choice.resultsnotsynced'] = 'Sua última resposta deve ser sincronizada antes de ser incluída nos resultados.';
$string['addon.mod_data.errorapproving'] = 'Erro ao aprovar ou desaprovar o registro.';
$string['addon.mod_data.errordeleting'] = 'Erro ao excluir o registro.';
$string['addon.mod_feedback.captchaofflinewarning'] = 'A pesquisa com CAPTCHA não pode ser concluída off-line, se não estiver configurada ou se o servidor estiver inativo.';
$string['addon.mod_feedback.feedback_submitted_offline'] = 'Esta pesquisa foi salva para ser enviada posteriormente.';
$string['addon.mod_folder.emptyfilelist'] = 'Não há arquivos para mostrar';
$string['addon.mod_forum.errorgetforum'] = 'Erro ao buscar dados de fórum.';
$string['addon.mod_forum.errorgetgroups'] = 'Erro ao obter configurações do grupo.';
$string['addon.mod_forum.errorposttoallgroups'] = 'Não foi possível criar nova discussão em todos os grupos.';
$string['addon.mod_forum.forumnodiscussionsyet'] = 'Não existem tópicos neste fórum ainda';
$string['addon.mod_forum.group'] = 'Grupo';
$string['addon.mod_forum.numdiscussions'] = '{{numdiscussions}} discussões';
$string['addon.mod_forum.numreplies'] = '{{numreplies}} respostas';
$string['addon.mod_forum.refreshdiscussions'] = 'Atualizar discussões';
$string['addon.mod_forum.refreshposts'] = 'Atualizar as postagens da discussão';
$string['addon.mod_glossary.browsemode'] = 'Navegar pelos registros';
$string['addon.mod_glossary.byalphabet'] = 'Alfabeticamente';
$string['addon.mod_glossary.byauthor'] = 'Agrupar por autor';
$string['addon.mod_glossary.bycategory'] = 'Agrupar por categoria';
$string['addon.mod_glossary.bynewestfirst'] = 'Os mais novos primeiro';
$string['addon.mod_glossary.byrecentlyupdated'] = 'Recentemente atualizados';
$string['addon.mod_glossary.bysearch'] = 'Pesquisa';
$string['addon.mod_glossary.cannoteditentry'] = 'Não é possível editar o item';
$string['addon.mod_glossary.entriestobesynced'] = 'Itens a serem sincronizados';
$string['addon.mod_glossary.entrypendingapproval'] = 'A entrada está pendente de aprovação.';
$string['addon.mod_glossary.errorloadingentries'] = 'Ocorreu um erro enquanto carregava entradas.';
$string['addon.mod_glossary.errorloadingentry'] = 'Ocorreu um erro enquanto carregava a entrada.';
$string['addon.mod_glossary.errorloadingglossary'] = 'Ocorreu um erro enquanto carregava a entrada.';
$string['addon.mod_glossary.noentriesfound'] = 'Nenhuma entrada foi encontrada';
$string['addon.mod_glossary.searchquery'] = 'Consulta de pesquisa';
$string['addon.mod_imscp.showmoduledescription'] = 'Mostrar descrição';
$string['addon.mod_lesson.errorprefetchrandombranch'] = 'Esta lição contém um salto para uma página de conteúdo aleatória. Não pode ser realizada no aplicativo até que tenha sido iniciada em um navegador da web';
$string['addon.mod_lesson.errorreviewretakenotlast'] = 'Essa tentativa não pode mais ser revisada porque outra tentativa foi finalizada.';
$string['addon.mod_lesson.finishretakeoffline'] = 'Esta tentativa foi finalizada offline.';
$string['addon.mod_lesson.retakefinishedinsync'] = 'Uma tentativa offline foi sincronizada. Você quer revisá-la?';
$string['addon.mod_lesson.retakelabelfull'] = '{{retake}}: {{grade}} {{timestart}} ({{duration}})';
$string['addon.mod_lesson.retakelabelshort'] = '{{retake}}: {{grade}} {{timestart}}';
$string['addon.mod_lesson.warningretakefinished'] = 'A tentativa foi finalizada no site.';
$string['addon.mod_lti.errorgetlti'] = 'Erro ao obter os dados do módulo.';
$string['addon.mod_lti.errorinvalidlaunchurl'] = 'O URL de início não é válido.';
$string['addon.mod_lti.launchactivity'] = 'Iniciar a atividade';
$string['addon.mod_page.errorwhileloadingthepage'] = 'Erro ao carregar o conteúdo da página.';
$string['addon.mod_quiz.cannotsubmitquizdueto'] = 'A tentativa do questionário não pode ser enviada pelas seguintes razões:';
$string['addon.mod_quiz.confirmcontinueoffline'] = 'A tentativa não foi sincronizada desde {{$a}}. Se você continuou essa tentativa em outro dispositivo desde então, você poderá perder dados.';
$string['addon.mod_quiz.confirmleavequizonerror'] = 'Ocorreu um erro ao salvar as respostas. Você tem certeza que quer sair do questionário?';
$string['addon.mod_quiz.errorbehaviournotsupported'] = 'Esse questionário não pode ser realizado no aplicativo porque o funcionamento da questão não é suportado pelo aplicativo:';
$string['addon.mod_quiz.errordownloading'] = 'Erro ao baixar dados necessários.';
$string['addon.mod_quiz.errorgetattempt'] = 'Erro ao receber dados da tentativa.';
$string['addon.mod_quiz.errorgetquestions'] = 'Erro ao receber as questões.';
$string['addon.mod_quiz.errorgetquiz'] = 'Erro ao receber dados do questionário.';
$string['addon.mod_quiz.errorparsequestions'] = 'Um erro aconteceu enquanto ocorria a leitura das questões. Por favor, tente fazer esse questionário no navegador web.';
$string['addon.mod_quiz.errorquestionsnotsupported'] = 'Esse questionário não pode ser tentado no aplicativo porque possui questões que não são suportadas pelo aplicativo:';
$string['addon.mod_quiz.errorrulesnotsupported'] = 'Esse questionário não pode ser tentado no aplicativo porque possui regras de acessos não suportadas pelo aplicativo:';
$string['addon.mod_quiz.errorsaveattempt'] = 'Aconteceu um erro ao salvar os dados da tentativa.';
$string['addon.mod_quiz.finishnotsynced'] = 'Finalizado, mas não sincronizado';
$string['addon.mod_quiz.opentoc'] = 'Abrir dicas de navegação.';
$string['addon.mod_quiz.warningattemptfinished'] = 'A tentativa offline foi descartada pois já foi finalizada no site ou não foi encontrada.';
$string['addon.mod_quiz.warningdatadiscarded'] = 'Algumas respostas offline foram descartadas por que as questões foram modificadas online.';
$string['addon.mod_quiz.warningdatadiscardedfromfinished'] = 'Tentativa não foi finalizada porque algumas respostas offline foram descartadas. Por favor, revise suas respostas e depois entregue novamente a tentativa.';
$string['addon.mod_resource.errorwhileloadingthecontent'] = 'Erro ao carregar conteúdo.';
$string['addon.mod_resource.openthefile'] = 'Abrir o arquivo';
$string['addon.mod_scorm.cannotcalculategrade'] = 'Nota não pôde ser calculada.';
$string['addon.mod_scorm.dataattemptshown'] = 'Estes dados pertence a tentativa número {{number}}.';
$string['addon.mod_scorm.errorcreateofflineattempt'] = 'Ocorreu um erro ao criar uma nova tentativa offline. Por favor, tente novamente.';
$string['addon.mod_scorm.errordownloadscorm'] = 'Erro baixar SCORM: "{{name}}".';
$string['addon.mod_scorm.errorgetscorm'] = 'Erro ao obter dados SCORM.';
$string['addon.mod_scorm.errorinvalidversion'] = 'Infelizmente, o aplicativo só suporta SCORM 1.2.';
$string['addon.mod_scorm.errornotdownloadable'] = 'O download de pacotes SCORM está desabilitado no seu site Moodle. Por favor, contate o administrador do site Moodle.';
$string['addon.mod_scorm.errornovalidsco'] = 'Este SCORM não tem um SCO visível para carregar.';
$string['addon.mod_scorm.errorpackagefile'] = 'Infelizmente, o aplicativo suporta apenas pacotes ZIP.';
$string['addon.mod_scorm.errorsyncscorm'] = 'Ocorreu um erro ao sincronizar. Por favor, tente novamente.';
$string['addon.mod_scorm.offlineattemptnote'] = 'Esta tentativa tem dados que não tem sido sincronizado.';
$string['addon.mod_scorm.offlineattemptovermax'] = 'Esta tentativa não pode ser enviada porque você ultrapassou o número máximo de tentativas.';
$string['addon.mod_scorm.scormstatusnotdownloaded'] = 'Este SCORM não é baixado. Ele será baixado automaticamente quando você abri-lo.';
$string['addon.mod_scorm.scormstatusoutdated'] = 'Este SCORM foi modificado desde o último download. Ele será baixado automaticamente quando você abri-lo.';
$string['addon.mod_scorm.warningofflinedatadeleted'] = 'Alguns dados offline da tentativa {{number}} foram excluídas porque ele não pôde ser criado em uma nova tentativa.';
$string['addon.mod_scorm.warningsynconlineincomplete'] = 'Algumas tentativas não poderiam ser sincronizadas com o site porque a última tentativa não foi finalizada. Por favor termine a tentativa online primeiro.';
$string['addon.mod_survey.cannotsubmitsurvey'] = 'Desculpe, houve um problema enviar a sua pesquisa. Por favor, tente novamente.';
$string['addon.mod_survey.errorgetsurvey'] = 'Erro ao obter dados da pesquisa.';
$string['addon.mod_survey.results'] = 'Resultados';
$string['addon.mod_url.accessurl'] = 'Acessar URL';
$string['addon.mod_url.pointingtourl'] = 'A URL desse recurso direciona para';
$string['addon.mod_wiki.errorloadingpage'] = 'Aconteceu um erro ao carregar a página.';
$string['addon.mod_wiki.errornowikiavailable'] = 'Essa wiki não tem nenhum conteúdo ainda.';
$string['addon.mod_wiki.gowikihome'] = 'Ir para o ínicio da Wiki';
$string['addon.mod_wiki.subwiki'] = 'Subwiki';
$string['addon.mod_wiki.titleshouldnotbeempty'] = 'O título não pode ser vazio';
$string['addon.mod_wiki.viewpage'] = 'Ver página';
$string['addon.mod_wiki.wikipage'] = 'Página do Wiki';
$string['addon.mod_workshop.assessmentstrategynotsupported'] = 'Estratégia de avaliação {{$a}} não suportada';
$string['addon.mod_workshop.submissionrequiredtitle'] = 'Você precisa digitar um título.';
$string['addon.mod_workshop.warningassessmentmodified'] = 'O envio foi modificado no site.';
$string['addon.mod_workshop.warningsubmissionmodified'] = 'A avaliação foi modificada no site.';
$string['addon.notes.userwithid'] = 'Usuário com o id {{id}}';
$string['addon.notes.warningnotenotsent'] = 'Não foi possível adicionar anotação(s) ao curso {{course}}. {{error}}';
$string['addon.notifications.errorgetnotifications'] = 'Erro ao receber notificações';
$string['addon.notifications.notifications'] = 'Notificação';
$string['addon.notifications.playsound'] = 'Tocar som';
$string['addon.notifications.therearentnotificationsyet'] = 'Não há notificações';
$string['addon.storagemanager.deletecourse'] = 'Limpar dados de todos os cursos';
$string['addon.storagemanager.deletedatafrom'] = 'Limpar dados de {{name}}';
$string['addon.storagemanager.info'] = 'Os arquivos armazenados no seu dispositivo tornam o aplicativo mais rápido e permitem que o aplicativo seja usado off-line. Você pode limpar estes arquivos com segurança se precisar liberar espaço de armazenamento.';
$string['addon.storagemanager.managestorage'] = 'Gerenciar armazenamento';
$string['addon.storagemanager.storageused'] = 'Armazenamento de arquivos utilizado:';
$string['appstoredescription'] = 'NOTA: Este aplicativo oficial Moodle Mobile vai funcionar apenas com sites de Moodle que foram configurados para permitir isso. Por favor, fale com o seu administrador do Moodle se você tiver quaisquer problemas para se conectar.

Se o seu site Moodle foi configurado corretamente, você pode usar este aplicativo para:

- Procurar o conteúdo de seus cursos, mesmo quando estiver offline
- Receber notificações instantâneas de mensagens e outros eventos
- Rapidamente encontrar e entrar em contato com outras pessoas em seus cursos
- Fazer upload de imagens, áudio, vídeos e outros arquivos do seu dispositivo móvel
- Visualizar suas notas do curso
- e mais!

Por favor, veja http://docs.moodle.org/en/Mobile_app para todas as últimas informações.

Nós realmente gostaríamos de receber quaisquer boas opiniões sobre a funcionalidade até agora e sugestões sobre o que mais você quer esse aplicativo faça!

O aplicativo requer as seguintes permissões:
Gravar áudio - Para gravação de áudio para enviar para o Moodle
Ler e modificar o conteúdo do cartão SD - Os conteúdos são baixados para o cartão SD para que você possa vê-los offline
Acesso à rede - Para ser capaz de se conectar com seu site Moodle e verificar se você está conectado ou não para mudar para o modo offline
Executar no início do sistema - Para você receber notificações locais, mesmo quando o aplicativo estiver sendo executado em segundo plano
Prevenir telefone de dormir - De forma que você possa receber notificações a qualquer momento';
$string['core.cannotconnect'] = 'Não foi possível conectar: Verifique se você digitou a URL corretamente e se seu site usa o Moodle {{$a}} ou posterior.';
$string['core.cannotdownloadfiles'] = 'Download de arquivos está desabilitado no seu serviço Mobile. Por favor, contate o administrador do site.';
$string['core.captureaudio'] = 'Gravar áudio';
$string['core.capturedimage'] = 'Fotografado';
$string['core.captureimage'] = 'Fotografar';
$string['core.capturevideo'] = 'Gravar vídeo';
$string['core.clearsearch'] = 'Limpar busca';
$string['core.clicktoseefull'] = 'Clique para ver o conteúdo completo.';
$string['core.confirmcanceledit'] = 'Você tem certeza que quer sair dessa página? Todas as mudanças serão perdidas.';
$string['core.confirmloss'] = 'Você tem certeza? Todas as alterações serão perdidas.';
$string['core.confirmopeninbrowser'] = 'Você quer abri-lo no navegador?';
$string['core.contenteditingsynced'] = 'O conteúdo que você está editando foi sincronizado.';
$string['core.contentlinks.chooseaccount'] = 'Escolha a conta';
$string['core.contentlinks.chooseaccounttoopenlink'] = 'Escolha a conta que irá abrir o link';
$string['core.contentlinks.confirmurlothersite'] = 'O link pertence a outro site. Você quer abrir-lo?';
$string['core.contentlinks.errornoactions'] = 'Não foi possível encontrar uma ação para executar com este link.';
$string['core.contentlinks.errornosites'] = 'Não foi possível encontrar qualquer site para lidar com este link.';
$string['core.contentlinks.errorredirectothersite'] = 'O URL de redirecionamento não pode apontar para um site diferente.';
$string['core.copiedtoclipboard'] = 'Texto copiado para a área de transferência';
$string['core.course.activitydisabled'] = 'Sua organização desativou essa atividade no aplicativo para dispositivos móveis.';
$string['core.course.activitynotyetviewableremoteaddon'] = 'Sua organização instalou um plugin que não é suportado ainda.';
$string['core.course.activitynotyetviewablesiteupgradeneeded'] = 'O Moodle de sua organização precisa ser atualizado.';
$string['core.course.allsections'] = 'Todas as seções';
$string['core.course.askadmintosupport'] = 'Contate o administrador do site e diga que você deseja usar essa atividade no aplicativo Moodle Mobile.';
$string['core.course.availablespace'] = 'Atualmente, você tem cerca de {{available}} de espaço livre.';
$string['core.course.confirmdeletemodulefiles'] = 'Você tem certeza que quer excluir esse modulo arquivos?';
$string['core.course.confirmdownload'] = 'Você está prestes a baixar {{size}}. Você tem certeza que quer continuar?';
$string['core.course.confirmdownloadunknownsize'] = 'Não fomos capazes de calcular o tamanho do download. Tem certeza de que deseja fazer o download?';
$string['core.course.confirmlimiteddownload'] = 'Atualmente, você não está conectado ao Wi-Fi.';
$string['core.course.confirmpartialdownloadsize'] = 'Você está prestes a baixar <strong>pelo menos</strong> {{size}}. Você tem certeza que quer continuar?';
$string['core.course.contents'] = 'Conteúdos';
$string['core.course.couldnotloadsectioncontent'] = 'Não foi possível carregar o conteúdo da seção, por favor tente mais tarde.';
$string['core.course.couldnotloadsections'] = 'Não foi possível carregar a seção, por favor tente mais tarde.';
$string['core.course.errordownloadingcourse'] = 'Erro ao baixar o curso.';
$string['core.course.errordownloadingsection'] = 'Erro ao baixar a seção.';
$string['core.course.errorgetmodule'] = 'Erro ao obter os dados do módulo.';
$string['core.course.insufficientavailablequota'] = 'Seu dispositivo não pôde alocar espaço para salvar este download. Reserve espaço para atualizações de aplicativos e do sistema. Por favor, limpe primeiro o espaço de armazenamento.';
$string['core.course.insufficientavailablespace'] = 'Você está tentando baixar {{size}}. Isso deixará o dispositivo com espaço insuficiente para funcionar normalmente. Por favor, limpe primeiro o espaço de armazenamento.';
$string['core.course.manualcompletionnotsynced'] = 'Conclusão manual não sincronizada.';
$string['core.course.nocontentavailable'] = 'Nenhum conteúdo disponível nesse momento.';
$string['core.course.refreshcourse'] = 'Atualizar curso';
$string['core.course.useactivityonbrowser'] = 'Você ainda pode usar isso no navegador do seu dispositivo';
$string['core.course.warningmanualcompletionmodified'] = 'A conclusão manual de uma atividade foi modificada no site.';
$string['core.course.warningofflinemanualcompletiondeleted'] = 'Alguma conclusão manual off-line do curso \'{{name}}\' foi excluída. {{erro}}';
$string['core.courses.cannotretrievemorecategories'] = 'Categorias mais profundas que o nível {{$a}} não podem ser recuperadas.';
$string['core.courses.confirmselfenrol'] = 'Tem certeza de que deseja se inscrever neste curso?';
$string['core.courses.downloadcourses'] = 'Baixar cursos';
$string['core.courses.enrolme'] = 'Inscreva-me';
$string['core.courses.errorloadcategories'] = 'Ocorreu um erro ao carregar categorias.';
$string['core.courses.errorloadcourses'] = 'Um erro ocorreu enquanto os cursos estavam sendo carregados.';
$string['core.courses.errorloadplugins'] = 'Os plugins necessários para este curso, não foram carregados corretamente. Por favor reinicie o aplicativo e tente novamente.';
$string['core.courses.errorsearching'] = 'Ocorreu um erro durante a pesquisa.';
$string['core.courses.errorselfenrol'] = 'Ocorreu um erro ao auto registo.';
$string['core.courses.filtermycourses'] = 'Filtrar meus cursos';
$string['core.courses.notenrollable'] = 'Você não pode inscrever-se neste curso.';
$string['core.courses.password'] = 'Chave de inscrição';
$string['core.courses.searchcoursesadvice'] = 'Você pode usar o botão de busca para encontrar cursos a serem acessados como convidado ou se inscrever em cursos que permitam inscrição.';
$string['core.courses.selfenrolment'] = 'Autoinscrição';
$string['core.courses.totalcoursesearchresults'] = 'Total de cursos: {{$a}}';
$string['core.currentdevice'] = 'Dispositivo atual';
$string['core.datastoredoffline'] = 'Os dados foram guardados no dispositivo porque não foi possível enviar agora. Os dados serão automaticamente enviados mais tarde.';
$string['core.deletedoffline'] = 'Offline excluído';
$string['core.deleting'] = 'Excluindo';
$string['core.dfdaymonthyear'] = 'MM-DD-YYYY';
$string['core.dfdayweekmonth'] = 'ddd, D MMM';
$string['core.dffulldate'] = 'dddd, D MMMM YYYY h[:]mm A';
$string['core.dflastweekdate'] = 'ddd';
$string['core.dfmediumdate'] = 'LLL';
$string['core.dftimedate'] = 'h[:]mm A';
$string['core.discard'] = 'Descartar';
$string['core.dismiss'] = 'Dispersar';
$string['core.downloaded'] = 'Baixado';
$string['core.downloading'] = 'Baixando';
$string['core.emptysplit'] = 'Esta página aparecerá em branco se o painel esquerdo estiver vazio ou estiver carregando.';
$string['core.errorchangecompletion'] = 'Ocorreu um erro ao alterar o status de conclusão. Por favor, tente novamente.';
$string['core.errordeletefile'] = 'Erro ao excluir o arquivo. Por favor tente novamente.';
$string['core.errordownloading'] = 'Erro ao baixar o arquivo';
$string['core.errordownloadingsomefiles'] = 'Erro ao transferir arquivos de módulo. Alguns arquivos podem estar faltando.';
$string['core.errorfileexistssamename'] = 'Já existe um arquivo com esse nome.';
$string['core.errorinvalidform'] = 'O formulário contém dados inválidos. Por favor tenha certeza de preencher todos os campos necessários e se os dados estão válidos.';
$string['core.errorinvalidresponse'] = 'Resposta inválida recebida. Por favor, contate o administrador do site Moodle se o erro persistir.';
$string['core.errorloadingcontent'] = 'Erro ao carregar o conteúdo.';
$string['core.errorofflinedisabled'] = 'A navegação offline está desativada em seu site. Você precisa estar conectado à internet para utilizar o aplicativo.';
$string['core.erroropenfilenoapp'] = 'Erro ao abrir o arquivo: nenhum aplicativo encontrado para abrir esse tipo de arquivo.';
$string['core.erroropenfilenoextension'] = 'Erro ao abrir o arquivo: o arquivo não tem extensão.';
$string['core.erroropenpopup'] = 'Esta atividade está tentando abrir um pop-up. Isto não é suportado neste app.';
$string['core.errorrenamefile'] = 'Erro ao renomear o arquivo. Por favor, tente novamente.';
$string['core.errorsync'] = 'Um erro aconteceu quando estava sincronizando. Por favor tente novamente.';
$string['core.errorsyncblocked'] = 'Esse {{$a}} não pode ser sincronizado agora por causa de um processo em andamento. Por favor tente mais tarde. Se o problema persistir, tente reiniciar o aplicativo.';
$string['core.filenameexist'] = 'O nome do arquivo já existe: {{$a}}';
$string['core.fileuploader.audio'] = 'Áudio';
$string['core.fileuploader.camera'] = 'Câmera';
$string['core.fileuploader.confirmuploadfile'] = 'Você está prestes a enviar {{size}}. Você tem certeza que quer continuar?';
$string['core.fileuploader.confirmuploadunknownsize'] = 'Não conseguimos calcular o tamanho do que será enviado. Você tem certeza que quer continuar?';
$string['core.fileuploader.errorcapturingaudio'] = 'Erro ao capturar áudio';
$string['core.fileuploader.errorcapturingimage'] = 'Erro ao capturar imagem.';
$string['core.fileuploader.errorcapturingvideo'] = 'Erro ao capturar  vídeo.';
$string['core.fileuploader.errorgettingimagealbum'] = 'Erro ao pegar imagem a partir do álbum.';
$string['core.fileuploader.errormustbeonlinetoupload'] = 'Você precisa estar online para enviar arquivos.';
$string['core.fileuploader.errornoapp'] = 'Você não tem um aplicativo instalado para fazer essa ação.';
$string['core.fileuploader.errorreadingfile'] = 'Erro ao ler arquivo.';
$string['core.fileuploader.errorwhileuploading'] = 'Houve um erro durante o envio do arquivo.';
$string['core.fileuploader.file'] = 'Arquivo';
$string['core.fileuploader.fileuploaded'] = 'Arquivo enviado';
$string['core.fileuploader.maxbytesfile'] = 'O arquivo {{$a.file}} é muito grande. O tamanho máximo que você pode enviar é {{$a.size}}.';
$string['core.fileuploader.photoalbums'] = 'Álbuns de fotos';
$string['core.fileuploader.readingfile'] = 'Lendo arquivo';
$string['core.fileuploader.readingfileperc'] = 'Lendo o arquivo: {{$a}}%';
$string['core.fileuploader.selectafile'] = 'Selecione um arquivo';
$string['core.fileuploader.uploadafile'] = 'Enviando um arquivo';
$string['core.fileuploader.uploading'] = 'Enviando';
$string['core.fileuploader.uploadingperc'] = 'Enviando: {{$a}}%';
$string['core.fileuploader.video'] = 'Vídeo';
$string['core.fullnameandsitename'] = '{{fullname}} ({{sitename}})';
$string['core.hasdatatosync'] = 'Esse {{$a}} tem informação offline que precisar ser sincronizada.';
$string['core.humanreadablesize'] = '{{size}} {{unit}}';
$string['core.image'] = 'Imagem';
$string['core.imageviewer'] = 'Visualizador de imagens';
$string['core.lastdownloaded'] = 'Último baixado';
$string['core.lastsync'] = 'Última sincronização';
$string['core.loadmore'] = 'Ler mais';
$string['core.login.authenticating'] = 'Autenticação';
$string['core.login.confirmdeletesite'] = 'Você tem certeza que quer excluir o site {{sitename}}?';
$string['core.login.connect'] = 'Conectar!';
$string['core.login.connecttomoodle'] = 'Conectar ao moodle';
$string['core.login.contactyouradministrator'] = 'Contate o administrador do site para ter mais ajuda.';
$string['core.login.contactyouradministratorissue'] = 'Por favor, pergunte ao administrador para verificar o seguinte problema: {{$a}}';
$string['core.login.credentialsdescription'] = 'Por favor, informe seu nome de usuário e senha para efetuar o login';
$string['core.login.emailconfirmsentnoemail'] = '<p>Um e-mail deve ter sido enviado para o seu endereço.</p><p>Ele contém instruções simplificadas para concluir seu registro.</p> <p>Se você continuar com dificuldades, entre em contato com o administrador do site.</p>';
$string['core.login.emailnotmatch'] = 'Os e-mail não coincidem';
$string['core.login.erroraccesscontrolalloworigin'] = 'A chamada de Cross-Origin que você está tentando executar foi rejeitada. Por favor, verifique https://docs.moodle.org/dev/Moodle_Mobile_development_using_Chrome_or_Chromium';
$string['core.login.errordeletesite'] = 'Um erro ocorreu ao excluir esse site. Por favor tente novamente.';
$string['core.login.errorupdatesite'] = 'Um erro ocorreu quando atualizava o token do site.';
$string['core.login.findyoursite'] = 'Encontre seu site';
$string['core.login.helpmelogin'] = '<p>Existem milhares de sites Moodle em todo o mundo. Este aplicativo pode se conectar somente a sites Moodle que habilitaram o acesso para dispositivos móveis.</p><p>Se você não conseguir se conectar ao seu site Moodle, entre em contato com o administrador do site e peça a ele para ler <a href="http://docs.moodle.org/en/Mobile_app" target="_blank">http://docs.moodle.org/en/Mobile_app</a></p><p>Para testar o aplicativo em um site de demonstração do Moodle digite <i>teacher</i> ou <i>student</i> no campo<i>Endereço do site</i> e clique no <b>botão Conectar</b>.</p>';
$string['core.login.invalidaccount'] = 'Por favor, verifique os detalhes de seu Usuário ou peça ao administrador do site para verificar a configuração do site.';
$string['core.login.invalidmoodleversion'] = 'Versão do Moodle inválida. A versão mínima requerida é:';
$string['core.login.invalidsite'] = 'A URL do siteé inválida.';
$string['core.login.invalidtime'] = 'Tempo inválido';
$string['core.login.invalidvaluemax'] = 'O valor máximo é {{$a}}';
$string['core.login.invalidvaluemin'] = 'O valor minimo é{{$a}}';
$string['core.login.localmobileunexpectedresponse'] = 'Verificação do Moodle Mobile Additional Features retornou uma resposta inesperada, você ira se autenticar usando o serviço Mobile padrão';
$string['core.login.loggedoutssodescription'] = 'Você tem que autenticar novamente. Você precisa fazer login no site em uma janela do navegador.';
$string['core.login.loginbutton'] = 'Entrar';
$string['core.login.logininsiterequired'] = 'É preciso logar no site num navegador.';
$string['core.login.mobileservicesnotenabled'] = 'Os serviços móveis não estão habilitados no seu Moodle. Por favor contate a administradora do seu Moodle se achar que o acesso móvel deveria estar habilitado';
$string['core.login.notloggedin'] = 'Você precisa estar logado.';
$string['core.login.passwordrequired'] = 'Senha necessária';
$string['core.login.recaptchachallengeimage'] = 'Desafio de imagem do reCAPTCHA';
$string['core.login.recaptchaexpired'] = 'Verificação expirada. Responda a pergunta de segurança novamente.';
$string['core.login.recaptchaincorrect'] = 'A resposta da pergunta de segurança está incorreta.';
$string['core.login.reconnect'] = 'Reconectar';
$string['core.login.reconnectdescription'] = 'Seu token de autenticação é inválido ou expirou, você tem que reconectar com o site.';
$string['core.login.reconnectssodescription'] = 'Seu token de autenticação é inválido ou expirou, você tem que reconectar com o site. Você precisa efetuar login no site em uma janela do navegador.';
$string['core.login.searchby'] = 'Buscar por:';
$string['core.login.selectsite'] = 'Por favor selecione seu site:';
$string['core.login.signupplugindisabled'] = '{{$a}} não está habilitado.';
$string['core.login.siteaddress'] = 'Endereço do site';
$string['core.login.sitehasredirect'] = 'Seu site contém pelo menos um redirecionamento de HTTP. O aplicativo não pode seguir redirecionamentos. Esse pode ser o problema que impede o aplicativo de se conectar ao seu site.';
$string['core.login.siteinmaintenance'] = 'O site está em modo de manutenção';
$string['core.login.sitepolicynotagreederror'] = 'Não concordou com a política do site.';
$string['core.login.siteurl'] = 'URL do site';
$string['core.login.siteurlrequired'] = 'URL do site é obrigatória, por exemplo  <i>http://www.yourmoodlesite.abc ou https://www.yourmoodlesite.efg</i>';
$string['core.login.stillcantconnect'] = 'Ainda não consegue conectar?';
$string['core.login.usernamerequired'] = 'Nome de usuário exigido';
$string['core.login.visitchangepassword'] = 'Você quer visitar o site para mudar sua senha?';
$string['core.login.webservicesnotenabled'] = 'Web Services não estão ativados em seu site. Por favor, contate a administradora do seu Moodle se você achar que o acesso móvel deve ser ativado.';
$string['core.lostconnection'] = 'Perdemos conexão. Você precisa se reconectar. Seu token agora está inválido.';
$string['core.mainmenu.changesite'] = 'Mudar site';
$string['core.mainmenu.website'] = 'Site';
$string['core.networkerroriframemsg'] = 'Este conteúdo não está disponível offline. Por favor, conecte-se à internet e tente novamente.';
$string['core.networkerrormsg'] = 'Rede não habilitada ou não está funcionado';
$string['core.nopasswordchangeforced'] = 'Você não pode proceder sem mudar sua senha.';
$string['core.nopermissionerror'] = 'Desculpe, mas você não tem permissões para fazer isso';
$string['core.notapplicable'] = 'n/a';
$string['core.notsent'] = 'Não enviado';
$string['core.openfullimage'] = 'Clique aqui para exibir a imagem no tamanho completo';
$string['core.openinbrowser'] = 'Abrir no navegador';
$string['core.percentagenumber'] = '{{$a}}%';
$string['core.pulltorefresh'] = 'Puxe para atualizar';
$string['core.question.cannotdeterminestatus'] = 'Não é possível determinar o status';
$string['core.question.errorquestionnotsupported'] = 'Esse tipo de questão não é suportada pelo aplicativo: {{$a}}.';
$string['core.question.howtodraganddrop'] = 'Toque para selecionar e então toque para soltar.';
$string['core.question.questionmessage'] = 'Questão {{$a}}: {{$b}}';
$string['core.redirectingtosite'] = 'Você será redirecionado para o site.';
$string['core.requireduserdatamissing'] = 'Este usuário não possui alguns dados de perfil exigidos. Por favor, preencha estes dados em seu Moodle e tente novamente. <br> {{$a}}';
$string['core.retry'] = 'Tentar novamente';
$string['core.searching'] = 'Procurando';
$string['core.settings.about'] = 'Sobre';
$string['core.settings.cannotsyncoffline'] = 'Não pode sincronizar offline.';
$string['core.settings.cannotsyncwithoutwifi'] = 'Não foi possível sincronizar por causa que as configurações atuais somente permite a sincronização em quando estiver conectado ao Wi-Fi. Por favor conecte-se a uma rede Wi-Fi.';
$string['core.settings.compilationinfo'] = 'Informação de compilação';
$string['core.settings.cordovadevicemodel'] = 'Cordova do modelo do dispositivo';
$string['core.settings.cordovadeviceosversion'] = 'Cordova Device OS versão';
$string['core.settings.cordovadeviceplatform'] = 'Cordova Device plataforma';
$string['core.settings.cordovadeviceuuid'] = 'Cordova Device uuid';
$string['core.settings.cordovaversion'] = 'Cordova versão';
$string['core.settings.debugdisplaydescription'] = 'Se habilitado, os modais de erro mostrarão mais dados sobre o erro, se possível.';
$string['core.settings.deletesitefiles'] = 'Você tem certeza que quer excluir os arquivos baixados do site \'{{sitename}}\'?';
$string['core.settings.deletesitefilestitle'] = 'Excluir os arquivos do site';
$string['core.settings.deviceinfo'] = 'Informação do dispositivo';
$string['core.settings.deviceos'] = 'Dispositivo OS';
$string['core.settings.displayformat'] = 'Formato de exibição';
$string['core.settings.enabledownloadsection'] = 'Ativar seções de download';
$string['core.settings.enablerichtexteditor'] = 'Habilitar editor de texto rico';
$string['core.settings.enablerichtexteditordescription'] = 'Se habilitado, o editor de texto rico será exibido em lugares em que ele é permitido.';
$string['core.settings.enablesyncwifi'] = 'Sincronizar somente em Wi-Fi';
$string['core.settings.entriesincache'] = '{{$a}} registros em cache';
$string['core.settings.errordeletesitefiles'] = 'Erro ao excluir os arquivos do site.';
$string['core.settings.errorsyncsite'] = 'Erro ao sincronizar os dados do site, por favor verifique sua conexão de internet e tente novamente.';
$string['core.settings.estimatedfreespace'] = 'Espaço livre estimado';
$string['core.settings.filesystemroot'] = 'Raiz do sistema de arquivos';
$string['core.settings.localnotifavailable'] = 'Notificações locais disponíveis';
$string['core.settings.locationhref'] = 'Webview URL';
$string['core.settings.navigatorlanguage'] = 'Idioma de navegação';
$string['core.settings.navigatoruseragent'] = 'Navegador userAgent';
$string['core.settings.networkstatus'] = 'O status da conexão Internet';
$string['core.settings.privacypolicy'] = 'Política de privacidade';
$string['core.settings.pushid'] = 'ID de notificações push';
$string['core.settings.reportinbackground'] = 'Relatar erros automaticamente';
$string['core.settings.showdownloadoptions'] = 'Mostrar opções para baixar';
$string['core.settings.spaceusage'] = 'Uso do espaço';
$string['core.settings.synchronization'] = 'Sincronização';
$string['core.settings.synchronizenow'] = 'Sincronizar agora';
$string['core.settings.syncsettings'] = 'Configurações de sincronização';
$string['core.settings.wificonnection'] = 'Conexão Wi-Fi';
$string['core.sharedfiles.chooseaccountstorefile'] = 'Escolha uma conta para armazenar os arquivos.';
$string['core.sharedfiles.chooseactionrepeatedfile'] = 'Já existe um arquivo com esse nome. Você deseja substituir o arquivo existente ou renomear ele para "{{$a}}"?';
$string['core.sharedfiles.errorreceivefilenosites'] = 'Não existem sites armazenados. Por favor, adicione um site antes de compartilhar o arquivo com o aplicativo.';
$string['core.sharedfiles.nosharedfiles'] = 'Não existem arquivos compartilhados guardados nesse site.';
$string['core.sharedfiles.nosharedfilestoupload'] = 'Você não tem arquivos para enviar aqui. Se você quer enviar um arquivo de um outro aplicativo, localiza aquele arquivo e clique no botão \'Abra em\'.';
$string['core.sharedfiles.rename'] = 'Renomear';
$string['core.sharedfiles.replace'] = 'Substituir';
$string['core.sharedfiles.sharedfiles'] = 'Arquivos compartilhados';
$string['core.sharedfiles.successstorefile'] = 'Arquivo armazenado com sucesso. Agora você pode selecionar esse arquivo para enviar para seus "arquivos privados" ou anexar em atividades.';
$string['core.sizetb'] = 'TB';
$string['core.sorry'] = 'Desculpe...';
$string['core.tablet'] = 'Tablet';
$string['core.thereisdatatosync'] = 'Existem {{$a}} offline para ser sincronizados.';
$string['core.tryagain'] = 'Tente de novo';
$string['core.twoparagraphs'] = '{{p1}}<br><br>{{p2}}';
$string['core.uhoh'] = 'Uh oh!';
$string['core.unexpectederror'] = 'Erro inesperado. Por favor, feche e abra novamente o aplicativo para tentar novamente';
$string['core.unicodenotsupported'] = 'Texto Unicode como emojis não são suportados neste site, o texto será enviado removendo esses caracteres.';
$string['core.unicodenotsupportedcleanerror'] = 'Texto vazio foi encontrado ao limpar caracteres Unicode.';
$string['core.unknown'] = 'Desconhecido';
$string['core.unzipping'] = 'Descompactando';
$string['core.user.contact'] = 'Contato';
$string['core.user.detailsnotavailable'] = 'Os detalhes desse usuário não estão disponíveis para você.';
$string['core.user.errorloaduser'] = 'Erro ao carregar o usuário.';
$string['core.user.sendemail'] = 'Email';
$string['core.viewcode'] = 'Ver o código';
$string['core.vieweditor'] = 'Ver o editor';
$string['core.viewembeddedcontent'] = 'Ver conteúdo incorporado';
$string['core.warningofflinedatadeleted'] = 'Dados offline de {{component}} \'{{name}}\' foram excluídos. {{error}}';
$string['core.whoops'] = 'Oops!';
$string['core.whyisthishappening'] = 'Por que isso está acontecendo?';
$string['core.wsfunctionnotavailable'] = 'A função do webservice não está disponível.';
$string['pluginname'] = 'Cadeias de idiomas no Moodle Mobile';
