<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'forum', language 'pt_br', version '3.5'.
 *
 * @package     forum
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityoverview'] = 'Existem novas postagens no fórum';
$string['addanewdiscussion'] = 'Acrescentar um novo tópico de discussão';
$string['addanewquestion'] = 'Acrescentar uma nova questão';
$string['addanewtopic'] = 'Acrescentar um novo tópico';
$string['advancedsearch'] = 'Busca avançada';
$string['allforums'] = 'Todos os fóruns';
$string['allowdiscussions'] = 'Um {$a} pode enviar mensagens a este fórum?';
$string['allowsallsubscribe'] = 'Neste fórum cada um pode escolher se quer ou não se inscrever';
$string['allowsdiscussions'] = 'Neste fórum todos os participantes podem iniciar novas discussões.';
$string['allsubscribe'] = 'Fazer assinatura em todos os fóruns';
$string['allunsubscribe'] = 'Cancelar assinatura em todos os fóruns';
$string['alreadyfirstpost'] = 'Este já é a primeira mensagem da discussão';
$string['anyfile'] = 'Qualquer arquivo';
$string['areaattachment'] = 'Anexos';
$string['areapost'] = 'Mensagens';
$string['attachment'] = 'Anexo';
$string['attachment_help'] = 'Opcionalmente, pode anexar um ou mais arquivos para uma mensagem do fórum. Se você anexar uma imagem, ela será exibida após a mensagem.';
$string['attachmentnopost'] = 'Você não pode exportar anexos sem o ID do post';
$string['attachments'] = 'Anexos';
$string['attachmentswordcount'] = 'Anexos e contador de palavras';
$string['blockafter'] = 'Limite de mensagens para bloqueio';
$string['blockafter_help'] = 'Esta configuração especifica o número máximo de mensagens que um usuário pode postar no período de tempo determinado. Os usuários com a capacidade mod/forum:postwithoutthrottling estão isentos de limites de postagens.';
$string['blockperiod'] = 'Duração do bloqueio';
$string['blockperiod_help'] = 'Os estudantes podem ser bloqueadas para publicar em mais que um determinado número de lugares por um determinado período de tempo. Os usuários com a capacidade mod/forum:postwithoutthrottling estão isentos de limites de postagens.';
$string['blockperioddisabled'] = 'Não bloquear';
$string['blogforum'] = 'Fórum padrão exibido em um formato de blog';
$string['bynameondate'] = 'por {$a->name} - {$a->date}';
$string['cannotadd'] = 'Não é possível adicionar uma discussão a este fórum';
$string['cannotadddiscussion'] = 'Apenas os participantes inscritos nos grupos podem escrever mensagens neste fórum.';
$string['cannotadddiscussionall'] = 'Você não tem permissão para abrir um novo tópico de discussão para todos os participantes.';
$string['cannotadddiscussiongroup'] = 'Você não pode criar uma discussão porque você não é membro de nenhum grupo.';
$string['cannotaddsubscriber'] = 'Não foi possível adicionar o assinante com ID {$a} a este fórum!';
$string['cannotaddteacherforumto'] = 'Não foi possível converter o exemplo do fórum de professore à secão 0 do curso';
$string['cannotcreatediscussion'] = 'Não foi possível criar uma nova discussão';
$string['cannotcreateinstanceforteacher'] = 'Não foi possível criar um novo exemplo de módulo de curso para o fórum de professore';
$string['cannotdeletepost'] = 'Você não pode excluir esta mensagem!';
$string['cannoteditposts'] = 'Não é permitido eliminar as menssagens de outras pessoas!';
$string['cannotfinddiscussion'] = 'Não foi possível encontrar a discussão neste fórum';
$string['cannotfindfirstpost'] = 'Não foi possível encontrar a primeira menssagem neste fórum.';
$string['cannotfindorcreateforum'] = 'Não foi possível encontrar ou criar um fórum de avisos neste site.';
$string['cannotfindparentpost'] = 'Não foi possível encontrar a mensagem anterior da mensagem {$a}';
$string['cannotmovefromsingleforum'] = 'Não foi possível mover um debate a partir de um fórum de debate simples';
$string['cannotmovenotvisible'] = 'Fórum não visível';
$string['cannotmovetonotexist'] = 'Não foi possível mover nada a esse fórum. Ele não existe!';
$string['cannotmovetonotfound'] = 'Fórum de destino não foi encontrado neste curso.';
$string['cannotmovetosingleforum'] = 'Não é possível mover a discussão para um fórum de discussão única simples';
$string['cannotpurgecachedrss'] = 'Não foi possível limpar feeds RSS em cache para a fonte e / ou fórum de destino (s) - verificar file permissionsforums';
$string['cannotremovesubscriber'] = 'Não foi possível remover assinante com id {$a} deste fórum!';
$string['cannotreply'] = 'Você não pode responder a este post';
$string['cannotsplit'] = 'Os debates a este fórum não podem ser divididos';
$string['cannotsubscribe'] = 'Desculpe, mas você deve ser um membro do grupo para se inscrever.';
$string['cannottrack'] = 'Não é possível parar de rastrear este fórum.';
$string['cannotunsubscribe'] = 'Não foi possível desligar sua assinatura deste fórum';
$string['cannotupdatepost'] = 'Você não pode atualizar esta mensagem.';
$string['cannotviewpostyet'] = 'Você ainda não pode ler as perguntas dos outros participantes desta discussão porque você ainda não publicou a sua';
$string['cannotviewusersposts'] = 'Não há posts deste usuário que você seja capaz de visualizar.';
$string['cleanreadtime'] = 'Quando marcar as mensagens antigas como lidas';
$string['clicktosubscribe'] = 'Você não é assinante desta discussão. Clique aqui para assinar.';
$string['clicktounsubscribe'] = 'Você está assinando esta discussão. Clique para cancelar a assinatura.';
$string['completiondiscussions'] = 'O usuário deve criar discussões:';
$string['completiondiscussionsdesc'] = 'O estudante deve criar pelo menos {$a} discussão(ôes)';
$string['completiondiscussionsgroup'] = 'Requer discussões';
$string['completiondiscussionshelp'] = 'discussões necessárias para completar';
$string['completionposts'] = 'O estudante precisa abrir ou responder em um tópico de discussão:';
$string['completionpostsdesc'] = 'O estudante deve postar pelo menos {$a} discussão(ões) ou resposta(s)';
$string['completionpostsgroup'] = 'Requer mensagens';
$string['completionpostshelp'] = 'discussões necessárias ou respostas para completar';
$string['completionreplies'] = 'O usuário deve enviar réplicas:';
$string['completionrepliesdesc'] = 'O estudante deve postar pelo menos {$a} resposta(s)';
$string['completionrepliesgroup'] = 'Requer réplicas';
$string['completionreplieshelp'] = 'necessário responder para completar';
$string['configcleanreadtime'] = 'Hora do dia em que as mensagens antigas serão apagadas da tabela \'lidas\'.';
$string['configdigestmailtime'] = 'Quem escolher esta opção receberá todas as mensagens do fórum agrupadas em um resumo diário. Esta opção controla a hora do dia que o email diário será enviado (o primeiro cron depois deste horário fará o envio).';
$string['configdisplaymode'] = 'Modalidade de visualização das discussões predefinida, se uma outra não for configurada.';
$string['configenablerssfeeds'] = 'Esta opção ativa a possibilidade de gerar alimentadores RSS nos fóruns. É necessário configurar cada fórum para que sejam gerados os feeds correspondentes.';
$string['configenabletimedposts'] = 'Defina para \'sim\' se você quiser permitir a configuração dos períodos de exibição ao postar uma nova discussão no fórum.';
$string['configlongpost'] = 'Todas as mensagens maiores que esta dimensão (sem contar o html) são consideradas longas.';
$string['configmanydiscussions'] = 'Número máximo de discussões mostrado em um fórum, por página.';
$string['configmaxattachments'] = 'Número máximo padrão de anexos permitido por mensagem.';
$string['configmaxbytes'] = 'Tamanho máximo predefinido dos anexos de todos os fóruns do site (sujeito aos limites dos cursos e outras configurações locais)';
$string['configoldpostdays'] = 'Número de dias passados antes que qualquer mensagem seja considerada lida.';
$string['configreplytouser'] = 'Quando as mensagens dos fóruns são enviadas aos usuários via email devem conter o endereço do autor para que seja possível responder via email diretamente a ele sem passar pelo fórum? Mesmo quando a opção escolhida for "sim" os usuários terão a possibilidade de mudar o perfil pessoal deles para manter o endereço de email escondido.';
$string['configrssarticlesdefault'] = 'Se o feed RSS está habilitado, define o número padrão de artigos (tanto discussões ou mensagens).';
$string['configrsstypedefault'] = 'Se o feed RSS está habilitado, define o tipo de atividade padrão.';
$string['configshortpost'] = 'Todas as mensagens menores que esta dimensão (sem contar o html) são consideradas curtas.';
$string['configsubscriptiontype'] = 'Configuração padrão para o modo de assinatura.';
$string['configtrackingtype'] = 'Configuração padrão para o monitoramento de leitura.';
$string['configtrackreadposts'] = 'Escolha \'sim\' se você quiser monitorar as mensagens lidas/não lidas de cada usuário.';
$string['configusermarksread'] = 'Se \'sim\',o usuário terá que marcar as mensagens lidas manualmente. Se \'não\', a mensagem acessada será marcada automaticamente.';
$string['confirmsubscribe'] = 'Você deseja realmente assinar o fórum  \'{$a}\'?';
$string['confirmsubscribediscussion'] = 'Você realmente quer se inscrever na discussão  \'{$a->discussion}\' no forum \'{$a->forum}\'?';
$string['confirmunsubscribe'] = 'Você deseja realmente cancelar assinatura do forum \'{$a}\'?';
$string['confirmunsubscribediscussion'] = 'Você realmente quer cancelar a inscrição do debate \'{$a->discussion}\' no forum \'{$a->forum}\'?';
$string['couldnotadd'] = 'Não foi possível publicar a sua mensagem. Infelizmente a causa do erro não foi identificada.';
$string['couldnotdeletereplies'] = 'Não é possível excluir esta mensagem porque já existem respostas.';
$string['couldnotupdate'] = 'Não foi possível atualizar a sua mensagem. Infelizmente a causa do erro não foi identificada.';
$string['crontask'] = 'Mailings  do Fórum e trabalhos de manutenção';
$string['delete'] = 'Excluir';
$string['deleteddiscussion'] = 'A discussão foi apagada';
$string['deletedpost'] = 'A mensagem foi apagada';
$string['deletedposts'] = 'Estas mensagens foram apagadas';
$string['deletesure'] = 'Você tem certeza que quer excluir esta mensagem?';
$string['deletesureplural'] = 'Tem certeza que quer excluir esta mensagem e todas as respostas? ({$a} mensagens)';
$string['digestmailheader'] = 'Este é o resumo diário das novas mensagens dos fóruns de {$a->sitename}. Para alterar suas preferências sobre o email de mensagens do fórum, acesse {$a->userprefs}.';
$string['digestmailpost'] = 'Alterar suas preferencias de resumo do fórum';
$string['digestmailpostlink'] = 'Alterar suas configurações de compilação dos fóruns: {$a}';
$string['digestmailprefs'] = 'O seu perfil';
$string['digestmailsubject'] = '{$a}: Resumo do fórum';
$string['digestmailtime'] = 'Horário de envio do resumo de emails';
$string['digestsentusers'] = 'Email de resumos enviados com sucesso para {$a} usuários.';
$string['disallowsubscribe'] = 'Assinaturas não permitidas';
$string['disallowsubscribeteacher'] = 'Assinaturas são autorizadas apenas para professores';
$string['disallowsubscription'] = 'Assinatura';
$string['disallowsubscription_help'] = 'Este fórum foi configurado de forma que você não pode se inscrever nas discussões.';
$string['discussion'] = 'Tópico';
$string['discussionlocked'] = 'Esta discussão foi bloqueada e já não é possível responder a ela.';
$string['discussionlockingdisabled'] = 'Não bloquear discussões';
$string['discussionlockingheader'] = 'Bloqueio de discussões';
$string['discussionmoved'] = 'Esta discussão foi transferida para \'{$a}\'.';
$string['discussionmovedpost'] = 'Esta discussão foi transferida <a href="{$a->discusshref}">aqui</a> no fórum <a href="{$a->forumhref}">{$a->forumname}</a>';
$string['discussionname'] = 'Título';
$string['discussionnownotsubscribed'] = '{$a->name} não será notificado de novos posts em \'{$a->discussion}\' de \'{$a->forum}\'';
$string['discussionnowsubscribed'] = '{$a->name} será notificado de novos posts em \'{$a->discussion}\' de \'{$a->forum}\\';
$string['discussionpin'] = 'Destacar';
$string['discussionpinned'] = 'Destacado';
$string['discussionpinned_help'] = 'As discussões em destaque irão aparecer no topo do fórum.';
$string['discussions'] = 'Tópicos';
$string['discussionsstartedby'] = 'Discussões iniciadas por {$a}';
$string['discussionsstartedbyrecent'] = 'Discussões iniciadas recentemente por {$a}';
$string['discussionsstartedbyuserincourse'] = 'Os debates começaram por {$a->fullname} em {$a->coursename}';
$string['discussionsubscribestart'] = 'Envie-me cópias por e-mail de post nesta discussão';
$string['discussionsubscribestop'] = 'Eu não quero cópias por e-mail de posts nesta discussão';
$string['discussionsubscription'] = 'Assinatura de discussão';
$string['discussionsubscription_help'] = 'Ser assinante em uma discussão significa que você receberá notificações de novas postagens nessa discussão.';
$string['discussionunpin'] = 'Remover destaque';
$string['discussthistopic'] = 'Discutir este tópico';
$string['displayend'] = 'Fim da visualização';
$string['displayend_help'] = '<p>Você pode escolher se seu fórum é acessível a partir de uma determinada data, expira depois
de um determinado período ou é visualizado em um determinado período.</p>

<p>Desmarque a opção "Desabilitar" para ativar a exibição da data inicial e/ou final.</p>

<p>Note que os usuários com poderes de Administrador verão as mensagens antes da data de publicação e depois da data de expiração.</p>';
$string['displaymode'] = 'Modo de visualização';
$string['displayperiod'] = 'Período de exibição';
$string['displaystart'] = 'Início da visualização';
$string['displaystart_help'] = '<p>Você pode escolher se seu fórum é acessível a partir de uma determinada data, expira depois
de um determinado período ou é visualizado em um determinado período.</p>

<p>Desmarque a opção "Desabilitar" para ativar a exibição da data inicial e/ou final.</p>

<p>Note que os usuários com poderes de Administrador verão as mensagens antes da data de publicação e depois da data de expiração.</p>';
$string['displaywordcount'] = 'Mostrar contagem de palavras';
$string['displaywordcount_help'] = 'Esta configuração especifica se a contagem de palavras de cada post deve ser exibida ou não.';
$string['eachuserforum'] = 'Cada usuário inicia apenas UM NOVO tópico';
$string['edit'] = 'Editar';
$string['editedby'] = 'Editado por {$a->name} - envio original {$a->date}';
$string['editedpostupdated'] = '{$a} mensagens foram atualizadas';
$string['editing'] = 'Edição';
$string['emaildigestcompleteshort'] = 'Mensagens completas';
$string['emaildigestdefault'] = 'Padrão ({$a})';
$string['emaildigestoffshort'] = 'Sem resumos';
$string['emaildigestsubjectsshort'] = 'Somente assuntos';
$string['emaildigesttype'] = 'Opções de alertas de email';
$string['emaildigesttype_help'] = 'O tipo de notificação que você receberá para cada fórum.

* Padrão - acompanhar a definição de resumo encontrada em seu perfil de usuário. Se você atualizar o seu perfil, em seguida, a mudança será refletida aqui também;
* Sem resumo - você receberá um e-mail por post no fórum,
* Resumo - mensagens completas - você receberá um e-mail de resumo por dia contendo o conteúdo completo de cada post no fórum,
* Resumo - apenas assuntos - você receberá um e-mail de resumo por dia contendo apenas o assunto de cada post no fórum.';
$string['emptymessage'] = 'A sua mensagem não foi enviada. Normalmente isto acontece quando a mensagem ou o campo assunto estão em branco ou quando o anexo é grande demais.';
$string['erroremptymessage'] = 'A mensagem não pode estar vazia.';
$string['erroremptysubject'] = 'O assunto da mensagem não pode ser vazio.';
$string['errorenrolmentrequired'] = 'Você precisa estar inscrito neste curso para acessar este conteúdo';
$string['errorwhiledelete'] = 'Ocorreu um erro ao se eliminar o registro.';
$string['eventassessableuploaded'] = 'Algum conteúdo foi publicado.';
$string['eventcoursesearched'] = 'Curso procurado';
$string['eventdiscussioncreated'] = 'Discussão criada';
$string['eventdiscussiondeleted'] = 'Discussão excluída';
$string['eventdiscussionmoved'] = 'Discussão movida';
$string['eventdiscussionpinned'] = 'Discussão destacada';
$string['eventdiscussionsubscriptioncreated'] = 'Assinatura de discussão criada';
$string['eventdiscussionsubscriptiondeleted'] = 'Assinatura de discussão excluída';
$string['eventdiscussionunpinned'] = 'Foi removido o destaque da discussão';
$string['eventdiscussionupdated'] = 'Discussão atualizada';
$string['eventdiscussionviewed'] = 'Discussão visualizada';
$string['eventpostcreated'] = 'Post criado';
$string['eventpostdeleted'] = 'Post excluído';
$string['eventpostupdated'] = 'Post atualizado';
$string['eventreadtrackingdisabled'] = 'Rastreamento de leitura desabilitado';
$string['eventreadtrackingenabled'] = 'Rastreamento de leitura habilitado';
$string['eventsubscribersviewed'] = 'Visualizado inscritos';
$string['eventsubscriptioncreated'] = 'Assinatura criada';
$string['eventsubscriptiondeleted'] = 'Assinatura excluída';
$string['eventuserreportviewed'] = 'Visualizado relatório de usuário';
$string['everyonecanchoose'] = 'Todos podem fazer a assinatura';
$string['everyonecannowchoose'] = 'Agora todos podem fazer a assinatura';
$string['everyoneisnowsubscribed'] = 'Agora todos são assinantes deste fórum';
$string['everyoneissubscribed'] = 'Todos são assinantes deste fórum';
$string['existingsubscribers'] = 'Assinantes';
$string['exportdiscussion'] = 'Exportar todo o debate para o portfólio';
$string['forcedreadtracking'] = 'Permitir monitoramento de leitura forçado';
$string['forcedreadtracking_desc'] = 'Permitir que fóruns sejam configurados para monitoramento de leitura forçado. Irá resultar em desempenho reduzido para alguns usuários, principalmente em cursos com muitos fóruns e posts. Quando desligado, quaisquer fóruns configurados anteriormente como "Forçado" são tratados como opcionais.';
$string['forcesubscribed'] = 'Todos os usuários deste fórum são assinantes';
$string['forcesubscribed_help'] = 'Este fórum foi configurado de forma que você não pode cancelar a sua inscrição nas discussões.';
$string['forum'] = 'Fórum';
$string['forum:addinstance'] = 'Adicionar novo fórum';
$string['forum:addnews'] = 'Acrescentar aviso';
$string['forum:addquestion'] = 'Adicionar questão';
$string['forum:allowforcesubscribe'] = 'Permitir forçar assinatura';
$string['forum:canoverridediscussionlock'] = 'Responder discussões bloqueadas';
$string['forum:canposttomygroups'] = 'Enviar para todos os grupos que você tem acesso';
$string['forum:createattachment'] = 'Criar anexos';
$string['forum:deleteanypost'] = 'Cancelar todas as mensagens (sempre)';
$string['forum:deleteownpost'] = 'Cancelar as próprias mensagens (com limite de tempo)';
$string['forum:editanypost'] = 'Editar qualquer mensagem';
$string['forum:exportdiscussion'] = 'Exportar todo o debate';
$string['forum:exportownpost'] = 'Exportar a própria mensagem';
$string['forum:exportpost'] = 'Exportar mensagem';
$string['forum:managesubscriptions'] = 'Gerenciar assinantes';
$string['forum:movediscussions'] = 'Mover discussões';
$string['forum:pindiscussions'] = 'Destacar discussões';
$string['forum:postwithoutthrottling'] = 'Isento de limite de mensagem';
$string['forum:rate'] = 'Avaliar mensagens';
$string['forum:replynews'] = 'Comentar o aviso';
$string['forum:replypost'] = 'Responder às mensagens';
$string['forum:splitdiscussions'] = 'Separar discussões';
$string['forum:startdiscussion'] = 'Iniciar novas discussões';
$string['forum:viewallratings'] = 'Ver todas as qualificações emitidas pelos usuários';
$string['forum:viewanyrating'] = 'Ver todas as avaliações de todos os estudantes';
$string['forum:viewdiscussion'] = 'Ver discussões';
$string['forum:viewhiddentimedposts'] = 'Ver mensagens escondidas';
$string['forum:viewqandawithoutposting'] = 'Ver sempre mensagens Q e A';
$string['forum:viewrating'] = 'Ver as suas avaliações';
$string['forum:viewsubscribers'] = 'Ver assinantes';
$string['forumauthorhidden'] = 'Autor (oculto)';
$string['forumblockingalmosttoomanyposts'] = 'Você está se aproximando do limite de publicações. Você publicou {$a->numposts} vezes no último {$a->blockperiod} e o limite é de {$a->blockafter} mensagens.';
$string['forumbodydeleted'] = 'O conteúdo desta postagem no fórum foi removido e não pode mais ser acessado.';
$string['forumbodyhidden'] = 'Este post não pode ser visualizada por você, provavelmente porque você ainda não postou na discussão, o tempo máximo de edição ainda não terminou, a discussão não iniciou ou a discussão expirou.';
$string['forumintro'] = 'Descrição';
$string['forumname'] = 'Nome do Fórum';
$string['forumposts'] = 'Mensagens do fórum';
$string['forums'] = 'Fóruns';
$string['forumsubjectdeleted'] = 'Esta postagem no fórum foi removida';
$string['forumsubjecthidden'] = 'Assunto (oculto)';
$string['forumtracked'] = 'As mensagens não lidas são evidenciadas';
$string['forumtrackednot'] = 'As mensagens não lidas não são evidenciadas';
$string['forumtype'] = 'Tipo de Fórum';
$string['forumtype_help'] = 'Existem 5 tipos de fórum:

* Uma única discussão simples - Um único tópico de discussão onde todos podem responder (não pode ser usado com grupos separados);
* Cada pessoa publica uma discussão - Cada aluno pode publicar exatamente um novo tópico de discussão, para que todos possam responder;
* Fórum de perguntas e repostas - Os estudantes devem postar primeiro antes de ver as publicações dos outros participantes;
* Fórum padrão exibido em formato de blog - Um fórum aberto onde qualquer um pode iniciar uma nova discussão a qualquer momento, e os tópicos de discussão são exibidos em uma página com links "Responder este tópico";
* Fórum padrão para uso geral - Um fórum aberto onde qualquer pessoa pode iniciar uma nova discussão a qualquer momento.';
$string['generalforum'] = 'Fórum geral';
$string['generalforums'] = 'Fóruns gerais';
$string['hiddenforumpost'] = 'Esconder post do fórum';
$string['indicator:cognitivedepth'] = 'Indicador cognitivo do Fórum';
$string['indicator:cognitivedepth_help'] = 'Este indicador baseia-se na profundidade cognitiva alcançada pelo estudante em uma atividade Fórum.';
$string['indicator:socialbreadth'] = 'Indicador social do Fórum';
$string['indicator:socialbreadth_help'] = 'Este indicador baseia-se na amplitude social alcançada pelo estudante em uma atividade Fórum.';
$string['inforum'] = 'em {$a}';
$string['introblog'] = 'As mensagens deste fórum foram copiadas aqui automaticamente a partir dos blogs dos usuarios deste curso uma vez que essas entradas de blog não mais estão disponíveis.';
$string['intronews'] = 'Notícias e avisos';
$string['introsocial'] = 'Um fórum para conversar sobre tudo o que você quiser';
$string['introteacher'] = 'Um fórum reservado aos professores';
$string['invalidaccess'] = 'Esta página não foi acessada corretamente';
$string['invaliddigestsetting'] = 'Uma configuração de resumo de email inválida foi fornecida';
$string['invaliddiscussionid'] = 'A identificação da discussão é incorreta ou já não existe mais';
$string['invalidforcesubscribe'] = 'Modo de assinatura forçada inválida';
$string['invalidforumid'] = 'A identificação do fórum foi incorreta';
$string['invalidparentpostid'] = 'Identificação da mensagem superior incorreta';
$string['invalidpostid'] = 'Identificação de mensagem inválida - {$a}';
$string['lastpost'] = 'Última mensagem';
$string['learningforums'] = 'Fóruns para atividades de aprendizagem';
$string['lockdiscussionafter'] = 'Bloquear discussões após período de inatividade';
$string['lockdiscussionafter_help'] = 'As discussões podem ser bloqueadas automaticamente após um tempo especificado decorrido desde a última resposta.

Os usuários com permissões para responder a discussões bloqueadas podem desbloquear um tópico inserindo uma resposta a ele.';
$string['longpost'] = 'Mensagem longa';
$string['mailnow'] = 'Enviar notificações de postagem no fórum sem aguardar o intervalo de edição';
$string['managesubscriptionsoff'] = 'Finalizar gerenciando de assinaturas';
$string['managesubscriptionson'] = 'Gerenciar assinantes';
$string['manydiscussions'] = 'Discussões por página';
$string['markalldread'] = 'Marcar todas as mensagens desta discussão como lidas.';
$string['markallread'] = 'Marcar todas as mensagens deste fórum como lidas.';
$string['markasreadonnotification'] = 'Ao enviar notificações de mensagens do fórum';
$string['markasreadonnotification_help'] = 'Ao receber uma notificação de uma mensagem de um fórum, pode escolher se isso deve marcar a mensagem como lida para fins de sinalização de mensagens do fórum.';
$string['markasreadonnotificationno'] = 'Não marque a mensagem como lida';
$string['markasreadonnotificationyes'] = 'Marcar a mensagem como lida';
$string['markread'] = 'Marcar como lida';
$string['markreadbutton'] = 'Marcar como<br />lida';
$string['markunread'] = 'Marcar como não lida';
$string['markunreadbutton'] = 'Marcar como<br />não lida';
$string['maxattachments'] = 'Número máximo de arquivos anexados';
$string['maxattachments_help'] = 'Este ajuste determina p número máximo de arquivos que se podem anexar a uma mensagem do fórum.';
$string['maxattachmentsize'] = 'Tamanho máximo do anexo';
$string['maxattachmentsize_help'] = '<P>É possível definir a dimensão máxima dos anexos das mensagens do fórum.</p>

<P>Os arquivos com dimensão superior àquela definida não serão transferidos ao servidor. Uma mensagem de erro será visualizada.</p>';
$string['maxtimehaspassed'] = 'Sinto muito, mas o prazo para editar esta mensagem ({$a})terminou!';
$string['message'] = 'Mensagem';
$string['messageinboundattachmentdisallowed'] = 'Não foi possível publicar sua resposta, uma vez que ela inclui um anexo e o fórum não permite anexos.';
$string['messageinboundfilecountexceeded'] = 'Não foi possível publicar sua resposta, já que inclui mais do que o número máximo de anexos permitidos para o fórum ({$a->forum->maxattachments}).';
$string['messageinboundfilesizeexceeded'] = 'Não foi possível publicar sua resposta, uma vez que o tamanho total  ({$a->filesize}) é maior do que o tamanho máximo permitido para o fórum ({$a->maxbytes}).';
$string['messageinboundforumhidden'] = 'Não foi possível publicar sua resposta, uma vez que o fórum está indisponível no momento.';
$string['messageinboundnopostforum'] = 'Não foi possível postar sua resposta, já que você não tem permissão para postar no fórum {$a->forum->name}.';
$string['messageinboundthresholdhit'] = 'Não é possível postar sua resposta. Você excedeu o limite de postagem marcada para este fórum';
$string['messageprovider:digests'] = 'Compilação de fóruns assinados';
$string['messageprovider:posts'] = 'Mensagens de fóruns assinados';
$string['missingsearchterms'] = 'Os seguintes termos da busca se encontram apenas no código HTML desta mensagem:';
$string['modeflatnewestfirst'] = 'Mostrar respostas começando pela mais recente';
$string['modeflatoldestfirst'] = 'Mostrar respostas começando pela mais antiga';
$string['modenested'] = 'Mostrar respostas aninhadas';
$string['modethreaded'] = 'Listar respostas';
$string['modulename'] = 'Fórum';
$string['modulename_help'] = 'O módulo de atividade fórum permite que participantes tenham discussões assíncronas, ou seja, discussões que acontecem durante um longo período de tempo.

Existem vários tipos de fóruns que você pode escolher, como o fórum padrão onde qualquer um pode iniciar uma discussão a qualquer momento; um fórum onde cada estudante pode postar apenas uma discussão; ou um fórum de perguntas e respostas onde os estudantes devem primeiro fazer um post para então serem autorizados a ver os outros posts de outros estudantes. Um professor pode permitir que arquivos sejam anexados aos posts dos fóruns. As imagens anexadas são exibidas no post do fórum.

Participantes podem assinar um fórum para receber notificações de novos posts do fórum. Um professor pode definir o modo de assinatura como opcional, forçado ou automático, ou proibir as assinaturas completamente. Se necessário, é possível estabelecer um número máximo de postagens num determinado período de tempo; isto pode prevenir que alguns indivíduos dominem as discussões.

Posts dos fóruns podem ser avaliados pelo professor ou pelos estudantes (avaliação por pares). As avaliações podem ser agregadas para formar uma única nota final a ser gravada no livro de notas.

Fórum tem muitas utilidades, como

* Um espaço social para os estudantes se conhecerem
* Anúncios sobre o curso (usando um fórum de notícias com assinatura forçada)
* Para discutir conteúdos do curso ou os materiais para leitura
* Para continuar online uma discussão iniciada em sala de aula
* Para discussões entre os professores (utilize um fórum oculto)
* Uma central de ajuda onde tutores e estudantes podem conseguir ajuda
* Uma área de suporte um-para-um para comunicações particulares entre professor e estudante (usando um fórum com grupos separados e um estudante por grupo)
* Para atividades de extensão, por exemplo "brainstorms" para estudantes sugerirem e avaliarem idéias';
$string['modulename_link'] = 'mod/forum/view';
$string['modulenameplural'] = 'Fóruns';
$string['more'] = 'mais';
$string['movedmarker'] = '(Movida)';
$string['movethisdiscussionto'] = 'Transfira esta discussão para ...';
$string['mustprovidediscussionorpost'] = 'Você deve propiciar uma identificação de discussão ou de mensagem para exportar.';
$string['myprofileotherdis'] = 'Discussões do fórum';
$string['myprofileowndis'] = 'Minhas discussões do fórum';
$string['myprofileownpost'] = 'Meus posts no fórum';
$string['namenews'] = 'Avisos';
$string['namenews_help'] = '<p>O fórum de avisos é um fórum especial que é automaticamente criado para cada curso e para a página principal do site e é um espaço para avisos gerais. Só é possível ter um único fórum de avisos por curso.</p>

<p>O bloco "Últimos Avisos" mostra os avisos mais recentes deste fórum especial (mesmo que se mude o nome dele). Por esta razão o fórum será recriado automaticamente pelo Moodle se o bloco Últimas Notícias está sendo usado.</p>';
$string['namesocial'] = 'Fórum social';
$string['nameteacher'] = 'Fórum dos professores';
$string['newforumposts'] = 'Novas mensagens no fórum';
$string['nextdiscussiona'] = 'Próxima discussão: {$a}';
$string['noattachments'] = 'Não há arquivos anexados a esta mensagem.';
$string['nodiscussions'] = 'Ainda não há nenhum tópico de discussão neste fórum';
$string['nodiscussionsstartedby'] = '{$a} não iniciou nenhuma discussão';
$string['nodiscussionsstartedbyyou'] = 'Você não iniciou nenhuma discussão ainda';
$string['noguestpost'] = 'Desculpe, visitantes não podem enviar mensagens.';
$string['noguestsubscribe'] = 'Desculpe, visitantes não estão autorizados a se inscrever.';
$string['noguesttracking'] = 'Sinto muito, os visitantes não podem definir opções de monitoramento.';
$string['nomorepostscontaining'] = 'Não foram encontradas outras mensagens que contenham \'{$a}\'';
$string['nonews'] = 'Nenhum aviso publicado.';
$string['noonecansubscribenow'] = 'As assianturas não estão permitidas neste momento';
$string['nopermissiontosubscribe'] = 'Você não tem permissão para ver os assinantes do fórum';
$string['nopermissiontoview'] = 'Você não tem permissão para ver esta mensagem';
$string['nopostforum'] = 'Sinto muito, você não pode escrever mensagnes neste fórum';
$string['noposts'] = 'Nenhuma mensagem';
$string['nopostsmadebyuser'] = '{$a} não criou nenhuma mensagem';
$string['nopostsmadebyyou'] = 'Você não enviou nenhuma mensagem';
$string['noquestions'] = 'Ainda não há questões neste fórum';
$string['nosubscribers'] = 'Este fórum não tem nenhum assinante';
$string['notexists'] = 'O debate já não mais existe.';
$string['nothingnew'] = 'Nenhuma novidade em {$a}';
$string['notingroup'] = 'Sinto muito mas você precisa ser membro de um grupo para acessar este fórum.';
$string['notinstalled'] = 'O módulo de fórum não está instalado.';
$string['notpartofdiscussion'] = 'Esta mensagem não é parte da discussão!';
$string['notrackforum'] = 'Não monitorar mensagens não lidas';
$string['notsubscribed'] = 'Assinar';
$string['noviewdiscussionspermission'] = 'Você não tem permissão para ver discussões neste fórum';
$string['nowallsubscribed'] = 'Assinatura ativada em todos os fóruns de {$a}.';
$string['nowallunsubscribed'] = 'Nenuma assinatura nos fóruns de {$a}.';
$string['nownotsubscribed'] = '{$a->name} não receberá cópias de novos posts em \'{$a->forum}\' por e-mail';
$string['nownottracking'] = '{$a->name} não está mais monitorando \'{$a->forum}\'.';
$string['nowsubscribed'] = '{$a->name} receberá cópias de novas mensagens de  \'{$a->forum}\' via e-mail';
$string['nowtracking'] = '{$a->name} está monitorando \'{$a->forum}\'.';
$string['numposts'] = '{$a} mensagens';
$string['olderdiscussions'] = 'Discussões mais antigas';
$string['oldertopics'] = 'Tópicos antigos';
$string['oldpostdays'] = 'Ler após dias';
$string['overviewnumpostssince'] = '{$a} postagens desde o último acesso';
$string['overviewnumunread'] = 'Total de não lidas {$a}';
$string['page-mod-forum-discuss'] = 'Página do tópico de discussão do módulo fórum';
$string['page-mod-forum-view'] = 'Página principal do módulo Fórum';
$string['page-mod-forum-x'] = 'Qualquer página do módulo Fórum';
$string['parent'] = 'Mostrar principal';
$string['parentofthispost'] = 'Mensagem original';
$string['permalink'] = 'Link direto';
$string['pluginadministration'] = 'Administração do fórum';
$string['pluginname'] = 'Fórum';
$string['postadded'] = '<p>A sua mensagem foi enviada com sucesso.</p><p>Você tem {$a} para editá-la se quiser fazer alguma alteração.';
$string['postaddedsuccess'] = 'A sua mensagem foi publicada.';
$string['postaddedtimeleft'] = 'Você pode modificar o texto apenas nos próximos {$a}.';
$string['postbymailsuccess'] = 'Parabéns, o seu post no fórum com o assunto "{$a->subject}" foi adicionado com sucesso. Você pode vê-lo em {$a->discussionurl}.';
$string['postbymailsuccess_html'] = 'Parabéns, o seu <a href="{$a->discussionurl}">post no fórum</a> com o assunto "{$a->subject}" foi publicado com sucesso.';
$string['postbyuser'] = '{$a->post} por {$a->user}';
$string['postincontext'] = 'Veja esta mensagem em seu contexto';
$string['postmailinfolink'] = 'Esta é uma cópia da mensagem postada no {$a->coursename}.

Para respondê-la clique neste link: {$a->replylink}';
$string['postmailnow'] = '<p>Esta mensagem será enviada imediatamente para todos os assinantes deste fórum.</p>';
$string['postmailsubject'] = '{$a->courseshortname}: {$a->subject}';
$string['postrating1'] = 'Sobretudo saber destacado';
$string['postrating2'] = 'Destacado e conectado';
$string['postrating3'] = 'Sobretudo saber conectado';
$string['posts'] = 'Mensagens';
$string['postsmadebyuser'] = 'Mensagem enviada por {$a}';
$string['postsmadebyuserincourse'] = 'Mensagens criadas por {$a->fullname} em {$a->coursename}';
$string['posttoforum'] = 'Enviar mensagem ao fórum';
$string['posttomygroups'] = 'Enviar uma cópia a todos os grupos';
$string['posttomygroups_help'] = 'Envia uma cópia dessa mensagem a todos os grupos que você tem acesso. Os participantes dos grupos que você não têm acesso não verão esta mensagem';
$string['postupdated'] = 'A sua mensagem foi atualizada';
$string['potentialsubscribers'] = 'Potenciais assinantes';
$string['prevdiscussiona'] = 'Discussão anterior: {$a}';
$string['privacy:digesttypenone'] = 'Não mantemos nenhum dado relacionado a um tipo de resumo de fórum preferencial para este fórum.';
$string['privacy:digesttypepreference'] = 'Você escolheu receber o seguinte tipo de resumo do fórum: "{$a->type}".';
$string['privacy:discussionsubscriptionpreference'] = 'Você escolheu a seguinte preferência de inscrição de discussão para este fórum: "{$a->preference}"';
$string['privacy:metadata:core_rating'] = 'O fórum faz uso do subsistema de classificação para suportar a classificação de postagens.';
$string['privacy:metadata:core_tag'] = 'O fórum faz uso do subsistema de tags para suportar a marcação de postagens.';
$string['privacy:metadata:forum_digests'] = 'Informações sobre as preferências de resumo para cada fórum.';
$string['privacy:metadata:forum_digests:forum'] = 'Fórum subscrito.';
$string['privacy:metadata:forum_digests:maildigest'] = 'Preferências de resumo';
$string['privacy:metadata:forum_digests:userid'] = 'O ID do usuário com a preferência de resumo.';
$string['privacy:metadata:forum_discussion_subs'] = 'Informações sobre as inscrições para discussões individuais no fórum';
$string['privacy:metadata:forum_discussion_subs:discussionid'] = 'O ID da discussão que foi assinada.';
$string['privacy:metadata:forum_discussion_subs:preference'] = 'A hora de início da assinatura.';
$string['privacy:metadata:forum_discussion_subs:userid'] = 'O ID do usuário com a assinatura de discussão.';
$string['privacy:metadata:forum_discussions'] = 'Informações sobre as discussões individuais no fórum que um usuário criou';
$string['privacy:metadata:forum_discussions:assessed'] = 'TODOD - o que esse armazenamento de campo';
$string['privacy:metadata:forum_discussions:name'] = 'O nome da discussão, conforme escolhido pelo autor.';
$string['privacy:metadata:forum_discussions:timemodified'] = 'A hora em que a discussão foi modificada pela última vez.';
$string['privacy:metadata:forum_discussions:userid'] = 'O ID do usuário que criou a discussão';
$string['privacy:metadata:forum_discussions:usermodified'] = 'O ID do usuário que modificou a discussão pela última vez de alguma forma.';
$string['privacy:metadata:forum_posts'] = 'Informações sobre as preferências de resumo para cada fórum.';
$string['privacy:metadata:forum_posts:created'] = 'A hora em que a postagem foi criada.';
$string['privacy:metadata:forum_posts:discussion'] = 'A discussão em que o post está.';
$string['privacy:metadata:forum_posts:message'] = 'A mensagem da postagem no fórum.';
$string['privacy:metadata:forum_posts:modified'] = 'O horário em que a postagem foi modificada pela última vez.';
$string['privacy:metadata:forum_posts:parent'] = 'A publicação principal que foi respondida.';
$string['privacy:metadata:forum_posts:subject'] = 'O assunto da postagem no fórum.';
$string['privacy:metadata:forum_posts:totalscore'] = 'A mensagem da postagem no fórum.';
$string['privacy:metadata:forum_posts:userid'] = 'ID do usuário que criou a postagem no fórum.';
$string['privacy:metadata:forum_queue'] = 'Log temporário dos posts que serão enviados no formato resumido';
$string['privacy:metadata:forum_queue:discussionid'] = 'ID de discussão do fórum';
$string['privacy:metadata:forum_queue:postid'] = 'ID da postagem do fórum';
$string['privacy:metadata:forum_queue:timemodified'] = 'O horário modificado da postagem original';
$string['privacy:metadata:forum_queue:userid'] = 'Usuário que precisa ser notificado da postagem';
$string['privacy:metadata:forum_read'] = 'Informações sobre quais postagens foram lidas pelo usuário.';
$string['privacy:metadata:forum_read:discussionid'] = 'A discussão em que o post está.';
$string['privacy:metadata:forum_read:firstread'] = 'A primeira vez que o post foi lido.';
$string['privacy:metadata:forum_read:lastread'] = 'A hora mais recente em que o post foi lido.';
$string['privacy:metadata:forum_read:postid'] = 'O post que foi lido.';
$string['privacy:metadata:forum_read:userid'] = 'O ID do usuário ao qual esse registro está relacionado.';
$string['privacy:metadata:forum_subscriptions'] = 'Informações sobre em quais fóruns o usuário se inscreveu.';
$string['privacy:metadata:forum_subscriptions:forum'] = 'O fórum que foi inscrito.';
$string['privacy:metadata:forum_subscriptions:userid'] = 'O ID do usuário ao qual essa inscrição no fórum está relacionada.';
$string['privacy:metadata:forum_track_prefs'] = 'Informação sobre quais fóruns o usuário escolheu monitorar a leitura de mensagem.';
$string['privacy:metadata:forum_track_prefs:forumid'] = 'O fórum que possui o monitoramento de leitura ativado.';
$string['privacy:metadata:forum_track_prefs:userid'] = 'O ID do usuário que esta preferência de monitoramento do fórum está relacionada.';
$string['privacy:metadata:preference:autosubscribe'] = 'Se inscrever para discussões ao responder a mensagens dentro deles.';
$string['privacy:metadata:preference:maildigest'] = 'The site-wide mail digest preference';
$string['privacy:metadata:preference:markasreadonnotification'] = 'Se deve marcar as postagens do fórum como lidas ao recebê-las como mensagens.';
$string['privacy:metadata:preference:trackforums'] = 'Se deve habilitar o monitoramento de leitura.';
$string['privacy:postwasread'] = 'Esta postagem foi lida pela primeira vez em {$a->firstread} e, mais recentemente, lida em {$a->lastread}';
$string['privacy:readtrackingdisabled'] = 'Você escolheu não monitorar a leitura de posts neste fórum';
$string['privacy:request:delete:discussion:name'] = 'Excluir a pedido do autor';
$string['privacy:request:delete:post:message'] = 'O conteúdo desta postagem foi excluído a pedido do autor.';
$string['privacy:request:delete:post:subject'] = 'Excluir a pedido do autor';
$string['privacy:subscribedtoforum'] = 'Você está inscrito neste fórum.';
$string['processingdigest'] = 'Processando digest para o usuário {$a}';
$string['processingpost'] = 'Processando mensagem {$a}';
$string['prune'] = 'Interromper';
$string['prunedpost'] = 'Foi criada uma nova discussão com esta mensagem inicial';
$string['pruneheading'] = 'Interromper a mensagem e mover para uma nova discussão';
$string['qandaforum'] = 'Fórum P e R (perguntas e respostas)';
$string['qandanotify'] = 'Este é um fórum de perguntas e respostas. Você poderá ler as respostas dadas por outros participantes a partir do momento em que publicar a sua resposta.';
$string['re'] = 'Re:';
$string['readtherest'] = 'Leia o resto deste tópico';
$string['removeallforumtags'] = 'Remover todas as tags do fórum';
$string['replies'] = 'Comentários';
$string['repliesmany'] = '{$a} respostas até agora';
$string['repliesone'] = '{$a} resposta até agora';
$string['reply'] = 'Responder';
$string['reply_handler'] = 'Responder a posts no fórum por e-mail';
$string['reply_handler_name'] = 'Responder a posts no fórum';
$string['replyforum'] = 'Responder ao fórum';
$string['replytopostbyemail'] = 'Você pode responder por e-mail.';
$string['replytouser'] = 'Usar endereço email na resposta';
$string['resetdigests'] = 'Excluir todas as configurações de email por usuário';
$string['resetforums'] = 'Excluir as mensagens de';
$string['resetforumsall'] = 'Excluir todas as mensagens';
$string['resetsubscriptions'] = 'Excluir todas as assinaturas do fórum';
$string['resettrackprefs'] = 'Excluir todas as preferências de rastreamento dos fóruns';
$string['rssarticles'] = 'Número de artígos recientes RSS';
$string['rssarticles_help'] = '<P>Esta configuração permite a escolha do número de artigos a serem incluídos no alimentador RSS.</p>

<P>Um número entre 5 e 20 é adequado à maior parte dos fóruns.  Aumente este valor nos fóruns em que a atividade é frequente.</p>';
$string['rsssubscriberssdiscussions'] = 'RSS feed das discussões';
$string['rsssubscriberssposts'] = 'RSS feed dos posts';
$string['rsstype'] = 'RSS feed desta atividade';
$string['rsstype_help'] = '<P>Esta opção configura a ativação de alimentadores RSS no fórum.</p>

<P>É possível escolher entre dois tipos de alimentadores RSS:</p>

<UL>
<LI><B>Tópicos:</B> Os alimentadores RSS incluirão apenas a mensagem inicial dos novos tópicos de discussão do fórum.</li>

<LI><B>Mensagens:</B> Os alimentadores RSS incluirão todas as mensagens do fórum.</li>
</UL>';
$string['rsstypedefault'] = 'Tipo do RSS feed';
$string['search'] = 'Buscar';
$string['search:activity'] = 'Fórum - informações da atividade';
$string['search:post'] = 'Fórum - mensagens';
$string['searchdatefrom'] = 'As mensagens devem ser mais recentes que esta';
$string['searchdateto'] = 'As mensagens devem ser mais antigas que esta';
$string['searchforumintro'] = 'Por favor inserir os termos para a busca em um ou mais dos seguintes campos:';
$string['searchforums'] = 'Buscar no fórum';
$string['searchfullwords'] = 'Estas palavras devem ser consideradas como palavras completas';
$string['searchnotwords'] = 'Estas palavras não devem ser incluídas';
$string['searcholderposts'] = 'Buscar nas mensagens mais antigas...';
$string['searchphrase'] = 'Esta frase exata deve fazer parte da mensagem';
$string['searchresults'] = 'Resultados da busca';
$string['searchsubject'] = 'Estas palavras devem fazer parte do título';
$string['searchtags'] = 'Está marcado com';
$string['searchuser'] = 'Este nome deve corresponder ao autor';
$string['searchuserid'] = 'ID do autor';
$string['searchwhichforums'] = 'Escolher os fóruns para a busca';
$string['searchwords'] = 'Estas palavras podem ser contidas em qualquer lugar da mensagem';
$string['seeallposts'] = 'Ver todas as mensagens criadas por este usuário';
$string['shortpost'] = 'Mensagem breve';
$string['showsubscribers'] = 'Mostrar assinantes';
$string['singleforum'] = 'Uma única discussão simples';
$string['smallmessage'] = '{$a->user} enviou mensagem em {$a->forumname}';
$string['smallmessagedigest'] = 'O resumo do fórum contém {$a} mensagens';
$string['startedby'] = 'Autor';
$string['subject'] = 'Assunto';
$string['subscribe'] = 'Assinar este fórum';
$string['subscribeall'] = 'Inscrever todos os participantes neste fórum';
$string['subscribed'] = 'Assinante';
$string['subscribediscussion'] = 'Inscrever-se neste debate';
$string['subscribeenrolledonly'] = 'Desculpe, apenas os usuários inscritos podem assinar o fórum para receber as notificações de postagem.';
$string['subscribenone'] = 'Cancelar a inscrição de todos os participantes deste fórum';
$string['subscribers'] = 'Assinantes';
$string['subscriberstowithcount'] = 'Inscritos para "{$a->name}" ({$a->count})';
$string['subscribestart'] = 'Me envie notificações de novos posts neste fórum';
$string['subscribestop'] = 'Não quero receber notificações de novos posts deste fórum';
$string['subscription'] = 'Assinatura';
$string['subscription_help'] = 'Se você assina um fórum, isso quer dizer que você irá receber notificações de posts novos no fórum. Normalmente você pode escolher se deseja assinar, apesar de as vezes a assinatura ser forçada para que todas recebam notificações.';
$string['subscriptionandtracking'] = 'Assinatura e monitoramento';
$string['subscriptionauto'] = 'Assinatura automática';
$string['subscriptiondisabled'] = 'Assinatura desabilitada';
$string['subscriptionforced'] = 'Assinatura forçada';
$string['subscriptionmode'] = 'Modo de assinatura';
$string['subscriptionmode_help'] = 'Quando um participante assina um fórum, isto quer dizer que ele irá receber notificações de novos posts. Existem 4 tipos de assinatura:

* Assinatura opcional - Participantes podem escolher se querem se inscrever
* Assinatura forçada - Todos são assinantes e não conseguem cancelar a assinatura
* Assinatura automática - Todos são inicialmente assinantes mas podem escolher deixar de assinar a qualquer momento
* Assinatura desabilitada - Assinaturas não são permitidas';
$string['subscriptionoptional'] = 'Assinatura opcional';
$string['subscriptions'] = 'Assinaturas';
$string['tagarea_forum_posts'] = 'Posts do fórum';
$string['tagsdeleted'] = 'As tags do fórum foram excluídas';
$string['thisforumisthrottled'] = 'Neste fórum o número de mensagens que você pode publicar é limitado a {$a->blockafter} mensagens no período de {$a->blockperiod}';
$string['timedhidden'] = 'Status temporário: escondido dos estudantes';
$string['timedposts'] = 'Mensagens com tempo definido';
$string['timedvisible'] = 'Status temporário: visível para todos os usuários';
$string['timestartenderror'] = 'A data final não pode ser anterior à data inicial';
$string['trackforum'] = 'Monitorar mensagens não lidas';
$string['tracking'] = 'Monitorar';
$string['trackingoff'] = 'Desativar';
$string['trackingon'] = 'Forçado';
$string['trackingoptional'] = 'Opcional';
$string['trackingtype'] = 'Monitorar leitura';
$string['trackingtype_help'] = 'A opção de monitorar leitura permite que os participantes verifiquem facilmente quais as mensagens ainda não foram lidas, colocando em evidência as novas mensagens.

Se configurado como opcional, os participantes podem escolher se desejam ativar ou desativar o monitoramento através de um link no bloco de administração. (Os usuários também devem ativar o monitoramento do fórum em suas preferências de fórum).

Se \'Permitir monitoramento de leitura forçado\' estiver habilitado na administração do site, uma outra opção fica disponível - forçado. Isso significa que o monitoramento será sempre ativado, independentemente das preferências de fórum configuradas no perfil dos usuários.';
$string['trackreadposts_header'] = 'Monitoramento do fórum';
$string['unread'] = 'Não lida';
$string['unreadposts'] = 'Mensagens não lidas';
$string['unreadpostsnumber'] = '{$a} mensagens não lidas';
$string['unreadpostsone'] = '1 mensagem não lida';
$string['unsubscribe'] = 'Suspender o recebimento de mensagens deste fórum via email';
$string['unsubscribeall'] = 'Suspender o recebimento de mensagens de todos os fóruns via email';
$string['unsubscribeallconfirm'] = 'Atualmente você está assinando {$a->forums} fóruns e {$a->discussions} discussões. Você realmente quer deixar de assinar todos os fóruns e discussões e desabilitar a assinatura automática?';
$string['unsubscribeallconfirmdiscussions'] = 'Atualmente você está assinando {$a->discussions} discussões. Você realmente quer deixar de assinar todas as discussões e desativar a assinatura automática de discussão?';
$string['unsubscribeallconfirmforums'] = 'Atualmente você está assinando  {$a->forums} fóruns. Você realmente quer deixar de assinar todos os fóruns e desativar a assinatura automática de discussão?';
$string['unsubscribealldone'] = 'Todas as suas assinaturas foram removidas. Você ainda vai receber notificações de fóruns configurados como assinatura obrigatória. Para gerenciar as notificações vá em Mensagem, em "Minhas configurações de perfil".';
$string['unsubscribeallempty'] = 'Você não é assinante de nenhum fórum.Se você não deseja receber qualquer e-mail deste site, por favor altere seu perfil desativando seu endereço de e-mail.';
$string['unsubscribed'] = 'Cancelado o recebimento de cópias das mensagens via email';
$string['unsubscribediscussion'] = 'Desinscrever da discussão';
$string['unsubscribediscussionlink'] = 'Deixar de assinar esta discussão: {$a}';
$string['unsubscribelink'] = 'Deixar de assinar este fórum: {$a}';
$string['unsubscribeshort'] = 'Cancelar assinatura';
$string['usermarksread'] = 'Marcar como lido manualmente';
$string['viewalldiscussions'] = 'Ver todas as discussões';
$string['viewthediscussion'] = 'Ver a discussão';
$string['warnafter'] = 'Limite de mensagem para aviso';
$string['warnafter_help'] = '<p>O conceito de limite do envio de mensagens é muito simples.
Os usuários serão impedidos de enviar mensagens depois de atingir um número de mensagens enviadas num dado período. Eles receberão avisos quando se aproximarem deste limite.</p>

<p>Configurando o limite para enviar avisos como 0 (zero) estes avisos são desabilitados.
Configurando o limite de mensagens enviadas como 0 (zero) o bloqueio é desabilitado.
Se o bloqueio estiver desabilitado, os avisos serão automaticamente desativados.</p>

<p> Nenhuma destas configuraços afetará o envio de mensagens pelos professores</p>';
$string['warnformorepost'] = 'Atenção! Existe mais do que uma discussão neste fórum - usando a mais recente';
$string['yournewquestion'] = 'A sua nova pergunta';
$string['yournewtopic'] = 'Novo tópico de discussão';
$string['yourreply'] = 'A sua resposta';
