<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'lti', language 'eu', version '3.5'.
 *
 * @package     lti
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accept'] = 'Onartu';
$string['accept_grades'] = 'Onartu kalifikazioak tresnatik';
$string['accept_grades_admin'] = 'Onartu kalifikazioak tresnatik';
$string['accept_grades_admin_help'] = 'Zehaztu tresna-hornitzaileak instantziekin lotutako kalifikazioak gehitu, eguneratu, irakurri eta ezabatu ahal izango dituen.

Tresna-hornitzaile batzuek tresnaren barruko ekintzetan oinarritutako kalifikazioak Moodlera pasatzea ahalbidetzen dute, esperientzia integratuagoa lortuz.';
$string['accept_grades_help'] = 'Zehaztu tresna-hornitzaileak instantziekin lotutako kalifikazioak gehitu, eguneratu, irakurri eta ezabatu ahal izango dituen.

Tresna-hornitzaile batzuek tresnaren barruko ekintzetan oinarritutako kalifikazioak Moodlera pasatzea ahalbidetzen dute, esperientzia integratuagoa lortuz.

Ohartu ezarpen hau tresnaren konfigurazioak baliogabe dezakeela.';
$string['accepted'] = 'Onartua';
$string['action'] = 'Ekintza';
$string['activate'] = 'Aktibatu';
$string['activatetoadddescription'] = 'Tresna hau aktibatu behar duzu deskribapena gehitu baino lehen.';
$string['active'] = 'Aktiboa';
$string['activity'] = 'Jarduera';
$string['addnewapp'] = 'Gaitu kanpoko aplikazioa';
$string['addserver'] = 'Gehitu konfiantzazko beste zerbitzari bat';
$string['addtype'] = 'Gehitu aurretik konfiguratutako tresna';
$string['allow'] = 'Baimendu';
$string['allowsetting'] = 'Baimendu tresnek Moodlen ezarpenen 8K gordetzen.';
$string['always'] = 'Beti';
$string['autoaddtype'] = 'Gehitu tresna';
$string['automatic'] = 'Automatikoa, erremintaren URLan oinarritua';
$string['baseurl'] = 'URL oinarria/tresnaren erregistro-izena';
$string['basiclti'] = 'LTI';
$string['basiclti_base_string'] = 'LTI OAuth-en oinarrizko katea';
$string['basiclti_endpoint'] = 'LTI abiarazteko amaiera-puntua';
$string['basiclti_in_new_window'] = 'Zure jarduera leiho berrian zabaldu da';
$string['basiclti_in_new_window_open'] = 'Ireki leiho berrian';
$string['basiclti_parameters'] = 'LTIko hasierako parametroak';
$string['basicltiactivities'] = 'LTI jarduerak';
$string['basicltifieldset'] = 'Eremu-multzo pertsonalizatuaren adibidea';
$string['basicltiintro'] = 'Jardueraren deskribapena';
$string['basicltiname'] = 'Jardueraren izena';
$string['basicltisettings'] = 'Oinarrizko Ikasteko Tresnaren Elkarreragingarritasunaren (LTI) ezarpenak';
$string['cancel'] = 'Utzi';
$string['cancelled'] = 'Bertan behera utzia';
$string['cannot_delete'] = 'Ezin dituzu tresnaren ezarpenak ezabatu';
$string['cannot_edit'] = 'Ezin dituzu tresnaren ezarpenak editatu';
$string['capabilities'] = 'Gaitasunak';
$string['capabilities_help'] = 'Aukeratu tresna-hornitzaileari eskaini nahi zenizkiokeen gaitasunak. Gaitasun bat baino gehiago aukera daiteke.';
$string['capabilitiesrequired'] = 'Tresna honek data hauetarako sarbidea eskatzen du gaitu ahal izateko:';
$string['click_to_continue'] = '<a href="{$a->link}" target="_top">Egin klik jarraitzeko</a>';
$string['comment'] = 'Iruzkina';
$string['configpassword'] = 'Urrutiko tresnan lehenetsitako pasahitza';
$string['configpreferheight'] = 'Lehenetsitako altuera';
$string['configpreferwidget'] = 'Gailuaren abiarazteko lehenetsitako widget-a';
$string['configpreferwidth'] = 'Lehenetsitako zabalera';
$string['configresourceurl'] = 'Baliabideen lehenetsitako URLa';
$string['configtoolurl'] = 'Urrutiko tresnan lehenetsitako URLa';
$string['configtypes'] = 'Gaitu LTI aplikazioak';
$string['configured'] = 'Konfiguratua';
$string['confirmtoolactivation'] = 'Ziur zaude tresna hau aktibatu nahi duzula?';
$string['contentitem'] = 'Eduki-Item Mezua';
$string['contentitem_help'] = 'Hautatuz gero, \'Aukeratu edukia\' aukera eskuragarri izango da kanpoko tresna bat gehitzean.';
$string['course_tool_types'] = 'Ikastaroko tresnak';
$string['courseactivitiesorresources'] = 'Ikastaroko jarduerak edo baliabideak';
$string['courseid'] = 'Ikastaroaren ID zenbakia';
$string['courseinformation'] = 'Ikastaroaren informazioa';
$string['courselink'] = 'Joan ikastarora';
$string['coursemisconf'] = 'Ikastaroa gaizki konfiguratuta dago';
$string['createdon'] = 'Noiz sortua';
$string['curllibrarymissing'] = 'PHP cURL hedapena beharrezkoa da kanpoko tresnarako.';
$string['custom'] = 'Parametro pertsonalizatuak';
$string['custom_config'] = 'Pertsonalizatutko ezarpen-tresna erabiltzen.';
$string['custom_help'] = 'Tresna-hornitzaileek beren ezarpenen artean parametro pertsonalizatuak erabiltzen dituzte. Adibidez, parametro pertsonalizatu bat erabil daiteke hornitzailearen baliabide zehatz bat erakusteko. Parametroak lerro banatan sartuko dira "name=value" formatua erabiliz; esaterako, "chapter=3".

Eremu hori ez aldatzea segurua da, tresna-hornitzaileak zehaztu ezean.';
$string['custominstr'] = 'Parametro pertsonalizatuak';
$string['debuglaunch'] = 'Arazketa-aukera';
$string['debuglaunchoff'] = 'Hasiera arrunta';
$string['debuglaunchon'] = 'Araztu hasiera';
$string['default'] = 'Lehenetsitakoa';
$string['default_launch_container'] = 'Lehenetsitako hasierako edukiontzia';
$string['default_launch_container_help'] = 'Hasierako edukiontziak tresnaren itxurari eragiten dio ikastarotik abiarazten denean. Hasierako edukiontzi batzuek tresnari pantaila-espazio gehiago ematen diote, eta beste batzuek, integrazio hobea Moodle-ren ingurunearekin.

* **Lehenetsi ** - Erabili tresnaren ezarpenek zehaztutako  hasierako edukiontzia.
* **Enbotatu ** - Tresna Moodle-ren leihoan bertan agertzen da, jarduera mota gehienek egiten duten antzeko moduan.
* **Blokerik gabe enbotatu ** - Tresna Moodle-ren leihoan bertan agertzen da, orrialdearen goialdeko nabigazio-kontrolekin.
* *Leiho berria ** - Tresna leiho berri batean irekitzen da, espazio osoa betez.
Nabigatzailearen arabera, fitxa edo leiho berria batean irekiko da.
Baliteke nabigatzaileak leiho berria irekiera eragoztea.';
$string['delegate'] = 'Utzi irakaslearen esku';
$string['delete'] = 'Ezabatu';
$string['delete_confirmation'] = 'Ziur zaude aurretik konfiguratutako tresna ezabatu nahi duzula?';
$string['deletetype'] = 'Ezabatu aurretik konfiguratutako tresna';
$string['display_description'] = 'Erakutsi jardueraren deskribapena hastean';
$string['display_description_help'] = 'Aukeratuz gero, goian zehaztutako jardueraren deskribapena tresna-hornitzailearen edukiaren gainean erakutsiko da.

Deskribapena tresnaren abiarazleentzako argibide gehigarriak emateko erabil daiteke, baina ez da beharrezkoa.

Deskribapena ez da inoiz erakusten tresnaren hasierako edukiontzia leiho berri batean dagoenean.';
$string['display_name'] = 'Erakutsi jardueraren izena';
$string['display_name_help'] = 'Aukeratuz gero, goian zehaztutako jarduera-izena tresna-hornitzailearen edukiaren gainean erakutsiko da.

Baliteke tresna-hornitzaileak izenburua ere erakustea. Aukera honek jardueraren izenburua bi aldiz erakustea saihets dezake.

Izenburua da ez da inoiz erakusten tresnaren hasierako edukiontzia leiho berri batean dagoenean.';
$string['domain_mismatch'] = 'Hasierako URLaren domeinua ez da dator bat tresnaren ezarpenekin.';
$string['donot'] = 'Ez bidali';
$string['donotaccept'] = 'Ez onartu';
$string['donotallow'] = 'Ez baimendu';
$string['duplicateregurl'] = 'Erregistro URL hau jadanik erabiltzen ari da';
$string['editdescription'] = 'Egin klik hemen tresna deskribatzeko';
$string['edittype'] = 'Editatu aurretik konfiguratutako tresna';
$string['embed'] = 'Enbotatu';
$string['embed_no_blocks'] = 'Enbotatu, blokerik gabe';
$string['enableemailnotification'] = 'Bidali jakinarazpenak posta elektroniko bidez';
$string['enableemailnotification_help'] = 'Gaituz gero, ikasleek posta elektroniko bidezko jakinarazpena jasoko dute bidalketak kalifikatzen direnean.';
$string['enterkeyandsecret'] = 'Idatzi kontsumitzaile-gakoa eta sekretu partekatua';
$string['enterkeyandsecret_help'] = 'Kontsumitzaile-gakoa edo/eta sekretu partekatua eman bazaizu, sartu hemen';
$string['errorbadurl'] = 'URLa ez da tresna edo kartutxo baliagarria';
$string['errorincorrectconsumerkey'] = 'Kontsumitzaile-gakoa ez da egokia.';
$string['errorinvaliddata'] = 'Datu baliogabea: {$a}';
$string['errorinvalidmediatype'] = 'Media mota baliogabea: {$a}';
$string['errorinvalidresponseformat'] = 'Eduki-Item baliogabeko erantzun-formatua.';
$string['errormisconfig'] = 'Tresna gaizki konfiguratu da. Mesedez, jarri harremanetan zure Moodle instalazioko kudeatzailearekin tresna ondo konfiguratzeko.';
$string['errortooltypenotfound'] = 'LTI tresna mota ez da aurkitu';
$string['existing_window'] = 'Leiho berean';
$string['extensions'] = 'LTI luzapen zerbitzuak';
$string['external_tool_type'] = 'Aurretik konfiguratutako tresna';
$string['external_tool_type_help'] = '* **Automatikoa, tresnaren URLan oinarritua** - Tresnaren konfigurazio egokiena automatikoki aukeratzen da. Tresnaren URLa ezagutzen ez bada, konfigurazioaren xehetasunak eskuz sartu beharko lirateke.
* **Aurrez konfiguratutako tresna** - Zehaztutako tresnaren konfigurazioa kanpoko tresna-hornitzailearekin komunikatzean erabiliko da. Tresnaren URLa hornitzaileari ez dagokiola baldin badirudi, abisua erakutsiko da. Tresnaren URLa ematea ez da beti beharrezkoa.
* **Konfigurazio pertsonala** - Kontsumitzaile-gakoa eta sekretu partekatua eskuz sartu behar dira. Kontsumitzaile-gakoa eta sekretu partekatua tresnaren hornitzailearengandik jaso behar dira. Hala ere, tresna guztiek ez dute kontsumitzaile-gakorik eskatzen, ezta sekretu partekaturik ere. Kasu horretan, eremuak hutsik utzi behar dira.

### Aurrez konfiguratutako tresna editatzen
Aurrez konfiguratutako tresnaren zerrenda zabalgarrian hiru ikono daude:

* **Gehitu** - Sortu ikastaro mailako tresna-konfigurazioa. Ikastaro honetako tresnaren kanpoko instantzia guztiek tresnaren konfigurazioa erabil dezakete.
* **Editatu** - Aukeratu ikastaro mailako tresna zerrenda zabalgarrian eta egin klik ikonoan. Tresnaren konfigurazioaren xehetasun guztiak edita daitezke.
* **Ezabatu** - Ezabatu aukeratutako ikastaro mailako tresna.';
$string['external_tool_types'] = 'Aurretik konfiguratutako tresnak';
$string['failedtoconnect'] = 'Moodlek ezin izan du "{$a}" sistemarekin komunikatu';
$string['failedtocreatetooltype'] = 'Tresna berria sortzeak huts egin du. Berrikusi URLa eta saiatu berriro, mesedez.';
$string['failedtodeletetoolproxy'] = 'Tresnaren erregistroa ezabatzeak huts egin du. "Kudeatu kanpoko tresnen erregistroak" bisitatu eta eskuz ezabatu beharko duzu.';
$string['filter_basiclti_configlink'] = 'Konfiguratu gogoko guneak eta pasahitzak';
$string['filter_basiclti_password'] = 'Pasahitza derrigorrezkoa da';
$string['filterconfig'] = 'LTIren kudeaketa';
$string['filtername'] = 'LTI';
$string['fixexistingconf'] = 'Erabili dagoeneko existitzen den ezarpena gaizki konfiguratutako instantziarako';
$string['fixnew'] = 'Ezarpen berria';
$string['fixnewconf'] = 'Zehaztu ezarpen berria gaizki konfiguratutako instantziarako';
$string['fixold'] = '.Erabili existitzen dena';
$string['force_ssl'] = 'Behartu SSL';
$string['force_ssl_help'] = 'Hau aukeratzeak tresna honen hornitzailearen abio guztiak SSL erabiltzera behartzen ditu.

Gainera,  tresna honen hornitzailearen web-zerbitzuetako eskaera guztiek SSL erabiliko dute.

Aukera hau gaituz gero, baieztatu Moodle gune honek eta tresna-hornitzaileak SSL onartzen dutela.';
$string['forced_help'] = 'Ezarpen hau ikastaro edo  gunearen mailan konfiguratu da. Litekeena da interfaz honetatik ezin aldatzea.';
$string['generaltool'] = 'Tresna orokorra';
$string['global_tool_types'] = 'Aurretik konfiguratutako tresna orokorrak';
$string['grading'] = 'Kalifikazio-ibilbidea';
$string['icon_url'] = 'Ikonoaren URLa';
$string['icon_url_help'] = 'Ikonoaren URLak jarduera honetarako ikastaro-zerrendan erakusten den ikonoa aldatzea ahalbidetzen du. Lehenetsitako LTI ikonoa erabili ordez, jarduera motari dagokion ikono bat zehaz daiteke.';
$string['id'] = 'ID';
$string['indicator:cognitivedepth'] = 'Gaitasun kognitiboa LTI jardueretan';
$string['indicator:cognitivedepth_help'] = 'Adierazle hau ikasleak LTI motako jardueretan lortutako sakonera kognitiboan oinarrituta dago.';
$string['indicator:socialbreadth'] = 'Gaitasun soziala LTI jardueretan';
$string['indicator:socialbreadth_help'] = 'Helburu hau ikasleak LTI motako jardueretan lortutako zabalera sozialean oinarrituta dago.';
$string['invalidid'] = 'LTIren IDa ez zen egokia';
$string['launch_in_moodle'] = 'Abiarazi tresna Moodle-n';
$string['launch_in_popup'] = 'Abiarazi tresna pop-up-ean';
$string['launch_url'] = 'Tresnaren URLa';
$string['launch_url_help'] = 'Tresnaren URLak kanpoko tresnaren web-helbidea adierazten du, eta erakusteko baliabidea bezalako informazio gehigarria eduki dezake. Tresnaren URLan zer jarri behar duzun seguru ez bazaude, eskatu informazioa tresna-hornitzaileari, mesedez.

Kartutxorik izanez gero, bere URLa sar dezakezu. Inprimakiaren beste xehetasunak automatikoki beteko dira.

Aurrez konfiguratutako tresna aukeratu baduzu, ez duzu tresnaren URLa sartu beharko. Horixe izango da kasua, tresnaren esteka hornitzailearen sisteman abiarazteko erabiltzen bada, eta ez baliabide zehatz batera joateko.';
$string['launchinpopup'] = 'Abiarazi edukiontzia';
$string['launchinpopup_help'] = 'Hasierako edukiontziak tresnaren itxurari eragiten dio ikastarotik abiarazten denean. Hasierako edukiontzi batzuek tresnari pantaila-espazio gehiago ematen diote, eta beste batzuek, integrazio hobeagoa Moodle-ren ingurunearekin.

* **Lehenetsi ** - Erabili tresnaren ezarpenek zehaztutako  hasierako edukiontzia.
* **Enbotatu ** - Tresna Moodle-ren leihoan bertan agertzen da, jarduera mota gehienek egiten duten antzeko moduan.
* **Blokerik gabe enbotatu ** - Tresna Moodle-ren leihoan bertan agertzen da, orrialdearen goialdeko nabigazio-kontrolekin.
* *Leiho berria ** - Tresna leiho berri batean irekitzen da, espazio osoa betez.
Nabigatzailearen arabera, fitxa edo leiho berria batean irekiko da.
Baliteke nabigatzaileak leiho berria irekiera eragoztea.';
$string['launchoptions'] = 'Abiarazte-aukerak';
$string['leaveblank'] = 'Hutsik utzi behar ez badituzu';
$string['lti'] = 'LTI';
$string['lti:addcoursetool'] = 'Gehitu ikastaroaren araberako tresna ezarpenak';
$string['lti:addinstance'] = 'Gehitu kanpoko beste tresna baten jarduerak';
$string['lti:admin'] = 'Tresna abiaraztean izan zaitez kudeatzailea';
$string['lti:grade'] = 'Ikusi kanpoko tresnak itzuli dituen kalifikazioak';
$string['lti:manage'] = 'Irakaslea izan erreminta abiarazten denean';
$string['lti:requesttooladd'] = 'Tresnaren eskaera gune osorako ezarri da';
$string['lti:view'] = 'Abiarazi kanpoko tresnaren jarduerak';
$string['lti_administration'] = 'Editatu aurretik konfiguratutako tresna';
$string['lti_errormsg'] = 'Tresnak ondoko errore-mezua itzuli du: "{$a}"';
$string['lti_launch_error'] = 'Errorea gertatu da kanpoko tresna hastean:';
$string['lti_launch_error_tool_request'] = '<p>
Kudeatzaileari tresnaren ezarpena osa dezala eskatzeko egin klik <a href="{$a->admin_request_url}" target="_top">hemen</a>.
</p>';
$string['lti_launch_error_unsigned_help'] = '<p>Errore hau tresna-hornitzailearentzako kontsumitzaile-gakoaren eta sekretu partekatuaren faltagatik gerta liteke.</p>
<p>Kontsumitzaile-gakoa eta sekretu partekatua baldin badauzkazu, kanpoko tresnaren instantzia editatzean sar dezakezu (ziurtatu aukera aurreratuak ikusgai direla).</p>
<p>Beste posibilitatea <a href="{$a->course_tool_editor}">ikastaro-mailako tresna-hornitzailearen konfigurazioa sortzea da</a>.</p>';
$string['lti_tool_request_added'] = 'Tresna-ezarpenaren eskaera ondo bidali da. Tresnaren ezarpenekin bukatzeko kudeatzaile batekin harremanetan jarri beharko zenuke.';
$string['lti_tool_request_existing'] = 'Tresnaren domeinurako tresna-ezarpena dagoeneko bidali da.';
$string['ltisettings'] = 'LTIren ezarpenak';
$string['ltiunknownserviceapicall'] = 'LTI zerbitzu ezezagun baten API deia';
$string['main_admin'] = 'Laguntza orokorra';
$string['main_admin_help'] = 'Kanpoko tresnek ahalbidetzen dute Moodle-erabiltzaileek urruneko ikasketa-baliabideekin etenik gabe eragitea. Abio-protokolo berezi batez, urruneko tresnak abiatzen duen erabiltzailearen informazio orokorrera sarbidea izango du. Adibidez, erakundearen izena, ikastaroaren IDa, eta erabiltzaile-izen edo e-postaren helbidea bezalako informazioa.

Orri honetan zerrendatutako tresnak hiru kategoriatan banatzen dira:

* **Aktibo** - Tresna-hornitzaile hauek kudeatzaile batek onartu eta ezarri ditu. Moodle instantzia honetako ikastaroetan erabil daiteke. Kontsumitzaile-gakoa eta partekatutako sekretua sartuz gero, Moodle-ren instantzia eta urruneko tresnaren arteko konfiantzazko harremana ezartzen da, komunikazio-kanala segurua erabiliz.
* **Zain** - Tresna-hornitzaile hauek pakete-inportazioaz ezartzen dira, baina ez ditu kudeatzaile batek konfiguratu behar.
Irakasleek hornitzaile hauen tresnak erabil ditzake kontsumitzaile-gakoa eta partekatutako sekretua baldin badauzka, edo holakorik eskatzen ez bada.
* **Ezeztatu** - Kudeatzaileak tresna-hornitzaile hauek markatu ditu, Moodle-ren instantzia osoan erabili ahal izateko asmorik ez baitauka. Irakasleek hornitzaile hauen tresnak erabil ditzake kontsumitzaile-gakoa eta partekatutako sekretua baldin badauzka, edo holakorik eskatzen ez bada.';
$string['manage_external_tools'] = 'Kudeatu tresnak';
$string['manage_tool_proxies'] = 'Kudeatu kanpoko tresnen erregistroak';
$string['manage_tools'] = 'Kudeatu aurretik konfiguratutako tresnak';
$string['manuallyaddtype'] = 'Bestela, <a href="{$a}">tresna eskuz konfigura dezakezu</a>.';
$string['miscellaneous'] = 'Denetarikoak';
$string['misconfiguredtools'] = 'Gaizki konfiguratutako tresna-instantziak atzeman dira';
$string['missingparameterserror'] = 'Orria gaizki konfiguratuta dago: "{$a}"';
$string['module_class_type'] = 'Moodle-ren jarduera mota';
$string['modulename'] = 'Kanpoko tresna';
$string['modulename_help'] = 'Kanpoko tresna jarduerak ikasleen eta beste webguneetako irakaskuntza jarduera eta baliabideen arteko interakzioa ahalbidetzen du. Esaterako, kanpoko tresna batek jarduera mota ezberdin baterako edo editore baten irakaskuntza-materialetarako sarbidea eman dezake.

Kanpoko tresna jarduera bat sortzeko, LTI (Learning Tools Interoperability) onartzen duen erreminta hornitzaile bat behar da. Irakasleak kanpoko tresna jarduera bat sortu edo kudeatzaileak aurrez konfiguraturiko bat erabil dezake.

Kanpoko tresna jarduera URL baliabidearekin hainbat gauzatan desberdintzen da:

* Kanpoko tresnak ingurunearen jakitun dira; besteak beste erreminta abiatu duen erabiltzailearen, bere instituzioaren, ikastaroaren eta izenaren berri du.
* Kanpoko tresnek jarduerarekin erlazionaturiko kalifikazioak irakurri, eguneratu eta ezabatzeko aukera ematen du.
* Kanpoko tresnek erreminta hornitzailearen webgunearen eta Moodleren arteko konfiantzazko erlazioa ezartzen du, euren arteko konfiantzazko komunikazioa ahalbidetuz.';
$string['modulenameplural'] = 'Kanpoko tresnak';
$string['modulenamepluralformatted'] = 'LTI instantziak';
$string['name'] = 'Izena';
$string['never'] = 'Inoiz ez';
$string['new_window'] = 'Leiho berria';
$string['no_lti_configured'] = 'Ez dago kanpoko tresna aktiborik konfiguratu.';
$string['no_lti_pending'] = 'Ez dago zain dagoen kanpoko tresnarik.';
$string['no_lti_rejected'] = 'Ez dago onartu gabeko kanpoko tresnarik.';
$string['no_lti_tools'] = 'Ez dago konfiguratutako kanpoko tresnarik.';
$string['no_tp_accepted'] = 'Ez da onartzen kanpoko tresnen erregistrorik';
$string['no_tp_cancelled'] = 'Ez da kanpoko tresnen erregistrorik ezeztatu.';
$string['no_tp_configured'] = 'Ez da ezarri kanpoko tresnen erregistrorik.';
$string['no_tp_pending'] = 'Ez dago zain kanpoko tresnaren erregistrorik.';
$string['no_tp_rejected'] = 'Ez da kanpoko tresnen erregistrorik gaitzetsi.';
$string['noattempts'] = 'Ez da saiakerarik izan tresna honen instantzian';
$string['noltis'] = 'Ez dago kanpoko tresnaren instantziarik';
$string['noprofileservice'] = 'Ez da profil-zerbitzua aurkitu';
$string['noservers'] = 'Ez da zerbitzaririk aurkitu';
$string['notypes'] = 'Une honetan Moodle-n ez da LTI tresnarik ezarri. Egin klik goiko instalazio-estekan bat gehitzeko.';
$string['noviewusers'] = 'Ez da baimendutako erabiltzailerik aurkitu tresna hau erabiltzeko';
$string['optionalsettings'] = 'Aukerako ezarpenak';
$string['organization'] = 'Erakundearen xehetasunak';
$string['organizationdescr'] = 'Erakundearen deskribapena';
$string['organizationid'] = 'Erakundearen IDa';
$string['organizationid_help'] = 'Moodle-instantzia honetarako identifikadore bakarra. Normalean, erankundearen DNSa erabiltzen da.

Eremu hau hutsik utziz gero, lehenetsitako balioa Moodle gune honen zerbitzariaren izena izango da.';
$string['organizationurl'] = 'Erakundearen URLa';
$string['organizationurl_help'] = 'Moodle instantzia honen oinarrizko URLa.

Eremu hau hutsik utzi da, gunearen ezarpenen araberako balio lehenetsia erabiliko da.';
$string['pagesize'] = 'Orriko erakutsitako bidalketak';
$string['parameter'] = 'Tresnaren parametroak';
$string['parameter_help'] = 'Tresna-hornitzaileak tresnaren parametroak eskatzen ditu onartutako proxy-tresnan.';
$string['password'] = 'Sekretu partekatua';
$string['password_admin'] = 'Sekretu partekatua';
$string['password_admin_help'] = 'Sekretu partekatua tresnaren sarbide kautotua lortzeko moduko pasahitzatzat jo daiteke. Tresna-hornitzailearen kontsumitzaile-gakoarekin batera erabili beharko litzateke.

Baliteke Moodlerekin komunikazio segurua behar ez duten eta kalifikazio-txostenak bezalako zerbitzu gehigarririk ematen ez duten tresnek sekretu partekatuaren beharrik ez izatea.';
$string['password_help'] = 'Aurrez konfiguratutako tresnen kasuan, ez da beharrezkoa sekretu partekatua hemen sartzea, horixe konfigurazio-prozesuaren barruan emango baita.

Eremu hau osatu beharko da oraindik konfiguratu ez den tresna-hornitzaile baterako esteka sortzen ari bada.

Tresna-hornitzailea ikastaro honetan behin baino gehiagotan erabiliko bada, ikastaroko tresna-konfigurazioa gehitzea ideia ona da.

Sekretu partekatua tresnaren sarbide kautotua lortzeko moduko pasahitza gisa jo daiteke. Tresna-hornitzailearen kontsumitzaile-gakoarekin batera erabili beharko litzateke.

Baliteke Moodlerekin komunikazio segurua behar ez duten eta kalifikazio-txostenak bezalako zerbitzu gehigarririk ematen ez duten tresnek sekretu partekatuaren beharrik ez izatea.';
$string['pending'] = 'Zain';
$string['pluginadministration'] = 'Kanpoko tresnaren kudeaketa';
$string['pluginname'] = 'Kanpoko tresna';
$string['preferheight'] = 'Hobetsitako altuera';
$string['preferwidget'] = 'Gailuaren abiarazteko hobetsitako widget-a';
$string['preferwidth'] = 'Hobetsitako zabalera';
$string['press_to_submit'] = 'Egin klik jarduera hau abiarazteko';
$string['privacy'] = 'Pribatutasuna';
$string['privacy:metadata:coursefullname'] = 'LTI kontsumitzailera sartzen ari den erabiltzailearen jatorrizko ikastaroaren izen osoa';
$string['privacy:metadata:courseid'] = 'LTI kontsumitzailera sartzen ari den erabiltzailearen jatorrizko ikastaroaren IDa';
$string['privacy:metadata:courseidnumber'] = 'LTI kontsumitzailera sartzen ari den erabiltzailearen jatorrizko ikastaroaren ID zenbakia';
$string['privacy:metadata:courseshortname'] = 'LTI kontsumitzailera sartzen ari den erabiltzailearen jatorrizko ikastaroaren izen laburra';
$string['privacy:metadata:createdby'] = 'Erregistroa sortu zuen erabiltzailea';
$string['privacy:metadata:email'] = 'LTI kontsumitzailera sartzen ari den erabiltzailearen helbide elektronikoa';
$string['privacy:metadata:externalpurpose'] = 'LTI kontsumitzaileak LTI tresna-hornitzaileari erabiltzailearen eta testuinguruaren informazioa ematen dio.';
$string['privacy:metadata:firstname'] = 'LTI kontsumitzailera sartzen ari den erabiltzailearen izena';
$string['privacy:metadata:fullname'] = 'LTI kontsumitzailera sartzen ari den erabiltzailearen izen osoa';
$string['privacy:metadata:lastname'] = 'LTI kontsumitzailera sartzen ari den erabiltzailearen abizena';
$string['privacy:metadata:lti_submission'] = 'LTI bidalketa';
$string['privacy:metadata:lti_submission:datesubmitted'] = 'Bidalketa egin zeneko unea';
$string['privacy:metadata:lti_submission:dateupdated'] = 'Bidalketa aldatu zeneko unea';
$string['privacy:metadata:lti_submission:gradepercent'] = 'Erabiltzailearen kalifikazioa ehunekoetan';
$string['privacy:metadata:lti_submission:originalgrade'] = 'Erabiltzailearen jatorrizko kalifikazioa';
$string['privacy:metadata:lti_submission:userid'] = 'LTI jarduera bidali zuen erabiltzailearen IDa';
$string['privacy:metadata:lti_tool_proxies'] = 'LTI proxya';
$string['privacy:metadata:lti_tool_proxies:name'] = 'LTI proxyaren izena';
$string['privacy:metadata:lti_types'] = 'LTI motak';
$string['privacy:metadata:lti_types:name'] = 'LTI motaren izena';
$string['privacy:metadata:role'] = 'LTI kontsumitzailera sartzen ari den erabiltzaileak ikastaroan duen rola';
$string['privacy:metadata:timecreated'] = 'Erregistroa sortu zeneko unea';
$string['privacy:metadata:timemodified'] = 'Erregistroa aldatu zeneko unea';
$string['privacy:metadata:userid'] = 'LTI kontsumitzailera sartzen ari den erabiltzailearen IDa';
$string['privacy:metadata:useridnumber'] = 'LTI kontsumitzailera sartzen ari den erabiltzailearen ID zenbakia';
$string['privacy:metadata:username'] = 'LTI kontsumitzailera sartzen ari den erabiltzailearen erabiltzaile-izena';
$string['quickgrade'] = 'Baimendu kalifikazio azkarra';
$string['quickgrade_help'] = 'Gaituz gero, tresna asko orri batean kalifika daitezke. Gehitu kalifikazio eta iruzkinak. Gero, egin klik "Gorde nire feedback guztiak" botoian orri horretarako aldaketa guztiak gordetzeko.';
$string['redirect'] = 'Berbidalketa segundo gutxitan gertatuko da. Horren ezean, sakatu botoia.';
$string['register'] = 'Erregistratu';
$string['register_warning'] = 'Erregistro-orria irekitzea luzeegi irauten ari dela dirudi. Erakusten ez bada, baieztatu konfigurazioan URL egokia sartu duzula. Moodlek https erabiltzen badu, ziurtatu konfiguratzen ari zaren tresnak https onartzen duen eta URLan https erabiltzen ari zaren.';
$string['registertype'] = 'Konfiguratu kanpoko tresna berri baten erregistroa.';
$string['registration_options'] = 'Erregistrorako aukerak';
$string['registrationname'] = 'Tresna-hornitzailearen izena';
$string['registrationname_help'] = 'Idatzi erregistratzen ari den tresnaren hornitzailearen izena.';
$string['registrationurl'] = 'Erregistrorako URLa';
$string['registrationurl_help'] = 'Tresna-hornitzaileak erregistroko URLa eskuragarri izan beharko luke erregistro-eskaerak bidali beharreko kokapen gisa.';
$string['reject'] = 'Ez onartu';
$string['rejected'] = 'Onartu gabea';
$string['resource'] = 'Baliabidea';
$string['resourcekey'] = 'Kontsumitzaile-gakoa';
$string['resourcekey_admin'] = 'Kontsumitzaile-gakoa';
$string['resourcekey_admin_help'] = 'Kontsumitzaile-gakoa tresnaren sarbide kautotua lortzeko moduko erabiltzaile-izentzat jo daiteke. Tresna-hornitzaileak erabil dezake tresna abiarazten deneko Moodle-gunea identifikatzeko.

Kontsumitzaile-gakoa tresna-hornitzaileak eman behar du. Lortzeko metodoa hornitzailearen arabera aldatzen da. Prozedura automatikoa izan daiteke edo tresna-hornitzailearen elkarrizketa eska dezake.

Baliteke Moodlekin komunikazio segurua behar ez duten eta kalifikazio-txostenak bezalako zerbitzu gehigarririk ematen ez duten tresnek partekatutako sekretuaren beharrik ez izatea.';
$string['resourcekey_help'] = 'Aurrez konfiguratutako tresnen kasuan, hemen baliabide-gakoa sartzea ez da beharrezkoa, kontsumitzailearen gakoa ezarpen-prozesuan zehar emango baita.

Eremu hau sartu beharko litzateke oraindik konfiguratu ez den tresna-hornitzaile batekiko esteka sortzen bada.
Tresna-hornitzailea ikastaro honetan behin baino gehiagotan erabiliko bada, ideia ona da ikastaroko tresna-konfigurazioa gehitzea.

Kontsumitzaile-gakoa tresnarako sarbidea kautotzeko erabiltzaile-izen bezala uler daiteke. Tresna-hornitzaileak erabil dezake tresna abiarazten ari den Moodle gunea identifikatzeko.

Kontsumitzaile-gakoa tresna-hornitzaileak eman behar du. Kontsumitzaile-gakoa lortzeko metodoa tresna-hornitzailearen arabera aldatzen da. Prozedura automatikoa izan daiteke, edo tresna-hornitzailearekin elkarrizketa eskatu.

Moodlekin komunikazio segurua eskatzen ez duten zerbitzu gehigarririk ematen ez duten tresnek (kalifikazio-txostenek bezala) ez dute baliabide-gakorik behar izaten.';
$string['resourceurl'] = 'Baliabidearen URLa';
$string['return_to_course'] = 'Egin klik <a href="{$a->link}" target="_top">hemen</a> ikastarora itzultzeko.';
$string['saveallfeedback'] = 'Gorde nire feedback guztiak';
$string['search:activity'] = 'Kanpoko tresna - jardueraren informazioa';
$string['secure_icon_url'] = 'Ikono seguruaren URLa';
$string['secure_icon_url_help'] = 'URL ikonoaren antzekoa, baina gunera SSLren bidez modu seguruan sartzen denean erabilia. Eremu honen helburu nagusia nabigatzaileak irudi arriskutsu batez abisua ez erakustea da.';
$string['secure_launch_url'] = 'Tresna seguruaren URLa';
$string['secure_launch_url_help'] = 'URL tresnaren antzekoa, baina URL tresnaren ordez erabilia segurtasun-maila altua eskatzen denean. Moodle-k URL tresna segurua erabiliko du URL tresnaren odez, Moodle-ra SSLren bidez sartzen denean erabilia, edo konfigurazio-tresna ezarri bada beti SSLren bidez abiarazteko.

URL tresnan https helbidea ezar daiteke SSLren bidez abiaraztea behartzeko, eta eremu hau hutsik utz daiteke.';
$string['selectcontent'] = 'Aukeratu edukia';
$string['send'] = 'Bidali';
$string['services'] = 'Zerbitzuak';
$string['services_help'] = 'Aukeratu tresna-hornitzaileari eskaini nahi dizkiozun zerbitzuak. Zerbitzu bat baino gehiago aukera daiteke.';
$string['setupoptions'] = 'Ezarpen-aukerak';
$string['share_email'] = 'Partekatu erabiltzailearen helbide elektronikoa tresnarekin';
$string['share_email_admin'] = 'Partekatu erabiltzailearen helbide elektronikoa tresnarekin';
$string['share_email_admin_help'] = 'Zehaztu tresna abiarazten ari den erabiltzailearen helbide elektronikoa tresna-hornitzailearekin partekatuko den.
Tresna-hornitzaileak abiarazten dutenen helbide elektronikoak eska ditzake UIn izen bera duten erabiltzaileak bereiztearren, edo tresnaren elkarrekintzaren araberako e-mailak erabiltzaileei bidaltzearren.';
$string['share_email_help'] = 'Zehaztu tresna abiarazten ari den erabiltzailearen helbide elektronikoa tresna-hornitzailearekin partekatuko den.

Tresna-hornitzaileak abiarazten dutenen helbide elektronikoak eska ditzake UIn izen bera duten erabiltzaileak bereiztearren, edo tresnaren elkarrekintzaren araberako mezuak erabiltzaileei bidaltzearren.

Ohar zaitez tresnaren konfigurazioan ezarpen hau gainidatz daitekeela.';
$string['share_name'] = 'Partekatu erabiltzailearen izena tresnarekin';
$string['share_name_admin'] = 'Partekatu erabiltzailearen izena tresnarekin';
$string['share_name_admin_help'] = 'Zehaztu tresna abiarazten ari den  erabiltzailearen izen osoa tresna-hornitzailearekin partekatuko ote den.
Baliteke tresna-hornitzaileak behar izatea tresnaren barruan abiarazleen izenek informazio esanguratsua erakustea.';
$string['share_name_help'] = 'Zehaztu tresna abiarazten ari den  erabiltzailearen izen osoa tresna-hornitzailearekin partekatuko ote den.

Baliteke tresna-hornitzaileak behar izatea tresnaren barruan abiarazleen izenek informazio esanguratsua erakustea.

Ohar zaitez ezarpen honek tresnaren konfigurazioa gainidatz dezakeela.';
$string['share_roster'] = 'Baimendu tresna honi ikastaro-zerrendara sartzea';
$string['share_roster_admin'] = 'Tresnak ikastaro-zerrendarako sarbidea izan dezake.';
$string['share_roster_admin_help'] = 'Zehaztu tresnak abiarazten ari deneko ikastaroetan matrikulatutako erabiltzaileen zerrendara sarbidea izango ote duen.';
$string['share_roster_help'] = 'Zehaztu tresnak abiarazten ari deneko ikastaroetan matrikulatutako erabiltzaileen zerrendara sarbidea izango ote duen.

Ohar zaitez ezarpen honek tresnaren konfigurazioa gainidatz dezakeela.';
$string['show_in_course_activity_chooser'] = 'Erakutsi jarduera-hautagailua aurrez konfiguratutako tresna gisa.';
$string['show_in_course_lti1'] = 'Tresnaren ezarpenen erabilera';
$string['show_in_course_lti1_help'] = 'Tresna hau jarduera-hautagailuan erakuts daiteke irakasleak aukera dezan ikastaro batean txertatzeko. Bestela, aurrez konfiguratutako zerrenda zabalgarriko menuan kanpoko tresna bat ikastarora gehitzean. Hurrengo aukera bat kanpoko tresna bat ikastarora gehitzean soilik konfigurazioa tresnaren URL zehatza sartzen denean erabiltzea da.';
$string['show_in_course_lti2'] = 'Tresnaren ezarpenen erabilera';
$string['show_in_course_lti2_help'] = 'Tresna hau jarduera-hautatzailean erakutsi daiteke irakasleak ikastaro batean txertatzea aukera dezan edo aurrez konfiguratutako zerrenda zabalgarriko menuan kanpoko tresna bat ikastarora gehitzean.';
$string['show_in_course_no'] = 'Ez erakutsi. Erabili soilik dagokion tresnaren URLa sartzen denean.';
$string['show_in_course_preconfigured'] = 'Erakutsi aurrez konfiguratutako tresna bezala kanpoko tresna bat gehitzean';
$string['size'] = 'Tamainaren parametroak';
$string['submission'] = 'Bidalketa';
$string['submissions'] = 'Bidalketak';
$string['submissionsfor'] = '{$a}-(r)entzako bidalketak';
$string['subplugintype_ltiresource'] = 'LTI zerbitzuaren baliabidea';
$string['subplugintype_ltiresource_plural'] = 'LTI zerbitzuaren baliabideak';
$string['subplugintype_ltiservice'] = 'LTI zerbitzua';
$string['subplugintype_ltiservice_plural'] = 'LTI zerbitzuak';
$string['subplugintype_ltisource'] = 'LTIren iturburua';
$string['subplugintype_ltisource_plural'] = 'LTIren iturburuak';
$string['successfullycreatedtooltype'] = 'Ondo sortu da tresna!';
$string['successfullyfetchedtoolconfigurationfromcontent'] = 'Aukeratutako edukitik tresnaren konfigurazioa ondo pasa da.';
$string['toggle_debug_data'] = 'Trukatu arazketaren informazioa';
$string['tool_config_not_found'] = 'Ez da aurkitu URL honetarako tresna-konfiguraziorik.';
$string['tool_settings'] = 'Tresnaren ezarpenak';
$string['tooldescription'] = 'Tresnaren deskribapena';
$string['tooldescription_help'] = 'Irakasleei jarduera-zerrendan erakutsiko zaien tresnaren deskribapena.

Tresna zertarako den, zer egiten duen eta irakasleak beharko lukeen beste edozein informazio gehigarri deskribatu beharko luke honek.';
$string['toolisbeingused'] = 'Tresna {$a} aldiz erabili da';
$string['toolisnotbeingused'] = 'Tresn hau ez da oraindik erabili';
$string['toolproxy'] = 'Kanpoko tresnen erregistroak';
$string['toolproxy_help'] = 'Kanpoko tresnen erregistroak Moodle guneko kudeatzaileei ahalbidetzen die LTI 2.0 onartzen duten kanpoko tresnak proxy bidez konfiguratzen. Tresnaren hornitzaileak emandako erregistrorako URLa da prozesua abiarazteko behar den gauza bakarra. Tresna-hornitzaileari eskainitako gaitasun eta zerbitzuak erregistro berria konfiguratzean aukeratzen dira.

Orri honetan zerrendatutako tresnen erregistroak lau kategoriatan banatzen dira:

* **Konfiguratuak** - Tresna hauen erregistroak instalatu dira, baina erregistro-prozesua ez da oraindik hasi.
* **Zain** - Tresna hauetarako erregistro-prozesua hasi da, baina ez da oraindik amaitu. Ireki eta gorde ezarpenak berriro \'Konfiguratuak\' kategoriara mugitzeko.
* **Onartuak** - Tresna hauen erregistroak onartu dira. Proxy-tresnan zehaztutako baliabideak aurrez konfiguratutako tresnen orrian \'Zain\' egoeran azalduko dira.
* **Gaitzetsiak** - Tresna hauen erregistroak prozesuan gaitzetsi zirenak dira. Ireki eta gorde ezarpenak berriro \'Konfiguratuak\' kategoriara mugitzeko, erregistro-prozesua berrabiaraz dadin.';
$string['toolproxyregistration'] = 'Kanpoko tresnen erregistroa';
$string['toolregistration'] = 'Kanpoko tresnen erregistroa';
$string['toolsetup'] = 'Kanpoko tresnaren ezarpenak';
$string['tooltypeadded'] = 'Aurretik konfiguratutako tresna gehitu da';
$string['tooltypedeleted'] = 'Aurretik konfiguratutako tresna ezabatu da';
$string['tooltypenotdeleted'] = 'Ezin izan da aurrez ezarritako tresna ezabatu';
$string['tooltypes'] = 'Tresnak';
$string['tooltypeupdated'] = 'Aurrez ezarritako tresna eguneratu da';
$string['toolurl'] = 'Tresnaren URLa';
$string['toolurl_contentitemselectionrequest'] = 'Edukia aukeratzeko URLa';
$string['toolurl_contentitemselectionrequest_help'] = 'Edukia aukeratzeko URLa erreminta-hornitzailetik edukia aukeratzeko orria irekitzeko erabiliko da. Hutsik badago, Erremintaren URLa erabiliko da';
$string['toolurl_help'] = 'Tresnaren URLa erabiltzen da tresnaren konfigurazio zuzenarekin lotzeko. URLen aurretik http(s) jartzea hautazkoa da.

Horrez gain, oinarrizko URLa tresnaren URL gisa erbiltzen da, kanpoko tresnaren instantzian URLrik zehaztu ezean.

Adibidez, *tool.com* oinarrizko URLa hurrengoekin lotuko litzateke:

* tool.com
* tool.com/quizzes
* tool.com/quizzes/quiz.php?id=10
* www.tool.com/quizzes

*www.tool.com/quizzes* inarrizko URLa hurrengoekin lotuko litzateke:

* www.tool.com/quizzes
* tool.com/quizzes
* tool.com/quizzes/take.php?id=10

*quiz.tool.com* inarrizko URLa hurrengoekin lotuko litzateke:

* quiz.tool.com
* quiz.tool.com/take.php?id=10

Domeinu berean bi tresna-konfigurazio ezberdin badaude, hoberen egokitzen dena erabiliko da.

Baldin badaukazu, URL kartxuoa sar dezakezu eta xehetasunak automatikoki beteko dira.';
$string['toolurlplaceholder'] = 'Tresnaren URLa...';
$string['typename'] = 'Tresnaren izena';
$string['typename_help'] = 'Tresnaren izena Moodleren barruan tresna-hornitzailea identifikatzeko erabiltzen da. Izena irakasleek ikusi ahal izango dute, ikastaroen barruan kanpoko tresnak gehitzean.';
$string['types'] = 'Motak';
$string['unabletocreatetooltype'] = 'Ezin da tresna sortu';
$string['unabletofindtooltype'] = '{$a->id}(e)rako tresna ezin izan da aurkitu';
$string['unknownstate'] = 'Egoera ezezaguna';
$string['update'] = 'Eguneratu';
$string['useraccountinformation'] = 'Erabiltzaile-kontuaren informazioa';
$string['userpersonalinformation'] = 'Erabiltzailearen informazio pertsonala';
$string['using_tool_cartridge'] = 'Tresnaren kartutxoa erabiltzen';
$string['using_tool_configuration'] = 'Tresnaren ezarpena erabiltzen:';
$string['validurl'] = 'URL baliagarriak honela hasi behar du: http(s)://';
$string['viewsubmissions'] = 'Ikusi bidalketak eta kalifikazio-pantaila';
