<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'competency', language 'it', version '3.5'.
 *
 * @package     competency
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['allchildrenarecomplete'] = 'Tutte le figlie sono state raggiunte';
$string['competencies'] = 'Competenze';
$string['competenciesarenotenabled'] = 'Le competenze non sono abilitate.';
$string['competenciessettings'] = 'Impostazioni competenze';
$string['completeplanstask'] = 'Completamento piani formativi in scadenza';
$string['coursecompetencyoutcome_complete'] = 'Raggiungi la competenza';
$string['coursecompetencyoutcome_evidence'] = 'Allega attestazione';
$string['coursecompetencyoutcome_none'] = 'Non eseguire azioni';
$string['coursecompetencyoutcome_recommend'] = 'Manda in revisione';
$string['coursemodulecompetencyoutcome_complete'] = 'Raggiungi la competenza';
$string['coursemodulecompetencyoutcome_evidence'] = 'Allega attestazione';
$string['coursemodulecompetencyoutcome_none'] = 'Non eseguire azioni';
$string['coursemodulecompetencyoutcome_recommend'] = 'Manda in revisione';
$string['deletecompetencyratings'] = 'Elimina valutazioni delle competenze';
$string['duplicateditemname'] = '{$a} (copia)';
$string['enablecompetencies'] = 'Abilita competenze';
$string['enablecompetencies_desc'] = 'Le competenze consentono di valutare gli utenti in base ai piani di formazione.';
$string['errorcannotchangeapastduedate'] = 'La data di scadenza è trascorsa, non è possibile modificarla.';
$string['errorcannotsetduedateinthepast'] = 'Non è possibile impostare date di scadenza già trascorse.';
$string['errorcannotsetduedatetoosoon'] = 'La data di scadenza è troppo vicina';
$string['errorcompetencyrule'] = 'La regola \'{$a}\' della competenza del corso è sconosciuta';
$string['errorcoursecompetencyrule'] = 'La regola \'{$a}\' della competenza del corso è sconosciuta';
$string['errorinvalidcourse'] = 'Il corso non è valido.';
$string['errornocompetency'] = 'Non è possibile trovare al competenza {$a}';
$string['errorplanstatus'] = 'Lo stato del piano di formazione \'{$a}\' non è noto';
$string['errorscalealreadyused'] = 'Non è possibile modificare la scala perché è in uso.';
$string['errorscaleconfiguration'] = 'La scala deve essere configurata indicando un livello di default ed un livello di esperto.';
$string['errorusercomptencystatus'] = 'Lo stato della competenza \'{$a}\' dell\'utente non è noto';
$string['eventcompetencycreated'] = 'Creata competenza.';
$string['eventcompetencydeleted'] = 'Eliminata competenza.';
$string['eventcompetencyframeworkcreated'] = 'Creato quadro di competenze.';
$string['eventcompetencyframeworkdeleted'] = 'Eliminato quadro di competenze.';
$string['eventcompetencyframeworkupdated'] = 'Aggiornato quadro di competenze.';
$string['eventcompetencyframeworkviewed'] = 'Visualizzato quadro di competenze.';
$string['eventcompetencyupdated'] = 'Aggiornata competenza.';
$string['eventcompetencyviewed'] = 'Visualizzata competenza.';
$string['eventevidencecreated'] = 'Creata attestazione.';
$string['eventplanapproved'] = 'Approvato piano di formazione.';
$string['eventplancompleted'] = 'Completato piano di formazione';
$string['eventplancreated'] = 'Creato piano di formazione.';
$string['eventplandeleted'] = 'Eliminato piano di formazione.';
$string['eventplanreopened'] = 'Riaperto piano di formazione.';
$string['eventplanreviewrequestcancelled'] = 'Annullata richiesta revisione piano di formazione.';
$string['eventplanreviewrequested'] = 'Richiesta revisione piano di formazione.';
$string['eventplanreviewstarted'] = 'Iniziata revisione piano di formazione.';
$string['eventplanreviewstopped'] = 'Fermata revisione piano di formazione.';
$string['eventplanunapproved'] = 'Disapprovato piano di formazione.';
$string['eventplanunlinked'] = 'Scollegato piano di formazione.';
$string['eventplanupdated'] = 'Aggiornato piano di formazione.';
$string['eventplanviewed'] = 'Visualizzato piano di formazione.';
$string['eventtemplatecreated'] = 'Creato modello di piano di formazione.';
$string['eventtemplatedeleted'] = 'Eliminato modello di piano di formazione.';
$string['eventtemplateupdated'] = 'Aggiornato modello di piano di formazione.';
$string['eventtemplateviewed'] = 'Visualizzato modello di piano di formazione.';
$string['eventusercompetencyplanviewed'] = 'Visualizzato piano delle competenze dell\'utente.';
$string['eventusercompetencyrated'] = 'Valutata competenza utente.';
$string['eventusercompetencyratedincourse'] = 'Valutata competenza utente in un corso.';
$string['eventusercompetencyratedinplan'] = 'Valutata competenza utente in un piano di formazione.';
$string['eventusercompetencyreviewrequestcancelled'] = 'Annullata richiesta di revisione competenza dell\'utente.';
$string['eventusercompetencyreviewrequested'] = 'Richiesta revisione c';
$string['eventusercompetencyreviewstarted'] = 'Iniziata revisione competenza dell\'utente.';
$string['eventusercompetencyreviewstopped'] = 'Fermata revisione competenza dell\'utente.';
$string['eventusercompetencyviewed'] = 'Visualizzata competenza utente.';
$string['eventusercompetencyviewedincourse'] = 'Visualizzata competenza utente in un corso.';
$string['eventusercompetencyviewedinplan'] = 'Visualizzata competenza utente in un piano di formazione.';
$string['eventuserevidencecreated'] = 'Creata attestazione della formazione pregressa.';
$string['eventuserevidencedeleted'] = 'Eliminata attestazione della formazione pregressa.';
$string['eventuserevidenceupdated'] = 'Aggiornata attestazione della formazione pregressa.';
$string['evidence_competencyrule'] = 'La regola della competenza è stata soddisfatta.';
$string['evidence_coursecompleted'] = 'Il corso \'{$a}\' è stato completato.';
$string['evidence_coursemodulecompleted'] = 'L\'attività \'{$a}\' è stata completato.';
$string['evidence_courserestored'] = 'La valutazione è stata ripristinata assieme al corso \'{$a}\'.';
$string['evidence_evidenceofpriorlearninglinked'] = 'L\'attestazione della formazione pregressa \'{$a}\' è stata collegata.';
$string['evidence_evidenceofpriorlearningunlinked'] = 'L\'attestazione della formazione pregressa \'{$a}\' è stata scollegata.';
$string['evidence_manualoverride'] = 'La valutazione della competenza è stata data manualmente.';
$string['evidence_manualoverrideincourse'] = 'La valutazione della competenza nel corso \'{$a}\' è stata data manualmente.';
$string['evidence_manualoverrideinplan'] = 'La valutazione della competenza nel piano di formazione \'{$a}\' è stata data manualmente.';
$string['invalidevidencedesc'] = 'La descrizione dell\'attestazione non è valida.';
$string['invalidgrade'] = 'Valutazione non valida';
$string['invalidpersistent'] = 'Non validità persistente';
$string['invalidpersistenterror'] = 'Errore: {$a}';
$string['invalidplan'] = 'Piano di formazione non valido';
$string['invalidtaxonomy'] = 'Tassonomia non valida: {$a}';
$string['invalidurl'] = 'L\'URL non è valida. Accertati che inizi per \'http://\' o \'https://\'.';
$string['planstatusactive'] = 'Attivo';
$string['planstatuscomplete'] = 'Raggiunta';
$string['planstatusdraft'] = 'Bozza';
$string['planstatusinreview'] = 'In revisione';
$string['planstatuswaitingforreview'] = 'In attesa di revisione';
$string['pointsrequiredaremet'] = 'Il punteggio richiesto è stato raggiunto';
$string['privacy:evidence:action:complete'] = 'Completamento competenza in mancanza di valutazione';
$string['privacy:evidence:action:log'] = 'Azione inserita nel log';
$string['privacy:evidence:action:override'] = 'Sovrascrittura della valutazione della competenza';
$string['privacy:metadata:competency'] = 'Registro delle competenze.';
$string['privacy:metadata:competency_coursecomp'] = 'Registro delle competenze collegate a un corso.';
$string['privacy:metadata:competency_coursecompsetting'] = 'Registro delle impostazioni delle competenze in un corso.';
$string['privacy:metadata:competency_evidence'] = 'Registro delle prove che incidono sullo stato di una competenza.';
$string['privacy:metadata:competency_framework'] = 'Registro dei quadri di competenze.';
$string['privacy:metadata:competency_modulecomp'] = 'Registro delle competenze collegate a un modulo.';
$string['privacy:metadata:competency_plan'] = 'Registro dei piani di formazione.';
$string['privacy:metadata:competency_plancomp'] = 'Registro delle competenze in un piano di formazione.';
$string['privacy:metadata:competency_relatedcomp'] = 'Registro delle relazioni fra le competenze.';
$string['privacy:metadata:competency_template'] = 'Registro dei modelli di piani di formazione.';
$string['privacy:metadata:competency_templatecohort'] = 'Registro dei gruppi globali associati a un modello di piano di formazione.';
$string['privacy:metadata:competency_templatecomp'] = 'Registro delle competenze in un modello di piano di formazione.';
$string['privacy:metadata:competency_usercomp'] = 'Registro dello stato delle competenze di un utente.';
$string['privacy:metadata:competency_usercompcourse'] = 'Registro dello stato delle competenze di un utente in un corso.';
$string['privacy:metadata:competency_usercompplan'] = 'Registro dello stato delle competenze in un piano di formazione.';
$string['privacy:metadata:competency_userevidence'] = 'Registro delle attestazioni della formazione pregressa.';
$string['privacy:metadata:competency_userevidencecomp'] = 'Registro delle competenze associate alle attestazioni della formazione pregressa.';
$string['privacy:metadata:core_comments'] = 'Commenti sui piani di formazione e sulle competenze.';
$string['privacy:metadata:evidence:action'] = 'Tipo di azione svolta con l\'attestazione.';
$string['privacy:metadata:evidence:actionuserid'] = 'L\'utente svolge l\'azione.';
$string['privacy:metadata:evidence:desca'] = 'Parametri facoltativi della descrizione traducibile della attestazione.';
$string['privacy:metadata:evidence:desccomponent'] = 'Componente della descrizione traducibile della attestazione.';
$string['privacy:metadata:evidence:descidentifier'] = 'Identificativo della descrizione traducibile della attestazione.';
$string['privacy:metadata:evidence:grade'] = 'Valutazione associata alla attestazione.';
$string['privacy:metadata:evidence:note'] = 'Nota non-localizzata allegata alla attestazione.';
$string['privacy:metadata:evidence:url'] = 'URL associato alla attestazione.';
$string['privacy:metadata:plan:description'] = 'Descrizione del piano di formazione.';
$string['privacy:metadata:plan:duedate'] = 'Data di consegna del piano di formazione.';
$string['privacy:metadata:plan:name'] = 'Nome del piano di formazione.';
$string['privacy:metadata:plan:reviewerid'] = 'ID del revisore del piano di formazione.';
$string['privacy:metadata:plan:status'] = 'Stato del piano di formazione.';
$string['privacy:metadata:plan:userid'] = 'ID dell\'utente a cui appartiene il piano di formazione.';
$string['privacy:metadata:timecreated'] = 'Data e ora di creazione del registro.';
$string['privacy:metadata:timemodified'] = 'Data e ora di modifica del registro.';
$string['privacy:metadata:usercomp:grade'] = 'Valutazione data per la competenza.';
$string['privacy:metadata:usercomp:proficiency'] = 'Indicatore di conseguimento del livello di competenza.';
$string['privacy:metadata:usercomp:reviewerid'] = 'ID del revisore.';
$string['privacy:metadata:usercomp:status'] = 'Stato della competenza.';
$string['privacy:metadata:usercomp:userid'] = 'ID dell\'utente a cui appartiene la competenza.';
$string['privacy:metadata:userevidence:description'] = 'Descrizione della prova.';
$string['privacy:metadata:userevidence:name'] = 'Nome della prova della formazione precedente.';
$string['privacy:metadata:userevidence:url'] = 'URL associato all\'attestazione.';
$string['privacy:metadata:usermodified'] = 'L\'utente che ha creato o modificato il registro.';
$string['privacy:path:plans'] = 'Piani di formazione';
$string['privacy:path:relatedtome'] = 'Relative alla persona';
$string['privacy:path:userevidence'] = 'Attestazione della formazione pregressa';
$string['pushcourseratingstouserplans'] = 'Aggiorna i piani formativi individuali con le valutazioni del corso';
$string['pushcourseratingstouserplans_desc'] = 'Di default le impostazioni del corso prevedono l\'aggiornamento dei piani formativi individuali quando vengono valutate le competenze.';
$string['syncplanscohorts'] = 'Sincronizza i piani dai modelli dei piani formativi dei gruppi globali';
$string['taxonomy_behaviour'] = 'Comportamento';
$string['taxonomy_competency'] = 'Competenza';
$string['taxonomy_concept'] = 'Concetto';
$string['taxonomy_domain'] = 'Settore';
$string['taxonomy_indicator'] = 'Indicatore';
$string['taxonomy_level'] = 'Livello';
$string['taxonomy_outcome'] = 'Risultato';
$string['taxonomy_practice'] = 'Pratica';
$string['taxonomy_proficiency'] = 'Esperienza';
$string['taxonomy_skill'] = 'Abilità';
$string['taxonomy_value'] = 'Valore';
$string['usercommentedonacompetency'] = '{$a->fullname} ha commentato la competenza "{$a->competency}":

{$a->comment}

Per ulteriori informazioni: {$a->url}';
$string['usercommentedonacompetencyhtml'] = '<p>{$a->fullname} ha commentato la competenza "{$a->competency}":</p>
<div>{$a->comment}</div>
<p>Per ulteriori informazioni: <a href="{$a->url}">{$a->urlname}</a>.</p>';
$string['usercommentedonacompetencysmall'] = '{$a->fullname} ha commentato la competenza "{$a->competency}".';
$string['usercommentedonacompetencysubject'] = '{$a} ha commentato una competenza.';
$string['usercommentedonaplan'] = '{$a->fullname} ha commentato il piano "{$a->plan}":

{$a->comment}

Per ulteriori informazioni: {$a->url}';
$string['usercommentedonaplanhtml'] = '<p>{$a->fullname} ha commentato il piano "{$a->plan}":</p>
<div>{$a->comment}</div>
<p>Per ulteriori informazioni: <a href="{$a->url}">{$a->urlname}</a>.</p>';
$string['usercommentedonaplansmall'] = '{$a->fullname} ha commentato il piano "{$a->plan}".';
$string['usercommentedonaplansubject'] = '{$a} ha commentato il piano.';
$string['usercompetencystatus_idle'] = 'Non attiva';
$string['usercompetencystatus_inreview'] = 'In revisione';
$string['usercompetencystatus_waitingforreview'] = 'In attesa di revisione';
$string['userplans'] = 'Piani di formazione';
