<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'hub', language 'es_mx', version '3.5'.
 *
 * @package     hub
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addscreenshots'] = 'Agregar pantallazos';
$string['advertise'] = 'Compartir este curso para que la gente se inscriba';
$string['advertised'] = 'Para que la gente se una';
$string['advertiseon'] = 'Compartir este curso en {$a}';
$string['advertiseonhub'] = 'Compartir este curso para que la gente se inscriba';
$string['advertiseonmoodleorg'] = 'Anunciar este curso en una central de cursos (\'hub\')';
$string['advertisepublication_help'] = 'Este curso será enlistado en Moodle.net como un curso en el cual las personas se pueden inscribir y participar. Debería de habilitarse el auto-registro basado en Email en el sitio y Usted necesita habilitar la auto-inscripción en este curso.';
$string['all'] = 'Todo';
$string['allowglobalsearch'] = 'Publicar esta Central de Cursos (hub) y permitir la búsqueda global de todos los cursos';
$string['allowpublicsearch'] = 'Publicar esta Central de Cursos (hub) para que la gente pueda unirse';
$string['audience'] = 'Audiencia';
$string['audience_help'] = 'Seleccionar la audiencia a quien está dirigido este curso';
$string['audienceadmins'] = 'Administradores de Moodle';
$string['audienceeducators'] = 'Educadores';
$string['audiencestudents'] = 'Estudiantes';
$string['badgesnumber'] = 'Número de insignias ({$a})';
$string['badurlformat'] = 'Formato URL erróneo';
$string['cannotsearchcommunity'] = 'Lo sentimos, no tiene los permisos adecuados para ver esta página';
$string['community'] = 'Comunidad';
$string['communityremoved'] = 'El enlace hacia ese curso ha sido eliminado de su lista';
$string['completeregistration'] = 'Registro completado con Moodle,net';
$string['confirmregistration'] = 'Confirmar registro';
$string['contactable'] = 'Contacto del público';
$string['contactable_help'] = 'Si se selecciona SÍ se mostrará su dirección email en la Central de Cursos';
$string['contactemail'] = 'Email del contacto';
$string['contactname'] = 'Nombre del contacto';
$string['contactphone'] = 'Teléfono';
$string['contactphone_help'] = 'Los números de teléfono se muestran únicamente al administrador de la Central de Cursos y no son públicos.';
$string['continue'] = 'Continuar';
$string['contributornames'] = 'Otros contribuyentes';
$string['contributornames_help'] = 'Usted puede usar este campo para enlistar los nombres de quienes han contribuído en este curso.';
$string['coursemap'] = 'Mapa del curso';
$string['coursename'] = 'Nombre';
$string['courseprivate'] = 'Privado';
$string['coursepublic'] = 'Público';
$string['coursepublished'] = 'Este curso ha sido compartido exitosamente en \'{$a}\'.';
$string['courseshortname'] = 'Nombre corto';
$string['courseshortname_help'] = 'Escriba un nombre corto para su curso. No necesita ser único.';
$string['coursesnumber'] = 'Número de cursos ({$a})';
$string['courseunpublished'] = 'El curso {$a->courseshortname} ya no está compartido en {$a->hubname}.';
$string['courseurl'] = 'URL del curso';
$string['courseurl_help'] = 'Es la URL de su curso. Esta URL se muestra como enlace en el resultado de una búsqueda.';
$string['creatorname'] = 'Creador';
$string['creatorname_help'] = 'El creador es el creador del curso.';
$string['creatornotes'] = 'Notas del creador';
$string['creatornotes_help'] = 'Las notas del creador son una guía para los profesores acerca de cómo usar el curso.';
$string['deletescreenshots'] = 'Eliminar estos pantallazos';
$string['deletescreenshots_help'] = 'Eliminar todos los pantallazos actualmente subidos.';
$string['demourl'] = 'URL de demostración';
$string['demourl_help'] = 'Introduzca la dirección URL de demostración de su curso. De forma predeterminada es la URL de su curso. La dirección URL de demostración se muestra como un enlace en un resultado de búsqueda.';
$string['description'] = 'Descripción';
$string['description_help'] = 'Esta descripción se mostrará en el listado del curso en Moodle.net.';
$string['detectednotexistingpublication'] = '{$a->hubname} está listando un curso que ya no existe. Alerte al administrador que la publicación número {$a->id} debería eliminarse.';
$string['downloadable'] = 'Descargable';
$string['educationallevel'] = 'Nivel educativo';
$string['educationallevel_help'] = 'Seleccione el nivel educativo más adecuado para este curso.';
$string['edulevelassociation'] = 'Asociación';
$string['edulevelcorporate'] = 'Corporativo';
$string['edulevelgovernment'] = 'Gobierno';
$string['edulevelother'] = 'Otro';
$string['edulevelprimary'] = 'Primaria';
$string['edulevelsecondary'] = 'Secundaria';
$string['eduleveltertiary'] = 'Terciaria';
$string['emailalert'] = 'Notificaciones por correo electrónico';
$string['emailalert_help'] = 'Si está habilitado, el administrador de la central de cursos (\'hub\') le enviará correos electrónicos sobre temas de seguridad y otras noticias importantes.';
$string['enrollable'] = 'Inscripción posible';
$string['errorbadimageheightwidth'] = 'La imagen debe tener un tamaño máximo de {$a->width} X {$a->height}';
$string['errorcourseinfo'] = 'Se produjo un error al recuperar los metadatos del curso de ({$a}). Por favor, intente recuperar de nuevo los metadatos del curso volviendo a cargar esta página más adelante. De otro modo, puede decidir continuar el proceso de registro con los siguientes metadatos predeterminados.';
$string['errorcoursepublish'] = 'Se produjo un error durante la publicación del curso ({$a}). Por favor, inténtelo de nuevo más tarde.';
$string['errorcoursewronglypublished'] = 'Un error de publicación ha sido devuelto por Moodle.net. Por favor, inténtelo de nuevo más tarde.';
$string['errorcron'] = 'Se produjo un error durante la actualización del registro por "{$a->hubname}" ({$a->errormessage})';
$string['errorcronnoxmlrpc'] = 'XML-RPC debe estar habilitado a fin de actualizar el registro.';
$string['errorhublisting'] = 'Se produjo un error al recuperar el listado de hubs (Centrales de Cursos) de Moodle.org, por favor, inténtelo de nuevo más tarde. ({$a})';
$string['errorlangnotrecognized'] = 'El código de idioma que ha proporcionado es desconocido por Moodle. Por favor, póngase en contacto con {$a}';
$string['errorotherhubsnotsupported'] = 'Esta página ya no puede ser usada para registro con sitios diferentes de Moodle.net';
$string['errorregistration'] = 'Se produjo un error durante el registro, por favor, inténtelo de nuevo más tarde. ({$a})';
$string['errorregistrationupdate'] = 'Ocurrió un error durante la actualización del registro ({$a})';
$string['errorunpublishcourses'] = 'Debido a un error inesperado, no se han podido eliminar los cursos de Moodle.net. Inténtelo de nuevo más tarde (recomendado) o póngase en contacto con el administrador de Moodle.net.';
$string['errorws'] = '{$a}';
$string['errorwstokenreset'] = '{$a}. La ficha (token) de registro en este sitio ha sido reinciada. Usted puede registrar de nuevo su sitio ahora..';
$string['existingscreenshotnumber'] = '{$a} pantallazos existentes. Usted podrá ver estos pantallazos en esta página, solamente después de que el administrador de Moodle.net habilite su curso.';
$string['existingscreenshots'] = 'Pantallazos existentes';
$string['forceunregister'] = 'Sí, limpia los datos de registro';
$string['forceunregisterconfirmation'] = 'Su sitio no puede ver {$a}. Este hub podría estar temporalmente fuera de servicio. A menos que esté seguro de querer continuar para quitar el registro a nivel local, por favor cancele y vuelva a intentarlo más tarde';
$string['geolocation'] = 'Geolocalización';
$string['geolocation_help'] = 'En el futuro podríamos proporcionar búsqueda basada en la ubicación. Si desea especificar la ubicación de su curso use un valor de posición latitud/longitud (por ejemplo: 19.1950,99.1035). Una forma de encontrar este valor es mediante Google Maps.';
$string['hub'] = 'Central de Cursos (hub)';
$string['imageurl'] = 'URL de la imagen';
$string['imageurl_help'] = 'Esta imagen se mostrará en el hub. Esta imagen debe estar disponible en el hub en cualquier momento. La imagen debe tener un tamaño máximo de {$a->width} X {$a->height}';
$string['information'] = 'Información';
$string['issuedbadgesnumber'] = 'Número de insignias emitidas ({$a})';
$string['language'] = 'Idioma';
$string['language_help'] = 'Idioma principal de este curso,';
$string['lasttimechecked'] = 'Comprobado por última vez';
$string['licence'] = 'Licencia';
$string['licence_help'] = 'Seleccione la licencia bajo la que desea distribuir su curso.';
$string['logourl'] = 'URL del logotipo';
$string['mobilenotificationsenabled'] = 'Notificaciones Mobile habilitadas ({$a})';
$string['mobileservicesenabled'] = 'Servicios Mobile habilitados ({$a})';
$string['modulenumberaverage'] = 'Número promedio de módulos del curso ({$a})';
$string['moodleorg'] = 'Moodle';
$string['mustselectsubject'] = 'Usted debe seleccionar un tema/materia';
$string['name'] = 'Nombre';
$string['name_help'] = 'Este nombre se mostrará en el listado de cursos.';
$string['neverchecked'] = 'Nunca comprobado';
$string['next'] = 'Siguiente';
$string['no'] = 'No';
$string['nocheckstatusfromunreghub'] = 'Este sitio no está registrado en el hub, por lo que el estatus no puede comprobarse';
$string['nohubselected'] = 'No hub seleccionado';
$string['none'] = 'Ninguna';
$string['nosearch'] = 'No publicar hub o cursos';
$string['notregisteredonhub'] = 'Su administrador necesita registrar este sitio con Moodle.net  antes de que Usted pueda compartir un curso.';
$string['notregisteredonmoodleorg'] = 'Su administrador necesita registrar este sitio con moodle.org';
$string['operation'] = 'Acciones';
$string['orenterprivatehub'] = 'Alternativamente, escriba una URL de hub privado:';
$string['participantnumberaverage'] = 'Número promedio de participantes ({$a})';
$string['policyagreed'] = 'Aviso de privacidad y acuerdo con procesamiento de datos';
$string['policyagreeddesc'] = 'Yo estoy de acuerdo con el <a href="{$a}" target="_blank">Aviso de privacidad y acuerdo de procesamiento de datos </a> para Moodle.net';
$string['postaladdress'] = 'Dirección postal';
$string['postaladdress_help'] = 'Dirección postal de este sitio, o de la entidad representada por este sitio.';
$string['postsnumber'] = 'Número de mensajes ({$a})';
$string['previousregistrationdeleted'] = 'El registro previo ha sido borrado de {$a}. Usted puede reiniciar el proceso de registro. Gracias.';
$string['prioritise'] = 'Priorizar';
$string['privacy'] = 'Privacidad';
$string['privacy_help'] = 'El hub puede desear mostrar una lista de sitios registrados. Si lo hace, entonces usted puede elegir si desea o no figurar en esa lista.';
$string['private'] = 'Privado';
$string['privatehuburl'] = 'URL de hub privado';
$string['publicationinfo'] = 'Información de la publicación del curso';
$string['publichub'] = 'Hub público';
$string['publish'] = 'Compartir';
$string['publishcourse'] = 'Compartir {$a}';
$string['publishcourseon'] = 'Compartir en {$a}';
$string['publishedon'] = 'Compartición de curso';
$string['publisheremail'] = 'Email del Editor';
$string['publisheremail_help'] = 'La dirección de correo electrónico del editor permite al administrador del hub alertar al editor sobre cualquier cambio en el estatus del curso publicado.';
$string['publishername'] = 'Editor';
$string['publishername_help'] = 'El editor es la persona u organización editora oficial del curso. A menos que usted lo está publicando en nombre de otra persona, el editor será usted.';
$string['publishon'] = 'Compartir en';
$string['publishonspecifichub'] = 'Publicar en otro Hub';
$string['questionsnumber'] = 'Número de preguntas ({$a})';
$string['readvertiseon'] = 'Actualizar los avisos informativos en {$a}';
$string['registeredactiveuserdevices'] = 'Número de usuarios activos con dispositivos Mobile registrados que están recibiendo notificaciones ({$a})';
$string['registeredcourses'] = 'Cursos registrados';
$string['registeredmoodleorg'] = 'Moodle ({$a})';
$string['registeredon'] = 'En donde está registrado su sitio';
$string['registeredsites'] = 'Sitios registrados';
$string['registereduserdevices'] = 'Número de usuarios con dispositivos Mobile registrados ({$a})';
$string['registermoochtips'] = 'Registre su sitio con Moodle para recibir notificaciones acerca de alertas de seguridad y tener acceso a Moodle.net, nuestra plataforma para compartir cursos.';
$string['registersite'] = 'Registrarse con {$a}';
$string['registerwith'] = 'Registrarse con un hub';
$string['registrationconfirmed'] = 'Registro del sitio confirmado';
$string['registrationconfirmedon'] = 'Gracias por registrar su sitio. La información del registro se mantendrá actualizada por el trabajo agendado del sistema \'Registro del sitio\'.';
$string['registrationinfo'] = 'Información de registro';
$string['registrationupdated'] = 'El registro se ha actualizado.';
$string['registrationupdatedfailed'] = 'No se pudo actualizar el registro.';
$string['removefromhub'] = 'Eliminar de Moodle.net';
$string['renewregistration'] = 'Renovar registro';
$string['resourcesnumber'] = 'Número de recursos ({$a})';
$string['restartregistration'] = 'Reiniciar registro';
$string['roleassignmentsnumber'] = 'Número de asignaciones de rol ({$a})';
$string['screenshots'] = 'Pantallazos';
$string['screenshots_help'] = 'Cualquier captura de pantalla (pantallazo) del curso se mostrará en los resultados de búsqueda.';
$string['search'] = 'Buscar';
$string['selecthub'] = 'Seleccione hub';
$string['selecthubforadvertise'] = 'Seleccione central de cursos para publicidad';
$string['selecthubforsharing'] = 'Seleccione central de cursos para subidas';
$string['selecthubinfo'] = 'Un hub comunitario es un servidor que enlista cursos. Usted solo podrá compartir sus cursos en los hubs en los que este sitio Moodle esté registrado. Si el hub al que quiere acceder no se lista debajo, por favor póngase en contacto con el administrador de su sitio.';
$string['sendfollowinginfo'] = 'Más información';
$string['sendfollowinginfo_help'] = 'La siguiente información se enviará solo para contribuir a las estadísticas globales. No se hará pública en ningún listado del sitio';
$string['sendingcourse'] = 'Enviando curso';
$string['sendingsize'] = 'Por favor, espere; el curso está subiendo ({$a->total}Mb)...';
$string['sent'] = '...finalizado';
$string['settings'] = 'Configuración';
$string['settingsupdated'] = 'La configuración se ha actualizado.';
$string['share'] = 'Compartir este curso para su descarga';
$string['shared'] = 'Para que la gente descargue';
$string['shareon'] = 'Subir este curso a {$a}';
$string['shareonhub'] = 'Subir este curso a un hub';
$string['sharepublication_help'] = 'Un respaldo de este curso estará disponible en Moodle.net para que las personas lo restauren y usen en su propio sitio..';
$string['siteadmin'] = 'Administrador';
$string['siteadmin_help'] = 'Nombre completo del administrador del sitio';
$string['sitecommnews'] = 'Actualizaciones acerca de noticias y características de Moodle';
$string['sitecommnews_help'] = 'Usted tiene la opción de suscribirse a nuestra lista de Email de bajo volumen, que incluye una gaceta acerca de lo que está pasando en la comunidad Moodle.';
$string['sitecommnewsno'] = 'No, no quiero recibir ningun correo de Moodle HQ';
$string['sitecommnewsyes'] = 'Sí, por favor; inclúyanme en actualizaciones regulares de e-gaceta';
$string['sitecountry'] = 'País';
$string['sitecountry_help'] = 'El país en donde se encuentra su organización o institución.';
$string['sitecreated'] = 'Sitio creado';
$string['sitedesc'] = 'Descripción';
$string['sitedesc_help'] = 'Proporcione alguna información acerca de como está Usted usando Moodle.';
$string['siteemail'] = 'Dirección Email del administrador';
$string['siteemail_help'] = 'Es necesaria una dirección de correo electrónico, para que Moodle HQ pueda contactar con Usted en caso necesario. También puede ser usada para otros propósitos en caso de que Usted así lo permita debajo. Nosotros recomendamos emplear una dirección genérica de corrreo electrónico asociada a un cargo administrativo (por ejemplo: jefedecomputo@ejemplo.com) y no a una dirección personal.';
$string['sitegeolocation'] = 'Geolocalización';
$string['sitegeolocation_help'] = 'En el futuro podríamos proporcionar búsqueda basada en la ubicación. Si desea especificar la ubicación de su curso use un valor de posición latitud/longitud (por ejemplo: 19.1950,99.1035). Una forma de encontrar este valor es mediante Google Maps.';
$string['sitelang'] = 'Idioma';
$string['sitelang_help'] = '¿Cual es el idioma principal usado en su sitio Moodle?';
$string['sitename'] = 'Nombre';
$string['sitename_help'] = 'El nombre del sitio aparecerá en el listado de sitios si el hub lo permite.';
$string['sitephone'] = 'Teléfono';
$string['sitephone_help'] = 'Su número de teléfono sólo será visto por el administrador del hub';
$string['siteprivacy'] = 'Enlistar el sitio';
$string['siteprivacy_help'] = 'Usted puede elegir tener su sitio enlistado públicamente en la lista de sitios registrados, con o sin un enlace hacia su sitio.';
$string['siteprivacylinked'] = 'Mostrar el nombre de mi sitio con el enlace';
$string['siteprivacynotpublished'] = 'No enlistar mi sitio';
$string['siteprivacypublished'] = 'Únicamente mostrar el nombre de mi sitio';
$string['siteregconfcomment'] = 'Su sitio necesita una confirmación final en {$a} (con el fin de evitar el spam en {$a})';
$string['siteregistrationcontact'] = 'Mostrar formato de contacto';
$string['siteregistrationcontact_help'] = 'Si usted lo permite, otras personas en nuestra comunidad Moodle (quienes necesitan una cuenta para ingresar) podrán contactar con usted a través de un formato en nuestro sitio de Comunidad Moodle. Sin embargo, ellos nunca podrán ver la dirección Email de Usted.';
$string['siteregistrationemail'] = 'Notificaciones acerca de asuntos técnicos y de seguridad importantes.';
$string['siteregistrationemail_help'] = 'Usted tiene la opción de suscribirse a nuestra lista de correo de bajo volumen para noticias importantes (sobre asuntos de seguridad o nuevas versiones).';
$string['siteregistrationupdated'] = 'Se ha actualizado el registro del sitio';
$string['siterelease'] = 'Versión liberada de Moodle';
$string['siterelease_help'] = 'Número de la versión liberada de Moodle de este sitio';
$string['sitereleasenum'] = 'Versión de Moodle ({$a})';
$string['siteupdatedcron'] = 'Registro del sitio actualizado en "{$a}"';
$string['siteupdatesend'] = 'Se terminó la actualización del registro en hubs';
$string['siteupdatesstart'] = 'Iniciando la actualización del registro en hubs';
$string['siteurl'] = 'URL del sitio';
$string['siteurl_help'] = 'La URL es la dirección de este sitio. Si la configuración de privacidad permite que la gente vea la dirección del sitio, esta es la URL que se utilizará.';
$string['siteversion'] = 'Versión de Moodle';
$string['siteversion_help'] = 'La versión de Moodle de este sitio.';
$string['skipregistration'] = 'Saltar';
$string['specifichubregistrationdetail'] = 'También puede registrar su sitio en otras Centrales de Cursos (hubs) comunitarias';
$string['statistics'] = 'Privacidad de estadísticas';
$string['status'] = 'Estatus de listado';
$string['statuspublished'] = 'Listado';
$string['statusunpublished'] = 'No listado';
$string['subject'] = 'Asunto';
$string['subject_help'] = 'Seleccione el tema principal del que trata el curso.';
$string['tags'] = 'Marcas';
$string['tags_help'] = 'Las marcas ayudan a clasificar mejor su curso y ayudan a encontrarlo. Por favor, use palabras sencillas y significativas separadas por una coma. Ejemplo: matemáticas, álgebra, geometría';
$string['trustme'] = 'Confiar';
$string['type'] = 'Compartido';
$string['unknownstatus'] = 'Desconocido';
$string['unlistedurl'] = 'URL de hub fuera de la lista';
$string['unprioritise'] = 'Des-priorizar';
$string['unpublish'] = 'Dejar de compartir';
$string['unpublishalladvertisedcourses'] = 'Retirar todos los cursos que estaban compartidos en Moodle.net para que la gente se una';
$string['unpublishalluploadedcourses'] = 'Retirar todos los cursos que estaban compartidos en Moodle.net para que la gente los descargue';
$string['unpublishconfirmation'] = '¿Está seguro de que quiere eliminar el curso " {$a->courseshortname}" de " {$a->hubname}"';
$string['unpublishcourse'] = 'Dejando de compartir {$a}';
$string['unregister'] = 'Anular el registro';
$string['unregisterconfirmation'] = 'Está a punto de dar de baja este sitio de la central de cursos {$a}. Una vez que se desconecte, no podrá gestionar ninguno de los cursos dejados en ella. ¿Está seguro de que quiere darlo de baja?';
$string['unregisterexplained'] = 'Si el sitio con  URL {$a} es registrado en Moodle.net su registro será eliminado.';
$string['unregisterfrom'] = 'Anular el registro de {$a}';
$string['unregistrationerror'] = 'Se produjo un error cuando el sitio ha intentado quitar el registro en Moodle,net: {$a}';
$string['untrustme'] = 'No confiable';
$string['update'] = 'Actualizar';
$string['updatesite'] = 'Actualizar registro en {$a}';
$string['updatestatus'] = 'Comprobarlo ahora.';
$string['uploaded'] = 'Comprobarlo ahora.';
$string['url'] = 'URL del hub';
$string['urlalreadyregistered'] = 'Parece que su sitio ya estaba registrado en Moodle.net, lo que significa que algo ha ido mal. Póngase en contacto con el administrador de Moodle,net para que reinicie su registro y usted pueda intentarlo de nuevo.';
$string['usedifferentemail'] = 'Usar Email diferente';
$string['usersnumber'] = 'Número de usuarios ({$a})';
$string['warning'] = 'ADVERTENCIA';
$string['wrongtoken'] = 'El registro falló por alguna razón desconocida (¿red?). Por favor, pruebe de nuevo.';
$string['wrongurlformat'] = 'Formato de dirección URL erróneo';
$string['xmlrpcdisabledcommunity'] = 'La extensión XML-RPC no está habilitada en el servidor. No se pueden buscar y descargar los cursos.';
$string['xmlrpcdisabledpublish'] = 'La extensión XML-RPC no está habilitada en el servidor, por lo que no es posible compartir cursos o gestionar cursos compartidos.';
$string['xmlrpcdisabledregistration'] = 'La extensión XML-RPC no está habilitada en el servidor. No podrá darse de baja ni actualizar su registro hasta que no la habilite';
