<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_simple', language 'ja', version '3.5'.
 *
 * @package     theme_simple
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['choosereadme'] = '<div class="clearfix">
<h2>Simple</h2>
<p>Simple template to extend the standard theme</p>
<h2>Key features</h2>
<ul>
<li>Simple design</li>
<li>Multi device optimized: "Simple" follows the best practice of using responsive web design, namely serving the same HTML for devices and using only CSS media queries to decide the rendering on each device</li>
<li>Easy to change the template color (possible to use different colors for different departments)</li>
<li>The front-page design uses blocks in the content area and displaying them as boxes</li>
<li>Changeable columns and height in "My home" for each user</li>
<li>Changeable font size for each user</li>
</ul>
</div>';
$string['pluginname'] = 'シンプル';
$string['region-side-post'] = '右';
$string['region-side-pre'] = '左';
