<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'filter_poodll', language 'fr', version '3.5'.
 *
 * @package     filter_poodll
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['REGION_APN1'] = 'Asie pacifique (Tokyo)';
$string['REGION_APN2'] = 'Asie pacifique (Séoul)';
$string['REGION_APS1'] = 'Asie pacifique (Mumbai)';
$string['REGION_APSE1'] = 'Asie pacifique (Singapour)';
$string['REGION_APSE2'] = 'Asie pacifique (Sydney)';
$string['REGION_CAC1'] = 'Canada (Centre)';
$string['REGION_EUC1'] = 'EU (Francfort)';
$string['REGION_EUW1'] = 'EU (irlande)';
$string['REGION_EUW2'] = 'EU (Londres)';
$string['REGION_SAE1'] = 'Amérique du sud (San Paolo)';
$string['REGION_USE1'] = 'E.U. côte est (Virginie du Nord)';
$string['REGION_USE2'] = 'E.U. côte est (Ohio)';
$string['REGION_USW1'] = 'E.U. côte ouest (Californie du Nord)';
$string['REGION_USW2'] = 'E.U. côte ouest (Oregon)';
$string['accountdashboard'] = 'Tableau de bord du compte';
$string['activate'] = 'Activer Poodll ?';
$string['advancedsettings'] = 'Paramètres avancés';
$string['alwayshtml5'] = 'Toujours utiliser HTML5';
$string['appauthorised'] = 'Le filtre Poodll est autorisé pour ce site.';
$string['appnotauthorised'] = 'Le filtre Poodll n\'est pas autorisé pour ce site.';
$string['audio'] = 'Audio';
$string['audiotranscode'] = 'Conversion automatique en MP3';
$string['audiotranscodedetails'] = 'Conversion des fichiers audio enregistrés ou téléversés au format MP3 avant de les stocker dans Moodle. Fonctionne seulement lorsque vous utilisez le serveur tokyo.poodll.com, ou les enregistrements téléversés si vous utilisez FFMPEG.';
$string['autotryports'] = 'Essayez des ports différents si la connexion échoue';
$string['awsregion'] = 'Région Cloud (AWS)';
$string['awsregion_desc'] = 'Certains services Poodll, y compris la conversion à distance et la synthèse vocale, sont assistés par des services cloud. Choisissez la région la plus proche de votre serveur Moodle pour obtenir les meilleures performances et respecter les règles ou réglementations de protection des données qui vous concernent.';
$string['awssdkauto'] = 'Sélection automatique du kit SDK AWS';
$string['awssdklocal'] = 'Utilisez le kit SDK AWS du plugin local_aws';
$string['awssdknone'] = 'Ne pas utiliser de  kit SDK AWS';
$string['awssdkv2'] = 'Utiliser le kit SDK AWS V2';
$string['awssdkv3'] = 'Utiliser le kit SDK AWS V3';
$string['bandwidth'] = 'Connexion étudiant en octets par seconde. Affecte la qualité de la Webcam.';
$string['bgtranscode_audio'] = 'Convertir en MP3 en tâche de fond';
$string['bgtranscode_video'] = 'Convertir en MP4 en tâche de fond';
$string['bgtranscodedetails_audio'] = 'C\'est plus fiable qu\'exécuter la conversion alors que l\'utilisateur attend. Mais l\'utilisateur n\'obtiendra pas son audio tant que le cron n\'aura pas été exécuté après l\'enregistrement. Ne fonctionne que si vous utilisez FFMPEG et Moodle 2.7 ou supérieur. Pour les enregistrements en MP3 avec l\'enregistreur MP3, la conversion a lieu dans le navigateur, pas sur le serveur. Donc la conversion côté serveur (FFMPEG) ne sera pas utilisée.';
$string['bgtranscodedetails_video'] = 'C\'est plus fiable qu\'exécuter la conversion alors que l\'utilisateur attend. Mais l\'utilisateur n\'obtiendra pas son audio tant que le cron n\'aura pas été exécuté après l\'enregistrement. Ne fonctionne que si vous utilisez FFMPEG et Moodle 2.7 ou supérieur.';
$string['bmr_recorder'] = 'Rose brûlé';
$string['bundle'] = 'Paquet';
$string['burntrose_recorder'] = 'Rose brûlé';
$string['cameraback'] = '';
$string['camerafront'] = 'de face';
$string['cancel'] = 'Annuler';
$string['capturefps'] = 'Enregistrement vidéo : images par seconde';
$string['captureheight'] = 'Enregistrement vidéo : hauteur';
$string['capturewidth'] = 'Enregistrement vidéo : largeur';
$string['cleartemplate'] = 'Effacer le modèle';
$string['cpapi_heading'] = 'Paramétrages de l\'API Poodll';
$string['cpapisecret'] = 'Clé secrète API Poodll';
$string['cpapisecret_details'] = 'Ceci peut être obtenu à partir de l\'onglet Crédits API de votre espace membre sur Poodll.com.';
$string['cpapiuser'] = 'Nom de l\'utilisateur de l\'API Poodll';
$string['cpapiuser_details'] = 'Il est identique à votre nom d\'utilisateur sur Poodll.com.';
$string['credentialsinvalid'] = 'Le nom d\'utilisateur et la clé secrète de l\'API entrés ne peuvent pas être utilisés pour obtenir un accès. Veuillez les vérifier.';
$string['dataset'] = 'Ensemble de données';
$string['dataset_desc'] = 'Poodll vous permet d\'extraire un ensemble de données de la base de données pour l\'utiliser dans votre modèle. Ceci est une fonctionnalité avancée. Entrez la partie sql d\'un appel $DB->get_records_sql ici.';
$string['datasetvars'] = 'Variables de l\'ensemble de données';
$string['datasetvars_desc'] = '';
$string['debug_enable'] = 'Activer le débogage';
$string['debug_enable_details'] = 'Si activé, les informations sur les enregistrements seront stockées dans les journaux Moodle. Celles-ci sont destinées à faciliter le dépannage et l\'assistance du service d\'assistance Poodll. Désactivez-le si vous n\'en avez pas besoin sinon vous stockerez des informations inutiles dans les journaux Moodle.';
$string['debug_heading'] = 'Débogage Poodll';
$string['default_camera'] = 'Caméra par défaut';
$string['defaultwhiteboard'] = 'Tableau blanc par défaut';
$string['displaysubs'] = '{$a->subscriptionname} : se termine le {$a->expiredate}';
$string['end'] = 'Expiration';
$string['event_adhoc_completed'] = 'Tâche Poodll Adhoc terminée';
$string['event_adhoc_convert_completed'] = 'Tâche Poodll Adhoc convert terminée';
$string['event_adhoc_convert_registered'] = 'Tâche Poodll Adhoc convert enregistrée';
$string['event_adhoc_move_completed'] = 'Tâche de déplacement Poodll Adhoc terminée';
$string['event_adhoc_move_registered'] = 'Tâche de déplacement Poodll Adhoc enregistrée';
$string['event_adhoc_registered'] = 'Tâche Poodll Adhoc enregistrée';
$string['event_debug_log'] = 'Note de débogage Poodll';
$string['expired'] = 'Poodll ne s\'affiche pas car l\'enregistrement a expiré. Demandez à votre enseignant/administrateur de renouveler votre inscription sur Poodll.com.';
$string['exportdiagnostics'] = 'Exporter';
$string['extensions'] = 'Extensions des fichiers';
$string['extensions_desc'] = 'Une liste CSV (valeurs séparées par des virgules) des extensions de fichier que ce filtre peut analyser.';
$string['extensionsettings'] = 'Paramètres d\'extension de fichier';
$string['failedfetchsubreport'] = 'Échec de la récupération du rapport d\'abonnement';
$string['ffmpeg'] = 'Convertir avec ffmpeg les fichiers multimédia déposés';
$string['ffmpeg_details'] = 'Le logiciel ffmpeg doit être installé sur votre serveur Moodle, et dans le chemin système. Il devra prendre en charge la conversion en MP3. Essayez d\'abord en ligne de commande. Par exemple : ffmpeg-i somefile.flv somefile.mp3 . C\'est encore « expérimental ».';
$string['filter_poodll_audioplayer_heading'] = 'Paramètres du lecteur audio';
$string['filter_poodll_camera_heading'] = 'Paramètres de la webcam (Flash seulement)';
$string['filter_poodll_flashcards_heading'] = 'Paramètres des Flashcards';
$string['filter_poodll_html5recorder_heading'] = 'Paramètres de l\'enregistreur HTML5';
$string['filter_poodll_mic_heading'] = 'Paramètres du microphone (Flash seulement)';
$string['filter_poodll_mp3recorder_heading'] = 'Paramètres de l\'enregistreur MP3 (Flash seulement)';
$string['filter_poodll_network_heading'] = 'Paramètres du serveur Red5 Poodll';
$string['filter_poodll_registration_explanation'] = 'Pour autoriser Poodll, entrez votre nom d\'utilisateur et votre phrase secrète d\'API Poodll. Vous pouvez les obtenir sur <a href=\'https://poodll.com/member\'> https://poodll.com/member </a> après vous être abonné. L\'ancien système de longue clé d\'enregistrement est obsolète, mais toujours disponible dans le menu avancé. Cependant, vous aurez besoin des informations d\'identification de l\'API pour utiliser les services assistés par le cloud Poodll.';
$string['filter_poodll_registration_heading'] = 'Enregistrer votre Poodll';
$string['filter_poodll_videogallery_heading'] = 'Paramètres de la galerie vidéo';
$string['filter_poodll_videoplayer_heading'] = 'Paramètres du lecteur vidéo';
$string['filter_poodll_whiteboard_heading'] = 'Paramètres du tableau blanc';
$string['filtername'] = 'Filtre Poodll';
$string['flashcardstype'] = 'Type de flashcards';
$string['flashonandroid'] = 'Utiliser Flash sur Android';
$string['flashonandroid_desc'] = 'Il est possible d’utiliser Flash sur Android, même si dans de nombreux cas, il n’est pas disponible et il est difficile de communiquer aux étudiants quoi faire. Donc par défaut il est désactivé.';
$string['fluencybuilder_recorder'] = 'Générateur de fluidité';
$string['fresh_recorder'] = 'Fresh';
$string['generalsettings'] = 'Paramètres généraux';
$string['gold_recorder'] = 'Bouton unique';
$string['handle'] = 'Gérer {$a}';
$string['have_recent_event'] = 'Vous avez trouvé un événement de fin de déplacement récemment déclenché pour : {$a}';
$string['have_task'] = 'Vous avez trouvé une tâche de déplacement / conversion en attente pour : {$a}';
$string['highquality'] = 'haute';
$string['html5ondsafari'] = 'Utiliser sur le bureau Safari';
$string['html5ondsafaridetails'] = 'Safari peut ne pas sélectionner le bon périphérique audio et il n\'y a pas d\'option pour en sélectionner un autre. Dans la plupart des cas, ça va, mais sur Mac Mini, il se peut qu\'il ne détecte pas du tout un périphérique audio fonctionnel.';
$string['html5recorder_skin_audio'] = 'Habillage enregistreur HTML5 (vidéo)';
$string['html5recorder_skin_video'] = 'Habillage enregistreur HTML5 (vidéo)';
$string['insert'] = 'Insérer';
$string['jumpcat_explanation'] = 'L\'ensemble complet des paramètres du filtre Poodll se trouve <a href="{$a}"> ici </a>.';
$string['jumpcat_heading'] = 'Paramètres du filtre Poodll';
$string['legacysettings'] = 'Paramètres obsolètes';
$string['license_details'] = '<br> -------------- <br> Type de licence : {$a->license_type} <br> Termine (JST) : {$a->expire_date} <br> URL enregistrée : {$a->registered_url}';
$string['lowquality'] = 'basse';
$string['mediumquality'] = 'moyenne';
$string['miccanpause'] = 'Autoriser la mise en pause (enregistreur MP3 uniquement)';
$string['micecho'] = 'Écho du micro';
$string['micgain'] = 'Gain du micro';
$string['micloopback'] = 'Bouclage du micro';
$string['micrate'] = 'Volume du micro';
$string['micsilencelevel'] = 'Niveau du silence micro';
$string['mobile_audio_quality'] = 'Qualité audio';
$string['mobile_os_version_warning'] = '<p>La version de votre système d\'exploitation est trop ancienne.</p>
<ul>
<li>Android : version 4 minimum</li>
<li>iOS : version 6 minimum</li>
</ul>';
$string['mobile_show'] = 'Afficher mobile';
$string['mobile_show_desc'] = 'Lorsque l\'utilisateur est sur un appareil iOS, un bouton « télécharger / enregistrer » et un bouton « utiliser l\'application Poodll » lui sont affichés à la place d\'un enregistreur. Décochez cette option pour masquer le bouton de l\'application Poodll.';
$string['mobile_video_quality'] = 'Qualité vidéo';
$string['mobileandwebkit'] = 'Mobiles + navigateurs Webkit (Safari, Chrome, etc.)';
$string['mobileonly'] = 'Seulement les appareils mobiles';
$string['mobilesettings'] = 'Paramètres App iOS';
$string['mp3_nocloud'] = 'Aucun cloud';
$string['mp3_nocloud_details'] = 'Ne soumettez pas les enregistrements Flash MP3 dans le Cloud pour le transcoder et le copier.';
$string['mp3opts'] = 'Options de conversion MP3 de FFmpeg';
$string['mp3opts_details'] = 'Laissez ceci vide si vous souhaitez laisser FFmpeg prendre les décisions. Tout ce que vous entrez ici apparaîtra entre [ffmpeg -i myfile.xx ] et [ myfile.mp3 ]';
$string['mp3skin'] = 'Habillage MP3';
$string['mp3skin_details'] = 'Si vous voulez utiliser un habillage de l\'enregistreur, entrez son nom ici. Sinon, saisissez : none.';
$string['mp4opts'] = 'Options de conversion MP4 de FFmpeg';
$string['mp4opts_details'] = 'Laissez ceci vide si vous souhaitez laisser FFmpeg prendre les décisions. Tout ce que vous entrez ici apparaîtra entre [ffmpeg -i myfile.xx ] et [ myfile.mp4 ]';
$string['neverhtml5'] = 'Ne jamais utiliser HTML5';
$string['ninety_days'] = '90 Jours';
$string['no_event_or_task'] = 'Aucune tâche de déplacement en attente, ni d\'événement de déplacement terminé pour : {$a}';
$string['no_subscriptions'] = 'Aucun abonnement.';
$string['noapisecret'] = 'Aucune phrase secrète API saisie.';
$string['noapiuser'] = 'Aucun utilisateur API saisi.';
$string['normal'] = 'Normal';
$string['notokenincache'] = 'Actualisez pour voir les informations de licence. Contactez le support Poodll en cas de problème.';
$string['once_recorder'] = 'Une fois';
$string['oneeighty_days'] = '180 Jours';
$string['onetwothree_recorder'] = 'Un Deux Trois';
$string['per_plugin'] = 'Par plugin (dernière année)';
$string['per_recording_type'] = 'Par type d\'enregistreur';
$string['picqual'] = 'Cible webcam qual. 1 - 10';
$string['placeholder_heading'] = 'Paramètres de fichier audio et vidéo de remplacement personnalisés';
$string['placeholder_heading_desc'] = 'Les fichiers d\'espace réservé audio et vidéo sont utilisés dans Poodll tandis que les fichiers sont convertis en MP3 ou MP4. Si ceux par défaut ne vous conviennent pas, vous pouvez en télécharger des personnalisés ici. Consultez <a href=\'https://support.poodll.com/support/solutions/articles/19000083252-custom-audio-and-video-placeholders\'> ici </a> pour plus de détails sur la façon de procéder.';
$string['placeholderaudiofile'] = 'Fichier audio de remplacement (.mp3)';
$string['placeholderaudiofile_desc'] = 'Téléchargez un fichier MP3 ici et Poodll l\'utilisera comme espace réservé.';
$string['placeholderaudiosecs'] = 'Durée audio (secondes)';
$string['placeholderaudiosecs_details'] = 'Durée en secondes avec au moins une décimale de l\'audio de remplacement';
$string['placeholdervideofile'] = 'Fichier vidéo de remplacement (.mp4)';
$string['placeholdervideofile_desc'] = 'Déposez un fichier MP4 ici et Poodll l\'utilisera comme fichier de remplacement.';
$string['placeholdervideosecs'] = 'Durée de la vidéo (sec.)';
$string['placeholdervideosecs_details'] = 'Durée en secondes avec au moins une décimale de la vidéo de remplacement';
$string['plain_recorder'] = 'Brut';
$string['player'] = 'Lecteur {$a}';
$string['playertype'] = 'lecteur';
$string['pluginname'] = 'Filtre Poodll';
$string['poodll:candownloadmedia'] = 'Peut télécharger des médias';
$string['poodll:comparetext'] = 'Autoriser la comparaison de texte via l\'API.';
$string['poodll:use'] = 'Peut utiliser le filtre Poodll';
$string['poodll_users'] = 'Utilisateurs Poodll';
$string['poodllsupportinfo'] = 'Information de support Poodll';
$string['poodlltemplatesadmin'] = 'Administration des modèles du filtre Poodll';
$string['ppn_assignfeedback_onlinepoodll'] = 'Feedback Poodll';
$string['ppn_assignsubmission_onlinepoodll'] = 'Dépôt Poodll';
$string['ppn_atto_generico'] = 'Atto Generico';
$string['ppn_atto_poodll'] = 'Poodll Atto';
$string['ppn_atto_snippet'] = 'Atto Snippet';
$string['ppn_atto_subtitle'] = 'Sous-titre Atto';
$string['ppn_data_field_poodll'] = 'Champ BD Poodll';
$string['ppn_essentials_plus'] = 'Essentials (Plus)';
$string['ppn_filter_generico'] = 'Filtre generico';
$string['ppn_filter_poodll'] = 'Filtre Poodll';
$string['ppn_filter_videoeasy'] = 'Filtre VideoEasy';
$string['ppn_local_trigger'] = 'Déclencheur';
$string['ppn_mod_englishcentral'] = 'EnglishCentral';
$string['ppn_mod_pchat'] = 'pChat';
$string['ppn_mod_readaloud'] = 'A voix haute';
$string['ppn_mod_voicestudio'] = 'Studio de voix';
$string['ppn_na'] = 'N.D.';
$string['ppn_p_chat_standard'] = 'pChat (standard)';
$string['ppn_portfolio_blogexport'] = 'BlogExport';
$string['ppn_qtype_poodllrecording'] = 'Question Poodll';
$string['ppn_repository_poodll'] = 'Dépôt Poodll';
$string['ppn_tinymce_poodll'] = 'Poodll TinyMCE';
$string['presets'] = 'Modèle de remplissage automatique avec un préréglage';
$string['presets_desc'] = 'Poodll est livré avec des préréglages par défaut que vous pouvez utiliser directement ou pour vous aider à démarrer avec votre propre modèle. Choisissez l\'un de ceux-ci ici ou créez simplement votre propre modèle à partir de zéro. Vous pouvez exporter un modèle sous forme de paquetage en cliquant sur la case verte ci-dessus. Vous pouvez importer un paquetage en le faisant glisser sur la case verte.';
$string['privacy:metadata'] = 'Le plugin filtre Poodll ne stocke aucune donnée personnelle.';
$string['readaloud_recorder'] = 'Lit à voix haute';
$string['recorderorder'] = 'Ordre préféré des enregistreurs';
$string['recorderorder_audio'] = 'Ordre des enregistreurs audio';
$string['recorderorder_desc'] = 'Poodll choisira le meilleur enregistreur possible si le navigateur de l\'utilisateur et la plate-forme le prennent en charge. Vous pouvez définir l\'ordre ici.';
$string['recorderorder_snapshot'] = 'Ordre des enregistreurs de capture d\'écran';
$string['recorderorder_video'] = 'Ordre des enregistreurs vidéo';
$string['recorderorder_whiteboard'] = 'Ordre des enregistreurs de tableau blanc';
$string['recorderorder_whiteboard_desc'] = '(Ce paramètre n\'est actuellement pas utilisé et pourrait bientôt être supprimé de Poodll)';
$string['recording_min'] = 'Minutes d\'enregistrement';
$string['recordings'] = 'Enregistrements';
$string['recui_audiogain'] = 'Gain audio';
$string['recui_audiorate'] = 'Taux audio';
$string['recui_awaitingconfirmation'] = 'En attente de confirmation';
$string['recui_awaitingconversion'] = 'En attente de conversion';
$string['recui_btnupload'] = 'Enregistrer ou choisir un fichier';
$string['recui_cancelsnapshot'] = 'Annuler';
$string['recui_choosefile'] = 'Choisir le fichier';
$string['recui_clicktofinish'] = 'Cliquez pour arrêter';
$string['recui_close'] = 'Fermer';
$string['recui_continue'] = 'Continuer';
$string['recui_converting'] = 'conversion';
$string['recui_downloadfile'] = 'Télécharger l\'enregistrement';
$string['recui_echo'] = 'Suppression d\'écho';
$string['recui_finished'] = 'Terminé';
$string['recui_inaudibleerror'] = 'Impossible de vous entendre. Veuillez vérifier les permissions Flash et celles du navigateur internet.';
$string['recui_loopback'] = 'Bouclage';
$string['recui_mediaaborterror'] = 'Quelque chose d\'étrange  qui a empêché l\'utilisation de la webcam ou du micro s\'est produit';
$string['recui_medianotallowederror'] = 'L\'utilisateur doit autoriser le navigateur à accéder à la webcam et au micro';
$string['recui_medianotfounderror'] = 'Aucun appareil d\'enregistrement n\'est connecté ou activé';
$string['recui_medianotreadableerror'] = 'Quelque chose empêche le navigateur d\'accéder à la webcam ou au micro';
$string['recui_medianotsupportederror'] = 'Votre type de navigateur ne prend pas en charge l’enregistrement via une connexion HTTP.';
$string['recui_mediaoverconstrainederror'] = 'La webcam / le microphone actuel ne peut pas générer de flux avec les exigences actuelles';
$string['recui_mediasecurityerror'] = 'Votre type de navigateur ne prend pas en charge l’enregistrement via une connexion HTTP.';
$string['recui_mediatypeerror'] = 'Échec d\'obtention du flux car aucun type de média n\'a été spécifié.';
$string['recui_nothingtosaveerror'] = 'Rien n\'a été capturé. Désolé… rien à déposer.';
$string['recui_off'] = 'Désactivé';
$string['recui_ok'] = 'OK';
$string['recui_on'] = 'Activé';
$string['recui_openrecorderapp'] = 'Application Poodll';
$string['recui_pause'] = 'Pause';
$string['recui_play'] = 'Lecture';
$string['recui_playing'] = 'Lire :';
$string['recui_pushtospeak'] = 'Appuyez pour parler';
$string['recui_ready'] = 'Prêt';
$string['recui_readytorecord'] = 'Prêt à enregistrer';
$string['recui_record'] = 'Enregistrer';
$string['recui_recordagain'] = 'Enregistrer à nouveau';
$string['recui_recording'] = 'Enregistrement :';
$string['recui_recordorchoose'] = 'Enregistrer ou choisir';
$string['recui_restart'] = 'Redémarrer';
$string['recui_save'] = 'Déposer';
$string['recui_silencelevel'] = 'Niveau de silence';
$string['recui_stop'] = 'Stop';
$string['recui_takesnapshot'] = 'Prendre une photo';
$string['recui_testmic'] = 'Prêt à enregistrer';
$string['recui_time'] = 'Temps :';
$string['recui_timeouterror'] = 'La demande a expiré. Désolé.';
$string['recui_unsupportedbrowser'] = 'Ce navigateur ne peut pas enregistrer ici. Désolé.<br>Veuillez essayer Google Chrome sur un ordinateur de bureau.';
$string['recui_upload'] = 'Déposer';
$string['recui_uploadafile'] = 'Fichier importé';
$string['recui_uploaderror'] = 'Une erreur est survenue et votre fichier n\'a PAS été déposé.';
$string['recui_uploading'] = 'téléversement en cours';
$string['recui_uploadsuccess'] = 'Importé avec succès';
$string['recui_waitwaitstilluploading'] = 'Votre fichier est toujours en cours de chargement. Voulez-vous vraiment quitter cette page ?';
$string['refreshtoken'] = 'Actualiser les informations de licence';
$string['registrationkey'] = 'Clé d\'enregistrement';
$string['registrationkey_explanation'] = 'Entrez votre clé d\'enregistrement Poodll ici uniquement si vous n\'avez pas entré de clé API et de phrase secrète ci-dessus. Vous pouvez obtenir une clé sur <a href=\'https://poodll.com/pricing\'>https://poodll.com/pricing</a>';
$string['serverhttpport'] = 'Port du serveur Red5 Poodll (HTTP)';
$string['serverid'] = 'Identifiant du serveur Red5 Poodll';
$string['servername'] = 'Adresse du serveur Red5 Poodll';
$string['serverport'] = 'Port du serveur Red5 Poodll (RTMP)';
$string['settings'] = 'Paramètres du filtre Poodll';
$string['shadow_recorder'] = 'Ombre';
$string['showdownloadicon'] = 'Afficher le bouton de téléchargement sous les lecteurs';
$string['showdownloadicon_desc'] = 'Votre fichier est toujours en cours de chargement. Voulez-vous vraiment quitter cette page ?';
$string['sitedefault'] = 'Site par défaut';
$string['size'] = 'Taille';
$string['skinstyleaudio'] = 'Style d\'habillage (audio)';
$string['skinstyleaudio_details'] = 'Un nom de classe CSS qui sera ajouté à l\'enregistreur audio pour aider à personnaliser l\'apparence de l\'enregistreur.';
$string['skinstylevideo'] = 'Style d\'habillage (vidéo)';
$string['skinstylevideo_details'] = 'Nom de la classe CSS qui sera ajouté à l’enregistreur vidéo pour aider à la personnalisation de son apparence.';
$string['split_recorder'] = 'Divisé';
$string['start'] = 'Démarrer';
$string['studentcam'] = 'Nom choisi pour l\'appareil photo';
$string['studentmic'] = 'Nom choisi pour le microphone';
$string['subscription'] = 'Abonnement';
$string['supportinfo'] = 'Support Info';
$string['template'] = 'Le corps du modèle {$a}';
$string['template_desc'] = 'Placez le modèle ici, définissez les variables en les entourant de marques @@ soit par exemple @@ variable @@';
$string['template_showatto'] = 'Afficher dans Atto (modèle {$a})';
$string['template_showatto_desc'] = 'Affichez un bouton et une forme pour ce widget dans la boîte de dialogue Poodll Widgets pour Atto.';
$string['template_showplayers'] = 'Afficher dans la liste des lecteurs (modèle {$a})';
$string['template_showplayers_desc'] = 'Afficher dans la liste déroulante les lecteurs pouvant être associés à une extension de fichier.';
$string['templatealternate'] = 'Contenu alternatif (modèle {$a})';
$string['templatealternate_desc'] = 'Contenu pouvant être utilisé lorsque le contenu CSS et JavaScript personnalisé n\'est pas disponible. Actuellement, cela est utilisé lorsque le modèle est traité par un service Web, probablement pour le contenu de l\'application mobile';
$string['templatealternate_end'] = 'Fin du contenu alternatif (modèle {$a})';
$string['templatealternate_end_desc'] = 'Fermeture des balises de contenu alternatives pour les modèles qui entourent le contenu utilisateur avec des balises Poodll de début et de fin';
$string['templatecount'] = 'Nombre de modèles';
$string['templatecount_desc'] = 'Le nombre de modèles que vous pouvez avoir ; 20 par défaut.';
$string['templatedefaults'] = 'Variables par défaut (modèle {$a})';
$string['templatedefaults_desc'] = 'Définissez les valeurs par défaut dans des ensembles de paires nom=valeur séparées par des virgules, par exemple : largeur=800, hauteur=900, sensation=joie';
$string['templateend'] = 'Balise de fin (modèle {$a})';
$string['templateend_desc'] = 'Si votre modèle comprend du contenu utilisateur, par exemple une zone d’information, placez les balises de fermeture ici. L\'utilisateur entrera quelque chose comme {POODLL:mytag_end} pour fermer le filtre.';
$string['templateheading'] = 'Paramètres pour le modèle Poodll {$a}';
$string['templateheadingcss'] = 'Paramètres CSS/Style.';
$string['templateheadingjs'] = 'Paramètres Javascript.';
$string['templateinstructions'] = 'Instructions (modèle {$a})';
$string['templateinstructions_desc'] = 'Toutes les instructions entrées ici seront affichées sur le formulaire Poodll atto si ce modèle est disponible pour être affiché. Les instructions doivent être courtes sinon l\'affichage du formulaire sera mauvais.';
$string['templatekey'] = 'La clé qui identifie le modèle {$a}';
$string['templatekey_desc'] = 'La clé doit être constituée d\'un mot et ne contenir que des chiffres et des lettres, des traits de soulignement, des traits d\'union et des points.';
$string['templatename'] = 'Le nom qui s\'affiche pour le modèle {$a}';
$string['templatename_desc'] = 'Le nom peut contenir des chiffres et des lettres, des traits de soulignement, des tirets et des points.';
$string['templatepageheading'] = '(T) : {$a}';
$string['templatepageplayerheading'] = '(P) : {$a}';
$string['templatepagewidgetheading'] = '(W) : {$a}';
$string['templaterequire_amd'] = 'Charger via AMD';
$string['templaterequire_amd_desc'] = 'AMD est un mécanisme de chargement javascript. Si vous téléchargez ou créez un lien vers des bibliothèques javascript dans votre modèle, vous devrez peut-être désélectionner cette option. Cela ne s\'applique que sur Moodle 2.9 ou supérieur';
$string['templaterequire_css'] = 'Nécessite CSS (modèle {$a})';
$string['templaterequire_css_desc'] = 'Lien (1 seul uniquement) vers un fichier CSS externe requis par ce modèle. Optionnel.';
$string['templaterequire_jquery'] = 'Nécessite JQuery (modèle {$a})';
$string['templaterequire_jquery_desc'] = 'Il vaut mieux NE PAS cocher cette option. De nombreux modèles non AMD nécessitent JQuery. Cocher cette option chargera JQuery, mais pas complètement. Votre thème peut déjà charger JQuery de toute façon. Sinon, ajoutez cette chaîne dans Administration du site -> Apparence -> HTML supplémentaire (dans HEAD): <br/> &lt;script src ="https://code.jquery.com/jquery-1.11.2.min.js"&gt;&lt;/script &gt;';
$string['templaterequire_js'] = 'Nécessite JS (modèle {$a})';
$string['templaterequire_js_desc'] = 'Lien (1 seul uniquement) vers un fichier JS externe requis par ce modèle. Optionnel.';
$string['templaterequire_js_shim'] = 'Export Shim (modèle {$a})';
$string['templaterequire_js_shim_desc'] = 'Entrez la valeur des exports shim UNIQUEMENT si vous avez besoin de shim.';
$string['templates'] = 'Modèles';
$string['templatescript'] = 'JS personnalisé (modèle {$a})';
$string['templatescript_desc'] = 'Si votre modèle doit exécuter du javascript personnalisé, entrez-le ici. Il sera exécuté une fois que tous les éléments auront été chargés sur la page.';
$string['templatestyle'] = 'CSS personnalisé (modèle {$a})';
$string['templatestyle_desc'] = 'Entrez le code CSS personnalisé que votre modèle utilise ici. Les variables de modèle ne fonctionneront pas ici. Seul le code CSS classique sera accepté.';
$string['templateupdated'] = '{$a} modèles Poodll mis à jour.';
$string['templateversion'] = 'La version de ce modèle {$a}';
$string['templateversion_desc'] = 'Utilisez le contrôle de version sémantique, par exemple 1.0.0. Poodll affichera un bouton de mise à jour lorsque la version prédéfinie est supérieure à la version du modèle.';
$string['thirty_days'] = '30 jours';
$string['threehundredsixtyfive_days'] = '365 jours';
$string['tiny'] = 'Tout petit';
$string['transcode_heading'] = 'Paramètres de conversion audio/vidéo (FFMPEG)';
$string['transcode_heading_desc'] = 'Les paramètres de cette section concernent FFMPEG et Red5 et ne s\'appliquent pas lors de l\'utilisation de conversions à distance';
$string['type'] = 'Type';
$string['unregistered'] = 'PoodLL ne s\'affiche pas car il n\'a pas été enregistré. Demandez à votre administrateur d\'enregistrer PoodLL sur Poodll.com';
$string['updateall'] = 'Tout mettre à jour.';
$string['updatetoversion'] = 'Mise à jour vers {$a}';
$string['upload_recorder'] = 'Déposer';
$string['usecloudnotifications'] = 'Notifications de conversion à distance';
$string['usecloudnotifications_desc'] = 'Si vrai, Poodll enverra un message à votre serveur indiquant que la conversion du fichier à distance est terminée afin qu\'il puisse le récupérer dès que possible.';
$string['usecloudrecording'] = 'Conversion à distance';
$string['usecloudrecording_desc'] = 'Conversion à distance. Cela permet le transcodage et d\'autres services dans le cloud. Les fichiers soumis sont renvoyés à Moodle et ne sont pas hébergés dans le cloud.';
$string['useplayer'] = 'Lecteur {$a}';
$string['useplayerdesc'] = 'Le lecteur sélectionné utilisera les informations du modèle approprié.';
$string['value'] = 'valeur';
$string['video'] = 'Vidéo';
$string['videotranscode'] = 'Conversion automatique en MP4';
$string['videotranscodedetails'] = 'Convertir automatiquement au format MP4 les fichiers vidéo enregistrés ou déposés avant de les stocker dans Moodle. Fonctionne seulement lorsque vous utilisez le serveur tokyo.poodll.com, ou les enregistrements téléversés si vous utilisez FFMPEG.';
$string['wboardautosave'] = 'Enregistrement automatique (millisecondes)';
$string['wboardautosave_details'] = 'Enregistrer le dessin lorsque l\'utilisateur arrête de dessiner pendant au moins X millisecondes. 0 = pas d\'enregistrement automatique';
$string['wboardheight'] = 'Hauteur par défaut du tableau blanc';
$string['wboardnozoom'] = 'Désactiver le zoom';
$string['wboardnozoom_details'] = 'S\'applique uniquement à LiterallyCanvas. Si cette case est cochée, les zooms maximum et minimum sont 1.0, désactivant ainsi la fonction de zoom.';
$string['wboardwidth'] = 'Largeur par défaut du tableau blanc';
$string['whiteboardsave'] = 'Enregistrer l\'image';
$string['widgetsettings'] = 'Paramètres du widget';
$string['widgettype'] = 'widget';
