<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_moodlebox', language 'de', version '3.5'.
 *
 * @package     tool_moodlebox
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['changepassworderror'] = 'Die Kennwörter für das Systemkonto (Unix) und die Datenbank wurden nicht geändert, weil die eingegebenen Kennwörter nicht übereinstimmen.';
$string['changepasswordmessage'] = 'Das MoodleBox-Kennwort für das Systemkonto (Unix) wurde geändert.<br /><br />Achtung! Das Kennwort für das Moodle-Nutzerkonto \'admin\' <b>wurde nicht verändert</b>. Öffnen Sie dafür die Einstellungen für das Moodle-Nutzerkonto \'admin\'.';
$string['changepasswordsetting'] = 'MoodleBox-Kennwort ändern';
$string['changewifipassword'] = 'WLAN-Kennwort ändern';
$string['changewifisettings'] = 'WLAN-Einstellungen ändern';
$string['cpufrequency'] = 'CPU-Frequenz';
$string['cpuload'] = 'CPU-Auslastung';
$string['cputemperature'] = 'CPU-Temperatur';
$string['currentwifipassword'] = 'WLAN-Kennwort';
$string['datetime'] = 'Datum und Uhrzeit';
$string['datetime_help'] = 'Ohne Verbindung mit dem Internet hat die MoodleBox möglicherweise eine falsche Systemzeit. Hier können Sie die Systemzeit manuell korrigieren.';
$string['datetimemessage'] = 'Die Systemzeit der MoodleBox wurde neu eingestellt. Um die Systemzeit möglichst genau zu halten, sollten Sie die MoodleBox über ein Ethernetkabel mit dem Internet verbinden.';
$string['datetimeset'] = 'Systemzeit einstellen';
$string['datetimesetmessage'] = 'Die Systemzeit der MoodleBox scheint nicht richtig zu sein. Sie sollten unbedingt das aktuelle Datum und die richtige Uhrzeit einstellen.';
$string['datetimesetting'] = 'Systemzeit';
$string['dhcpclientinfo'] = 'IP-Adresse und Name';
$string['dhcpclientnumber'] = 'Anzahl';
$string['dhcpclients'] = 'DHCP-Clients';
$string['hidden'] = 'Verborgen';
$string['information'] = 'Information';
$string['kernelversion'] = 'Kernel-Version';
$string['missingconfigurationerror'] = 'Dieser Bereich ist nicht verfügbar. Die Installation des Plugins ist unvollständig, so dass die Einstellungen der MoodleBox nicht verarbeitet werden können. Lesen Sie die <a href="https://github.com/moodlebox/moodle-tool_moodlebox/blob/master/README.md"" target="_blank">Installationshinweise</a> zum Plugin.';
$string['moodleboxinfo'] = 'MoodleBox-Version';
$string['moodleboxinfofileerror'] = 'Information nicht verfügbar';
$string['moodleboxpluginversion'] = 'MoodleBox-Plugin-Version';
$string['newwifipassword'] = 'Neues WLAN-Kennwort';
$string['nopassworddefined'] = 'Kein WLAN-Kennwort festgelegt';
$string['parameter'] = 'Parameter';
$string['passwordprotected'] = 'Mit Kennwort geschützt';
$string['passwordsetting'] = 'MoodleBox-Kennwort';
$string['passwordsetting_help'] = 'Das Hauptkennwort der MoodleBox kann hier geändert werden. Es wird dringend davon abgeraten, das Standardkennwort zu behalten. Als minimale Sicherheitsmaßnahme müssen Sie das Kennwort unbedingt ändern.';
$string['pluginname'] = 'MoodleBox';
$string['privacy:metadata'] = 'Das Moodlebox-Plugin zeigt Infos zum Raspberry Pi und ermöglicht Änderungen in der Konfiguration. Das Plugin verarbeitet und speichert keine personenbezogenen Daten.';
$string['raspberryhardware'] = 'Hardware';
$string['raspbianversion'] = 'Betriebssystem';
$string['resizepartition'] = 'Partition auf der SD-Karte vergrößern';
$string['resizepartition_help'] = 'Verwenden Sie diese Taste, um die Partition auf der SD-Karte zu vergrößern.';
$string['resizepartitionmessage'] = 'Die Partitionsgröße der SD-Karte wurde auf den maximalen Speicherplatz erweitert. Die MoodleBox startet neu. Das System ist nach einer kurzen Unterbrechung wieder online.';
$string['resizepartitionsetting'] = 'Partition auf der SD-Karte wird vergrößert';
$string['restart'] = ' MoodleBox neustarten ';
$string['restartmessage'] = 'Die MoodleBox startet neu und ist nach kurzer Unterbrechung wieder online.';
$string['restartstop'] = 'Neustarten und Ausschalten';
$string['restartstop_help'] = 'Verwenden Sie diese Tasten zum Neustarten oder Ausschalten der MoodleBox. Es wird empfohlen, die MoodleBox softwaremäßig herunterzufahren und erst dann die Stromversorgung zu trennen.';
$string['rpi1'] = 'Raspberry Pi 1';
$string['rpi2'] = 'Raspberry Pi 2B';
$string['rpi3'] = 'Raspberry Pi 3B';
$string['rpi3bplus'] = 'Raspberry Pi 3B+';
$string['rpizerow'] = 'Raspberry Pi Zero W';
$string['sdcardavailablespace'] = 'Freier Speicher';
$string['shutdown'] = 'MoodleBox ausschalten';
$string['shutdownmessage'] = 'Die MoodleBox wird ausgeschaltet. Warten Sie bitte einige Sekunden, bevor Sie die Stromversorgung trennen.';
$string['systeminfo'] = 'Informationen';
$string['systeminfo_help'] = 'Die MoodleBox-Informationen zeigen wichtige Daten:

* Kritische Details, z.B. verbleibender Speicherplatz auf der SD-Karte sowie CPU-Auslastung, -Temperatur und -Frequenz
* Aktuelle WLAN-Einstellungen der MoodleBox
* Anzahl, IP-Adresse und Name aller auf der MoodleBox registrierten Geräte
* Hardware und Betriebssystem
* MoodleBox-Version und MoodleBox-Plugin-Version';
$string['unknownmodel'] = 'Unbekannte Hardware';
$string['unsupportedhardware'] = 'Die Hardware wird scheinbar nicht unterstützt! Dieses Plugin arbeitet nur mit einem Raspberry Pi.';
$string['uptime'] = 'Betriebsdauer';
$string['visible'] = 'Sichtbar';
$string['wifichannel'] = 'WLAN-Kanal';
$string['wifichannel_help'] = 'Normalerweise kann der WLAN-Kanal unverändert bleiben, außer wenn mehrere WLAN-Sender sich überlagern und gegenseitig stören.';
$string['wificountry'] = 'WLAN-Regulierungsland';
$string['wificountry_help'] = 'Aus rechtlichen Gründen sollten Sie hier den tatsächlichen Aufenthaltsort als WLAN-Regulierungsland eintragen.';
$string['wifipassword'] = 'WLAN-Kennwort';
$string['wifipassword_help'] = 'Wenn Sie das WLAN der MoodleBox mit einem Kennwort schützen, sollten Sie das Kennwort ändern. Nur so verhindern Sie, dass unberechtigte Personen in das WLAN eindringen. Das WLAN-Kennwort muss zwischen 8 und 63 Zeichen lang sein.';
$string['wifipassworderror'] = 'Das WLAN-Kennwort muss zwischen 8 und 63 Zeichen lang sein.';
$string['wifipasswordmessage'] = 'Das WLAN-Kennwort wurde geändert. Denken Sie daran, allen beteiligten Personen die neuen Zugangsdaten mitzuteilen.';
$string['wifipasswordon'] = 'WLAN-Schutz';
$string['wifipasswordon_help'] = 'Wenn diese Option aktiviert ist, muss ein WLAN-Kennwort eingegeben werden.';
$string['wifipasswordonhelp'] = 'Wenn diese Option aktiviert ist, muss ein WLAN-Kennwort eingegeben werden.';
$string['wifipasswordsetting'] = 'WLAN-Kennwort ändern';
$string['wifisettings'] = 'WLAN-Einstellungen';
$string['wifisettingsmessage'] = 'Die WLAN-Einstellungen wurden geändert. Denken Sie daran, allen beteiligten Personen die neuen Zugangsdaten mitzuteilen.';
$string['wifissid'] = 'WLAN-Name (SSID)';
$string['wifissid_help'] = 'Der WLAN-Name (SSID) für die MoodleBox kann zwischen 1 und 32 Bytes lang sein. Beachten Sie, dass manche Zeichen (z.B. Emoticons) mehr als nur 1 Byte verwenden.';
$string['wifissidhidden'] = 'Verborgenes WLAN';
$string['wifissidhiddenstate'] = 'WLAN-Sichtbarkeit';
$string['wifissidhiddenstate_help'] = 'Wenn diese Option aktiviert ist, wird der WLAN-Name (SSID) verborgen. Niemand kann dann sehen, ob eine MoodleBox vorhanden ist. Dies erhöht einerseits die Sicherheit der MoodleBox, reduziert aber andererseits deren Usability.';
