<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_adaptable', language 'es_mx', version '3.5'.
 *
 * @package     theme_adaptable
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actingasrole'] = 'Actualmente Usted está actuando como un rol diferente';
$string['activebreadcrumb'] = 'Color de fondo de la ruta de navegación activa';
$string['activebreadcrumbdesc'] = 'Establece el color de fondo de la ruta de navegación activa.';
$string['alertaccess'] = 'Visibilidad de la Alerta';
$string['alertaccessadmins'] = 'Visible para administradores';
$string['alertaccessdesc'] = 'Establece la visibilidad de la Alerta según su tipo. Nota: Si se usa "Añadir restricción por campo personalizado" necesitarás añadir el campo personalizado del usuario.';
$string['alertaccessglobal'] = 'Visible para todos';
$string['alertaccessprofile'] = 'Añadir restricción por campo personalizado del perfil';
$string['alertaccessusers'] = 'Visible para usuarios ingresados';
$string['alertannounce'] = 'Anuncio';
$string['alertannouncedesc'] = 'Mostrar un Anuncio en la Caja de Alertas.';
$string['alertbackgroundcolorinfo'] = 'Color del Fondo de Información';
$string['alertbackgroundcolorinfodesc'] = 'Color del Fondo de las cajas de alerta de tipo de Información';
$string['alertbackgroundcolorsuccess'] = 'Color del Fondo de Anuncio';
$string['alertbackgroundcolorsuccessdesc'] = 'Color del Fondo de las cajas de alerta de tipo de Anuncio';
$string['alertbackgroundcolorwarning'] = 'Color del Fondo de Advertencia';
$string['alertbackgroundcolorwarningdesc'] = 'Color del Fondo de las cajas de alerta de tipo de Advertencia';
$string['alertbordercolorinfo'] = 'Color del Borde de Información';
$string['alertbordercolorinfodesc'] = 'Color del Borde de las cajas de alerta de tipo Información';
$string['alertbordercolorsuccess'] = 'Color del Borde de Anuncio';
$string['alertbordercolorsuccessdesc'] = 'Color del Borde de las cajas de alerta de tipo Anuncio';
$string['alertbordercolorwarning'] = 'Color del Borde de Advertencia';
$string['alertbordercolorwarningdesc'] = 'Color del Borde de las cajas de alerta de tipo Advertencia';
$string['alertcolorinfo'] = 'Color de Información';
$string['alertcolorinfodesc'] = 'Color del Ícono de las cajas de alerta de tipo Información';
$string['alertcolorsheading'] = 'Personalizar Cajas de Alerta superior';
$string['alertcolorsheadingdesc'] = 'Configurar colores e ícono.';
$string['alertcolorsuccess'] = 'Color de Anuncio';
$string['alertcolorsuccessdesc'] = 'Color del ícono de las cajas de alerta de tipo Anuncio';
$string['alertcolorwarning'] = 'Color de Advertencia';
$string['alertcolorwarningdesc'] = 'Color del ícono de las cajas de alerta de tipo Advertencia';
$string['alertcount'] = 'Número de Alertas';
$string['alertcountdesc'] = 'Número de alertas a crear a continuación.';
$string['alertdesc'] = 'Introduce y personaliza un texto para ser mostrado en la parte superior del sitio como alerta. Es posible crear más de una para mostrarse a diferentes tipos de usuarios. También existe la opción de mostrar las alertas en todo el sitio o solamente en las páginas iniciales.<br /><br /><strong>Nota:</strong>Ahora también es posible mostrar alertas dentro de páginas del curso para advertirle a profesores que los cursos están ocultos.';
$string['alertdisabled'] = 'Deshabilitada';
$string['alertdisabledesc'] = 'Deshabilitar esta alerta.';
$string['alerthiddencourse'] = 'Advertencia de curso oculta';
$string['alerthiddencoursedesc'] = 'Mostrar alerta en página de curso si está oculta';
$string['alerthiddencoursetext-1'] = 'El curso está oculto y no puede ser accesado por estudiantes.';
$string['alerthiddencoursetext-2'] = 'Hacer clic aquí para actualizar configuraciones';
$string['alerticoninfo'] = 'Ícono de Información';
$string['alerticoninfodesc'] = 'Configure el <a href="http://fortawesome.github.io/Font-Awesome/icons/">Ícono de Font Awesome</a> a ser usado en las cajas de alerta de tipo Información. Ingrese el nombre del ícono sin el prefijo  fa-.';
$string['alerticonsuccess'] = 'Ícono de Anuncio';
$string['alerticonsuccessdesc'] = 'Configure el <a href="http://fortawesome.github.io/Font-Awesome/icons/">Ícono de Font Awesome</a>a ser usado en las cajas de alerta de tipo Anuncio. Ingrese el nombre del ícono sin el prefijo  fa-.';
$string['alerticonwarning'] = 'Ícono de Advertencia';
$string['alerticonwarningdesc'] = 'Configure el  <a href="http://fortawesome.github.io/Font-Awesome/icons/">Ícono de Font Awesome</a> a ser usado en las cajas de alerta de tipo Advertencia. Ingrese el nombre del ícono sin el prefijo  fa-.';
$string['alertinfo'] = 'Información';
$string['alertinfodesc'] = 'Muestra información en la Caja de Alerta.';
$string['alertkeyvalue'] = 'Clave de Alerta';
$string['alertkeyvalue_details'] = 'Esta clave identifica la alerta y permite el control de la eliminación de la alerta en la pantalla por parte del usuario. Si se cambia la clave, los usuarios volverán a ver la alerta de nuevo.';
$string['alertprofilefield'] = 'Campo personalizado  del usuario Nombre=Valor (opcional)';
$string['alertprofilefielddesc'] = 'Añade una regla de acceso usando un campo personalizado del perfil . Ejemplo: "usertype=student"';
$string['alertsettings'] = 'Caja de Alerta {$a}';
$string['alertsettingscourse'] = 'Configuraciones de Alerta de Curso';
$string['alertsettingsgeneral'] = 'Configuración Alertas';
$string['alertsettingsheading'] = 'Personalizar la caja de Alerta superior. Vea el diseño <a href="./../theme/adaptable/pix/layout.png" target="_blank"> aquí</a>';
$string['alerttext'] = 'Texto de la Alerta';
$string['alerttextdesc'] = 'Introduce el texto a mostrar en la alerta.';
$string['alerttype'] = 'Tipo de Alerta';
$string['alerttypedesc'] = 'Selecciona el tipo de alerta: info (azul), aviso (amarillo) o anuncio (verde)';
$string['alertwarning'] = 'Advertencia';
$string['alertwarningdesc'] = 'Mostrar una advertencia en la Caja de Alerta.';
$string['analyticscount'] = 'Conteo de análisis';
$string['analyticscountdesc'] = 'Número de campos personalizados a introducir en el área inferior.';
$string['analyticsprofilefield'] = 'Nombre del campo personalizado del perfíl Field Name=Value (opcional)';
$string['analyticsprofilefielddesc'] = 'Añade una regla de acceso usando un campo personalizado del perfil . Ejemplo: "usertype=student"';
$string['analyticssettings'] = 'Analítica Web';
$string['analyticssettingsdesc'] = 'Usted puede configurar múltiples códigos para Google Analytics y enlazarlos con diversos campos personalizados del perfil . O Usted puede usar Matomo, el analizador de código abierto.';
$string['analyticssettingsheading'] = 'Configurar Google Analytics (Análisis de Google), Matomo, o ambos';
$string['analyticstext'] = 'ID de Google Analytics';
$string['analyticstextdesc'] = 'Introducir el código de Google Analytics.';
$string['anonymizega'] = 'Anonimizar la IP del usuario';
$string['anonymizegadesc'] = 'Anonimizar la IP del usuario enviada a a Google Analytics';
$string['answered'] = 'Contestado';
$string['attempted'] = 'Intentado';
$string['backcolor'] = 'Color de fondo';
$string['backcolordesc'] = 'Establece el color de fondo de la plantilla.';
$string['bcustyle'] = 'Estilo BCU';
$string['beta'] = 'VERSIÓN EN DESARROLLO. NO USARLA EN SITIOS EN PRODUCCIÓN';
$string['blockbackgroundcolor'] = 'Color de fondo de los bloques';
$string['blockbackgroundcolordesc'] = 'Establece el color de fondo de los bloques.';
$string['blockbordercolor'] = 'Color del borde de los bloques';
$string['blockbordercolordesc'] = 'Establece el color del borde de los bloques.';
$string['blockheaderbackgroundcolor'] = 'Color del texto de los encabezados de los bloques';
$string['blockheaderbackgroundcolordesc'] = 'Establece el color del texto de los encabezados de los bloques.';
$string['blockheaderborderbottom'] = 'Grueso del borde inferior de los bloques';
$string['blockheaderborderbottomdesc'] = 'Establece el grosor del borde inferior de los bloques.';
$string['blockheaderborderleft'] = 'Grueso del borde izquierdo de los bloques';
$string['blockheaderborderleftdesc'] = 'Establece el grosor del borde izquierdo de los bloques.';
$string['blockheaderborderright'] = 'Grueso del borde derecho de los bloques';
$string['blockheaderborderrightdesc'] = 'Establece el grosor del borde derecho de los bloques.';
$string['blockheaderbordertop'] = 'Grueso del borde superior de los bloques';
$string['blockheaderbordertopdesc'] = 'Establece el grosor del borde superior de los bloques.';
$string['blockheaderbordertopstyle'] = 'Estilo del borde de los bloques';
$string['blockheaderbordertopstyledesc'] = 'Establece el estilo del borde de los bloques laterales.';
$string['blockheaderbottomradius'] = 'Radio de las esquinas inferiores de los bloques laterales';
$string['blockheaderbottomradiusdesc'] = 'Radio de las esquinas inferiores de los bloques laterales. Valor más alto es igual a efecto redondeado.';
$string['blockheadercolor'] = 'Color de fondo de la cabecera de los bloques';
$string['blockheadercolordesc'] = 'Establece el color de fondo de la cabecera de los bloques.';
$string['blockheadertopradius'] = 'Radio de las esquinas superiores de los bloques laterales';
$string['blockheadertopradiusdesc'] = 'Radio de las esquinas superiores de los bloques laterales. Valor más alto es igual a efecto redondeado.';
$string['blockicons'] = 'Mostrar iconos en los bloques';
$string['blockiconsdesc'] = 'Mostrar / Ocultar un icono relacionado con el tipo de bloque al lado del encabezamiento.';
$string['blockiconsheadersize'] = 'Tamaño del ícono del encabezado de bloques';
$string['blockiconsheadersizedesc'] = 'Configurar el tamaño del ícono del font usado en el encabezado de los bloques de Moodle. Seleccionar un valor de la lista.';
$string['blocklayoutbuilder'] = 'Regiones de Bloques de la Portada';
$string['blocklayoutbuilderdesc'] = 'Debajo puede Usted construir su propio diseño para las regiones de bloques en la página de la Portada.
Para añadir contenido a estas regiones, Usted necesitará  <strong> activar la edición en la Portada de su sitio Moodle</strong>.
¡Después Usted podrá arrastrar /soltar bloques dentro de las regiones que Usted cree!';
$string['blocklayoutlayoutcheck'] = 'Revise su diseño';
$string['blocklayoutlayoutcheckdesc'] = 'Use la herramienta inferior para revisar el númeo de bloques que Usted haya usado y ver una representación de su nuevo diseño.';
$string['blocklayoutlayoutcount1'] = 'Usted puede configurar un máximo de';
$string['blocklayoutlayoutcount2'] = 'Regiones de bloque. Actualmente Usted está usando:';
$string['blocklayoutlayoutrow'] = 'Hilera de Región de Bloque';
$string['blocklayoutlayoutrowdesc'] = 'Añadir/configurar diseño para hilera de región de bloque en la Portada.';
$string['blockmainborderbottom'] = 'Grueso del borde inferior del bloque central';
$string['blockmainborderbottomdesc'] = 'Establece el grosor del borde inferior del bloque central.';
$string['blockmainborderleft'] = 'Grueso del borde izquierdo del bloque central';
$string['blockmainborderleftdesc'] = 'Establece el grosor del borde izquierdo del bloque central.';
$string['blockmainborderright'] = 'Grueso del borde derecho del bloque central';
$string['blockmainborderrightdesc'] = 'Establece el grosor del borde derecho del bloque central.';
$string['blockmainbordertop'] = 'Grueso del borde superior del bloque central';
$string['blockmainbordertopdesc'] = 'Establece el grosor del borde superior del bloque central.';
$string['blockmainbordertopstyle'] = 'Estilo del borde del Bloque Principal';
$string['blockmainbordertopstyledesc'] = 'Establece el estilo del borde del área de contenido de bloques';
$string['blockmainbottomradius'] = 'Radio de las esquinas inferiores de los bloques centrales';
$string['blockmainbottomradiusdesc'] = 'Radio de las esquinas inferiores de los bloques centrales. Valor más alto es igual a efecto redondeado.';
$string['blockmaintopradius'] = 'Radio de las esquinas superiores de los bloques centrales';
$string['blockmaintopradiusdesc'] = 'Radio de las esquinas superiores de los bloques centrales. Valor más alto es igual a efecto redondeado.';
$string['blockregionbackground'] = 'Color del Fondo de Región de Bloque';
$string['blockregionbackgrounddesc'] = 'Color del fondo del contenedor que tiene los diseños personalizados de bloque en la Portada';
$string['blocksettings'] = 'Configuraciones de Bloques';
$string['blockside'] = 'Posición de los bloques';
$string['blocksidedesc'] = 'Mostrar los bloques en la columna derecha o izquierda.';
$string['breadcrumb'] = 'Color de fondo de la ruta de navegación';
$string['breadcrumbdesc'] = 'Establece el color de fondo de la ruta de navegación.';
$string['breadcrumbhome'] = 'Hogar de ruta de navegación';
$string['breadcrumbhomedesc'] = 'Mostrar hogar de ruta de navegación como un ícono o como un texto.';
$string['breadcrumbhomeicon'] = 'Ícono';
$string['breadcrumbhometext'] = 'Texto';
$string['breadcrumbseparator'] = 'Separador de ruta de navegación';
$string['breadcrumbseparatordesc'] = 'Configurar el <a href="https://fortawesome.github.io/Font-Awesome/icons/" target="_blank">Ícono de Font Awesome</a> para usarlo como separador de ítems en la ruta de navegación. Escriba el nombre del ícono sin el prefijo fa- .';
$string['breadcrumbtextcolor'] = 'Color del texto de la ruta de navegación';
$string['breadcrumbtextcolordesc'] = 'Establece el color del texto de la ruta de navegación.';
$string['breadcrumbtitle'] = 'Nombre del curso en la ruta de navegación';
$string['breadcrumbtitledesc'] = 'Establece el modo de visualización del título del curso en la ruta de navegación (breadcumb).';
$string['breadcrumbtitlefullname'] = 'Nombre Completo del Curso';
$string['breadcrumbtitleshortname'] = 'Nombre corto / Código del Curso';
$string['buttoncancelbackgroundcolor'] = 'Color del fondo para Botón de Cancelar';
$string['buttoncancelbackgroundcolordesc'] = 'Color del fondo para Botón de Cancelar.  Escribir <i>transparent</i>en la caja para transparencia.';
$string['buttoncancelcolor'] = 'Color del botón Cancelar';
$string['buttoncancelcolordesc'] = 'Elegir el Color para el botón Cancelar';
$string['buttoncolor'] = 'Colores de los botones';
$string['buttoncolordesc'] = 'El color de los botones principales.';
$string['buttondesc'] = 'Personaliza la forma y colores de los botones utilizados en la plantilla.';
$string['buttondropshadow'] = 'Decoración de Sombreado en el fondo del botón';
$string['buttondropshadowdesc'] = 'Mostrar una decoración de Sombreado en el fondo del botón.';
$string['buttonhovercolor'] = 'Color de botón (al pasarle ratón encima)';
$string['buttonhovercolordesc'] = 'Color al que cambia el botón al pasarle el cursor por encima.';
$string['buttonlogincolor'] = 'Color del botón para Ingresar';
$string['buttonlogincolordesc'] = 'El color del botón para Ingresar';
$string['buttonloginheight'] = 'Altura del botón para Ingresar';
$string['buttonloginheightdesc'] = 'Altura del botón para Ingresar. Solo si se utiliza el formato para ingresar entrada en la cabecera.';
$string['buttonloginhovercolor'] = 'Color al pasarle el cursor encima al botón para Ingresar';
$string['buttonloginhovercolordesc'] = 'Color del botón para Ingresar al pasarle el cursor encima';
$string['buttonloginmargintop'] = 'Margen superior del botón Entrar';
$string['buttonloginmargintopdesc'] = 'Permite posicionar el boton Entrar si se han cambiado los valores indicados anteriormente.';
$string['buttonloginpadding'] = 'Separación del texto del botón para Ingresar';
$string['buttonloginpaddingdesc'] = 'Separación alrededor del texto del botón para Ingresar. Número más alto = Botón más grande.';
$string['buttonlogintextcolor'] = 'Color del texto del botón para Ingresar';
$string['buttonlogintextcolordesc'] = 'Color del texto del botón para Ingresar.';
$string['buttonradius'] = 'Radio de las esquinas';
$string['buttonradiusdesc'] = '0 = esquinas cuadradas. Un valor más alto es igual a esquinas más redondeadas.';
$string['buttonsettings'] = 'Botones';
$string['buttonsettingsheading'] = 'Personalizar los botones.';
$string['buttontextcolor'] = 'Color del texto de los botones';
$string['buttontextcolordesc'] = 'Color del texto de los botones.';
$string['cachedef_userdata'] = 'Un caché de sesión usado para guardar datos específicos dl usuario.';
$string['choosereadme'] = '<div class="clearfix">
<div class="well">
 <h2>Adaptable</h2>
 <p><img class="img-polaroid" src="adaptable/pix/screenshot.png" /></p>
</div>
<div class="well">
 <h2>Créditos</h2>
 <h3>Acerca de...</h3>
 <p>Adaptable es un tema para Moodle, de dos columnas y tipo responsivo, altamente personalizable y basada en el popular tema BCU.</p>
 <p>Este tema está bajo licencia GPL (GNU General Public License). Puedes encontrar la licencia completa en: <a href="http://www.gnu.org/licenses/">http://www.gnu.org/licenses</a></p>
 <p>Modifícalo / Mejóralo / Compártelo</p>
 <br>
 <p>Este tema ha sido creada por:<br>
 Jeremy Hopkins (Coventry University)<br>
 Fernando Acedo (3-bits.com</a>)</p>
<br>
<p>y muchos otros desarrolladores, probadores, traductores y voluntarios (Vea <a href="adaptable/README.txt" target="_blank">README.txt</a>)</p>
<br>
 <h3>Informar de errores</h3>
 <p>Puedes informar de errores encontrados en este tema a través del foro de moodle o en https://bitbucket.org/covuni/moodle-theme_adaptable/issues</p>
 <br>
 <h3>Soporte tècnico</h3>
<p>Usted puede hacer preguntas, discutir sus dudas y compartir sus sugerencias en el foro Moodle:</p>
<ul>
<li>English: <a href="https://moodle.org/mod/forum/discuss.php?d=340404" target="_blank">https://moodle.org/mod/forum/discuss.php?d=340404</a>
<li>Español: <a href="https://moodle.org/mod/forum/discuss.php?d=326804" target="_blank">https://moodle.org/mod/forum/discuss.php?d=326804</a>
<li>Català: <a href="https://moodle.org/mod/forum/discuss.php?d=340406" target="_blank">https://moodle.org/mod/forum/discuss.php?d=340406</a>
</ul>
<br>
<h3>Documentación</h3>
<p>Pronto vendrà...</p>
 <br>
 <h3>Demo</h3>
 <p>Puedes ver una demostración del sitio y descargar un archivo de instalación <a href="https://3-bits.com/demo/adaptable" target="_blank">AQUÌ</a></p>
 <br>
<p>Traducción es_mx: Germán Valero (UNAM)</p>
</div>
</div>';
$string['colordesc'] = 'Puedes seleccionar los colores que desees para ser usados por la plantilla. Usa la notacion HEXADECIMAL estándar. También puedes usar como valores <i>transparent</i> e <i>inherited.</i>';
$string['colorsettings'] = 'Colores';
$string['colorsettingsheading'] = 'Modifica los principales colores utilizados en la plantilla.';
$string['configtitle'] = 'Adaptable';
$string['contributed'] = 'Contribuído';
$string['course'] = 'Curso';
$string['coursepageactivitybottomblockregionheading'] = 'Región del bloque del fondo de actividad de curso personalizada';
$string['coursepageactivitybottomblockregionheadingdesc'] = 'Una región de bloque personalizada que aparece después del final de las actividades.';
$string['coursepageblockactivitybottomenabled'] = 'Habilitar región del bloque del fondo de actividad del curso en página del curso';
$string['coursepageblockactivitybottomenableddesc'] = 'Habilitar esta región en todas las páginas de curso.';
$string['coursepageblocklayoutbuilder'] = 'Regiones de Bloque de Página de Curso';
$string['coursepageblocklayoutbuilderdesc'] = 'Debajo, Usted puede construir su propio diseño para regiones de bloque en la página de curso.
Para añadir contenido a estas regiones, Usted necesitará <strong> activar la edición, en la página del curso de  Moodle</strong>.
¡ Entonces podrá Usted comenzar a arrastrar / soltar bloques en las regiones que cree !';
$string['coursepageblocklayoutlayoutbottomrow'] = 'Fila de Región Inferior de Bloque de página de curso';
$string['coursepageblocklayoutlayoutbottomrowdesc'] = 'Añadir / configurar diseño para fila de región de bloque en Página de Curso.';
$string['coursepageblocklayoutlayouttoprow'] = 'Fila de región Superior de Bloque de página de Curso';
$string['coursepageblocklayoutlayouttoprowdesc'] = 'Añadir / configurar diseño para fila de región de bloque en Página de Curso.';
$string['coursepageblockregionsettings'] = 'Constructor de Región de Bloque de página de Curso';
$string['coursepageblocksenabled'] = 'Habilitar regiones de bloque personalizadas en página de Curso';
$string['coursepageblocksenableddesc'] = 'Usted puede habilitar / deshabilitar regiones de bloques personalizadas  (superior e inferior) en la página del Curso.
Usted puede entonces arrastrar y soltar bloques a las regiones que Usted creó';
$string['coursepageblocksliderenabled'] = 'Habilitar región de bloque deslizador personalizado en Página de curso';
$string['coursepageblocksliderenableddesc'] = 'Habilitar esta región en todas las páginas de curso.';
$string['coursepageheaderhidesitetitle'] = 'Ocultar título del sitio en páginas de curso';
$string['coursepageheaderhidesitetitledesc'] = 'Ocultar título del sitio, logo y barra de búsqueda en páginas de curso. Use esto junto con la configuración de la altura del encabezado de la página para mostrar un encabezado más pequeño en páginas relacionadas con el curso.';
$string['coursepagenewssliderblockregionheading'] = 'Región del bloque deslizador de noticias personalizado';
$string['coursepagenewssliderblockregionheadingdesc'] = 'Una región de bloque personalizada para usar con el nuevo deslizador de novedades que es parte de la Interfaz del Usuario de Adaptable. Esta región aparece arriba de las actividades del curso en una Página de curso. Para añadir nuevos bloques de deslizador de novedades, primeramente instale el  <strong><a href="https://moodle.org/plugins/block_news_slider">Adaptable UI news slider</a></strong> y configúrelo para que aparezca en la región de "región de deslizador de página de curso" en todas las páginas de curso.';
$string['coursepagesidebarinfooterenabled'] = 'Mover barra lateral al pie de página en Página de curso';
$string['coursepagesidebarinfooterenableddesc'] = 'Diseño de página ancha de curso al mover barra lateral al pie de página.';
$string['coursepagesidebarinfooterenabledsection'] = 'Configuraciones comunes';
$string['coursepagesidebarinfooterenabledsectiondesc'] = 'Configuraciones comunes para la mayoría de los formatos de curso.';
$string['coursesectionactivityassignbgcolor'] = 'Color del fondo de actividad tarea';
$string['coursesectionactivityassignbgcolordesc'] = 'Configurar el color del fondo de actividad tarea.';
$string['coursesectionactivityassignleftbordercolor'] = 'Color para mostrar borde izquierdo de actividad Tarea';
$string['coursesectionactivityassignleftbordercolordesc'] = 'Configurar el color del borde izquierdo.';
$string['coursesectionactivitybordercolor'] = 'Color del Borde del Botón de Actividad en Sección de Curso';
$string['coursesectionactivitybordercolordesc'] = 'Configurar el color del borde del botón de actividad se seción de curso.';
$string['coursesectionactivityborderstyle'] = 'Estilo del Borde de Botón de Actividad de Sección de Curso';
$string['coursesectionactivityborderstyledesc'] = 'Configurar el estilo del borde del botón de actividad en sección de curso.';
$string['coursesectionactivityborderwidth'] = 'Ancho del Borde de Botón de Actividad en Sección de Curso';
$string['coursesectionactivityborderwidthdesc'] = 'Configurar el ancho del borde que aparece al fondo de una actividad de sección de curso';
$string['coursesectionactivitycolors'] = 'Opciones de Actividad en Sección de Curso';
$string['coursesectionactivityforumbgcolor'] = 'Color del fondo de actividad Foro';
$string['coursesectionactivityforumbgcolordesc'] = 'Configurar el color del fondo de la actividad Foro.';
$string['coursesectionactivityforumleftbordercolor'] = 'Color para mostrar borde izquierdo de actividad Foro';
$string['coursesectionactivityforumleftbordercolordesc'] = 'Configurar el color del borde izquierdo.';
$string['coursesectionactivityfurtherinformation'] = 'Información adicional de página de curso';
$string['coursesectionactivityfurtherinformationassign'] = 'Mostrar Información de Tarea';
$string['coursesectionactivityfurtherinformationassigndesc'] = 'Mostrar información sobre tarea, tal como fecha esperada, estatus del envío. Para profesores y administradores, mostrar número de envíos.';
$string['coursesectionactivityfurtherinformationchoice'] = 'Mostrar información de elección';
$string['coursesectionactivityfurtherinformationchoicedesc'] = 'Mostrar información de elección, como por ejemplo, estatus del envío. Para profesores y administradores, mostrar número de envíos.';
$string['coursesectionactivityfurtherinformationdata'] = 'Mostrar información de base de datos';
$string['coursesectionactivityfurtherinformationdatadesc'] = 'Mostrar información de los datos, como por ejemplo, estatus del envío.Para profesores y administradores, mostrar número de envíos.';
$string['coursesectionactivityfurtherinformationfeedback'] = 'Mostrar información de retroalimentación';
$string['coursesectionactivityfurtherinformationfeedbackdesc'] = 'Mostrar información de retroalimentación, como por ejemplo estatus del envío. Para profesores y administradores, mostrar número de envíos.';
$string['coursesectionactivityfurtherinformationlesson'] = 'Mostrar información de lección';
$string['coursesectionactivityfurtherinformationlessondesc'] = 'Mostra información de lección, como por ejemplo, estatus del envío. Para profesores y administradores, mostrar número de envíos.';
$string['coursesectionactivityfurtherinformationquiz'] = 'Mostrar información de examen';
$string['coursesectionactivityfurtherinformationquizdesc'] = 'Mostrar información de examen, como por ejemplo, estatus del envío. Para profesores y administradores, mostrar número de envíos.';
$string['coursesectionactivityiconsize'] = 'Tamaño del Ícono de Actividad en Sección de Curso';
$string['coursesectionactivityiconsizedesc'] = 'Configurar el tamaño del ícono para actividades / recursos (por ejemplo, un valor de "16px" los configurará a 16 pixeles por 16 pixeles).';
$string['coursesectionactivityleftborderwidth'] = 'Ancho del Borde Izquierdo de Actividad en Sección de Curso';
$string['coursesectionactivityleftborderwidthdesc'] = 'Configurar el ancho del borde que aparece en la izquierda de una actividad de sección de curso.';
$string['coursesectionactivitymarginbottom'] = 'Espaciado de actividad margen del botón.';
$string['coursesectionactivitymarginbottomdesc'] = 'Espaciado entre actividades del margen del botón';
$string['coursesectionactivitymargintop'] = 'Espaciado de actividad margen superior';
$string['coursesectionactivitymargintopdesc'] = 'Espaciado entre actividades del margen superior';
$string['coursesectionactivityquizbgcolor'] = 'Color del fondo de actividad Examen';
$string['coursesectionactivityquizbgcolordesc'] = 'Configurar el color del fondo dactividad Examen';
$string['coursesectionactivityquizleftbordercolor'] = 'Color a mostrar borde izquierdo de actividad examen';
$string['coursesectionactivityquizleftbordercolordesc'] = 'Configurar el color del borde izquierdo.';
$string['coursesectionactivityuseadaptableicons'] = 'Usar Conjunto de Íconos de Adaptable';
$string['coursesectionactivityuseadaptableiconsdesc'] = 'Active esto para usar íconos Adaptable. Si se desactiva, por favor también asegúrese de quitar los directorios adaptable/pix_plugins y adaptable/pix_core/f tpar usar los íconos por defecto de Moodle.';
$string['coursesectionbgcolor'] = 'Fondo de Sección del Curso';
$string['coursesectionbgcolordesc'] = 'Configurar el color del fondo de la sección del curso.';
$string['coursesectionbordercolor'] = 'Color del Borde de Sección de Curso';
$string['coursesectionbordercolordesc'] = 'Configurar el color del Borde de Secciones de Curso';
$string['coursesectionborderradius'] = 'Radio del Borde de Sección del Curso';
$string['coursesectionborderradiusdesc'] = 'Configurar el Radio del Borde de Sección del Curso (esquinas redondeadas)';
$string['coursesectionborderstyle'] = 'Estilo del borde de sección del curso';
$string['coursesectionborderstyledesc'] = 'Configurar el estilo del borde de sección del curso';
$string['coursesectionborderwidth'] = 'Ancho del Borde de Sección del Curso';
$string['coursesectionborderwidthdesc'] = 'Configurar el ancho del Borde de Sección del Curso';
$string['coursesectionheaderbg'] = 'Fondo del Encabezado de Sección del curso';
$string['coursesectionheaderbgdesc'] = 'Configurar el color del fondo de los Encabezados de Sección del curso';
$string['coursesectionheaderbordercolor'] = 'Color del Borde del Encabezado de Sección del Curso';
$string['coursesectionheaderbordercolordesc'] = 'Configurar el color del borde del encabezado de sección del curso (solamente se usa el borde inferior porque el contenedor externo también tiene borde)';
$string['coursesectionheaderborderradiusbottom'] = 'Botón del Radio del Borde de Sección de Encabezado del curso';
$string['coursesectionheaderborderradiusbottomdesc'] = 'Configurar el Botón del Radio de los Bordes de Sección de Encabezado del curso (esquinas redondeadas)';
$string['coursesectionheaderborderradiustop'] = 'Radio superior del Borde de Sección de Encabezado de Curso';
$string['coursesectionheaderborderradiustopdesc'] = 'Configurar el Radio superior del Borde de Sección de Encabezado de Curso (esquinas redondeadas)';
$string['coursesectionheaderborderstyle'] = 'Estilo del Borde del Encabezado de Sección del Curso';
$string['coursesectionheaderborderstyledesc'] = 'Configurar el estilo del Borde del Encabezado de Sección del Curso (solamente se usa el borde inferior porque el contenedor externo también tiene borde)';
$string['coursesectionheaderborderwidth'] = 'Ancho del Borde del Encabezado de Sección del Curso';
$string['coursesectionheaderborderwidthdesc'] = 'Configurar el Ancho del Borde del Encabezado de Sección del Curso (solamente se usa el borde inferior porque el contenedor externo también tiene borde)';
$string['coursesettings'] = 'Formatos de Curso';
$string['coursesettingsdesc'] = 'Personalizar algunos de los formatos de curso de Moodle más usados para que quepan en el diseño principal.';
$string['coursesettingsheading'] = 'Configuraciones de Formatos de Curso';
$string['coursetitlemaxwidth'] = 'Longitud Máxima del Título del Curso';
$string['coursetitlemaxwidthdesc'] = 'Establece el número máximo de caracteres del área del título del curso';
$string['coursetitlepaddingleft'] = 'Separación izquierda del Título del Curso';
$string['coursetitlepaddingleftdesc'] = 'Configurar la separación a la izquierda del título del curso para ajustar posición';
$string['coursetitlepaddingtop'] = 'Separación superior del título del curso';
$string['coursetitlepaddingtopdesc'] = 'Configurar separación arriba del título del curso para ajustar posición';
$string['covbkcolor'] = 'Color de fondo en los bloques estilo Coventry';
$string['covbkcolordesc'] = 'Establece el color de superposición de los bloques cuando se ha seleccionado el estilo Coventry.';
$string['coventrystyle'] = 'Estilo Coventry';
$string['covfontcolor'] = 'Color del texto en los bloques estilo Coventry';
$string['covfontcolordesc'] = 'Establece el color del texto en los bloques estilo Coventry.';
$string['covhidebutton'] = 'Mostrar el botón del curso en los bloques estilo Coventry';
$string['covhidebuttondesc'] = 'Mostrar / ocultar el botón del curso cuando se utiliza el estilo Coventry se encuentra activo.';
$string['currentcolor'] = 'Color de realce de la sección actual del curso';
$string['currentcolordesc'] = 'Establece el color de realce de la sección actual del curso';
$string['customcss'] = 'CSS personalizado';
$string['customcssdesc'] = 'Introduce las reglas CSS.';
$string['customcssjssettings'] = 'CSS y JS personalizado';
$string['customfontheadername'] = 'Font del Encabezado Personalizado';
$string['customfontheadernamedesc'] = 'Ingresar el nombre del Font del Encabezado personalizado solamente si Usted seleccionó \'Personalizado\' en el menú desplegable del Font del Encabezado.';
$string['customfontname'] = 'Font Principal Personalizado';
$string['customfontnamedesc'] = 'Ingresar el nombre del Font Principal personalizado solamente si Usted seleccionó \'Personalizado\' en el menú desplegable del Font Principal.';
$string['customfonttitlename'] = 'Font del Título Personalizado';
$string['customfonttitlenamedesc'] = 'Ingresar el nombre del Font del Tíulo personalizado solamente si Usted seleccionó \'Personalizado\' en el menú desplegable del Font del Título.';
$string['dashblocklayoutbuilder'] = 'Regiones de Bloque del Tablero';
$string['dashblocklayoutbuilderdesc'] = 'Debajo, Usted puede construir su propio diseño para las regiones de bloque en la  pagina del Tablero.
Para añadir contenido en estas regiones Usted necesitará  <strong> activar la edición, en la página del Tablero de Moodle</strong>.
¡Entonces Usted puede comenzar a arrastrar/soltar bloques a las regiones que Usted creó!';
$string['dashblocklayoutlayoutrow'] = 'Fila de regiones de Bloque del Tablero';
$string['dashblocklayoutlayoutrowdesc'] = 'Añadir / configurar el diseño para la fila de región de bloques en la página del Tablero.';
$string['dashblocksenabled'] = 'Habilitar región de bloque personalizado en página del Tablero';
$string['dashblocksenableddesc'] = 'Usted puede habilitar / deshabilitar las regiones de bloque personalizadas en la página del Tablero.

Usted puede entonces arrastrar y soltar bloques a las regiones que Usted creó.';
$string['dashboardblockregionsettings'] = 'Constructor de región de Bloque del Tablero';
$string['deprecated'] = 'VERSIÓN DE MOODLE OBSOLETA. NO USE ADAPTABLE EN ESTE SITIO';
$string['disablecustommenu'] = 'Desactivar el menú personalizado de Moodle';
$string['disablecustommenudesc'] = 'Desactiva el menú personalizado de Moodle en la barra de navegación (seguirá funcionando en otras plantillas instaladas)';
$string['disabled'] = 'Deshabilitado';
$string['disablemenuscoursepages'] = 'Desactivar menús en las páginas de los cursos';
$string['disablemenuscoursepagesdesc'] = 'Activando esta opción los menús solo se mostrarán en las páginas del sitio, la página inicial, el Área Personal, etc. y no se mostrará en las páginas de los cursos.';
$string['discardbuttontext'] = 'Cancelar';
$string['displaygrades'] = 'Mostrar Calificaciones';
$string['displaygradesdesc'] = 'Mostrar los ítems de Calificaciones en el menú';
$string['displaylogin'] = 'Mostrar ingreso';
$string['displayloginbox'] = 'Caja para Ingresar';
$string['displayloginbutton'] = 'Botón';
$string['displaylogindesc'] = 'Seleccionar como mostrar el ingreso en la pantalla (cuando se habilita arriba)';
$string['displayloginno'] = 'Sin Ingreso';
$string['displayparticipants'] = 'Mostrar Participantes';
$string['displayparticipantsdesc'] = 'Mostrar el ítem de los Participantes en el menú';
$string['dividingline'] = 'Color de la línea divisoria de la cabecera';
$string['dividingline2'] = 'Color de la línea divisoria del pie de página';
$string['dividingline2desc'] = 'Establece el color de la línea divisoria del pie de página. Usar el mismo color que el pie para eliminarla.';
$string['dividinglinedesc'] = 'Establece el color de la línea divisoria de la cabecera. Usar el mismo color que la cabecera para eliminarla.';
$string['draft'] = 'No publicado para estudiantes';
$string['due'] = 'Esperado en {$a}';
$string['editfont'] = 'Color del texto de los botones de <i>Edición</i> y <i>Personalizar esta página</i>';
$string['editfontdesc'] = 'Establece el color del texto de los botones de <i>Edición</i> y <i>Personalizar esta página</i>';
$string['edithorizontalpadding'] = 'Separación horizontal de los botones de edición';
$string['editoffbk'] = 'Color de fondo de los botones de edición y personalización desactivados';
$string['editoffbkdesc'] = 'Establece el color de fondo de los botones de edición y personalización cuando están desactivados.';
$string['editonbk'] = 'Color de fondo de los botones de edición y personalización activados';
$string['editonbkdesc'] = 'Establece el color de fondo de los botones de edición y personalización cuando están activados.';
$string['edittopmargin'] = 'Margen superior de los botones de edición';
$string['editverticalpadding'] = 'Separación vertical de los botones de edición';
$string['emoticonsize'] = 'Tamaño de emoticones';
$string['emoticonsizedesc'] = 'Configurar el alto y ancho de los emoticones de Moodle.';
$string['enablealert'] = 'Activar Alerta {$a}';
$string['enablealertcoursepages'] = 'Activar Alertas en las páginas de los cursos';
$string['enablealertcoursepagesdesc'] = 'Activar las alertas también en las páginas de los cursos.';
$string['enablealertdesc'] = 'Activar la alerta {$a}.';
$string['enablealerts'] = 'Habilitar / deshabilitar Alertas';
$string['enablealertsdesc'] = 'Habilitar / deshabilitar Alertas en su sitio';
$string['enablealertstriptags'] = 'Automáticamente eliminar marcas HTML del texto de alertas';
$string['enablealertstriptagsdesc'] = 'Si se activa, se eliminarán las etiquetas HTML del texto. Si está desactivado, se permitirá introducir etiquetas HTML por ejemplo para añadir enlaces.';
$string['enableanalytics'] = 'Activar Google Analytics';
$string['enableanalyticsdesc'] = 'Activar Google Analytics en el sitio.';
$string['enableavailablecourses'] = 'Mostrar "Cursos Disponibles"';
$string['enableavailablecoursesdesc'] = 'Mostrar el texto "Cursos Disponibles" en la Portada';
$string['enablebadges'] = 'Insignias';
$string['enablebadgesdesc'] = 'Mostrar el enlace de las insignias del usuario.';
$string['enableblog'] = 'Habilitar Mis Blogs';
$string['enableblogdesc'] = 'Mostrar el enlace a ls blogs del usuario.';
$string['enablecalendar'] = 'Calendario';
$string['enablecalendardesc'] = 'Mostrar el enlace al calendario del usuario.';
$string['enableeditprofile'] = 'Editar perfil';
$string['enableeditprofiledesc'] = 'Mostrar el enlace para editar el perfil del usuario.';
$string['enableeventsdesc'] = 'Mostrar un enlace al calendario';
$string['enablefeed'] = 'Mi retroalimentación';
$string['enablefeeddesc'] = 'Mostrar el enlace a la página "Opiniones" - <i>Nota: esta opción requiere el <a href="https://moodle.org/plugins/report_myfeedback" target="blank">plugin My Feedback</a> instalado';
$string['enablegrades'] = 'Calificaciones';
$string['enablegradesdesc'] = 'Mostrar el enlace de las calificaciones del usuario.';
$string['enableheading'] = 'Nombre del curso';
$string['enableheadingdesc'] = 'Establece el modo de visualización del título del curso en la cabecera cuando se habilita el título del sitio Moodle por defecto.';
$string['enablehelp'] = 'Enlace de ayuda';
$string['enablehelpdesc'] = 'Añade un enlace de ayuda en la barra de navegación.';
$string['enablehomedesc'] = 'Mostrar enlace a Inicio';
$string['enablehomeredirect'] = 'Activar redirect=0';
$string['enablehomeredirectdesc'] = 'Activa la opción redirect=0 para redirigir a la página inicial del sitio. Está opción puede  utilizarse en sitios que tienen el Área Personal como página inicial por defecto. Desactivada previene redireccionar a los usuarios a la página inicial y ser redirigidos al Área Personal';
$string['enablemenus'] = 'Activar Menús';
$string['enablemenusdesc'] = 'Por motivos de rendimiendo, se recomienda no activarlo si no se utilizan los menús.';
$string['enablemessagemenu'] = 'Menú de Mensaje';
$string['enablemessagemenudesc'] = 'Habilitar Menú de Mensaje en el encabezado (no hacerlo si está desactivada la mensajería global)';
$string['enablemy'] = 'Mi Hogar';
$string['enablemydesc'] = 'Mostrar el enlace al Tablero.';
$string['enablemyhomedesc'] = 'Mostrar un enlace a {$a}';
$string['enablemysitesdesc'] = 'Mostrar los cursos del usuario';
$string['enablemysitesrestriction'] = 'Restringir desplegable de cursos del usuario a un campo personalizado del perfil';
$string['enablemysitesrestrictiondesc'] = 'Restringir el desplegable con cursos del usuario por campo personalizado del perfil . Por ejemplo, usertype=staff';
$string['enablenavbarwhenloggedout'] = 'Habilitar Barra de Navegación cuando salió del sitio';
$string['enablenavbarwhenloggedoutdesc'] = 'Mostrar la Barra de Navegación aun y cuando haya salido del sitio. Limitado a menúes de Ayuda y Herramientas solamente.';
$string['enablenote'] = 'Mis Notificaciones';
$string['enablenotedesc'] = 'Mostrar el enlace página de notificaciones.';
$string['enableposts'] = 'Mis Publicaciones';
$string['enablepostsdesc'] = 'Mostrar el enlace a las publicaciones en los foros realizadas por el usuario.';
$string['enablepref'] = 'Mis Preferencias';
$string['enableprefdesc'] = 'Mostrar el enlace a las preferencias del usuario.';
$string['enableprivatefiles'] = 'Archivos privados';
$string['enableprivatefilesdesc'] = 'Mostrar el enlace a los archivos privados del usuario.';
$string['enableprofile'] = 'Perfil usuario';
$string['enableprofiledesc'] = 'Mostrar el enlace del perfil de usuario.';
$string['enablesavecanceloverlay'] = 'Habilitar sobrepuesto de Guardar / Cancelar en páginas de configuraciones';
$string['enablesavecanceloverlaydesc'] = 'Mostrar un botón sobrepuesto de Guardar / Cancelar en la parte superior de una página de configuración para hacer más fácil el guardar las configuraciones.';
$string['enablesearchbox'] = 'Habilitar Caja para Búsqueda';
$string['enablesearchboxdesc'] = 'Mostrar una caja para búsqueda en el encabezado';
$string['enableshowhideblocks'] = 'Activar Mostrar/Ocultar bloques';
$string['enableshowhideblocksdesc'] = 'Permite a los usuarios mostrar / ocultar los bloques laterales.';
$string['enablethiscoursedesc'] = 'Mostrar las actividades del curso actual';
$string['enableticker'] = 'Activar los anuncios en la página de inicio';
$string['enabletickerc'] = 'Activar los anuncios en las páginas internas';
$string['enabletickercdesc'] = 'Marcar para activar los anuncios en las páginas internas.';
$string['enabletickerdesc'] = 'Marcar para activar los anuncios en la página de inicio.';
$string['enabletickermy'] = '¿Activar los anuncios en la página del Tablero / Mi Hogar?';
$string['enabletickermydesc'] = 'Marcar para activar los anuncios en la página del Tablero / Mi Hogar';
$string['enabletoolsmenus'] = 'Activar menús de herramientas';
$string['enabletoolsmenusdesc'] = 'Por razones de rendimiento se recomienda dejarlo desactivado si no se utilizan.';
$string['enablezoom'] = 'Activar Zoom';
$string['enablezoomdesc'] = 'Permite a los usuarios cambiar entre pantalla completa o ancho fijo de pantalla.';
$string['events'] = 'Eventos';
$string['favicon'] = 'Favicon';
$string['favicondesc'] = 'Sube el archivo favicon.ico';
$string['feedbackavailable'] = 'Retroalimentación disponible';
$string['filteradminmessages'] = 'Filtrar Mensajes de Administración';
$string['filteradminmessagesdesc'] = 'Habilitar para quitar mensajes de usuario administrador; esto puede reducir los mensajes del tipo del sistema que les aparecen a los estudiantes.';
$string['fontblockheadercolor'] = 'Color del tipo de letra de encabezado de bloques';
$string['fontblockheadercolordesc'] = 'Configura el color del tipo de letra del encabezado de los bloques de Moodle; use código hexadecimal HTML. Tenga en cuenta que esto también afecta el color del ícono.';
$string['fontblockheadersize'] = 'Tamaño del tipo de letra del encabezado de bloques';
$string['fontblockheadersizedesc'] = 'Configurar el tamaño del tipo de letra en el encabezado de bloques de Moodle. Seleccione un valor de la lista.';
$string['fontblockheaderweight'] = 'Peso del tipo de letra del encabezado del bloque';
$string['fontblockheaderweightdesc'] = 'Configurar el peso del tipo de letra usado en el encabezado de bloques de Moodle. Seleccione un valor de 100 a 900 dependiendo del tipo de letra seleccionado.';
$string['fontcolor'] = 'Color del tipo de letra principal';
$string['fontcolordesc'] = 'Establece el color del tipo de letra principal, usar código hexadecimal HTML.';
$string['fontdesc'] = 'Selecciona la fuente de <a href="https://www.google.com/fonts" target="_blank">Google Fonts</a> para el texto, los encabezados y el título. Selecciona también el juego de caracteres a usar (latin está incluido por defecto) e introduce el valor correcto para el grueso de fuente utilizado o no se mostrará.';
$string['fontheadercolor'] = 'Color del tipo de letra de los encabezados';
$string['fontheadercolordesc'] = 'Establece el color del tipo de  letra de los encabezados utilizados en la plantilla.';
$string['fontheadername'] = 'Tipo de letra de encabezados';
$string['fontheadernamedesc'] = 'Establece el tipo de letra de los encabezados utilizados en la plantilla. Selecciona default o un tipo de letra de <a href="https://www.google.com/fonts" target="_blank">Google Fonts</a>.';
$string['fontheaderweight'] = 'Grueso del tipo de letra de encabezados';
$string['fontheaderweightdesc'] = 'Establece el grueso del tipo de letra de encabezados. Introducir un valor entre 100 y 900 dependiendo del tipo de letra utilizado.';
$string['fontname'] = 'Tipo de letra principal';
$string['fontnamedesc'] = 'Establece el tipo de letra principal o <a href="https://www.google.com/fonts" target="_blank">Google Fonts</a> que se usa en el sitio.';
$string['fontsettings'] = 'Tipos de letras (fonts)';
$string['fontsettingsheading'] = 'Establece los tipos de letras utilizados por la plantilla.';
$string['fontsize'] = 'Tamaño del tipo de letra principal';
$string['fontsizedesc'] = 'Selecciona el tamaño por defecto del tipo de letra (en porcentaje) usado en todo el sitio.';
$string['fontsubset'] = 'Juego de caracteres de Google Fonts';
$string['fontsubsetdesc'] = 'Seleccionar el juego de caracteres de Google Fonts a usar, además del latin ya incluido por defecto. Se aplicará a toda la plantilla.';
$string['fonttitlecolor'] = 'Color del tipo de letra del título del Sitio / Curso';
$string['fonttitlecolorcourse'] = 'Color del tipo de letra del título del curso';
$string['fonttitlecolorcoursedesc'] = 'Establecer el color del tipo de letra (font) del título del curso en el tema; use código HEXADECIMAL.';
$string['fonttitlecolordesc'] = 'Establece el color del tipo de letra del título del sitio y título del curso en el tema; use código hexadecimal HTML.';
$string['fonttitlename'] = 'Tipo de letra del título del Sitio / Curso';
$string['fonttitlenamedesc'] = 'Establece el tipo de letra del título del sitio situado en la cabecera. Selecciona default o una fuente de <a href="https://www.google.com/fonts" target="_blank">Google Fonts</a>.';
$string['fonttitlesize'] = 'Tamaño del tipo de letra del título del Sitio / Curso';
$string['fonttitlesizedesc'] = 'Tamaño del tipo de letra del título del sitio y del título del curso usados en el sitio. Seleccionar un valor de la lista.';
$string['fonttitleweight'] = 'Grueso del tipo de letra del título del Sitio / Curso';
$string['fonttitleweightdesc'] = 'Establece el grueso del tipo de letra del título del sitio y título del curso. Introducir un valor entre 100 y 900 dependiendo de la fuente utilizada.';
$string['fontweight'] = 'Grueso del tipo de letra principal';
$string['fontweightdesc'] = 'Establece el grueso del tipo de letra principal. Seleccionar un valor entre 100 y 900 dependiendo del tipo de letra utilizado.';
$string['footerbkcolor'] = 'Color del fondo del pie de página superior';
$string['footerbkcolordesc'] = 'Establece el color de fondo usado por el pie de página superior.';
$string['footerblocksplacement'] = 'Posición de los bloques del pie de página';
$string['footerblocksplacement1'] = 'Sitewide (Todo_el_sitio)';
$string['footerblocksplacement2'] = 'Solamente Página inicial';
$string['footerblocksplacement3'] = 'Never (Nunca)';
$string['footerblocksplacementdesc'] = 'Controla en donde se muestran los bloques de pie de página superiores. Sitewide (todo_el_sitio) es la opción por defecto.';
$string['footercontent'] = 'Sección con Contenido del Pie de página';
$string['footercontentdesc'] = 'Añadirle contenido a sección del pie de página';
$string['footerdesc'] = 'Añadir un título para la sección del pie de página';
$string['footerheader'] = 'Sección del Título del Pie de Página';
$string['footerlayoutrow'] = 'Constructor de Diseño de Pie de Página';
$string['footerlayoutrowdesc'] = 'Fabrique su diseño para las regiones de bloque del pie de página';
$string['footerlinkcolor'] = 'Color de los enlaces del pie de página';
$string['footerlinkcolordesc'] = 'Establece el color de los enlaces del pie de página.';
$string['footersettings'] = 'Pie de Página';
$string['footersettingsheading'] = 'Configurar el contenido de lo que debe de aparecer en el pie de página. Vea el diseño <a href="./adaptable/pix/layout.png" target="_blank"> aquí</a>';
$string['footertextcolor'] = 'Color de texto del pie de página superior';
$string['footertextcolor2'] = 'Color del texto del pie de página inferior';
$string['footertextcolor2desc'] = 'Establece el color usado por el texto en el pie de página inferior.';
$string['footertextcolordesc'] = 'Establece el color usado por el texto en el pie de página superior.';
$string['footnote'] = 'Copyright / Nota al pie';
$string['footnotedesc'] = 'Añadir un texto de copyright / nota al pie en el pie de página.';
$string['forumbodybackgroundcolor'] = 'Fondo del cuerpo de publicación en foro';
$string['forumbodybackgroundcolordesc'] = 'Color del fondo para una publicación en foro';
$string['forumheaderbackgroundcolor'] = 'Fondo del encabezado de publicación en foro';
$string['forumheaderbackgroundcolordesc'] = 'Color del Fondo para una publicación en foro';
$string['frnt-footer'] = 'Los bloques en esta área serán visibles solamente para los usuarios administradores.';
$string['frontpagealertsettings'] = 'Alertas';
$string['frontpageblockregionsettings'] = 'Constructor de Región de Bloque';
$string['frontpageblocksenabled'] = 'Habilitar región de bloque personalizada en la Portada';
$string['frontpageblocksenableddesc'] = 'Usted puede habilitar / deshabilitar regiones de bloque personalizadas en la Portada. Usted puede entonces arrastrar y soltar bloques dentro de las regiones que haya creado.';
$string['frontpageblocksettings'] = 'Bloques promocionales';
$string['frontpagecoursesettings'] = 'Lista de Cursos en Portada';
$string['frontpagedesc'] = 'Configurar la forma en que los cursos son mostrados en la página inicial.';
$string['frontpagelogin'] = 'Ingreso en la Portada';
$string['frontpagelogindesc'] = 'Mostrar el formato de entrada en la parte superior de la cabecera. En caso contrario, se mostrará solo el botón.';
$string['frontpagemarketenabled'] = 'Activar los bloques promocionales';
$string['frontpagemarketenableddesc'] = 'Activar los bloques promocionales en la pagina de inicio.';
$string['frontpagemarketoption'] = 'Elegir estilo para los Bloques Promocionales';
$string['frontpagemarketoptiondesc'] = 'Usted puede aplicar diferentes estilos a los bloques promocionales. Tenga en cuenta que el estilo BCU está diseñado para trabajar con imágenes en la zona de arriba de los bloques.';
$string['frontpagerenderer'] = 'Bloques de cursos';
$string['frontpagerendererdefaultimage'] = 'Imagen por defecto para los cursos';
$string['frontpagerendererdefaultimagedesc'] = 'Sube la imagen que se utilizará por defecto en los cursos que no dispongan de ella.  (sólo se aplica en el estilo "Bloques Superpuestos")';
$string['frontpagerendererdesc'] = 'Configurar la forma en que los cursos son mostrados en la página inicial.';
$string['frontpagerendereroption1'] = 'Mosaicos';
$string['frontpagerendereroption2'] = 'Mosaicos sin sobreposición';
$string['frontpagerendereroption3'] = 'Por defecto';
$string['frontpagerendereroption4'] = 'Tipo Coventry';
$string['frontpagesettingsheading'] = 'Página Inicial';
$string['frontpageslidersettings'] = 'Presentación de diapositivas';
$string['frontpagetickersettings'] = 'Anuncios';
$string['fullscreen'] = 'Pantalla completa';
$string['fullscreenwidth'] = 'Ancho de pantalla completa';
$string['fullscreenwidthdesc'] = 'Establece el ancho máximo de la pantalla en modo pantalla completa / zoom.';
$string['genericsettingsdescription'] = 'Introduce tu propio código CSS y Javascript.';
$string['genericsettingsheading'] = 'Introduce tu propio código CSS y Javascript';
$string['googleanalyticssettings'] = 'Google Analytics';
$string['googleanalyticssettingsdesc'] = 'Usted puede configurar códigos múltiples para Google Analytics y dirigirlos a campos de perfil del usuario.';
$string['googleanalyticssettingsheading'] = 'Configurar Google Analytics para su sitio';
$string['headerbgimage'] = 'Imágen de Fondo';
$string['headerbgimagedesc'] = 'Configurar una imagen del fondo para el encabezado. El tamaño mínimo es de 1600 pixeles por 180 pixeles (1900x180 pixeles recomendados). La imagen cubre a todo el encabezado. Usted puede añadir un color en \'Color del fondo del encabezado superior\' o puede usar <i>transparent</i> para mostrar la imagen del fondo. En ese caso, modifique el color del texto para obtener que se muestre correctamente sobre la imagen.';
$string['headerbkcolor'] = 'Color de fondo de la parte superior de la cabecera';
$string['headerbkcolor2'] = 'Color de fondo de la parte inferior de la cabecera';
$string['headerbkcolor2desc'] = 'Establece el color de fondo de la parte inferior de la cabecera.';
$string['headerbkcolordesc'] = 'Establece el color de fondo de la parte superior de la cabecera.';
$string['headerdesc'] = 'Suba su favicon, logo, configure el formato para ingresar al sitio, ajuste títulos en encabezado.<br />
<strong>Usted puede configurar tamaño y estilo del tipo de letra (font) para los títulos en la página de configuraciones para los tipos de letras "fonts".</strong>';
$string['headernavbarhelpheading'] = 'Enlaces de Ayuda y Opciones';
$string['headernavbarhelpheadingdesc'] = 'Opciones para enlaces del menú para ayuda.';
$string['headernavbarmycoursesheading'] = 'Menú de Mis Cursos';
$string['headernavbarmycoursesheadingdesc'] = 'Todas las opciones parala opción del menú de Mis Cursos (Mis Sitios) que muestra la lista de los cursos actuales del usuario';
$string['headernavbarstylingheading'] = 'Estilo de Barra de Navegación';
$string['headernavbarstylingheadingdesc'] = 'Opciones de estilo para el menú de navegación principal.';
$string['headernavbarthiscourseheading'] = 'Menú de Este Curso';
$string['headernavbarthiscourseheadingdesc'] = 'En este menú el estudiante puede acceder directamente a todas las actividades del curso y la lista de los participantes y sus calificaciones.';
$string['headersettings'] = 'Cabecera';
$string['headersettingsheading'] = 'Personalice el encabezado de este tema. Vea el diseño  <a href="./../theme/adaptable/pix/layout.png" target="_blank"> aquí</a>';
$string['headertextcolor'] = 'Color de texto y enlaces de la parte superior de la cabecera';
$string['headertextcolor2'] = 'Color del texto y enlaces de la parte inferior de la cabecera';
$string['headertextcolor2desc'] = 'Establece el color de texto y enlaces de la parte inferior de la cabecera.';
$string['headertextcolordesc'] = 'Establece el color de texto y enlaces de la parte superior de la cabecera.';
$string['help'] = 'Ayuda';
$string['helpprofilefield'] = 'Campo personalizado para la ayuda (opcional)';
$string['helpprofilefielddesc'] = 'Añade una regla de acceso usando un campo de perfil personalizado. Ejemplo: "usertype=student"';
$string['helptarget'] = 'Nueva ventana de ayuda';
$string['helptargetdesc'] = 'Abrir la ayuda en la misma ventana o en una nueva.';
$string['helptitle'] = 'Ayuda por perfíl';
$string['helptitle2'] = 'Enlace de ayuda dependiente del campo personalizado en el perfíl.';
$string['hiddencourses'] = 'Cursos Ocultos';
$string['hide'] = 'Ocultar';
$string['hidealertsmobile'] = 'Ocultar Alertas en dispositivo móvil (si están activadas)';
$string['hidealertsmobiledesc'] = 'Oculta las alertas de la parte superior de la pantalla en dispositivos móviles (si están activadas)';
$string['hideblocks'] = 'Ocultar bloques';
$string['hidebreadcrumbmobile'] = 'Ocultar ruta de navegación';
$string['hidebreadcrumbmobiledesc'] = 'Oculta la ruta de navegación.';
$string['hidecoursetitlemobile'] = 'Oculta el título del curso/sitio en Mobile';
$string['hidecoursetitlemobiledesc'] = 'Oculta el título del curso y del sitio';
$string['hidefootersocial'] = 'Mostrar íconos sociales';
$string['hidefootersocialdesc'] = 'Mostrar íconos sociales en el pie de página debajo de los bloques.';
$string['hideheadermobile'] = 'Ocultar la cabecera';
$string['hideheadermobiledesc'] = 'Oculta la cabecera, logo, íconos sociales y búsqueda.';
$string['hideinforum'] = 'Ocultar Menús de Ayuda y Herramientas en los foros';
$string['hideinforumdesc'] = 'Si se utiliza un ancho fijo de pantalla es posible que los menús salten a la línea inferior. Activando esta opción se ocultan los menús en las páginas de foros.';
$string['hidelogomobile'] = 'Ocultar Logo en dispositivos móviles';
$string['hidelogomobiledesc'] = 'Ocultar Logo en dispositivos móviles';
$string['hidepagefootermobile'] = 'Ocultar pie de página en dispositivos móviles';
$string['hidepagefootermobiledesc'] = 'Ocultar pie de página en dispositivos móviles';
$string['hideslidermobile'] = 'Ocultar deslizador en Mobile';
$string['hideslidermobiledesc'] = 'Ocultar quitará el deslizador de la portada en dispositivos móviles';
$string['hidesocialmobile'] = 'Ocultar los iconos sociales en dispositivos móviles';
$string['hidesocialmobiledesc'] = 'Oculta los iconos sociales en dispositivos móviles (si están activados)';
$string['home'] = 'Inicio';
$string['homebk'] = 'Imagen de fondo de la Portada';
$string['homebkdesc'] = 'Sube la imagen de fondo para la plantilla.';
$string['infobox'] = 'Cuadro informativo 1';
$string['infobox2'] = 'Cuadro informativo 2';
$string['infobox2desc'] = 'Caja de Información Secundaria de la Portada (vea el archivo <a href="./../theme/adaptable/README.txt" target="_blank">README</a> para mayor información y sugerencias).<br><br><strong>Nota: </strong><i>Este elemento solamente es usado para compatibilidad con BCU y será elimniado en versiones futuras.</i>';
$string['infoboxdesc'] = 'HTML del Bloque de información de la Portada (vea el archivo <a href="./../theme/adaptable/README.txt" target="_blank">README</a> para mayor información y sugerencias).<br><br><strong>Nota: </strong><i>Este elemento solamente es usado para compatibilidad con BCU y será elimniado en versiones futuras.</i>';
$string['infoboxfullscreen'] = 'Cuadros informativos a pantalla completa';
$string['infoboxfullscreendesc'] = 'Marcar está opción para mostrar los cuadros informativos a ancho completo.';
$string['jssection'] = 'Javascript personalizado';
$string['jssectiondesc'] = 'Introduce el código Javascript.';
$string['jssectionrestricted'] = 'Sección de JavaScript Condicional';
$string['jssectionrestricteddashboardonly'] = 'Incluir JavaScript solamente en la página del Tablero';
$string['jssectionrestricteddashboardonlydesc'] = 'Mostrar el JavaScript solamente en la página del Tablero. En caso contrario, se muestra en todo el sitio.';
$string['jssectionrestricteddesc'] = 'Añadir código JavaScript al sitio basado condicionalmente en un campo personalizado del perfil . Este JavaScript solamente aparece si se cumple esta condición.';
$string['jssectionrestrictedprofilefield'] = 'Campo personalizado del perfil de Sección JavaScript';
$string['jssectionrestrictedprofilefielddesc'] = 'Mostrar el JavaScript de arriba SOLAMENTE cuando el usuario coincide con el valor de este campo personalizado del perfil ; por ejemplo:  faculty=fbl';
$string['jumpto'] = 'Saltar a ...';
$string['layoutaddcontent'] = '¿Está feliz con su diseño? Ahora Añada Contenido a Sus Bloques';
$string['layoutaddcontentdesc1'] = 'Usted ha configurado';
$string['layoutaddcontentdesc2'] = 'bloques promocionales. Si Usted está feliz con este diseño, añada contenido a los bloques inferiores.
Si Usted no está feliz, use el constructor de diseño superior para realizar cambios<br />';
$string['layoutcheck'] = 'Revise su diseño';
$string['layoutcheckdesc'] = 'Uase la herramienta inferior para revisar el número de bloques que Usted haya usado y ver una representación de su nuevo diseño.';
$string['layoutcount1'] = 'Usted puede configurar un máximo de';
$string['layoutcount2'] = 'Regiones de bloque. Actualmente Usted está usando:';
$string['layoutdesc'] = 'Configuración de la disposición por defecto.';
$string['layoutmobilesettings'] = 'Configuración Móvil';
$string['layoutmobilesettingsdesc'] = 'Configuración especifica para dispositivos móviles.';
$string['layoutsettings'] = 'Diseño de pantalla';
$string['layoutsettingsheading'] = 'Controlar las diferentes disposiciones de la plantilla.';
$string['leftblocks'] = 'Lado izquierdo';
$string['linkcolor'] = 'Color de enlace';
$string['linkcolordesc'] = 'Establece el color de los enlaces.';
$string['linkhover'] = 'Color sobre enlace';
$string['linkhoverdesc'] = 'Establece el color cuando pasa el cursor sobre los enlaces.';
$string['linksmenu'] = 'Menú de Enlaces';
$string['loadingcolor'] = 'Color del cargador';
$string['loadingcolordesc'] = 'Color del cargador situado en la parte superior de la página.';
$string['loadtime'] = 'Página cargada en';
$string['loginplaceholder'] = 'Nombre_de_usuario';
$string['logintextbutton'] = 'Ingresar';
$string['logo'] = 'Logo';
$string['logodesc'] = 'Subir un logo para usarlo en su sitio. Dimesiones: 200x80 px.';
$string['maincolor'] = 'Color principal';
$string['maincolordesc'] = 'Establece el color principal del sitio.';
$string['maincoursepage'] = 'Página Principal del Curso';
$string['market'] = 'Bloque Promocional';
$string['marketblockbordercolor'] = 'Color del borde de los bloques promocionales';
$string['marketblockbordercolordesc'] = 'Establece el color del borde de los bloques promocionales.';
$string['marketblocksbackgroundcolor'] = 'Color de fondo de la región de los bloques promocionales.';
$string['marketblocksbackgroundcolordesc'] = 'Establece el color de fondo de la región de los bloques promocionales.';
$string['marketdesc'] = 'Añádale HTML al bloque publicitario (vea el archivo <a href="./../theme/adaptable/README.txt" target="_blank">README</a> para más información y sugerencias).';
$string['marketingbuilderdesc'] = 'Use la herramienta inferior para configurar sus bloques promocionales. Una vez que lo haya definido aparecerán las configuraciones del bloque más abajo en la página.';
$string['marketingbuilderheading'] = 'Constructor del Diseño de Bloque Publicitario';
$string['marketingdesc'] = 'Existen dos cajas con información de ancho completo con diferentes estilos que Usted puede usar. Adicionalmente, existe un constructor de diseño que le permite a Usted decidir cuantos bloques necesita y definir su propio diseño; por favor vea el archivo <a href="./../theme/adaptable/README.txt" target="_blank">README</a> que viene con este tema.';
$string['marketingsettings'] = 'Bloques promocionales';
$string['marketingsettingsheading'] = 'Personaliza los bloques promocionales que aparecen en la Portada. Vea el diseño <a href="./../theme/adaptable/pix/layout.png" target="_blank"> aquí</a>';
$string['marketlayoutrow'] = 'Fila de Bloque Promocional';
$string['marketlayoutrowdesc'] = 'Añadir / configurar diseño para la fila de bloques promocionales en la Portada';
$string['menubkcolor'] = 'Color de fondo del menú principal';
$string['menubkcolordesc'] = 'Establece el color de fondo del menú principal.';
$string['menubordercolor'] = 'Color de la línea divisoria de la barra de navegación';
$string['menubordercolordesc'] = 'Establece el color de la linea divisoria de la barra de navegación.';
$string['menufontcolor'] = 'Color de texto del menú principal';
$string['menufontcolordesc'] = 'Establece el color del texto del menú principal.';
$string['menufontpadding'] = 'Separación para ítems de navegación';
$string['menufontpaddingdesc'] = 'Configurar la separación o de los ítems en la Barra de Navegación principal.';
$string['menufontsize'] = 'Tamaño de fuente de la barra de navegación';
$string['menufontsizedesc'] = 'Establece el tamaño de fuente de la barra de navegación.';
$string['menuhovercolor'] = 'Color del Menú principal al pasar el ratón encima';
$string['menuhovercolordesc'] = 'Configurar el color del Menú principal al pasar el ratón encim';
$string['menuoverrideprofilefield'] = 'Nombre del campo personalizado del perfil';
$string['menuoverrideprofilefielddefault'] = 'topmenusettings';
$string['menuoverrideprofilefielddesc'] = 'El nombre del campo de perfíl "list" usado por la anulacion por usuario.';
$string['menusdesc'] = '';
$string['menusession'] = 'Almacenar los detalles de acceso en la sesión';
$string['menusessiondesc'] = 'Se aconseja activar esta opción para optimizar el rendimiento. Mantener desactivado para pruebas.';
$string['menusessionttl'] = 'Tiempo (minutos) de almacenamiento del acceso a los menús por sesión';
$string['menusessionttldesc'] = 'Número de minutos antes de reiniciar la sesión.';
$string['menusettings'] = 'Menús de cabecera';
$string['menusettingsheading'] = 'Personaliza los menús de la cabecera superior.';
$string['menusheading'] = 'Configurar Navegación para los menús de la parte superior de la cabecera';
$string['menusheadingvisibility'] = 'Configuración para la visibilidad del menú superior';
$string['menusheadingvisibilitydesc'] = 'La siguiente configuración permite controlar donde mostrar los menús y opcionalmente permitir a los usuarios su personalización.';
$string['menuslinkright'] = 'Mostrar enlace a menús en parte superior derecha';
$string['menuslinkrightdesc'] = 'Si se activa, mostrar el enlace hacia los menús en la parte superior derecha junto al menú de mensajes';
$string['menustitledesc'] = 'Los Menús de Herramientas (en la Barra de Navegación) y los Menús Superiores (cabecera superior) pueden ser restringidos dependiendo de un campo personalizado del perfíl de usuario (opcional). Los menús siguen el formato de los menús estándar de moodle:
<pre>
Comunidad Moodle|https://moodle.org
-Soporte Gratuito Moodle https://moodle.org/support
-Desarrollo de Moodle|https://moodle.org/development
--Moodle Docs|http://docs.moodle.org
 --Moodle Docs en Español|https://docs.moodle.org/all/es/P%C3%A1gina_Principal
</pre>';
$string['menuuseroverride'] = 'Permitir la anulación por usuario';
$string['menuuseroverridedesc'] = 'Estas configuraciones pueden ser usadas para darle a los usuarios el control sobre cuales menúes aparecen vía un campo personalizado del perfil. Para usar esta opción, Usted necesitará crear un campo personalizado del perfil en el formato de "lista" con valores en el orden correspondiente:
<pre>1. Sitewide (el primer elemento en la lista será para visibilidad en el menú para todo el sitio)
2. Homepages Only (el segundo elemento en la lista configurará visibilidad solamente para sitio / páginas iniciales)
3. Hidden (el tercer valor en la lista ocultará menúes enteramente)</pre>
NO debes utilizar la opción "Desactivar menús en las páginas de los cursos" junto a configuraciones de campos de perfíl. En su lugar, seleccione el valor predeterminado a su entrada de "Homepages Only" cuando configure su lista de campos del perfil.

Nota: Los usuarios deberán salir de Moodle y volver a entrar para que los cambios hagan efecto. Puede indicarse una nota al crear el campo personalizado del perfil.';
$string['messagepopupbackground'] = 'Color del fondo de mensajes emergentes';
$string['messagepopupbackgrounddesc'] = 'Configurar el color del fondo de encabezado de mensajes emergentes.';
$string['messagepopupcolor'] = 'Color del texto de mensaje emergente';
$string['messagepopupcolordesc'] = 'Seleccionar el color del encabezado del mensaje emergente.';
$string['messagingbackgroundcolor'] = 'Color del fondo de ventana principal de mensajes';
$string['messagingbackgroundcolordesc'] = 'Configurar el color del fondo de ventana principal de mensajes';
$string['mobilemenubkcolor'] = 'Color de fondo del menú para móvil';
$string['mobilemenubkcolordesc'] = 'Establece el color de fondo del menú principal en móviles (colapsado)';
$string['mobilemenufontcolor'] = 'Color del texto del menú para móvil';
$string['mobilemenufontcolordesc'] = 'Establece el color de texto del menú principal en móviles (colapsado)';
$string['mobilesettings'] = 'Configuración para dispositivos Móviles';
$string['mobilesettingsheading'] = 'Configura la plantilla para ser visualizada en dispositivos móviles.';
$string['moodledocs'] = 'Mostrar enlace a Moodle Docs';
$string['moodledocsdesc'] = 'Mostrar enlace a Moodle Docs en el pie de página.';
$string['msgbadgecolor'] = 'Color del fondo de insignia mensaje';
$string['msgbadgecolordesc'] = 'Configurar el color del fondo para la insignia / burbuja en el encabezado (muestra el número de mensajes sin leer)';
$string['myblogs'] = 'Mis Blogs';
$string['mycoursesmenulimit'] = 'Límite de Menú de Mis Cursos';
$string['mycoursesmenulimitdesc'] = 'Ajustar el número máximo de cursos que aparecen en el menú desplegable de Mis Cursos. 0 mostrará todos los cursos.';
$string['mysites'] = 'Mis Cursos';
$string['mysitesdisabled'] = 'Deshabilitar';
$string['mysitesexclude'] = 'Habilitar excluir cursos ocultos';
$string['mysitesinclude'] = 'Habilitar incluir cursos ocultos';
$string['mysitesmaxlength'] = 'Longitud Máxima de Mis Cursos';
$string['mysitesmaxlengthdesc'] = 'Ajuste la longitud máxima de coursenames (nombres_de_los_cursos) en el desplegable de Mis Cursos para optimizar su tipo de letra (font).';
$string['mysitesmenudisplay'] = 'Mostrar Menú de Mis Cursos';
$string['mysitesmenudisplaydesc'] = 'Elegir cual texto a mostrar para un ítem del menú y al pasarle el ratón encima.';
$string['mysitesmenudisplayfullnamefullnameonhover'] = 'Mostrar título completo del curso y título completo al pasar el ratón encima.';
$string['mysitesmenudisplayfullnamenohover'] = 'Mostrar título completo del curso y sin texto al pasar el ratón encima.';
$string['mysitesmenudisplayshortcodefullnameonhover'] = 'Mostrar código corto y nombre completo del curso al pasar el ratón encima.';
$string['mysitesmenudisplayshortcodenohover'] = 'Mostrar código corto y sin texto al pasar el ratón encima.';
$string['mysitessortoverride'] = 'Habilitar Ordenamiento Personalizado de Mis Cursos';
$string['mysitessortoverridedesc'] = 'Use campos personalizados del perfil o cadenas de caracteres genéricas (year, etc) para colapsar los cursos pasados en el sub-menú.';
$string['mysitessortoverridefield'] = 'Campo(s) Personalizado del Perfil o Cadenas de Caracteres de Mis Cursos';
$string['mysitessortoverridefielddesc'] = 'Lista delimitada por comas de campos de perfil o cadena de caracteres para revisar dentro de los códigos cortos (nombres cortos) de curso';
$string['mysitessortoverrideoff'] = 'Mostrar todos los cursos inscritos en lista plana única';
$string['mysitessortoverrideprofilefields'] = 'Mostrar cursos encontrados en campos de perfil en la lista primeramente, los demás en sub-menú.';
$string['mysitessortoverrideprofilefieldscohort'] = 'Mostrar cursos encontrados en campos de perfil + cohortes enlista primeramente, los demás en sub-menú';
$string['mysitessortoverridestrings'] = 'Mostrar inscritos que contengan cadenas de caracteres primeramente en lista, otros en sub-menú';
$string['navbarcachetime'] = 'Tiempo de Caché de Barra-de-Navegación';
$string['navbarcachetimedesc'] = 'El número de minutos que es cacheada la Barra-de-navegación';
$string['navbardesc'] = 'Controlar los diferentes elementos a mostrar en la barra de navegación.';
$string['navbardisplayicons'] = 'Mostrar íconos';
$string['navbardisplayiconsdesc'] = 'Mostrar íconos junto a los encabezados del menú principal';
$string['navbardisplaysubmenuarrow'] = 'Mostrar flecha de sub-menú';
$string['navbardisplaysubmenuarrowdesc'] = 'Mostrar flecha de sub-menú (que apunta hacia abajo) cuando un encabezado del menú tenga opciones de sub-menú.';
$string['navbardropdownborderradius'] = 'Radio del borde del menú desplegable';
$string['navbardropdownborderradiusdesc'] = 'Controla el radio del borde para los menúes desplegables (por ejemplo las esquinas redondeadas).';
$string['navbardropdownhovercolor'] = 'Color al pasar el ratón encima el menú desplegable';
$string['navbardropdownhovercolordesc'] = 'Color del menú desplegable al pasar el ratón encima sobre de ítems del menú.';
$string['navbardropdowntransitiontime'] = 'Tiempo de transición de Barra de Navegación';
$string['navbardropdowntransitiontimedesc'] = 'Tiempo de efecto de transiciónde Barra de Navegación. Proporciona un efecto de animación de desvanecimiento al pasar el ratón encima sobre un menú que tenga sub-menúes.';
$string['navbarmenusettings'] = 'Menú Navegación';
$string['navbarmenusettingsdesc'] = 'Añadir menús en la barra de navegación.';
$string['navbarmenusettingsheading'] = 'Personalizar el menú en la Barra de Navegacióm. Vea el diseño <a href="./../theme/adaptable/pix/layout.png" target="_blank"> aquí</a>';
$string['navbarsettings'] = 'Barra de navegación';
$string['navbarsettingsheading'] = 'Personalizar la barra de navegación';
$string['newmenu'] = 'Menú superior desplegable';
$string['newmenu1trigger'] = 'Palabra clave para el Menú desplegable superior';
$string['newmenu1triggerdesc'] = 'Establece una palabra clave para el Menú desplegable superior. Puedes utilizar los iconos de Font Awesome.';
$string['newmenu2trigger'] = 'Palabra clave para el Menú desplegable superior';
$string['newmenu2triggerdesc'] = 'Establece la palabra clave para el Menú desplegable superior Set a Top Menu Dropdown 2 trigger word.';
$string['newmenudesc'] = 'Configurar los enlaces mostrados bajo el menú de la cabecera superior.';
$string['newmenufield'] = 'Campo Personalizado  del Perfil Nombre=Valor (opcional)';
$string['newmenufielddesc'] = 'Añade una regla de acceso usando un campo personalizado del perfil . Ejemplo: "usertype=student"';
$string['newmenuheading'] = 'Menu superior';
$string['newmenurequirelogin'] = 'Requiere Ingresar';
$string['newmenurequirelogindesc'] = 'Si está activado este menú será visible a los usuarios ingresados al sitio';
$string['newmenutitle'] = 'Título menú superior';
$string['newmenutitledefault'] = 'Menú';
$string['newmenutitledesc'] = 'El título del menú aparecerá en la cabecera del sitio';
$string['newstickercount'] = 'Número de secciones en el tablón de anuncios';
$string['newstickercountdesc'] = 'Define el número de multiples secciones de anuncios basadas en campos de perfil de usuario personalizados.';
$string['nextsection'] = 'Sección Siguiente';
$string['noenrolments'] = 'No se encontraron inscripciones';
$string['nostyle'] = 'Sin estilo';
$string['notanswered'] = 'No contestado';
$string['notattempted'] = 'No intentado';
$string['notcontributed'] = 'No contribuído';
$string['notsubmitted'] = 'No enviado';
$string['overdue'] = 'Retrasado';
$string['pageheaderheight'] = 'Altura del encabezado de Página';
$string['pageheaderheightdesc'] = 'Configurar la altura del área del encabezado principal (que contiene Logo y Títulos)';
$string['passwordplaceholder'] = 'Contraseña';
$string['pastcourses'] = 'Cursos Anteriores';
$string['people'] = 'Participantes';
$string['piwikenabled'] = 'Habilitado';
$string['piwikenableddesc'] = 'Habilitar monitoreo Matomo para Moodle';
$string['piwikimagetrack'] = 'Monitoreo de Imagen';
$string['piwikimagetrackdesc'] = 'Habilitar Monitoreo de Imagen para Moodle para los navegadores con JavaScript deshabilitado.';
$string['piwiksettings'] = 'Análisis Matomo (anteriormente Piwik)';
$string['piwiksettingsdesc'] = 'Generar URL limpia para monitoreo avanzado.';
$string['piwiksettingsheading'] = 'Configurar Matomo';
$string['piwiksiteid'] = 'ID del sitio';
$string['piwiksiteiddesc'] = 'Ingrese su ID del sitio';
$string['piwiksiteurl'] = 'URL de Matomo';
$string['piwiksiteurldesc'] = 'Ingrese su URL de Matomo Analytics sin  http(s) ni la diagonal final';
$string['piwiktrackadmin'] = 'Monitoreando Admins';
$string['piwiktrackadmindesc'] = 'Habilitar monitoreo de usuarios Admins (no recomendado)';
$string['pluginname'] = 'Adaptable';
$string['previoussection'] = 'Sección Anterior';
$string['privacy:metadata'] = 'Adaptable no almacena ningún dato del usuario individual.';
$string['properties'] = 'Configuraciones para Importar / Exportar';
$string['propertiesdesc'] = 'En esta sección Usted puede importar las configuraciones (propiedades) actuales del tema Adaptable  en formato JSON. También puede Usted ver todas las configuraciones actuales en esta intalación Moodle.';
$string['propertiesexport'] = 'Exportar propiedades como una cadena de caracteres JSON';
$string['propertiesproperty'] = 'Propiedad';
$string['propertiesreturn'] = 'Retornar';
$string['propertiessub'] = 'Configuraciones actuales del tema';
$string['propertiesvalue'] = 'Valor';
$string['putpropertiesadded'] = 'Añadido:';
$string['putpropertieschanged'] = 'Cambiado:';
$string['putpropertiesdesc'] = 'Pegar la cadena de caracteres JSON y \'Guardar cambios\'. Advertencia: No valida los valores de configuraciones y realiza un proceso de \'Purgar todas las cachés\'.';
$string['putpropertiesfrom'] = 'desde';
$string['putpropertiesheading'] = 'Importar configuraciones del tema';
$string['putpropertiesignorecti'] = 'Ignorando todas las configuraciones de imagen del título del curso.';
$string['putpropertiesignored'] = 'Ignorado:';
$string['putpropertiesname'] = 'Importar propiedades';
$string['putpropertiesreportfiles'] = 'Recuerde subir los siguientes archivos a sus configuraciones:';
$string['putpropertiessettingsreport'] = 'Reporte de configuraciones:';
$string['putpropertiesunchanged'] = 'Sin-cambios:';
$string['putpropertiesvalue'] = '->';
$string['putpropertyour'] = 'Nuestra(s)';
$string['putpropertyproperties'] = 'Propiedades';
$string['putpropertyreport'] = 'Reporte:';
$string['putpropertyversion'] = 'versión:';
$string['region-course-bottom-a'] = 'Botón de página de curso región 5';
$string['region-course-bottom-b'] = 'Botón de página de curso región 6';
$string['region-course-bottom-c'] = 'Botón de página de curso región 7';
$string['region-course-bottom-d'] = 'Botón de página de curso región 8';
$string['region-course-section-a'] = 'Región del fondo de fin de actividad de página del curso';
$string['region-course-top-a'] = 'Región superior de página de curso 1';
$string['region-course-top-b'] = 'Región superior de página de curso 2';
$string['region-course-top-c'] = 'Región superior de página de curso 3';
$string['region-course-top-d'] = 'Región superior de página de curso 4';
$string['region-frnt-footer'] = 'Pie';
$string['region-frnt-market-a'] = 'Región de página 1';
$string['region-frnt-market-b'] = 'Región de página 2';
$string['region-frnt-market-c'] = 'Región de página 3';
$string['region-frnt-market-d'] = 'Región de página 4';
$string['region-frnt-market-e'] = 'Región de página 5';
$string['region-frnt-market-f'] = 'Región de página 6';
$string['region-frnt-market-g'] = 'Región de página 7';
$string['region-frnt-market-h'] = 'Región de página 8';
$string['region-frnt-market-i'] = 'Región de página 9';
$string['region-frnt-market-j'] = 'Región de página 10';
$string['region-frnt-market-k'] = 'Región de página 11';
$string['region-frnt-market-l'] = 'Región de página 12';
$string['region-frnt-market-m'] = 'Región de página 13';
$string['region-frnt-market-n'] = 'Región de página 14';
$string['region-frnt-market-o'] = 'Región de página 15';
$string['region-frnt-market-p'] = 'Región de página 16';
$string['region-frnt-market-q'] = 'Región de página 17';
$string['region-frnt-market-r'] = 'Región de página 18';
$string['region-frnt-market-s'] = 'Región de página 19';
$string['region-frnt-market-t'] = 'Región de página 20';
$string['region-middle'] = 'Centro';
$string['region-news-slider-a'] = 'Región del delizador de página de curso';
$string['region-side-post'] = 'Derecha';
$string['region-side-pre'] = 'Izquierda';
$string['regionmaincolor'] = 'Color de región principal';
$string['regionmaincolordesc'] = 'Configurar el color de fondo para el área principal de contenido';
$string['rendereroverlaycolor'] = 'Color superpuesto';
$string['rendereroverlaycolordesc'] = 'El color superpuesto sobre el bloque de curso cuando "Mosaicos Superpuestos" está seleccionado.';
$string['rendereroverlayfontcolor'] = 'Color de texto en la superposición';
$string['rendereroverlayfontcolordesc'] = 'El color de la fuente cuando pasa el cursor por encima del bloque del curso y "Mosaicos Superpuestos" está activado.';
$string['reopened'] = 'Reabierto';
$string['rightblocks'] = 'Lado derecho';
$string['savebuttontext'] = 'Guardar cambios';
$string['searchboxpadding'] = 'Separación de caja de búsqueda';
$string['searchboxpaddingdesc'] = 'Configurar la separación de la caja de búsqueda superior (si se usa en lugar de los íconos sociales) <br />Por ejemplo 5px 10px 5px 10px (superior, derecha, inferior, izquierda).<br> Usted puede configurar íconos sociales bajo la página de configuraciones de <a href="./../admin/settings.php?section=theme_adaptable_social">Redes Sociales</a>.';
$string['searchcourses'] = 'Buscar Cursos';
$string['sectionheadingcolor'] = 'Color de fondo de la cabecera de sección';
$string['sectionheadingcolordesc'] = 'Establece el color de fondo de la cabecera del tema actual.';
$string['selectionbackground'] = 'Color de fondo de selección';
$string['selectionbackgrounddesc'] = 'Configurar el color del fondo cuando es seleccionado un texto en la pantalla.';
$string['selectiontext'] = 'Color de texto de selección';
$string['selectiontextdesc'] = 'Configurar el color del texto cuando es seleccionado un texto en la pantalla.';
$string['settingsalertbox'] = 'Alertas';
$string['settingsanalytics'] = 'Análisis';
$string['settingsblockicons'] = 'Íconos';
$string['settingsborders'] = 'Bordes';
$string['settingsbreadcrumbcolors'] = 'Colores de la Ruta de Navegación';
$string['settingscolors'] = 'Colores';
$string['settingsfonts'] = 'Tipos de letras (fonts)';
$string['settingsfootercolors'] = 'Colores del pie de página';
$string['settingsforumheading'] = 'Foro';
$string['settingsheadercolors'] = 'Colores cabecera';
$string['settingsinfoboxcolors'] = 'Colores cuadro informativo principal';
$string['settingsmaincolors'] = 'Colores principales';
$string['settingsmarketingcolors'] = 'Colores bloques moodle';
$string['settingsmenucolors'] = 'Colores menú';
$string['settingsmessagescolors'] = 'Colores de Mensajes Emergentes';
$string['settingsmobilemenucolors'] = 'Colores menú móvil';
$string['settingsnavbarcolors'] = 'Colores de la Barra de Navegación (navbar)';
$string['settingsoverlaycolors'] = 'Colores bloques cursos';
$string['settingssecondinfoboxcolors'] = 'Colores cuadro informativo secundario';
$string['settingstopicsweeks'] = 'Tópicos / semanas';
$string['show'] = 'Mostrar';
$string['showblocks'] = 'Mostrar bloques';
$string['showfooterblocks'] = 'Mostrar bloques en el pie de página';
$string['showfooterblocksdesc'] = 'Mostrar / Ocultar los bloques personalizables del pie de página.';
$string['showyourprogress'] = 'Mostrar etiqueta de \'Su Progreso\'';
$string['showyourprogressdesc'] = 'Mostrar / ocultar la etiqueta de \'Su Progreso\' en la parte superior del contenido del curso. Esta etiqueta es solamente para fines informativos y puede ser ocultada.';
$string['side-post1'] = 'barra lateral en pie de página';
$string['sitetitle'] = 'Mostrar título del sitio';
$string['sitetitlecoursesdisabled'] = 'Deshabilitado - mostrar solamente títulos de curso en páginas de cursos';
$string['sitetitlecoursesenabled'] = 'Habilitado -  mostrar título del sitio y títulos de cursos en páginas de curso';
$string['sitetitlecustom'] = 'Usar título personalizado del sitio (escribir en el campo inferior para  texto)';
$string['sitetitledefault'] = 'Usar el título del sitio Moodle (nombre del sitio)';
$string['sitetitledesc'] = 'Mostrar el título del sitio Moodle por defecto desde <a href="./../admin/settings.php?section=frontpagesettings" target="_blank">Configuraciones de la Portada</a> o ingresar un título personalizado del sitio en la caja de texto inferior. Si Usted añade una imagen de logo entonces no se mostrará el título.';
$string['sitetitlemaxwidth'] = 'Ancho Máximo de Título del Sitio';
$string['sitetitlemaxwidthdesc'] = 'Configurar el Ancho Máximo de Título del Sitio';
$string['sitetitleoff'] = 'Deshabiliar el título del sitio';
$string['sitetitlepaddingleft'] = 'Separación izquierda Título del Sitio';
$string['sitetitlepaddingleftdesc'] = 'Configurar la separación a la izquierda del  Título del Sitio para ajustar su posición';
$string['sitetitlepaddingtop'] = 'Separación superior Título del Sitio';
$string['sitetitlepaddingtopdesc'] = 'Configurar la separación arriba del  Título del Sitio para ajustar su posición';
$string['sitetitletext'] = 'Título del sitio';
$string['sitetitletextdesc'] = 'El título del sitio mostrado en la cabecera. Usted puede usar cualquier tag (marca) HTML y aplicar estilos en-línea. Se recomienda que añada una marca HTML h1 alrededor del título, en lugar de la marca p que es añadida por defecto cuando Usted escribe algo en este campo.';
$string['slider2h3bgcolor'] = 'Color del fondo del deslizador 2 H3';
$string['slider2h3bgcolordesc'] = 'Elegir el color del fondo que desee para la marca del deslizador 2 H3';
$string['slider2h3color'] = 'Color del texto del deslizador 2 H3';
$string['slider2h3colordesc'] = 'Elija el color del texto que desee para la marca del deslizador 2 H3';
$string['slider2h4bgcolor'] = 'Color del Fondo Deslizador 2 H4';
$string['slider2h4bgcolordesc'] = 'Elija el color del fondo que desee para la marca del deslizador 2 H4';
$string['slider2h4color'] = 'Color del Texto Deslizador 2 H4';
$string['slider2h4colordesc'] = 'Elija el color del texto que desee para la marca del deslizador 2 H4';
$string['slidercaption'] = 'Subtítulo del deslizador';
$string['slidercaptiondesc'] = 'Añada un subttítulo para su diapositiva';
$string['slidercount'] = 'Número de deslizadores';
$string['slidercountdesc'] = 'Seleccionar cuantas dispositivas quiere añadir <strong>y después GUARDAR</strong> para cargar los campos a ingresar';
$string['sliderenabled'] = 'Habilitar deslizador';
$string['sliderenableddesc'] = 'Habilitar un deslizador en la parte superior de su página inicial';
$string['sliderfullscreen'] = 'Presentación de diapositivas en ancho completo';
$string['sliderfullscreendesc'] = 'Muestra la presentación de diapositivas en todo el ancho de la pantalla.';
$string['sliderh3color'] = 'Color del Deslizador 1 H3';
$string['sliderh3colordesc'] = 'Elegir el color que desea para la marca del deslizador 1 H3';
$string['sliderh4color'] = 'Color del Deslizador 1 H4';
$string['sliderh4colordesc'] = 'Elegir el color que desea para la marca del deslizador 1 H4';
$string['sliderimage'] = 'Imagen del deslizador';
$string['sliderimagedesc'] = 'Añadir una imagen a su diapositiva. El tamaño recomendado es 1600 pixeles x 400 pixeles o mayor.';
$string['slidermarginbottom'] = 'Margen inferior de la presentación de diapositivas';
$string['slidermarginbottomdesc'] = 'Establece el margen inferior de la presentación de diapositivas.';
$string['slidermargintop'] = 'Margen superior de la presentación de diapositivas';
$string['slidermargintopdesc'] = 'Establece el margen superior de la presentación de diapositivas.';
$string['slideroption2'] = 'Elegir Tipo de Deslizador';
$string['slideroption2a'] = 'Color de fondo de las flechas de la presentación de diapositivas tipo 2';
$string['slideroption2adesc'] = 'Configura el color de fondo de las flechas de la presentación de diapositivas usando el segundo estilo.';
$string['slideroption2color'] = 'Color de fondo del envío del Deslizador 2';
$string['slideroption2colordesc'] = 'Configura el color de fondo del texto del envío en la opción del estilo del Deslizador';
$string['slideroption2desc'] = 'Elija el tipo de Deslizador <strong>y después haga clic en GUARDAR</strong> para ver la configuración de colores de su deslizador elegido';
$string['slideroption2snippet'] = '<p>HTML  de muestra para Subtítulos del Deslizador:</p>
<pre>
<div class="span6 col-sm-6">
<h3>Hecho-a-mano</h3> <h4>pixeles y código para la comunidad Moodle</h4>
<a href="#" class="submit">¡ Por favor ponga \'favorito\' a nuestro tema !</a>
</pre>';
$string['slideroption2submitcolor'] = 'Fondo de Envío de Deslizador 2';
$string['slideroption2submitcolordesc'] = 'Configurar un color de fondo para el texto aenviar en el color 2 de opción de estilo de deslizador';
$string['sliderstyle1'] = 'Deslizador estilo 1';
$string['sliderstyle2'] = 'Deslizador estilo 2';
$string['slidersubmitbgcolor'] = 'Fondo de Envío de Deslizador 1';
$string['slidersubmitbgcolordesc'] = 'Elegir el color del fondo del botón para envío del Deslizador 1';
$string['slidersubmitcolor'] = 'Texto para Envío de Deslizador 1';
$string['slidersubmitcolordesc'] = 'Elegir el color del texto del botón para envío del Deslizador 1';
$string['sliderurl'] = 'URL de enlace de Diapositiva';
$string['sliderurldesc'] = 'Añada una URL a la cual enlazará su diapositiva cuando le haga clic.';
$string['slideshowdesc'] = 'Sube imagenes, añade enlaces y descripciones en las dispositivas de la presentación de la página de inicio.';
$string['slideshowsettings'] = 'Presentación de diapositivas';
$string['slideshowsettingsheading'] = 'Personaliza el carusel de imágenes en la portada. Vea el diseño <a href="./../theme/adaptable/pix/layout.png" target="_blank"> aquí</a>';
$string['socialboxpaddingbottommobile'] = 'Establece la separación superior del bloque de iconos sociales';
$string['socialboxpaddingtopmobile'] = 'Separación superior del bloque de iconos sociales';
$string['socialheading'] = 'Configuración de los iconos de redes sociales';
$string['socialicondesc'] = 'Configurar ícono de Font Awesome como por ejemplo: fa-facebook';
$string['socialiconlist'] = 'Lista de íconos sociales';
$string['socialiconlistdesc'] = 'Introducir una lista delimitada para configurar los enlaces / iconos de redes sociales que necesites usando el formato: url|titulo|ícono';
$string['socialorsearch'] = 'Usar Caja de Búsqueda o Íconos sociales';
$string['socialorsearchdesc'] = 'Usted puede configurar el tema para que muestre, ya sea íconos sociales o una caja para búsqueda en el encabezado. <br />
Usted puede configurar los íconos sociales debajo de la<a href="./../admin/settings.php?section=theme_adaptable_social">Header Social</a> spágina de configuraciones</strong>.';
$string['socialorsearchnone'] = 'Ninguno';
$string['socialorsearchsearch'] = 'Mostrar caja de búsqueda en encabezado';
$string['socialorsearchsocial'] = 'Mostrar íconos sociales en encabezado';
$string['socialpaddingtop'] = 'Ajustar la separación debajo los iconos sociales (altera la posición vertical)';
$string['socialsearchicon'] = 'Buscar en Moodle';
$string['socialsearchicondesc'] = 'Habilitar para poner un enlace hacia búsqueda junto a los íconos sociales (porque al usar social se deshabilita la caja de busqueda en todo-el-sitio)';
$string['socialsettings'] = 'Redes sociales';
$string['socialsize'] = 'Configurar tamaño de los íconos sociales';
$string['socialsizemobile'] = 'Configurar tamaño de los íconos sociales en móviles';
$string['socialtarget'] = 'Formato de apertura de la ventana de enlaces sociales';
$string['socialtargetdesc'] = 'Abrir la red social en la misma venta (\'\'Same Window\'\') o en una nueva ventana (\'\'New Window\'\')';
$string['socialtitledesc'] = '<pre>Puedes desactivar la caja para búsqueda en todo el sitio y activar los íconos / enlaces de redes sociales en su lugar.
Para configurar los iconos, introduce una lista delimitada en el campo "Lista de íconos sociales".
El formato debe ser:

url|titulo|ícono

Por ejemplo:

http://localhost/moodle/course/search.php|Buscar en Moodle|fa-search
http://facebook.com/|Facebook|fa-facebook-square
http://twitter.com/|Twitter|fa-twitter-square
http://instagram.com|Instagram|fa-instagram

Para referencia, el listado de íconos se puede encontrar <a href="http://fortawesome.github.io/Font-Awesome/icons/">Font Awesome Icons Aquí</a></pre>';
$string['socialwall'] = 'Pared / Muro Social (cursos)';
$string['socialwallactionlinkcolor'] = 'Color del Enlace de acción';
$string['socialwallactionlinkcolordesc'] = 'El color de los enlaces de acción en Pared Social.';
$string['socialwallactionlinkhovercolor'] = 'Color al pasar el ratón encima para el enlace de Acción';
$string['socialwallactionlinkhovercolordesc'] = 'El color de los enlaces de Acción al pasar el ratón encima en Pared Social.';
$string['socialwallbackgroundcolor'] = 'Color del fondo';
$string['socialwallbackgroundcolordesc'] = 'El color del fondo de un curso en Pared Social.';
$string['socialwallbordercolor'] = 'Color del Borde';
$string['socialwallbordercolordesc'] = 'El color del borde de secciones en Pared Social';
$string['socialwallbordertopstyle'] = 'Estilo del Borde';
$string['socialwallbordertopstyledesc'] = 'El estilo del borde de secciones en Pared Social';
$string['socialwallborderwidth'] = 'Ancho del borde';
$string['socialwallborderwidthdesc'] = 'El ancho del borde en secciones de Pared Social';
$string['socialwalldesc'] = 'Personalizar la apariencia del <a href="https://moodle.org/plugins/format_socialwall">Formato de Curso de Pared Social</a> (si se usa en su sitio)';
$string['socialwallheading'] = 'Configuraciones de Pared Social';
$string['socialwallsectionradius'] = 'Radio del Borde';
$string['socialwallsectionradiusdesc'] = 'El radio del borde de secciones en Pared Social.';
$string['standardview'] = 'Vista estándar';
$string['stickynavbar'] = 'Barra de Navegación pegajosa en la parte superior';
$string['stickynavbardesc'] = 'Pegar la Barra-de-Navegación  a la parte superior de la pantalla al deslizarse hacia abajo.';
$string['submitted'] = 'Enviado';
$string['targetnewwindow'] = 'Nueva ventana';
$string['targetsamewindow'] = 'Misma ventana';
$string['thiscourse'] = 'Este curso';
$string['ticker'] = 'Anuncios';
$string['tickerdefault'] = 'No hay anuncios para mostrar';
$string['tickerdesc'] = 'Aquí puedes configurar los anuncios de la página de inicio de tu moodle.
   Está planeada como una alternativa menos intrusiva al deslizador y que usa muy poco espacio.
   Para configurar tu anuncio simplemente ingresa una lista con viñetas e incluye cualquier hipervínculo que necesites en ese texto.
Nota: Usted no debe de poner marcas URL en su lista, solamente use marcas li; el editor de texto de Moodle tiende a añadir marcas ul.
Si su anuncio no carga apropiadamente, cambie a vista HTML y asegúrese de que solamente tenga marcas li
 <pre>
<li>Ítem de anuncio uno.....</li>
<li>Ítem de anuncio dos.....</li>
</pre>
Tip: Si no funciona lo anterior usa<pre> <p>Mi anuncio</p></li></pre>';
$string['tickerfullscreen'] = 'Ancho de Pantalla Completa';
$string['tickersettings'] = 'Anuncios';
$string['tickersettingsheading'] = 'Configurar el parpadeante de Novedades en la Portada. Vea el diseño  <a href="./../theme/adaptable/pix/layout.png" target="_blank"> aquí</a>';
$string['tickertext'] = 'Texto de Anuncios';
$string['tickertext1'] = 'Texto Anuncios 1';
$string['tickertext1desc'] = 'Añadir los anuncios en formato de lista HTML. Ver <a href="adaptable/README.txt">README.txt</a> para más información.';
$string['tickertext2'] = 'Texto Anuncios 2';
$string['tickertext2desc'] = 'Añadir los anuncios en formato de lista HTML para un segundo tipo de usuario. Ver <a href="adaptable/README.txt">README.txt</a> para más información.';
$string['tickertextdesc'] = 'Añadir texto de Anuncios en formato de lista. Vea el archivo readme para mayor información.';
$string['tickertextprofilefield'] = 'Nombre del campo personalizado del perfíl=Valor (opcional)';
$string['tickertextprofilefielddesc'] = 'Añade una regla de acceso usando un campo personalizado del perfil . Ejemplo: "usertype=student"';
$string['tickerwidth'] = 'Ancho Fijo';
$string['tickerwidthdesc'] = 'Usted puede usar esta configuración para arreglar el ancho de anuncios al máximo de 100%.';
$string['tilesbordercolor'] = 'Color del borde de los bloques de cursos';
$string['tilesbordercolordesc'] = 'Establece el color del borde de los bloques de cursos.';
$string['tilescontactstitle'] = 'Mostrar el rol de los contactos del curso';
$string['tilescontactstitledesc'] = 'Muestra / Oculta el rol del contacto en el curso. Si no se muestra, se mostrará una imagen para cada contacto.';
$string['tilesshowallcontacts'] = 'Mostrar todos los contactos del curso';
$string['tilesshowallcontactsdesc'] = 'Muestra todos los contactos del curso o solo el principal.';
$string['tilesshowcontacts'] = 'Mostrar los contactos del curso';
$string['tilesshowcontactsdesc'] = 'Muestra / Oculta los contactos del curso.';
$string['toolsmenu'] = 'Menú de herramientas desplegable';
$string['toolsmenu2'] = '2º Menu Herramientas';
$string['toolsmenu2desc'] = 'Puedes configurar los items a mostrar debajo de un menú de herramientas. Cada línea consiste en texto del menú, URL del enlace  (opcional), un título de la herramientita (opcional)  y el código de idioma o una lista de códigos separada por comas (opcional, para mostrar el item dependiendo del idioma del usuario) separado por una linea vertical (|) (AltGr + 1). También pueden añadirse sub-items usando guiones. Por ejemplo:
<pre>
Comunidad Moodle|https://moodle.org
-Soporte Moodle gratuito|https://moodle.org/support
-Moodle development|https://moodle.org/development
--Documentación de Moodle|http://docs.moodle.org|Moodle Docs
--Documentación de Moodle en español|http://docs.moodle.org/es|Documentación en español|es
Moodle.com|http://moodle.com/
</pre>';
$string['toolsmenudesc'] = 'Añade un menú desplegable en la barra de navegación.';
$string['toolsmenufield'] = 'Nombre del campo personalizado del perfíl=Valor (opcional)';
$string['toolsmenufielddesc'] = 'Añade una regla de acceso usando un campo personalizado del perfil . Ejemplo: "usertype=student"';
$string['toolsmenuheading'] = 'Menús herramientas (en la barra de navegación)';
$string['toolsmenuheadingdesc'] = 'Puedes configurar los enlaces a mostrar en el menú de herramientas (en la barra de navegación).
 este formato es similar al usado por los menús personalizados de moodle pero permite añadir los iconos Font Awesome:
<pre>
&lt;span class=&quot;fa fa-video-camera&quot;&gt;&lt;/span&gt; Record Screen|http://google.co.uk|Record Screen
&lt;span class=&quot;fa fa-picture-o&quot;&gt;&lt;/span&gt; ThinkStock|http://google.co.uk|ThinkStock
&lt;span class=&quot;fa fa-clock-o&quot;&gt;&lt;/span&gt; Exam Clock|http://google.co.uk|Exam Clock
</pre><br />';
$string['toolsmenulabel'] = 'Menu Herramientas';
$string['toolsmenulabel2'] = 'Herramientas 2';
$string['toolsmenuscount'] = 'Número de menús de herramientas';
$string['toolsmenuscountdesc'] = 'Establece el número de menús de herramientas que quieres a la barra de navegación.';
$string['toolsmenutitle'] = 'Título menú de herramientas';
$string['toolsmenutitledefault'] = 'Herramientas';
$string['toolsmenutitledesc'] = 'Añade el título a mostrar en la barra de navegación.';
$string['topicsweeks'] = 'Formato de curso Tópicos/Semanas';
$string['topicsweeksdesc'] = 'Configurar estilos para el formato de curso de Tópicos/Semanas';
$string['topmenufontsize'] = 'Tamaño del tipo de letra del Menú Superior';
$string['topmenufontsizedesc'] = 'Ajustar el tamaño del tipo de letra de los menús superiores';
$string['topmenuscount'] = 'Número de menús superiores';
$string['topmenuscountdesc'] = 'Establece el número de menús superiores que quieres añadir en la cabecera.';
$string['usernav'] = 'Usuario en encabezado';
$string['usernavdesc'] = 'Permite personalizar todos los elementos que aparecen en el menú desplegable de navegación del usuario.';
$string['usernavheading'] = 'Personaliza el menú desplegable del perfíl de usuario.';
$string['viewselect'] = 'Pantalla completa como vista por defecto';
$string['viewselectdesc'] = 'Establecer la vista por defecto a pantalla completa (cuando la opción zoom está activada)';
$string['xofyanswered'] = '{$a->completed} de {$a->participants} Contestados';
$string['xofyattempted'] = '{$a->completed} de {$a->participants} Intentados';
$string['xofycontributed'] = '{$a->completed} de {$a->participants} Contribuídos';
$string['xofysubmitted'] = '{$a->completed} de {$a->participants} Enviados';
$string['xungraded'] = '{$a} Sin-calificar';
