<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'questionnaire', language 'eu', version '3.5'.
 *
 * @package     questionnaire
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Ekintza';
$string['activityoverview'] = 'Bidali gabeko galdeketak dituzu';
$string['additionalinfo'] = 'Informazio osagarria';
$string['additionalinfo_help'] = 'Galdeketa honen lehen orriko goiko aldean erakutsiko den testua (argibideak edo testuinguruko informazioa, adibidez).';
$string['addnewquestion'] = '{$a} galdera gehitzen';
$string['addnewsection'] = 'Gehitu atal berria';
$string['addquestion'] = 'Gehitu galdera...';
$string['addquestions'] = 'Gehitu galderak';
$string['addquestiontosection'] = 'Gehitu galdera atalera';
$string['addselqtype'] = 'Gehitu aukeratutako galdera mota';
$string['alignment'] = 'Aukera bakarreko botoien lerrokadura';
$string['alignment_help'] = 'Aukeratu botoien lerrokadura: bertikala (lehenetsia) edo horizontala.';
$string['all'] = 'Guztiak';
$string['alreadyfilled'] = '{$a} galdeketa hau bete duzu. Eskerrik asko.';
$string['andaveragevalues'] = 'eta batez besteko balioak';
$string['anonymous'] = 'Anonimoa';
$string['answer'] = 'Erantzuna';
$string['answergiven'] = 'Erantzun hau eman da';
$string['answernotgiven'] = 'Erantzun hau ez da eman';
$string['answerquestions'] = 'Erantzun galderei...';
$string['answers'] = 'Erantzunak';
$string['attempted'] = 'Galdeketa bidali da.';
$string['attemptstillinprogress'] = 'Abian. Azkenengoz gordeta:';
$string['autonumbering'] = 'Auto-zenbakitzea';
$string['autonumbering_help'] = 'Galdera eta orrien zenbaketa automatikoa. Baldintzapeko adarkatzea duten galdeketetan ziur aski auto-zenbakitzea desgaitu nahiko duzu.';
$string['autonumberno'] = 'Ez zenbakitu galderak eta orriak';
$string['autonumberpages'] = 'Auto-zenbakitu orriak';
$string['autonumberpagesandquestions'] = 'Auto-zenbakitu orriak eta galderak';
$string['autonumberquestions'] = 'Auto-zenbakitu galderak';
$string['average'] = 'Batez bestekoa';
$string['averageposition'] = 'Batez besteko posizioa';
$string['averagerank'] = 'Batez besteko rankinga';
$string['bodytext'] = 'Gorputzaren testua';
$string['boxesnbexact'] = 'zehazki {$a} laukitxo.';
$string['boxesnbmax'] = '{$a} laukitxo gehienez.';
$string['boxesnbmin'] = '{$a} laukitxo gutxienez.';
$string['boxesnbreq'] = 'Galdera honentzako hurrengo kopurua markatu behar duzu:';
$string['by'] = 'egilea:';
$string['cannotviewpublicresponses'] = 'Ezin duzu galdeketa publiko honen erantzunik ikusi.';
$string['chart:bipolar'] = 'Barra bipolarrak';
$string['chart:hbar'] = 'Barra horizontalak';
$string['chart:radar'] = 'Radar';
$string['chart:rose'] = 'Arrosa';
$string['chart:type'] = 'Grafiko mota';
$string['chart:type_help'] = 'Aukeratu feedback honetan erabili nahi duzun grafiko mota';
$string['chart:vprogress'] = 'Aurrerapen-barra bertikala';
$string['checkallradiobuttons'] = 'Egiaztatu mesedez <strong>{$a}</strong> aukera bakarreko botoiak!';
$string['checkboxes'] = 'Aukera anitzeko laukitxoak';
$string['checkboxes_help'] = 'Idatzi erabiltzaileak aukeratu ahalko duen aukera bat errenkada bakoitzean.';
$string['checkbreaksadded'] = 'Orri-salto berria(k) gehitu dira hurrengo kokapene(t)an:';
$string['checkbreaksok'] = 'Beharrezkoak diren orri-salto guztiak prest daude!';
$string['checkbreaksremoved'] = '{$a} orri-salto gehigarri ezabatu dira.';
$string['checknotstarted'] = 'Aukeratu hasi gabekoak';
$string['checkstarted'] = 'Aukeratu hasitakoak';
$string['clicktoswitch'] = '(egin klik aldatzeko)';
$string['closed'] = 'Galdeketa hau {$a} itxi zen. Eskerrik asko.';
$string['closeson'] = 'Galdeketa {$a} ixten da';
$string['completionsubmit'] = 'Ikasleak galdeketa bidali behar du osatutzat emateko';
$string['condition'] = 'Baldintza';
$string['confalts'] = '- EDO - <br />Berrespen-orria';
$string['configmaxsections'] = 'Feedback-erako gehienezko atal kopurua';
$string['configusergraph'] = 'Erakutsi "Nortasun Proba" feedbackaren grafikoak';
$string['configusergraphlong'] = 'Erabili <a href="http://www.rgraph.net/">Rgraph</a> liburutegia "Nortasun Proba" feedbackaren grafikoak erakusteko.';
$string['confirmdelallresp'] = 'Ziur zaude galdeketa honetako galdera GUZTIAK ezabatu nahi dituzula?';
$string['confirmdelchildren'] = 'Galdera hau ezabatzen baduzu, bere menpeko galdera(k) ere ezabatuko dira:';
$string['confirmdeletesection'] = 'Ziur zaude "{$a}" feedback-atala ezabatu nahi duzula?';
$string['confirmdelgroupresp'] = 'Ziur zaude {$a}(e)ko erantzun GUZTIAK ezabatu nahi dituzula?';
$string['confirmdelquestion'] = 'Ziur zaude {$a}. kokapeneko galdera ezabatu nahi duzula?';
$string['confirmdelquestionresps'] = 'Honek galdera honi emandako {$a} erantzunak ere ezabatuko du.';
$string['confirmdelresp'] = 'Ziur zaude {$a} erabiltzaileak emandako erantzuna ezabatu nahi duzula?';
$string['confirmremovequestion'] = 'Ziur zaude "{$a->sname}" ataleko "{$a->qname}" galdera ezabatu nahi duzula?';
$string['confpage'] = 'Goiburuko testua';
$string['confpage_help'] = 'Erabiltzaile batek galdeketa hau osatzen duenean erakusten den Berrespen-orriko goiburua (letra lodiz) eta testuaren gorputza. URLa egotekotan berrespen-testuarekiko lehentasuna izango du. Eremu hau hutsik utziz gero galdeketa-osaketarako lehenetsitako mezu bat erakutsiko da (Eskerrik asko galdeketa hau erantzuteagatik).';
$string['confpagedesc'] = 'Erabiltzaile batek galdeketa hau osatzen duenean erakusten den &quot;Berrespen-orriko&quot; goiburua (letra lodiz) eta testuaren gorputza. URLa egotekotan berrespen-testuarekiko lehentasuna izango du.';
$string['contentoptions'] = 'Edukiaren aukerak';
$string['couldnotcreatenewsurvey'] = 'Ezin izan da galdeketa berri bat sortu!';
$string['couldnotdelresp'] = 'Ezin izan da erantzuna ezabatu';
$string['createcontent'] = 'Zehaztu eduki berria';
$string['createcontent_help'] = 'Hautatu aukera bakarreko botoiaren aukeretako bat. \'Sortu berria\' da lehenetsitakoa.';
$string['createnew'] = 'Sortu berria';
$string['crontask'] = 'Galdeketaren garbiketa-ataza';
$string['date'] = 'Data';
$string['date_help'] = 'Erabili ezazu galdera-mota hau erantzuna data-formatu egokian jasotzea espero baduzu.';
$string['deleteallresponses'] = 'Ezabatu erantzun GUZTIAK';
$string['deletecurrentquestion'] = 'Ezabatu {$a} galdera';
$string['deletedallgroupresp'] = '{$a} ataleko erantzun GUZTIAK ezabatu dira';
$string['deletedallresp'] = 'Galdeketako erantzunak ezabatu dira';
$string['deletedisabled'] = 'Elementu hau ezin da ezabatu';
$string['deletedresp'] = 'Ezabatutako Erantzuna';
$string['deleteresp'] = 'Ezabatu erantzun hau';
$string['deletesection'] = 'Ezabatu atal hau';
$string['deletingresp'] = 'Erantzuna ezabatzen';
$string['dependencies'] = 'Menpekotasunak';
$string['dependquestion'] = 'Goragoko galdera';
$string['dependquestion_help'] = 'Galdera honentzako goragoko galdera bat eta eta hautatze-aukera bat aukeratu dezakezu. Menpeko galdera bat soilik erakutsiko zaio ikasleari goragoko galdera eta bertako hautatze-aukera aukeratzen bada.';
$string['didnotrespondtoquestion'] = 'Ez diozu galderari erantzun';
$string['directwarnings'] = 'Galdera honekiko menpekotasun zuzenak ezabatuko dira. Honek hurrengoei eragingo die:';
$string['displaymethod'] = 'Ez da zehaztu galdera honentzako erakuste-metodorik.';
$string['download'] = 'Jaitsi';
$string['dropdown'] = 'Kutxa zabalgarria';
$string['dropdown_help'] = 'Ez dago kutxa zabalgarria erabiltzeagatiko onura handirik Aukera Bakarreko botoia erabiltzearekin alderatuta, ez bada aukera-zerrenda luzeetan pantailako leku pixka bat aurreztea.';
$string['edit'] = 'Editatu';
$string['editingfeedback'] = 'Feedbackaren ezarpenak editatzen';
$string['editingquestionnaire'] = 'Galdeketaren ezarpenak editatzen';
$string['editquestion'] = '{$a} galdera editatzen';
$string['email'] = 'Helbide elektronikoa';
$string['errnewname'] = 'Sentitzen dugu, izen hori dagoeneko erabilia dago. Aukeratu ezazu beste izen bat.';
$string['erroropening'] = 'Errorea galdeketa irekitzean.';
$string['errortable'] = 'Errorea: sistemako taula kaltetuta dago.';
$string['essaybox'] = 'Entsegua';
$string['essaybox_help'] = 'Galdera honek testu lauko eremu bat erakusten du testu-eremuko x zutabeekin (eremuaren zabalera) eta y testu-eremuko y errenkadekin (testu-lerro kopurua).

Biak (x eta y) lehenetsitako 0 balioarekin utziz gero, Moodleren HTML editorea erakutsiko da lehenetsitako altuera eta zabalerarekin (ikastaro/erabiltzaile testuinguruan eta erabiltzaile-profilean eskuragarri badago).';
$string['event_all_responses_deleted'] = 'Erantzun guztiak ezabatu dira';
$string['event_all_responses_saved_as_text'] = 'Erantzun guztiak testu gisa gorde dira';
$string['event_all_responses_viewed'] = 'Erantzun guztien txostena ikusi da';
$string['event_individual_responses_viewed'] = 'Banakako erantzunen txostena ikusi da';
$string['event_non_respondents_viewed'] = 'Erantzuna eman ez dutenak ikusi da';
$string['event_previewed'] = 'Galdeketa aurreikusi da';
$string['event_question_created'] = 'Galdera sortu da';
$string['event_question_deleted'] = 'Galdera ezabatu da';
$string['event_response_deleted'] = 'Banakako erantzuna ezabatu da';
$string['event_resumed'] = 'Saiakerarekin jarraitu da';
$string['event_saved'] = 'Erantzuna gorde da';
$string['event_submitted'] = 'Erantzuna bidali da';
$string['feedback'] = 'Feedbacka';
$string['feedback_help'] = 'Feedback Laguntza';
$string['feedbackaddmorefeedbacks'] = 'Gehitu {no} feedback-eremu gehiago';
$string['feedbackbysection'] = 'Feedbacka-atalak';
$string['feedbackdefaultlabel'] = '[Atal berria]';
$string['feedbackeditingglobal'] = 'Galdeketako feedback orokorra editatzen';
$string['feedbackeditingmessages'] = 'Galdeketako feedback-mezuak editatzen';
$string['feedbackeditingsections'] = 'Galdeketako feedback-atalak editatzen';
$string['feedbackeditmessages'] = 'Gorde atalen ezarpenak eta editatu feedback-mezuak';
$string['feedbackeditsections'] = 'Gorde ezarpenak eta editatu feedback-atalak';
$string['feedbackerrorboundaryformat'] = 'Feedback-puntuazioen mugak ehunekoak ala zenbakiak izan behar dira. Zuk idatzitako {$a} mugaren balioa ez da baliozkoa.';
$string['feedbackerrorboundaryoutofrange'] = 'Feedback-puntuazioen mugak %0 eta %100 artekoak izan behar dira. Zuk idatzitako {$a} mugaren balioa tarte horretatik kanpo dago.';
$string['feedbackerrorjunkinboundary'] = 'Feedback-puntuazioaren muga hutsunerik utzi gabe bete behar duzu.';
$string['feedbackerrorjunkinfeedback'] = 'Feedback-kutxak hutsunerik utzi gabe bete behar dituzu.';
$string['feedbackerrororder'] = 'Feedback-puntuazioen mugak ordenatuta egon behar dira, handienetik txikienera. Zuk idatzitako {$a} mugaren balioa sekuentziatik kanpo dago.';
$string['feedbackglobal'] = 'Feedback Orokorra';
$string['feedbackglobalheading'] = 'Feedback Orokorraren goiburua';
$string['feedbackglobalmessages'] = 'Feedback Orokorraren mezuak';
$string['feedbackhdr'] = 'Feedbackak';
$string['feedbackheading'] = 'Feedbackaren goiburua';
$string['feedbackheading_help'] = 'Feedback-goiburuaren eremuan 2 aldagai erabili ditzakezu: $scorepercent eta $oppositescorepercent.';
$string['feedbackmessages'] = '{$a}. ataleko mezuak';
$string['feedbacknextsection'] = 'Hurrengo {$a}. atala';
$string['feedbacknone'] = 'Ez dago feedback-mezurik';
$string['feedbacknotes'] = 'Feedback-oharrak';
$string['feedbacknotes_help'] = 'Hemen idatzitako testua ikasleei Feedback txostenaren amaieran erakutsiko zaie.';
$string['feedbackoptions'] = 'Feedback aukerak';
$string['feedbackoptions_help'] = 'Feedback aukerak eskuragarri daude zure galdeketak hurrengo galdera-motak eta galdera-ezarpenak baditu:
Aukera bakarreko botoiak, Kutxa zabalgarria, Bai/Ez edo Baloratu (normala edo Osgood eskala). Galdera horiek Beharrezko gisa konfiguratu behar dira, euren galdera-izenaren eremua EZIN da hutsik egon eta erantzun posibleen aukerak balioren bat izan behar dute.';
$string['feedbackremovequestionfromsection'] = 'Galdera hau [{$a}]. feedback-atalaren parte da';
$string['feedbackremovesection'] = 'Galdera hau ezabatzeak  [{$a}]. feedback-atala guztiz ezabatuko du';
$string['feedbackreport'] = 'Feedback Txostena';
$string['feedbackscore'] = 'Feedback-puntuazioa';
$string['feedbackscoreboundary'] = 'Feedback-puntuazioen muga';
$string['feedbackscores'] = 'Erakutsi Puntuazioak';
$string['feedbackscores_help'] = 'Erakutsi feedback-puntuazioen taula';
$string['feedbacksection'] = 'Atala';
$string['feedbacksectionheading'] = '{$a}. atalaren goiburua';
$string['feedbacksectionheadingmissing'] = 'Feedback-atal honentzako Goiburua idatzi behar duzu!';
$string['feedbacksectionheadingtext'] = 'Goiburua';
$string['feedbacksectionlabel'] = 'Etiketa';
$string['feedbacksectionlabel_help'] = 'Etiketa hau grafiko/diagrametan erabiliko da. Saiatu zaitez laburra izaten!';
$string['feedbacksectionquestions'] = '{$a}. ataleko galderak';
$string['feedbacksections'] = 'Feedback-atalak';
$string['feedbacksectionsselect'] = 'Atalak';
$string['feedbacksectionsselect_help'] = 'Kokatu zure galderak atal horietan';
$string['feedbacksettingssaved'] = 'Feedback ezarpenak gorde dira';
$string['feedbacktype'] = 'Feedback-mota';
$string['field'] = '{$a} galdera';
$string['fieldlength'] = 'Sarbide-kutxaren luzera';
$string['fieldlength_help'] = '**Testu-kutxa** galdera motarentzat, zehaztu **sarrera-kutxaren luzera** eta erantzunetako **testuaren gehienezko luzera**.

Testu-kutxaren luzera lehenetsia 20 karaktere dira eta erantzunetako testuaren gehienezko luzera 25 karaktere.';
$string['finished'] = 'Galdeketako galdera guztiak erantzun dituzu!';
$string['firstrespondent'] = 'Lehen erantzuna';
$string['formateditor'] = 'HTML editorea';
$string['formatplain'] = 'Testu laua';
$string['grade'] = 'Bidalketaren kalifikazioa';
$string['gradesdeleted'] = 'Galdeketaren kalifikazioak ezabatu dira';
$string['headingtext'] = 'Goiburuaren testua';
$string['horizontal'] = 'Horizontala';
$string['id'] = 'IDa';
$string['includechoicecodes'] = 'Gehitu aukeren kodeak';
$string['includechoicetext'] = 'Gehitu aukeren testua';
$string['includeincomplete'] = 'Gehitu osatu gabeko erantzunak';
$string['incorrectcourseid'] = 'Ikastaroaren IDa baliogabea da';
$string['incorrectmodule'] = 'Ikastaro-moduluaren IDa baliogabea da';
$string['incorrectquestionnaire'] = 'Galdeketa ez da zuzena';
$string['indirectwarnings'] = 'Zerrenda honek zeharkako menpeko galderak eta menpekotasun zuzeneko galderentzat geratzen diren menpekotasunak erakusten ditu:';
$string['invalidresponse'] = 'Zehaztutako erantzuna baliogabea da.';
$string['invalidresponserecord'] = 'Zehaztutako erantzun-erregistroa baliogabea da.';
$string['invalidsectionid'] = 'Feedback-atal baliogabea zehaztu da.';
$string['invalidsurveyid'] = 'Galdeketaren ID baliogabea.';
$string['kindofratescale'] = 'Balorazio-eskala mota';
$string['kindofratescale_help'] = 'Egin klik eskuineko botoiarekin azpiko Laguntza Gehiago estekan.';
$string['lastrespondent'] = 'Azken erantzuna';
$string['length'] = 'Luzera';
$string['managequestions'] = 'Kudeatu galderak';
$string['managequestions_help'] = 'Editatu galderak orriko Kudeatu galderak atalean galdeketako galderetako hainbat ekintza egin ditzakezu.';
$string['mandatory'] = 'Derrigorrezkoa - Menpekotasun hauek guztiak bete behar dira.';
$string['maxdigitsallowed'] = 'Gehienez baimendutako digituak';
$string['maxdigitsallowed_help'] = 'Erabili **Gehienez baimendutako digituak** zenbakizko galderan erantzun daitekeen zenbakiaren digitu kopurua mugatzeko. Kontuan izan hamartarren koma banatzailearen karakterea ere kontuan hartzen dela!';
$string['maxforcedresponses'] = 'Gehienezko erantzun kopurua';
$string['maxforcedresponses_help'] = 'Parametro hauek erabili itzazu erantzunean aukeratu daitezkeen **gutxienezko** laukitxo kopurua eta **gehienezko** laukitxo kopurua behartzeko. Kopuru zehatz bat aukeratzea behartzeko **gutxienezko** eta **gehienezko** eremuetan balio berdina jarri ezazu. Gutxienezko edo gehienezko kopurua soilik zehazteko utzi ezazu beste parametroan lehenetsitako **0** balioa utzi ezazu. **Gutxienezko** eta **gehienezko** balioetan **0** ez den balio bat zehazten baduzu erantzutean baldintza betetzen ez duten erabiltzaileei ohar-mezu bat erakutsiko zaie. Baldintza hauek zure galdeketako argibide orokorretan edo galderaren testuan argi utzi beharko dituzu, noski.';
$string['maxtextlength'] = 'Testuaren gehienezko luzera';
$string['maxtextlength_help'] = 'Testu-kutxa galdera motarentzat, zehaztu sarrera-kutxaren luzera eta erantzunetako testuaren gehienezko luzera.

Testu-kutxaren luzera lehenetsia 20 karaktere dira eta erantzunetako testuaren gehienezko luzera 25 karaktere.';
$string['messageprovider:message'] = 'Galdeketaren gogorarazpena';
$string['messageprovider:notification'] = 'Galdeketaren bidalketa';
$string['minforcedresponses'] = 'Gutxienezko erantzun kopurua';
$string['minforcedresponses_help'] = 'Parametro hauek erabili itzazu erantzunean aukeratu daitezkeen **gutxienezko** laukitxo kopurua eta **gehienezko** laukitxo kopurua behartzeko. Kopuru zehatz bat aukeratzea behartzeko **gutxienezko** eta **gehienezko** eremuetan balio berdina jarri ezazu. Gutxienezko edo gehienezko kopurua soilik zehazteko utzi ezazu beste parametroan lehenetsitako **0** balioa utzi ezazu. **Gutxienezko** eta **gehienezko** balioetan **0** ez den balio bat zehazten baduzu erantzutean baldintza betetzen ez duten erabiltzaileei ohar-mezu bat erakutsiko zaie. Baldintza hauek zure galdeketako argibide orokorretan edo galderaren testuan argi utzi beharko dituzu, noski.';
$string['misconfigured'] = 'Ikastaroa gaizki konfiguratuta dago';
$string['missingname'] = '{$a} galdera ezin da feedback-atal honetan erabili ez duelako izenik.';
$string['missingnameandrequired'] = '{$a} galdera ezin da feedback-atal honetan erabili ez duelako izenik eta ez delako derrigorrezkoa.';
$string['missingrequired'] = '{$a} galdera ezin da feedback-atal honetan erabili ez delako derrigorrezkoa.';
$string['modulename'] = 'Galdeketa';
$string['modulename_help'] = 'Galdeketa moduluak galdera-mota ezberdinak erabilita erabiltzaileen datuak biltzeko inkestak eraikitzea ahalbidetzen du.';
$string['modulenameplural'] = 'Galdeketak';
$string['movedisabled'] = 'Elementu hau ezin da mugitu';
$string['myresponses'] = 'Zure erantzun guztiak';
$string['myresponsetitle'] = 'Zure {$a} erantzun';
$string['myresults'] = 'Zure emaitzak';
$string['name'] = 'Izena';
$string['navigate'] = 'Baimendu galdera adarkatuak';
$string['navigate_help'] = 'Gaitu zure galdeketan Bai/Ez eta aukera bakarreko botoien galderetan hautatze-aukeraren menpeko galderak izatea.';
$string['navigatetosection'] = 'Joan feedback-atalera';
$string['next'] = 'Hurrengoa';
$string['nextpage'] = 'Hurrengo orria';
$string['nlines'] = '{$a} lerro';
$string['noanswer'] = 'Erantzunik gabe';
$string['noattempts'] = 'Oraindik ez dago saiakerarik galdeketa honetan';
$string['nodata'] = 'Ez da daturik bidali.';
$string['noduplicates'] = 'Aukera bikoizturik ez';
$string['noduplicateschoiceserror'] = 'Gutxienez 2 erantzun posible eman behar dituzu "Aukera bikoizturik ez" aukerarentzat!';
$string['non_respondents'] = 'Galdeketa honetara euren erantzunak oraindik bidali ez duten erabiltzaileak';
$string['noneinuse'] = 'Galdeketa honek ez dauka galderarik.';
$string['nopublicsurveys'] = 'Ez dago galdeketa publikorik.';
$string['noresponsedata'] = 'Ez dago erantzunik galdera honentzat.';
$string['noresponses'] = 'Erantzunik ez';
$string['normal'] = 'Normala';
$string['not_started'] = 'Hasi gabea';
$string['notanumber'] = '<strong>{$a}</strong> ez da zenbakizko formatu baliagarri bat.';
$string['notapplicable'] = 'E/A';
$string['notapplicablecolumn'] = 'E/A zutabea';
$string['notavail'] = 'Galdeketa dagoeneko ez dago eskuragarri. Irakasleari ezabatzeko esan ahal diozu.';
$string['noteligible'] = 'Ezin duzu galdeketa hau erantzun.';
$string['notemplatesurveys'] = 'Galdeketa-txantiloirik ez.';
$string['notenoughscaleitems'] = 'Gutxienez 2 eskala-elementu sartu behar dituzu!';
$string['notificationfull'] = 'Bidalketa osoa';
$string['notifications'] = 'Bidali bidalketa-jakinarazpenak';
$string['notifications_help'] = 'Jakinarazi "mod/questionnaire:submissionnotification" baimena duten rola dutenei bidalketa bat egiten denean.';
$string['notificationsimple'] = 'Jakinarazpena soilik';
$string['notopen'] = 'Galdeketa hau ez da {$a} arte zabalduko.';
$string['notrequired'] = 'Erantzuna ez da derrigorrezkoa';
$string['notset'] = 'ezarri gabea';
$string['nousersselected'] = 'Ez da erabiltzailerik aukeratu';
$string['num'] = '#';
$string['numattemptsmade'] = 'Galdeketa honetan {$a} saiakera egin dira';
$string['numberfloat'] = 'Zuk emandako <strong>{$a->number}</strong> zenbakia <strong>{$a->precision}</strong> hamartarretara moldatu/borobildu da.';
$string['numberofdecimaldigits'] = 'Hamartar kopurua';
$string['numberofdecimaldigits_help'] = 'Erabili **Hamartar kopurua** Galdeketa-txostenaren orrian erakusten den batez besteko balioaren formatua zehazteko.';
$string['numberscaleitems'] = 'Eskala-elementu kopurua';
$string['numberscaleitems_help'] = 'Zure balorazio-eskalan erabiliko den elementu-kopurua. Normalean 3 eta 5 arteko balio bat erabili nahiko duzu. Lehenetsitako balioa: **5**.';
$string['numeric'] = 'Zenbakizkoa';
$string['numeric_help'] = 'Erabili galdera-mota hau erantzuna formatu egokia duen zenbakia izatea espero baduzu.';
$string['of'] = 'hauetatik';
$string['option'] = '{$a} aukera';
$string['optional'] = 'Aukerazkoa - menpekotasun hauetako baten bat bete behar da.';
$string['optionalname'] = 'Galderaren izena';
$string['optionalname_help'] = 'Galderaren izena erantzunak CSV/Excel formatura esportatzean baino ez da erabiltzen.
Ez badituzu erantzunak esportatzeko asmorik, ez duzu galderen izenengatik kezkatu behar.
Zure galdeketaren datuak erregularki esportatzeko asmoa baduzu, galderak izendatzeko bi aukera dituzu.';
$string['or'] = '- EDO -';
$string['order_ascending'] = 'Goranzko ordena';
$string['order_default'] = 'Ikusi lehenetsitako ordena';
$string['order_descending'] = 'Beheranzko ordena';
$string['orderresponses'] = 'Ordenatu erantzunak';
$string['orderresponses_help'] = 'Erantzun guztiak erakustean aukerak erantzun kopuruaren arabera (Batez bestea zutabea) ordenatu daitezke hurrengo 4 galdera-motetan:

* aukera bakarreko botoia
* aukera bakarreko kutxa zabalgarria
* aukera anitzekoa (laukitxoak)
* baloratu motakoak (Likert eskala barne)

Erantzun guztien orrira heltzen zarenean, modu lehenetsian erantzun guztiak galdeketaren egileak zehaztutako jatorrizko hurrenkeran erakusten dira, eta zuk goranzko edo beheranzko hurrenkeran erakutsi ahal dituzu.';
$string['osgood'] = 'Osgood';
$string['other'] = 'Beste bat:';
$string['otherempty'] = 'Aukera hau markatzen baduzu testu-kutxan testuren bat idatzi behar duzu!';
$string['overviewnumresplog'] = 'erantzunak';
$string['overviewnumresplog1'] = 'erantzuna';
$string['overviewnumrespvw'] = 'erantzunak';
$string['overviewnumrespvw1'] = 'erantzuna';
$string['owner'] = 'Jabea';
$string['page'] = 'Orria';
$string['pageof'] = '{$a->page}.a {$a->totpages} orrietatik';
$string['parent'] = 'Goragokoa';
$string['participant'] = 'Partaidea';
$string['pleasecomplete'] = 'Osatu mesedez aukera hau.';
$string['pluginadministration'] = 'Galdeketaren kudeaketa';
$string['pluginname'] = 'Galdeketa';
$string['position'] = 'kokapena';
$string['possibleanswers'] = 'Erantzun posibleak';
$string['posteddata'] = 'Bidalitako datuekin iritsitako orria:';
$string['preview_label'] = 'Aurreikusi';
$string['preview_questionnaire'] = 'Aurreikusi galdeketa';
$string['previewing'] = 'Galdeketa aurreikusten';
$string['previous'] = 'Aurrekoa';
$string['previouspage'] = 'Aurreko orria';
$string['print'] = 'Inprimatu erantzun hau';
$string['printblank'] = 'Inprimatu hutsik';
$string['printblanktooltip'] = 'Galdeketa hutsik inprimatzeko egokitutako leihoan irekitzen du';
$string['printtooltip'] = 'Galdeketa oraingo erantzunarekin inprimatzeko egokitutako leihoan irekitzen du';
$string['privacy:metadata:questionnaire_resp_multiple'] = 'Aukera anitzeko galderaren erantzuna.';
$string['privacy:metadata:questionnaire_resp_multiple:choice_id'] = 'Erantzun honetako aukera-erregistro baten IDa.';
$string['privacy:metadata:questionnaire_resp_multiple:question_id'] = 'Erantzun honen galdera-erregistroaren IDa.';
$string['privacy:metadata:questionnaire_resp_multiple:response_id'] = 'Erantzun honen erantzun-erregistroaren IDa.';
$string['privacy:metadata:questionnaire_resp_single'] = 'Aukera bakarreko galderaren erantzuna.';
$string['privacy:metadata:questionnaire_resp_single:choice_id'] = 'Erantzun honetako aukera-erregistroaren IDa.';
$string['privacy:metadata:questionnaire_resp_single:question_id'] = 'Erantzun honen galdera-erregistroaren IDa.';
$string['privacy:metadata:questionnaire_resp_single:response_id'] = 'Erantzun honen erantzun-erregistroaren IDa.';
$string['privacy:metadata:questionnaire_response'] = 'Abian edo bidalita dagoen erantzuna';
$string['privacy:metadata:questionnaire_response:complete'] = 'Erantzunaren osaketaren egoera.';
$string['privacy:metadata:questionnaire_response:grade'] = 'Erantzunaren kalifikazioa.';
$string['privacy:metadata:questionnaire_response:questionnaireid'] = 'Erantzun honen galdeketa-erregistroaren IDa.';
$string['privacy:metadata:questionnaire_response:submitted'] = 'Erantzun hau azkenengoz gorde zeneko unea.';
$string['privacy:metadata:questionnaire_response:userid'] = 'Erantzun honen erabiltzailearen IDa.';
$string['privacy:metadata:questionnaire_response_bool'] = 'Galdera boolearraren (bai/ez) erantzuna.';
$string['privacy:metadata:questionnaire_response_bool:choice_id'] = 'Erantzunaren boolear zehatza';
$string['privacy:metadata:questionnaire_response_bool:question_id'] = 'Erantzun honen galdera-erregistroaren IDa.';
$string['privacy:metadata:questionnaire_response_bool:response_id'] = 'Erantzun honen erantzun-erregistroaren IDa.';
$string['privacy:metadata:questionnaire_response_date'] = 'Data-galderaren erantzuna.';
$string['privacy:metadata:questionnaire_response_date:question_id'] = 'Erantzun honen galdera-erregistroaren IDa.';
$string['privacy:metadata:questionnaire_response_date:response'] = 'Data-erantzun zehatza.';
$string['privacy:metadata:questionnaire_response_date:response_id'] = 'Erantzun honen erantzun-erregistroaren IDa.';
$string['privacy:metadata:questionnaire_response_other'] = '\'beste bat\' aukeraren testuzko erantzuna.';
$string['privacy:metadata:questionnaire_response_other:choice_id'] = 'The ID of the choice record for this response';
$string['privacy:metadata:questionnaire_response_other:question_id'] = 'Erantzun honen galdera-erregistroaren IDa.';
$string['privacy:metadata:questionnaire_response_other:response'] = 'Testuzko erantzun zehatza.';
$string['privacy:metadata:questionnaire_response_other:response_id'] = 'Erantzun honen erantzun-erregistroaren IDa.';
$string['privacy:metadata:questionnaire_response_rank'] = 'Galderaren erantzunen rankinga.';
$string['privacy:metadata:questionnaire_response_rank:choice_id'] = 'The ID of the choice record for this response';
$string['privacy:metadata:questionnaire_response_rank:question_id'] = 'Erantzun honen galdera-erregistroaren IDa.';
$string['privacy:metadata:questionnaire_response_rank:rankvalue'] = 'Ranking-erantzun zehatza.';
$string['privacy:metadata:questionnaire_response_rank:response_id'] = 'Erantzun honen erantzun-erregistroaren IDa.';
$string['privacy:metadata:questionnaire_response_text'] = 'Testuzko galderaren erantzuna.';
$string['privacy:metadata:questionnaire_response_text:question_id'] = 'Erantzun honen galdera-erregistroaren IDa.';
$string['privacy:metadata:questionnaire_response_text:response'] = 'Testuzko erantzun zehatza.';
$string['privacy:metadata:questionnaire_response_text:response_id'] = 'Erantzun honen erantzun-erregistroaren IDa.';
$string['private'] = 'Pribatua';
$string['public'] = 'Publikoa';
$string['publiccopy'] = 'Kopia:';
$string['publicoriginal'] = 'Jatorrizkoa:';
$string['qtype'] = 'Mota';
$string['qtype_help'] = 'Aukeratu erabiltzaileek behin, egunero, astero, hilabetero edo mugarik gabe erantzun ahalko duten.';
$string['qtypedaily'] = 'eguneroko erantzuna';
$string['qtypemonthly'] = 'hilabeteroko erantzuna';
$string['qtypeonce'] = 'erantzun bakarra';
$string['qtypeunlimited'] = 'mugarik gabeko erantzunak';
$string['qtypeweekly'] = 'asteroko erantzuna';
$string['questionnaire:addinstance'] = 'Gehitu galdeketa berri bat';
$string['questionnaire:copysurveys'] = 'Kopiatu txantiloia eta galdeketa pribatuak';
$string['questionnaire:createpublic'] = 'Sortu galdeketa publikoak';
$string['questionnaire:createtemplates'] = 'Sortu galdeketa-txantiloiak';
$string['questionnaire:deleteresponses'] = 'Ezabatu erantzun guztiak';
$string['questionnaire:downloadresponses'] = 'Jaitsi erantzunak CSV fitxategian';
$string['questionnaire:editquestions'] = 'Sortu eta editatu galdeketaren galderak';
$string['questionnaire:manage'] = 'Sortu eta editatu galdeketak';
$string['questionnaire:message'] = 'Bidali mezua erantzuna eman ez dutenei';
$string['questionnaire:preview'] = 'Aurreikusi galdeketak';
$string['questionnaire:printblank'] = 'Inprimatu galdeketa hutsik';
$string['questionnaire:readallresponseanytime'] = 'Irakurri erantzun guztiak edonoiz';
$string['questionnaire:readallresponses'] = 'Irakurri erantzunen laburpena, gaia eta irekitze-datak';
$string['questionnaire:readownresponses'] = 'Irakurri norbere erantzunak';
$string['questionnaire:submissionnotification'] = 'Jaso bidalketa bakoitzeko jakinarazpena';
$string['questionnaire:submit'] = 'Osatu eta bidali galdeketa';
$string['questionnaire:view'] = 'Ikusi galdeketa';
$string['questionnaire:viewsingleresponse'] = 'Ikusi banakako erantzun osoak';
$string['questionnaireadministration'] = 'Galdeketen kudeaketa';
$string['questionnairecloses'] = 'Galdeketaren hasiera-data';
$string['questionnaireopens'] = 'Galdeketaren itxiera-data';
$string['questionnairereport'] = 'Galdeketaren txostena';
$string['questionnum'] = '# galdera';
$string['questions'] = 'Galderak';
$string['questionsinsection'] = 'Atal honetako galderak:';
$string['questiontypes'] = 'Galdera motak';
$string['questiontypes_help'] = 'Ikusi Moodleko dokumentazioa azpian';
$string['radiobuttons'] = 'Aukera bakarreko botoiak';
$string['radiobuttons_help'] = 'Galdera-mota honetan erantzuten duenak emandako aukeretatik bakarra aukeratu behar du.';
$string['rank'] = 'Rankinga';
$string['ratescale'] = 'Baloratu (1etik 5erako eskala)';
$string['ratescale_help'] = 'Ikusi Moodleko dokumentazioa azpian';
$string['realm'] = 'Galdeketa mota';
$string['realm_help'] = '* **Hiru galdeketa mota dago:**
 * Pribatua - sortu den ikastaroan baino ez dago.
 * Txantiloia - kopiatua eta editatua izan daiteke.
 * Publikoa - hainbat ikastarok partekatu dezakete.';
$string['redirecturl'] = 'Galdeketa hau amaitzean erabiltzaileari bideratuko zaion URLa.';
$string['remove'] = 'Ezabatu';
$string['removeallquestionnaireattempts'] = 'Ezabatu galdeketako erantzun guztiak';
$string['removenotinuse'] = 'Galdeketa hau ezabatua izan den galdeketa publiko baten menpekoa zen. Dagoeneko ezin da erabili eta ezabatu beharko litzateke.';
$string['required'] = 'Erantzuna derrigorrezkoa da';
$string['required_help'] = '***Bai*** aukeratzen baduzu galdera honi erantzutea derrigorrezkoa izango da, eta beraz galdera honi erantzun arte erabiltzaileek ezingo dute galdeketa bidali.';
$string['requiredparameter'] = 'Derrigorrezko parametro bat falta da';
$string['reset'] = 'Berrabiarazi';
$string['respeligiblerepl'] = '(rol-baliogabetzeekin ordezkatua)';
$string['respondent'] = 'Erantzuna eman duena';
$string['respondenteligibleall'] = 'guztiak';
$string['respondenteligiblestudents'] = 'ikasleek soilik';
$string['respondenteligibleteachers'] = 'irakasleek soilik';
$string['respondents'] = 'Erantzuna eman dezakatenak';
$string['respondenttype'] = 'Erantzun dezaketenen motak';
$string['respondenttype_help'] = 'Erantzun bakoitzarekin batera erabiltzaileen izen osoak erakutsi ahal dituzu "izen osoa" aukeratuta. Erantzunen egileen identitatea ezkutatu dezakezu hemen "anonimoa" aukeratuta.';
$string['respondenttypeanonymous'] = 'anonimoa';
$string['respondenttypefullname'] = 'izen osoa';
$string['response'] = 'Erantzuna';
$string['responsefieldlines'] = 'Sarbide-kutxaren tamaina';
$string['responseformat'] = 'Erantzunaren formatua';
$string['responseoptions'] = 'Erantzunen aukerak';
$string['responses'] = 'Erantzunak';
$string['responseview'] = 'Ikasleek erantzun GUZTIAK ikusi ditzakete';
$string['responseview_help'] = 'Bidalitako galdeketen erantzun guztiak ikusi ahal dutenak zehaztu dezakezu (estatistika orokorreko taulak).';
$string['responseviewstudentsalways'] = 'Beti';
$string['responseviewstudentsnever'] = 'Inoiz ez';
$string['responseviewstudentswhenanswered'] = 'Galdeketa erantzun ondoren';
$string['responseviewstudentswhenclosed'] = 'Galdeketa itxita dagoenean';
$string['restrictedtoteacher'] = 'Funtzio hauek soilik edizio baimenak dituzten irakasleentzat dira!';
$string['resume'] = 'Gorde/Jarraitu erantzunak';
$string['resume_help'] = 'Ezarpen honek erabiltzaileei euren erantzunak galdeketa bidali gabe gordetzea ahalbidetzen du. Erabiltzaileek galdeketa amaitu gabe utzi dezakete eta beranduago utzi zuten moduan jarraitu dezakete.';
$string['resumesurvey'] = 'Jarraitu galdeketarekin';
$string['return'] = 'Itzuli';
$string['save'] = 'Gorde';
$string['saveasnew'] = 'Gorde galdera berri gisa';
$string['savedbutnotsubmitted'] = 'Galdeketa hau gordeta baina oraindik bidali gabe dago.';
$string['savedprogress'] = 'Zure aurrerapena gorde da. Beranduago galdeketa amaitzera itzuli zaitezke.';
$string['saveeditedquestion'] = 'Gorde {$a} galdera';
$string['savesettings'] = 'Gorde ezarpenak';
$string['search:activity'] = 'Galdeketa - jardueraren informazioa';
$string['search:question'] = 'Galdeketa - galderak';
$string['section'] = 'Deskribapena';
$string['sectionbreak'] = '----- Orri-saltoa -----';
$string['sectionbreak_help'] = '----- Orri-saltoa -----';
$string['sectionsnotset'] = 'Atal bakoitzean gutxienez galdera BAT aukeratu behar duzu!<br />Aukeratu gabeko atalak: {$a}';
$string['sectiontext'] = 'Etiketa';
$string['sectiontext_help'] = 'Hau ez da galdera bat galdera sorta bat aurkezteko erakutsiko den testu (laburra) baizik.';
$string['selecttheme'] = 'Aukeratu galdeketa honetan erabiltzeko azal bat (css)';
$string['send'] = 'Bidali';
$string['send_message'] = 'Bidali mezua aukeratutako erabiltzaileei';
$string['send_message_to'] = 'Bidali mezua hurrengoei:';
$string['sendemail'] = 'Bidali e-maila';
$string['set'] = 'zehaztuta';
$string['settings'] = 'Ezarpenak';
$string['settingssaved'] = 'Ezarpenak gorde dira';
$string['show_nonrespondents'] = 'Erantzuna eman ez dutenak';
$string['started'] = 'hasita';
$string['strfdate'] = '%Y/%m/%d';
$string['strfdateformatcsv'] = 'Y/m/d H:i:s';
$string['subject'] = 'Gaia';
$string['submissionnotificationhtmlanon'] = '<a href="{$a->submissionurl}">Bidalketa</a> berri bat dago "{$a->name}" galdeketan.';
$string['submissionnotificationhtmluser'] = '<a href="{$a->profileurl}">{$a->username}</a> erabiltzaileak <a href="{$a->submissionurl}">bidalketa</a> berria egin du "{$a->coursename}" ikastaroko  "{$a->name}" galdeketan.';
$string['submissionnotificationsubject'] = 'Galdeketa-bidalketa berria';
$string['submissionnotificationtextanon'] = 'Bidalketa berri bat dago ({$a->submissionurl}) "{$a->name}" galdeketan.';
$string['submissionnotificationtextuser'] = '{$a->username} ({$a->profileurl}) erabiltzaileak bidalketa berria egin du ({$a->submissionurl}) "{$a->coursename}" ikastaroko  "{$a->name}" galdeketan.';
$string['submitoptions'] = 'Bidalketaren aukerak';
$string['submitpreview'] = 'Aurreikusi bidalketa';
$string['submitpreviewcorrect'] = 'Bidalketa hau modu egokian osatutako gisa onartuko da.';
$string['submitsurvey'] = 'Bidali galdeketa';
$string['submitted'] = 'Bidalketa-data:';
$string['subtitle'] = 'Azpiizenburua';
$string['subtitle_help'] = 'Galdeketaren azpiizenburua.';
$string['summary'] = 'Laburpena';
$string['surveynotexists'] = 'galdeketa ez da existitzen.';
$string['surveyowner'] = 'Ekintza hau burutzeko galdeketaren jabea izan behar zara.';
$string['surveyresponse'] = 'Galdeketaren erantzuna';
$string['template'] = 'Txantiloia';
$string['templatenotviewable'] = 'Galdeketa-txantiloiak ez dira ikusgarriak.';
$string['text'] = 'Galderaren testua';
$string['textareacolumns'] = 'Testu-eremuko zutabeak';
$string['textareacolumns_help'] = 'Galdera honek testu lauko eremu bat erakusten du testu-eremuko **x** *zutabeekin* (eremuaren *zabalera*) eta **y** testu-eremuko **y** *errenkadekin* (testu-*lerro* kopurua).

Biak (x eta y) lehenetsitako **0** balioarekin utziz gero, Moodleren HTML editorea erakutsiko da lehenetsitako altuera eta zabalerarekin (ikastaro/erabiltzaile testuinguruan eta erabiltzaile-profilean eskuragarri badago).';
$string['textarearows'] = 'Testu-eremuko errenkadak';
$string['textbox'] = 'Testu-kutxa';
$string['textbox_help'] = 'Testu-kutxa galdera motarentzat, zehaztu sarrera-kutxaren luzera eta erantzunetako testuaren gehienezko luzera.

Testu-kutxaren luzera lehenetsia 20 karaktere dira eta erantzunetako testuaren gehienezko luzera 25 karaktere.';
$string['textdownloadoptions'] = 'CSV deskargarako aukerak';
$string['thank_head'] = 'Eskerrik asko galdeketa hau betetzeagatik.';
$string['theme'] = 'Azala';
$string['thismonth'] = 'hilabete honetan';
$string['thisresponse'] = 'Erantzun hau';
$string['thisweek'] = 'aste honetan';
$string['thousands'] = 'Ez erabili milakoen banatzailerik';
$string['title'] = 'Izenburua';
$string['title_help'] = 'Galdeketa honen izenburua, orri guztien goiko aldean erakutsiko dena. Modu lehenetsian izenburua galdeketaren izena da, baina nahi izanez gero editatu dezakezu.';
$string['today'] = 'gaur';
$string['total'] = 'Guztira';
$string['totalofnumbers'] = 'Idatzitako zenbakiak guztira';
$string['totalresponses'] = 'Galderaren erantzunak guztira';
$string['type'] = 'Galdera mota';
$string['undefinedquestiontype'] = 'Zehaztu gabeko galdera-mota!';
$string['unknown'] = 'Ezezaguna';
$string['unknownaction'] = 'Galdeketa-ekintza ezezaguna zehaztu da...';
$string['url'] = 'Berrespen URLa';
$string['url_help'] = 'Galdeketa hau amaitzean erabiltzaileari bideratuko zaion URLa.';
$string['useprivate'] = 'Kopiatu dagoena';
$string['usepublic'] = 'Erabili publikoa';
$string['usetemplate'] = 'Erabili txantiloia';
$string['vertical'] = 'Bertikala';
$string['view'] = 'Ikusi';
$string['viewallresponses'] = 'Ikusi erantzun guztiak';
$string['viewallresponses_help'] = 'Galdeketako **talde-moduan** *Taldeek elkar ikusten dute* aukeratuta badago edo *Taldeek ezin dute elkar ikusi* aukeratuta badago eta oraingo erabiltzaileak *moodle/site:accessallgroups* baimena badauka (oraingo testuinguruan), eta oraingo ikastaroan taldeak badaude, erabiltzaileak taldea aukeratzeko zerrenda ikusi ahalko du. Zerrenda honek galdeketako erantzunak taldearen arabera iragazteko aukera ematen du.
**Talde-moduan** *Taldeek ezin dute elkar ikusi* aukeratuta badago, *moodle/site:accessallgroups* baimena ez duten erabiltzaileek (normalean ikasleak edo edizio-baimenik gabeko irakasleak) kide diren taldeko erantzunak baino ezingo dituzte ikusi.';
$string['viewbyresponse'] = 'Erantzunen zerrenda';
$string['viewindividualresponse'] = 'Banakako erantzunak';
$string['viewindividualresponse_help'] = 'Egin klik azpiko zerrendan erantzuna eman dutenen izenetan euren banakako erantzunak ikusteko.';
$string['viewresponses'] = 'Erantzun guztiak ({$a})';
$string['viewyourresponses'] = 'Zure erantzunak - ikusi {$a}';
$string['warning'] = 'Oharra, errorea gertatu da.';
$string['wronganswers'] = 'Zure erantzunak arazoren bat dauka (ikusi azpian)';
$string['wrongdateformat'] = 'Idatzitako <strong>{$a}</strong> data ez dator bat adibidearen formatuarekin.';
$string['wrongdaterange'] = 'ERROREA: Urtea 1902 eta 2037 tartean egon behar da.';
$string['wrongformat'] = 'Hurrengo galderari zuk emandako erantzunak arazoren bat dauka:&nbsp;';
$string['wrongformats'] = 'Hurrengo galderari zuk emandako erantzunak arazoren bat dauka:&nbsp;';
$string['yesno'] = 'Bai/Ez';
$string['yesno_help'] = 'Bai/Ez motako galdera sinplea';
$string['yourresponse'] = 'Zure erantzuna';
$string['yourresponses'] = 'Zure erantzunak';
