<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'diary', language 'pt', version '3.5'.
 *
 * @package     diary
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessdenied'] = 'Acesso negado';
$string['alias'] = 'Palavra-chave';
$string['aliases'] = 'Palavras-chave';
$string['aliases_help'] = 'Cada entrada do diário pode ter uma lista de palavras-chave associada (ou sinónimos).

Insira cada palavra-chave numa nova linha (não separada por vírgulas).';
$string['alwaysopen'] = 'Sempre aberto';
$string['attachment'] = 'Anexo';
$string['attachment_help'] = 'Pode opcionalmente anexar um ou mais ficheiros a uma entrada do diário.';
$string['blankentry'] = 'Entrada em branco';
$string['calendarend'] = 'Fecha {$a}';
$string['calendarstart'] = 'Abre {$a}';
$string['configdateformat'] = 'Define como as datas são mostradas nos relatórios dos diários. O valor predefinido, "M d, Y G: i" corresponde ao mês, dia, ano e formato de hora de 24 horas. Consulte Date no manual do PHP para mais exemplos e constantes de data predefinidas.';
$string['created'] = 'Criada há {$a->one} dias e {$a->two} horas atrás.';
$string['csvexport'] = 'Exportar para .csv';
$string['currententry'] = 'Entradas atuais do diário';
$string['dateformat'] = 'Formato de data predefinido';
$string['daysavailable'] = 'Dias disponíveis';
$string['daysavailable_help'] = 'Se estiver a usar o formato Semanal, pode definir quantos dias o diário está aberto para uso.';
$string['deadline'] = 'Dias aberto';
$string['details'] = 'Detalhes:';
$string['diary:addentries'] = 'Adicionar entradas no diário';
$string['diary:addinstance'] = 'Adicionar instâncias de Registo diário';
$string['diary:manageentries'] = 'Gerir entradas do diário';
$string['diary:rate'] = 'Avaliar entradas do diário';
$string['diaryclosetime'] = 'Fecho';
$string['diaryclosetime_help'] = 'Se ativar esta opção, pode definir uma data/hora para o diário ser fechado e deixar de estar aberto para uso.';
$string['diarydescription'] = 'Descrição do diário';
$string['diaryentrydate'] = 'Definir a data para esta entrada';
$string['diarymail'] = 'Olá {$a->user},<br />
{$a->teacher} publicou algum feedback na sua entrada no diário \'{$a->diary}\'.

Pode vê-lo anexado à sua entrada no diário:

    {$a->url}';
$string['diarymailhtml'] = 'Olá {$a->user},<br />
{$a->teacher} publicou algum feedback na sua entrada no diário \'<i>{$a->diary}</i>\'.<br /><br />
Pode vê-lo anexado à sua <a href="{$a->url}">entrada no diário</a>.';
$string['diaryname'] = 'Nome';
$string['diaryopentime'] = 'Abertura';
$string['diaryopentime_help'] = 'Se ativar esta opção, pode definir uma data/hora para o diário ser aberto para uso.';
$string['editall'] = 'Editar todas as entradas';
$string['editall_help'] = 'Se ativar esta opção, os utilizadores podem editar qualquer entrada.';
$string['editdates'] = 'Editar datas da entrada';
$string['editdates_help'] = 'Se ativar esta opção, os utilizadores podem editar a data de qualquer entrada.';
$string['editingended'] = 'O período de edição já terminou';
$string['editingends'] = 'O período de edição termina';
$string['editthisentry'] = 'Editar esta entrada';
$string['edittopoflist'] = 'Editar o topo da lista';
$string['entries'] = 'Entradas';
$string['entry'] = 'Entrada';
$string['entrybgc_colour'] = '#93FC84';
$string['entrybgc_descr'] = 'Define a cor de fundo de uma entrada/feedback do diário.';
$string['entrybgc_title'] = 'Cor de fundo de uma entrada/feedback do diário';
$string['entrycomment'] = 'Comentário da entrada';
$string['entrytextbgc_colour'] = '#93FC84';
$string['entrytextbgc_descr'] = 'Define a cor do texto de uma entrada do diário.';
$string['entrytextbgc_title'] = 'Cor do texto de uma entrada do diário';
$string['eventdiarycreated'] = 'Diário criado';
$string['eventdiarydeleted'] = 'Diário apagado';
$string['eventdiaryviewed'] = 'Diário visualizado';
$string['eventdownloadentriess'] = 'Descarregar entradas';
$string['evententriesviewed'] = 'Entradas do diário visualizadas';
$string['evententrycreated'] = 'Entradas do diário criadas';
$string['evententryupdated'] = 'Entradas do diário atualizadas';
$string['eventfeedbackupdated'] = 'Feedback do diário atualizado';
$string['exportfilename'] = 'entradas.csv';
$string['exportfilenamep1'] = 'Todo_Site';
$string['exportfilenamep2'] = '_Entradas_Diario_Exportadas_';
$string['feedbackupdated'] = 'Feedback de {$a} entradas atualizado';
$string['firstentry'] = 'Primeiras entradas do diário';
$string['format'] = 'Formato';
$string['generalerror'] = 'Ocorreu um erro.';
$string['generalerrorinsert'] = 'Não foi possível inserir uma nova entrada no diário.';
$string['generalerrorupdate'] = 'Não foi possível atualizar o seu diário.';
$string['gradeingradebook'] = 'Avaliação atual na pauta';
$string['highestgradeentry'] = 'Entradas com melhor avaliação';
$string['incorrectcourseid'] = 'ID da disciplina está incorreto';
$string['incorrectmodule'] = 'O ID do módulo da disciplina estava incorreto';
$string['lastnameasc'] = 'Apelido ascendente';
$string['lastnamedesc'] = 'Apelido descendente';
$string['latestmodifiedentry'] = 'Entradas modificadas mais recentemente';
$string['lowestgradeentry'] = 'Entradas com pior avaliação';
$string['mailed'] = 'Enviadas por e-mail';
$string['mailsubject'] = 'Feedback do diário';
$string['modulename'] = 'Registo diário';
$string['modulename_help'] = 'A atividade Registo diário permite que os professores obtenham feedback dos alunos durante um determinado período de tempo.';
$string['modulenameplural'] = 'Registos diários';
$string['needsgrading'] = 'Esta entrada ainda não recebeu feedback ou avaliação.';
$string['needsregrade'] = 'Esta entrada foi alterada desde que foi lhe dado feedback ou avaliação.';
$string['newdiaryentries'] = 'Novas entradas no diário';
$string['nextentry'] = 'Nova entrada';
$string['nodeadline'] = 'Sempre aberto';
$string['noentriesmanagers'] = 'Não existem professores';
$string['noentry'] = 'Nenhuma entrada';
$string['noratinggiven'] = 'Sem avaliação';
$string['notopenuntil'] = 'Este diário apenas abrirá';
$string['notstarted'] = 'Registo diário não iniciado';
$string['outof'] = '&nbsp;de {$a} entradas.';
$string['overallrating'] = 'Avaliação global';
$string['pagesize'] = 'Entradas por página';
$string['pluginadministration'] = 'Administração do Registo diário';
$string['pluginname'] = 'Registo diário';
$string['previousentry'] = 'Entrada anterior';
$string['rate'] = 'Avaliarar';
$string['rating'] = 'Avaliação desta entrada';
$string['reload'] = 'Recarregar e mostrar da entrada do diário atual à mais antiga';
$string['removeentries'] = 'Remover todas as entradas';
$string['removemessages'] = 'Remover todas as entradas do Registo diário';
$string['reportsingle'] = 'Obter todas as entradas do Registo diário para este utilizador.';
$string['reportsingleallentries'] = 'Todas as entradas do Registo diário para este utilizador.';
$string['returnto'] = 'Voltar para {$a}';
$string['returntoreport'] = 'Voltar para a página do relatório de - {$a}';
$string['saveallfeedback'] = 'Guardar todos os meus comentários';
$string['savesettings'] = 'Guardar configurações';
$string['search'] = 'Procurar';
$string['search:activity'] = 'Registo diário - informação da atividade';
$string['search:entry'] = 'Registo diário - entradas';
$string['search:entrycomment'] = 'Registo diário - comentário da entrada';
$string['selectentry'] = 'Selecionar uma entrada';
$string['showoverview'] = 'Mostrar visão global do registo diário no meu painel do utilizador';
$string['showrecentactivity'] = 'Mostrar a atividade recente';
$string['sortcurrententry'] = 'Da entrada atual até à primeira entrada do diário';
$string['sortfirstentry'] = 'Da primeira à última entrada do diário';
$string['sorthighestentry'] = 'Da entrada com avaliação mais alta até à entrada com avaliação mais baixa.';
$string['sortlastentry'] = 'Da entrada modificada mais recentemente até à entrada modificada há mais tempo.';
$string['sortlowestentry'] = 'Da entrada com classificação mais baixa até à mais alta.';
$string['sortoptions'] = 'Opções de ordenação';
$string['sortorder'] = '<h5>Ordem de classificação:</h5>';
$string['startnewentry'] = 'Iniciar uma nova entrada';
$string['startoredit'] = 'Iniciar nova ou editar a entrada de hoje';
$string['teacher'] = 'Professor';
$string['text'] = 'Texto';
$string['timecreated'] = 'Criação';
$string['timemarked'] = 'Avaliação';
$string['timemodified'] = 'Modificação';
$string['toolbar'] = 'Barra de ferramentas:';
$string['userid'] = 'ID do utilizador';
$string['usertoolbar'] = 'Barra de ferramentas do utilizador:';
$string['viewalldiaries'] = 'Todos os registos diários da disciplina';
$string['viewallentries'] = 'Ver {$a} entradas';
$string['viewentries'] = 'Visualizar entradas';
