<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'admin', language 'pt', version '3.5'.
 *
 * @package     admin
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessdenied'] = 'Acesso negado';
$string['accounts'] = 'Contas';
$string['addcategory'] = 'Adicionar uma categoria';
$string['additionalhtml'] = 'HTML Adicional';
$string['additionalhtml_desc'] = 'Estas configurações permitem indicar código HTML que será incluído em todas as páginas do site. É possível especificar código HTML que será adicionado dentro da secção HEAD da página, no início da secção BODY ou no final desta secção.<br />Desta forma é possível adicionar cabeçalhos e rodapés personalizados em qualquer página, bem como configurar aplicações como o Google Analytics de forma fácil, independente do tema que estiver em utilização.';
$string['additionalhtml_heading'] = 'HTML adicional que será incluído em todas as páginas';
$string['additionalhtmlfooter'] = 'Antes da secção BODY ser fechada';
$string['additionalhtmlfooter_desc'] = 'Este conteúdo será adicionado no final da secção BODY de todas as páginas.';
$string['additionalhtmlhead'] = 'Antes da secção HEAD ser fechada';
$string['additionalhtmlhead_desc'] = 'Este conteúdo será adicionado no final da secção HEAD de todas as páginas.';
$string['additionalhtmltopofbody'] = 'Quando a secção BODY é aberta';
$string['additionalhtmltopofbody_desc'] = 'Este conteúdo será adicionado no início da secção BODY de todas as páginas.';
$string['admincategory'] = 'Categoria: {$a}';
$string['adminseesall'] = 'Administradores veem todos os eventos';
$string['adminseesallevents'] = 'Os administradores veem todos os eventos';
$string['adminseesownevents'] = 'Administradores são como os outros utilizadores';
$string['advancedfeatures'] = 'Funcionalidades avançadas';
$string['agedigitalconsentverification'] = 'Verificar idade mínima de consentimento';
$string['agedigitalconsentverification_desc'] = 'Permite a verificação da idade mínima de consentimento antes de mostrar aos utilizadores a página de autorregisto na plataforma. Isto protege o seu site de autoregisto de crianças sem o consentimento dos pais/responsáveis. <a target="_blank" href="{$a}">Contacte o suporte</a> para mais detalhes sobre  assistência adicional a crianças.';
$string['ageofdigitalconsentmap'] = 'Idade mínima de consentimento';
$string['ageofdigitalconsentmap_desc'] = 'Valor predefinido da idade mínima de consentimento e a idade em que esta difere do padrão em determinado país, pode ser especificada aqui. Digite cada idade numa nova linha no formato: código do país, idade (separada por uma vírgula). A idade padrão é indicada com * no lugar do código do país. Os códigos dos países são os especificados na ISO 3166-2.';
$string['allcountrycodes'] = 'Códigos de todos os países';
$string['allowattachments'] = 'Permitir anexos';
$string['allowbeforeblock'] = 'Processar primeiro a lista de permissões';
$string['allowbeforeblockdesc'] = 'Por predefinição, os endereços na lista de IP\'s bloqueados são os primeiros a serem verificados. Se ativar esta opção, os endereços na lista de IP\'s permitidos serão verificados antes dos IP\'s bloqueados.';
$string['allowblockstodock'] = 'Permitir que os blocos usem a consola';
$string['allowcategorythemes'] = 'Permitir definir temas para categorias';
$string['allowcohortthemes'] = 'Permitir definir temas para Grupos globais';
$string['allowcoursethemes'] = 'Permitir definir temas para disciplinas';
$string['allowedemaildomains'] = 'Domínios de e-mail permitidos';
$string['allowediplist'] = 'Lista de IP\'s permitidos';
$string['allowemailaddresses'] = 'Domínios de e-mail permitidos';
$string['allowframembedding'] = 'Permitir incorporar o frame';
$string['allowframembedding_help'] = 'Se ativar esta opção, é permitida a incorporação deste site em frames de sistemas externos, tal como recomendado ao usar "Publicar como ferramenta LTI". No entanto, não é recomendável ativar esta opção por motivos de segurança.';
$string['allowguestmymoodle'] = 'Permitir o acesso de visitante ao Painel do utilizador';
$string['allowindexing'] = 'Permitir indexação pelos motores de busca';
$string['allowindexing_desc'] = 'Esta opção determina se os motores de busca podem, ou não, indexar o seu site. "Todo o site" permitirá que os motores de busca pesquisem em todas as páginas, incluindo a de entrada e a de registo, o que significa que os sites com a opção "Forçar autenticação" ativada são igualmente indexados. Para evitar o risco de spam envolvido com o facto da página de entrada ser pesquisável, selecione "Todo o site, exceto autenticação". "Não indexar" indicará aos motores de busca que não indexem nenhuma página. Tenha em atenção que esta é apenas uma tag no cabeçalho do site. Cabe ao mecanismo de pesquisa respeitar, ou não, a tag.';
$string['allowindexingeverywhere'] = 'Em todas as páginas';
$string['allowindexingexceptlogin'] = 'Em todas as páginas exceto páginas de entrada e autenticação';
$string['allowindexingnowhere'] = 'Em nenhuma página';
$string['allowobjectembed'] = 'Permitir <i>tags</i> EMBED e OBJECT';
$string['allowthemechangeonurl'] = 'Permitir mudança de tema através de URL';
$string['allowuserblockhiding'] = 'Permitir aos utilizadores ocultar blocos';
$string['allowusermailcharset'] = 'Permitir que o utilizador selecione o conjunto de caracteres';
$string['allowuserswitchrolestheycantassign'] = 'Permitir que os utilizadores sem permissão para atribuir papéis possam assumir outros papéis';
$string['allowuserthemes'] = 'Permitir ao utilizador escolher o seu tema';
$string['alternativefullnameformat'] = 'Formato alternativo do nome completo';
$string['alternativefullnameformat_desc'] = 'Isto define como os nomes são exibidos para utilizadores com a permissão \'viewfullnames\' (por predefinição, os utilizadores com o papel de gestor, professor ou professor não-editor). Os espaços reservados que podem ser usados são idênticos aos da configuração de "Formato de nome completo".';
$string['always'] = 'Sempre';
$string['appearance'] = 'Aparência';
$string['aspellpath'] = 'Caminho para o programa <strong>aspell</strong>';
$string['authentication'] = 'Autenticação';
$string['authpreventaccountcreation'] = 'Impedir a criação de contas na autenticação';
$string['authpreventaccountcreation_help'] = 'Quando um utilizador que ainda não tem conta no site se autentica com sucesso, é criada automaticamente a sua conta. Se for usada uma base de dados externa para a autenticação, como o LDAP, mas deseja limitar o acesso ao site apenas aos utilizadores que já têm uma conta existente, então esta opção deve ser ativada. As novas contas terão de ser criadas manualmente ou através do carregamento de ficheiro de utilizadores. Note que esta configuração não se aplica à autenticação MNet.';
$string['authsettings'] = 'Gerir autenticação';
$string['autolang'] = 'Deteção automática';
$string['autologinguests'] = 'Autenticar automaticamente os visitantes';
$string['availablelicenses'] = 'Licenças disponíveis';
$string['availableto'] = 'Disponível para ';
$string['backgroundcolour'] = 'Cor transparente';
$string['backup_shortname'] = 'Usar nome da disciplina no nome do ficheiro da cópia de segurança';
$string['backup_shortnamehelp'] = 'Usar nome da disciplina como parte do nome do ficheiro da cópia de segurança.';
$string['backups'] = 'Cópias de segurança';
$string['badwordsconfig'] = 'Nesta configuração devem ser indicadas as palavras a censurar, separadas por vírgulas.';
$string['badwordsdefault'] = 'Se a lista personalizada estiver vazia, será utilizada uma lista predefinida do pacote de idiomas.';
$string['badwordslist'] = 'Lista de palavras a censurar';
$string['blockediplist'] = 'Lista de IP\'s bloqueados';
$string['blockinstances'] = 'Instâncias';
$string['blockmultiple'] = 'Múltiplo';
$string['blockprotect'] = 'Proteger instâncias';
$string['blockprotect_help'] = 'Se bloquear um tipo de bloco em particular, então ninguém poderá adicionar ou apagar as suas instâncias. (Pode, evidentemente, desbloquear novamente se tiver de editar alguma instância.)

Esta opção é usada principalmente para proteger blocos como os blocos Navegação e Configurações que podem ser muito difíceis de recuperar caso sejam acidentalmente apagados.';
$string['blocksettings'] = 'Gerir blocos';
$string['blockunprotect'] = 'Desprotegido';
$string['bloglevel'] = 'Visibilidade dos Blogues';
$string['bookmarkadded'] = 'Marcador criado.';
$string['bookmarkalreadyexists'] = 'Já criou um marcador para esta página';
$string['bookmarkdeleted'] = 'Marcador apagado';
$string['bookmarkthispage'] = 'Criar marcador para esta página';
$string['cacheapplication'] = 'Cache da aplicação';
$string['cacheapplicationhelp'] = 'Os itens da cache são partilhados entre todos os utilizadores e expiram por um determinado TTL.';
$string['cachejs'] = 'Cache do JavaScript';
$string['cachejs_help'] = 'A realização de cache e compressão do código JavaScript diminui significativamente o tempo que as páginas levam a carregar. É recomendado para sites em produção. Os programadores necessitarão provavelmente de desativar esta configuração.';
$string['cacherequest'] = 'Solicitar cache';
$string['cacherequesthelp'] = 'Cache específica do utilizador que expira quando o pedido é concluído. Concebida para substituir áreas onde são utilizadas unidades de armazenamento estáticas.';
$string['cachesession'] = 'Cache da sessão';
$string['cachesessionhelp'] = 'Cache específica do utilizador que expira quando a sessão do utilizador termina. Concebido para aliviar a sobrecarga/esforço da sessão.';
$string['cachesettings'] = 'Definições da cache';
$string['caching'] = 'Cache';
$string['calendar_weekend'] = 'Dias do fim de semana';
$string['calendarexportsalt'] = 'Salt de exportação do calendário';
$string['calendarsettings'] = 'Calendário';
$string['calendartype'] = 'Tipo de calendário';
$string['calendartype_desc'] = 'Selecione o tipo de calendário predefinido para todo o site. Esta configuração pode ser redefinida nas configurações da disciplina ou pelos utilizadores no seu perfil pessoal.';
$string['cannotdeletemodfilter'] = 'O filtro \'{$a->filter}\' não pode ser desinstalado porque faz parte do módulo \'{$a->module}\' .';
$string['cannotuninstall'] = '{$a} não pode ser desinstalado.';
$string['categoryemail'] = 'E-mail';
$string['cfgwwwrootslashwarning'] = 'A variável $CFG->wwwroot está mal definida no seu ficheiro config.php. Foi incluída uma barra \'/\' no fim. Por favor retire a barra para evitar erros como o seguinte: <a href=\'http://tracker.moodle.org/browse/MDL-11061\'>MDL-11061</a>';
$string['cfgwwwrootwarning'] = 'A variável $CFG->wwwroot está mal definida no seu ficheiro config.php. Não coincide com o URL que está a usar para aceder a esta página. Por favor corrija o URL para evitar erros como o seguinte: <a href=\'http://tracker.moodle.org/browse/MDL-11061\'>MDL-11061</a>';
$string['change'] = 'alterar';
$string['checkboxno'] = 'Não';
$string['checkboxyes'] = 'Sim';
$string['choosefiletoedit'] = 'Selecione o ficheiro a editar';
$string['cleanup'] = 'Limpeza';
$string['clianswerno'] = 'n';
$string['cliansweryes'] = 's';
$string['cliincorrectvalueerror'] = 'Erro: o valor "{$a->value}" não é permitido para a opção "{$a->option}"';
$string['cliincorrectvalueretry'] = 'Valor incorreto, por favor, tente novamente';
$string['clistatusdisabled'] = 'Estado: desativado';
$string['clistatusenabled'] = 'Estado: ativado';
$string['clistatusenabledlater'] = 'Estado: modo de manutenção CLI ficará ativo em {$a}';
$string['clitypevalue'] = 'introduza valor';
$string['clitypevaluedefault'] = 'introduza valor, pressione a tecla \'Enter\' para usar o valor predefinido ({$a})';
$string['cliunknowoption'] = 'Opções desconhecidas: {$a}. Por favor use a opção --help';
$string['cliupgradefinished'] = 'A atualização da versão {$a->oldversion} para {$a->newversion}, através da linha de comandos, foi realizada com sucesso.';
$string['cliupgradenoneed'] = 'Não é necessária nenhuma atualização para a versão {$a}. Obrigado pela sua visita!';
$string['cliyesnoprompt'] = 'digite s (para sim) ou n (para não)';
$string['commentsperpage'] = 'Comentários mostrados por página';
$string['commonactivitysettings'] = 'Configurações comuns';
$string['commonfiltersettings'] = 'Configurações comuns dos filtros';
$string['commonsettings'] = 'Configurações comuns';
$string['componentinstalled'] = 'A informação foi atualizada';
$string['computedfromlogs'] = 'Calculado a partir dos registos de atividade desde {$a}.';
$string['condifmodeditdefaults'] = 'Os valores predefinidos são usados no formulário de configurações ao criar uma nova atividade ou recurso.';
$string['confeditorhidebuttons'] = 'Selecione os botões do editor HTML que devem estar ocultos.';
$string['configallcountrycodes'] = 'Lista dos países que podem ser selecionados em vários sítios, como no perfil do utilizador. Se não for indicado nenhum valor será usada a lista definida no pacote linguístico do inglês. É a lista da norma ISO 3166-1. Se desejar, pode indicar uma lista de códigos separados por vírgulas (Ex: \'GB,FR,ES\'). Se adicionar novos códigos que não existam na norma, estes terão que ser também adicionados no ficheiro countries.php do pacote linguístico usado no site.';
$string['configallowassign'] = 'Permitir que os utilizadores com os papéis à esquerda (primeira coluna da tabela) atribuam a outros utilizadores os papéis em cima (primeira linha da tabela).';
$string['configallowattachments'] = 'Se ativar esta opção, os e-mails enviados a partir do site podem ter anexos, tais como medalhas.';
$string['configallowblockstodock'] = 'Se ativar esta opção e for permitido pelo tema selecionado, os utilizadores podem mover blocos para uma consola especial.';
$string['configallowcategorythemes'] = 'Se ativar esta opção, será possível escolher um tema para uma categoria. Este tema será usado em todas as disciplinas da categoria e das respetivas subcategorias, a menos que tenham definido o seu próprio tema. ATENÇÃO: O uso de temas para as categorias pode prejudicar o desempenho.';
$string['configallowcohortthemes'] = 'Se ativar esta opção, os temas poderão ser definidos para cada Grupo global. Afetará todos os utilizadores que pertençam a um ou mais Grupos globais, mas com o mesmo tema.';
$string['configallowcoursethemes'] = 'Se ativar esta opção, será possível definir o tema de uma disciplina. O tema da disciplina sobrepõe-se às outras definições de tema (tema do site, do utilizador ou temas da sessão)';
$string['configallowedemaildomains'] = 'Liste os domínios de e-mail que podem ser divulgados na secção "De" do e-mail enviado. O valor predefinido de "Vazio" usará o endereço de \'Não responder\' (no-reply) para todos os e-mails enviados. É permitido o uso de caracteres especiais, por exemplo, *.example.com permitirá os e-mails enviados de qualquer subdomínio de example.com, mas não de example.com propriamente dito. Para esta última será necessária uma entrada em separado.';
$string['configallowemailaddresses'] = 'Se quer restringir os novos endereços de e-mail a domínios específicos, então insira-os aqui, separados por espaços. Todos os outros domínios serão rejeitados. Para permitir subdomínios, adicione o domínio precedido de \'.\'. Para permitir um domínio raiz juntamente com os seus subdomínios, adicione o domínio duas vezes - uma vez com um \'.\' antes do nome e uma vez sem, por exemplo: .nossaescola.edu.pt nossaescola.edu.pt.';
$string['configallowguestmymoodle'] = 'Se ativar esta opção, os visitantes podem aceder ao Painel do utilizador, caso contrário, os visitantes serão redirecionados para a Página principal do site.';
$string['configallowobjectembed'] = 'Como medida de segurança, o Moodle não permite na sua configuração base que os utilizadores normais possam inserir objetos multimédia (como conteúdos Flash) em textos utilizando tags EMBED e OBJECT no HTML (embora tal possa ser feito com segurança utilizando o filtro "mediaplugins"). Esta configuração deve ser ativada caso pretenda permitir que os utilizadores possam inserir este tipo de conteúdo.';
$string['configallowoverride'] = 'Permitir que os utilizadores com os papéis à esquerda possam redefinir alguns dos papéis das colunas.';
$string['configallowoverride2'] = 'Selecione os papéis que podem ser redefinidos por cada papel na coluna da esquerda.<br />Tenha em atenção que estas definições apenas se aplicam a utilizadores aos quais foi atribuída a permissão \'moodle/role:override\' ou a permissão \'moodle/role:safeoverride\'.';
$string['configallowswitch'] = 'Selecione os papéis que um utilizador pode mudar para, baseado nos papéis que já tenha. Além de uma entrada nesta tabela, o utilizador deve ter também a capacidade moodle/role:switchroles para poder trocar.<br />Note que só é possível assumir os papéis que tenham a permissão moodle/course:view e que não tenham a permissão moodle/site:doanything. Por esta razão, algumas das colunas desta tabela estão desativadas.';
$string['configallowthemechangeonurl'] = 'Se ativar esta opção, o tema pode ser mudado adicionando o elemento \'theme={themename}\' a qualquer URL.';
$string['configallowuserblockhiding'] = 'Pretende permitir aos utilizadores ocultar/mostrar os blocos laterais em todo o site? Esta funcionalidade usa JavaScript e cookies para memorizar o estado de cada bloco, e apenas afeta o modo de visualização do utilizador.';
$string['configallowusermailcharset'] = 'Se ativar esta opção, os utilizadores podem selecionar nas configurações do seu perfil um conjunto de caracteres para usar no e-mail.';
$string['configallowuserswitchrolestheycantassign'] = 'Por predefinição, é necessário ter a capacidade moodle/role:assign para os utilizadores poderem assumir outros papéis. Ativar esta opção, remove essa restrição, fazendo com que os papéis disponíveis na lista pendente "Assumir o papel de..." sejam determinados pelas configurações no separador "Permitir atribuição de papéis". Recomenda-se que as definições em "Permitir atribuição de papéis" não permitam aos utilizadores assumir um papel com mais capacidades do que o seu papel atual.';
$string['configallowuserthemes'] = 'Se ativar esta opção, os utilizadores poderão escolher os seus próprios temas. Os temas do utilizador prevalecem sobre os temas definidos para o site (mas não sobre os temas da disciplina)';
$string['configallowview'] = 'Selecione os papeis que um utilizador pode ver, poderá filtrar por, etc. com base nos papéis que já possui.';
$string['configallusersaresitestudents'] = 'Todos os utilizadores devem ser considerados alunos nas atividades da página principal? Se a resposta for "Sim", então qualquer utilizador autenticado poderá participar como aluno nessas atividades. Se a resposta for "Não", então apenas os utilizadores já inscritos em pelo menos uma disciplina poderão tomar parte nestas atividades. Apenas os administradores e professores designados explicitamente poderão participar nestas atividades como professores.';
$string['configauthenticationplugins'] = 'Escolha os módulos de autenticação que pretende usar e ordene-os pela ordem que estes serão usados até encontrar um que autentique o utilizador com sucesso.';
$string['configautolang'] = 'Deteção automática do idioma com base na configuração do navegador. Se esta opção estiver desativada será usado o idioma predefinido do site.';
$string['configautologinguests'] = 'Pretende que utilizadores não autenticados que acedam a disciplinas que permitem acesso a visitantes sejam autenticados automaticamente como tal?';
$string['configbloglevel'] = 'Esta opção permite restringir o âmbito no qual os blogues dos utilizadores poderão ser visualizados neste site. Note que está a especificar o contexto máximo do VISUALIZADOR e não quem publicou ou tipo de publicação no blogue. Os blogues também poderão ser desativados completamente se não os quiser de todo.';
$string['configcalendarcustomexport'] = 'Ativar personalização do intervalo de datas de exportação do calendário';
$string['configcalendarexportsalt'] = 'Este texto aleatório é utilizado para a melhoria da segurança na exportação do calendário. Note que todos os tokens atuais serão invalidados se alterar este salt.';
$string['configcookiehttponly'] = 'Ativa a nova funcionalidade da versão 5.2.0 do PHP: os navegadores só podem enviar cookies com pedidos HTTP reais e as cookies não devem ser acessíveis pelas linguagens de script. Esta funcionalidade não é suportada por todos os navegadores e poderá não ser totalmente compatível com o código atual. Ajuda a evitar alguns tipos de ataques XSS.';
$string['configcookiesecure'] = 'Se o servidor apenas usa ligações HTTPS, recomenda-se a utilização de cookies seguros. Ao ativar, verifique que o servidor não está a aceitar pedidos http:// ou configure o redirecionamento permanente para endereços https:// e de preferência envie cabeçalhos HSTS. Quando o endereço <em>wwwroot</em> não começa por https:// esta configuração é ignorada.';
$string['configcountry'] = 'Se selecionar um país, este será predefinido na criação de novas contas de utilizador. Para forçar os utilizadores a selecionar o país, deixe este campo vazio.';
$string['configcourseoverviewfilesext'] = 'Lista das extensões, separadas por vírgulas, permitidas para os ficheiros de resumo da disciplina.';
$string['configcourseoverviewfileslimit'] = 'Número máximo de ficheiros que podem ser anexados ao resumo da disciplina.';
$string['configcourserequestnotify'] = 'Escreva o nome de utilizador do utilizador que deve ser notificado quando uma nova disciplina for pedida.';
$string['configcourserequestnotify2'] = 'Utilizadores que são notificados aquando de um pedido de disciplina. Apenas aparecem nesta lista os utilizadores que podem aprovar a criação de disciplinas.';
$string['configcoursesperpage'] = 'Insira o número de disciplinas a mostrar por página na listagem de disciplinas.';
$string['configcourseswithsummarieslimit'] = 'Número máximo de disciplinas numa lista de disciplinas com inclusão da respetiva descrição. A partir deste número será exibida uma lista simples, sem descrições.';
$string['configcronclionly'] = 'Executar o cron através do navegador web pode expor informação importante a utilizadores anónimos. Por isso, recomenda-se a execução do cron apenas a partir da linha de comandos ou a definição de uma senha do cron para acesso remoto.';
$string['configcronremotepassword'] = 'Isto significa que o script cron.php só pode ser executado a partir de um navegador web se for indicada a senha usando a seguinte forma <pre>http://site.example.com/admin/cron.php?password=opensesame</pre>Nota: Se este campo ficar em branco não é necessária nenhuma senha.';
$string['configcurlcache'] = 'Time-to-live da cache do cURL (em segundos).';
$string['configcustommenuitems'] = 'Aqui pode configurar um menu personalizado que será exibido pelos temas. Cada linha consiste num texto de menu, numa hiperligação de URL (opcional), num título de tooltip (opcional) e num código linguístico ou lista de códigos separados por vírgula (opcional, para exibir a linha apenas aos utilizadores do idioma especificado), separados pelo caráter \'|\'. As linhas que começam com um hífen vão aparecer como itens de menu no menu anterior de nível superior e os divisores podem ser utilizados adicionando uma linha de um ou mais caracteres \'#\' onde desejado. Por exemplo:
<pre>
Moodle community|https://moodle.org
-Moodle free support|https://moodle.org/support
-Moodle Docs|http://docs.moodle.org|Moodle Docs
-German Moodle Docs|http://docs.moodle.org/de|Documentation in German|de
-###
-Moodle development|https://moodle.org/development
Moodle.com|http://moodle.com/
</pre>';
$string['configcustomusermenuitems'] = 'Pode configurar os conteúdos do menu do utilizador (exceto a hiperligação de terminar sessão, que é automaticamente adicionada). Cada linha é separada pelo caractere \'|\' e consiste em 1) uma string no formato "langstringname, componentname" ou como texto simples, 2) um URL, e 3) um ícone, seja um ícone pix (da pasta pix/t ou adicionar o prefixo ../ ao nome do ícone, se a localização for outra pasta pix) ou como um URL. Podem ser utilizados separadores através da adição de uma linha de um ou mais caracteres \'#\' onde desejado.';
$string['configdbsessions'] = 'Se ativar esta opção, a base de dados será usada para guardar a informação sobre as sessões abertas. Tenha em atenção que alterando esta definição irá encerrar todas as sessões de todos os utilizadores (incluindo a sua). Se estiver a utilizar MySQL, certifique-se de que o parâmetro "max_allowed_packet" em my.cnf (ou my.ini) é 4M ou maior. Outros parâmetros podem ser configurados diretamente em config.php. Consulte \'config-dist.php\' para mais informações. Esta opção não estará disponível se especificar "session driver" no ficheiro config.php.';
$string['configdebug'] = 'Se ativar esta opção, o nível de error_reporting do PHP é aumentado, fazendo com que mais avisos sejam apresentados. Isto só tem utilidade para programadores.';
$string['configdebugdisplay'] = 'Se ativar esta opção, as mensagens de erro serão mostradas no HTML. Isto é prático, mas quebra os "HTTP Headers", "JavaScript", "cookies" e "XHTML". Se desativar esta opção, as mensagens de erro serão registadas nos registos de atividade do servidor, permitindo uma melhor análise de erros. A variável "error_log" do PHP controla para que log vai esta informação.';
$string['configdebugpageinfo'] = 'Se ativar esta opção, será mostrada informação da página no rodapé.';
$string['configdebugsmtp'] = 'Se ativar esta opção, serão mostradas mensagens caso ocorram erros durante o envio de mensagens de e-mail para o servidor SMTP. Para que esta configuração tenha efeito, a configuração \'Mensagens de erro\' deve ser definida como \'PROGRAMADOR\'.';
$string['configdebugvalidators'] = 'Ative esta configuração se pretender incluir hiperligações para servidores externos de validação no rodapé da página. Pode ser necessário criar uma nova conta de utilizador com o nome de utilizador <strong>w3cvalidator</strong> e disponibilizar o acesso a visitantes. Estas configurações podem permitir acessos não autorizados ao servidor, pelo que não deve ser ativada em sites em produção!';
$string['configdefaulthomepage'] = 'Define a página inicial para utilizadores autenticados';
$string['configdefaultrequestcategory'] = 'As disciplinas pedidas pelos utilizadores serão colocadas automaticamente nesta categoria.';
$string['configdefaultrequestedcategory'] = 'Categoria por predefinição para colocar as disciplinas pedidas, se forem aprovadas.';
$string['configdefaultuserroleid'] = 'Todos os utilizadores autenticados terão as permissões do papel aqui indicado no contexto do site, para além de quaisquer outros papéis que estejam atribuidos a esse utilizador. O valor predefinido desta opção é "Utilizador autenticado". Note que isto não colide com outros papéis que os utilizadores tenham, simplesmente garante que todos os utilizadores têm permissões que não são atribuíveis ao nível da disciplina (por exemplo, inserir entradas no blogue, gerir o próprio calendário, etc.).';
$string['configdeleteincompleteusers'] = 'Depois deste período, qualquer conta sem o Nome, Apelido ou campo de e-mail preenchido é apagada.';
$string['configdeleteunconfirmed'] = 'Para alguns métodos de autenticação, tal como o auto-registo com autenticação por e-mail, os utilizadores devem confirmar a sua conta dentro de um determinado período de tempo. Depois deste período, as contas antigas não confirmadas serão apagadas automaticamente.';
$string['configdenyemailaddresses'] = 'Para recusar endereços de e-mail de determinados domínios, introduza aqui a lista dos mesmos, separados por espaços. Todos os outros domínios serão aceites. Por exemplo: <strong>hotmail.com yahoo.co.uk live.com</strong>';
$string['configdisableuserimages'] = 'Se ativar esta configuração os utilizadores não poderão alterar a sua fotografia no perfil do utilizador.';
$string['configdisplayloginfailures'] = 'Se ativar esta opção, serão exibidas informação aos utilizadores sobre as tentativas de autenticação falhadas anteriormente.';
$string['configdndallowtextandlinks'] = 'Permite que, em simultâneo com a possibilidade de arrastar e largar ficheiros para uma página de disciplina, possa arrastar e largar texto e hiperligações. Note que arrastar texto para o Firefox, ou entre diferentes navegadores, não é fiável, podendo acontecer que nenhuma informação seja carregada ou o texto carregado fique corrompido.';
$string['configdoclang'] = 'Idioma que será usado nas hiperligações para as páginas de documentação.';
$string['configdocroot'] = 'Define o URL para o Moodle Docs para fornecer documentação adaptada ao contexto através da hiperligação "Documentação Moodle para esta página" no rodapé de cada página. Se o campo for deixado em branco, as hiperligações não serão exibidas.';
$string['configdoctonewwindow'] = 'Se ativar esta opção, as hiperligações para a documentação do Moodle serão abertas numa nova janela do navegador.';
$string['configeditordictionary'] = 'Esta opção será usada se o aspell não tiver dicionário para a linguagem do utilizador.';
$string['configeditorfontlist'] = 'Selecione os tipos de letra que deverão aparecer na lista de tipos de letra do editor.';
$string['configemailchangeconfirmation'] = 'Se ativar esta configuração os utilizadores receberão um e-mail para confirmação quando alterarem o seu e-mail no perfil.';
$string['configemailfromvia'] = 'Adicionar informações na secção "De" do e-mail de saída. Isto informa o destinatário da origem do e-mail e ajuda também a evitar que os destinatários respondam acidentalmente a endereços de e-mail \'Não responder\' (no-reply).';
$string['configenableactivitychooser'] = 'A seleção rápida é uma caixa de diálogo com uma breve descrição de cada atividade e recurso. Se desativar esta opção, em vez da caixa de diálogo serão mostradas listas pendentes em separado para os recursos e para as atividades.';
$string['configenableblogs'] = 'Esta opção de configuração disponibiliza a todos os utilizadores do site o seu próprio blogue.';
$string['configenablecalendarexport'] = 'Ativa a possibilidade de exportação ou subscrição de calendários.';
$string['configenablecomments'] = 'Ativar comentários';
$string['configenablecourserequests'] = 'Se ativar esta opção, qualquer utilizador poderá pedir a criação de uma disciplina.';
$string['configenabledevicedetection'] = 'Ativa a deteção de dispositivos móveis, telemóveis, tablets e outros (portáteis, computadores, etc.) permitindo a aplicação de temas específicos e outras funcionalidades.';
$string['configenablemobilewebservice'] = 'Ativa o serviço para dispositivos móveis para a Aplicação móvel Moodle oficial ou outra aplicação para dispositivos móveis que necessite desse serviço. Para mais informação consulte a página {$a}.';
$string['configenablerssfeeds'] = 'Se ativar esta opção, as listas RSS serão geradas a partir de várias funcionalidades do site (tais como blogues, fóruns, bases de dados e glossários). Note que deverá ativar as Listagens RSS nas configurações das respetivas atividades.';
$string['configenablerssfeedsdisabled'] = 'Não está disponível porque as listas RSS estão desativadas ao nível do site. Podem ser ativadas em Administração do Site » Funcionalidades avançadas » Ativar Listas RSS.';
$string['configenablerssfeedsdisabled2'] = 'As listas RSS estão desativados ao nível do site. Podem ser ativadas em Administração do Site » Funcionalidades avançadas » Ativar Listas RSS.';
$string['configenablesafebrowserintegration'] = 'Adicionar a opção \'Forçar Safe Exam Browser\' ao campo \'Segurança do Navegador\' na página de configurações da atividade Teste. Para mais informações, consulte a página <a href="http://www.safeexambrowser.org/" target="_blank">http://www.safeexambrowser.org/</a>';
$string['configenablestats'] = 'Se selecionar \'Sim\', o script cron do Moodle irá processar os registos de atividade e calcular algumas estatísticas. Dependendo do volume de tráfego do site, esta operação pode demorar muito tempo. Se ativar esta opção, poderá ver alguns gráficos e estatísticas em cada disciplina e para todo o site.';
$string['configenabletrusttext'] = 'O Moodle efetua normalmente uma limpeza a fundo dos conteúdos enviados pelos utilizadores para eliminar scripts maliciosos, spam, etc. que possam colocar o site em risco. A ativação desta configuração permite a alguns utilizadores de confiança incluir este tipo de conteúdo sem restrições. Para ativar esta funcionalidade, depois de ativar esta opção é necessário ativar a permissão "Conteúdo fiável" num papel específico do Moodle. O texto criado ou enviado por esses utilizadores será identificado como fiável e não será submetido ao processo de limpeza.';
$string['configenablewebservices'] = 'Os web services permitem a outros sistemas aceder a este Moodle e realizar operações. Por questões de segurança, esta função deve ser desativada se não for utilizada.';
$string['configenablewsdocumentation'] = 'Ativar a geração automática de documentação dos web services. Um utilizador pode aceder à documentação na sua página de chaves de segurança {$a}. Aqui apenas é mostrada a documentação para os protocolos que estiverem ativos.';
$string['configerrorlevel'] = 'Escolha a quantidade de avisos PHP que pretende que sejam mostrados. Normal é geralmente a melhor escolha.';
$string['configexportlookahead'] = 'Dias subsequentes a incluir na exportação';
$string['configexportlookback'] = 'Número de dias antecedentes a abranger durante a exportação';
$string['configextendedusernamechars'] = 'Se ativar esta opção, os utilizadores poderão utilizar quaisquer carateres nos seus nomes de utilizador (note que esta opção não afeta os nomes de utilizador atuais). Por predefinição, esta opção está desativada, o que limita os caracteres nos nomes de utilizador a caracteres alfanuméricos em minúsculas, underscore (_), hífen (-), ponto (.) e o símbolo arroba (@).';
$string['configextramemorylimit'] = 'Alguns scripts como pesquisas, cópias de segurança, restauro ou cron requerem mais memória. Defina valores mais elevados para grandes sites.';
$string['configfilterall'] = 'Se ativar esta opção, todos os textos serão filtrados, incluindo cabeçalhos, títulos, barra de navegação e outros. É muito útil quando se utiliza o filtro multilingue, caso contrário apenas criará carga extra no seu site com vantagens pouco significativas.';
$string['configfiltermatchoneperpage'] = 'Se ativar esta opção, os filtros geradores de hiperligações automáticas apenas gerarão uma hiperligação na primeira ocorrência de um texto encontrado na página. Todas as restantes ocorrências na mesma página serão ignoradas.';
$string['configfiltermatchonepertext'] = 'Se ativar esta opção, os filtros geradores de hiperligações automáticas apenas gerarão uma hiperligação na primeira ocorrência de um texto encontrado em cada item de texto na página (exemplo: recurso, bloco). Todas as restantes ocorrências no mesmo item serão ignoradas. Esta opção não tem efeito se a opção <strong>Filtrar um por página</strong> estiver ativa.';
$string['configfilteruploadedfiles'] = 'Indique se pretende que o conteúdo dos ficheiros HTML e de texto, apenas dos ficheiros HTML ou de nenhum ficheiro objeto de carregamento, sejam objeto de processamento pelos filtros.';
$string['configforcelogin'] = 'Normalmente a página principal e a lista de disciplinas (não as disciplinas em si) podem ser vistas por utilizadores não autenticados. A ativação desta configuração obriga todos os utilizadores a iniciarem uma sessão antes de poderem consultar qualquer informação no site.';
$string['configforceloginforprofiles'] = 'Se ativar esta configuração apenas os utilizadores autenticados poderão consultar os perfis de outros utilizadores. Caso desative esta configuração, poderá encontrar mensagens de spam ou outro conteúdo impróprio publicado por alguns utilizadores nos seus perfis, que estará visível para todos os utilizadores.';
$string['configfrontpage'] = 'Os itens selecionados acima serão exibidos na página principal do site.';
$string['configfrontpagecourselimit'] = 'Número máximo de disciplinas';
$string['configfrontpagecourselimithelp'] = 'Número máximo de disciplinas a serem exibidas nas listas de disciplinas na página principal.';
$string['configfrontpageloggedin'] = 'Os itens selecionados acima serão exibidos na página principal do site quando um utilizador está autenticado.';
$string['configfullnamedisplay'] = 'Define como são mostrados os nomes completos. Na generalidade dos sites o formato mais comum é "nome + apelido", mas é possível ocultar o apelido ou mostrar de acordo com o critério definido no pacote linguístico do idioma que estiver a ser usado (alguns idiomas têm convenções diferentes).

Para a maioria dos sites com apenas um idioma instalado, a configuração mais eficiente é "firstname lastname" ("nome apelido"), mas pode optar por ocultar completamente os apelidos.

Podem ser usados os seguintes espaços reservados: firstname, lastname, firstnamephonetic, lastnamephonetic, middlename e alternatename.';
$string['configgeoipfile'] = 'Localização do ficheiro binário de dados do GeoLite2 City. Este ficheiro não faz parte da distribuição do Moodle e deverá ser obtido separadamente em <a href="https://www.maxmind.com/">MaxMind</a>.<br />É possível comprar uma versão comercial ou utilizar a versão gratuita. Tem de se registar para descarregar o ficheiro da base de dados da cidade, o que pode ser feito em <a href="https://dev.maxmind.com/geoip/geoip2/geolite2/" >https://dev.maxmind.com/geoip/geoip2/geolite2/</a>. Depois de registar-se e descarregar o ficheiro, extraia-o para a diretoria "{$a}" do seu servidor.';
$string['configgetremoteaddrconf'] = 'Se o acesso ao Moodle for feito através de um <em>Reverse Proxy</em> é possível especificar neste campo que cabeçalhos HTTP são mais fiávies para obter o endereço IP externo. Os cabeçalhos são lidos por ordem sendo usado o primeiro que se encontrar disponível.';
$string['configgradebookroles'] = 'Esta opção permite controlar quem aparece na pauta. Só constarão da pauta duma disciplina os utilizadores que desempenham pelo menos um destes papéis nessa disciplina.';
$string['configgradeexport'] = 'Selecione que formatos principais usa para exportar as notas da pauta. Os módulos selecionados configurarão e usarão um campo "última exportação" associado a cada nota. Por exemplo, isto poderá fazer com que os registos exportados sejam identificados como "novos" ou "atualizados". Se não tiver a certeza sobre como configurar esta opção, não selecione qualquer formato.';
$string['confighiddenuserfields'] = 'Selecione quais os campos de informação de utilizador que pretende ocultar dos outros utilizadores que não os professores e administradores. Isto aumentará a privacidade dos alunos. Prima a tecla CTRL para selecionar vários campos.';
$string['configidnumber'] = 'Esta opção especifica se: (a) Não é pedido aos utilizadores um número de ID, (b) É pedido um número de ID aos utilizadores mas este pode ser deixado em branco, ou (c) É pedido um número de ID aos utilizadores e este não pode ficar em branco. Se for fornecido, o número de ID do utilizador será mostrado no seu perfil.';
$string['configintro'] = 'Nesta página pode configurar as variáveis relacionadas com o correto funcionamento do Moodle no seu servidor. Não se preocupe muito com esta página - em geral, os valores por predefinição funcionam bem e poderá sempre voltar a esta página e mudar as configurações.';
$string['configintroadmin'] = 'Nesta página deve configurar a sua conta de Administrador principal a qual terá um controlo absoluto de todo o site. Não se esqueça de indicar um nome de utilizador e senha seguros, bem como um endereço e-mail válido. Posteriormente poderá criar mais contas de Administrador.';
$string['configintrosite'] = 'Nesta página pode configurar a página principal e o nome do seu site. Poderá voltar a esta página e alterar as configurações através do menu da Administração do Site.';
$string['configiplookup'] = 'Quando clica num endereço IP (por exemplo, 34.12.222.93), designadamente na página de registos de atividade, é apresentado um mapa com a localização mais provável desse IP. Pode selecionar entre diferentes módulos para este efeito, cada um com as suas vantagens e desvantagens.';
$string['configkeeptagnamecase'] = 'Ative esta opção para que as palavras-chave do site mantenham a mesma combinação de maiúsculas e minúsculas com que foram introduzidas pelos utilizadores que as criaram.';
$string['configlang'] = 'Selecione o idioma predefinido a utilizar em todo o site. Os utilizadores poderão selecionar outro idioma no menu de idiomas ou no seu perfil de utilizador.';
$string['configlanglist'] = 'Se esta configuração não tiver nenhum valor os utilizadores poderão selecionar qualquer um dos idiomas instalados no Moodle. Contudo, é possível reduzir o número de idiomas no menu introduzindo uma lista de códigos dos idiomas a apresentar, separados por vírgulas. Por exemplo: pt,pt_br,en,es,fr,it';
$string['configlangmenu'] = 'Esta opção permite definir se o menu de idiomas será exibido, ou não, na página principal, página de autenticação, etc. Os utilizadores continuarão a poder definir nos seus perfis qual o idioma que pretendem utilizar.';
$string['configlangstringcache'] = 'Se ativar esta opção, serão guardadas em cache todas as traduções a utilizar no Moodle (em ficheiros compilados, na pasta de dados), melhorando o desempenho do sistema. Esta opção deve ser desativada durante processos de alteração das traduções, para que estas se tornem visíveis de forma imediata.';
$string['configlatinexcelexport'] = 'Codificação a utilizar nas exportações de ficheiros para formato Excel';
$string['configlocale'] = 'Esta configuração define o "locale" do site. Esta configuração afeta o formato e a tradução das datas mostradas para qualquer idioma (os nomes dos dias no calendário não são afetados). O "locale" introduzido tem que estar previamente instalado no sistema operativo (Exemplo: para linux en_US.UTF-8 ou es_ES.UTF-8). Normalmente esta opção não deve ser preenchida.';
$string['configloginhttps'] = 'Se ativar esta opção, o Moodle usará uma ligação segura HTTPS apenas para a página de autenticação (garantindo uma autenticação segura), voltando depois a uma ligação normal HTTP. AVISO: Esta opção requer que o seu servidor suporte HTTPS caso contrário PODERÁ IMPEDIR-SE A SI PRÓPRIO DE ENTRAR NO SITE.';
$string['configloglifetime'] = 'Período de tempo durante o qual os registos de atividade dos utilizadores devem ser mantidos. Os registos de atividade com antiguidade superior a este período são automaticamente apagados. É útil manter os registos de atividade o maior tempo possível, caso necessite destes, mas se tem um servidor muito solicitado e estão a ocorrer problemas de performance, então pode desejar reduzir o tempo de manutenção dos registos de atividade. Não se recomendam valores inferiores a 30 dias pois podem comprometer o funcionamento correto das estatísticas.';
$string['configlookahead'] = 'Número de dias futuros a considerar';
$string['configmailnewline'] = 'Caracteres usados para iniciar uma nova linha nas mensagens de e-mail. De acordo com a norma RFC 822bis deve ser usado o CRLF. Alguns servidores de e-mail fazem automaticamente a conversão de LF para CRLF, mas outros fazem a conversão incorreta de CRLF para CRCRLF, e outros rejeitam os e-mails apenas com LF (qmail por exemplo). Tente alterar esta configuração se estiver com problemas na recepção dos e-mails pelos utilizadores ou mudanças duplas de linha.';
$string['configmaxbytes'] = 'Tamanho máximo para o carregamento de ficheiros no site. O valor indicado nesta configuração está limitado externamente pelos valores dos parâmetros <strong>post_max_size</strong> e <strong>upload_max_filesize</strong> do PHP, bem como pela definição <strong>LimitRequestBody</strong> do Apache. Esta opção limita o intervalo de tamanhos que poderão ser selecionados ao nível das disciplinas e dos módulos. Se selecionar o valor "Limite de carregamento no contexto Site" será considerado o tamanho máximo permitido pelo servidor.';
$string['configmaxconsecutiveidentchars'] = 'As senhas não podem conter mais do que este número de caracteres iguais consecutivos. Defina o valor \'0\' (zero) para desativar esta verificação.';
$string['configmaxeditingtime'] = 'Intervalo de tempo que os utilizadores têm para editar as mensagens que inserem nos fóruns, comentários dos glossários, etc. depois da sua submissão.';
$string['configmaxevents'] = 'Eventos futuros a mostrar';
$string['configmaxusersperpage'] = 'Número máximo de utilizadores a serem mostrados no seletor de utilizadores no âmbito da disciplina, grupo, grupo global, web service, etc.';
$string['configmessaging'] = 'Se ativar esta opção os utilizadores poderão usar o sistema de mensagens do site para comunicar entre si.';
$string['configmessagingallowemailoverride'] = 'Se ativar esta opção, será permitido que os utilizadores possam especificar um e-mail diferente do definido nos seus perfis para efeitos de envio das notificações por e-mail.';
$string['configmessagingdeleteallnotificationsdelay'] = 'As notificações lidas e não lidas podem ser apagadas para libertar espaço. A partir de quanto tempo é que uma notificação, depois de ser criada, pode ser pode apagada?';
$string['configmessagingdeletereadnotificationsdelay'] = 'As notificações lidas podem ser apagadas para poupar espaço. Após a leitura, quanto tempo depois é que as notificações podem ser apagadas?';
$string['configminpassworddigits'] = 'As senhas devem ter pelo menos este número de caracteres numéricos.';
$string['configminpasswordlength'] = 'As senhas devem ter pelo menos este número de caracteres.';
$string['configminpasswordlower'] = 'As senhas devem ter pelo menos este número de letras minúsculas.';
$string['configminpasswordnonalphanum'] = 'As senhas devem ter pelo menos este número de caracteres não alfanuméricos.';
$string['configminpasswordupper'] = 'As senhas deverão ter pelo menos este número de letras maiúsculas.';
$string['configmodchooserdefault'] = 'Ativar o modo de seleção rápida de recursos e atividades por predefinição?';
$string['configmycoursesperpage'] = 'Número máximo de disciplinas a mostrar em lista';
$string['configmymoodleredirect'] = 'Esta opção força o redireccionamento para /my após a autenticação de não-administradores e substitui o nível superior de navegação no site por /my';
$string['configmypagelocked'] = 'Esta configuração impede que a página predefinida seja modificada por utilizadores que não sejam administradores';
$string['confignavcourselimit'] = 'Limita o número de disciplinas mostradas ao utilizador na navegação.';
$string['confignavshowallcourses'] = 'Esta configuração determina se os utilizadores que estão inscritos em disciplinas podem ver a opção "Disciplinas" na Navegação (lista de todas as disciplinas) para além da opção "As minhas disciplinas" (lista das disciplinas em que estão inscritos).';
$string['confignavshowcategories'] = 'Mostrar categorias de disciplinas na barra e blocos de navegação. Esta configuração não tem efeito nas disciplinas em que o utilizador está atualmente inscrito. Nestes casos, as disciplinas continuarão a ser mostradas nas disciplinas do utilizador, sem categorias.';
$string['confignoreplyaddress'] = 'Por vezes, os e-mails são enviados em nome de um utilizador (por exemplo, as mensagens do fórum). O e-mail que inserir aqui será usado como o endereço do remetente nos casos em que os destinatários não devem responder diretamente ao utilizador (por exemplo, quando um utilizador opta por manter o seu endereço privado).';
$string['confignotifyloginfailures'] = 'Enviar mensagens de notificação de falha de autenticação para estes utilizadores selecionados. Isto requer uma logstore interna (por exemplo, Logstore padrão) para ser ativado.';
$string['confignotifyloginthreshold'] = 'Se as notificações de tentativas falhadas de autenticação estiverem ativas, quantas tentativas falhadas por utilizador ou endereço IP deverão ocorrer para ter lugar uma notificação?';
$string['confignotloggedinroleid'] = 'Os utilizadores não autenticados no site serão tratados como tendo as permissões deste papel, no contexto do site. Em geral deverá selecionar Visitante, mas em alguns casos poderá querer criar papéis mais ou menos restritivos. Tarefas como inserir mensagens em fóruns continuam a necessitar que o utilizador se autentique no site.';
$string['configopentogoogle'] = 'Se ativar esta opção, o motor de busca Google terá acesso às páginas do site como um utilizador com o papel "Visitante". Adicionalmente, qualquer pessoa que entre no seu site através de uma pesquisa Google entrará também como visitante. Tenha em atenção que a ativação desta configuração apenas disponibiliza o acesso a disciplinas que, na sua configuração, permitam o acesso a visitantes.';
$string['configoverride'] = 'Definido em config.php';
$string['configpasswordpolicy'] = 'Se ativar esta opção, as senhas dos utilizadores terão de cumprir a política de senhas especificada nas configurações abaixo. A ativação da política de senhas não afetará os utilizadores já existentes até que decidam ou precisem de alterar a senha.';
$string['configpasswordresettime'] = 'Esta configuração especifica quanto tempo o utilizador tem para validar um pedido de reposição de senha antes que esta expire. Normalmente, 30 minutos é um intervalo adequado.';
$string['configpathtodu'] = 'Caminho para o programa <strong>du</strong>. Provavelmente algo como \'/usr/bin/du\'. Se indicar um valor, as páginas que exibem conteúdos de pastas com muitos ficheiros irão ser processadas com maior rapidez.';
$string['configpathtophp'] = 'Caminho para a CLI do PHP. Provavelmente algo como \'/usr/bin/php\'. Se for indicado, os scripts cron podem ser executados a partir da interface web de administração.';
$string['configperfdebug'] = 'Se ativar esta opção, será mostrada informação sobre desempenho  no rodapé do tema standard.';
$string['configprofileroles'] = 'Lista de papéis que são mostrados na página de perfil dos utilizadores e na página de participação.';
$string['configprofilesforenrolledusersonly'] = 'Para impedir o uso indevido por spammers, as descrições dos perfis dos utilizadores que ainda não estão inscritos em nenhuma disciplina estão ocultas. Os novos utilizadores têm de inscrever-se em pelo menos uma disciplina, antes de poderem inserir uma descrição no perfil.';
$string['configprotectusernames'] = 'Se ativar esta opção, a página de recuperação da senha não mostrará qualquer pista que possibilite saber se o nome de utilizador ou o endereço de e-mail existem no site.';
$string['configproxybypass'] = 'Lista de nomes (parciais) de servidores ou IPs que devem contornar o proxy (Ex: 192.168., .meudominio.com)';
$string['configproxyhost'] = 'Se este <strong>servidor</strong> precisar de usar um proxy (Ex: uma firewall) para aceder à Internet, coloque aqui o hostname do proxy. Caso contrário deixe em branco.';
$string['configproxypassword'] = 'Senha necessária para aceder à Internet através do proxy, se necessária, ou vazio se não necessária (é necessária a extensão cURL do PHP)';
$string['configproxyport'] = 'Se este servidor precisar de usar um proxy, escreva aqui a porta do proxy.';
$string['configproxytype'] = 'Tipo de web proxy (é necessário o PHP5 e a extensão cURL para suportar SOCKS5)';
$string['configproxyuser'] = 'Nome de utilizador necessário para aceder à Internet através do proxy, se necessário, ou vazio se não necessário (é necessária a extensão cURL do PHP)';
$string['configrecaptchaprivatekey'] = 'Sequência de caracteres (Chave privada) utilizada na comunicação entre o servidor Moodle e o servidor reCAPTCHA. As chaves reCAPTCHA podem ser obtidas em <a target="_blank" href="https://www.google.com/recaptcha">Google reCAPTCHA</a>.';
$string['configrecaptchapublickey'] = 'Sequência de caracteres (Chave pública) utilizada para exibir o elemento reCAPTCHA no formulário de registo. As chaves reCAPTCHA podem ser obtidas em <a target="_blank" href="https://www.google.com/recaptcha">Google reCAPTCHA</a>.';
$string['configrequestcategoryselection'] = 'Permitir a seleção de uma categoria ao solicitar uma disciplina.';
$string['configrequestedstudentname'] = 'Designação do Aluno, a usar nas disciplinas pedidas';
$string['configrequestedstudentsname'] = 'Designação dos Alunos, a usar nas disciplinas pedidas';
$string['configrequestedteachername'] = 'Designação do Professor, a usar nas disciplinas pedidas';
$string['configrequestedteachersname'] = 'Designação dos Professores, a usar nas disciplinas pedidas';
$string['configreverseproxyignore'] = 'Se o servidor estiver atrás de diversos reverse proxies que anexam ao cabeçalho X-Forwarded-For, será necessário especificar uma lista separada por vírgulas dos endereços IP ou sub-redes dos reverse proxies a serem ignorados para encontrar o endereço IP correto dos utilizadores.';
$string['configsectioninterface'] = 'Interface';
$string['configsectionmail'] = 'Email';
$string['configsectionmaintenance'] = 'Manutenção';
$string['configsectionmisc'] = 'Diversos';
$string['configsectionoperatingsystem'] = 'Sistema operativo';
$string['configsectionpermissions'] = 'Permissões';
$string['configsectionrequestedcourse'] = 'Pedidos de disciplinas';
$string['configsectionsecurity'] = 'Segurança';
$string['configsectionstats'] = 'Estatísticas';
$string['configsectionuser'] = 'Utilizadores';
$string['configsecureforms'] = 'O Moodle pode utilizar um nível adicional de segurança no processamento de dados provenientes de formulários web. Se ativar esta opção, então a variável HTTP_REFERER do navegador é verificada se contém o endereço do formulário corrente. Por vezes esta opção pode causar problemas, por exemplo se o utilizador usar uma firewall (Ex: Zonealarm) configurada para omitir o HTTP_REFERER do seu web. Os sintomas são ficar preso num formulário. Assim, se os seus utilizadores estiverem com problemas na página de autenticação, por exemplo, então poderá ter de desativar esta opção, embora o seu site fique mais permeável a ataques. Em caso de dúvida deixe esta opção ativa.';
$string['configsessioncookie'] = 'Esta opção define o nome do cookie utilizado para registar sessões Moodle. É opcional e apenas é útil para evitar que se confundam os cookies quando está a correr mais do que uma cópia do Moodle no mesmo site.';
$string['configsessioncookiedomain'] = 'Esta configuração permitir definir o domínio em que as cookies do Moodle estão disponíveis. Esta funcionalidade é útil em personalizações do Moodle (autenticação, inscrição por módulos, etc.)  em que é necessário partilhar informação da sessão Moodle com uma aplicação web noutro subdomínio. <strong> ATENÇÃO: normalmente o campo deve ficar vazio. Um valor incorreto irá bloquear o acesso ao Moodle</strong>.';
$string['configsessioncookiepath'] = 'Se precisar de alterar o local para onde os navegadores enviam os cookies do Moodle, pode alterar esta configuração para especificar uma subpasta do seu site. Caso contrário, utilize o caminho predefinido \'/\'.';
$string['configsessiontimeout'] = 'Se um utilizador autenticado estiver sem atividade durante um longo período de tempo (sem abrir páginas), a sessão será terminada automaticamente após o período de tempo aqui definido.';
$string['configshowcommentscount'] = 'Exibe número de comentários na hiperligação para visualizar os comentários. Tem como desvantagem a necessidade de uma consulta adicional à base de dados.';
$string['configshowicalsource'] = 'Exibir a origem da informação para os eventos do iCal';
$string['configshowsiteparticipantslist'] = 'Todos os alunos e professores do site serão listados na lista de participantes do site. Quem tem permissões para ver esta lista de participantes?';
$string['configsitedefaultlicense'] = 'Tipo de licença';
$string['configsitedefaultlicensehelp'] = 'Tipo de licença a aplicar aos conteúdos colocados no site.';
$string['configsitemailcharset'] = 'Esta configuração especifica o conjunto de caracteres predefinido para todos os e-mails enviados a partir do site.';
$string['configsitemaxcategorydepth'] = 'Nº de níveis de categorias a exibir';
$string['configsitemaxcategorydepthhelp'] = 'Esta configuração especifica o nível máximo das categorias que surgirão expandidas ao exibir uma lista de categorias/disciplinas. Categorias de nível mais profundo serão exibidas como hiperligações, podendo o utilizador expandi-las o que resultará num pedido AJAX.';
$string['configslasharguments'] = 'A utilização dos "slash arguments" (que utilizam <em>PATH_INFO</em>) é necessária para a correta visualização de pacotes SCORM e Recursos com múltiplos ficheiros. Caso o seu navegador não suporte "slash arguments", e não consiga configurá-lo, poderá desativar este parâmetro, embora vá fazer com que algumas coisas não funcionem. <br />Nota: A utilização de "slash arguments" será necessária em futuras versões do Moodle.';
$string['configsmartpix'] = 'Se ativar esta opção, os ícones são obtidos através de um script PHP que procura primeiro o tema atual, depois todos os temas ascendentes, depois a pasta /pix. Isto reduz a necessidade de duplicar ficheiros de imagens dentro dos temas, mas tem alguns custos a nível de performance.';
$string['configsmtpauthtype'] = 'Esta configuração define o tipo de autenticação a utilizar no servidor SMTP.';
$string['configsmtphosts'] = 'Indique o nome completo de um ou mais servidores SMTP locais que o Moodle deve usar para enviar e-mails (ex: \'mail.a.com\' ou \'mail.a.com;mail.b.com\'). Para especificar uma porta não predefinida (isto é, outra além da porta 25), pode usar a sintaxe [server]:[port] (ex \'mail.a.com:587\'). Para ligações seguras, a porta 465 é normalmente usada com SSL e a porta 587 é usada com TLS. Se pretender, especifique abaixo um protocolo de segurança. Se deixar este campo vazio, o Moodle usará o método PHP padrão de envio de e-mail.';
$string['configsmtpmaxbulk'] = 'Número máximo de mensagens enviadas por sessão SMTP. Agrupar mensagens pode acelerar o envio de e-mails. Valores inferiores a 2 forçam a criação de uma nova sessão SMTP para cada e-mail.';
$string['configsmtpsecure'] = 'Se o servidor SMTP requerer uma ligação segura, especifique o tipo de protocolo correto.';
$string['configsmtpuser'] = 'Se acima especificou um servidor SMTP e o servidor requer autenticação, digite o nome de utilizador e a senha.';
$string['configstartwday'] = 'Primeiro dia da semana';
$string['configstatsfirstrun'] = 'Esta opção especifica qual a antiguidade dos registos de atividade que serão processados <strong>na primeira vez</strong> que o cron processar as estatísticas. Se tiver muito tráfego e usar um servidor partilhado, não é aconselhado o processamento de registos muito antigos, pois poderá demorar muito tempo e consome muitos recursos do servidor. (Tenha em atenção que para esta definição, 1 mês = 28 Dias. Nos gráficos e relatórios gerados, 1 mês = 1 mês do calendário)';
$string['configstatsmaxruntime'] = 'O processamento das estatísticas pode ser muito intensivo, por isso use uma combinação desta opção com a seguinte para especificar quando irá ter lugar e durante quanto tempo.';
$string['configstatsmaxruntime2'] = 'O processamento das estatísticas pode ser muito intensivo. Defina o tempo máximo permitido para o processamento das estatísticas de um dia. O número máximo de dias processados por cada execução do cron é de 31.';
$string['configstatsmaxruntime3'] = 'Tempo máximo permitido para calcular as estatísticas de um dia, tendo em conta que o processamento das estatísticas pode sobrecarregar o servidor. O número máximo de dias processados, em cada execução do cron, pode ser especificado abaixo.';
$string['configstatsruntimedays'] = 'Número máximo de dias processados em cada execução das estatísticas. Assim que as estatísticas estão atualizadas, apenas um dia será processado (ajuste este valor em função da capacidade do seu servidor, reduzindo-o se for necessário encurtar o tempo de execução do cron).';
$string['configstatsruntimestart'] = 'A que horas deverá iniciar o cronjob que executa o processamento das estatísticas? Especifique horas diferentes se existirem diversos sites Moodle alojados no mesmo servidor.';
$string['configstatsuserthreshold'] = 'Número mínimo de utilizadores inscritos que uma disciplina deve ter para seja incluída nas estatísticas.';
$string['configstrictformsrequired'] = 'Se ativado, os utilizadores são impedidos de inserir apenas um espaço ou quebra de linha nos campos obrigatórios dos formulários.';
$string['configstripalltitletags'] = 'Se desativar esta configuração as <em>tags</em> HTML existentes nos nomes das atividades e recursos das disciplinas deixarão de ser removidas.';
$string['configsupportemail'] = 'Este endereço de e-mail será divulgado aos utilizadores deste site como sendo o e-mail para pedidos de ajuda (por exemplo, quando os utilizadores criam as suas próprias contas). Se este e-mail estiver em branco, não será fornecido nenhum contacto para ajuda.';
$string['configsupportname'] = 'Nome da pessoa ou entidade que oferece ajuda através do e-mail de suporte ou endereço web.';
$string['configsupportpage'] = 'Este endereço web será divulgado aos utilizadores deste site como o endereço a consultar quando necessitarem de ajuda (por exemplo, quando os utilizadores criam as suas próprias contas). Se este endereço estiver em branco, não será fornecida nenhuma hiperligação para ajuda.';
$string['configtempdatafoldercleanup'] = 'Apagar os ficheiros de dados temporários da pasta de dados mais antigos que o intervalo de tempo selecionado.';
$string['configthemedesignermode'] = 'Normalmente as imagens e estilos dos temas são guardados em cache pelos navegadores e nos servidores durante um longo período por questões de desempenho. Se estiver a criar temas ou a desenvolver código provavelmente vai querer ativar esta configuração para evitar o armazenamento desta informação em cache. Aviso: Esta alteração tornará o site mais lento para todos os utilizadores! Em alternativa, pode esvaziar manualmente as caches de tema na página de seleção de temas.';
$string['configthemelist'] = 'Deixe em branco para permitir que qualquer tema válido seja utilizado. Se quiser encurtar o menu dos temas, especifique aqui uma lista de nomes de temas separados por vírgulas (Não use espaços!). Por exemplo: standard,orangewhite.';
$string['configtimezone'] = 'Fuso horário predefinido usado para mostrar datas - cada utilizador poderá alterar o seu fuso horário na configuração do seu perfil. As tarefas do cron e outras configurações do servidor são especificadas neste fuso horário. Caso surja a informação "Fuso horário inválido" deverá alterar a configuração';
$string['configuseblogassociations'] = 'Devem os utilizadores ter a possibilidade de organizar o seu blogue associando mensagens a disciplinas e módulos?';
$string['configuseexternalyui'] = 'Se ativar esta funcionalidade, serão utilizadas as versões online das bibliotecas YUI disponíveis em servidores externos, em substituição das versões locais. AVISO: Esta configuração requer a existência de uma ligação à internet, caso contrário a funcionalidade AJAX não funcionará no site. Esta configuração não é compatível com sites que usam https.';
$string['configuserquota'] = 'Número máximo de bytes que um utilizador pode ocupar na sua área de ficheiros privados. Nota: {$a->bytes} bytes correspondem a {$a->displaysize}';
$string['configusesitenameforsitepages'] = 'Se ativar esta opção, o nome curto do site será apresentado na barra de Navegação com hiperligação para as Páginas do site, em vez do texto \'Páginas do site\'';
$string['configusetags'] = 'Ativar a funcionalidade palavras-chave em todo o site';
$string['configvariables'] = 'Variáveis';
$string['configverifychangedemail'] = 'Ativa a verificação de endereços de e-mail quando os mesmos são alterados, tendo em conta as configurações dos domínios permitidos. Se esta configuração se encontrar inativa as configurações dos domínios permitidos são considerados apenas durante a criação de novos utilizadores.';
$string['configvisiblecourses'] = 'mostrar normalmente disciplinas em categorias escondidas.';
$string['configwarning'] = 'Tenha cuidado ao alterar estas configurações - valores estranhos poderão causar problemas.';
$string['configyuicomboloading'] = 'Estas opções permitem ativar a optimização do carregamento combinado de ficheiros das bibliotecas YUI. Esta configuração deve estar ativa em sites em produção, por questões de desempenho.';
$string['confirmation'] = 'Confirmação';
$string['confirmdeletecomments'] = 'Tem a certeza de que pretende apagar comentários?';
$string['confirmed'] = 'Confirmado';
$string['cookiehttponly'] = 'Utilizar apenas cookies HTTP';
$string['cookiesecure'] = 'Utilizar apenas cookies seguros';
$string['country'] = 'País predefinido';
$string['coursecontact'] = 'Titulares das disciplinas';
$string['coursecontact_desc'] = 'Esta configuração define quem aparece junto da descrição das disciplinas. Os utilizadores que tenham pelo menos um destes papéis nas disciplinas aparecerão junto das descrições das mesmas.';
$string['courselistshortnames'] = 'Mostrar nomes extensos das disciplinas';
$string['courselistshortnames_desc'] = 'Se ativar esta opção, o nome curto das disciplinas será exibido junto do nome completo na lista de disciplinas. Se necessário, estes nomes extensos das disciplinas podem ser personalizados através da edição da string \'courseextendednamedisplay\' utilizando a funcionalidade de personalização do pacote linguístico.';
$string['coursemgmt'] = 'Gerir disciplinas e categorias';
$string['courseoverview'] = 'Visão geral da disciplina';
$string['courserequestnotify'] = 'Notificação de pedido de disciplina';
$string['courserequestnotifyemail'] = 'Utilizador {$a->user} pediu uma nova disciplina em {$a->link}';
$string['courserequests'] = 'Disciplinas pedidas';
$string['courserequestspending'] = 'Disciplinas pedidas pendentes';
$string['courses'] = 'Disciplinas';
$string['coursesperpage'] = 'N.º de Disciplinas mostradas por página';
$string['courseswithsummarieslimit'] = 'Número máximo de disciplinas com descrição';
$string['creatornewroleid'] = 'Papel a atribuir ao criador nas novas disciplinas';
$string['creatornewroleid_help'] = 'Se o utilizador ainda não tem permissão para gerir a nova disciplina então é-lhe automaticamente atribuído este papel.';
$string['cron'] = 'Cron';
$string['cron_help'] = 'O script de manutenção \'cron.php\' realiza periodicamente um conjunto de tarefas necessárias, tais como o envio por e-mail de novas mensagens submetidas nos fóruns. Este script deve ser executado com regularidade - idealmente a cada minuto.';
$string['cron_link'] = 'Link para executar o script cron';
$string['cronclionly'] = 'Limitar execução do cron à linha de comandos';
$string['cronerrorclionly'] = 'O acesso via Internet a esta página foi desativado pelo administrador.';
$string['cronerrorpassword'] = 'Não indicou uma senha válida para aceder a esta página';
$string['cronremotepassword'] = 'Senha do cron para acesso remoto';
$string['cronwarning'] = 'O script de manutenção \'<a href="{$a}">cron.php</a>\' não é executado há pelo menos 24 horas.';
$string['cronwarningcli'] = 'O script de manutenção \'cron.php\' não é executado há pelo menos 24 horas.';
$string['ctyperequired'] = 'A extensão ctype PHP é requerida pelo Moodle, a fim de melhorar o desempenho do site e para oferecer compatibilidade multilingue.';
$string['curlcache'] = 'TTL da cache do cURL';
$string['curlrequired'] = 'A instalação da extensão cURL do PHP é obrigatória para permitir ao Moodle comunicar com os repositórios.';
$string['curlsecurityallowedport'] = 'Lista de portas permitidas do cURL';
$string['curlsecurityallowedportsyntax'] = 'Lista dos números das portas que o cURL se pode se ligar. Apenas números inteiros são entradas válidas. Coloque cada entrada numa nova linha. Se deixar vazio, todas as portas são permitidas. Se for definido, em quase todos os casos, tanto a porta 443 como a porta 80 devem ser especificadas para que o cURL ligue através das portas padrão de HTTPS e HTTP';
$string['curlsecurityblockedhosts'] = 'Lista de servidores bloqueados do cURL';
$string['curlsecurityblockedhostssyntax'] = 'Coloque cada entrada numa nova linha. As entradas válidas são endereços completos IPv4 ou IPv6 (tal como 192.168.10.1, 0:0:0:0:0:0:0:1, ::1, fe80::) que corresponde a um único servidor; ou um registo CIDR (tal como 231.54.211.0/20 ou fe80::/64); ou um intervalo de endereços IP (tal como 231.3.56.10-20 ou fe80::1111-bbbb) em que o intervalo se aplica ao último grupo do endereço; ou nomes de domínio (tal como localhost ou exemplo.com); ou nomes de domínio com caracteres universais (tal como *.exemplo.com or *.sub.exemplo.com). Não são permitidas linhas em branco.';
$string['curlsecurityurlblocked'] = 'O URL está bloqueado.';
$string['curltimeoutkbitrate'] = 'Bitrate que deve ser usado no cálculo de timetouts do cURL (Kbps).';
$string['curltimeoutkbitrate_help'] = 'Esta configuração é usada para calcular um valor apropriado de timeout em pedidos cURL de grande dimensão. Neste cálculo é realizado um pedido HTTP HEAD para determinar a dimensão do conteúdo. Se definir o valor 0 (zero) nesta configuração este pedido HTTP HEAD não é realizado.';
$string['currenttheme'] = 'Tema atual';
$string['customcheck'] = 'Outras verificações';
$string['custommenu'] = 'Menu personalizado';
$string['custommenuitems'] = 'Elementos de menu personalizados';
$string['customusermenuitems'] = 'Itens do menu do utilizador';
$string['datarootsecurityerror'] = '<p><strong>AVISO DE SEGURANÇA!</strong></p><p>A sua pasta raiz de dados está numa localização errada e está exposta à web. Isto significa que todos os seus ficheiros privados estão disponíveis para qualquer pessoa e alguns deles podem ser usados por um hacker para obter acesso de administrador não autorizado ao seu site!</p><p><strong>Deve</strong> mover a pasta raiz de dados ({$a}) para um novo local que não esteja dentro da sua pasta pública da web, e atualizar a configuração <code>$CFG->dataroot</code> no ficheiro config.php em conformidade.</p>';
$string['datarootsecuritywarning'] = 'A configuração do seu site pode não ser segura. <br />Certifique-se de que a pasta <br /><strong>{$a}</strong><br /> não é acessível através da Internet.';
$string['dbsessions'] = 'Guardar a informação sobre sessões na base de dados';
$string['debug'] = 'Mensagens de erro';
$string['debugall'] = 'TODAS: Mostrar todas as mensagens de erro razoáveis do PHP';
$string['debugdeveloper'] = 'PROGRAMADOR: Mensagens de erro adicionais, para programadores';
$string['debugdisplay'] = 'Mostrar mensagens de erro';
$string['debugging'] = 'Erros';
$string['debugminimal'] = 'MÍNIMO: Mostrar apenas erros graves';
$string['debugnone'] = 'NADA: Não mostrar quaisquer erros ou advertências';
$string['debugnormal'] = 'NORMAL: Mostrar erros, advertências e avisos';
$string['debugpageinfo'] = 'Mostrar informação da página';
$string['debugsmtp'] = 'Analisar erros no envio de e-mail';
$string['debugstringids'] = 'Mostrar localização das traduções';
$string['debugstringids_desc'] = 'Se ativar esta opção, será mostrada a componente e identificador de cada string exibida se adicionar \'?strings=1\' ou \'&strings=1\' ao URL.';
$string['debugvalidators'] = 'Mostrar hiperligações de validação';
$string['defaultcity'] = 'Cidade predefinida';
$string['defaultcity_help'] = 'A cidade aqui indicada será a cidade predefinida para as novas contas de utilizador que forem criadas.';
$string['defaultformatnotset'] = 'Erro ao determinar o formato predefinido da disciplina. Por favor, verifique as configurações do site.';
$string['defaulthomepage'] = 'Página inicial predefinida para os utilizadores';
$string['defaultrequestcategory'] = 'Categoria predefinida a atribuir às disciplinas pedidas';
$string['defaultsettinginfo'] = 'Valor predefinido: {$a}';
$string['defaultuserroleid'] = 'Papel predefinido de todos os utilizadores';
$string['deleteincompleteusers'] = 'Apagar utilizadores incompletos após';
$string['deleteunconfirmed'] = 'Apagar utilizadores não confirmados após';
$string['deleteuser'] = 'Apagar utilizador';
$string['density'] = 'Densidade';
$string['denyemailaddresses'] = 'Domínios de e-mail rejeitados';
$string['development'] = 'Desenvolvimento';
$string['devicedetectregex'] = 'Expressões regulares (REGEXP) para deteção de dispositivos';
$string['devicedetectregex_desc'] = '<p>Por predefinição, o Moodle pode detetar dispositivos do tipo Default (computadores, portáteis, ...), Mobile (telemóveis, pdas, ...), Tablet (iPads, Android, ...) e outros (Ex: utilizadores que usam navegadores mais antigos como o Internet Explorer 6).  O seletor de temas pode ser usado para aplicar temas diferentes de acordo com o tipo de dispositivo usado pelos utilizadores. Esta configuração permite definir expressões regulares que façam a deteção de outros dispositivos não previstos originalmente  (estas regras de deteção têm precedência sobre os tipos predefinidos).</p>
<p>Por exemplo, pode usar a expressão "/(MIDP-1.0|Maemo|Windows CE)/" para detetar alguns telemóveis não previstos e retornar o valor "outros telemóveis".  Esta definição adicionará o valor "outros telemóveis" no seletor de temas, podendo assim selecionar um tema específico para este tipo de dispositivos. De qualquer forma, telemóveis que não se enquadrem na nova regra criada, usarão o tema que estiver selecionado para o seu tipo de dispositivo.</p>';
$string['devicedetectregexexpression'] = 'Expressão regular (REGEXP)';
$string['devicedetectregexvalue'] = 'Valor de retorno';
$string['devicetype'] = 'Tipo de dispositivo';
$string['devlibdirpresent'] = 'As diretorias com bibliotecas de desenvolvimento, especialmente <em>/vendor</em> e <em>/node_modules</em>, não devem estar presentes em sites públicos. Consulte o <a href="{$a->moreinfourl}"> relatório da vista geral de segurança</a> para mais detalhes.';
$string['disableuserimages'] = 'Desativar fotografia de perfil de utilizador';
$string['displayerrorswarning'] = 'Por questões de segurança a configuração <em>display_errors</em> do PHP (ficheiro php.ini) não deve estar ativa, pois pode ser revelada alguma informação sensível do servidor através das mensagens de erro.';
$string['displayloginfailures'] = 'Mostrar tentativas falhadas de autenticação';
$string['dndallowtextandlinks'] = 'Ativar arrastar e largar para carregar textos/hiperligações';
$string['doclang'] = 'Idioma a usar nas páginas de documentação';
$string['docroot'] = 'URL da documentação Moodle';
$string['doctonewwindow'] = 'Abrir numa nova janela';
$string['doesnotfit'] = 'Configurações de privacidade do e-mail';
$string['doesnotfitdetail'] = 'Mostrar definições para os e-mails enviados pelo Moodle';
$string['download'] = 'Exportar para ficheiro';
$string['durationunits'] = 'Duração das unidades';
$string['edithelpdocs'] = 'Editar documentos de ajuda';
$string['editlang'] = '<strong>Editar</strong>';
$string['editorbackgroundcolor'] = 'Cor de fundo';
$string['editordictionary'] = 'Dicionário do editor';
$string['editorfontfamily'] = 'Tipo de letra';
$string['editorfontlist'] = 'Lista de tipos de letra';
$string['editorfontsize'] = 'Tamanho do tipo de letra';
$string['editorhidebuttons'] = 'Botões ocultos';
$string['editorkillword'] = 'Ativar filtro do formato Word';
$string['editorspelling'] = 'Dicionário do Editor';
$string['editorspellinghelp'] = 'Ativa a correção automática. Para funcionar, o <strong>aspell</strong> deve estar instalado no servidor.';
$string['editstrings'] = 'Editar frases';
$string['emailchangeconfirmation'] = 'Ativar confirmação de mudança de e-mail';
$string['emailfromvia'] = 'Informações via e-mail';
$string['emoticonalt'] = 'Informação alternativa';
$string['emoticoncomponent'] = 'Componente';
$string['emoticonimagename'] = 'Nome da imagem';
$string['emoticons'] = 'Emoticons';
$string['emoticons_desc'] = 'Este formulário define os emoticons (smileys) usados no site. <br />Para voltar aos valores definidos originalmente pelo Moodle clique na hiperligação acima.<br />Para remover uma linha da tabela grave o formulário com um valor vazio em qualquer dos campos obrigatórios da linha que pretende remover. <br />Para registar um novo emoticon preencha os campos na última linha em branco, de acordo com as seguintes regras: <br /><strong>Texto (obrigatório)</strong> - Este texto vai ser substituído com a imagem do emoticon. Tem que conter pelo menos dois caracteres.<br /><strong>Nome da imagem (obrigatório)</strong> - Nome do ficheiro da imagem do emoticon, sem extensão do ficheiro, relativamente à pasta dos componentes pix.<br /><strong>Componente (obrigatório)</strong> - Componente de imagem que fornece o ícone.<br /><strong>Texto alternativo (opcional)</strong> - Identificador do texto e componente do texto alternativos do emoticon.';
$string['emoticonsreset'] = 'Repor configurações predefinidas dos emoticons';
$string['emoticontext'] = 'Texto';
$string['emptysettingvalue'] = 'Vazio';
$string['enableactivitychooser'] = 'Ativar modo de seleção rápida';
$string['enableblogs'] = 'Ativar blogues';
$string['enablecalendarexport'] = 'Ativar exportação do calendário';
$string['enablecomments'] = 'Ativar comentários';
$string['enablecourserequests'] = 'Ativar pedido de disciplinas';
$string['enabled'] = 'Ativado';
$string['enabledevicedetection'] = 'Ativar detecção de dispositivo';
$string['enableglobalsearch'] = 'Ativar pesquisa global';
$string['enableglobalsearch_desc'] = 'Se ativar esta opção, os dados serão indexados e sincronizados por uma tarefa agendada.';
$string['enablegravatar'] = 'Ativar Gravatar';
$string['enablegravatar_help'] = 'Se ativar esta opção, o Moodle tentará obter uma imagem para o perfil do utilizador a partir da base de dados Gravatar (http://gravatar.com), caso o utilizador não tenha carregado nenhuma imagem.';
$string['enablemobilewebservice'] = 'Ativar web services para dispositivos móveis';
$string['enablerecordcache'] = 'Ativar cache de registos';
$string['enablerssfeeds'] = 'Ativar listas RSS';
$string['enablesafebrowserintegration'] = 'Ativar a integração Safe Exam Browser';
$string['enablesearchareas'] = 'Permitir áreas de pesquisa';
$string['enablestats'] = 'Ativar estatísticas';
$string['enabletrusttext'] = 'Ativar conteúdo Fiável';
$string['enablewebservices'] = 'Ativar web services';
$string['enablewsdocumentation'] = 'Documentação dos web services';
$string['enrolinstancedefaults'] = 'Valores predefinidos das utilizações de módulos de inscrição';
$string['enrolinstancedefaults_desc'] = 'Valores predefinidos das configurações de inscrições em novas disciplinas.';
$string['enrolmultipleusers'] = 'Inscrever os utilizadores';
$string['environment'] = 'Ambiente';
$string['environmenterrortodo'] = 'Tem de resolver todos os problemas de ambiente (erros) indicados acima antes de instalar esta versão do Moodle!';
$string['environmenterrorupgrade'] = 'Advertência: deve resolver todos os problemas de ambiente (erros) detetados, antes de atualizar para esta versão do Moodle! Continuar a atualização sem resolver esses problemas, poderá ter consequências, como por exemplo, a perda de dados. Tem a certeza de que pretende continuar com a atualização?';
$string['environmentmariadbwrongdbtype'] = '<code>$CFG->dbtype</code> incorreto: tem de alterá-lo no ficheiro <code>config.php</code> de \'<code>mysql</code>\' para \'<code>mariadb</code>\'.';
$string['environmentmustfixsetting'] = 'A configuração do PHP tem que ser alterada.';
$string['environmentok'] = 'O seu servidor cumpre todos os requisitos mínimos.';
$string['environmentrecommendcustomcheck'] = 'se este teste falhar pode existir um problema';
$string['environmentrecommendinstall'] = 'recomenda-se a sua instalação e ativação para melhores resultados';
$string['environmentrecommendversion'] = 'é recomendada a versão {$a->needed} e atualmente está a correr a versão {$a->current}';
$string['environmentrequirecustomcheck'] = 'Este teste deve passar';
$string['environmentrequireinstall'] = 'deve estar instalada e ativa';
$string['environmentrequireversion'] = 'é requerida a versão {$a->needed} e está a correr a versão {$a->current}';
$string['environmentsettingok'] = 'foi detetada uma configuração recomendada';
$string['environmentshouldfixsetting'] = 'A configuração do PHP deve ser alterada.';
$string['environmentxmlerror'] = 'Erros ao ler dados do ambiente ({$a->error_code})';
$string['errordeletingconfig'] = 'Ocorreu um erro ao apagar os registos de configuração do módulo  \'{$a}\' .';
$string['errorsetting'] = 'Não foi possível guardar as configurações:';
$string['errorwithsettings'] = 'Algumas configurações não foram modificadas devido a um erro:';
$string['eventshandlersinuse'] = 'Os seguintes módulos no seu sistema utilizam manipuladores obsoletos da API Events 1: \'{$a}\'. Por favor, atualize-os para utilizar API Events 2. Consulte a página https://docs.moodle.org/dev/Event_2#Event_dispatching_and_observers.';
$string['everyonewhocan'] = 'Todos com permissão \'{$a}\'';
$string['exceptions'] = 'exceções';
$string['execpathnotallowed'] = 'Definição de caminhos executáveis e locais desativada em config.php';
$string['experimental'] = 'Experimental';
$string['experimentalsettings'] = 'Configurações experimentais';
$string['extendedusernamechars'] = 'Permitir caracteres especiais no nome de utilizador';
$string['extramemorylimit'] = 'Limite extra de memória PHP';
$string['fatalsessionautostart'] = '<p>Foi detetado um erro grave de configuração, por favor informe o administrador do site.</p><p> Para funcionar corretamente é necessário que o administrador altere as configurações do PHP.</p><p><code>session.auto_start</code> deve estar definido como <code>off</code>.</p><p>Esta configuração é alterada no ficheiro <code>php.ini</code>, no ficheiro de configuração do Apache/IIS <br /> ou no ficheiro <code>.htaccess</code> no servidor.</p>';
$string['fileconversioncleanuptask'] = 'Limpeza dos registos temporários das conversões de ficheiros';
$string['filecreated'] = 'Criado um novo ficheiro';
$string['filestoredin'] = 'Guardar ficheiro na pasta:';
$string['filestoredinhelp'] = 'Onde o ficheiro será guardado';
$string['filterall'] = 'Filtrar todos os textos';
$string['filtermatchoneperpage'] = 'Filtrar um por página';
$string['filtermatchonepertext'] = 'Filtrar um por texto';
$string['filters'] = 'Filtros';
$string['filtersettings'] = 'Gerir filtros';
$string['filtersettingsgeneral'] = 'Definições gerais dos filtros';
$string['filteruploadedfiles'] = 'Filtrar envios de ficheiros';
$string['forceclean'] = 'Limpeza geral de conteúdos';
$string['forceclean_desc'] = 'O conteúdo adicionado ao site é normalmente limpo antes de ser mostrado, para remover tudo o que possa ser uma ameaça à segurança. No entanto, o conteúdo não é limpo em determinados locais, tais como, descrições das atividades, páginas ou blocos HTML, para permitir que sejam adicionados scripts, ficheiros multimédia, molduras incorporadas, etc. Se ativar esta configuração, TODO o conteúdo será limpo. Isto pode resultar que o conteúdo existente não seja mostrado corretamente.';
$string['forcelogin'] = 'Forçar autenticação dos utilizadores';
$string['forceloginforprofileimage'] = 'Forçar os utilizadores a autenticarem-se para visualizarem as fotos dos utilizadores';
$string['forceloginforprofileimage_help'] = 'Se ativar esta opção, os utilizadores devem autenticar-se para verem fotos de perfil e a imagem de utilizador predefinida será usada em todos os e-mails de notificação.';
$string['forceloginforprofiles'] = 'Forçar os utilizadores a autenticarem-se para visualizarem os perfis';
$string['forcetimezone'] = 'Forçar fuso horário';
$string['formatuninstallwithcourses'] = 'Existem {$a->count} disciplinas a utilizar o formato {$a->format}. O formato das disciplinas será alterado para {$a->defaultformat} (formato predefinido para este site). Poderão perder-se alguns dados específicos deste formato. Tem a certeza de que pretende continuar?';
$string['frontpage'] = 'Página principal';
$string['frontpagebackup'] = 'Cópia de segurança da página principal';
$string['frontpagedefaultrole'] = 'Papel a atribuir automaticamente na página principal';
$string['frontpagefilters'] = 'Filtros da página principal';
$string['frontpageloggedin'] = 'Página principal, quando autenticado';
$string['frontpageoverrides'] = 'Redefinições das permissões da página principal';
$string['frontpagequestions'] = 'Perguntas da página principal';
$string['frontpagerestore'] = 'Restauro da página principal';
$string['frontpageroles'] = 'Atribuir papéis na página principal';
$string['frontpagesettings'] = 'Configurar página principal';
$string['fullnamedisplay'] = 'Formato do nome completo';
$string['fullnamedisplayprivate'] = 'Formato do nome completo - privado';
$string['gdrequired'] = 'A extensão GD é agora exigida pelo Moodle para conversão de imagens.';
$string['generalsettings'] = 'Configurações gerais';
$string['geoipfile'] = 'Base de dados GeoLite2 City MaxMind';
$string['getremoteaddrconf'] = 'Origem do endereço IP';
$string['globalsearch'] = 'Pesquisa global';
$string['globalsearchmanage'] = 'Gerir pesquisa global';
$string['googlemapkey3'] = 'Chave da API V3 do Google Maps';
$string['googlemapkey3_help'] = 'É necessária uma chave especial para usar o Google Maps de modo a poder visualizar a localização de endereços IP. Essa chave pode ser obtida gratuitamente na página <a href="https://developers.google.com/maps/documentation/javascript/tutorial#api_key" target="_blank">https://developers.google.com/maps/documentation/javascript/tutorial#api_key</a>';
$string['gotofirst'] = 'Ir para primeira frase em falta';
$string['gradebook'] = 'Pauta';
$string['gradebookroles'] = 'Papéis mostrados na pauta';
$string['gradeexport'] = 'Métodos primários de exportação de notas';
$string['gravatardefaulturl'] = 'URL da imagem predefinida do Gravatar';
$string['gravatardefaulturl_help'] = 'É necessário especificar uma imagem predefinida para o caso do Gravatar não encontrar uma imagem para um determinado utilizador. Indique um URL completo de uma imagem. Se deixar em branco, o Moodle tentará usar a imagem predefinida mais adequada para a página que está a ver. Note ainda que o Gravatar tem um conjunto de códigos que pode usar para <a href="https://en.gravatar.com/site/implement/images/#default-image">gerar imagens predefinidas</a>.';
$string['groupenrolmentkeypolicy'] = 'Política para a senha de inscrição nos grupos';
$string['groupenrolmentkeypolicy_desc'] = 'Se ativar esta opção, as senhas de inscrição nos grupos terão de cumprir a política de senhas especificada nas configurações abaixo.';
$string['guestroleid'] = 'Papel a atribuir aos visitantes';
$string['guestroleid_help'] = 'Este papel é atribuído automaticamente ao utilizador "Visitante". É também atribuído temporariamente a utilizadores não inscritos na disciplina que acedem através do módulo de inscrição Visitante.';
$string['helpadminseesall'] = 'No calendário do site, os administradores veem e filtram eventos de todos os calendários de disciplinas ou apenas das disciplinas em que estão inscritos? Independentemente da opção escolhida, os administradores poderão sempre gerir eventos do calendário de cada disciplina se acederem à disciplina e depois diretamente ao calendário.';
$string['helpcalendarcustomexport'] = 'Ativar a opção de exportação de intervalo personalizado de datas nas exportações do calendário. Note que as exportações do calendário devem ser ativadas antes de definir esta opção.';
$string['helpexportlookahead'] = 'Número de dias futuros a considerar';
$string['helpexportlookback'] = 'Ao longo de quantos dias antecedentes deve o calendário procurar eventos durante a exportação para a opção de exportação personalizada?';
$string['helpforcetimezone'] = 'Esta configuração permite definir se os utilizadores podem escolher individualmente o seu fuso horário ou se este é definido ao nível do sistema para todos os utilizadores.';
$string['helpshowicalsource'] = 'Se ativar esta opção, o nome da subscrição e respetiva hiperligação serão exibidas nos eventos iCal importados.';
$string['helpsitemaintenance'] = 'Para atualizações e outras tarefas';
$string['helpstartofweek'] = 'Em que dia começa a semana no calendário?';
$string['helpupcominglookahead'] = 'Quantos dias futuros devem ser considerados por predefinição para detetar os eventos que vão ocorrer?';
$string['helpupcomingmaxevents'] = 'Qual o número máximo de eventos futuros que podem ser mostrados aos utilizadores, por predefinição?';
$string['helpweekenddays'] = 'Quais os dias da semana que são considerados como "Fim de Semana" e apresentados com uma cor diferente?';
$string['hiddenuserfields'] = 'Campos de utilizador a ocultar';
$string['hidefromall'] = 'Ocultar a todos os utilizadores';
$string['hidefromnone'] = 'Não ocultar a ninguém';
$string['hidefromstudents'] = 'Ocultar aos alunos';
$string['htmleditor'] = 'Editor HTML';
$string['htmleditorsettings'] = 'Configurações do editor de HTML';
$string['htmlsettings'] = 'Configurações HTML';
$string['http'] = 'HTTP';
$string['httpsecurity'] = 'Segurança HTTP';
$string['hubs'] = 'Centros';
$string['iconvrequired'] = 'É obrigatória a instalação da extensão ICONV.';
$string['ignore'] = 'Ignorar';
$string['includemoduleuserdata'] = 'Incluir dados de utilizador dos módulos';
$string['incompatibleblocks'] = 'Blocos incompatíveis';
$string['incompleteunicodesupport'] = 'A configuração atual do MySQL ou MariaDB utiliza \'utf8\'. Esta definição de caracteres não suporta caracteres de quatro byte que incluem alguns emoji. Se tentar usar estes caracteres resultará em erro ao atualizar um registo e qualquer informação que esteja a ser enviada para a base de dados será perdida. Considere alterar as suas configurações para \'utf8mb4\'. Consulte a documentação para obter mais detalhes.';
$string['indexdata'] = 'Dados do índice';
$string['indexinginfo'] = 'A forma recomendada para indexar os conteúdos do seu site é utilizar a tarefa agendada "Indexação da pesquisa global".';
$string['installhijacked'] = 'A instalação tem que ser concluída a partir do endereço de IP inicial.';
$string['installsessionerror'] = 'Não foi possível iniciar a sessão PHP, verifique, por favor, se o seu navegador aceita cookies.';
$string['intlrecommended'] = 'A extensão Intl do PHP é usada para melhorar as funcionalidades de internacionalização do Moodle e a ordenação de acordo com o local.';
$string['intlrequired'] = 'A extensão Intl é necessária para melhorar o suporte à internacionalização, tais como a classificação local e os nomes de domínios internacionais.';
$string['invalidagedigitalconsent'] = 'A idade mínima de consentimento não é válida: {$a}';
$string['invalidforgottenpasswordurl'] = 'O URL da recuperação da senha não é um URL válido.';
$string['invalidsection'] = 'Secção inválida';
$string['invaliduserchangeme'] = 'O nome de utilizador "changeme" está reservado -- não pode criar uma conta com este nome.';
$string['ipblocked'] = 'Atualmente este site não está disponível.';
$string['ipblocker'] = 'Restringir IPs';
$string['ipblockersyntax'] = 'Coloque cada elemento numa linha separada. As entradas válidas são endereços de IP completos (tal como <b>192.168.10.1</b>) que corresponde a um único servidor; ou endereços parciais (tal como <b>192.168</b>) que corresponde a qualquer endereço que comece com aqueles números; ou um registo CIDR (tal como <b>231.54.211.0/20</b>); ou um intervalo de endereços IP (tal como <b>231.3.56.10-20</b>) em que o intervalo se aplica à última parte do endereço. Nomes de domínio de texto (tal como \'exemplo.com\') não são suportados. Linhas em branco são ignoradas.';
$string['iplookup'] = 'Localização de endereço IP';
$string['iplookupgeoplugin'] = '<a href="http://www.geoplugin.com">geoPlugin</a> é usado para procurar informação geográfica. Para obter resultados mais precisos recomendamos instalar uma cópia local do base de dados GeoLite MaxMind.';
$string['iplookupinfo'] = 'Por predefinição o Moodle usa o servidor NetGeo (base de dados geográficos gratuita) para localizar endereços IP. Contudo, esta base de dados deixou de ser atualizada e poderá devolver dados <em>completamente incorretos</em>. É recomendada a instalação de uma cópia local da base de dados (gratuita) GeoLite2 City da MaxMind. <br />
A localização dos endereços IP é apresentada num mapa simples ou através do Google Maps. Por favor, tenha em atenção que é necessário ter uma conta no Google e obter uma chave gratuita para a API do Google Maps para ser possível ativar os mapas interativos.';
$string['iplookupmaxmindnote'] = 'Este produto inclui dados do GeoLite2, criado pela MaxMind, disponível em <a href="http://www.maxmind.com/">http://www.maxmind.com/</a>.';
$string['ishttpswarning'] = 'Foi detetado que o seu site não utiliza o protocolo de segurança HTTPS. É fortemente recomendado que migre o seu site para o protocolo HTTPS de modo a incrementar a segurança e melhorar a integração com outros sistemas.';
$string['keeptagnamecase'] = 'Manter maiúsculas/minúsculas nas palavras-chave';
$string['lang'] = 'Idioma predefinido';
$string['langcache'] = 'Cache do menu de idiomas';
$string['langcache_desc'] = 'Guardar em cache o menu de idiomas. Se esta configuração estiver ativa, a lista de idiomas disponíveis fica guardada em memória cache. Esta memória de acesso rápido é atualizada de forma automática quando um pacote linguístico é instalado ou removido através da interface do Moodle. Se instalar ou remover um novo idioma manualmente (colocando ou removendo um pacote linguístico diretamente no servidor) terá que usar a funcionalidade <b>Apagar o conteúdo de todas as caches</b> para atualizar o menu de idiomas.';
$string['langlist'] = 'Idiomas a mostrar no menu de idiomas';
$string['langmenu'] = 'Mostrar menu de idiomas';
$string['langpackwillbeupdated'] = 'Nota: Durante a atualização, o Moodle tentará atualizar os pacotes linguísticos instalados.';
$string['langstringcache'] = 'Cache de todas as palavras do idioma';
$string['languagesettings'] = 'Configurar idioma';
$string['latinexcelexport'] = 'Codificação Excel';
$string['legacyfilesaddallowed'] = 'Permitir adicionar ficheiros de retrocompatibilidade da disciplina';
$string['legacyfilesaddallowed_help'] = 'Se uma disciplina tiver ficheiros de retrocompatibilidade da disciplina, permite que novos ficheiros e pastas lhe sejam adicionados.';
$string['legacyfilesinnewcourses'] = 'Antigos \'Ficheiros da disciplina\' (Moodle 1.9) nas novas disciplinas (Moodle 2.0)';
$string['legacyfilesinnewcourses_help'] = 'Por predefinição, os ficheiros de retrocompatibilidade da disciplina (Moodle 1.9) apenas estão disponíveis nas disciplinas que tenham sido atualizadas a partir de versões anteriores à 2.0. Nestes casos, algumas funcionalidades, tal como realizar e restaurar uma cópia de segurança, não estão disponíveis.';
$string['libcurlwarning'] = 'Foi detetado que o libcurl não tem suporte para o CURLOPT_PROTOCOL. Recomenda-se a instalação atualizada do libcurl por razões de segurança.';
$string['licensesettings'] = 'Configurações da licença';
$string['linkadmincategories'] = 'Hiperligações para as categorias de administração';
$string['linkadmincategories_help'] = 'Se ativar esta opção, as categorias de configurações da Administração do Site serão mostradas como hiperligações na Navegação apontando para as páginas de configurações da categoria.';
$string['linkcoursesections'] = 'Hiperligações para as secções da disciplina';
$string['linkcoursesections_help'] = 'Tentar sempre disponibilizar uma hiperligação para as secções da disciplina. As hiperligações para as secções da disciplina estão sempre disponíveis quando o formato da disciplina está definido para apresentar apenas uma secção por página. Se ativar esta opção, será sempre disponibilizada uma hiperligação.';
$string['loading'] = 'A carregar';
$string['localetext'] = 'Locale do site';
$string['localstringcustomization'] = 'Personalização local do idioma';
$string['location'] = 'Localização';
$string['locationsettings'] = 'Configurar localização';
$string['locked'] = 'Bloqueado';
$string['lockoutduration'] = 'Duração do bloqueio de conta';
$string['lockoutduration_desc'] = 'O bloqueio de conta será automaticamente desbloqueado depois desta duração.';
$string['lockoutemailbody'] = 'A sua conta com o nome de utilizador \'{$a->username}\' no servidor \'{$a->sitename}\' foi bloqueada após múltiplas tentativas de autenticação inválidas.

Para desbloquear imediatamente a conta, aceda ao seguinte endereço:

{$a->link}

Se o endereço acima não for apresentado como uma hiperligação em que basta clicar, copie o endereço e cole na linha de endereço do seu navegador de Internet.

Se precisar de ajuda, por favor, contacte o administrador do site, {$a->admin}.';
$string['lockoutemailsubject'] = 'A sua conta em \'{$a}\' foi bloqueada.';
$string['lockouterrorunlock'] = 'A informação fornecida para desbloqueio de conta é inválida.';
$string['lockoutthreshold'] = 'Limite de bloqueio de conta';
$string['lockoutthreshold_desc'] = 'Selecione o número de tentativas de autenticação falhadas que geram o bloqueio da conta. Esta funcionalidade poderá ser usada em ataques de negação de serviço.';
$string['lockoutwindow'] = 'Tempo do limite de bloqueio de conta';
$string['lockoutwindow_desc'] = 'Período de tempo para verificação do limite de bloqueio da conta. O contador te tentativas falhadas será reiniciado após este período, caso não hajam tentativas de autenticação falhadas.';
$string['log'] = 'Registos de atividade';
$string['logguests'] = 'Registar acessos dos utilizadores com o papel de Visitante';
$string['logguests_help'] = 'Esta configuração ativa o registo das ações das contas de visitantes e utilizadores não autenticados. Em sites com muita atividade pode ser desejável desativar este parâmetro para melhorar o desempenho. A ativação deste parâmetro é recomendada em sites de produção.';
$string['loginhttps'] = 'Usar HTTPS para autenticação';
$string['loginpageautofocus'] = 'Autofocus do formulário da página de autenticação';
$string['loginpageautofocus_help'] = 'A ativação desta opção melhora a usabilidade da página de autenticação, mas o foco automático de campos de formulário pode ser considerado desfavorável em termos de acessibilidade.';
$string['loginpasswordautocomplete'] = 'Evitar a opção de autocompletar a senha no formulário de autenticação';
$string['loginpasswordautocomplete_help'] = 'Se ativar esta opção, os utilizadores não terão permissão para guardar a senha da sua conta no seu navegador.';
$string['loglifetime'] = 'Manter registos de atividade durante';
$string['logo'] = 'Logótipo';
$string['logo_desc'] = 'Um logótipo completo para ser utilizado como decoração por alguns temas (tal como temas predefinidos). Esta imagem poderá ser de elevada resolução porque será reduzida para utilização (e armazenada em cache para desempenho). Os logótipos com uma largura superior à altura costumam resultar melhor. Os formatos aceites são PNG e JPG.';
$string['logocompact'] = 'Logótipo compacto';
$string['logocompact_desc'] = 'Versão compacta do logótipo acima, tal como um emblema, escudo ou ícone. A imagem deve ser nítida, mesmo em tamanhos reduzidos. Os formatos aceites são PNG e JPG.';
$string['logossettings'] = 'Logótipos';
$string['logstorenotrequired'] = 'Não é necessária a unidade de armazenamento de registos de atividade';
$string['logstoressupported'] = 'Unidades de armazenamento de registos de atividade que suportam este relatório';
$string['longtimewarning'] = '<strong> Tome nota que este processo pode demorar muito tempo. </strong>q';
$string['mailnewline'] = 'Caracteres de nova linha na mensagem';
$string['maintenancemode'] = 'Em modo de manutenção';
$string['maintenancemodeisscheduled'] = 'O site entrará em modo de manutenção dentro de {$a->min} minutos e {$a->sec} segundos';
$string['maintenancemodeisscheduledlong'] = 'Este site irá entrar em modo de manutenção em {$a->hour} horas, {$a->min} minutos e {$a->sec} segundos';
$string['maintfileopenerror'] = 'Erro ao abrir ficheiros de manutenção!';
$string['maintinprogress'] = 'Manutenção em progresso...';
$string['manageformats'] = 'Gerir formatos da disciplina';
$string['manageformatsgotosettings'] = 'O formato predefinido pode ser alterado em {$a}';
$string['managelang'] = 'Gerir';
$string['managelicenses'] = 'Gerir licenças';
$string['manageqbehaviours'] = 'Gerir comportamentos das perguntas';
$string['manageqtypes'] = 'Gerir tipos de perguntas';
$string['maturity100'] = 'Beta';
$string['maturity150'] = 'Versão candidata';
$string['maturity200'] = 'Versão estável';
$string['maturity50'] = 'Alfa';
$string['maturityallowunstable'] = 'Dica: Poderá querer executar este programa com a opção --allow-unstable';
$string['maturitycoreinfo'] = 'O seu site contém código de desenvolvimento instável: "{$a}"';
$string['maturitycorewarning'] = 'A versão do Moodle que pretende instalar, ou atualizar para, contém código de desenvolvimento instável "{$a}" que não deve ser usado em ambientes de produção. Se não for isto que pretende, confirme que está a fazer uma atualização a partir de uma versão estável do Moodle. Para mais informações, consulte a documentação oficial do Moodle.';
$string['maxbytes'] = 'Tamanho máximo dos ficheiros enviados';
$string['maxconsecutiveidentchars'] = 'Caracteres iguais consecutivos';
$string['maxeditingtime'] = 'Intervalo para edição de mensagens nos fóruns';
$string['maxtimelimit'] = 'Tempo limite máximo';
$string['maxtimelimit_desc'] = 'Para restringir o tempo máximo de execução PHP que o Moodle permitirá, sem que qualquer resultado seja exibido, digite um valor em segundos aqui. "0" significa que as restrições predefinidas do Moodle estão a ser usadas. Se tem um servidor de front-end com o seu próprio limite de tempo, defina este valor para um número mais baixo para receber os erros de PHP nos registos de atividade. Não se aplica aos scripts CLI.';
$string['maxusersperpage'] = 'Número máximo de utilizadores por página';
$string['mbstringrecommended'] = 'É recomendada a instalação da extensão MBSTRING do PHP para um melhor desempenho do site, principalmente se o site utiliza idiomas não-latinos.';
$string['mbstringrequired'] = 'É necessário instalar a biblioteca MBSTRING para melhorar o desempenho do site, principalmente se o seu site oferecer suporte a idiomas não latinos.';
$string['mediapluginavi'] = 'Ativar filtro .avi';
$string['mediapluginflv'] = 'Ativar filtro .flv';
$string['mediapluginimg'] = 'Ativar incorporação automática de imagens com hiperligações.';
$string['mediapluginmov'] = 'Ativar filtro .mov';
$string['mediapluginmp3'] = 'Ativar filtro .mp3';
$string['mediapluginmpg'] = 'Ativar filtro .mpg';
$string['mediapluginogg'] = 'Ativar filtro .ogg';
$string['mediapluginogv'] = 'Ativar filtro .ogv';
$string['mediapluginram'] = 'Ativar filtro .ram';
$string['mediapluginrm'] = 'Ativar filtro .rm';
$string['mediapluginrpm'] = 'Ativar filtro .rpm';
$string['mediapluginswf'] = 'Ativar filtro .swf';
$string['mediapluginswfnote'] = 'Como medida de segurança, os utilizadores normais não devem ser autorizados a incorporar ficheiros flash (swf).';
$string['mediapluginwmv'] = 'Ativar filtro .wmv';
$string['mediapluginyoutube'] = 'Ativar filtro de hiperligações do YouTube';
$string['messaging'] = 'Ativar sistema de envio de mensagens';
$string['messagingallowemailoverride'] = 'Alterar e-mail de notificação';
$string['messagingdeleteallnotificationsdelay'] = 'Apagar todas as notificações';
$string['messagingdeletereadnotificationsdelay'] = 'Apagar notificações já lidas';
$string['minpassworddigits'] = 'Caracteres numéricos';
$string['minpasswordlength'] = 'Dimensão da senha';
$string['minpasswordlower'] = 'Letras minúsculas';
$string['minpasswordnonalphanum'] = 'Caracteres não alfanuméricos';
$string['minpasswordupper'] = 'Letras maiúsculas';
$string['misc'] = 'Diversos';
$string['mnetrestore_extusers'] = '<strong>Nota:</strong> Esta cópia de segurança contém contas remotas de utilizadores da Rede Moodle que serão restauradas como parte do processo.';
$string['mnetrestore_extusers_admin'] = '<strong>Aviso:</strong> Este ficheiro de cópia de segurança parece provir de uma instalação Moodle diferente e contêm contas de utilizador remotas de Rede Moodle. O processo de restauração vai tentar identificar a Rede de anfitriões Moodle para todos os utilizadores criados. Aqueles que não coincidirem serão automaticamente registados com autenticação interna (no lugar da mnet). O log de restauração conterá informação detalhada sobre estas ocorrências.';
$string['mnetrestore_extusers_mismatch'] = '<strong>Nota:</strong> Esta cópia de segurança aparentemente tem origem numa instalação diferente do Moodle e contém contas de utilizadores remotos da Rede Moodle que podem não ser restauradas com sucesso. Esta operação não é suportada. Se tem a certeza de que foi criada nesta instalação do Moodle, ou se garantir que todos os servidores da Rede Moodle necessários estão configurados, pode querer tentar restaurar.';
$string['mnetrestore_extusers_noadmin'] = '<strong>Aviso:</strong> Este ficheiro de cópia de segurança parece provir de uma instalação Moodle diferente e contêm contas de utilizador remotas de Rede Moodle. Você não está autorizado a executar este tipo de restauração. Entre em contacto com o administrador do site, ou, alternativa, restaure a disciplina sem informação de utilizadores (módulos, ficheiros, ...)';
$string['mnetrestore_extusers_switchuserauth'] = 'O utilizador remoto da Rede Moodle {$a->username} (originário de {$a->mnethosturl}) mudou para utilizador local com autenticação {$a->auth}.';
$string['mobile'] = 'Móvel';
$string['mobilenotconfiguredwarning'] = 'Aplicação móvel Moodle não está ativa.';
$string['modchooserdefault'] = 'Predefinição do modo de seleção rápida';
$string['modeditdefaults'] = 'Valores predefinidos das configurações das atividades';
$string['modsettings'] = 'Gerir atividades';
$string['modulesecurity'] = 'Segurança dos módulos';
$string['moodleorghubname'] = 'Moodle.net';
$string['multilangforceold'] = 'Forçar sintaxe multilang antiga:&lt;span&gt; sem a class="multilang" e &lt;lang&gt;';
$string['mustenablestats'] = 'As estatísticas ainda não foram ativadas neste site.';
$string['mycoursesperpage'] = 'Número de disciplinas';
$string['mydashboard'] = 'Painel predefinido de controlo do sistema';
$string['mymoodle'] = 'Painel do utilizador';
$string['mymoodleredirect'] = 'Obrigar os utilizadores a usar a Minha página principal';
$string['mypage'] = 'Painel do utilizador predefinido';
$string['mypagelocked'] = 'Página predefinida de bloqueio';
$string['myprofile'] = 'Página de perfil predefinida';
$string['navadduserpostslinks'] = 'Adicionar hiperligações para ver mensagens dos utilizadores';
$string['navadduserpostslinks_help'] = 'Se ativar esta opção, serão adicionadas duas hiperligações a cada utilizador na navegação para ver os tópicos que o utilizador iniciou e as mensagens que submeteu em fóruns de todo o site ou em disciplinas específicas.';
$string['navcourselimit'] = 'Número máximo de disciplinas';
$string['navigationupgrade'] = 'Esta atualização cria dois novos blocos de navegação que substituem os seguintes: Administração, Disciplinas, Atividades e Participantes. Se tiverem sido definidas permissões específicas nestes blocos, deve ser verificado se o comportamento pretendido se mantém.';
$string['navshowallcourses'] = 'Mostrar todas as disciplinas';
$string['navshowcategories'] = 'Mostrar categorias das disciplinas';
$string['navshowfrontpagemods'] = 'Mostrar atividades da página principal na navegação';
$string['navshowfrontpagemods_help'] = 'Se ativar esta opção, a atividade da página principal será exibida na navegação das Páginas do site';
$string['navshowfullcoursenames'] = 'Mostrar nome completo das disciplinas';
$string['navshowfullcoursenames_help'] = 'Se ativar esta opção, o nome completo das disciplinas será usado, na navegação, em vez do nome curto.';
$string['navshowmycoursecategories'] = 'Mostrar as minhas categorias';
$string['navshowmycoursecategories_help'] = 'Se ativar esta opção, as minhas disciplinas são exibidas nas categorias';
$string['navsortmycoursessort'] = 'Ordenar as minhas disciplinas';
$string['navsortmycoursessort_help'] = 'Determina a ordem pela qual as disciplinas são apresentadas no bloco Navegação, em \'As minhas disciplinas\'. Por predefinição, as disciplinas são exibidas pela ordem em que foram criadas.';
$string['never'] = 'Nunca';
$string['neverdeleteruns'] = 'Nunca apagar <i>runs</i>';
$string['newestdocindexed'] = 'Data/hora do documento indexado mais recente';
$string['nobookmarksforuser'] = 'Não tem nenhum marcador.';
$string['nodatabase'] = 'Não existe base de dados';
$string['nohttpsformobilewarning'] = 'É recomendado que ative a utilização do protocolo HTTPS com um certificado válido. A Aplicação móvel Moodle para dispositivos móveis tentará sempre usar a ligação segura em primeiro lugar.';
$string['nomissingstrings'] = 'Não existem frases em falta';
$string['none'] = 'Nenhum';
$string['nonewsettings'] = 'Durante esta atualização não foram adicionadas configurações adicionais.';
$string['nonexistentbookmark'] = 'O marcador solicitado não existe.';
$string['noreplyaddress'] = 'Endereço \'Não responder\'';
$string['noreplydomain'] = 'Domínio e endereço \'Não responder\'';
$string['noreplydomaindetail'] = 'Configurações do endereço \'Não responder\' e dos domínios permitidos';
$string['noresults'] = 'Não foram encontrados resultados.';
$string['noroles'] = 'Não existem papéis';
$string['nosupportedlogstore'] = '';
$string['notifications'] = 'Notificações';
$string['notifyloginfailures'] = 'Enviar tentativas de autenticação falhadas para';
$string['notifyloginthreshold'] = 'Limite para envio de notificações por e-mail';
$string['notloggedinroleid'] = 'Papel a atribuir aos utilizadores não autenticados';
$string['numberofmissingstrings'] = 'Numero de frases em falta: {$a}';
$string['numberofstrings'] = 'Número total de frases: {$a->strings}<br />Em falta: {$a->missing} ({$a->missingpercent}&nbsp;%)';
$string['oauthrefreshtokenexpired'] = 'O token de atualização para um dos serviços OAuth {$a->issuer} no seu site {$a->siteurl} expirou. Isto limitará a funcionalidade de qualquer módulo que use este serviço. Para corrigir este problema, visite a página de configuração dos Serviços OAuth 2 (Administração do Site / Servidor / Serviços OAuth 2) e clique no ícone "Ligar a uma conta do sistema" na linha da tabela correspondente a este serviço. Cada vez que autenticar-se, não se esqueça de usar a mesma conta de serviço para o sistema OAuth.';
$string['oauthrefreshtokenexpiredshort'] = 'O token de atualização do OAuth {$a->issuer} no seu site {$a->siteurl} expirou.';
$string['onlynoreply'] = 'Apenas a partir do endereço \'Não responder\'';
$string['opcacherecommended'] = 'A cache de opcodes do PHP melhora o desempenho e reduz os requisitos de memória. A extensão OPcache é recomendada e totalmente suportada.';
$string['opensslrecommended'] = 'É altamente recomendada a instalação da opcional OpenSSL library -- permite a funcionalidade Rede Moodle.';
$string['opensslrequired'] = 'A extensão OpenSSL do PHP é agora obrigatória pelo Moodle para os melhores serviços criptográficos.';
$string['opentogoogle'] = 'Permitir acesso Google';
$string['optionalmaintenancemessage'] = 'Mensagem de manutenção opcional';
$string['order1'] = 'Primeiro';
$string['order2'] = 'Segundo';
$string['order3'] = 'Terceiro';
$string['order4'] = 'Quarto';
$string['outgoingmailconfig'] = 'Configuração de e-mail de saída';
$string['overridetossl'] = 'Já é obsoleto usar HTTPS para autenticação. Esta instância agora é obrigada a usar SSL. Para contornar este aviso, altere no ficheiro wwwroot para  para https: //';
$string['pageinfodebugsummary'] = 'Esta página é: {$a}';
$string['passwordchangelogout'] = 'Terminar sessões após alteração da senha';
$string['passwordchangelogout_desc'] = 'Se ativar esta opção, quando a senha for alterada, todas as sessões do navegador são terminadas, à exceção daquela em que a nova senha foi definida. (Esta configuração não afeta as alterações de senha feitas através do processamento em massa.)';
$string['passwordchangetokendeletion'] = 'Apagar tokens de acesso ao web service após alteração da senha';
$string['passwordchangetokendeletion_desc'] = 'Se ativar esta opção, sempre que uma senha é alterada, todos os tokens de acesso ao web service do utilizador são apagados.';
$string['passwordpolicy'] = 'Ativar regras para as senhas';
$string['passwordresettime'] = 'Tempo máximo para validar o pedido de reposição da senha';
$string['passwordreuselimit'] = 'Limite de reutilização da senha';
$string['passwordreuselimit_desc'] = 'Número de vezes que um utilizador tem de alterar a senha antes de ser permitida a sua reutilização. As hashes das senhas utilizadas anteriormente são armazenadas numa base de dados local. Esta opção poderá não ser compatível com alguns plugins externos de autenticação';
$string['pathtodot'] = 'Caminho para o programa <strong>dot</strong>';
$string['pathtodot_help'] = 'Caminho para o programa <strong>dot</strong>. Em Linux é algo como \'/usr/bin/dot\'. Em Windows é algo como \'C:\\Program Files (x86)\\Graphviz2.38\\bin\\dot.exe\'. Em Mac é algo como \'/opt/local/bin/dot\'. Para ser possível gerar gráficos a partir de ficheiros DOT é necessário que este programa esteja instalado no servidor e o caminho do respetivo ficheiro executável do programa deve ser indicado aqui.';
$string['pathtodu'] = 'Caminho para o programa <strong>du</strong>';
$string['pathtogs'] = 'Caminho para o Ghostscript';
$string['pathtogs_help'] = 'Na maioria das instalações Linux, isto pode ficar definido como  \'/usr/bin/gs\'. Em Windows será algo como \'c:\\gs\\bin\\gswin32c.exe\' (certifique-se de que não existem espaços no caminho - se necessário, copie os ficheiros \'gswin32c.exe\' e \'gsdll32.dll\' para uma nova pasta sem espaços no caminho).';
$string['pathtopgdump'] = 'Caminho para o programa <strong>pg_dump</strong>';
$string['pathtopgdumpdesc'] = 'Apenas necessário digitar se tiver mais que um programa <strong>pg_dump</strong> no seu sistema (por exemplo se tiver mais que uma versão do PostgreSQL instalada)';
$string['pathtopgdumpinvalid'] = 'O caminho indicado para <strong>pg_dump</strong> é inválido ou não foi possível executar o ficheiro';
$string['pathtophp'] = 'Caminho para a CLI do PHP';
$string['pathtopsql'] = 'Caminho para o programa <strong>psql</strong>';
$string['pathtopsqldesc'] = 'Apenas necessário se tiver mais de um programa <strong>psql</strong> no seu sistema (por exemplo se tiver mais que uma versão do PostgreSQL instalada)';
$string['pathtopsqlinvalid'] = 'O caminho indicado para <strong>psql</strong> é inválido ou não foi possível executar o ficheiro';
$string['pathtopython'] = 'Caminho para Python';
$string['pathtopythondesc'] = 'Caminho para o binário Python executável (Python 2 e Python 3 são aceites).';
$string['pathtosassc'] = 'Caminho para SassC';
$string['pathtosassc_help'] = 'Ao especificar a localização do binário SassC mudará o compilador SASS da implementação PHP do Moodle para SassC. Para mais informações, visite https://github.com/sass/sassc .';
$string['pcreunicodewarning'] = 'É extremamente recomendado usar a extensão PCRE PHP que é compatível como os caracteres Unicode.';
$string['perfdebug'] = 'Informação de desempenho';
$string['performance'] = 'Desempenho';
$string['pgcluster'] = 'Cluster PostgreSQL';
$string['pgclusterdescription'] = 'Parâmetro versão/cluster PostgreSQL para operações através da linha de comandos. Se tiver apenas um PostgreSQL no seu sistema ou não tiver a certeza do que é isto, deixe em branco.';
$string['phpfloatproblem'] = 'Detetado um problema inesperado na manipulação de PHP números float PHP - {$a}';
$string['pleaserefreshregistration'] = 'O seu site está registado. Última atualização do registo: {$a}.<br />A tarefa agendada "Registo do site" mantém o registo atualizado. A qualquer momento pode atualizar manualmente o registo.';
$string['pleaserefreshregistrationnewdata'] = 'As informações do registo foram alteradas. Clique no botão "Atualizar obregisto" para confirmar as alterações.';
$string['pleaserefreshregistrationunknown'] = 'O seu site foi registado, mas a data de registo é desconhecida.
Por favor, atualize o seu registo através do botão "Atualizar o registo" ou assegure-se que a tarefa agendada "Registo do site" encontra-se ativa para que o registo seja atualizado automaticamente.';
$string['plugin'] = 'Módulo';
$string['plugins'] = 'Módulos';
$string['pluginscheck'] = 'Conferir dependências dos módulos';
$string['pluginscheckfailed'] = 'A verificação de dependências falhou para {$a->pluginslist}';
$string['pluginschecktodo'] = 'Tem de resolver todas as exigências do módulo antes de prosseguir para instalar esta versão do Moodle!';
$string['pluginsoverview'] = 'Lista de módulos instalados';
$string['pluginsoverviewsee'] = 'Consulte a página \'<a href="{$a->url}">Lista de módulos instalados</a>\' para mais detalhes.';
$string['policysettings'] = 'Configurações da política';
$string['privacy:metadata'] = 'O módulo de administração não armazena dados pessoais';
$string['privacyandpolicies'] = 'Privacidade e políticas';
$string['privacysettings'] = 'Configurações da privacidade';
$string['profilecategory'] = 'Categoria';
$string['profilecategoryname'] = 'Nome da Categoria (deve ser único)';
$string['profilecategorynamenotunique'] = 'Este nome de categoria já existe';
$string['profilecommonsettings'] = 'Configurações comuns';
$string['profileconfirmcategorydeletion'] = 'Há {$a} campo(s) nesta categoria que serão movidos para a categoria acima (ou abaixo, se for a primeira).<br />Pretende apagar esta categoria?';
$string['profileconfirmfielddeletion'] = 'Existem {$a} utilizadores para este campo que será apagado.<br />Ainda pretende apagar este campo?';
$string['profilecreatecategory'] = 'Criar uma nova categoria de perfil';
$string['profilecreatefield'] = 'Criar um novo campo de perfil';
$string['profilecreatenewcategory'] = 'Criar uma nova categoria';
$string['profilecreatenewfield'] = 'Criar um novo campo do tipo \'{$a}\' no perfil do utilizador';
$string['profiledefaultcategory'] = 'Outros campos';
$string['profiledefaultchecked'] = 'Ativo por predefinição';
$string['profiledefaultdata'] = 'Valor predefinido';
$string['profiledeletecategory'] = 'Apagar uma categoria';
$string['profiledeletefield'] = 'Apagar o campo \'{$a}\'';
$string['profiledescription'] = 'Descrição do campo';
$string['profiledscript'] = 'Este script foi classificado';
$string['profiledscriptview'] = 'Ver a informação deste script';
$string['profileeditcategory'] = 'Editar categoria: {$a}';
$string['profileeditfield'] = 'Editar campo de perfil: {$a}';
$string['profilefield'] = 'Campo de perfil';
$string['profilefieldcolumns'] = 'Colunas';
$string['profilefieldispassword'] = 'Trata-se de um campo de senha?';
$string['profilefieldlink'] = 'Hiperligação';
$string['profilefieldlink_help'] = 'Para transformar o texto numa hiperligação, insira um URL contendo $$, em que $$ será substituído pelo texto. Por exemplo, para transformar um identificação Twitter numa hiperligação, inserir http://twitter.com/$$.';
$string['profilefieldlinktarget'] = 'Página de destino da hiperligação';
$string['profilefieldmaxlength'] = 'Tamanho máximo';
$string['profilefieldrows'] = 'Linhas';
$string['profilefields'] = 'Campos de perfil';
$string['profilefieldsize'] = 'Tamanho de exibição';
$string['profileforceunique'] = 'A informação deve ser única?';
$string['profileinvaliddata'] = 'Valor inválido';
$string['profilelocked'] = 'Este campo está bloqueado?';
$string['profilemenudefaultnotinoptions'] = 'O valor predefinido não é uma das opções acima indicadas';
$string['profilemenunooptions'] = 'Não indicou nenhuma opção do menu';
$string['profilemenuoptions'] = 'Opções do menu (uma por linha)';
$string['profilemenutoofewoptions'] = 'Tem de indicar pelo menos 2 opções';
$string['profilename'] = 'Nome';
$string['profilenofieldsdefined'] = 'Nenhum campo foi definido';
$string['profilerequired'] = 'O campo é obrigatório?';
$string['profileroles'] = 'Papéis visíveis no perfil';
$string['profilesforenrolledusersonly'] = 'Só podem alterar o perfil alunos inscritos';
$string['profileshortname'] = 'Nome curto (deve ser único)';
$string['profileshortnameinvalid'] = 'Este nome curto só pode conter caracteres alfanuméricos (letras e números) ou underscore (_).';
$string['profileshortnamenotunique'] = 'Nome curto já em uso';
$string['profilesignup'] = 'Mostrar na página de registo?';
$string['profilespecificsettings'] = 'Opções de configuração';
$string['profilevisible'] = 'Quem pode ver este campo?';
$string['profilevisible_help'] = '<ul><li>Invisível - Informação privada visível apenas pelos administradores</li><li>Visível para o utilizador - Informação privada visível apenas pelo utilizador e pelos administradores</li><li>Visível para todos</li></ul>';
$string['profilevisibleall'] = 'Visível para todos';
$string['profilevisiblenone'] = 'Invisível';
$string['profilevisibleprivate'] = 'Visível para o utilizador';
$string['profiling'] = 'Classificação';
$string['profilingallowall'] = 'Classificação contínua';
$string['profilingallowall_help'] = 'Se ativar esta configuração, então, a qualquer momento, pode usar o parâmetro PROFILEALL (PGC) para ativar a classificação de todos os scripts executados durante a duração da sessão Moodle. Pelo contrário, pode usar o parâmetro PROFILEALLSTOP para interromper este processo.';
$string['profilingallowme'] = 'Classificação seletiva';
$string['profilingallowme_help'] = 'Se ativar esta configuração então pode, de forma seletiva, usar o parâmetro PROFILEME (PGC) para classificar um determinado script se ele for executado. Pelo contrário, pode usar o parâmetro  DONTPROFILEME para impedir a classificação do script.';
$string['profilingautofrec'] = 'Classificação automática';
$string['profilingautofrec_help'] = 'Ao configurar este parâmetro, alguns pedidos (definidos aleatoriamente com base na frequência especificada - 1 de N) serão selecionados e classificados automaticamente, sendo os resultados armazenados para análise posterior. Note que esta forma de classificação respeita as configurações de inclusão e exclusão definidas. Defina o valor "0" (zero) para desativar a classificação automática.';
$string['profilingenabled'] = 'Ativar classificação';
$string['profilingenabled_help'] = 'Se ativar esta opção, então a classificação vai estar disponível no site e vai poder definir o seu comportamento através da configuração das seguintes opções.';
$string['profilingexcluded'] = 'Excluir da classificação';
$string['profilingexcluded_help'] = 'Lista de URLs (separados por vírgulas, ignorando wwwroot, invocável) que serão excluídos da classificação dos definidos na configuração \'Classificar estes\' .';
$string['profilingimportprefix'] = 'Prefixo de importação de perfis';
$string['profilingimportprefix_desc'] = 'Para facilitar a deteção, o prefixo de todas as operações de importação de perfis será igual ao valor especificado aqui.';
$string['profilingincluded'] = 'Classificar estes';
$string['profilingincluded_help'] = 'Lista de URLs (separados por vírgulas, ignorando wwwroot, invocável) que serão automaticamente classificados. Exemplos: /index.php, /course/view.php. Aceita também o carater * como wildchar em qualquer posição. Exemplos: /mod/forum/*, /mod/*/view.php.';
$string['profilinglifetime'] = 'Manter <i>runs</i> de classificação';
$string['profilinglifetime_help'] = 'Defina o tempo durante o qual pretende manter a informação acerca de <i>runs</i> de classificação antigos. Os mais antigos serão apagados periodicamente. De notar que isto exclui todos os <i>runs</i> de classificação definidos como \'run de referência\'.';
$string['protectusernames'] = 'Proteger nomes de utilizador';
$string['proxybypass'] = 'Servidores a contornar o proxy';
$string['proxyhost'] = 'Servidor Proxy';
$string['proxypassword'] = 'Senha do proxy';
$string['proxyport'] = 'Porta do Proxy';
$string['proxytype'] = 'Tipo de proxy';
$string['proxyuser'] = 'Username do proxy';
$string['purgecaches'] = 'Limpar todas as caches';
$string['purgecachesconfirm'] = 'O Moodle pode armazenar em cache temas, código javascript, traduções, texto filtrado, listas rss e muitas outras informações. Esvaziar estas caches vai apagar essa informação do servidor e forçar os navegadores a voltar a obter esses dados. Desta forma, pode garantir que consulta os valores mais atualizados do código atual. Não existe nenhum risco em esvaziar as caches, mas o site pode parecer momentaneamente mais lento até que o servidor e os clientes obtenham novamente a informação e a armazenem em cache.';
$string['purgecachesfinished'] = 'Todas as caches foram esvaziadas.';
$string['query'] = 'Pesquisa';
$string['question'] = 'Pergunta';
$string['questionbehaviours'] = 'Comportamento das perguntas';
$string['questioncwqpfscheck'] = 'Uma ou mais perguntas \'aleatórias\' num teste foram configuradas para selecionar perguntas de uma mistura de categorias partilhadas e não partilhadas. Existe um <a href="{$a->reporturl}">relatório mais completo </a> e deve consultar
<a href="{$a->docsurl}">esta página do Moodle Docs</a>.';
$string['questioncwqpfsok'] = 'Bom! Não existem nos seus testes perguntas aleatórias configuradas para selecionar perguntas de uma mistura de categorias partilhadas e não partilhadas.';
$string['questiontype'] = 'Tipo de pergunta';
$string['questiontypes'] = 'Tipos de perguntas';
$string['quizattemptsupgradedmessage'] = 'No Moodle 2.1 houve uma grande atualização para as perguntas do teste. Foi possível atrasar partes da atualização da base de dados a serem executadas mais tarde. Deve concluir essa atualização antes de atualizar para o Moodle 2.7';
$string['recaptchaprivatekey'] = 'Chave secreta do ReCAPTCHA';
$string['recaptchapublickey'] = 'Chave de site do reCAPTCHA';
$string['register'] = 'Registe o seu site';
$string['registermoodlenet'] = '<p>Gostaríamos muito de ficar em contacto para lhe disponibilizar coisas importantes para o seu site Moodle!</p><p>Ao registar o seu site:</p><ul><li>Será dos primeiros a receber notificações importantes, tais como alertas de segurança e novos lançamentos do Moodle.</li><li>Pode aceder e ativar o envio de notificações móveis a partir do seu site através da <a href="https://download.moodle.org/mobile/">Aplicação Móvel Moodle</a> gratuita.</li><li>Está a contribuir para as nossas <a href="https://moodle.net/stats/">estatísticas Moodle</a> da comunidade mundial, que nos ajudam a melhorar o Moodle e os sites da nossa comunidade.</li><li>Se desejar, o seu site pode ser incluído na <a href="https://moodle.net/sites/">lista de sites Moodle registados</a> no seu país.</li></ul>';
$string['registermoodleorg'] = 'Quando regista o seu site';
$string['registermoodleorgli1'] = 'É adicionado a uma lista de e-mail de baixo volume, através da qual receberá notificações importantes, tais como alertas de segurança e lançamento de novas versões do Moodle.';
$string['registermoodleorgli2'] = 'Serão adicionadas estatísticas do seu site na página {$a} da comunidade global do Moodle.';
$string['registerwithmoodleorg'] = 'Registar o seu site';
$string['registration'] = 'Registo';
$string['registration_help'] = 'É recomendável que registe o seu site em Moodle.net para que receba notificações e alertas de segurança, e poder aceder à nossa comunidade Moodle.';
$string['registrationwarning'] = 'O seu site ainda não está registado.';
$string['registrationwarningcontactadmin'] = 'Este site ainda não está registado. Informe o Administrador.';
$string['releasenoteslink'] = 'Para mais informação sobre esta versão do Moodle, veja as <a target="_new" href="{$a}">Notas de Lançamento</a>';
$string['rememberusername'] = 'Lembrar nome de utilizador';
$string['rememberusername_desc'] = 'Ative esta opção, para que sejam guardados cookies permanentes com os nomes de utilizador durante a autenticação do utilizador. Os cookies permanentes podem ser considerados abusivos em termos de privacidade, se usados sem consentimento.';
$string['reportsmanage'] = 'Gerir relatórios';
$string['requestcategoryselection'] = 'Permitir seleção da categoria';
$string['requiredentrieschanged'] = '<strong>IMPORTANTE - LER POR FAVOR<br/>(Este aviso apenas aparece durante esta atualização)</strong><br/>Devido à resolução de um bug, o funcionamento das atividades de Base de dados que usam as opções \'Registos obrigatórios\' e \'Registos obrigatórios antes de ser permitida a visualização\' vai mudar. Uma explicação detalhada das mudanças pode ser lida no <a href="http://moodle.org/mod/forum/discuss.php?d=110928" target="_blank">fórum do módulo Base ded dados</a>. O funcionamento esperado destas opções pode também ser lido em <a href="http://docs.moodle.org/en/Adding/editing_a_database#Required_entries" target="_blank">Moodle Docs</a>.<br/><br/>Esta alteração afeta as seguintes bases de dados do seu sistema: (Por favor, guarde esta lista e depois da atualização, verifique se essas atividades continuam a funcionar corretamente.)<br/><strong style="color:red">{$a->text}</strong><br/>';
$string['requiremodintro'] = 'Forçar a inserção de descrição da atividade';
$string['requiremodintro_desc'] = 'Se ativar esta opção, os utilizadores serão forçados a introduzir uma descrição na configuração de cada atividade.';
$string['requires'] = 'Requer';
$string['restorecourse'] = 'Restaurar disciplina';
$string['restorernewroleid'] = 'Papel a atribuir ao restaurador na disciplina';
$string['restorernewroleid_help'] = 'Se o utilizador não tiver permissão para gerir a disciplina que acabou de restaurar, este papel é automaticamente atribuido ao utilizador na disciplina, se necessário. Selecione "Nenhum" se não quiser que os restauradores possam gerir todas as disciplinas restauradas.';
$string['reverseproxy'] = 'Reverse proxy';
$string['reverseproxyignore'] = 'Ignorar reverse proxies';
$string['riskconfig'] = 'Os utilizadores poderiam alterar a configuração e comportamento do site';
$string['riskconfigshort'] = 'Risco de configuração';
$string['riskdataloss'] = 'Os utilizadores podem apagar grandes quantidades de informação e conteúdos';
$string['riskdatalossshort'] = 'Risco de perda de informação';
$string['riskmanagetrust'] = 'Os utilizadores poderiam alterar as definições de conteúdo fiável de outros utilizadores';
$string['riskmanagetrustshort'] = 'Gerir fiáveis';
$string['riskpersonal'] = 'Os utilizadores poderiam ter acesso a informação privada de outros utilizadores';
$string['riskpersonalshort'] = 'Risco de privacidade';
$string['riskspam'] = 'Os utilizadores poderiam enviar spam a outros utilizadores do site ou outros';
$string['riskspamshort'] = 'Risco de Spam';
$string['riskxss'] = 'Os utilizadores poderiam adicionar ficheiros e textos que permitam "cross-site scripting" (XSS)';
$string['riskxssshort'] = 'Risco XSS';
$string['roleswithexceptions'] = '{$a->roles} com {$a->exceptions}';
$string['rssglobaldisabled'] = 'Desativado ao nível do site';
$string['save'] = 'Guardar';
$string['savechanges'] = 'Guardar alterações';
$string['scssinvalid'] = 'O código SCSS não é válido, falha: {$a}';
$string['search'] = 'Pesquisar';
$string['searchallavailablecourses'] = 'Disciplinas pesquisáveis';
$string['searchallavailablecourses_desc'] = 'Em algumas situações, o mecanismo de busca pode não funcionar corretamente ao pesquisar num grande número de disciplinas. Defina para pesquisar apenas as disciplinas inscritas, se precisar de restringir o número de disciplinas a pesquisar.';
$string['searchallavailablecourses_off'] = 'Procurar apenas nas disciplinas inscritas';
$string['searchallavailablecourses_on'] = 'Procurar em todas as disciplinas que o utilizador pode aceder';
$string['searchalldeleted'] = 'Todos os conteúdos indexados foram apagados';
$string['searchareadisabled'] = 'Área de pesquisa desativada';
$string['searchareaenabled'] = 'Área de pesquisa ativada';
$string['searchareas'] = 'Áreas de pesquisa';
$string['searchdeleteindex'] = 'Apagar todos os conteúdos indexados';
$string['searchengine'] = 'Motor de busca';
$string['searchindexactions'] = 'Ações no índice';
$string['searchindexdeleted'] = 'Índice apagado';
$string['searchindextime'] = 'Limite de tempo de indexação';
$string['searchindextime_desc'] = 'Ao indexar grandes quantidades de novos conteúdos, a tarefa agendada irá parar depois que este limite de tempo seja atingido. Continuará na próxima vez que a tarefa for executada.';
$string['searchindexupdated'] = 'Os conteúdos do motor de busca foram atualizados';
$string['searchindexwhendisabled'] = 'Indexar quando desativada';
$string['searchindexwhendisabled_desc'] = 'Permite que a tarefa agendada crie o índice de pesquisa mesmo quando a pesquisa está desativada. É útil se pretende criar o índice antes que a funcionalidade de pesquisa seja mostrada aos alunos.';
$string['searchinsettings'] = 'Pesquisar nas configurações';
$string['searchlastrun'] = 'Última execução (tempo, # documentos, # registos, # ignorados)';
$string['searchnotavailable'] = 'A pesquisa não está disponível';
$string['searchoptions'] = 'Opções de pesquisa';
$string['searchpartial'] = '(ainda não totalmente indexado)';
$string['searchreindexed'] = 'Todos os conteúdos do site foram novamente indexados.';
$string['searchreindexindex'] = 'Reindexar todos os conteúdos do site';
$string['searchresults'] = 'Resultados da pesquisa';
$string['searchsetupinfo'] = 'Configurações da pesquisa';
$string['searchupdateindex'] = 'Atualizar conteúdos indexados';
$string['sectionerror'] = 'Erro na secção!';
$string['secureforms'] = 'Usar segurança adicional de formulários';
$string['security'] = 'Segurança';
$string['selectdevice'] = 'Selecionar dispositivo';
$string['selectsearchengine'] = 'Selecionar motor de busca';
$string['selecttheme'] = 'Selecione o tema para o dispositivo {$a}';
$string['server'] = 'Servidor';
$string['serverchecks'] = 'Verificações do servidor';
$string['serverlimit'] = 'Limite de servidor';
$string['sessionautostartwarning'] = '<p>Foi detetado um erro de configuração grave, por favor contacte o administrador do servidor.</p><p> Para funcionar corretamente, o Moodle requer que o administrador modifique as configurações do PHP.</p><p><code>session.auto_start</code> deve ser configurado como <code>off</code>.</p><p>Esta configuração é modificada editando o ficheiro <code>php.ini</code>, ou o ficheiro <code>.htaccess</code> no servidor.</p>';
$string['sessioncookie'] = 'Prefixo dos cookies';
$string['sessioncookiedomain'] = 'Domínio dos cookies';
$string['sessioncookiepath'] = 'Caminho para os cookies';
$string['sessionhandling'] = 'Sessões';
$string['sessiontimeout'] = 'Tempo limite da sessão';
$string['settingfileuploads'] = 'O carregamento de ficheiros é obrigatório para um funcionamento normal. Por favor ative-o na configuração do PHP.';
$string['settingmemorylimit'] = 'A memória detetada é insuficiente. Por favor aumente o valor deste limite na configuração do PHP.';
$string['settingsafemode'] = 'O Moodle não é completamente compatível com o PHP em <strong>safe mode</strong>. Por favor peça ao administrador do servidor para o desativar. Não é possível usar o Moodle com o PHP em <strong>safe mode</strong>, vários problemas podem ocorrer se o fizer.';
$string['setupsearchengine'] = 'Configurar motor de busca';
$string['showcommentscount'] = 'Mostrar número total de comentários';
$string['showdetails'] = 'Mostrar detalhes';
$string['showuseridentity'] = 'Mostrar identidade do utilizador';
$string['showuseridentity_desc'] = 'Quando seleciona ou procura utilizadores, ou quando é exibida a lista de utilizadores, estes campos podem ser exibidos juntamente com o nome completo. Estes campos são apenas exibidos aos utilizadores que possuem a permissão moodle/site:viewuseridentity. Por predefinição apenas os professores e gestores têm esta permissão. (Esta opção é útil para especificar um ou dois campos que são obrigatórios na sua instituição.)';
$string['simplexmlrequired'] = 'A extensão SimpleXML do PHP é necessária para o funcionamento do Moodle.';
$string['sitemailcharset'] = 'Conjunto de caracteres';
$string['sitemaintenance'] = 'O site está em manutenção e não está disponível de momento';
$string['sitemaintenancemode'] = 'Modo de manutenção';
$string['sitemaintenanceoff'] = 'O modo de manutenção foi desativado e o site está novamente operacional';
$string['sitemaintenanceon'] = 'De momento, o site está em manutenção (apenas os administradores poderão se autenticar e utilizar o site)';
$string['sitemaintenanceoncli'] = 'O seu site está atualmente em modo de manutenção CLI. Não é permitido qualquer acesso web.';
$string['sitemaintenancewarning'] = 'De momento o seu site está em modo de manutenção (apenas os Administradores se podem autenticar). Para que o site volte a estar operacional, <a href="maintenance.php">desative o modo de manutenção</a>.';
$string['sitemaintenancewarning2'] = 'O site está atualmente em modo de manutenção (apenas os administradores têm acesso). Para colocar o site em modo normal de funcionamento clique em <a href="{$a}">Desativar modo de manutenção</a>.';
$string['sitemenubar'] = 'Navegação do Site';
$string['sitepolicies'] = 'Configurações de segurança do site';
$string['sitepolicy'] = 'URL da política do site';
$string['sitepolicy_help'] = 'URL da política do site que todos os utilizadores registados devem ver e concordar antes de aceder ao site. Note que esta configuração apenas terá efeito se a opção selecionada em \'Controlador de políticas do site\' for \'Predefinido (core)\'';
$string['sitepolicyguest'] = 'URL da política do site para visitantes';
$string['sitepolicyguest_help'] = 'O URL da política do site que todos os visitantes devem ver e concordar antes de aceder ao site. Note que esta configuração apenas terá efeito se a opção selecionada em \'Controlador de políticas do site\' for \'Predefinido (core)\'';
$string['sitepolicyhandler'] = 'Controlador de políticas do site';
$string['sitepolicyhandler_desc'] = 'Esta opção determina como são geridas as políticas do site e consentimentos do utilizador. O controlador de políticas prefefinido (core) permite definir um URL para a política do site e um URL para a política do site para visitantes. Controladores alternativos podem ser disponibilizados por módulos adicionais para oferecer um controlo mais avançado sobre as políticas do site.';
$string['sitepolicyhandlercore'] = 'Predefinido (core)';
$string['sitepolicyhandlerplugin'] = '{$a->name} ({$a->component})';
$string['sitesectionhelp'] = 'Se ativar esta opção, será apresentada na página principal do site uma secção inicial editável para poder inserir conteúdo.';
$string['sixtyfourbitswarning'] = 'Foi detetado que seu site não está a usar uma versão do PHP de 64 bits. Recomenda-se que atualize o seu site para garantir compatibilidade futura.';
$string['slasharguments'] = 'Usar slash arguments';
$string['slashargumentswarning'] = 'É recomendado que ative o uso dos \'slash arguments\'. No futuro será obrigatório. Para mais detalhes, consulte a documentação <a href="https://docs.moodle.org/en/admin/environment/slasharguments">Using slash arguments</a>.';
$string['smartpix'] = 'Procura inteligente de ícones';
$string['smtp'] = 'SMTP';
$string['smtpauthtype'] = 'Tipo de autenticação SMTP';
$string['smtpdetail'] = 'Configurações de SMTP (Simple Mail Transfer Protocol) para enviar e-mails';
$string['smtphosts'] = 'Servidores SMTP';
$string['smtpmaxbulk'] = 'Limite de sessão SMTP';
$string['smtppass'] = 'Senha SMTP';
$string['smtpsecure'] = 'Segurança SMTP';
$string['smtpuser'] = 'Nome de utilizador SMTP';
$string['soaprecommended'] = 'A instalação da extensão opcional SOAP é útil para web services e para alguns módulos.';
$string['sort_fullname'] = 'Nome completo da disciplina';
$string['sort_idnumber'] = 'ID da disciplina';
$string['sort_shortname'] = 'Nome curto da disciplina';
$string['sort_sortorder'] = 'Ordenação predefinida';
$string['spellengine'] = 'Motor de verificação ortográfica';
$string['spelllanguagelist'] = 'Formar lista de linguas';
$string['splrequired'] = 'A extensão SPL do PHP é obrigatória para o funcionamento do Moodle.';
$string['stats'] = 'Estatísticas';
$string['statsfirstrun'] = 'Intervalo máximo de processamento';
$string['statsmaxruntime'] = 'Tempo máximo de execução';
$string['statsmoodleorg'] = 'estatísticas';
$string['statsruntimedays'] = 'Dias para processamento';
$string['statsruntimestart'] = 'Horário de execução';
$string['statsuserthreshold'] = 'Limite de utilizadores';
$string['stickyblocks'] = 'Blocos Persistentes';
$string['stickyblockscourseview'] = 'Página da Disciplina';
$string['stickyblocksduplicatenotice'] = 'Se adicionar aqui um bloco que já está presente nalguma página em particular, irá resultar numa duplicação. <br />Apenas o bloco fixado não será editável. O duplicado continuará a ser editável.';
$string['stickyblocksmymoodle'] = 'Minha página principal';
$string['stickyblockspagetype'] = 'Tipo de página a configurar';
$string['strictformsrequired'] = 'Validação estrita de campos obrigatórios';
$string['stripalltitletags'] = 'Apagar <em>tags</em> HTML do nome das atividades e recursos';
$string['supportcontact'] = 'Contacto para pedidos de ajuda';
$string['supportemail'] = 'E-mail do responsável pelo apoio aos utilizadores';
$string['supportname'] = 'Nome do responsável pelo apoio aos utilizadores';
$string['supportpage'] = 'Página de apoio aos utilizadores';
$string['suspenduser'] = 'Suspender contas de utilizadores';
$string['switchlang'] = 'Alterar pasta do idioma';
$string['systempaths'] = 'Caminhos do sistema';
$string['tablenosave'] = 'As alterações feitas na tabela acima são guardadas automaticamente.';
$string['tablesnosave'] = 'Mudanças feitas nas tabelas acima são guardadas automaticamente.';
$string['tabselectedtofront'] = 'Em tabelas com separadores, devem as linhas com o separador selecionado ser colocadas à frente';
$string['tabselectedtofronttext'] = 'Trazer a linha de separador selecionada para a frente';
$string['taskanalyticscleanup'] = 'Limpeza da Analítica';
$string['taskautomatedbackup'] = 'Cópias de segurança automáticas';
$string['taskbackupcleanup'] = 'Limpar tabelas e registos de atividade de cópias de segurança';
$string['taskbadgescron'] = 'Atribuir medalhas';
$string['taskblogcron'] = 'Sincronizar blogues externos';
$string['taskcachecleanup'] = 'Remover entradas de cache expiradas';
$string['taskcachecron'] = 'Processamento das caches';
$string['taskcalendarcron'] = 'Enviar notificações de calendário';
$string['taskcheckforupdates'] = 'Verificar atualizações';
$string['taskcompletiondaily'] = 'Assinalar conclusão como iniciada';
$string['taskcompletionregular'] = 'Calcular a realização periódica de dados';
$string['taskcontextcleanup'] = 'Limpeza de contextos';
$string['taskcreatecontexts'] = 'Criar contextos em falta';
$string['taskdeletecachetext'] = 'Eliminar registos de cache de texto antigos';
$string['taskdeleteincompleteusers'] = 'Eliminar utilizadores incompletos';
$string['taskdeleteunconfirmedusers'] = 'Eliminar utilizadores não confirmados';
$string['taskeventscron'] = 'A processar eventos...';
$string['taskfiletrashcleanup'] = 'Limpeza dos ficheiros enviados para o lixo';
$string['taskglobalsearchindex'] = 'Indexação da pesquisa global';
$string['taskglobalsearchoptimize'] = 'Otimização do índice da pesquisa global';
$string['taskgradecron'] = 'Processamento em segundo plano da pauta';
$string['tasklegacycron'] = 'Processamento do cron de retrocompatibilidade dos módulos';
$string['taskmessagingcleanup'] = 'Processamento das mensagens';
$string['taskpasswordresetcleanup'] = 'Limpeza das tentativas de reposição de senha';
$string['taskplagiarismcron'] = 'Processamento em segundo plano de módulos de antiplágio';
$string['taskportfoliocron'] = 'Processamento dos módulos de portfólio';
$string['taskquestioncron'] = 'Processamento de fundo do motor de perguntas';
$string['taskrefreshsystemtokens'] = 'Atualizar tokens OAuth para contas de serviço';
$string['taskregistrationcron'] = 'Registo do site';
$string['tasksendfailedloginnotifications'] = 'Enviar notificações de tentativas de autenticação falhadas';
$string['tasksendnewuserpasswords'] = 'Enviar senhas de novos utilizadores';
$string['tasksessioncleanup'] = 'Limpeza de sessões antigas';
$string['taskstatscron'] = 'Processamento das estatísticas';
$string['tasktagcron'] = 'Processamento das palavras-chave';
$string['tasktempfilecleanup'] = 'Eliminar ficheiros temporários obsoletos';
$string['tempdatafoldercleanup'] = 'Limpar ficheiros de dados temporários anteriores a';
$string['testsiteupgradewarning'] = 'Atualmente está a usar o site de teste {$a}, para o atualizar corretamente use a ferramenta de interface de linha de comando';
$string['themedesignermode'] = 'Modo de desenho do tema';
$string['themedesignermodewarning'] = 'O modo de desenho do tema está ativado. Isto não deve ser ativado em sites em produção, pois pode reduzir significativamente o desempenho.';
$string['themelist'] = 'Lista de temas';
$string['themenoselected'] = 'Não foi selecionado nenhum tema';
$string['themeresetcaches'] = 'Esvaziar cache dos temas';
$string['themeselect'] = 'Selecionar tema';
$string['themeselector'] = 'Seletor de temas';
$string['themesettings'] = 'Configurações do tema';
$string['therewereerrors'] = 'Foram encontrados erros nos seus dados';
$string['thirdpartylibrary'] = 'Biblioteca';
$string['thirdpartylibrarylocation'] = 'Localização';
$string['thirdpartylibs'] = 'Bibliotecas externas';
$string['timezone'] = 'Fuso horário predefinido';
$string['timezoneforced'] = 'Forçado pelo administrador do site';
$string['timezoneinvalid'] = 'Fuso horário inválido "{$a}"';
$string['timezoneisforcedto'] = 'Forçar todos os utilizadores a usar';
$string['timezonenotforced'] = 'Os utilizadores podem definir o seu fuso horário';
$string['timezonephpdefault'] = 'Fuso horário PHP predefinido ({$a})';
$string['timezoneserver'] = 'Fuso horário do servidor ({$a})';
$string['tlswarning'] = 'Não foi detetada nenhuma extensão PHP/cURL com suporte para TLSv1.2. Alguns serviços poderão não funcionar. É altamente recomendada a atualização das suas bibliotecas TLS.';
$string['tokenduration'] = 'Duração do token criado pelo utilizador';
$string['tokenduration_desc'] = 'Período de tempo durante o qual um token de web services criado por um utilizador (por exemplo, via Aplicação móvel Moodle) é válido.';
$string['tokenizerrecommended'] = 'Para melhorar a funcionalidade da Rede Moodle é recomendada a instalação da extensão Tokenizer do PHP.';
$string['tools'] = 'Ferramentas de administração';
$string['toolsmanage'] = 'Gerir ferramentas de administração';
$string['unattendedoperation'] = 'Execução não interativa';
$string['unbookmarkthispage'] = 'Apagar esta página dos marcadores';
$string['unicoderequired'] = 'É necessário armazenar todos os seus dados com a codificação Unicode (UTF-8). Instalações feitas de raiz devem usar bases de dados com codificação predefinida Unicode. Se estiver a atualizar uma instalação, deve realizar o processo de migração para UTF-8 (ver página de administração).';
$string['uninstallplugin'] = 'Desinstalar';
$string['unlockaccount'] = 'Desbloquear conta';
$string['unoconvwarning'] = 'A versão do unoconv instalada não é suportada. A funcionalidade de avaliar Trabalho requer a versão 0.7 ou superior.';
$string['unsettheme'] = 'Anular seleção de tema';
$string['unsupported'] = 'Não suportado';
$string['unsupporteddbfileformat'] = 'A sua base de dados utiliza o formato de ficheiro Antelope. O suporte total ao UTF-8 no MySQL e MariaDB requer o formato de ficheiros Barracuda. Por favor, converta as tabelas para o formato de ficheiros Barracuda. Para mais detalhes, consulte a documentação sobre o <a href="https://docs.moodle.org/en/admin/environment/custom check/mysql full unicode support">suporte total ao unicode no MySQL</a>.';
$string['unsupporteddbfilepertable'] = 'Para suporte total ao UTF-8, o MySQL e MariaDB exigem que altere a sua configuração MySQL \'innodb_file_per_table\' para \'ON\'. Consulte a documentação para obter mais detalhes.';
$string['unsupporteddblargeprefix'] = 'Para suporte total do UTF-8, o MySQL e MariaDB exigem que altere a sua configuração MySQL \'innodb_large_prefix\' para \'ON\'. Consulte a documentação para obter mais detalhes.';
$string['unsupporteddbstorageengine'] = 'O \'storage engine\' da base de dados usado deixou de ser suportado.';
$string['unsupporteddbtablerowformat'] = 'Na sua base de dados existem tabelas que usam o formato de ficheiro Antelope. É recomendado que converta as tabelas para o formato de ficheiro Barracuda. Para mais informações acerca de ferramentas de conversão de tabelas InnoDB para Barracuda, consulte a documentação sobre <a href="https://docs.moodle.org/en/cli">Administração via linha de comandos</a>.';
$string['unsupportedphpversion7'] = 'Incompatível com a versão 7 de PHP.';
$string['unsupportedphpversion71'] = 'Versão 7.1 do PHP não é suportada.';
$string['unsupportedphpversion72'] = 'A versão 7.2 do PHP não é suportada';
$string['unsupportedphpversion73'] = 'Versão 7.3 do PHP não é suportada.';
$string['unsupportedphpversion74'] = 'A versão 7.4 do PHP não é suportada.';
$string['unsupportedphpversion80'] = 'Versão 8.0 do PHP não é suportada.';
$string['unsuspenduser'] = 'Ativar contas de utilizadores';
$string['updateaccounts'] = 'Atualizar contas existentes';
$string['updateautocheck'] = 'Verificar atualizações automaticamente';
$string['updateautocheck_desc'] = 'Se ativar esta opção, o seu Moodle irá automaticamente procurar por atualizações para o código Moodle e para os módulos instalados. Se existirem   atualizações disponíveis, será enviada uma notificação ao administrador do site.';
$string['updateavailable'] = 'Está disponível uma versão mais recente do Moodle!';
$string['updateavailable_moreinfo'] = 'Mais info…';
$string['updateavailable_release'] = 'Moodle {$a}';
$string['updateavailable_version'] = 'Versão {$a}';
$string['updateavailabledetailslink'] = 'Visite {$a->url} para mais detalhes.';
$string['updateavailableforplugin'] = 'Está disponível uma versão mais recente de alguns módulos instalados!';
$string['updateavailableinstall'] = 'Instalar agora esta atualização';
$string['updateavailableinstallall'] = 'Instalar as atualizações disponíveis ({$a})';
$string['updateavailableinstallallhead'] = 'A instalar as atualizações disponíveis';
$string['updateavailablenot'] = 'O código do seu Moodle está atualizado!';
$string['updateavailablerecommendation'] = 'É altamente recomendado que atualize o seu site para a versão mais recente para resolver todas as falhas de segurança.';
$string['updatecomponent'] = 'Atualizar informação';
$string['updateminmaturity'] = 'Maturidade exigida do código';
$string['updateminmaturity_desc'] = 'Notificar a existência de atualizações disponíveis apenas se o código disponível tem, pelo menos, o nível de maturidade selecionado. As atualizações dos módulos que não especificam o seu nível de maturidade do código são sempre notificadas independentemente desta configuração.';
$string['updatenotificationfooter'] = 'O seu site Moodle {$a->siteurl} está configurado para procurar automaticamente por novas atualizações. Está a receber esta mensagem por ser o administrador do site. Pode desativar as verificações automáticas de atualizações disponíveis em "Administração do Site" do bloco Administração. Pode personalizar a entrega desta mensagem através das suas configurações pessoais de mensagens no bloco Administração > Meu perfil > Notificações.';
$string['updatenotifications'] = 'Notificação de atualizações';
$string['updatenotificationsubject'] = 'Existem atualizações disponíveis para o seu Moodle ({$a->siteurl})';
$string['updatenotifybuilds'] = 'Notificar sobre novas \'builds\'';
$string['updatenotifybuilds_desc'] = 'Se ativar esta opção, a disponibilidade de novas \'builds\' para a versão atual do Moodle também será notificada. \'Builds\' são melhorias contínuas de uma versão do Moodle. Geralmente são lançadas com periodicidade semanal. Se desativar esta opção, será notificado apenas quando houver atualizações disponíveis para uma versão superior do Moodle. A verificação de atualizações para os módulos não é afetada por esta configuração.';
$string['upgradeerror'] = 'Ocorreu um erro ao atualizar o módulo \'{$a->plugin}\' para a versão {$a->version}. Não é possível continuar.';
$string['upgradeforumread'] = 'Foi adicionada uma nova funcionalidade ao Moodle 1.5 para assinalar as mensagens lidas/não lidas nos fóruns.<br />Para utilizar esta funcionalidade tem que <a href="{$a}">atualizar as suas tabelas</a>.';
$string['upgradeforumreadinfo'] = 'Foi adicionada uma nova funcionalidade ao Moodle 1.5 para assinalar as mensagens lidas/não lidas nos fóruns. Para utilizar esta funcionalidade tem que atualizar as suas tabelas com toda a informação de rastreio para mensagens existentes. Dependendo do tamanho do seu site, poderá levar muito tempo (horas) e poderá ser muito pesado para a Base de Dados, por isso é aconselhável fazê-lo num período calmo. Contudo, o seu site continuará a funcionar durante essa atualização e os utilizadores não serão afetados. Desde que comece este processo, é aconselhável que o deixe acabar (deixe a janela do navegador aberta). Contudo, se parar o processo fechando a janela, não se preocupe, pode sempre começar outra vez.<br /><br />Quer iniciar o processo de atualização agora?';
$string['upgradekeyreq'] = 'Necessária chave de atualização';
$string['upgradekeyset'] = 'Chave de atualização (deixe em branco caso não pretenda definir uma)';
$string['upgradelogs'] = 'Para funcionar em pleno, os seus registos de atividade antigos deverão ser atualizados. <a href="{$a}">Mais informação</a>';
$string['upgradelogsinfo'] = 'Foram efetuadas algumas alterações à forma como os registos de atividade são armazenados. Para conseguir consultar os suas antigos registos de atividade, estes deverão ser atualizados. Dependendo do seu site, esta operação pode demorar bastante (até algumas horas) e pode implicar um processamento pesado para a base de dados em sites de grande dimensão. Uma vez iniciado este processo deverá deixá-lo terminar (mantendo a janela do navegador aberta). Não se preocupe - o seu site continuará a trabalhar bem para outras pessoas enquanto as estatísticas são atualizadas.<br /><br />Quer atualizar as suas estatísticas agora?';
$string['upgradepluginsfirst'] = 'Recomenda-se que instale primeiro todas as atualizações disponíveis';
$string['upgradepluginsinfo'] = 'A atualizar módulos';
$string['upgradepluginsinfo_help'] = 'Existem atualizações disponíveis para alguns dos seus módulos. Deve instalá-las todas antes de atualizar a base de dados do Moodle. Se o seu site não suportar o desdobramento automático de atualizações, terá de descarregar as novas versões dos módulos e instalá-las manualmente.';
$string['upgradepluginsinfo_link'] = 'admin/upgradepluginsinfo';
$string['upgradesettings'] = 'Novas configurações';
$string['upgradesettingsintro'] = 'As configurações mostradas abaixo foram adicionadas durante a última atualização do Moodle. Modifique as que achar necessário e quando terminar clique no botão \'Guardar alterações\' no fim da página.';
$string['upgradestalefiles'] = 'Foram detetados ficheiros de instalação inválidos. A atualização não pode continuar.';
$string['upgradestalefilesinfo'] = 'O processo de atualização do Moodle foi interrompido porque foram detetados scripts de PHP de, pelo menos, duas versões anteriores do Moodle na pasta do Moodle.

Isto poderá causar problemas significativos mais tarde. Para prosseguir deverá certificar-se que a pasta do Moodle contém apenas os ficheiros de uma única versão do Moodle.

Recomenda-se o seguinte procedimento para limpar a sua pasta do Moodle:<br>
* atribua um novo nome à pasta atual do Moodle (por exemplo: "moodle_antiga");<br>
* crie uma nova pasta do Moodle que contenha apenas os ficheiros extraídos de um pacote Moodle ou a partir do repositório Moodle Git;<br>
* mova o ficheiro original \'config.php\' e todos os outros módulos não padrão da pasta "moodle_antiga" para a nova pasta do Moodle.

Quando tiver uma pasta do Moodle limpa, recarregue esta página para retomar o processo de atualização do Moodle.

Este aviso é frequentemente causado quando um pacote do Moodle é extraído de uma pasta comprimida (zip ou tgz) na mesma pasta de uma versão anterior do Moodle. Apesar disto ser aceitável para atualizações menores mas é altamente desaconselhado em atualizações maiores do Moodle.

Este aviso também pode ser causado por uma verificação incompleta ou por uma operação de atualização a partir do repositório Git. Neste caso, terá de aguardar que a operação termine, ou talvez correr o comando adequado de limpeza e repetir a operação.

Pode obter mais informações na documentação sobre atualizações em <a href="{$a}">{$a}</a>.';
$string['upgradestart'] = 'Atualizar agora a base de dados do Moodle';
$string['upgradesure'] = 'Os seus ficheiros Moodle foram alterados e está prestes a proceder à atualização do seu servidor para a nova versão:<br /><br /><strong>{$a}</strong>.<br /><br />Assim que efetuar esta operação não será possível voltar atrás.<br /><br />Tenha em atenção que este processo pode demorar algum tempo.<br /><br />Tem a certeza de que pretende atualizar o seu servidor para a nova versão?';
$string['upgradetimedout'] = 'Expirou o tempo para atualização. Por favor, reinicie o processo.';
$string['upgradingdata'] = 'A atualizar os dados';
$string['upgradinglogs'] = 'A atualizar os registos de atividade';
$string['upgradingversion'] = 'A atualizar para nova versão';
$string['upwards'] = 'ou superior';
$string['useblogassociations'] = 'Ativar associações';
$string['useexternalyui'] = 'Usar bibliotecas YUI online';
$string['user'] = 'Utilizador';
$string['userbulk'] = 'Processar em massa';
$string['userbulkdownload'] = 'Exportar utilizadores para';
$string['userdefaultpreferences'] = 'Preferências predefinidas do utilizador';
$string['userimagesdisabled'] = 'As imagens de perfil do utilizador estão desativadas';
$string['userlist'] = 'Ver lista completa';
$string['userpolicies'] = 'Política de utilizadores';
$string['userpreference'] = 'Preferência do utilizador';
$string['userquota'] = 'Quota do utilizador';
$string['users'] = 'Utilizadores';
$string['usesitenameforsitepages'] = 'Usar nome do site nas páginas do site';
$string['usetags'] = 'Ativar funcionalidade de palavras-chave';
$string['validateemptylineerror'] = 'As linhas vazias não são válidas';
$string['validateerror'] = 'Este valor não é válido';
$string['validateerrorlist'] = 'Estes registos são inválidos: {$a}';
$string['validateiperror'] = 'Estes endereços IP são inválidos: {$a}';
$string['verifychangedemail'] = 'Restringir domínios em alterações de e-mail';
$string['warningcurrentsetting'] = 'Valor atual inválido: {$a}';
$string['warningiconvbuggy'] = 'A sua versão da biblioteca iconv não suporta o modificador //IGNORE. Deverá instalar a extensão mbstring que pode ser usada como substituto para limpar texto com caracteres UTF-8 não válidos.';
$string['webproxy'] = 'Proxy web';
$string['webproxyinfo'] = 'Preencha as opções seguintes se o servidor Moodle não tiver acesso direto à Internet. O acesso à Internet é necessário para descarregar os dados do ambiente, pacotes linguísticos, fusos horários, etc.<br /><strong>É recomendada a instalação da extensão cURL do PHP.</strong>';
$string['xmlrpcrecommended'] = 'A extensão XMLRPC é útil para web services e redes Moodle';
$string['yuicomboloading'] = 'Optimizar carregamento de bibliotecas YUI';
$string['ziprequired'] = 'É obrigatória a instalação da extensão Zip do PHP. Os ficheiros binários info-ZIP e as bibliotecas PclZip deixaram de ser utilizados pelo Moodle.';
