<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'webservice', language 'cs', version '3.5'.
 *
 * @package     webservice
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessexception'] = 'Vyjímka v řízení přístupu';
$string['actwebserviceshhdr'] = 'Aktivní protokoly webových služeb';
$string['addaservice'] = 'Přidat službu';
$string['addcapabilitytousers'] = 'Zkontrolovat oprávnění uživatelů';
$string['addcapabilitytousersdescription'] = 'Uživatelé by měli mít dvě pravomoci - webservice:createtoken a pravomoc porovnávat použité protokoly, například webservice/rest:use, webservice/soap:use. Aby to bylo možné dosáhnout, vytvořte roli webové služby s povolenými příslušnými pravomocemi a přiřaďte ji uživateli webových služeb jako systémovou roli.';
$string['addfunction'] = 'Přidat funkci';
$string['addfunctionhelp'] = 'Vyberte funkci k přidání do služeb.';
$string['addfunctions'] = 'Přidat funkce';
$string['addfunctionsdescription'] = 'Vybrat požadované funkce pro nově vytvořenou službu.';
$string['addrequiredcapability'] = 'Přidat/odebrat požadovaná oprávnění';
$string['addservice'] = 'Přidat novou službu: {$a->name} (identifikátor: {$a->id})';
$string['addservicefunction'] = 'Přidat funkce ke službě "{$a}"';
$string['allusers'] = 'Všichni uživatelé';
$string['apiexplorer'] = 'API průzkumník';
$string['apiexplorernotavalaible'] = 'API průzkumník ještě není dostupný.';
$string['arguments'] = 'Parametry';
$string['authmethod'] = 'Autentizační metoda';
$string['callablefromajax'] = 'Volatelný z AJAX-u';
$string['cannotcreatetoken'] = 'Žádná povolení na vytvoření tokenu webové služby pro službu {$a}.';
$string['cannotgetcoursecontents'] = 'Nelze získat obsah kurzu';
$string['checkusercapability'] = 'Zkontrolovat oprávnění uživatele';
$string['checkusercapabilitydescription'] = 'Uživatel by měl mít příslušné pravomoci podle použitých protokolů, např. webservice/rest:use, webservice/soap:use. Aby to bylo možné dosáhnout, vytvořte roli webové služby s povolenými protokolovými schopnostmi a přiřaďte ji uživateli webových služeb jako systémovou roli.';
$string['configwebserviceplugins'] = 'Z bezpečnostních důvodů by měly být povoleny jen protokoly, které se používají.';
$string['context'] = 'Kontext';
$string['createservicedescription'] = 'Služba je soubor funkcí webové služby. Povolíte uživateli přistupovat k nové službě. Na stránce <strong>Přidat službu</strong> označte možnosti \'Aktivovat\' a \'Oprávnění uživatelé\'. Zvolte \'Žádná povinná schopnost\'.';
$string['createserviceforusersdescription'] = 'Služba je soubor funkcí webové služby. Povolíte uživatelům přistupovat k nové službě. Na stránce <strong>Přidat službu</strong> označte možnosti \'Aktivovat\' a \'Oprávnění uživatelé\'. Zvolte \'Žádná povinná schopnost\'.';
$string['createtoken'] = 'Vytvořit token';
$string['createtokenforuser'] = 'Vytvořit token pro uživatele';
$string['createtokenforuserdescription'] = 'Vytvořit token pro uživatele webových služeb.';
$string['createuser'] = 'Vytvoření konkrétního uživatele';
$string['createuserdescription'] = 'Uživatel webové služby je povinen fungovat v systému kontrolovatelném Moodlem.';
$string['criteriaerror'] = 'Chybějící oprávnění pro vyhledávání kritéria.';
$string['default'] = 'Výchozí hodnota je "{$a}"';
$string['deleteaservice'] = 'Odstranit službu';
$string['deleteservice'] = 'Odstranit službu: {$a->name} (identifikátor: {$a->id})';
$string['deleteserviceconfirm'] = 'Odstranění služby také odstraní tokeny vztahující se k této službě. Opravdu chcete odstranit externí službu "{$a}"?';
$string['deletetokenconfirm'] = 'Opravdu chcete odstranit tento token webové služby <strong>{$a->user}</strong> pro službu <strong>{$a->service}</strong>?';
$string['disabledwarning'] = 'Všechny protokoly webové služby jsou deaktivovány. Nastavení "Aktivovat webové služby" lze najít v Rozšířených vlastnostech.';
$string['doc'] = 'Dokumentace';
$string['docaccessrefused'] = 'Nemáte oprávnění vidět dokumentaci pro tento token';
$string['documentation'] = 'dokumentace webové služby';
$string['downloadfiles'] = 'Může stahovat soubory';
$string['downloadfiles_help'] = 'Pokud je povoleno, může každý uživatel stahovat soubory se svými bezpečnostními klíči. Samozřejmě, že jsou omezeny na soubory na webu, které mají oprávnění ke stažení.';
$string['editaservice'] = 'Úprava služby';
$string['editservice'] = 'Úprava služby: {$a->name} (id: {$a->id})';
$string['enabled'] = 'Povoleno';
$string['enabledocumentation'] = 'Povolit dokumentaci vývojáře';
$string['enabledocumentationdescription'] = 'Podrobná dokumentace webových služeb je dostupná pro aktivované protokoly.';
$string['enableprotocols'] = 'Povolit protokoly';
$string['enableprotocolsdescription'] = 'Alespoň jeden protokol by měl být aktivován. Z bezpečnostních důvodů by měly být aktivovány pouze skutečně použité protokoly.';
$string['enablews'] = 'Povolit webové služby';
$string['enablewsdescription'] = 'Webové služby musí být povoleny v Pokročilých funkcích.';
$string['entertoken'] = 'Zadejte bezpečnostní klíč/token:';
$string['error'] = 'Chyba: {$a}';
$string['errorcatcontextnotvalid'] = 'Nemůžete spouštět funkce v kontextu kategorie (category id:{$a->catid}). Chybová zpráva kontextu byla: {$a->message}';
$string['errorcodes'] = 'Chybová zpráva';
$string['errorcoursecontextnotvalid'] = 'Nemůžete spouštět funkce v kontextu kurzu (course id:{$a->courseid}). Chybová zpráva kontextu byla: {$a->message}';
$string['errorinvalidparam'] = 'Parametr "{$a}" je neplatný.';
$string['errornotemptydefaultparamarray'] = 'Parametr popisu webové služby "{$a}" má jednoduchou nebo vícenásobnou strukturu. Standardně to může být pouze prázdné pole. Zkontrolujte popis webové služby.';
$string['erroroptionalparamarray'] = 'Parametr popisu webové služby "{$a}" má jednoduchou nebo vícenásobnou strukturu. Nemůže být nastaven ako VALUE_OPTIONAL.  Zkontrolujte popis webové služby.';
$string['eventwebservicefunctioncalled'] = 'Byla volána webová služba';
$string['eventwebserviceloginfailed'] = 'Přihlášení webové služby zhavarovalo';
$string['eventwebserviceservicecreated'] = 'Vytvořena webová služba';
$string['eventwebserviceservicedeleted'] = 'Webová služba odstraněna';
$string['eventwebserviceserviceupdated'] = 'Webová služba byla aktualizována';
$string['eventwebserviceserviceuseradded'] = 'Byla přidán uživatel webové služby';
$string['eventwebserviceserviceuserremoved'] = 'Uživatel webové služby byl odstraněn';
$string['eventwebservicetokencreated'] = 'Byl vytvořen token webové služby';
$string['eventwebservicetokensent'] = 'Token webové služby byl odeslán';
$string['execute'] = 'Provést';
$string['executewarnign'] = 'UPOZORNĚNÍ: Stisknete-li "vykonat", vaše databáze bude upravena a změny nebude možné vrátit automaticky!';
$string['externalservice'] = 'Externí služby';
$string['externalservicefunctions'] = 'Funkce externích služeb';
$string['externalservices'] = 'Externí služby';
$string['externalserviceusers'] = 'Uživatelé externích služeb';
$string['failedtolog'] = 'Nepodařilo se přihlásit';
$string['filenameexist'] = 'Název souboru již existuje: {$a}';
$string['forbiddenwsuser'] = 'Nelze vytvořit token pro uživatele, který je nepotvrzen, odstraněn, pozastaven nebo je hostem.';
$string['function'] = 'Funkce';
$string['functions'] = 'Funkce';
$string['generalstructure'] = 'Obecná struktura';
$string['information'] = 'Informace';
$string['installexistingserviceshortnameerror'] = 'Webová služba se zkráceným názvem "{$a}" již existuje. Nelze nainstalovat/aktualizovat jinou webovou službu s tímto zkráceným názvem.';
$string['installserviceshortnameerror'] = 'Chyba kódování: zkrácený název služby "{$a}" může obsahovat pouze alfanumerické znaky (písmena a čísla), podtržítko (_), pomlčku (-) nebo tečku (.)';
$string['invalidextparam'] = 'Neplatný parametr externího API: {$a}';
$string['invalidextresponse'] = 'Neplatná odpověď externího API: {$a}';
$string['invalidiptoken'] = 'Neplatný token - vaše IP není podporována';
$string['invalidtimedtoken'] = 'Neplatný token - vypršela platnost tokenu';
$string['invalidtoken'] = 'Neplatný token - token nebyl nalezen';
$string['iprestriction'] = 'Omezení IP adres';
$string['iprestriction_help'] = 'Uživatel bude moci zavolat webovou službu z IP adres ze seznamu';
$string['key'] = 'Klíč';
$string['keyshelp'] = 'Klíče se používají k přístupu do vašeho Moodle účtu z externích aplikací.';
$string['loginrequired'] = 'Omezeno na přihlášené uživatele';
$string['manageprotocols'] = 'Správa protokolů';
$string['managetokens'] = 'Správa tokenů';
$string['missingcaps'] = 'Chybějící pravomoci';
$string['missingcaps_help'] = 'Seznam povinných pravomocí pro službu, kterou zvolený uživatel nemá. Aby mohl uživatel tuto službu používat, musí být chybějící pravomoci přidány do jeho uživatelské role.';
$string['missingpassword'] = 'Chybějící heslo';
$string['missingrequiredcapability'] = 'Je požadována pravomoc {$a}.';
$string['missingusername'] = 'Chybějící uživatelské jméno';
$string['missingversionfile'] = 'Chyba kódování: pro komponent {$a} chybí soubor version.php';
$string['nameexists'] = 'Tento název je již používán jinou službou';
$string['nocapabilitytouseparameter'] = 'Uživatel nemá požadovanou pravomoc k používání parametru {$a}';
$string['nofunctions'] = 'Tato služba nemá žádné funkce';
$string['norequiredcapability'] = 'Chybí vyžadovaná pravomoc';
$string['notoken'] = 'Seznam tokenů je prázdný';
$string['onesystemcontrolling'] = 'Povolit externí systém pro řízení Moodle';
$string['onesystemcontrollingdescription'] = 'Následující kroky vám pomohou nastavit webovou službu Moodle, aby bylo povoleno vzájemné působení externího systému a Moodle. Toto zahrnuje nastavení metody ověření tokenu (bezpečnostního klíče).';
$string['onlyseecreatedtokens'] = 'Libovolný token lze smazat, ačkoli můžete zobrazit pouze tokeny, které jste vytvořili.';
$string['operation'] = 'Operace';
$string['optional'] = 'Volitelný';
$string['passwordisexpired'] = 'Platnost hesla vypršela';
$string['phpparam'] = 'XML-RPC (PHP structure)';
$string['phpresponse'] = 'XML-RPC (PHP structure)';
$string['postrestparam'] = 'PHP kód pro REST (požadavek POST)';
$string['potusers'] = 'Nejsou oprávnění uživatelé';
$string['potusersmatching'] = 'Nejsou vhodní oprávnění uživatelé';
$string['print'] = 'Tisknout vše';
$string['privacy:metadata:serviceusers'] = 'Seznam uživatelů, kteří mohou používat určité externí službu';
$string['privacy:metadata:serviceusers:iprestriction'] = 'IP omezení pro použití služby';
$string['privacy:metadata:serviceusers:timecreated'] = 'Datum vytvoření záznamu';
$string['privacy:metadata:serviceusers:userid'] = 'ID uživatele';
$string['privacy:metadata:serviceusers:validuntil'] = 'Datum ukončení oprávnění';
$string['privacy:metadata:tokens'] = 'Záznam tokenů pro interakci s Moodle prostřednictvím webových služeb nebo mobilních aplikací.';
$string['privacy:metadata:tokens:creatorid'] = 'ID uživatele, který vytvořil token';
$string['privacy:metadata:tokens:iprestriction'] = 'IP omezení pro použití tohoto tokenu';
$string['privacy:metadata:tokens:lastaccess'] = 'Datum posledního užití tokenu';
$string['privacy:metadata:tokens:privatetoken'] = 'Soukromý token se příležitostně používá k ověření některých operací, jako je SSO';
$string['privacy:metadata:tokens:timecreated'] = 'Datum vytvoření tokenu';
$string['privacy:metadata:tokens:token'] = 'Token uživatele';
$string['privacy:metadata:tokens:tokentype'] = 'Typ tokenu';
$string['privacy:metadata:tokens:userid'] = 'ID uživatele, vlastníka tokenu';
$string['privacy:metadata:tokens:validuntil'] = 'Datum zneplatnění tokenu';
$string['privacy:request:notexportedsecurity'] = 'Neexportováno z bezpečnostních důvodů';
$string['protocol'] = 'Protokol';
$string['removefunction'] = 'Odebrat';
$string['removefunctionconfirm'] = 'Skutečně si přejete odstranit funkci "{$a->function}" ze služby "{$a->service}"?';
$string['requireauthentication'] = 'Tato metoda vyžaduje autentizaci s xxx povolením.';
$string['required'] = 'Požadováno';
$string['requiredcapability'] = 'Požadovaná pravomoc';
$string['requiredcapability_help'] = 'Je-li nastaveno, pak mohou mít přístup ke službě pouze uživatelé s požadovaným oprávněním.';
$string['requiredcaps'] = 'Požadované pravomoci';
$string['resettokenconfirm'] = 'Skutečně si přejete znovu nastavit tento klíč webové služby pro uživatele: <strong>{$a->user}</strong> ve službě <strong>{$a->service}</strong>?';
$string['resettokenconfirmsimple'] = 'Skutečně si přejete znovu nastavit tento klíč? Všechny uložené odkazy obsahující tento klíč již nebudou funkční.';
$string['response'] = 'Odpověď';
$string['restcode'] = 'Obnovit';
$string['restexception'] = 'Obnovit';
$string['restoredaccountresetpassword'] = 'Obnovený účet potřebuje obnovit heslo dříve, než dostane token.';
$string['restparam'] = 'REST (parametry POST)';
$string['restrictedusers'] = 'Pouze oprávnění uživatelé';
$string['restrictedusers_help'] = 'Toto nastavení určuje, zda všichni uživatelé s povolením k vytvoření webových token služeb, mohou generovat token pro tuto službu prostřednictvím svého klíče zabezpečení, nebo zda mohou tak učinit pouze oprávnění uživatelé.';
$string['securitykey'] = 'Bezpečnostní klíč (token)';
$string['securitykeys'] = 'Bezpečnostní klíče';
$string['selectauthorisedusers'] = 'Vybrat oprávněné uživatele';
$string['selectedcapability'] = 'Vybrané';
$string['selectedcapabilitydoesntexit'] = 'Aktuálně nastavená požadovaná schopnost ({$a}) již neexistuje. Prosím, změňte ji a uložte změny.';
$string['selectservice'] = 'Zvolit službu';
$string['selectspecificuser'] = 'Výběr konkrétního uživatele';
$string['selectspecificuserdescription'] = 'Přidat webové služby uživatele jako oprávněného uživatele.';
$string['service'] = 'Služby';
$string['servicehelpexplanation'] = 'Služba je sada funkcí. Služba může být přístupná všem uživatelům nebo jen konkrétnímu uživateli.';
$string['servicename'] = 'Název služby';
$string['servicenotavailable'] = 'Webová služba není dostupná (neexistuje nebo je vypnuta)';
$string['servicerequireslogin'] = 'Webová služba není k dispozici (relace byla odhlášena nebo vypršela)';
$string['servicesbuiltin'] = 'Vestavěné služby';
$string['servicescustom'] = 'Vlastní služby';
$string['serviceusers'] = 'Oprávnění uživatelé';
$string['serviceusersettings'] = 'Uživatelské nastavení';
$string['serviceusersmatching'] = 'Odpovídající oprávnění uživatelé';
$string['serviceuserssettings'] = 'Změna nastavení pro oprávněné uživatele';
$string['shortnametaken'] = 'Zkrácený název je již používán pro jinou službu ({$a})';
$string['simpleauthlog'] = 'Jednoduchá autentizace';
$string['step'] = 'Krok';
$string['supplyinfo'] = 'Více informací';
$string['testauserwithtestclientdescription'] = 'Simulovat externí přístup ke službě použitím testovacího klienta webové služby. Před simulací se přihlašte jako uživatel se schopností moodle/webservice:createtoken capability a získejte bezpečnostný klíč (token) přes nastavení Můj profil. Tento klíč použijete v testovacím klientu. V testovacím klientu si také vyberete aktivovaný protokol s ověřením tokenu. <strong>VAROVÁNÍ: Funkce, které testujete BUDOU pro tohoto uživatele VYKONÁNY, proto buďte opatrni, co si vyberete k testování!</strong>';
$string['testclient'] = 'Testovací klient webové služby';
$string['testclientdescription'] = '* Testovací klient webové služby <strong>provádí SKUTEČNÉ</strong> funkce. Netestujte funkce, které neznáte. <br/>* Všechny stávající funkce pro webové služby nejsou dosud implementovány do zkušebního klienta. <br/>* Za účelem ověření, že uživatel nemůže získat přístup k některým funkcím, můžete vyzkoušet některé funkce, které nemáte povolené. <br/>* Chcete-li vidět podrobnější chybové zprávy, nastavte ladění na <strong>{$a->mode}</strong> do {$a->atag}.';
$string['testwithtestclient'] = 'Test služeb';
$string['testwithtestclientdescription'] = 'Simulujte externí přístup ke službě pomocí testovacího klienta webové služby. Použijte aktivovaný protokol s ověřením tokenu. <strong>VAROVÁNÍ: Funkce, které testujete BUDOU pro tohoto uživatele VYKONÁNY, proto buďte opatrni, co si vyberete k testování!</strong>';
$string['token'] = 'Token';
$string['tokenauthlog'] = 'Autentizační token';
$string['tokencreatedbyadmin'] = 'Resetovat může pouze správce (*)';
$string['tokencreator'] = 'Tvůrce';
$string['unknownoptionkey'] = 'Neznámý klíč volby  ({$a})';
$string['unnamedstringparam'] = 'Parametr řetězce není pojmenován.';
$string['updateusersettings'] = 'Aktualizace';
$string['uploadfiles'] = 'Může nahrávat soubory';
$string['uploadfiles_help'] = 'Pokud je povoleno, může každý uživatel vkládat se svým bezpečnostním klíčem ve vlastním prostředí osobní soubory nebo do pracovní oblasti souborů.  Jsou platná omezení souborů uživatele.';
$string['userasclients'] = 'Uživatelé jako klienti s tokenem';
$string['userasclientsdescription'] = 'Následující kroky vám pomohou nastavit webovou službu Moodle pro uživatele jako klienty. Tyto kroky také pomohou nastavit doporučenou metodu ověřování tokenů (bezpečnostní klíče). V tomto případě použití uživatel vytvoří svůj token ze stránky bezpečnostních klíčů přes nastavení svého profilu.';
$string['usermissingcaps'] = 'Chybějící schopnosti: {$a}';
$string['usernameorid'] = 'Uživatelské jméno / ID uživatele';
$string['usernameorid_help'] = 'Zadejte uživatelské jméno nebo ID uživatele';
$string['usernameoridnousererror'] = 'Nebyl nalezen uživatel pro toto  uživatelské jméno/ID uživatele';
$string['usernameoridoccurenceerror'] = 'Byl nalezen více než jeden uživatel s tímto uživatelským jménem. Prosím, vložte ID uživatele.';
$string['usernotallowed'] = 'Uživatel nemá oprávnění pro tuto službu. Nejprve je potřebujete tomuto uživateli přidat na stránce administrace oprávněných uživatelů {$a}.';
$string['userservices'] = 'Uživatel služby: {$a}';
$string['usersettingssaved'] = 'Uživatelské nastavení uloženo';
$string['validuntil'] = 'Platné do';
$string['validuntil_help'] = 'Je-li nastaveno, služba bude po tomto datu pro tohoto uživatele deaktivována';
$string['webservice'] = 'Webová služba';
$string['webservices'] = 'Webové služby';
$string['webservicesoverview'] = 'Přehled';
$string['webservicetokens'] = 'Tokeny webové služby';
$string['wrongusernamepassword'] = 'Chybné uživatelské jméno nebo heslo';
$string['wsaccessuserdeleted'] = 'Odmítnutý přístup webové služby pro odstraněná uživatelská jména: {$a}';
$string['wsaccessuserexpired'] = 'Odmítnutý přístup webové služby pro uživatelská jména s vypršeným heslem: {$a}';
$string['wsaccessusernologin'] = 'Odmítnutý přístup webové služby pro uživatelská jména bez ověření přihlášení : {$a}';
$string['wsaccessusersuspended'] = 'Odmítnutý přístup webové služby pro pozastavená uživatelská jména: {$a}';
$string['wsaccessuserunconfirmed'] = 'Odmítnutý přístup webové služby pro nepotvrzená uživatelská jména: {$a}';
$string['wsclientdoc'] = 'Dokumentace webové služby Moodle klienta';
$string['wsdocapi'] = 'API Dokumentace';
$string['wsdocumentation'] = 'Dokumentace webové služby';
$string['wsdocumentationdisable'] = 'Dokumentace webové služby není povolená.';
$string['wsdocumentationintro'] = 'Chcete-li vytvořit klienta doporučujeme, abyste si přečetli  {$a->doclink}';
$string['wsdocumentationlogin'] = 'nebo zadejte své uživatelské jméno a heslo webové služby :';
$string['wspassword'] = 'Heslo webové služby';
$string['wsusername'] = 'Uživatelské jméno webové služby';
