<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'forum', language 'cs', version '3.5'.
 *
 * @package     forum
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityoverview'] = 'Máte jeden či více nových příspěvků ve fóru (klikněte zde pro zobrazení).';
$string['addanewdiscussion'] = 'Přidat nové téma diskuse';
$string['addanewquestion'] = 'Přidat novou otázku';
$string['addanewtopic'] = 'Přidat nové téma';
$string['advancedsearch'] = 'Pokročilé vyhledávání';
$string['allforums'] = 'Všechna fóra';
$string['allowdiscussions'] = 'Může {$a} přispívat do tohoto fóra?';
$string['allowsallsubscribe'] = 'V tomto fóru si může každý zvolit, zda bude odebírat příspěvky nebo ne.';
$string['allowsdiscussions'] = 'V tomto fóru může každý zahájit nové téma diskuse.';
$string['allsubscribe'] = 'Odebírat příspěvky ze všech fór';
$string['allunsubscribe'] = 'Zrušit odebírání příspěvků ze všech fór';
$string['alreadyfirstpost'] = 'Toto je první příspěvek ve fóru';
$string['anyfile'] = 'Libovolný soubor';
$string['areaattachment'] = 'Přílohy';
$string['areapost'] = 'Zprávy';
$string['attachment'] = 'Příloha';
$string['attachment_help'] = 'Volitelně můžete k příspěvku přiložit jeden nebo více souborů. Přiložíte-li obrázek, bude automaticky zobrazen.';
$string['attachmentnopost'] = 'Nemůžete exportovat přílohy bez id příspěvku';
$string['attachments'] = 'Přílohy';
$string['attachmentswordcount'] = 'Přílohy a počet slov';
$string['blockafter'] = 'Blokovat po dosažení počtu příspěvků';
$string['blockafter_help'] = 'Uživatelům je zablokována možnost dále přispívat, vloží-li do fóra během daného období nastavený počet příspěvků. Toto omezení se nevztahuje na uživatele s pravomocí "Ignorovat limit počtu příspěvků" (mod/forum:postwithoutthrottling).';
$string['blockperiod'] = 'Blokační období';
$string['blockperiod_help'] = 'Uživatelům je zablokována možnost dále přispívat, vloží-li do fóra během nastaveného období jistý počet příspěvků. Toto omezení se nevztahuje na uživatele s pravomocí "Ignorovat limit počtu příspěvků" (mod/forum:postwithoutthrottling).';
$string['blockperioddisabled'] = 'Neblokovat';
$string['blogforum'] = 'Standardní fórum zobrazované jako blog';
$string['bynameondate'] = 'autor {$a->name} - {$a->date}';
$string['cannotadd'] = 'Do tohoto fóra není možné přidat diskusi';
$string['cannotadddiscussion'] = 'Abyste mohli přidávat diskuse do tohoto fóra, musíte být členy skupiny.';
$string['cannotadddiscussionall'] = 'Nemáte oprávnění vkládat téma diskuse pro všechny účastníky.';
$string['cannotadddiscussiongroup'] = 'Nemůžete vytvořit diskusi, protože nejste členem žádné skupiny.';
$string['cannotaddsubscriber'] = 'Není možné přidat do tohoto fóra odběratele {$a}!';
$string['cannotaddteacherforumto'] = 'Není možné přidat do sekce 0 (úvodní) převedené učitelské fórum.';
$string['cannotcreatediscussion'] = 'Nelze vytvořit novou diskusi';
$string['cannotcreateinstanceforteacher'] = 'Není možné vytvořit nové učitelské fórum';
$string['cannotdeletepost'] = 'Nemáte oprávnění odstranit tento příspěvek';
$string['cannoteditposts'] = 'Nemůžete upravovat příspěvky jiných lidí!';
$string['cannotfinddiscussion'] = 'V tomto fóru se nepodařilo najít diskusi';
$string['cannotfindfirstpost'] = 'Nelze najít první příspěvek v tomto fóru';
$string['cannotfindorcreateforum'] = 'Na tomto webu nelze najít nebo vytvořit hlavní fórum oznámení';
$string['cannotfindparentpost'] = 'Nelze najít počáteční příspěvek v této diskusi {$a}';
$string['cannotmovefromsingleforum'] = 'Nemůžete přesunout diskusi z typu jednoduchého diskusního fóra';
$string['cannotmovenotvisible'] = 'Fórum není viditelné';
$string['cannotmovetonotexist'] = 'Nemůžete přesunout diskusi do neexistujícího fóra!';
$string['cannotmovetonotfound'] = 'Cílové fórum nebylo v tomto kurzu nalezeno.';
$string['cannotmovetosingleforum'] = 'Nelze přesunout diskusi na jednoduché prosté diskusní fórum';
$string['cannotpurgecachedrss'] = 'Nelze vymazat mezipaměť RSS pro daný zdroj a/nebo cílové fórum. Zkontrolujte oprávnění.';
$string['cannotremovesubscriber'] = 'Nelze odstranit odběratele s id {$a} z tohoto fóra!';
$string['cannotreply'] = 'Na tento příspěvek nemůžete odpovídat';
$string['cannotsplit'] = 'Diskuze z tohoto fóra nelze rozdělit';
$string['cannotsubscribe'] = 'Promiňte, ale chcete-li se přihlásit k odběru tohoto fóra, musíte být členem nějaké skupiny.';
$string['cannottrack'] = 'Z tohoto fóra není možné zastavit sledování ';
$string['cannotunsubscribe'] = 'Z tohoto fóra není možné odhlásit odběr';
$string['cannotupdatepost'] = 'Tento příspěvek nemůžete aktualizovat';
$string['cannotviewpostyet'] = 'Nemůžete si prohlédnout otázky jiných studentů, protože jste ještě nevložili svůj příspěvek.';
$string['cannotviewusersposts'] = 'Nemáte přístup k žádným příspěvkům tohoto uživatele.';
$string['cleanreadtime'] = 'Hodina označování přečtených příspěvků';
$string['clicktosubscribe'] = 'V této diskusi nejste přihlášeni k odběru. Klikněte na tlačítko odebírat.';
$string['clicktounsubscribe'] = 'V této diskusi jste přihlášeni k odběru. Klikněte na tlačítko zrušit odběr.';
$string['completiondiscussions'] = 'Počet diskusí, které musí student odstartovat:';
$string['completiondiscussionsdesc'] = 'Student musí vytvořit alespoň {$a} diskusí';
$string['completiondiscussionsgroup'] = 'Požadovat diskuse';
$string['completiondiscussionshelp'] = 'Pro ukončení se vyžadují diskuse';
$string['completionposts'] = 'Počet příspěvků nebo odpovědí, které musí student vytvořit:';
$string['completionpostsdesc'] = 'Student musí zveřejnit alespoň {$a} diskusí nebo odpovědí';
$string['completionpostsgroup'] = 'Vyžadovat příspěvky';
$string['completionpostshelp'] = 'Pro ukončení se vyžadují diskuse nebo odpovědi';
$string['completionreplies'] = 'Počet odpovědí, které musí student odeslat:';
$string['completionrepliesdesc'] = 'Student musí odeslat nejméně {$a} odpověď/odpovědí';
$string['completionrepliesgroup'] = 'Vyžadovat odpovědi';
$string['completionreplieshelp'] = 'Pro ukončení modulu se vyžadují odpovědi';
$string['configcleanreadtime'] = 'V kterou denní hodinu se mají staré příspěvky označit jako přečtené, tj. v kolik hodin se má čistit tabulka \'read\' od starých příspěvků';
$string['configdigestmailtime'] = 'Zadejte hodinu, kdy mají být odesílány denní e-mailové přehledy. (E-maily budou rozeslány při prvním spuštění cronu po nastavené hodině.)';
$string['configdisplaymode'] = 'Výchozí způsob zobrazování diskuse, není-li uživateli nastaveno jinak.';
$string['configenablerssfeeds'] = 'Povolit funkci RSS kanálů pro všechna diskusní fóra. Budete ještě muset zapnout RSS kanály v nastavení jednotlivých fór.';
$string['configenabletimedposts'] = 'Zvolte "Ano", pokud chcete povolit nastavování doby zobrazení při vkládání nové diskuse.';
$string['configlongpost'] = 'Příspěvek delší než tato vložená hodnota (HTML kód se nepočítá) je považován za dlouhý. Příspěvky zobrazované na titulní stránce instalace, v kurzech s diskusním uspořádáním a na stránce uživatelského profilu jsou zalomeny v místě přirozeného předělu tak, že počet zobrazených znaků leží někde mezi hodnotami forum_shortpost a forum_longpost.';
$string['configmanydiscussions'] = 'Maximální počet diskusí zobrazovaných na jedné stránce fóra.';
$string['configmaxattachments'] = 'Výchozí maximální počet příloh pro každý příspěvek.';
$string['configmaxbytes'] = 'Výchozí maximální velikost přílohy ve všech fórech na těchto stránkách (může být upravena nastavením kurzu a dalšími lokálními proměnnými).';
$string['configoldpostdays'] = 'Po kolika dnech se bude příspěvek považovat za přečtený';
$string['configreplytouser'] = 'Když je příspěvek odesílán odběratelům, má e-mail v poli \'Od:\' obsahovat adresu autora příspěvku? Příjemce tak může odpovídat přímo autorovi e-mailem, a ne prostřednictvím diskusního fóra. I když je zde zvolena hodnota \'Ano\', uživatelé si mohou ve svých profilech nastavit skrývání své e-mailové adresy.';
$string['configrssarticlesdefault'] = 'Pokud jsou povoleny RSS kanály, nastavení výchozího počet článků (buď diskuse nebo příspěvků).';
$string['configrsstypedefault'] = 'Pokud jsou povoleny RSS kanály, nastaví výchozí typ činnosti.';
$string['configshortpost'] = 'Příspěvek kratší než tato vložená hodnota (HTML kód se nepočítá) je považován za krátký.';
$string['configsubscriptiontype'] = 'Výchozí nastavení pro režim odběru.';
$string['configtrackingtype'] = 'Výchozí nastavení pro sledování příspěvků.';
$string['configtrackreadposts'] = 'Zvolte \'Ano\', chcete-li pro každého uživatele zaznamenávat stav příspěvků přečteno/nepřečteno.';
$string['configusermarksread'] = 'Při \'Ano\' si musí uživatelé sami označit příspěvek jako přečtený. Při \'Ne\' se příspěvek automaticky označí jako přečtený po zobrazení uživateli.';
$string['confirmsubscribe'] = 'Skutečně si přejete odebírat příspěvky z fóra "{$a}"?';
$string['confirmsubscribediscussion'] = 'Chcete se opravdu přihlásit k odebírání diskuse "{$a->discussion}" na fóru "{$a->forum}"?';
$string['confirmunsubscribe'] = 'Skutečně si přejete zrušit odebírání příspěvků z fóra "{$a}"?';
$string['confirmunsubscribediscussion'] = 'Chcete se opravdu odhlásit z odebírání diskuse "{$a->discussion}" na fóru "{$a->forum}"?';
$string['couldnotadd'] = 'Neznámá chyba! Nemohu přidat váš příspěvek.';
$string['couldnotdeletereplies'] = 'Příspěvek, na který již někdo odpověděl, nemůže být odstraněn.';
$string['couldnotupdate'] = 'Neznámá chyba! Nemohu aktualizovat váš příspěvek.';
$string['crontask'] = 'Zasílání zpráv a údržba diskusních fór';
$string['delete'] = 'Odstranit';
$string['deleteddiscussion'] = 'Téma diskuse bylo odstraněno.';
$string['deletedpost'] = 'Příspěvek byl odstraněn.';
$string['deletedposts'] = 'Tyto příspěvky byly odstraněny.';
$string['deletesure'] = 'Jste si jistí, že chcete odstranit tento příspěvek?';
$string['deletesureplural'] = 'Jste si jistí, že chcete odstranit tento příspěvek a všechny odpovědi na něj? ({$a} příspěvků)';
$string['digestmailheader'] = 'Toto je váš denní souhrn nových příspěvků v diskusních fórech na stránkách {$a->sitename}. Chcete-li změnit nastaveni těchto odběrů, jděte na {$a->userprefs}.';
$string['digestmailpost'] = 'Změna nastavení preferencí souhrnu';
$string['digestmailpostlink'] = 'Změnit nastavení voleb fóra: {$a}';
$string['digestmailprefs'] = 'váš uživatelský profil';
$string['digestmailsubject'] = '{$a}: souhrn novych prispevku';
$string['digestmailtime'] = 'Hodina odesílání souhrnných emailů';
$string['digestsentusers'] = 'Souhrnné e-maily úspěšně zaslány {$a} uživatelům.';
$string['disallowsubscribe'] = 'Odebírání e-mailem není povoleno.';
$string['disallowsubscribeteacher'] = 'Odebírání e-mailem není povoleno (s výjimkou učitelů).';
$string['disallowsubscription'] = 'Odebírání';
$string['disallowsubscription_help'] = 'V tomto fóru se nemůžete přihlásit k odebírání diskusí.';
$string['discussion'] = 'Diskuse';
$string['discussionlocked'] = 'Tato diskuse byla uzavřena, takže již nemůže odpovídat.';
$string['discussionlockingdisabled'] = 'Neuzavírejte diskuse';
$string['discussionlockingheader'] = 'Uzavření diskuse';
$string['discussionmoved'] = 'Tato diskuse byla přesunuta do "{$a}".';
$string['discussionmovedpost'] = 'Diskuse byla přesunuta <a href="{$a->discusshref}">na jiné místo</a> do fóra <a href="{$a->forumhref}">{$a->forumname}</a>';
$string['discussionname'] = 'Název diskuse';
$string['discussionnownotsubscribed'] = '{$a->name} NEBUDE  informován o nových příspěvcích v "{$a->discussion}" z "{$a->forum}"';
$string['discussionnowsubscribed'] = '{$a->name} bude  informován o nových příspěvcích v "{$a->discussion}" z "{$a->forum}"';
$string['discussionpin'] = 'Vždy na vrchu';
$string['discussionpinned'] = 'Připnuté navrch';
$string['discussionpinned_help'] = 'Diskuse se objeví připnutá v horní části fóra.';
$string['discussions'] = 'Diskuse';
$string['discussionsstartedby'] = 'Diskuse, které zahájil(a) {$a}';
$string['discussionsstartedbyrecent'] = 'Diskuse, které právě zahájil(a) {$a}';
$string['discussionsstartedbyuserincourse'] = 'Diskuse zahájené uživatelem {$a->fullname} v kurzu {$a->coursename}';
$string['discussionsubscribestart'] = 'Pošlete mi upozornění na nové příspěvky této diskuze';
$string['discussionsubscribestop'] = 'Nechci být upozorňován na nové příspěvky této diskuze';
$string['discussionsubscription'] = 'Odebírání diskuse';
$string['discussionsubscription_help'] = 'Při zapnutém odběru diskuse budete dostávat upozornění na nové příspěvky v této diskusi.';
$string['discussionunpin'] = 'Oodepnout';
$string['discussthistopic'] = 'Zobrazit diskusi';
$string['displayend'] = 'Konec';
$string['displayend_help'] = '<p>Můžete si zvolit, zda se váš příspěvek bude zobrazovat od určitého data,
nebo do určitého data, nebo bude zobrazen pouze po určitou dobu.</p>

<p>Odškrtnutím pole "Zakázat" aktivujete datum pro začátek a/nebo konec
zobrazení.</p>

<p>Poznámka: Uživatelé, kteří mají práva správce, uvidí příspěvky před
stanoveným datem i po něm.</p>';
$string['displaymode'] = 'Režim zobrazení';
$string['displayperiod'] = 'Doba zobrazování příspěvku';
$string['displaystart'] = 'Začátek';
$string['displaystart_help'] = '<p>Můžete si zvolit, zda se váš příspěvek bude zobrazovat od určitého data,
nebo do určitého data, nebo bude zobrazen pouze po určitou dobu.</p>

<p>Odškrtnutím pole "Zakázat" aktivujete datum pro začátek a/nebo konec
zobrazení.</p>

<p>Poznámka: Uživatelé, kteří mají práva správce, uvidí příspěvky před
stanoveným datem i po něm.</p>';
$string['displaywordcount'] = 'Zobrazovat počet slov';
$string['displaywordcount_help'] = 'Zda se má zobrazovat počet slov v každém příspěvku.';
$string['eachuserforum'] = 'Každý může zahájit jedno téma diskuse';
$string['edit'] = 'Upravit';
$string['editedby'] = 'Dodatečně upravil/-a: {$a->name}; čas vložení původního příspěvku:  {$a->date}';
$string['editedpostupdated'] = 'Příspěvek uživatele {$a} byl aktualizován';
$string['editing'] = 'Úprava';
$string['emaildigestcompleteshort'] = 'Plné znění příspěvků';
$string['emaildigestdefault'] = 'Výchozí  ({$a})';
$string['emaildigestoffshort'] = 'Bez souhrnu';
$string['emaildigestsubjectsshort'] = 'Pouze témata';
$string['emaildigesttype'] = 'Volby e-mailového souhrnu';
$string['emaildigesttype_help'] = 'Typ zprávy, kterou budete dostávat z každého fóra.

* Výchozí- stejné nastavení přehledu jako ve vašem uživatelském profilu. Pokud aktualizujete svůj profil, pak se tato změna se promítne i zde;
* Nezkrácené - za každý diskusní příspěvek obdržíte e-mail;
* Přehled - kompletní příspěvky - obdržíte jeden e-mail s přehledem denně, který obsahuje kompletní obsah příspěvků fóra;
* Přehled - pouze předměty - obdržíte jeden e-mail s přehledem denně, který obsahuje  předmět příspěvků fóra.';
$string['emptymessage'] = 'Ve vašem příspěvku je něco špatně. Možná jste nevyplnili některé povinné údaje, nebo byl přiložený soubor moc velký. Vaše úpravy NEBYLY ULOŽENY!';
$string['erroremptymessage'] = 'Text příspěvku nemůže být prázdný';
$string['erroremptysubject'] = 'Předmět příspěvku nemůže být prázdný';
$string['errorenrolmentrequired'] = 'Musíte být zapsáni v tomto kurzu pro přístup k danému obsahu';
$string['errorwhiledelete'] = 'Při mazání záznamu došlo k chybě.';
$string['eventassessableuploaded'] = 'Byl zveřejněn nový obsah.';
$string['eventcoursesearched'] = 'Hledaný kurz';
$string['eventdiscussioncreated'] = 'Vytvořena diskuse';
$string['eventdiscussiondeleted'] = 'Diskuse odstraněna';
$string['eventdiscussionmoved'] = 'Diskuse přesunuta';
$string['eventdiscussionpinned'] = 'Diskuse připnuta';
$string['eventdiscussionsubscriptioncreated'] = 'Vytvořeno odebírání diskuse';
$string['eventdiscussionsubscriptiondeleted'] = 'Odebírání diskuse odstraněno';
$string['eventdiscussionunpinned'] = 'Diskuse odepnuta';
$string['eventdiscussionupdated'] = 'Diskuse aktualizována';
$string['eventdiscussionviewed'] = 'Diskuse zobrazena';
$string['eventpostcreated'] = 'Vytvořen příspěvek';
$string['eventpostdeleted'] = 'Příspěvek odstraněn';
$string['eventpostupdated'] = 'Příspěvek aktualizován';
$string['eventreadtrackingdisabled'] = 'Zakázáno sledování příspěvků';
$string['eventreadtrackingenabled'] = 'Sledování příspěvků povoleno';
$string['eventsubscribersviewed'] = 'Zobrazen seznam odběratelů';
$string['eventsubscriptioncreated'] = 'Vytvořen odběr';
$string['eventsubscriptiondeleted'] = 'Odběr odstraněn';
$string['eventuserreportviewed'] = 'Zobrazena uživatelská sestava';
$string['everyonecanchoose'] = 'Odebírání příspěvků je volitelné';
$string['everyonecannowchoose'] = 'Nyní je odebírání příspěvků volitelné';
$string['everyoneisnowsubscribed'] = 'Nyní všichni odebírají příspěvky tohoto fóra';
$string['everyoneissubscribed'] = 'Všichni odebírají nové příspěvky';
$string['existingsubscribers'] = 'Stávající odběratelé';
$string['exportdiscussion'] = 'Exportovat celou diskusi do portfolia';
$string['forcedreadtracking'] = 'Povolit vynucení sledování příspěvků';
$string['forcedreadtracking_desc'] = 'Umožňuje ve fórech nastavit vnucené sledování příspěvků. Následkem bude pokles výkonu u některých uživatelů, především v kurzech s mnoha fóry a příspěvky. Zaškrtnutím této možnosti bude se sledováním příspěvků ve fórech dříve nastavených na Vnucené zacházeno tak, jako by bylo nastaveno na Volitelné.';
$string['forcesubscribed'] = 'Toto fórum vynucuje odběr příspěvků';
$string['forcesubscribed_help'] = 'V tomto fóru není povoleno odhlásit se z odběru diskusí.';
$string['forum'] = 'Fórum';
$string['forum:addinstance'] = 'Přidat nové fórum';
$string['forum:addnews'] = 'Přidat oznámení';
$string['forum:addquestion'] = 'Přidávat otázku';
$string['forum:allowforcesubscribe'] = 'Vnucovat odběr příspěvků';
$string['forum:canoverridediscussionlock'] = 'Odpověď na uzavřených diskusí';
$string['forum:canposttomygroups'] = 'Poslat do všech skupin, kam máte přístup';
$string['forum:createattachment'] = 'Vkládat přílohy';
$string['forum:deleteanypost'] = 'Kdykoliv odstraňovat jakékoliv příspěvky';
$string['forum:deleteownpost'] = 'Odstraňovat vlastní příspěvky (během nastaveného limitu)';
$string['forum:editanypost'] = 'Upravovat libovolný příspěvek';
$string['forum:exportdiscussion'] = 'Exportovat celou diskusi';
$string['forum:exportownpost'] = 'Exportovat vlastní příspěvek';
$string['forum:exportpost'] = 'Exportovat příspěvek';
$string['forum:managesubscriptions'] = 'Spravovat odběratele příspěvků';
$string['forum:movediscussions'] = 'Přesouvat diskuse';
$string['forum:pindiscussions'] = 'Diskuse vždy navrchu';
$string['forum:postwithoutthrottling'] = 'Ignorovat limit počtu příspěvků';
$string['forum:rate'] = 'Hodnotit příspěvky';
$string['forum:replynews'] = 'Odpovídat na oznámení';
$string['forum:replypost'] = 'Odpovídat na příspěvky';
$string['forum:splitdiscussions'] = 'Rozdělovat diskusi';
$string['forum:startdiscussion'] = 'Začínat novou diskusi';
$string['forum:viewallratings'] = 'Zobrazit podrobné informace o hodnocení jednotlivými uživateli';
$string['forum:viewanyrating'] = 'Zobrazit celkový výsledek hodnocení libovolného uživatele';
$string['forum:viewdiscussion'] = 'Zobrazit diskuse';
$string['forum:viewhiddentimedposts'] = 'Zobrazit časově omezené příspěvky';
$string['forum:viewqandawithoutposting'] = 'Vždy vidí otázky (Q) a odpovědi (A)';
$string['forum:viewrating'] = 'Zobrazit celkové hodnocení vlastních příspěvků';
$string['forum:viewsubscribers'] = 'Zobrazit odběratele';
$string['forumauthorhidden'] = 'Autor (nezveřejněno)';
$string['forumblockingalmosttoomanyposts'] = 'Blížíte se limitu pro počet vložených příspěvků. Za poslední {$a->blockperiod} jste do fóra vložili {$a->numposts} příspěvků, limit je {$a->blockafter}.';
$string['forumbodydeleted'] = 'Obsah tohoto příspěvku ve fóru byl odstraněn a již nemůže být zpřístupněn.';
$string['forumbodyhidden'] = 'Tento příspěvek si nemůžete momentálně prohlédnout. Zřejmě jste do diskuse ještě nevložili žádný příspěvek nebo ještě neuplynula lhůta pro úpravu příspěvku, diskuse nezačala nebo již vypršela její platnost.';
$string['forumintro'] = 'Popis';
$string['forumname'] = 'Název fóra';
$string['forumposts'] = 'Příspěvky ve fóru';
$string['forums'] = 'Fóra';
$string['forumsubjectdeleted'] = 'Tento příspěvek ve fóru byl odstraněn';
$string['forumsubjecthidden'] = 'Předmět  (nezveřejněno)';
$string['forumtracked'] = 'Sledovat nepřečtené příspěvky';
$string['forumtrackednot'] = 'Nesledovat nepřečtené příspěvky';
$string['forumtype'] = 'Typ fóra';
$string['forumtype_help'] = 'Můžete si vybrat z několika typů fór:

* Prostá diskuse - pouze jedno diskusní téma, na které mohou všichni odpovídat (nelze použít v režimu oddělených skupin)
* Každý může zahájit jedno téma diskuse - každý může začít právě jedno téma, na které pak mohou všichni odpovídat.
* Otázky a odpovědi - studenti musejí nejprve zaslat svou odpověď na vložený příspěvek předtím, než mohou vidět odpovědi ostatních.
Běžné fórum zobrazené jako blog - otevřené fórum, ve kterém může kdokoliv kdykoliv začít novou diskusi. Diskutovaná témata jsou zobrazena na jedné stránce, jako by se jednalo o společný blog.
* Běžné fórum pro obecné použití - otevřené fórum, ve kterém může kdokoliv kdykoliv začít novou diskusi a všichni mohou odpovídat.';
$string['generalforum'] = 'Běžné fórum pro obecné použití';
$string['generalforums'] = 'Obecná fóra';
$string['hiddenforumpost'] = 'Skrýt příspěvek';
$string['indicator:cognitivedepth'] = 'Kognitivní Fórum';
$string['indicator:cognitivedepth_help'] = 'Tento ukazatel je založen na studentem získané kognitivní hloubce v aktivitě Fórum.';
$string['indicator:socialbreadth'] = 'Sociální Fórum';
$string['indicator:socialbreadth_help'] = 'Tento ukazatel je založen na studentem získané sociální šířce v aktivitě Fórum.';
$string['inforum'] = 'v {$a}';
$string['introblog'] = 'Příspěvky v tomto fóru byly do něj zkopírované automaticky z blogů uživatelů z tohoto kurzu, protože položky blogů již nejsou k dispozici.';
$string['intronews'] = 'Novinky a oznámení';
$string['introsocial'] = 'Otevřené fórum pro debaty na libovolné téma';
$string['introteacher'] = 'Uzavřené fórum pro učitele kurzu';
$string['invalidaccess'] = 'Neplatný přístup ke stránce';
$string['invaliddigestsetting'] = 'Pro nastavení výtahu příspěvků byl poskytnut neplatný mail';
$string['invaliddiscussionid'] = 'Neplatný identifikátor diskuse - diskuse mohla být odstraněna';
$string['invalidforcesubscribe'] = 'Neplatný způsob nuceného odebírání fór';
$string['invalidforumid'] = 'ID fóra bylo nesprávné';
$string['invalidparentpostid'] = 'Nadřízený ID příspěvku byl nesprávný';
$string['invalidpostid'] = 'Neplatné ID příspěvku - {$a}';
$string['lastpost'] = 'Poslední příspěvek';
$string['learningforums'] = 'Učební fóra';
$string['lockdiscussionafter'] = 'Uzavřít diskuse po době nečinnosti';
$string['lockdiscussionafter_help'] = 'Diskuse mohou být automaticky zamčené po uplynutí nastavené doby od poslední odpovědi.

Uživatelé, kteří mají práva odpovídat na zamčené diskuse je mohou odemknout tím, že na ně odpoví.';
$string['longpost'] = 'Dlouhý příspěvek';
$string['mailnow'] = 'Odeslat oznámení ihned e-mailem bez času zpoždění pro úpravu příspěvku';
$string['managesubscriptionsoff'] = 'Dokončení správy odběrů';
$string['managesubscriptionson'] = 'Spravovat odběratele příspěvků';
$string['manydiscussions'] = 'Počet diskusí na stránce';
$string['markalldread'] = 'Označit všechny příspěvky v této diskusi jako přečtené';
$string['markallread'] = 'Označit všechny příspěvky v tomto fóru jako přečtené';
$string['markasreadonnotification'] = 'Oznámení při odesílání příspěvku';
$string['markasreadonnotification_help'] = 'Když budete upozorněni na příspěvky fóra, můžete si vybrat, zda to označí příspěvek jako čtení pro účely sledování fóra.';
$string['markasreadonnotificationno'] = 'Neoznačit příspěvek jako přečtené';
$string['markasreadonnotificationyes'] = 'Označit příspěvek jako přečtený';
$string['markread'] = 'Označit jako přečtené';
$string['markreadbutton'] = 'Označit jako<br />přečtené';
$string['markunread'] = 'Označit jako nepřečtené';
$string['markunreadbutton'] = 'Označit jako<br />nepřečtené';
$string['maxattachments'] = 'Maximální počet příloh';
$string['maxattachments_help'] = 'Toto nastavení určuje maximální počet příloh pro každý příspěvek.';
$string['maxattachmentsize'] = 'Maximální velikost přílohy';
$string['maxattachmentsize_help'] = '<p>Při zakládání fóra můžete určit, jaká bude maximální velikost přílohy,
kterou lze připojit k jednotlivým příspěvkům.</p>

<p>(Někdy se zdánlivě podaří přiložit soubor, který je větší, než je stanovené
maximum. Tento soubor však nebude uložen na server; uživatel o tom může být
informován chybovým hlášením.)</p>';
$string['maxtimehaspassed'] = 'Časový limit ({$a}) pro úpravu příspěvku bohužel vypršel!';
$string['message'] = 'Zpráva';
$string['messageinboundattachmentdisallowed'] = 'Odpověď nelze uložit jako příspěvek, protože obsahuje přílohu a fórum nepovoluje přílohy.';
$string['messageinboundfilecountexceeded'] = 'Odpověď nelze uložit jako příspěvek, protože obsahuje více příloh než je maximální počet příloh povolených pro fórum ({$a->forum-> maxattachments}).';
$string['messageinboundfilesizeexceeded'] = 'Odpověď nelze uložit jako příspěvek,  jelikož celková velikost přílohy ({$a->filesize}) je větší, než je maximální povolená velikost pro fórum ({$a->maxbytes}).';
$string['messageinboundforumhidden'] = 'Odpověď nelze uložit jako příspěvek, protože fórum je momentálně nedostupné.';
$string['messageinboundnopostforum'] = 'Odpověď nelze uložit jako příspěvek, protože nemáte oprávnění přispívat do fóra {$a->forum-&gt; name}.';
$string['messageinboundthresholdhit'] = 'Odpověď nelze uložit jako příspěvek. Překročili jste práh počtu příspěvků nastavený pro toto fórum';
$string['messageprovider:digests'] = 'Odběr souhrnných přehledů z fóra';
$string['messageprovider:posts'] = 'Odběr jednotlivých příspěvků z fóra';
$string['missingsearchterms'] = 'Následující termíny se vyskytují pouze ve značkách jazyka HTML:';
$string['modeflatnewestfirst'] = 'Zobrazit odpovědi za sebou (nejnovější nahoře)';
$string['modeflatoldestfirst'] = 'Zobrazit odpovědi za sebou (nejstarší nahoře)';
$string['modenested'] = 'Zobrazit hierarchii odpovědí (včetně textu)';
$string['modethreaded'] = 'Zobrazit hierarchii odpovědí (pouze osnovu)';
$string['modulename'] = 'Fórum';
$string['modulename_help'] = 'Modul Fórum umožňuje účastníkům vést asynchronní diskuse, tj. diskuse, které probíhají po delší dobu.

K dispozici je několik typů fór: běžné fórum, kde může každý začínat nové diskuse a zapojit se do stávajících; fórum, v němž může každý student začít nejvýše jednu diskusi; nebo fórum, v němž musí student nejprve sám za sebe odpověď položené otázky před tím, než vidí odpovědi ostatních. K příspěvkům lze přikládat soubory jako přílohy.

Účastníci kurzu se mohou přihlásit k odběru nových příspěvků ve fórech. Toto upozorňování na nové příspěvky je možno vnutit i zakázat podle potřeby. Vyžadují-li to okolnosti, může být nastaven limit pro počet příspěvků za daný čas (slouží jako obrana před nežádoucí aktivitou jednotlivců, kteří by jinak svými příspěvky zahltili dané fórum).

Příspěvky ve fóru je možno hodnotit, a to i ostatními studenty (vzájemné hodnocení). Hodnocení se přepočítává na výslednou známku, která může být součástí klasifikace v kurzu.

Fórum lze použít např.

* jako prostor pro představení se ostatním účastníkům v kurzu
* jako nástěnka pro zveřejňování novinek a oznámení (s možností vnuceného upozorňování na nové příspěvky)
* pro diskusi o obsahu kurzu nebo zdrojů
* jako prostor, v němž pokračuje výklad a diskuse po ukončení prezenční části kurzu
* jako prostor diskuse pouze pro učitele daného kurzu k diskusím a výměně materiálů (pomocí skrytého fóra)
* jako nástroj podpory uživatelům vašeho serveru
* pro oblast podpory pro soukromou komunikaci studentů a učitelů (pomocí fóra se samostatnými skupinami a s jedním studentem za skupinu)
* pro rozšiřující aktivity, například „hlavolamy“, aby studenti přemýšleli a navrhovali řešení
* jako otevřený prostor pro neformální diskuse o tématech mimo rámec kurzu';
$string['modulenameplural'] = 'Fóra';
$string['more'] = 'více';
$string['movedmarker'] = '(Přesunuto)';
$string['movethisdiscussionto'] = 'Přesunout tuto diskusi do ...';
$string['mustprovidediscussionorpost'] = 'Pro export musíte zadat buď id diskuse nebo id příspěvku
';
$string['myprofileotherdis'] = 'Diskuse ve fóru';
$string['myprofileowndis'] = 'Moje diskuse ve fóru';
$string['myprofileownpost'] = 'Moje příspěvky ve fóru';
$string['namenews'] = 'Oznámení';
$string['namenews_help'] = 'Fórum Oznámení je speciální fórum, určené pro vkládání obecných oznámení.
   Fórum se vytváří automaticky při vytvoření kurzu.
   Každý kurz může obsahovat pouze jedno fórum Oznámení.</p>
Pouze učitelé a správci mohou oznámení odesílat.
 Nejnovější diskuse založené ve fóru Oznámení se zobrazují v bloku "Poslední oznámení "';
$string['namesocial'] = 'Společné fórum';
$string['nameteacher'] = 'Učitelské fórum';
$string['newforumposts'] = 'Nové příspěvky';
$string['nextdiscussiona'] = 'Další diskuse: {$a}';
$string['noattachments'] = 'K tomuto příspěvku nejsou žádné přílohy';
$string['nodiscussions'] = 'V tomto fóru zatím nejsou žádná témata diskuse.';
$string['nodiscussionsstartedby'] = 'Uživatel {$a} nezahájil žádné diskuse';
$string['nodiscussionsstartedbyyou'] = 'Nezahájili jste žádné diskuse';
$string['noguestpost'] = 'Bohužel, hosté nemohou přispívat do diskuse.';
$string['noguestsubscribe'] = 'Je nám líto, hosté se nemohou přihlásit k odběru příspěvků.';
$string['noguesttracking'] = 'Bohužel, hosté si nemohou zapnout označování nepřečtených příspěvků.';
$string['nomorepostscontaining'] = 'Nebyly nalezeny žádné další příspěvky obsahující "{$a}".';
$string['nonews'] = 'Dosud nebyly vloženy žádná oznámení';
$string['noonecansubscribenow'] = 'Odběry jsou nyní zakázány';
$string['nopermissiontosubscribe'] = 'Nemáte oprávnění zobrazit odběratele fóra';
$string['nopermissiontoview'] = 'Nemáte oprávnění zobrazit tento příspěvek';
$string['nopostforum'] = 'Je nám líto, ale nemáte oprávnění přispívat do tohoto fóra';
$string['noposts'] = 'Bez příspěvků';
$string['nopostsmadebyuser'] = 'Uživatel {$a} nevložil žádný příspěvek';
$string['nopostsmadebyyou'] = 'Nevložili jste žádný příspěvek';
$string['noquestions'] = 'Do tohoto fóra zatím nebyla vložena žádná otázka.';
$string['nosubscribers'] = 'V tomto fóru zatím nikdo neodebírá nové příspěvky';
$string['notexists'] = 'Diskuse už neexistuje';
$string['nothingnew'] = 'Žádné nové zprávy';
$string['notingroup'] = 'Pro prohlížení tohoto fóra musíte být členem skupiny.';
$string['notinstalled'] = 'Modul fórum není nainstalován';
$string['notpartofdiscussion'] = 'Tento příspěvek není součástí diskuse!';
$string['notrackforum'] = 'Neoznačovat nepřečtené příspěvky';
$string['notsubscribed'] = 'Odebírat';
$string['noviewdiscussionspermission'] = 'Nemáte oprávnění vidět diskuse probíhající v tomto fóru';
$string['nowallsubscribed'] = 'Odebírání příspěvků ze všech fór v kurzu {$a} zapnuto.';
$string['nowallunsubscribed'] = 'Odebírání příspěvků ze všech fór v kurzu \'{$a}\' vypnuto.';
$string['nownotsubscribed'] = '{$a->name}: odebírání příspěvků z fóra "{$a->forum}" VYPNUTO.';
$string['nownottracking'] = '{$a->name}: označování nepřečtených příspěvků ve fóru \'{$a->forum}\' VYPNUTO.';
$string['nowsubscribed'] = '{$a->name}: odebírání příspěvků z fóra "{$a->forum}" ZAPNUTO.';
$string['nowtracking'] = '{$a->name}: označování nepřečtených příspěvků ve fóru \'{$a->forum}\' ZAPNUTO.';
$string['numposts'] = '{$a} příspěvků';
$string['olderdiscussions'] = 'Starší diskuse';
$string['oldertopics'] = 'Starší témata';
$string['oldpostdays'] = 'Přečteno po kolika dnech';
$string['overviewnumpostssince'] = '{$a} příspěvků od posledního přihlášení';
$string['overviewnumunread'] = '{$a} celkem nepřečteno';
$string['page-mod-forum-discuss'] = 'Stránka diskusního vlákna';
$string['page-mod-forum-view'] = 'Hlavní stránka fóra';
$string['page-mod-forum-x'] = 'Jakákoliv stránka fóra';
$string['parent'] = 'Ukázat předchůdce';
$string['parentofthispost'] = 'Předchůdce tohoto příspěvku';
$string['permalink'] = 'Trvalý odkaz';
$string['pluginadministration'] = 'Správa fóra';
$string['pluginname'] = 'Fórum';
$string['postadded'] = '<p>Váš příspěvek byl úspěšně přidán.</p><p>Na případné úpravy máte {$a}</p>';
$string['postaddedsuccess'] = 'Váš příspěvek byl úspěšně přidán.';
$string['postaddedtimeleft'] = 'Na případné úpravy máte {$a}';
$string['postbymailsuccess'] = 'Gratulujeme, váš diskusní příspěvek s předmětem "{$a->subject}" byl úspěšně přidán. Můžete si jej zobrazit na {$a->discussionurl}.';
$string['postbymailsuccess_html'] = 'Gratulujeme, vaše <a href="{$a->discussionurl}">diskusní příspěvek</a> na téma "{$a->subject}" byl úspěšně zapsán.';
$string['postbyuser'] = '{$a->post} od {$a->user}';
$string['postincontext'] = 'Ukázat příspěvek v kontextu';
$string['postmailinfolink'] = 'Toto je kopie zprávy zveřejněné na {$a->coursename} .

 Chcete-li odpovědět klikněte na tento odkaz: {$a->replylink}';
$string['postmailnow'] = '<p>Upozornění na tento příspěvek bude neprodleně odesláno všem odběratelům.</p>';
$string['postmailsubject'] = '{$a->courseshortname}: {$a->subject}';
$string['postrating1'] = 'Vykazuje zejména individuální poznávání';
$string['postrating2'] = 'Rovnoměrně individuální i kolektivní';
$string['postrating3'] = 'Vykazuje zejména kolektivní poznávání';
$string['posts'] = 'Příspěvky';
$string['postsmadebyuser'] = 'Příspěvky uživatele {$a}';
$string['postsmadebyuserincourse'] = 'Příspěvky uživatele {$a->fullname} v kurzu {$a->coursename}';
$string['posttoforum'] = 'Poslat do fóra';
$string['posttomygroups'] = 'Odeslat kopii do všech skupin';
$string['posttomygroups_help'] = 'Odeslat kopii této zprávy do všech skupin, které mají přístup. Účastníci ve skupinách, které nemají přístup, tento příspěvek neuvidí';
$string['postupdated'] = 'Váš příspěvek byl aktualizován';
$string['potentialsubscribers'] = 'Odběratelé k dispozici';
$string['prevdiscussiona'] = 'Předchozí diskuse: {$a}';
$string['privacy:digesttypenone'] = 'Neudržujeme žádné údaje týkající se preferovaného typu výběru pro toto fórum.';
$string['privacy:digesttypepreference'] = 'Vybrali jste si pro získání následujícího formátu: "{$a->type}".';
$string['privacy:discussionsubscriptionpreference'] = 'Vybrali jste si následující diskusní předvolbu pro toto fórum: "{$a->preference}"';
$string['privacy:metadata:core_rating'] = 'Fórum využívá hodnotícího subsystému k podpoře známkování příspěvků.';
$string['privacy:metadata:core_tag'] = 'Fórum využívá pro podporu označování příspěvků subsystém štítků.';
$string['privacy:metadata:forum_digests'] = 'Informace o preferencích výběru pro každé fórum.';
$string['privacy:metadata:forum_digests:forum'] = 'Fórum  přihlášeno k odběru.';
$string['privacy:metadata:forum_digests:maildigest'] = 'Výběr předvoleb.';
$string['privacy:metadata:forum_digests:userid'] = 'ID uživatele s výběrem předvoleb.';
$string['privacy:metadata:forum_discussion_subs'] = 'Informace o odběrech jednotlivých diskusních fór';
$string['privacy:metadata:forum_discussion_subs:discussionid'] = 'ID odebírané diskuse.';
$string['privacy:metadata:forum_discussion_subs:preference'] = 'Doba zahájení odběru.';
$string['privacy:metadata:forum_discussion_subs:userid'] = 'ID uživatele s odběrem diskuse.';
$string['privacy:metadata:forum_discussions'] = 'Informace o diskuzích jednotlivých fór, které uživatel vytvořil';
$string['privacy:metadata:forum_discussions:assessed'] = 'TODOD - co toto pole uchovává';
$string['privacy:metadata:forum_discussions:name'] = 'Název diskuze, zvolený autorem.';
$string['privacy:metadata:forum_discussions:timemodified'] = 'Čas poslední úpravy diskuse.';
$string['privacy:metadata:forum_discussions:userid'] = 'ID uživatele, který diskusi vytvořil';
$string['privacy:metadata:forum_discussions:usermodified'] = 'ID uživatele, který nějakým způsobem změnil diskusi.';
$string['privacy:metadata:forum_posts'] = 'Informace o preferencích výběru pro každé fórum.';
$string['privacy:metadata:forum_posts:created'] = 'Čas vytvoření příspěvku.';
$string['privacy:metadata:forum_posts:discussion'] = 'Diskuse, které byly odeslány.';
$string['privacy:metadata:forum_posts:message'] = 'Zpráva fóra.';
$string['privacy:metadata:forum_posts:modified'] = 'Čas poslední úpravy příspěvku.';
$string['privacy:metadata:forum_posts:parent'] = 'Předchozí příspěvek, na který bylo odpovězeno.';
$string['privacy:metadata:forum_posts:subject'] = 'Předmět příspěvku fóra.';
$string['privacy:metadata:forum_posts:totalscore'] = 'Zpráva příspěvku fóra.';
$string['privacy:metadata:forum_posts:userid'] = 'ID uživatele, který vytvořil příspěvek ve fóru.';
$string['privacy:metadata:forum_queue'] = 'Dočasný protokol o příspěvcích, které budou zasílány poštou';
$string['privacy:metadata:forum_queue:discussionid'] = 'ID diskuse ve fóru';
$string['privacy:metadata:forum_queue:postid'] = 'ID příspěvku ve fóru';
$string['privacy:metadata:forum_queue:timemodified'] = 'Upravený čas původního příspěvku';
$string['privacy:metadata:forum_queue:userid'] = 'Uživatel, který má být o příspěvku upozorněn';
$string['privacy:metadata:forum_read'] = 'Informace o příspěvcích, které uživatel přečetl.';
$string['privacy:metadata:forum_read:discussionid'] = 'Diskuse, ve které je příspěvek.';
$string['privacy:metadata:forum_read:firstread'] = 'Čas prvního přečtení příspěvku.';
$string['privacy:metadata:forum_read:lastread'] = 'Čas posledního přečtení příspěvku.';
$string['privacy:metadata:forum_read:postid'] = 'Přečtený příspěvek.';
$string['privacy:metadata:forum_read:userid'] = 'ID uživatele, ke kterému se tento záznam vztahuje.';
$string['privacy:metadata:forum_subscriptions'] = 'Informace o tom, kterým fórům se uživatel přihlásil k odběru.';
$string['privacy:metadata:forum_subscriptions:forum'] = 'Fórum, kterému byl odběr přihlášen.';
$string['privacy:metadata:forum_subscriptions:userid'] = 'ID uživatele, ke kterému se vztahuje tento odběr fóra.';
$string['privacy:metadata:forum_track_prefs'] = 'Informace o tom, které fóra uživatel zvolil pro sledování příspěvků.';
$string['privacy:metadata:forum_track_prefs:forumid'] = 'Fórum, které má zapnuté sledování čtení.';
$string['privacy:metadata:forum_track_prefs:userid'] = 'ID uživatele, ke kterému se tato předvolba pro sledování fóra vztahuje.';
$string['privacy:metadata:preference:autosubscribe'] = 'Zda se při odpovědi na příspěvky přihlásí k diskusím.';
$string['privacy:metadata:preference:maildigest'] = 'Předvolba výběru pošty na celém webu';
$string['privacy:metadata:preference:markasreadonnotification'] = 'Nezáleží na tom, zda budou příspěvky ve fóru při jejich přijímání jako zpráv označeny jako přečtené.';
$string['privacy:metadata:preference:trackforums'] = 'Zda povolit sledování čtení.';
$string['privacy:postwasread'] = 'Tento příspěvek byl na stránkách poprvé přečten {$a->firstread} a naposledy  {$a->lastread}';
$string['privacy:readtrackingdisabled'] = 'Rozhodli jste se, že nebudete sledovat příspěvky, které jste si v tomto fóru přečetli.';
$string['privacy:request:delete:discussion:name'] = 'Odstranit na žádost autora';
$string['privacy:request:delete:post:message'] = 'Obsah tohoto příspěvku byl na žádost autora odstraněn.';
$string['privacy:request:delete:post:subject'] = 'Odstranit na žádost autora';
$string['privacy:subscribedtoforum'] = 'Jste přihlášeni k odběru tohoto fóra.';
$string['processingdigest'] = 'Zpracovávám souhrnný e-mail pro uživatele {$a}';
$string['processingpost'] = 'Zpracovávám příspěvek {$a}';
$string['prune'] = 'Oddělit';
$string['prunedpost'] = 'Z příspěvku byla vytvořena nová diskuse';
$string['pruneheading'] = 'Oddělit a přesunout tento příspěvek do nové diskuse.';
$string['qandaforum'] = 'Otázky a odpovědi';
$string['qandanotify'] = 'Toto je fórum typu "Otázky a odpovědi". Chcete-li si prohlédnout odpovědi na vložené otázky, musíte nejdříve vložit svou odpověď.';
$string['re'] = 'Re:';
$string['readtherest'] = 'Číst zbytek tohoto tématu';
$string['removeallforumtags'] = 'Odstranit všechny štítky fóra';
$string['replies'] = 'Odpovědi';
$string['repliesmany'] = '{$a} odpovědí';
$string['repliesone'] = '{$a} odpověď';
$string['reply'] = 'Odpovědět';
$string['reply_handler'] = 'Odpovědět na příspěvky fóra e-mailem';
$string['reply_handler_name'] = 'Odpovědět na příspěvky fóra';
$string['replyforum'] = 'Odpovědět do fóra';
$string['replytopostbyemail'] = 'Můžete na to odpovědět  e-mailem.';
$string['replytouser'] = 'Při odpovědi na příspěvek použij emailovou adresu autora';
$string['resetdigests'] = 'Odstranit uživatelské nastavení odebírání příspěvků z fóra';
$string['resetforums'] = 'Odstranit všechny příspěvky z';
$string['resetforumsall'] = 'Odstranit všechny příspěvky';
$string['resetsubscriptions'] = 'Odstranit všechna přihlášení k odběru příspěvků';
$string['resettrackprefs'] = 'Vypnout všechna označování nepřečtených příspěvků';
$string['rssarticles'] = 'Počet posledních RSS článků';
$string['rssarticles_help'] = '<p>Tato volba umožňuje nastavit počet článků, které mají být zahrnuty v RSS
kanálu.</p>

<p>Pro většinu fór je vhodný počet mezi 5 a 20 články. Pokud je fórum velmi
frekventované, můžete počet zvýšit.</p>';
$string['rsssubscriberssdiscussions'] = 'RSS zdroj diskusí';
$string['rsssubscriberssposts'] = 'RSS zdroj příspěvků';
$string['rsstype'] = 'RSS kanál pro tuto aktivitu';
$string['rsstype_help'] = '<p>Tato volba umožňuje aktivovat RSS kanál pro aktuální fórum.</p>

<p>Můžete zvolit jeden ze dvou typů RSS kanálu:</p>

<ul>
  <li><b>Diskuse</b> Pokud vyberete toto nastavení, kanál bude obsahovat nové
  diskuse ve fóru včetně prvního příspěvku.</li>

  <li><b>Příspěvky</b> Toto nastavení znamená, že kanál bude obsahovat všechny
  nové příspěvky ve fóru.</li>
</ul>';
$string['rsstypedefault'] = 'Typ RSS kanál';
$string['search'] = 'Hledat';
$string['search:activity'] = 'Fórum - informace';
$string['search:post'] = 'Příspěvky ve fóru';
$string['searchdatefrom'] = 'Příspěvky musí být novější než';
$string['searchdateto'] = 'Příspěvky musí být starší než';
$string['searchforumintro'] = 'Prosím, vložte hledané termíny do jednoho nebo více následujících polí:';
$string['searchforums'] = 'Prohledat fóra';
$string['searchfullwords'] = 'Tato slova by se měla vyskytovat jako celá slova';
$string['searchnotwords'] = 'Tato slova by v příspěvku NEMĚLA být';
$string['searcholderposts'] = 'Prohledat starší příspěvky...';
$string['searchphrase'] = 'V příspěvku se musí vyskytovat přesně tato fráze';
$string['searchresults'] = 'Výsledky hledání';
$string['searchsubject'] = 'Tato slova by měla být v předmětu příspěvku';
$string['searchtags'] = 'Je štítkováno';
$string['searchuser'] = 'Toto jméno by se mělo shodovat s autorem';
$string['searchuserid'] = 'Autorovo Moodle ID';
$string['searchwhichforums'] = 'Která fóra se mají prohledat';
$string['searchwords'] = 'Tato slova se mohou vyskytovat kdekoliv v příspěvku';
$string['seeallposts'] = 'Zobrazit všechny příspěvky tohoto uživatele';
$string['shortpost'] = 'Krátký příspěvek';
$string['showsubscribers'] = 'Ukázat/vybrat odběratele';
$string['singleforum'] = 'Prostá diskuse';
$string['smallmessage'] = 'Nový příspěvek od {$a->user} ve fóru {$a->forumname}';
$string['smallmessagedigest'] = 'Přehled fóra obsahuje {$a} zpráv';
$string['startedby'] = 'Zahájil/-a';
$string['subject'] = 'Předmět';
$string['subscribe'] = 'Odebírat nové příspěvky';
$string['subscribeall'] = 'Zapnout odebírání příspěvků všem';
$string['subscribed'] = 'Příspěvky odebírány';
$string['subscribediscussion'] = 'Přihlásit se k této diskusi';
$string['subscribeenrolledonly'] = 'Pouze zapsaní účastníci kurzu mohou být upozorňováni na nové příspěvky.';
$string['subscribenone'] = 'Vypnout odebírání příspěvků všem';
$string['subscribers'] = 'Odběratelé';
$string['subscriberstowithcount'] = 'Odběratelé fóra "{{$a->name}}" ({$a->count})';
$string['subscribestart'] = 'Povolit zasílání upozornění na nové příspěvky v tomto fóru';
$string['subscribestop'] = 'Vypnout zasílání upozornění na nové příspěvky v tomto fóru';
$string['subscription'] = 'Odebírání';
$string['subscription_help'] = 'Jste-li přihlášeni k odběru příspěvků z určitého fóra, budou vám zasílána upozornění na nové příspěvky. Odebírání je většinou volitelné, v některých případech však může být vnuceno tak, že upozornění jsou automaticky zasílána všem.';
$string['subscriptionandtracking'] = 'Odebírání a sledování';
$string['subscriptionauto'] = 'Automatické odebírání';
$string['subscriptiondisabled'] = 'Odebírání není možné';
$string['subscriptionforced'] = 'Vnucené odebírání';
$string['subscriptionmode'] = 'Způsob odebírání';
$string['subscriptionmode_help'] = 'Pokud je účastník kurzu přihlášen k odebírání příspěvků z určitého fóra, bude mu zasláno upozornění na nové příspěvky.

K dispozici jsou čtyři režimy odebírání:

* Volitelné - účastníci sami si mohou nastavit odebírání příspěvků
* Vnucené - upozornění je odesíláno všem a účastníci nemohou toto odesílání v Moodle zrušit
* Automatické - účastníci jsou automaticky přihlášeni k odebírání příspěvků, ale mohou toto odebírání kdykoliv zrušit
* Zakázáno - odebírání příspěvků není vůbec povoleno';
$string['subscriptionoptional'] = 'Volitelné odebírání';
$string['subscriptions'] = 'Odebírání';
$string['tagarea_forum_posts'] = 'Příspěvky ve fóru';
$string['tagsdeleted'] = 'Štítky fóra byly odstraněny';
$string['thisforumisthrottled'] = 'Do tohoto fóra můžete v určeném časovém období vložit jen omezený počet příspěvků. Současné nastavení je {$a->blockafter} příspěvků za {$a->blockperiod}.';
$string['timedhidden'] = 'Časový status: Studentům skryté';
$string['timedposts'] = 'Termínované příspěvky';
$string['timedvisible'] = 'Časový status: Viditelné všem uživatelům';
$string['timestartenderror'] = 'Datum pro konec zobrazování příspěvku nemůže předcházet datu pro začátek zobrazování.';
$string['trackforum'] = 'Označovat nepřečtené příspěvky';
$string['tracking'] = 'Označování';
$string['trackingoff'] = 'Vypnuto';
$string['trackingon'] = 'Vnuceno';
$string['trackingoptional'] = 'Volitelné';
$string['trackingtype'] = 'Označování nepřečtených příspěvků';
$string['trackingtype_help'] = 'Sledování čtení umožňuje účastníkům snadno zkontrolovat, která příspěvky ještě neviděl a zvýraznění nové příspěvky.

Pokud je nastaveno na volitelné, účastníci mohou zvolit, zda chtějí  sledování zapnout nebo vypnout prostřednictvím odkazu v administračním bloku. (Uživatelé musí také umožnit sledování fóra ve svých předvolbách pro fóra.)

Pokud je nastaveno "Povolit vynucení sledování příspěvků" ve správě Moodle, pak další možností k dispozici je - vynucení. To znamená, že sledování je vynuceno bez ohledu na předvolby fóra uživatelů.';
$string['trackreadposts_header'] = 'Sledování fóra';
$string['unread'] = 'Nepřečteno';
$string['unreadposts'] = 'Nepřečtené příspěvky';
$string['unreadpostsnumber'] = 'Nepřečtené příspěvky: {$a}';
$string['unreadpostsone'] = 'Nepřečtené příspěvky: 1';
$string['unsubscribe'] = 'Neodebírat příspěvky z tohoto fóra';
$string['unsubscribeall'] = 'Neodebírat příspěvky z žádných fór';
$string['unsubscribeallconfirm'] = 'Momentálně odebíráte příspěvky z {$a->forums} diskusních fór a {$a->discussions} diskusí. Opravdu si přejete zrušit všechna tato odebírání a zakázat automatické nastavení odebírání?';
$string['unsubscribeallconfirmdiscussions'] = 'Momentálně odebíráte příspěvky z {$a->discussions} diskusí. Opravdu si přejete zrušit všechna tato odebírání a zakázat automatické nastavení odebírání?';
$string['unsubscribeallconfirmforums'] = 'Momentálně odebíráte příspěvky z {$a->forums} diskusních fór. Opravdu si přejete zrušit všechna tato odebírání a zakázat automatické nastavení odebírání?';
$string['unsubscribealldone'] = 'Všechna volitelná odebírání z diskusních fór byla odstraněna. Stále ještě můžete dostávat emaily s příspěvky z diskusních fór, u nichž je odebírání vynuceno. Pro nastavení upozornění zasílaných z těchto stránek navštivte sekci Zprávu v nastavení vašeho uživatelského profilu.';
$string['unsubscribeallempty'] = 'Neodebíráte příspěvky z žádného diskusního fóra na těchto stránkách. Pro zrušení všech upozornění zasílaných z těchto stránek navštivte sekci Zprávu v nastavení vašeho uživatelského profilu.';
$string['unsubscribed'] = 'Neodebíráno';
$string['unsubscribediscussion'] = 'Vypnout odebírání příspěvků z této diskuse';
$string['unsubscribediscussionlink'] = 'Odhlásit se z diskuse: {$a}';
$string['unsubscribelink'] = 'Odhlásit se z fóra: {$a}';
$string['unsubscribeshort'] = 'Neodebírat';
$string['usermarksread'] = 'Ruční označování příspěvku jako přečteného';
$string['viewalldiscussions'] = 'Zobrazit všechny diskuse';
$string['viewthediscussion'] = 'Zobrazit diskusi';
$string['warnafter'] = 'Upozornit po překročení počtu příspěvků';
$string['warnafter_help'] = 'Účastníci kurzu mohou být upozorněni, pokud se blíží nejvyššímu povolenému počtu příspěvků do fóra za dané období. Toto nastavení určuje, při kolika příspěvcích je jim zasláno upozornění. Uživatelům s pravomocí ignorovat tento limit není upozorňování zasíláno.';
$string['warnformorepost'] = 'Varování! V tomto fóru je více diskusí - použijte novější';
$string['yournewquestion'] = 'Nová otázka';
$string['yournewtopic'] = 'Nové téma diskuse';
$string['yourreply'] = 'Vaše odpověď';
