<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'certificate', language 'cs', version '3.5'.
 *
 * @package     certificate
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addlinklabel'] = 'Přidat možnost další propojené aktivity';
$string['addlinktitle'] = 'Klepněte na tlačítko přidat další propojené aktivity';
$string['areaintro'] = 'Úvod osvědčení';
$string['awarded'] = 'Udělěno';
$string['awardedto'] = 'Uděleno';
$string['back'] = 'Zpět';
$string['border'] = 'Ohraničení';
$string['borderblack'] = 'Černá';
$string['borderblue'] = 'Modrá';
$string['borderbrown'] = 'Hnědá';
$string['bordercolor'] = 'Čáry ohraničení';
$string['bordercolor_help'] = 'Vzhledem k tomu, že obrázky mohou podstatně zvýšit velikost souboru pdf, můžete zvolit vykreslení obrajů řádek namísto použití okrajového obrázku (ujistěte se, že je možnost Obrázek ohraničení nastavena na Ne). Možnost Okrajové čáry vytiskne pěkné ohraničení tří řádků různých šířek ve zvolené barvě.';
$string['bordergreen'] = 'Zelená';
$string['borderlines'] = 'Čáry';
$string['borderstyle'] = 'Obrázek ohraničení';
$string['borderstyle_help'] = 'Volba Obrázek ohraničení umožňuje vybrat okrajový obrázek ze složky certificate/pix/borders. Vyberte požadovaný okraj hranice okrajů osvědčení nebo vyberte žádný okraj.';
$string['certificate'] = 'Ověřovací kód:';
$string['certificate:addinstance'] = 'Přidat instanci osvědčení';
$string['certificate:manage'] = 'Správa instance osvědčení';
$string['certificate:printteacher'] = 'Zadejte učitel který bude uveden na osvědčení , pokud je zapnuto nastavení uvádění učitele';
$string['certificate:student'] = 'Získat osvědčení';
$string['certificate:view'] = 'Zobrazit osvědčení';
$string['certificatename'] = 'Název osvědčení';
$string['certificatereport'] = 'Sestava osvědčení';
$string['certificatesfor'] = 'Osvědčení pro';
$string['certificatetype'] = 'Typ osvědčení';
$string['certificatetype_help'] = 'Zde určujete rozložení osvědčení . Složka typu osvědčení obsahuje čtyři výchozí :
Embedded A4 tiskne na papír formátu A4 s vloženým písmem.
A4 Non-Embedded tiskne na papír formátu A4 bez vložených písem.
Vložený dopis tiskne na papír formátu dopisu s vloženým písmem.
Letter Non-Embedded tiskne na papír formátu dopisu bez vložených písem.

Nepřidělené typy používají fonty Helvetica a Times. Pokud se domníváte, že uživatelé nebudou mít tato písma v počítači, nebo pokud váš jazyk používá znaky nebo symboly, které nejsou uloženy fonty Helvetica a Times, vyberte typ Embedded . Vložené typy používají fonty Dejavusans a Dejavuserif. Díky tomu budou soubory PDF poměrně velké; proto se nedoporučuje používat Embedded typ, pokud nemusíte.

Do složky osvědčení / typu lze přidat nové typy složek. Název složky a všechny nové řetězce jazyka pro nový typ musí být přidány do souboru jazyků osvědčení.';
$string['certify'] = 'Osvědčení o';
$string['code'] = 'Kód';
$string['completiondate'] = 'Absolvování kurzu';
$string['course'] = 'pro';
$string['coursegrade'] = 'Hodnocení v kurzu';
$string['coursename'] = 'Kurz';
$string['coursetimereq'] = 'Požadované minuty v kurzu';
$string['coursetimereq_help'] = 'Zadejte zde minimální čas, v minutách, po které musí být student přihlášen do kurzu, než bude moci získat osvědčení.';
$string['credithours'] = 'Časová dotace';
$string['customtext'] = 'Nastavitelný text';
$string['customtext_help'] = 'Chcete-li na osvědčení vytisknout různé názvy pro učitele než ty, které jsou přiřazeni
roli učitele, nevybírejte Tisk jména  nebo jakýkoli podpisový obrázek s výjimkou obrazu řádku. Do tohoto textového pole zadejte názvy učitelů, jak chcete, aby se zobrazily. Ve výchozím nastavení je tento text umístěn v levém dolním rohu osvědčení. K dispozici jsou následující značky html:  <br>, <p>, <b>, <i>, <u>, <img> (src a šířka (nebo výška) jsou povinné), <font> (href je povinné), <a> (možná atributy jsou: barva, hexadecimální kód), tvář (arial, times, courier, helvetica, symbol)).';
$string['date'] = 'dne';
$string['datefmt'] = 'Formát data';
$string['datefmt_help'] = 'Zvolte formát data, chcete-li vytisknout datum v osvědčení. Nebo zvolte poslední možnost pro vytištění data ve formátu zvoleného jazyka uživatele.';
$string['datehelp'] = 'Datum';
$string['deletissuedcertificates'] = 'Odstranit vydaná osvědčení';
$string['delivery'] = 'Způsob výstupu';
$string['delivery_help'] = 'Zvolte zde, jak chcete, aby vaši studenti získali osvědčení.
Otevřít v prohlížeči: Otevře osvědčení v novém okně prohlížeče.
Vynutit stahování: Otevře okno stahování souboru prohlížeče.
E-mailové osvědčení: Volbou této možnosti odesíláte osvědčení studentovi jako přílohu e-mailu.
Poté, co uživatel obdrží osvědčení, kliknutím na odkaz osvědčení na domovské stránce kurzu uvidí datum obdržení osvědčení a bude jej moci zobrazit.';
$string['designoptions'] = 'Nastavení vzhledu';
$string['download'] = 'Vnutit stažení';
$string['emailcertificate'] = 'Zaslat e-mailem (Současně zvolte uložit!)';
$string['emailothers'] = 'Zaslat také dalším';
$string['emailothers_help'] = 'Zadejte zde e-mailové adresy, oddělené čárkou, těch, kteří by měli být upozorněni e-mailem vždy, když student obdrží osvědčení.';
$string['emailstudenttext'] = 'V příloze je vaše osvědčení za kurz {$a->course}.';
$string['emailteachermail'] = '{$a->student} obdržel osvědčení: \'{$a->certificate}\'
za {$a->course}.

Prohlédnout si je můžete zde:

    {$a->url}';
$string['emailteachermailhtml'] = '{$a->student} obdržel osvědčení: \'<i>{$a->certificate}</i>\'
za {$a->course}.

Prohlédnout si je můžete zde:

    <a href="{$a->url}">Sestava osvědčení</a>.';
$string['emailteachers'] = 'Informovat vyučující';
$string['emailteachers_help'] = 'Pokud je povoleno, učitelé jsou upozorněni e-mailem vždy, když student obdrží osvědčení.';
$string['entercode'] = 'Zadejte kód osvědčení k ověření:';
$string['fontsans'] = 'Rodina znaků Sans-serif';
$string['fontsans_desc'] = 'Rodina znaků Sans-serif s embedded fonty';
$string['fontserif'] = 'Rodina znaků Serif';
$string['fontserif_desc'] = 'Rodina znaků Serif s embedded fonty';
$string['getcertificate'] = 'Získejte osvědčení';
$string['grade'] = 'Hodnocení';
$string['gradedate'] = 'Datum hodnocení';
$string['gradefmt'] = 'Formát hodnocení';
$string['gradefmt_help'] = 'Existují tři dostupné formáty, pokud se rozhodnete vytisknout známku na osvědčení:

Známka v procentech: Vytiskne známku jako procento.
Známka v bodech: Vytiskne bodovou hodnotu hodnocení.
Slovní známka: Vytiskne procentní stupeň jako písmeno.';
$string['gradeletter'] = 'Slovní známka';
$string['gradepercent'] = 'Známka v procentech';
$string['gradepoints'] = 'Známka v bodech';
$string['imagetype'] = 'Typ obrázku';
$string['incompletemessage'] = 'Aby bylo možné stáhnout osvědčení, musíte nejprve splnit všechny požadované činnosti. Vraťte se prosím na kurzu a dokončete své studium.';
$string['intro'] = 'Úvod';
$string['issued'] = 'Vystaveno';
$string['issueddate'] = 'Datum vystavení';
$string['issueoptions'] = 'Volby vystavení';
$string['landscape'] = 'Na šířku';
$string['lastviewed'] = 'Toto osvědčení jste získali naposledy:';
$string['letter'] = 'Dopis';
$string['lockingoptions'] = 'Zamčené volby';
$string['modulename'] = 'Osvědčení';
$string['modulename_help'] = 'Tento modul umožňuje dynamické generování osvědčení na základě předem definovaných podmínek nastavených učitelem.';
$string['modulenameplural'] = 'Osvědčení';
$string['mycertificates'] = 'Moje osvědčení';
$string['nocertificates'] = 'Toto není osvědčení';
$string['nocertificatesissued'] = 'Nejsou žádné vydané osvědčení';
$string['nocertificatesreceived'] = 'neobdržel žádné osvědčení.';
$string['nofileselected'] = 'Musíte vybrat soubor, který chcete nahrát!';
$string['nogrades'] = 'Hodnocení není k dispozici';
$string['notapplicable'] = 'N/A';
$string['notfound'] = 'Číslo osvědčení nelze ověřit.';
$string['notissued'] = 'Nevystaveno';
$string['notissuedyet'] = 'Dosud nevystaveno';
$string['notreceived'] = 'Nedostal jste osvědčení';
$string['openbrowser'] = 'Otevřít v novém okně';
$string['opendownload'] = 'Pro uložení osvědčení klikněte na tlačítko';
$string['openemail'] = 'Klikněte na tlačítko a osvědčení Vám bude zasláno jako příloha e-mailu.';
$string['openwindow'] = 'Klikněte na tlačítko a osvědčení se otevře v novém okně prohlížeče.';
$string['or'] = 'Nebo';
$string['orientation'] = 'Orientace';
$string['orientation_help'] = 'Zvolte, zda chcete orientaci osvědčení na výšku nebo na šířku.';
$string['pluginadministration'] = 'Správa osvědčení';
$string['pluginname'] = 'Osvědčení';
$string['portrait'] = 'Na výšku';
$string['printdate'] = 'Datum tisku';
$string['printdate_help'] = 'Toto je datum, které bude vytištěno, pokud je vybráno datum tisku. Je-li zvolen termín dokončení kurzu, ale student nedokončil kurz, vytiskne se datum získání. Můžete také vybrat datum vytištění podle toho, kdy byla aktivita hodnocena. Pokud je osvědčení vydáno předtím, než je tato aktivita klasifikována, bude vytištěno den získání.';
$string['printerfriendly'] = 'Tisknutelná stránka';
$string['printgrade'] = 'Tisk známky';
$string['printgrade_help'] = 'Můžete si vybrat libovolné dostupné položky z kurzu, abyste mohli vytisknout uživatelské hodnocení získané pro danou položku v osvědčení. Položky známek jsou uvedeny v pořadí, ve kterém se objevují v Klasifikaci. Vyberte formát hodnocení níže.';
$string['printhours'] = 'Tisk položky počet hodin';
$string['printhours_help'] = 'Zde zadejte počet kreditních hodin, která mají být vytištěna na osvědčení.';
$string['printnumber'] = 'Tisk kódu osvědčení';
$string['printnumber_help'] = 'Do osvědčení lze vytisknout jedinečný 10 místný kód náhodných písmen a čísel. Toto číslo pak můžete ověřit porovnáním s číslem kódu zobrazeným v přehledu certifikátů.';
$string['printoutcome'] = 'Tisk očekávaných výstupů';
$string['printoutcome_help'] = 'Můžete zvolit jakýkoli očekávávanou úroveň a vytisknout název. Příkladem může být: Přiřazená úroveň: Splněno.';
$string['printseal'] = 'Pečeť nebo obrázek (logo)';
$string['printseal_help'] = 'Tato volba umožňuje vytisknout osvědčení z adresáře certificate/pix/seals , pomocí štítku nebo loga. Ve výchozím nastavení je tento obrázek umístěn v pravém dolním rohu osvědčení.';
$string['printsignature'] = 'Obrázek Podpisu';
$string['printsignature_help'] = 'Tato volba umožňuje tisknout obrázek podpisu ze složky certificate/pix/signatures. Můžete vytisknout grafické znázornění podpisu nebo vytisknout řádek pro ruční podpis. Ve výchozím nastavení je tento obrázek umístěn v levém dolním rohu osvědčení.';
$string['printteacher'] = 'Tisk jména učitele/ů';
$string['printteacher_help'] = 'Chcete-li vytisknout jméno učitele na osvědčení, nastavte roli učitele na úrovni modulu. Udělejte to například v případě, že máte k dispozici více než jednoho učitele, nebo máte v kurzu více než jedno osvědčení a chcete vytisknout jiná jména učitelů na každém. Klepnutím upravte osvědčení a poté klikněte na kartu Místní přiřazené role. Pak přiřaďte roli Učitele (editace učitele) k osvědčení (nemusí být učitelem v kurzu - můžete tuto roli přiřadit komukoli). Tato jména budou vytištěna na osvědčení pro učitele.';
$string['printwmark'] = 'Vodoznak';
$string['printwmark_help'] = 'Soubor vodoznaku lze umístit na pozadí osvědčení. Vodoznak je vybledlá grafika. Vodoznakem by mohlo být logo, pečeť, erb, znění nebo co chcete použít jako grafické pozadí.';
$string['receivedcerts'] = 'Získaná osvědčení';
$string['receiveddate'] = 'Datum získání';
$string['reissuecert'] = 'Nově vydaná osvědčení';
$string['removecert'] = 'Vydaná osvědčení byla odstraněna';
$string['report'] = 'Sestava';
$string['reportcert'] = 'Sestava osvědčení';
$string['reportcert_help'] = 'Pokud zde zvolíte Ano, bude datum získání osvědčení, číslo kódu a název kurzu zobrazeno v přehledech uživatelských osvědčení. Pokud se rozhodnete vytisknout známku v tomto osvědčení, bude tato známka zobrazena také v přehledu osvědčení.';
$string['requiredtimenotmet'] = 'Předtím, než budete mít přístup k tomuto osvědčení, musíte v kurzu strávit minimálně {$a->requiredtime}  minut';
$string['requiredtimenotvalid'] = 'Požadovaný čas musí být platné číslo větší než 0';
$string['reviewcertificate'] = 'Zkontrolovat osvědčení';
$string['savecert'] = 'Uložit osvědčení';
$string['savecert_help'] = 'Pokud zvolíte tuto možnost, kopie každého souboru PDF osvědčení uživatele se uloží do složky moddata kurzů pro toto osvědčení. V přehledu osvědčení se zobrazí odkaz pro každého uživatele.';
$string['seal'] = 'Pečeť';
$string['sigline'] = 'čára';
$string['signature'] = 'Podpis';
$string['statement'] = 'dokončil kurz';
$string['summaryofattempts'] = 'Přehled o doposud získaných osvědčeních';
$string['textoptions'] = 'Text';
$string['title'] = 'Osvědčení o';
$string['to'] = 'Uděluje';
$string['typeA4_embedded'] = 'A4 s vloženými fonty';
$string['typeA4_non_embedded'] = 'A4 bez vložených fontů';
$string['typeletter_embedded'] = 'Dopis s vloženými fonty';
$string['typeletter_non_embedded'] = 'Dopis bez vložených fontů';
$string['unsupportedfiletype'] = 'Soubor musí být soubor jpeg nebo png';
$string['uploadimage'] = 'Nahrát obrázek';
$string['uploadimagedesc'] = 'Toto tlačítko vás přenese na novou obrazovku, kde budete moci nahrávat obrázky.';
$string['userdateformat'] = 'Formát data';
$string['validate'] = 'Ověřit';
$string['verifycertificate'] = 'Ověřit osvědčení';
$string['viewcertificateviews'] = 'Zobrazit {$a} vydaná osvědčení';
$string['viewed'] = 'Obdržel jste osvědčení o:';
$string['viewtranscript'] = 'Zobrazit osvědčení';
$string['watermark'] = 'Vodoznak';
