<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'hub', language 'no', version '3.5'.
 *
 * @package     hub
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addscreenshots'] = 'Legg til skjermbilder';
$string['advertise'] = 'Del dette kurset slik at folk kan bli med';
$string['advertised'] = 'For påmelding';
$string['advertiseon'] = 'Del dette kurset på {$a}';
$string['advertiseonhub'] = 'Del dette kurset slik at brukere kan ta melde seg på';
$string['advertiseonmoodleorg'] = 'Annonser dette kurset på moodle.org';
$string['advertisepublication_help'] = 'Dette kurset vil bli vist på Moodle.net som et kurs brukere kan melde seg på og delta i. E-postbasert selvregistrering bør være aktivert på portalen og du må sette å egenpåmelding i selve kurset.';
$string['all'] = 'Alle';
$string['allowglobalsearch'] = 'Publiser dette navet og tillat globalt søk på alle kurs';
$string['allowpublicsearch'] = 'Publiser dette navet slik at folk kan melde seg på det';
$string['audience'] = 'Publikum';
$string['audience_help'] = 'Velg målgruppe for kurset';
$string['audienceadmins'] = 'Moodleadministratorer';
$string['audienceeducators'] = 'Lærere';
$string['audiencestudents'] = 'Studenter';
$string['badgesnumber'] = 'Antall utmerkelser ({$a})';
$string['badurlformat'] = 'Feil URL-format';
$string['cannotsearchcommunity'] = 'Beklager, du har ikke riktig tillatelse fo rå se denne siden';
$string['community'] = 'Samfunn';
$string['communityremoved'] = 'Kurset er blitt fjernet fra lista di';
$string['completeregistration'] = 'Fullfør registreringen hos Moodle.net';
$string['confirmregistration'] = 'Bekreft registrering';
$string['contactable'] = 'Almenn kontakt';
$string['contactable_help'] = 'Satt til ja, vil navet vise epostadressen din';
$string['contactemail'] = 'Kontakt epost';
$string['contactname'] = 'Kontaktnavn';
$string['contactphone'] = 'Telefon';
$string['contactphone_help'] = 'Telefonnummer er vist bare til nav-administratoren og blir ikke vist offentlig.';
$string['continue'] = 'Fortsett';
$string['contributornames'] = 'Andre bidragsytere';
$string['contributornames_help'] = 'Du kan bruke dette feltet for å liste opp navn på andre som har bidratt til kurset.';
$string['coursemap'] = 'S';
$string['coursename'] = 'Navn';
$string['courseprivate'] = 'Privat';
$string['coursepublic'] = 'Offentlig';
$string['coursepublished'] = 'Dette kurset er deles nå på \'{$a}\'.';
$string['courseshortname'] = 'Kortnavn';
$string['courseshortname_help'] = 'Skriv inn kortnavn for kurset ditt. Det må ikke være unikt.';
$string['coursesnumber'] = 'Antall kurs ({$a})';
$string['courseunpublished'] = 'Kurset {$a->courseshortname} er ikke lenger delt på {$a->hubname}.';
$string['courseurl'] = 'Kurs URL';
$string['courseurl_help'] = 'Dette er URL til kurset ditt. Denne URL er vist som en lenke i et søkeresultat.';
$string['creatorname'] = 'Opphavsmann';
$string['creatorname_help'] = 'Opphavsmannen er kursoppretter';
$string['creatornotes'] = 'Opphavsmannens notater';
$string['creatornotes_help'] = 'Notater fra opphavsmannen er en guide til lærere for hvordan de kan bruke kurset.';
$string['deletescreenshots'] = 'Slett disse skjermbildene';
$string['deletescreenshots_help'] = 'Slette alle nåværende opplastede skjermbilder';
$string['demourl'] = 'Demo URL';
$string['demourl_help'] = 'Skriv in demo URL til kurset ditt. Som standard er denne URL satt til kurset ditt. Demo-URL er vist som en lenke i søkeresultat.';
$string['description'] = 'Beskrivelse';
$string['description_help'] = 'Denne beskrivelsen vises i kurslistinga på Moodle.net.';
$string['detectednotexistingpublication'] = '{$a->hubname}  er en liste over kurs som ikke eksisterer lenger. Varsle {$a->hubname} -administratoren om at publiseringsnummeret {$a->id} bør fjernes.';
$string['downloadable'] = 'Nedlastbar';
$string['educationallevel'] = 'Utdanningsnivå';
$string['educationallevel_help'] = 'Velg det utdanningsnivået som passer dette kurset best.';
$string['edulevelassociation'] = 'Lag/forening';
$string['edulevelcorporate'] = 'Komersiell';
$string['edulevelgovernment'] = 'Offentlig';
$string['edulevelother'] = 'Annet';
$string['edulevelprimary'] = 'Primær';
$string['edulevelsecondary'] = 'Sekundær';
$string['eduleveltertiary'] = 'Tertiær';
$string['emailalert'] = 'Epostvarsling';
$string['emailalert_help'] = 'Dersom dette er aktivert vil nav-administratoren sende deg epost om sikkerhetssmeldinger og andre viktige nyheter.';
$string['enrollable'] = 'Tar i mot påmelding';
$string['errorbadimageheightwidth'] = 'Bildet skal maksimum være {$a->width} X {$a->height}';
$string['errorcourseinfo'] = 'Det oppstod en feil ved henting av kursets metadata fra  ({$a}). Vennligst prøv igjen senere for å hente kursets metadata. Ellers kan du fortsette registreringsprosessen med følgende standard metainformasjon.';
$string['errorcoursepublish'] = 'Det oppstod en feil i kurspubliseringen ({$a}). Vennligst prøv igjen senere.';
$string['errorcoursewronglypublished'] = 'Moodle.net rapporterte en publiseringsfeil. Vennligst prøv igjen senere.';
$string['errorcron'] = 'Det oppstod en feil i registreringsoppdateringen på  "{$a->hubname}" ({$a->errormessage})';
$string['errorcronnoxmlrpc'] = 'XML-RPC må være aktivert for at registreringen skal kunne oppdateres.';
$string['errorhublisting'] = 'Det oppstod en feil under mottak av kursoversikten fra Moodle
. Vennligst prøv igjen senere. ({$a})';
$string['errorlangnotrecognized'] = 'Den angitte landskoden er ukjent for Moodle. Vennligst kontakt {$a}';
$string['errorotherhubsnotsupported'] = 'Denne siden kan ikke lengre brukes for registrering på andre sider enn Moodle.net';
$string['errorregistration'] = 'Det oppstod en feil under registreringen, vennligst prøv igjen senere.';
$string['errorregistrationupdate'] = 'Det oppstod en feil under registreringsoppdateringen ({$a})';
$string['errorunpublishcourses'] = 'På grunn av en uventet feil kunne ikke kurset slettes fra Moodle.net. Vennligst prøv igjen (anfefales) eller kontakt Moodle.net-administratoren.';
$string['errorws'] = '{$a}';
$string['errorwstokenreset'] = '{$a}. Registreringstokenen på denne portalen har blitt tilbakestil. Du kan nå registrere portalen på nytt.';
$string['existingscreenshotnumber'] = '{$a} eksisterende skjermbilder. Du kan se disse bildene på denne siden straks Moodle.net-administratoren aktiverer kurset ditt.';
$string['existingscreenshots'] = 'Eksisterende skjermbilder';
$string['forceunregister'] = 'Ja, slett registreringsdata';
$string['forceunregisterconfirmation'] = 'Portalen din kan ikke nå {$a}. Dette kursnavet kan være midlertidig nede. Så sant du ikke vil fortsette med å fjerne den lokale registreringen - vennligst prøv igjen senere.';
$string['geolocation'] = 'Geolokalisering';
$string['geolocation_help'] = 'I fremtiden vil vi trolig tilby tilbyderbaserte søk. Dersom du ønsker å oppgi geografisk sted for kurset ditt med lengde/breddegrad, kan du gjøre det her. (Eks: -31.947884,115.871285)
En grei måte å finne denne informasjonen på er å bruke Google Maps.';
$string['hub'] = 'Nav';
$string['imageurl'] = 'Bilde URL';
$string['imageurl_help'] = 'Dette bildet vil bli brukt på kursnavet. Bildet må alltid være tilgjengelig for kursnavet. Bildet bør ha en maksimum størrelse på {$a->width} X {$a->height}';
$string['information'] = 'Informasjon';
$string['issuedbadgesnumber'] = 'Antall utstedte utmerkelser ({$a})';
$string['language'] = 'Språk';
$string['language_help'] = 'Hovedspråk i dette kurset';
$string['lasttimechecked'] = 'Sist kontrollert';
$string['licence'] = 'Lisens';
$string['licence_help'] = 'Velg lisensen du vil distribuere kurset ditt i';
$string['logourl'] = 'Logo URL';
$string['mobilenotificationsenabled'] = 'Mobilvarslinger aktivert ({$a})';
$string['mobileservicesenabled'] = 'Mobiltjenester aktivert ({$a})';
$string['modulenumberaverage'] = 'Gjennomsnittlig antall kursmoduler ({$a})';
$string['moodleorg'] = 'Moodle';
$string['mustselectsubject'] = 'Du må velge et emne';
$string['name'] = 'Navn';
$string['name_help'] = 'Dette navnet vil vises i kursoversikten';
$string['neverchecked'] = 'Aldri sjekket';
$string['next'] = 'Neste';
$string['no'] = 'Nei';
$string['nocheckstatusfromunreghub'] = 'Portalen er ikke registrert i kursnavet, så status kan ikke kontrolleres.';
$string['nohubselected'] = 'Ingen kursnav valgt';
$string['none'] = 'Ingen';
$string['nosearch'] = 'Ikke publiser kursnav eller kurs';
$string['notregisteredonhub'] = 'Administratoren din må registrere denne portalen på Moodle.net før du kan dele et kurs.';
$string['notregisteredonmoodleorg'] = 'Administratoren din må først registrere dennne portalen hos moodle.org.';
$string['operation'] = 'Handlinger';
$string['orenterprivatehub'] = 'Alternativt, skriv inn en URL til et privat kursnav';
$string['participantnumberaverage'] = 'Gjennomsnittlig antall deltakere ({$a})';
$string['policyagreed'] = 'Personvernerklæring og databehandleravtale';
$string['policyagreeddesc'] = 'Jeg godtar  <a href="{$a}" target="_blank">Personvernerklæringen og databehandleravtalen</a> for Moodle.net';
$string['postaladdress'] = 'Postadresse';
$string['postaladdress_help'] = 'Postadressen til denne portalen, eller for organisasjonen som eier den.';
$string['postsnumber'] = 'Antall poster ({$a})';
$string['previousregistrationdeleted'] = 'Den forrige registreringen er slettet fra {$a}. Du kan restarte registreringsprosessen. Tusen takk.';
$string['prioritise'] = 'Prioriter';
$string['privacy'] = 'Personvern';
$string['privacy_help'] = 'Kursnavet kan ønske å publisere en oversikt over registrerte portaler. Hvis den gjør det kan du velge selv om din portal skal vises på denne oversikten.';
$string['private'] = 'Privat';
$string['privatehuburl'] = 'URL til privat kursnav';
$string['publicationinfo'] = 'Kursets publiseringsinformasjon';
$string['publichub'] = 'Offentlig nav';
$string['publish'] = 'Del';
$string['publishcourse'] = 'Del {$a}';
$string['publishcourseon'] = 'Del på {$a}';
$string['publishedon'] = 'Kursdeling';
$string['publisheremail'] = 'Utgivers e-post';
$string['publisheremail_help'] = 'Utgivers e-postadresse gir en mulighet for at kursnav-administratoren kan varsle utgiver om endringer i kursets publiseringsstatus.';
$string['publishername'] = 'Utgiver';
$string['publishername_help'] = 'Utgiver er den personen eller organisasjonen som er offisiell utgiver av kurset. Så fremt du ikke publiserer på vegne av noen andre vil dette være deg.';
$string['publishon'] = 'Del på';
$string['publishonspecifichub'] = 'Publiser til et annet kursnav';
$string['questionsnumber'] = 'Antall spørsmål ({$a})';
$string['readvertiseon'] = 'Oppdater annonseringsinformasjonen på {$a}';
$string['registeredactiveuserdevices'] = 'Antall registrerte brukere fra mobile enheter som mottar mobilvarslinger ({$a})';
$string['registeredcourses'] = 'Registrerte kurs';
$string['registeredmoodleorg'] = 'Moodle ({$a})';
$string['registeredon'] = 'Hvor nettstedet ditt er registrert';
$string['registeredsites'] = 'Registrerte portaler';
$string['registereduserdevices'] = 'Antall registrerte brukere fra mobile enheter ({$a})';
$string['registermoochtips'] = 'Registrer portalen din hos Moodle for å få sikkerhetsvarsler og tilgang til Moodle.net som er Moodle kursdelingsplattform.';
$string['registersite'] = 'Registrer med {$a}';
$string['registerwith'] = 'Registrer deg hos et nav';
$string['registrationconfirmed'] = 'Portalregistreringen bekreftet';
$string['registrationconfirmedon'] = 'Tusen takk for at du registrerte nettstedet ditt. Registreringsinformasjonen vil holdes oppdatert ved hjelp av cron-jobben \'Portalregistrering\'.';
$string['registrationinfo'] = 'Registreringsinformasjon';
$string['registrationupdated'] = 'Registreringen er oppdatert';
$string['registrationupdatedfailed'] = 'Oppdatering av registreringen var mislykket';
$string['removefromhub'] = 'Fjern fra Moodle.net';
$string['renewregistration'] = 'Forny registreringen';
$string['resourcesnumber'] = 'Antall ressurser ({$a})';
$string['restartregistration'] = 'Restart registreringen';
$string['roleassignmentsnumber'] = 'Antall rolletildelinger ({$a})';
$string['screenshots'] = 'Skjermbilder';
$string['screenshots_help'] = 'Et bilde av kurset vil vises i søkeresultatene.';
$string['search'] = 'Søk';
$string['selecthub'] = 'Velg nav';
$string['selecthubforadvertise'] = 'Velg kursnav for annonsering';
$string['selecthubforsharing'] = 'Velg kursnav for opplasting';
$string['selecthubinfo'] = 'Et kursnav er en server som viser oversikt over kurs. Du kan bare publisere kursene dine på kursnav som denne portalen er registrert på fra før. Dersom ønsket kursnav ikke finnes på listen under kan du kontakte portaladministratoren.';
$string['sendfollowinginfo'] = 'Mer informasjon';
$string['sendfollowinginfo_help'] = 'Følgende informasjon vil bli sendt for å bidra til overordnet statistikk. Informasjonen vil ikke bli offentlig i noen portaloversikter.';
$string['sendingcourse'] = 'Sender kurset';
$string['sendingsize'] = 'Vennligst vent mens filen lastes opp  ({$a->total}Mb)...';
$string['sent'] = '... ferdig';
$string['settings'] = 'Innstillinger';
$string['settingsupdated'] = 'Innstillingene er oppdatert';
$string['share'] = 'Del dette kurset slik at andre kan laste det ned';
$string['shared'] = 'For nedlasting';
$string['shareon'] = 'Last opp dette kurset til {$a}';
$string['shareonhub'] = 'Last opp dette kurset til et nav';
$string['sharepublication_help'] = 'En sikkerhetskopi av dette kurset vil være tilgjengelig på Moodle.net alik at andre kan laste det ned og installere det på sin egen Moodle-portal.';
$string['siteadmin'] = 'Administrator';
$string['siteadmin_help'] = 'Portaladministratorens fulle navn';
$string['sitecommnews'] = 'Oppdateringer om Moodles nyheter og funksjoner.';
$string['sitecommnews_help'] = 'Du har muligheten til å abonnere på vårt nyhetsbrev om hva som skjer i Moodlenettverket.';
$string['sitecommnewsno'] = 'Nei, jeg ønsker ingen eposter fra Moodles hovedkvarter';
$string['sitecommnewsyes'] = 'Ja, inkluder meg i Moodle epostliste om oppdateringer';
$string['sitecountry'] = 'Land';
$string['sitecountry_help'] = 'Landet hvor din organisasjon befinner seg';
$string['sitecreated'] = 'Nettsted opprettet';
$string['sitedesc'] = 'Beskrivelse';
$string['sitedesc_help'] = 'Gi noe informasjon om hvordan du bruker Moodle.';
$string['siteemail'] = 'Administrators epostadresse';
$string['siteemail_help'] = 'Du må oppgi en e-postadresse slik at Moodles hovedkvarter kan kontakte deg om nødvendig. Den kan også brukes til andre formål dersom du tillater det nedenfor. Vi anbefaler å bruker en generisk epostadresse relatert til stilling (f.eks. administrator@eksempel.no), ikke en personlig addresse.';
$string['sitegeolocation'] = 'Geolokalisering';
$string['sitegeolocation_help'] = 'I fremtiden vil vi trolig tilby geografiske søk i kursnavene. Dersom du ønsker å angi posisjon for  din portal kan du oppgi lengd/breddegrad her: (Eks: -31.947884,115.871285)
En grei måte å finne denne informasjonen på er å bruke Google Maps.';
$string['sitelang'] = 'Språk';
$string['sitelang_help'] = 'Hva er standardspråket på Moodleportalen din?';
$string['sitename'] = 'Navn';
$string['sitename_help'] = 'Portalnavnet vil vises i portaloversikten dersom kursnavet tillater det.';
$string['sitephone'] = 'Telefon';
$string['sitephone_help'] = 'Telefonnummeret ditt blir kun sendt til kursnavets administrator.';
$string['siteprivacy'] = 'Portaloversikt';
$string['siteprivacy_help'] = 'Du kan velge å la portalen din vises i den offentlige listen med registrerte portalen, enten med eller uten en lenke til portalen.';
$string['siteprivacylinked'] = 'Publiser portalnavnet med en lenke';
$string['siteprivacynotpublished'] = 'Vennligst ikke publiser denne portalen';
$string['siteprivacypublished'] = 'Publiser bare portalnavnet';
$string['siteregconfcomment'] = 'Portalen din trenger en avsluttende godkjenning på {$a} (for å unngå spam på {$a})';
$string['siteregistrationcontact'] = 'Vis kontaktinformasjon';
$string['siteregistrationcontact_help'] = 'Dersom du tillater det, kan andre brukere  i Moodlesamfunnet (som trenger en brukerkonto) kontakte deg via kontaktskjemaet på Moodle.net. De får aldri se e-postadressen din.';
$string['siteregistrationemail'] = 'Varslinger om viktige sikkerhets og tekniske problemet.';
$string['siteregistrationemail_help'] = 'Du har muligheten til å abonnere på vår lavt-volum epostlistemed viktige nyheter som sikkerhetsoppdateringer og nye versjoner.';
$string['siteregistrationupdated'] = 'Portalregistreringen er oppdatert';
$string['siterelease'] = 'Moodleversjon';
$string['siterelease_help'] = 'Moodle versjonsnummer for denne portalen.';
$string['sitereleasenum'] = 'Moodle versjon ({$a})';
$string['siteupdatedcron'] = 'Portalregistreringen ble oppdatert på "{$a}"';
$string['siteupdatesend'] = 'Oppdatering av registreringsinformasjonen på kursnavene er fullført.';
$string['siteupdatesstart'] = 'Starter oppdatering av registreringsinfomasjonen på kursnavene.';
$string['siteurl'] = 'Portal URL';
$string['siteurl_help'] = 'URL er nettadressen til denne portalen. Dersom personverninnstillingene lar andre se portaladressen er det denne URL-en som blir benyttet.';
$string['siteversion'] = 'Moodleversjon';
$string['siteversion_help'] = 'Moodleversjonen for denne portalen.';
$string['skipregistration'] = 'Hopp over';
$string['specifichubregistrationdetail'] = 'Du kan også registrere portalen din på  andre kursnav.';
$string['statistics'] = 'Statistikk personvern';
$string['status'] = 'Publiseringsstatus';
$string['statuspublished'] = 'Publiserte';
$string['statusunpublished'] = 'Ikke publiserte';
$string['subject'] = 'Emne';
$string['subject_help'] = 'Velg hovedområde dette kurset dekker';
$string['tags'] = 'Tagger';
$string['tags_help'] = 'Tagger er til hjelp for videre kategorisering av kurset ditt og gjør det lettere å finne. Vennligst bruk enkle meningsfylte ord og atskill dem med komma. Eks. matematikk, algebra, geometri';
$string['trustme'] = 'Erklæring';
$string['type'] = 'Delt';
$string['unknownstatus'] = 'Ukjent';
$string['unlistedurl'] = 'Kursnavet finnes ikke i listen';
$string['unprioritise'] = 'Fjern prioritering';
$string['unpublish'] = 'Avslutt deling';
$string['unpublishalladvertisedcourses'] = 'Fjern alle kurs som er delt for påmelding på Moodle.net';
$string['unpublishalluploadedcourses'] = 'Fjernet alle kurs som er delt for nedlasting på Moodle.net';
$string['unpublishconfirmation'] = 'Vil du virkelig fjerne kurset "{$a->courseshortname}" fra "{$a->hubname}" ?';
$string['unpublishcourse'] = 'Avslutt deling {$a}';
$string['unregister'] = 'Fjern registrering';
$string['unregisterconfirmation'] = 'Du er i ferd med å fjerne registreringen av denne portalen fra kursnavet {$a}. Straks du er frakoblet vil du ikke lenger kunne administrere kurs du måtte ha igjen der. Er du sikker på at du vil fjerne registreringen?';
$string['unregisterexplained'] = 'Dersom portalen med URL {$a} er registrert på Moodle.net vil registrering bli fjernet.';
$string['unregisterfrom'] = 'Fjern registrering fra {$a}';
$string['unregistrationerror'] = 'Det oppstod en feil da portalen forskte en avregistrering fra Moodle.net: {$a}';
$string['untrustme'] = 'Usikker';
$string['update'] = 'Oppdater';
$string['updatesite'] = 'Oppdater registreringen på {$a}';
$string['updatestatus'] = 'Sjekk det nå.';
$string['uploaded'] = 'Lastet opp';
$string['url'] = 'nav-URL';
$string['urlalreadyregistered'] = 'Portalen din ser ut til å allerede være registrert allerede på Moodle.net, som betyr at noe har gått galt. Vennligst kontakt Moodle.net-administratoren for å tilbakestille registreringen din så du kan prøve en gang til.';
$string['usedifferentemail'] = 'Bruk annen epostadresse';
$string['usersnumber'] = 'Antall brukere ({$a})';
$string['warning'] = 'ADVARSEL';
$string['wrongtoken'] = 'Registreringen mislykkes av en ukjent årsak (nettverket kanskje ??). Vennligst prøv igjen.';
$string['wrongurlformat'] = 'Feil URL-format';
$string['xmlrpcdisabledcommunity'] = 'Programtillegget XML-RPC er ikke aktivert på denne serveren. Du kan derfor ikke søke etter eller laste ned kurs.';
$string['xmlrpcdisabledpublish'] = 'Programtillegget XML-RPC er ikke aktivert på denne serveren. Du kan derfor ikke dele eller administrere delte kurs.';
$string['xmlrpcdisabledregistration'] = 'Programtillegget XML-RPC er ikke aktivert på denne serveren. Du kan derfor ikke fjerne eller oppdatere registreringsinformasjon før du slår dette programtillegget på.';
