<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'offlinequiz', language 'sr_cr', branch 'MOODLE_36_STABLE'
 *
 * @package   offlinequiz
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['add'] = 'Додај';
$string['addarandomquestion'] = 'питања насумично';
$string['addarandomquestion_help'] = 'Moodle додаје насумичнo изaбрaна питања вишеструког избора (или питања вишеструког избора са више тачних одговора која се оцењују по принципу ”све-или-ништа”) у текућу групу офлајн теста. Број питања који се додаје може се подесити. Питања се бирају из текуће категорије питања (и, ако је изабрано, из њених поткатегорија).';
$string['addarandomselectedquestion'] = 'Додај насумично одабрано питање...';
$string['addlist'] = 'Додај списак';
$string['addnewpagesafterselected'] = 'Додај прелом странице после изабраних питања';
$string['addnewquestion'] = 'ново питање';
$string['addnewquestionsqbank'] = 'Додај питања у категорију {$a->catname}: {$a->link}';
$string['addnewuseroverride'] = 'Додај корисничке измене';
$string['addpagebreak'] = 'Додај прелом странице';
$string['addpagehere'] = 'Додај страницу овде';
$string['addparts'] = 'Додај учеснике';
$string['addquestionfrombankatend'] = 'Додај из банке питања  на крај';
$string['addquestionfrombanktopage'] = 'Додај из банке питања на страницу {$a}';
$string['addrandom'] = 'Насумично додај {$a} питање/a вишеструког избора';
$string['addrandomfromcategory'] = 'питања насумично из категорије';
$string['addrandomquestion'] = 'питања насумично';
$string['addrandomquestiontoofflinequiz'] = 'Додавање питања у офлајн тест {$a->name} (група {$a->group})';
$string['addrandomquestiontopage'] = 'Додај насумично изабрано питање на страницу {$a}';
$string['addtoofflinequiz'] = 'Додај у офлајн тест';
$string['addtoqueue'] = 'Додај у ред за чекање';
$string['allinone'] = 'Неограничено';
$string['alllists'] = 'Сви спискови';
$string['allornothing'] = 'Све-или-ништа';
$string['allresults'] = 'Прикажи све резултате';
$string['allstudents'] = 'Прикажи све полазнике';
$string['alwaysavailable'] = 'Увек доступно';
$string['analysis'] = 'Анализа питања';
$string['answerform'] = 'Образац за одговоре';
$string['answerformforgroup'] = 'Образац за одговоре за групу {$a}';
$string['answerforms'] = 'Обрасци за одговоре';
$string['answerpdfxy'] = 'Образац за одговоре ({$a}->maxquestions питања / {$a}->maxanswers одговора)';
$string['areyousureremoveselected'] = 'Да ли сте сигурни да желите да уклоните сва изабрана питања?';
$string['attemptexists'] = 'Покушај постоји';
$string['attemptsexist'] = 'Више не можете да додајете или уклањате питања.';
$string['attemptsnum'] = 'Укупан број покушајa: {$a}';
$string['attemptsonly'] = 'Прикажи само полазнике са покушајима';
$string['attendances'] = 'Присутност';
$string['basicideasofofflinequiz'] = 'Основне идеје о прављењу офлајн теста';
$string['bulksavegrades'] = 'Сачувај оцене';
$string['calibratescanner'] = 'Калибриши скенер';
$string['cannoteditafterattempts'] = 'Не можете да додајете или уклањате питања јер већ постоје комплетирани покушаји. ({$a})';
$string['category'] = 'Категорија';
$string['changed'] = 'Резултат је промењен.';
$string['checkparts'] = 'Обележи изабране учеснике као присутне';
$string['checkuserid'] = 'Обележи групу/ID ознаку корисника';
$string['chooseagroup'] = 'Изабери групу...';
$string['closebeforeopen'] = 'Није могуће ажурирати офлајн тест. Навели сте датум затварања пре датума отварања.';
$string['closestudentview'] = 'Затвори преглед из угла полазника';
$string['closewindow'] = 'Затвори прозор';
$string['cmmissing'] = 'Модул курса за офлајн тест са ID ознаком {$a} недостаје';
$string['configdecimalplaces'] = 'Број цифара који треба приказати иза децималне тачке, када се се приказују оцене за офлајн тест.';
$string['configintro'] = 'Вредности које овде подесите користиће се као подразумеване вредности за нове офлајн тестове.';
$string['configkeepfilesfordays'] = 'Одредите колико дана ће се постављене датотеке слика чувати у привременом складишту. Током овог периода датотеке слика биће доступне у администраторском извештају о офлајн тесту.';
$string['configonlylocalcategories'] = 'Нису дозвољене дељене категорије питања.';
$string['configshuffleanswers'] = 'Измешај одговоре';
$string['configshufflequestions'] = 'Ако омогућите ову опцију, онда ће редослед питања у групама офлајн теста бити насумично измешан сваки пут када поново креирате преглед теста на картици "Креирај обрасце".';
$string['configshufflewithin'] = 'Ако омогућите ову опцију, онда ће делови који чине појединачна питања бити насумично измешани када се креирају обрасци за питања и одговоре.';
$string['configuseridentification'] = 'Формула описује идентитет корисника. Ова формула се користи како би се доделили обрасци за одговоре корисницима у систему. Десна страна једначине мора да означава поље у табели корисника у Moodleu.';
$string['confirmremovequestion'] = 'Да ли сте сигурни да желите да уклоните ово {$a} питање?';
$string['copy'] = 'Копирај';
$string['copyright'] = '<strong>Упозорење: Текстови на овој страници су само за вашу личну информацију. Као и било које други текст ова питања су заштићена ауторским правима. Није вам дозвољено да их копирате или да их показујете другим људима!</strong>';
$string['copyselectedtogroup'] = 'Додај изабрана питања групи: {$a}';
$string['copytogroup'] = 'Додај сва питања групи: {$a}';
$string['correct'] = 'тачно';
$string['correcterror'] = 'реши';
$string['correctforgroup'] = 'Тачни одговори за групу {$a}';
$string['correctionform'] = 'Исправка';
$string['correctionforms'] = 'Обрасци са тачним одговорима';
$string['correctionoptionsheading'] = 'Опције исправке';
$string['correctupdated'] = 'Ажуриран образац са тачним одговорима за групу {$a}.';
$string['couldnotgrab'] = 'Није могуће дохватити слику {$a}';
$string['couldnotregister'] = 'Није могуће регистровати корисника {$a}';
$string['createcategoryandaddrandomquestion'] = 'Креирај категорију и додај насумична питања';
$string['createlistfirst'] = 'Додај учеснике';
$string['createofflinequiz'] = 'Креирај обрасце';
$string['createpartpdferror'] = 'PDF образац за списак корисника {$a} не може да се креира. Списак је можда празан.';
$string['createpdf'] = 'PDF образац';
$string['createpdferror'] = 'Образац за групу {$a} не може да се креира. Можда не постоје питања за групу.';
$string['createpdffirst'] = 'Креирај прво PDF списак';
$string['createpdfforms'] = 'Креирај обрасце';
$string['createpdfs'] = 'PDF обрасци';
$string['createpdfsparticipants'] = 'PDF обрасци за списак учесника';
$string['createquestionandadd'] = 'Креирај ново питање и додај га у тест.';
$string['createquiz'] = 'Креирај обрасце';
$string['csvfile'] = 'CSV датотека';
$string['csvformat'] = 'Текстуална датотека са вредностима раздвојеним зарезом (CSV)';
$string['csvplus1format'] = 'Текстуална датотека са необрађеним подацима (CSV)';
$string['csvpluspointsformat'] = 'Текстуална датотека са тачкама (CSV)';
$string['darkgray'] = 'Тамно сива';
$string['datanotsaved'] = 'Није могуће сачувати подешавања';
$string['decimalplaces'] = 'Децимална места';
$string['decimalplaces_help'] = 'Број цифара који треба приказати иза децималне тачке, када се се приказују оцене за офлајн тест.';
$string['deletelistcheck'] = 'Да ли заиста желите да обришете изабрану листу и све њене учеснике?';
$string['deletepagecheck'] = 'Да ли заиста желите да обришете изабране странице?';
$string['deletepagesafterselected'] = 'Уклони прелом странице после изабраних питања';
$string['deletepartcheck'] = 'Да ли заиста желите да обришете изабране учеснике?';
$string['deleteparticipantslist'] = 'Обриши списак учесника';
$string['deletepdfs'] = 'Обриши документе';
$string['deleteresultcheck'] = 'Да ли заиста желите да обришете изабране резултате?';
$string['deleteselectedpart'] = 'Обриши изабране учеснике';
$string['deleteselectedresults'] = 'Обриши изабране резултате';
$string['deletethislist'] = 'Обриши овај списак';
$string['deleteupdatepdf'] = 'Обриши и ажурирај PDF обрасце';
$string['difficultytitle'] = 'Тежина';
$string['difficultytitlea'] = 'Тежина А';
$string['difficultytitleb'] = 'Тежина Б';
$string['difficultytitlediff'] = 'Разлика';
$string['displayoptions'] = 'Опције приказа';
$string['done'] = 'готово';
$string['downloadallzip'] = 'Преузми све датотеке као ZIP архиву';
$string['downloadpartpdf'] = 'Преузми PDF датотеку за списак \'{$a}\'';
$string['downloadpdfs'] = 'Преузми документе';
$string['downloadresultsas'] = 'Преузми резултате као:';
$string['dragtoafter'] = 'После {$a}';
$string['dragtostart'] = 'На почетак';
$string['editgroupquestions'] = 'Уреди групу питања';
$string['editgroups'] = 'Уреди офлајн групе';
$string['editingofflinequiz'] = 'Уређивање групе питања';
$string['editingofflinequiz_help'] = 'Када се креира офлајн тест, главни појмови су:
<ul><li> Офлајн тест, који садржи питања на једној или више страна</li>
<li> Банка питања, у којој се чувају копије свих питања, организованих у категорије</li></ul>';
$string['editingofflinequizx'] = 'Уреди офлајн тест: {$a}';
$string['editlist'] = 'Уреди списак';
$string['editlists'] = 'Уреди спискове';
$string['editmaxmark'] = 'Уреди максималну оцену';
$string['editofflinequiz'] = 'Уреди офлајн тест';
$string['editofflinesettings'] = 'Уреди офлајн подешавања';
$string['editorder'] = 'Уреди редослед';
$string['editparticipants'] = 'Уреди учеснике';
$string['editquestion'] = 'Уреди питање';
$string['editquestions'] = 'Уреди питања';
$string['editscannedform'] = 'Уреди скенирани образац';
$string['editthislist'] = 'Уреди овај списак';
$string['emptygroups'] = 'Неке групе питања офлајн тестова су празне. Молимо, додајте неколико питања.';
$string['enroluser'] = 'Упиши корисника';
$string['erroraccessingreport'] = 'Није вам дозвољено да видите овај извештај.';
$string['errorreport'] = 'Извештај о грешкама приликом увоза';
$string['eventattemptdeleted'] = 'Покушај решавања офлајн теста обрисан';
$string['eventattemptpreviewstarted'] = 'Преглед покушаја решавања офлајн теста започет';
$string['eventattemptreviewed'] = 'Покушај решавања офлајн теста прегледан';
$string['eventattemptsummaryviewed'] = 'Резиме покушаја решавања офлајн теста приказан';
$string['eventattemptviewed'] = 'Покушај решавања офлајн теста приказан';
$string['eventdocscreated'] = 'Обрасци за питања и одговоре офлајн теста креирани';
$string['eventdocsdeleted'] = 'Обрасци за питања и одговоре офлајн теста обрисани';
$string['eventeditpageviewed'] = 'Страница  за уређивање офлајн теста приказана';
$string['eventofflinequizattemptsubmitted'] = 'Покушај решавања офлајн теста предат';
$string['eventoverridecreated'] = 'Измена офлајн теста креирана';
$string['eventoverridedeleted'] = 'Измена офлајн теста обрисана';
$string['eventoverrideupdated'] = 'Измена офлајн теста ажурирана';
$string['eventparticipantmarked'] = 'Учесника офлајн тест ручно обележен';
$string['eventquestionmanuallygraded'] = 'Питање ручно оцењено';
$string['eventreportviewed'] = 'Извештај о офлајн тесту приказан';
$string['eventresultsregraded'] = 'Резултати офлајн теста поново оцењени';
$string['everythingon'] = 'омогућено';
$string['excelformat'] = 'Excel радна табела (XLSX)';
$string['fileformat'] = 'Формат за листове са питањима';
$string['fileformat_help'] = 'Изаберите да ли желите да ваши листови са питањима буду у PDF, DOCX или TEX формату. Обрасци за одговоре и листови са тачним одговорима ће увек бити генерисан у PDF формату.';
$string['fileprefixanswer'] = 'answer_form';
$string['fileprefixcorrection'] = 'correction_form';
$string['fileprefixform'] = 'question_form';
$string['fileprefixparticipants'] = 'participants_list';
$string['filesizetolarge'] = 'Неке од ваших датотека слика су врло велике. Димензије ће бити промењене током интерпретације скенираних образаца. Молимо вас да обрасце скенирате у резолуцији између 200 и 300 dpi (тачака по инчу) и у црно-бело режиму. Ово ће убрзати интерпретацију следећи пут.';
$string['fontsize'] = 'Величина фонта';
$string['forautoanalysis'] = 'За аутоматску анализу';
$string['formforcorrection'] = 'Образац са тачним одговорима за групу {$a}';
$string['formforgroup'] = 'Образац са питањима за групу {$a}';
$string['formforgroupdocx'] = 'Образац са питањима за групу {$a} (DOCX)';
$string['formforgrouplatex'] = 'Образац са питањима за групу {$a} (LATEX)';
$string['formsexist'] = 'Обрасци су већ креирани.';
$string['formsexistx'] = 'Обрасци су већ креирани (<a href="{$a}">Преузми обрасце</a>)';
$string['formsheetsettings'] = 'Подешавања образаца';
$string['formspreview'] = 'Преглед за обрасце';
$string['formwarning'] = 'Не постоји дефинисан образац за одговоре. Молимо контактирајте свог администратора.';
$string['fromquestionbank'] = 'из банке питања';
$string['functiondisabledbysecuremode'] = 'Ова функционалност је тренутно онемогућена';
$string['generalfeedback'] = 'Опште повратне информације';
$string['generalfeedback_help'] = 'Опште повратне информације представљају текст који се приказује након покушаја да се одговори на питање. За разлику од повратне информације за појединачно питање које зависи од датог одговора , исте опште повратне информације се увек приказују.';
$string['generatepdfform'] = 'Генериши PDF образац';
$string['grade'] = 'Оцена';
$string['gradedon'] = 'Оцењено';
$string['gradedscannedform'] = 'Скенирани образац са оценама';
$string['gradeiszero'] = 'Напомена: максимална оцена за овај офлајн тест је 0 бодова!';
$string['gradeswarning'] = 'Оцене за питања морају бити бројеви!';
$string['gradewarning'] = 'Оцена за питање мора бити број!';
$string['gradingofflinequiz'] = 'Оцене';
$string['gradingofflinequizx'] = 'Оцене: {$a}';
$string['gradingoptionsheading'] = 'Опције оцењивања';
$string['greeniscross'] = 'рачунато као крстић';
$string['group'] = 'Група';
$string['groupoutofrange'] = 'Група је ван опсега и замењена је са групом А.';
$string['groupquestions'] = 'Питања групе';
$string['hasresult'] = 'Постоји резултат';
$string['idnumber'] = 'ID број / Број досијеа';
$string['imagefile'] = 'Датотека слике';
$string['imagenotfound'] = 'Датотека слике: {$a} није пронађена!';
$string['imagenotjpg'] = 'Слика није jpg или png: {$a}';
$string['imagickwarning'] = 'Недостаје imagemagick библиотека: Замолите свог администратора система да инсталира imagemagick библиотеку и да провери путању до датотеке за конверзију у вашим подешавањима филтера за TeX нотацију. TIF датотеке не можетете да увезете без imagemagick библиотеке!';
$string['import'] = 'Увези';
$string['importedon'] = 'Увезено';
$string['importerror11'] = 'Постоји други резултат';
$string['importerror12'] = 'Корисник није регистрован';
$string['importerror13'] = 'Нема податка о групи';
$string['importerror14'] = 'Није могуће дохватити';
$string['importerror15'] = 'Нејасно обележени одговори';
$string['importerror16'] = 'Грешка странице';
$string['importerror17'] = 'Странице непотпуне';
$string['importerror21'] = 'Није могуће дохватити';
$string['importerror22'] = 'Нејасно обележени одговори';
$string['importerror23'] = 'Корисник није на списку';
$string['importerror24'] = 'Списак није детектован';
$string['importforms'] = 'Увези обрасце са одговорима';
$string['importfromto'] = 'Увоз {$a->from} до {$a->to} од укупно {$a->total}.';
$string['importisfinished'] = 'Увоз за офлајн тест {$a} је завршен.';
$string['importlinkresults'] = 'Линк за резултате: {$a}';
$string['importlinkverify'] = 'Линк за проверу: {$a}';
$string['importmailsubject'] = 'обавештење о увозу офлајн теста';
$string['importnew'] = 'Увези';
$string['importnew_help'] = '<p>
Можете да увезете појединачне датотеке скенираних слика или већи број њих, упаковане у ZIP-архиву. Модул ”Офлајн тест” ће обрадити датотеке слика у позадини.
Називи датотека нису битни али не би требало да садрже посебне знакове као што су дијакритици, умлаути итд. Слике треба да буду у форматима GIF, PNG или TIF. Препоручује се резолуција између 200 и 300dpi (тачака по инчу).</p>';
$string['importnumberexisting'] = 'Број дуплих образаца: {$a}';
$string['importnumberpages'] = 'Број успешно увезених страница: {$a}';
$string['importnumberresults'] = 'Број увезених: {$a}';
$string['importnumberverify'] = 'Број образаца за који је потребна провера: {$a}';
$string['importtimefinish'] = 'Обрада је завршена: {$a}';
$string['importtimestart'] = 'Обрада је започела: {$a}';
$string['inconsistentdata'] = 'Противречни подаци: {$a}';
$string['info'] = 'Информације';
$string['infoshort'] = 'инфо';
$string['insecuremarkings'] = 'Нејасно обележени одговори траже ручне исправке';
$string['insecuremarkingsforquestion'] = 'Нејасно обележени одговори траже ручне исправке за питања';
$string['insertnumber'] = 'Молимо вас да убаците тачан идентификациони број обележен плавим оквиром.';
$string['instruction1'] = 'Овај образац са одговорима биће аутоматски скениран. Молимо вас да га не савијате или жврљате по њему. За обележавање одговора користите црну или плаву оловку:';
$string['instruction2'] = 'Само јасно обележени одговори биће интерпретирани као исправни. Ако желите да исправите (поништите) свој одговор, комплетно испуните поље бојом. Тако обележено поље, приликом скенирања, биће интерпретирано као празно:';
$string['instruction3'] = 'Поља која су исправљена (комплетно испуњена бојом) не могу више да буду исправно обележена. Молимо вас да не ништа не пишете изван поља за обележавање.';
$string['introduction'] = 'Увод';
$string['invalidnumberofdigits'] = 'Коришћен је неисправан број цифара. Дозвољено је само 1 до 9 цифара.';
$string['invaliduserfield'] = 'Коришћено је неисправно поље корисничке табеле.';
$string['invigilator'] = 'Дежурни на испиту';
$string['ischecked'] = 'Учешће је проверено';
$string['isnotchecked'] = 'Учешће није проверено';
$string['itemdata'] = 'Подаци о ајтему';
$string['keepfilesfordays'] = 'Временски период чувања датотека (у данима)';
$string['lightgray'] = 'Светло сивa';
$string['linktoscannedform'] = 'Прикажи скенирани образац';
$string['listnotdetected'] = 'Није могуће детектовати бар кôд за списак!';
$string['logdeleted'] = 'Запис {$a} је обрисан.';
$string['logourl'] = 'URL адреса логотипа';
$string['logourldesc'] = 'URL адреса датотеке слике који се приказује у горњем десном углу обрасца са одговорима, тј. <b>http://www.yoursite.tld/mylogo.png</b> или <b>../path/to/your/logo.png</b>. Максимална дозвољена величина је 520x140 пиксела. Образац са одговорима не може да се евалуира ако слика прелази максималну величину!';
$string['lowertrigger'] = 'Друга доња граница';
$string['lowertriggerzero'] = 'Друга доња граница је нула';
$string['lowerwarning'] = 'Прва доња граница';
$string['lowerwarningzero'] = 'Прва доња граница је нула';
$string['marginwarning'] = 'Молимо вас да одштампате следеће PDF документе без додатних маргина!<br /> Избегавајте да студентима дајете фотокопије. Ако имате било какву дилему наручите копије од тима за подршку.';
$string['marks'] = 'Оцене';
$string['matrikel'] = 'идентификациони број полазника';
$string['maxgradewarning'] = 'Највећа оцена мора да буде број!';
$string['maxmark'] = 'Максимална оцена';
$string['membersinplist'] = '{$a->count} учесник/а у<a href="{$a->url}">{$a->name}</a>';
$string['missingimagefile'] = 'Недостаје датотека слике';
$string['missingitemdata'] = 'Недостаје/у одговор/и за корисника {$a}';
$string['missinglogdata'] = 'Недостају подаци о запису за постојећи резултат.';
$string['missingquestion'] = 'Изгледа да ово питање више не постоји';
$string['missinguserid'] = 'Недостаје идентификациони број корисника! Није могуће прочитати бар кôд!';
$string['modulename'] = 'Офлајн тест';
$string['modulenameplural'] = 'Офлајн тестови';
$string['moodleprocessing'] = 'Пустите да Moodle обради податке';
$string['movecorners'] = 'Промените прво позицију угаоних маркера. Користите опцију \'превуци и спусти\'';
$string['moveselectedonpage'] = 'Преместите изабрана питања на страницу: {$a}';
$string['multianswersforsingle'] = 'Питање вишеструког избора са једним одговором';
$string['multichoice'] = 'Вишеструки избор';
$string['multipleanswers'] = 'Изаберите бар један одговор.';
$string['name'] = 'Назив офлајн теста';
$string['neededcorrection'] = '<strong>Пажња: За неке од ваших обележених одговара потребна је ручна исправка. Погледајте црвени квадрат на следећој слици.
<br />Ово подразумева ручну интервенције од стране предавача и одложено објављивање резултата офлајн теста!</strong>';
$string['newgrade'] = 'Оцењено';
$string['newpage'] = 'Нова страница';
$string['noattemptexists'] = 'Не постоји ниједан покушај';
$string['noattempts'] = 'Није увезен ниједан покушај!';
$string['noattemptsonly'] = 'Прикажи само студенте без покушаја';
$string['nocourse'] = 'Недостаје курс са ID ознаком {$a->course} којем припада офлајн тест са ID ознаком {$a->offlinequiz}.';
$string['nogradesseelater'] = 'Овај тест није оцењен још за {$a}. Резултати ће бити овде објављени.';
$string['nogroupdata'] = 'Нема податка о групи за корисника {$a}';
$string['nomcquestions'] = 'Не постоје питања вишеструког избора у групи {$a}!';
$string['noofflinequiz'] = 'Не постоји офлајн тест са ID ознаком {$a}!';
$string['nopages'] = 'Није увезена ниједна страница';
$string['noparticipantsfound'] = 'Није пронађен ниједан учесник';
$string['nopdfscreated'] = 'Није креиран ниједан документ!';
$string['noquestions'] = 'Неке групе офлајн теста су празне. Додајте питања.';
$string['noquestionselected'] = 'Није изабрано ниједно питање!';
$string['noquestionsfound'] = 'Не постоје питања у групи {$a}!';
$string['noquestionsonpage'] = 'Празна страница';
$string['noresults'] = 'Не постоје резултати.';
$string['noreview'] = 'Није вам дозвољено да прегледате овај офлајн тест';
$string['noscannedpage'] = 'Не постоји скенирана страница са ID ознаком {$a}!';
$string['nothingtodo'] = 'Не ради ништа';
$string['notxtfile'] = 'Нема TXT датотеке';
$string['notyetgraded'] = 'Још није оцењено';
$string['nozipfile'] = 'Нема ZIP датотеке';
$string['numattempts'] = 'Број увезених покушаја: {$a}';
$string['numattemptsqueue'] = 'Број образаца са одговорима који су додати на чекање: {$a}. Након обраде података биће послата порука на вашу е-адресу.';
$string['numattemptsverify'] = 'Број скенираних образаца који чекају исправку: {$a}';
$string['numberformat'] = 'Вредност мора да буде број са {$a} цифре/цифара!';
$string['numbergroups'] = 'Број група';
$string['numpages'] = 'Увезено страна: {$a}';
$string['numquestionsx'] = 'Питања: {$a}';
$string['numusersadded'] = 'Додато учесника: {$a}';
$string['odsformat'] = 'OpenDocument радна табела (ODS)';
$string['offlineimplementationfor'] = 'Офлајн имплементација за';
$string['offlinequiz:addinstance'] = 'Додај офлајн тест';
$string['offlinequiz:attempt'] = 'Покушај решавања тестова';
$string['offlinequizcloses'] = 'Офлајн тест се затвара';
$string['offlinequizcloseson'] = 'Преглед овог офлајн теста ће се затворити {$a}';
$string['offlinequiz:createofflinequiz'] = 'Креирај обрасце за офлајн тест';
$string['offlinequiz:deleteattempts'] = 'Обриши покушаје решавања офлајн теста';
$string['offlinequiz:grade'] = 'Оцени офлајн тестове ручно';
$string['offlinequizisclosed'] = 'Офлајн тест затворен';
$string['offlinequizisclosedwillopen'] = 'Офлајн тест затворен (отвара се {$a})';
$string['offlinequizisopen'] = 'Овај офлајн тест је отворен';
$string['offlinequizisopenwillclose'] = 'Офлајн тест отворен (затвара се {$a})';
$string['offlinequiz:manage'] = 'Управљање офлајн тестовима';
$string['offlinequizopenedon'] = 'Овај офлајн тест је отворен {$a}';
$string['offlinequizopens'] = 'Офлајн тест се отвара';
$string['offlinequiz:preview'] = 'Прегледај офлајн тестове';
$string['offlinequizsettings'] = 'Подешавања офлајн теста';
$string['offlinequiz:view'] = 'Прикажи информације о офлајн тесту';
$string['offlinequiz:viewreports'] = 'Прикажи извештаје о офлајн тесту';
$string['offlinequizwillopen'] = 'Офлајн тест се отвара {$a}';
$string['oneclickenrol'] = 'Упис на 1 клик';
$string['oneclickenroldesc'] = 'Ако је активирана ова опција предавачи имају могућност да упишу кориснике једним кликом док исправљају обрасце са одговорима(грешка "Корисник није уписан на курс").';
$string['oneclickrole'] = 'Улога за ”Упис на 1 клик”';
$string['oneclickroledesc'] = 'Изаберите улогу која се користи за ”Упис на 1 клик”. Могу бити изабране само улоге са архетипом ”студент”.';
$string['onlylocalcategories'] = 'Само локалне категорије питања';
$string['orderandpaging'] = 'Редослед и пагинација';
$string['orderandpaging_help'] = 'Бројеви 10, 20, 30... поред сваког питања указују на редослед питања у тесту. Бројеви се повећавају у корацима по 10 како би се оставио простор за убацивање додатних питања. Да бисте променили редослед питања, промените број а онда кликните на дугме "Промени редослед питања".

Да бисте додали прелом странице након одређеног питања, означите поље за потврду одмах поред самог питања а затим кликните на дугме "Додај прелом странице после изабраних питања"

Да бисте организовали питања на више страница кликните на дугме "Реорганизуј странице" и изаберите жељени број питања по страници.';
$string['orderingofflinequiz'] = 'Редослед и пагинација';
$string['otherresultexists'] = 'Другачији резултат за {$a}  већ постоји, увоз је игнорисан! Обришите резултат прво.';
$string['outof'] = '{$a->grade} од максималних {$a->maxgrade}';
$string['outofshort'] = '{$a->grade}/{$a->maxgrade}';
$string['overallfeedback'] = 'Свеобухватне повратне информације';
$string['overview'] = 'Преглед';
$string['overviewdownload_help'] = '';
$string['pagecorrected'] = 'Исправљени лист са списком учесника увезен';
$string['pageimported'] = 'Лист са списком учесника увезен';
$string['page-mod-offlinequiz-edit'] = 'Страница за уређивање офлајн теста';
$string['page-mod-offlinequiz-x'] = 'Било која страница офлајн теста';
$string['pagenotdetected'] = 'Није могуће детектовати бар кôд за страницу!';
$string['pagenumberimported'] = 'Лист {$a} са списком учесника увезен';
$string['pagesizeparts'] = 'Број учесника приказаних по страници:';
$string['papergray'] = 'Вредност белине папира';
$string['papergray_help'] = 'Ако су бели делови ваших скенираних образаца за одговоре веома тамни, то можете да исправите тако што ћете ову вредност подесити на \'Тамно сива\'.';
$string['partcheckedwithoutresult'] = '<a href="{$a->url}">Потврђени учесници без резултата: {$a->count}</a>';
$string['partcheckedwithresult'] = 'Потврђени учесници са резултатом: {$a}';
$string['participants'] = 'Учесници';
$string['participants_help'] = '<p>Спискови учесника су дизајнирани за велике тестове са великим бројем учесника. Они помажу предавачу да провери који полазници су приступили тесту и да ли су сви резултати исправно увезени.
Можете да додате кориснике на различите спискове. Сваки списак може, на пример, да садржи учеснике у одређеној просторији. Учесници могу да буду чланови посебне групе. За креирање тих група може се користити алат за регистрацију групе.
Спискови учесника могу се преузети као PDF документи и одштампати. Присутни полазници се могу обележити крстићем, баш као што се обележавају одговори у обрасцу за одговоре офлајн теста. Након тога, скенирани спискови могу да буду постављени на сервер, а полазници обележени крстићем биће означени у бази података као присутни.
Избегавајте мрље на бар кôдовима јер се они користе за идентификацију полазника.</p>';
$string['participantsinlists'] = 'Учесници на списку';
$string['participantslist'] = 'Списак учесника';
$string['participantslists'] = 'Учесници';
$string['partimportnew'] = 'Постављање списка учесника';
$string['partimportnew_help'] = 'У овој картици можете да поставите попуњене спискове учесника. Можете да поставите појединачне датотеке скенираних слика или већи број њих, упаковане у ZIP-архиву. Модул ”Офлајн тест” ће обрадити датотеке слика у позадини.
Називи датотека нису битни али не би требало да садрже посебне знакове као што су дијакритици, умлаути итд. Слике треба да буду у форматима GIF, PNG или TIF. Препоручује се резолуција између 200 и 300dpi (тачака по инчу).</p>';
$string['partuncheckedwithoutresult'] = 'Непотврђени учесници без резултата: {$a}';
$string['partuncheckedwithresult'] = '<a href="{$a->url}">Непотврђени учесници са резултатом: {$a->count}</a>';
$string['pdfdeletedforgroup'] = 'Образац за групу {$a} обрисан';
$string['pdfintro'] = 'Додатне информације';
$string['pdfintro_help'] = 'Ове информације биће штампане на првој страници листа са питањима. Оне треба да садрже упутство како се попуњава образац са одговорима.';
$string['pdfintrotext'] = '<b>Како да правилно обележим одговоре?</b><br />Овај образац са одговорима биће аутоматски скениран. Молимо вас да га не савијате или жврљате по њему. За обележавање одговора користите црну или плаву оловку. Одговор који сматрате тачним обележите знаком X. Ако желите да исправите свој одговор, комплетно испуните поље бојом. Тако обележено поље, приликом скенирања, биће интерпретирано као празно.<br />';
$string['pdfintrotoolarge'] = 'Увод је предугачак (максимално 2000 знакова).';
$string['pdfscreated'] = 'PDF обрасци су креирани';
$string['pdfsdeletedforgroup'] = 'Обрасци за групу {$a} обрисани';
$string['pearlywhite'] = 'Бисерно бела';
$string['pluginadministration'] = 'Администрација офлајн теста';
$string['pluginname'] = 'Офлајн тест';
$string['point'] = 'поен';
$string['present'] = 'присутан';
$string['preventsamequestion'] = 'Спречите вишеструко коришћење истог питања у различитим групама';
$string['preview'] = 'Преглед';
$string['previewforgroup'] = 'Преглед за групу {$a}';
$string['previewquestion'] = 'Прегледај питање';
$string['printstudycodefield'] = 'Штампај поље за шифру студијског програма на листу са питањима';
$string['printstudycodefield_help'] = 'Ако омогућите ову опцију, онда ће на првој страници обрасца са питањима бити одштампано поље за уписивање шифре студијског програма.';
$string['questionanalysis'] = 'Анализа тежине питања';
$string['questionanalysistitle'] = 'Табела са анализом тежине питања';
$string['questionbankcontents'] = 'Садржај банке питања';
$string['questionforms'] = 'Обрасци са питањима';
$string['questioninfoanswers'] = 'Број тачних одговора';
$string['questioninfocorrectanswer'] = 'тачан одговор';
$string['questioninfocorrectanswers'] = 'тачни одговори';
$string['questioninfonone'] = 'Ништа';
$string['questioninfoqtype'] = 'Тип питања';
$string['questionname'] = 'Назив питања';
$string['questionsheet'] = 'Лист са питањима';
$string['questionsin'] = 'Питања у';
$string['questionsingroup'] = 'Питања у групи';
$string['questionsinthisofflinequiz'] = 'Питања у овом офлајн тесту';
$string['questiontextisempty'] = '[Празан текст питања]';
$string['quizdate'] = 'Датум офлајн теста';
$string['quizopenclose'] = 'Датуми отварања и затварања';
$string['quizopenclose_help'] = 'Полазници могу да виде свој(е) покушај(е) након датум отварања и пре датума затварања.';
$string['quizquestions'] = 'Питања теста';
$string['randomfromexistingcategory'] = 'Насумично питања из постојеће категорије';
$string['randomnumber'] = 'Број насумичних питања';
$string['randomquestionusinganewcategory'] = 'Насумично питање користећи нову категорију';
$string['readjust'] = 'Подеси';
$string['recreatepdfs'] = 'Поново креирај PDF документе';
$string['recurse'] = 'Укључи и питања из поткатегорија';
$string['rediswrong'] = 'крстић погрешан или недостаје';
$string['refreshpreview'] = 'Освежи преглед';
$string['regrade'] = 'Оцени поново';
$string['regradedisplayexplanation'] = '<b>Пажња:</b> Поновно оцењивање неће променити обележене одговоре који су ручно измењени!';
$string['regradinginfo'] = 'Ако промените оцену за питање, морате поново да оцените офлајн тест како бисте ажурирали резултате учесника.';
$string['regradingquiz'] = 'Поновно оцењивање';
$string['regradingresult'] = 'Поновно оцењивање резултата за корисника {$a}...';
$string['reloadpreview'] = 'Поново учитај преглед';
$string['reloadquestionlist'] = 'Поново учитај списак питања';
$string['remove'] = 'Уклони';
$string['removeemptypage'] = 'Уклони празну страницу';
$string['removepagebreak'] = 'Уклони прелом странице';
$string['removeselected'] = 'Уклони изабрано';
$string['reordergroupquestions'] = 'Промени редослед питања групе';
$string['reorderquestions'] = 'Промени редослед питања';
$string['reordertool'] = 'Прикажи алат за реорганизовање питања';
$string['repaginate'] = 'Реорганизуј странице са {$a} питања по једној страници';
$string['repaginatecommand'] = 'Реорганизуј странице';
$string['repaginatenow'] = 'Реорганизуј странице сад';
$string['reportoverview'] = 'Преглед';
$string['reportstarts'] = 'преглед резултата';
$string['resetofflinequizzes'] = 'Ресетуј податке офлајн теста';
$string['resultexists'] = 'Isti резултат за {$a}  већ постоји, увоз је игнорисан';
$string['resultimport'] = 'Увези резултате';
$string['results'] = 'Резултати';
$string['review'] = 'Преглед';
$string['reviewbefore'] = 'Дозволи преглед док је офлајн тест отворен';
$string['reviewclosed'] = 'Након што се офлајн тест затвори';
$string['reviewcloses'] = 'Преглед се затвара';
$string['reviewimmediately'] = 'Одмах након покушаја';
$string['reviewincludes'] = 'Преглед укључује';
$string['reviewofresult'] = 'Преглед резултата';
$string['reviewopens'] = 'Преглед се отвара';
$string['reviewoptions'] = 'Полазници могу да виде';
$string['reviewoptionsheading'] = 'Опције прегледа';
$string['reviewoptions_help'] = 'Са овим опцијама можете да контролишете шта полазници могу да виде након што се увезу резултати.
Такође можете да дефинишете временски период током којег ће бити доступан извештај са резултатима. Поља за потврду имају следећа значења:
<table>
<tr><td style="vertical-align: top;"><b>Покушај</b></td><td>
Текст питања и одговори биће приказани полазницима. Они ће видети одговоре које су изабрали, али тачни одговори неће бити назначени.</td>
</td></tr>
<tr><td style="vertical-align: top;"><b>Да ли је одговор тачан</b></td><td>
Ова опција може да буде активирана само ако је укључена опција "Покушај". Ако је активна, полазници ће моћи да виде који од одговора које су изабрали је тачан (зелена позадина) а који нетачан (црвена позадина).
</td></tr>
<tr><td style="vertical-align: top;"><b>Оцене</b></td><td>
Биће приказана група теста (нпр. Б), резултати (постигнута оцена, укупна оцена за питања, постигнуће у процентима, на пример 40/80 (50)) и оцена (нпр. 50 од максималних100).
Поред тога, ако је укључена опција "Покушај", за свако питање биће приказани постигнут, као и максималан резултат.
</td></tr>
<tr><td style="vertical-align: top;"><b>Тачни одговори</b></td><td>
Ако је ова опција активирана биће показано који одговори су тачни а који нетачни. Ова опција доступна је само ако је укључен "Покушај".
</td></tr>
<tr><td style="vertical-align: top;"><b>Скенирани образац</b></td><td>
Приказује су скенирани обрасци са одговорима. Обележена поља (одговори) су означена зеленим квадратом.
</td></tr>
<tr><td style="vertical-align: top;"><b>Скенирани образац са оценама</b></td><td>
Приказује су скенирани обрасци са одговорима. Обележена поља (одговори) су означена зеленим квадратом. Погрешно обележени одговори, као и они који нису обележени су истакнути.
Поред тога, табела приказује максималну и постигнуту оцену за свако питање.
</td></tr>
</table>';
$string['rimport'] = 'Постави/Исправи';
$string['rotate'] = 'Ротирај';
$string['rotatingsheet'] = 'Лист је ротиран...';
$string['save'] = 'Сачувај';
$string['saveandshow'] = 'Сачувај и покажи промене полазницима';
$string['savescannersettings'] = 'Сачувај подешавања скенера';
$string['scannedform'] = 'Скенирани образац';
$string['scannerformfortype'] = 'Образац за тип {$a}';
$string['scanneroptions'] = 'Подешавања скенера';
$string['scannerpdfs'] = 'Празни обрасци';
$string['scannerpdfstext'] = 'Преузети следећа празне обрасце ако желите да користите свој софтвер за скенирање.';
$string['scanningoptionsheading'] = 'Опције за скенирање';
$string['score'] = 'Скор';
$string['select'] = 'Изабери';
$string['selectagroup'] = 'Изабери групу';
$string['selectall'] = 'Изабери све';
$string['selectcategory'] = 'Изабери категорију';
$string['selectdifferentgroup'] = 'Молимо вас, изаберите другу групу!';
$string['selectedattempts'] = 'Изабрани покушаји...';
$string['selectformat'] = 'Изабери формат...';
$string['selectgroup'] = 'Изабери групу';
$string['selectlist'] = 'Изаберите списак или покушајте да подесите лист:';
$string['selectnone'] = 'Поништи избор свега';
$string['selectpage'] = 'Изаберите број странице или покушајте да подесите лист:';
$string['selectquestiontype'] = '-- Изабери тип питања --';
$string['showallparts'] = 'Прикажи све учеснике, њих {$a}';
$string['showcopyright'] = 'Прикажи изјаву о ауторским правима';
$string['showcopyrightdesc'] = 'Ако омогућите ову опцију, изјава о ауторским правима биће приказана на страници полазника за преглед резултата.';
$string['showgrades'] = 'Штампај оцене за питања';
$string['showgrades_help'] = 'Ова опција одређује да ли на листу са питањима треба да се штампају максималне оцене за питања офлајн теста.';
$string['showmissingattemptonly'] = 'Прикажи све означене учеснике без покушаја';
$string['showmissingcheckonly'] = 'Прикажи све означене учеснике са резултатом';
$string['shownumpartsperpage'] = 'Прикажи {$a} учесника по страници';
$string['showquestioninfo'] = 'Штампај информације о одговорима';
$string['showquestioninfo_help'] = 'Помоћу ове опције можете да одредите које додатне информације о питању ће се штампати на листу са питањима.
Можете да изаберете једну од следећих опција:
<ul>
<li> Ништа
<li> Тип питања - зависно од типа питања биће одштампано ”Вишеструки избор са једним тачним одговором”, ”Вишеструки избор са више тачних одговора”, ”Вишеструки избор са више тачних одговора типа све-или-ништа”
<li> Број тачних одговора
</ul>';
$string['showstudentview'] = 'Прикажи преглед из угла полазника';
$string['showtutorial'] = 'Прикажи полазницима упутство за офлајн тест.';
$string['showtutorialdescription'] = 'Можете додати линк ка упутству на страници курса користећи следећу URL адресу:';
$string['showtutorial_help'] = 'Ова опција одређује да ли полазници могу да виде упутство са основним информацијама о офлајн тестовима.
Упутство пружа информације о томе како се поступа са различитим врстама докумената унутар офлајн тестова. У интерактивном делу полазници уче како да правилно унесу своју ID ознаку.<br />
<b>Имајте у виду:</b><br />
Ако поставите ову опцију на "Да", али притом сакријете офлајн тест линк ка упутству неће бити видљив. У том случају можете да додате линк ка упутству на страници курса.';
$string['shuffleanswers'] = 'Измешај одговоре';
$string['shufflequestions'] = 'Измешај питања';
$string['shufflequestionsanswers'] = 'Измешај питања и одговоре';
$string['shufflequestionsselected'] = 'Опција за мешање питања је укључена, тако да поједине акције у вези са страницама нису доступне. Да бисте променили опцију за мешање питања идите на страницу за уређивање офлајн теста - {$a}.';
$string['shufflewithin'] = 'Измешај унутар питања';
$string['shufflewithin_help'] = 'Ако је ова опција омогућена, онда ће одговори унутар свих питања бити насумично измешани сваки пут када притиснете дугме за поновно учитавање на страници за преглед обрасца са питањима. НАПОМЕНА: Ово подешавање се примењује само на питања код којих је опција за мешање активирана.';
$string['signature'] = 'Потпис';
$string['singlechoice'] = 'Вишеструки избор са једним тачним одговором';
$string['standard'] = 'Стандардна';
$string['starttutorial'] = 'Стартуј упутство о офлајн тестирању';
$string['statistics'] = 'Статистика';
$string['statisticsplural'] = 'Статистика';
$string['statsoverview'] = 'Преглед статистике';
$string['studycode'] = 'Шифра студијског програма';
$string['theattempt'] = 'Покушај';
$string['timesup'] = 'Време је истекло!';
$string['totalmarksx'] = 'Укупна оцене за сва питања: {$a}';
$string['totalpointsx'] = 'Укупна оцене за сва питања: {$a}';
$string['totalquestionsinrandomqcategory'] = 'Укупан број питања у категорији: {$a}.';
$string['trigger'] = 'доња/горња граница';
$string['tutorial'] = 'Упутство за офлајн тестове';
$string['type'] = 'Тип';
$string['uncheckparts'] = 'Обележи изабране кориснике као одсутне';
$string['updatedsumgrades'] = 'Збир свих оцена за групу {$a->letter} је прерачунат на {$a->grade}.';
$string['upgradingfilenames'] = 'Ажурирање назива датотека докумената: офлајн тест {$a->done}/{$a->outof} <br/>(Офлајн тест ID {$a->info})';
$string['upgradingilogs'] = 'Ажурирање скенираних страница: скенирана страница {$a->done}/{$a->outof} <br/>(Офлајн тест ID {$a->info})';
$string['upgradingofflinequizattempts'] = 'Ажурирање покушаја решавања теста: офлајн тест $a->done}/{$a->outof} <br/>(Офлајн тест ID {$a->info})';
$string['upload'] = 'Постави/Исправи';
$string['uploadpart'] = 'Постави/Исправи спискове учесника';
$string['uppertrigger'] = 'Друга горња граница';
$string['uppertriggerzero'] = 'Друга горња граница је нула';
$string['upperwarning'] = 'Прва горња граница';
$string['upperwarningzero'] = 'Прва горња граница је нула';
$string['useradded'] = 'Корисник {$a} је додат/а';
$string['userdoesnotexist'] = 'Корисник {$a} не постоји у систему';
$string['useridentification'] = 'Идентификација корисника';
$string['userimported'] = 'Корисник {$a} је увезен/а и оцењен/а';
$string['usernotincourse'] = 'Корисник {$a} није на курсу.';
$string['usernotinlist'] = 'Корисник није регистрован на списку!';
$string['usernotregistered'] = 'Корисник {$a} није регистрован на курсу';
$string['userpageimported'] = 'Једна страница увезена за корисника {$a}';
$string['valuezero'] = 'Вредност не би требало да буде нула';
$string['viewresults'] = 'Прикажи резултате';
$string['white'] = 'Бела';
$string['withselected'] = 'Са изабраним....';
$string['zerogradewarning'] = 'Упозорење: Ваша оцена за офлајн тест је 0.0!';
$string['zipfile'] = 'ZIP датотека';
$string['zipok'] = 'ZIP датотека увезена';
