<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'assign', language 'sr_cr', branch 'MOODLE_36_STABLE'
 *
 * @package   assign
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityoverview'] = 'Имате задатке на које треба обратити пажњу';
$string['addattempt'] = 'Дозволи други покушај';
$string['addnewattempt'] = 'Додај нови покушај';
$string['addnewattemptfromprevious'] = 'Додај нови покушај на основу претходно предатог рада';
$string['addnewattemptfromprevious_help'] = 'Ово ће копирати садржај вашег претходног рада у нови како бисте могли да радите на њему.';
$string['addnewattempt_help'] = 'Ово ће креирати нови празан рад како бисте могли да радите на њему';
$string['addnewgroupoverride'] = 'Додај измену за групу';
$string['addnewuseroverride'] = 'Додај измену за корисника';
$string['addsubmission'] = 'Додај рад';
$string['addsubmission_help'] = 'Још увек нисте предали свој рад.';
$string['allocatedmarker'] = 'Додељени оцењивач';
$string['allocatedmarker_help'] = 'Оцењивач који је додељен за овај рад.';
$string['allowsubmissions'] = 'Дозволи кориснику да настави  предају радова на овај задатак';
$string['allowsubmissionsanddescriptionfromdatesummary'] = 'Детаљније информације о задатку и образац за предају радова биће доступни од <strong>{$a}</strong>';
$string['allowsubmissionsfromdate'] = 'Дозволи предају од';
$string['allowsubmissionsfromdate_help'] = 'Ако је ова опција омогућена полазницинеће моћи да предају рад пре овог датума. Ако је онемогућена, полазници ће одмах моћи да предају рад.';
$string['allowsubmissionsfromdatesummary'] = 'Овај задатак ће прихватити предају рада од <strong>{$a}</strong>';
$string['allowsubmissionsshort'] = 'Дозволи промене предатог рада';
$string['alwaysshowdescription'] = 'Увек прикажи опис';
$string['alwaysshowdescription_help'] = 'Ако је ова опција омогућена, \'Опис задатка\' ће постати видљив полазницима тек од датума наведеног за подешавање "Дозволи предају од".';
$string['applytoteam'] = 'Примените оцене и повратне информације на целу групу';
$string['assign:addinstance'] = 'Додај нови задатак';
$string['assign:editothersubmission'] = 'Уреди други рад полазника';
$string['assign:exportownsubmission'] = 'Извоз сопственог рада';
$string['assignfeedback'] = 'Додатак за повратне информације';
$string['assignfeedbackpluginname'] = 'Додатак за повратне информације';
$string['assign:grade'] = 'Оцењивање задатка';
$string['assign:grantextension'] = 'Одобри продужетак';
$string['assign:manageallocations'] = 'Управљање оцењивачима додељеним предатим радовима';
$string['assign:managegrades'] = 'Прегледај и објави оцене';
$string['assign:manageoverrides'] = 'Управљање изменама подешавања задатка';
$string['assignmentisdue'] = 'Крајњи рок за предају је истекао';
$string['assignmentmail'] = '{$a->grader} је послао/ла повратне информације на рад који сте предали за задатак \'{$a->assignment}\'

Повратне информације су придружене вашем раду и можете их погледати  на:

{$a->url}';
$string['assignmentmailhtml'] = '<p>{$a->grader} је послао/ла повратне информације на рад који сте предали за задатак \'<i>{$a->assignment}</i>\'.</p>
<p>Повратне информације можете погледати придружене вашем <a href="{$a->url}">раду</a>.</p>';
$string['assignmentmailsmall'] = '{$a->grader} је послао/ла повратне информације на рад који сте предали за задатак \'{$a->assignment}\' . Повратне информације можете погледати придружене вашем раду.';
$string['assignmentname'] = 'Назив задатка';
$string['assignmentplugins'] = 'Додаци за задатак';
$string['assignmentsperpage'] = 'Задаци по страници';
$string['assign:receivegradernotifications'] = 'Примај обавештења о додељеним оценама';
$string['assign:releasegrades'] = 'Објави оцене';
$string['assign:revealidentities'] = 'Откриј идентитет полазника';
$string['assign:reviewgrades'] = 'Прегледај оцене';
$string['assignsubmission'] = 'Додатак за предају рада';
$string['assignsubmissionpluginname'] = 'Додатак за предају рада';
$string['assign:submit'] = 'Предај рад';
$string['assign:view'] = 'Прегледај задатак';
$string['assign:viewblinddetails'] = 'Прикажи идентитет полазника када је анонимно оцењивање омогућено';
$string['assign:viewgrades'] = 'Погледај оцене';
$string['attemptheading'] = 'Покушај {$a->attemptnumber}: {$a->submissionsummary}';
$string['attempthistory'] = 'Претходни покушаји';
$string['attemptnumber'] = 'Број покушаја';
$string['attemptreopenmethod'] = 'Поновно отварање рада';
$string['attemptreopenmethod_help'] = 'Ово подешавање одређује како се радови полазника поново отварају. Доступне су следеће опције:
<ul>
<li>Никад - рад не може да се отвара поново.</li>
<li>Ручно - предавач може поново да отвори рад./li>
<li>Аутоматски док не добије прелазну оцену - рад се аутоматски поново отвара све док полазник, за овај задатак, не постигне прелазну оцену која је подешена у књизи оцена.</li>
</ul>';
$string['attemptreopenmethod_manual'] = 'Ручно';
$string['attemptreopenmethod_none'] = 'Никад';
$string['attemptreopenmethod_untilpass'] = 'Аутоматски док не добије прелазну оцену';
$string['attemptsettings'] = 'Подешавања покушаја';
$string['availability'] = 'Доступност';
$string['backtoassignment'] = 'Назад на задатак';
$string['batchoperationconfirmaddattempt'] = 'Дозволите још један покушај за изабране радове?';
$string['batchoperationconfirmdownloadselected'] = 'Желите да  преузмете изабране радове?';
$string['batchoperationconfirmgrantextension'] = 'Одобрити продужење рока свим изабраним радовима?';
$string['batchoperationconfirmlock'] = 'Закључајте све изабране предате радове?';
$string['batchoperationconfirmreverttodraft'] = 'Вратите изабране радове у статус нацрта?';
$string['batchoperationconfirmsetmarkingallocation'] = 'Доделите оцењивача за све изабране предате радове?';
$string['batchoperationconfirmsetmarkingworkflowstate'] = 'Подесити стање тока оцењивања за све изабране радове?';
$string['batchoperationconfirmunlock'] = 'Одкључајте све изабране предате радове?';
$string['batchoperationlock'] = 'закључај предате радове';
$string['batchoperationreverttodraft'] = 'вратите предате радове у статус нацрта';
$string['batchoperationsdescription'] = 'Са изабранима...';
$string['batchoperationunlock'] = 'откључај предате радове';
$string['batchsetallocatedmarker'] = 'Додели оцењивача за следећи број одабраних корисника: {$a} .';
$string['batchsetmarkingworkflowstateforusers'] = 'Подеси стање тока оцењивања за следећи број изабраних корисника: {$a}.';
$string['blindmarking'] = 'Анонимно оцењивање';
$string['blindmarkingenabledwarning'] = 'Анонимно оцењивање је омогућено за ову активности.';
$string['blindmarking_help'] = 'Анонимно оцењивање скрива од оцењивача идентитет полазника. Подешавања за анонимно оцењивање биће закључана оног тренутка када рад буде предат или када буде оцењен.';
$string['calendardue'] = 'Истиче крајњи рок за предају {$a}';
$string['calendargradingdue'] = '{$a} треба да буде оцењен';
$string['changefilters'] = 'Промени филтере';
$string['changeuser'] = 'Промени корисника';
$string['choosegradingaction'] = 'Акција оцењивања';
$string['choosemarker'] = 'Изабери...';
$string['chooseoperation'] = 'Изаберите операцију';
$string['clickexpandreviewpanel'] = 'Кликни за проширење панела за преглед';
$string['collapsegradepanel'] = 'Скупи панел за оцењивање';
$string['collapsereviewpanel'] = 'Скупи панел за преглед';
$string['comment'] = 'Коментар';
$string['completionsubmit'] = 'Полазник мора да преда ову активност како би је завршио';
$string['configshowrecentsubmissions'] = 'Сви могу да виде обавештење о предатим радовима у извештају о скорашњим активностима.';
$string['confirmbatchgradingoperation'] = 'Да ли сте сигурни да желите да {$a->operation}  за {$a->count} полазника?';
$string['confirmsubmission'] = 'Да ли сте сигурни да желите да  предате свој рад на оцењивање? Више нећете моћи да га мењате.';
$string['confirmsubmissionheading'] = 'Потврди предају';
$string['conversionexception'] = 'Није могуће конвертовати рад. Изузетак је гласио: {$a}.';
$string['couldnotconvertgrade'] = 'Није могуће конвертовати оцену задатка за корисника {$a}.';
$string['couldnotconvertsubmission'] = 'Није могуће конвертовати предати рад за корисника {$a}.';
$string['couldnotcreatecoursemodule'] = 'Није могуће креирати модул курса';
$string['couldnotcreatenewassignmentinstance'] = 'Није могуће креирати нову инстанцу задатка';
$string['couldnotfindassignmenttoupgrade'] = 'Није могуће наћи стару инстанцу задатка за надоградњу';
$string['currentassigngrade'] = 'Тренутна оцена за задатак';
$string['currentattempt'] = 'Ово је покушај {$a}.';
$string['currentattemptof'] = 'Ово је покушај {$a->attemptnumber} ( {$a->maxattempts} дозвољена/их покушаја ).';
$string['currentgrade'] = 'Тренутна оцена у књизи оцена';
$string['cutoffdate'] = 'Дефинитивни рок';
$string['cutoffdatecolon'] = 'Дефинитивни рок: {$a}';
$string['cutoffdatefromdatevalidation'] = 'Дефинитивни рок за предају не може бити пре датума од ког је дозвољена предаја рада.';
$string['cutoffdate_help'] = 'Ако је подешен овај датум, након њега неће бити могуће предати рад без продужетка рока за предају.';
$string['cutoffdatevalidation'] = 'Дефинитивни рок не може бити пре крајњег рока за предају рада.';
$string['defaultlayout'] = 'Рестаурирај подразумевани распоред';
$string['defaultsettings'] = 'Подразумевана подешавања задатка';
$string['defaultsettings_help'] = 'Ова подешавања дефинишу подразмеване вредности за све нове задатке';
$string['defaultteam'] = 'Подразумевана група';
$string['deleteallsubmissions'] = 'Обриши све предате радове';
$string['description'] = 'Опис';
$string['disabled'] = 'Онемогућено';
$string['downloadall'] = 'Преузми све предате радове';
$string['downloadasfolders'] = 'Преузми радове као директоријуме';
$string['downloadasfolders_help'] = 'Предати радови се могу преузети у директоријумима. Сваки предати рад се смешта у засебан директоријум, са очувавањем структуре директоријума са евентуалним поддиректоријумима, а датотекама се не мењају називи.';
$string['downloadselectedsubmissions'] = 'Преузми изабране радове';
$string['duedate'] = 'Крајњи рок';
$string['duedatecolon'] = 'Крајњи рок: {$a}';
$string['duedate_help'] = 'Овај датум представља крајњи рок за предају задатка. Предаја након овог датума ће и даље бити дозвољена, али ће сви радови предати након овог датума бити обележени као закаснели. Да бисте спречили предају радова након одређеног датума подесите дефинитивни рок за предају рада.';
$string['duedateno'] = 'Нема крајњег рока';
$string['duedatereached'] = 'Крајњи рок за овај задатак је сада истекао';
$string['duedatevalidation'] = 'Крајњи рок за предају не може бити пре датума од којег је дозвољена предаја.';
$string['duplicateoverride'] = 'Креирај копију измене';
$string['editaction'] = 'Акције...';
$string['editattemptfeedback'] = 'Уреди оцену и повратне информације за покушај број {$a}.';
$string['editingpreviousfeedbackwarning'] = 'Уређујете повратне информације за претходни покушај. Ово је покушај {$a->attemptnumber} од укупно {$a->totalattempts}.';
$string['editingstatus'] = 'Статус уређивања';
$string['editonline'] = 'Уреди онлајн';
$string['editoverride'] = 'Уреди измену';
$string['editsubmission'] = 'Уреди рад';
$string['editsubmission_help'] = 'Још увек можете да направите промене у свом раду.';
$string['editsubmissionother'] = 'Уреди рад за {$a}';
$string['enabled'] = 'Омогућено';
$string['errornosubmissions'] = 'Нема предатих радова за преузимање';
$string['errorquickgradingvsadvancedgrading'] = 'Оцене нису сачуване зато што овај задатак тренутно користи напредно оцењивање';
$string['errorrecordmodified'] = 'Оцене нису сачуване зато што је неко изменио један или више записа након што сте учитали страницу';
$string['eventallsubmissionsdownloaded'] = 'Сви предати радови се преузимају.';
$string['eventassessablesubmitted'] = 'Рад је предат.';
$string['eventbatchsetmarkerallocationviewed'] = 'Групна додела оцењивача приказана';
$string['eventbatchsetworkflowstateviewed'] = 'Групно подешавање стања тока оцењивања приказано';
$string['eventextensiongranted'] = 'Продужетак је одобрен.';
$string['eventfeedbackupdated'] = 'Повратне информације ажуриране';
$string['eventfeedbackviewed'] = 'Повратне информације приказане';
$string['eventgradingformviewed'] = 'Образац за оцењивање приказан';
$string['eventgradingtableviewed'] = 'Табела за оцењивања приказана';
$string['eventidentitiesrevealed'] = 'Идентитети су откривени.';
$string['eventmarkerupdated'] = 'Додељени оцењивач је ажуриран.';
$string['eventoverridecreated'] = 'Измена подешавања задатка креирана';
$string['eventoverridedeleted'] = 'Измена подешавања задатка обрисана';
$string['eventoverrideupdated'] = 'Измена подешавања задатка ажурирана';
$string['eventrevealidentitiesconfirmationpageviewed'] = 'Страница за потврду откривања идентитета приказана';
$string['eventstatementaccepted'] = 'Корисник је прихватио изјаву о предаjи рада.';
$string['eventsubmissionconfirmationformviewed'] = 'Образац за потврду о предаји рада прикзан.';
$string['eventsubmissioncreated'] = 'Предати рад креиран';
$string['eventsubmissionduplicated'] = 'Корисник је предао дупликат свог рада.';
$string['eventsubmissionformviewed'] = 'Образац за предају рада приказан';
$string['eventsubmissiongraded'] = 'Предати рад је оцењен.';
$string['eventsubmissionlocked'] = 'Предати радови су закључани за корисника.';
$string['eventsubmissionstatusupdated'] = 'Статус предатог рада је ажуриран.';
$string['eventsubmissionstatusviewed'] = 'Статус предатог рада је приказан.';
$string['eventsubmissionunlocked'] = 'Предати радови су откључани за корисника.';
$string['eventsubmissionupdated'] = 'Предати рад ажуриран';
$string['eventsubmissionviewed'] = 'Предати рад приказан';
$string['eventworkflowstateupdated'] = 'Стање тока оцењивања је ажурирано.';
$string['expandreviewpanel'] = 'Рашири панел за преглед';
$string['extensionduedate'] = 'Продужени рок';
$string['extensionnotafterduedate'] = 'Продужени рок мора бити након крајњег рока за предају рада.';
$string['extensionnotafterfromdate'] = 'Продужени рок мора бити након датумa од ког је дозвољена предаја решења.';
$string['feedback'] = 'Повратне информације';
$string['feedbackavailablehtml'] = '{$a->username} је послао/ла повратне информације на рад који сте предали за задатак  \'<i>{$a->assignment}</i>\'<br /><br /> Повратне информације можете погледати придружене вашем <a href="{$a->url}">предатом раду</a>.';
$string['feedbackavailablesmall'] = '{$a->username} је дао/ла повратне информације за задатак {$a->assignment}';
$string['feedbackavailabletext'] = '{$a->username} је послао/ла повратне информације на рад који сте предали за задатак \'{$a->assignment}\'

Повратне информације су придружене вашем раду и можете их погледати  на:

{$a->url}';
$string['feedbackplugin'] = 'Додатак за повратне информације';
$string['feedbackpluginforgradebook'] = 'Додатак за повратне информације који ће пребацивати коментаре у књигу оцена';
$string['feedbackpluginforgradebook_help'] = 'Само један додатак за повратне информације задатка може да пребаци повратне информације у књигу оцена.';
$string['feedbackplugins'] = 'Додаци за повратне информације';
$string['feedbacksettings'] = 'Подешавања повратних информација';
$string['feedbacktypes'] = 'Врсте повратних информација';
$string['filesubmissions'] = 'Предаја датотека';
$string['filter'] = 'Филтер';
$string['filtergrantedextension'] = 'Одобрен продужетак';
$string['filternone'] = 'Нема филтера';
$string['filternotsubmitted'] = 'Није предато';
$string['filterrequiregrading'] = 'Захтева оцењивање';
$string['filtersubmitted'] = 'Предато';
$string['fixrescalednullgrades'] = 'Овај задатак садржи неке погрешне оцене. Можете <a href="{$a->link}">аутоматски поправити ове оцене</a>. Ово може утицати на укупну оцену.';
$string['fixrescalednullgradesconfirm'] = 'Да ли сте сигурни да желите поправити погрешне оцене? Све погрешне оцене ће бити уклоњене. Ово може утицати на укупну оцену.';
$string['fixrescalednullgradesdone'] = 'Оцене поправљене.';
$string['gradeabovemaximum'] = 'Оцена мора да буде мања од или једнака {$a}';
$string['gradebelowzero'] = 'Оцена мора бити већа од или једнака нули';
$string['gradecanbechanged'] = 'Оцена може бити промењена';
$string['gradechangessaveddetail'] = 'Промене оцена и повратних информација су сачуване';
$string['graded'] = 'Оцењено';
$string['gradedby'] = 'Оценио/ла';
$string['gradedfollowupsubmit'] = 'Оцењено - примљен накнадно достављен рад';
$string['gradedon'] = 'Оцењено';
$string['gradelocked'] = 'Ова оцена је закључана или преписана у књизи оцена.';
$string['gradeoutof'] = 'Оцена од {$a}';
$string['gradeoutofhelp'] = 'Оцена';
$string['gradeoutofhelp_help'] = 'Овде унесите оцену за рад полазника. Можете укључити децимале.';
$string['gradersubmissionupdatedhtml'] = '{$a->username} је ажурирао/ла своје решење задатка <i>\'{$a->assignment}\' у  {$a->timeupdated}</i><br /><br />
Решење је <a href="{$a->url}">доступно на веб сајту</a>.';
$string['gradersubmissionupdatedsmall'] = '{$a->username} је ажурирао/ла свој рад за задатак за задатак {$a->assignment}.';
$string['gradersubmissionupdatedtext'] = '{$a->username} је ажурирао/ла свој рад за задатак \'{$a->assignment}\' у  {$a->timeupdated}

Рад је доступно на следећој адреси:

{$a->url}';
$string['gradestudent'] = 'Оцени полазника: (id={$a->id}, име и презиме={$a->fullname}).';
$string['gradeuser'] = 'Оцена {$a}';
$string['grading'] = 'Оцењивање';
$string['gradingchangessaved'] = 'Промене оцена су сачуване';
$string['gradingduedate'] = 'Подсети ме да оценим до';
$string['gradingduedate_help'] = 'Датум до ког треба да буде завршено оцењивање предатих радова. Овај датум се користи како би се одредио приоритет обавештења која се појављују на контролном панелу предавача.';
$string['gradingdueduedatevalidation'] = 'Подсети ме да датум до када радови треба да буду оцењени не може бити пре крајњег рока за њихову предају.';
$string['gradingduefromdatevalidation'] = 'Подсети ме да датум до када радови треба да буду оцењени не може бити пре датума од ког је дозвољена њихова предаја.';
$string['gradingmethodpreview'] = 'Критеријуми оцењивања';
$string['gradingoptions'] = 'Опције';
$string['gradingstatus'] = 'Статус оцењивања';
$string['gradingstudent'] = 'Оцењивање полазника';
$string['gradingsummary'] = 'Резиме оцењивања';
$string['grantextension'] = 'Одобри продужетак';
$string['grantextensionforusers'] = 'Одобри продужетак за {$a} полазника';
$string['groupoverrides'] = 'Измене за групе';
$string['groupoverridesdeleted'] = 'Измене за групе обрисане';
$string['groupsnone'] = 'Не постоје групе којима можете приступити.';
$string['groupsubmissionsettings'] = 'Подешавања за групну предају рада';
$string['hiddenuser'] = 'Учесник';
$string['hideshow'] = 'Сакриј/Прикажи';
$string['inactiveoverridehelp'] = '* Полазник нема исправну групу или улогу да би могао да покуша задатак';
$string['indicator:cognitivedepth'] = 'Задатак - когнитивни аспект';
$string['indicator:cognitivedepth_help'] = 'Овај индикатор се заснива на когнитивној дубини коју је полазник постигао у оквиру активности \'Задатак\'.';
$string['indicator:socialbreadth'] = 'Задатак - социјални аспект';
$string['indicator:socialbreadth_help'] = 'Овај индикатор се заснива на обиму социјалних интеракција који је полазник постигао у оквиру активности \'Задатак\'.';
$string['instructionfiles'] = 'Датотеке са инструкцијама';
$string['introattachments'] = 'Додатне датотеке';
$string['introattachments_help'] = 'Додатне датотеке у задатку, као што су шаблони одговора, могу да се додају. Линк за преузимање датотека биће приказан на страници задатка испод описа.';
$string['invalidfloatforgrade'] = 'Није могуће разумети оцену која је дата: {$a}';
$string['invalidgradeforscale'] = 'Оцена која је дата није исправна за текућу скалу';
$string['invalidoverrideid'] = 'Неисправна ID ознака измене';
$string['lastmodifiedgrade'] = 'Последње измене (оцена)';
$string['lastmodifiedsubmission'] = 'Последње измене (предати рад)';
$string['latesubmissions'] = 'Касно предати радови';
$string['latesubmissionsaccepted'] = 'Дозвољено до {$a}';
$string['loading'] = 'Учитавање...';
$string['locksubmissionforstudent'] = 'Спречи даљу предају радова за полазника: (id={$a->id}, име и презиме={$a->fullname}).';
$string['locksubmissions'] = 'Закључај предате радове';
$string['manageassignfeedbackplugins'] = 'Управљање додацима за повратне информације';
$string['manageassignsubmissionplugins'] = 'Управљање додацима за предају радова';
$string['marker'] = 'Оцењивач';
$string['markerfilter'] = 'Филтер оцењивача';
$string['markerfilternomarker'] = 'Нема оцењивача';
$string['markingallocation'] = 'Користи расподелу оцењивања';
$string['markingallocation_help'] = 'Ако је ово подешавање омогућено, заједно са током оцењивања, оцењивачима могу бити додељени поједини полазници.';
$string['markingworkflow'] = 'Користи ток цењивања';
$string['markingworkflow_help'] = 'Ако је ово подешавање омогућено, оцене ће проћи кроз низ фаза у процесу оцењивања пре него што буду објављене полазницима. Ово омогућава више кругова оцењивања, као и да оцене буду објављене полазницима истовремено.';
$string['markingworkflowstate'] = 'Стање тока оцењивања';
$string['markingworkflowstate_help'] = 'Могућа стања тока оцењивања могу да укључе (зависно од ваших овлашћења):

* Неоцењено - оцењивач још није започео оцењивање
* Оцењује се - оцењивач је започео оцењивање али га још није завршио
* Оцењивање завршено . оцењивач је завршио оцењивање,  али је можда потребно да се врати због провере/исправки
* На прегледу - оцењивање је сада код надлежног наставника одговорног за проверу квалитета
* Спремно за објављивање - надлежни наставник је задовољан са оцењивањем али може да сачека пре него што полазницима дозволи приступ оценама
* Објављено - полазници могу да приступе оценама/повратним информацијама';
$string['markingworkflowstateinmarking'] = 'Оцењује се';
$string['markingworkflowstateinreview'] = 'На прегледу';
$string['markingworkflowstatenotmarked'] = 'Није оцењено';
$string['markingworkflowstatereadyforrelease'] = 'Спремно за објаву';
$string['markingworkflowstatereadyforreview'] = 'Оцењивање завршено';
$string['markingworkflowstatereleased'] = 'Објављено';
$string['maxattempts'] = 'Максималан број покушаја';
$string['maxattempts_help'] = 'Максималан број дозвољених покушаја предаје рада од стране полазника. Након овог броја покушаја рад полазника више не може бити поново отворен.';
$string['maxgrade'] = 'Максимална оцена';
$string['maxperpage'] = 'Максимална број задатака по страници';
$string['maxperpage_help'] = 'Максималан број задатака који оцењивач може да прикаже на страници за оцењивање. Ово подешавање је корисно како би се спречила временска ограничења на курсевима са великим бројем уписаних полазника.';
$string['messageprovider:assign_notification'] = 'Обавештење о задатку';
$string['modulename'] = 'Задатак';
$string['modulename_help'] = 'Модул активности "Задатак"  пружа могућност наставнику да полазницима  задаје задатке, прикупља њихове радове, оцењује их, као и да им  шаље повратне информације.

Полазници, као свој рад, могу да предају различите дигиталне садржаје (датотеке), као што су текстуални документи, прорачунске табеле, слике, презентације или аудио и видео клипови. Алтернативно, или као додатак претходном, задатак може да тражи од полазника да текст унесу директно у текст едитор. Задатак, такође, може да се користи као подсетник полазницима за „стварни“ задатак који морају да ураде „офлајн“, ван сајта, попут  рецимо неког уметничког рада, цртежа итд, а да се при томе од њих не захтева слање било каквог дигиталног садржаја. Полазници могу да предају рад индивидуално или као чланови групе.

Приликом прегледања задатака, наставници могу да остављају коментаре, повратне информације и постављају датотеке, као што су прегледани и  обележени радови полазника са коментарима, засебни докуменати са коментарима или повратне информације у говорном тј. аудио формату. Задаци се оцењује бројчаном,  или наменски прилагођеном, скалом за оцењивање, или, коришћењем напредних метода оцењивања као што су рубрике. Завршне оцене се записују у књигу оцена.';
$string['modulenameplural'] = 'Задаци';
$string['moreusers'] = 'још {$a}...';
$string['multipleteams'] = 'Члан више од једне групе';
$string['multipleteams_desc'] = 'Овај задатак тражи групну предају рада. Члан сте више од једне групе. Да бисте могли да предате рад морате да будете члан само једне групе. Контактирајте свог предавача како би променио ваше чланство у групи.';
$string['multipleteamsgrader'] = 'Члан више од једне групе, тако да не може да преда рад.';
$string['mysubmission'] = 'Моји предати радови';
$string['newsubmissions'] = 'Задаци су предати';
$string['noattempt'] = 'Нема покушаја';
$string['noclose'] = 'Нема датума затварања задатка';
$string['nofiles'] = 'Нема датотека';
$string['nofilters'] = 'Нема филтера';
$string['nograde'] = 'Нема оцене';
$string['nolatesubmissions'] = 'Не прихвата се закаснела преда радова.';
$string['nomoresubmissionsaccepted'] = 'Дозвољено само полазницима којима је одобрен продужетак';
$string['none'] = 'Ниједна';
$string['noonlinesubmissions'] = 'Овај задатак не тражи од вас да било штa предате  онлајн';
$string['noopen'] = 'Нема датума отварања задатка';
$string['nooverridedata'] = 'Морате да измените барем једно од подешавања задатка.';
$string['nosavebutnext'] = 'Следећи';
$string['nosubmission'] = 'За овај задатак још ништа није предато';
$string['nosubmissionsacceptedafter'] = 'Решења се не прихватају после';
$string['noteam'] = 'Није члан ниједне групе.';
$string['noteam_desc'] = 'Овај задатак тражи групну предају рада. Нисте члан ниједне групе, тако да не можете да предате рад. Контактирајте свог предавача како би вас додао у групу.';
$string['noteamgrader'] = 'Није члан ниједне групе, тако да не може да преда рад.';
$string['notgraded'] = 'Није оцењено';
$string['notgradedyet'] = 'Још није оцењено';
$string['notifications'] = 'Обавештења';
$string['notsubmittedyet'] = 'Још није предато';
$string['nousers'] = 'Нема корисника';
$string['nousersselected'] = 'Није изабран ниједан полазник';
$string['numberofdraftsubmissions'] = 'Нацрти';
$string['numberofparticipants'] = 'Учесници';
$string['numberofsubmissionsneedgrading'] = 'Тражи оцењивање';
$string['numberofsubmittedassignments'] = 'Предато';
$string['numberofteams'] = 'Групе';
$string['offline'] = 'Не тражи се онлајн предаја рада';
$string['open'] = 'Отворено';
$string['outlinegrade'] = 'Оцена: {$a}';
$string['outof'] = '{$a->current} од {$a->total}';
$string['overdue'] = '<font color="red">Крајњи рок за предају рада је истекао пре: {$a}</font>';
$string['override'] = 'Измена';
$string['overridedeletegroupsure'] = 'Да ли сте сигурни да желите да избришете измену подешавања за групу {$a}?';
$string['overridedeleteusersure'] = 'Да ли сте сигурни да желите да избришете измену подешавања за корисника {$a}?';
$string['overridegroup'] = 'Измени подешавања за групу';
$string['overridegroupeventname'] = '{$a->assign} - {$a->group}';
$string['overrides'] = 'Измене';
$string['overrideuser'] = 'Измени подешавања за корисника';
$string['overrideusereventname'] = '{$a->assign} - Измена';
$string['page-mod-assign-view'] = 'Главна страница модула \'Задатак\'';
$string['page-mod-assign-x'] = 'Било која страница модула \'Задатак\'';
$string['paramtimeremaining'] = 'Преостало време: {$a}';
$string['participant'] = 'Учесник';
$string['pluginadministration'] = 'Администрација задатака';
$string['pluginname'] = 'Задатак';
$string['preventsubmissionnotingroup'] = 'Неопходна је група за предају рада';
$string['preventsubmissionnotingroup_help'] = 'Ако је ова опција омогућена, корисници који нису чланови групе неће моћи да предају радове.';
$string['preventsubmissions'] = 'Спречи корисника да више не предаје своје радове за овај задатак.';
$string['preventsubmissionsshort'] = 'Спречи измене предатих радова';
$string['previous'] = 'Претходни';
$string['privacy:attemptpath'] = 'покушај {$a}';
$string['privacy:blindmarkingidentifier'] = 'Идентификатор који се користи за анонимно оцењивање';
$string['privacy:gradepath'] = 'оцена';
$string['privacy:metadata:assigndownloadasfolders'] = 'Корисничка преференција везана за то да ли да се више предатих докумената преузме у директоријуме';
$string['privacy:metadata:assignfeedbackpluginsummary'] = 'Повратне информације за задатак.';
$string['privacy:metadata:assignfilter'] = 'Опције за филтрирање као што су \'Предато\', \'Није предато\', \'Захтева оцењивање\', and \'Одобрен продужетак\'';
$string['privacy:metadata:assigngrades'] = 'Чува корисничке оцене за задатак';
$string['privacy:metadata:assignmarkerfilter'] = 'Филтрирај сажетак задатка према додељеном оцењивачу';
$string['privacy:metadata:assignmentid'] = 'Идентификатор задатка';
$string['privacy:metadata:assignmessageexplanation'] = 'Поруке се полазницима шаљу кроз интерни систем за слање порука.';
$string['privacy:metadata:assignoverrides'] = 'Чува информације о иновираним подацима везаним за задатак';
$string['privacy:metadata:assignperpage'] = 'Број задатака који се приказују по страници.';
$string['privacy:metadata:assignquickgrading'] = 'Преференција везана за то да ли се користи брзо оцењивање или не.';
$string['privacy:metadata:assignsubmissiondetail'] = 'Чува податке о предатим радовима корисника';
$string['privacy:metadata:assignsubmissionpluginsummary'] = 'Подаци о предатим задацима.';
$string['privacy:metadata:assignuserflags'] = 'Чува мета податке корисника као што су датуми продужетака';
$string['privacy:metadata:assignusermapping'] = 'Мапирање за анонимно оцењивање';
$string['privacy:metadata:assignworkflowfilter'] = 'Филтрирај према различитим стадијумима тока рада.';
$string['privacy:metadata:grade'] = 'Нумеричка оцена за предати рад. Може се одредити на основу подешавања скала, напредних форми за оцењивање и сл. али ће увек бити конвертована у реални број.';
$string['privacy:metadata:grader'] = 'Идентификатор корисника који оцењује.';
$string['privacy:metadata:groupid'] = 'Идентификатор групе чији је корисник члан.';
$string['privacy:metadata:latest'] = 'Прилично поједностављује упите везане за добијање информација само о најфришкијем покушају.';
$string['privacy:metadata:mailed'] = 'Да ли је овом кориснику већ послата електронска порука?';
$string['privacy:metadata:timecreated'] = 'Време креирања';
$string['privacy:metadata:userid'] = 'ID ознака корисника';
$string['privacy:studentpath'] = 'радови полазника';
$string['privacy:submissionpath'] = 'рад';
$string['quickgrading'] = 'Брзо оцењивања';
$string['quickgradingchangessaved'] = 'Промене оцена су сачуване';
$string['quickgrading_help'] = 'Брзо оцењивање вам дозвољава да доделите оцене (и исходе) директно у табели предатих задатака. Брзо оцењивање није компатибилно са напредним оцењивањем и не препоручује се када постоји више оцењивача.';
$string['quickgradingresult'] = 'Брзо оцењивање';
$string['recordid'] = 'Индетификатор';
$string['removeallgroupoverrides'] = 'Обриши све измене за групе';
$string['removealluseroverrides'] = 'Обриши све измене за кориснике';
$string['reopenuntilpassincompatiblewithblindmarking'] = 'Држи отвореним све док је опције за прелазну оцену некомпатибилна са анонимним оцењивањем, пошто се оцене не шаљу у дневник оцена све док се не открије идентитет полазника.';
$string['requireallteammemberssubmit'] = 'Неопходна је предаја рада од стране свих чланова групе';
$string['requireallteammemberssubmit_help'] = 'Ако је ова опција омогућена сви чланови групе полазника ће морати да кликну на дугме \'Предај\' за овај задатак, пре него што групни рад буде могао да се сматра предатим. Ако је опција онемогућена, групни рад ће се сматрати предатим оног момента када било ко од чланова групе кликне на дугме \'Предај\'.';
$string['requiresubmissionstatement'] = 'Захтевај да полазници прихвате изјаву о предаји рада';
$string['requiresubmissionstatement_help'] = 'Захтевај да полазници прихвате изјаву о предаји рада за све предате радове за овај задатак.';
$string['revealidentities'] = 'Откриј идентитет полазника';
$string['revealidentitiesconfirm'] = 'Да ли сте сигурни да желите да откријете идентитет полазника за овај задатак? Ова операција не може бити поништена, Једном када се идентитет полазника открије оцене ће бити објављене у књизи оцена.';
$string['reverttodefaults'] = 'Врати задатак на стандардна подешавања';
$string['reverttodraft'] = 'Врати предати рад у статус нацрта';
$string['reverttodraftforstudent'] = 'Врати рад у статус нацрта за полазника: (id={$a->id}, име и презиме={$a->fullname}).';
$string['reverttodraftshort'] = 'Врати предати рад у статус нацрта';
$string['reviewed'] = 'Прегледано';
$string['save'] = 'Сачувај';
$string['saveallquickgradingchanges'] = 'Сачувај све промене брзог оцењивања';
$string['saveandcontinue'] = 'Сачувај и настави';
$string['savechanges'] = 'Сачувај промене';
$string['savegradingresult'] = 'Оцена';
$string['savenext'] = 'Сачувај и прикажи следећи';
$string['saveoverrideandstay'] = 'Сачувај и унеси другу измену';
$string['savingchanges'] = 'Чување промена...';
$string['scale'] = 'Скала';
$string['search:activity'] = 'Задатак - информације о активности';
$string['selectedusers'] = 'Одабрани корисници';
$string['selectlink'] = 'Изабери...';
$string['selectuser'] = 'Изабери {$a}';
$string['sendlatenotifications'] = 'Обавести оцењиваче о радовима који су предати са закашњењем';
$string['sendlatenotifications_help'] = 'Ако је ова опција омогућена, оцењивачи (обично предавачи) ће добити поруку кад год полазник рад преда са закашњењем. Начин слања поруке се може подесити.';
$string['sendnotifications'] = 'Обавести оцењиваче о предатим радовима';
$string['sendnotifications_help'] = 'Ако је ова опција омогућена, оцењивачи (обично предавачи) ће добити поруку кад год полазник рад преда раније, на време и са закашњењем. Начин слања поруке се може подесити.';
$string['sendstudentnotifications'] = 'Обавести полазнике';
$string['sendstudentnotificationsdefault'] = 'Подразумевано подешавање за "Обавести полазнике"';
$string['sendstudentnotificationsdefault_help'] = 'Поставља подразумевану вредност за опцију "Обавести полазнике" у обрасцу за оцењивање.';
$string['sendstudentnotifications_help'] = 'Ако је ова опција омогућена полазници ће примати поруку о ажурираној оцене или повратним информацијама.';
$string['sendsubmissionreceipts'] = 'Пошаљи полазницима потврду о предатом раду';
$string['sendsubmissionreceipts_help'] = 'Ово омогућава слање потврду о предатом раду. Полазници ће примити обавештење сваки пут када успешно предају рад.';
$string['setmarkerallocationforlog'] = 'Подеси доделу оцењивања : (id={$a->id}, има и презиме={$a->fullname}, оцењивач={$a->marker}).';
$string['setmarkingallocation'] = 'Подеси додељеног оцењивача';
$string['setmarkingworkflowstate'] = 'Подеси стање тока оцењивања';
$string['setmarkingworkflowstateforlog'] = 'Подеси стање тока оцењивања : (id={$a->id}, име и презиме={$a->fullname}, стање={$a->state}).';
$string['settings'] = 'Подешавања задатка';
$string['showrecentsubmissions'] = 'Прикажи скоро предате радове';
$string['status'] = 'Статус';
$string['studentnotificationworkflowstateerror'] = 'Ток оцењивања мора бити у статусу "Објављено" да би се полазници курса обавестили о оценама.';
$string['submission'] = 'Предати рад';
$string['submissioncopiedhtml'] = '<p>Направили сте копију свог претходног рада за задатак \'<i>{$a->assignment}</i>\'.</p>
<p>Можете видети статус свог <a href="{$a->url}">предатог рада</a>.</p>';
$string['submissioncopiedsmall'] = 'Копирали сте свој претходни рад за задатак {$a->assignment}';
$string['submissioncopiedtext'] = 'Направили сте копију свог претходног рада за задатак \'{$a->assignment}\'

Можете видети статус свог предатог рада:

    {$a->url}';
$string['submissiondrafts'] = 'Захтевај да полазници кликну на дугме "Предај\'';
$string['submissiondrafts_help'] = 'Ако је ова опција омогућена, полазници ће морати да кликну на дугме \'Предај\' како би свој рад прогласили коначним. Ово омогућава полазницима да унутар система чувају верзију нацрта свог рада. Ако се ово подешавање са "Не" промени на "Да" након што су полазници предали своје радове те верзије њихових радове ће бити сматране коначним.';
$string['submissioneditable'] = 'Полазници могу да уређују овај задатак';
$string['submissionempty'] = 'Ништа није предато';
$string['submissionlog'] = 'Полазник: {$a->fullname}, Статус: {$a->status}';
$string['submissionmodified'] = 'Већ имате предате радове. Молим вас, напустите ову страницу и покушајте поново.';
$string['submissionmodifiedgroup'] = 'Неко други је изменио предати рад. Молим вас, напустите ову страницу и покушајте поново.';
$string['submissionnotcopiedinvalidstatus'] = 'Рад није копиран зато што је промењен од момента када је поново отворен.';
$string['submissionnoteditable'] = 'Полазници не могу да уређују овај задатак';
$string['submissionnotready'] = 'Овај задатак није спреман за предају радова:';
$string['submissionplugins'] = 'Додаци за предају радова';
$string['submissionreceipthtml'] = '<p>Предали сте свој рад за задатак \'<i>{$a->assignment}</i>\' </p>
<p>Можете видети статус свог <a href="{$a->url}">предатог рада</a>.</p>';
$string['submissionreceiptotherhtml'] = 'Ваш рад за задатак
\'<i>{$a->assignment}</i>\' је предат.<br /><br />
Можете да видите статус вашег <a href="{$a->url}">предатог рада</a>.';
$string['submissionreceiptothersmall'] = 'Ваш рад за задатак {$a->assignment} је предат.';
$string['submissionreceiptothertext'] = 'Ваш рад за задатак
\'<i>{$a->assignment}</i>\' је предат.

Можете да видите статус вашег предатог рада:

   {$a->url}';
$string['submissionreceipts'] = 'Пошаљи потврду о предатом раду';
$string['submissionreceiptsmall'] = 'Предали сте свој рад за задатак {$a->assignment}';
$string['submissionreceipttext'] = 'Предали сте свој рад за задатак \'{$a->assignment}</i>\'

Можете видети статус свог рада на следећој адреси:

   {$a->url}';
$string['submissions'] = 'Предати радови';
$string['submissionsclosed'] = 'Предаја радова је затворена';
$string['submissionsettings'] = 'Подешавања за предају рада';
$string['submissionslocked'] = 'Овај задатак не прихвата предају радова';
$string['submissionslockedshort'] = 'Промене предатих радова нису дозвољено';
$string['submissionsnotgraded'] = 'Неоцењени радови: {$a}';
$string['submissionstatement'] = 'Изјава о предаји рада';
$string['submissionstatementacceptedlog'] = 'Корисник {$a} је прихватио/ла изјаву о предаји рада';
$string['submissionstatementdefault'] = 'Овај рад је искључиво мој, осим сегмената у којима је експлицитно наглашено да су коришћени резултати других људи.';
$string['submissionstatement_help'] = 'Потврдна изјава о предаји рада';
$string['submissionstatus'] = 'Статус предатог рада';
$string['submissionstatus_'] = 'Нема предатих радова';
$string['submissionstatus_draft'] = 'Нацрт рада (није предато)';
$string['submissionstatusheading'] = 'Статус предатог рада';
$string['submissionstatus_marked'] = 'Оцењено';
$string['submissionstatus_new'] = 'Нови предати рад';
$string['submissionstatus_reopened'] = 'Поново отворено';
$string['submissionstatus_submitted'] = 'Предато за оцењивање';
$string['submissionsummary'] = '{$a->status}. Последњи пут промењено {$a->timemodified}';
$string['submissionteam'] = 'Група';
$string['submissiontypes'] = 'Врста предатог рада';
$string['submitaction'] = 'Предај';
$string['submitassignment'] = 'Predaj rad';
$string['submitassignment_help'] = 'Оног тренутка када предате овај рад више нећете моћи да га мењате.';
$string['submitforgrading'] = 'Предај на оцењивање';
$string['submitted'] = 'Предато';
$string['submittedearly'] = 'Задатак је предат {$a} раније';
$string['submittedlate'] = 'Задатак је предат {$a} касније';
$string['submittedlateshort'] = '{$a} касније';
$string['subplugintype_assignfeedback'] = 'Додатак за повратне информације';
$string['subplugintype_assignfeedback_plural'] = 'Додаци за повратне информација';
$string['subplugintype_assignsubmission'] = 'Додатак за предају рада';
$string['subplugintype_assignsubmission_plural'] = 'Додаци за предају рада';
$string['teamname'] = 'Тим: {$a}';
$string['teamsubmission'] = 'Полазници предају радове у групама';
$string['teamsubmissiongroupingid'] = 'Груписање за групе полазника';
$string['teamsubmissiongroupingid_help'] = 'Ово је груписање које ће Задатак користити како би пронашао групе за групе полазника. Уколико није подешено користиће се подразумевани скуп група.';
$string['teamsubmission_help'] = 'Ако је ова опција омогућена, полазници ће бити подељени у групе на основу подразумеваног скупа група или наменски прилагођеног груписања. Групни рад ће бити дељен између чланова групе и сви чланови групе ће видети промене у раду које буду унели други чланови групе.';
$string['textinstructions'] = 'Упутства за задатак';
$string['timemodified'] = 'Последње измене';
$string['timeremaining'] = 'Преостало време';
$string['timeremainingcolon'] = 'Преостало време: {$a}';
$string['togglezoom'] = 'Увећај/умањи регион';
$string['ungroupedusers'] = 'Подешавање \'Неопходна је група за предају рада\' је омогућено, али неки корисници нису чланови ниједне групе, или су чланови више од једне групе, тако да не могу да предају рад.';
$string['unlimitedattempts'] = 'Неограничено';
$string['unlimitedattemptsallowed'] = 'Неограничен број покушаја';
$string['unlimitedpages'] = 'Неограничено';
$string['unlocksubmissionforstudent'] = 'Дозволи предају радова за полазника: (id={$a->id}, име и презиме={$a->fullname}).';
$string['unlocksubmissions'] = 'Откључај предате радове';
$string['unsavedchanges'] = 'Несачуване промене';
$string['unsavedchangesquestion'] = 'Постоје промене оцена или повратних информација које нису сачуване. Да ли желите да сачувате промене и наставите даље?';
$string['updategrade'] = 'Ажурирај оцену';
$string['updatetable'] = 'Сачувај и ажурирај табелу';
$string['upgradenotimplemented'] = 'Надоградња није имплементирана у додатку ({$a->type} {$a->subtype})';
$string['userextensiondate'] = 'Продужетак је одобрен до: {$a}';
$string['usergrade'] = 'Водич за кориснике';
$string['useridlistnotcached'] = 'Измене оцена НИСУ сачуване јер систем није могао да утврди на који предати рад су се односиле.';
$string['useroverrides'] = 'Измене за кориснике';
$string['useroverridesdeleted'] = 'Измене за кориснике обрисане';
$string['usersnone'] = 'Ниједан полазник нема приступ овом задатку';
$string['userswhoneedtosubmit'] = 'Корисници који треба да предају решење: {$a}';
$string['validmarkingworkflowstates'] = 'Исправна стања тока оцењивања';
$string['viewadifferentattempt'] = 'Погледај други покушај';
$string['viewbatchmarkingallocation'] = 'Погледај страницу за групну доделу оцењивача.';
$string['viewbatchsetmarkingworkflowstate'] = 'Погледај страницу за групно подешавање тока оцењивања.';
$string['viewfeedback'] = 'Погледајте повратне информације';
$string['viewfeedbackforuser'] = 'Погледајте повратне информације за корисника {$a}';
$string['viewfull'] = 'Прикажи све';
$string['viewfullgradingpage'] = 'Отворите страницу за оцењивање у пуном формату како бисте дали повратне информације';
$string['viewgradebook'] = 'Погледај књигу оцена';
$string['viewgrading'] = 'Погледај све предате радове';
$string['viewgradingformforstudent'] = 'Погледајте страницу за оцењивање за  полазника: (id={$a->id}, fullname={$a->fullname}).';
$string['viewownsubmissionform'] = 'Погледајте страницу за предају сопственог рада';
$string['viewownsubmissionstatus'] = 'Погледајте страницу статуса сопственог рада';
$string['viewrevealidentitiesconfirm'] = 'Погледај страницу са потврдом за откривање идентитета полазника';
$string['viewsubmission'] = 'Погледај предати рад';
$string['viewsubmissionforuser'] = 'Погледај предати рад за корисника: {$a}';
$string['viewsubmissiongradingtable'] = 'Погледај табелу за оцењивање предатих радова';
$string['viewsummary'] = 'Прикажи сажетак';
$string['workflowfilter'] = 'Филтер тока оцењивања';
$string['xofy'] = '{$a->x} од {$a->y}';
