<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'attendance', language 'de', branch 'MOODLE_36_STABLE'
 *
 * @package   attendance
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['Aacronym'] = 'U';
$string['absenteereport'] = 'Abwesenheitsbericht';
$string['acronym'] = 'Abkürzung';
$string['add'] = 'Hinzufügen';
$string['addedrecip'] = '{$a} neue/n Empfänger/in hinzugefügt';
$string['addedrecips'] = '{$a} neue Empfänger/innen hinzugefügt';
$string['addmultiplesessions'] = 'Wiederkehrende Lerneinheiten';
$string['addsession'] = 'Lerneinheit hinzufügen';
$string['adduser'] = 'Teilnehmer/in hinzufügen';
$string['addwarning'] = 'Warnung hinzufügen';
$string['Afull'] = 'Unentschuldigt';
$string['all'] = 'Alle';
$string['allcourses'] = 'Alle Kurse';
$string['allpast'] = 'Alle vergangenen';
$string['allsessions'] = 'Alle Lerneinheiten';
$string['attendance:addinstance'] = 'Neue Anwesenheitsliste hinzufügen';
$string['attendance_already_submitted'] = 'Sie können keine Anwesenheit eintragen, die schon gesetzt wurde.';
$string['attendance:canbelisted'] = 'Erscheint in der Liste';
$string['attendance:changeattendances'] = 'Anwesenheit ändern';
$string['attendance:changepreferences'] = 'Einstellungen ändern';
$string['attendancedata'] = 'Anwesenheitsdaten';
$string['attendance:export'] = 'Berichte exportieren';
$string['attendanceforthecourse'] = 'Anwesenheit für den Kurs';
$string['attendancegrade'] = 'Anwesenheitshäufigkeit';
$string['attendance:manageattendances'] = 'Anwesenheit verwalten';
$string['attendance:managetemporaryusers'] = 'Temporäre Teilnehmer/innen verwalten';
$string['attendance_no_status'] = 'Es wurde kein gültiger Status gefunden - Sie könnten zu spät dran sein, um Ihre Anwesenheit zu erfassen.';
$string['attendancenotset'] = 'Sie müssen Ihre Anwesenheit eintragen';
$string['attendancenotstarted'] = 'Die Anwesenheitsliste für diesen Kurs startet zu einem späteren Zeitpunkt.';
$string['attendancepercent'] = 'Anwesend in Prozent';
$string['attendancereport'] = 'Bericht zu Anwesenheit';
$string['attendanceslogged'] = 'Erfasste Anwesenheiten';
$string['attendancestaken'] = 'Teilgenommene Anwesenheiten';
$string['attendancesuccess'] = 'Anwesenheitsliste gespeichert';
$string['attendance:takeattendances'] = 'Anwesenheit eintragen';
$string['attendanceupdated'] = 'Anwesenheitsliste geändert';
$string['attendance:view'] = 'Anwesenheit einsehen';
$string['attendance:viewreports'] = 'Berichte ansehen';
$string['attendance:viewsummaryreports'] = 'Zusammenfassenden Kursbericht ansehen';
$string['attendance:warningemails'] = 'Kann abonniert werden, um E-Mails über abwesende Teilnehmer/innen zu erhalten';
$string['attforblockdirstillexists'] = 'Das obsolete mod/attforblock Verzeichnis ist noch nicht gelöscht - Sie müssen dieses Verzeichnis löschen, bevor Sie dieses Upgrade durchführen können.';
$string['attrecords'] = 'Aufzeichnungen zur Anwesenheit';
$string['autoassignstatus'] = 'Automatisch den höchstmöglichen Status auswählen';
$string['autoassignstatus_help'] = 'Wenn dies ausgewählt ist, wird automatisch der höchstmögliche Status den Nutzer/innen zugewiesen.';
$string['automark'] = 'Automatische Bewertung';
$string['automarkall'] = 'Ja';
$string['automarkclose'] = 'Am Ende der Lerneinheit auf nicht bewertet setzen';
$string['automark_help'] = 'Automatische Statusänderung erlauben
Wenn diese Einstellung auf "Ja" gesetzt ist, erhalten die Nutzer/innen automatisch den Status in Abhängigkeit Ihres Erstzugriffs auf den Kurs.
Wenn die Einstellung auf "Am Ende der Lerneinheit auf nicht bewertet setzen" gesetzt ist, wird bei jedem Nutzenden, der seine / ihre Anwesenheit noch nicht erfasst hat, der nicht bewertete Status gesetzt.';
$string['automarktask'] = 'Auf Lerneinheiten überprüfen, die automatische Markierung voraussetzen';
$string['autorecorded'] = 'Vom System automatisch erfasst';
$string['averageattendance'] = 'Durchschnittliche Anwesenheit';
$string['averageattendancegraded'] = 'Durchschnittliche Anwesenheit';
$string['backtoparticipants'] = 'Zurück zur Teilnehmerliste';
$string['below'] = 'Unter {$a}%';
$string['calclose'] = 'Schließen';
$string['calendarevent'] = 'Kalenderereignis für diese Sitzung erzeugen';
$string['calendarevent_help'] = 'Wenn aktiviert, dann wird ein Kalenderereignis für diese Lerneinheit erzeugt.
Wenn deaktiviert, dann werden alle bisher existierenden Kalenderereignisse für diese Lerneinheit gelöscht.';
$string['caleventcreated'] = 'Kalendereinträge für die Lerneinheit erfolgreich erstellt';
$string['caleventdeleted'] = 'Kalendereinträge für die Lerneinheit erfolgreich gelöscht';
$string['calmonths'] = 'Januar,Februar,März,April,Mai,Juni,Juli,August,September,Oktober,November,Dezember';
$string['calshow'] = 'Datum auswählen';
$string['caltoday'] = 'Heute';
$string['calweekdays'] = 'So,Mo,Die,Mi,Do,Fr,Sa';
$string['cannottakeforgroup'] = 'Sie können für die Gruppe \'{$a}\' keine Anwesenheiten erfassen';
$string['cantaddstatus'] = 'Sie müssen eine Abkürzung und eine Beschreibung hinzufügen, wenn Sie einen neuen Status definieren.';
$string['categoryreport'] = 'Kurskategorie Bericht';
$string['changeattendance'] = 'Anwesenheit ändern';
$string['changeduration'] = 'Dauer ändern';
$string['changesession'] = 'Lerneinheiten ändern';
$string['checkweekdays'] = 'Wählen Sie die Wochentage aus, die in Ihre gewählte Zeitspanne der Lerneinheiten fallen.';
$string['closed'] = 'Diese Sitzung steht gerade nicht zur Selbsterfassung zur Verfügung';
$string['column'] = 'Spalte';
$string['columns'] = 'Spalten';
$string['commonsession'] = 'Alle Teilnehmer/innen';
$string['commonsessions'] = 'Alle Teilnehmer/innen';
$string['confirm'] = 'Bestätigen';
$string['confirmcolumnmappings'] = 'Spaltenzuweisungen bestätigen';
$string['confirmdeletehiddensessions'] = 'Sind Sie sicher, dass Sie {$a->count} Lerneinheiten, die vor dem Kursbeginn ({$a->date}) geplant sind, löschen möchten?';
$string['confirmdeleteuser'] = 'Sind Sie sicher, dass Sie Teilnehmer/in \'{$a->fullname}\' ({$a->email}) löschen möchten? <br/> Alle Aufzeichnungen der Anwesenheit werden dabei für diese/n Teilnehmer/in dauerhaft gelöscht.';
$string['copyfrom'] = 'Daten zur Anwesenheit kopieren von';
$string['countofselected'] = 'Anzahl markierter Objekte';
$string['course'] = 'Kurs';
$string['coursemessage'] = 'Teilnehmer/innen anschreiben';
$string['coursesummary'] = 'Zusammenfassender Kursbericht';
$string['createmultiplesessions'] = 'Lerneinheiten-Reihe erstellen';
$string['createmultiplesessions_help'] = 'Diese Funktion ermöglicht Ihnen, wiederkehrende Lerneinheiten in einem Schritt zu erstellen. Die Lerneinheiten starten an dem Tag der oben definierten Einheit und wiederholen sich bis zum Ende des angegebenen \'Wiederholen bis\'-Datums.

  * <strong>Wiederholen am</strong>: Wählen Sie die Wochentage aus, wann Ihre Veranstaltung stattfindet (zum Beispiel Montag/Mittwoch/Freitag).
  * <strong>Wiederholen alle</strong>: Dies erlaubt das Setzen einer Terminfrequenz. Wenn Ihre Veranstaltung wöchentlich stattfindet, wählen Sie 1;  wenn sie alle zwei Wochen stattfindet, wählen Sie 2; alle drei Wochen, wählen Sie 3, und so weiter.
  * <strong>Wiederholen bis</strong>: Wählen Sie den letzten Tag der Veranstaltung (den letzen Tag, an dem Sie die Anwesenheit erfassen möchten).';
$string['createonesession'] = 'Lerneinheit für diesen Kurs erstellen';
$string['csvdelimiter'] = 'CSV Trennzeichen';
$string['currentlyselectedusers'] = 'Zur Zeit ausgewählte Nutzer/innen';
$string['date'] = 'Datum';
$string['days'] = 'Tage';
$string['defaultdisplaymode'] = 'Standardmäßiger Anzeigemodus';
$string['defaults'] = 'Voreinstellungen';
$string['defaultsessionsettings'] = 'Standardmäßige Einstellungen zur Lerneinheit';
$string['defaultsessionsettings_help'] = 'Diese Einstellungen definieren den Standard für alle neuen Lerneinheiten';
$string['defaultsettings'] = 'Standardmäßige Einstellungen zur Anwesenheit';
$string['defaultsettings_help'] = 'Diese Einstellungen definieren den Standard für alle neuen Anwesenheiten';
$string['defaultstatus'] = 'Standardmäßiger Statussatz';
$string['defaultsubnet'] = 'Standardmäßige Netzwerkadresse';
$string['defaultsubnet_help'] = 'Die Erfassung von Anwesenheiten kann auf bestimmte Subnetze beschränkt werden. Dazu listen Sie die vollen oder Teil-IP-Adressen in einer Komma separierten Liste auf. Dies ist der Standardwert, wenn neue Lerneinheiten erstellt werden.';
$string['defaultview'] = 'Standardansicht beim Login';
$string['defaultview_desc'] = 'Dies ist die standardmäßige Ansicht für Trainer/innen beim ersten Login.';
$string['defaultwarnings'] = 'Standardmäßiger Katalog für Warnungen';
$string['defaultwarningsettings'] = 'Standardmäßige Einstellungen für Warnungen';
$string['defaultwarningsettings_help'] = 'Diese Einstellungen legen den Standard für alle neuen Warnungen fest';
$string['delete'] = 'löschen';
$string['deletecheckfull'] = 'Möchten Sie wirklich {$a} inklusive aller Nutzerdaten löschen?';
$string['deletedgroup'] = 'Die Gruppe, die dieser Lerneinheit zugewiesen wurde, ist gelöscht worden';
$string['deletehiddensessions'] = 'Alle versteckten Lerneinheiten löschen';
$string['deletelogs'] = 'Daten zur Anwesenheit löschen';
$string['deleteselected'] = 'Ausgewählte Objekte löschen.';
$string['deletesession'] = 'Lerneinheit löschen';
$string['deletesessions'] = 'Alle Lerneinheiten löschen';
$string['deleteuser'] = 'Teilnehmer/in löschen';
$string['deletewarningconfirm'] = 'Sind Sie sicher, dass Sie diese Warnung löschen möchten?';
$string['deletingsession'] = 'Lerneinheit dieses Kurses wird gelöscht.';
$string['deletingstatus'] = 'Status dieses Kurses wird gelöscht.';
$string['description'] = 'Beschreibung';
$string['display'] = 'Anzeige';
$string['displaymode'] = 'Anzeigemodus';
$string['donotusepaging'] = 'Seitenaufteilung nicht verwenden';
$string['downloadexcel'] = 'Excel-Datei (.xls) herunterladen';
$string['downloadooo'] = 'OpenOffice-Datei (.ods) herunterladen';
$string['downloadtext'] = 'Textdatei (.txt) herunterladen';
$string['duration'] = 'Dauer';
$string['Eacronym'] = 'E';
$string['editsession'] = 'Lerneinheit bearbeiten';
$string['edituser'] = 'Teilnehmer/in bearbeiten';
$string['Efull'] = 'Entschuldigt';
$string['emailcontent'] = 'Inhalt der E-Mail';
$string['emailcontent_default'] = 'Hallo %userfirstname%,
Ihre Anwesenheit %attendencename% im Kurs %coursename% ist unter die kritische Anwesenheitsschwelle %warningpercent% gefallen und beträgt zur Zeit %percent%.
Wir hoffen, dass es Ihnen gut geht.

Um das Beste aus diesem Kurs herauszuholen, sollten Sie Ihre Anwesenheit erhöhen. Bitte melden Sie sich, falls Sie zusätzliche Unterstützung benötigen.';
$string['emailcontent_help'] = 'Wenn eine Warnung an eine/n Teilnehmer/in verschickt wird, wird der Inhalt der E-Mail aus dieser Einstellung eingefügt. Folgende Platzhalter können verwendet werden:
<ul>
<li>%coursename%</li>
<li>%userfirstname%</li>
<li>%userlastname%</li>
<li>%userid%</li>
<li>%warningpercent%</li>
<li>%attendancename%</li>
<li>%cmid%</li>
<li>%numtakensessions%</li>
<li>%points%</li>
<li>%maxpoints%</li>
<li>%percent%</li>
</ul>';
$string['emailsubject'] = 'Betreff der E-Mail';
$string['emailsubject_default'] = 'Anwesenheitswarnung';
$string['emailsubject_help'] = 'Beim Senden einer Warnung an Teilnehmer/innen wird der Betreff aus diesem Feld verwendet.';
$string['emailuser'] = 'E-Mail an Nutzer/in';
$string['emailuser_help'] = 'Wenn dies aktiviert ist, wird eine Warnung an Teilnehmer/innen gesendet.';
$string['emptyacronym'] = 'Leere Akronyme sind nicht erlaubt. Der Statuseintrag wurde nicht aktualisiert.';
$string['emptydescription'] = 'Leere Beschreibungen sind nicht erlaubt. Der Statuseintrag wurde nicht aktualisiert.';
$string['enablecalendar'] = 'Kalenderereignis erstellen';
$string['enablecalendar_desc'] = 'Wenn dies aktiviert wird, wird ein Kalenderereignis für jede Lerneinheit erzeugt. Nach Änderungen an dieser Einstellung, sollten Sie den Bericht zum Zurücksetzen des Kalenders laufen lassen.';
$string['enablewarnings'] = 'Warnungen aktivieren';
$string['enablewarnings_desc'] = 'Dies erlaubt es, eine Warnung für eine Anwesenheitsaktivität festzulegen, die als E-Mail-Benachrichtigung an Teilnehmer/innen geschickt wird, wenn diese unter die definierte Anwesenheitsschwelle fallen. <br/><strong>WARNUNG: Dies ist eine neue Funktionalität und wurde noch nicht ausführlich getestet. Die Nutzung erfolgt auf eigenes Risiko. Bitte geben Sie Rückmeldung in den Moodle Foren, wenn Sie der Ansicht sind, dass dies gut funktioniert.</strong>';
$string['encoding'] = 'Kodierung';
$string['endofperiod'] = 'Ende des Zeitraums';
$string['endtime'] = 'Ende der Lerneinheit';
$string['enrolmentend'] = 'Einschreibung endet: {$a}';
$string['enrolmentstart'] = 'Einschreibung beginnt: {$a}';
$string['enrolmentsuspended'] = 'Einschreibung unterbrochen';
$string['enterpassword'] = 'Kennwort eingeben';
$string['error:coursehasnoattendance'] = 'Der Kurs mit dem Kurznamen {$a} hat keine Aktivitäten des Typs Anwesenheit.';
$string['error:coursenotfound'] = 'Ein Kurs mit dem Kurznamen {$a} kann nicht gefunden werden.';
$string['errorgroupsnotselected'] = 'Wählen Sie eine oder mehrere Gruppen aus';
$string['errorinaddingsession'] = 'Fehler beim Hinzufügen der Lerneinheit';
$string['erroringeneratingsessions'] = 'Fehler beim Erstellen der Lerneinheit';
$string['error:qrcode'] = '"Teilnehmer/innen erlauben, die eigene Anwesenheit zu erfassen" muss aktiviert sein, um den QR-Code nutzen zu können! Überspringen.';
$string['error:sessioncourseinvalid'] = 'Ein Kurs einer Lerneinheit ist ungültig! Überspringen.';
$string['error:sessiondateinvalid'] = 'Ein Datum einer Lerneinheit ist ungültig! Überspringen.';
$string['error:sessionendinvalid'] = 'Eine Endzeit einer Lerneinheit ist ungültig! Überspringen.';
$string['error:sessionstartinvalid'] = 'Eine Startzeit einer Lerneinheit ist ungültig! Überspringen.';
$string['eventdurationupdated'] = 'Die Dauer der Lerneinheit wurde aktualisiert';
$string['eventreportviewed'] = 'Report angesehen';
$string['eventscreated'] = 'Kalenderereignisse wurden erzeugt';
$string['eventsdeleted'] = 'Kalenderereignisse wurden gelöscht';
$string['eventsessionadded'] = 'Lerneinheit hinzugefügt';
$string['eventsessiondeleted'] = 'Lerneinheit gelöscht';
$string['eventsessionipshared'] = 'IP-Konflikt bei der Selbsterfassung der Anwesenheit';
$string['eventsessionsimported'] = 'Lerneinheiten wurden importiert';
$string['eventsessionupdated'] = 'Lerneinheit aktualisiert';
$string['eventstatusadded'] = 'Status hinzugefügt';
$string['eventstatusupdated'] = 'Status aktualisiert';
$string['eventtaken'] = 'Anwesenheit erfasst';
$string['eventtakenbystudent'] = 'Anwesenheit durch Teilnehmer/in erfasst';
$string['export'] = 'Export';
$string['extrarestrictions'] = 'Zusätzliche Einschränkungen';
$string['formattexttype'] = 'Formatieren';
$string['from'] = 'von:';
$string['gradebookexplanation'] = 'In der Bewertung eintragen';
$string['gradebookexplanation_help'] = 'Das Modul \'Anwesenheit\' zeigt Ihre Anwesenheitsbewertung auf Grund der Punkte, welche Sie bisher gesammelt haben im Vergleich zur bisher möglichen Punktzahl (zukünftige Lektionen sind nicht berücksichtigt). Ihre Kursbewertung hingegen zeigt die Anwesenheitsbewertung im Vergleich zur Maximalpunktzahl am Ende des Kurses (mit allen zukünftigen Lektionen). Die beiden Bewertungen können also unterschiedlich sein, beruhen aber auf dem selben Prozentwert.

Haben Sie z.B. bisher 8 von 10 Punkten (80% Anwesenheit) bei Halbzeit eines Kurses, der 50 Punkte Wert ist, zeigt die Anwesenheitsbewertung 8/10 und die Kursbewertung 16/20. Die 16 Punkte werden Sie nur erhalten, wenn Ihre Anwesenheit bei 80% bleibt. Sie wird aber steigen oder fallen, je nachdem, wie häufig Sie bis zum Kursende noch anwesend sein werden.';
$string['graded'] = 'Bewertete Lerneinheiten';
$string['gridcolumns'] = 'Tabellenspalten';
$string['group'] = 'Gruppe';
$string['groups'] = 'Gruppen';
$string['groupsession'] = 'Teilnehmergruppe';
$string['hiddensessions'] = 'Versteckte Lerneinheiten';
$string['hiddensessionsdeleted'] = 'Alle versteckten Lerneinheiten wurden gelöscht';
$string['hiddensessions_help'] = 'Eine Lerneinheit wird versteckt, wenn der Kursbeginn nach dem Datum der Lerneinheit gesetzt ist. Sie können damit ältere Lerneinheiten verstecken, wenn Sie sie nicht löschen wollen. Beachten Sie, dass Sie in der Bewertung angeben, nur die sichtbaren Lektionen in die Bewertung einzubeziehen.';
$string['hideextrauserdetails'] = 'Zusätzliche Nutzerdetails verbergen';
$string['hidensessiondetails'] = 'Verberge Details zur Lerneinheit';
$string['identifyby'] = 'Teilnehmer/innen auswählen nach';
$string['import'] = 'Import';
$string['importfile'] = 'Importdatei';
$string['importfile_help'] = 'Importdatei';
$string['importsessions'] = 'Lerneinheiten importieren';
$string['includeabsentee'] = 'Lerneinheiten für die Erstellung des Abwesenheitsberichts einbeziehen';
$string['includeabsentee_help'] = 'Wenn dies ausgewählt ist, wird diese Lerneinheit in den Abwesenheitsbericht einbezogen.';
$string['includeall'] = 'Alle Lerneinheiten auswählen';
$string['includenottaken'] = 'Nicht belegte Lerneinheiten einbeziehen';
$string['includeqrcode'] = 'QR-Code einbeziehen';
$string['includeremarks'] = 'Bemerkungen einschließen';
$string['incorrectpassword'] = 'Sie haben ein ungültiges Passwort eingegeben. Damit wurde Ihre Anwesenheit nicht erfasst. Bitte geben Sie das korrekte Passwort ein.';
$string['incorrectpasswordshort'] = 'Falsches Kennwort. Die Anwesenheit wurde nicht erfasst.';
$string['indetail'] = 'Detaillierter ...';
$string['invalidaction'] = 'Sie müssen eine Aktion auswählen';
$string['invalidemails'] = 'Sie müssen gültige Nutzeraccounts als Empfänger eingeben. Folgende Nutzer/innen konnten nicht gefunden werden: {$a}';
$string['invalidimportfile'] = 'Dateiformat ist ungültig.';
$string['invalidsessionenddate'] = 'Dieses Datum kann nicht vor dem Startzeitpunkt liegen';
$string['invalidsessionendtime'] = 'Das Ende muss größer als die Startzeit sein';
$string['invalidstatus'] = 'Sie haben einen ungültigen Status ausgewählt, bitte versuchen Sie es erneut';
$string['iptimemissing'] = 'Ungültige Minuten für Freigabe';
$string['jumpto'] = 'Direkt zu ...';
$string['keepsearching'] = 'Suche fortsetzen';
$string['Lacronym'] = 'V';
$string['Lfull'] = 'Verspätet';
$string['maxpossible'] = 'Mögliches Maximum';
$string['maxpossible_help'] = 'Zeigt die Punktzahl an, die jede/r Teilnehmer/in noch erreichen kann, wenn diese/r die Maximalpunkte für jede Lerneinheit, die noch nicht stattgefunden hat, erhält.
    <ul>
    <li><strong>Punkte</strong>: Maximal mögliche Punkte, die über alle Lerneinheiten erreicht werden können.</li>
    <li><strong>Prozentsatz</strong>: Maximaler Prozentsatz, der über alle Lerneinheiten erreicht werden kann.</li>
    </ul>';
$string['maxpossiblepercentage'] = 'Maximaler Prozentsatz';
$string['maxpossiblepoints'] = 'Maximale Punktzahl';
$string['maxwarn'] = 'Maximale Zahl an E-Mail-Warnungen';
$string['maxwarn_help'] = 'Maximale Anzahl an Warnungen, die versendet werden sollen (es wird nur eine Warnung pro Lerneinheit verschickt)';
$string['mergeuser'] = 'Teilnehmer/in zusammenführen';
$string['modulename'] = 'Anwesenheit';
$string['modulename_help'] = 'Das Modul \'Anwesenheit\' ermöglicht die Erfassung von An- und Abwesenheiten und verschafft Teilnehmer/innen einen Überblick über ihre bisherige Teilnahme.

Trainer/innen können eine Serie von Lerneinheiten anlegen und die Teilnehmer/innen darin jeweils mit \'Anwesend\', \'Verspätet\', \'Entschuldigt\' und \'Unentschuldigt\' erfassen.

Berichte können für einzelne Teilnehmer/innen oder für ganze Lerngruppen erzeugt werden.';
$string['modulenameplural'] = 'Anwesenheit';
$string['months'] = 'Monate';
$string['moreattendance'] = 'Anwesenheit für diese Seite wurde erfolgreich erfasst';
$string['moveleft'] = 'Nach links schieben';
$string['moveright'] = 'Nach rechts schieben';
$string['multisessionexpanded'] = 'Wiederkehrende Lerneinheiten ausklappen';
$string['multisessionexpanded_desc'] = 'Wenn neue Lerneinheiten hinzugefügt werden, wird der Abschnitt "Wiederkehrende Lerneinheiten" standardmäßig ausgeklappt angezeigt.';
$string['mustselectusers'] = 'Sie müssen Teilnehmer/innen für den Export auswählen';
$string['newdate'] = 'Neues Datum';
$string['newduration'] = 'Neue Dauer';
$string['newstatusset'] = 'Neuer Statussatz';
$string['noabsentstatusset'] = 'Der verwendete Statuskatalog hat keinen Status, der genutzt werden kann, wenn keine Bewertung stattgefunden hat.';
$string['noattendanceusers'] = 'Es ist nicht möglich, Daten zu exportieren weil keine Teilnehmer/innen im Kurs eingeschrieben sind.';
$string['noattforuser'] = 'Für diese/n Teilnehmer/in gibt es keine Anwesenheitsdaten.';
$string['noautomark'] = 'Deaktiviert';
$string['nodescription'] = 'Lerneinheit für den gesamten Kurs';
$string['noeventstoreset'] = 'Es gibt keine Kalenderereignisse, die eine Aktualisierung benötigen.';
$string['nogroups'] = 'Sie können keine Gruppen-Lerneinheiten hinzufügen, denn für diesen Kurs sind keine Gruppen vorhanden.';
$string['noguest'] = 'Gäste dürfen keine Anwesenheitsdaten einsehen.';
$string['noofdaysabsent'] = 'Zahl der Tage unentschuldigt';
$string['noofdaysexcused'] = 'Zahl der Tage entschuldigt';
$string['noofdayslate'] = 'Zahl der Tage verspätet';
$string['noofdayspresent'] = 'Zahl der Tage anwesend';
$string['nosessiondayselected'] = 'Es wurde kein Tag ausgewählt, an dem eine Lerneinheit stattfindet.';
$string['nosessionexists'] = 'Für diesen Kurs sind keine Lerneinheiten erfasst.';
$string['nosessionsselected'] = 'Keine Lerneinheiten ausgewählt';
$string['notfound'] = 'Für diesen Kurs gibt es keine Anwesenheitsliste!';
$string['notifytask'] = 'Warnungen an Nutzer/innen verschicken';
$string['notmember'] = 'kein Mitglied';
$string['noupgradefromthisversion'] = 'Das Update des Moduls \'attforblock\' zum Modul \'Anwesenheit\' kann nicht ausgeführt werden. Bitte löschen Sie attforblock oder aktualisieren Sie es auf die neueste Version, bevor Sie das neue Modul \'Anwesenheit\' installieren.';
$string['numsessions'] = 'Anzahl der Lerneinheiten';
$string['olddate'] = 'Vormaliges Datum';
$string['onlyselectedusers'] = 'Ausgewählte Nutzer/innen exportieren';
$string['overallsessions'] = 'Über alle Lerneinheiten';
$string['overallsessions_help'] = 'Zeigt die Statistik für alle Lerneinheiten inklusive der noch nicht stattgefundenen (der Vergangenheit und Zukunft):
    <ul>
    <li><strong>Lerneinheiten</strong>: Gesamtzahl der Lerneinheiten.</li>
    <li><strong>Punkte</strong>: Erhaltene Punkte basierend auf den besuchten Lerneinheiten.</li>
    <li><strong>Prozentsatz</strong>: Prozentsatz der erhaltenen Punkte über die maximal mögliche Punktzahl aller Lerneinheiten.</li>
    </ul>';
$string['oversessionstaken'] = 'Über stattgefundene Lerneinheiten';
$string['oversessionstaken_help'] = 'Zeigt die Statistik für die Lerneinheiten, bei denen Anwesenheiten eingetragen wurden:
    <ul>
    <li><strong>Lerneinheiten</strong>: Anzahl der bereits stattgefundenen Lerneinheiten.</li>
    <li><strong>Punkte</strong>: Erhaltene Punkte auf Basis der stattgefundenen Lerneinheiten.</li>
    <li><strong>Prozentsatz</strong>: Prozentsatz der erhaltenen Punkte über die maximal mögliche Punktzahl der stattgefundenen Lerneinheiten.</li>
    </ul>';
$string['Pacronym'] = 'A';
$string['participant'] = 'Teilnehmer/in';
$string['password'] = 'Passwort';
$string['passwordgrp'] = 'Passwort für Teilnehmer/innen';
$string['passwordgrp_help'] = 'Wenn dies gesetzt ist, müssen Teilnehmer/innen erst dieses Passwort eingeben, bevor sie ihre Anwesenheit für die Lerneinheit erfassen können. Wenn Sie dieses Feld leer lassen, wird kein Passwort abgefragt.';
$string['passwordrequired'] = 'Sie müssen das Passwort für diese Lerneinheit eingeben, bevor Sie Ihre Anwesenheit dafür erfassen können.';
$string['percentage'] = 'Prozentsatz';
$string['percentageallsessions'] = 'Prozentsatz über alle Lerneinheiten';
$string['percentagesessionscompleted'] = 'Prozentsatz über die abgehaltenen Lerneinheiten';
$string['Pfull'] = 'Anwesend';
$string['pluginadministration'] = 'Verwaltung der Anwesenheit';
$string['pluginname'] = 'Anwesenheit';
$string['points'] = 'Punkte';
$string['pointsallsessions'] = 'Punkte über alle Lerneinheiten';
$string['pointssessionscompleted'] = 'Punkte über die abgehaltenen Lerneinheiten';
$string['preferences_desc'] = 'Änderungen';
$string['preventsharederror'] = 'Die Selbsterfassung wurde für eine Sitzung deaktiviert, weil es so aussieht, dass dieses Endgerät bereits zur Erfassung der Anwesenheit einer anderen Person genutzt wurde.';
$string['preventsharedip'] = 'Verhindern, dass Teilnehmer/innen eine IP-Adresse miteinander teilen können';
$string['preventsharedip_help'] = 'Verhindern, dass Teilnehmer/innen dasselbe Endgerät (über die IP-Adresse identifiziert) nutzen, um die Anwesenheit für andere zu erfassen.';
$string['preventsharediptime'] = 'Zeit, nach der die IP-Adresse wieder verwendet werden kann (Minuten)';
$string['preventsharediptime_help'] = 'Erlaubt es, eine IP-Adresse, die für die Erfassung einer Anwesenheit verwendet wurde, nach Ablauf dieser Zeit wieder zu verwenden.';
$string['priorto'] = 'Das Datum der Lerneinheit liegt vor dem Kursbeginn ({$a}), weswegen neue Einheiten, die vor diesem Datum terminiert sind, verborgen (nicht erreichbar) sind. Sie können das Startdatum des Kurses jederzeit in den Kurseinstellungen ändern, um auf diese Lerneinheit zugreifen zu können. <br> Bitte ändern Sie das Datum der Lerneinheit oder bestätigen Sie mit einem Klick auf den Button "Hinzufügen". <br>';
$string['privacy:metadata:attendancelog'] = 'Log der Nutzeranwesenheiten aufgezeichnet.';
$string['privacy:metadata:attendancesessions'] = 'Sitzungen für die die Anwesenheit erfasst wird.';
$string['privacy:metadata:attendancewarningdone'] = 'Log für Warnungen, die an Nutzer/innen über deren Anwesenheitseintrag versendet wurden.';
$string['privacy:metadata:duration'] = 'Sitzungsdauer in Sekunden';
$string['privacy:metadata:groupid'] = 'Gruppen-ID, die mit der Session verknüpft ist.';
$string['privacy:metadata:ipaddress'] = 'IP-Adresse mit der die Anwesenheit erfasst wurde.';
$string['privacy:metadata:lasttaken'] = 'Zeitstempel wann eine Anwesenheitssitzung zuletzt besucht wurde.';
$string['privacy:metadata:lasttakenby'] = 'Nutzer-ID des/der Nutzers/Nutzerin, der/die in dieser Sitzung zuletzt die Anwesenheit erfasst hat';
$string['privacy:metadata:notifyid'] = 'Sitzung-ID einer Anwesenheit, für die eine Warnung vorliegt.';
$string['privacy:metadata:remarks'] = 'Kommentare zu der Anwesenheit eines/einer Nutzers/Nutzerin.';
$string['privacy:metadata:sessdate'] = 'Zeitstempel wann die Sitzung beginnt.';
$string['privacy:metadata:sessionid'] = 'Session-ID der Anwesenheit.';
$string['privacy:metadata:statusid'] = 'ID des Anwesenheitsstatus eines Teilnehmenden.';
$string['privacy:metadata:statusset'] = 'Statuskatalog zu der eine Status-ID gehört.';
$string['privacy:metadata:studentid'] = 'ID des/der Teilnehmer/in, der/die die Anwesenheit erfasst hat.';
$string['privacy:metadata:takenby'] = 'Nutzer-ID des/der Nutzers/Nutzerin, der/die Anwesenheit für den/die Teilnehmer/in erfasst hat.';
$string['privacy:metadata:timemodified'] = 'Zeitstempel wann die Sitzung zuletzt geändert wurde';
$string['privacy:metadata:timesent'] = 'Zeitstempel der verschickten Warnung.';
$string['privacy:metadata:timetaken'] = 'Zeitstempel wann die Anwesenheit für den/die Teilnehmer/in erfasst wurde.';
$string['privacy:metadata:userid'] = 'Nutzer-ID an die die Warnung versendet wird.';
$string['processingfile'] = 'Datei wird verarbeitet';
$string['qrcode'] = 'QR-Code';
$string['randompassword'] = 'Zufälliges Passwort';
$string['remark'] = 'Bemerkung für: {a}';
$string['remarks'] = 'Bemerkungen';
$string['repeatasfollows'] = 'Die obige Lerneinheit wie folgt wiederholen';
$string['repeatevery'] = 'Wiederholen alle';
$string['repeaton'] = 'Wiederholen am';
$string['repeatuntil'] = 'Wiederholen bis';
$string['report'] = 'Bericht';
$string['required'] = 'Erforderlich*';
$string['requiredentries'] = 'Temporäre Einträge überschreiben die Anwesenheitsaufzeichnungen von den Teilnehmer/innen';
$string['requiredentry'] = 'Hilfestellung zur Zusammenführung von temporären Teilnehmer/innen';
$string['requiredentry_help'] = '<p align="center"><b>Anwesenheit</b></p>
<p align="left"><strong>Nutzerkonten zusammenführen</strong></p>
<p align="left">
<table border="2" cellpadding="4">
<tr>
<th>Moodle Teilnehmer/in</th>
<th>Temporäre/r Nutzer/in</th>
<th>Aktion</th>
</tr>
<tr>
<td>Anwesenheiten</td>
<td>Anwesenheiten</td>
<td>Temporäre/r Nutzer/in wird den/die Moodle Teilnehmer/in überschreiben</td>
</tr>
<tr>
<td>Keine Anwesenheiten</td>
<td>Anwesenheiten</td>
<td>Die temporären Anwesenheiten werden auf den Moodle Teilnehmer übertragen</td>
</tr>
<tr>
<td>Anwesenheiten</td>
<td>Keine Anwesenheiten</td>
<td>Temporäre/r Nutzer/in wird gelöscht</td>
</tr>
<tr>
<td>Keine Anwesenheiten</td>
<td>Keine Anwesenheiten</td>
<td>Temporäre/r Nutzer/in wird gelöscht</td>
</tr>
</table>

</p>
<p align="left"><strong>Temporäre/r Nutzer/in wird auf jeden Fall nach der Zusammenführung gelöscht.</strong></p>';
$string['requiresubnet'] = 'Teilnehmer/innen können die eigene Anwesenheit nur von diesen Rechnern aus eintragen.';
$string['requiresubnet_help'] = 'Die Eintragung der Anwesenheit kann für bestimmte Subnetze mittels einer kommasseparierten Liste von vollständigen oder Teil-IP-Adressen eingeschränkt werden.';
$string['resetcaledarcreate'] = 'Kalenderereignisse wurden aktiviert, aber einige bestehende Lerneinheiten haben noch keine entsprechenden Ereignisse. Möchten Sie Kalenderereignisse für alle bestehenden Lerneinheiten erstellen?';
$string['resetcaledardelete'] = 'Kalenderereignisse wurden deaktiviert, aber einige bestehende Lerneinheiten haben entsprechende Ereignisse, die gelöscht werden sollten. Möchten Sie alle bestehenden Ereignisse löschen?';
$string['resetcalendar'] = 'Kalender zurücksetzen';
$string['resetdescription'] = 'Beachten Sie, dass beim Löschen von Anwesenheits-Daten auch die Datenbankinformation geändert wird. Sie können ältere Lerneinheiten einfach verbergen, wenn Sie den Beginn des Kurses verschoben haben!';
$string['resetstatuses'] = 'Alle Status auf die Voreinstellungen zurücksetzen';
$string['restoredefaults'] = 'Voreinstellungen wieder herstellen';
$string['resultsperpage'] = 'Ergebnisse pro Seite';
$string['resultsperpage_desc'] = 'Anzahl der Teilnehmer/innen pro Seite';
$string['save'] = 'Anwesenheit speichern';
$string['search:activity'] = 'Anwesenheit - Information zur Aktivität';
$string['session'] = 'Lerneinheit';
$string['sessionadded'] = 'Lerneinheit hinzugefügt';
$string['sessionalreadyexists'] = 'Für dieses Datum gibt es bereits eine Lerneinheit';
$string['sessiondate'] = 'Datum';
$string['sessiondays'] = 'Tage mit Lerneinheiten';
$string['sessiondeleted'] = 'Lerneinheit gelöscht';
$string['sessionduplicate'] = 'Es existiert bereits eine duplizierte Lerneinheit für den Kurs {$a->course} in der Anwesenheit: {$a->activity}';
$string['sessionexist'] = 'Lerneinheit nicht hinzugefügt, da sie bereits existiert.';
$string['sessiongenerated'] = 'Eine Lerneinheit wurde erfolgreich erzeugt';
$string['session_help'] = 'Lerneinheit';
$string['sessions'] = 'Lerneinheiten';
$string['sessionscompleted'] = 'Abgehaltene Lerneinheiten';
$string['sessionsgenerated'] = '{$a} Lerneinheiten wurden erfolgreich erzeugt';
$string['sessionsids'] = 'IDs der Lerneinheiten:';
$string['sessionsnotfound'] = 'Im gewählten Zeitraum sind keine Lerneinheiten erfasst.';
$string['sessionstartdate'] = 'Anfangsdatum';
$string['sessionstotal'] = 'Gesamtzahl der Lerneinheiten';
$string['sessiontype'] = 'Art';
$string['sessiontype_help'] = 'Sie können Lerneinheiten für alle Teilnehmer/innen oder für Gruppen hinzufügen. Die verschiedenen Arten hängen von dem Gruppenmodus der Aktivität ab.

* Im Modus "Keine Gruppen" können Sie nur Lerneinheiten für alle Teilnehmer/innen erstellen.
* Im Modus "Getrennte Gruppen" können Sie nur Lerneinheiten für Gruppen erstellen.
* Im Modus "Sichtbare Gruppen" können Sie beide Arten an Lerneinheiten anlegen.';
$string['sessiontypeshort'] = 'Typ';
$string['sessionunknowngroup'] = 'Eine Lerneinheit hat unbekannte Gruppen: {$a}';
$string['sessionupdated'] = 'Lerneinheit geändert';
$string['setallstatuses'] = 'Status für alle Teilnehmer/innen übernehmen';
$string['setallstatusesto'] = 'Status «{$a}» für alle Teilnehmer/innen setzen';
$string['set_by_student'] = 'Selbst eingetragen';
$string['setperiod'] = 'Eingestellte Zeit in Minuten, um die IP wieder freizugeben';
$string['settings'] = 'Einstellungen';
$string['setunmarked'] = 'Dies automatisch setzen, wenn nicht ausgewählt';
$string['setunmarked_help'] = 'Wenn dies in der Lerneinheit aktiviert ist, wird dieser Status gesetzt, wenn ein/e Teilnehmer/in seine/ihre Anwesenheit nicht erfasst hat.';
$string['showdefaults'] = 'Voreinstellungen anzeigen';
$string['showduration'] = 'Dauer anzeigen';
$string['showextrauserdetails'] = 'Zeige weitere Nutzerdetails';
$string['showqrcode'] = 'QR-Code zeigen';
$string['showsessiondescriptiononreport'] = 'Beschreibung der Sitzung im Bericht anzeigen';
$string['showsessiondescriptiononreport_desc'] = 'Zeigt die Beschreibung der Sitzung in der Auflistung des Anwesenheitsberichts an.';
$string['showsessiondetails'] = 'Zeige Details zur Lerneinheit';
$string['somedisabledstatus'] = '(Einige Auswahlmöglichkeiten wurden entfernt nachdem die Lerneinheit bereits begonnen hat.)';
$string['sortedgrid'] = 'Sortiertes Raster';
$string['sortedlist'] = 'Sortierte Liste';
$string['startofperiod'] = 'Beginn des Zeitraums';
$string['starttime'] = 'Startzeit';
$string['status'] = 'Status';
$string['statusdeleted'] = 'Status gelöscht';
$string['statuses'] = 'Status';
$string['statusset'] = 'Status {$a} gesetzt';
$string['statussetsettings'] = 'Status Katalog';
$string['strftimedm'] = '%d. %h';
$string['strftimedmy'] = '%d.%m.%Y';
$string['strftimedmyhm'] = '%d.%m.%Y %H:%M';
$string['strftimedmyw'] = '%a, %d.%m.%y';
$string['strftimeh'] = '%H';
$string['strftimehm'] = '%H:%M';
$string['strftimeshortdate'] = '%d.%m.%Y';
$string['studentavailability'] = 'Verfügbar für Teilnehmer/innen (Minuten)';
$string['studentavailability_help'] = 'Wenn Teilnehmer/innen ihre eigene Anwesenheit erfassen, dann erscheint der jeweilige Status zeitversetzt in den hier angegebenen Minuten nach Beginn der Lerneinheit.
<br/> Wenn hier nichts eingetragen wird, dann ist der Status immer verfügbar. Wenn Sie hier eine 0 eintragen, dann wird dieser Status immer vor den Teilnehmer/innen verborgen.';
$string['studentid'] = 'Teilnehmer-ID';
$string['studentmarked'] = 'Ihre Anwesenheit in dieser Lerneinheit wurde erfasst.';
$string['studentmarking'] = 'Erfassung durch die Teilnehmer/innen';
$string['studentpassword'] = 'Kennwort für Teilnehmer/innen';
$string['studentrecordingexpanded'] = 'Erfassung durch Teilnehmer/innen ausgeklappt';
$string['studentrecordingexpanded_desc'] = 'Zeigt den Abschnitt "Erfassung durch Teilnehmer/innen" standardmäßig ausgeklappt, wenn eine neue Lerneinheit hinzugefügt wird.';
$string['studentscanmark'] = 'Teilnehmer/innen erlauben, die Anwesenheit selbst zu erfassen';
$string['studentscanmark_desc'] = 'Wenn gesetzt, können Teilnehmer/innen ihre Anwesenheit selbst erfassen.';
$string['studentscanmark_help'] = 'Wenn gesetzt, dann sind Teilnehmer/innen in der Lage, ihren eigenen Anwesenheitsstatus für die Sitzung zu ändern.';
$string['studentscanmarksessiontime'] = 'Teilnehmer/innen erfassen ihre Anwesenheit';
$string['studentscanmarksessiontime_desc'] = 'Wenn dies aktiviert ist, können Teilnehmer/innen Ihre Anwesenheit nur erfassen, während die Lerneinheit stattfindet.';
$string['studentscanmarksessiontimeend'] = 'Ende der Lerneinheit (Minuten)';
$string['studentscanmarksessiontimeend_desc'] = 'Wenn die Lerneinheit über kein Endzeitpunkt verfügt, für wie viele Minuten soll es Teilnehmer/innen möglich sein, ihre Anwesenheit zu erfassen.';
$string['submitattendance'] = 'Anwesenheit erfassen';
$string['subnet'] = 'Subnetz';
$string['subnetactivitylevel'] = 'Subnetz-Einstellungen auf Aktivitätenebene erlauben';
$string['subnetactivitylevel_desc'] = 'Wenn dies aktiviert ist, können Trainer/innen die standardmäßig gesetzten Subnetz Einstellungen auf der Aktivitätsebene überschreiben. Sonst wird der eingestellte Standardwert verwendet, wenn eine Lerneinheit hinzugefügt wird.';
$string['subnetwrong'] = 'Die Anwesenheit kann nur von bestimmten Orten aus eingetragen werden und dieser Computer befindet sich nicht auf der erlaubten Liste.';
$string['summary'] = 'Zusammenfassung';
$string['tablerenamefailed'] = 'Umbenennen der alten attforblock-Tabelle schlug fehl.';
$string['tactions'] = 'Aktion';
$string['takeattendance'] = 'Anwesenheit erfassen';
$string['takensessions'] = 'Abgehaltene Lerneinheiten';
$string['tcreated'] = 'Erstellt';
$string['tempaddform'] = 'Temporäre/n Teilnehmer/in hinzufügen';
$string['tempexists'] = 'Es existiert bereits ein/e temporäre Teilnehmer/in mit dieser E-Mail-Adresse';
$string['temptable'] = 'Liste temporärer Teilnehmer/innen';
$string['tempuser'] = 'Temporäre/r Teilnehmer/in';
$string['tempusermerge'] = 'Temporäre/n Teilnehmer/in zusammenführen';
$string['tempusers'] = 'Temporäre Teilnehmer/innen';
$string['tempusersedit'] = 'Temporäre/r Teilnehmer/in bearbeiten';
$string['tempuserslist'] = 'Temporäre Teilnehmer/innen';
$string['thirdpartyemails'] = 'Andere Teilnehmer/innen benachrichtigen';
$string['thirdpartyemails_help'] = 'Liste an weiteren Teilnehmer/innen, die benachrichtigt werden (benötigt das Recht mod/attendance:viewreports).';
$string['thirdpartyemailsubject'] = 'Anwesenheitswarnung';
$string['thirdpartyemailtext'] = 'Die Anwesenheit von {$a->firstname} {$a->lastname} im Kurs {$a->coursename} {$a->aname} ist weniger als {$a->warningpercent} ({$a->percent})';
$string['thirdpartyemailtextfooter'] = 'Sie erhalten diese Mitteilung, weil der/die Trainer/in dieses Kurses Sie auf die Empfängerliste gesetzt hat.';
$string['thiscourse'] = 'Dieser Kurs';
$string['time'] = 'Zeit';
$string['timeahead'] = 'Wiederkehrende Lerneinheiten, die die Dauer eines Jahres überschreiten können nicht erzeigt werden. Bitte passen Sie das Start- und Endedatum an.';
$string['to'] = 'bis:';
$string['triggered'] = 'Zuerst benachrichtigt';
$string['tuseremail'] = 'E-Mail';
$string['tusername'] = 'Vollständiger Name';
$string['ungraded'] = 'Unbewertete';
$string['unknowngroup'] = 'Gruppe nicht bekannt';
$string['update'] = 'Ändern';
$string['usedefaultsubnet'] = 'Standard verwenden';
$string['usemessageform'] = 'oder nutzen Sie das unten stehende Formular, um die Nachricht an die ausgewählten Nutzer/innen zu schicken.';
$string['userexists'] = 'Es existiert bereits ein/e echte/r Teilnehmer/in mit dieser E-Mail-Adresse';
$string['users'] = 'Teilnehmer/innen zum exportieren';
$string['usestatusset'] = 'Statussatz';
$string['variable'] = 'Variable';
$string['variablesupdated'] = 'Variable geändert';
$string['versionforprinting'] = 'Druckversion';
$string['viewmode'] = 'Ansichtsmodus';
$string['warnafter'] = 'Anzahl an erfassten Lerneinheiten vor Warnung';
$string['warnafter_help'] = 'Warnungen werden nur ausgelöst, wenn der/die Teilnehmer/in seine/ihre Anwesenheit für mindestens diese Zahl an Lerneinheiten erfasst hat.';
$string['warningdeleted'] = 'Warnung gelöscht';
$string['warningdesc'] = 'Diese Warnungen werden automatisch neuen Anwesenheitsaktivitäten hinzugefügt. Wenn mehr als eine Warnung exakt zur selben Zeit ausgelöst werden, wird nur die Warnung mit dem niedrigeren Schwellenwert verschickt.';
$string['warningdesc_course'] = 'Die Warnungsschwelle, die hier gesetzt ist, beeinflusst den Abwesenheitsbericht und erlaubt es, dass Teilnehmer/innen und Dritte informiert werden können. Wenn mehr als eine Warnung exakt zur selben Zeit ausgelöst werden, wird nur die Warnung mit dem niedrigeren Schwellenwert verschickt.';
$string['warningfailed'] = 'Sie können keine Warnung erzeugen, bei der der Prozentsatz gleich der Zahl der Lerneinheiten ist.';
$string['warningpercent'] = 'Warnen, wenn der Prozentsatz darunter fällt';
$string['warningpercent_help'] = 'Eine Warnung wird ausgelöst, wenn der Gesamtprozentsatz unter diesen Wert sinkt.';
$string['warnings'] = 'Texte für Warnungen';
$string['warningthreshold'] = 'Schwelle für Warnung';
$string['warningupdated'] = 'Warnungen wurden aktualisiert';
$string['week'] = 'Woche(n)';
$string['weeks'] = 'Wochen';
$string['youcantdo'] = 'Sie können keine Aktionen ausführen.';
