<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'zoom', language 'pt', branch 'MOODLE_36_STABLE'
 *
 * @package   zoom
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actions'] = 'Ações';
$string['addtocalendar'] = 'Adicionar ao calendário';
$string['allmeetings'] = 'Todas as reuniões';
$string['alternative_hosts'] = 'Anfitriões alternativos';
$string['apikey'] = 'Chave da API do Zoom';
$string['apisecret'] = 'Chave secreta da API do Zoom';
$string['apiurl'] = 'Url da API do Zoom';
$string['attentiveness_score'] = 'Avaliação da atenção*';
$string['attentiveness_score_help'] = '*A avaliação da atenção é reduzida quando um participante não está focado no Zoom por mais de 30 segundos quando alguém está a partilhar o ecrã.';
$string['audio_both'] = 'VoIP e Telefone';
$string['audio_telephony'] = 'Apenas telefone';
$string['audio_voip'] = 'Apenas VoIP';
$string['cachedef_sessions'] = 'Informações do Zoom para obter solicitação de relatório do utilizador';
$string['cachedef_zoomid'] = 'O ID do utilizador do Zoom';
$string['calendardescriptionintro'] = '\\nDescrição:\\n{\\$a}';
$string['calendardescriptionURL'] = 'URL de acesso à reunião: {$a}.';
$string['calendariconalt'] = 'Ícone do calendário';
$string['clickjoin'] = 'Clicou no botão de aceder à reunião';
$string['connectionfailed'] = 'Erro na ligação:';
$string['connectionok'] = 'Ligação em funcionamento.';
$string['connectionstatus'] = 'Estado da ligação';
$string['defaultsettings'] = 'Configurações predefinidas do Zoom';
$string['defaultsettings_help'] = 'Estas configurações definem os valores predefinidos para todas as novas reuniões e webinars Zoom.';
$string['downloadical'] = 'Descarregar iCal';
$string['duration'] = 'Duração (minutos)';
$string['endtime'] = 'Hora de fim';
$string['err_duration_nonpositive'] = 'A duração deve ser um valor positivo.';
$string['err_duration_too_long'] = 'A duração não pode exceder as 150 horas.';
$string['err_long_timeframe'] = 'Período de tempo solicitado muito longo. A mostrar os resultados do último mês no intervalo.';
$string['errorwebservice'] = 'Erro no web service Zoom: {$a}';
$string['err_password'] = 'A senha apenas pode conter os seguintes caracteres: [a-z A-Z 0-9 @ - _ *]. Máximo de 10 caracteres.';
$string['err_start_time_past'] = 'A data de início não pode ser no passado';
$string['export'] = 'Exportar';
$string['firstjoin'] = 'Acesso antecipado';
$string['firstjoin_desc'] = 'O mais cedo que um utilizador pode aceder a uma reunião agendada (minutos antes do início).';
$string['getmeetingreports'] = 'Obter relatório da reunião do Zoom';
$string['invalid_status'] = 'Estado inválido. Verifique a base de dados.';
$string['join'] = 'Aceder';
$string['joinbeforehost'] = 'Aceder à reunião antes do anfitrião';
$string['join_meeting'] = 'Aceder à reunião';
$string['jointime'] = 'Hora de acesso';
$string['leavetime'] = 'Hora de saída';
$string['licensesnumber'] = 'Número de licenças';
$string['lowlicenses'] = 'Se o número das suas licenças exceder as necessárias, quando criar cada nova atividade por um utilizador, será atribuída uma licença PRO à atividade reduzindo o estado do outro utilizador. A opção é efetiva quando o número de licenças PRO ativas é superior a 5.';
$string['meeting_finished'] = 'Terminada';
$string['meeting_nonexistent_on_zoom'] = 'Não existe no Zoom';
$string['meeting_not_started'] = 'Não iniciada';
$string['meetingoptions'] = 'Opção da reunião';
$string['meetingoptions_help'] = '*Aceder antes do anfitrião* permite que os participantes acedam à reunião antes da entrada do anfitrião ou quando o anfitrião não puder participar na reunião.';
$string['meeting_started'] = 'A decorrer';
$string['meeting_time'] = 'Hora de início';
$string['modulename'] = 'Reunião Zoom';
$string['modulename_help'] = 'O Zoom é uma plataforma de videoconferência que oferece aos utilizadores autorizados a capacidade de realizar reuniões online.';
$string['modulenameplural'] = 'Reuniões Zoom';
$string['newmeetings'] = 'Novas reuniões';
$string['nomeetinginstances'] = 'Nenhuma sessão encontrada para esta reunião.';
$string['noparticipants'] = 'De momento, não foi encontrado qualquer participante para esta sessão.';
$string['nosessions'] = 'Nenhuma sessão encontrada para o intervalo especificado.';
$string['nozooms'] = 'Sem reuniões';
$string['off'] = 'Off';
$string['oldmeetings'] = 'Reuniões concluídas';
$string['on'] = 'On';
$string['option_audio'] = 'Opções do áudio';
$string['option_host_video'] = 'Vídeo do anfitrião';
$string['option_jbh'] = 'Permitir aceder antes do anfitrião';
$string['option_participants_video'] = 'Vídeo dos participantes';
$string['participants'] = 'Participantes';
$string['password'] = 'Senha';
$string['passwordprotected'] = 'Protegido por senha';
$string['pluginadministration'] = 'Gerir reunião Zoom';
$string['pluginname'] = 'Reunião Zoom';
$string['recurringmeeting'] = 'Recorrente';
$string['recurringmeeting_help'] = 'Sem data de fim';
$string['recurringmeetinglong'] = 'Reunião recorrente (reunião sem data ou hora de fim)';
$string['redefinelicenses'] = 'Redefinir licenças';
$string['report'] = 'Relatórios';
$string['reportapicalls'] = 'Reportar chamadas da API esgotadas';
$string['requirepassword'] = 'Requer senha da reunião';
$string['resetapicalls'] = 'Redefinir o número de chamadas disponíveis da API';
$string['search:activity'] = 'Reunião Zoom - informações da atividade';
$string['sessions'] = 'Sessões';
$string['start'] = 'Iniciar';
$string['starthostjoins'] = 'Iniciar vídeo quando o anfitrião acede';
$string['start_meeting'] = 'Iniciar reunião';
$string['startpartjoins'] = 'Iniciar vídeo quando o participante acede';
$string['starttime'] = 'Hora de início';
$string['start_time'] = 'Início';
$string['status'] = 'Estado';
$string['title'] = 'Título';
$string['topic'] = 'Tópico';
$string['unavailable'] = 'De momento não é possível aceder';
$string['updatemeetings'] = 'Atualizar as configurações da reunião a partir do Zoom';
$string['usepersonalmeeting'] = 'Use o ID pessoal da reunião {$a}';
$string['webinar'] = 'Webinar';
$string['webinar_already_false'] = '<p><b>Este módulo já foi definido como uma reunião. Não pode alternar esta configuração para webinar depois de criar a reunião.</b></p>';
$string['webinar_already_true'] = '<p><b>Este módulo já foi definido como um webinar. Não pode alternar esta configuração para reunião depois de criar o webinar.</b></p>';
$string['webinar_help'] = 'Esta opção só está disponível para contas Zoom pré-autorizadas.';
$string['zoom:addinstance'] = 'Adicionar nova reunião Zoom';
$string['zoomerr'] = 'Ocorreu um erro com o Zoom.';
$string['zoomerr_apikey_missing'] = 'Chave da API do Zoom não encontrada';
$string['zoomerr_apisecret_missing'] = 'Chave secreta da API do Zoom não encontrada';
$string['zoomerr_id_missing'] = 'Tem de especificar um ID do course_module ou um ID da instância';
$string['zoomerr_licensescount_missing'] = 'A configuração máxima do Zoom foi encontrada mas a configuração de contagem de licenças não foi encontrada';
$string['zoomerr_meetingnotfound'] = 'Não foi possível encontrar esta reunião no Zoom. Pode <a href="{$a->recreate}">recriar a reunião</a> ou <a href="{$a->delete}">apagar a reunião</a>.';
$string['zoomerr_meetingnotfound_info'] = 'Não foi possível encontrar esta reunião no Zoom. Se tiver alguma dúvida, entre em contacto com o organizador da reunião';
$string['zoomerr_usernotfound'] = 'Não foi possível encontrar a sua conta no Zoom. Se estiver a usar o Zoom pela primeira vez, deverá usar a conta do Zoom acedendo à página <a href="{$a}" target="_blank">{$a}</a>. Depois de ativar a sua conta do Zoom, recarregue esta página e continue a configurar a sua reunião. Caso contrário, verifique se o seu e-mail no Zoom corresponde ao seu e-mail neste sistema.';
$string['zoomurl'] = 'URL da página inicial do Zoom';
$string['zoom:view'] = 'Ver reuniões Zoom';
