<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'moodle', language 'ru', branch 'MOODLE_36_STABLE'
 *
 * @package   moodle
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abouttobeinstalled'] = 'должно быть установлено';
$string['action'] = 'Действие';
$string['actionchoice'] = 'Что Вы хотите сделать с файлом «{$a}»?';
$string['actions'] = 'Действия';
$string['actionsmenu'] = 'Меню действий';
$string['active'] = 'Активно';
$string['activeusers'] = 'Активные пользователи';
$string['activities'] = 'Элементы курса';
$string['activities_help'] = 'Такие элементы курса, как форумы, тесты и Wiki, позволяют добавлять к курсу интерактивное содержимое.';
$string['activity'] = 'Элемент курса';
$string['activityclipboard'] = 'Перемещение элемента: {$a}';
$string['activityiscurrentlyhidden'] = 'Извините, данный элемент курса сейчас скрыт';
$string['activitymodule'] = 'Модуль элемента курса';
$string['activitymodules'] = 'Модули элементов курса';
$string['activityreport'] = 'Отчет о деятельности';
$string['activityreports'] = 'Отчеты о деятельности';
$string['activityselect'] = 'Выберите элемент курса для переноса';
$string['activitysince'] = 'Действия с {$a}';
$string['activitytypetitle'] = '{$a->activity} - {$a->type}';
$string['activityweighted'] = 'Активность на одного пользователя';
$string['add'] = 'Добавить';
$string['addactivity'] = 'Добавить элемент курса...';
$string['addactivitytosection'] = 'Добавить элемент курса в раздел «{$a}»';
$string['addadmin'] = 'Добавить администратора';
$string['addblock'] = 'Добавить блок';
$string['addcomment'] = 'Добавить комментарий...';
$string['addcountertousername'] = 'Создавать пользователя, добавляя номер к логину';
$string['addcreator'] = 'Добавить создателя курсов';
$string['adddots'] = 'Добавить...';
$string['added'] = 'Добавлено: {$a}';
$string['addedrecip'] = 'Добавлен {$a} новый получатель';
$string['addedrecips'] = 'Добавлено {$a} новых получателей';
$string['addedtogroup'] = 'Добавлен в группу «{$a}»';
$string['addedtogroupnot'] = 'Не добавлен в группу «{$a}»';
$string['addedtogroupnotenrolled'] = 'Не добавлен в группу «{$a}», потому что не зарегистрирован в курсе';
$string['addfilehere'] = 'Добавить сюда файл(ы)';
$string['addinganew'] = 'Добавление: {$a}';
$string['addinganewto'] = 'Добавить {$a->what} в {$a->to}';
$string['addingdatatoexisting'] = 'Добавление данных к существующим';
$string['additionalnames'] = 'Дополнительная информация об имени';
$string['addlinkhere'] = 'Добавить сюда ссылку';
$string['addnewcategory'] = 'Добавить категорию';
$string['addnewcourse'] = 'Добавить курс';
$string['addnewuser'] = 'Добавить пользователя';
$string['addnousersrecip'] = 'Добавить пользователей, которые не имеют доступа к «{$a}», в список получателей';
$string['addpagehere'] = 'Добавить текст здесь';
$string['addresource'] = 'Добавить ресурс...';
$string['addresourceoractivity'] = 'Добавить элемент или ресурс';
$string['addresourcetosection'] = 'Добавить ресурс в раздел «{$a}»';
$string['address'] = 'Адрес';
$string['addsections'] = 'Добавить разделы';
$string['addstudent'] = 'Добавить студента';
$string['addsubcategory'] = 'Добавить подкатегорию';
$string['addteacher'] = 'Добавить преподавателя';
$string['admin'] = 'Администратор';
$string['adminhelpaddnewuser'] = 'Чтобы вручную создать учетную запись нового пользователя';
$string['adminhelpassignadmins'] = 'Администраторы могут на сайте делать что угодно и попасть куда угодно';
$string['adminhelpassigncreators'] = 'Создатели курсов могут создавать новые курсы';
$string['adminhelpassignsiteroles'] = 'Назначить указанные роли определенным пользователям';
$string['adminhelpassignstudents'] = 'Перейдите в курс и добавьте студентов из меню «Управление»';
$string['adminhelpauthentication'] = 'Вы можете использовать внутренние учетные записи пользователя или данные из внешней базы данных';
$string['adminhelpbackup'] = 'Настройте автоматическое резервное копирование и расписание его работы';
$string['adminhelpconfiguration'] = 'Установите переменные, влияющие на работу и внешний вид сайта';
$string['adminhelpconfigvariables'] = 'Настройте переменные, определяющие основные характеристики сайта';
$string['adminhelpcourses'] = 'Создайте курсы и категории и назначьте в них пользователей для редактирования предполагаемых курсов';
$string['adminhelpeditorsettings'] = 'Определите базовые настройки HTML-редактора';
$string['adminhelpedituser'] = 'Просмотрите список учетных записей пользователей и, при необходимости, отредактируйте их';
$string['adminhelpenvironment'] = 'Проверьте, насколько Ваш сервер отвечает текущим и будущим требованиям';
$string['adminhelpfailurelogs'] = 'Посмотреть список неудачных попыток входа';
$string['adminhelplanguage'] = 'Для проверки и редактирования текущего перевода системы';
$string['adminhelplogs'] = 'Просмотр журнала всех событий на этом сайте';
$string['adminhelpmanageblocks'] = 'Управление установленными блоками и их настройками';
$string['adminhelpmanagedatabase'] = 'Прямой доступ к базе данных (будьте внимательны!)';
$string['adminhelpmanagefilters'] = 'Выберите текстовые фильтры и связанные с ними настройки';
$string['adminhelpmanagemodules'] = 'Управление и настройка установленных модулей.';
$string['adminhelpmanageroles'] = 'Создайте и определите роли, которые могут назначены пользователям';
$string['adminhelpmymoodle'] = 'Настройте для пользователей вид блока «Мой Moodle»';
$string['adminhelpreports'] = 'Отчеты уровня сайта';
$string['adminhelpsitefiles'] = 'Для публикации основных файлов или передачи внешних резервных копий';
$string['adminhelpsitesettings'] = 'Определите вид первой страницы сайта';
$string['adminhelpstickyblocks'] = 'Настройте блоки, закрепленные на всех страницах Moodle';
$string['adminhelpthemes'] = 'Выберите, как должен выглядеть сайт (цвет, шрифт и т.п.)';
$string['adminhelpuploadusers'] = 'Импорт новых учетных записей пользователей из текстового файла';
$string['adminhelpusers'] = 'Определите своих пользователей и установите способ их аутентификации';
$string['adminhelpxmldbeditor'] = 'Интерфейс для редактирования XMLDB файлов. Только для разработчиков';
$string['administration'] = 'Управление';
$string['administrationsite'] = 'Администрирование';
$string['administrator'] = 'Администратор';
$string['administratordescription'] = 'Обычно администраторы могут делать всё, что угодно, на всём сайте и во всех курсах.';
$string['administrators'] = 'Администраторы';
$string['administratorsall'] = 'Все администраторы';
$string['administratorsandteachers'] = 'Администраторы и преподаватели';
$string['advanced'] = 'Расширенная форма ответа';
$string['advancedfilter'] = 'Расширенный  поиск';
$string['advancedsettings'] = 'Расширенные настройки';
$string['afterresource'] = 'После ресурса «{$a}»';
$string['aftersection'] = 'После раздела «{$a}»';
$string['again'] = 'еще раз';
$string['agelocationverification'] = 'Проверка возраста и местонахождения';
$string['aimid'] = 'AIM ID';
$string['ajaxuse'] = 'AJAX и Javascript';
$string['all'] = 'Все';
$string['allactions'] = 'Все действия';
$string['allactivities'] = 'Все действия';
$string['allcategories'] = 'Все категории';
$string['allchanges'] = 'Все изменения';
$string['alldays'] = 'Все дни';
$string['allfieldsrequired'] = 'Необходимо заполнить все поля';
$string['allfiles'] = 'Все файлы';
$string['allgroups'] = 'Все группы';
$string['alllogs'] = 'Все события';
$string['allmods'] = 'Все {$a}';
$string['allow'] = 'Разрешить';
$string['allowinternal'] = 'Разрешить также внутренние методы';
$string['allownone'] = 'Запретить всё';
$string['allownot'] = 'Не разрешать';
$string['allowstealthmodules'] = 'Разрешить невидимые элементы курса';
$string['allowstealthmodules_help'] = 'При включенном параметре элементы курса могут быть доступны, но не отображаться в видимых разделах курса. Ссылки на такие элементы курса должны предоставляться другим способом, например, с помощью ресурса типа «Страница». Невидимые элементы курса по прежнему будут отображаться в журнале оценок и других отчетах.';
$string['allparticipants'] = 'Все участники';
$string['allteachers'] = 'Все преподаватели';
$string['alphanumerical'] = 'Может содержать только буквы, цифры, дефис (-) и точку (.)';
$string['alreadyconfirmed'] = 'Регистрация уже была подтверждена';
$string['alternatename'] = 'Альтернативное имя';
$string['always'] = 'Всегда';
$string['and'] = '{$a->one} и {$a->two}';
$string['answer'] = 'Ответ';
$string['any'] = 'Любое';
$string['appearance'] = 'Внешний вид';
$string['approve'] = 'Одобрить';
$string['areyousure'] = 'Вы уверены?';
$string['areyousuretorestorethis'] = 'Вы уверены, что хотите продолжить?';
$string['areyousuretorestorethisinfo'] = 'Далее Вы сможете выбрать - добавить эту резервную копию в уже существующий курс или создать отдельный новый курс';
$string['asc'] = 'По возрастанию';
$string['assessment'] = 'Оценка';
$string['assignadmins'] = 'Назначить администраторов';
$string['assigncreators'] = 'Назначить создателей курсов';
$string['assignedrolecount'] = '{$a->role}: {$a->count}';
$string['assignsiteroles'] = 'Назначить глобальные роли';
$string['authenticateduser'] = 'Аутентифицированный пользователь';
$string['authenticateduserdescription'] = 'Все пользователи, вошедшие в систему';
$string['authentication'] = 'Аутентификация';
$string['authenticationplugins'] = 'Плагины аутентификации';
$string['autosubscribe'] = 'Автоподписка на форум';
$string['autosubscribeno'] = 'Нет: автоматически не подписывать меня на темы форумов';
$string['autosubscribeyes'] = 'Да: когда я отправляю сообщение, я хочу, чтобы меня автоматически подписывали на этот форум';
$string['availability'] = 'Доступность';
$string['availablecourses'] = 'Доступные курсы';
$string['back'] = 'Назад';
$string['backto'] = 'Назад к {$a}';
$string['backtocourselisting'] = 'Вернуться к списку курсов';
$string['backtohome'] = 'Возврат на главную';
$string['backtopageyouwereon'] = 'Вернуться к странице, на которой Вы были';
$string['backtoparticipants'] = 'Вернуться к списку участников';
$string['backup'] = 'Резервное копирование';
$string['backupactivehelp'] = 'Выберите, нужно ли осуществлять автоматическое резервное копирование.';
$string['backupcancelled'] = 'Резервное копирование отменено';
$string['backupcoursefileshelp'] = 'Если разрешено, то файлы данного курса автоматически будут включены в резервную копию';
$string['backupdate'] = 'Дата резервной копии';
$string['backupdatenew'] = '&nbsp; {$a->TAG} сейчас {$a->weekday}, {$a->mday} {$a->month} {$a->year}<br />';
$string['backupdateold'] = '{$a->TAG} был {$a->weekday}, {$a->mday} {$a->month} {$a->year}';
$string['backupdaterecordtype'] = '<br />{$a->recordtype} - {$a->recordname}<br />';
$string['backupdetails'] = 'Детали резервной копии';
$string['backuperrorinvaliddestination'] = 'Каталог для резервного копирования не существует или защищен от записи.';
$string['backupexecuteathelp'] = 'Укажите, в какое время осуществлять автоматическое резервное копирование.';
$string['backupfailed'] = 'Некоторые из Ваших курсов не были сохранены';
$string['backupfilename'] = 'backup';
$string['backupfinished'] = 'Резервное копирование успешно окончено';
$string['backupfromthissite'] = 'Эта резервная копия была сделана на этом сайте?';
$string['backupgradebookhistoryhelp'] = 'Если параметр выбран, то история оценок будет включена в автоматические резервные копии. Обратите внимание, для того, чтобы это работало история оценок не должна быть отключена в настройках сервера (параметр disablegradehistory).';
$string['backupincludemoduleshelp'] = 'Хотите ли Вы включить в резервную копию курса модули (с пользовательскими данными или без них)';
$string['backupincludemoduleuserdatahelp'] = 'Хотите ли Вы включить в резервную копию пользовательские данные модулей.';
$string['backuplogdetailed'] = 'Детальная информация о выполнении';
$string['backuploglaststatus'] = 'Последняя информация (log) о выполнении';
$string['backupmissinguserinfoperms'] = 'Примечание: Эта резервная копия не содержит данных пользователя. Элементы Упражнение и Семинар не будут включены в резервную копию, так как эти модули не совместимы с таким типом резервного копирования.';
$string['backupnext'] = 'Следующая резервная копия';
$string['backupnonisowarning'] = 'Внимание! Эта резервная копия была создана в неюникодной версии Moodle (до версии 1.6). Если эта резервная копия содержит символы отличные от стандарта ISO-8859-1 (например, русские), то эти тексты могут быть ИСПОРЧЕНЫ если Вы попытаетесь востановить их в этой Юникодной версии Moodle. Смотрите <a href="http://docs.moodle.org/en/Backup_FAQ">Backup FAQ</a> для более подробной информации по восстановлению архивов.';
$string['backupnotyetrun'] = 'Отложенное автоматическое резервное копирование';
$string['backuporiginalname'] = 'Название резервной копии';
$string['backuproleassignments'] = 'Сохранять в резервной копии назначения следующих ролей';
$string['backupsavetohelp'] = 'Полный путь к каталогу, в котором Вы хотите хранить файлы резервных копий';
$string['backupsitefileshelp'] = 'Если выбрана эта опция, то файлы сайта, используемые в курсах, будут включены в резервные копии';
$string['backuptakealook'] = 'Вы можете посмотреть журнал резервного копирования по ссылке:
{$a}';
$string['backupuserfileshelp'] = 'Выберите, должны ли пользовательские файлы (например, изображение в профиле) войти в автоматически создаваемую резервную копию';
$string['backupversion'] = 'Версия резервной копии';
$string['badges'] = 'Значки';
$string['block'] = 'Блок';
$string['blockconfiga'] = 'Настройка блока "{$a}"';
$string['blockconfigbad'] = 'Этот блок реализован некорректно, поэтому у него нет конфигурационного интерфейса.';
$string['blocks'] = 'Блоки';
$string['blocksaddedit'] = 'Добавить/редактировать блоки';
$string['blockseditoff'] = 'Выключить редактирование блоков';
$string['blocksediton'] = 'Включить редактирование блоков';
$string['blocksetup'] = 'Настройка таблиц базы данных для блока';
$string['blocksuccess'] = 'Таблицы для блока «{$a}» установлены';
$string['brief'] = 'Кратко';
$string['bulkactions'] = 'Массовые действия';
$string['bulkactionselect'] = '{$a} выбрано для массовых действий';
$string['bulkmovecoursessuccess'] = 'Курсы ({$a->courses}) успешно перемещены в категорию «{$a->category}»';
$string['bycourseorder'] = 'Курсы по порядку';
$string['byname'] = 'от {$a}';
$string['bypassed'] = 'Пройдено';
$string['cachecontrols'] = 'Управление кэшированием';
$string['cancel'] = 'Отмена';
$string['cancelled'] = 'Отменено';
$string['categories'] = 'Категории курсов';
$string['categoriesandcourses'] = 'Категории курсов и курсы';
$string['category'] = 'Категория';
$string['categoryadded'] = 'Категория «{$a}» добавлена';
$string['categorybulkaction'] = 'Массовые действия с выбранными категориями';
$string['categorycontents'] = 'Подкатегории и курсы';
$string['categorycurrentcontents'] = 'Содержание {$a}';
$string['categorydeleted'] = 'Категория «{$a}» была удалена';
$string['categoryduplicate'] = 'Категория с именем «{$a}» уже существует!';
$string['categorymodifiedcancel'] = 'Категория была изменена! Отмените действие и попробуйте снова.';
$string['categoryname'] = 'Название категории';
$string['categorysubcategoryof'] = '«{$a->category}» - подкатегория категории «{$a->parentcategory}»';
$string['categoryupdated'] = 'Категория «{$a}» обновлена';
$string['changedpassword'] = 'Пароль был изменен';
$string['changepassword'] = 'Изменить пароль';
$string['changesmadereallygoaway'] = 'Вы внесли изменения. Вы уверены, что хотите уйти и потерять изменения?';
$string['changessaved'] = 'Изменения сохранены';
$string['check'] = 'Проверьте';
$string['checkall'] = 'Отметить все';
$string['checkingbackup'] = 'Проверка бэкапа';
$string['checkingcourse'] = 'Проверка курса';
$string['checkingforbbexport'] = 'Проверка экспорта BlackBoard';
$string['checkinginstances'] = 'Проверка образцов';
$string['checkingsections'] = 'Проверка разделов';
$string['checklanguage'] = 'Настройки языка';
$string['checknone'] = 'Убрать отметки';
$string['childcoursenotfound'] = 'Дочерний курс не найден!';
$string['childcourses'] = 'Дочерние курсы';
$string['choose'] = 'Выбрать';
$string['choosecourse'] = 'Выбрать курс';
$string['choosedots'] = 'Выберите...';
$string['chooselivelogs'] = 'Или посмотрите отчет о текущей деятельности в курсе';
$string['chooselogs'] = 'Выберите события, которые хотите увидеть';
$string['choosereportfilter'] = 'Выберите фильтр для отчета';
$string['choosetheme'] = 'Выбрать тему';
$string['chooseuser'] = 'Выбрать пользователя';
$string['city'] = 'Город';
$string['cleaningtempdata'] = 'Удаление временных данных';
$string['clear'] = 'Очистить';
$string['clickhelpiconformoreinfo'] = '...продолжение... Нажмите на значок справки, чтобы прочитать статью полностью';
$string['clickhere'] = 'Нажмите здесь...';
$string['clicktochangeinbrackets'] = '{$a} (Нажмите для изменения)';
$string['clicktohideshow'] = 'Нажмите, чтобы раскрыть или скрыть';
$string['closebuttontitle'] = 'Закрыть';
$string['closewindow'] = 'Закрыть окно';
$string['collapse'] = 'Свернуть';
$string['collapseall'] = 'Свернуть всё';
$string['collapsecategory'] = 'Свернуть {$a}';
$string['commentincontext'] = 'Найти этот комментарий в контексте';
$string['comments'] = 'Комментарии';
$string['commentscount'] = 'Комментарии ({$a})';
$string['commentsnotenabled'] = 'Возможность комментирования отключена';
$string['commentsrequirelogin'] = 'Для просмотра комментариев необходимо войти в систему.';
$string['comparelanguage'] = 'Редактирование перевода';
$string['complete'] = 'Завершено';
$string['completereport'] = 'Полный отчет';
$string['configuration'] = 'Настройки';
$string['confirm'] = 'Подтвердить';
$string['confirmcheckfull'] = 'Вы абсолютно уверены, что хотите подтвердить {$a}?';
$string['confirmcoursemove'] = 'Вы уверены, что хотите перенести этот курс ({$a->course}) в категорию ({$a->category})?';
$string['confirmdeletesection'] = 'Вы абсолютно уверены, что хотите полностью удалить «{$a}» и все элементы, содержащиеся в нем?';
$string['confirmed'] = 'Регистрация подтверждена';
$string['confirmednot'] = 'Ваша регистрация еще не подтверждена. Пожалуйста, проверьте ваш почтовый ящик для подтверждения по электронной почте.';
$string['considereddigitalminor'] = 'Вы слишком молоды, чтобы создать учетную запись на этом сайте.';
$string['content'] = 'Содержимое';
$string['continue'] = 'Продолжить';
$string['continuetocourse'] = 'Нажмите для входа в Ваш курс';
$string['convertingwikitomarkdown'] = 'Конвертация разметки вики в разметку Markdown';
$string['cookiesenabled'] = 'В Вашем браузере должен быть разрешен прием cookies';
$string['cookiesenabled_help'] = 'На сайте используется два типа cookies:

Основным является сессионный cookie, обычно называемый MoodleSession. Вы должны разрешить использование этого файла cookie в своем браузере, чтобы обеспечить непрерывность и оставаться в системе при просмотре сайта. Когда вы выходите из системы или закрываете браузер, этот файл cookie уничтожается (в вашем браузере и на сервере).

Другой файл cookie предназначен исключительно для удобства, его обычно называют MOODLEID или аналогичным. Он просто запоминает ваше имя пользователя в браузере. Это означает, что когда вы возвращаетесь на этот сайт, поле имени пользователя на странице входа в систему уже заполнено для вас. Отказ от этого файла cookie безопасен - вам нужно будет просто вводить свое имя пользователя при каждом входе в систему.';
$string['cookiesenabledonlysession'] = 'В Вашем браузере должен быть разрешен прием cookies';
$string['cookiesenabledonlysession_help'] = 'Этот сайт использует один сеансовый cookie, обычно называемый MoodleSession. Вы должны разрешить использование этого файла cookie в своем браузере, чтобы обеспечить непрерывность и оставаться в системе при просмотре сайта. Когда вы выходите из системы или закрываете браузер, этот файл cookie уничтожается (в вашем браузере и на сервере).';
$string['cookiesnotenabled'] = 'К сожалению, в Вашем браузере отключены cookies';
$string['copy'] = 'копировать';
$string['copyasnoun'] = 'копия';
$string['copyingcoursefiles'] = 'Копирование файлов курса';
$string['copyingsitefiles'] = 'Копирование файлов сайта, используемых в курсе';
$string['copyinguserfiles'] = 'Копирование пользовательских файлов';
$string['copyingzipfile'] = 'Копирование ZIP-файла';
$string['copyrightnotice'] = 'Заметка об авторском праве';
$string['coresystem'] = 'Система';
$string['cost'] = 'Стоимость';
$string['costdefault'] = 'Базовая стоимость';
$string['counteditems'] = '{$a->count} {$a->items}';
$string['country'] = 'Страна';
$string['course'] = 'Курс';
$string['courseadministration'] = 'Управление курсом';
$string['coursealreadyfinished'] = 'Курс уже завершен';
$string['courseapprovedemail'] = 'Ваш запрос на создание курса «{$a->name}» был одобрен и Вам теперь назначена роль «{$a->teacher}». Чтобы перейти к Вашему новому курсу, воспользуйтесь ссылкой {$a->url}';
$string['courseapprovedemail2'] = 'Ваш запрос на создание курса «{$a->name}» был одобрен. Чтобы перейти к Вашему новому курсу, воспользуйтесь ссылкой {$a->url}';
$string['courseapprovedfailed'] = 'Не удается сохранить курс, как одобренный!';
$string['courseapprovedsubject'] = 'Ваш запрос на создание курса был одобрен!';
$string['courseavailable'] = 'Курс доступен';
$string['courseavailablenot'] = 'Курс не доступен';
$string['coursebackup'] = 'Бэкап курса';
$string['coursebulkaction'] = 'Массовые действия с выбранными курсами';
$string['coursecategories'] = 'Категории курсов';
$string['coursecategory'] = 'Категория курса';
$string['coursecategorydeleted'] = 'Удалена категория курсов «{$a}»';
$string['coursecategory_help'] = 'Этот параметр определяет категорию, в которой курс будет отображаться в списке курсов.';
$string['coursecatmanagement'] = 'Управление курсами и категориями';
$string['coursecompletion'] = 'Окончание курса';
$string['coursecompletions'] = 'Окончания курса';
$string['coursecreators'] = 'Создатель курса';
$string['coursecreatorsdescription'] = 'Создатели курсов могут создавать новые курсы.';
$string['coursedeleted'] = 'Удален курс «{$a}»';
$string['coursedetails'] = 'Информация о курсе';
$string['coursedisplay'] = 'Представление курса';
$string['coursedisplay_help'] = 'Этот параметр определяет, будет ли весь курс отображаться на одной странице или будет разделен на несколько страниц.';
$string['coursedisplay_multi'] = 'Показывать один раздел на странице';
$string['coursedisplay_single'] = 'Показывать все разделы на одной странице';
$string['courseduration'] = 'Длительность курса';
$string['courseduration_desc'] = 'Продолжительность курса используется для вычисления даты окончания курса по умолчанию. Дата окончания курса используется для определения того, должен ли курс включаться в список курсов пользователя. Он также может использоваться пользовательскими отчетами. Пользователи могут по-прежнему входить в курс после даты окончания.';
$string['courseenddateenabled'] = 'Дата окончания курса выставлена по умолчанию';
$string['courseenddateenabled_desc'] = 'Этот параметр определяет, будет ли дата окончания курса выставлена по умолчанию для новых курсов и будет установлена на дату, рассчитанную из продолжительности курса.';
$string['courseextendednamedisplay'] = '{$a->shortname} {$a->fullname}';
$string['coursefiles'] = 'Файлы курса (устаревшее хранилище)';
$string['coursefilesedit'] = 'Редактировать файлы курса (устаревшее хранилище)';
$string['coursefileswarning'] = 'Хранение файлов в папке курса считается устаревшим';
$string['coursefileswarning_help'] = 'Начиная с версии Moodle 2.0, подход к хранению файлов в области файлов курса считается устаревшим. Вместо этого старайтесь использовать другие хранилища.';
$string['courseformatdata'] = 'Формат данных курса';
$string['courseformatoptions'] = 'Настройки форматирования {$a}';
$string['courseformats'] = 'Форматы курсов';
$string['courseformatudpate'] = 'Обновить формат';
$string['coursegrades'] = 'Оценки курса';
$string['coursehelpcategory'] = 'Разместите курс в списке курсов, это может облегчить студентам его поиск.';
$string['coursehelpforce'] = 'Применять групповой режим к каждому элементу в курсе';
$string['coursehelpformat'] = 'Главная страница курса будет отображена в этом формате.';
$string['coursehelphiddensections'] = 'Как скрытые разделы курса отображаются для студентов.';
$string['coursehelpmaximumupload'] = 'Определите наибольший размер файла, который может быть загружен в этот курс. Ограничено установками сайта.';
$string['coursehelpnewsitemsnumber'] = 'Количество последних элементов из форума объявлений, отображаемых в блоке «Последние объявления» на странице курса. Если установить значение «0», то форум объявлений не будет создан.';
$string['coursehelpnumberweeks'] = 'Количество недель/тем, отображаемых на главной странице курса.';
$string['coursehelpshowgrades'] = 'Включить отображение журнала оценок. Это не препятствует отображению оценок внутри отдельных элементов курса.';
$string['coursehidden'] = 'Этот курс скрыт';
$string['courseinfo'] = 'Информация о курсе';
$string['courselegacyfiles'] = 'Файлы курса (устаревшее хранилище)';
$string['courselegacyfiles_help'] = 'Область файлов курса сохранена для обратной совместимости с Moodle 1.9 и более ранними версиями. Все файлы из этой области доступны всем участникам курса (независимо от того, ссылаетесь Вы на них или нет), и нет возможности узнать, где эти файлы используются в Moodle.

Используя эту область для хранения файлов курса, Вы подвергаете себя такой опасности, как, например, пропажа файлов из резервных копий. Кроме того, в любой момент содержимое может быть опубликовано или повторно использовано. Поэтому не рекомендуется использовать эту область, если Вы не уверены, что это действительно необходимо.';
$string['courselegacyfilesofcourse'] = 'Устаревшее хранилище файлов курса: {$a}';
$string['coursemessage'] = 'Отправка сообщения участникам курса';
$string['coursenotaccessible'] = 'Свободный доступ к этому курсу запрещен';
$string['coursenotyetfinished'] = 'Курс еще не завершен';
$string['coursenotyetstarted'] = 'Курс еще не начат';
$string['courseoverview'] = 'Сводка по курсам';
$string['courseoverviewfiles'] = 'Изображения курса';
$string['courseoverviewfilesext'] = 'Расширения файлов изображений курса';
$string['courseoverviewfiles_help'] = 'Изображение курса отображается в обзоре курса на информационной панели. Администратором сайта могут быть разрешены дополнительные допустимые типы файлов и размещение более одного файла. В этом случае эти файлы будут отображаться рядом с описанием курса на странице списка курсов.';
$string['courseoverviewfileslimit'] = 'Ограничение на количество изображений курса';
$string['courseoverviewgraph'] = 'Графическое представление сводки по курсам';
$string['coursepreferences'] = 'Настройки курса';
$string['courseprofiles'] = 'Участник курсов';
$string['coursereasonforrejecting'] = 'Ваши мотивы для отклонения этого запроса';
$string['coursereasonforrejectingemail'] = 'Эта информация будет отправлена по электронной почте автору запроса';
$string['coursereject'] = 'Отклонить запрос курса';
$string['courserejected'] = 'Курс был отклонен и автор запроса уведомлен об этом';
$string['courserejectemail'] = 'К сожалению, Ваш запрос на создание курса был отклонен. Была указана следующая причина этого:

{$a}';
$string['courserejectreason'] = 'Опишите причину отклонения этого курса<br/>(она будет отправлена запросившему)';
$string['courserejectsubject'] = 'Ваш курс был отклонен';
$string['coursereport'] = 'Отчет курса';
$string['coursereports'] = 'Отчеты по курсам';
$string['courserequest'] = 'Запрос курса';
$string['courserequestdetails'] = 'Подробности о запрошенном Вами курсе';
$string['courserequestfailed'] = 'По какой-то причине Ваш запрос курса не был сохранен';
$string['courserequestintro'] = 'Используйте эту форму для того, чтобы создать запрос на создание курса .<br /> Укажите как можно больше информации,<br /> чтобы администраторы поняли причины, по которым Вам нужен этот курс.';
$string['courserequestreason'] = 'Причины создания курса';
$string['courserequestsuccess'] = 'Ваш запрос на создание курса принят. Ответ о возможности его удовлетворения будет отправлен Вам по электронной почте.';
$string['courserequestsupport'] = 'Дополнительная информация, которая может помочь администратору принять решение по этому запросу';
$string['courserequestwarning'] = 'Пользователь, запросивший данный курс, будет автоматически записан в него и получит роль «{$a}».';
$string['courserestore'] = 'Восстановление курса';
$string['courses'] = 'Курсы';
$string['coursesearch'] = 'Поиск курсов';
$string['coursesearch_help'] = 'Вы можете искать одновременно несколько слов и осуществить более точный поиск следующим образом:

* слово - найти любые соответствия этого слова в тексте.
* +слово - искать только полное соответствие.
* -слово - не выводить результаты, содержащие это слово.';
$string['coursesectionsummaries'] = 'Описания разделов курса';
$string['coursesectiontitle'] = 'Курс: {$a->course}, {$a->sectionname}: {$a->sectiontitle}';
$string['coursesettings'] = 'Настройки курса по умолчанию';
$string['coursesmovedout'] = 'Курсы, перемещенные из {$a}';
$string['coursespending'] = 'Курсы, ожидающие одобрения';
$string['coursestart'] = 'Начало курса';
$string['coursesummary'] = 'Описание курса';
$string['coursesummary_help'] = 'Описание курса отображается в списке курсов. Поиск курсов  осуществляется по их названиям и по их описаниям.';
$string['coursetitle'] = 'Курс: {$a->course}';
$string['courseupdates'] = 'Обновление курса';
$string['coursevisibility'] = 'Видимость курса';
$string['coursevisibility_help'] = 'Этот параметр определяет, появится ли курс в списке курсов и смогут ли студенты получить к нему доступ. Если установлено значение «Скрыть», то доступ разрешен только пользователям с возможностью просмотра скрытых курсов (например, преподавателям).';
$string['create'] = 'Создание';
$string['createaccount'] = 'Создать мой новый аккаунт';
$string['createcategory'] = 'Создать категорию';
$string['createfolder'] = 'Создать папку в {$a}';
$string['createnew'] = 'Создать новый';
$string['createnewcategory'] = 'Создать новую категорию';
$string['createnewcourse'] = 'Создать новый курс';
$string['createnewsubcategory'] = 'Создать новую подкатегорию';
$string['createsubcategoryof'] = 'Создать подкатегорию в {$a}';
$string['createuser'] = 'Создать пользователя';
$string['createuserandpass'] = 'Выберите имя пользователя и пароль';
$string['createziparchive'] = 'Создать ZIP-архив';
$string['creatingblocks'] = 'Создание блоков';
$string['creatingblocksroles'] = 'Назначение и переопределение ролей на уровне блоков';
$string['creatingblogsinfo'] = 'Создание инфрмации в блогах';
$string['creatingcategoriesandquestions'] = 'Создание категорий и вопросов';
$string['creatingcoursemodules'] = 'Создание модулей курса';
$string['creatingcourseroles'] = 'Назначение и переопределение ролей на уровне курса';
$string['creatingevents'] = 'Создание событий';
$string['creatinggradebook'] = 'Создание журнала оценок';
$string['creatinggroupings'] = 'Создание группировок';
$string['creatinggroupingsgroups'] = 'Добавление групп в группировки';
$string['creatinggroups'] = 'Создание групп';
$string['creatinglogentries'] = 'Создание записей журнала событий';
$string['creatingmessagesinfo'] = 'Создание информации о сообщениях';
$string['creatingmodroles'] = 'Назначение и переопределение ролей на уровне модулей';
$string['creatingnewcourse'] = 'Создание нового курса';
$string['creatingrolesdefinitions'] = 'Создание ролей';
$string['creatingscales'] = 'Создание шкал';
$string['creatingsections'] = 'Создание разделов';
$string['creatingtemporarystructures'] = 'Создание структуры';
$string['creatinguserroles'] = 'Назначение и переопределение ролей уровня пользователей';
$string['creatingusers'] = 'Создание пользователей';
$string['creatingxmlfile'] = 'Создание XML-файла';
$string['currency'] = 'Валюта';
$string['currentcourse'] = 'Текущий курс';
$string['currentcourseadding'] = 'Текущий курс, добавить в него данные';
$string['currentcoursedeleting'] = 'Текущий курс, сначала удалить';
$string['currentlanguage'] = 'Выбранный язык';
$string['currentlocaltime'] = 'Ваше текущее местное время';
$string['currentlyselectedusers'] = 'Выбранные пользователи';
$string['currentpicture'] = 'Текущее изображение';
$string['currentrelease'] = 'Информация о текущем выпуске';
$string['currentversion'] = 'Текущая версия';
$string['databasechecking'] = 'Обновление базы данных Moodle с версии {$a->oldversion} до {$a->newversion}';
$string['databaseperformance'] = 'Производительность базы данных';
$string['databasesetup'] = 'Установка базы данных';
$string['databasesuccess'] = 'База данных была успешно обновлена';
$string['databaseupgradebackups'] = 'Версия Бэкапа {$a}';
$string['databaseupgradeblocks'] = 'Версия Блоков {$a}';
$string['databaseupgradegroups'] = 'Версия групп';
$string['databaseupgradelocal'] = 'Версия локальной базы данных {$a}';
$string['databaseupgrades'] = 'Обновление базы данных';
$string['dataformats'] = 'Форматы данных';
$string['date'] = 'Дата';
$string['datechanged'] = 'Дата изменена';
$string['datemostrecentfirst'] = 'По дате - свежие вверху';
$string['datemostrecentlast'] = 'По дате - свежие внизу';
$string['day'] = 'день';
$string['days'] = 'дн.';
$string['decodinginternallinks'] = 'Расшифровка внутренних ссылок';
$string['default'] = 'По умолчанию';
$string['defaultcompetencescale'] = 'Шкала компетенции по умолчанию';
$string['defaultcompetencescaledesc'] = 'Двоичная шкала оценок, которая содержит информацию только о том, демонстрирует человек умение или нет.';
$string['defaultcompetencescalenotproficient'] = 'Пока не соответствует требованиям';
$string['defaultcompetencescaleproficient'] = 'Соответствует требованиям';
$string['defaultcoursestudent'] = 'Студент';
$string['defaultcoursestudentdescription'] = 'Обычно студенты обладают меньшим набором прав в рамках курса.';
$string['defaultcoursestudents'] = 'Студенты';
$string['defaultcoursesummary'] = 'Напишите здесь краткое и интересное описание курса.';
$string['defaultcourseteacher'] = 'Учитель';
$string['defaultcourseteacherdescription'] = 'Учителя могут делать в курсе всё, в том числе изменять элементы курса и оценивать студентов.';
$string['defaultcourseteachers'] = 'Учителя';
$string['defaulteditor'] = 'Текстовый редактор, установленный по умолчанию';
$string['delete'] = 'Удалить';
$string['deleteablock'] = 'Удалить блок';
$string['deleteall'] = 'Удалить все';
$string['deleteallcannotundo'] = 'Удалить все - действие не может быть отменено';
$string['deleteallcomments'] = 'Удалить все комментарии';
$string['deleteallratings'] = 'Удалить все оценки';
$string['deletecategory'] = 'Удалить категорию: {$a}';
$string['deletecategorycheck'] = 'Вы абсолютно уверены, что хотите удалить категорию <b>«{$a}»</b>?<br />В результате, все курсы из нее будут перемещены в родительскую категорию или в категорию «Разное».';
$string['deletecategorycheck2'] = 'Если Вы удаляете эту категорию, то должны определиться, что сделать с курсами и подкатегориями, которые она содержит.';
$string['deletecategoryempty'] = 'Эта категория пуста';
$string['deletecheck'] = 'Удалить {$a} ?';
$string['deletecheckfiles'] = 'Вы абсолютно уверены, что хотите удалить эти файлы?';
$string['deletecheckfull'] = 'Вы абсолютно уверены, что хотите полностью удалить пользователя «{$a}», включая его записи на курсы, действия и другие данные пользователя?';
$string['deletechecktype'] = 'Вы уверены, что хотите удалить этот {$a->type}?';
$string['deletechecktypename'] = 'Вы уверены, что хотите удалить {$a->type} «{$a->name}»?';
$string['deletecheckwarning'] = 'Вы собираетесь удалить следующие файлы';
$string['deletecomment'] = 'Удалить этот комментарий';
$string['deletecommentbyon'] = 'Удалить комментарий, размещенный пользователем {$a->user} в {$a->time}';
$string['deletecompletely'] = 'Полное удаление';
$string['deletecourse'] = 'Удалить курс';
$string['deletecoursecheck'] = 'Вы абсолютно уверены, что хотите полностью удалить этот курс и все данные, которые он содержит?';
$string['deleted'] = 'Удалено';
$string['deletedactivity'] = 'Удален {$a}';
$string['deletedcourse'] = '{$a} был полностью удален';
$string['deletednot'] = '{$a} не может быть удален!';
$string['deletepicture'] = 'Удалить';
$string['deletesection'] = 'Удалить раздел';
$string['deleteselected'] = 'Удалить выделенные';
$string['deleteselectedkey'] = 'Удалить выбранный ключ';
$string['deletingcourse'] = 'Удаление {$a}';
$string['deletingexistingcoursedata'] = 'Удаление существующих данных курса';
$string['deletingolddata'] = 'Удаление устаревших данных';
$string['department'] = 'Отдел';
$string['deprecatedeventname'] = '{$a} (больше не используется)';
$string['desc'] = 'По убыванию';
$string['description'] = 'Описание';
$string['deselectall'] = 'Убрать выделение';
$string['detailedless'] = 'Кратко';
$string['detailedmore'] = 'Подробнее';
$string['digitalminor'] = 'Цифровой возраст совершеннолетия';
$string['digitalminor_desc'] = 'Чтобы создать учетную запись на этом сайте, пожалуйста, попросите родителя/опекуна связаться со следующим лицом:';
$string['directory'] = 'Каталог';
$string['disable'] = 'Отключить';
$string['disabledcomments'] = 'Комментарии отключены';
$string['displayingfirst'] = 'Выведены только первые {$a->count} {$a->things}.';
$string['displayingrecords'] = 'Вывести на экран записи ({$a}).';
$string['displayingusers'] = 'Пользователи с {$a->start} до {$a->end}';
$string['displayonpage'] = 'Показать на странице';
$string['dndcourse'] = 'Вы можете перетащить этот курс для изменения порядка сортировки или перемещения его в другую категорию';
$string['dndenabled_inbox'] = 'Для загрузки файлов перетащите их сюда.';
$string['dndnotsupported'] = 'Загрузка методом перетаскивания файла не поддерживается';
$string['dndnotsupported_help'] = 'Ваш браузер не поддерживает  загрузку методом перетаскивания фалов. <br /> Эта функция доступна во всех последних версиях Chrome, Firefox и Safari, а также Internet Explorer 10 и выше.';
$string['dndnotsupported_insentence'] = 'Перетаскивание не поддерживается';
$string['dnduploadwithoutcontent'] = 'Это загрузка не имеет никакого содержимого';
$string['dndworkingfile'] = 'Для загрузки файлов перетащите их в разделы курса';
$string['dndworkingfilelink'] = 'Для загрузки файлов или ссылок перетащите их в разделы курса';
$string['dndworkingfiletext'] = 'Для загрузки файлов или текста перетащите их в разделы курса';
$string['dndworkingfiletextlink'] = 'Для загрузки файлов, текста или ссылок перетащите их в разделы курса';
$string['dndworkinglink'] = 'Для загрузки ссылок перетащите их в разделы курса';
$string['dndworkingtext'] = 'Для загрузки текста перетащите их в разделы курса';
$string['dndworkingtextlink'] = 'Для загрузки текста или ссылок перетащите их в разделы курса';
$string['documentation'] = 'Документация Moodle';
$string['dontsortcategories'] = 'Не сортировать категории';
$string['dontsortcourses'] = 'Не сортировать курсы';
$string['down'] = 'Вниз';
$string['download'] = 'Скачать';
$string['downloadall'] = 'Скачать все';
$string['downloadexcel'] = 'Скачать в формате Excel';
$string['downloadfile'] = 'Скачать файл';
$string['downloadods'] = 'Скачать в формате ODS';
$string['downloadtext'] = 'Скачать в текстовом формате';
$string['doyouagree'] = 'Прочитали ли Вы эти условия и поняли их?';
$string['droptoupload'] = 'Для загрузки перетащите файл сюда';
$string['duplicate'] = 'Дублировать';
$string['duplicatedmodule'] = '{$a} (копия)';
$string['edhelpaspellpath'] = 'Чтобы использовать в редакторе встроенную проверку орфографии, на Вашем сервере ДОЛЖЕН быть установлен <strong>aspell 0.50</strong> или более поздней версии. Ниже необходимо указать правильный путь к исполняемому файлу aspell. В Unix/Linux системах это обычно <strong>/usr/bin/aspell</strong>, но может быть и другой.';
$string['edhelpbgcolor'] = 'Задать цвет фона редактора.<br />Например: #ffffff или white';
$string['edhelpcleanword'] = 'Эта настройка разрешает или запрещает фильтр формата Word';
$string['edhelpenablespelling'] = 'Разрешить или запретить проверку правописания. Для проверки на сервере должен быть установлен <strong>aspell</strong>. Второе значение - <strong> словарь по умолчанию </strong>. Он будет использоваться, если у aspell не будет словаря для  собственного языка пользователя.';
$string['edhelpfontfamily'] = 'Свойства font-family - список шрифтов или названий семейств шрифтов. Названия семейств шрифтов должны разделяться запятыми.';
$string['edhelpfontlist'] = 'Определите шрифт для выпадающего меню визуального редактора';
$string['edhelpfontsize'] = 'Выбор шрифта по умолчанию устанавливает размер шрифта. <br /> Допустимые значения: medium, large, smaller, larger, 10pt, 11px.';
$string['edit'] = 'Редактировать';
$string['edita'] = 'Редактировать {$a}';
$string['editcategorysettings'] = 'Редактировать настройки категории';
$string['editcategorythis'] = 'Редактировать эту категорию';
$string['editcoursesettings'] = 'Редактировать настройки курса';
$string['editfiles'] = 'Редактировать файлы';
$string['editgroupprofile'] = 'Редактировать профиль группы';
$string['editinga'] = 'Редактирование {$a}';
$string['editingteachershort'] = 'Может редактировать';
$string['editlock'] = 'Значение не может быть изменено!';
$string['editmyprofile'] = 'Редактировать информацию';
$string['editorbgcolor'] = 'Цвет фона';
$string['editorcleanonpaste'] = 'Очищать HTML от тегов Word при вставке';
$string['editorcommonsettings'] = 'Общие настройки';
$string['editordefaultfont'] = 'Шрифт по-умолчанию';
$string['editorenablespelling'] = 'Разрешить проверку правописания';
$string['editorfontlist'] = 'Список шрифтов';
$string['editorfontsize'] = 'Размер шрифта по-умолчанию';
$string['editorpreferences'] = 'Настройки редактора';
$string['editorresettodefaults'] = 'Вернуть значения по умолчанию';
$string['editorsettings'] = 'Настройки редактора';
$string['editorshortcutkeys'] = 'Горячие клавиши редактора';
$string['editsection'] = 'Редактировать раздел';
$string['editsectionname'] = 'Редактировать название раздела';
$string['editsettings'] = 'Редактировать настройки';
$string['editsummary'] = 'Редактировать вступление';
$string['editthisactivity'] = 'Редактировать этот элемент курса';
$string['editthiscategory'] = 'Редактирование категории';
$string['edittitle'] = 'Изменить название';
$string['edittitleinstructions'] = 'Нажмите «Escape» для отмены, «Enter» - при завершении';
$string['edituser'] = 'Редактировать записи пользователей';
$string['edulevel'] = 'Все события';
$string['edulevel_help'] = '* Обучение — действия, выполняемые учителем, например, обновление ресурса
* Участие — действия, выполняемые студентом, например, публикация в форуме
* Другое — действия, выполняемые пользователем с ролью, отличной от роли учителя или студента';
$string['edulevelother'] = 'Другое';
$string['edulevelparticipating'] = 'Участие';
$string['edulevelteacher'] = 'Обучение';
$string['email'] = 'Адрес электронной почты';
$string['emailactive'] = 'Адрес электронной почты подтвержден';
$string['emailagain'] = 'Адрес электронной почты (еще раз)';
$string['emailalreadysent'] = 'Сообщение о восстановлении пароля уже было отправлено по электронной почте. Зайдите в свою почту.';
$string['emailcharset'] = 'Почтовая кодировка';
$string['emailconfirm'] = 'Подтвердить учетную запись';
$string['emailconfirmation'] = 'Здравствуйте, {$a->firstname}.

На сайте «{$a->sitename}» был запрос на создание учетной записи с указанием Вашего адреса электронной почты.

Для подтверждения новой учетной записи пройдите по следующему адресу:

{$a->link}

В большинстве почтовых программ этот адрес должен выглядеть как синяя ссылка, на которую достаточно нажать. Если это не так, просто скопируйте этот адрес и вставьте его в строку адреса в верхней части окна Вашего браузера.

С уважением, администратор сайта,
{$a->admin}';
$string['emailconfirmationresend'] = 'Послать письмо подтверждения снова';
$string['emailconfirmationsubject'] = '{$a}: подтверждение учетной записи';
$string['emailconfirmsent'] = 'На указанный Вами адрес электронной почты (<b>{$a}</b>) было отправлено письмо с простыми инструкциями для завершения регистрации.
 Если у вас появятся проблемы с регистрацией, свяжитесь с администратором сайта.';
$string['emailconfirmsentfailure'] = 'Письмо подтверждения не удалось отправить';
$string['emailconfirmsentsuccess'] = 'Письмо подтверждения отправлено успешно';
$string['emaildigest'] = 'Тип отправляемого дайджеста';
$string['emaildigestcomplete'] = 'Полный (ежедневное электронное письмо со всеми сообщениями)';
$string['emaildigest_help'] = 'Эти установки ежедневного дайджеста для форумов будут использоваться по умолчанию.

* Без дайджеста - Вы будете получать по одному электронному письму на каждое сообщение форума;
* Полный - Вы будете получать ежедневное электронное письмо, содержащее полный текст каждого сообщения форума;
* Только темы - Вы будете получать одно письмо в день, содержащее только темы каждого сообщения форума.

Вы сможете выбрать различные настройки для каждого форума, если захотите.';
$string['emaildigestoff'] = 'Без дайджеста (по одному электронному письму на каждое сообщение форума)';
$string['emaildigestsubjects'] = 'Только темы (ежедневное электронное письмо с темами сообщений)';
$string['emaildisable'] = 'Этот электронный адрес не доступен.';
$string['emaildisableclick'] = 'Щелкните сюда, чтобы отменить отправку любых писем на этот адрес';
$string['emaildisplay'] = 'Показывать адрес электронной почты';
$string['emaildisplaycourse'] = 'Только другим слушателям курса';
$string['emaildisplay_help'] = 'Привилегированные пользователи (такие как учителя и управляющие) смогут всегда видеть ваш адрес электронной почты.';
$string['emaildisplayhidden'] = 'Адрес электронной почты скрыт';
$string['emaildisplayno'] = 'Скрыть мой адрес электронной почты от непривилегированных пользователей';
$string['emaildisplayyes'] = 'Всем';
$string['emailenable'] = 'Этот электронный адрес доступен';
$string['emailenableclick'] = 'Щелкните сюда, чтобы включить отправку писем на этот адрес';
$string['emailexists'] = 'Этот адрес электронной почты уже зарегистрирован';
$string['emailexistshintlink'] = 'Восстановить забытые имя пользователя и пароль';
$string['emailexistssignuphint'] = 'Возможно, вы ранее создавали учетную запись? {$a}';
$string['emailformat'] = 'Формат сообщений электронной почты';
$string['emailmustbereal'] = 'Внимание: Ваш адрес электронной почты должен быть реальным';
$string['emailnotallowed'] = 'Запрещена электронная почта с этих доменов ({$a})';
$string['emailnotfound'] = 'В базе данных не найден такой адрес электронной почты';
$string['emailonlyallowed'] = 'Этот адрес электронной почты не относится к числу разрешенных ({$a})';
$string['emailpasswordchangeinfo'] = 'Здравствуйте, {$a->firstname}!

Кто-то (вероятно, Вы) запросил новый пароль для Вашей учетной записи  «{$a->username}» на «{$a->sitename}».

Для изменения пароля перейдите по следующей ссылке:

{$a->link}

В большинстве почтовых программ этот адрес должен выглядеть как синяя ссылка, на которую достаточно нажать. Если  не получается, просто скопируйте этот адрес и вставьте его в адресную строку в верхней части окна своего браузера.

Если Вам понадобится помощь, пожалуйста, свяжитесь с администратором сайта,
{$a->admin}';
$string['emailpasswordchangeinfodisabled'] = 'Здравствуйте, {$a->firstname}!

Кто-то (скорее всего, Вы) запросил новый пароль для Вашей учетной записи на сайте «{$a->sitename}».

К сожалению, Ваша учетная запись на сайте отключена, поэтому пароль нельзя сбросить/изменить. Вам необходимо связаться с администратором сайта .

С уважением, администратор сайта, {$a->admin}';
$string['emailpasswordchangeinfofail'] = 'Здравствуйте, {$a->firstname}!

Кто-то (вероятно, Вы) запросил новый пароль для Вашей учетной записи  на «{$a->sitename}».

К сожалению, пароли не могут быть сброшены на этом сайте. Пожалуйста, свяжитесь с администратором сайта {$a->admin}.';
$string['emailpasswordchangeinfosubject'] = '{$a}: Информация об изменении пароля';
$string['emailpasswordconfirmation'] = 'Здравствуйте, {$a->firstname}.

Кто-то (скорее всего, Вы) запросил смену пароля Вашей учетной записи на сайте «{$a->sitename}».

Для подтверждения этого действия и получения нового пароля по электронной почте пройдите по следующему адресу:

{$a->link}

В большинстве почтовых программ этот адрес должен выглядеть как синяя ссылка, на которую достаточно нажать. Если это не так, просто скопируйте этот адрес и вставьте его в строку адреса в верхней части окна Вашего браузера.

С уважением, администратор сайта,
{$a->admin}';
$string['emailpasswordconfirmationsubject'] = '{$a}: подтверждение изменения пароля';
$string['emailpasswordconfirmmaybesent'] = '<p>Если Вы указали верный логин или адрес электронной почты, то Вам будет отправлено электронное письмо.</p> <p>Оно содержит простые инструкции для завершения процедуры изменения пароля. Если после этого возникнут какие-то сложности, свяжитесь с администратором сайта.</p>';
$string['emailpasswordconfirmnoemail'] = '<p> Указанная учетная запись пользователя не имеет зарегистрированного адреса электронной почты.</p>
<p> Свяжитесь с администратором сайта.</p>';
$string['emailpasswordconfirmnotsent'] = '<p>Указанные детали пользователя не позволили идентифицировать существующую учетную запись. </p>
<p> Пожалуйста, проверьте введенную информацию, а затем повторите попытку.
Если Вы будете продолжать испытывать трудности, то обратитесь к администратору сайта.</p>';
$string['emailpasswordconfirmsent'] = 'На Ваш адрес (<b>{$a}</b>) было отправлено письмо. <br />Оно содержит простые инструкции для завершения смены пароля. Если у Вас появятся какие-нибудь трудности, свяжитесь с администратором сайта.';
$string['emailpasswordsent'] = 'Вы подтвердили смену пароля.
<br />Письмо, содержащее Ваш новый пароль, было отправлено на адрес<br /><b>{$a->email}</b>.
<br />Новый пароль был создан автоматически - возможно, Вы пожелаете
<a href="{$a->link}">сменить его</a> на более запоминающийся.';
$string['emailresetconfirmation'] = 'Здравствуйте, {$a->firstname}.

Для Вашей учетной записи «{$a->username}» на сайте «{$a->sitename}» было запрошено восстановление пароля.
Для подтверждения этого запроса и создания нового пароля для своей учетной записи, пожалуйста, перейдите по адресу: {$a->link}. (Эта ссылка действительна в течение {$a->resetminutes} мин. с момента первого запроса восстановления пароля).

Если восстановление пароля было запрошено не Вами, не нужно производить никаких действий.
Если Вам нужна помощь, пожалуйста, свяжитесь с администратором сайта, {$a->admin}';
$string['emailresetconfirmationsubject'] = '{$a}: Запрос на восстановление пароля';
$string['emailresetconfirmsent'] = 'Сообщение было отправлено на Ваш адрес <b>{$a}</b>. <br />Оно содержит простые инструкции для подтверждения и завершения изменения пароля. Если Вы будете продолжать испытывать трудности, то обратитесь к администратору сайта.';
$string['emailtoprivatefiles'] = 'Вы также можете отправить файлы прямо в область личных файлов в виде вложений по электронной почте. Просто прикрепите файлы к письму и отправьте его по адресу {$a}';
$string['emailtoprivatefilesdenied'] = 'Администратор отключил возможность загружать личные файлы по электронной почте.';
$string['emailuserhasnone'] = 'Отсутствует адрес электронной почты для пользователя';
$string['emailvia'] = '{$a->name} (отправлено через {$a->url})';
$string['emptydragdropregion'] = 'пустая область';
$string['enable'] = 'Включить';
$string['encryptedcode'] = 'Зашифрованый код';
$string['enddate'] = 'Дата окончания курса';
$string['enddate_help'] = 'Дата окончания курса используется для определения того, должен ли курс включаться в список курсов пользователя. После прошедшей даты окончания курс больше не показывается в навигации и указан как прошлый в обзоре курсов. Дата окончания курса также используется и в пользовательских отчетах. Пользователи по-прежнему могут зайти в курс после даты его окончания; другими словами, дата не ограничивает доступ.';
$string['english'] = 'Английский';
$string['enrolmentmethods'] = 'Способы записи';
$string['entercourse'] = 'Нажмите для входа в курс';
$string['enteremail'] = 'Введите Ваш адрес электронной почты';
$string['enteremailaddress'] = 'Для сброса пароля введите Ваш адрес электронной почты. Новый пароль будет выслан на указанный адрес.';
$string['enterusername'] = 'Введите логин';
$string['entries'] = 'Записи';
$string['error'] = 'Ошибка';
$string['errorcreatingactivity'] = 'Не удается создать экземпляр элемента «{$a}»';
$string['errorfiletoobig'] = 'Файл был больше, чем предел {$a} байт';
$string['errornouploadrepo'] = 'Загрузка из репозитория не разрешена на этом сайте';
$string['errorwhenconfirming'] = 'Вы до сих пор не прошли регистрацию, так как произошла ошибка. Убедитесь, что при переходе по ссылке связь не была прервана. Вы можете повторить вход по присланной Вам ссылке для окончательной регистрации в системе.';
$string['eventcommentcreated'] = 'Комментарий создан';
$string['eventcommentdeleted'] = 'Комментарий удален';
$string['eventcommentsviewed'] = 'Комментарии просмотрены';
$string['eventconfiglogcreated'] = 'Создан лог конфигурации';
$string['eventcontentviewed'] = 'Содержимое просмотрено';
$string['eventcoursebackupcreated'] = 'Резервная копия курса создана';
$string['eventcoursecategorycreated'] = 'Категория создана';
$string['eventcoursecategorydeleted'] = 'Категория удалена';
$string['eventcoursecategoryupdated'] = 'Категория обновлена';
$string['eventcoursecategoryviewed'] = 'Просмотренные категории';
$string['eventcoursecontentdeleted'] = 'Содержимое курса удалено';
$string['eventcoursecreated'] = 'Курс создан';
$string['eventcoursedeleted'] = 'Курс удален';
$string['eventcourseinformationviewed'] = 'Просмотрено описание курса';
$string['eventcoursemodulecreated'] = 'Модуль курса создан';
$string['eventcoursemoduledeleted'] = 'Модуль курса удален';
$string['eventcoursemoduleinstancelistviewed'] = 'Список экземпляров модуля в курсе просмотрен';
$string['eventcoursemoduleupdated'] = 'Модуль курса обновлен';
$string['eventcoursemoduleviewed'] = 'Модуль курса просмотрен';
$string['eventcourseresetended'] = 'Сброс курса завершен';
$string['eventcourseresetstarted'] = 'Сброс курса начат';
$string['eventcourserestored'] = 'Курс восстановлен';
$string['eventcoursesectioncreated'] = 'Раздел курса создан';
$string['eventcoursesectiondeleted'] = 'Раздел курса удален';
$string['eventcoursesectionupdated'] = 'Раздел курса обновлен';
$string['eventcoursessearched'] = 'Проведен поиск по курсам';
$string['eventcourseupdated'] = 'Курс обновлен';
$string['eventcourseuserreportviewed'] = 'Отчет по участнику курса просмотрен';
$string['eventcourseviewed'] = 'Курс просмотрен';
$string['eventdashboardreset'] = 'Страница «Личный кабинет» сброшена';
$string['eventdashboardsreset'] = 'Все страницы «Личный кабинет» сброшены';
$string['eventdashboardviewed'] = 'Страница «Личный кабинет» просмотрена';
$string['eventemailfailed'] = 'Не удалось отправить сообщение электронной почты';
$string['eventname'] = 'Название события';
$string['eventrecentactivityviewed'] = 'Отчет о последних действиях просмотрен';
$string['eventsearchindexed'] = 'Данные для поиска проиндексированы';
$string['eventsearchresultsviewed'] = 'Просмотренные поисковые запросы';
$string['eventunknownlogged'] = 'Неизвестное событие';
$string['eventusercreated'] = 'Пользователь создан';
$string['eventuserdeleted'] = 'Пользователь удален';
$string['eventuserinfocategorycreated'] = 'Создана категория поля профиля пользователя';
$string['eventuserinfocategorydeleted'] = 'Категория поля профиля пользователя удалена';
$string['eventuserinfocategoryupdated'] = 'Категория поля профиля пользователя обновлена';
$string['eventuserinfofieldcreated'] = 'Создано поле профиля пользователя';
$string['eventuserinfofielddeleted'] = 'Поле профиля пользователя удалено';
$string['eventuserinfofieldupdated'] = 'Поле профиля пользователя обновлено';
$string['eventuserlistviewed'] = 'Список пользователей просмотрен';
$string['eventuserloggedout'] = 'Пользователь вышел';
$string['eventuserpasswordupdated'] = 'Пароль пользователя обновлен';
$string['eventuserprofileviewed'] = 'Профиль пользователя просмотрен';
$string['eventuserupdated'] = 'Пользователь обновлен';
$string['everybody'] = 'Все';
$string['executeat'] = 'Запускать в';
$string['existing'] = 'Существующий';
$string['existingadmins'] = 'Существующие администраторы';
$string['existingcourse'] = 'Существующие курсы';
$string['existingcourseadding'] = 'Существующий курс, добавить данные';
$string['existingcoursedeleting'] = 'Существующий курс, предварительно удалить';
$string['existingcreators'] = 'Существующие создатели курса';
$string['existingstudents'] = 'Записанные студенты';
$string['existingteachers'] = 'Существующие преподаватели';
$string['expand'] = 'Развернуть';
$string['expandall'] = 'Развернуть всё';
$string['expandcategory'] = 'Развернуть {$a}';
$string['explanation'] = 'Объяснение';
$string['explanationdigitalminor'] = 'Эта информация необходима для определения того, превышает ли ваш возраст цифровой возраст согласия. Это возраст, когда человек может соглашаться с условиями и его данные будут храниться и обрабатываться на законных основаниях.';
$string['extendenrol'] = 'Продлить обучение (индивидуально)';
$string['extendperiod'] = 'Продлить на';
$string['failedloginattempts'] = 'Неудачных попыток авторизации после Вашего последнего входа: {$a->attempts}';
$string['favourites'] = 'Помеченные';
$string['feedback'] = 'Отзыв';
$string['file'] = 'Файл';
$string['fileexists'] = 'Файл с именем {$a} уже существует';
$string['filemissing'] = 'не хватает {$a}';
$string['filereaderror'] = 'Не удается прочитать файл «{$a}». Проверьте, что это действительно файл, а не папка.';
$string['files'] = 'Файлы';
$string['filesanduploads'] = 'Файлы и загрузки';
$string['filesfolders'] = 'Файлы/папки';
$string['fileuploadwithcontent'] = 'Загружаемый файл не должен содержать параметр контента???';
$string['filloutallfields'] = 'Заполните необходимые поля в форме';
$string['filter'] = 'Фильтр';
$string['filteroption'] = '{$a->criteria}: {$a->value}';
$string['filters'] = 'Фильтры';
$string['findmorecourses'] = 'Найти больше курсов...';
$string['first'] = 'Первая';
$string['firstaccess'] = 'Первый вход';
$string['firstname'] = 'Имя';
$string['firstnamephonetic'] = 'Имя - фонетическая запись';
$string['firstsiteaccess'] = 'Первый доступ к сайту';
$string['firsttime'] = 'Вы в первый раз на нашем сайте?';
$string['folder'] = 'Папка';
$string['folderclosed'] = 'Закрытая папка';
$string['folderopened'] = 'Открытая папка';
$string['followingoptional'] = 'Следующие элементы являются необязательными';
$string['followingrequired'] = 'Следующие элементы являются необходимыми';
$string['for'] = 'Для';
$string['force'] = 'Принудительно';
$string['forcelanguage'] = 'Принудительный  язык';
$string['forceno'] = 'не устанавливать принудительно';
$string['forcepasswordchange'] = 'Принудительная смена пароля';
$string['forcepasswordchangecheckfull'] = 'Вы абсолютно уверены, что Вы хотите принудить пользователя «{$a}» изменить пароль?';
$string['forcepasswordchange_help'] = 'Если поставить отметку, то пользователю будет предложено изменить пароль при следующем входе в систему';
$string['forcepasswordchangenot'] = 'Невозможно принудительно изменить пароль на {$a}';
$string['forcepasswordchangenotice'] = 'Вы должны изменить свой пароль.';
$string['forcetheme'] = 'Тема принудительно';
$string['forgotaccount'] = 'Забыли пароль?';
$string['forgotten'] = 'Забыли логин или пароль?';
$string['forgottenduplicate'] = 'Этот адрес электронной почты является общим для нескольких учетных записей. Пожалуйста, введите имя пользователя.';
$string['forgotteninvalidurl'] = 'Неверная ссылка для сброса пароля';
$string['format'] = 'Формат';
$string['format_help'] = 'Формат курса определяет представление страницы курса.

* Единственный элемент курса - отображение единственного элемента или ресурса (например, теста или пакета SCORM) на странице курса
* Форум - На главной странице курса отображается форум.
* Разделы по темам - Страница курса представляется в виде разделов по темам.
* Разделы по неделям - Страница курса представляется в виде разделов, разбитых по неделям. Первая неделя отсчитывается от даты начала курса.';
$string['formathtml'] = 'Формат HTML';
$string['formatmarkdown'] = 'Формат Markdown';
$string['formatplain'] = 'Текстовый формат';
$string['formattext'] = 'Выбирать формат автоматически ';
$string['formattexttype'] = 'Форматирование';
$string['forumpreferences'] = 'Настройки форума';
$string['framesetinfo'] = 'Этот  документ содержит:';
$string['from'] = 'с';
$string['frontpagecategorycombo'] = 'Комбинированный список';
$string['frontpagecategorynames'] = 'Список категорий';
$string['frontpagecourselist'] = 'Список курсов';
$string['frontpagecoursesearch'] = 'Поле поиска курса';
$string['frontpagedescription'] = 'Описание главной страницы сайта';
$string['frontpagedescriptionhelp'] = 'Это описание может быть отображено на главной странице с помощью блока «Описание курса/сайта».';
$string['frontpageenrolledcourselist'] = 'Курсы, на которые пользователь записан';
$string['frontpageformat'] = 'Вид главной страницы сайта';
$string['frontpageformatloggedin'] = 'Вид главной страницы после авторизации';
$string['frontpagenews'] = 'Объявления';
$string['frontpagesettings'] = 'Настройки главной страницы';
$string['fulllistofcourses'] = 'Все курсы';
$string['fullname'] = 'Полное имя';
$string['fullnamecourse'] = 'Полное название курса';
$string['fullnamecourse_help'] = 'Полное название курса отображается вверху каждой страницы курса и в списке курсов.';
$string['fullnamedisplay'] = '{$a->firstname} {$a->lastname}';
$string['fullnameuser'] = 'Полное имя пользователя';
$string['fullprofile'] = 'Профиль полностью';
$string['fullsitename'] = 'Полное название сайта';
$string['functiondisabled'] = 'В настоящее время эта функция отключена';
$string['general'] = 'Основные';
$string['geolocation'] = 'широта - долгота';
$string['gettheselogs'] = 'Получить события журналов';
$string['go'] = 'Применить';
$string['gpl'] = 'Copyright (C) 1999 и далее Martin Dougiamas (http://moodle.com)

Эта программа является свободным программным обеспечением;
Вы можете распространять и/или изменять ее в соответствиями
с условиями опубликованной «Free Software Foundation» лицензии
«GNU General Public License» версии 2, или (по Вашему усмотрению)
любой более поздней версии.

Программа распространяется в надежде, что она окажется полезной,
но БЕЗ КАКИХ ЛИБО ГАРАНТИЙ; в том числе без гарантий ПРИГОДНОСТИ
ВООБЩЕ и ПРИГОДНОСТИ ДЛЯ КОНКРЕТНЫХ ЦЕЛЕЙ.

Более подробную информацию можно найти на странице лицензии Moodle:
http://docs.moodle.org/dev/License';
$string['gpl3'] = 'Copyright (C) 1999 и далее Martin Dougiamas (http://moodle.com)

Эта программа является свободным программным обеспечением;
Вы можете распространять и/или изменять ее в соответствиями
с условиями опубликованной «Free Software Foundation» лицензии
«GNU General Public License» версии 3, или (по Вашему усмотрению)
любой более поздней версии.

Программа распространяется в надежде, что она окажется полезной,
но БЕЗ КАКИХ ЛИБО ГАРАНТИЙ; в том числе без гарантий ПРИГОДНОСТИ
ВООБЩЕ и ПРИГОДНОСТИ ДЛЯ КОНКРЕТНЫХ ЦЕЛЕЙ.

Более подробную информацию можно найти на странице лицензии Moodle:
http://docs.moodle.org/dev/License';
$string['gpllicense'] = 'Лицензия GPL';
$string['grade'] = 'Оценка';
$string['grades'] = 'Оценки';
$string['gravatarenabled'] = 'На этом сайте включена поддержка сервиса <a href="http://www.gravatar.com/">Gravatar</a>. Если Вы не загрузите свое изображение в профиль, Moodle попробует загрузить изображение из Gravatar.';
$string['group'] = 'Группа';
$string['groupadd'] = 'Добавить новую группу';
$string['groupaddusers'] = 'Добавить выбранных в группу';
$string['groupextendenrol'] = 'Продлить обучение (одновременно для всех)';
$string['groupfor'] = 'для группы';
$string['groupinfo'] = 'Информация о выбранной группе';
$string['groupinfoedit'] = 'Редактировать настройки группы';
$string['groupinfomembers'] = 'Информация о выбранных членах';
$string['groupinfopeople'] = 'Информация о выбранных людях';
$string['groupmembers'] = 'Члены группы';
$string['groupmemberssee'] = 'Просмотр членов группы';
$string['groupmembersselected'] = 'Члены выбранной группы';
$string['groupmode'] = 'Групповой режим';
$string['groupmodeforce'] = 'Групповой режим принудительно';
$string['groupmy'] = 'Моя группа';
$string['groupnonmembers'] = 'Люди не в группе';
$string['groupnotamember'] = 'Извините, Вы не являетесь участником группы';
$string['grouprandomassign'] = 'Случайно распределить всех по группам';
$string['groupremove'] = 'Удалить выбранную группу';
$string['groupremovemembers'] = 'Удалить выбранных членов';
$string['groups'] = 'Группы';
$string['groupsnone'] = 'Нет групп';
$string['groupsseparate'] = 'Изолированные группы';
$string['groupsvisible'] = 'Видимые группы';
$string['guest'] = 'Гость';
$string['guestdescription'] = 'Обычно гости имеют минимальный набор прав и не могут нигде вводить текст.';
$string['guestskey'] = 'Допускать гостя, имеющего ключ';
$string['guestsno'] = 'Не допускать гостя';
$string['guestsnotallowed'] = 'Для курса «{$a}» не предусмотрен гостевой допуск';
$string['guestsyes'] = 'Допускать гостя без ключа';
$string['guestuser'] = 'Гость';
$string['guestuserinfo'] = 'Этот - специальный пользователь, которому разрешен доступ только на чтение к некоторым курсам.';
$string['help'] = 'Справка';
$string['helpprefix2'] = 'Справка по использованию элемента «{$a}»';
$string['helpwiththis'] = 'Помочь с этим';
$string['hiddenassign'] = 'Скрытое назначение';
$string['hiddenfromstudents'] = 'Скрыто от студентов';
$string['hiddenoncoursepage'] = 'Доступно, но не показано на странице курса';
$string['hiddensections'] = 'Отображение скрытых разделов';
$string['hiddensectionscollapsed'] = 'В неразвернутом виде';
$string['hiddensections_help'] = 'Этот параметр определяет, будут ли скрытые разделы отображаться для студентов в свернутом виде (например, чтобы в курсе с форматом по неделям отметить каникулы) или они будут полностью скрыты.';
$string['hiddensectionsinvisible'] = 'Полностью невидимы';
$string['hiddenwithbrackets'] = '(скрытый)';
$string['hide'] = 'Скрыть';
$string['hideadvancedsettings'] = 'Скрыть расширенные настройки';
$string['hidechartdata'] = 'Скрыть данные диаграммы';
$string['hidefromstudents'] = 'Скрыть от студентов';
$string['hideoncoursepage'] = 'Сделать доступным, но не отображать на странице курса';
$string['hidepicture'] = 'Скрыть изображение';
$string['hidepopoverwindow'] = 'Скрыть всплывающее окно';
$string['hidesection'] = 'Скрыть раздел {$a}';
$string['hidesettings'] = 'Скрыть настройки';
$string['hideshowblocks'] = 'Скрыть/показать блоки';
$string['highlight'] = 'Выделить';
$string['highlightoff'] = 'Убрать выделение';
$string['hits'] = 'Выбор';
$string['hitsoncourse'] = 'Выбран {$a->coursename} {$a->username}';
$string['hitsoncoursetoday'] = 'Сегодняшние посещения {$a->coursename} {$a->username}';
$string['home'] = 'В начало';
$string['hour'] = 'ч.';
$string['hours'] = 'час.';
$string['howtomakethemes'] = 'Как создать новый дизайн';
$string['htmleditor'] = 'Использовать редактор HTML';
$string['htmleditoravailable'] = 'HTML-редактор доступен для использования.';
$string['htmleditordisabled'] = 'При заполнении информации о пользователе Вы отключили возможность использования редактора HTML.';
$string['htmleditordisabledadmin'] = 'Администратор отключил возможность использования -редактора HTML на этом сайте.';
$string['htmleditordisabledbrowser'] = 'Редактор HTML недоступен, потому что не поддерживается используемым браузером.';
$string['htmlfilesonly'] = 'Только  HTML-файлы';
$string['htmlformat'] = 'HTML-формат';
$string['icon'] = 'Значок';
$string['icqnumber'] = 'Номер ICQ';
$string['idnumber'] = 'Индивидуальный номер';
$string['idnumbercourse'] = 'Идентификационный номер курса';
$string['idnumbercoursecategory'] = 'Идентификационный номер категории';
$string['idnumbercoursecategory_help'] = 'Этот идентификационный номер категории курсов используется только для сопоставления категории с внешними системами и больше нигде на сайте не отображается. Если у категории есть официальное кодовое обозначение, его можно ввести здесь, в остальных случаях можно просто оставить поле пустым.';
$string['idnumbercourse_help'] = 'Идентификационный номер курса необходим только при использовании курса во внешних системах, он нигде не отображается на сайте Moodle.  Если у вас есть официальное кодовое обозначение данного курса, то используйте его; в противном случае оставьте поле пустым.';
$string['idnumbergroup'] = 'ID группы';
$string['idnumbergroup_help'] = 'Идентификационный номер группы используется только при согласовании групп с внешними системами и нигде не будет отображаться на сайте. ID может быть введен, если группа имеет официально назначенный код; в противном случае поле может быть пустым.';
$string['idnumbergrouping'] = 'ID потока';
$string['idnumbergrouping_help'] = 'Идентификационный номер потока используется только при согласовании потока с внешними системами и нигде не будет отображаться на сайте. ID может быть введен, если поток имеет официально назначенный код; в противном случае поле может быть пустым.';
$string['idnumbermod'] = 'Идентификатор';
$string['idnumbermod_help'] = 'Установка идентификационного номера обеспечивает способ идентифицировать элемент курса при вычислении оценки. Если элемент не участвует в вычислении оценки, тогда поле идентификационный номер можно оставить пустым.

Идентификационный номер можно также установить в журнале оценок, но изменен он может быть только на странице редактирования элемента.';
$string['idnumbertaken'] = 'Этот номер ID уже занят';
$string['imagealt'] = 'Описание изображения';
$string['import'] = 'Импорт';
$string['importdata'] = 'Импортировать данные курса';
$string['importdataexported'] = 'Данные из курса экспортированы успешно.<br />Продолжайте импортировать их в другой свой  курс.';
$string['importdatafinished'] = 'Импорт завершен! Перейдите в Ваш курс.';
$string['importdatafrom'] = 'Поиск курса для импорта данных:';
$string['inactive'] = 'Не активно';
$string['include'] = 'Включить';
$string['includeallusers'] = 'Включая всех пользователей';
$string['includecoursefiles'] = 'Включая файлы курса';
$string['includecourseusers'] = 'Включая пользователей курсов';
$string['included'] = 'Включены';
$string['includelogentries'] = 'Включать записи журнала событий';
$string['includemodules'] = 'Включая модули';
$string['includemoduleuserdata'] = 'Включать данные пользователей модуля';
$string['includeneededusers'] = 'Включая необходимых пользователей';
$string['includenoneusers'] = 'Не включать ни одного пользователя';
$string['includeroleassignments'] = 'Включая назначения ролей';
$string['includesitefiles'] = 'Включая файлы сайта, используемые в этом курсе';
$string['includeuserfiles'] = 'Включая пользовательские файлы';
$string['increasesections'] = 'Увеличить количество разделов';
$string['indicator:accessesafterend'] = 'Предоставлен доступ к курсу после даты окончания';
$string['indicator:accessesafterend_help'] = 'Этот индикатор отражает, получил ли студент доступ к курсу после даты окончания курса.';
$string['indicator:accessesbeforestart'] = 'Предоставлен доступ к курсу до даты начала';
$string['indicator:accessesbeforestart_help'] = 'Этот показатель отражает, получил ли студент доступ к курсу до даты начала курса.';
$string['indicator:anywrite'] = 'Любое действие записи';
$string['indicator:anywrite_help'] = 'Этот показатель представляет собой любое действие записи (отправки), совершенное студентом.';
$string['indicator:anywriteincourse'] = 'Любое действие записи в курсе';
$string['indicator:anywriteincourse_help'] = 'Этот показатель представляет собой любое действие записи (отправки), совершенное студентом в любом активном элементе курса.';
$string['indicator:completeduserprofile'] = 'Профиль пользователя завершен';
$string['indicator:completeduserprofile_help'] = 'Этот показатель отображает, что студент завершил свой профиль пользователя.';
$string['indicator:completionenabled'] = 'Включено отслеживание завершения';
$string['indicator:completionenabled_help'] = 'Этот показатель отображает, что для этого курса включено отслеживание завершения.';
$string['indicator:nostudent'] = 'Нет студентов';
$string['indicator:nostudent_help'] = 'Данный показатель отображает, что этот курс не имеет студентов';
$string['indicator:noteacher'] = 'Нет преподавателей';
$string['indicator:noteacher_help'] = 'Данный показатель отображает, что этот курс не имеет преподавателей';
$string['indicator:potentialcognitive'] = 'Потенциальная глубина познания курса';
$string['indicator:potentialcognitive_help'] = 'Этот показатель основан на потенциальной глубине познания, которая может быть достигнута студентом, принимающим участие в элементах курса.';
$string['indicator:potentialsocial'] = 'Потенциальная социальная широта курса';
$string['indicator:potentialsocial_help'] = 'Этот показатель основан на потенциальной широте общения, которая может быть достигнута студентом, принимающим участие в элементах курса.';
$string['indicator:readactions'] = 'Количество прочитанных действий';
$string['indicator:readactions_help'] = 'Данный индикатор отображает количество прочитанных (просмотренных) действий, предпринятых студентом.';
$string['indicator:userforumstracking'] = 'Пользователь отслеживает форумы';
$string['indicator:userforumstracking_help'] = 'Этот показатель показывает, включено ли студентом отслеживание на форумах.';
$string['info'] = 'Информация';
$string['institution'] = 'Учреждение (организация)';
$string['instudentview'] = 'студенческий вид';
$string['interests'] = 'Интересы';
$string['interestslist'] = 'Список интересов';
$string['interestslist_help'] = 'Введите свои интересы, один за другим, они потом будут отображаться на странице Вашего профиля в виде тегов.';
$string['invalidemail'] = 'Некорректный формат адреса электронной почты';
$string['invalidlogin'] = 'Неверный логин или пароль, попробуйте заново.';
$string['invalidusername'] = 'Имя пользователя может содержать только буквенно-цифровые символы в нижнем регистре, символ подчеркивания (_), дефис (-), точку (.) или символ @';
$string['invalidusernameupload'] = 'Некорректный логин';
$string['ip_address'] = 'IP-адрес';
$string['jump'] = 'Перейти';
$string['jumpto'] = 'Перейти на...';
$string['keep'] = 'Хранить';
$string['keepsearching'] = 'Продолжить поиск';
$string['langltr'] = 'Направления вывода символов - слева направо';
$string['langrtl'] = 'Направления вывода символов - справа налево';
$string['language'] = 'Язык';
$string['languagegood'] = 'Установлен самая последняя версия языкового пакета! :-)';
$string['last'] = 'Последняя';
$string['lastaccess'] = 'Последний вход';
$string['lastcourseaccess'] = 'Последний доступ к курсу';
$string['lastedited'] = 'Последнее редактирование';
$string['lastip'] = 'Последний IP-адрес';
$string['lastlogin'] = 'Последний вход';
$string['lastmodified'] = 'Последнее изменение';
$string['lastname'] = 'Фамилия';
$string['lastnamephonetic'] = 'Фамилия - фонетическая запись';
$string['lastsiteaccess'] = 'Последний доступ к сайту';
$string['lastyear'] = 'Последний год';
$string['latestlanguagepack'] = 'Проверить наличие обновленной версии языкового пакета на moodle.org';
$string['layouttable'] = 'Таблица размещения';
$string['leavetokeep'] = 'Оставьте поле пустым, чтобы сохранить текущий пароль';
$string['legacylogginginuse'] = 'В настоящий момент на этом сайте разрешена запись в устаревший журнал событий. Записи в этот журнал событий являются устаревшими. Пожалуйста, ведите записи в поддерживаемые журналы событий - стандартный или внешний.';
$string['legacythemeinuse'] = 'У Вас этот сайт отображается в режиме совместимости, потому что ваш браузер слишком устарел.';
$string['license'] = 'Лицензия';
$string['licenses'] = 'Лицензии';
$string['liketologin'] = 'Вы хотите войти в систему от своего имени?';
$string['list'] = 'Список';
$string['listfiles'] = 'Список файлов в {$a}';
$string['listofallpeople'] = 'Список участников';
$string['listofcourses'] = 'Список курсов';
$string['loading'] = 'Загрузка';
$string['loadinghelp'] = 'Загрузка ...';
$string['local'] = 'Локальный';
$string['localplugins'] = 'Локальные плагины';
$string['localpluginsmanage'] = 'Управление локальными плагинами';
$string['location'] = 'Размещение';
$string['locktimeout'] = 'Для операции истекло время ожидания для блокировки.';
$string['log_excel_date_format'] = 'd mmmm yyyy h:mm';
$string['loggedinas'] = 'Вы зашли под именем {$a}';
$string['loggedinasguest'] = 'Вы используете гостевой доступ';
$string['loggedinnot'] = 'Вы не вошли в систему';
$string['login'] = 'Вход';
$string['loginactivity'] = 'Входы в систему';
$string['loginalready'] = 'Вы уже вошли в систему';
$string['loginas'] = 'Зайти под именем';
$string['loginaspasswordexplain'] = '<p>Чтобы использовать эту функцию Вы должны ввести специальный пароль для входа под другим именем.<br /> Если Вы его не знаете, спросите у администратора сервера. </p>';
$string['login_failure_logs'] = 'Журнал неудачных попыток входа';
$string['loginguest'] = 'Зайти гостем';
$string['loginsite'] = 'Вход на сайт';
$string['loginsteps'] = 'Для полноценного доступа к этому сайту Вам необходимо сначала создать учетную запись.';
$string['loginstepsnone'] = '<p>Здравствуйте!</p>
<p> Для полного доступа к курсам Вам необходимо создать себе учетную запись. </p> <p> Все, что Вам нужно сделать, это придумать логин и пароль и ввести его в форму на этой странице! </p> <p> Если кто-то уже выбрал этот логин, то придется попробовать еще раз, используя другой.</p>';
$string['loginto'] = 'Зайти на {$a}';
$string['logout'] = 'Выход';
$string['logoutconfirm'] = 'Вы действительно хотите выйти?';
$string['logs'] = 'Журнал событий';
$string['logtoomanycourses'] = '[ <a href="{$a->url}">подробнее</a> ]';
$string['logtoomanyusers'] = '[ <a href="{$a->url}">подробнее</a> ]';
$string['lookback'] = 'За период';
$string['mailadmins'] = 'Сообщить администраторам';
$string['mailstudents'] = 'Сообщить студентам';
$string['mailteachers'] = 'Сообщить преподавателям';
$string['maincoursepage'] = 'Главная страница курса';
$string['makeafolder'] = 'Создать папку';
$string['makeavailable'] = 'Сделать доступным';
$string['makeeditable'] = 'Если процесс веб-сервера (например, Apache) может редактировать «{$a}», тогда и Вы сможете отредактировать этот файл прямо на этой странице';
$string['makethismyhome'] = 'Сделать эту страницу моей домашней';
$string['makeunavailable'] = 'Сделать недоступным';
$string['manageblocks'] = 'Блоки';
$string['managecategorythis'] = 'Управление категорией';
$string['managecourses'] = 'Управление курсами';
$string['managedatabase'] = 'База данных';
$string['managedataformats'] = 'Управление форматами данных';
$string['manageeditorfiles'] = 'Управление файлами, использующимися редактором';
$string['managefilters'] = 'Фильтры';
$string['managemodules'] = 'Модули';
$string['manageroles'] = 'Роли и разрешения';
$string['markallread'] = 'Пометить все прочитанным';
$string['markedthistopic'] = 'Эта тема выделена как текущая';
$string['markthistopic'] = 'Выделить тему как текущую';
$string['matchingsearchandrole'] = 'Соответствует шаблону «{$a->search}» и «{$a->role}»';
$string['maxareabytesreached'] = 'Файл (или общий размер нескольких файлов) больше, чем оставшееся пространство в этой области.';
$string['maxfilesize'] = 'Максимальный размер для новых файлов: {$a}';
$string['maxfilesreached'] = 'К этому элементу разрешено прикреплять не более {$a} файла(ов)';
$string['maximumchars'] = 'Максимум символов: {$a} ';
$string['maximumgrade'] = 'Максимальная оценка';
$string['maximumgradex'] = 'Максимальная оценка: {$a}';
$string['maximumshort'] = 'Макс.';
$string['maximumupload'] = 'Максимальный размер загружаемого файла';
$string['maximumupload_help'] = 'Эта установка определяет максимальный размер файла, который может быть загружен в курс. Она не может превышать значения, установленного администратором для всего сайта. У отдельных элементов курса тоже есть настройка максимального размера загружаемого файла для дополнительного ограничения этого размера.';
$string['maxnumberweeks'] = 'Максимальное количество разделов';
$string['maxnumberweeks_desc'] = 'Максимальное значение количества разделов в выпадающем меню (распространяется только на конкретный формат курса).';
$string['maxnumcoursesincombo'] = 'Обзор <a href="{$a->link}">{$a->numberofcourses} курсов</a>.';
$string['maxsectionslimit'] = 'Невозможно создать новый раздел, так как он превышает максимально допустимое количество разделов для этого курса ({$a})';
$string['maxsize'] = 'Максимальный размер: {$a}';
$string['maxsizeandareasize'] = 'Максимальный размер файла: {$a->size}, суммарное ограничение: {$a->areasize}';
$string['maxsizeandattachments'] = 'Максимальный размер новых файлов: {$a->size}, максимальное количество прикрепленных файлов: {$a->attachments}';
$string['maxsizeandattachmentsandareasize'] = 'Максимальный размер файла: {$a->size}, доступно вложений: {$a->attachments}, суммарное ограничение: {$a->areasize}';
$string['memberincourse'] = 'Участники курса';
$string['messagebody'] = 'Текст сообщения';
$string['messagedselectedcountusersfailed'] = 'Возникла проблема и сообщения ({$a}) не были отправлены.';
$string['messagedselecteduserfailed'] = 'Сообщение не было отправлено пользователю {$a->fullname}.';
$string['messagedselectedusers'] = 'Выбранные пользователи были уведомлены и список получателей был очищен.';
$string['messagedselectedusersfailed'] = 'При уведомлении выбранных пользователей что-то пошло не так. Некоторые, возможно, получили сообщение по электронной почте.';
$string['messageprovider:availableupdate'] = 'Уведомления о наличии обновлений';
$string['messageprovider:backup'] = 'Уведомления о резервном копировании';
$string['messageprovider:badgecreatornotice'] = 'Уведомления создателям значков';
$string['messageprovider:badgerecipientnotice'] = 'Уведомления получателям значков';
$string['messageprovider:competencyplancomment'] = 'Опубликован комментарий к плану обучения';
$string['messageprovider:competencyusercompcomment'] = 'Опубликован комментарий к компетенции';
$string['messageprovider:courserequestapproved'] = 'Уведомление о подтверждении запроса на создание курса';
$string['messageprovider:courserequested'] = 'Уведомление о запросе на создание курса';
$string['messageprovider:courserequestrejected'] = 'Уведомление об отклонении запроса на создание курса';
$string['messageprovider:errors'] = 'Важные ошибки на сайте';
$string['messageprovider:errors_help'] = 'Это важные ошибки, о которых администратору следует знать.';
$string['messageprovider:insights'] = 'Знания, сгенерированные моделями прогнозирования';
$string['messageprovider:instantmessage'] = 'Личные сообщения между пользователями';
$string['messageprovider:instantmessage_help'] = 'В этом разделе настраивается, что происходит с сообщениями, которые отправляют Вам другие пользователи этого сайта.';
$string['messageprovider:messagecontactrequests'] = 'Сообщение контактов запрашивает уведомление';
$string['messageprovider:notices'] = 'Уведомления о незначительных проблемах';
$string['messageprovider:notices_help'] = 'Это уведомления, которые могут быть интересны администратору.';
$string['messageselect'] = 'Выбрать этого пользователя в качестве получателя сообщения';
$string['messageselectadd'] = 'Отправить сообщение';
$string['middlename'] = 'Отчество или второе имя';
$string['migratinggrades'] = 'Перенос оценок';
$string['min'] = 'мин.';
$string['mins'] = 'мин.';
$string['minute'] = 'минут';
$string['minutes'] = 'мин.';
$string['miscellaneous'] = 'Разное';
$string['missingcategory'] = 'Выберите категорию';
$string['missingdescription'] = 'Заполните поле';
$string['missingemail'] = 'Заполните поле';
$string['missingfirstname'] = 'Заполните поле';
$string['missingfromdisk'] = 'Отсутствует на диске';
$string['missingfullname'] = 'Заполните поле';
$string['missinglastname'] = 'Заполните поле';
$string['missingname'] = 'Заполните поле';
$string['missingnewpassword'] = 'Заполните поле';
$string['missingpassword'] = 'Заполните поле';
$string['missingrecaptchachallengefield'] = 'Сбой вызова reCAPTCHA, повторите попытку.';
$string['missingreqreason'] = 'Заполните поле';
$string['missingshortname'] = 'Не указано краткое название';
$string['missingshortsitename'] = 'Заполните поле';
$string['missingsitedescription'] = 'Заполните поле';
$string['missingsitename'] = 'Заполните поле';
$string['missingstrings'] = 'Проверка перевода';
$string['missingstudent'] = 'Необходимо кого-нибудь выбрать';
$string['missingsummary'] = 'Отсутствует описание';
$string['missingteacher'] = 'Необходимо кого-нибудь выбрать';
$string['missingurl'] = 'Отсутствует URL';
$string['missingusername'] = 'Не указан логин';
$string['moddoesnotsupporttype'] = 'Модуль {$a->modname} не поддерживает загрузку типа {$a->type}';
$string['modhide'] = 'Скрыть';
$string['modified'] = 'Изменено';
$string['modshow'] = 'Показать';
$string['moduleintro'] = 'Описание';
$string['modulesetup'] = 'Установка таблиц базы данных для модуля';
$string['modulesuccess'] = 'Таблицы для модуля «{$a}» успешно установлены';
$string['modulesused'] = 'Модулей используется';
$string['modvisible'] = 'Доступность';
$string['modvisible_help'] = 'Если для параметра «Доступность» установлено значение «Отображать на странице курса», элемент курса или ресурс будет доступен для студентов (при соблюдении ограничений доступа, если они установлены).<br><br>
Если для параметра «Доступность» установлено значение «Скрыть от студентов», элемент курса или ресурс будет доступен только пользователям с разрешением на просмотр скрытых элементов; по умолчанию это пользователи с ролью «Учитель» или «Ассистент (без права редактирования)».';
$string['modvisiblehiddensection'] = 'Доступность';
$string['modvisiblehiddensection_help'] = 'Если для параметра «Доступность» установлено значение «Скрыть от студентов», элемент курса или ресурс будет доступен только пользователям с разрешением на просмотр скрытых элементов; по умолчанию это пользователи с ролью «Учитель» или «Ассистент (без права редактирования)».<br><br>
Когда курс содержит много элементов или ресурсов, можно упростить страницу курса, установив для параметра «Доступность» значение «Сделать доступным, но не отображать на странице курса». В этом случае ссылка на элемент курса или ресурс должна предоставляться другим способом, например, с помощью ресурса типа «Страница». Элемент курса по прежнему будет отображаться в журнале оценок и других отчетах.';
$string['modvisiblewithstealth'] = 'Доступность';
$string['modvisiblewithstealth_help'] = 'Если для параметра «Доступность» установлено значение «Отображать на странице курса», элемент курса или ресурс будет доступен для студентов (при соблюдении ограничений доступа, если они установлены).<br><br>
Если для параметра «Доступность» установлено значение «Скрыть от студентов», элемент курса или ресурс будет доступен только пользователям с разрешением на просмотр скрытых элементов; по умолчанию это пользователи с ролью «Учитель» или «Ассистент (без права редактирования)».<br><br>
Когда курс содержит много элементов или ресурсов, можно упростить страницу курса, установив для параметра «Доступность» значение «Сделать доступным, но не отображать на странице курса». В этом случае ссылка на элемент курса или ресурс должна предоставляться другим способом, например, с помощью ресурса типа «Страница». Элемент курса по прежнему будет отображаться в журнале оценок и других отчетах.';
$string['month'] = 'Месяц';
$string['months'] = 'Месяцы';
$string['moodledocs'] = 'Документация Moodle';
$string['moodledocslink'] = 'Документация Moodle для этой страницы';
$string['moodlelogo'] = 'Логотип Moodle';
$string['moodlerelease'] = 'Релиз Moodle';
$string['moodleversion'] = 'Версия Moodle';
$string['more'] = 'подробнее';
$string['morehelp'] = 'Подробнее';
$string['moreinfo'] = 'Подробнее';
$string['moreinformation'] = 'Подробнее об этой ошибке';
$string['morenavigationlinks'] = 'Больше...';
$string['moreprofileinfoneeded'] = 'Пожалуйста, расскажите нам о себе';
$string['mostrecently'] = 'последний';
$string['move'] = 'Перенести';
$string['movecategoriessuccess'] = 'Категории ({$a->count} шт.) успешно перемещены в категорию «{$a->to}»';
$string['movecategoriestotopsuccess'] = 'Категории ({$a->count} шт.) успешно перемещены на верхний уровень';
$string['movecategorycontentto'] = 'Переместить в';
$string['movecategorysuccess'] = 'Категория «{$a->moved}» успешно перемещена в категорию «{$a->to}»';
$string['movecategoryto'] = 'Переместить категорию в:';
$string['movecategorytotopsuccess'] = 'Категория «{$a->moved}» успешно перемещена на верхний уровень';
$string['movecontent'] = 'Переместить {$a}';
$string['movecontentafter'] = 'После «{$a}»';
$string['movecontentstoanothercategory'] = 'Переместить содержимое в другую категорию';
$string['movecontenttothetop'] = 'К началу списка';
$string['movecoursemodule'] = 'Переместить ресурс';
$string['movecoursesection'] = 'Переместить раздел';
$string['movecourseto'] = 'Переместить курс в:';
$string['movedown'] = 'Переместить вниз';
$string['movefilestohere'] = 'Переместить файлы сюда';
$string['movefull'] = 'Перенести {$a} в эту позицию';
$string['movehere'] = 'Перенести сюда';
$string['moveleft'] = 'Переместить влево';
$string['moveright'] = 'Переместить вправо';
$string['movesection'] = 'Переместить раздел «{$a}»';
$string['moveselectedcategoriesto'] = 'Переместить выбранные категории в';
$string['moveselectedcoursesto'] = 'Переместить выбранные курсы в ...';
$string['movetoanotherfolder'] = 'Переместить в другой каталог';
$string['moveup'] = 'Переместить вверх';
$string['msnid'] = 'MSN ID';
$string['mustchangepassword'] = 'Новый пароль должен отличаться от текущего';
$string['mustconfirm'] = 'Необходимо подтвердить учетную запись';
$string['mycourses'] = 'Мои курсы';
$string['myfiles'] = 'Мои личные файлы';
$string['myfilesmanage'] = 'Мои личные файлы';
$string['myhome'] = 'Личный кабинет';
$string['mymoodledashboard'] = 'Личный кабинет';
$string['myprofile'] = 'Мой профиль';
$string['name'] = 'Название';
$string['namedfiletoolarge'] = 'Файл «{$a->filename}» слишком большой и не может быть загружен на сайт';
$string['nameforlink'] = 'Как Вы хотите назвать эту ссылку?';
$string['nameforpage'] = 'Название';
$string['navigation'] = 'Навигация';
$string['needed'] = 'Необходимы';
$string['networkdropped'] = 'Обнаружено, что подключение к Интернету ненадежно или было прервано. <br /> Помните, что изменения не могут быть сохранены должным образом, пока подключение не улучшится.';
$string['never'] = 'Никогда';
$string['neverdeletelogs'] = 'Никогда не удалять записи журнала событий';
$string['new'] = 'Новый';
$string['newaccount'] = 'Новая учетная запись';
$string['newactivityname'] = 'Новое название для элемента {$a}';
$string['newcourse'] = 'Новый курс';
$string['newpassword'] = 'Новый пароль';
$string['newpasswordfromlost'] = '<strong>ВНИМАНИЕ:</strong>Ваш <strong> текущий пароль</strong> выслан Вам во <strong>втором</strong> из двух сообщений, отправленных в ходе восстановления пароля. Прежде чем продолжить, убедитесь, что Вы получили свой измененный пароль.';
$string['newpassword_help'] = 'Введите новый пароль или оставьте поле пустым чтобы сохранить текущий пароль.';
$string['newpasswordtext'] = 'Здравствуйте, {$a->firstname}.

Пароль Вашей учетной записи на сайте «{$a->sitename}» был аннулирован, и Вам был присвоен новый временный пароль.

Сейчас Вы можете зайти на сайт так:
Логин: {$a->username}
Пароль: {$a->newpassword}

В целях безопасности, зайдите на сайт и измените пароль:
  {$a->link}

В большинстве почтовых программ этот адрес должен выглядеть как синяя ссылка, на которую достаточно нажать. Если это не так, просто скопируйте этот адрес и вставьте его в строку адреса в верхней части окна Вашего браузера.

С уважением,
администратор сайта «{$a->sitename}»,
{$a->signoff}';
$string['newpicture'] = 'Новое изображение';
$string['newpicture_help'] = 'Чтобы добавить новое изображение, выберите его (в формате JPG или PNG) и нажмите «Обновить профиль». Изображение будет обрезано до квадрата размером 100х100 пикселей.';
$string['newpictureusernotsetup'] = 'Изображение может быть добавлено в профиль только после того, как будет сохранена вся обязательная информация профиля.';
$string['newsectionname'] = 'Новое название для раздела {$a}';
$string['newsitem'] = 'новость';
$string['newsitems'] = 'объявления';
$string['newsitemsnumber'] = 'Количество отображаемых объявлений';
$string['newsitemsnumber_help'] = 'Форум объявлений - это специальный форум, автоматически создаваемый в курсе. По умолчанию на него подписаны все. Только участники с соответствующими разрешениями (по умолчанию - преподаватели) могут размещать в нем сообщения.

Этот параметр определяет количество элементов в блоке «Последние объявления» на странице курса.

Если форум объявлений в курсе не используется, то в данном параметре следует установить значение «0».';
$string['newuser'] = 'Новый пользователь';
$string['newusernewpasswordsubj'] = 'Новая учетная запись';
$string['newusernewpasswordtext'] = 'Здравствуйте, {$a->firstname}!

На сайте «{$a->sitename}» для Вас была создана новая учетная запись с временным паролем.

Сейчас Вы можете зайти на сайт так:
Логин: {$a->username}
Пароль: {$a->newpassword}
(Вам придется сменить пароль при первом входе).

Чтобы начать использование сайта «{$a->sitename}», пройдите по адресу {$a->link}

В большинстве почтовых программ этот адрес должен выглядеть как синяя ссылка, на которую достаточно нажать. Если это не так, просто скопируйте этот адрес и вставьте его в строку адреса в верхней части окна Вашего браузера.

С уважением,
администратор сайта «{$a->sitename}»,
{$a->signoff}';
$string['newusers'] = 'Новые пользователи';
$string['newwindow'] = 'Новое окно';
$string['next'] = 'Далее';
$string['nextsection'] = 'Следующий раздел';
$string['no'] = 'Нет';
$string['noblockstoaddhere'] = 'Нет ни одного блока, который Вы могли бы добавить на эту страницу.';
$string['nobody'] = 'Никто';
$string['nochange'] = 'Не изменено';
$string['nocomments'] = 'Нет комментариев';
$string['nocourseactivity'] = 'Недостаточно курсовой активности между началом и концом курса';
$string['nocourseendtime'] = 'Курс не имеет времени окончания';
$string['nocourses'] = 'Нет курсов';
$string['nocoursesections'] = 'Нет разделов курса';
$string['nocoursesfound'] = 'Курсов со словами «{$a}» не найдено';
$string['nocoursestarttime'] = 'Курс не имеет времени начала';
$string['nocoursestudents'] = 'Нет студентов';
$string['nocoursesyet'] = 'В этой категории нет курсов';
$string['nodstpresets'] = 'Администратор не включил поддержку перехода на летнее время';
$string['nofilesselected'] = 'Ни одного файла не было выбрано для восстановления';
$string['nofilesyet'] = 'В этот курс еще не были загружены файлы';
$string['nofiltersapplied'] = 'Фильтры не применены';
$string['nograde'] = 'Без оценки';
$string['nohelpforactivityorresource'] = 'В настоящее время нет справки по этому ресурсу или элементу';
$string['noimagesyet'] = 'В этот курс еще не были загружены изображения';
$string['nologsfound'] = 'Записей не найдено';
$string['nomatchingusers'] = 'Нет пользователей, соответствующих шаблону «{$a}»';
$string['nomorecourses'] = 'Соответствующих курсов больше не найдено';
$string['nomoreidnumber'] = 'Не использовать ID-номер для избежания противоречий';
$string['none'] = 'Пусто';
$string['noneditingteacher'] = 'Ассистент (без права редактирования)';
$string['noneditingteacherdescription'] = 'Ассистент может преподавать в курсах и выставлять оценки, но он не может изменять содержание курса.';
$string['nonstandard'] = 'Нестандартный';
$string['nopendingcourses'] = 'Нет курсов, ожидающих подтверждения';
$string['nopotentialadmins'] = 'Нет потенциальных администраторов';
$string['nopotentialcreators'] = 'Нет потенциальных создателей курсов';
$string['nopotentialstudents'] = 'Нет потенциальных студентов';
$string['nopotentialteachers'] = 'Нет потенциальных преподавателей';
$string['norecentactivity'] = 'В последнее время деятельности не было';
$string['noreplybouncemessage'] = 'Вы отправили ответ на письмо, отправленное с адреса электронной почты для писем, не треубующих ответа. Если Вы пытались таким образом ответить на сообщение, опубликованное в форуме, отвечайте на него, пользуясь самим форумом сайта «{$a}».

Вот содержание Вашего сообщения  электронной почты:';
$string['noreplybouncesubject'] = '{$a} - сообщение без ответа.';
$string['noreplyname'] = 'Не нужно отвечать на это сообщение';
$string['noresetrecord'] = 'Отсутствует запись об этом запросе восстановления пароля. Пожалуйста, инициируйте новый запрос восстановления пароля.';
$string['noresults'] = 'Нет результатов';
$string['normal'] = 'Обычный';
$string['normalfilter'] = 'Нормальный поиск';
$string['nosite'] = 'Невозможно найти главный курс уровня сайта';
$string['nostudentsfound'] = '{$a}  не найдено';
$string['nostudentsingroup'] = 'Студентов в этой группе пока нет';
$string['nostudentsyet'] = 'На этот курс пока не записан ни один студент';
$string['nosuchemail'] = 'Такого e-mail адреса не существует';
$string['notavailable'] = 'Не доступен';
$string['notavailablecourse'] = '{$a} не доступен';
$string['noteachersyet'] = 'В курсе нет преподавателей';
$string['notenrolled'] = 'Пользователь «{$a}» не записан на этот курс.';
$string['notenrolledprofile'] = 'Этот профиль не доступен, потому что пользователь не записан на этот курс.';
$string['noteusercannotrolldatesoncontext'] = '<strong>Примечание:</strong> Восстановление архива к выбранным датам невозможно, т.к. Вы не имеете на это права.';
$string['noteuserschangednonetocourse'] = '<strong>Примечание:</strong> Пользователи курса должны быть восстановлены при восстановлении пользовательских данных (в элементах, файлах или сообщениях). Для Вас этот параметр был изменен.';
$string['nothingnew'] = 'Со времени Вашего последнего входа ничего не произошло';
$string['nothingtodisplay'] = 'Нечего показывать';
$string['notice'] = 'Уведомление';
$string['noticenewerbackup'] = 'Этот файл резервной копии был создан с помощью более новой версии Moodle {$a->backuprelease} ({$a->backupversion}), чем ваша текущая версия Moodle {$a->serverrelease} ({$a->serverversion}). Это может привести к несоответствиям, поскольку обратная совместимость файлов резервных копий не гарантируется.';
$string['notifications'] = 'Уведомления';
$string['notifyloginfailuresmessage'] = '{$a->time}, IP: {$a->ip}, Пользователь: {$a->info}, Полное имя пользователя: {$a->name}';
$string['notifyloginfailuresmessageend'] = 'Вы можете просмотреть эти события по ссылке {$a}.';
$string['notifyloginfailuresmessagestart'] = 'Это список ошибочных попыток входа на сайт {$a} с момента последнего уведомления';
$string['notifyloginfailuressubject'] = '{$a} :: Уведомление об ошибках входа в систему';
$string['notincluded'] = 'Не включено';
$string['notingroup'] = 'Извините, но Вы должны быть участником группы, чтобы видеть эту страницу.';
$string['notpublic'] = 'Не для всех!';
$string['nousersfound'] = 'Пользователи не найдены';
$string['nousersmatching'] = 'Не найдено пользователей, соответствующих шаблону «{$a}»';
$string['nousersyet'] = 'Пока нет ни одного пользователя';
$string['novalidcourses'] = 'Нет доступных курсов для отображения';
$string['now'] = 'сейчас';
$string['numattempts'] = 'Неудачных попыток входа - {$a} ';
$string['numberofcourses'] = 'Количество курсов';
$string['numberweeks'] = 'Количество разделов';
$string['numday'] = '{$a} д.';
$string['numdays'] = '{$a} дн.';
$string['numhours'] = '{$a} ч.';
$string['numletters'] = '{$a} симв.';
$string['numminutes'] = '{$a} мин.';
$string['nummonth'] = '{$a} мес.';
$string['nummonths'] = '{$a} мес.';
$string['numseconds'] = '{$a} сек.';
$string['numviews'] = 'просмотров - {$a}';
$string['numweek'] = '{$a} нед.';
$string['numweeks'] = '{$a} нед.';
$string['numwords'] = 'всего слов - {$a}';
$string['numyear'] = '{$a} г.';
$string['numyears'] = '{$a} г.';
$string['ok'] = 'OK';
$string['oldpassword'] = 'Текущий пароль';
$string['olduserdirectory'] = 'Это - СТАРЫЙ каталог пользователей, он больше не нужен. Вы можете удалить его. Файлы, которые он содержит, были скопированы в НОВЫЙ каталог пользователей.';
$string['optional'] = 'необязательно';
$string['options'] = 'опции';
$string['order'] = 'Порядок';
$string['originalpath'] = 'Оригинальный путь';
$string['orphanedactivitiesinsectionno'] = 'Потерянные элементы курса (раздел {$a})';
$string['other'] = 'Другие';
$string['outline'] = 'Структура';
$string['outlinereport'] = 'Краткий отчет';
$string['page'] = 'Страница';
$string['pagea'] = 'Страница {$a}';
$string['pagedcontentnavigation'] = 'Нумерация страниц';
$string['pagedcontentnavigationactiveitem'] = 'Текущая страница, страница {$a}';
$string['pagedcontentnavigationitem'] = 'Перейти на страницу {$a}';
$string['pagedcontentpagingbaritemsperpage'] = 'Показывать {$a} элементов на странице';
$string['pageheaderconfigablock'] = 'Настройка блока в {$a->fullname}';
$string['pagepath'] = 'Путь к странице';
$string['pageshouldredirect'] = 'Эта страница автоматического перенаправления. Если ничего не происходит, воспользуйтесь указанной ниже ссылкой «Продолжить».';
$string['parentcategory'] = 'Родительская категория';
$string['parentcoursenotfound'] = 'Родительский курс не найден!';
$string['parentfolder'] = 'Родительская папка';
$string['participants'] = 'Участники';
$string['participantscount'] = 'Число участников: {$a}';
$string['participantslist'] = 'Список участников';
$string['participationratio'] = 'Коэффициент участия';
$string['participationreport'] = 'Отчет об участии';
$string['password'] = 'Пароль';
$string['passwordchanged'] = 'Пароль был изменен';
$string['passwordconfirmchange'] = 'Подтверждение изменения пароля';
$string['passwordextlink'] = 'Эта ссылка служит для восстановление забытого пароля. Это приведет к выходу из системы Moodle.';
$string['passwordforgotten'] = 'Восстановление забытого пароля';
$string['passwordforgotteninstructions'] = 'Ваши сведения должны быть найдены в базе данных.<br>Введите свой логин <strong>ИЛИ</strong> указанный при регистрации адрес электронной почты в соответствующее поле.<br>(Нет необходимости заполнять оба поля.)';
$string['passwordforgotteninstructions2'] = 'Для сброса пароля укажите ниже Ваш логин или адрес электронной почты. Если Ваша учетная запись есть в базе данных, на Ваш адрес электронной почты будет отправлено письмо, содержащее инструкции по восстановлению доступа.';
$string['passwordnohelp'] = 'Восстановление забытого пароля невозможно. Пожалуйста, обратитесь к администратору Moodle.';
$string['passwordrecovery'] = 'Да, помогите войти в систему';
$string['passwordsdiffer'] = 'Пароль не удовлетворяет требованиям безопасности';
$string['passwordsent'] = 'Пароль был отправлен';
$string['passwordsenttext'] = '<p>На адрес {$a->email} было отправлено письмо с Вашим логином и новым паролем.</p>
<p>Если Вы хотите изменить автоматически созданный пароль на более запоминающийся, то пройдите по <a href="{$a->link}">ссылке</a>.</p>';
$string['passwordset'] = 'Ваш пароль был установлен.';
$string['path'] = 'Путь';
$string['pathnotexists'] = 'Путь на сервере не найден!';
$string['pathslasherror'] = 'Путь не может заканчиваться символом «/»!!';
$string['paymentinstant'] = 'Используйте кнопку, чтобы произвести оплату и зарегистрироваться в течение нескольких минут!';
$string['paymentpending'] = '(<small>в ожидании - <b><u>{$a}</u></b></small>)';
$string['paymentrequired'] = 'Для регистрации на этом курсе требуется оплата';
$string['payments'] = 'Оплата';
$string['paymentsorry'] = 'Благодарим Вас за оплату! К сожалению, платеж еще не обработан и Вы не записаны на курс «{$a->fullname}». Пожалуйста, попробуйте зайти на курс через несколько секунд. Если у Вас не получится, пожалуйста, свяжитесь с пользователем «{$a->teacher}» или администратором сайта';
$string['paymentthanks'] = 'Благодарим Вас за оплату! Вы записаны на курс:<br />«{$a}»';
$string['pendingrequests'] = 'Запросы, ожидающие рассмотрения';
$string['percents'] = '{$a}%';
$string['periodending'] = 'Окончание периода ({$a})';
$string['perpage'] = 'На странице';
$string['perpagea'] = 'На странице: {$a}';
$string['personal'] = 'Личный';
$string['personalprofile'] = 'Личные данные';
$string['phone'] = 'Телефон';
$string['phone1'] = 'Телефон';
$string['phone2'] = 'Мобильный телефон';
$string['phpinfo'] = 'Информация о PHP';
$string['pictureof'] = 'Изображение пользователя {$a}';
$string['pictureofuser'] = 'Изображение пользователя';
$string['pleaseclose'] = 'Теперь, пожалуйста, закройте это окно.';
$string['pleasesearchmore'] = 'Поищите еще';
$string['pleaseusesearch'] = 'Используйте поиск';
$string['plugin'] = 'Плагин';
$string['plugincheck'] = 'Проверка плагинов';
$string['plugindeletefiles'] = 'Все данные, связанные с плагином «{$a->name}» были удалены из базы данных. Для предотвращения самоустановки плагина, Вы должны удалить этот каталог с сервера: {$a->directory}';
$string['pluginsetup'] = 'Установка таблиц плагина';
$string['policyaccept'] = 'Я понял(а) и согласен(на)';
$string['policyagree'] = 'Чтобы продолжить работу с этим сайтом, Вы должны принять Пользовательское соглашение. Вы согласны?';
$string['policyagreement'] = 'Пользовательское соглашение';
$string['policyagreementclick'] = 'Ссылка на пользовательское соглашение';
$string['popup'] = 'всплывающее окно';
$string['popupwindow'] = 'Открыть файл в новом окне';
$string['popupwindowname'] = 'Всплывающее окно';
$string['post'] = 'Сообщение';
$string['posts'] = 'Сообщения';
$string['potentialadmins'] = 'Потенциальные администраторы';
$string['potentialcreators'] = 'Потенциальные создатели курсов';
$string['potentialstudents'] = 'Потенциальные студенты';
$string['potentialteachers'] = 'Потенциальные преподаватели';
$string['preferences'] = 'Настройки';
$string['preferredlanguage'] = 'Предпочитаемый язык';
$string['preferredtheme'] = 'Предпочитаемая тема';
$string['preprocessingbackupfile'] = 'Предварительная обработка файла резервной копии';
$string['prev'] = 'Пред';
$string['preview'] = 'Предварительный просмотр';
$string['previewhtml'] = 'Предварительный просмотр текста в формате HTML';
$string['previeworchoose'] = 'Просмотр или выбор темы';
$string['previous'] = 'Назад';
$string['previouslyselectedusers'] = 'Ранее выбранные пользователи, не соответствующие шаблону «{$a}»';
$string['previoussection'] = 'Предыдущий раздел';
$string['primaryadminsetup'] = 'Настройка учетной записи администратора';
$string['privacy:metadata:config_log'] = 'Журнал изменений конфигурации.';
$string['privacy:metadata:config_log:name'] = 'Название изменяемого параметра.';
$string['privacy:metadata:config_log:oldvalue'] = 'Предыдущее значение для этого параметра.';
$string['privacy:metadata:config_log:plugin'] = 'Плагин изменился.';
$string['privacy:metadata:config_log:timemodified'] = 'Момент времени, когда было сделано изменение.';
$string['privacy:metadata:config_log:userid'] = 'Пользователь, который сделал изменение.';
$string['privacy:metadata:config_log:value'] = 'Новое значение для этого параметра.';
$string['privacy:metadata:events_queue'] = 'Очередь пользовательских событий, ожидающих обработки.';
$string['privacy:metadata:events_queue:eventdata'] = 'Данные, сохраненные в событии.';
$string['privacy:metadata:events_queue:stackdump'] = 'Отладочная информация стека, связанная с этим событием.';
$string['privacy:metadata:events_queue:timecreated'] = 'Момент времени, когда было создано это событие.';
$string['privacy:metadata:events_queue:userid'] = 'Идентификатор пользователя, связанного с этим событием.';
$string['privacy:metadata:log'] = 'Коллекция прошедших событий';
$string['privacy:metadata:log:action'] = 'Описание действия';
$string['privacy:metadata:log:cmid'] = 'cmid';
$string['privacy:metadata:log:course'] = 'курс';
$string['privacy:metadata:log:info'] = 'Дополнительная информация';
$string['privacy:metadata:log:ip'] = 'IP-адрес, использованный во время события';
$string['privacy:metadata:log:module'] = 'модуль';
$string['privacy:metadata:log:time'] = 'Дата, когда было выполнено действие.';
$string['privacy:metadata:log:url'] = 'URL, связанный с событием';
$string['privacy:metadata:log:userid'] = 'ID пользователя, выполнившего действие';
$string['privacy:metadata:task_adhoc'] = 'Статус задач adhoc.';
$string['privacy:metadata:task_adhoc:component'] = 'Компонент-владелец задачи.';
$string['privacy:metadata:task_adhoc:nextruntime'] = 'Самый ранний момент времени для запуска этой задачи.';
$string['privacy:metadata:task_adhoc:userid'] = 'Пользователь, от имени которого запускается задача.';
$string['privacy:metadata:upgrade_log'] = 'Журнал обновления.';
$string['privacy:metadata:upgrade_log:backtrace'] = 'Отладочная информация, связанная с этим шагом обновления.';
$string['privacy:metadata:upgrade_log:details'] = 'Дополнительная информация, связанная с обновлением.';
$string['privacy:metadata:upgrade_log:info'] = 'Основная информация для этого шага обновления.';
$string['privacy:metadata:upgrade_log:plugin'] = 'Плагин, который был обновлён.';
$string['privacy:metadata:upgrade_log:targetversion'] = 'Новая версия, до которой нужно обновиться.';
$string['privacy:metadata:upgrade_log:timemodified'] = 'Момент времени, когда было сделано обновление.';
$string['privacy:metadata:upgrade_log:type'] = 'Тип записи журнала.';
$string['privacy:metadata:upgrade_log:userid'] = 'Пользователь, запустивший обновление.';
$string['privacy:metadata:upgrade_log:version'] = 'Старая версия плагина.';
$string['privatefiles'] = 'Личные файлы';
$string['private_files_handler'] = 'Сохраняет файлы, прикрепленные к сообщениям электронной почты, в область личных файлов пользователя.';
$string['private_files_handler_name'] = 'Отправка файлов по электронной почте в область личных файлов';
$string['privatefilesmanage'] = 'Управление личными файлами';
$string['proceed'] = 'Перейти';
$string['profile'] = 'О пользователе';
$string['profilenotshown'] = 'Описание профиля недоступно, пока этот пользователь не запишется по крайней мере на один курс.';
$string['publicprofile'] = 'Публичный профиль';
$string['publicsitefileswarning'] = 'Замечание: Доступ к файлам, расположенным здесь, есть у всех';
$string['publicsitefileswarning2'] = 'Обратите внимание: К размещенным здесь файлам может получить доступ любой, кто знает (или может угадать) URL. Из соображений безопасности рекомендуется, чтобы любые файлы резервных копий были немедленно удалены сразу после восстановления.';
$string['publicsitefileswarning3'] = 'Обратите внимание: К размещенным здесь файлам может получить доступ любой, кто знает (или может угадать) URL.<br /> Из соображений безопасности фалы резервных копий должны сохраняться только в безопасной папке backupdata.';
$string['publish'] = 'Опубликовать';
$string['question'] = 'Вопрос';
$string['questionsinthequestionbank'] = 'Вопросов в банке вопросов';
$string['quotausage'] = 'В настоящее время вы использовали {$a->used} из своего лимита {$a->total}.';
$string['readinginfofrombackup'] = 'Чтение информации из файла бэкапа';
$string['readme'] = 'Файл «Прочти меня»';
$string['recentactivity'] = 'Последние действия';
$string['recentactivityreport'] = 'Полный отчет о последних действиях';
$string['recipientslist'] = 'Список получателей';
$string['recreatedcategory'] = 'Пересоздать категорию {$a}';
$string['redirect'] = 'Перенаправление';
$string['reducesections'] = 'Уменьшить количество разделов';
$string['refresh'] = 'Обновить';
$string['refreshingevents'] = 'Обновление событий';
$string['registration'] = 'Регистрация Moodle';
$string['registrationcontact'] = 'Публичный контакт';
$string['registrationcontactno'] = 'Нет, я не хочу, чтобы другие люди связывались со мной';
$string['registrationcontactyes'] = 'Да, предоставьте другим участникам Moodle форму для связи со мной';
$string['registrationemail'] = 'E-mail оповещения';
$string['registrationinfo'] = '<p>На этой странице Вы сможете зарегистрировать Ваш сайт под управлением Moodle на moodle.org. Регистрация бесплатная. Основное преимущество регистрации состоит в том, что Вы будете подписаны на небольшую по объему рассылку (на английском языке), содержащую срочные объявления об исправлениях в системе безопасности и выходе новых версий Moodle.</p>
<p>По умолчанию, Ваша информация будет считаться конфиденциальной и никогда не будет продаваться или передаваться кому-либо. Причины сбора такой информации - техническая поддержка и сбор статистической информации для представления картины мирового сообщества пользователей Moodle.</p>
<p>При желании, Вы можете разрешить добавить страну, название Вашего сайта и ссылку на него в публичный список сайтов, работающих под управлением Moodle.</p>
<p>Все новые регистрационные записи перед добавлением в список проверяются вручную, а после включения в список Вы сможете обновлять регистрационную информацию в любое время, отправляя эту форму заново.</p>';
$string['registrationinfotitle'] = 'Регистрационная информация';
$string['registrationno'] = 'Нет, я не хочу получать сообщения по электронной почте';
$string['registrationsend'] = 'Отправить регистрационную информацию на www.moodle.org';
$string['registrationyes'] = 'Да, сообщайте мне о важных новостях (например, проблемы безопасности или выпуски)';
$string['reject'] = 'Отклонить';
$string['rejectdots'] = 'Отклонить...';
$string['reload'] = 'Обновить';
$string['remoteappuser'] = 'Внешний пользователь системы «{$a}»';
$string['remove'] = 'Удалить';
$string['removeadmin'] = 'Удалить администратора';
$string['removecreator'] = 'Удалить создателя курса';
$string['removestudent'] = 'Удалить студента';
$string['removeteacher'] = 'Удалить преподавателя';
$string['rename'] = 'Переименовать';
$string['renamefileto'] = 'Переименовать <b>{$a}</b> в';
$string['report'] = 'Отчет';
$string['reports'] = 'Отчеты';
$string['repositories'] = 'Хранилища';
$string['requestcourse'] = 'Отправить запрос на создание курса';
$string['requestedby'] = 'Автор запроса';
$string['requestedcourses'] = 'Запрошенные курсы';
$string['requestreason'] = 'Причина запроса курса';
$string['requests'] = 'Запросы';
$string['required'] = 'Необходимо заполнить';
$string['requirespayment'] = 'Для доступа к этому курсу необходима оплата';
$string['resendemail'] = 'Отправить письмо еще раз';
$string['reset'] = 'Очистка';
$string['resetcomponent'] = 'Компонент';
$string['resetcourse'] = 'Очистка курса';
$string['resetinfo'] = 'На данной странице вы можете удалить из курса данные пользователей (попытки в тестах, сообщения в форумах и т.п.), сохраняя при этом содержимое элементов курса и другие настройки. Будьте осторожны! Действия на данной странице могут <strong>безвозвратно</strong> удалить данные ваших пользователей об их участии в элементах курса!';
$string['resetnotimplemented'] = 'Очистка не поддерживается';
$string['resetrecordexpired'] = 'Ссылка для восстановления пароля использовалась больше {$a} минут - она устарела и не действительна. Пожалуйста, инициируйте новое восстановление пароля.';
$string['resetstartdate'] = 'Сбросить дату начала';
$string['resetstatus'] = 'Состояние';
$string['resettable'] = 'Сбросить настройки таблицы';
$string['resettask'] = 'Задача';
$string['resettodefaults'] = 'Вернуть к значениям по умолчанию';
$string['resortcourses'] = 'Отсортировать курсы';
$string['resortsubcategoriesby'] = 'Сортировать подкатегории по возрастанию {$a}';
$string['resortsubcategoriesbyreverse'] = 'Сортировать подкатегории по убыванию {$a}';
$string['resource'] = 'Ресурс';
$string['resourcedisplayauto'] = 'Автоматически';
$string['resourcedisplaydownload'] = 'Принудительное скачивание';
$string['resourcedisplayembed'] = 'Внедрить';
$string['resourcedisplayframe'] = 'Во фрейме';
$string['resourcedisplaynew'] = 'В новом окне';
$string['resourcedisplayopen'] = 'Открыть';
$string['resourcedisplaypopup'] = 'Во всплывающем окне';
$string['resources'] = 'Ресурсы';
$string['resources_help'] = 'Различные типы ресурсов позволяют вставить в курс практически любое веб-содержимое.';
$string['restore'] = 'Восстановить';
$string['restorecancelled'] = 'Восстановление отменено';
$string['restorecannotassignroles'] = 'При восстановлении требуется назначение ролей, а Вы не имеете на это разрешения';
$string['restorecannotcreateorassignroles'] = 'При восстановлении требуется создание или назначение  ролей, а Вы не имеете на это разрешения';
$string['restorecannotcreateuser'] = 'При восстановлении требуется создание пользователя «{$a}» из резервной копии, а Вы не имеете на это разрешения';
$string['restorecannotoverrideperms'] = 'При восстановлении требуется переопределение роли, а Вы не имеете на это разрешения';
$string['restorecoursenow'] = 'Восстановить этот курс!';
$string['restoredaccount'] = 'Восстановленная учетная запись';
$string['restoredaccountinfo'] = 'Эта учетная запись была импортирована с другого сервера, и пароль был потерян. Чтобы установить новый пароль по электронной почте, пожалуйста, щелкните «Продолжить»';
$string['restorefinished'] = 'Восстановление успешно завершено';
$string['restoremnethostidmismatch'] = 'MNet host id пользователя «{$a}» не совпадает с локальным MNet host ID.';
$string['restoreto'] = 'Восстановить до';
$string['restoretositeadding'] = 'Предупреждение: Вы собираетесь восстановить главную страницу сайта, добавляя на нее данные!';
$string['restoretositedeleting'] = 'Предупреждение: Вы собираетесь восстановить главную страницу сайта, удалив с нее существующие данные!';
$string['restoreuserconflict'] = 'Попытка восстановления пользователя «{$a}» из файла резервной копии приводит к конфликту';
$string['restoreuserinfofailed'] = 'Процесс восстановления остановлен, потому что Вы не имеете разрешения восстанавливать пользовательские данные.';
$string['restoreusersprecheck'] = 'Проверка данных пользователя';
$string['restoreusersprecheckerror'] = 'Обнаружены проблемы при проверке данных пользователя';
$string['restricted'] = 'Ограничено';
$string['returningtosite'] = 'Уже были на этом сайте?';
$string['returntooriginaluser'] = 'Вернуться к {$a}';
$string['revert'] = 'Отменить';
$string['role'] = 'Роль';
$string['roleassignments'] = 'Назначения ролей';
$string['rolemappings'] = 'Сопоставления ролей';
$string['rolerenaming'] = 'Переименование ролей';
$string['rolerenaming_help'] = 'Этот параметр позволяет изменять отображаемые названия ролей, используемых в Вашем курсе. Изменяется только отображаемое название - основные разрешения роли не будут затронуты. Эти новые названия ролей будут отображаться на странице участников курса и во всех других местах в пределах курса. Если переименованная роль выбрана администратором в качестве роли управляющего курсом, то новое название роли будет также отображаться в списке курсов.';
$string['roles'] = 'Роли';
$string['rss'] = 'RSS';
$string['rssarticles'] = 'Количество недавних статей в формате RSS';
$string['rsserror'] = 'Ошибка при чтении RSS данных';
$string['rsserrorauth'] = 'Ваша RSS-ссылка не содержит требуемый признак аутентификации.';
$string['rsserrorguest'] = 'Эта RSS-лента использует гостевой доступ для доступа к данным, но гость не имеет разрешения на чтение данных. Посетите адрес, откуда была взята исходная ссылка на эту ленту, в качестве действующего пользователя и получите там новую ссылку на RSS-ленту.';
$string['rsskeyshelp'] = '<p>Для обеспечения безопасности и конфиденциальности адреса RSS-лент содержат специальный ключ, который идентифицирует пользователей, для которых они предназначены. Это ограничивает доступ других пользователей к тем областям системы Moodle, к которым они не должны иметь доступ с помощью RSS-лент.</p><p> Этот ключ автоматически создается при первом доступе к той области системы Moodle, в которой формируется RSS-лента. Если Вы считаете, что ключ RSS-ленты стал кому-то доступен, Вы можете запросить новый, нажав на ссылку «Очистка». Обратите внимание, что текущие ссылки на RSS-ленты при этом станут недействительными.</p>';
$string['rsstype'] = 'RSS-лента для этого элемента курса';
$string['save'] = 'Сохранить';
$string['saveandnext'] = 'Сoхранить и показать следующий';
$string['savechanges'] = 'Сохранить';
$string['savechangesanddisplay'] = 'Сохранить и показать';
$string['savechangesandreturn'] = 'Сохранить и вернуться';
$string['savechangesandreturntocourse'] = 'Сохранить и вернуться к курсу';
$string['savecomment'] = 'Сохранить комментарий';
$string['savedat'] = 'Сохранено в:';
$string['savepreferences'] = 'Сoхранить настройки';
$string['saveto'] = 'Сохранить в';
$string['scale'] = 'Шкала';
$string['scale_help'] = 'Шкала позволяет словесно оценивать результаты работы с элементами курса. Она представляет упорядоченный через запятые список значений, начиная с отрицательного к положительному, например: «Слишком плохо, Плохо, Средне, Хорошо, Очень хорошо, Великолепно!»';
$string['scales'] = 'Шкалы';
$string['scalescustom'] = 'Пользовательская шкала';
$string['scalescustomcreate'] = 'Добавить новую шкалу';
$string['scalescustomno'] = 'Не было создано ни одной пользовательской шкалы';
$string['scalesstandard'] = 'Стандартные шкалы';
$string['scalestandard'] = 'Стандартная шкала';
$string['scalestandard_help'] = 'Стандартная шкала доступна на всем сайте, для всех курсов.';
$string['scalestip'] = 'Чтобы создать пользовательские шкалы оценок, используйте ссылку «Шкалы» в меню «Управление курсом».';
$string['scalestip2'] = 'Чтобы создать пользовательские шкалы, в меню «Управление курсом» щелкните ссылку «Оценки», затем выберите «Шкалы».';
$string['schedule'] = 'Расписание';
$string['screenshot'] = 'Снимок экрана';
$string['search'] = 'Найти';
$string['searchagain'] = 'Возобновить поиск';
$string['searchbyemail'] = 'Поиск по адресу электронной почты';
$string['searchbyusername'] = 'Поиск по логину';
$string['searchcourses'] = 'Поиск курса';
$string['search_help'] = 'Для поиска одного или нескольких слов в тексте, просто введите их, разделяя пробелами. Используются все слова длиннее двух символов.

Для вызова формы расширенного поиска нажмите кнопку поиска ничего не вводя в поле.';
$string['searchoptions'] = 'Параметры поиска';
$string['searchresults'] = 'Результаты поиска';
$string['sec'] = 'сек.';
$string['seconds'] = 'сек.';
$string['secondsleft'] = '{$a} сек.';
$string['secondstotime172800'] = '2 дня';
$string['secondstotime259200'] = '3 дня';
$string['secondstotime345600'] = '4 дня';
$string['secondstotime432000'] = '5 дней';
$string['secondstotime518400'] = '6 дней';
$string['secondstotime604800'] = '1 неделя';
$string['secondstotime86400'] = '1 день';
$string['secretalreadyused'] = 'Ссылка подтверждения изменения пароля уже использовалась, пароль не был изменен.';
$string['secs'] = 'сек.';
$string['section'] = 'Раздел';
$string['sectionactionnotsupported'] = 'Действие раздела «{$a}» здесь не поддерживается';
$string['sectionname'] = 'Название раздела';
$string['sections'] = 'Разделы';
$string['sectionusedefaultname'] = 'Использовать название раздела по умолчанию';
$string['seealsostats'] = 'См. также: статистика';
$string['selctauser'] = 'Выберите пользователя';
$string['select'] = 'Выбрать';
$string['selectacategory'] = 'Пожалуйста, выберите категорию';
$string['selectacountry'] = 'Выберите страну';
$string['selectacourse'] = 'Выберите курс';
$string['selectacoursesite'] = 'Выберите курс или сайт';
$string['selectagroup'] = 'Выберите группу';
$string['selectall'] = 'Выбрать все';
$string['selectallusersonpage'] = 'Выбрать всех пользователей на странице';
$string['selectalluserswithcount'] = 'Выбрать всех пользователей - {$a}';
$string['selectamodule'] = 'Выберите элемент курса';
$string['selectanaction'] = 'Выберите действие';
$string['selectanoptions'] = 'Выберите вариант';
$string['selectaregion'] = 'Выберите регион';
$string['selectcategorysort'] = 'Какие категории Вы хотите отсортировать?';
$string['selectcategorysortby'] = 'Выберите, как Вы хотите упорядочить категории';
$string['selectcoursesortby'] = 'Выберите, как Вы хотите упорядочить курсы';
$string['selectdefault'] = 'Выбрать значение по умолчанию';
$string['selectedcategories'] = 'Выбранные категории';
$string['selectedfile'] = 'Выбранный файл';
$string['selectednowmove'] = 'Выбрано файлов для перемещения - {$a}. Выберите для них новую папку и в ней нажмите на кнопку «Переместить файлы сюда»';
$string['selectfiles'] = 'Выберите файлы';
$string['selectmoduletoviewhelp'] = 'Выберите модуль элемента курса или ресурса, чтобы просмотреть информацию о нём.

Двойной щелчок позволяет сразу перейти к добавлению этого модуля.';
$string['selectnos'] = 'Выделить все «нет»';
$string['selectperiod'] = 'Выбрать период';
$string['senddetails'] = 'Отправить мои данные по электронной почте';
$string['separate'] = 'Отдельные';
$string['separateandconnected'] = 'Будьте беспристрастным';
$string['separateandconnectedinfo'] = 'Шкала основана на теории независимого и связного познания. Эта теория описывает два различных способа изучения и оценки вещей, которые мы видим и о которых слышим.
<ul><li>Те, кто познают мир <strong>независимо</strong>, остаются, насколько возможно, объективными без учета своих чувств и эмоций. В обсуждениях с другими людьми, у которых могут быть другие взгляды, им нравится защищать свои собственные идеи с использованием логики, чтобы найти слабые места в суждениях соперника. </li><li>Те же, кто познают мир <strong>связанно</strong> более восприимчивы к другим людям. Они зависимы от сопереживаний и склонны слушать и задавать вопросы, пока не почувствуют, что нашли связь и начали «понимать вещи с другой точки зрения». Они учатся, пытаясь заимствовать опыт и знания, которые они находят в других людях. </li></ul>';
$string['servererror'] = 'Произошла ошибка во время связи с сервером';
$string['serverlocaltime'] = 'Время на сервере';
$string['sessionforceclean'] = 'Из соображений безопасности созданные в этом сеансе пользовательские сценарии были отключены.';
$string['setcategorytheme'] = 'Установить тему оформления категории';
$string['setpassword'] = 'Установить пароль';
$string['setpasswordinstructions'] = 'Пожалуйста, введите новый пароль ниже, затем сохраните изменения.';
$string['settings'] = 'Настройки';
$string['shortname'] = 'Краткое имя';
$string['shortnamecollisionwarning'] = '[*] = Это короткое имя уже используется и должно быть изменено после одобрения';
$string['shortnamecourse'] = 'Краткое название курса';
$string['shortnamecourse_help'] = 'Краткое название курса отображается в элементах навигации и используется в теме сообщений электронной почты.';
$string['shortnametaken'] = 'Краткое название уже используется для другого курса ({$a})';
$string['shortnameuser'] = 'Краткое имя пользователя';
$string['shortsitename'] = 'Краткое название сайта (например, одним словом)';
$string['show'] = 'Показать';
$string['showactions'] = 'Показать действия';
$string['showadvancedsettings'] = 'Показать расширенные настройки';
$string['showall'] = 'Показать все {$a}';
$string['showallcourses'] = 'Показать курсы';
$string['showallusers'] = 'Показать всех пользователей';
$string['showblockcourse'] = 'Вывести список курсов, содержащих блок';
$string['showcategory'] = 'Показать {$a}';
$string['showchartdata'] = 'Показать данные диаграммы';
$string['showcomments'] = 'Отобразить/скрыть комментарии';
$string['showcommentsnonjs'] = 'Отобразить комментарии';
$string['showdescription'] = 'Отображать описание / вступление на странице курса';
$string['showdescription_help'] = 'При включении этого параметра указанное выше описание будет отображаться на странице курса под ссылкой на ресурс или элемент курса.';
$string['showgrades'] = 'Показывать журнал оценок студентам';
$string['showgrades_help'] = 'Многие элементы курса позволяют выставлять оценки. Этот параметр определяет, может ли студент посмотреть список всех своих оценок в курсе по ссылке «Оценки» в блоке «Управление курсом».';
$string['showingacourses'] = 'Отображаются все {$a} курса(ов)';
$string['showingxofycourses'] = 'Отображаются курсы с {$a->start} по  {$a->end}. Всего курсов: {$a->total}';
$string['showlistofcourses'] = 'Показать список курсов';
$string['showmodulecourse'] = 'Вывести список курсов, содержащих этот элемент';
$string['showoncoursepage'] = 'Отображать на странице курса';
$string['showonly'] = 'Показать только';
$string['showperpage'] = 'Показать по {$a} на странице';
$string['showpopoverwindow'] = 'Показать всплывающее окно';
$string['showrecent'] = 'Показать последние действия';
$string['showreports'] = 'Показывать отчеты о деятельности';
$string['showreports_help'] = 'Отчеты о деятельности доступны для каждого участника и отображают результаты его работы в курсе. Отчет может содержать подробный список действий пользователя, например, сообщения форума или представленные задания, эти отчеты также содержат записи журнала событий. Этот параметр определяет, сможет ли студент просматривать отчеты о своей собственной деятельности на странице своего профиля.';
$string['showsettings'] = 'Показать настройки';
$string['showtheselogs'] = 'Отобразить эти записи журнала событий';
$string['showthishelpinlanguage'] = 'Вывести эту справку на следующем языке: {$a}';
$string['sidepanel'] = 'Боковая панель';
$string['signoutofotherservices'] = 'Выйти отовсюду';
$string['signoutofotherservices_help'] = 'Если включено, будет осуществлен выход из учетной записи со всех устройств и систем, использующих веб-сервисы, таких, например, как мобильное приложение.';
$string['since'] = 'С';
$string['sincelast'] = 'с последнего входа';
$string['site'] = 'Сайт';
$string['sitedefault'] = 'Сайт по умолчанию';
$string['siteerrors'] = 'Ошибки сайта';
$string['sitefiles'] = 'Файлы сайта';
$string['sitefilesused'] = 'Файлы сайта, используемые в этом курсе';
$string['sitehome'] = 'Домашняя страница';
$string['sitelegacyfiles'] = 'Файлы сайта (устаревшее хранилище)';
$string['sitelogs'] = 'Записи журнала событий сайта';
$string['sitemessage'] = 'Сообщения пользователей';
$string['sitenews'] = 'Объявления сайта';
$string['sitepages'] = 'Страницы сайта';
$string['sitepartlist'] = 'Вы не имеете разрешения на просмотр списка участников';
$string['sitepartlist0'] = 'Для просмотра списка пользователей сайта Вы должны быть преподавателем на уровне сайта';
$string['sitepartlist1'] = 'Для просмотра списка участников курса Вы должны быть преподавателем в этом курсе';
$string['sites'] = 'Сайты';
$string['sitesection'] = 'Включить раздел курса';
$string['sitesettings'] = 'Настройки сайта';
$string['siteteachers'] = 'Преподаватели сайта';
$string['size'] = 'Размер';
$string['sizeb'] = 'байт';
$string['sizegb'] = 'Гбайт';
$string['sizekb'] = 'Кбайт';
$string['sizemb'] = 'Мбайт';
$string['skipped'] = 'Пропущено';
$string['skiptocategorylisting'] = 'Пропустить список категорий';
$string['skiptocoursedetails'] = 'Пропустить описание курсов';
$string['skiptocourselisting'] = 'Пропустить список курсов';
$string['skypeid'] = 'Skype ID';
$string['socialheadline'] = 'Общий форум - последние темы';
$string['someallowguest'] = 'Некоторые курсы, возможно, открыты для гостей';
$string['someerrorswerefound'] = 'Часть информации отсутствовала или была некорректна.  Детали смотрите ниже.';
$string['sort'] = 'Отсортировать';
$string['sortby'] = 'Сортировать по';
$string['sortbyx'] = 'Сортировать по столбцу «{$a}» по возрастанию';
$string['sortbyxreverse'] = 'Сортировать по столбцу «{$a}» по убыванию';
$string['sorting'] = 'Сортировка';
$string['sourcerole'] = 'Исходная роль';
$string['specifyname'] = 'Вы должны указать имя';
$string['standard'] = 'Стандартный';
$string['starpending'] = '([*] - курс, ожидающий одобрения)';
$string['startdate'] = 'Дата начала курса';
$string['startdate_help'] = 'Этот параметр определяет начало первой недели курса в формате «Разделы по неделям». Он также определяет начальную дату, с которой будут доступны  отчеты по элементам курса. Если курс был очищен и дата начала курса была изменена, все даты в курсе будут исправлены относительно новой даты начала курса.';
$string['startingfrom'] = 'Начиная с';
$string['startsignup'] = 'Создать учетную запись';
$string['state'] = 'Область/край';
$string['statistics'] = 'Статистика';
$string['statisticsgraph'] = 'График статистики';
$string['stats'] = 'Статистика';
$string['statslogins'] = 'Входы в систему';
$string['statsmodedetailed'] = 'Детализированный (по пользователям) вид';
$string['statsmodegeneral'] = 'Общий вид';
$string['statsnodata'] = 'Нет данных для выбранной комбинации курса и периода времени.';
$string['statsnodatauser'] = 'Нет данных для выбранной комбинации курса, пользователя и периода времени.';
$string['statsoff'] = 'Статистика отключена';
$string['statsreads'] = 'Просмотры';
$string['statsreport1'] = 'Входы в систему';
$string['statsreport10'] = 'Активность пользователей';
$string['statsreport11'] = 'Самые активные курсы';
$string['statsreport12'] = 'Самые активные курсы (взвешенно)';
$string['statsreport13'] = 'Наибольшая численность участников (записи на курс)';
$string['statsreport14'] = 'Наибольшая активность участников (просмотры/изменения)';
$string['statsreport2'] = 'Просмотры (все роли)';
$string['statsreport3'] = 'Сообщения (все роли)';
$string['statsreport4'] = 'Вся деятельность (все роли)';
$string['statsreport5'] = 'Вся деятельность (просмотры и сообщения)';
$string['statsreport7'] = 'Активность пользователей (просмотры и изменения)';
$string['statsreport8'] = 'Вся деятельность пользователей';
$string['statsreport9'] = 'Входы (главная страница)';
$string['statsreportactivity'] = 'Вся деятельность (все роли)';
$string['statsreportactivitybyrole'] = 'Вся деятельность (просмотры и изменения)';
$string['statsreportforuser'] = 'для';
$string['statsreportlogins'] = 'Входы';
$string['statsreportreads'] = 'Просмотры (все роли)';
$string['statsreporttype'] = 'Тип отчета';
$string['statsreportwrites'] = 'Изменения (все роли)';
$string['statsstudentactivity'] = 'Деятельность студентов';
$string['statsstudentreads'] = 'Студенты: просмотры';
$string['statsstudentwrites'] = 'Студенты: изменения';
$string['statsteacheractivity'] = 'Деятельность преподавателей';
$string['statsteacherreads'] = 'Преподаватели: просмотры';
$string['statsteacherwrites'] = 'Преподаватели: изменения';
$string['statstimeperiod'] = 'Период времени - последние:';
$string['statsuniquelogins'] = 'Уникальные входы';
$string['statsuseractivity'] = 'Вся активность';
$string['statsuserlogins'] = 'Входы в систему';
$string['statsuserreads'] = 'Просмотры';
$string['statsuserwrites'] = 'Изменения';
$string['statswrites'] = 'Изменения';
$string['status'] = 'Статус';
$string['stringsnotset'] = 'Следующие строки не определены в {$a}';
$string['studentnotallowed'] = 'К сожалению, Вы не можете войти в данный курс от имени пользователя «{$a}»';
$string['students'] = 'Студенты';
$string['studentsandteachers'] = 'Студенты и преподаватели';
$string['subcategories'] = 'Подкатегории';
$string['subcategory'] = 'Подкатегория';
$string['subcategoryof'] = 'Подкатегория категории «{$a}»';
$string['submit'] = 'Отправить';
$string['success'] = 'Успешно';
$string['successduration'] = 'Успешно ({$a} секунды)';
$string['summary'] = 'Описание';
$string['summary_help'] = 'Описание - это небольшой текст, рассказывающий студентам о дальнейшей деятельности в рамках этого раздела (темы или недели). Текст отображается на странице курса под названием раздела.';
$string['summaryof'] = 'Описание для «{$a}»';
$string['supplyinfo'] = 'Заполните информацию о себе';
$string['suspended'] = 'Заблокировано';
$string['suspendedusers'] = 'Заблокированные пользователи';
$string['switchdevicedefault'] = 'Переключить на стандартную тему';
$string['switchdevicerecommended'] = 'Переключить на тему, рекомендованную для Вашего устройства';
$string['switchrolereturn'] = 'Вернуться к моей обычной роли';
$string['switchroleto'] = 'Переключиться к роли...';
$string['switchroleto_help'] = 'Выберите роль, чтобы понять, каким этот курс выглядит для людей с этой ролью.

Обратите внимание, что в представлении могут быть недоработки (см. <a href="https://docs.moodle.org/en/Switch_roles">подробности и альтернативы</a>).';
$string['tag'] = 'Тег';
$string['tagalready'] = 'Этот тег уже существует';
$string['tagmanagement'] = 'Добавить/удалить теги...';
$string['tags'] = 'Теги';
$string['target:coursedropout'] = 'Студенты, которым грозит риск отчисления';
$string['target:coursedropout_help'] = 'Эта цель описывает, грозит ли студенту риск отчисления.';
$string['targetlabelstudentdropoutno'] = 'Нет риска отчисления';
$string['targetlabelstudentdropoutyes'] = 'Студенты, которым грозит отчисление';
$string['targetlabelteachingno'] = 'Нет преподавания';
$string['targetlabelteachingyes'] = 'Пользователи с возможностями обучения имеют доступ к курсу';
$string['target:noteachingactivity'] = 'Нет преподавания';
$string['target:noteachingactivity_help'] = 'Эта цель описывает, будут ли курсы, начинающиеся на следующей неделе, иметь преподавательскую деятельность.';
$string['targetrole'] = 'Роль в этом курсе';
$string['teacheronly'] = 'только для {$a}';
$string['teacherroles'] = '{$a} роли';
$string['teachers'] = 'Преподаватели';
$string['textediting'] = 'Текстовый редактор';
$string['textediting_help'] = 'Если выбран такой редактор HTML как Atto или TinyMCE, то поля ввода текста будут содержать панель инструментов с кнопками для упрощения добавления контента.

Если выбран «Простой текст», то для полей ввода текста можно выбрать формат HTML или Markdown.

Список доступных текстовых редакторов определяется администратором сайта.';
$string['texteditor'] = 'Использовать стандартные веб-формы';
$string['textformat'] = 'Текст';
$string['thanks'] = 'Спасибо';
$string['theme'] = 'Тема оформления';
$string['themes'] = 'Темы';
$string['themesaved'] = 'Новая тема выбрана';
$string['therearecourses'] = 'Всего курсов: {$a}';
$string['thereareno'] = 'В этом курсе нет элементов типа «{$a}»';
$string['thiscategory'] = 'Эта категория';
$string['thiscategorycontains'] = 'Содержимое этой категории';
$string['time'] = 'Время';
$string['timecreatedcourse'] = 'Время создания курса';
$string['timesplitting:deciles'] = 'Десятые доли';
$string['timesplitting:decilesaccum'] = 'Накапливающиеся десятые доли';
$string['timesplitting:decilesaccum_help'] = 'Этот метод разделения по времени делит курс на десятые доли (10 равных частей), причем каждый прогноз основывается на данных всех прошедших десятых долей.';
$string['timesplitting:deciles_help'] = 'Этот метод разделения по времени делит курс на десятые доли (10 равных частей), причем каждый прогноз основывается на данных только последней прошедшей десятой доли.';
$string['timesplitting:nosplitting'] = 'Нет разделения по времени';
$string['timesplitting:nosplitting_help'] = 'Для этой модели не определен метод разделения по времени.';
$string['timesplitting:quarters'] = 'Четверти';
$string['timesplitting:quartersaccum'] = 'Накапливающиеся четверти';
$string['timesplitting:quartersaccum_help'] = 'Этот метод разделения времени делит курс на четверти (4 равные части), причем каждый прогноз основывается на данных всех прошедших четвертей.';
$string['timesplitting:quarters_help'] = 'Этот метод разделения времени делит курс на четверти (4 равные части), причем каждый прогноз основывается на данных только последней прошедшей четверти.';
$string['timesplitting:singlerange'] = 'Одиночный диапазон';
$string['timesplitting:singlerange_help'] = 'Этот метод разбиения по времени рассматривает весь курс как один промежуток.';
$string['timesplitting:weekly'] = 'Еженедельный';
$string['timesplitting:weeklyaccum'] = 'Еженедельный накапливающийся';
$string['timesplitting:weeklyaccum_help'] = 'Этот метод разделения времени делит курс на недели (7 дней), при этом каждый прогноз основан на данных всех предыдущих недель.';
$string['timesplitting:weekly_help'] = 'Этот метод разделения времени делит курс на недели (7 дней), при этом каждый прогноз основан на данных только последней прошедшей недели.';
$string['timezone'] = 'Часовой пояс';
$string['to'] = 'по';
$string['tocontent'] = 'К пункту «{$a}»';
$string['tocreatenewaccount'] = 'Пропустить и перейти к созданию новой учетной записи';
$string['today'] = 'Сегодня';
$string['todaylogs'] = 'Сегодняшние события';
$string['toeveryone'] = 'для всех';
$string['toomanybounces'] = 'Очень много отказов в доставке почты на этот адрес электронной почты. Вы <b>должны</b> изменить его для дальнейшей работы.';
$string['toomanytags'] = 'Этот поиск включает слишком много тегов. Некоторые из них будут проигнорированы.';
$string['toomanytoshow'] = 'Список пользователей слишком велик для отображения.';
$string['toomanyusersmatchsearch'] = 'Слишком много пользователей ({$a->count}) соответствуют шаблону «{$a->search}»';
$string['toomanyuserstoshow'] = 'Слишком много пользователей ({$a}) для отображения';
$string['toonly'] = 'только для {$a}';
$string['top'] = 'Верхний уровень';
$string['topic'] = 'Тема';
$string['topichide'] = 'Скрыть этот раздел от пользователей с ролью «{$a}»';
$string['topicoutline'] = 'Тематический план';
$string['topicshow'] = 'Показать этот раздел пользователям с ролью «{$a}»';
$string['toplevelcategory'] = 'Категория верхнего уровня';
$string['total'] = 'Итог';
$string['totopofsection'] = 'К началу раздела "{$a}"';
$string['trackforums'] = 'Слежение за форумами';
$string['trackforumsno'] = 'Нет, не отслеживать новые сообщения';
$string['trackforumsyes'] = 'Да, выделять новые сообщения';
$string['trysearching'] = 'Вместо этого попробуйте воспользоваться поиском';
$string['turneditingoff'] = 'Завершить редактирование';
$string['turneditingon'] = 'Режим редактирования';
$string['unauthorisedlogin'] = 'Учетная запись пользователя «{$a}» недействительна на этом сайте';
$string['undecided'] = 'Нерешено';
$string['unfinished'] = 'Не завершено';
$string['unknowncategory'] = 'Неизвестная категория';
$string['unknownerror'] = 'Неизвестная ошибка';
$string['unknownuser'] = 'Неизвестный пользователь';
$string['unlimited'] = 'Неограничено';
$string['unpacking'] = 'Распаковка {$a}';
$string['unsafepassword'] = 'Небезопасный пароль - попробуйте какой-нибудь другой';
$string['untilcomplete'] = 'До завершения';
$string['unusedaccounts'] = 'Пользователи, не появляющиеся на курсе больше, чем {$a} дней, автоматически исключаются';
$string['unzip'] = 'Распаковать ZIP-архив';
$string['unzippingbackup'] = 'Распаковка бэкапа';
$string['up'] = 'Вверх';
$string['update'] = 'Обновление';
$string['updated'] = 'Обновлено: {$a}';
$string['updatemymoodleoff'] = 'Прекратить настраивать эту страницу';
$string['updatemymoodleon'] = 'Настроить эту страницу';
$string['updatemyprofile'] = 'Обновить профиль';
$string['updatesevery'] = 'Обновлять каждые {$a} сек.';
$string['updatethis'] = 'Обновить {$a}';
$string['updatethiscourse'] = 'Обновление курса';
$string['updatinga'] = 'Обновление: {$a}';
$string['updatingain'] = 'Обновление {$a->what} в {$a->in}';
$string['upload'] = 'Загрузить';
$string['uploadafile'] = 'Загрузить файл';
$string['uploadcantwrite'] = 'Не удалось записать файл на диск';
$string['uploadedfile'] = 'Файл успешно загружен';
$string['uploadedfileto'] = 'Файл «{$a->file}» загружен в папку «{$a->directory}»';
$string['uploadedfiletoobig'] = 'Извините, файл слишком велик (превышает {$a} байт)';
$string['uploadextension'] = 'Загрузка файла остановлена расширением PHP';
$string['uploadfailednotrecovering'] = 'Загрузка файла была прервана, так как возникла проблема с одним из файлов, {$a->name}.<br /> Сообщение о проблеме:<br />{$a->problem}<br />Не восстанавливается.';
$string['uploadfilelog'] = 'Протокол загрузки файла {$a}';
$string['uploadformlimit'] = 'Загружаемый файл {$a} превысил ограничение на максимальный размер, установленный в форме';
$string['uploadlabel'] = 'Заголовок:';
$string['uploadlimitwithsize'] = 'Максимальный размер загружаемого файла для уровня «{$a->contextname}» ({$a->displaysize})';
$string['uploadnewfile'] = 'Загрузить новый файл';
$string['uploadnofilefound'] = 'Файл не был найден. Вы уверены, что выбрали файл для загрузки?';
$string['uploadnotallowed'] = 'Загрузки не разрешены';
$string['uploadnotempdir'] = 'Отсутствует временная папка';
$string['uploadoldfilesdeleted'] = 'Старый(е) файл(ы) в Вашей области загрузки был(и) удален(ы)';
$string['uploadpartialfile'] = 'Файл был загружен лишь частично';
$string['uploadproblem'] = 'Неизвестная проблема возникла при загрузке файла «{$a}» (возможно он был слишком большой?)';
$string['uploadrenamedchars'] = 'Файл был переименован из «{$a->oldname}» в «{$a->newname}», так как старое название содержало недопустимые символы.';
$string['uploadrenamedcollision'] = 'Файл был переименован из {$a->oldname} в {$a->newname} из-за конфликта имен.';
$string['uploadserverlimit'] = 'Загружаемый файл превысил ограничение на максимальный размер, установленный на сервере';
$string['uploadthisfile'] = 'Загрузить этот файл';
$string['url'] = 'URL';
$string['used'] = 'Используется';
$string['usedinnplaces'] = 'Количество использований - {$a}';
$string['user'] = 'Пользователь';
$string['useraccount'] = 'Учетная запись пользователя';
$string['useractivity'] = 'Элемент курса';
$string['userconfirmed'] = 'Подтвердить {$a}';
$string['userdata'] = 'Данные пользователя';
$string['userdeleted'] = 'Учетная запись пользователя была удалена';
$string['userdescription'] = 'Описание';
$string['userdescription_help'] = 'В это поле можно ввести любую информацию о себе. Эта информация будет отображаться другим пользователям на странице Вашего профиля.';
$string['userdetails'] = 'Подробная информация о пользователе';
$string['userfiles'] = 'Файлы пользователя';
$string['userfilterplaceholder'] = 'Введите слово для поиска или выберите фильтр';
$string['userlist'] = 'Список пользователей';
$string['usermenu'] = 'Меню пользователя';
$string['username'] = 'Логин';
$string['usernameemail'] = 'Логин / адрес электронной почты';
$string['usernameemailmatch'] = 'Логин и адрес электронной почты не относятся к одному и тому же пользователю.';
$string['usernameexists'] = 'Данный логин уже используется. Выберите другой.';
$string['usernamelowercase'] = 'Допустимы только строчные буквы';
$string['usernamenotfound'] = 'Логин не найден в базе данных';
$string['usernameoremail'] = 'Введите логин или адрес электронной почты';
$string['usernotconfirmed'] = 'Невозможно подтвердить {$a}';
$string['userpic'] = 'Изображение пользователя';
$string['userpreferences'] = 'Настройки пользователя';
$string['users'] = 'Пользователи';
$string['userselectorautoselectunique'] = 'Если только один пользователь соответствует строке поиска, то выбирать его автоматически';
$string['userselectorpreserveselected'] = 'Сохранить выбранный список пользователей, даже если они больше не соответствуют критериям поиска';
$string['userselectorsearchanywhere'] = 'Проверять искомый текст в любом из отображаемых полей';
$string['usersnew'] = 'Новые пользователи';
$string['usersnoaccesssince'] = 'Показать пользователей, которые были неактивны более чем';
$string['userswithfiles'] = 'Пользователи с файлами';
$string['useruploadtype'] = 'Тип загружаемого пользователя: {$a}';
$string['userzones'] = 'Пользовательские зоны';
$string['usetheme'] = 'Использовать тему';
$string['usingexistingcourse'] = 'Использовать существующий курс';
$string['valuealreadyused'] = 'Это значение уже было использовано';
$string['version'] = 'Версия';
$string['view'] = 'Просмотр';
$string['viewallcourses'] = 'Показать все курсы';
$string['viewallcoursescategories'] = 'Показать все курсы и категории';
$string['viewallsubcategories'] = 'Просмотреть все подкатегории';
$string['viewfileinpopup'] = 'Просмотреть файл во всплывающем окне';
$string['viewing'] = 'Отображение:';
$string['viewmore'] = 'Показать еще';
$string['viewprofile'] = 'Просмотр профиля';
$string['views'] = 'Просмотры';
$string['viewsolution'] = 'посмотреть решение';
$string['visible'] = 'Доступность';
$string['visible_help'] = 'Этот параметр определяет, будет ли курс отображаться в списке курсов. Пользователи, кроме преподавателей и администраторов, не смогут войти в скрытый курс.';
$string['visibletostudents'] = 'Доступно для {$a}';
$string['warning'] = 'Предупреждение';
$string['warningdeleteresource'] = 'Внимание: на {$a} ссылается ресурс. Вы хотите обновить этот ресурс?';
$string['webpage'] = 'Веб-страница';
$string['week'] = 'Неделя';
$string['weekhide'] = 'Не показывать эту неделю {$a}';
$string['weeklyoutline'] = 'Календарный план';
$string['weeks'] = 'нед.';
$string['weekshow'] = 'Показать эту неделю {$a}';
$string['welcometocourse'] = 'Добро пожаловать в {$a}';
$string['welcometocoursetext'] = 'Добро пожаловать на курс «{$a->coursename}»!

Если Вы еще не сделали этого, отредактируйте страницу своего профиля, чтобы мы могли узнать о Вас побольше:

{$a->profileurl}';
$string['whatforlink'] = 'Что Вы хотите сделать с ссылкой?';
$string['whatforpage'] = 'Что Вы хотите сделать с текстом?';
$string['whatisyourage'] = 'Сколько вам лет?';
$string['whattocallzip'] = 'Как Вы хотите назвать ZIP-архив?';
$string['whattodo'] = 'Что делать';
$string['wheredoyoulive'] = 'В какой стране вы живете?';
$string['whyisthisrequired'] = 'Зачем это нужно?';
$string['windowclosing'] = 'Это окно должно закрываться автоматически. Если нет, то, пожалуйста, закройте его самостоятельно.';
$string['withchosenfiles'] = 'С выбранными файлами';
$string['withdisablednote'] = '{$a} (выкл)';
$string['withoutuserdata'] = 'без данных пользователей';
$string['withselectedusers'] = 'С выбранными пользователями...';
$string['withselectedusers_help'] = '* Отправить сообщение - Отправка сообщения одному или нескольким участникам
* Добавить новую заметку - Для добавления заметки выбранному участнику';
$string['withuserdata'] = 'с данными пользователей';
$string['wordforstudent'] = 'Обращение для Студента';
$string['wordforstudenteg'] = 'например, Студент, Участник…';
$string['wordforstudents'] = 'Ваше слово вместо «Студенты»';
$string['wordforstudentseg'] = 'например, Студенты, Участники…';
$string['wordforteacher'] = 'Ваше слово вместо «Преподаватель»';
$string['wordforteachereg'] = 'например, Учитель, Инструктор, Тьютор…';
$string['wordforteachers'] = 'Ваше слово вместо «Преподаватели»';
$string['wordforteacherseg'] = 'например, Учителя, Инструкторы, Тьюторы…';
$string['writingblogsinfo'] = 'Запись информации о блогах';
$string['writingcategoriesandquestions'] = 'Запись категорий и вопросов';
$string['writingcoursedata'] = 'Запись данных курса';
$string['writingeventsinfo'] = 'Запись информации о событиях';
$string['writinggeneralinfo'] = 'Запись общей информации';
$string['writinggradebookinfo'] = 'Запись информации об оценках';
$string['writinggroupingsgroupsinfo'] = 'Запись информации о группировках-группах';
$string['writinggroupingsinfo'] = 'Запись информации о группировках';
$string['writinggroupsinfo'] = 'Запись информации о группах';
$string['writingheader'] = 'Запись заголовка';
$string['writingloginfo'] = 'Запись в журнал событий';
$string['writingmessagesinfo'] = 'Запись информации о сообщениях';
$string['writingmoduleinfo'] = 'Запись информации по модулям';
$string['writingscalesinfo'] = 'Информация по шкале';
$string['writinguserinfo'] = 'Запись данных о пользователях';
$string['wrongpassword'] = 'Этот пароль не подходит для пользователя с таким логином';
$string['yahooid'] = 'Yahoo ID';
$string['year'] = 'г.';
$string['years'] = 'г.';
$string['yes'] = 'Да';
$string['youareabouttocreatezip'] = 'Вы собираетесь создать ZIP-файл, содержащий';
$string['youaregoingtorestorefrom'] = 'Вы хотите начать процесс восстановления для';
$string['youneedtoenrol'] = 'Для выполнения этого действия необходимо зарегистрировать на этом курсе.';
$string['yourlastlogin'] = 'Последний вход';
$string['yourself'] = 'себя';
$string['yourteacher'] = 'Ваш {$a}';
$string['yourwordforx'] = 'Ваше слово вместо «{$a}»';
$string['zippingbackup'] = 'Архивирование резервной копии';
