<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'qtype_stack', language 'ja', branch 'MOODLE_36_STABLE'
 *
 * @package   qtype_stack
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addanothernode'] = '新しいノードを追加する';
$string['addanothertestcase'] = '新しいテストケースを追加する';
$string['addatestcase'] = 'テストケースを追加する';
$string['addingatestcase'] = '問題{$a}にテストケースを追加する';
$string['alg_indices_fact'] = '以下は指数の法則です。
\\[a^ma^n = a^{m+n}\\]
\\[\\frac{a^m}{a^n} = a^{m-n}\\]
\\[(a^m)^n = a^{mn}\\]
\\[a^0 = 1\\]
\\[a^{-m} = \\frac{1}{a^m}\\]
\\[a^{\\frac{1}{n}} = \\sqrt[n]{a}\\]
\\[a^{\\frac{m}{n}} = \\left(\\sqrt[n]{a}\\right)^m\\]';
$string['alg_indices_name'] = '指数の法則';
$string['alg_inequalities_fact'] = '\\[a>b \\hbox{ ： } a \\hbox{ は } b \\hbox{ よりも大きい } \\] <br /> \\[ a < b \\hbox{ ： } a \\hbox{ は } b \\hbox{ よりも小さい } \\] <br /> \\[a\\geq b \\hbox{ ： } a \\hbox{ は } b \\hbox{ よりも大きいかまたは等しい } \\] <br /> \\[a\\leq b \\hbox{ ： } a \\hbox{ は } b \\hbox{ よりも小さいかまたは等しい } \\]';
$string['alg_inequalities_name'] = '不等式';
$string['alg_logarithms_fact'] = '任意の正の底 \\(c\\) (ただし \\(c \\neq 1\\))に対して \\[\\log_c(a) = b \\mbox{，つまり } a = c^b\\]
\\[\\log_c(a) + \\log_c(b) = \\log_c(ab)\\]
\\[\\log_c(a) - \\log_c(b) = \\log_c \\left(\\frac{a}{b}\\right)\\]
\\[n\\log_c(a) = \\log_c \\left(a^n \\right)\\]
\\[\\log_c(1) = 0\\]
\\[\\log_c(b) = 1\\]
底の変換公式
\\[\\log_a(x) = \\frac{\\log_b(x)}{\\log_b(a)}\\]
底 \\(e\\) の対数 \\(\\log_e\\) あるいは \\(\\ln\\) は自然対数と呼ばれる。\\(e\\) は定数でおよそ 2.718 である。';
$string['alg_logarithms_name'] = '対数の法則';
$string['alg_partial_fractions_fact'] = '\\(P\\) と \\(Q\\) が多項式で，\\(P\\) の次数が \\(Q\\) の次数よりも小さい時，\\[{\\frac{P(x)}{Q(x)}}\\] は真分数となる。さらに，\\(Q(x)\\) が因数分解でき，<ul>
<li><em>一次式の因子</em> \\(ax+b\\) を使って次のような形式に書くことができる。 \\[{\\frac{A}{ax+b}}.\\] </li>
<li>あるいは<em>上記の二乗の因子</em> \\((ax+b)^2\\) を使って次のような形式に書くことができる。\\[{A \\over ax+b}+{B \\over (ax+b)^2}.\\] </li>
<li>また，<em>二次式の因子</em> \\(ax^2+bx+c\\) を使って次のような形式に書くことができる。\\[{Ax+B \\over ax^2+bx+c}\\] </li> さらに，<li> <em>仮分数</em> の場合は，\\(n-d\\)次の多項式の項が必要となる。ただし，\\(n\\) は分子(i.e. \\(P(x)\\)) の次数であり，\\(d\\) は分母 (ie \\(Q(x)\\))の次数である。 </li>
</ul>';
$string['alg_partial_fractions_name'] = '部分分数';
$string['alg_quadratic_formula_fact'] = '二次方程式 \\[ ax^2 + bx +c =0 \\] の解は解の公式により \\[ x = \\frac{-b \\pm \\sqrt{b^2-4ac}}{2a}\\] となります。';
$string['alg_quadratic_formula_name'] = '二次方程式の解の公式';
$string['all'] = 'すべて';
$string['allnodefeedbackmustusethesameformat'] = 'ポテンシャル・レスポンス・ツリーの全てのノードのフィードバックは同じフォーマットで記述する必要があります。';
$string['allowwords'] = '許可されたワード';
$string['allowwords_help'] = 'デフォルトでは，3文字以上の関数名，変数名は許可されていません。これは解答に使用できる関数名，変数名のリストです。';
$string['alreadydeployed'] = 'この問題記録に対応する変形はすでにデプロイされています。';
$string['ansnotemismatch'] = '[解答記録が一致していません]';
$string['answernote'] = '解答記録';
$string['answernotedefaultfalse'] = '{$a->prtname}-{$a->nodename}-F';
$string['answernotedefaulttrue'] = '{$a->prtname}-{$a->nodename}-T';
$string['answernote_err'] = '解答記録に「 | 」を含むことはできません。この文字は解答記録を分割するためにSTACKによって自動的に挿入されます。';
$string['answernote_err2'] = '解答ノートには ; や : を含むことはできません。これらの文字は，オフラインのレポートのサマリーで，問題への試行の区切りに使われています。';
$string['answernote_help'] = 'これはレポートを目的としたタグで，ポテンシャル・レスポンス・ツリーのパスと各評価関数の出力を記録するように設計されています。これは自動的に生成されますが，目的に応じて変更できます。';
$string['answernoterequired'] = '解答記録は空欄のままではいけません';
$string['answernoteunique'] = 'このポテンシャル・レスポンス・ツリーの解答記録を複製します。';
$string['answertest'] = '評価関数';
$string['answertest_help'] = '評価関数は，数式がある条件をみたしているかどうかを判定するために用いられるものです。';
$string['assumepositive'] = '正の仮定';
$string['assumepositive_help'] = 'このオプションはMaximaのassume_posオプションの値を設定します。';
$string['assumereal'] = '実数を仮定';
$string['assumereal_help'] = 'このオプションは assume_real 変数を設定します。';
$string['ATAlgEquiv_SA_not_equation'] = '方程式を入力してください。';
$string['ATAlgEquiv_SA_not_expression'] = '解答は数式で行ってください。方程式，不等式，リスト，集合，また行列などは入力しないでください。';
$string['ATAlgEquiv_SA_not_function'] = '解答は<tt>:=</tt>の演算子で定義された関数を入力してください。';
$string['ATAlgEquiv_SA_not_inequality'] = '不等式を入力してください。';
$string['ATAlgEquiv_SA_not_list'] = 'リストを入力してください。リストは角括弧で囲まれたカンマ区切りの値で入力してください。例：[a, b, c]';
$string['ATAlgEquiv_SA_not_logic'] = '解答は方程式，不等式，あるいはそれらの論理的な組み合わせでなければなりませんが，そうなっていません。';
$string['ATAlgEquiv_SA_not_matrix'] = '行列を入力してください。';
$string['ATAlgEquiv_SA_not_set'] = '集合を入力してください。集合は波括弧で囲まれたカンマ区切りの値で入力してください。例：{a, b, c}';
$string['ATAlgEquiv_SA_not_string'] = '解答は文字列でなければなりません。';
$string['ATAlgEquiv_TA_not_equation'] = 'あなたの解答は方程式になっていますが，この問題は解答に方程式を要求していません。「y=2*x+1」のような解答の場合は「2*x+1」とだけ入力してください。';
$string['ATCompSquare_false_no_summands'] = '平方完成は\\(a, b\\)を定数として\\(a(\\cdots \\cdots)^2+b\\)の形式です。あなたの解答では，2つ以上の加数が変数に依存しているようです。';
$string['ATCompSquare_not_AlgEquiv'] = 'あなたの解答の書式は正しいようですが，正解ではありません。';
$string['ATCompSquare_SA_not_depend_var'] = '変数{$a->m0}に依存した解答を入力してください。';
$string['ATDiff_error_list'] = 'この評価関数には不具合が含まれています。サイト管理者に問い合わせてください。';
$string['ATDiff_int'] = '間違って積分してませんか？';
$string['AT_EmptySA'] = '評価対象が空欄のまま評価関数を実行しました。問題作成時にCASの評価で問題が生じます。';
$string['AT_EmptyTA'] = '評価対象が空欄のまま評価基準を実行しました。問題作成時にCASの評価で問題が生じます。';
$string['ATEquivFirst_SA_not_list'] = '評価関数「等価」の最初の引数はリストでなければなりませんが，テストが正常に動作していません。管理者に問い合わせてください。';
$string['ATEquivFirst_SA_wrong_end'] = '最終的な解答が正しい形式ではありません。';
$string['ATEquivFirst_SA_wrong_start'] = '最初の行は"{$a->m0}"でなければなりません。';
$string['ATEquivFirst_SB_not_list'] = '評価関数「等価」の2番目の引数はリストでなければなりませんが，テストが正常に動作していません。管理者に問い合わせてください。';
$string['ATEquiv_SA_not_list'] = '評価関数「等価」の最初の引数はリストでなければなりませんが，テストが正常に動作していません。管理者に問い合わせてください。';
$string['ATEquiv_SB_not_list'] = '評価関数「等価」の2番目の引数はリストでなければなりませんが，テストが正常に動作していません。管理者に問い合わせてください。';
$string['ATFacForm_error_degreeSA'] = 'CASはあなたの解答を処理できませんでした。';
$string['ATFacForm_error_list'] = 'この評価関数には不具合が含まれています。サイト管理者に問い合わせてください。';
$string['ATFacForm_isfactored'] = '形式的には因数分解できています。';
$string['ATFacForm_notalgequiv'] = 'あなたの解答は正答と代数的に等価ではありません。どこか計算間違いをしていませんか？';
$string['ATFacForm_notfactored'] = 'あなたの解答は因数分解されていません。';
$string['ATInequality_backwards'] = '不等式が反対になっていませんか？';
$string['ATInequality_nonstrict'] = 'この問題の不等号は「＜」か「＞」である必要があります。';
$string['ATInequality_strict'] = 'この問題の不等号は「≤」か「≥」である必要があります。';
$string['ATInt_const'] = '積分定数を忘れていませんか？積分定数を追加すれば正解です。';
$string['ATInt_const_int'] = '積分定数がありません。積分定数は数値ではなく任意の定数である必要があります。';
$string['ATInt_diff'] = '間違って微分してませんか？';
$string['ATInt_EqFormalDiff'] = 'あなたの解答を微分すると，問題の非積分関数と確かに一致します。ところが，例えば，積分定数がない，などの意味で正解と異なっています。';
$string['ATInt_error_list'] = 'この評価関数には不具合が含まれています。サイト管理者に問い合わせてください。';
$string['ATInt_generic'] = 'あなたの解答を微分したものは，積分すべき数式に一致しなければなりません。あなたの解答を{a->m1}で微分すると{$a->m2}になります。これは{a->m0}に一致しません。';
$string['ATInt_logabs'] = 'あなたの解答を形式的に微分すると，確かに積分すべき数式に一致します。しかし，あなたの解答は，次の理由で正解ではありません。\\(\\int \\frac{1}{x}dx=\\log (x) +c\\)ではなく，\\(\\(int \\(frac{1}{x}dx=\\log (|x|) +c\\)であることに注意してください。詳しくは教師にたずねてください。';
$string['ATInt_logabs_inconsistent'] = '\\(\\log (...)\\)と\\(\\log ( |...|)\\)の使い方に間違いがあるようです。詳しくは教師にたずねてください。';
$string['ATInt_STACKERROR_OptList'] = 'この評価関数は正しく実行されませんでした。教師に伝えてください。積分の評価関数の場合，オプションには2つの要素が必ずふくまれていなければなりませんが，そうなっていません。';
$string['ATInt_weirdconst'] = 'あなたの解答を形式的に微分すると，確かに積分すべき数式に一致します。しかし，不適切な積分定数が含まれています。詳しくは教師にたずねてください。';
$string['AT_InvalidOptions'] = 'オプションのフィールドが正しくありません。 {$a->errors}';
$string['ATList_wrongentries'] = '赤字で示された部分が不正解です。{$a->m0}';
$string['ATList_wronglen'] = 'あなたの解のリストは {$a->m1} 個の要素が含まれていますが，{$a->m0} 個の要素が含まれているべきです。';
$string['ATLowestTerms_entries'] = '以下の項は約分が十分ではありません。{$a->m0} もう一度よく確認してください。';
$string['ATLowestTerms_not_rat'] = '分数の分母から次を消去してください: {$a->m0}';
$string['ATLowestTerms_wrong'] = '解答中の分数を約分する必要があります。';
$string['ATMatrix_wrongentries'] = '赤字で示された部分が不正解です。{$a->m0}';
$string['ATMatrix_wrongsz'] = 'あなたの入力した行列は{$a->m0}×{$a->m1}ですが，正しくは{$a->m2}×{$a->m3}です。';
$string['AT_MissingOptions'] = '評価関数を実行するために必要なオプションがありません。';
$string['AT_NOTIMPLEMENTED'] = 'この評価関数はまだ実装されていません。';
$string['ATNumDecPlaces_Float'] = 'あなたの解答は浮動小数点でなければなりませんが，そうなっていません。';
$string['ATNumDecPlaces_NoDP'] = '解答は小数点を含む10進数でなければなりません。';
$string['ATNumDecPlaces_OptNotInt'] = '評価関数「小数部桁数」のオプションは正の整数でなければなりませんが，{$a->opt}になっています。';
$string['ATNumDecPlaces_Wrong_DPs'] = 'あなたの解答では小数点の位置が間違っています。';
$string['ATNumDecPlacesWrong_OptNotInt'] = '評価関数ATNumDecPlacesWrongでは，オプションは正の整数でなければなりませんが，"{$a->opt}"を受け取りました。';
$string['ATNumerical_FAILED'] = '解答は実数，あるいは実数のリスト，集合としてください。';
$string['ATNumerical_SA_not_list'] = '解答はリスト形式としてください。リストはカンマで区切られた値を角括弧（[， ]）で閉じてください。';
$string['ATNumerical_SA_not_number'] = '解答は実数としてください。';
$string['ATNumerical_SA_not_set'] = '解答は集合としてください。集合はカンマで区切られた値を波括弧（{，}）で閉じてください。';
$string['ATNumerical_STACKERROR_tol'] = 'ATNumericalテストでは，実数を使ってください。内部エラーがあるので，教師に問い合わせてください。';
$string['ATNum_OutofRange'] = '数値の表現が可能な精度を超えています。教師に問い合わせてください。';
$string['ATNumSigFigs_error_list'] = 'この評価関数には不具合が含まれています。サイト管理者に問い合わせてください。';
$string['ATNumSigFigs_Inaccurate'] = 'あなたの解答の精度（桁数）が正しくありません。正しく四捨五入していないか，計算の途中で四捨五入して最終的な答えが間違いとなった可能性があります。';
$string['ATNumSigFigs_NotDecimal'] = '解答は10進数でなければなりません。';
$string['ATNumSigFigs_WrongDigits'] = 'あなたの解答の桁数が間違っています。';
$string['ATNumSigFigs_WrongSign'] = 'あなたの解答は，符号が間違っています。';
$string['ATPartFrac_denom_ret'] = 'あなたの解答を単一の分数で記述すると分母は{$a->m0}になります。正しくは{$a->m1}です。';
$string['ATPartFrac_diff_variables'] = '解答の中の変数は，問題文の中の変数と異なっています。確認してください。';
$string['ATPartFrac_error_list'] = '評価関数が正常に動作しませんでした。サイト管理者に問い合わせてください。';
$string['ATPartFrac_ret_expression'] = 'あなたの解答を単一の分数で記述すると{$a->m0}になります。';
$string['ATPartFrac_single_fraction'] = 'あなたの解答は単一の分数で記述されています。この問題では部分分数の形で記述する必要があります。';
$string['ATRegEx_missing_option'] = '正規表現が含まれていません。';
$string['ATSets_duplicates'] = '集合の中に重複した要素が含まれています。';
$string['ATSets_missingentries'] = '集合に次のものが含まれていません {$a->m0}。';
$string['ATSets_SA_not_set'] = '解答は集合でなければなりません。集合を入力する場合，要素をカンマ(,)で区切り，波括弧{ }で囲ってください。';
$string['ATSets_SB_not_set'] = '評価関数「集合」の第2引数は集合でなければなりません。';
$string['ATSets_wrongentries'] = 'この入力は集合の要素ではありません。{$a->m0}';
$string['ATSet_wrongentries'] = 'ここでは整理された形で表示されることもありますが，入力されたものは間違っています。';
$string['ATSet_wrongsz'] = '集合は{$a->m0}個の異なる要素が必要ですが，実際には {$a->m1}個の要素になっています。';
$string['ATSingleFrac_div'] = 'あなたの解答は分数の中に分数を含んでいます。一つの分数で解答を入力してください。';
$string['ATSingleFrac_error_list'] = '評価関数が正常に動作しませんでした。サイト管理者に問い合わせてください。';
$string['ATSingleFrac_part'] = '解答は\\(\\frac{a}{b}\\)の形式の一つの分数である必要があります。';
$string['ATSingleFrac_ret_exp'] = 'あなたの解答は正解と代数的に等しくありません。どこか計算間違いしていませんか？';
$string['ATSingleFrac_var'] = '解答の中の変数は，問題文の中の変数と異なっています。';
$string['ATSRegExp_SA_not_string'] = '評価関数SRegExpの第1引数は文字でなければなりません。評価が失敗しました。管理者に問い合わせてください。';
$string['ATSRegExp_SB_not_string'] = '評価関数SRegExpの第2引数は文字でなければなりません。評価が失敗しました。管理者に問い合わせてください。';
$string['ATSysEquiv_SA_extra_variables'] = '解答に含まれている変数が多すぎます。';
$string['ATSysEquiv_SA_missing_variables'] = 'あなたの解答には変数が足りません。';
$string['ATSysEquiv_SA_not_eq_list'] = '解答は方程式のリストでなければなりません。';
$string['ATSysEquiv_SA_not_list'] = '解答はリスト形式でなければなりません。';
$string['ATSysEquiv_SA_not_poly_eq_list'] = '方程式が多項式ではありません。';
$string['ATSysEquiv_SA_system_overdetermined'] = '赤字で示された部分が不正解です。{$a->m0}';
$string['ATSysEquiv_SA_system_underdetermined'] = '方程式は正しいようですが，それ以外にも必要です。';
$string['ATSysEquiv_SA_wrong_variables'] = 'あなたの解答には，誤った変数が用いられています。';
$string['ATSysEquiv_SB_not_eq_list'] = '評価基準は方程式のリストではなければなりません。';
$string['ATSysEquiv_SB_not_list'] = '評価基準はリストではありません。';
$string['ATSysEquiv_SB_not_poly_eq_list'] = '評価基準は多項式のリストですが，そうなっていません。';
$string['ATUnits_compatible_units'] = 'あなたの単位は正解の単位とは異なっていますが，対応しています。数値はSI単位系に変換されて比較されます。';
$string['ATUnits_correct_numerical'] = '単位を注意深く確認してください。';
$string['ATUnits_incompatible_units'] = 'あなたの単位は正解の単位とは対応していません。';
$string['ATUnits_SA_bad_units'] = '解答には単位が必要です。数値に単位を掛けることによって，単位を付けることができます。例：<code>3.2*m/s</code>';
$string['ATUnits_SA_errorbounds_invalid'] = 'あなたの解答には誤差範囲が指定されています。この問題では誤差範囲は設定しないで，値と単位のみ使ってください。';
$string['ATUnits_SA_excess_units'] = 'あなたの解答には単位（あるいは変数）が用いられていますが，不要です。';
$string['ATUnits_SA_not_expression'] = '解答は単位付きの数値でなければなりません。集合，リスト，方程式，行列を使わないでください。';
$string['ATUnits_SA_no_units'] = '解答には単位が必要です。';
$string['ATUnits_SA_only_units'] = '解答は単位付きの数値でなければなりません。あなたの解答には単位しかありません。';
$string['ATUnits_SO_wrong_units'] = '数値誤差の単位が，評価基準の単位と一致していません。これは内部エラーです。管理者に問い合わせてください。';
$string['autosimplify'] = '自動簡略化';
$string['autosimplify_help'] = 'Yesが指定されると，この問題（問題変数，問題文など）に対して，Maximaのsimp変数を設定します。各ポテンシャル・レスポンス・ツリーでこの変数が指定されると，それが優先されます。';
$string['autosimplifyprt'] = '自動簡略化';
$string['autosimplifyprt_help'] = 'このポテンシャル・レスポンス・ツリーのフィードバック変数に対して，Maximaのsimp変数を設定します。この設定は，他で指定されたsimp変数よりも優先されます。';
$string['Bad_assignment'] = '変数の値を列挙する場合は，{$a->m0}のように入力を修正してください。';
$string['basicquestionreport'] = '簡易問題利用レポート';
$string['basicquestionreport_help'] = 'サーバ上で，この問題への解答に関する簡易なレポートを生成します。学生が実際どのような解答を行ったかを参照しながら，フィードバックを改良するために，どのようにポテンシャル・レスポンス・ツリーを構成するかを検討するために役立つでしょう。';
$string['basicreportinputsummary'] = 'どのような変形が使われたかにかかわらず，入力されたものをそのまま提示';
$string['basicreportnotes'] = 'どのような変形が使われたかにかかわらず，各ポテンシャル・レスポンス・ツリーで使われた問題記録の回数';
$string['basicreportnotessplit'] = 'どのような変形が使われたかにかかわらず，| で区切られた，各ポテンシャル・レスポンス・ツリーで使われた問題記録の回数';
$string['basicreportraw'] = '生データ';
$string['basicreportvariants'] = '各変形毎に入力データとポテンシャル・レスポンス・ツリーの問題記録';
$string['booleangotunrecognisedvalue'] = '入力エラー';
$string['boxsize'] = '解答欄のサイズ';
$string['boxsize_help'] = '解答入力欄の大きさを設定します。';
$string['branchfeedback'] = 'ノード・フィードバック';
$string['branchfeedback_help'] = '問題変数，入力，フィードバック変数に依存したCASテキストで記述されます。解答がこの分岐を通過する場合，CASテキストが評価され学生に表示されます。';
$string['bulktestcontinuefromhere'] = 'もう一度実行するかやり直して，ここから始めてください。';
$string['bulktestindexintro'] = 'どのリンクをクリックしても，全てのSTACKの問題のテストを実行します。';
$string['bulktestindexintro_desc'] = '<a href="{$a->link}">内部での問題実行スクリプト</a> は全てのSTACKの問題のテストを簡単に実行することができます。また，CASのキャッシュの再構築のための良い方法でもあります。';
$string['bulktestindextitle'] = '内部で問題のテストを実行';
$string['bulktestnodeployedseeds'] = 'この問題ではランダム変数が用いられていますが，乱数シードがデプロイされていません。';
$string['bulktestnogeneralfeedback'] = 'この問題には一般フィードバックが含まれていません。';
$string['bulktestnotests'] = 'この問題にはテストが含まれていません。';
$string['bulktestrun'] = 'システムの全ての問題に対して，全てのテストケースを実行します（時間がかかります。管理者のみ実行してください。）';
$string['bulktesttitle'] = '{$a}で問題のテストが実行されています。';
$string['cachedef_parsercache'] = 'STACKはMaximaの表現を解釈しました。';
$string['calc_chain_rule_fact'] = '次のようにして合成関数の微分を行うことができます。関数\\(f(g(x))\\)で\\(u=g(x)\\)と仮定することにより，\\(f(g(x))\\)を\\(x\\)で微分すると \\[ \\frac{df(g(x))}{dx} = \\frac{dg(x)}{dx} \\cdot \\frac{df(u)}{du} \\] となります。あるいは， \\[ frac{df(g(x))}{dx} = f\\\'(g(x)) \\cdot g\\\'(x)\\] と書くこともできます。';
$string['calc_chain_rule_name'] = 'チェーンルール';
$string['calc_diff_linearity_rule_fact'] = '\\[ frac{\\rm d}{{\\rm d}x}(af(x)+bg(x)) = a\\frac{{\\rm d}f(x)}{dx} + b \\frac{{\\rm d} g(x)}{{\\rm d}x} \\] ただし，\\(a, b\\)は定数。ただし，(a, b)は定数。';
$string['calc_diff_linearity_rule_name'] = '微分の線形性';
$string['calc_diff_standard_derivatives_fact'] = '次の表はいくつかの標準的な関数の微分を表示しています。計算にしばしば用いられるので，覚えておくと便利です。
<center>
<table>
<tr><th>\\(f(x)\\)               </th><th> \\(f\'(x)\\)</th></tr>
<tr>
<td>\\(k\\), constant           </td> <td> \\(0\\) </td> </tr> <tr> <td>
\\(x^n\\), any constant \\(n\\) </td> <td> \\(nx^{n-1}\\)</td> </tr> <tr> <td>
\\(e^x\\)                   </td> <td> \\(e^x\\)</td> </tr> <tr> <td>
\\(\\ln(x)=\\log_{\\rm e}(x)\\)              </td> <td> \\(\\frac{1}{x}\\)                </td> </tr> <tr> <td>
\\(\\sin(x)\\)                             </td> <td> \\(\\cos(x)\\)                    </td> </tr> <tr> <td>
\\(\\cos(x)\\)                             </td> <td> \\(-\\sin(x)\\)                   </td> </tr> <tr> <td>
\\(\\tan(x) = \\frac{\\sin(x)}{\\cos(x)}\\)   </td> <td>   \\(\\sec^2(x)\\)                </td> </tr> <tr> <td>
\\(cosec(x)=\\frac{1}{\\sin(x)}\\)         </td> <td>   \\(-cosec(x)\\cot(x)\\)        </td> </tr> <tr> <td>
\\(\\sec(x)=\\frac{1}{\\cos(x)}\\)           </td> <td>   \\(\\sec(x)\\tan(x)\\)           </td> </tr> <tr> <td>
\\(\\cot(x)=\\frac{\\cos(x)}{\\sin(x)}\\)     </td> <td>   \\(-cosec^2(x)\\)             </td> </tr> <tr> <td>
\\(\\cosh(x)\\)                            </td> <td>   \\(\\sinh(x)\\)                 </td> </tr> <tr> <td>
\\(\\sinh(x)\\)                            </td> <td>   \\(\\cosh(x)\\)                 </td> </tr> <tr> <td>
\\(\\tanh(x)\\)                            </td> <td>   \\(sech^2(x)\\)               </td> </tr> <tr> <td>
\\(sech(x)\\)                            </td> <td>   \\(-sech(x)\\tanh(x)\\)        </td> </tr> <tr> <td>
\\(cosech(x)\\)                          </td> <td>   \\(-cosech(x)\\coth(x)\\)      </td> </tr> <tr> <td>
\\(coth(x)\\)                            </td> <td>   \\(-cosech^2(x)\\)            </td> </tr>
</table>
</center>

 \\[ \\frac{d}{dx}\\left(\\sin^{-1}(x)\\right) =  \\frac{1}{\\sqrt{1-x^2}}\\]
 \\[ \\frac{d}{dx}\\left(\\cos^{-1}(x)\\right) =  \\frac{-1}{\\sqrt{1-x^2}}\\]
 \\[ \\frac{d}{dx}\\left(\\tan^{-1}(x)\\right) =  \\frac{1}{1+x^2}\\]
 \\[ \\frac{d}{dx}\\left(\\cosh^{-1}(x)\\right) =  \\frac{1}{\\sqrt{x^2-1}}\\]
 \\[ \\frac{d}{dx}\\left(\\sinh^{-1}(x)\\right) =  \\frac{1}{\\sqrt{x^2+1}}\\]
 \\[ \\frac{d}{dx}\\left(\\tanh^{-1}(x)\\right) =  \\frac{1}{1-x^2}\\]';
$string['calc_diff_standard_derivatives_name'] = '標準的な微分';
$string['calc_int_linearity_rule_fact'] = '\\[\\int \\left(af(x)+bg(x)\\right){\\rm d}x = a\\int\\!\\!f(x),{\\rm d}x \\,+\\,b\\int \\!\\!g(x)\\,{\\rm d}x, \\quad (a,b \\, \\, \\mbox{定数} )\\]';
$string['calc_int_linearity_rule_name'] = '積分の線形性';
$string['calc_int_methods_parts_fact'] = '\\[ \\int_a^b u{{\\rm d}v\\over {\\rm d}x}{\\rm d}x=\\left[uv\\right]_a^b- \\int_a^b{{\\rm d}u\\over {\\rm d}x}v\\,{\\rm d}x\\] あるいは \\[\\int_a^bf(x)g(x)\\,{\\rm d}x=\\left[f(x)\\,\\int g(x){\\rm d}x\\right]_a^b -\\int_a^b{{\\rm d}f\\over {\\rm d}x}\\left\\{\\int g(x){\\rm d}x\\right\\}{\\rm d}x.\\]';
$string['calc_int_methods_parts_name'] = '部分積分';
$string['calc_int_methods_substitution_fact'] = '\\[ \\int f(u){{\\rm d}u\\over {\\rm d}x}{\\rm d}x=\\int f(u){\\rm d}u \\quad\\hbox{および}\\quad \\int_a^bf(u){{\\rm d}u\\over {\\rm d}x}\\,{\\rm d}x = \\int_{u(a)}^{u(b)}f(u){\\rm d}u. \\]';
$string['calc_int_methods_substitution_name'] = '置換積分';
$string['calc_int_standard_integrals_fact'] = '\\[\\int k\\ dx = kx +c, \\mbox{ ただし} k \\mbox{は定数}\\]
\\[\\int x^n\\ dx  = \\frac{x^{n+1}}{n+1}+c, \\quad (n\\ne -1)\\]
\\[\\int x^{-1}\\ dx = \\int {\\frac{1}{x}}\\ dx = \\ln(|x|)+c = \\ln(k*|x|) = \\left\\{\\matrix{\\ln(x)+c & x>0\\cr
\\ln(-x)+c & x<0\\cr}\\right.\\]

<center>
<table>
<tr><th>\\(f(x)\\)</th><th> \\(\\int f(x)\\ dx\\)</th></tr>
<tr><td>\\(e^x\\) </td> <td>  \\(e^x+c\\)</td> <td> </td> </tr>
<tr><td>\\(\\cos(x)\\) </td> <td>  \\(\\sin(x)+c\\)   </td> <td> </td> </tr>
<tr><td>\\(\\sin(x)\\) </td> <td>  \\(-\\cos(x)+c\\)  </td> <td> </td> </tr>
<tr><td>\\(\\tan(x)\\) </td> <td>  \\(\\ln(\\sec(x))+c\\) </td> <td>\\(-\\frac{\\pi}{2} < x < \\frac{\\pi}{2}\\)</td> </tr>
<tr><td>\\(\\sec x\\)  </td> <td>  \\(\\ln (\\sec(x)+\\tan(x))+c\\) </td> <td> \\( -{\\pi\\over 2}< x < {\\pi\\over 2}\\)</td> </tr>
<tr><td>cosec\\(\\, x\\) </td> <td>  \\(\\ln ($cosec$(x)-\\cot(x))+c\\) </td> <td>\\(0 < x < \\pi\\)</td> </tr>
<tr><td>cot\\(\\,x\\) </td> <td>  \\(\\ln(\\sin(x))+c\\) </td> <td>  \\(0< x< \\pi\\) </td> </tr>
<tr><td>\\(\\cosh(x)\\) </td> <td>  \\(\\sinh(x)+c\\)</td> <td></td> </tr>
<tr><td>\\(\\sinh(x)\\) </td> <td>  \\(\\cosh(x) + c\\) </td> <td> </td> </tr>
<tr><td>\\(\\tanh(x)\\) </td> <td>  \\(\\ln(\\cosh(x))+c\\)</td> <td> </td> </tr>
<tr><td>coth\\((x)\\) </td> <td>  \\(\\ln(\\sinh(x))+c \\)</td> <td>   \\(x>0\\)</td> </tr>
<tr><td>\\({1\\over x^2+a^2}\\) </td> <td>  \\({1\\over a}\\tan^{-1}{x\\over a}+c\\)</td> <td> \\(a>0\\)</td> </tr>
<tr><td>\\({1\\over x^2-a^2}\\) </td> <td>  \\({1\\over 2a}\\ln{x-a\\over x+a}+c\\) </td> <td>  \\(|x|>a>0\\)</td> </tr>
<tr><td>\\({1\\over a^2-x^2}\\) </td> <td>  \\({1\\over 2a}\\ln{a+x\\over a-x}+c\\) </td> <td>   \\(|x|<a\\)</td> </tr>
<tr><td>\\({1\\over \\sqrt{x^2+a^2}}\\) </td> <td>  \\(\\sinh^{-1}\\left(\\frac{x}{a}\\right) + c\\) </td> <td> \\(a>0\\) </td> </tr>
<tr><td>\\({1\\over \\sqrt{x^2-a^2}}\\) </td> <td>  \\(\\cosh^{-1}\\left(\\frac{x}{a}\\right) + c\\) </td> <td>  \\(x\\geq a > 0\\) </td> </tr>
<tr><td>\\({1\\over \\sqrt{x^2+k}}\\) </td> <td>  \\(\\ln (x+\\sqrt{x^2+k})+c\\)</td> <td> </td> </tr>
<tr><td>\\({1\\over \\sqrt{a^2-x^2}}\\) </td> <td>  \\(\\sin^{-1}\\left(\\frac{x}{a}\\right)+c\\)</td> <td>  \\(-a\\leq x\\leq a\\)  </td> </tr>
</table></center>';
$string['calc_int_standard_integrals_name'] = '標準的な積分';
$string['calc_product_rule_fact'] = '関数の積の微分の法則を示します。 \\(f(x)g(x)\\) を \\(x\\) で微分する場合次のようになります。 \\(f(x)g(x)\\) with respect to \\(x\\). \\[ \\frac{\\mathrm{d}}{\\mathrm{d}{x}} \\big(f(x)g(x)\\big) = f(x) \\cdot \\frac{\\mathrm{d} g(x)}{\\mathrm{d}{x}} + g(x)\\cdot \\frac{\\mathrm{d} f(x)}{\\mathrm{d}{x}},\\] あるいは別の表記で \\[ (f(x)g(x))\\\' = f\\\'(x)g(x)+f(x)g\\\'(x). \\]';
$string['calc_product_rule_name'] = '積法則';
$string['calc_quotient_rule_fact'] = '微分可能な関数 \\(f(x)\\) と \\(g(x)\\)に対する微分の商法則は次のとおりです。\\[\\frac{d}{dx}\\left(\\frac{f(x)}{g(x)}\\right)=\\frac{g(x)\\cdot\\frac{df(x)}{dx}\\ \\ - \\ \\ f(x)\\cdot \\frac{dg(x)}{dx}}{g(x)^2}. \\]';
$string['calc_quotient_rule_name'] = '商法則';
$string['calc_rules_fact'] = '<b>微分の積法則</b><br /> \\(f(x)g(x)\\) を \\(x\\) で微分する場合，関数の積の微分の法則は次のようになります。\\[ \\frac{\\mathrm{d}}{\\mathrm{d}{x}} \\big(f(x)g(x)\\big) = f(x) \\cdot \\frac{\\mathrm{d} g(x)}{\\mathrm{d}{x}} + g(x)\\cdot \\frac{\\mathrm{d} f(x)}{\\mathrm{d}{x}},\\] あるいは別の表記で \\[ (f(x)g(x))\\\' = f\\\'(x)g(x)+f(x)g\\\'(x). \\] <b>微分の商法則</b><br />微分可能な関数 \\(f(x)\\) と \\(g(x)\\)に対する微分の商法則は次のとおりです。 \\[frac{d}{dx}\\left(\\frac{f(x)}{g(x)}\\right)=\\frac{g(x)\\cdot\\frac{df(x)}{dx} - f(x)\\cdot \\frac{dg(x)}{dx}}{g(x)^2}. \\] <b>チェーンルール</b><br />2つの関数で構成される関数の微分は次のようになります。\\(u=g(x)\\) とおくことにより，関数 \\(f(g(x))\\) の \\(x\\) に関する微分は次のようになります。 \\[\\frac{df(g(x))}{dx} = \\frac{dg(x)}{dx}\\cdot\\frac{df(u)}{du}.\\] あるいは別の表記で \\[\\frac{df(x)}{dx} = f\\\'(g(x))\\cdot g\\\'(x).\\]';
$string['calc_rules_name'] = '計算の法則';
$string['casdisplay'] = 'CAS表示';
$string['cassuitecolerrors'] = 'CASエラー';
$string['castext'] = 'CASテキスト';
$string['casvalid'] = 'V2';
$string['casvalidatemismatch'] = 'CASは不一致と判定しています';
$string['casvalue'] = 'CASの値';
$string['chat'] = 'CASに送信する';
$string['chat_desc'] = '<a href="{$a->link}">CASチャットのスクリプト</a>により，CASとの接続を確認し，Maximaの文法を試すことができます。';
$string['chatintro'] = 'このページではCASテキストの動作確認を行うことができます。「問題変数」のテキストボックスで変数の定義を行い（これは省略できます），「CASテキスト」のテキストボックスにCASテキストを入力します。例：「問題変数」に「a:x^3」，「CASテキスト」に「@a@を@x@で微分すると@diff(a,x)@となります」';
$string['chattitle'] = 'CASへの接続を確認します';
$string['checkanswertype'] = '解答形式の確認';
$string['checkanswertype_help'] = 'Yesが指定されると，解答形式として指定された形式と異なる形式の解答が提示された場合，解答が受け付けられません。';
$string['clearedthecache'] = 'CASのキャッシュがクリアされました。';
$string['clearingcachefiles'] = 'キャッシュされたSTACKの描画ファイルを消去しています {$a->done}/{$a->total}';
$string['clearingthecache'] = 'キャッシュを削除しています';
$string['clearthecache'] = 'キャッシュを削除する';
$string['CommaError'] = 'あなたの解答には，リスト，集合，行列で用いられるもの以外のコンマが使われています。<ul><li>リストの場合は，<tt>[...]を使用してください</tt></li><li>集合の場合は，<tt>{...}</tt>を使用してください</li></ul>';
$string['completetestcase'] = '成功するテストケースになるように残りのフォームに入力してください。';
$string['complexno'] = '虚数単位の表記';
$string['complexno_help'] = '記号iとsqrt(-1)の意味と表記を指定します。';
$string['createtestcase'] = 'テストケースを作成する';
$string['currentlyselectedvariant'] = '以下に示す変形です';
$string['ddl_badanswer'] = '入力形式に対して解答例は間違った型になっています：<code>{$a}</code>';
$string['ddl_duplicates'] = '解答欄のオプションを生成しているときに，変数の重複が見つかりました。';
$string['ddl_empty'] = 'ドロップダウンリストの選択肢が定義されていません。a, b, c, dのように値を入力してください。';
$string['ddl_nocorrectanswersupplied'] = '少なくとも一つの解答例が示されなければなりません。';
$string['ddl_runtime'] = '次のランタイムエラーが発生し，解答することができません。管理者に問い合わせてください。';
$string['ddl_unknown'] = 'STACKは<code>{$a}</code>を受け取りましたが，このオプションはリストにはありません。';
$string['debuginfo'] = 'デバッグ情報';
$string['defaultmarkzeroifnoprts'] = 'ポテンシャル・レスポンス・ツリーが定義されていない場合，デフォルトの採点は0です。';
$string['defaultprtcorrectfeedback'] = 'よくできました。正解です!';
$string['defaultprtincorrectfeedback'] = '残念，間違いです。';
$string['defaultprtpartiallycorrectfeedback'] = '惜しい！部分的に正解です。';
$string['deletetestcase'] = '問題{$a->question}のテストケース {$a->no}を削除する';
$string['deletetestcaseareyousure'] = '本当に問題{$a->question}のテストケース {$a->no}を削除しますか？';
$string['deletethistestcase'] = 'このテストケースを削除する';
$string['deploy'] = 'デプロイ';
$string['deployedprogress'] = '変形をデプロイしています';
$string['deployedvariants'] = 'デプロイされた変形';
$string['deployedvariantsn'] = 'デプロイされた変形 ({$a})';
$string['deploymany'] = '以下の数の変形を自動的にデプロイします。';
$string['deploymanyerror'] = '入力が間違っています。変形 "{$a->err}" がデプロイできません。';
$string['deploymanynonew'] = '既存の問題記録の再生成の連続回数が多すぎます。';
$string['deploymanynotes'] = '新しい問題記録の生成に3度失敗するか，問題テストに1度失敗するとSTACKはそれらを中止します。';
$string['deploymanysuccess'] = '正しく生成，テストされ，デプロイされた新しい変形の個数: {$a->no}';
$string['deployoutoftime'] = '{$a->time}秒経過し制限時間を超過しました。もう一度デプロイしてください。';
$string['deployremoveall'] = 'すべての変形をアンデプロイします。';
$string['deploytestall'] = 'デプロイされた全ての変形に対して，全てのテストケースを実行します（時間がかかります。）';
$string['deploytoomanyerror'] = 'STACKは1回のリクエストで最大100の新しい変形をデプロイできます。変形がデプロイされていません。';
$string['displaymismatch'] = '[LaTeX の誤り]';
$string['dropdowngotunrecognisedvalue'] = '不正な入力です。';
$string['editingtestcase'] = '問題{$a->question}のテストケース{$a->no}の編集';
$string['editthistestcase'] = 'このテストケースを編集する';
$string['equiv_AND'] = 'かつ';
$string['equiv_ANDOR'] = 'and / or が混乱しています';
$string['equiv_ASSUMEPOSREALVARS'] = '正の実数変数を仮定';
$string['equiv_ASSUMEPOSVARS'] = '正の変数を仮定';
$string['equivfirstline'] = '解答の最初の行が間違っています。';
$string['Equiv_Illegal_list'] = '同値変形では，リストは許可されていません。';
$string['Equiv_Illegal_matrix'] = '同値変形では，行列は許可されていません。';
$string['Equiv_Illegal_set'] = '同値変形では，集合は許可されていません。';
$string['equiv_MISSINGVAR'] = '評価がされていません。';
$string['equivnocomments'] = 'この入力タイプではコンマの使用は認められていません。一行一行に式を記述してください。';
$string['equiv_NOT'] = '否定';
$string['equiv_OR'] = 'あるいは';
$string['equiv_SAMEROOTS'] = '（同じ根）';
$string['errors'] = 'エラー';
$string['exceptionmessage'] = '{$a}';
$string['expectedanswernote'] = '予想される解答記録';
$string['expectedoutcomes'] = '期待されるポテンシャル・レスポンス・ツリーの出力: [入力に対する]';
$string['expectedpenalty'] = '予想される減点';
$string['expectedscore'] = '予想される採点';
$string['exportthisquestion'] = 'この問題をエクスポートする。';
$string['exportthisquestion_help'] = '一つの問題のみ含むMoodle XMLファイルが作成されます。この問題が，開発者に報告したいと思っているSTACKのバグが再現されるものであると考えれば，有効な一つの例となるでしょう。';
$string['FacForm_UnPick_intfac'] = '共通因子をくくり出す必要があります。';
$string['FacForm_UnPick_morework'] = '項{$a->m0}に対してさらに計算することができます。';
$string['false'] = '偽';
$string['falsebranch'] = '偽の分岐';
$string['falsebranch_help'] = 'これらのフィールドにより様々な解答の処理が行われます。###「計算」と「点数」により採点します。「=」は特定の点数を与えます。「+ / -」は現在の点から加点・減点を行います。###アダプティブモード，インタラクティブモードでは減点は蓄積されます。###「次のノード」で次にどのノードで評価するか，あるいは終了するかを指定します。###「解答記録」は学生の解答履歴をレポートするためのタグで，ポテンシャル・レスポンス・ツリーのパスと評価関数の出力を記録します。';
$string['feedbackfromprtx'] = '{$a}からのフィードバック';
$string['feedbackstyle'] = 'ポテンシャル・レスポンス・ツリーの形式';
$string['feedbackstyle0'] = '形成的';
$string['feedbackstyle1'] = '標準';
$string['feedbackstyle2'] = '簡易';
$string['feedbackstyle3'] = '記号のみ';
$string['feedbackstyle_help'] = 'どのようにポテンシャル・レスポンス・ツリーのフィードバックが表示されるかを制御';
$string['feedbackvariables'] = 'フィードバック変数';
$string['feedbackvariables_help'] = 'フィードバック変数によって，ポテンシャル・レスポンス・ツリーをたどる前に、入力と問題変数を処理することができます。ここで定義されたフィードバック変数は、このポテンシャル・レスポンス・ツリー内のどこでも使うことができます。';
$string['fieldshouldnotcontainplaceholder'] = '{$a->field} はどの[[{$a->type}:...]] も含みません。';
$string['firstnodemusthavelowestnumber'] = '最初のノードは最も小さな番号でなければなりません。';
$string['fixdollars'] = '$の修正';
$string['fixdollars_help'] = '<code>$...$</code> や <code>$$...$$</code>によるTeXの表記をコピー・ペーストしたり入力したりするときに，このオプションは便利です。保存する際に，適切な記号に置き換えられます。';
$string['fixdollarslabel'] = '保存する時に，<code>$...$</code> を <code>\\(...\\)</code>に，<code>$$...$$</code> を<code>\\[...\\]</code> に置き換えます。';
$string['forbiddendoubledollars'] = 'TeXによる数式のインライン表示には<code>\\(...\\)</code>を，ディスプレイ表示には<code>\\[...\\]</code>を使用してください。<code>$...$</code>や<code>$$...$$</code>は許可されていません。これを自動的に修正するためのオプションがあります。。';
$string['forbidfloat'] = '浮動小数点数の禁止';
$string['forbidfloat_help'] = 'Yesが指定されると，浮動小数点数（実数）で入力された解答は禁止されます。';
$string['forbidwords'] = '禁止ワード';
$string['forbidwords_help'] = '学生が解答を入力時に禁止する文字列を，カンマで区切って指定します。';
$string['generalfeedback'] = '全体フィードバック';
$string['generalfeedback_help'] = '全般に対するフィードバックはCASテキストであり，模範解答として学生が解答した後に表示されます。学生の解答に対して与えられるフィードバックとは異なり，全ての学生に対して同じテキストが表示されます。問題変数に応じて表示される場合もあります。';
$string['greek_alphabet_fact'] = '<center> <table> <tr><td> 大文字, \\(\\quad\\) </td><td> 小文字, \\(\\quad\\) </td><td> 名前 </td> </tr> <tr> <td> \\(A\\) </td><td> \\(\\alpha\\) </td><td> アルファ </td> </tr> <tr> <td> \\(B\\) </td><td> \\(\\beta\\) </td><td> ベータ </td> </tr> <tr> <td> \\(\\Gamma\\) </td><td> \\(\\gamma\\) </td><td> ガンマ </td> </tr> <tr> <td> \\(\\Delta\\) </td><td> \\(\\delta\\) </td><td> デルタ </td> </tr> <tr> <td> \\(E\\) </td><td> \\(\\epsilon\\) </td><td> イプシロン </td> </tr> <tr> <td> \\(Z\\) </td><td> \\(\\zeta\\) </td><td> ゼータ </td> </tr> <tr> <td> \\(H\\) </td><td> \\(\\eta\\) </td><td> イータ </td> </tr> <tr> <td> \\(\\Theta\\) </td><td> \\(\\theta\\) </td><td> シータ </td> </tr> <tr> <td> \\(K\\) </td><td> \\(\\kappa\\) </td><td> カッパ </td> </tr> <tr> <td> \\(M\\) </td><td> \\(\\mu\\) </td><td> ミュー </td> </tr> <tr> <td> \\(N\\) </td><td> \\( u\\) </td><td> ニュー </td> </tr> <tr> <td> \\(\\Xi\\) </td><td> \\(\\xi\\) </td><td> グザイ </td> </tr> <tr> <td> \\(O\\) </td><td> \\(o\\) </td><td> おミクロン </td> </tr> <tr> <td> \\(\\Pi\\) </td><td> \\(\\pi\\) </td><td> パイ </td> </tr> <tr> <td> \\(I\\) </td><td> \\(\\iota\\) </td><td> イオタ </td> </tr> <tr> <td> \\(P\\) </td><td> \\(\\rho\\) </td><td> ロー </td> </tr> <tr> <td> \\(\\Sigma\\) </td><td> \\(\\sigma\\) </td><td> シグマ </td> </tr> <tr> <td> \\(\\Lambda\\) </td><td> \\(\\lambda\\) </td><td> ラムダ </td> </tr> <tr> <td> \\(T\\) </td><td> \\(\\tau\\) </td><td> タウ </td> </tr> <tr> <td> \\(\\Upsilon\\) </td><td> \\(\\upsilon\\) </td><td> ウプシロン </td> </tr> <tr> <td> \\(\\Phi\\) </td><td> \\(\\phi\\) </td><td> ファイ </td> </tr> <tr> <td> \\(X\\) </td><td> \\(\\chi\\) </td><td> カイ </td> </tr> <tr> <td> \\(\\Psi\\) </td><td> \\(\\psi\\) </td><td> プサイ </td> </tr> <tr> <td> \\(\\Omega\\) </td><td> \\(\\omega\\) </td><td> オメガ </td></tr> </table></center>';
$string['greek_alphabet_name'] = 'ギリシャ文字';
$string['healthautomaxopt'] = '最適化されたMaximaイメージを自動的に作成します。';
$string['healthautomaxopt_failed'] = '最適化されたMaximaイメージの作成に失敗しました : [{$a->errmsg}]';
$string['healthautomaxoptintro'] = '最高のパフォーマンスを得るためには，Linux上でMaximaを最適化する必要があります。<a href="doc/doc.php/CAS/Optimising_Maxima.md">documentation</a>を参照してください。';
$string['healthautomaxopt_nolisp'] = 'LISPのバージョンを特定できなかったので，Maximaイメージが自動的には作成されませんでした。';
$string['healthautomaxopt_nolisprun'] = 'lisp.runを自動的に見つけることができませんでした。コマンドラインから"sudo updatedb"を実行し，最適化のためのドキュメントを参照してください。';
$string['healthautomaxopt_notok'] = 'Maximaのイメージが自動的には作成できませんでした。';
$string['healthautomaxopt_ok'] = 'Maximaのイメージが<tt>{$a->command}</tt>に作成されました。';
$string['healthautomaxopt_succeeded'] = '最適化されたMaximaイメージの作成に成功しました';
$string['healthcheck'] = 'STACK動作確認';
$string['healthcheckcache_db'] = 'CASの演算結果がデータベースにキャッシュされています。';
$string['healthcheckcache_none'] = 'CASの結果はキャッシュされません。';
$string['healthcheckcache_otherdb'] = 'CASの結果が別のデータベースにキャッシュされています。';
$string['healthcheckcachestatus'] = 'キャッシュは {$a} を含んでいます。';
$string['healthcheckconfig'] = 'Maxima設定ファイル';
$string['healthcheckconfigintro1'] = '次のディレクトリにMaximaが見つかり，使用されています。';
$string['healthcheckconfigintro2'] = 'Maximaの設定ファイルを自動生成しています。';
$string['healthcheckconnect'] = 'CASへ接続しています。';
$string['healthcheckconnectintro'] = '以下のCASテキストを評価しています。';
$string['healthcheckcreateimage'] = 'Maximaのイメージを作成';
$string['healthcheck_desc'] = '<a href="{$a->link}">動作確認スクリプト</a>により，STACKの全ての機能が正しく動作していることを検証することができます。';
$string['healthcheckfilters'] = '<a href="{$a->url}">フィルターの利用</a>のページで {$a->filter} が利用可能になります。';
$string['healthchecklatex'] = 'LaTeXが正しく変換されているかチェックしています。';
$string['healthchecklatexintro'] = 'STACKではLaTeXを解釈するので，教師はLaTeXを使って問題を作成することができます。LaTeXはMoodleのフィルターにより変換されます。LaTeXのデスプレイ表示とインライン表示の例を以下に表示します。あなたのブラウザで正しく表示されているはずです。表示の問題があれば，それはMoodleのフィルター設定の問題であり，STACKの問題ではありません。STACKでは$あるいは$$のみを使用することができますが，問題の作成においては他の表記を使います。';
$string['healthchecklatexmathjax'] = '式をレンダリングする一つの方法は，次のコードを<a href="{$a}">Additional HTML</a>に設定されている<b>Within HEAD</b>にコピーすることです。';
$string['healthcheckmathsdisplaymethod'] = '数式の表示には{$a}が使われています。';
$string['healthcheckmaximabat'] = 'maxima.batファイルが見つかりません。';
$string['healthcheckmaximabatinfo'] = '"C:\\Program files\\Maxima-1.xx.y\\bin"のmaxima.batを"{$a}stack"にコピーしようとしましたが，正常に処理できませんでした。このファイルを手動でコピーしてください。';
$string['healthchecknombstring'] = 'STACK v4.3とそれ以降はPHPモジュール mbstring が必要ですが，見つかりません。インストールドキュメントを参照してください。';
$string['healthcheckplots'] = 'グラフ描画';
$string['healthcheckplotsintro'] = '二つの異なった描画がなければなりません。同一の描画の場合，描画ファイルのネーミングにエラーが生じます。エラーがないにもかかわらずグラフが描画されない場合，次のいずれかが参考になります。(i)テンポラル・ディレクトリの読み出し許可をチェックしてください。(ii)GNUplotのオプションを変更してください。ただし，現在のところオプション変更のためのWebインターフェースはありません。';
$string['healthchecksamplecas'] = '{@ x^4/(1+x^4) @} の微分は \\[ \\frac{d}{dx} \\frac{x^4}{1+x^4} = {@ diff(x^4/(1+x^4),x) @}. \\]';
$string['healthchecksampledisplaytex'] = '\\[\\sum_{n=1}^\\infty \\frac{1}{n^2} = \\frac{\\pi^2}{6}.\\]';
$string['healthchecksampleinlinetex'] = '\\(
\\sum_{n=1}^\\infty \\frac{1}{n^2} = \\frac{pi^2}{6}
\\)';
$string['healthchecksampleplots'] = '2つのグラフの例。{@plot([x^4/(1+x^4),diff(x^4/(1+x^4),x)],[x,-3,3])@} {@plot([sin(x),x,x^2,x^3],[x,-3,3],[y,-3,3],grid2d)@} 通常の軸で，3つ目のプロットがここに表示されます（Maximaの新しいバージョンの場合）。 {@plot([sin(x),x,x^2,x^3],[x,-3,3],[y,-3,3],[box, false],[yx_ratio, 1],[axes, solid],[xtics, -3, 1, 3],[ytics, -3, 1, 3])@}';
$string['healthchecksstackmaximanotupdated'] = 'STACKは正常にアップデートされませんでした。<a href="{$a}">System administration -> Notifications page</a>.を確認してください。';
$string['healthchecksstackmaximatooold'] = 'バージョンが古すぎます。';
$string['healthchecksstackmaximaversion'] = 'Maximaのバージョン';
$string['healthchecksstackmaximaversionfixoptimised'] = '<a href="{$a->url}">最適化されたMaxima実行ファイルの再構築</a>を行ってください。';
$string['healthchecksstackmaximaversionfixserver'] = 'MaximaPoolサーバでMaximaのコードを再構築してください。';
$string['healthchecksstackmaximaversionfixunknown'] = 'それがどのようにして起こったのか不明です。この問題は自分で解決する必要があるでしょう。CASのキャッシュを消去して始めてください。';
$string['healthchecksstackmaximaversionmismatch'] = '使用されているSTACK-Maximaライブラリのバージョン ({$a->usedversion}) はSTACK問題タイプで必要とされているバージョン ({$a->expectedversion}) と一致していません。{$a->fix}';
$string['healthchecksstackmaximaversionok'] = '正しいSTACK-Maximaライブラリのバージョンが使われています。({$a->usedversion})';
$string['healthunabletolistavail'] = '「プラットフォームの種類」が"unix"に設定されていないので，可能なMaximaのバージョンをリストアップすることができません。';
$string['healthuncached'] = 'CASをキャッシュしません';
$string['healthuncachedintro'] = '現在のキャッシュの設定にかかわらず，このセクションは常にCASに命令を送ります。これは，CASへの接続が本当に現在動作しているかを確認するために必要です。';
$string['healthuncachedstack_CAS_calculation'] = '期待されるCASの計算：{$a->expected}。実際のCASの計算：{$a->actual}。';
$string['healthuncachedstack_CAS_not'] = 'CASは期待したとおりデータを返しましたが，エラーがありました。';
$string['healthuncachedstack_CAS_ok'] = 'CASは期待したとおりデータを返しました。現在CASと接続しています。';
$string['healthuncachedstack_CAS_version'] = '期待されるMaximaのバージョン："{$a->expected}"。実際のMaximaのバージョン：{$a->actual}';
$string['healthuncachedstack_CAS_versionnotchecked'] = 'あなたはMaximaの"デフォルト"バージョンを選択したので，Maximaのバージョンの確認は行われていません。実際に使われているバージョンは{$a->actual}です。';
$string['htmlfragment'] = 'HTMLの要素が含まれているようです。';
$string['hyp_functions_fact'] = '双曲線関数は三角関数と同様の性質を持っていますが，次のように指数関数を使って表すことができます。\\[ \\cosh(x) = \\frac{e^x+e^{-x}}{2}, \\qquad \\sinh(x)=\\frac{e^x-e^{-x}}{2} \\] \\[ \\tanh(x) = \\frac{\\sinh(x)}{\\cosh(x)} = \\frac{{e^x-e^{-x}}}{e^x+e^{-x}} \\] \\[ {\\rm sech}(x) ={1\\over \\cosh(x)}={2\\over {\\rm e}^x+{\\rm e}^{-x}}, \\qquad {\\rm cosech}(x)= {1\\over \\sinh(x)}={2\\over {\\rm e}^x-{\\rm e}^{-x}} \\] \\[ {\\rm coth}(x) ={\\cosh(x)\\over \\sinh(x)} = {1\\over {\\rm tanh}(x)} ={{\\rm e}^x+{\\rm e}^{-x}\\over {\\rm e}^x-{\\rm e}^{-x}}\\]';
$string['hyp_functions_name'] = '双曲線関数';
$string['hyp_identities_fact'] = '双曲線関数と三角関数の類似性が次の関係式により明らかです。
 \\[{\\rm e}^x=\\cosh(x)+\\sinh(x), \\quad {\\rm e}^{-x}=\\cosh(x)-\\sinh(x)\\]
  \\[\\cosh^2(x) -\\sinh^2(x) = 1\\]
  \\[1-{\\rm tanh}^2(x)={\\rm sech}^2(x)\\]
  \\[{\\rm coth}^2(x)-1={\\rm cosech}^2(x)\\]
  \\[\\sinh(x\\pm y)=\\sinh(x)\\ \\cosh(y)\\ \\pm\\ \\cosh(x)\\ \\sinh(y)\\]
  \\[\\cosh(x\\pm y)=\\cosh(x)\\ \\cosh(y)\\ \\pm\\ \\sinh(x)\\ \\sinh(y)\\]
  \\[\\sinh(2x)=2\\,\\sinh(x)\\cosh(x)\\]
  \\[\\cosh(2x)=\\cosh^2(x)+\\sinh^2(x)\\]
  \\[\\cosh^2(x)={\\cosh(2x)+1\\over 2}\\]
  \\[\\sinh^2(x)={\\cosh(2x)-1\\over 2}\\]';
$string['hyp_identities_name'] = '双曲線関数の公式';
$string['hyp_inverse_functions_fact'] = '\\[\\cosh^{-1}(x)=\\ln\\left(x+\\sqrt{x^2-1}\\right) \\quad x\\geq 1 \\mbox{のとき} \\] \\[\\sinh^{-1}(x)=\\ln\\left(x+\\sqrt{x^2+1}\\right)\\] \\[\\tanh^{-1}(x) = \\frac{1}{2}\\ln\\left({1+x\\over 1-x}\\right) \\quad  -1< x < 1 \\mbox{のとき}\\]';
$string['hyp_inverse_functions_name'] = '逆双曲線関数';
$string['illegalcaschars'] = 'CASの入力では@, $, \\ は使用できません。';
$string['Illegal_floats'] = 'あなたの解答には小数が含まれています。整数または分数で解答してください。例：0.3333ではなく1/3と入力してください。';
$string['inputdisplayed'] = '表示';
$string['inputentered'] = '入力値';
$string['inputexpression'] = '入力テスト';
$string['inputextraoptions'] = 'その他のオプション';
$string['inputextraoptions_help'] = 'いくつかの解答形式では正常に処理されるためにオプションが必要です。CASの表示で入力してください。';
$string['inputheading'] = '解答欄: {$a}';
$string['inputlanguageproblems'] = '言語間で入力と確認のタグに不一致があります。';
$string['inputname'] = '解答の名前';
$string['inputnamelength'] = '解答の名前は18文字を超えてはいけません。\'{$a}\' は長すぎます。';
$string['inputoptionunknown'] = 'この入力では\'{$a}\'オプションはサポートされていません。';
$string['inputremovedconfirm'] = 'この問題から解答欄を本当に削除します。';
$string['inputremovedconfirmbelow'] = '解答欄 \'{$a}\' が削除されました。以下で確認してください。';
$string['inputs'] = '解答';
$string['inputstatus'] = '状態';
$string['inputstatusname'] = '空白';
$string['inputstatusnameinvalid'] = '無効';
$string['inputstatusnamescore'] = '採点';
$string['inputstatusnamevalid'] = '有効';
$string['inputtest'] = '解答テスト';
$string['inputtype'] = '解答形式';
$string['inputtypealgebraic'] = '数式';
$string['inputtypeboolean'] = '○/×';
$string['inputtypecheckbox'] = 'チェックボックス';
$string['inputtypedropdown'] = 'ドロップダウンリスト';
$string['inputtypeequiv'] = '同値変形';
$string['inputtype_help'] = '解答形式を指定します。';
$string['inputtypematrix'] = '行列';
$string['inputtypenotes'] = 'ノート';
$string['inputtypenumerical'] = '数値';
$string['inputtyperadio'] = 'ラジオボタン';
$string['inputtypesinglechar'] = '単一文字';
$string['inputtypestring'] = '文字列';
$string['inputtypetextarea'] = 'テキストエリア';
$string['inputtypeunits'] = '単位';
$string['inputwillberemoved'] = 'この解答は問題テキストで参照されていません。今問題を保存すると，この解答に関するデータが失われます。本当に保存してよろしいですか？あるいは，問題テキストを編集して，\'[[input:{$a}]]\' と \'[[validation:{$a}]]\'を戻してください。';
$string['insertspaces'] = '空白に対して*を自動挿入する';
$string['insertstars'] = '*(積)の自動挿入';
$string['insertstarsassumesinglechar'] = '変数名が1文字と仮定して*を挿入する';
$string['insertstars_help'] = 'このオプションで，暗黙的に積である場合に「*」を挿入するかどうかについて様々な指定が可能になります。詳細はドキュメントを参照してください。';
$string['insertstarsno'] = '*の自動挿入をしない';
$string['insertstarsspaces'] = '積を意味するところや空白に*を自動挿入する';
$string['insertstarsspacessinglechar'] = '一文字変数の積とみなされる場合や，一文字変数の間の空白に*を自動挿入する';
$string['insertstarsyes'] = '暗黙の積に対して*を自動挿入する';
$string['inversetrig'] = '逆三角関数';
$string['inversetrig_help'] = 'CASの出力で逆三角関数をどのように表示するかを指定します。';
$string['irred_Q_commonint'] = '共通因子をくくり出す必要があります。';
$string['irred_Q_factored'] = '{$a->m0}の項は因数分解してはいけません。';
$string['irred_Q_optional_fac'] = '{$a->m0}は因数分解できますが、その必要はありません。';
$string['Lowest_Terms'] = 'あなたの解答には約分出来ていない箇所があります。もう一度よく見直して入力してください。';
$string['matrixparens'] = '行列の括弧のデフォルトの形式';
$string['matrixparens_help'] = '行列の括弧の形式を設定してください。';
$string['Maxima_Args'] = '引数 args: は同時実行は許可されていません。';
$string['Maxima_DivisionZero'] = 'あなたの解答には0で割られている箇所があります。もう一度見直して入力してください。';
$string['multcross'] = 'クロス (×)';
$string['multdot'] = 'ドット (・)';
$string['multiplicationsign'] = '積の記号';
$string['multiplicationsign_help'] = '積の演算子の表記を定義します。';
$string['mustverify'] = '入力した解答の表示';
$string['mustverify_help'] = '採点される前に，入力した数式が自ら意図したものかどうかを確認するために，入力した数式を表示するかどうかを指定します。文法の間違いも表示されます。';
$string['mustverifyshowvalidation'] = '学生に，入力した数式の文法の確認結果を表示しないで，入力した数式の2段階確認を求めることはできません。このような設定は学生に実行不可能なことを求めることになります。';
$string['namealreadyused'] = 'すでにこの名前は使用されています。';
$string['newnameforx'] = '\'{$a}\'に対する新しい名前';
$string['next'] = '次のノード';
$string['nextcannotbeself'] = '次のノードに現在のノード自身を指定することはできません。';
$string['nodehelp'] = 'ポテンシャル・レスポンス・ツリーのノード';
$string['nodehelp_help'] = '###「評価関数」は2つの数式を比較して，ある数学的な条件を満たしているかどうかを判定します。

###「評価対象」は評価関数の最初の引数で，通常は学生の解答ですが，問題変数やフィードバック変数を含む，任意の数式も使用できます。

###「評価基準」は評価関数の2番目の引数で，通常は正解ですが，問題変数やフィードバック変数を含む，任意の数式も使用できます。

###「オプション」は評価関数に必要な場合に指定します。

###「抑制」は評価関数からのフィードバックを表示しないようにするために指定します。フィードバックのフィールドはこのオプションにより影響を受けることはありません。';
$string['nodeloopdetected'] = 'ポテンシャル・レスポンス・ツリーのループができます。';
$string['nodenotused'] = 'どのノードからもこのノードにリンクがありません。';
$string['nodex'] = 'ノード {$a}';
$string['nodexdelete'] = 'ノード {$a}の削除';
$string['nodexfalsefeedback'] = 'ノード\'{$a}\'の偽のフィードバック';
$string['nodextruefeedback'] = 'ノード\'{$a}\'の真のフィードバック';
$string['nodexwhenfalse'] = '偽の場合のノード{$a}';
$string['nodexwhentrue'] = '真の場合のノード{$a}';
$string['nonempty'] = '空白にできません。';
$string['noprtsifnoinputs'] = '解答を求めない問題はポテンシャル・レスポンス・ツリーを作成することはできません。';
$string['notanswered'] = '(以下のいずれでもない)';
$string['notavalidname'] = '正しい名前ではありません。';
$string['notestcasesyet'] = 'テストケースは追加されませんでした。';
$string['numericalinputdp'] = '小数点以下\\( {$a} \\)桁で表してください。';
$string['numericalinputmaxdp'] = '高々，小数点以下\\( {$a} \\)桁で表してください。';
$string['numericalinputmaxsf'] = '有効数字\\( {$a} \\)桁で表してください。';
$string['numericalinputmindp'] = '少なくとも，小数点以下\\( {$a} \\)桁で表してください。';
$string['numericalinputminmaxerr'] = '入力された最小桁数が，最大桁数を超えています！';
$string['numericalinputminsf'] = '少なくとも有効数字\\( {$a} \\)桁で表してください。';
$string['numericalinputminsfmaxdperr'] = '小数点以下の桁数と有効数字の桁数を同時に指定しないでください。';
$string['numericalinputmustfloat'] = '浮動小数点数を入力してください。';
$string['numericalinputmustrational'] = '分数か有理数で入力してください。';
$string['numericalinputoptboolerr'] = 'オプション<code>{$a->opt}</code> は論理型でなければなりませんが，実際には<code>{$a->val}</code>となっています。';
$string['numericalinputoptinterr'] = 'オプション<code>{$a->opt}</code> は整数型でなければなりませんが，実際には<code>{$a->val}</code>となっています。';
$string['numericalinputsf'] = '有効数字\\( {$a} \\)で表してください。';
$string['numericalinputvarsforbidden'] = '変数を含まない，数値で解答してください。';
$string['options'] = 'オプション';
$string['optionsnotrequired'] = 'この解答形式にはオプションは必要ありません';
$string['overallresult'] = '全体の結果';
$string['penalty'] = '減点';
$string['penaltyerror'] = '減点は0から1の間の数値としてください。';
$string['penaltyerror2'] = '減点は空欄か，0から1の間の数値としてください。';
$string['penalty_help'] = '部分点を与える場合，ポテンシャル・レスポンス・ツリーの結果に応じてここで指定した点数を減点していきます。';
$string['phpcasstring'] = 'PHP出力';
$string['phpsuitecolerror'] = 'PHPエラー';
$string['phpvalid'] = 'V1';
$string['phpvalidatemismatch'] = 'PHPは不一致と判定しています';
$string['pleaseananswerallparts'] = '全ての問題に解答してください。';
$string['pleasecheckyourinputs'] = 'あなたの入力した数式が期待したものであるか確認してください。';
$string['pluginname'] = 'STACK';
$string['pluginnameadding'] = 'STACK問題の追加';
$string['pluginnameediting'] = 'STACK問題の編集';
$string['pluginname_help'] = 'STACKは数学オンラインテスト・評価システムです。';
$string['pluginnamesummary'] = 'STACKはMoodleにおいて数式で解答する形式の問題を可能にします。数式処理システムを用いて，解答の正誤評価や解答に応じた様々なフィードバックの提示を実現します。';
$string['privacy:metadata'] = 'STACK問題タイプには個人情報は保存されません。';
$string['prtcorrectfeedback'] = '正解の場合のフィードバック';
$string['prtheading'] = 'ポテンシャル・レスポンス・ツリー: {$a}';
$string['prtincorrectfeedback'] = '不正解の場合のフィードバック';
$string['prtmustbesetup'] = '問題を保存する前にポテンシャル・レスポンス・ツリーを設定しなければなりません。';
$string['prtname'] = 'ポテンシャル・レスポンス・ツリー名';
$string['prtnamelength'] = 'ポテンシャル・レスポンス・ツリーの名前は18文字を超えてはいけません。\'{$a}\'は長過ぎます。';
$string['prtnodesheading'] = 'ポテンシャル・レスポンス・ツリーのノード ({$a})';
$string['prtpartiallycorrectfeedback'] = '部分的正解の場合のフィードバック';
$string['prtremovedconfirm'] = '問題からこのポテンシャル・レスポンス・ツリーを本当に削除します。';
$string['prtremovedconfirmbelow'] = 'ポテンシャル・レスポンス・ツリー\'{$a}\'が削除されました。以下を確認してください。';
$string['prtruntimeerror'] = 'ノード{$a->node}は以下のエラーを引き起こしました。{$a->error}';
$string['prts'] = 'ポテンシャル・レスポンス・ツリー';
$string['prtwillbecomeactivewhen'] = '解答欄 {$a} に解答が行われたときに，このポテンシャル・レスポンス・ツリーは有効になります。';
$string['prtwillberemoved'] = 'このポテンシャル・レスポンス・ツリーは問題テキストや特定フィードバックから参照されていません。今この問題を保存すると，ポテンシャル・レスポンス・ツリーに関するデータが失われます。本当に保存してもよろしいですか？あるいは，問題テキストや特定フィードバックを編集して，\'[[feedback:{$a}]]\'を戻してください。';
$string['qm_error'] = 'あなたの解答には ? マークが含まれていますが，それは許可されていません。';
$string['questiondoesnotuserandomisation'] = 'この問題はランダム化されていません。';
$string['questionnotdeployedyet'] = 'この問題では変形がデプロイされていません。';
$string['questionnote'] = '問題記録';
$string['questionnote_help'] = '問題記録はCASテキストで記述し，個々のランダムな問題を区別するために用いられます。問題記録が同じ場合，またその時にのみ，ランダム化された問題は同じものとみなされます。後の解析のために意味のある問題記録を残すことが重要です。';
$string['questionnotempty'] = '問題変数にrand() が用いられている場合，問題記録は空欄にはできません。問題記録は個々のランダムな問題を区別するために用いられます。';
$string['questionpreview'] = '問題のプレビュー';
$string['questionsimplify'] = '自動簡略化（全般）';
$string['questionsimplify_help'] = '全ての問題でMaximaのグローバルなsimp変数を設定します。';
$string['questiontests'] = '問題のテスト';
$string['questiontestspass'] = '全ての問題テストがパスしました。';
$string['questiontext'] = '問題文';
$string['questiontextfeedbacklanguageproblems'] = '言語間でフィードバックタグに不一致があります。';
$string['questiontextfeedbackonlycontain'] = '特定フィードバックをもつ問題文に \'{$a}\' を1つだけ含むことができます。';
$string['questiontext_help'] = '学生が実際に目にする問題文でCASテキストで入力します。解答欄と解答確認欄を入力しなければなりません。入力例：[[input:ans1]] [[validation:ans1]]';
$string['questiontextmustcontain'] = '問題文には \'{$a}\' が含まれていなければなりません。';
$string['questiontextnonempty'] = '問題文は空白であってはいけません。';
$string['questiontextonlycontain'] = '問題文に \'{$a}\' を1つだけ含むことができます。';
$string['questiontextplaceholderswhitespace'] = '空白文字を含むことができません。\'{$a}';
$string['questionvalue'] = '比重';
$string['questionvaluepostive'] = '比重は正でなければなりません。';
$string['questionvariables'] = '問題変数';
$string['questionvariables_help'] = '問題文の中で使用する変数を定義し，ランダム問題を作成することもできます。ここで定義された変数は，他のフィールドでも使用できます。';
$string['questionvariablevalues'] = '問題変数の値';
$string['quiet'] = '抑制';
$string['quiet_help'] = '「はい」と設定された場合，評価関数によって自動的に生成されるフィードバックは抑制され，学生には表示されません。このオプションは，フィードバックのフィールドには影響を与えません。';
$string['renamequestionparts'] = '問題の一部の名前を変更します';
$string['replacedollarscount'] = 'このカテゴリはSTACKの問題{$a}を含みます。';
$string['replacedollarserrors'] = '次の問題がエラーを引き起こしました。';
$string['replacedollarsin'] = '{$a}の数式範囲指定区切り文字を修正しました。';
$string['replacedollarsindex'] = 'STACKの問題の内容';
$string['replacedollarsindexintro'] = 'これらのどのリンクをクリックしても$を含む問題をプレビューでき，自動的に修正します。';
$string['replacedollarsindextitle'] = '問題文中の $ を置き換えます。';
$string['replacedollarsnoproblems'] = '問題のある$は見つかりませんでした。';
$string['replacedollarstitle'] = '{$a} 内の $ を置き換えます。';
$string['requiredfield'] = 'このフィールドは必須です。';
$string['requirelowestterms'] = '約分を要求する';
$string['requirelowestterms_help'] = 'Yesが指定されると，分数は約分されていなければなりません。もし約分されていなければ解答は受け付けられません。';
$string['runquestiontests'] = '問題のテストとデプロイ';
$string['sans'] = '評価対象';
$string['sans_help'] = 'これは評価関数の第1引数で，通常，学生の解答ですが，に任意のCASテキストを指定することができ，問題変数，フィードバック変数に依存したものも可能です。';
$string['sansinvalid'] = '評価対象が正しく指定されていません。{$a}';
$string['sansrequired'] = '評価対象は空欄とすることはできません。';
$string['score'] = '点数';
$string['scoreerror'] = '点数は0から1の間の数値でなければなりません。';
$string['scoremode'] = '計算';
$string['seedx'] = '乱数のシード {$a}';
$string['seethisquestioninthequestionbank'] = 'この問題を問題バンク内で見る。';
$string['settingajaxvalidation'] = '即時評価';
$string['settingajaxvalidation_desc'] = 'Yesが指定されると，学生の解答はリアルタイムに表示され確認されます。学生にとって使い勝手はよいかもしれませんが，サーバに負荷がかかります。';
$string['settingcasdebugging'] = 'CASのデバッグ';
$string['settingcasdebugging_desc'] = 'CAS接続についてのデバッグ情報を保存するかどうかを指定します。';
$string['settingcasmaximaversion'] = 'Maximaのバージョン';
$string['settingcasmaximaversion_desc'] = '使用しているMaximaバーション';
$string['settingcasresultscache'] = 'CASの結果をキャッシュ';
$string['settingcasresultscache_db'] = 'データベースのキャッシュ';
$string['settingcasresultscache_desc'] = 'この設定はCASの情報をキャッシュするかどうかを決定します。Maximaのコードを変更するような開発を行うのでなければ，この設定は有効にしておくべきです。キャッシュの現在の情報は動作確認のページに表示されます。例えばgnuplotコマンドなどの設定を変更する場合，その効果を確かめる前にキャッシュをクリアする必要があります。';
$string['settingcasresultscache_none'] = 'キャッシュしない';
$string['settingcastimeout'] = 'CASタイムアウト';
$string['settingcastimeout_desc'] = 'Maximaへの接続のタイムアウト';
$string['settingdefaultinputoptions'] = 'デフォルトの解答形式オプション';
$string['settingdefaultinputoptions_desc'] = '新しい問題を作成したり，既存の問題に新しい解答欄を加えるときに参照されます。';
$string['settingdefaultquestionoptions'] = 'デフォルトの解答形式オプション';
$string['settingdefaultquestionoptions_desc'] = '新しい問題を作成するときに使用します。';
$string['settingmathsdisplay'] = '数式表示フィルター';
$string['settingmathsdisplay_desc'] = '数式を表示するための方法です。もしMathJaxを選択した場合，動作確認のページで指示に従わなければなりません。フィルターを選択したら，設定ページでそのフィルターを有効にしなければなりません。';
$string['settingmathsdisplay_mathjax'] = 'MathJax';
$string['settingmathsdisplay_maths'] = 'OU Mathフィルター';
$string['settingmathsdisplay_oumaths'] = '新しいOpen University数学フィルター';
$string['settingmathsdisplay_tex'] = 'Moodle TeX フィルター';
$string['settingmaximalibraries'] = 'オプションのMaximaライブラリの読み込み：';
$string['settingmaximalibraries_desc'] = 'これはカンマで区切られたMaximaのライブラリ名のリストで，Maximaに自動的にロードされます。サポートされているライブラリのみ使用することができます。サポートされているライブラリについてはドキュメントを参照してください。もしパフォーマンスの最適化のためにMaximaイメージが保存されている場合は，ライブラリは読み込まれません。';
$string['settingmaximalibraries_error'] = '次のパッケージはサポートされていません：{$a}';
$string['settingmaximalibraries_failed'] = 'あなたの要求したMaximaパッケージのいくつかの読み込みに失敗しているようです。このエラーに対する注意については，インストール手順を参照してください。';
$string['settingplatformmaximacommand'] = 'Maximaコマンド';
$string['settingplatformmaximacommand_desc'] = '「プラットフォームの種類」がサーバの場合，これはMaxima Pool ServletのURLを指定しなければいけません。そのほかのプラットフォームの場合，ここが空欄にするとSTACKはMaximaの場所を取得します。取得に失敗した場合は，Maximaの場所をフルパス(full path）で指定してください。Unixベースのシステムの場合，タイムアウトコマンドを使用することを検討してください。例 timeout --kill-after=10s 10s maxima';
$string['settingplatformplotcommand'] = 'gnuplot コマンド';
$string['settingplatformplotcommand_desc'] = 'STACKはgnuplotのコマンドの場所を知らなければなりません。もし空欄の場合推測します。';
$string['settingplatformtype'] = 'プラットフォームの種類';
$string['settingplatformtype_desc'] = 'STACKはどのOS上で動作しているかを知る必要があります。サーバのオプションを指定することによりパフォーマンスが向上します。Linux（最適化）はドキュメントの「Maxima最適化」の項で解説されています。';
$string['settingplatformtypeserver'] = 'サーバ';
$string['settingplatformtypeunix'] = 'Linux';
$string['settingplatformtypeunixoptimised'] = 'Linux（最適化）';
$string['settingplatformtypewin'] = 'Windows';
$string['settingreplacedollars'] = '<code>$</code> と <code>$$</code> を置き換え';
$string['settingreplacedollars_desc'] = '問題テキストの <code>$</code> と <code>$$</code> を<code>\\\\(...\\\\)</code> と <code>\\\\[...\\\\]</code> に置き換えます。「数式タグの修正スクリプト」が便利です。';
$string['settingserveruserpass'] = 'サーバ　ユーザ名:パスワード';
$string['settingserveruserpass_desc'] = 'もし「プラットフォームの種類」でサーバを指定していて，MaximaプールサーバをHTTP認証で設定したら，ユーザ名とパスワードを入力することができ，多少安全です。フォーマットは，ユーザ名:パスワード，です。';
$string['settingsmathsdisplayheading'] = '数式表示オプション';
$string['settingsmaximasettings'] = 'Maximaに接続しています';
$string['settingusefullinks'] = '便利なリンク';
$string['showingundeployedvariant'] = 'デプロイされていない変形 {$a} を表示しています';
$string['showvalidation'] = '数式の文法の確認';
$string['showvalidation_help'] = '入力された数式の文法に間違いがないかどうかを確認し，伝統的な2次元表示で数式を表示します。';
$string['showvalidationno'] = 'いいえ';
$string['showvalidationyes'] = 'はい（変数リストあり）';
$string['showvalidationyesnovars'] = 'はい（変数リストなし）';
$string['singlechargotmorethanone'] = 'ここには1文字だけ入力できます。';
$string['specificfeedback'] = '特定フィードバック';
$string['specificfeedback_help'] = 'デフォルトでは各ポテンシャル・レスポンス・ツリーのフィードバックはこのブロックに表示されます。表示位置を問題テキストに移動が可能ですが，その場合にはMoodleはあまり制御できません。このブロックはCASテキストではありません。';
$string['specificfeedbacktags'] = '特定フィードバックには\'{$a}\'が含まれてはいけません。';
$string['sqrtsign'] = '平方根の記号';
$string['sqrtsign_help'] = '平方根の記号を表示します。';
$string['stackBlock_elif_after_else'] = '"if-else"には"elif"を使います。';
$string['stackBlock_elif_out_of_an_if'] = '"elif"はifブロックの外では使えません。';
$string['stackBlock_else_out_of_an_if'] = '"else"はifブロックの外では使えません。';
$string['stackBlock_escapeNeedsValue'] = 'Escapeブロックには値の属性が必要です。';
$string['stackBlock_ifNeedsCondition'] = 'ifブロックには条件の属性が必要です。';
$string['stackBlock_jsxgraph_height'] = 'JSXGraphの高さはCSSの長さの単位を使ってください。';
$string['stackBlock_jsxgraph_height_num'] = 'JSXGraphの高さの割合は数値であり，文字が含まれてはいけません。';
$string['stackBlock_jsxgraph_param'] = 'JSXGraphブロックはこれらのパラメータのみサポートしています：{$a->param}';
$string['stackBlock_jsxgraph_ref'] = '';
$string['stackBlock_jsxgraph_width'] = 'JSXGraphの幅はCSSの長さの単位を使ってください。';
$string['stackBlock_jsxgraph_width_num'] = 'JSXGraphの幅の割合は数値であり，文字が含まれてはいけません。';
$string['stackBlock_missmatch'] = '一致していません。';
$string['stackBlock_multiple_else'] = 'ifブロックでの複数のelseブランチ';
$string['stackBlock_unknownBlock'] = '次のブロックは不明です：';
$string['stackCas_allFailed'] = 'CASは何も評価された式を返しませんでした。CASとの接続を確認してください。';
$string['stackCas_apostrophe'] = 'アポストロフィは許可されていません。';
$string['stackCas_backward_inequalities'] = '不等号\\( \\leq \\) や \\( \\geq \\) は<=，=>と入力しなければなりません。あなたの入力した数式には{$a->cmd}が含まれています。';
$string['stackCas_badLogIn'] = '数式<tt>In</tt>を入力しました。自然対数は<tt>ln</tt>を小文字で入力する必要があります。（"Lima November"であり，"India November"ではありません）';
$string['stackCas_bracketsdontmatch'] = '数式中の括弧の入れ子が正しくありません。{$a->cmd}';
$string['stackCas_CASError'] = 'CASは次のエラーを返しました。';
$string['stackCas_CASErrorCaused'] = 'CASエラーが発生しました。';
$string['stackCas_chained_inequalities'] = 'あなたの入力した数式には \\(a &lt b &lt c \\) のような形式の連結不等式が含まれているようです。個々の不等式を AND や OR の論理演算で結合する必要があります。';
$string['stackCas_failedReturn'] = 'CASはデータを返しませんでした。';
$string['stackCas_failedReturnOne'] = 'CASがいくつかのデータを返していません。';
$string['stackCas_failedValidation'] = 'CASテキストが正しくありません。';
$string['stackCas_finalChar'] = '\'{a->char}\'は{a->cmd}の中では無効な終端文字です。';
$string['stackCas_forbiddenChar'] = 'CASコマンドには文字 {$a->char} を含んではいけません。';
$string['stackCas_forbiddenWord'] = '{$a->forbid}は禁止されています。';
$string['stackCas_inputsdefined'] = '変数として入力名は使用できません。<code>{$a}</code>を定義しなければなりません。';
$string['stackCas_invalidCommand'] = 'CASコマンドが間違っています。';
$string['stackCas_MissingAt'] = '<code>@</code>が入力されていません。';
$string['stackCas_MissingCloseDisplay'] = '<code>\\]</code>が入力されていません。';
$string['stackCas_MissingCloseHTML'] = 'HTMLタグを閉じ忘れています。';
$string['stackCas_MissingCloseInline'] = '<code>\\)</code>が入力されていません。';
$string['stackCas_MissingClosingRawCAS'] = '<code>#}</code>が入力されていません。';
$string['stackCas_MissingClosingTeXCAS'] = '<code>@}</code>が入力されていません。';
$string['stackCas_MissingDollar'] = '<code>$</code>が入力されていません。';
$string['stackCas_missingLeftBracket'] = '左括弧がありません<span class="stacksyntaxexample">{$a->bracket}</span>: {$a->cmd}。';
$string['stackCas_MissingOpenDisplay'] = '<code>\\[</code>が入力されていません。';
$string['stackCas_MissingOpenHTML'] = 'HTMLの始まりタグを忘れています。';
$string['stackCas_MissingOpenInline'] = '<code>\\(</code>が入力されていません。';
$string['stackCas_MissingOpenRawCAS'] = '<code>{#</code>が入力されていません。';
$string['stackCas_MissingOpenTeXCAS'] = '<code>{@</code>が入力されていません。';
$string['stackCas_missingRightBracket'] = '右括弧がありません<span class="stacksyntaxexample">{$a->bracket}</span>: {$a->cmd}。';
$string['stackCas_MissingStars'] = '*を忘れているようです。 おそらく{$a->cmd}とタイプしたと思われます。';
$string['stackCas_MissingString'] = '引用符<code>"</code>を忘れています。';
$string['stackCas_newline'] = '改行文字は許可されていません。';
$string['stackCas_percent'] = '式の中に%が含まれています: {$a->expr}。';
$string['stackCas_spaces'] = '式の中に空白が含まれています: {$a->expr}。';
$string['stackCas_spuriousop'] = '不明な演算子です。{$a->cmd}';
$string['stackCas_StringOperation'] = '文字列が不適切な場所で使われています。これは<code>{$a->issue}</code>の問題です。';
$string['stackCas_trigexp'] = '{$a->forbid}という入力では，三角関数になりません。\\(\\sin(x)\\)の2乗は<tt>sin (x)^2</tt>と入力します。\\(\\sin(x)\\)の逆関数は<tt>asin(x)</tt>と入力します。<tt>sin (x)^(-1)</tt>ではありません。';
$string['stackCas_triginv'] = '三角関数の逆関数は{$a->badinv}ではなく{$a->goodinv}と入力します。';
$string['stackCas_trigop'] = '引数に対して{$a->trig}を適用する必要があります。あなたは{$a->forbid}としたようですが， 変数名として{$a->trig}としようとしたように見えます。';
$string['stackCas_trigparens'] = 'この引数に対して三角関数を適用する場合，引数を角括弧ではなく丸括弧で囲まなければなりません。例 {$a->forbid}';
$string['stackCas_trigspace'] = 'この引数に三角関数を適用する場合，スペースではなく括弧を使わなければなりません。例えば，{$a->trig}。';
$string['stackCas_underscores'] = '次の「下付き添字」は許されません：{$a}';
$string['stackCas_unencpsulated_comma'] = '式の中に不適切なカンマが使われています。カンマはリストや集合などの要素を区切るために使われます。実数にはカンマではなく小数点を使う必要があります。';
$string['stackCas_unitssynonym'] = 'あなたは単位{$a->forbid}を使っているようですが，{$a->unit}の間違いではありませんか？';
$string['stackCas_unknownFunction'] = '不明な関数です。{$a->forbid}';
$string['stackCas_unknownFunctionCase'] = '入力は大文字と小文字を区別します。{$a->forbid}は不明な関数です。{$a->lower}の間違いではないですか？';
$string['stackCas_unknownUnitsCase'] = '単位の入力は大文字と小文字が区別されます：{$a->forbid}は不明な単位です。以下のリストのうちの一つの単位 {$a->unit}の間違いではありませんか？';
$string['stackCas_unsupportedKeyword'] = 'サポートされていないキーワードです。 {$a->forbid}';
$string['stackDoc_404'] = 'エラー 404';
$string['stackDoc_404message'] = 'ファイルが見つかりません。';
$string['stackDoc_directoryStructure'] = 'ディレクトリ構成';
$string['stackDoc_docs'] = 'STACKドキュメント';
$string['stackDoc_docs_desc'] = '<a href="{$a->link}">STACKドキュメント</a>：STACK wiki';
$string['stackDoc_home'] = 'ドキュメントホーム';
$string['stackDoc_index'] = 'カテゴリインデックス';
$string['stackDoc_siteMap'] = 'サイトマップ';
$string['stackDoc_version'] = 'あなたのサイトではSTACKバージョン{$a}が動作しています。';
$string['stackHintOld'] = 'CASテキストに古いタイプのタグが使われています。現在，<pre>[[facts:tag]]</pre>の形式が使われています。';
$string['stackInstall_input_intro'] = 'このページでは学生からの入力をSTACKがどのように解釈するのかを確認することができます。<br />\'V\' はPHPとCASによって判定された妥当性を記録しています。V1はPHPの妥当性，V2はCASの妥当性です。';
$string['stackInstall_input_title'] = '学生の入力をテストするためのツール';
$string['stackInstall_input_title_desc'] = '<a href="{$a->link}">解答入力の確認スクリプト</a> は学生が解答として入力した数式をSTACKがどのように解釈するかをテストします。';
$string['stackInstall_replace_dollars_desc'] = '<a href="{$a->link}">数式タグの修正スクリプト</a> は，古いスタイルのタグ<code>@...@</code>, <code>$...$</code>, <code>$$...$$</code>を，新しいスタイルのタグ<code>{@...@}</code>, <code>\\\\(...\\\\)</code>, <code>\\\\[...\\\\]</code>に置き換えます（<code>@...@</code>から<code>{@...@}</code>はSTACK4のための変形です）。';
$string['stackInstall_testsuite_choose'] = '評価関数を選んでください。';
$string['stackInstall_testsuite_errors'] = 'この問題は以下のエラーを発生しました。';
$string['stackInstall_testsuite_fail'] = '問題が発生しました。';
$string['stackInstall_testsuite_failingtests'] = '失敗した問題';
$string['stackInstall_testsuite_failingupgrades'] = 'アップグレードに失敗した問題';
$string['stackInstall_testsuite_intro'] = 'このページは評価関数などが正しく機能するかを確認します。 Webインターフェースを通してのみチェックされることに注意してください。その他のMaximaのコマンドはunittest.macを確認してコマンドラインからチェックを行ってください。';
$string['stackInstall_testsuite_nogeneralfeedback'] = '一般フィードバックのない問題：模範解答があれば学生は喜ぶでしょう。';
$string['stackInstall_testsuite_notests'] = '問題が含まれていません。何か追加してください。';
$string['stackInstall_testsuite_pass'] = 'すべてのテストをパスしました。';
$string['stackInstall_testsuite_title'] = 'STACK評価関数の動作テスト';
$string['stackInstall_testsuite_title_desc'] = '<a href="{$a->link}">評価関数の確認スクリプト</a> は評価関数が正しく動作するかどうかを確認します。それぞれの評価関数がどのように使用されるかは，例を参考にしてください。';
$string['stackOptions_AnsTest_values_AlgEquiv'] = '代数等価';
$string['stackOptions_AnsTest_values_CasEqual'] = '構文等価';
$string['stackOptions_AnsTest_values_CompSquare'] = '平方完成';
$string['stackOptions_AnsTest_values_Diff'] = '微分';
$string['stackOptions_AnsTest_values_EqualComAss'] = '交換・結合等価';
$string['stackOptions_AnsTest_values_Equiv'] = '同値変形';
$string['stackOptions_AnsTest_values_EquivFirst'] = '完全同値変形';
$string['stackOptions_AnsTest_values_Expanded'] = '展開';
$string['stackOptions_AnsTest_values_FacForm'] = '因数分解';
$string['stackOptions_AnsTest_values_GT'] = '超過';
$string['stackOptions_AnsTest_values_GTE'] = '以上';
$string['stackOptions_AnsTest_values_Int'] = '積分';
$string['stackOptions_AnsTest_values_LowestTerms'] = '既約';
$string['stackOptions_AnsTest_values_NumAbsolute'] = '絶対精度';
$string['stackOptions_AnsTest_values_NumDecPlaces'] = '小数部桁数';
$string['stackOptions_AnsTest_values_NumDecPlacesWrong'] = '小数部桁数間違い';
$string['stackOptions_AnsTest_values_NumRelative'] = '相対精度';
$string['stackOptions_AnsTest_values_NumSigFigs'] = '有効数字';
$string['stackOptions_AnsTest_values_PartFrac'] = '部分分数';
$string['stackOptions_AnsTest_values_RegExp'] = '正規表現';
$string['stackOptions_AnsTest_values_SameType'] = '型等価';
$string['stackOptions_AnsTest_values_Sets'] = '集合';
$string['stackOptions_AnsTest_values_SigFigsStrict'] = '厳密有効数字';
$string['stackOptions_AnsTest_values_SingleFrac'] = '仮分数';
$string['stackOptions_AnsTest_values_String'] = '文字列';
$string['stackOptions_AnsTest_values_StringSloppy'] = 'あいまい文字列';
$string['stackOptions_AnsTest_values_SubstEquiv'] = '変数等価';
$string['stackOptions_AnsTest_values_SysEquiv'] = '多項式等価';
$string['stackOptions_AnsTest_values_UnitsAbsolute'] = '絶対単位';
$string['stackOptions_AnsTest_values_UnitsRelative'] = '相対単位';
$string['stackOptions_AnsTest_values_UnitsSigFigs'] = '有効単位';
$string['stackOptions_AnsTest_values_UnitsStrictAbsolute'] = '強絶対単位';
$string['stackOptions_AnsTest_values_UnitsStrictRelative'] = '強相対単位';
$string['stackOptions_AnsTest_values_UnitsStrictSigFigs'] = '強有効単位';
$string['stackQuestion_noQuestionParts'] = '解答すべき問題がありません。';
$string['stack:usediagnostictools'] = 'STACKツールを使ってください。';
$string['stackversionedited'] = 'この問題は STACK {$a} で作成されました。';
$string['stackversionmulerror'] = 'この問題には"mul"オプションを使う入力がありますが，STACK 4.2 からはサポートされていません。この問題を修正してください。';
$string['stackversionnone'] = 'STACK 4.2がリリースされて以降，この問題は編集されていないようです。注意深く問題を見直してください。';
$string['stackversionnow'] = '現在のバージョンは STACK {$a} です。';
$string['stop'] = '[終了]';
$string['strictsyntax'] = '厳密な文法';
$string['strictsyntax_help'] = 'Yesが指定されると，解答の入力は厳密なMaximaの書式である必要があります。Noが指定された場合，積の * が省かれていると，入力された文字列が関数とみなされるなど，幅広く解釈されます。';
$string['strlengtherror'] = '文字列は255文字以下です。';
$string['studentanswer'] = '評価対象';
$string['studentValidation_invalidAnswer'] = 'この解答は正しく入力されていません。';
$string['studentValidation_listofunits'] = 'あなたの解答の中で使われている単位は{$a}です。';
$string['studentValidation_listofvariables'] = 'あなたの解答の中で使われている変数は{$a}です';
$string['studentValidation_notes'] = 'この入力はSTACKで自動的には採点されません。作業の記録や教師へのコメントとして使用してください。';
$string['studentValidation_yourLastAnswer'] = 'あなたの入力した数式は次のとおりです : {$a}';
$string['Subst'] = '{$a->m0}の変数の代入を行うと，あなたの解答は正しいいでしょう。';
$string['switchtovariant'] = '任意の変形に変更します';
$string['syntaxattribute'] = 'ヒント属性';
$string['syntaxattribute_help'] = '書式のヒントが編集可能な*値*あるいは編集不可能な*ボックス*として現れます。';
$string['syntaxattributeplaceholder'] = 'ボックス';
$string['syntaxattributevalue'] = '値';
$string['syntaxhint'] = '書式のヒント';
$string['syntaxhint_help'] = '解答入力の書式の例が表示されます。';
$string['tans'] = '評価基準';
$string['tans_help'] = 'これは評価関数の第2引数で，通常，正答ですが，任意のCASテキストを指定することができます。また，それは問題変数，フィードバック変数に依存していることも可能です。';
$string['tansinvalid'] = '評価基準が正しくありません{$a}';
$string['tansrequired'] = '評価基準は空欄とすることはできません。';
$string['teacheranswer'] = '評価基準';
$string['teacheranswershow'] = '正解は \\( {$a->display} \\) で，次のように入力します: {$a->value}';
$string['teacheranswershow_disp'] = '正解は {$a->display} です。';
$string['teacheranswershownotes'] = 'この入力に対しては正答は表示されません。';
$string['teachersanswer'] = '正解';
$string['teachersanswer_help'] = '各解答欄に対する正解を指定しなければなりません。この正解は正しいMaximaの書式となっており，問題変数を用いることができます。';
$string['testcasexresult'] = 'テストケース{$a->no} {$a->result}';
$string['TEST_FAILED'] = '評価関数が正しく実行されませんでした。{$a->errors}';
$string['TEST_FAILED_Q'] = '評価関数が正しく実行されませんでした。教師に連絡してください。';
$string['testingquestion'] = '問題の確認 {$a}';
$string['testingquestionvariants'] = '問題変形のテストをしています';
$string['testinputs'] = 'テスト入力';
$string['testinputsimpwarning'] = '問題やポテンシャル・レスポンス・ツリーのオプションにかかわらず，テスト入力は<em>簡略化されていない形式</em>であることに注意してください。簡略化する場合は<tt>ev(..., simp)</tt>を使ってください。';
$string['testoptions'] = 'オプション';
$string['testoptions_help'] = 'このフィールドは評価関数にオプションを可能にします。変数や数値の精度を入力してください。';
$string['testoptionsinvalid'] = 'オプションが正しくありません。{$a}';
$string['testoptionsrequired'] = 'この評価関数にはオプションが必要です。';
$string['testpassesandfails'] = '{$a->passes} はパスし {$a->fails} はエラーが生じました。';
$string['testsuitecolerror'] = 'CASエラー';
$string['testsuitecolexpectedscore'] = '予想される採点';
$string['testsuitecolpassed'] = 'パスしますか？';
$string['testsuitecolrawmark'] = '素点';
$string['testsuitefail'] = '失敗';
$string['testsuitefeedback'] = 'フィードバック';
$string['testsuiteknownfail'] = '予想される間違い';
$string['testsuiteknownfailmaths'] = '予想される間違い（数学）';
$string['testsuitenotests'] = '評価関数の番号{$a->no}';
$string['testsuitepass'] = 'パス';
$string['testsuiteteststook'] = '評価に {$a->time} 秒かかりました。';
$string['testsuiteteststookeach'] = '平均評価時間：{$a->time} 秒';
$string['testthisvariant'] = 'この変形のテストに変更します';
$string['texdisplaystyle'] = 'ディスプレイ表示の方程式';
$string['texinlinestyle'] = 'インライン表示の方程式';
$string['tidyquestion'] = '問題の整頓';
$string['tidyquestionx'] = '問題 {$a} の一部の名前の変更';
$string['trig_degrees_radians_fact'] = '\\[ 360^\\circ= 2\\pi \\hbox{ ラジアン},\\quad 1^\\circ={2\\pi\\over 360}={\\pi\\over 180}\\hbox{ ラジアン} \\] \\[ 1 \\hbox{ ラジアン} = {180\\over \\pi} \\hbox{ 度} \\approx 57.3^\\circ \\]';
$string['trig_degrees_radians_name'] = '度とラジアン';
$string['trig_standard_identities_fact'] = '\\[\\sin(a\\pm b)\\ = \\  \\sin(a)\\cos(b)\\ \\pm\\  \\cos(a)\\sin(b)\\]
 \\[\\cos(a\\ \\pm\\ b)\\ = \\  \\cos(a)\\cos(b)\\ \\mp \\sin(a)\\sin(b)\\]
 \\[\\tan (a\\ \\pm\\ b)\\ = \\  {\\tan (a)\\ \\pm\\ \\tan (b)\\over1\\ \\mp\\ \\tan (a)\\tan (b)}\\]
 \\[ 2\\sin(a)\\cos(b)\\ = \\  \\sin(a+b)\\ +\\ \\sin(a-b)\\]
 \\[ 2\\cos(a)\\cos(b)\\ = \\  \\cos(a-b)\\ +\\ \\cos(a+b)\\]
 \\[ 2\\sin(a)\\sin(b) \\ = \\  \\cos(a-b)\\ -\\ \\cos(a+b)\\]
 \\[ \\sin^2(a)+\\cos^2(a)\\ = \\  1\\]
 \\[ 1+{\\rm cot}^2(a)\\ = \\  {\\rm cosec}^2(a),\\quad \\tan^2(a) +1 \\ = \\  \\sec^2(a)\\]
 \\[ \\cos(2a)\\ = \\  \\cos^2(a)-\\sin^2(a)\\ = \\  2\\cos^2(a)-1\\ = \\  1-2\\sin^2(a)\\]
 \\[ \\sin(2a)\\ = \\  2\\sin(a)\\cos(a)\\]
 \\[ \\sin^2(a) \\ = \\  {1-\\cos (2a)\\over 2}, \\qquad \\cos^2(a)\\ = \\  {1+\\cos(2a)\\over 2}\\]';
$string['trig_standard_identities_name'] = '標準的な三角関数の公式';
$string['trig_standard_values_fact'] = '\\[\\sin(45^\\circ)={1\\over \\sqrt{2}}, \\qquad \\cos(45^\\circ) = {1\\over \\sqrt{2}},\\qquad
\\tan( 45^\\circ)=1
\\]
\\[
\\sin (30^\\circ)={1\\over 2}, \\qquad \\cos (30^\\circ)={\\sqrt{3}\\over 2},\\qquad
\\tan (30^\\circ)={1\\over \\sqrt{3}}
\\]
\\[
\\sin (60^\\circ)={\\sqrt{3}\\over 2}, \\qquad \\cos (60^\\circ)={1\\over 2},\\qquad
\\tan (60^\\circ)={ \\sqrt{3}}
\\]';
$string['trig_standard_values_name'] = '標準的な三角関数の値';
$string['true'] = '真';
$string['truebranch'] = '真の分岐';
$string['truebranch_help'] = 'これらのフィールドは評価関数が真の場合の処理です。

###「計算」と「点数」により採点します。「=」は特定の点数を与えます。「+ / -」は現在の点から加点・減点を行います。

###アダプティブモード，インタラクティブモードでは減点は蓄積されます。

###「次のノード」で次にどのノードで評価するか，あるいは終了するかを指定します。

###「解答記録」は学生の解答履歴をレポートするためのタグで，ポテンシャル・レスポンス・ツリーのパスと評価関数の出力を記録します。';
$string['undeploy'] = 'アンデプロイ';
$string['unrecognisedfactstags'] = '次のタグは{$a->tags}と解釈されていません';
$string['Variable_function'] = 'あなたの入力した数式は変数と関数のいずれにも解釈できます：{$a->m0}。<code>*</code>を挿入して関数とみなさないか，全ての文字列を関数とするか，入力を明確にしてください。';
$string['variant'] = '変形';
$string['variantsselectionseed'] = 'ランダムグループ';
$string['variantsselectionseed_help'] = '通常，ここは空欄でかまいません。一つの小テストに含まれる二つの問題において同じ乱数シードを使いたい場合，この欄に二つの問題に対して用いる文字列を入力することにより，二つの問題の乱数シードは同期します。（デプロイされたものを使う場合は，同じ乱数シードをデプロイすること）';
$string['verifyquestionandupdate'] = '問題テキストのチェックと入力フォームの更新';
$string['youmustconfirm'] = 'ここで確認が必要です';
