<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'hvp', language 'pt_br', branch 'MOODLE_36_STABLE'
 *
 * @package   hvp
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Ação';
$string['addedandupdatedpp'] = 'Adicionadas {$a->%new} novas bibliotecas H5P e atualizadas {$a->%old} antigas.';
$string['addedandupdatedps'] = 'Adicionado {$a->%new} a novas bibliotecas H5P e atualizada {$a->%old} antiga.';
$string['addedandupdatedsp'] = 'Adicionada {$a->%new} a nova biblioteca H5P e atualizadas {$a->%old} antigas.';
$string['addedandupdatedss'] = 'Adicionada {$a->%new} nova biblioteca H5P e atualizada {$a->%old} antiga.';
$string['addednewlibraries'] = 'Adicionadas {$a->%new} novas bibliotecas H5P.';
$string['addednewlibrary'] = 'Adicionada {$a->%new} nova biblioteca H5P.';
$string['additionalinfo'] = 'Informações adicionais';
$string['additionallicenseinfo'] = 'Qualquer informação adicional sobre a licença';
$string['addlibraries'] = 'Adicionar bibliotecas';
$string['ajaxfailed'] = 'Falha ao carregar dados.';
$string['anunexpectedsave'] = 'Aconteceu algo inexperado. Não foi possível salvar este conteúdo.';
$string['attribution'] = 'Atribuição 4.0';
$string['attributionnc'] = 'Atribuição não comercial 4.0';
$string['attributionncnd'] = 'Atribuição não comercial não derivada 4.0';
$string['attributionncsa'] = 'Atribuição não comercial compartilhada 4.0';
$string['attributionnd'] = 'Atribuição não derivada 4.0';
$string['attributionsa'] = 'Atribuição compartilhada 4.0';
$string['author'] = 'Autor';
$string['authorcomments'] = 'Comentários do autor';
$string['authorcommentsdescription'] = 'Comentários para o editor de conteúdo (Este texto não será publicado como parte das informações sobre direitos autorais)';
$string['authorname'] = 'Nome do Autor';
$string['authorrole'] = 'Papel do Autor';
$string['by'] = 'por';
$string['cancellabel'] = 'Cancelar';
$string['ccattribution'] = 'Atribuição (CC BY)';
$string['ccattributionnc'] = 'Atribuição-NãoComercial (CC BY-NC)';
$string['ccattributionncnd'] = 'Atribuição-NãoComercial-SemDerivações (CC BY-NC-ND)';
$string['ccattributionncsa'] = 'Atribuição-NãoComercial-CompartilhaIgual (CC BY-NC-SA)';
$string['ccattributionnd'] = 'Atribuição-SemDerivações (CC BY-ND)';
$string['ccattributionsa'] = 'Atribuição-CompartilhaIgual (CC BY-SA)';
$string['ccpdd'] = 'Dedicação de domínio público (CC0)';
$string['ccpdm'] = 'Marca de domínio público (PDM)';
$string['changedby'] = 'Alterado por';
$string['changedescription'] = 'Descrição da alteração';
$string['changelog'] = 'Alterar Log';
$string['changeplaceholder'] = 'Foto cortada, texto alterado, etc.';
$string['close'] = 'Fechar';
$string['confirmdialogbody'] = 'Por favor, confirme que você deseja prosseguir. Esta ação não é reversível.';
$string['confirmdialogheader'] = 'Confirmar a ação';
$string['confirmlabel'] = 'Confirmar';
$string['connectionlost'] = 'Conexão perdida. Os resultados serão salvos e enviados quando for restabelecida sua conexão.';
$string['connectionreestablished'] = 'Conexão restabelecida.';
$string['contentchanged'] = 'Este conteúdo foi alterado desde que você usou pela última vez.';
$string['contentcopied'] = 'Conteúdo é copiado para a área de transferência.';
$string['contentstatefrequency'] = 'Salvar frequência do estado de conteúdo';
$string['contentstatefrequency_help'] = 'Em segundos, com que frequência você deseja que seja salvo automaticamente o progresso do usuário. Aumente este número se você está tendo problemas com muitas solicitações AJAX';
$string['contenttype'] = 'Tipo de Conteúdo';
$string['contenttypecacheheader'] = 'Cache de tipo de conteúdo';
$string['copyright'] = 'Direitos de uso';
$string['copyrightinfo'] = 'Informações sobre direitos autorais';
$string['copyrightstring'] = 'Direitos autorais';
$string['copyrighttitle'] = 'Visualizar informações de copyright para este conteúdo.';
$string['couldnotcopy'] = 'Não foi possível copiar o arquivo.';
$string['couldnotparsejsonfromzip'] = 'Não foi possível analisar o JSON do pacote: %fileName';
$string['couldnotparsepostdata'] = 'Não foi possível analisar os dados enviados.';
$string['couldnotreadfilefromzip'] = 'Não foi possível ler o arquivo do pacote: %fileName';
$string['couldnotsave'] = 'Não foi possível salvar o arquivo.';
$string['create'] = 'Criar';
$string['creativecommons'] = 'Creative Commons';
$string['ctcachebuttonlabel'] = 'Atualizar cache de tipo de conteúdo';
$string['ctcacheconnectionfailed'] = 'Não foi possível comunicar com o H5P Hub. Por favor, tente novamente mais tarde.';
$string['ctcachedescription'] = 'Certificar de que o cache do tipo de conteúdo está atualizado, garantirá que você possa visualizar, baixar e utilizar as bibliotecas mais recentes. Isso é diferente de atualizar as próprias bibliotecas.';
$string['ctcachelastupdatelabel'] = 'Última atualização';
$string['ctcacheneverupdated'] = 'Nunca';
$string['ctcachenolibraries'] = 'Nenhum tipo de conteúdo foi recebido do H5P Hub. Por favor, tente novamente mais tarde.';
$string['ctcachesuccess'] = 'O cache da biblioteca foi atualizado com sucesso!';
$string['ctcachetaskname'] = 'Atualizar cache de tipo de conteúdo';
$string['currentpage'] = 'Página $current de $total';
$string['dataviewreportlabel'] = 'Ver respostas';
$string['date'] = 'Data';
$string['disablefileextensioncheck'] = 'Desabilitar a verificação da extensão do arquivo';
$string['disablefileextensioncheckwarning'] = 'Atenção! Desativando a verificação de extensão de arquivo pode ter implicações de segurança, uma vez que permite o upload de arquivos PHP. Que por sua vez poderia torná-lo possível a execução de código malicioso em seu site. Por favor, verifique se você sabe exatamente o que você está carregando.';
$string['disablefullscreen'] = 'Desabilitar o modo tela cheia';
$string['disablehubconfirmationmsg'] = 'Você ainda quer ativar o hub?';
$string['disablehubdescription'] = 'É fortemente recomendado manter esta opção ativada. O H5P Hub fornece uma interface fácil para obter novos tipos de conteúdo e manter os tipos de conteúdo existentes atualizados. No futuro, também facilitará o compartilhamento e a reutilização do conteúdo. Se esta opção estiver desativada, você terá que instalar e atualizar tipos de conteúdo através de formulários de upload de arquivos.';
$string['displayoptionalwaysshow'] = 'Mostar sempre';
$string['displayoptionauthoroff'] = 'Controlado pelo autor, padrão é desligado';
$string['displayoptionauthoron'] = 'Controlado pelo autor, padrão é ligado';
$string['displayoptiondownloadalways'] = 'Always';
$string['displayoptiondownloadnever'] = 'Never';
$string['displayoptiondownloadpermission'] = 'Only if user has permissions to export H5P';
$string['displayoptionnevershow'] = 'Nunca mostrar';
$string['displayoptionpermissions'] = 'Mostrar apenas se o usuário tiver permissões para exportar o H5P';
$string['displayoptionpermissionsembed'] = 'Mostrar somente se o usuário tiver permissões para incorporar o H5P';
$string['displayoptions'] = 'Opções de exibição';
$string['download'] = 'Baixar';
$string['downloadfailed'] = 'O download da biblioteca solicitada falhou.';
$string['downloadtitle'] = 'Baixar este conteúdo como um arquivo H5P.';
$string['editor'] = 'Editor';
$string['emailconfirmbody'] = 'Olá {$a->username},

Obrigado por enviar suas respostas para \'{$a->hvpname}\' no curso \'{$a->coursename}\'.

Esta mensagem confirma que suas respostas foram salvas.

Você pode acessar o H5P em {$a->hvpurl}.';
$string['emailconfirmsmall'] = 'Obrigado por enviar suas respostas para \'{$a->hvpname}\\';
$string['emailconfirmsubject'] = 'Confirmação de envio: {$a->hvpname}';
$string['emailnotifybody'] = 'Olá {$a->username},

{$a->studentname} concluiu \'{$a->hvpname}\' ({$a->hvpurl}) no curso \'{$a->coursename}\'.

Você pode revisar esta tentativa em {$a->hvpreporturl}.';
$string['emailnotifysmall'] = '{$a->studentname} concluiu {$a->hvpname}. Veja {$a->hvpreporturl}';
$string['emailnotifysubject'] = '{$a->studentname} concluiu {$a->hvpname}';
$string['embed'] = 'Incorporar';
$string['embedloginfailed'] = 'Você não tem acesso a esse conteúdo. Tente fazer o login.';
$string['embedtitle'] = 'Visualizar o código de incorporação para este conteúdo.';
$string['empty'] = 'Não há resultados disponíveis';
$string['enableabout'] = 'Sobre o botão H5P';
$string['enablecopyright'] = 'Botão copyright';
$string['enabledlrscontenttypes'] = 'Habilitar tipos de conteúdo dependentes de LRS';
$string['enabledlrscontenttypes_help'] = 'Faz possível usar tipos de conteúdo que dependem de um Learning Record Store para funcionar corretamente, como o tipo de conteúdo Questionário.';
$string['enabledownload'] = 'Botão download';
$string['enableembed'] = 'Botão incorporar';
$string['enableframe'] = 'Exibir barra de ação e quadro';
$string['enablehublabel'] = 'Use H5P Hub';
$string['enablejavascript'] = 'Por favor habilite o JavaScript.';
$string['enablesavecontentstate'] = 'Salvar o estado do conteúdo';
$string['enablesavecontentstate_help'] = 'Salvar automaticamente o estado atual de conteúdo interativo para cada usuário. Isso significa que o usuário pode continuar de onde ele parou.';
$string['failedtodownloadh5p'] = 'Falha ao fazer o download do H5P solicitado.';
$string['fileexceedsmaxsize'] = 'Um dos arquivos dentro do pacote excedeu o tamanho máximo de arquivo permitido. (%file %used > %max)';
$string['filenotfoundonserver'] = 'Arquivo não encontrado no servidor. Verifique as configurações de upload de arquivos.';
$string['filenotimage'] = 'Arquivo não é uma imagem.';
$string['filetypenotallowed'] = 'Tipo de arquivo não é permitido.';
$string['finished'] = 'Terminado';
$string['fullscreen'] = 'Tela cheia';
$string['gpl'] = 'General Public License v3';
$string['h5pfile'] = 'Arquivo H5P';
$string['h5ptitle'] = 'Visite H5P.org para encontrar mais conteúdos legais.';
$string['hide'] = 'Ocultar';
$string['hideadvanced'] = 'Esconder avançado';
$string['hubcommunicationdisabled'] = 'A comunicação do hub H5P foi desativada porque um ou mais requisitos H5P falharam.';
$string['hubisdisabled'] = 'O hub está desativado. Você pode reativá-lo nas configurações do H5P.';
$string['hubisdisableduploadlibraries'] = 'O H5P Hub foi desabilitado até que este problema possa ser resolvido. Você ainda pode carregar bibliotecas através da página "Bibliotecas H5P".';
$string['hubsettingsheader'] = 'Tipos de Conteúdo';
$string['hvp:addinstance'] = 'Adicionar uma nova atividade H5P';
$string['hvp:emailconfirmsubmission'] = 'Receber uma mensagem de confirmação ao enviar';
$string['hvp:emailnotifysubmission'] = 'Receber uma mensagem de notificação quando uma tentativa é enviada';
$string['hvp:getcachedassets'] = 'Necessário para visualizar as atividades do H5P';
$string['hvp:getembedcode'] = 'Ver conteúdo H5P embutido quando a opção \'controlado por permissão\'  estiver ativa';
$string['hvp:getexport'] = 'Obter arquivo de exportação de H5P em curso';
$string['hvp:installrecommendedh5plibraries'] = 'Instalar novo conteúdo de segurança H5P recomendado por H5P.org';
$string['hvp:manage'] = 'Edite as atividades H5P existentes';
$string['hvp:restrictlibraries'] = 'Restringir uma biblioteca H5P';
$string['hvp:savecontentuserdata'] = 'Salvar dados de usuário do conteúdo H5P';
$string['hvp:saveresults'] = 'Salvar resultado para conteúdo H5P';
$string['hvp:updatelibraries'] = 'Atualizar a versão de uma biblioteca H5P';
$string['hvp:userestrictedlibraries'] = 'Usar tipos de conteúdos H5P restritos';
$string['hvp:view'] = 'Ver e interajir com as atividades do H5P';
$string['hvp:viewallresults'] = 'Ver todos os resultados das atividades H5P concluídas';
$string['hvp:viewresults'] = 'Visualisar resultado de conteúdo H5P';
$string['installdenied'] = 'Você não possui permissão para instalar tipos de conteúdo. Entre em contato com o administrador do seu site.';
$string['installedlibraries'] = 'Bibliotecas instaladas';
$string['intro'] = 'Introdução';
$string['invalidaudioformat'] = 'Formato de arquivo de áudio inválido. Utilize mp3 ou wav.';
$string['invalidcontentfolder'] = 'Diretório de conteúdo inválido';
$string['invalidcontenttype'] = 'O tipo de conteúdo escolhido é inválido.';
$string['invalidfieldtype'] = 'Tipo de campo inválido.';
$string['invalidfile'] = 'Arquivo "{$a->%filename}" não permitido. Apenas os arquivos com as seguintes extensões são permitidos: {$a->%files-allowed}.';
$string['invalidh5ppost'] = 'Não foi possível obter postagem H5P.';
$string['invalidimageformat'] = 'Formato de arquivo de imagem inválido. Utilize jpg, png ou gif.';
$string['invalidlanguagefile'] = 'Arquivo de idioma inválido {$a->%file} na biblioteca {$a->%library}';
$string['invalidlanguagefile2'] = 'Arquivo de idioma inválido {$a->%languageFile} foi incluído na biblioteca {$a->%name}';
$string['invalidlibrary'] = 'Biblioteca inválida';
$string['invalidlibrarydata'] = 'Dados inválidos para {$a->%property} de {$a->%library}';
$string['invalidlibrarydataboolean'] = 'Dados inválidos para {$a->%property} de {$a->%library}. Boolean esperado.';
$string['invalidlibraryname'] = 'Nome da biblioteca inválido: {$a->%name}';
$string['invalidlibrarynamed'] = 'A biblioteca H5P {$a->%library} utilizada no conteúdo não é válida';
$string['invalidlibraryoption'] = 'Opção ilegal {$a->%option} de {$a->%library}';
$string['invalidlibraryproperty'] = 'Não é possível ler a propriedade {$a->%property} de {$a->%library}';
$string['invalidmainjson'] = 'O principal arquivo h5p.json válido não foi encontrado';
$string['invalidmultiselectoption'] = 'Opção selecionada inválida no multi-select.';
$string['invalidparameters'] = 'Parâmetros inválidos';
$string['invalidselectoption'] = 'Opção selecionada inválida no select.';
$string['invalidsemanticsjson'] = 'Arquivo semantics.json inválido foi incluído na biblioteca {$a->%name}';
$string['invalidsemanticstype'] = 'H5P Erro interno: tipo de conteúdo desconhecido "{$a->@type}" na semântica. Remoção de conteúdo!';
$string['invalidstring'] = 'Cadeia de caracteres fornecida não está de acordo com a semântica solicitada pela expressão regular. (valor: "{$a->%value}", expressão regular: "{$a->%regexp}")';
$string['invalidtoken'] = 'Token de segurança inválido.';
$string['invalidvideoformat'] = 'Formato de arquivo de vídeo inválido. Utilize mp4 ou webm.';
$string['invalidxapiresult'] = 'Nenhum resultado xAPI foi encontrado para a combinação conteúdo e id de usuário informados';
$string['javascriptloading'] = 'Esperando por JavaScript...';
$string['libraries'] = 'Bibliotecas H5P';
$string['librarydirectoryerror'] = 'O nome do diretório de bibliotecas deve corresponder a machineName ou machineName-majorVersion.minorVersion (da library.json). (Directory: {$a->%directoryName} , machineName: {$a->%machineName}, majorVersion: {$a->%majorVersion}, minorVersion: {$a->%minorVersion})';
$string['librarylistactions'] = 'Ações';
$string['librarylistinstancedependencies'] = 'Dependências da instância';
$string['librarylistinstances'] = 'Instâncias';
$string['librarylistlibrarydependencies'] = 'Dependências da biblioteca';
$string['librarylistrestricted'] = 'Restrito';
$string['librarylisttitle'] = 'Título';
$string['librarynotselected'] = 'Você deve selecionar um tipo de conteúdo.';
$string['license'] = 'Licença';
$string['licenseCC010'] = 'CC0 1.0 Universal (CC0 1.0) Public Domain Dedication';
$string['licenseCC010U'] = 'CC0 1.0 Universal';
$string['licenseCC10'] = '1.0 Genérico';
$string['licenseCC20'] = '2.0 Genérico';
$string['licenseCC25'] = '2.5 Genérico';
$string['licenseCC30'] = '3.0 Não portado';
$string['licenseCC40'] = '4.0 Internacional';
$string['licensee'] = 'Licenciado';
$string['licenseextras'] = 'Extras da licença';
$string['licenseGPL'] = 'Licença Pública Geral';
$string['licenseV1'] = 'Versão 1';
$string['licenseV2'] = 'Versão 2';
$string['licenseV3'] = 'Versão 3';
$string['licenseversion'] = 'Versão da Licença';
$string['loadingdata'] = 'Carregando dados.';
$string['lookforupdates'] = 'Veja atualizações H5P';
$string['maximumgrade'] = 'Nota máxima';
$string['maximumgradeerror'] = 'Insira um número inteiro positivo válido como os pontos máximos disponíveis para esta atividade';
$string['maxpostsizetoosmall'] = 'Seu máximo tamanho de postagem no PHP é bem pequeno. Com sua configuração atual, você não pode fazer upload de arquivos maiores que {$a->%number} MB. Isso pode ser um problema ao tentar enviar H5Ps, imagens e vídeos. Por favor, considere aumentá-lo para mais de 5MB';
$string['maxscore'] = 'Pontuação máxima';
$string['maxuploadsizetoosmall'] = 'Seu tamanho máximo de upload do PHP é bem pequeno. Com sua configuração atual, você não pode fazer upload de arquivos maiores que {$a->%number} MB. Isso pode ser um problema ao tentar enviar H5Ps, imagens e vídeos. Por favor, considere aumentá-lo para mais de 5MB.';
$string['messageprovider:confirmation'] = 'Confirmação dos seus próprios envios de H5P';
$string['messageprovider:submission'] = 'Notificação de envio de H5P';
$string['missingcontentfolder'] = 'O diretório de conteúdo válido não foi encontrado';
$string['missingcontentuserdata'] = 'Erro: Não foi possível encontrar os dados de conteúdo do usuário';
$string['missingcoreversion'] = 'O sistema não conseguiu instalar o componente <em>{$a->%component} </em> do pacote, ele requer uma versão mais recente do plugin H5P. Este site está atualmente executando a versão {$a->%current}, enquanto a versão necessária é {$a->%required} ou superior. Você deve considerar a atualização e tente novamente.';
$string['missingdependency'] = 'Dependência {$a->@dep} não encontrada solicitado por {$a->@lib}.';
$string['missinglibrary'] = 'Faltando biblioteca necessária {$a->@library}';
$string['missinglibraryfile'] = 'O arquivo "{$a->%file}" está ausente da biblioteca: "{$a->%name}"';
$string['missinglibraryjson'] = 'Não foi possível encontrar o arquivo library.json com formato JSON válido para biblioteca {$a->%name}';
$string['missinglibraryproperty'] = 'A propriedade necessária {$a->%property} não foi encontrada em {$a->%library}';
$string['missingmbstring'] = 'A extensão mbstring PHP não está carregada. H5P precisa disso para funcionar corretamente';
$string['missingparameters'] = 'Ausência de parâmetros';
$string['missinguploadpermissions'] = 'Note-se que as bibliotecas podem existir no arquivo enviado, mas você não tem permissão para fazer upload de novas bibliotecas. Entre em contato com o administrador do site.';
$string['modulename'] = 'Conteúdo Interativo H5P';
$string['modulename_help'] = 'O módulo de atividade do H5P permite que você crie conteúdo interativo, como vídeos interativos, conjuntos de perguntas, perguntas sobre arrastar e soltar, perguntas sobre múltipla escolha, apresentações e muito mais.

Além de ser uma ferramenta de criação de conteúdo sofisticado, o H5P permite importar e exportar arquivos H5P para reutilização e compartilhamento efetivos de conteúdo.

As interações e pontuações do usuário são rastreadas usando o xAPI e estão disponíveis no Quadro de Notas do Moodle.

Você adiciona conteúdo H5P interativo criando conteúdo usando a ferramenta de criação interna ou carregando arquivos H5P encontrados em outros sites habilitados para o H5P.';
$string['modulename_link'] = 'https://h5p.org/moodle-more-help';
$string['modulenameplural'] = 'Conteúdos Interativos H5P';
$string['nextpage'] = 'Próxima página';
$string['noanswersubmitted'] = 'Este usuário ainda não submeteu nenhuma resposta ao H5P';
$string['nocontent'] = 'Não foi possível encontrar ou analisar o arquivo content.json';
$string['nocontenttype'] = 'Nenhum tipo de conteúdo foi especificado.';
$string['nocopyright'] = 'Nenhuma informação de copyright disponível para este conteúdo.';
$string['nodata'] = 'Não há dados disponíveis que corresponda aos seus critérios.';
$string['noextension'] = 'O arquivo enviado não é um pacote HTML5 válido (Ele não tem a extensão de arquivo .h5p)';
$string['noh5ps'] = 'Não há conteúdo interativo H5P disponível para este curso.';
$string['nojson'] = 'O arquivo principal h5p.json não é válido';
$string['nombstringexteension'] = 'A extenção PHP mbstring não está carregada. H5P precisa disso para funcionar corretamente';
$string['noparameters'] = 'Não há parâmetros';
$string['noparse'] = 'Não foi possível analisar o arquivo principal h5p.json';
$string['nopermissiontogettranslations'] = 'You do not have permissions to retrieve translations';
$string['nopermissiontorestrict'] = 'Você não tem permissão para restringir bibliotecas.';
$string['nopermissiontosavecontentuserdata'] = 'Você não tem permissão para salvar os dados de conteúdo do usuário.';
$string['nopermissiontosaveresult'] = 'Você não tem permissão para salvar resultados deste conteúdo.';
$string['nopermissiontoupgrade'] = 'Você não tem permissão para atualizar as bibliotecas.';
$string['nopermissiontouploadcontent'] = 'Você não tem permissão para carregar conteúdo aqui.';
$string['nopermissiontouploadfiles'] = 'Você não tem permissão para carregar arquivos aqui.';
$string['nopermissiontoviewcontenttypes'] = 'Você não tem permissão para visualizar os tipos de conteúdo.';
$string['nopermissiontoviewresult'] = 'Você não tem permissão para ver os resultados deste conteúdo.';
$string['nosuchlibrary'] = 'Não há tal biblioteca';
$string['notapplicable'] = 'N/A';
$string['nounzip'] = 'O arquivo enviado não é um pacote HTML5 válido (Nós somos incapazes de descompactá-lo)';
$string['noversionattribution'] = 'Atribuição';
$string['noversionattributionnc'] = 'Atribuição não comercial';
$string['noversionattributionncnd'] = 'Atribuição não comercial não derivada';
$string['noversionattributionncsa'] = 'Atribuição não comercial compartilhar como';
$string['noversionattributionnd'] = 'Atribuição não comercial';
$string['noversionattributionsa'] = 'Atribuição compartilhar como';
$string['nowriteaccess'] = 'Um problema com o acesso de gravação do servidor foi detectado. Por favor, certifique-se de que seu servidor possa gravar em sua pasta de dados.';
$string['noziparchive'] = 'A sua versão do PHP não suporta ZipArchive.';
$string['offlinedialogbody'] = 'Não foi possível enviar informações sobre sua conclusão dessa tarefa. Por favor, verifique sua conexão com a internet.';
$string['offlinedialogheader'] = 'Sua conexão com o servidor foi perdida';
$string['offlinedialogretrybuttonlabel'] = 'Tentar novamente';
$string['offlinedialogretrymessage'] = 'Tentando novamente em :num....';
$string['offlinesuccessfulsubmit'] = 'Resultados enviados com sucesso.';
$string['oldphpversion'] = 'Sua versão do PHP está desatualizada. O H5P requer a versão 5.2 para funcionar corretamente. Recomenda-se a versão 5.6 ou posterior.';
$string['olduploadoldcontent'] = 'Você está tentando enviar conteúdo de uma versão mais antiga do H5P. Por favor, atualize o conteúdo no servidor de origem e tente fazer o envio novamente ou habilite o H5P Hub para que esse servidor atualize para você automaticamente.';
$string['onlyupdate'] = 'Atualize apenas as bibliotecas existentes';
$string['options'] = 'Opções';
$string['originator'] = 'Criador';
$string['pd'] = 'Domínio público';
$string['pddl'] = 'Dedicação e Licença de Domínio Público';
$string['pdm'] = 'Marca de domínio público';
$string['pluginadministration'] = 'H5P';
$string['pluginname'] = 'H5P';
$string['postmessagerequired'] = 'Uma mensagem postada é necessária para acessar o endpoint fornecido';
$string['previouspage'] = 'Página anterior';
$string['privacy:metadata:core_files'] = 'A atividade H5P armazena arquivos que tenham sido enviados como parte do conteúdo H5P.';
$string['privacy:metadata:core_grades'] = 'A atividade H5P armazena notas do usuários que responderam o conteúdo H5P.';
$string['privacy:metadata:hvp_content_user_data'] = 'Descreve o estado atual de um conteúdo exibido para o usuário. Usado para restaurar estados antigos de conteúdo.';
$string['privacy:metadata:hvp_content_user_data:data'] = 'Dados armazenados do usuário.';
$string['privacy:metadata:hvp_content_user_data:data_id'] = 'Identificar de tipo de dados.';
$string['privacy:metadata:hvp_content_user_data:delete_on_content_change'] = 'Flag que determina se dados devem ser deletados quando o conteúdo é alterado.';
$string['privacy:metadata:hvp_content_user_data:hvp_id'] = 'A ID do conteúdo H5P que os dados pertencem.';
$string['privacy:metadata:hvp_content_user_data:id'] = 'A ID da relção de dados de usuário e conteúdo.';
$string['privacy:metadata:hvp_content_user_data:preloaded'] = 'Flag que determina se dados devem ser pré-carregados no conteúdo.';
$string['privacy:metadata:hvp_content_user_data:sub_content_id'] = 'Sub-conteúdo do H5P, 0 se não é sub-conteúdo.';
$string['privacy:metadata:hvp_content_user_data:user_id'] = 'A ID do usuário a quem os dados pertencem.';
$string['privacy:metadata:hvp_events'] = 'Mantém o controle de eventos registrados do H5P.';
$string['privacy:metadata:hvp_events:content_id'] = 'A ID do conteúdo em que a ação foi executada, 0 se nenhum ou novo conteúdo.';
$string['privacy:metadata:hvp_events:content_title'] = 'Título do conteúdo.';
$string['privacy:metadata:hvp_events:created_at'] = 'A hora em que o evento foi criado.';
$string['privacy:metadata:hvp_events:id'] = 'A ID única do evento.';
$string['privacy:metadata:hvp_events:library_name'] = 'A biblioteca afetada pelo evento.';
$string['privacy:metadata:hvp_events:library_version'] = 'A versão da biblioteca afeitada pelo evento.';
$string['privacy:metadata:hvp_events:sub_type'] = 'O sub-tipo de evento, ou ação do evento.';
$string['privacy:metadata:hvp_events:type'] = 'O tipo de evento.';
$string['privacy:metadata:hvp_events:user_id'] = 'A ID do usuário que executou a ação.';
$string['privacy:metadata:hvp_xapi_results'] = 'Armazena eventos xAPI em conteúdo H5P.';
$string['privacy:metadata:hvp_xapi_results:additionals'] = 'Informações adicionais que o H5P pode enviar.';
$string['privacy:metadata:hvp_xapi_results:content_id'] = 'A ID do conteúdo em que o evento foi executado.';
$string['privacy:metadata:hvp_xapi_results:correct_responses_pattern'] = 'O padrão correto de resposta.';
$string['privacy:metadata:hvp_xapi_results:description'] = 'A descrição, tarefa ou questão do conteúdo em que a ação foi executada.';
$string['privacy:metadata:hvp_xapi_results:id'] = 'A ID única do evento xAPI.';
$string['privacy:metadata:hvp_xapi_results:interaction_type'] = 'O tipo de interação.';
$string['privacy:metadata:hvp_xapi_results:max_score'] = 'Pontuação máxima adquirível para o evento.';
$string['privacy:metadata:hvp_xapi_results:parent_id'] = 'A ID do conteúdo-pai do conteúdo em que o evento foi executado. Null se não há conteúdo-pai.';
$string['privacy:metadata:hvp_xapi_results:raw_score'] = 'Pontuação atingida para o evento.';
$string['privacy:metadata:hvp_xapi_results:response'] = 'A resposta que o usuário enviou.';
$string['privacy:metadata:hvp_xapi_results:user_id'] = 'A ID do usuário que executou a ação.';
$string['question'] = 'Questão';
$string['removeoldlogentries'] = 'Remover as antigas entradas de log H5P';
$string['removeoldmobileauthentries'] = 'Remove old H5P mobile auth entries';
$string['removetmpfiles'] = 'Remover antigos arquivos temporários H5P';
$string['reportingquestionsremaininglabel'] = 'questões restantes para correção';
$string['reportingscaledscoredelimiter'] = ',';
$string['reportingscaledscorelabel'] = 'Pontuação do livro de notas:';
$string['reportingscoredelimiter'] = 'fora de';
$string['reportingscorelabel'] = 'Pontuação:';
$string['reportnotsupported'] = 'Não suportado';
$string['reportsubmitgradelabel'] = 'Submeter notas';
$string['resizescript'] = 'Incluir este script em seu site se você quiser dimensionamento dinâmico do conteúdo incorporado:';
$string['resubmitscores'] = 'Tentando enviar resultados armazenados.';
$string['reuse'] = 'Reuse';
$string['reusecontent'] = 'Reutilizar Conteúdo';
$string['reusedescription'] = 'Reutilizar este conteúdo.';
$string['reveal'] = 'Revelar';
$string['reviseserversetupandretry'] = 'Depois de revisar a configuração do servidor, você poderá reativar a comunicação do hub H5P nas configurações do H5P.';
$string['score'] = 'Pontuação';
$string['search'] = 'Pesquisa';
$string['sendusagestatistics'] = 'Contribuir com estatísticas de uso.';
$string['sendusagestatistics_help'] = 'Os números de estatísticas de uso serão automaticamente reportados para ajudar os desenvolvedores a entender melhor como o H5P é usado e determinar áreas potenciais de melhoria. Leia mais sobre quais dados <a {$a}> são coletados no h5p.org</a>.';
$string['settings'] = 'Configurações H5P';
$string['showadvanced'] = 'Mostrar avançado';
$string['showless'] = 'Mostre menos';
$string['showmore'] = 'Mostre mais';
$string['sitecouldnotberegistered'] = 'O site não pôde ser registrado no Hub. Entre em contato com o administrador do seu site.';
$string['sitekey'] = 'Chave do Site';
$string['sitekeydescription'] = 'A chave do site é um segredo que identifica exclusivamente este site com o Hub.';
$string['sitekeyregistered'] = 'Você recebeu uma chave exclusiva que o identifica com o Hub ao receber novas atualizações. A chave está disponível para visualização na página "Configurações H5P".';
$string['size'] = 'Tamanho';
$string['source'] = 'Fonte';
$string['sslnotenabled'] = 'Seu servidor não possui SSL habilitado. SSL deve ser habilitado para garantir uma conexão segura com o Hub H5P.';
$string['startingover'] = 'Você estará começando de novo.';
$string['sublevel'] = 'Subnível';
$string['successfullyregisteredwithhub'] = 'Seu site foi registrado com sucesso no H5P Hub.';
$string['thumbnail'] = 'Miniatura';
$string['title'] = 'Título';
$string['unabletocreatedir'] = 'Não é possível criar diretório.';
$string['unabletogetfieldtype'] = 'Não é possível obter tipo de campo.';
$string['undisclosed'] = 'Não revelado';
$string['unpackedfilesexceedsmaxsize'] = 'O tamanho total dos arquivos descompactados excede o tamanho máximo permitido (%used > %max)';
$string['updatedlibraries'] = 'Atualizada {$a->%old} bibliotecas H5P.';
$string['updatedlibrary'] = 'Biblioteca H5P atualizada de {$a->%old}.';
$string['updatelibraries'] = 'Atualizar todas as bibliotecas';
$string['upgrade'] = 'Atualizar H5P';
$string['upgradebuttonlabel'] = 'Atualizar';
$string['upgradedone'] = 'Você atualizou com sucesso {$a} instância (s) de conteúdo.';
$string['upgradeerror'] = 'Ocorreu um erro ao processar os parâmetros:';
$string['upgradeerrorcontent'] = 'Não foi possível atualizar o conteúdo %id:';
$string['upgradeerrordata'] = 'Não foi possível carregar dados para biblioteca %lib.';
$string['upgradeerrormissinglibrary'] = 'Missing required library %lib.';
$string['upgradeerrornotsupported'] = 'Parameters contain %used which is not supported.';
$string['upgradeerrorparamsbroken'] = 'Os parâmetros estão quebrados.';
$string['upgradeerrorscript'] = 'Não foi possível carregar script de atualizações para %lib.';
$string['upgradeerrortoohighversion'] = 'Parameters contain %used while only %supported or earlier are supported.';
$string['upgradeheading'] = 'Atualize o conteúdo {$a}';
$string['upgradeinprogress'] = 'Atualizando para %ver ...';
$string['upgradeinvalidtoken'] = 'Erro: Token de segurança inválido!';
$string['upgradelibrarycontent'] = 'Atualizar o conteúdo da biblioteca';
$string['upgradelibrarymissing'] = 'Erro: Biblioteca não encontrada!';
$string['upgrademessage'] = 'Você está prestes a atualizar {$a} instância(s) de conteúdo(s). Por favor selecione a versão de atualização.';
$string['upgradenoavailableupgrades'] = 'Não há atualizações disponíveis para esta biblioteca.';
$string['upgradenothingtodo'] = 'Não há instâncias de conteúdo para atualizar.';
$string['upgradereturn'] = 'Retorna';
$string['upload'] = 'Upload';
$string['uploadlibraries'] = 'Upload de Bibliotecas';
$string['uploadsizelargerthanpostsize'] = 'Seu tamanho máximo de upload do PHP é maior que seu tamanho máximo de postagem. Isso é conhecido por causar problemas em algumas instalações.';
$string['user'] = 'Usuário';
$string['validatingh5pfailed'] = 'A validação do pacote h5p falhou.';
$string['validationfailed'] = 'O H5P solicitado não era válido';
$string['viewreportlabel'] = 'Relatório';
$string['welcomecommunity'] = 'Esperamos que você aproveite o H5P e engaje-se em nossa crescente comunidade através de nossos fóruns <a {$a->forums}></a>.';
$string['welcomecontactus'] = 'Se você tiver algum comentário, não hesite em <a {$a}> entrar em contato conosco </a>. Nós levamos o feedback muito a sério e nos dedicamos a melhorar o H5P todos os dias!';
$string['welcomegettingstarted'] = 'Para começar a usar o H5P e o Moodle, dê uma olhada no nosso <a {$a->moodle_tutorial}> tutorial</a> e confira o <a {$a->example_content}>conteúdo do exemplo</a> no H5P. org para inspiração.';
$string['welcomeheader'] = 'Bem-vindo ao mundo da H5P!';
$string['wrongversion'] = 'A versão da biblioteca H5P {$a >%machineName} usada neste conteúdo não é válida. O conteúdo contém {$a->%contentLibrary}, mas deve ser {$a->%semanticsLibrary}.';
$string['year'] = 'Ano';
$string['years'] = 'Ano(s)';
$string['yearsfrom'] = 'Ano (de)';
$string['yearsto'] = 'Ano (até)';
