<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'hub', language 'pt_br', branch 'MOODLE_36_STABLE'
 *
 * @package   hub
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addscreenshots'] = 'Acrescentar imagem de tela';
$string['advertise'] = 'Compartilhe este curso para pessoas participarem';
$string['advertised'] = 'Inscrição disponível';
$string['advertiseon'] = 'Compartilhe este curso em {$a}';
$string['advertiseonhub'] = 'Compartilhe este curso para pessoas participarem';
$string['advertiseonmoodleorg'] = 'Anuncie esse curso em moodle.org';
$string['advertisepublication_help'] = 'Este curso será listado no Moodle.net como um curso que as pessoas podem se inscrever e participar. A autoinscrição por email deve estar habilitada no site e você precisa habilitar a autoinscrição neste curso.';
$string['all'] = 'Todos';
$string['allowglobalsearch'] = 'Publicar este hub e permitir uma pesquisa global de todos os cursos';
$string['allowpublicsearch'] = 'Publicar este hub para que as pessoas podem associar-se';
$string['audience'] = 'Público-alvo';
$string['audienceadmins'] = 'Administradores Moodle';
$string['audienceeducators'] = 'Educadores';
$string['audience_help'] = 'Selecionar a público-alvo do curso.';
$string['audiencestudents'] = 'Estudantes';
$string['badgesnumber'] = 'Número de emblemas ({$a})';
$string['badurlformat'] = 'Formato da URL incorreto';
$string['cannotsearchcommunity'] = 'Desculpe, você não tem as permissões corretas para ver esta página';
$string['community'] = 'Comunidade';
$string['communityremoved'] = 'O link para este curso foi removido de sua lista';
$string['completeregistration'] = 'Complete o registro em Moodle.net';
$string['confirmregistration'] = 'Confirme o registro';
$string['contactable'] = 'Contato ao público';
$string['contactable_help'] = 'Definindo como "sim" o hub vai mostrar o seu endereço de e-mail.';
$string['contactemail'] = 'E-mail para contato';
$string['contactname'] = 'Nome para contato';
$string['contactphone'] = 'Telefone';
$string['contactphone_help'] = 'Números de telefone são mostrados apenas para o administrador do Hub e não são mostrados publicamente.';
$string['continue'] = 'Continue';
$string['contributornames'] = 'Outros colaboradores';
$string['contributornames_help'] = 'Você pode usar este campo para listar os nomes de qualquer outra pessoa que contribuiu para este curso.';
$string['coursemap'] = 'Mapa do curso';
$string['coursename'] = 'Nome';
$string['courseprivate'] = 'Privado';
$string['coursepublic'] = 'Público';
$string['coursepublished'] = 'Este curso foi compartilhado com sucesso em \'{$a}\'.';
$string['courseshortname'] = 'Nome breve';
$string['courseshortname_help'] = 'Insira um nome curto para seu curso. Ele não precisa ser único.';
$string['coursesnumber'] = 'Número de cursos ({$a})';
$string['courseunpublished'] = 'O curso {$a->courseshortname} não está mais publicado em {$a->hubname}.';
$string['courseurl'] = 'URL do curso';
$string['courseurl_help'] = 'Este é o URL do seu curso. Este URL é mostrado como um link nos resultados de busca.';
$string['creatorname'] = 'Criador';
$string['creatorname_help'] = 'O criador é o criador de cursos.';
$string['creatornotes'] = 'Anotações sobre o criador';
$string['creatornotes_help'] = 'Notas do criador são um guia para professores sobre como usar o curso.';
$string['deletescreenshots'] = 'Excluir estes screenshots';
$string['deletescreenshots_help'] = 'Excluir todas as imagens atualmente subidas.';
$string['demourl'] = 'URL demonstração';
$string['demourl_help'] = 'Entre com a URL do demo do seu curso. Por padrão esta é a URL do seu curso. A URL do demo é mostrado como um link no resultado de busca.';
$string['description'] = 'Descrição';
$string['description_help'] = 'Este texto descritivo será mostrado na lista de cursos no Moodle.net.';
$string['detectednotexistingpublication'] = '{$a->hubname} está listando um curso que não existe mais. Informe ao administrador de {$a->hubname}  que a publicação {$a->id} deve ser removida.';
$string['downloadable'] = 'Downloadable';
$string['educationallevel'] = 'Nível de escolaridade';
$string['educationallevel_help'] = 'Selecione o nível educacional mais adequado para o curso.';
$string['edulevelassociation'] = 'Associação';
$string['edulevelcorporate'] = 'Corporativo';
$string['edulevelgovernment'] = 'Governo';
$string['edulevelother'] = 'Outros';
$string['edulevelprimary'] = 'Primário';
$string['edulevelsecondary'] = 'Secundário';
$string['eduleveltertiary'] = 'Terciário';
$string['emailalert'] = 'Avisdos de e-mail';
$string['emailalert_help'] = 'Se esta opção for ativada, o administrador do hub irá lhe enviar e-mails com notas sobre segurança e outras notícias importantes.';
$string['enrollable'] = 'Aceita inscrições';
$string['errorbadimageheightwidth'] = 'A imagem deve ter um tamanho máximo de {$a->width} X {$a->height}';
$string['errorcourseinfo'] = 'Ocorreu um erro ao recuperar os metadados do curso a partir de {$a}. Por favor, tente  recuperar novamente os metadados do curso recarregando esta página mais tarde. Caso contrário, você pode decidir continuar o processo de registro com os seguintes metadados padrão.';
$string['errorcoursepublish'] = 'Ocorreu um erro durante a publicação do curso ({$a}). Por favor, tente novamente mais tarde.';
$string['errorcoursewronglypublished'] = 'Um erro de publicação foi retornado pelo Moodle.net. Por favor, tente novamente mais tarde.';
$string['errorcron'] = 'Ocorreu um erro durante a atualização do registro no "{$a->hubname}" ({$a->errormessage})';
$string['errorcronnoxmlrpc'] = 'XML-RPC deve ser ativado para atualizar o registro.';
$string['errorhublisting'] = 'Um erro ocorreu no recebimento da lista de hubs do Moodle.org. Por favor, tente novamente mais tarde ({$a})';
$string['errorlangnotrecognized'] = 'Esta linguagem não é reconhecida pelo Moodle. Por favor, entre em contato com {$a}';
$string['errorotherhubsnotsupported'] = 'Esta página não pode mais ser usada para registro em diretórios de sites personalizados.';
$string['errorregistration'] = 'Um errou ocorrou durante o registro. Por favor, tente novamente. ({$a})';
$string['errorregistrationupdate'] = 'Ocorreu um erro durante a atualização do registro ({$a})';
$string['errorunpublishcourses'] = 'Devido um erro inesperado, os cursos não podem ser excluídos do Moodle.net. Tente novamente mais tarde (recomendado) ou entre em contato com o administrador do Moodle.net.';
$string['errorws'] = '{$a}';
$string['errorwstokenreset'] = '{$a}. O token de registro neste site foi redefinido. Agora você pode registrar seu site novamente.';
$string['existingscreenshotnumber'] = '{$a} screenshots existentes. Você será capaz de ver essas imagens nesta página, somente se o administrador do Moodle.net habilitar seu curso.';
$string['existingscreenshots'] = 'Screenshots existentes';
$string['forceunregister'] = 'Sim, limpe os dados de registro';
$string['forceunregisterconfirmation'] = 'Seu site não consegue localizar {$a}. Este hub pode estar temporariamente fora do ar. A menos que você tenha certeza que quer continuar a remover registro localmente, cancele esta operação e tente novamente mais tarde.';
$string['geolocation'] = 'Geolocalização';
$string['geolocation_help'] = 'No futuro poderemos fornecer pesquisa baseado na localização. Se você quiser especificar a localização do seu curso use um valor latitude/longitude aqui (Exemplo: -31.947884,115.871285). Uma forma de descobrir isto é utilizar o Google Maps.';
$string['hub'] = 'Hub';
$string['imageurl'] = 'Link da imagem';
$string['imageurl_help'] = 'Esta imagem será exibida no hub. Esta imagem deve estar disponível a partir do hub em qualquer momento. A imagem deve ter um tamanho máximo de {$a->width} X {$a->height}';
$string['information'] = 'Informação';
$string['issuedbadgesnumber'] = 'Número de emblemas emitidos ({$a})';
$string['language'] = 'Idioma';
$string['language_help'] = 'O idioma principal do curso.';
$string['lasttimechecked'] = 'Última verificação';
$string['licence'] = 'Licença';
$string['licence_help'] = 'Selecione a licença com a qual você deseja distribuir o seu curso.';
$string['licence_link'] = 'licenças';
$string['logourl'] = 'Link do logo';
$string['mobilenotificationsenabled'] = 'Notificações móveis habilitados ({$a})';
$string['mobileservicesenabled'] = 'Serviços móveis habilitados ({$a})';
$string['modulenumberaverage'] = 'Número médio de módulos do curso ({$a})';
$string['moodleorg'] = 'Moodle';
$string['mustselectsubject'] = 'Você deve selecionar um assunto';
$string['name'] = 'Nome';
$string['name_help'] = 'Esse nome será exibido na listagem do curso.';
$string['neverchecked'] = 'Nunca verificada';
$string['next'] = 'Próximo';
$string['no'] = 'Não';
$string['nocheckstatusfromunreghub'] = 'O site não está registrado no hub, o status não pode ser verificado.';
$string['nohubselected'] = 'Nenhum hub selecionado';
$string['none'] = 'Nenhum';
$string['nosearch'] = 'Não publique hub ou cursos';
$string['notregisteredonhub'] = 'O administrador do sistema precisa registrar este site no Moodle.net para que você possa publicar um curso.';
$string['notregisteredonmoodleorg'] = 'O administrador precisa registrar este site no moodle.org.';
$string['operation'] = 'Ações';
$string['orenterprivatehub'] = 'Alternativamente, insira a URL de um hub privado:';
$string['participantnumberaverage'] = 'Número médio de participantes ({$a})';
$string['policyagreed'] = 'Aviso de privacidade e contrato de processamento de dados';
$string['policyagreeddesc'] = 'Concordo com o <a href="{$a}" target="_blank">Aviso de privacidade e contrato de processamento de dados</a>';
$string['postaladdress'] = 'Endereço postal';
$string['postaladdress_help'] = 'Endereço postal deste site, ou da entidade representada por este site.';
$string['postsnumber'] = 'Número de posts ({$a})';
$string['previousregistrationdeleted'] = 'O registro anterior foi removido do {$a}. You pode recomeçar o processo de registro. Obrigado.';
$string['prioritise'] = 'Priorizar';
$string['privacy'] = 'Privacidade';
$string['privacy_help'] = 'O hub pode querer exibir uma lista de sites cadastrados. Você pode escolher se deseja ou não aparecer na lista, caso isso aconteça.';
$string['private'] = 'Privado';
$string['privatehuburl'] = 'URL do hub privado';
$string['publicationinfo'] = 'Informações sobre publicação de curso';
$string['publichub'] = 'Hub public';
$string['publish'] = 'Publicar';
$string['publishcourse'] = 'Publicar {$a}';
$string['publishcourseon'] = 'Publicar em {$a}';
$string['publishedon'] = 'Publicações';
$string['publisheremail'] = 'Email do editor';
$string['publisheremail_help'] = 'O endereço de e-mail do editor permite que o administrador do hub possa alertar o editor sobre todas as alterações no status do curso publicado.';
$string['publishername'] = 'Editor';
$string['publishername_help'] = 'O editor é a pessoa ou organização que é editora oficial do curso. A menos que você esteja publicando o curso em nome de outra pessoa, usualmente o editor é você mesmo.';
$string['publishon'] = 'Publicar em';
$string['publishonspecifichub'] = 'Publicar em outro Hub';
$string['questionsnumber'] = 'Número de perguntas ({$a})';
$string['readvertiseon'] = 'Atualize as informações do anúncio no {$a}';
$string['registeredactiveuserdevices'] = 'Número de usuários ativos com dispositivos móveis registrados que estão recebendo notificações ({$a})';
$string['registeredcourses'] = 'Cursos registrados';
$string['registeredmoodleorg'] = 'Moodle ({$a})';
$string['registeredon'] = 'Onde o site está registrado';
$string['registeredsites'] = 'Sites registrados';
$string['registereduserdevices'] = 'Número de usuários com dispositivos móveis registrados ({$a})';
$string['registermoochtips'] = 'Cadastre seu site com o Moodle para obter alertas de segurança e acesso a Moodle.net, a nossa plataforma de compartilhamento de curso.';
$string['registersite'] = 'Registrar com {$a}';
$string['registerwith'] = 'Registrar em um hub';
$string['registerwithmoodleorg'] = 'Registre seu site em Moodle.org';
$string['registerwithmoodleorgcomplete'] = 'Conclua o registro do seu site';
$string['registerwithmoodleorginfo'] = 'Gostaríamos muito de manter contato e fornecer a você coisas importantes para o seu site Moodle! Ao registrar-se:

* Você pode se inscrever para receber notificações de novos lançamentos do Moodle, alertas de segurança e outras notícias importantes.
* Você pode acessar e ativar notificações móveis via push no seu site Moodle através do nosso aplicativo Moodle.
* Você está contribuindo para as estatísticas do Moodle da comunidade no mundo todo, que nos ajudam a melhorar o Moodle e os sites da comunidade.
* Se desejar, seu site pode ser incluído na lista de sites Moodle registrados do seu país.';
$string['registerwithmoodleorginfoapp'] = 'Sobre o app Moodle';
$string['registerwithmoodleorginfosites'] = 'Outros sites no meu país';
$string['registerwithmoodleorginfostats'] = 'Estatísticas do Moodle';
$string['registerwithmoodleorgupdate'] = 'Atualize o registro do seu site';
$string['registrationconfirmed'] = 'Registro do site confirmado';
$string['registrationconfirmedon'] = 'Obrigado por registrar seu site. As informações de registro serão atualizadas pela tarefa agendada "Registro do site".';
$string['registrationinfo'] = 'Informações de registro';
$string['registrationupdated'] = 'O registro foi atualizado.';
$string['registrationupdatedfailed'] = 'A atualização de registro falhou.';
$string['removefromhub'] = 'Remover do Moodle.net';
$string['renewregistration'] = 'Renovar o registro';
$string['resourcesnumber'] = 'Número de recursos ({$a})';
$string['restartregistration'] = 'Recomeçar o registro';
$string['roleassignmentsnumber'] = 'Número de papéis atribuídos ({$a})';
$string['screenshots'] = 'Screenshots';
$string['screenshots_help'] = 'Quaisquer screenshots do curso serão exibidos nos resultados de busca.';
$string['search'] = 'Buscar';
$string['selecthub'] = 'Seleciona hub';
$string['selecthubforadvertise'] = 'Selecione hub para publicidade';
$string['selecthubforsharing'] = 'Selecione hub para upload';
$string['selecthubinfo'] = 'Um hub comunidade é um servidor que lista os cursos. Você só pode publicar seus cursos em hubs que este site Moodle está registrado. Se o hub que você deseja não estiver listado abaixo, entre em contato com o administrador do site.';
$string['sendfollowinginfo'] = 'Mais informações';
$string['sendfollowinginfo_help'] = 'A informação seguinte será enviada apenas para contribuir com as estatísticas globais. Ela não será divulgada em nenhuma lista do site.';
$string['sendingcourse'] = 'Enviando curso';
$string['sendingsize'] = 'Por favor, aguarde o envio do arquivo do curso ({$a->total}Mb)...';
$string['sent'] = '...terminado';
$string['settings'] = 'Configurações';
$string['settingsupdated'] = 'As configurações foram atualizadas.';
$string['share'] = 'Permitir o download deste curso';
$string['shared'] = 'Para as pessoas baixarem';
$string['shareon'] = 'Enviar este curso para  {$a}';
$string['shareonhub'] = 'Enviar este curso para o hub';
$string['sharepublication_help'] = 'Um backup deste curso estará disponível no Moodle.net para que as pessoas possam restaurar e utilizar em seu próprio site.';
$string['siteadmin'] = 'Administrador';
$string['siteadmin_help'] = 'O nome completo do administrador do site.';
$string['sitecommnews'] = 'Boletim informativo Moodle';
$string['sitecommnews_help'] = 'Você tem a opção de assinar o boletim informativo do Moodle. Você pode cancelar sua assinatura a qualquer momento.';
$string['sitecommnewsno'] = 'Não, eu não quero receber nenhum e-mail';
$string['sitecommnewsyes'] = 'Sim, eu gostaria de receber o periódico de informações do Moodle';
$string['sitecountry'] = 'País';
$string['sitecountry_help'] = 'O pais em que sua organização ou institutição está localizada.';
$string['sitecreated'] = 'Site criado';
$string['sitedesc'] = 'Descrição';
$string['sitedesc_help'] = 'Forneça algumas informações sobre como você está utilizando o Moodle.';
$string['siteemail'] = 'Endereço de email do administrador';
$string['siteemail_help'] = 'Um endereço de e-mail é necessário para que o Moodle HQ possa entrar em contato com você, se necessário. Este email não será utilizado para nenhum outro propósito. É recomendado fornecer um endereço de e-mail genérico, relacionado a uma função/cargo (por exemplo: gerentedosite@exemplo.com) e não um pessoal.';
$string['sitegeolocation'] = 'Localização geográfica';
$string['sitegeolocation_help'] = 'No futuro nós providenciaremos nos hubs buscas baseadas na localização geográfica. Se você deseja especificar a localização do seu site, use valores de latitude e longitude (ex. -31.947884,115.871285). Uma forma de encontrar essa localização é usar o Google Maps.';
$string['sitelang'] = 'Idioma';
$string['sitelang_help'] = 'Qual é o idioma principal usado no seu site Moodle?';
$string['sitename'] = 'Nome';
$string['sitename_help'] = 'O nome do site será mostrado na listagem de sites se o hub permitir isso.';
$string['sitephone'] = 'Telefone';
$string['sitephone_help'] = 'Seu número de telefone será visível apenas para o administrador do hub.';
$string['siteprivacy'] = 'Lista de site';
$string['siteprivacy_help'] = 'Você pode optar por ter seu site listado publicamente na lista de sites registrados, com ou sem um link para seu site.';
$string['siteprivacylinked'] = 'Mostrar o nome do meu site com link';
$string['siteprivacynotpublished'] = 'Não publicar meu site';
$string['siteprivacypublished'] = 'Publicar somente o nome do site';
$string['siteregconfcomment'] = 'Seu site precisa de uma confirmação final sobre {$a} (para evitar spam em {$a})';
$string['siteregistrationcontact'] = 'Mostrar formulário de contato';
$string['siteregistrationcontact_help'] = 'Se você permitir isso, outras pessoas cadastradas em nossa comunidade Moodle podem contatá-lo através de um formulário no site da comunidade. No entanto, eles nunca poderão ver seu endereço de e-mail.';
$string['siteregistrationemail'] = 'Notificações de novos lançamentos do Moodle, alertas de segurança e outras notícias importantes';
$string['siteregistrationemail_help'] = 'Você tem a opção de assinar nossa lista de emails para receber notificações de novos lançamentos do Moodle, alertas de segurança e outras notícias importantes. Você pode cancelar sua assinatura a qualquer momento.';
$string['siteregistrationupdated'] = 'Registro do site atualizado';
$string['siterelease'] = 'Versão do Moodle';
$string['siterelease_help'] = 'Número da versão do Moodle desse site.';
$string['sitereleasenum'] = 'Moodle versão ({$a})';
$string['siteupdatedcron'] = 'Registro do site atualizado em "{$a}"';
$string['siteupdatesend'] = 'Concluída a atualização do registro nos hubs.';
$string['siteupdatesstart'] = 'Iniciando a atualização do registro nos hubs...';
$string['siteurl'] = 'URL do site';
$string['siteurl_help'] = 'O URL é o endereço desse site. Se as preferências de privacidade permitirem que as pessoas vejam o endereço do site, então este URL será mostrado.';
$string['siteversion'] = 'Versão do Moodle';
$string['siteversion_help'] = 'A versão do Moodle deste site.';
$string['skipregistration'] = 'Saltar';
$string['specifichubregistrationdetail'] = 'Você também pode registrar o seu site em outros hubs da comunidade.';
$string['statistics'] = 'Estatístísticas de privacidade';
$string['status'] = 'Status da listagem';
$string['statuspublished'] = 'Listado';
$string['statusunpublished'] = 'Não listado';
$string['subject'] = 'Assunto';
$string['subject_help'] = 'Selecione o tema principal abordado pelo curso.';
$string['tags'] = 'Tags';
$string['tags_help'] = 'Tags ajudam a classificar melhor o seu curso e também a encontrá-lo nas buscas. Por favor use palavras simples e significativas, e separe-as com uma vírgula. Exemplo: matemática, álgebra, geometria.';
$string['trustme'] = 'Confie';
$string['type'] = 'Publicado/compartilhado';
$string['unknownstatus'] = 'Desconhecido';
$string['unlistedurl'] = 'Não listar a URL do hub';
$string['unprioritise'] = 'Adiar';
$string['unpublish'] = 'Pausar a publicação';
$string['unpublishalladvertisedcourses'] = 'Remova todos os cursos que estão publicados no Moodle.net com inscrição disponível';
$string['unpublishalluploadedcourses'] = 'Excluir todos os cursos que foram publicados no Moodle.net para as pessoas baixarem';
$string['unpublishconfirmation'] = 'Você realmente deseja remover o curso "{$a->courseshortname}" de "{$a->hubname}"';
$string['unpublishcourse'] = 'Pausar a publicação {$a}';
$string['unregister'] = 'Cancelar o registro';
$string['unregisterconfirmation'] = 'Você está prestes a cancelar este site a partir do {$a} hub. Uma vez que você desligá-lo, você não será capaz de gerenciar todos os cursos que você deixou lá. Tem certeza que deseja cancelar o registro?';
$string['unregisterexplained'] = 'Se o site com URL {$a} estiver registrado, seu registro será excluído.';
$string['unregisterfrom'] = 'Remover o registro com {$a}';
$string['unregistrationerror'] = 'Ocorreu um erro quando o site tentou excluir o registro do Moodle.net: {$a}';
$string['untrustme'] = 'Não confiável';
$string['update'] = 'Atualizar';
$string['updatesite'] = 'Atualizar o registro no {$a}';
$string['updatesiteregistration'] = 'Atualizar registro';
$string['updatestatus'] = 'Verificar agora.';
$string['uploaded'] = 'Enviado';
$string['url'] = 'URL do hub';
$string['urlalreadyregistered'] = 'Seu site parece estar registrado no Moodle.net, o que significa que algo deu errado. Entre em contato com o administrador do Moodle.net para redefinir seu registro para que você pode tentar novamente.';
$string['usedifferentemail'] = 'Utilize um e-mail diferente';
$string['usersnumber'] = 'Número de usuários ({$a})';
$string['warning'] = 'CUIDADO';
$string['wrongtoken'] = 'O registro falhou por uma razão desconhecida (rede?). Por favor, tente novamente.';
$string['wrongurlformat'] = 'Formato errado do URL';
$string['xmlrpcdisabledcommunity'] = 'A extensão XML-PRC não está habilitada no servidor. Você não pode buscar e baixar cursos.';
$string['xmlrpcdisabledpublish'] = 'A extensão XML-RPC não está habilitada no servidor, portanto não é possível publicar cursos ou gerenciar cursos publicados.';
$string['xmlrpcdisabledregistration'] = 'A extensão XML-RPC não está habilitada no servidor. Você não poderá desregistrar ou atualizar seu registro até que você habilite a extensão.';
