<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_essential', language 'fr', branch 'MOODLE_36_STABLE'
 *
 * @package   theme_essential
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['above'] = 'Au-dessus';
$string['advert_alttext'] = 'Bandeau publicitaire de 1er niveau';
$string['advert_heading'] = 'Conception de thème Niveau 1';
$string['advert_tagline'] = 'Vous voulez savoir comment personnaliser des thèmes, mais vous n\'avez pas de formation en développement, une expérience avec PHP et une expérience avec Moodle Themes, alors \'MoodleBites Theme Design Level 1\' est fait pour vous ! Il vous proposera une introduction en douceur au développement du thème Moodle et vous fournira de bonnes bases si vous souhaitez progresser davantage. Cliquez ici pour plus d\'informations.';
$string['aftercontent'] = 'Après le contenu';
$string['alert1'] = 'Première alerte';
$string['alert2'] = 'Deuxième alerte';
$string['alert3'] = 'Troisième alerte';
$string['alert_edit'] = 'Modifier les alertes';
$string['alert_general'] = 'Annonce';
$string['alert_info'] = 'Information';
$string['alertinfodesc'] = 'Entrez les paramètres de votre alerte.';
$string['alertsdesc'] = 'Ceci va afficher une (ou plusieurs) alerte(s) dans trois différents styles à vos utilisateurs sur la page d\'accueil de Moodle. Pensez s\'il vous plaît à les désactiver lorsqu\'elles ne seront plus nécessaires.';
$string['alertsheading'] = 'Alertes utilisateur';
$string['alertsheadingsub'] = 'Affiche des messages importants à vos utilisateurs sur la page d\'accueil';
$string['alerttext'] = 'Texte de l\'alerte';
$string['alerttextdesc'] = 'Le texte que vous souhaitez afficher dans votre alerte';
$string['alerttitle'] = 'Titre';
$string['alerttitledesc'] = 'Titre/en-tête principal pour votre alerte';
$string['alerttype'] = 'Niveau';
$string['alerttypedesc'] = 'Définissez le juste niveau d\'alerte pour informer au mieux vos utilisateurs';
$string['alert_warning'] = 'Attention';
$string['allclasses'] = 'Toutes les classes';
$string['allcourses'] = 'Tous les cours';
$string['allmodules'] = 'Tous les modules';
$string['allunits'] = 'Toutes les unités';
$string['alternativecolors'] = 'Couleurs alternatives {$a}';
$string['alternativethemecolor'] = 'Couleur alternative de thème {$a}';
$string['alternativethemecolordesc'] = 'Quelle devraient-être les couleurs alternatives du thème {$a} ? Si activées et choisies par l\'utilisateur, elles remplaceront les couleurs par défaut du thème.';
$string['alternativethemecolorname'] = 'Nom du jeu alternatif de couleurs {$a}';
$string['alternativethemecolornamedesc'] = 'Fournissez un nom reconnaissable pour ce jeu alternatif de couleurs de thème';
$string['alternativethemecolors'] = 'Couleurs alternatives du thème';
$string['alternativethemecolorsdesc'] = 'Définit les couleurs alternatives du thème que l\'utilisateur peut choisir.';
$string['alternativethemedefaultbuttonbackgroundcolour'] = 'Couleur par défaut du fond des boutons {$a}';
$string['alternativethemedefaultbuttonbackgroundcolourdesc'] = 'Définissez la couleur par défaut du fond des boutons {$a}';
$string['alternativethemedefaultbuttonbackgroundhovercolour'] = 'Couleur de survol par défaut pour les fond des boutons {$a}';
$string['alternativethemedefaultbuttonbackgroundhovercolourdesc'] = 'Définissez la couleur de survol par défaut pour les fond des boutons {$a}';
$string['alternativethemedefaultbuttontextcolour'] = 'Couleur par défaut du texte des boutons {$a}';
$string['alternativethemedefaultbuttontextcolourdesc'] = 'Définissez la couleur par défaut du texte des boutons {$a}';
$string['alternativethemedefaultbuttontexthovercolour'] = 'Couleur de survol par défaut pour le texte des boutons {$a}';
$string['alternativethemedefaultbuttontexthovercolourdesc'] = 'Définissez la couleur de survol par défaut pour le texte des boutons {$a}';
$string['alternativethemefooterblockbackgroundcolour'] = 'Couleur de fond alternative du bloc Pied de page {$a}';
$string['alternativethemefooterblockbackgroundcolourdesc'] = 'Définissez la couleur de fond alternative du bloc Pied de page {$a}';
$string['alternativethemefooterblockhovercolour'] = 'Couleur de survol alternative des liens du bloc Pied de page {$a}';
$string['alternativethemefooterblockhovercolourdesc'] = 'Définissez la couleur de survol alternative des liens textes du bloc Pied de page {$a}';
$string['alternativethemefooterblocktextcolour'] = 'Couleur alternative du texte du bloc Pied de page {$a}';
$string['alternativethemefooterblocktextcolourdesc'] = 'Définissez la couleur alternative souhaitée pour le texte du bloc Pied de page {$a}';
$string['alternativethemefooterblockurlcolour'] = 'Couleur alternative des liens du bloc Pied de page {$a}';
$string['alternativethemefooterblockurlcolourdesc'] = 'Définissez la couleur alternative des liens du bloc Pied de page {$a}';
$string['alternativethemefootercolor'] = 'Couleur de fond alternative du bloc Pied de page {$a}';
$string['alternativethemefootercolordesc'] = 'Définissez quelle devrait être la couleur de fond alternative du bloc Pied de page {$a}';
$string['alternativethemefooterheadingcolor'] = 'Couleur alternative du titre du pied de page {$a}';
$string['alternativethemefooterheadingcolordesc'] = 'Définissez la couleur alternative des titres dans le pied de page {$a}';
$string['alternativethemefooterhovercolor'] = 'Couleur de survol alternative des liens du pied de page {$a}';
$string['alternativethemefooterhovercolordesc'] = 'Définissez la couleur de survol alternative des liens du pied de page {$a}';
$string['alternativethemefootersepcolor'] = 'Couleur alternative de séparation {$a}';
$string['alternativethemefootersepcolordesc'] = 'Les séparateurs sont des lignes utilisées pour séparer le contenu. Définissez ici leur couleur alternative {$a}';
$string['alternativethemefootertextcolor'] = 'Couleur alternative du texte du pied de page {$a}';
$string['alternativethemefootertextcolordesc'] = 'Définissez la couleur alternative souhaitée pour le texte du pied de page {$a}';
$string['alternativethemefooterurlcolor'] = 'Couleur alternative pour les liens du pied de page {$a}';
$string['alternativethemefooterurlcolordesc'] = 'Définissez la couleur alternative pour les liens du pied de page {$a}';
$string['alternativethemehovercolor'] = 'Couleur de survol alternative du thème {$a}';
$string['alternativethemehovercolordesc'] = 'Quelle devrait-être la couleur de survol alternative du thème {$a} ? Si activée et choisie par l\'utilisateur, elle remplacera la couleur de survol par défaut du thème.';
$string['alternativethemeiconcolor'] = 'Couleur alternative des icônes {$a}';
$string['alternativethemeiconcolordesc'] = 'Définissez la couleur alternative des icônes {$a}';
$string['alternativethememycoursesorderenrolbackcolour'] = 'Couleur de fond des cours inscrits et non accessibles en couleurs alternatives {$a}';
$string['alternativethememycoursesorderenrolbackcolourdesc'] = 'Définit la couleur de fond pour les cours inscrits mais non accessibles dans l\'alternative {$a}. Pour "Tri des cours" réglé sur "Dernier accédé…".';
$string['alternativethemename'] = 'Nom du jeu de couleurs';
$string['alternativethemenamedesc'] = 'Donnez un nom à votre jeu alternatif de couleurs';
$string['alternativethemenavcolor'] = 'Couleur alternative du texte de navigation {$a}';
$string['alternativethemenavcolordesc'] = 'Définissez la couleur alternative du texte de navigation {$a}. Soit la barre de navigation et le fil d\'Ariane en style Fantaisie';
$string['alternativethemequizsubmitbackgroundcolour'] = 'Quiz : Couleur de fond {$a} du bouton \'Soumettre tout et terminer\\';
$string['alternativethemequizsubmitbackgroundcolourdesc'] = 'Définissez la couleur alternative d\'arrière-plan {$a} pour le bouton \'Soumettre tout et terminer\'.';
$string['alternativethemequizsubmitbackgroundhovercolour'] = 'Quiz Couleur de survol {$a} de l\'arrière-plan du bouton \'Soumettre tout et terminer\'';
$string['alternativethemequizsubmitbackgroundhovercolourdesc'] = 'Définir la couleur de survol {$a} de l\'arrière plan du bouton \'Soumettre tout et terminer\'.';
$string['alternativethemequizsubmittextcolour'] = 'Quiz Couleur du texte {$a} du bouton \'Soumettre tout et terminer\'.';
$string['alternativethemequizsubmittextcolourdesc'] = 'Définir la couleur alternative {$a} du texte du bouton \'Soumettre tout et terminer\'.';
$string['alternativethemequizsubmittexthovercolour'] = 'Quiz : Couleur de survol {$a} du texte du bouton \'Soumettre tout et terminer\\';
$string['alternativethemequizsubmittexthovercolourdesc'] = 'Définissez la couleur alternative {$a} de survol du texte du bouton \'Soumettre tout et terminer\'.';
$string['alternativethemesidepreblockbackgroundcolour'] = 'Couleur de fond alternative {$a} pour le bloc \'side-pre\'.';
$string['alternativethemesidepreblockbackgroundcolourdesc'] = 'Définir la couleur de fond alternative {$a} du bloc \'side-pre\'.';
$string['alternativethemesidepreblockhovercolour'] = 'Couleur alternative {$a} au survol du lien du bloc \'side-pre\'';
$string['alternativethemesidepreblockhovercolourdesc'] = 'Définir la couleur alternative {$a} au survol du texte du bloc \'side-pre\'';
$string['alternativethemesidepreblocktextcolour'] = 'Couleur alternative {$a} du texte du bloc \'side-pre\'';
$string['alternativethemesidepreblocktextcolourdesc'] = 'Définir la couleur alternative {$a} du texte du bloc \'side-pre\'';
$string['alternativethemesidepreblockurlcolour'] = 'Couleur alternative {$a} du lien du bloc \'side-pre\'';
$string['alternativethemesidepreblockurlcolourdesc'] = 'Définir la couleur alternative {$a} pour le bloc \'side-pre\'';
$string['alternativethemeslidebuttoncolor'] = 'Couleur alternative du bouton du diaporama {$a}';
$string['alternativethemeslidebuttoncolordesc'] = 'Couleur alternative du bouton de la diapo « En savoir plus » {$a}';
$string['alternativethemeslidebuttonhovercolor'] = 'Couleur alternative du bouton de diapositive {$a}';
$string['alternativethemeslidebuttonhovercolordesc'] = 'La couleur alternative que devrait avoir le bouton de navigation de diapositive au survol {$a}';
$string['alternativethemeslidecaptionbackgroundcolor'] = 'Couleur de fond alternative des légendes des diapositives {$a}';
$string['alternativethemeslidecaptionbackgroundcolordesc'] = 'La couleur alternative que devrait avoir le fond des légendes des diapositives {$a}. Ne s\'applique pas à l\'option légende de la diapositive "A côté".';
$string['alternativethemeslidecaptiontextcolor'] = 'Couleur alternative du texte des légendes des diapositives {$a}';
$string['alternativethemeslidecaptiontextcolordesc'] = 'La couleur alternative que devrait avoir le texte des légendes des diapositives. Ne s\'applique pas à l\'option légende de la diapositive "A côté".';
$string['alternativethemeslidecolors'] = 'Couleurs alternatives du diaporama';
$string['alternativethemeslidecolorsdesc'] = 'Définissez les couleurs alternatives du diaporama que l\'utilisateur peut choisir';
$string['alternativethemestripebackgroundcolour'] = 'Couleur inverse de fond en couleurs alternatives {$a}';
$string['alternativethemestripebackgroundcolourdesc'] = 'Définit la couleur inversée de fond dans les tableaux en couleurs alternatives {$a}';
$string['alternativethemestripetextcolour'] = 'Couleur inverse du texte en couleurs alternatives {$a}';
$string['alternativethemestripetextcolourdesc'] = 'Définit la couleur inversée du texte dans les tableaux en couleurs alternatives {$a}';
$string['alternativethemestripeurlcolour'] = 'Couleur inverse des liens en couleurs alternatives {$a}';
$string['alternativethemestripeurlcolourdesc'] = 'Définit la couleur inversée des liens dans les tableaux en couleurs alternatives {$a}';
$string['alternativethemetextcolor'] = 'Couleur alternative de texte {$a}';
$string['alternativethemetextcolordesc'] = 'Définissez la couleur alternative de votre texte {$a}';
$string['alternativethemeurlcolor'] = 'Couleur de lien alternatif {$a}';
$string['alternativethemeurlcolordesc'] = 'Définissez la couleur de votre lien alternatif {$a}';
$string['alwaysdisplay'] = 'Toujours afficher';
$string['android'] = 'Android (Google Play)';
$string['androiddesc'] = 'Indiquez l\'URL vers votre application pour mobiles sur le Google Play Store. Si vous ne disposez pas de la vôtre, vous pouvez envisager de pointer vers l\'application officielle gratuite Moodle pour mobiles.';
$string['androidurl'] = 'URL Android (Google Play)';
$string['asconfigintlower'] = '{$a->value} est plus petit que la limite inférieure de {$a->lower}';
$string['asconfigintnan'] = '{$a->value} n\'est pas un nombre';
$string['asconfigintupper'] = '{$a->value} est plus grand que la limite supérieure de {$a->upper}';
$string['backtotop'] = 'Retour en haut de page';
$string['badgepreferences'] = 'Badge';
$string['badgesmi'] = 'Badges';
$string['badgesmidesc'] = 'Affiche l\'élément de menu Badges si l\'utilisateur a la capacité \'moodle/badges:manageownbadges\' et que les badges sont activés au niveau du site.';
$string['beforecontent'] = 'Avant le contenu';
$string['breadcrumbsimple'] = 'Simple';
$string['breadcrumbstyle'] = 'Style fil d\'Ariane';
$string['breadcrumbstyled'] = 'Fantaisie';
$string['breadcrumbstyledesc'] = 'Ici vous pouvez changer le style du fil d\'Ariane';
$string['breadcrumbstylednocollapse'] = 'Fantaisie pas réduite';
$string['breadcrumbthin'] = 'Fin';
$string['cachesused'] = 'Mise en cache utilisée';
$string['calendarmi'] = 'Calendrier';
$string['calendarmidesc'] = 'Affiche l\'élément de menu Calendrier si l\'utilisateur a la capacité \'moodle/calendar:manageownentries\'.';
$string['categoryctidesc'] = 'Si ce réglage est activé, cela vous permettrait d\'associer une image pour chaque catégorie.';
$string['categoryctiheading'] = 'Images de catégorie';
$string['categoryctiheadingcategory'] = 'Images de catégorie pour :  {$a->category}';
$string['categoryctiheadingcs'] = 'Paramètre des images pour le titre des cours de la catégorie';
$string['categoryctiheadingsub'] = 'Utilise des images pour représenter vos catégories dans un cours';
$string['categoryctiheight'] = 'Hauteur de l\'image pour le titre des cours de la catégorie « {$a->category} »';
$string['categoryctiheightdesc'] = 'Hauteur de l\'image du titre de cours dans la catégorie « {$a->category} » entre {$a->lower} et {$a->upper} pixels. Ne pas faire suivre de \'px\', seulement le nombre.';
$string['categoryctiinfo'] = 'Paramètres de {$a->category}';
$string['categoryctiinfodesc'] = 'Paramètres de l\'image du titre de cours de la catégorie : {$a->category}.';
$string['categoryctimage'] = 'Fichier de l\'image du titre de cours de la catégorie « {$a->category} »';
$string['categoryctimagedesc'] = 'Fichier de l\'image pour le titre des cours de la catégorie « {$a->category} ».';
$string['categoryctimageurl'] = 'URL de l\'image du titre de cours de la catégorie « {$a->category} »';
$string['categoryctimageurldesc'] = 'URL de l\'image du titre de cours dans la catégorie « {$a->category} ». Si le fichier est téléchargé alors cela passera outre celui-ci.';
$string['categoryctitextbackgroundcolour'] = 'Couleur de fond du texte du titre de cours pour la catégorie « {$a->category} »';
$string['categoryctitextbackgroundcolourdesc'] = 'Couleur de fond du texte pour le titre de cours de la catégorie « {$a->category} ».';
$string['categoryctitextbackgroundopacity'] = 'Opacité du fond du texte du titre de cours pour la catégorie « {$a->category} »';
$string['categoryctitextbackgroundopacitydesc'] = 'Opacité du fond du texte du titre de cours pour la catégorie « {$a->category} ».';
$string['categoryctitextcolour'] = 'Couleur du texte du titre de cours pour la catégorie « {$a->category} »';
$string['categoryctitextcolourdesc'] = 'Couleur du texte du titre de cours pour la catégorie « {$a->category} ».';
$string['categoryiconcategory'] = 'L\'icône de la catégorie : {$a->category}.';
$string['categoryicondesc'] = 'Si ce réglage est activé, ceci vous permettra de définir des icônes pour chaque catégorie de cours.';
$string['categoryiconheading'] = 'Affichage d\'icône basé sur la catégorie';
$string['categoryiconheadingsub'] = 'Utiliser des icônes pour représenter vos catégories';
$string['categoryiconinfo'] = 'Définissez des icônes de catégorie personnalisées';
$string['categoryiconinfodesc'] = 'Chaque icône est définie par son "category ID". Vous les obtenez en regardant l\'URL de chaque catégorie.';
$string['categoryimagecategory'] = 'L\'image pour la catégorie : {$a->category}.';
$string['categoryincoursebreadcrumbfeature'] = 'Catégories dans le fil d\'Ariane du cours';
$string['categoryincoursebreadcrumbfeaturedesc'] = 'Affiche les liens des catégories dans le fil d\'Ariane du cours.';
$string['colordesc'] = 'Ici vous pouvez trouver différents réglages pour changer de nombreuses couleurs présentes dans ce thème.';
$string['colorheading'] = 'Paramètres des couleurs';
$string['colorheadingsub'] = 'Définissez les couleurs utilisées dans votre thème';
$string['configtitle'] = 'Essential';
$string['contactinfo'] = 'Coordonnées';
$string['contactinfodesc'] = 'Entrez vos coordonnées';
$string['copyright'] = 'Droits d\'auteur';
$string['copyrightdesc'] = 'Le nom de votre organisation';
$string['coursecategorysettingstitle'] = 'Paramètres de catégories de cours';
$string['coursecontentsearch'] = 'Recherche de contenus de cours';
$string['coursecontentsearchdesc'] = 'Active la recherche de contenu de cours sur le "Tableau de bord". Fonctionne seulement lorsque Essential n\'est pas dans "$CFG->themedir".';
$string['coursegrades'] = 'Notes de cours';
$string['coursegradesmi'] = 'Notes du cours';
$string['coursegradesmidesc'] = 'Affiche l\'élément de menu Notes du cours si l\'utilisateur a la capacité \'gradereport/user:view\' et que le paramètre de cours Afficher les notes (\'showgrades\') est activé.';
$string['courselistteachericon'] = 'Course';
$string['courselistteachericondesc'] = 'Nom de l\'icône que vous souhaitez utiliser ou vide pour aucun. La liste est <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">ici</a>. Entrer simplement ce qui est après le "fa-", e.g. "star".';
$string['coursesettingstitle'] = 'Paramètres du cours';
$string['coursetitleposition'] = 'Position du titre du cours';
$string['coursetitlepositiondesc'] = 'Choisissez entre \'Au-dessus\' et \'Entre\' pour le titre de cours. Où \'Au dessus\' est situé au-dessus des régions \'side-pre\', \'page-top\' et \'course-content\' et \'Within\' se situe dans la région de contenu du cours telle qu\'elle était située avant l\'introduction de ce paramètre.';
$string['ctioverride'] = 'Remplacer les images de catégorie dans un cours';
$string['ctioverridedesc'] = 'Si vous souhaitez remplacer l\'image du titre de cours dans une catégorie au sein d\'un cours lorsque le paramètre "enablecategorycti" est activé, modifiez le résumé du cours dans les paramètres du cours et ajoutez une image. Ensuite, modifiez en mode HTML, supprimez les balises "p" environnantes et la balise "br", puis supprimez les attributs "style", "width" et "height" et toutes les "classes" ajoutées par l\'éditeur de texte sur la balise "img". Ajoutez ensuite la classe "categorycti". Pour spécifier la hauteur (px) et la couleur du texte, la couleur d\'arrière-plan et l\'opacité, utilisez respectivement les attributs suivants : "ctih", "ctit", "ctib" et "ctio".

Par exemple: <br/> <br/> <img src="https: //mymoodleinstall.me/pluginfile.php/493/course/section/237/myimage.jpg" Alt="Image de remplacement" class="categorycti" ctih="250" ctit="#afafaf" ctib="#222222" ctio="0,5"&gt;<br/> <br/> Cette image ne sera pas représentée dans le résumé lui-même lors de l\'affichage de la liste de cours.';
$string['ctioverrideheight'] = 'Hauteur par défaut de l\'image de remplacement du titre de cours';
$string['ctioverrideheightdesc'] = 'Hauteur par défaut de l\'image de remplacement pour le titre du cours entre {$a->lower} et {$a->upper} pixels. Ne pas faire suivre de "px", seulement le nombre.';
$string['ctioverridetextbackgroundcolour'] = 'Couleur de remplacement par défaut du fond du titre de cours';
$string['ctioverridetextbackgroundcolourdesc'] = 'Couleur de remplacement par défaut du fond pour le titre du cours.';
$string['ctioverridetextbackgroundopacity'] = 'Opacité de remplacement par défaut du fond du titre de cours';
$string['ctioverridetextbackgroundopacitydesc'] = 'Opacité de remplacement par défaut du fond pour le titre du cours.';
$string['ctioverridetextcolour'] = 'Couleur de remplacement par défaut du titre de cours';
$string['ctioverridetextcolourdesc'] = 'Couleur de remplacement par défaut pour le titre du cours';
$string['customcss'] = 'CSS personnalisées';
$string['customcssdesc'] = 'Toutes les règles CSS que vous ajoutez à cette zone de texte seront reflétées dans chaque page, ce qui rend plus facile la personnalisation de ce thème.';
$string['customscrollbars'] = 'Barres de défilement personnalisées';
$string['customscrollbarsdesc'] = 'Utiliser des barres de défilement personnalisées. Cela remplacera les barres de défilement standard du navigateur.';
$string['dbqueries'] = 'Lectures/Écritures en base de données';
$string['dbtime'] = 'Délai des requêtes de base de données';
$string['defaultcategoryicon'] = 'Icônes de catégorie par défaut';
$string['defaultcategoryicondesc'] = 'Définissez une icône de catégorie par défaut';
$string['defaultcategoryimage'] = 'Image de catégorie par défaut';
$string['defaultcategoryimagedesc'] = 'Définissez une image de catégorie par défaut. Cela remplacera l\'icône.';
$string['defaultcolors'] = 'Couleurs par défaut';
$string['displayafterlogin'] = 'Afficher après authentification uniquement';
$string['displaybeforelogin'] = 'Afficher avant authentification uniquement';
$string['displayeditingmenu'] = 'Afficher le bouton d\'édition';
$string['displayeditingmenudesc'] = 'Affiche un bouton dans l\'entête avec la même fonctionnalité que le bouton d\'activation du mode édition.';
$string['displayhiddenmycourses'] = 'Afficher les cours cachés';
$string['displayhiddenmycoursesdesc'] = 'Afficher les cours cachés dans le menu personnalisé pour les utilisateurs ayant la permission de voir les cours cachés';
$string['displaymycourses'] = 'Afficher les cours des utilisateurs';
$string['displaymycoursesdesc'] = 'Afficher les cours des utilisateurs dans le "Menu personnalisé"';
$string['dontdisplay'] = 'Ne jamais afficher';
$string['dropdownmenumaxheight'] = 'Hauteur maximale du menu déroulant';
$string['dropdownmenumaxheightdesc'] = 'Hauteur maximale du menu déroulant lorsque les barres de défilement sont activées. Entre {$a->lower} et {$a->upper} pixels.';
$string['dropdownmenuscroll'] = 'Barres de défilement sur les menus déroulants';
$string['dropdownmenuscrolldesc'] = 'Ajouter une barre de défilement dans le menu déroulant où la hauteur du menu est limitée.';
$string['editingmenu'] = 'Bascule du mode édition de page';
$string['editingmenudesc'] = 'Affiche un bouton pour activer/désactiver le mode édition si l’utilisateur possède les droits requis. C\'est la même fonctionnalité que le bouton d\'activation du mode édition.';
$string['enablealert'] = 'Activer l\'alerte';
$string['enablealertdesc'] = 'Active ou désactive les alertes';
$string['enablealternativethemecolors'] = 'Activer les couleurs alternatives de thème {$a}';
$string['enablealternativethemecolorsdesc'] = 'Si ce réglage est activé, l\'utilisateur pourra choisir des couleurs alternatives pour le thème {$a}.';
$string['enablecategorycti'] = 'Activer les images de titre de cours pour les catégories';
$string['enablecategoryctics'] = 'Activer les pages de paramètres des images de titre de cours pour les catégories';
$string['enablecategorycticsdesc'] = 'Si ce réglage est activé, chaque catégorie principale disposera de sa propre page de paramètres.';
$string['enablecategoryctidesc'] = 'Si ce réglage est activé, vous serez en mesure de sélectionner les images de titre de cours pour les catégories après avoir cliqué sur "Enregistrer les modifications".';
$string['enablecategoryicon'] = 'Activer les icônes de catégorie';
$string['enablecategoryicondesc'] = 'Si ce réglage est activé, vous serez en mesure de choisir des icônes de catégorie après avoir cliqué sur « Enregistrer les modifications ».';
$string['enablecustomcategoryicon'] = 'Activer les icônes de catégorie';
$string['enablecustomcategoryicondesc'] = 'Si ce réglage est activé, vous verrez sous cette section chaque catégorie avec une option personnalisable. Pensez à enregistrer après activation ou désactivation de cette option.';
$string['extperfinfoheading'] = 'Information de performance étendue';
$string['facebook'] = 'Facebook';
$string['facebookdesc'] = 'Entrez l\'URL de votre page Facebook. (ex. http://www.facebook.com/mycollege)';
$string['facebookurl'] = 'URL Facebook';
$string['favicon'] = 'Favicon personnalisée';
$string['favicondesc'] = 'Déposez votre propre fichier favicon. Cela doit être un fichier .ico.';
$string['featuredesc'] = 'Vous trouvez ici divers réglages permettant de modifier les nombreuses fonctionnalités de ce thème.';
$string['featureheading'] = 'Fonctionnalités';
$string['featureheadingsub'] = 'Régler les fonctionnalités utilisées par votre thème';
$string['findcoursecontent'] = 'Contenu de cours :';
$string['fitvids'] = 'Utiliser FitVids';
$string['fitvidsdesc'] = 'Activer FitVids (fitvidsjs.com) pour afficher vos vidéos de manière adaptative. Si FitVids est activé et que vous voulez exclure une vidéo, il faut ajouter «class="fitvidsignore"» au tag «iframe» dans le mode HTML de l\'éditeur. Par exemple : <iframe class="fitvidsignore" width="420" height="315" src="//www.youtube.com/embed/enmEmym85xc" frameborder="0" allowfullscreen=""></iframe>';
$string['fixedwidthnarrow'] = 'Largeur fixe - Rapproché';
$string['fixedwidthnormal'] = 'Largeur fixe - Normal';
$string['fixedwidthwide'] = 'Largeur fixe - Large';
$string['flatnavigation'] = 'Activer la navigation à plat.';
$string['flatnavigationdesc'] = 'Si cette option est activée, la navigation à plat sera utilisée à la place des blocs de navigation et de paramètres.';
$string['flickr'] = 'Flickr';
$string['flickrdesc'] = 'Entrez l\'URL de votre page Flickr. (ex. http://www.flickr.com/mycollege)';
$string['flickrurl'] = 'URL de Flickr';
$string['floatingsubmitbuttons'] = 'Boutons de validation flotttants';
$string['floatingsubmitbuttonsdesc'] = 'Avoir une zone "flottante" contenant les boutons utilisés pour soumettre un formulaire sur les appareils de bureau. Cela permet de réduire le défilement sur certaines pages. Non utilisé pour l\'inscription aux cours et sur les messages de forum';
$string['fontcharacterset'] = 'Jeu de caractères Google additionnel';
$string['fontcharactersetcyrillic'] = 'Cyrillique';
$string['fontcharactersetcyrillicext'] = 'Cyrillique étendu';
$string['fontcharactersetdesc'] = 'Choisissez des jeux de caractères supplémentaires pour les différentes langues. L\'utilisation de nombreux jeux de caractères peuvent ralentir votre Moodle, il faut donc faire en sorte de sélectionner les jeux de caractères dont vous avez réellement besoin.';
$string['fontcharactersetgreek'] = 'Grec';
$string['fontcharactersetgreekext'] = 'Grec étendu';
$string['fontcharactersetlatinext'] = 'Latin étendu';
$string['fontcharactersetvietnamese'] = 'Vietnamien';
$string['fontfileeotbody'] = 'Fichier de police EOT Corps de texte';
$string['fontfileeotheading'] = 'Fichier de police EOT Titres';
$string['fontfileotfbody'] = 'Fichier de police OTF Corps de texte';
$string['fontfileotfheading'] = 'Fichier de police OTF Titres';
$string['fontfiles'] = 'Fichiers de police';
$string['fontfilesdesc'] = 'Déposez vos fichiers de police ici.';
$string['fontfilesvgbody'] = 'Fichier de police SVG Corps de texte';
$string['fontfilesvgheading'] = 'Fichier de police SVG Titres';
$string['fontfilettfbody'] = 'Fichier de police TTF Corps de texte';
$string['fontfilettfheading'] = 'Fichier de police TTF Titres';
$string['fontfilewoffbody'] = 'Fichier de police WOFF Corps de texte';
$string['fontfilewoffheading'] = 'Fichier de police WOFF';
$string['fontfilewofftwobody'] = 'Fichier de police WOFF Corps de texte';
$string['fontfilewofftwoheading'] = 'Fichier de police WOFF Titres';
$string['fontheadingdesc'] = 'Sélectionnez et entrez les polices que vous souhaitez utiliser dans votre environnement Moodle.';
$string['fontheadingsub'] = 'Réglages de la police';
$string['fontnamebody'] = 'Police du texte';
$string['fontnamebodydesc'] = 'Entrez le nom exact de la police à utiliser pour tous les autres textes.';
$string['fontnameheading'] = 'Police de titre';
$string['fontnameheadingdesc'] = 'Entrez le nom exact de la police à utiliser pour les titres.';
$string['fontselect'] = 'Sélecteur de police';
$string['fontselectdesc'] = '';
$string['fontsettings'] = 'Police';
$string['fonttypecustom'] = 'Police personnalisée';
$string['fonttypegoogle'] = 'Police web Google';
$string['fonttypeuser'] = 'Polices utilisateur';
$string['footerblockbackgroundcolour'] = 'Couleur de fond du bloc Pied de page';
$string['footerblockbackgroundcolourdesc'] = 'Définissez la couleur de fond du bloc Pied de page';
$string['footerblockhovercolour'] = 'Couleur de survol des liens dans le bloc Pied de page';
$string['footerblockhovercolourdesc'] = 'Définissez la couleur de survol des liens textes dans le bloc Pied de page';
$string['footerblocktextcolour'] = 'Couleur du texte dans le bloc Pied de page';
$string['footerblocktextcolourdesc'] = 'Définissez la couleur souhaitée pour le texte du bloc Pied de page';
$string['footerblockurlcolour'] = 'Couleur des liens dans le bloc Pied de page';
$string['footerblockurlcolourdesc'] = 'Définissez la couleur des liens textes dans le pied de page';
$string['footercolor'] = 'Couleur de fond du pied de page';
$string['footercolordesc'] = 'Régler la couleur de fond de la boîte du pied de page.';
$string['footercolors'] = 'Couleurs du pied de page';
$string['footercolorsdesc'] = 'Changer les couleurs du pied de page';
$string['footerheading'] = 'Pied de page';
$string['footerheadingcolor'] = 'Couleur des titres dans le pied de page';
$string['footerheadingcolordesc'] = 'Définissez la couleur des titres pour les blocs dans le pied de page.';
$string['footerhovercolor'] = 'Couleur au survol dans le pied de page';
$string['footerhovercolordesc'] = 'Définissez la couleur des hyperliens au survol de la souris.';
$string['footersepcolor'] = 'Couleur du séparateur dans le pied de page';
$string['footersepcolordesc'] = 'Les séparateurs sont des lignes utilisées pour séparer le contenu. Réglez leur couleur ici.';
$string['footertextcolor'] = 'Couleur du texte du pied de page';
$string['footertextcolordesc'] = 'Définissez la couleur de votre texte dans le pied de page';
$string['footerurlcolor'] = 'Couleur des liens dans le pied de page';
$string['footerurlcolordesc'] = 'Définissez la couleur de vos hyperliens dans le pied de page.';
$string['footnote'] = 'Note de bas de page';
$string['footnotedesc'] = 'Le texte ajouté dans cette zone de texte sera affiché dans le pied de page sur tout votre site Moodle.';
$string['forumdiscussionsmi'] = 'Discussions';
$string['forumdiscussionsmidesc'] = 'Affiche l\'élément de menu Discussions (forum) si l\'utilisateur a la capacité \'mod/forum:viewdiscussion\'.';
$string['forumpostsmi'] = 'Messages de forum';
$string['forumpostsmidesc'] = 'Affiche l\'élément de menu Messages de forum si l\'utilisateur a la capacité \'mod/forum:viewdiscussion\'.';
$string['fppagetopblocks'] = 'Activer des blocs "Haut de page" supplémentaires en page d\'accueil';
$string['fppagetopblocksdesc'] = 'Si cette option est activée, un emplacement de bloc supplémentaire est placé à côté des blocs latéraux et au-dessus de la zone de contenu. Remarque : Le nombre de blocs par ligne dépend du paramètre "pagetopblocksperrow".';
$string['fppagetopblocksperrow'] = 'Nombre de blocs par ligne en haut de la page';
$string['fppagetopblocksperrowdesc'] = 'Indiquez le nombre de blocs par ligne entre {$a->lower} et {$a->upper} pour la zone de bloc \'Top\' sur la page d\'accueil.';
$string['frontcontent'] = 'Activer la zone de contenu de la page d\'accueil';
$string['frontcontentarea'] = 'Contenu de la page d\'accueil';
$string['frontcontentareadesc'] = 'Tout ce qui est écrit dans cette zone de texte sera affiché sur toute la largeur de la page entre le diaporama et les annonces marketing';
$string['frontcontentdesc'] = 'Si ce réglage est activé, cela ajoute un contenu personnalisé entre le diaporama et les annonces marketing.';
$string['frontcontentheading'] = 'Réglages de la page d\'accueil';
$string['frontpageblocks'] = 'Alignement des blocs de la page d\'accueil';
$string['frontpageblocksdesc'] = 'Ici, vous pouvez déterminer si les blocs Moodle standard sur la première page s\'alignent avant ou après le contenu.';
$string['frontpageblocksheading'] = 'Blocs de la page d\'accueil';
$string['frontpageheading'] = 'Page d\'accueil';
$string['frontpageheadingdesc'] = 'Configurez ici quels éléments additionnels vous voulez afficher sur la page d\'accueil.';
$string['frontpagehomeblocksperrow'] = 'Blocs d\'accueil par rangée';
$string['frontpagehomeblocksperrowdesc'] = 'Indiquez le nombre de blocs par ligne entre {$a->lower} et {$a->upper} pour les \'Blocs d\'accueil\'. Remarque : pour faciliter l\'édition, deux blocs par ligne seront affichés, quel que soit ce paramètre.';
$string['frontpagemiddleblocks'] = 'Activer les blocs dans la zone centrale';
$string['frontpagemiddleblocksdesc'] = 'Si cette option est activée, cela affichera un emplacement de blocs juste sous les spots de marketing.';
$string['frontpagesettingstitle'] = 'Paramètres de la page d\'accueil';
$string['fullname'] = 'Nom complet du site';
$string['fullnamesummary'] = 'Nom complet et résumé';
$string['generalheadingdesc'] = 'Configurez les paramètres globaux du thème sur cette page. Vous y trouverez aussi bien des options de mise en page que visuelles.';
$string['generalheadingsub'] = 'Paramètres généraux';
$string['genericsettings'] = 'Paramètres généraux';
$string['googleplus'] = 'Google+';
$string['googleplusdesc'] = 'Saisir l\'URL de votre profil Google+ (p. ex. http://plus.google.com/107817105228930159735).';
$string['googleplusurl'] = 'URL Google+';
$string['gotobottom'] = 'Aller en bas de page';
$string['haveheaderblock'] = 'Zone de blocs d\'en-tête';
$string['haveheaderblockdesc'] = 'Ajoute une zone de blocs en en-tête juste en dessous du fil d\'Ariane.';
$string['headerbackground'] = 'Image de fond de l\'en-tête';
$string['headerbackgrounddesc'] = 'Déposez votre propre image de fond';
$string['headerbackgroundstyle'] = 'Style d\'arrière-plan de l\'en-tête';
$string['headerbackgroundstyledesc'] = 'Sélectionnez le style de l\'arrière-plan de l\'en-tête.';
$string['headerblocksperrow'] = 'Blocs d\'en-tête par rangée';
$string['headerblocksperrowdesc'] = 'Indiquez le nombre de blocs par rangée entre {$a->lower} et {$a->upper} pour les pages avec une "Zone de blocs d\'en-tête".';
$string['headerheading'] = 'En-tête';
$string['headertextcolor'] = 'Couleur du texte de l\'en-tête';
$string['headertextcolordesc'] = 'Choisissez la couleur du texte de l\'en-tête';
$string['headertitle'] = 'Titre de l\'en-tête';
$string['headertitledesc'] = 'Configurez ici le titre à afficher dans l\'en-tête. Remarque : le titre de l\'entête ne sera utilisé que s\'il n\'y a pas de logo.';
$string['helplink'] = 'Lien d\'aide';
$string['helplinkdesc'] = 'Si vous avez choisi URL ci-dessus, renseignez l\'URL complète vers votre site d\'aide (doit inclure http:// ou https://). Si vous avez choisi adresse de courriel, renseignez la.';
$string['helplinktype'] = 'Activez le lien d\'aide dans le menu';
$string['helplinktypedesc'] = 'Choisissez si vous souhaitez activer une option d\'aide dans le menu de l\'utilisateur. Vous pouvez choisir de fournir une URL qui sera ouverte dans une nouvelle fenêtre ou une adresse e-mail.';
$string['hidedefaulteditingbutton'] = 'Cacher le bouton d\'édition par défaut';
$string['hidedefaulteditingbuttondesc'] = 'Cache le bouton d\'édition par défaut de toutes les pages. Ce paramètre n\'aura d\'effet que si le paramètre "Afficher le bouton d\'édition" est activé.';
$string['hideonphone'] = 'Diaporama sur les mobiles';
$string['hideonphonedesc'] = 'Choisissez si vous souhaitez que le diaporama s\'affiche sur les mobiles ou non';
$string['hideontablet'] = 'Cacher le diaporama sur les tablettes';
$string['hideontabletdesc'] = 'Choisissez si vous souhaitez désactiver le diaporama sur les tablettes.';
$string['icon'] = 'icône';
$string['image'] = 'image';
$string['included'] = 'Fichiers inclus';
$string['instagram'] = 'Instagram';
$string['instagramdesc'] = 'Entrez l\'URL de votre page Instagram. (ex. http://instagram.com/mycollege)';
$string['instagramurl'] = 'URL Instagram';
$string['ios'] = 'iPhone/iPad/iPod Touch (App Store)';
$string['iosdesc'] = 'Indiquez l\'URL vers votre application pour mobile sur l\'App Store. Si vous ne disposez pas de la vôtre, vous pouvez envisager de pointer vers l\'application officielle gratuite Moodle pour mobiles.';
$string['iosicon'] = 'Icônes d\'écran d\'accueil iOS';
$string['iosicondesc'] = 'Le thème fournit une icône par défaut pour les écrans d\'accueil d\'iOS et Android. Vous pouvez déposer vos icônes personnalisées si vous le souhaitez.';
$string['iosurl'] = 'URL iPhone/iPad/iPod Touch (App Store)';
$string['ipadicon'] = 'Icône iPad (Non Retina)';
$string['ipadicondesc'] = 'L\'icône devrait être un fichier PNG d\'une définition de 72 px par 72 px.';
$string['ipadretinaicon'] = 'Icône iPad (Retina)';
$string['ipadretinaicondesc'] = 'L\'icône devrait être un fichier PNG d\'une définition de 144 px par 144 px.';
$string['iphoneicon'] = 'Icône iPhone/iPod Touch (Non Retina)';
$string['iphoneicondesc'] = 'L\'icône devrait être un fichier PNG d\'une dimension de 57 px par 57 px.';
$string['iphoneretinaicon'] = 'Icône iPhone/iPod Touch (Retina)';
$string['iphoneretinaicondesc'] = 'L\'icône devrait être un fichier PNG d\'une dimension de 114 px par 114 px.';
$string['layout'] = 'Utiliser une disposition de cours standard';
$string['layoutdesc'] = 'Ce thème est conçu pour mettre les deux colonnes de blocs sur le côté. Si vous préférez la disposition standard des cours Moodle, vous pouvez cocher cette case et retourner à l\'ancienne et ennuyeuse disposition en trois colonnes.';
$string['left'] = 'Gauche';
$string['linkedin'] = 'LinkedIn';
$string['linkedindesc'] = 'Entrez l\'URL de votre profil LinkedIn. (ex. http://www.linkedin.com/company/mycollege)';
$string['linkedinurl'] = 'URL LinkedIn';
$string['loadtime'] = 'Temps de chargement';
$string['loggedinas'] = 'Connecté en tant que';
$string['loggedinfrom'] = 'Connecté depuis';
$string['loggedinfrommi'] = 'Connecté depuis';
$string['loggedinfrommidesc'] = 'Affiche l\'item du menu connecté si l\'utilisateur est un utilisateur distant MNET.';
$string['loginbackground'] = 'Image d\'arrière-plan de connexion';
$string['loginbackgrounddesc'] = 'Téléchargez votre propre image d\'arrière-plan de connexion. Sélectionnez le style de l\'image ci-dessous.';
$string['loginbackgroundopacity'] = 'Opacité de l\'arrière-plan de la zone de connexion en cas d\'image de fond';
$string['loginbackgroundopacitydesc'] = 'Opacité de l\'arrière-plan pour la zone de connexion quand il y a une image de fond.';
$string['loginbackgroundstyle'] = 'Style de l\'arrière-plan de connexion';
$string['loginbackgroundstyledesc'] = 'Sélectionnez le style de l\'image téléchargée.';
$string['logo'] = 'Logo';
$string['logodesc'] = 'Télécharger ici votre logo personnalisé si vous souhaitez l\'ajouter à l\'en-tête. <br> L\'image sera mise à l\'échelle pour correspondre à la largeur de pourcentage disponible spécifiée pour le dispositif ci-dessous. Cela donne une solution adaptative. Si vous avez beaucoup d\'icônes sociales/d\'applications, vérifiez le résultat. <br> Si vous téléchargez un logo, il remplacera l\'icône standard et le nom affiché par défaut.';
$string['logodesktopwidth'] = 'Largeur du logo';
$string['logodesktopwidthdesc'] = 'La largeur du conteneur d\'image du logo sur le bureau, >= 980px.<br>Veuillez indiquer en pourcentage l\'espace disponible entre {$a->lower} et {$a->upper}.<br>L\'espace disponible est la largeur autorisée par le paramètre \'pagewidth\'. L\'image remplira le pourcentage indiqué jusqu\'à sa largeur de résolution. <br>Remarque : La hauteur minimale du conteneur est de 64 pixels, il y aura donc un écart inférieur si la hauteur de l\'image est calculée pour être inférieure.';
$string['logodimerror'] = 'est invalide. Veuillez indiquer "px" ou "em" immédiatement après l\'unité et rien avant.';
$string['logomobilewidth'] = 'Largeur du logo pour appareil mobile';
$string['logomobilewidthdesc'] = 'La largeur du conteneur d\'image du logo sur un mobile, < 980px.<br> Veuillez indiquer une largeur en pourcentage de l\'espace disponible entre {$a->lower} et {$a->upper}. <br> L\'espace disponible est la largeur autorisée par le paramètre \'pagewidth\'. L\'image remplira le pourcentage indiqué jusqu\'à sa largeur de résolution. <br> Remarque : la hauteur minimale du conteneur est de 52 pixels, il y aura donc un espace inférieur si la hauteur de l\'image est calculée pour être inférieure.';
$string['marketing1'] = 'Annonce marketing Une - Titre';
$string['marketing2'] = 'Annonce marketing Deux - Titre';
$string['marketing3'] = 'Annonce marketing Trois - Titre';
$string['marketingbuttontext'] = 'Texte du lien';
$string['marketingbuttontextdesc'] = 'Texte à afficher sur le bouton';
$string['marketingbuttonurl'] = 'Lien URL';
$string['marketingbuttonurldesc'] = 'URL vers laquelle le bouton va pointer';
$string['marketingcontent'] = 'Contenu';
$string['marketingcontentdesc'] = 'Contenu à afficher dans l\'annonce marketing. Gardez le court et concis.';
$string['marketingdesc'] = 'Ce thème offre la possibilité d\'activer trois annonces "marketing" ou "spots publicitaires" juste sous le diaporama. Elles vous permettent d\'afficher facilement les informations essentielles à vos utilisateurs et fournissent des liens directs.';
$string['marketingheading'] = 'Annonces marketing';
$string['marketingheadingsub'] = 'Trois emplacements sur la première page pour ajouter des informations et des liens.';
$string['marketingheight'] = 'Hauteur du conteneur des images marketing (px)';
$string['marketingheightdesc'] = 'Spécifiez la hauteur du conteneur des annonces marketings (en pixels). Ajustez ceci en fonction de votre contenu. Si une annonce comporte une image ou un lien, cela sera utilisé pour toutes les annonces.';
$string['marketingicon'] = 'Icône';
$string['marketingicondesc'] = 'Nom de l\'icône que vous souhaitez utiliser. La liste est <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">ici</a>. Il suffit d\'entrer ce qui est après "fa-".';
$string['marketingimage'] = 'Image';
$string['marketingimagedesc'] = 'Ceci donne la possibilité d\'afficher une image au-dessus du texte dans l\'annonce marketing';
$string['marketingimageheight'] = 'Hauteur des images marketing (px)';
$string['marketingimageheightdesc'] = 'Si vous souhaitez afficher des images dans les annonces marketing, vous pouvez spécifier leur hauteur (en pixels) ici.';
$string['marketinginfodesc'] = 'Entrez les réglages de votre annonce marketing.';
$string['marketingtitle'] = 'Titre';
$string['marketingtitledesc'] = 'Titre à afficher dans cette annonce marketing';
$string['marketingurltarget'] = 'Cible du lien';
$string['marketingurltargetdesc'] = 'Choisissez comment le lien doit être ouvert';
$string['marketingurltargetnew'] = 'Nouvelle page';
$string['marketingurltargetparent'] = 'Cadre parent';
$string['marketingurltargetself'] = 'Page actuelle';
$string['memused'] = 'Mémoire utilisée';
$string['messagesmi'] = 'Messages';
$string['messagesmidesc'] = 'Affiche l\'élément de menu Messages si la messagerie est activée.';
$string['mobileappsdesc'] = 'Avez-vous une web app sur l\'App Store ou Google Play Store ? Fournissez un lien ici afin que vos utilisateurs puissent se procurer l\'application en ligne';
$string['mobileappsheading'] = 'Apps pour mobiles';
$string['mobileappsheadingsub'] = 'Lien vers votre application pour vos étudiants qui utilisent des mobiles';
$string['modulesettingstitle'] = 'Paramètres du module';
$string['myclasses'] = 'Mes classes';
$string['mycourses'] = 'Mes cours';
$string['mycoursescatsubmenu'] = 'Sous-menu Catégorie et cours';
$string['mycoursescatsubmenudesc'] = 'Organise les cours dans un sous-menu basé sur la catégorie de haut niveau dans lesquels ils sont situés. Lorsque "enablecategoryicon" n\'est pas actif alors l\'icône de catégorie utilisée sera celle du thème par défaut, alors que dans le cas contraire ce sera soit la valeur de "defaultcategoryicon", soit la catégorie elle-même si "enablecustomcategoryicon" est activé. Le paramètre "mycoursesmax" s\'appliquera toujours mais au niveau de la catégorie.';
$string['mycoursesinfo'] = 'Menu Cours';
$string['mycoursesinfodesc'] = 'Affiche une liste dynamique des cours des utilisateurs.';
$string['mycoursesmax'] = 'Cours maximum';
$string['mycoursesmaxdesc'] = 'Indiquez jusqu\'à combien de cours il faut lister, entre {$a->lower} et {$a->upper} où « {$a->lower} » représente tout.';
$string['mycoursesorder'] = 'Ordre des cours';
$string['mycoursesorderdesc'] = 'Indiquez comment les cours doivent être ordonnés. L\'ordre de tri du cours peut être défini par le paramètre de navigation de base "navsortmycoursessort".';
$string['mycoursesorderenrolbackcolour'] = 'Couleur de fond du cours inscrit et non accessible';
$string['mycoursesorderenrolbackcolourdesc'] = 'Couleur d\'arrière plan pour les cours inscrits mais non-accessibles. Lorsque \'mycourseorder\' est fixé à \'Dernier accès…\'.';
$string['mycoursesorderid'] = 'ID du cours';
$string['mycoursesorderidasc'] = 'Croissant';
$string['mycoursesorderiddes'] = 'Décroissant';
$string['mycoursesorderidorder'] = 'Ordre d\'ID de cours';
$string['mycoursesorderidorderdesc'] = 'Ordre de l\'ID du cours dès lors que "ID du cours" est défini comme "Ordre des cours".';
$string['mycoursesorderlast'] = 'Dernier accès ou date de début de l\'inscription si jamais accédé';
$string['mycoursesordersort'] = 'Ordre de tri des cours';
$string['mycoursetitle'] = 'Terminologie';
$string['mycoursetitledesc'] = 'Modifiez la terminologie du titre du menu "Mes cours". Lorsque "mycoursesorder" est réglé sur "Dernier accédé…", le mot "dernier" sera ajouté.';
$string['mygrades'] = 'Mes notes';
$string['mygradesmi'] = 'Mes notes';
$string['mygradesmidesc'] = 'Affiche l\'élément de menu Mes notes si l\'utilisateur a la capacité \'gradereport/overview:view\' dans un cours. Non vérifié au niveau du site.';
$string['mylatestclasses'] = 'Mes dernières classes';
$string['mylatestcourses'] = 'Mes dernier cours';
$string['mylatestmodules'] = 'Mes derniers modules';
$string['mylatestunits'] = 'Mes dernières unités';
$string['mymodules'] = 'Mes modules';
$string['myunits'] = 'Mes unités';
$string['navbarabove'] = 'Barre de navigation au dessus de l\'en-tête';
$string['navbarbelow'] = 'Barre de navigation sous l\'en-tête';
$string['navbartitle'] = 'Titre de la barre de navigation';
$string['navbartitledesc'] = 'Configurez ici le titre à afficher dans la barre de navigation';
$string['nextsection'] = 'Section suivante';
$string['nobreadcrumb'] = 'Cacher';
$string['noenrolments'] = 'Vous n\'avez pas de cours actuellement';
$string['noslidetitle'] = 'Pas de titre pour la diapositive {$a->slide}';
$string['notitle'] = 'Pas de titre';
$string['numberofcoursesandsubcatcourses'] = 'Nombre de cours - cours de sous catégories';
$string['numberofslides'] = 'Nombre de diapositives';
$string['numberofslides_desc'] = 'Nombre de diapositives dans le diaporama';
$string['oldnavbar'] = 'Utiliser l\'ancienne position de la barre de navigation';
$string['oldnavbardesc'] = 'Activez cette option pour utiliser l\'ancienne position de la barre de navigation';
$string['pagebackground'] = 'Image de fond de la page';
$string['pagebackgrounddesc'] = 'Déposez votre propre image de fond. Choisissez le style de l\'image ci-dessous.';
$string['pagebackgroundstyle'] = 'Style du fond de page';
$string['pagebackgroundstyledesc'] = 'Sélectionnez le style de l\'image téléchargée.';
$string['pagebottomblocksperrow'] = 'Blocs de bas de page par rangée';
$string['pagebottomblocksperrowdesc'] = 'Indiquez le nombre de blocs par rangée entre {$a->lower} et {$a->upper} pour les pages avec des "blocs de bas de page". Les pages actuelles sont : Admin, Gestion du cours, Évaluation et Édition de quiz.';
$string['pagetopblocks'] = 'Activer les blocs de page supplémentaires \'Page top\'';
$string['pagetopblocksdesc'] = 'Si cette option est activée, un emplacement de bloc supplémentaire s\'affichera à côté des blocs latéraux et au-dessus de la zone de contenu de toutes les pages, à l\'exception de la page d\'accueil qui possède son propre paramètre. Remarque : le nombre de blocs par ligne dépend du paramètre \'pagetopblocksperrow\'.';
$string['pagetopblocksperrow'] = 'Nombre de blocs de haut de page par rangée';
$string['pagetopblocksperrowdesc'] = 'Indiquez le nombre de blocs par rangée entre {$a->lower} et {$a->upper} pour les pages comportant des blocs "Haut de page". Les pages actuelles sont : Admin, Cours, Catégorie de cours, Tableau de bord, Page d\'accueil, My Public.';
$string['pagewidth'] = 'Largeur de page';
$string['pagewidthdesc'] = 'Choisissez parmi la liste de largeurs de page disponibles pour votre site';
$string['paypal_click'] = 'Profil Moodle';
$string['paypal_desc'] = '{$a->url} pour les détails (car en tant qu\'individu, je ne peux donc pas avoir le bouton « Achetez maintenant ») ou&nbsp;';
$string['peakmem'] = 'Pic de mémoire';
$string['perfinfo'] = 'Mode d\'indications de performance';
$string['perfinfodesc'] = 'De nombreux sites n\'ont pas besoin d\'indications de performance entièrement détaillées. Surtout vu du côté utilisateurs. Lorsqu\'il est activé, il montre un formulaire simplifié avec des informations de base de chargement de la page.';
$string['perfinfoheading'] = 'Information de performance';
$string['perf_max'] = 'Détaillé';
$string['perf_min'] = 'Minimal';
$string['pinterest'] = 'Pinterest';
$string['pinterestdesc'] = 'Entrez l\'URL de votre page Pinterest. (ex. http://pinterest.com/mycollege)';
$string['pinteresturl'] = 'URL Pinterest';
$string['pluginname'] = 'Essential';
$string['preferencesmi'] = 'Préferences';
$string['preferencesmidesc'] = 'Affiche l\'élément de menu Préférences.';
$string['previoussection'] = 'Section précédente';
$string['privacy:metadata:preference:courseitemsearchtype'] = 'Le choix des utilisateurs pour la recherche de cours (\'Nom complet du cours\'-\'0\' ou \'Tout le contenu du cours\' - \'1\') a été coché. Si rien n\'est indiqué, la recherche de cours est désactivée ou l\'utilisateur n\'a jamais vu le tableau de bord lorsqu\'il était allumé.';
$string['privacy:request:preference:courseitemsearchtype'] = 'L\'utilisateur a choisi "{$a->value}" pour la préférence utilisateur de recherche dans le cours "{$a->name}" où \'0\' est \'nom complet du cours\' et \'1\' est \'tout le contenu du cours\'.';
$string['privatefilesmi'] = 'Fichiers privés';
$string['privatefilesmidesc'] = 'Affiche l\'élément de menu Fichiers privés si l\'utilisateur a la capacité \'moodle/user:manageownfiles\'.';
$string['profilebarcustomtitle'] = 'Titre du bloc personnalisé de la barre de profil';
$string['profilebarcustomtitledesc'] = 'Titre du bloc personnalisé de la barre de profil';
$string['profilelinkmi'] = 'Lien vers le profil';
$string['profilelinkmidesc'] = 'Affiche l\'élément de menu Lien vers le profil.';
$string['properties'] = 'Propriétés';
$string['propertiesdesc'] = 'Liste des propriétés.';
$string['propertiesexport'] = 'Exporter les propriétés comme chaîne JSON';
$string['propertiesproperty'] = 'Propriété';
$string['propertiesreturn'] = 'Revenir';
$string['propertiessub'] = 'Les propriétés';
$string['propertiesvalue'] = 'Valeur';
$string['putpropertiesadded'] = 'Ajouté :';
$string['putpropertieschanged'] = 'Modifié :';
$string['putpropertiesdesc'] = 'Collez la chaîne JSON et \'Enregistrer les modifications\'. Attention ! Cela ne valide pas les valeurs des réglages et vous devez effectuer un \'Purger tous les caches\'.';
$string['putpropertiesfrom'] = 'de';
$string['putpropertiesignorecti'] = 'Ignorer tous les paramètres d\'image de titre du cours.';
$string['putpropertiesignored'] = 'Ignoré :';
$string['putpropertiessettingsreport'] = 'Rapport de paramétrage :';
$string['putpropertiesunchanged'] = 'Inchangé :';
$string['putpropertiesvalue'] = '->';
$string['putpropertyour'] = 'Notre';
$string['putpropertyproperties'] = 'Propriétés';
$string['putpropertyreport'] = 'Rapport :';
$string['putpropertyversion'] = 'version :';
$string['readme_click'] = 'cliquer pour obtenir le fichier README.txt';
$string['readme_desc'] = 'Veuillez {$a->url} qui contient plus d\'informations sur le thème Essential, dont la personnalisation.';
$string['readme_title'] = 'Lisez-moi Essential.';
$string['readmore'] = 'Lire la suite';
$string['region-footer-left'] = 'Pied de page (gauche)';
$string['region-footer-middle'] = 'Pied de page (centre)';
$string['region-footer-right'] = 'Pied de page (droite)';
$string['region-header'] = 'En-tête';
$string['region-hidden-dock'] = 'Caché aux utilisateurs';
$string['region-home'] = 'Accueil';
$string['region-page-top'] = 'Haut de page';
$string['region-side-post'] = 'Droite';
$string['region-side-pre'] = 'Gauche';
$string['returntosection'] = 'Revenir à {$a->section}';
$string['returntosectionfeature'] = 'Revenir à la section';
$string['returntosectionfeaturedesc'] = 'Active la fonctionnalité "Revenir à la section" au sein des modules de cours.';
$string['returntosectiontextlimitfeature'] = 'Longueur de texte pour "Revenir à la section"';
$string['returntosectiontextlimitfeaturedesc'] = 'Longueur maximale pour le nom de la section sur le bouton entre {$a->lower} et {$a->upper} caractères.';
$string['right'] = 'Droite';
$string['searchallcoursecontent'] = 'Chercher dans tous les contenus de cours';
$string['searchallcoursecontentdefault'] = 'Recherche par défaut de tous les contenus de cours';
$string['searchallcoursecontentdefaultdesc'] = 'Définit la valeur de la case à cocher \'Rechercher dans tout le contenu du cours\' dans la recherche du contenu du cours. Si l\'option \'Rechercher dans tout le contenu du cours\' est cochée, seul le nom complet du cours est recherché.';
$string['searchallcoursecontentenable'] = 'Activer la recherche sur tout le contenu du cours';
$string['searchallcoursecontentenabledesc'] = 'Permettre à l\'utilisateur de décider s\'il souhaite effectuer une recherche dans tout le contenu du cours. Si cette option est désactivée, la valeur de \'searchallcoursecontentdefault\' sera appliquée pour la recherche de cours.';
$string['serverload'] = 'Charge du serveur';
$string['sessionsize'] = 'Taille de la session';
$string['shortname'] = 'Nom court du site';
$string['shortnamesummary'] = 'Nom court et résumé';
$string['siteicon'] = 'Icône du site';
$string['siteicondesc'] = 'Vous n\'avez pas de logo ? Entrez le nom de l\'icône que vous souhaitez utiliser. La liste est <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">ici</a>. Il suffit d\'entrer ce qui est après "fa-".';
$string['skype'] = 'Compte Skype';
$string['skypedesc'] = 'Entrez le nom d\'utilisateur Skype du compte de votre organisation';
$string['skypeuri'] = 'URI du compte Skype';
$string['slidebuttoncolor'] = 'Couleur du bouton du diaporama';
$string['slidebuttoncolordesc'] = 'Couleur du bouton de la diapo « En savoir plus »';
$string['slidebuttonhovercolor'] = 'Couleur du bouton de diapositive';
$string['slidebuttonhovercolordesc'] = 'La couleur que devrait avoir le bouton de navigation de diapositive au survol.';
$string['slidecaption'] = 'Légende de diapositive';
$string['slidecaptionbackgroundcolor'] = 'Couleur de fond des légendes des diapositives';
$string['slidecaptionbackgroundcolordesc'] = 'La couleur que devrait avoir le fond des légendes des diapositives. Ne s\'applique pas à l\'option légende de la diapositive "A côté"';
$string['slidecaptionbelow'] = 'Légende de la diapositive sous l\'image';
$string['slidecaptionbelowdesc'] = 'Indique si la légende de la diapositive doit être sous l\'image';
$string['slidecaptionbeside'] = 'À côté';
$string['slidecaptioncentred'] = 'Légende de la diapositive centrée';
$string['slidecaptioncentreddesc'] = 'Si la légende de la diapositive devrait être centrée';
$string['slidecaptiondesc'] = 'Entrez le texte de la légende à utiliser pour la première diapositive';
$string['slidecaptionontop'] = 'En haut';
$string['slidecaptionoptions'] = 'Options des légendes de diapositive';
$string['slidecaptionoptionsdesc'] = 'Où les légendes devraient apparaître autour de l\'image';
$string['slidecaptiontextcolor'] = 'Couleur du texte des légendes des diapositives';
$string['slidecaptiontextcolordesc'] = 'La couleur que devrait avoir le texte des légendes des diapositives. Ne s\'applique pas à l\'option légende de la diapositive "A côté"';
$string['slidecaptionunderneath'] = 'En dessous';
$string['slidecolor'] = 'Couleur du texte du diaporama';
$string['slidecolordesc'] = 'Quelle couleur devrait avoir le texte principal sur le côté.';
$string['slideimage'] = 'Image de la diapositive';
$string['slideimagedesc'] = 'L\'image s\'affiche mieux si elle est transparente. (Les dimensions de l\'image devraient être de 256 px par 256 px)';
$string['slideinterval'] = 'Intervalle entre les diapositives';
$string['slideintervaldesc'] = 'Intervalle de transition des diapositives en millisecondes.';
$string['slideno'] = 'Diapositive {$a->slide}';
$string['slidenodesc'] = 'Entrez les paramètres de la diapositive {$a->slide}.';
$string['slideshowdesc'] = 'Ceci crée un diaporama dynamique avec jusqu\'à seize diapositives pour vous permettre de promouvoir des éléments importants de votre site. Le diaporama est adaptatif par le fait que la hauteur d\'image se règle selon la taille de l\'écran. La hauteur recommandée est de 300px. La largeur est fixée à 100% et donc la hauteur réelle sera plus faible si la largeur est supérieure à la taille de l\'écran. Avec les petites tailles d\'écran la hauteur est réduite dynamiquement sans la nécessité de fournir des images séparées. Pour des largeurs d\'écran <= 767px 165px de hauteur, largeur entre 768px et 979px 225px = hauteur et la largeur> = 980px 300px de hauteur. Si aucune image n\'est sélectionnée pour une diapositive, alors l\'image par défaut dans le dossier pix est utilisée.';
$string['slideshowheading'] = 'Diaporama de la page d\'accueil';
$string['slideshowheadingsub'] = 'Diaporama dynamique pour la page d\'accueil';
$string['slidetitle'] = 'Titre de la diapositive';
$string['slidetitledesc'] = 'Entrez un titre descriptif pour votre diapositive';
$string['slideurl'] = 'Lien de la diapositive';
$string['slideurldesc'] = 'Entrez la cible du lien de l\'image de la première diapositive';
$string['slideurltarget'] = 'Cible du lien';
$string['slideurltargetdesc'] = 'Choisissez comment le lien doit être ouvert';
$string['slideurltargetnew'] = 'Nouvelle page';
$string['slideurltargetparent'] = 'Cadre parent';
$string['slideurltargetself'] = 'Page actuelle';
$string['socialdesc'] = 'Fournir des liens directs vers les réseaux sociaux essentiels qui font de la publicité pour votre site. Ceux-ci apparaissent dans l\'en-tête de chaque page.';
$string['socialheading'] = 'Réseautage social';
$string['socialheadingsub'] = 'Motivez vos utilisateurs avec les réseaux sociaux';
$string['socialnetworks'] = 'Réseaux sociaux';
$string['sponsor_desc'] = 'Merci de sponsoriser Essential via Paypal ou en me contactant via mon&nbsp;';
$string['sponsor_desc2'] = '&nbsp;pour la poursuite du développement de Essential ou simplement pour exprimer votre gratitude.';
$string['sponsor_title'] = 'Sponsoriser Essential';
$string['stylecover'] = 'Couverture';
$string['stylefixed'] = 'Fixé';
$string['styleguide'] = 'Guide de style';
$string['styleguidedesc'] = 'Code de documentation original sous licence "{$a->origcodelicenseurl}".  Holder.js est sous licence "{$a->holderlicenseurl}". Le code additionnel est sous licence "{$a->thiscodelicenseurl}", qui est une licence "{$a->compatible}". Le contenu est sous licence "{$a->contentlicenseurl}". La mise en forme de cette documentation pour Moodle a été faite avec l\'ajout d\'icônes FontAwesome si nécessaire. Des paramètres CSS additionnels se trouvent dans le fichier "essential_admin_setting_styleguide.php" sous le commentaire "// Beyond docs.css". La section "{$a->globalsettings}" a été retirée.';
$string['styleguidesub'] = 'Guide de style Bootstrap V2.3.2';
$string['stylestretch'] = 'Étendue';
$string['styletiled'] = 'Mosaïque';
$string['switchrolemi'] = 'Prendre le rôle';
$string['switchrolemidesc'] = 'Affiche l\'élément de menu Prendre le rôle si l\'utilisateur a la capacité de prendre d\'autres rôles.';
$string['tallyinoftotal'] = '{$a->rtally} dans {$a->ctally} de {$a->ctotal}';
$string['tallyoftotal'] = '{$a->tally} de {$a->total}';
$string['themecolor'] = 'Couleur du thème';
$string['themecolordesc'] = 'La couleur que votre thème devrait avoir. Ceci va changer de multiples composants pour produire la couleur que vous souhaitez sur le site Moodle';
$string['themecolors'] = 'Couleurs du thème';
$string['themedefaultbuttonbackgroundcolour'] = 'Couleur par défaut du fond des boutons';
$string['themedefaultbuttonbackgroundcolourdesc'] = 'Définissez la couleur par défaut du fond des boutons';
$string['themedefaultbuttonbackgroundhovercolour'] = 'Couleur par défaut pour le survol du fond des boutons';
$string['themedefaultbuttonbackgroundhovercolourdesc'] = 'Définissez la couleur par défaut pour le survol du fond des boutons';
$string['themedefaultbuttontextcolour'] = 'Couleur par défaut du texte des boutons';
$string['themedefaultbuttontextcolourdesc'] = 'Définissez la couleur par défaut du texte des boutons';
$string['themedefaultbuttontexthovercolour'] = 'Couleur par défaut pour le survol du texte des boutons';
$string['themedefaultbuttontexthovercolourdesc'] = 'Définissez la couleur par défaut pour le survol du texte des boutons';
$string['themehovercolor'] = 'Couleur de survol du thème';
$string['themehovercolordesc'] = 'La couleur que prennent les éléments survolés sur votre site. Ceci concerne les liens, les menus, etc.';
$string['themeiconcolor'] = 'Couleur d\'icône';
$string['themeiconcolordesc'] = 'Définir la couleur pour toutes les icônes';
$string['themenavcolor'] = 'Couleur de la navigation';
$string['themenavcolordesc'] = 'Définissez la couleur pour la navigation.  En l\'occurrence la barre de menus et le style fantaisie du fil d\'Ariane.';
$string['themequizsubmitbackgroundcolour'] = 'Quiz Couleur de fond de \'Soumettre tout et terminer\'';
$string['themequizsubmitbackgroundcolourdesc'] = 'Quiz Définir la couleur de fond pour le bouton \'Soumettre tout et terminer\'.';
$string['themequizsubmitbackgroundhovercolour'] = 'Quiz Couleur au survol de \'Soumettre tout et terminer\'';
$string['themequizsubmitbackgroundhovercolourdesc'] = 'Quiz Définissez la couleur de survol de l\'arrière-plan pour le bouton \'Soumettre tout et terminer\'.';
$string['themequizsubmittextcolour'] = 'Quiz Couleur du texte \'Soumettre tout et terminer\'';
$string['themequizsubmittextcolourdesc'] = 'Définissez la couleur du texte pour le bouton \'Soumettre tout et terminer\'.';
$string['themequizsubmittexthovercolour'] = 'Quiz Couleur de survol du texte \'Soumettre tout et terminer\'';
$string['themequizsubmittexthovercolourdesc'] = 'Définissez la couleur de survol du texte pour le bouton \'Soumettre tout et terminer\'.';
$string['themesidepreblockbackgroundcolour'] = 'Couleur d\'arrière plan du bloc \'side-pre\'';
$string['themesidepreblockbackgroundcolourdesc'] = 'Définissez la couleur d\'arrière plan du bloc \'side-pre\'.';
$string['themesidepreblockhovercolour'] = 'Couleur au survol de l\'arrière-plan du lien du bloc \'side-pre\'';
$string['themesidepreblockhovercolourdesc'] = 'Définissez la couleur au survol de l\'arrière-plan du lien du bloc \'side-pre\'.';
$string['themesidepreblocktextcolour'] = 'Couleur de texte du bloc \'side-pre\'';
$string['themesidepreblocktextcolourdesc'] = 'Définissez la couleur du texte pour le bloc \'side-pre\'.';
$string['themesidepreblockurlcolour'] = 'Couleur du lien du bloc \'side-pre\'';
$string['themesidepreblockurlcolourdesc'] = 'Définissez la couleur du lien du bloc \'side-pre\'.';
$string['themestripebackgroundcolour'] = 'Couleur inverse d\'arrière-plan';
$string['themestripebackgroundcolourdesc'] = 'Définissez la couleur d\'arrière-plan des bandes inversées dans les tableaux.';
$string['themestripetextcolour'] = 'Couleur inverse du texte';
$string['themestripetextcolourdesc'] = 'Définissez la couleur du texte des bandes inversées dans les tableaux.';
$string['themestripeurlcolour'] = 'Couleur inverse des URL';
$string['themestripeurlcolourdesc'] = 'Définissez la couleur des URL des bandes inversées dans les tableaux.';
$string['themetextcolor'] = 'Couleur du texte';
$string['themetextcolordesc'] = 'Définissez la couleur de votre texte.';
$string['themeurlcolor'] = 'Couleur du lien';
$string['themeurlcolordesc'] = 'Définissez la couleur de votre lien textuel.';
$string['thiscourse'] = 'Ce cours';
$string['togglemarketing'] = 'Bascule de l\'affichage des annonces marketing';
$string['togglemarketingdesc'] = 'Choisissez si vous souhaitez afficher ou masquer les trois annonces marketing.';
$string['toggleslideshow'] = 'Bascule de l\'affichage du diaporama';
$string['toggleslideshowdesc'] = 'Choisissez si vous souhaitez afficher ou masquer le diaporama.';
$string['twitter'] = 'Twitter';
$string['twitterdesc'] = 'Entrez l\'URL de votre flux Twitter. (ex. http://www.twitter.com/mycollege)';
$string['twitterurl'] = 'URL Twitter';
$string['userimageborderradius'] = 'Rayon de la bordure de la photo utilisateur';
$string['userimageborderradiusdesc'] = 'Spécifiez le rayon de la bordure entre {$a->lower} et {$a->upper} pixels de l\'image de l\'utilisateur sur le site, à l\'exception de l\'en-tête qui utilise le paramètre \'usermenuuserimageborderradius\'.';
$string['usermenu'] = 'Menu utilisateur';
$string['usermenudesc'] = 'Le menu de l\'utilisateur';
$string['usermenuuserimageborderradius'] = 'Rayon de l\'image du menu utilisateur';
$string['usermenuuserimageborderradiusdesc'] = 'Spécifiez le rayon de la bordure entre {$a->lower} et {$a->upper} pixels de l\'image utilisateur dans le menu utilisateur.';
$string['usersettingstitle'] = 'Paramètres utilisateur';
$string['usesiteicon'] = 'Utilise une icône de site';
$string['usesiteicondesc'] = 'Utilise l\'icône du site s\'il n\'y a pas de logo.';
$string['variablewidth'] = 'Largeur variable';
$string['versionalerttext1'] = 'Thème non prévu pour cette version de Moodle.';
$string['versionalerttext2'] = 'Des problèmes inattendus peuvent apparaître ; merci d\'installer la version du thème correcte pour votre version de Moodle.';
$string['versionalerttitle'] = 'Attention à la version :';
$string['visibleadminonly'] = 'Les blocs déplacés dans la zone ci-dessous ne seront visibles que par les administrateurs';
$string['vk'] = 'VKontakte';
$string['vkdesc'] = 'Entrez l\'URL de la page Vkontakte. (ex. http://www.vk.com/mycollege)';
$string['vkurl'] = 'URL VKontakte';
$string['website'] = 'Site Web';
$string['websitedesc'] = 'Entrez l\'URL de votre propre site. (ex. http://www.pukunui.com)';
$string['websiteurl'] = 'URL du site web';
$string['windows'] = 'Bureau Windows';
$string['windowsdesc'] = 'Fournissez une URL vers votre application mobile sur Windows Store. Si vous n\'en disposez pas, vous pouvez peut-être envisager de faire un lien vers l\'application officielle Moodle Mobile. (http://apps.microsoft.com/windows/en-us/app/9df51338-015c-41b7-8a85-db2fdfb870bc)';
$string['windowsurl'] = 'URL du bureau Windows';
$string['winphone'] = 'Windows Mobile';
$string['winphonedesc'] = 'Fournissez une URL vers votre application mobile sur Windows Store. Si vous n\'en disposez pas, vous pouvez peut-être envisager de faire un lien vers l\'application officielle  (http://www.windowsphone.com/en-us/store/app/moodlemobile/d0732b88-3c6d-4127-8f24-3fca2452a4dc)';
$string['winphoneurl'] = 'URL Windows Mobile';
$string['youtube'] = 'Youtube';
$string['youtubedesc'] = 'Entrez l\'URL de votre chaîne YouTube. (ex. http://www.youtube.com/mycollege)';
$string['youtubeurl'] = 'URL Youtube';
