<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'lesson', language 'fr', branch 'MOODLE_36_STABLE'
 *
 * @package   lesson
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accesscontrol'] = 'Contrôle d\'accès';
$string['actionaftercorrectanswer'] = 'Action après réponse correcte';
$string['actionaftercorrectanswer_help'] = 'Après une réponse correcte, il y a 3 possibilités pour la page suivante :

* Normale : suivre la leçon dans l\'ordre logique
* Afficher une page non vue : les pages sont affichées aléatoirement sans qu\'aucune page ne soit affichée deux fois
* Afficher une page sans réponse : les pages sont affichées aléatoirement, certaines pages déjà vues par l\'étudiant lui étant montrée une nouvelle fois, s\'il n\'y a pas répondu ou s\'il y a répondu incorrectement';
$string['actions'] = 'Actions';
$string['activitylink'] = 'Lien vers l\'activité suivante';
$string['activitylink_help'] = 'Afin de fournir un lien vers une autre activité de cours au terme de la leçon, choisissez une activité dans le menu déroulant.';
$string['activitylinkname'] = 'Allez à {$a}';
$string['activityoverview'] = 'Vous avez des leçons à terminer';
$string['addabranchtable'] = 'Ajouter une page de contenu';
$string['addanendofbranch'] = 'Ajouter une fin de branchement';
$string['addanewpage'] = 'Ajouter une page';
$string['addaquestionpage'] = 'Ajouter une page question';
$string['addaquestionpagehere'] = 'Ajouter une page question ici';
$string['addbranchtable'] = 'Ajouter une page de contenu';
$string['addcluster'] = 'Ajouter un groupe';
$string['addedabranchtable'] = 'Page de contenu ajoutée';
$string['addedanendofbranch'] = 'Fin de branchement ajoutée';
$string['addedaquestionpage'] = 'Page question ajoutée';
$string['addedcluster'] = 'Groupe ajouté';
$string['addedendofcluster'] = 'Fin de groupe ajoutée';
$string['addendofbranch'] = 'Ajouter une fin de branchement';
$string['addendofcluster'] = 'Ajouter une fin de groupe';
$string['addessay'] = 'Créer une page de question composition';
$string['additionalattemptsremaining'] = 'Terminé. Vous pouvez refaire cette leçon';
$string['addmatching'] = 'Créer une page Question d\'appariement';
$string['addmultichoice'] = 'Créer un page Question à choix multiples';
$string['addnewgroupoverride'] = 'Ajouter une dérogation de groupe';
$string['addnewuseroverride'] = 'Ajouter une dérogation d\'utilisateur';
$string['addnumerical'] = 'Créer une page Question numérique';
$string['addpage'] = 'Ajouter une page';
$string['addshortanswer'] = 'Créer une page Question à réponse courte';
$string['addtruefalse'] = 'Créer une page Question vrai/faux';
$string['allowofflineattempts'] = 'Permettre de tenter la leçon hors ligne au moyen de l\'app mobile';
$string['allowofflineattempts_help'] = 'Si ce réglage est activé, l\'utilisateur d\'une app mobile peut télécharger la leçon et l\'effectuer hors ligne.
Toutes les réponses possibles et les réponses correctes seront aussi téléchargées.
Remarque : il n\'est pas possible d\'effectuer hors ligne une leçon assortie d\'une limite de temps.';
$string['anchortitle'] = 'Début du contenu principal';
$string['and'] = 'ET';
$string['answer'] = 'Réponse';
$string['answeredcorrectly'] = 'répondu correctement.';
$string['answersfornumerical'] = 'Les réponses aux questions numériques doivent être constituées d\'une valeur minimale et d\'une valeur maximale.';
$string['arrangebuttonshorizontally'] = 'Arranger horizontalement les boutons de contenu ?';
$string['attempt'] = 'Tentative : {$a}';
$string['attemptheader'] = 'Tentative';
$string['attempts'] = 'Tentatives';
$string['attemptsdeleted'] = 'Tentatives supprimées';
$string['attemptsremaining'] = 'Il vous reste {$a} tentative(s)';
$string['available'] = 'Disponible dès le';
$string['averagescore'] = 'Note moyenne';
$string['averagetime'] = 'Durée moyenne';
$string['branch'] = 'Contenu';
$string['branchtable'] = 'Table de contenu';
$string['cancel'] = 'Annuler';
$string['cannotfindanswer'] = 'Erreur : impossible de trouver la réponse';
$string['cannotfindattempt'] = 'Erreur : impossible de trouver la tentative';
$string['cannotfindessay'] = 'Erreur : impossible de trouver la composition';
$string['cannotfindfirstgrade'] = 'Erreur : impossible de trouver les notes';
$string['cannotfindfirstpage'] = 'Impossible de trouver la première page';
$string['cannotfindgrade'] = 'Erreur : impossible de trouver les notes';
$string['cannotfindnewestgrade'] = 'Erreur : impossible de trouver la note la plus récente';
$string['cannotfindnextpage'] = 'Sauvegarde de la leçon : page suivante non trouvée !';
$string['cannotfindpagerecord'] = 'Ajout d\'un fin de branche : enregistrement de page non trouvé';
$string['cannotfindpages'] = 'Impossible de trouver les pages de la leçon';
$string['cannotfindpagetitle'] = 'Confirmation de suppression : titre de page non trouvé';
$string['cannotfindpreattempt'] = 'L\'enregistrement de la tentative précédente n\'a pas été trouvé !';
$string['cannotfindrecords'] = 'Erreur : impossible de trouver les enregistrements de la leçon';
$string['cannotfindtimer'] = 'Erreur : impossible de trouver les enregistrements de la table lesson_timer';
$string['cannotfinduser'] = 'Erreur : impossible de trouver les utilisateurs';
$string['canretake'] = '{$a} peut refaire la leçon';
$string['casesensitive'] = 'Utiliser les expressions régulières';
$string['casesensitive_help'] = 'Si ce réglage est activé, des expressions régulières peuvent être utilisées pour l\'analyse des réponses.';
$string['checkbranchtable'] = 'Vérifier la page de contenu';
$string['checkedthisone'] = 'Ont coché cette option.';
$string['checknavigation'] = 'Vérifier la navigation';
$string['checkquestion'] = 'Vérifier la question';
$string['classstats'] = 'Statistique de classe';
$string['clicktodownload'] = 'Cliquer sur le lien ci-dessous pour télécharger le fichier.';
$string['closebeforeopen'] = 'Impossible de modifier la leçon. Vous avez indiqué une date de fermeture antérieure à la date d\'ouverture.';
$string['cluster'] = 'Groupe';
$string['clusterjump'] = 'Question non vue du groupe';
$string['clustertitle'] = 'Groupe';
$string['collapsed'] = 'Replié';
$string['comments'] = 'Vos commentaires';
$string['completed'] = 'Terminé';
$string['completederror'] = 'Terminer la leçon';
$string['completethefollowingconditions'] = 'Vous devez remplir la (les) condition(s) suivante(s) dans la leçon <b>{$a}</b> avant de continuer.';
$string['completionendreached'] = 'Exiger d\'atteindre la fin';
$string['completionendreached_desc'] = 'Si ce réglage est activé, les étudiants doivent atteindre la page de fin de la leçon pour terminer cette activité';
$string['completiontimespent'] = 'Les étudiants doivent faire cette activité au moins durant';
$string['completiontimespentdesc'] = 'L\'étudiant doit travailler sur cette activité durant au moins {$a}';
$string['completiontimespentgroup'] = 'Exiger une durée minimale';
$string['conditionsfordependency'] = 'Condition(s) de dépendance';
$string['configintro'] = 'Les données saisies ici définissent les valeurs par défaut utilisées dans la configuration d\'une nouvelle activité Leçon. Les réglages indiqués comme avancés ne sont affichés que le lien « Afficher plus » est cliqué.';
$string['configmaxanswers'] = 'Nombre maximal par défaut de réponses par page';
$string['configmediaclose'] = 'Afficher un bouton fermer dans la fenêtre surgissante créée pour un fichier média lié';
$string['configmediaheight'] = 'Hauteur de la fenêtre affichée pour un fichier média lié';
$string['configmediawidth'] = 'Largeur de la fenêtre affichée pour un fichier média lié';
$string['configpassword_desc'] = 'Détermine si un mot de passe est requis pour accéder à la leçon.';
$string['configslideshowbgcolor'] = 'Couleur de fond du diaporama';
$string['configslideshowheight'] = 'Hauteur du slideshow';
$string['configslideshowwidth'] = 'Largeur du slideshow';
$string['configtimelimit_desc'] = 'Si une limite de temps est fixée, un avertissement est affiché au début de la leçon et un compte à rebours est affiché. Une valeur 0 signifie une durée illimitée.';
$string['confirmdelete'] = 'Supprimer la page';
$string['confirmdeletionofthispage'] = 'Voulez-vous vraiment supprimer cette page ?';
$string['congratulations'] = 'Félicitations - la leçon est terminée';
$string['continue'] = 'Continuer';
$string['continuetoanswer'] = 'Continuer pour modifier les réponses.';
$string['continuetonextpage'] = 'Continuer vers la page suivante.';
$string['correctanswerjump'] = 'Lien après réponse correcte';
$string['correctanswerscore'] = 'Score des réponses correctes';
$string['correctresponse'] = 'Feedback réponse correcte';
$string['createaquestionpage'] = 'Créer une page question';
$string['credit'] = 'Crédit';
$string['customscoring'] = 'Score personnalisé';
$string['customscoring_help'] = 'Si cette option est activée, une valeur numérique négative ou positive peut être attribuée à chaque réponse.';
$string['deadline'] = 'À faire jusqu\'au';
$string['defaultessayresponse'] = 'Votre composition sera évaluée par votre enseignant.';
$string['deleteallattempts'] = 'Supprimer toutes les tentatives des leçons';
$string['deletedefaults'] = 'Leçon par défaut {$a} x supprimée';
$string['deletedpage'] = 'Page supprimée';
$string['deletepagenamed'] = 'Supprimer la page {$a}';
$string['deleting'] = 'En cours de suppression';
$string['deletingpage'] = 'Suppression de la page ? {$a}';
$string['dependencyon'] = 'Dépend de';
$string['dependencyon_help'] = 'Grâce à ce réglage, l\'accès à cette leçon peut dépendre des résultats de l\'étudiant à d\'autres leçons dans le même cours. Il est possible de combiner les critères « durée utilisée », « terminé » ou « note plus haute que ».';
$string['description'] = 'Description';
$string['detailedstats'] = 'Statistiques détaillées';
$string['didnotanswerquestion'] = 'N\'a pas répondu à cette question';
$string['didnotreceivecredit'] = 'N\'a pas reçu de point';
$string['disabled'] = 'Désactivée';
$string['displaydefaultfeedback'] = 'Utiliser le feedback par défaut';
$string['displaydefaultfeedback_help'] = 'Si ce réglage est activé, un feedback par défaut est affiché lorsqu\'aucun autre n\'a été défini spécifiquement. Les feedbacks par défaut sont « C\'est une réponse correcte » et « C\'est une mauvaise réponse ».';
$string['displayinleftmenu'] = 'Afficher dans le menu ?';
$string['displayleftif'] = 'Note minimale pour afficher le menu';
$string['displayleftif_help'] = 'Ce réglage détermine si un participant doit obtenir une note minimale pour que le menu de la leçon soit affiché. Ceci impose au participant de parcourir la totalité de la leçon lors de sa première tentative, puis lui permet d\'utiliser le menu pour sa relecture, s\'il a obtenu la note requise.';
$string['displayleftmenu'] = 'Afficher le menu';
$string['displayleftmenu_help'] = 'Si ce réglage est activé, un menu est affiché, permettant aux utilisateurs de parcourir les pages de la leçon.';
$string['displayofgrade'] = 'Affichage de la note (pour l\'étudiant)';
$string['displayreview'] = 'Offrir la possibilité de refaire une question';
$string['displayreview_help'] = 'Si cette option est activée, lorsqu\'une question reçoit une réponse incorrecte, l\'étudiant a la possibilité de corriger celle-ci (sans obtenir de point) ou de continuer la leçon.';
$string['displayscorewithessays'] = '<p>Vous avez obtenu un score de {$a->score} sur {$a->tempmaxgrade} aux questions notées automatiquement.</p>
<p>Les notes de votre(vos) {$a->essayquestions} composition(s) sera(ont) évaluée(s) et ajoutée(s) au score final ultérieurement.</p>
<p>Votre note actuelle, sans la(les) composition(s), est de {$a->score} sur {$a->grade}.</p>';
$string['displayscorewithoutessays'] = 'Votre score est de {$a->score} (sur {$a->grade}).';
$string['duplicatepagenamed'] = 'Dupliquer la page : {$a}';
$string['edit'] = 'Modifier';
$string['editbranchtable'] = 'Modification d\'une page de contenu';
$string['editcluster'] = 'Modification d\'un groupe';
$string['editendofbranch'] = 'Modification d\'une page fin de branchement';
$string['editendofcluster'] = 'Modification d\'une page de fin de groupe';
$string['editessay'] = 'Modification d\'une page Question de composition';
$string['editingquestionpage'] = 'Modification de la page de question {$a}';
$string['editlessonsettings'] = 'Modifier les réglages de la leçon';
$string['editmatching'] = 'Modification d\'une page Question de correspondance';
$string['editmultichoice'] = 'Modification d\'une page Question à choix multiples';
$string['editnumerical'] = 'Modification d\'une page Question numérique';
$string['editoverride'] = 'Modifier une dérogation';
$string['editpage'] = 'Modifier le contenu de la page';
$string['editpagecontent'] = 'Modifier le contenu de la page';
$string['editquestion'] = 'Modification d\'une page de question';
$string['editshortanswer'] = 'Modification d\'une page Question à réponse courte';
$string['edittruefalse'] = 'Modification d\'une page Question vrai/faux';
$string['email'] = 'Courriel';
$string['emailallgradedessays'] = 'Envoyer par courriel TOUTES les compositions évaluées';
$string['emailgradedessays'] = 'Envoyer par courriel les compositions évaluées';
$string['emailsuccess'] = 'Envoi effectué avec succès';
$string['emptypassword'] = 'Le mot de passe ne peut pas être vide';
$string['enabled'] = 'Activée';
$string['endofbranch'] = 'Fin de branchement';
$string['endofcluster'] = 'Fin du groupe';
$string['endofclustertitle'] = 'Fin de groupe';
$string['endoflesson'] = 'Fin de la leçon';
$string['enteredthis'] = 'a saisi ceci.';
$string['enterpassword'] = 'Veuillez saisir le mot de passe :';
$string['eolstudentoutoftime'] = 'Attention : le temps à votre disposition pour cette leçon est échu. Votre dernière réponse ne sera pas prise en compte si elle est survenue après l\'échéance.';
$string['eolstudentoutoftimenoanswers'] = 'vous n\'avez répondu à aucune question. Votre note pour cette leçon est de 0.';
$string['essay'] = 'Composition';
$string['essayemailmessage2'] = '<p>Question ouverte : {$a->question}</p><p>Votre réponse : <em>{$a->response}</em></p><p>Commentaire de l\'évaluateur : <em>{$a->comment}</em></p><p>Vous avez obtenu {$a->earned} points sur un total de {$a->outof} à cette question ouverte.</p><p>Votre note pour cette leçon est maintenant {$a->newgrade} %.</p>';
$string['essayemailsubject'] = 'Note pour la question de leçon';
$string['essaynotgradedyet'] = 'La composition n\'a pas encore été évaluée';
$string['essayresponses'] = 'Compositions';
$string['essays'] = 'Compositions';
$string['essayscore'] = 'Score de votre composition';
$string['eventcontentpageviewed'] = 'Page consultée';
$string['eventessayassessed'] = 'Composition évaluée';
$string['eventessayattemptviewed'] = 'Composition consultée';
$string['eventlessonended'] = 'Leçon terminée';
$string['eventlessonrestarted'] = 'Leçon recommencée';
$string['eventlessonresumed'] = 'Leçon reprise';
$string['eventlessonstarted'] = 'Leçon commencée';
$string['eventoverridecreated'] = 'Dérogation de leçon créée';
$string['eventoverridedeleted'] = 'Dérogation de leçon supprimée';
$string['eventoverrideupdated'] = 'Dérogation de leçon modifiée';
$string['eventpagecreated'] = 'Page créée';
$string['eventpagedeleted'] = 'Page supprimée';
$string['eventpagemoved'] = 'Page déplacée';
$string['eventpageupdated'] = 'Page modifiée';
$string['eventquestionanswered'] = 'Question répondue';
$string['eventquestionviewed'] = 'Question consultée';
$string['false'] = 'Faux';
$string['fileformat'] = 'Format de fichier';
$string['finalwrong'] = 'Pas tout à fait.';
$string['finish'] = 'Terminer';
$string['firstanswershould'] = 'La première réponse devrait toujours diriger vers la page « Réponse correcte »';
$string['firstwrong'] = 'Vous n\'avez pas répondu correctement. Voulez-vous essayer de deviner la bonne réponse ? Si vous répondez maintenant correctement, vous ne recevrez cependant pas de point.';
$string['flowcontrol'] = 'Contrôle du déroulement';
$string['fractionsaddwrong'] = 'La somme des notes positives que vous avez choisies n\'atteint pas 100%.<br />Elle est de {$a}%.<br />Souhaitez-vous revenir en arrière pour corriger cela ?';
$string['fractionsnomax'] = 'L\'une des propositions devrait avoir la note 100% afin qu\'il soit<br />possible d\'obtenir la note maximale à cette question.<br />Souhaitez-vous revenir en arrière pour corriger cela ?';
$string['full'] = 'Déplié';
$string['general'] = 'Général';
$string['gotoendoflesson'] = 'Aller à la fin de la leçon';
$string['grade'] = 'Note';
$string['gradebetterthan'] = 'Note supérieure à (&#37;)';
$string['gradebetterthanerror'] = 'Obtenir une note supérieure à {$a} pour-cents';
$string['graded'] = 'Noté';
$string['gradeessay'] = 'Évaluer les questions de composition ({$a->notgradedcount} sans note et {$a->notsentcount} pas envoyés)';
$string['gradeis'] = 'La note est {$a}';
$string['gradeoptions'] = 'Options des notes';
$string['groupoverrides'] = 'Dérogations de groupe';
$string['groupoverridesdeleted'] = 'Dérogations de groupe supprimées';
$string['groupsnone'] = 'Il n\'y a pas de groupe auquel vous pouvez accéder.';
$string['handlingofretakes'] = 'Traitement des différentes tentatives';
$string['handlingofretakes_help'] = 'Lorsque les étudiants ont la permission de répéter la leçon, ce réglage spécifie si la note de la leçon est la moyenne ou la note de la meilleure tentative.';
$string['havenotgradedyet'] = 'Pas encore été notée.';
$string['here'] = 'ici';
$string['highscore'] = 'Meilleure note';
$string['hightime'] = 'Plus longue durée';
$string['importcount'] = 'Importation de {$a} questions';
$string['importquestions'] = 'Importer des questions';
$string['importquestions_help'] = 'Cette fonctionnalité permet d\'importer des questions de divers formats à partir de fichiers texte.';
$string['inactiveoverridehelp'] = '* L\'étudiant n\'est pas dans le groupe correct ou n\'a pas le rôle adéquat pour consulter/effectuer la leçon, ou la leçon est cachée';
$string['indicator:cognitivedepth'] = 'Leçon : aspect cognitif';
$string['indicator:cognitivedepth_help'] = 'Cet indicateur est basé sur la profondeur cognitive atteinte par l\'étudiant dans une activité Leçon.';
$string['indicator:socialbreadth'] = 'Leçon : aspect social';
$string['indicator:socialbreadth_help'] = 'Cet indicateur se base sur l\'interaction sociale atteinte par l\'étudiant dans une activité Leçon.';
$string['insertedpage'] = 'Page insérée';
$string['invalidfile'] = 'Fichier non valide';
$string['invalidid'] = 'Aucun identifiant de cours ou de leçon n\'a été fourni';
$string['invalidlessonid'] = 'Identifiant de leçon non valide';
$string['invalidoverrideid'] = 'Identifiant de dérogation non valide';
$string['invalidpageid'] = 'Identifiant de page non valide';
$string['jump'] = 'Aller';
$string['jumps'] = 'Sauts';
$string['jumps_help'] = 'Chaque réponse (pour les questions) ou description (pour les pages de contenu) possède un lien correspondant. Ce lien peut être relatif, comme cette page ou la page suivante, ou absolu, en spécifiant une page de la leçon.';
$string['jumpsto'] = 'Saute vers <em>{$a}</em>';
$string['leftduringtimed'] = 'Vous avez quitté une leçon à durée limitée.<br />Veuillez cliquer sur Continuer pour recommencer cette leçon.';
$string['leftduringtimednoretake'] = 'Vous avez quitté une leçon à durée limitée et vous n\'êtes<br />pas autorisé à la recommencer ou la continuer.';
$string['leftduringtimedsession'] = 'Vous avez interrompu une leçon chronométrée.';
$string['lesson:addinstance'] = 'Ajouter une leçon';
$string['lessonclosed'] = 'Cette leçon n\'est plus disponible depuis {$a}.';
$string['lessoncloses'] = 'La leçon se termine';
$string['lessoncloseson'] = 'La leçon se termine le {$a}';
$string['lesson:edit'] = 'Modifier les activités leçon';
$string['lessoneventcloses'] = '{$a} se termine';
$string['lessoneventopens'] = '{$a} s\'ouvre';
$string['lessonformating'] = 'Format de la leçon';
$string['lesson:grade'] = 'Évaluer les questions de composition de leçons';
$string['lesson:manage'] = 'Gérer les activités leçon';
$string['lesson:manageoverrides'] = 'Gérer les dérogations de leçon';
$string['lessonmenu'] = 'Menu leçon';
$string['lessonname'] = 'Leçon : {$a}';
$string['lessonnotready'] = 'Cette leçon n\'est pas encore prête. Veuillez contacter votre {$a}.';
$string['lessonnotready2'] = 'Cette leçon n\'est pas encore prête.';
$string['lessonopen'] = 'Cette leçon sera ouverte le {$a}.';
$string['lessonopens'] = 'La leçon s\'ouvre';
$string['lessonpagelinkingbroken'] = 'La première page n\'a pas été trouvée. Les liens de la leçon sont vraisemblablement cassés. Veuillez contacter un administrateur.';
$string['lessonstats'] = 'Statistiques de la leçon';
$string['lesson:view'] = 'Consulter les activités leçon';
$string['lesson:viewreports'] = 'Consulter les rapports des leçons';
$string['linkedmedia'] = 'Médias liés';
$string['loginfail'] = 'Connexion échouée, veuillez réessayer…';
$string['lowscore'] = 'Note la plus basse';
$string['lowtime'] = 'Plus courte durée';
$string['manualgrading'] = 'Évaluer les compositions';
$string['matchesanswer'] = 'Correspond avec la réponse';
$string['matching'] = 'Correspondant';
$string['matchingpair'] = 'Paire correspondante {$a}';
$string['maxgrade'] = 'Note maximale';
$string['maxgrade_help'] = 'Ce réglage détermine la note maximale pouvant être accordée dans cette leçon. Si la valeur 0 est indiquée, la leçon n\'apparaîtra dans aucune des pages de notes.';
$string['maximumnumberofanswersbranches'] = 'Nombre maximal de réponses';
$string['maximumnumberofanswersbranches_help'] = 'Cette valeur détermine le nombre maximal de réponses utilisables dans la leçon. Si une leçon n\'utilise que des questions vrai/faux, elle peut être fixée à 2. Ce paramètre peut être modifié à tout moment, car il n\'a d\'effet que sur ce que voit l\'enseignant, pas sur les données.
';
$string['maximumnumberofattempts'] = 'Nombre maximal de tentatives';
$string['maximumnumberofattempts_help'] = 'Ce réglage fixe le nombre maximal de tentatives à disposition des étudiants pour répondre à chaque question. Si une réponse incorrecte est répétée, lorsque cette valeur est atteinte, la page suivante de la leçon est affichée.';
$string['maximumnumberofattemptsreached'] = 'Le nombre maximal de tentatives a été atteint - On passe à la page suivante';
$string['mediaclose'] = 'Afficher un bouton fermer';
$string['mediafile'] = 'Média lié';
$string['mediafile_help'] = 'Un fichier média peut être déposé pour utilisation dans la leçon. Dans ce cas, un bloc « Média lié » sera affiché sur chaque page de la leçon, comprenant un lien pour afficher ce fichier.';
$string['mediafilepopup'] = 'Cliquer ici pour afficher';
$string['mediaheight'] = 'Hauteur de la fenêtre surgissante';
$string['mediawidth'] = 'Largeur de la fenêtre surgissante';
$string['messageprovider:graded_essay'] = 'Notification d\'évaluation de composition de leçon';
$string['minimumnumberofquestions'] = 'Nombre minimal de questions';
$string['minimumnumberofquestions_help'] = 'Ce réglage détermine le nombre minimum de questions qui seront utilisées pour calculer la note de l\'activité.';
$string['missingname'] = 'Veuillez saisir un pseudo';
$string['modattempts'] = 'Permettre la relecture par les étudiants';
$string['modattempts_help'] = 'Si ce réglage est activé, les étudiants peuvent reprendre la leçon depuis le début.';
$string['modattemptsnoteacher'] = 'La critique par les étudiants ne fonctionne que pour les étudiants.';
$string['modulename'] = 'Leçon';
$string['modulename_help'] = 'Le module d\'activité leçon permet à l\'enseignant de proposer des contenus et/ou des activités d\'exercice d\'une façon intéressante et flexible.

Une leçon est créée par l\'enseignant et se compose de plusieurs pages qui chacune se termine normalement par une question et un choix de réponses. Les types de questions comprennent les questions à choix multiple, d\'appariement et à réponse courte. Selon la réponse du participant, la leçon peut se poursuivre par la page suivante ou par une autre page.

Une leçon peut si désiré être sanctionnée par une note. La note est alors enregistrée dans le carnet de notes.

Les leçons peuvent être utilisées :

* pour l\'apprentissage auto-géré d\'un nouveau sujet
* pour des simulations ou des jeux de rôles exerçant la prise de décision
* comme un moyen de profiter des différents styles d\'apprentissage, en offrant au participant une page vidéo, une page podcast ou une page de texte suivant sa préférence
* pour des supports de révision différenciés, avec plusieurs jeux de questions de révision suivant les réponses précédemment données';
$string['modulenameplural'] = 'Leçons';
$string['move'] = 'Déplacer la page';
$string['movedpage'] = 'Page déplacée';
$string['movepagehere'] = 'Déplacer la page ici';
$string['movepagenamed'] = 'Déplacer la page {$a}';
$string['moving'] = 'Déplacement de la page : {$a}';
$string['multianswer'] = 'Plusieurs réponses';
$string['multianswer_help'] = 'Veuillez cocher cette option si toutes les réponses correctes dans l\'ensemble proposé doivent être indiquées.';
$string['multichoice'] = 'Choix multiple';
$string['multipleanswer'] = 'Réponses multiples';
$string['nameapproved'] = 'Nom approuvé';
$string['namereject'] = 'Désolé, votre nom a été rejeté par le filtre.<br />Veuillez essayer un autre nom.';
$string['new'] = 'Nouveau';
$string['nextpage'] = 'Page suivante';
$string['noanswer'] = 'Une ou plusieurs questions n\'ont pas de réponse donnée. Veuillez revenir en arrière et donner une réponse.';
$string['noattemptrecordsfound'] = 'Aucune tentative trouvée : pas de note';
$string['nobranchtablefound'] = 'Aucune page de contenu';
$string['noclose'] = 'Pas de date de fermeture';
$string['nocommentyet'] = 'Pas encore de commentaire.';
$string['nocoursemods'] = 'Aucune activité trouvée';
$string['nocredit'] = 'Pas de crédit';
$string['nodeadline'] = 'Pas d\'échéance';
$string['noessayquestionsfound'] = 'Il n\'y a pas de question de composition dans cette leçon.';
$string['nohighscores'] = 'Pas de meilleur résultat';
$string['nolessonattempts'] = 'Personne n\'a encore fait cette leçon.';
$string['nolessonattemptsgroup'] = 'Aucune tentative n\'a été effectuée dans cette leçon par des membres du groupe {$a}.';
$string['none'] = 'Aucun';
$string['nooneansweredcorrectly'] = 'Personne n\'a répondu correctement.';
$string['nooneansweredthisquestion'] = 'Personne n\'a répondu à cette question.';
$string['noonecheckedthis'] = 'Personne n\'a coché cette option.';
$string['nooneenteredthis'] = 'Personne n\'a tapé ceci.';
$string['noonehasanswered'] = 'Personne n\'a encore répondu à une question de composition.';
$string['noonehasansweredgroup'] = 'Aucun membre de {$a} n\'a encore répondu à une question de composition.';
$string['noopen'] = 'Pas de date d\'ouverture';
$string['nooverridedata'] = 'Vous devez définir une dérogation pour au moins un des paramètres de la leçon.';
$string['noretake'] = 'Vous n\'êtes pas autorisé à refaire cette leçon.';
$string['normal'] = 'Normal - suivre le parcours de la leçon';
$string['notcompleted'] = 'Pas terminé';
$string['notdefined'] = 'Non défini';
$string['notenoughsubquestions'] = 'Vous n\'avez pas défini assez de sous-questions !<br />Souhaitez-vous revenir en arrière pour corriger cela ?';
$string['notenoughtimespent'] = 'Vous avez terminé cette leçon en {$a->timespent}, c\'est-à-dire en moins de temps que la durée minimale exigée {$a->timerequired}.';
$string['notgraded'] = 'Non évalué';
$string['notitle'] = 'Pas de titre';
$string['notyetcompleted'] = 'La leçon a été commencée, mais n\'est pas terminée';
$string['numberofcorrectanswers'] = 'Nombre de réponses correctes : {$a}';
$string['numberofcorrectanswersheader'] = 'Nombre de réponses correctes';
$string['numberofcorrectmatches'] = 'Nombre d\'appariements corrects : {$a}';
$string['numberofpagestoshow'] = 'Nombre de pages à afficher';
$string['numberofpagestoshow_help'] = 'Ce réglage détermine le nombre de pages affichées dans une leçon. Il n\'est valable que pour les leçons où les pages sont affichées en ordre aléatoire (lorsque le réglage « Action après réponse correcte » est fixé à « Afficher une page non vue » ou « Afficher une page sans réponse »). Si le nombre indiqué est 0, toutes les pages seront affichées.';
$string['numberofpagesviewed'] = 'Nombre de questions répondues : {$a}';
$string['numberofpagesviewedheader'] = 'Nombre de questions répondues';
$string['numberofpagesviewednotice'] = 'Nombre de questions répondues : {$a->nquestions} (vous devez répondre au moins à {$a->minquestions})';
$string['numerical'] = 'Numérique';
$string['offlinedatamessage'] = 'Vous avez travaillé à cette tentative à l\'aide d\'un appareil mobile. Les données ont été enregistrées sur ce site il y a {$a}. Veuillez vérifier que vous n\'avez pas de données non enregistrées.';
$string['ongoing'] = 'Afficher le score actuel';
$string['ongoingcustom'] = 'Vous avez jusqu\'ici reçu {$a->score} sur un maximum de {$a->currenthigh} point(s).';
$string['ongoing_help'] = 'Si ce réglage est activé, l\'étudiant verra sur chaque page, le nombre des points qu\'il a obtenu par rapport au total possible jusqu\'ici.';
$string['ongoingnormal'] = 'Vous avez répondu correctement à {$a->correct} tentatives sur {$a->viewed}.';
$string['onpostperpage'] = 'Seulement un message par note';
$string['openafterclose'] = 'Vous avez indiqué une date d\'ouverture postérieure à la date de fermeture.';
$string['options'] = 'Options';
$string['or'] = 'OU';
$string['ordered'] = 'Ordonnés';
$string['other'] = 'Autre';
$string['outof'] = 'sur {$a}';
$string['override'] = 'Dérogation';
$string['overridedeletegroupsure'] = 'Voulez-vous vraiment supprimer la dérogation pour le groupe {$a} ?';
$string['overridedeleteusersure'] = 'Voulez-vous vraiment supprimer la dérogation pour l\'utilisateur {$a} ?';
$string['overridegroup'] = 'Dérogation de groupe';
$string['overridegroupeventname'] = '{$a->lesson} - {$a->group}';
$string['overrides'] = 'Dérogations';
$string['overrideuser'] = 'Dérogation utilisateur';
$string['overrideusereventname'] = '{$a->lesson} - Dérogation';
$string['overview'] = 'Vue d\'ensemble';
$string['overview_help'] = 'Une leçon est constituée de plusieurs pages et éventuellement de pages de contenu.
Une page contient des données et se termine souvent par une question. Un lien est associé à chaque réponse. Ce lien peut être relatif, comme cette page ou page suivante, ou absolue, en spécifiant une des pages de la leçon. Une page de contenu est une page qui contient des liens vers d\'autres pages de la leçon, comme une table des matières.';
$string['page'] = 'Page : {$a}';
$string['pageanswers'] = 'Page réponses';
$string['pagecontents'] = 'Contenu de la page';
$string['page-mod-lesson-edit'] = 'Modifier page de leçon';
$string['page-mod-lesson-view'] = 'Afficher ou prévisualiser une page leçon';
$string['page-mod-lesson-x'] = 'Toute page de leçon';
$string['pageresponses'] = 'Page réponses attendues';
$string['pages'] = 'Pages';
$string['pagetitle'] = 'Titre de la page';
$string['password'] = 'Mot de passe';
$string['passwordprotectedlesson'] = '{$a} est une leçon protégée par mot de passe.';
$string['pleasecheckoneanswer'] = 'Valider la réponse choisie';
$string['pleasecheckoneormoreanswers'] = 'Valider la ou les réponses choisies';
$string['pleaseenteryouranswerinthebox'] = 'Veuillez saisir votre réponse dans le champ';
$string['pleasematchtheabovepairs'] = 'Valider les appariements choisis';
$string['pluginadministration'] = 'Administration de la leçon';
$string['pluginname'] = 'Leçon';
$string['pointsearned'] = 'Points reçus';
$string['postprocesserror'] = 'Erreur lors du post-traitement !';
$string['postsuccess'] = 'Message envoyé avec succès';
$string['practice'] = 'Leçon d\'entraînement';
$string['practice_help'] = 'Le résultat d\'une leçon d\'entraînement n\'apparaîtra pas dans le carnet de notes.';
$string['preprocesserror'] = 'Erreur lors du pré-traitement !';
$string['prerequisiteisobsolete'] = 'Le réglage « Leçon prérequise » sera supprimé prochainement. Veuillez plutôt utiliser les restrictions d\'accès en lieu et place.';
$string['prerequisitelesson'] = 'Leçon prérequise';
$string['preview'] = 'Prévisualisation';
$string['previewlesson'] = 'Prévisualiser {$a}';
$string['previewpagenamed'] = 'Prévisualiser la page {$a}';
$string['previouspage'] = 'Page précédente';
$string['privacy:metadata:attempts'] = 'Un enregistrement des tentatives de la page';
$string['privacy:metadata:attempts:answerid'] = 'L\'ID de la réponse';
$string['privacy:metadata:attempts:correct'] = 'Si la tentative était correcte';
$string['privacy:metadata:attempts:pageid'] = 'L\'ID de la page';
$string['privacy:metadata:attempts:retry'] = 'Le numéro de la tentative';
$string['privacy:metadata:attempts:timeseen'] = 'La date et l\'heure de la tentative';
$string['privacy:metadata:attempts:useranswer'] = 'Infos sur la réponse de l\'utilisateur';
$string['privacy:metadata:attempts:userid'] = 'L\'ID de l\'utilisateur';
$string['privacy:metadata:branch'] = 'Un enregistrement des pages consultées';
$string['privacy:metadata:branch:flag'] = 'Si la page suivante a été calculé aléatoirement';
$string['privacy:metadata:branch:nextpageid'] = 'L\'ID de la page suivante';
$string['privacy:metadata:branch:pageid'] = 'L\'ID de la page';
$string['privacy:metadata:branch:retry'] = 'Le numéro de la tentative';
$string['privacy:metadata:branch:timeseen'] = 'La date et l\'heure de la consultation de la page';
$string['privacy:metadata:branch:userid'] = 'L\'ID de l\'utilisateur';
$string['privacy:metadata:grades'] = 'Un enregistrement des notes de chaque leçon';
$string['privacy:metadata:grades:completed'] = 'La date à laquelle la note a été donnée';
$string['privacy:metadata:grades:grade'] = 'La note donnée';
$string['privacy:metadata:grades:userid'] = 'L\'ID de l\'utilisateur';
$string['privacy:metadata:overrides'] = 'Un enregistrement des dérogation par leçon';
$string['privacy:metadata:overrides:available'] = 'La date et l\'heure à laquelle les étudiants peuvent commencer la leçon.';
$string['privacy:metadata:overrides:deadline'] = 'La date d\'échéance pour terminer la leçon.';
$string['privacy:metadata:overrides:maxattempts'] = 'Le nombre maximum de tentatives';
$string['privacy:metadata:overrides:password'] = 'Le mot de passe pour accéder à la leçon';
$string['privacy:metadata:overrides:retake'] = 'Si les tentatives répétées sont autorisées';
$string['privacy:metadata:overrides:review'] = 'Si la tentative répétée d\'une question est autorisée';
$string['privacy:metadata:overrides:timelimit'] = 'La temps imparti pour terminer la leçon, en secondes.';
$string['privacy:metadata:overrides:userid'] = 'L\'ID de l\'utilisateur';
$string['privacy:metadata:timer'] = 'Un enregistrement d\'une tentative de leçon';
$string['privacy:metadata:timer:completed'] = 'Si la tentative est terminée';
$string['privacy:metadata:timer:lessontime'] = 'La date et l\'heure de la dernière activité';
$string['privacy:metadata:timer:starttime'] = 'La date à laquelle la tentative a commencé';
$string['privacy:metadata:timer:timemodifiedoffline'] = 'La date et l\'heure de la dernière activité depuis l\'app mobile';
$string['privacy:metadata:timer:userid'] = 'L\'ID de l\'utilisateur';
$string['privacy:metadata:userpref:lessonview'] = 'Le mode d\'affichage préféré lors de l\'édition de leçons';
$string['privacy:path:essayresponses'] = 'Réponses de composition';
$string['privacy:path:pages'] = 'Pages';
$string['processerror'] = 'Erreur lors du traitement !';
$string['progressbar'] = 'Barre de progression';
$string['progressbar_help'] = 'Si ce réglage est activé, une barre de progression est affichée en bas des pages de la leçon, indiquant le pourcentage approximatif du travail effectué.';
$string['progressbarteacherwarning'] = 'La barre de progression ne s\'affiche pas pour {$a}';
$string['progressbarteacherwarning2'] = 'La barre de progression ne sera pas affichée, car vous pouvez modifier cette leçon';
$string['progresscompleted'] = 'Vous avez terminé {$a} % de la leçon';
$string['qtype'] = 'Type de page';
$string['question'] = 'Question';
$string['questionoption'] = 'Question';
$string['questiontype'] = 'Type de question';
$string['randombranch'] = 'Page de contenu aléatoire';
$string['randompageinbranch'] = 'Question aléatoire au sein du groupe';
$string['rank'] = 'Rang';
$string['rawgrade'] = 'Note brute';
$string['receivedcredit'] = 'A reçu les points';
$string['redisplaypage'] = 'Réafficher la page';
$string['removeallgroupoverrides'] = 'Supprimer toutes les dérogations de groupe';
$string['removealluseroverrides'] = 'Supprimer toutes les dérogations utilisateur';
$string['report'] = 'Rapport';
$string['reports'] = 'Rapports';
$string['response'] = 'Feedback';
$string['retakesallowed'] = 'Plusieurs tentatives permises';
$string['retakesallowed_help'] = 'Si ce réglage est activé, les étudiants peuvent effectuer la leçon à plusieurs reprises.';
$string['returnto'] = 'Retour à {$a}';
$string['returntocourse'] = 'Retour au cours';
$string['reverttodefaults'] = 'Revenir aux réglages par défaut de la leçon';
$string['review'] = 'Relecture';
$string['reviewlesson'] = 'Revoir la leçon';
$string['reviewquestionback'] = 'Oui, j\'aimerais essayer à nouveau';
$string['reviewquestioncontinue'] = 'Non, je veux passer à la question suivante';
$string['sanitycheckfailed'] = 'Vérification échouée : cette tentative a été supprimée';
$string['save'] = 'Enregistrer';
$string['savechanges'] = 'Enregistrer les modifications';
$string['savechangesandeol'] = 'Enregistrer tous les changements et aller à la fin de la leçon.';
$string['saveoverrideandstay'] = 'Enregistrer et ajouter une autre dérogation';
$string['savepage'] = 'Enregistrer la page';
$string['score'] = 'Score';
$string['score_help'] = 'Le score n\'est utilisé que si l\'option « score personnalisé » de la leçon est activée. Chaque réponse peut alors recevoir un nombre de points (positif ou négatif).';
$string['scores'] = 'Scores';
$string['search:activity'] = 'Leçon – information sur l\'activité';
$string['secondpluswrong'] = 'Pas tout à fait. Voulez-vous essayer à nouveau ?';
$string['selectaqtype'] = 'Sélectionner un type de question';
$string['sent'] = 'Envoyé';
$string['shortanswer'] = 'Réponse courte';
$string['showanunansweredpage'] = 'Afficher une page sans réponse';
$string['showanunseenpage'] = 'Afficher une page non vue';
$string['singleanswer'] = 'Réponse simple';
$string['skip'] = 'Passer la navigation';
$string['slideshow'] = 'Diaporama';
$string['slideshowbgcolor'] = 'Couleur de fond du diaporama';
$string['slideshowheight'] = 'Hauteur du diaporama';
$string['slideshow_help'] = 'Si ce réglage est activé, la leçon sera affichée à la manière d\'une présentation (diaporama), avec une largeur et une hauteur déterminées.';
$string['slideshowwidth'] = 'Largeur du diaporama';
$string['startlesson'] = 'Commencer la leçon';
$string['studentattemptlesson'] = 'Tentative numéro {$a->attempt} de {$a->firstname} {$a->lastname}';
$string['studentname'] = 'Nom de l\'étudiant';
$string['studentoneminwarning'] = 'Attention : il vous reste moins d\'une minute pour terminer la leçon.';
$string['studentoutoftimeforreview'] = 'Attention : vous avez dépassé le temps alloué pour relire la leçon';
$string['studentresponse'] = 'Feedback de {$a}';
$string['submit'] = 'Envoyer';
$string['submitname'] = 'Proposer un nom';
$string['teacherjumpwarning'] = 'Un lien {$a->cluster} ou un lien {$a->unseen} est utilisé dans cette leçon. Un lien « Page suivante » sera utilisé à sa place. Veuillez vous connecter en tant qu\'étudiant pour tester ces liens.';
$string['teacherongoingwarning'] = 'Le score actuel n\'est affiché que pour les étudiants. Veuillez vous connecter en tant qu\'étudiant pour tester le score actuel.';
$string['teachertimerwarning'] = 'Le chronomètre ne fonctionne que pour les étudiants. Veuillez vous connecter en tant qu\'étudiant pour tester le chronomètre.';
$string['thatsthecorrectanswer'] = 'C\'est une réponse correcte';
$string['thatsthewronganswer'] = 'C\'est une mauvaise réponse';
$string['thefollowingpagesjumptothispage'] = 'Les pages suivantes renvoient vers cette page';
$string['thispage'] = 'Cette page';
$string['timeisup'] = 'C\'est l\'heure';
$string['timelimit'] = 'Temps imparti';
$string['timelimit_help'] = 'Si ce réglage est activé, un avertissement est affiché au début de la leçon, indiquant le temps imparti pour la leçon. Un compte à rebours est également affiché. Les réponses données après le délai ne sont pas évaluées.';
$string['timelimitwarning'] = 'Vous avez {$a} pour terminer la leçon.';
$string['timeremaining'] = 'Durée restante';
$string['timespenterror'] = 'Passer au moins {$a} minutes dans la leçon';
$string['timespentminutes'] = 'Durée utilisée (minutes)';
$string['timetaken'] = 'Durée utilisée';
$string['totalpagesviewedheader'] = 'Nombre de pages consultées';
$string['true'] = 'Vrai';
$string['truefalse'] = 'Vrai/Faux';
$string['unabledtosavefile'] = 'Le fichier déposé n\'a pas pu être enregistré.';
$string['unknownqtypesnotimported'] = '{$a} questions de types de questions non supportés n\'ont pas été importées';
$string['unseenpageinbranch'] = 'Question non vue au sein d\'un groupe';
$string['unsupportedqtype'] = 'Type de question non supporté ({$a}) !';
$string['updatedpage'] = 'Page modifiée';
$string['updatefailed'] = 'Modification échouée';
$string['updatepagenamed'] = 'Modifier la page {$a}';
$string['usemaximum'] = 'Utiliser le maximum';
$string['usemean'] = 'Utiliser la moyenne';
$string['usepassword'] = 'Leçon protégée par mot de passe';
$string['usepassword_help'] = 'Si ce réglage est activé, un mot de passe doit être saisi pour accéder à la leçon.';
$string['useroverrides'] = 'Dérogations utilisateur';
$string['useroverridesdeleted'] = 'Dérogations utilisateur supprimées';
$string['usersnone'] = 'Aucun étudiant n\'a accès à cette leçon';
$string['viewessayanswers'] = 'Consultez les réponses de composition';
$string['viewgrades'] = 'Afficher les notes';
$string['viewreports'] = 'Afficher les {$a->attempts} tentatives terminées';
$string['viewreports2'] = 'Afficher les {$a} tentatives terminées';
$string['warning'] = 'Avertissement';
$string['welldone'] = 'Bien joué !';
$string['whatdofirst'] = 'Par quoi voulez-vous commencer ?';
$string['wronganswerjump'] = 'Lien après mauvaise réponse';
$string['wronganswerscore'] = 'Score des mauvaises réponses';
$string['wrongresponse'] = 'Feedback mauvaise réponse';
$string['xattempts'] = '{$a} tentatives';
$string['youhaveseen'] = 'Vous avez déjà vu au moins une page de cette leçon.<br />Voulez-vous commencer à la dernière page que vous avez vue ?';
$string['youranswer'] = 'Votre réponse';
$string['yourcurrentgradeis'] = 'Votre note actuelle est {$a}';
$string['yourcurrentgradeisoutof'] = 'Votre note actuelle est {$a->grade} sur {$a->total}';
$string['youshouldview'] = 'Vous devriez répondre au moins à {$a}';
