<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'hvp', language 'fr', branch 'MOODLE_36_STABLE'
 *
 * @package   hvp
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Action';
$string['addedandupdatedpp'] = 'Ajout de {$a->%new} nouvelles bibliothèques H5P et mise à jour de {$a->%old} anciennes.';
$string['addedandupdatedps'] = 'Ajout de {$a->%new} nouvelles bibliothèques H5P et mise à jour de {$a->%old} ancienne.';
$string['addedandupdatedsp'] = 'Ajout de {$a->%new} nouvelles bibliothèques H5P et mise à jour de {$a->%old} anciennes.';
$string['addedandupdatedss'] = 'Ajout de {$a->%new} nouvelles bibliothèques H5P et mise à jour de {$a->%old} ancienne.';
$string['addednewlibraries'] = 'Ajout de {$a->%new} nouvelles bibliothèques H5P.';
$string['addednewlibrary'] = 'Ajout de {$a->%new} nouvelle bibliothèque H5P.';
$string['additionalinfo'] = 'Information supplémentaire';
$string['additionallicenseinfo'] = 'Toute information supplémentaire sur la licence';
$string['addlibraries'] = 'Ajouter des bibliothèques';
$string['ajaxfailed'] = 'Échec du téléchargement des données.';
$string['anunexpectedsave'] = 'Erreur inattendue. Impossible d\'enregistrer ce contenu.';
$string['attribution'] = 'Attribution 4.0';
$string['attributionnc'] = 'Attribution - Pas d’Utilisation Commerciale 4.0';
$string['attributionncnd'] = 'Attribution - Pas d’Utilisation Commerciale - Pas de Modification 4.0';
$string['attributionncsa'] = 'Attribution - Pas d’Utilisation Commerciale - Partage dans les Mêmes Conditions 4.0';
$string['attributionnd'] = 'Attribution - Pas de Modification 4.0';
$string['attributionsa'] = 'Attribution - Pas de Modification 4.0';
$string['author'] = 'Auteur';
$string['authorcomments'] = 'Commentaires de l\'auteur';
$string['authorcommentsdescription'] = 'Commentaires pour l\'éditeur du contenu (Ce texte ne sera pas publié avec les informations de copyright)';
$string['authorname'] = 'Nom de l\'auteur';
$string['authorrole'] = 'Rôle de l\'auteur';
$string['by'] = 'par';
$string['cancellabel'] = 'Annuler';
$string['ccattribution'] = 'Attribution (CC BY)';
$string['ccattributionnc'] = 'Attribution - Pas d’Utilisation Commerciale (CC BY-NC)';
$string['ccattributionncnd'] = 'Attribution - Pas d’Utilisation Commerciale - Pas de Modification (CC BY-NC-ND)';
$string['ccattributionncsa'] = 'Attribution - Pas d’Utilisation Commerciale - Partage dans les Mêmes Conditions (CC BY-NC-SA)';
$string['ccattributionnd'] = 'Attribution - Pas de Modification (CC BY-ND)';
$string['ccattributionsa'] = 'Attribution - Partage dans les Mêmes Conditions (CC BY-SA)';
$string['ccpdd'] = 'CC0 1.0 universel (CC0 1.0) Transfert dans le Domaine Public';
$string['ccpdm'] = 'Marque du Domaine Public (PDM)';
$string['changedby'] = 'Modifié par';
$string['changedescription'] = 'Description de la modification';
$string['changelog'] = 'Journal des modifications';
$string['changeplaceholder'] = 'Photo recadrée, texte modifié, etc.';
$string['close'] = 'Fermer';
$string['confirmdialogbody'] = 'Merci de confirmer que vous voulez continuer. Cette action est irréversible.';
$string['confirmdialogheader'] = 'Confirmer l\'action';
$string['confirmlabel'] = 'Confirmer';
$string['connectionlost'] = 'Connexion perdue. Les résultats seront enregistrés et envoyés que lorsque vous retrouverez la connexion.';
$string['connectionreestablished'] = 'Connexion rétablie.';
$string['contentchanged'] = 'Ce contenu a changé depuis votre dernière utilisation.';
$string['contentcopied'] = 'Le contenu est copié dans le presse-papiers';
$string['contentstatefrequency'] = 'Fréquence de la sauvegarde du contenu';
$string['contentstatefrequency_help'] = 'En secondes, à quelle fréquence souhaitez-vous que les utilisateurs enregistrent leurs progrès. Augmentez ce nombre si vous rencontrez des problèmes avec les requêtes ajax.';
$string['contenttype'] = 'Type de Contenu';
$string['contenttypecacheheader'] = 'Cache du type de contenu';
$string['copyright'] = 'Droits d\'utilisation';
$string['copyrightinfo'] = 'Informations sur le copyright';
$string['copyrightstring'] = 'Copyright';
$string['copyrighttitle'] = 'Voir les informations du copyright pour ce contenu.';
$string['couldnotcopy'] = 'Le fichier n\'a pas pu être copié.';
$string['couldnotparsejsonfromzip'] = 'Impossible de parser le JSON du paquetage : %fileName';
$string['couldnotparsepostdata'] = 'Impossible de parser les données postées.';
$string['couldnotreadfilefromzip'] = 'Impossible de lire le fichier du paquetage : %fileName';
$string['couldnotsave'] = 'Le fichier n\'a pas pu être sauvegardé.';
$string['create'] = 'Créer';
$string['creativecommons'] = 'Creative Commons';
$string['ctcachebuttonlabel'] = 'Mettre à jour le cache';
$string['ctcacheconnectionfailed'] = 'Impossible de communiquer avec le hub H5P. Merci de ré-essayer plus tard.';
$string['ctcachedescription'] = 'Assurez-vous que le cache du type de contenu est à jour pour vous permettre de visualiser, télécharger et utiliser les dernières bibliothèques. Ceci est différent de la mise à jour des bibliothèques elles-mêmes.';
$string['ctcachelastupdatelabel'] = 'Dernière mise à jour';
$string['ctcacheneverupdated'] = 'Jamais';
$string['ctcachenolibraries'] = 'Pas de types de contenu reçus du hub H5P. Merci de ré-essayer plus tard.';
$string['ctcachesuccess'] = 'Le cache des librairies H5P a été correctement mis à jour !';
$string['ctcachetaskname'] = 'Mettre à jour le cache des types de contenu';
$string['currentpage'] = 'Page $current de $total';
$string['dataviewreportlabel'] = 'Voir les réponses';
$string['date'] = 'Date';
$string['disablefileextensioncheck'] = 'Désactiver la vérification de l\'extension du fichier';
$string['disablefileextensioncheckwarning'] = 'Attention ! Désactiver la vérification de l\'extension du fichier peut entrainer des problèmes de sécurité car cela autorise le dépôt de fichiers php. Par conséquent, des personnes mal intentionnées pourraient exécuter du code sur votre site. Veuillez vous assurer que vous connaissez le contenu de tout ce que vous déposez.';
$string['disablefullscreen'] = 'Désactiver le plein écran';
$string['disablehubconfirmationmsg'] = 'Voulez-vous toujours activer le hub ?';
$string['disablehubdescription'] = 'Il est fortement recommandé de maintenir cette option activée. Le Hub H5P fournit une interface facile pour obtenir de nouveaux types de contenu et maintenir les types de contenu existants à jour. À l\'avenir, il facilitera également la diffusion et la réutilisation du contenu. Si cette option est désactivée, vous devrez installer et mettre à jour des types de contenu via des formulaires de téléchargement de fichiers.';
$string['displayoptionalwaysshow'] = 'Toujours montrer';
$string['displayoptionauthoroff'] = 'Contrôlé par l\'auteur, désactivé par défaut';
$string['displayoptionauthoron'] = 'Contrôlé par l\'auteur, activé par défaut';
$string['displayoptiondownloadalways'] = 'Toujours';
$string['displayoptiondownloadnever'] = 'Jamais';
$string['displayoptiondownloadpermission'] = 'Seulement si l\'utilisateur dispose des autorisations pour exporter des activités H5P';
$string['displayoptionnevershow'] = 'Ne jamais montrer';
$string['displayoptionpermissions'] = 'Ne montrer que si l\'utilisateur a les droits d\'export H5P';
$string['displayoptionpermissionsembed'] = 'Ne montrer que si l\'utilisateur a les droits d\'intégration H5P';
$string['displayoptions'] = 'Afficher les options';
$string['download'] = 'Télécharger';
$string['downloadfailed'] = 'Le téléchargement de la librairie a échoué';
$string['downloadtitle'] = 'Télécharger ce contenu comme un fichier H5P.';
$string['editor'] = 'Éditeur';
$string['emailconfirmbody'] = 'Bonjour {$a->username},

Merci pour l\'envoi de vos réponses à l\'activité « {$a->hvpname} » dans le cours « {$a->coursename} ».

Ce message vous confirme que vos réponses ont bien été enregistrées.

Vous pouvez accéder à ce contenu H5P à l\'adresse {$a->hvpurl}.';
$string['emailconfirmsmall'] = 'Merci pour l\'envoi de vos réponses à l\'activité « {$a->hvpname} »';
$string['emailconfirmsubject'] = 'Confirmation de soumission: {$a->hvpname}';
$string['emailnotifybody'] = 'Bonjour {$a->username},

{$a->studentname} a terminé « {$a->hvpname} » ({$a->hvpurl}) dans le cours « {$a->coursename} ».

Vous pouvez contrôler cette tentative à l\'adresse {$a->hvpreporturl}.';
$string['emailnotifysmall'] = '{$a->studentname} a terminé {$a->hvpname}. Consulter {$a->hvpreporturl}';
$string['emailnotifysubject'] = '{$a->studentname} a terminé {$a->hvpname}';
$string['embed'] = 'Embarqué';
$string['embedloginfailed'] = 'Vous n\'avez pas accès à ce contenu. Essayez de vous connecter.';
$string['embedtitle'] = 'Voir le code embarqué pour ce contenu';
$string['empty'] = 'Pas de résultat disponible';
$string['enableabout'] = 'Bouton À propos d\'H5P';
$string['enablecopyright'] = 'Bouton Copyright';
$string['enabledlrscontenttypes'] = 'Activer les types de contenu dépendants d\'un LRS';
$string['enabledlrscontenttypes_help'] = 'Permet d\'utiliser des types de contenu qui s\'appuient sur un Learning Record Store pour fonctionner correctement, comme le type de contenu « Questionnaire »';
$string['enabledownload'] = 'Autoriser le téléchargement';
$string['enableembed'] = 'Bouton Intégration';
$string['enableframe'] = 'Afficher la barre d\'action et le cadre';
$string['enablehublabel'] = 'Utiliser Hub H5P';
$string['enablejavascript'] = 'Veuillez activer le JavaScript.';
$string['enablesavecontentstate'] = 'Sauvegarder le contenu actuel';
$string['enablesavecontentstate_help'] = 'Enregistrer automatiquement l\'état actuel du contenu interactif pour chaque utilisateur. Cela veut dire que l\'utilisateur pourra reprendre où il s\'est arrêté.';
$string['failedtodownloadh5p'] = 'Impossible de télécharger le fichier H5P demandé.';
$string['fileexceedsmaxsize'] = 'Un des fichiers du paquetage dépasse la taille maximale autorisée pour les fichiers. (%file %used > %max)';
$string['filenotfoundonserver'] = 'Le fichier n\'existe pas. Merci de revoir les options de téléchargement.';
$string['filenotimage'] = 'Le fichier n\'est pas une image.';
$string['filetypenotallowed'] = 'Ce type de fichier n\'est pas autorisé.';
$string['finished'] = 'Terminé';
$string['fullscreen'] = 'Plein écran';
$string['gpl'] = 'General Public License v3';
$string['h5pfile'] = 'Fichier H5P';
$string['h5ptitle'] = 'Visitez H5P.org pour consulter plus de contenus sympas.';
$string['hide'] = 'Cacher';
$string['hideadvanced'] = 'Cacher (mode avancé)';
$string['hubcommunicationdisabled'] = 'La communication avec le hub H5P a été désactivée car une ou plusieurs dépendances H5P ont échoué.';
$string['hubisdisabled'] = 'Le hub H5P est désactivé. Vous pouvez le réactiver via la page de configuration du plugin H5P.';
$string['hubisdisableduploadlibraries'] = 'Le hub H5P a été désactivé. Vous pouvez toujours télécharger des bibliothèques via la page « Bibliothèques H5P ».';
$string['hubsettingsheader'] = 'Types de contenus';
$string['hvp:addinstance'] = 'Ajouter une nouvelle activité H5P';
$string['hvp:emailconfirmsubmission'] = 'Avoir un message de confirmation au moment de la soumission';
$string['hvp:emailnotifysubmission'] = 'Avoir un message de notification quand la tentative est soumise';
$string['hvp:getcachedassets'] = 'Obtenir le contenu H5P mis en cache';
$string['hvp:getembedcode'] = 'Voir le code embarqué quand l\'option « contrôle par permission » est active';
$string['hvp:getexport'] = 'Obtenez un fichier d\'exportation de H5P';
$string['hvp:installrecommendedh5plibraries'] = 'Installation des librairies H5P recommandées';
$string['hvp:manage'] = 'Modifier les activités H5P existantes';
$string['hvp:restrictlibraries'] = 'Restreindre une bibliothèque H5P.';
$string['hvp:savecontentuserdata'] = 'Enregistrer les données d\'utilisateurs du contenu H5P';
$string['hvp:saveresults'] = 'Sauvegarder les résultats du contenu H5P';
$string['hvp:updatelibraries'] = 'Mettre à jour la version d\'une bibliothèque H5P.';
$string['hvp:userestrictedlibraries'] = 'Utiliser des bibliothèques H5P restreintes';
$string['hvp:view'] = 'Voir et interagir avec les activités H5P';
$string['hvp:viewallresults'] = 'Voir tous les résultats des activités H5P terminées';
$string['hvp:viewresults'] = 'Voir le résultat du contenu H5P';
$string['installdenied'] = 'Vous n\'avez pas l\'autorisation d\'installer des types de contenu. Merci de contacter l\'administrateur du site.';
$string['installedlibraries'] = 'Bibliothèques installées';
$string['intro'] = 'Introduction';
$string['invalidaudioformat'] = 'Format du fichier audio non valide. Utilisez mp3 ou wav.';
$string['invalidcontentfolder'] = 'Contenu du dossier non valide.';
$string['invalidcontenttype'] = 'Le type de contenu choisi n\'est pas valide.';
$string['invalidfieldtype'] = 'Type de champ non valide.';
$string['invalidfile'] = 'Fichier « {$a->%filename} » non autorisé. Seuls les fichiers avec les extensions suivantes sont autorisés : {$a->%files-allowed}.';
$string['invalidh5ppost'] = 'Impossible de publier';
$string['invalidimageformat'] = 'Format de l\'image non valide. Utilisez jpg, png ou gif.';
$string['invalidlanguagefile'] = 'Fichier de langue non valide {$a->%file} dans la bibliothèque {$a->%library}';
$string['invalidlanguagefile2'] = 'Un fichier de langue non valide {$a->%languageFile} a été ajouté dans la bibliothèque {$a->%name}';
$string['invalidlibrary'] = 'Bibliothèque H5P {$a->%library} non valide';
$string['invalidlibrarydata'] = 'Données fournies invalides pour {$a->%property} de {$a->%library}';
$string['invalidlibrarydataboolean'] = 'Données fournies invalides pour {$a->%property} de {$a->%library}. Booléen attendu.';
$string['invalidlibraryname'] = 'Nom de bibliothèque non valide : {$a->%name}';
$string['invalidlibrarynamed'] = 'La bibliothèque H5P {$a->%library} utilisée dans le contenu n\'est pas valide';
$string['invalidlibraryoption'] = 'Option {$a->%option} non autorisée de {$a->%library}';
$string['invalidlibraryproperty'] = 'Impossible de lire les propriétés {$a->%property} de {$a->%library}';
$string['invalidmainjson'] = 'Un fichier h5p.json valide est manquant';
$string['invalidmultiselectoption'] = 'Option sélectionnée non valide pour multi-select';
$string['invalidparameters'] = 'Paramètres non valides';
$string['invalidselectoption'] = 'Option sélectionnée non valide';
$string['invalidsemanticsjson'] = 'Un fichier semantics.json invalide a été inclus dans la bibliothèque {$a->%name}';
$string['invalidsemanticstype'] = 'Erreur interne : le type de contenu « {$a->@type} » est inconnu. Le contenu est supprimé !';
$string['invalidstring'] = 'La chaîne fournie n\'est pas une chaîne regexp valide dans le fichier sémantique (valeur : « {$a->%value} », regexp : « {$a->%regexp} »).';
$string['invalidtoken'] = 'Jeton de sécurité non valide.';
$string['invalidvideoformat'] = 'Format de la vidéo non valide. Utilisez mp4 ou webm.';
$string['invalidxapiresult'] = 'Aucun résultat xAPI n\'a été trouvé pour cette combinaison contenu et identifiant utilisateur';
$string['javascriptloading'] = 'En attente du Javascript…';
$string['libraries'] = 'Bibliothèques H5P';
$string['librarydirectoryerror'] = 'Le nom du répertoire doit correspondre au nom à machineName ou machineName-majorVersion.minorVersion du fichier library.json (dossier : {$a->%directoryName}, machineName : {$a->%machineName}, majorVersion : {$a->%majorVersion}, minorVersion : {$a->%minorVersion})';
$string['librarylistactions'] = 'Actions';
$string['librarylistinstancedependencies'] = 'Dépendances entre les instances';
$string['librarylistinstances'] = 'Instances';
$string['librarylistlibrarydependencies'] = 'Dépendances entre les bibliothèques';
$string['librarylistrestricted'] = 'Restreint';
$string['librarylisttitle'] = 'Titre';
$string['librarynotselected'] = 'Vous devez sélectionner un type de contenu.';
$string['license'] = 'Licence';
$string['licenseCC010'] = 'CC0 1.0 universel (CC0 1.0) Transfert dans le Domaine Public';
$string['licenseCC010U'] = 'CC0 1.0 Universel';
$string['licenseCC10'] = '1.0 Générique';
$string['licenseCC20'] = '2.0 Générique';
$string['licenseCC25'] = '2.5 Générique';
$string['licenseCC30'] = '3.0 non transposé';
$string['licenseCC40'] = '4.0 International';
$string['licensee'] = 'Titulaire de la licence';
$string['licenseextras'] = 'Suppléments de licence';
$string['licenseGPL'] = 'Licence publique générale';
$string['licenseV1'] = 'Version 1';
$string['licenseV2'] = 'Version 2';
$string['licenseV3'] = 'Version 3';
$string['licenseversion'] = 'Version de la licence';
$string['loadingdata'] = 'Chargement des données.';
$string['lookforupdates'] = 'Rechercher des mises à jour';
$string['maximumgrade'] = 'Note maximale';
$string['maximumgradeerror'] = 'Veuillez entrer un entier positif valide pour définir le nombre de points maximum pour cette activité';
$string['maxpostsizetoosmall'] = 'Votre variable PHP post_max_size est assez petite. Avec votre configuration actuelle, vous ne pouvez pas télécharger des fichiers de plus de {$a->%number} Mo. Cela peut être un problème lorsque vous essayez de télécharger des fichiers H5Ps, des images et des vidéos. Veuillez prévoir de l\'augmenter à plus de 5 Mo';
$string['maxscore'] = 'Score maximum';
$string['maxuploadsizetoosmall'] = 'Votre variable PHP upload_max_filesize est assez petite. Avec votre configuration actuelle, vous ne pouvez pas télécharger des fichiers de plus de {$a->%number} Mo. Cela peut être un problème lorsque vous essayez de télécharger des fichiers H5Ps, des images et des vidéos. Veuillez prévoir de l\'augmenter à plus de 5 Mo.';
$string['messageprovider:confirmation'] = 'Confirmation de vos soumissions H5P';
$string['messageprovider:submission'] = 'Notifications des soumissions H5P';
$string['missingcontentfolder'] = 'Il manque un dossier de contenu valide';
$string['missingcontentuserdata'] = 'Erreur : impossible de trouver les données d\'utilisateur pour cette activité';
$string['missingcoreversion'] = 'Le système n\'a pas réussi à installer le composant <em>{$a->%component}</em> du paquetage car il nécessite une nouvelle version du plugin H5P. Le site utilise actuellement la version {$a->%current}, alors que la version {$a->%required} (ou plus) est requise. Nous vous recommandons de procéder à une mise à jour et de réessayer.';
$string['missingdependency'] = 'Dépendance manquante {$a->@dep} requise par {$a->@lib}.';
$string['missinglibrary'] = 'Bibliothèque requise manquante {$a->@library}';
$string['missinglibraryfile'] = 'Le fichier « {$a->%file} » est manquant dans la bibliothèque : « {$a->%name} »';
$string['missinglibraryjson'] = 'Impossible de trouver le fichier library.json avec un format json valide pour la bibliothèque {$a->%name}';
$string['missinglibraryproperty'] = 'La propriété {$a->%property} requise est manquante de la bibliothèque {$a->%library}';
$string['missingmbstring'] = 'L\'extension mbstring de PHP n\'est pas chargée. H5P a besoin de cette extension pour fonctionner correctement';
$string['missingparameters'] = 'Paramètres manquants';
$string['missinguploadpermissions'] = 'Veuillez noter que les bibliothèques peuvent exister dans le fichier que vous avez téléchargé, mais vous n\'êtes pas autorisé à télécharger de nouvelles bibliothèques. Contactez l\'administrateur du site.';
$string['modulename'] = 'Contenu interactif';
$string['modulename_help'] = 'Le module d\'activités H5P vous permet de créer du contenu interactif tel que des vidéos interactives, des banques de questions, des questions « glisser-déposer », des questions à choix multiples, des présentations et bien plus encore.

En plus d\'être un outil de création pour du contenu riche, H5P vous permet d\'importer et d\'exporter des fichiers H5P afin de les réutiliser et de les partager.

Les interactions et les scores des utilisateurs sont suivis en utilisant xAPI et sont accessibles dans le carnet de note de Moodle. Veuillez noter qu\'il est actuellement possible à des gens ayant des talents de programmation de tricher avec les interactions H5P et d\'obtenir les scores maximum sans connaître les réponses correctes. H5P ne doit pas être utilisé pour des examens.

Vous ajoutez un contenu interactif H5P en créant votre propre contenu grâce aux outils de création intégrés ou en important des fichiers H5P que vous aurez trouvés sur d\'autres sites H5P.';
$string['modulenameplural'] = 'Contenu interactif';
$string['nextpage'] = 'Page suivante';
$string['noanswersubmitted'] = 'Cet utilisateur n\'a pas encore soumis de réponse à l\'activité H5P';
$string['nocontent'] = 'Le fichier content.json est introuvable ou n\'a pas pu être parsé';
$string['nocontenttype'] = 'Aucun type de contenu n\'a été spécifié.';
$string['nocopyright'] = 'Aucune information sur le copyright de ce contenu n\'est disponible.';
$string['nodata'] = 'Il n\'y a pas de données disponibles correspondant à vos critères.';
$string['noextension'] = 'Le fichier que vous avez chargé n\'est pas un paquetage HTML5 valide (il n\'a pas l\'extension .h5p)';
$string['noh5ps'] = 'Il n\'y a pas de contenu interactif disponible pour ce cours.';
$string['nojson'] = 'Le fichier h5p.json principal n\'est pas valide';
$string['nombstringexteension'] = 'L\'extension PHP mbstring n\'est pas chargée. Elle est requise pour un fonctionnement correct de H5P.';
$string['noparameters'] = 'Pas de paramètres';
$string['noparse'] = 'Le fichier h5p.json n\'a pas pu être parsé';
$string['nopermissiontogettranslations'] = 'Vous n\'avez pas le droit de récupérer des traductions';
$string['nopermissiontorestrict'] = 'Vous n\'avez pas les droits pour restreindre des bibliothèques.';
$string['nopermissiontosavecontentuserdata'] = 'Vous n\'avez pas les permissions pour sauvegarder les données de l\'utilisateur.';
$string['nopermissiontosaveresult'] = 'Vous n\'avez pas les droits pour enregistrer les résultats de ce contenu.';
$string['nopermissiontoupgrade'] = 'Vous n\'avez pas les droits pour mettre à jour les bibliothèques.';
$string['nopermissiontouploadcontent'] = 'Vous n\'avez pas les droits pour déposer du contenu ici.';
$string['nopermissiontouploadfiles'] = 'Vous n\'avez pas les droits pour déposer des fichiers ici.';
$string['nopermissiontoviewcontenttypes'] = 'Vous n\'avez pas les droits pour voir les types de contenu.';
$string['nopermissiontoviewresult'] = 'Vous n\'avez pas les droits pour voir les résultats de ce contenu.';
$string['nosuchlibrary'] = 'Cette bibliothèque n\'existe pas';
$string['notapplicable'] = 'N/A';
$string['nounzip'] = 'Le fichier que vous avez déposé n\'est pas un paquet HTML 5 valide (il n\'est pas possible de le décompresser)';
$string['noversionattribution'] = 'Attribution';
$string['noversionattributionnc'] = 'Attribution - Pas d’Utilisation Commerciale';
$string['noversionattributionncnd'] = 'Attribution - Pas d’Utilisation Commerciale - Pas de Modification';
$string['noversionattributionncsa'] = 'Attribution - Pas d’Utilisation Commerciale - Partage dans les Mêmes Conditions';
$string['noversionattributionnd'] = 'Attribution - Pas de Modification';
$string['noversionattributionsa'] = 'Attribution - Partage dans les Mêmes Conditions';
$string['nowriteaccess'] = 'Un problème d\'accès en écriture au serveur a été détecté. Assurez-vous que votre serveur peut écrire dans votre dossier de données.';
$string['noziparchive'] = 'Votre version de PHP ne supporte pas ZipArchive.';
$string['offlinedialogbody'] = 'Impossible d\'envoyer des informations sur votre achèvement de cette tâche. Veuillez vérifier votre connexion internet.';
$string['offlinedialogheader'] = 'Votre connexion au serveur a été perdue.';
$string['offlinedialogretrybuttonlabel'] = 'Réessayer maintenant';
$string['offlinedialogretrymessage'] = 'Réessayer dans :num...';
$string['offlinesuccessfulsubmit'] = 'Résultats envoyés avec succès.';
$string['oldphpversion'] = 'Votre version de PHP est obsolète. H5P nécessite la version 5.2 pour fonctionner correctement. La version 5.6 ou ultérieure est recommandée.';
$string['olduploadoldcontent'] = 'Vous essayez de télécharger une activité créée avec une ancienne version de H5P. Veuillez mettre à niveau l\'activité sur le serveur d\'où elle provient et essayez de la télécharger à nouveau ou activez le hub H5P pour que ce serveur la mette à niveau automatiquement.';
$string['onlyupdate'] = 'Mettre à jour les bibliothèques existantes uniquement.';
$string['options'] = 'Options';
$string['originator'] = 'Initiateur';
$string['pd'] = 'Domaine public';
$string['pddl'] = 'Transfert du droit d’auteur seul ou certification du domaine Public';
$string['pdm'] = 'Marque du Domaine Public';
$string['pluginadministration'] = 'H5P';
$string['pluginname'] = 'H5P';
$string['postmessagerequired'] = 'Un message est nécessaire pour accéder au point de terminaison donné';
$string['previouspage'] = 'Page précédente';
$string['privacy:metadata:core_files'] = 'Le module H5P stocke les fichiers qui ont été téléchargés dans le cadre des activités H5P.';
$string['privacy:metadata:core_grades'] = 'Le module H5P stocke les scores des utilisateurs qui ont répondu à des activités H5P.';
$string['privacy:metadata:hvp_content_user_data'] = 'Décrit l\'état actuel de l\'activité pour chaque utilisateur. Sert à permettre à un utilisateur de reprendre une activité H5P là où il s\'était arrêté.';
$string['privacy:metadata:hvp_content_user_data:data'] = 'Données utilisateur stockées.';
$string['privacy:metadata:hvp_content_user_data:data_id'] = 'Identifiant du type de données.';
$string['privacy:metadata:hvp_content_user_data:delete_on_content_change'] = 'Indicateur déterminant si les données doivent être supprimées lorsque le contenu d\'une activité H5P change.';
$string['privacy:metadata:hvp_content_user_data:hvp_id'] = 'L\'ID du contenu H5P auquel les données appartiennent.';
$string['privacy:metadata:hvp_content_user_data:id'] = 'ID de la relation entre les données utilisateur et une activité H5P.';
$string['privacy:metadata:hvp_content_user_data:preloaded'] = 'Indicateur déterminant si les données doivent être préchargées dans l\'activité H5P.';
$string['privacy:metadata:hvp_content_user_data:sub_content_id'] = 'Sous-contenu de H5P, 0 s\'il ne s\'agit pas d\'un sous-contenu.';
$string['privacy:metadata:hvp_content_user_data:user_id'] = 'L\'identifiant de l\'utilisateur auquel les données appartiennent.';
$string['privacy:metadata:hvp_events'] = 'Assure le suivi des événements H5P enregistrés.';
$string['privacy:metadata:hvp_events:content_id'] = 'L\'ID de contenu sur lequel l\'action a été effectuée, 0 si nouveau ou aucun contenu.';
$string['privacy:metadata:hvp_events:content_title'] = 'Titre du contenu.';
$string['privacy:metadata:hvp_events:created_at'] = 'L\'heure à laquelle l\'événement a été créé.';
$string['privacy:metadata:hvp_events:id'] = 'L\'identifiant unique de l\'événement.';
$string['privacy:metadata:hvp_events:library_name'] = 'La bibliothèque concernée par l\'événement.';
$string['privacy:metadata:hvp_events:library_version'] = 'La version de la bibliothèque affectée par l\'événement.';
$string['privacy:metadata:hvp_events:sub_type'] = 'Le sous-type d\'événement ou l\'action de l\'événement.';
$string['privacy:metadata:hvp_events:type'] = 'Le type d\'événement.';
$string['privacy:metadata:hvp_events:user_id'] = 'L\'ID de l\'utilisateur qui a effectué l\'action.';
$string['privacy:metadata:hvp_xapi_results'] = 'Stocke les événements xAPI dans l\'activité H5P.';
$string['privacy:metadata:hvp_xapi_results:additionals'] = 'Informations supplémentaires que le H5P peut envoyer.';
$string['privacy:metadata:hvp_xapi_results:content_id'] = 'L\'ID de l\'activité sur laquelle l\'événement a été exécuté.';
$string['privacy:metadata:hvp_xapi_results:correct_responses_pattern'] = 'Le modèle de réponse correcte.';
$string['privacy:metadata:hvp_xapi_results:description'] = 'Description, tâche ou question de l\'activité sur laquelle l\'action a été effectuée.';
$string['privacy:metadata:hvp_xapi_results:id'] = 'L\'ID unique de l\'événement xAPI.';
$string['privacy:metadata:hvp_xapi_results:interaction_type'] = 'Le type d\'interaction.';
$string['privacy:metadata:hvp_xapi_results:max_score'] = 'Score maximum réalisable pour l\'événement.';
$string['privacy:metadata:hvp_xapi_results:parent_id'] = 'ID du parent de l\'activité sur laquelle cet événement a été exécuté. Nul si elle n\'a pas de parent.';
$string['privacy:metadata:hvp_xapi_results:raw_score'] = 'Score atteint pour l\'événement.';
$string['privacy:metadata:hvp_xapi_results:response'] = 'La réponse envoyée par l\'utilisateur.';
$string['privacy:metadata:hvp_xapi_results:user_id'] = 'L\'ID de l\'utilisateur qui a effectué l\'action.';
$string['question'] = 'Question';
$string['removeoldlogentries'] = 'Effacer les anciens logs H5P';
$string['removeoldmobileauthentries'] = 'Supprimer les anciennes entrées d\'authentification mobile H5P';
$string['removetmpfiles'] = 'Effacer les anciens fichiers temporaires d\'H5P';
$string['reportingquestionsremaininglabel'] = 'questions restant à noter';
$string['reportingscaledscoredelimiter'] = ',';
$string['reportingscaledscorelabel'] = 'Score du carnet de notes :';
$string['reportingscoredelimiter'] = 'sur';
$string['reportingscorelabel'] = 'Score :';
$string['reportnotsupported'] = 'Non supporté';
$string['reportsubmitgradelabel'] = 'Soumettre la note';
$string['resizescript'] = 'Insérez ce script sur votre site si vous voulez que le contenu intégré soit redimensionné dynamiquement :';
$string['resubmitscores'] = 'Tentative d\'envoyer les résultats enregistrés.';
$string['reuse'] = 'Réutiliser';
$string['reusecontent'] = 'Réutiliser le contenu';
$string['reusedescription'] = 'Réutiliser ce contenu';
$string['reveal'] = 'Révéler';
$string['reviseserversetupandretry'] = 'Lorsque vous aurez révisé la configuration de votre serveur, vous pourrez réactiver les communications du hub H5P dans les Paramètres H5P.';
$string['score'] = 'Score';
$string['search'] = 'Rechercher';
$string['sendusagestatistics'] = 'Contribuer aux statistiques d\'utilisation';
$string['sendusagestatistics_help'] = 'Les statistiques d\'utilisation seront automatiquement reportées pour aider les développeurs à mieux comprendre comment H5P est utilisé et pour déterminer les potentiels domaines d\'amélioration. En savoir plus sur <a {$a}>les données collectées sur h5p.org</a>.';
$string['settings'] = 'Paramètres H5P';
$string['showadvanced'] = 'Afficher les paramètres avancés';
$string['showless'] = 'Afficher moins';
$string['showmore'] = 'Afficher plus';
$string['sitecouldnotberegistered'] = 'Le site n\'a pas pu être enregistré avec le hub H5P. Merci de contacter l\'administrateur du site.';
$string['sitekey'] = 'Clef du site';
$string['sitekeydescription'] = 'La clef de site est un code secret qui identifie de manière unique ce site avec le Hub.';
$string['sitekeyregistered'] = 'Vous avez reçu une clef unique qui vous identifie avec le Hub lors de la réception de nouvelles mises à jour. La clef est disponible pour l\'affichage dans la page « Paramètres H5P ».';
$string['size'] = 'Taille';
$string['source'] = 'Source';
$string['sslnotenabled'] = 'SSL n\'est pas activé sur votre serveur. SSL doit être activé pour assurer une connexion sécurisée avec le hub H5P.';
$string['startingover'] = 'Vous allez recommencer depuis le début.';
$string['sublevel'] = 'Sous-niveau';
$string['successfullyregisteredwithhub'] = 'Votre site a été enregistré avec succès avec le hub H5P.';
$string['thumbnail'] = 'Vignette';
$string['title'] = 'Titre';
$string['unabletocreatedir'] = 'Impossible de créer le dossier.';
$string['unabletogetfieldtype'] = 'Impossible d\'identifier le type de champ.';
$string['undisclosed'] = 'Confidentiel';
$string['unpackedfilesexceedsmaxsize'] = 'La taille totale des fichiers décompressés dépasse la taille maximale autorisée. (%used > %max)';
$string['updatedlibraries'] = 'Bibliothèques H5P {$a->%old} mises à jour.';
$string['updatedlibrary'] = 'Bibliothèque H5P {$a->%old} mise à jour.';
$string['updatelibraries'] = 'Mettre à jour toutes les bibliothèques';
$string['upgrade'] = 'Actualiser H5P';
$string['upgradebuttonlabel'] = 'Actualiser';
$string['upgradedone'] = 'Vous avez mis à jour avec succès {$a} instance(s) d\'activité(s).';
$string['upgradeerror'] = 'Une erreur s\'est produite pendant le traitement des paramètres :';
$string['upgradeerrorcontent'] = 'Impossible de mettre à jour l\'activité %id:';
$string['upgradeerrordata'] = 'Impossible de charger les données pour la bibliothèque %lib.';
$string['upgradeerrormissinglibrary'] = 'Bibliothèque requise manquante : %lib.';
$string['upgradeerrornotsupported'] = 'Des paramètres contiennent %used qui n\'est pas supporté.';
$string['upgradeerrorparamsbroken'] = 'Paramètres invalides.';
$string['upgradeerrorscript'] = 'Impossible de mettre à jour le script pour la bibliothèque %lib.';
$string['upgradeerrortoohighversion'] = 'Des paramètres contiennent %used alors que seul %supported ou précédents sont supportés.';
$string['upgradeheading'] = 'Actualiser le contenu {$a}';
$string['upgradeinprogress'] = 'Mise à jour vers %ver…';
$string['upgradeinvalidtoken'] = 'Erreur : jeton de sécurité non valide !';
$string['upgradelibrarycontent'] = 'Actualiser le contenu de la bibliothèque';
$string['upgradelibrarymissing'] = 'Erreur : votre bibliothèque est manquante !';
$string['upgrademessage'] = 'Vous êtes sur le point de mettre à jour {$a} instance(s) d\'activité(s). Merci de sélectionner la version de la mise à jour.';
$string['upgradenoavailableupgrades'] = 'Il n\'y a pas d\'actualisation disponible pour cette bibliothèque.';
$string['upgradenothingtodo'] = 'Il n\'y a pas d\'activité à mettre à jour.';
$string['upgradereturn'] = 'Retour';
$string['upload'] = 'Déposer';
$string['uploadlibraries'] = 'Déposer des bibliothèques';
$string['uploadsizelargerthanpostsize'] = 'La taille maximale de votre envoi PHP est supérieure à la taille maximale de votre publication. Ceci est connu pour causer des problèmes dans certaines installations.';
$string['user'] = 'Utilisateur';
$string['validatingh5pfailed'] = 'La validation du paquet h5p a échoué.';
$string['validationfailed'] = 'Le H5P demandé n\'était pas valide';
$string['viewreportlabel'] = 'Reporter';
$string['welcomecommunity'] = 'Nous espérons que vous aimerez H5P et que vous vous engagerez dans notre communauté grandissante à travers nos <a {$a->forums}>forums</a>.';
$string['welcomecontactus'] = 'Si vous avez des retours, n\'hésitez pas à nous <a {$a}>contacter</a>. Nous prenons les retours très sérieusement et nous investissons pour rendre H5P meilleur de jour en jour !';
$string['welcomegettingstarted'] = 'Pour commencer avec H5P et Moodle, lisez notre <a {$a->moodle_tutorial}>tutoriel</a> et regardez nos <a {$a->example_content}>exemples de contenus</a> sur h5p.org pour vous inspirer.';
$string['welcomeheader'] = 'Bienvenue dans le monde d\'H5P !';
$string['wrongversion'] = 'La version de la bibliothèque H5P {$a->%machineName} utilisée dans cette activité n\'est pas valide. L\'activité contient {$a->%contentLibrary}, mais cela devrait être {$a->%semanticsLibrary}.';
$string['year'] = 'Année';
$string['years'] = 'Année(s)';
$string['yearsfrom'] = 'Années (à partir de)';
$string['yearsto'] = 'Années (à)';
