<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'forum', language 'fr', branch 'MOODLE_36_STABLE'
 *
 * @package   forum
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityoverview'] = 'Il y a de nouveaux messages de forum';
$string['addanewdiscussion'] = 'Ajouter une discussion';
$string['addanewquestion'] = 'Ajouter une nouvelle question';
$string['addanewtopic'] = 'Ajouter un nouveau sujet';
$string['advancedsearch'] = 'Recherche avancée';
$string['allforums'] = 'Tous les forums';
$string['allowdiscussions'] = 'Est-ce que {$a} peut poster dans ce forum ?';
$string['allowsallsubscribe'] = 'Tout le monde peut choisir de s\'abonner ou non à ce forum';
$string['allowsdiscussions'] = 'Tout le monde peut lancer une nouvelle discussion dans ce forum';
$string['allsubscribe'] = 'S\'abonner à tous les forums';
$string['allunsubscribe'] = 'Se désabonner de tous les forums';
$string['alreadyfirstpost'] = 'Ce message est déjà le premier de la discussion';
$string['anyfile'] = 'Tout fichier';
$string['areaattachment'] = 'Annexes';
$string['areapost'] = 'Messages';
$string['attachment'] = 'Annexe';
$string['attachment_help'] = 'Il vous est possible de joindre un ou plusieurs fichiers à chaque message que vous postez dans un forum. Si vous joignez une image, elle sera affichée en fin de message.';
$string['attachmentnopost'] = 'Vous ne pouvez pas exporter les annexes sans identifiant de message';
$string['attachments'] = 'Annexes';
$string['attachmentswordcount'] = 'Annexes et nombre de mots';
$string['blockafter'] = 'Nombre maximal de messages';
$string['blockafter_help'] = 'Ce réglage définit le nombre maximal de messages qu\'un participant peut poster durant une période donnée. Les utilisateurs ayant la capacité mod/forum:postwithoutthrottling ne sont pas touchés par les limites de message.';
$string['blockperiod'] = 'Durée de blocage';
$string['blockperioddisabled'] = 'Ne pas bloquer';
$string['blockperiod_help'] = 'Il est possible d\'empêcher des participants de poster des messages après qu\'ils en ont écrit un certain nombre durant une période donnée. Les utilisateurs ayant la capacité mod/forum:postwithoutthrottling ne sont pas touchés par les limites de message.';
$string['blogforum'] = 'Forum standard affiché comme un blog';
$string['bynameondate'] = 'par {$a->name}, {$a->date}';
$string['cannotadd'] = 'Impossible d\'ajouter la discussion dans ce forum';
$string['cannotadddiscussion'] = 'Pour créer une discussion dans ce forum, vous devez être membre de ce groupe.';
$string['cannotadddiscussionall'] = 'Vous n\'avez pas les permissions requises pour lancer une nouvelle discussion pour tous les participants.';
$string['cannotadddiscussiongroup'] = 'Vous ne pouvez pas créer de discussion parce que vous n\'êtes pas membre d\'un groupe ou du groupement.';
$string['cannotaddsubscriber'] = 'Impossible d\'abonner à ce forum l\'utilisateur d\'identifiant {$a} !';
$string['cannotaddteacherforumto'] = 'Impossible d\'ajouter le forum des enseignants converti à la section 0 du cours';
$string['cannotcreatediscussion'] = 'Impossible de créer une nouvelle discussion';
$string['cannotcreateinstanceforteacher'] = 'Impossible de créer une nouvelle instance de module de cours pour le forum des enseignants';
$string['cannotdeletepost'] = 'Vous ne pouvez pas supprimer ce message !';
$string['cannoteditposts'] = 'Vous ne pouvez pas modifier les messages d\'autres participants !';
$string['cannotfinddiscussion'] = 'Impossible de trouver cette discussion dans ce forum';
$string['cannotfindfirstpost'] = 'Impossible de trouver le premier message de ce forum';
$string['cannotfindorcreateforum'] = 'Impossible de trouver ou de créer le forum des annonces principal pour ce site';
$string['cannotfindparentpost'] = 'Impossible de trouver le parent ultime du message {$a}';
$string['cannotmovefromsingleforum'] = 'Impossible de déplacer une discussion depuis un forum avec une seule discussion';
$string['cannotmovenotvisible'] = 'Forum non visible';
$string['cannotmovetonotexist'] = 'Vous ne pouvez pas déplacer vers ce forum, qui n\'existe pas !';
$string['cannotmovetonotfound'] = 'Le forum de destination n\'a pas été trouvé dans ce cours.';
$string['cannotmovetosingleforum'] = 'Impossible de déplacer une discussion vers un forum avec une discussion simple';
$string['cannotpurgecachedrss'] = 'Impossible de purger le flux RSS en cache pour le forum source et/ou destination. Veuillez vérifier votre fichier permissionsforums';
$string['cannotremovesubscriber'] = 'Impossible de désabonner de ce forum l\'utilisateur d\'identifiant {$a} !';
$string['cannotreply'] = 'Vous ne pouvez pas répondre à ce message';
$string['cannotsplit'] = 'Les discussions de ce forum ne peuvent pas être séparées';
$string['cannotsubscribe'] = 'Vous devez être un membre du groupe pour vous abonner.';
$string['cannottrack'] = 'Impossible de stopper le suivi des messages de ce forum';
$string['cannotunsubscribe'] = 'Vous ne pouvez pas vous désabonner de ce forum';
$string['cannotupdatepost'] = 'Vous ne pouvez pas modifier ce message';
$string['cannotviewpostyet'] = 'Vous ne pouvez pas lire les questions des autres étudiants, car vous n\'avez pas encore écrit de message';
$string['cannotviewusersposts'] = 'Il n\'y a aucun message de cet utilisateur que vous puissiez consulter.';
$string['cleanreadtime'] = 'Heure de nettoyage des messages lus';
$string['clicktosubscribe'] = 'Vous n\'êtes pas abonné à cette discussion. Cliquez pour vous abonner.';
$string['clicktounsubscribe'] = 'Vous êtes abonné à cette discussion. Cliquez pour vous désabonner.';
$string['completiondiscussions'] = 'Le participant doit créer des discussions :';
$string['completiondiscussionsdesc'] = 'L\'étudiant doit créer au moins {$a} discussions';
$string['completiondiscussionsgroup'] = 'Discussions requises';
$string['completiondiscussionshelp'] = 'discussions requises pour terminer';
$string['completionposts'] = 'Le participant doit écrire des messages ou des réponses :';
$string['completionpostsdesc'] = 'L\'étudiant doit écrire au moins {$a} discussions ou réponses';
$string['completionpostsgroup'] = 'Messages requis';
$string['completionpostshelp'] = 'discussions ou réponses requises pour terminer';
$string['completionreplies'] = 'Le participant doit écrire des réponses :';
$string['completionrepliesdesc'] = 'L\'étudiant doit poster au moins {$a} réponses';
$string['completionrepliesgroup'] = 'Réponses requises';
$string['completionreplieshelp'] = 'réponses requises pour terminer';
$string['configcleanreadtime'] = 'L\'heure à laquelle nettoyer les anciens messages de la table des messages lus.';
$string['configdigestmailtime'] = 'Les utilisateurs désirant recevoir un courriel contenant tous les messages des forums le recevront quotidiennement. Ce réglage détermine l\'heure de la journée à laquelle le courriel sera envoyé (la tâche cron s\'exécutant immédiatement après cette heure enverra le message).';
$string['configdisplaymode'] = 'Mode d\'affichage par défaut des discussions';
$string['configenablerssfeeds'] = 'Cette option permet l\'activation des flux RSS pour tous les forums. Il est en outre nécessaire d\'activer manuellement les flux RSS dans les réglages de chaque forum.';
$string['configenabletimedposts'] = 'Si ce réglage est activé, il est possible de définir des périodes d\'affichage lors de l\'écriture de nouvelles discussions dans les forums.';
$string['configlongpost'] = 'Tout message dépassant cette longueur (nombre de caractères, code HTML non compris) est considéré comme long message. L\'affichage des messages sur la page d\'accueil du site, sur la page des cours en format informel et dans le profil des utilisateurs est tronqué à un endroit adéquat, entre les valeurs forum_shortpost et forum_longpost.';
$string['configmanydiscussions'] = 'Nombre maximal de discussions affichées sur une page';
$string['configmaxattachments'] = 'Nombre maximal d\'annexes permises par message.';
$string['configmaxbytes'] = 'Taille maximale des annexes des forums (cette taille dépend par ailleurs des limites définies au niveau du cours et d\'autres réglages locaux)';
$string['configoldpostdays'] = 'Nombre de jours après lequel tout message est considéré comme lu.';
$string['configreplytouser'] = 'Lorsqu\'un message est envoyé par courriel, doit-il contenir l\'adresse de courriel de son auteur, afin que le destinataire puisse l\'atteindre personnellement ? Même lorsque cette option est activée, les utilisateurs peuvent choisir dans leur profil de garder leur adresse secrète.';
$string['configrssarticlesdefault'] = 'Si les flux RSS sont activés, ce réglage détermine le nombre d\'articles par défaut (discussions ou messages).';
$string['configrsstypedefault'] = 'Si les flux RSS sont activés, ce réglage détermine le type d\'activité par défaut.';
$string['configshortpost'] = 'Tout message plus court que cette longueur (nombre de caractères, code HTML non compris) est considéré comme message court (voir ci-dessous).';
$string['configsubscriptiontype'] = 'Réglage par défaut pour le mode d\'abonnement.';
$string['configtrackingtype'] = 'Réglage par défaut du suivi des messages.';
$string['configtrackreadposts'] = 'Choisissez « Oui » pour activer le suivi des messages pour chaque utilisateur.';
$string['configusermarksread'] = 'Si « Oui », l\'utilisateur doit marquer manuellement un message comme lu. Si « Non », le message est automatiquement marqué comme lu après sa lecture.';
$string['confirmsubscribe'] = 'Voulez-vous vraiment vous abonner au forum « {$a} » ?';
$string['confirmsubscribediscussion'] = 'Voulez-vous vraiment vous abonner à la discussion « {$a->discussion} » du forum « {$a->forum} » ?';
$string['confirmunsubscribe'] = 'Voulez-vous vraiment vous désabonner du forum « {$a} » ?';
$string['confirmunsubscribediscussion'] = 'Voulez-vous vraiment vous désabonner de la discussion « {$a->discussion} » du forum « {$a->forum} » ?';
$string['couldnotadd'] = 'Impossible d\'ajouter votre message à cause d\'une erreur indéterminée';
$string['couldnotdeletereplies'] = 'Désolé, la suppression n\'est plus possible car quelqu\'un a déjà répondu';
$string['couldnotupdate'] = 'Impossible de modifier votre message à cause d\'une erreur inconnue';
$string['crontask'] = 'Envoi des messages et maintenance des forums';
$string['delete'] = 'Supprimer';
$string['deleteddiscussion'] = 'Le sujet de discussion a été supprimé';
$string['deletedpost'] = 'Ce message a été supprimé';
$string['deletedposts'] = 'Ces messages ont été supprimés';
$string['deletesure'] = 'Voulez-vous vraiment supprimer ce message ?';
$string['deletesureplural'] = 'Voulez-vous vraiment supprimer ces messages et toutes les réponses ? ({$a} messages)';
$string['digestmailheader'] = 'Ceci est le courriel quotidien contenant tous les nouveaux messages des forums de {$a->sitename}. Pour modifier les réglages par défaut de vos abonnements, veuillez visiter {$a->userprefs}.';
$string['digestmailpost'] = 'Modifier vos préférences pour les courriels quotidiens';
$string['digestmailpostlink'] = 'Modifier vos préférences pour les résumés de forum : {$a}';
$string['digestmailprefs'] = 'votre profil utilisateur';
$string['digestmailsubject'] = 'Courriel quotidien de {$a}';
$string['digestmailtime'] = 'Heure d\'envoi du courriel quotidien';
$string['digestsentusers'] = 'Les courriels quotidiens ont été envoyés correctement à {$a} utilisateurs.';
$string['disallowsubscribe'] = 'L\'abonnement n\'est pas autorisé';
$string['disallowsubscribeteacher'] = 'L\'abonnement n\'est pas autorisé (sauf pour les enseignants)';
$string['disallowsubscription'] = 'Abonnement';
$string['disallowsubscription_help'] = 'Ce forum ne permet pas de s\'abonner aux discussions.';
$string['discussion'] = 'Discussion';
$string['discussionlocked'] = 'Cette discussion a été verrouillée. Vous ne pouvez plus y répondre.';
$string['discussionlockingdisabled'] = 'Ne pas verrouiller les discussions';
$string['discussionlockingheader'] = 'Verrouillage des discussions';
$string['discussionmoved'] = 'Cette discussion a été déplacée vers « {$a} ».';
$string['discussionmovedpost'] = 'Cette discussion a été déplacée <a href="{$a->discusshref}">ici</a>, dans le forum <a href="{$a->forumhref}">{$a->forumname}</a>';
$string['discussionname'] = 'Nom de la discussion';
$string['discussionnownotsubscribed'] = '{$a->name} ne recevra pas notification de nouveaux messages dans « {$a->discussion} » de « {$a->forum} »';
$string['discussionnowsubscribed'] = '{$a->name} recevra notification de nouveaux messages dans « {$a->discussion} » de « {$a->forum} »';
$string['discussionpin'] = 'Épingler';
$string['discussionpinned'] = 'Épinglé';
$string['discussionpinned_help'] = 'Les discussions épinglées apparaissent en haut d\'un forum.';
$string['discussions'] = 'Discussions';
$string['discussionsplit'] = 'La discussion a été séparée.';
$string['discussionsstartedby'] = 'Discussions lancées par {$a}';
$string['discussionsstartedbyrecent'] = 'Discussions récentes lancées par {$a}';
$string['discussionsstartedbyuserincourse'] = 'Discussions commencées par {$a->fullname} dans {$a->coursename}';
$string['discussionsubscribestart'] = 'M\'envoyer par courriel les notifications de nouveaux messages dans cette discussion';
$string['discussionsubscribestop'] = 'Ne pas m\'envoyer par courriel de notification des nouveaux messages dans cette discussion';
$string['discussionsubscription'] = 'Abonnement à la discussion';
$string['discussionsubscription_help'] = 'L\'abonnement à une discussion vous permet de recevoir notification de nouveaux messages dans cette discussion.';
$string['discussionunpin'] = 'Dépingler';
$string['discussthistopic'] = 'Discuter sur ce sujet';
$string['displayend'] = 'Fin de l\'affichage';
$string['displayend_help'] = 'Ce réglage détermine si un message de forum doit être caché après une certaine date. À noter que les administrateurs peuvent toujours voir les messages.';
$string['displaymode'] = 'Type d\'affichage';
$string['displayperiod'] = 'Période d\'affichage';
$string['displaystart'] = 'Début de l\'affichage';
$string['displaystart_help'] = 'Ce réglage détermine si un message de forum doit être affiché à partir d\'une certaine date. À noter que les administrateurs peuvent toujours voir les messages.';
$string['displaywordcount'] = 'Afficher le nombre de mots';
$string['displaywordcount_help'] = 'Ce réglage détermine si le nombre de mots de chaque message est affiché ou non.';
$string['eachuserforum'] = 'Chaque personne lance une discussion unique';
$string['edit'] = 'Modifier';
$string['editedby'] = 'Modifié par {$a->name}. Écrit initialement le {$a->date}';
$string['editedpostupdated'] = 'Le message de {$a} a été modifié';
$string['editing'] = 'Modification';
$string['emaildigestcompleteshort'] = 'Messages complets';
$string['emaildigestdefault'] = 'Réglage par défaut ({$a})';
$string['emaildigestoffshort'] = 'Pas de courriel quotidien';
$string['emaildigestsubjectsshort'] = 'Objets seulement';
$string['emaildigesttype'] = 'Options des courriels quotidiens';
$string['emaildigesttype_help'] = 'Le type de notification que vous recevrez pour chaque forum.

* Réglage par défaut – c\'est le réglage de votre profil pour ce paramètre. Si vous le modifiez dans votre profil, cette modification sera prise en compte ici également.
* Pas de courriel quotidien – vous ne recevrez pas de courriel quotidien, mais un courriel pour chaque message de forum.
* Messages complets – vous recevrez un courriel quotidien contenant la totalité du contenu de chaque message de forum.
* Objets seulement – vous recevrez un courriel quotidien ne contenant que l\'objet de chaque message de forum.';
$string['emptymessage'] = 'Il y a eu un problème avec votre message. Peut-être est-il vide ou alors la taille de l\'annexe est trop grande. Vos modifications n\'ont pas été enregistrées.';
$string['erroremptymessage'] = 'Un message ne peut pas être vide';
$string['erroremptysubject'] = 'L\'objet d\'un message ne peut pas être vide';
$string['errorenrolmentrequired'] = 'Vous devez être inscrit dans ce cours pour avoir accès à ce contenu';
$string['errorwhiledelete'] = 'Une erreur est survenue lors de la suppression de l\'enregistrement.';
$string['eventassessableuploaded'] = 'Contenu posté';
$string['eventcoursesearched'] = 'Cours recherché';
$string['eventdiscussioncreated'] = 'Discussion créée';
$string['eventdiscussiondeleted'] = 'Discussion supprimée';
$string['eventdiscussionmoved'] = 'Discussion déplacée';
$string['eventdiscussionpinned'] = 'Discussion épinglée';
$string['eventdiscussionsubscriptioncreated'] = 'Abonnement à une discussion créé';
$string['eventdiscussionsubscriptiondeleted'] = 'Abonnement à une discussion supprimé';
$string['eventdiscussionunpinned'] = 'Discussion dépinglée';
$string['eventdiscussionupdated'] = 'Discussion modifiée';
$string['eventdiscussionviewed'] = 'Discussion consultée';
$string['eventpostcreated'] = 'Message créé';
$string['eventpostdeleted'] = 'Message supprimé';
$string['eventpostupdated'] = 'Message modifié';
$string['eventreadtrackingdisabled'] = 'Suivi de lecture désactivé';
$string['eventreadtrackingenabled'] = 'Suivi de lecture activé';
$string['eventsubscribersviewed'] = 'Liste d\'abonnés consultée';
$string['eventsubscriptioncreated'] = 'Abonnement créé';
$string['eventsubscriptiondeleted'] = 'Abonnement supprimé';
$string['eventuserreportviewed'] = 'Rapport utilisateur consulté';
$string['everyonecanchoose'] = 'Tous les participants peuvent s\'abonner';
$string['everyonecannowchoose'] = 'Tous les participants peuvent maintenant choisir de s\'abonner';
$string['everyoneisnowsubscribed'] = 'Tous les participants sont maintenant abonnés à ce forum';
$string['everyoneissubscribed'] = 'Tous les participants sont abonnés à ce forum';
$string['existingsubscribers'] = 'Abonnés actuels';
$string['exportdiscussion'] = 'Exporter la discussion vers le portfolio';
$string['forcedreadtracking'] = 'Permettre d\'imposer le suivi des messages.';
$string['forcedreadtracking_desc'] = 'Permet d\'imposer le suivi des messages de forums. Ce réglage aura pour conséquence une diminution de performance pour certains utilisateurs, en particulier dans des cours avec de nombreux forums et messages. Si le réglage est désactivé, dans les forums qui étaient en mode de suivi imposé, le suivi sera optionnel.';
$string['forcesubscribed'] = 'Tous les participants sont obligatoirement abonnés à ce forum';
$string['forcesubscribed_help'] = 'Ce forum ne permet pas de se désabonner des discussions.';
$string['forum'] = 'Forum';
$string['forum:addinstance'] = 'Ajouter un forum';
$string['forum:addnews'] = 'Ajouter des annonces';
$string['forum:addquestion'] = 'Ajouter une question';
$string['forum:allowforcesubscribe'] = 'Permettre d\'imposer l\'abonnement';
$string['forumauthorhidden'] = 'Auteur (masqué)';
$string['forumblockingalmosttoomanyposts'] = 'Vous approchez du nombre maximal de messages autorisés. Vous avez écrit {$a->numposts} durant les derniers {$a->blockperiod}. La limite est de {$a->blockafter} messages.';
$string['forumbodydeleted'] = 'Le contenu de ce message de forum a été supprimé et ne peut plus être consulté.';
$string['forumbodyhidden'] = 'Vous ne pouvez pas voir ce message, probablement parce que vous n\'avez pas encore participé à cette discussion, la durée maximale de modification n\'est pas encore passée, la discussion n\'a pas encore commencée ou elle est déjà terminée.';
$string['forum:canoverridediscussionlock'] = 'Répondre aux discussions verrouillées';
$string['forum:canposttomygroups'] = 'Poster dans tous les groupes auxquel on a accès';
$string['forum:createattachment'] = 'Créer des annexes';
$string['forum:deleteanypost'] = 'Supprimer des messages (en tout temps)';
$string['forum:deleteownpost'] = 'Supprimer ses propres messages (durant un délai)';
$string['forum:editanypost'] = 'Modifier des messages';
$string['forum:exportdiscussion'] = 'Exporter une discussion vers un portfolio';
$string['forum:exportownpost'] = 'Exporter ses propres messages vers un portfolio';
$string['forum:exportpost'] = 'Exporter des messages vers un portfolio';
$string['forumintro'] = 'Description';
$string['forum:managesubscriptions'] = 'Gérer les abonnés';
$string['forum:movediscussions'] = 'Déplacer des discussions';
$string['forumname'] = 'Nom du forum';
$string['forum:pindiscussions'] = 'Épingler des discussions';
$string['forumposts'] = 'Messages des forums';
$string['forum:postwithoutthrottling'] = 'Être exempté des limites de message';
$string['forum:rate'] = 'Évaluer les messages';
$string['forum:replynews'] = 'Répondre aux annonces';
$string['forum:replypost'] = 'Répondre aux messages';
$string['forums'] = 'Forums';
$string['forum:splitdiscussions'] = 'Séparer des discussions';
$string['forum:startdiscussion'] = 'Lancer des discussions';
$string['forumsubjectdeleted'] = 'Ce message de forum a été supprimé';
$string['forumsubjecthidden'] = 'Sujet (masqué)';
$string['forumtracked'] = 'Les messages non lus sont marqués';
$string['forumtrackednot'] = 'Les messages non lus ne sont pas marqués';
$string['forumtype'] = 'Type de forum';
$string['forumtype_help'] = 'Il y a 5 types de forums :

* Une seule discussion simple : un seul sujet de discussion sur lequel chacun peut s\'exprimer (ne peut pas être utilisé avec des groupes séparés).
* Chaque personne commence une seule discussion : chaque étudiant ne peut entamer qu\'une seule discussion, à laquelle chacun peut répondre.
* Forum questions/réponses : les étudiants doivent poster un message avant de pouvoir consulter et répondre aux questions et messages des autres participants.
* Forum standard affiché comme un blog : un forum ouvert, où chacun peut entamer une nouvelle discussion à tout instant. Les sujets de discussion sont affichés sur une page, avec un lien « Discuter sur ce sujet » pour y répondre.
* Forum standard pour utilisation générale : un forum ouvert, où chacun peut entamer une nouvelle discussion à tout instant.';
$string['forum:viewallratings'] = 'Voir toutes les évaluations brutes données par des participants';
$string['forum:viewanyrating'] = 'Voir toutes les évaluations globales';
$string['forum:viewdiscussion'] = 'Voir les discussions';
$string['forum:viewhiddentimedposts'] = 'Voir les messages cachés en attente de publication';
$string['forum:viewqandawithoutposting'] = 'Toujours voir les questions/réponses';
$string['forum:viewrating'] = 'Voir ses propres évaluations globales reçues';
$string['forum:viewsubscribers'] = 'Voir les abonnés';
$string['generalforum'] = 'Forum standard pour utilisation générale';
$string['generalforums'] = 'Forums standards';
$string['hiddenforumpost'] = 'Message de forum caché';
$string['indicator:cognitivedepth'] = 'Forum : aspect cognitif';
$string['indicator:cognitivedepth_help'] = 'Cet indicateur est basé sur la profondeur cognitive atteinte par l\'étudiant dans une activité Forum.';
$string['indicator:socialbreadth'] = 'Forum : aspect social';
$string['indicator:socialbreadth_help'] = 'Cet indicateur se base sur l\'interaction sociale atteinte par l\'étudiant dans une activité Forum.';
$string['inforum'] = 'dans {$a}';
$string['introblog'] = 'Les messages de ce forum ont été copiés depuis les blogs des utilisateurs de ce cours, car ces articles de blog ne sont plus disponibles';
$string['intronews'] = 'Nouvelles diverses et annonces';
$string['introsocial'] = 'Un forum pour discuter de sujets divers';
$string['introteacher'] = 'Un forum réservé aux remarques et discussions entre enseignants';
$string['invalidaccess'] = 'L\'accès à cette page n\'a pas été effectué correctement';
$string['invaliddigestsetting'] = 'Un réglage non valide a été fourni pour le courriel quotidien';
$string['invaliddiscussionid'] = 'Identifiant de discussion incorrect ou inexistant';
$string['invalidforcesubscribe'] = 'Mode d\'abonnement imposé non valide';
$string['invalidforumid'] = 'L\'identifiant de forum est incorrect';
$string['invalidparentpostid'] = 'Identifiant du message parent incorrect';
$string['invalidpostid'] = 'Identifiant de message incorrect : {$a}';
$string['lastpost'] = 'Dernier message';
$string['learningforums'] = 'Forums d\'apprentissage';
$string['lockdiscussionafter'] = 'Verrouiller les discussions après une période d\'inactivité';
$string['lockdiscussionafter_help'] = 'Les discussions peuvent être verrouillées automatiquement après une durée spécifiée écoulée depuis la dernière réponse.

Les utilisateurs disposant de la capacité de répondre aux discussions verrouillées peuvent déverrouiller une discussion en y répondant.';
$string['longpost'] = 'Message long';
$string['mailnow'] = 'Envoyer les notifications de messages des forums sans délai de modification.';
$string['managesubscriptionsoff'] = 'Terminer la gestion des abonnements';
$string['managesubscriptionson'] = 'Gérer les abonnés';
$string['manydiscussions'] = 'Discussions par page';
$string['markalldread'] = 'Marquer tous les messages de cette discussion comme lus.';
$string['markallread'] = 'Marquer tous les messages de ce forum comme lus.';
$string['markasreadonnotification'] = 'Lors de l\'envoi des notifications de messages de forums';
$string['markasreadonnotification_help'] = 'Il est possible de choisir si un message de forum doit être marqué comme lu ou non lorsque l\'on reçoit la notification de ce message de forum.';
$string['markasreadonnotificationno'] = 'Ne pas marquer le message comme lu';
$string['markasreadonnotificationyes'] = 'Marquer le message comme lu';
$string['markread'] = 'Marquer comme lu';
$string['markreadbutton'] = 'Marquer<br />comme lu';
$string['markunread'] = 'Marquer comme non lu';
$string['markunreadbutton'] = 'Marquer comme<br />non lu';
$string['maxattachments'] = 'Nombre maximal d\'annexes';
$string['maxattachments_help'] = 'Ce réglage vous permet de spécifier le nombre maximal d\'annexes de chaque message de forum.';
$string['maxattachmentsize'] = 'Taille maximale de l\'annexe';
$string['maxattachmentsize_help'] = 'Ce réglage détermine la taille maximale de chaque fichier joint à un message de forum.';
$string['maxtimehaspassed'] = 'Le délai pour modifier ce message ({$a}) est échu';
$string['message'] = 'Message';
$string['messageinboundattachmentdisallowed'] = 'Impossible de poster votre réponse, car elle comporte une annexe, ce qui n\'est pas autorisé dans ce forum.';
$string['messageinboundfilecountexceeded'] = 'Impossible de poster votre réponse, car elle comporte plus d\'annexes que le maximum autorisé dans ce forum ({$a->forum->maxattachments}).';
$string['messageinboundfilesizeexceeded'] = 'Impossible de poster votre réponse, car la taille totale des annexes ({$a->filesize}) dépasse la taille maximale permise dans ce forum ({$a->maxbytes}).';
$string['messageinboundforumhidden'] = 'Impossible de poster votre réponse, car le forum n\'est actuellement pas disponible.';
$string['messageinboundnopostforum'] = 'Impossible de poster votre réponse, car vous n\'avez pas les permissions requises pour écrire dans le forum {$a->forum->name} .';
$string['messageinboundthresholdhit'] = 'Impossible de poster votre réponse. Vous avez dépassé le nombre de messages fixé pour ce forum.';
$string['messageprovider:digests'] = 'Abonnements aux courriels quotidiens de forum';
$string['messageprovider:posts'] = 'Abonnements aux messages de forum';
$string['missingsearchterms'] = 'Le terme recherché suivant n\'apparaît que dans le code HTML de ce message :';
$string['modeflatnewestfirst'] = 'Réponses en ligne, la plus récente en premier';
$string['modeflatoldestfirst'] = 'Réponses en ligne, la plus ancienne en premier';
$string['modenested'] = 'Réponses emboîtées';
$string['modethreaded'] = 'Réponses en fils de discussions';
$string['modulename'] = 'Forum';
$string['modulename_help'] = 'Le module d\'activité forum permet aux participants de tenir des discussions asynchrones, c\'est-à-dire ne nécessitant pas leur participation au même moment.

Divers types de forums peuvent être choisis, comme un forum standard, où chacun peut lancer de nouvelles discussions à n\'importe quel moment, ou un forum où chaque participant doit lancer exactement une discussion, ou encore un forum de questions et réponses où ils doivent écrire un message avant de voir ceux des autres participants. L\'enseignant peut autoriser que des fichiers soit joints aux messages des forums.

Les images jointes sont affichées dans le message. Les participants peuvent s\'abonner à un forum afin de recevoir les messages des forums par courriel. L\'enseignant peut rendre l\'abonnement facultatif, obligatoire ou l\'empêcher complètement. Au besoin, les participants peuvent être empêchés de poster plus d\'un nombre donné de messages durant une période donnée, afin d\'éviter que l\'un d\'entre eux domine les discussions.

Les messages des forums peuvent être évalués par les enseignants ou les participants (évaluation par les pairs). Les évaluations sont combinées pour former une note qui est enregistrée dans le carnet de notes.

Les forums ont de nombreuses utilisations, comme :

* un espace de présentation pour que les participants à un cours apprennent à se connaître
* une tribune pour diffuser les informations du cours (à l\'aide d\'un forum d\'annonces avec abonnement imposé)
* un centre d\'aide où les enseignants et les participants peuvent donner des conseils
* une façon informelle de partager des documents entre participants (et éventuellement d\'évaluer par les pairs)
* poursuivre en ligne une discussion commencée lors d\'une session face à face
* un endroit pour des discussions réservées aux enseignants (avec un forum caché)
* pour des activités complémentaires, par exemple des problèmes ouverts où les participants peuvent suggérer des solutions
* un lieu social pour des discussions hors-sujet';
$string['modulenameplural'] = 'Forums';
$string['more'] = 'plus';
$string['movedmarker'] = '(Déplacée)';
$string['movethisdiscussionto'] = 'Déplacer cette discussion vers…';
$string['mustprovidediscussionorpost'] = 'Vous devez fournir l\'identifiant soit de la discussion, soit du message à exporter';
$string['myprofileotherdis'] = 'Discussions de forum';
$string['myprofileowndis'] = 'Mes discussions de forum';
$string['myprofileownpost'] = 'Mes messages de forum';
$string['namenews'] = 'Annonces';
$string['namenews_help'] = 'Le forum des annonces du cours est un forum spécial, destiné aux annonces. Il est automatiquement créé dans chaque nouveau cours. Un cours ne peut avoir qu\'un seul forum des annonces. Seuls les enseignants et administrateurs peuvent poster des annonces. Le bloc « Dernières annonces » affiche les annonces récentes.';
$string['namesocial'] = 'Forum informel';
$string['nameteacher'] = 'Forum des enseignants';
$string['newforumposts'] = 'Nouveaux messages dans les forums';
$string['nextdiscussiona'] = 'Discussion suivante : {$a}';
$string['noattachments'] = 'Ce message n\'a pas d\'annexe';
$string['nodiscussions'] = 'Il n\'y a pas encore de discussion dans ce forum';
$string['nodiscussionsstartedby'] = '{$a} n\'a lancé aucune discussion';
$string['nodiscussionsstartedbyyou'] = 'Vous n\'avez pas encore commencé de discussion';
$string['noguestpost'] = 'Les visiteurs anonymes n\'ont pas les permissions requises pour poster de messages.';
$string['noguestsubscribe'] = 'Les utilisateurs anonymes ne peuvent pas s\'abonner.';
$string['noguesttracking'] = 'Les visiteurs anonymes n\'ont pas les permissions requises pour modifier les options de suivi des forums.';
$string['nomorepostscontaining'] = 'Plus aucun message contenant « {$a} » n\'a été trouvé';
$string['nonews'] = 'Aucune annonce n\'a encore été publiée';
$string['noonecansubscribenow'] = 'L\'abonnement n\'est maintenant plus autorisé  ';
$string['nopermissiontosubscribe'] = 'Vous n\'avez pas les permissions requises pour voir les abonnés au forum';
$string['nopermissiontoview'] = 'Vous n\'avez pas les permissions requises pour voir ce message';
$string['nopostforum'] = 'Désolé, vous ne pouvez pas écrire dans ce forum';
$string['noposts'] = 'Aucun message';
$string['nopostsmadebyuser'] = '{$a} n\'a pas écrit de message';
$string['nopostsmadebyyou'] = 'Vous n\'avez pas écrit de message';
$string['noquestions'] = 'Il n\'y a pas encore de question dans ce forum';
$string['nosubscribers'] = 'Personne n\'est abonné à ce forum';
$string['notexists'] = 'La discussion n\'existe plus';
$string['nothingnew'] = 'Rien de neuf pour {$a}';
$string['notingroup'] = 'Vous devez faire partie d\'un groupe pour consulter ce forum.';
$string['notinstalled'] = 'Le module forum n\'est pas installé';
$string['notpartofdiscussion'] = 'Ce message n\'appartient pas à une discussion !';
$string['notrackforum'] = 'Ne pas signaler les messages non lus';
$string['notsubscribed'] = 'M\'abonner';
$string['noviewdiscussionspermission'] = 'Vous n\'avez pas les permissions requises pour voir les discussions de ce forum';
$string['nowallsubscribed'] = 'Vous êtes maintenant abonné à tous les forums de {$a}.';
$string['nowallunsubscribed'] = 'Vous êtes maintenant désabonné de tous les forums de {$a}.';
$string['nownotsubscribed'] = '{$a->name} ne sera pas informé des nouveaux messages de « {$a->forum} »';
$string['nownottracking'] = '{$a->name} ne désire plus le suivi des messages du forum « {$a->forum} ».';
$string['nowsubscribed'] = '{$a->name} sera informé des nouveaux messages de « {$a->forum} »';
$string['nowtracking'] = '{$a->name} désire le suivi des messages du forum « {$a->forum} ».';
$string['numposts'] = '{$a} messages';
$string['olderdiscussions'] = 'Discussions antérieures';
$string['oldertopics'] = 'Sujets antérieurs';
$string['oldpostdays'] = 'Délai de lecture';
$string['overviewnumpostssince'] = '{$a} messages depuis la dernière connexion';
$string['overviewnumunread'] = '{$a} messages non lus';
$string['page-mod-forum-discuss'] = 'Page de discussion du module forum';
$string['page-mod-forum-view'] = 'Page principale du module forum';
$string['page-mod-forum-x'] = 'Toute page du module forum';
$string['parent'] = 'Niveau supérieur';
$string['parentofthispost'] = 'Niveau supérieur de ce message';
$string['permalink'] = 'Permalien';
$string['pluginadministration'] = 'Administration forum';
$string['pluginname'] = 'Forum';
$string['postadded'] = '<p>Votre message a été enregistré.</p><p>Il vous est possible de le modifier pendant {$a}.</p>';
$string['postaddedsuccess'] = 'Votre message a été enregistré.';
$string['postaddedtimeleft'] = 'Il vous est possible de le modifier pendant {$a}.';
$string['postbymailsuccess'] = 'Votre message de forum intitulé « {$a->subject} » a été posté. Vous pouvez le lire ici : {$a->discussionurl}.';
$string['postbymailsuccess_html'] = 'Votre <a href="{$a->discussionurl}">message de forum</a> intitulé « {$a->subject} » a été posté.';
$string['postbyuser'] = '{$a->post} de {$a->user}';
$string['postincontext'] = 'Voir ce message dans son contexte';
$string['postmailinfolink'] = 'Ce message est une copie du message posté dans {$a->coursename}.

Pour y répondre, cliquez sur ce lien : {$a->replylink}';
$string['postmailnow'] = '<p>Ce message sera envoyé immédiatement à tous les participants abonnés à ce forum.</p>';
$string['postmailsubject'] = '{$a->courseshortname} : {$a->subject}';
$string['postrating1'] = 'Pas très pertinent';
$string['postrating2'] = 'Moyennement intéressant';
$string['postrating3'] = 'Plutôt pertinent';
$string['posts'] = 'Messages';
$string['postsmadebyuser'] = 'Messages écrits par {$a}';
$string['postsmadebyuserincourse'] = 'Messages écrits par {$a->fullname} dans {$a->coursename}';
$string['posttoforum'] = 'Envoyer';
$string['posttomygroups'] = 'Envoyer une copie à tous mes groupes';
$string['posttomygroups_help'] = 'Poste une copie de ce message dans tous les groupes auxquels vous avez accès. Les participants aux groupes auxquels vous n\'avez pas accès ne verront pas ce message.';
$string['postupdated'] = 'Votre message a été modifié';
$string['potentialsubscribers'] = 'Abonnés potentiels';
$string['prevdiscussiona'] = 'Discussion précédente : {$a}';
$string['privacy:digesttypenone'] = 'Aucune donnée concernant les préférences de type de courriel quotidien n\'est conservée pour ce forum.';
$string['privacy:digesttypepreference'] = 'Vous avez choisi de recevoir le type de courriel quotidien de forum suivant : {$a->type}.';
$string['privacy:discussionsubscriptionpreference'] = 'Vous avez choisi la préférence d\'abonnement de discussion suivante pour ce forum : {$a-> preference}';
$string['privacy:metadata:core_rating'] = 'Le forum utilise le sous-système d\'évaluation pour permettre l\'évaluation des messages.';
$string['privacy:metadata:core_tag'] = 'Le forum utilise le sous-système de tags pour permettre de tagger des messages.';
$string['privacy:metadata:forum_digests'] = 'Informations sur les préférences de courriel quotidien de chaque forum.';
$string['privacy:metadata:forum_digests:forum'] = 'Le forum auquel l\'abonnement est relié.';
$string['privacy:metadata:forum_digests:maildigest'] = 'La préférence de courriel quotidien.';
$string['privacy:metadata:forum_digests:userid'] = 'L\'identifiant de l\'utilisateur avec la préférence de courriel quotidien.';
$string['privacy:metadata:forum_discussions'] = 'Informations sur les discussions de forum qu\'un utilisateur a créé';
$string['privacy:metadata:forum_discussions:assessed'] = 'TODO - ce que ce champ enregistre';
$string['privacy:metadata:forum_discussions:name'] = 'Le nom de la discussion, tel que choisi par l\'auteur.';
$string['privacy:metadata:forum_discussions:timemodified'] = 'La date et l\'heure de la dernière modification de la discussion.';
$string['privacy:metadata:forum_discussion_subs'] = 'Informations sur les abonnements aux discussions de forum';
$string['privacy:metadata:forum_discussion_subs:discussionid'] = 'L\'identifiant de la discussion auquel l\'abonnement est relié.';
$string['privacy:metadata:forum_discussion_subs:preference'] = 'La date et l\'heure du début de l\'abonnement.';
$string['privacy:metadata:forum_discussion_subs:userid'] = 'L\'identifiant de l\'utilisateur qui s\'est abonné à la discussion.';
$string['privacy:metadata:forum_discussions:userid'] = 'L\'identifiant de l\'utilisateur qui a créé la discussion';
$string['privacy:metadata:forum_discussions:usermodified'] = 'L\'identifiant de l\'utilisateur qui a modifié en dernier la discussion.';
$string['privacy:metadata:forum_posts'] = 'Informations sur les préférences de courriel quotidiens de chaque forum.';
$string['privacy:metadata:forum_posts:created'] = 'La date et l\'heure de la création du message.';
$string['privacy:metadata:forum_posts:discussion'] = 'La discussion dans laquelle se trouvent les messages.';
$string['privacy:metadata:forum_posts:message'] = 'Le contenu du message de forum.';
$string['privacy:metadata:forum_posts:modified'] = 'La date et l\'heure de la dernière modification du message.';
$string['privacy:metadata:forum_posts:parent'] = 'Le message auquel il a été répondu.';
$string['privacy:metadata:forum_posts:subject'] = 'L\'objet du message de forum.';
$string['privacy:metadata:forum_posts:totalscore'] = 'Le contenu du message de forum.';
$string['privacy:metadata:forum_posts:userid'] = 'L\'identifiant de l\'utilisateur qui a écrit le message.';
$string['privacy:metadata:forum_queue'] = 'Journal temporaire des messages qui seront envoyés dans le courriel quotidien';
$string['privacy:metadata:forum_queue:discussionid'] = 'Identifiant de discussion de forum';
$string['privacy:metadata:forum_queue:postid'] = 'Identifiant de message de forum';
$string['privacy:metadata:forum_queue:timemodified'] = 'La date et l\'heure de modification du message original';
$string['privacy:metadata:forum_queue:userid'] = 'L\'utilisateur qui doit être notifié du message';
$string['privacy:metadata:forum_read'] = 'Informations sur les messages consultés par l\'utilisateur.';
$string['privacy:metadata:forum_read:discussionid'] = 'La discussion dans laquelle se trouve le message.';
$string['privacy:metadata:forum_read:firstread'] = 'La date et l\'heure de la première consultation du message.';
$string['privacy:metadata:forum_read:lastread'] = 'La date et l\'heure de la consultation la plus récente du message.';
$string['privacy:metadata:forum_read:postid'] = 'Le message qui a été consulté.';
$string['privacy:metadata:forum_read:userid'] = 'L\'identifiant de l\'utilisateur auquel l\'enregistrement est relié.';
$string['privacy:metadata:forum_subscriptions'] = 'Informations sur les forums auxquels l\'utilisateur est abonné.';
$string['privacy:metadata:forum_subscriptions:forum'] = 'Le forum auquel on s\'est abonné.';
$string['privacy:metadata:forum_subscriptions:userid'] = 'L\'identifiant de l\'utilisateur auquel cet abonnement de forum est relié.';
$string['privacy:metadata:forum_track_prefs'] = 'Les informations sur les forums dans lesquels l\'utilisateur a choisi de suivre les messages consultés.';
$string['privacy:metadata:forum_track_prefs:forumid'] = 'Le forum dans lequel le suivi des messages est activé.';
$string['privacy:metadata:forum_track_prefs:userid'] = 'L\'identifiant de l\'utilisateur auquel la préférence de suivi des messages de ce forum est reliée.';
$string['privacy:metadata:preference:autosubscribe'] = 'S\'il faut s\'abonner aux discussions lorsqu\'on répond à ses messages.';
$string['privacy:metadata:preference:maildigest'] = 'La préférence globale des courriels quotidiens';
$string['privacy:metadata:preference:markasreadonnotification'] = 'S\'il faut marquer les messages comme lus quand on les reçoit par messagerie.';
$string['privacy:metadata:preference:trackforums'] = 'S\'il faut activer le suivi des messages.';
$string['privacy:postwasread'] = 'Ce message a été consulté pour la première fois le {$a->firstread} et consulté pour la dernière fois le {$a->lastread}';
$string['privacy:readtrackingdisabled'] = 'Vous avez choisi de ne pas suivre les messages que vous avez consultés dans ce forum.';
$string['privacy:request:delete:discussion:name'] = 'Supprimé à la demande de l\'auteur';
$string['privacy:request:delete:post:message'] = 'Le contenu de ce message a été supprimé à la demande de son auteur.';
$string['privacy:request:delete:post:subject'] = 'Supprimer à la demande de l\'auteur';
$string['privacy:subscribedtoforum'] = 'Vous êtes abonné à ce forum.';
$string['processingdigest'] = 'Traitement du courriel quotidien de l\'utilisateur {$a}';
$string['processingpost'] = 'Enregistrement du message {$a}';
$string['prune'] = 'Séparer';
$string['prunedpost'] = 'Une nouvelle discussion a été créée à partir de ce message';
$string['pruneheading'] = 'Séparer la discussion et déplacer ce message vers une nouvelle discussion';
$string['qandaforum'] = 'Forum questions/réponses';
$string['qandanotify'] = 'Ce forum est un forum « Questions et Réponses ». Pour voir les autres réponses à ces questions, vous devez d\'abord écrire votre propre réponse';
$string['re'] = 'Re:';
$string['readtherest'] = 'Lire le reste de la discussion';
$string['removeallforumtags'] = 'Supprimer tous les tags de forum';
$string['replies'] = 'Réponses';
$string['repliesmany'] = '{$a} réponses';
$string['repliesone'] = '{$a} réponse';
$string['reply'] = 'Répondre';
$string['replyforum'] = 'Répondre au forum';
$string['reply_handler'] = 'Ce gestionnaire permet de répondre aux messages des forums par courriel';
$string['reply_handler_name'] = 'Réponse aux messages des forums';
$string['replytopostbyemail'] = 'Vous pouvez répondre à ce message par courriel.';
$string['replytouser'] = 'Utiliser l\'adresse de l\'auteur';
$string['resetdigests'] = 'Supprimer toutes les préférences des utilisateurs pour les courriels quotidiens de forum';
$string['resetforums'] = 'Supprimer les messages du';
$string['resetforumsall'] = 'Supprimer tous les messages';
$string['resetsubscriptions'] = 'Supprimer tous les abonnements aux forums';
$string['resettrackprefs'] = 'Supprimer toutes les préférences de suivi des messages de forum';
$string['rssarticles'] = 'Nombre d\'articles récents RSS';
$string['rssarticles_help'] = '<p>Cette option vous permet de fixer le nombre d\'articles récents à inclure dans le flux RSS.</p>

<p>Un nombre entre 5 et 20 est adéquat pour la plupart des forums. Si le forum est très actif, il est souhaitable d\'augmenter ce nombre.</p>';
$string['rsssubscriberssdiscussions'] = 'Flux RSS des discussions';
$string['rsssubscriberssposts'] = 'Flux RSS des messages';
$string['rsstype'] = 'Flux RSS de cette activité';
$string['rsstypedefault'] = 'Type de flux RSS';
$string['rsstype_help'] = 'Pour activer le flux RSS de cette activité, choisissez soit les discussions, soit les messages à inclure dans le flux.';
$string['search'] = 'Rechercher';
$string['search:activity'] = 'Forum – information sur l\'activité';
$string['searchdatefrom'] = 'Dans les messages postérieurs à';
$string['searchdateto'] = 'Dans les messages antérieurs à';
$string['searchforumintro'] = 'Veuillez saisir les termes à rechercher dans l\'un ou plusieurs des champs ci-dessous :';
$string['searchforums'] = 'Recherche (forums)';
$string['searchfullwords'] = 'Mots entiers';
$string['searchnotwords'] = 'Termes à exclure';
$string['searcholderposts'] = 'Rechercher les anciens messages…';
$string['searchphrase'] = 'Phrase exacte dans le corps du message';
$string['search:post'] = 'Forum – messages';
$string['searchresults'] = 'Résultats de la recherche';
$string['searchsubject'] = 'Terme dans le sujet du message';
$string['searchtags'] = 'Est tag avec';
$string['searchuser'] = 'Nom de l\'auteur';
$string['searchuserid'] = 'Identifiant (Moodle ID) de l\'auteur';
$string['searchwhichforums'] = 'Rechercher dans quels forums ?';
$string['searchwords'] = 'Termes apparaissant n\'importe où dans le message';
$string['seeallposts'] = 'Afficher tous les messages écrits par cet utilisateur';
$string['shortpost'] = 'Message court';
$string['showsubscribers'] = 'Afficher/modifier les abonnés à ce forum';
$string['singleforum'] = 'Une seule discussion';
$string['smallmessage'] = '{$a->user} a écrit dans {$a->forumname}';
$string['smallmessagedigest'] = 'Courriel quotidien contenant {$a} messages de forum';
$string['startedby'] = 'lancée par';
$string['subject'] = 'Sujet';
$string['subscribe'] = 'S\'abonner à ce forum';
$string['subscribeall'] = 'Abonner tous les participants';
$string['subscribed'] = 'Abonné';
$string['subscribediscussion'] = 'S\'abonner à cette discussion';
$string['subscribeenrolledonly'] = 'Seuls les utilisateurs inscrits au cours sont autorisés à s\'abonner aux notifications des messages des forums.';
$string['subscribenone'] = 'Désabonner tous les participants';
$string['subscribers'] = 'Abonnés';
$string['subscriberstowithcount'] = 'Abonnés à « {$a->name} » ({$a->count})';
$string['subscribestart'] = 'M\'envoyer par courriel les notifications de nouveaux messages dans ce forum';
$string['subscribestop'] = 'Ne pas m\'envoyer par courriel de notification des nouveaux messages dans ce forum';
$string['subscription'] = 'Abonnement';
$string['subscriptionandtracking'] = 'Inscription et suivi des messages';
$string['subscriptionauto'] = 'Abonnement automatique';
$string['subscriptiondisabled'] = 'Abonnement désactivé';
$string['subscriptionforced'] = 'Abonnement imposé';
$string['subscription_help'] = 'Si vous êtes abonné à un forum, vous recevrez par courriel une notification des nouveaux messages postés sur ce forum. Habituellement, vous pouvez décider de vous abonner, mais dans certains forums, l\'abonnement est imposé, de sorte que tout le monde reçoit les notifications.';
$string['subscriptionmode'] = 'Mode d\'abonnement';
$string['subscriptionmode_help'] = 'Lorsqu\'un participant est abonné à un forum, il reçoit par courriel une copie de tous les messages postés sur ce forum. Il existe 4 modes pour cet abonnement :

* Abonnement facultatif : les participants peuvent décider de s\'abonner ou non.
* Abonnement imposé : tous les participants sont abonnés et ne peuvent pas se désabonner.
* Abonnement automatique : tous les participants sont initialement abonnés, mais peuvent choisir de se désabonner quand ils le veulent.
* Abonnement désactivé : l\'abonnement n\'est pas autorisé.';
$string['subscriptionoptional'] = 'Abonnement facultatif';
$string['subscriptions'] = 'Abonnements';
$string['tagarea_forum_posts'] = 'Messages de forum';
$string['tagsdeleted'] = 'Les tags de forum ont été supprimés';
$string['thisforumisthrottled'] = 'Ce forum a une limite du nombre de messages que vous pouvez poster durant une période donnée. Cette limite est actuellement de {$a->blockafter} message(s) durant {$a->blockperiod}';
$string['timedhidden'] = 'Temporisation : caché pour les étudiants';
$string['timedposts'] = 'Messages temporisés';
$string['timedvisible'] = 'Temporisation : visible pour tous les utilisateurs';
$string['timestartenderror'] = 'La date de fin d\'affichage ne peut pas être antérieure à la date du début de l\'affichage';
$string['trackforum'] = 'Activer le suivi des messages';
$string['tracking'] = 'Suivi des messages';
$string['trackingoff'] = 'Désactivé';
$string['trackingon'] = 'Imposé';
$string['trackingoptional'] = 'Facultatif';
$string['trackingtype'] = 'Suivi des messages';
$string['trackingtype_help'] = 'Le suivi des messages permet aux participants de vérifier facilement les messages qu\'ils n\'ont pas encore vu en les surlignant.

Si le réglage est mis sur « Facultatif », les participants peuvent activer ou désactiver à discrétion le suivi des messages dans le menu des actions ou le bloc d\'administration, selon le thème (le suivi des messages doit d\'abord être activé dans leurs préférences de forum).

Si le réglage « Permettre d\'imposer le suivi des messages » est activé dans l\'administration de la plateforme, une option supplémentaire est affichée : « Imposé ». Le suivi est alors toujours activé, indépendamment des préférences de forum de l\'utilisateur.';
$string['trackreadposts_header'] = 'Suivi des messages de forum';
$string['unread'] = 'Non lu';
$string['unreadposts'] = 'Messages non lus';
$string['unreadpostsnumber'] = '{$a} messages non lus';
$string['unreadpostsone'] = '1 message non lu';
$string['unsubscribe'] = 'Se désabonner de ce forum';
$string['unsubscribeall'] = 'Se désabonner de tous les forums';
$string['unsubscribeallconfirm'] = 'Vous êtes actuellement abonné à {$a->forums} forums et à {$a->discussions} discussions. Voulez-vous vraiment vous désabonner de tous les forums et discussions, ainsi que désactiver l\'abonnement automatique aux discussions ?';
$string['unsubscribeallconfirmdiscussions'] = 'Vous êtes actuellement abonné à {$a->discussions} discussions. Voulez-vous vraiment vous désabonner de toutes les discussions et désactiver l\'abonnement automatique aux discussions ?';
$string['unsubscribeallconfirmforums'] = 'Vous êtes actuellement abonné à {$a->forums} forums. Voulez-vous vraiment vous désabonner de tous les forums et désactiver l\'abonnement automatique aux discussions ?';
$string['unsubscribealldone'] = 'Tous vos abonnements ont été annulés. Vous recevrez encore les notifications de messages des forums pour lesquels l\'abonnement est imposé. Vous pouvez modifier la notification des messages dans les réglages de votre profil.';
$string['unsubscribeallempty'] = 'Vous n\'êtes abonné à aucun forum. Si vous voulez désactiver toutes les notifications de ce serveur, modifiez la notification des messages dans les réglages de votre profil.';
$string['unsubscribed'] = 'Désabonné';
$string['unsubscribediscussion'] = 'Se désabonner de cette discussion';
$string['unsubscribediscussionlink'] = 'Me désabonner de cette discussion : {$a}';
$string['unsubscribelink'] = 'Me désabonner de ce forum : {$a}';
$string['unsubscribeshort'] = 'Désabonner';
$string['usermarksread'] = 'Marquage manuel des messages lus';
$string['viewalldiscussions'] = 'Afficher toutes les discussions';
$string['viewthediscussion'] = 'Consulter la discussion';
$string['warnafter'] = 'Nombre de messages avant notification';
$string['warnafter_help'] = 'Les participants peuvent être avertis lorsque le nombre de messages écrits s\'approche du nombre maximal autorisé dans une période donnée. Ce réglage détermine après combien de messages écrits ils recevront cette notification. Les utilisateurs ayant la capacité mod/forum:postwithoutthrottling ne sont pas touchés par les limites de message.';
$string['warnformorepost'] = 'Attention ! Il y a plus d\'une discussion dans ce forum. La plus récente sera utilisée';
$string['yournewquestion'] = 'Nouvelle question';
$string['yournewtopic'] = 'Nouveau sujet de discussion';
$string['yourreply'] = 'Votre réponse';
