<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_oauth2', language 'cs', branch 'MOODLE_36_STABLE'
 *
 * @package   tool_oauth2
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['authconfirm'] = 'Tato akce udělí přístup k Moodle pro ověřený účet. To je určeno pro použití systémového účtu pro správu souborů vlastněných společností Moodle.';
$string['authconnected'] = 'Systémový účet je nyní připojen pro off-line přístup';
$string['authnotconnected'] = 'Systémový účet není nyní připojen pro off-line přístup';
$string['configured'] = 'Nakonfigurován';
$string['configuredstatus'] = 'Nakonfigurován';
$string['connectsystemaccount'] = 'Připojení k systémovému účtu';
$string['createfromtemplate'] = 'Vytvoření služby OAuth 2 ze šablony';
$string['createfromtemplatedesc'] = 'Vyberte jednu z níže uvedených šablon služeb OAuth 2 a vytvořte službu OAuth s platnou konfigurací pro jeden z typů služeb. Tím vytvoříte službu OAuth 2 se všemi správnými koncovými body a parametry požadovanými pro ověření, ale ještě před tím, než je použijete, musíte zadat ID klienta a klíč nové služby.';
$string['createnewendpoint'] = 'Vytvořit nový koncový bod poskytovatele "{$a}"';
$string['createnewfacebookissuer'] = 'Vytvořit novou službu Facebook';
$string['createnewgoogleissuer'] = 'Vytvořit novou službu Google';
$string['createnewissuer'] = 'Vytvořit novou vlastní službu';
$string['createnewmicrosoftissuer'] = 'Vytvořit novou službu Microsoft';
$string['createnewnextcloudissuer'] = 'Vytvořit novou službu Nextcloud';
$string['createnewuserfieldmapping'] = 'Vytvořit nové mapování uživatelského pole poskytovatele "{$a}"';
$string['deleteconfirm'] = 'Jste si jisti, že chcete odstranit poskytovatele identity';
$string['deleteendpointconfirm'] = 'Opravdu chcete smazat koncový bod "{$a-> endpoint}" pro poskytovatele "{$a-> emitent}"? Všechny moduly závislé na tomto koncovém bodu přestanou fungovat.';
$string['deleteuserfieldmappingconfirm'] = 'Jste si jistí, že chcete odstranit mapování uživatelského pole poskytovatele "{$a}"?';
$string['discovered'] = 'Zjišťování služby bylo úspěšné';
$string['discovered_help'] = 'Zjišťování znamená, že koncové body OAuth2 mohou být automaticky určeny z adresy URL pro službu OAuth. Ne všechny služby vyžadují, aby byly "objeveny", ale pokud nejsou, je třeba zadat koncové body a informace o mapování uživatelů ručně.';
$string['discoverystatus'] = 'Zjištění služby';
$string['editendpoint'] = 'Upravit koncový bod: {$a->endpoint}  poskytovatele {$a->issuer}';
$string['editendpoints'] = 'Konfigurace koncových bodů';
$string['editissuer'] = 'Upravit poskytovatele identity: {$a}';
$string['edituserfieldmapping'] = 'Upravit mapování uživatelského pole poskytovatele {$a}';
$string['edituserfieldmappings'] = 'Konfigurovat mapování uživatelského pole';
$string['endpointdeleted'] = 'Koncový bod odstraněn';
$string['endpointname'] = 'Název';
$string['endpointname_help'] = 'Klíč slouží k vyhledání tohoto koncového bodu. Musí skončit s "_endpoint".';
$string['endpointsforissuer'] = 'Koncový bod poskytovatele: {$a}';
$string['endpointurl'] = 'URL';
$string['endpointurl_help'] = 'Adresa URL tohoto koncového bodu. Musí používat protokol https://.';
$string['issueralloweddomains'] = 'Přihlášení na domény';
$string['issueralloweddomains_help'] = 'Je-li nastaveno, je toto nastavení seznamu domén, oddělených čárkami, které budou omezeny při přihlašování k tomuto poskytovateli.';
$string['issuerbaseurl'] = 'Base URL služeb';
$string['issuerbaseurl_help'] = 'Base URL  se používá pro přístup ke službě';
$string['issuerclientid'] = 'Id klienta';
$string['issuerclientid_help'] = 'ID klienta OAuth pro tohoto poskytovatele.';
$string['issuerclientsecret'] = 'Heslo klienta';
$string['issuerclientsecret_help'] = 'Heslo klienta OAuth pro tohoto poskytovatele.';
$string['issuerdeleted'] = 'Poskytovatel identity odstraněn';
$string['issuerdisabled'] = 'Poskytovatel identity zakázán';
$string['issuerenabled'] = 'Poskytovatel identity povolen';
$string['issuerimage'] = 'URL loga';
$string['issuerimage_help'] = 'Adresa URL obrázku, který se používá pro zobrazení tohoto poskytovatele. Může se zobrazit na přihlašovací stránce.';
$string['issuerloginparams'] = 'Další parametry zahrnuté v požadavku přihlášení.';
$string['issuerloginparams_help'] = 'Některé systémy vyžadují další parametry pro přihlášení, aby si mohli přečíst základní profil uživatelů.';
$string['issuerloginparamsoffline'] = 'Další parametry zahrnuté v požadavku přihlášení pro přístup offline.';
$string['issuerloginparamsoffline_help'] = 'Každý OAuth systém definuje jiný způsob, jak požádat o přístup v režimu offline. Např. Google vyžaduje dodatečné parametry: "access_type=offline&prompt=consent".  Tyto parametry by měly být ve formátu url dotazu.';
$string['issuerloginscopes'] = 'Rozsahy zahrnuté v požadavku přihlášení.';
$string['issuerloginscopes_help'] = 'Některé systémy vyžadují další požadavky pro přihlášení, aby si mohli přečíst základní profil uživatelů. Standardní rozsahy systému kompatibilních s OpenID Connect jsou "e-mail s otevřeným profilem".';
$string['issuerloginscopesoffline'] = 'Rozsahy zahrnuté v požadavku přihlášení pro přístup offline.';
$string['issuerloginscopesoffline_help'] = 'Každý OAuth systém definuje jiný způsob, jak požádat o přístup v režimu offline. Např. Microsoft vyžaduje další prostor "offline_access".';
$string['issuername'] = 'Název';
$string['issuername_help'] = 'Jméno poskytovatel identity. Může se zobrazit na přihlašovací stránce.';
$string['issuerrequireconfirmation'] = 'Požadovat ověření e-mailem';
$string['issuerrequireconfirmation_help'] = 'Požádejte, aby si všichni uživatelé ověřili svou e-mailovou adresu, než se budou hlásit pomocí služby OAuth. To se týká nově vytvořených účtů v rámci přihlašovacího procesu nebo když je stávající účet Moodle připojen k přihlašování OAuth prostřednictvím odpovídajících e-mailových adres.';
$string['issuers'] = 'Poskytovatelé';
$string['issuersetup'] = 'Podrobné pokyny pro konfiguraci běžných služeb OAuth 2';
$string['issuersetuptype'] = 'Podrobné informace o nastavení protokolu OAuth 2 poskytovatele {$a}';
$string['issuershowonloginpage'] = 'Zobrazit na přihlašovací stránce';
$string['issuershowonloginpage_help'] = 'Je-li povolen modul OAuth 2, bude tento poskytovatel zobrazen na přihlašovací stránce, aby uživatelé mohli přihlásit se k účtům od tohoto poskytovatele.';
$string['loginissuer'] = 'Povolit přihlášení';
$string['notconfigured'] = 'Není nakonfigurováno';
$string['notdiscovered'] = 'Zjištění služby nebylo úspěšné';
$string['notloginissuer'] = 'Zakázat přihlášení';
$string['pluginname'] = 'Služby OAuth 2';
$string['privacy:metadata'] = 'Modul Služby OAuth 2 neukládá žádné osobní údaje.';
$string['savechanges'] = 'Uložit změny';
$string['serviceshelp'] = 'Pokyny k nastavení služeb poskytovatele.';
$string['systemaccountconnected'] = 'Připojen systémový účet';
$string['systemaccountconnected_help'] = 'Systémové účty se používají v modulech z realizaci pokročilých funkcí. Nejsou požadovány pouze pro funkce přihlášení, ale jiné moduly používající službu OAuth mohou nabízet omezenou sadu funkcí, pokud nebyl připojen systémový účet. Například repozitáře nemohou bez systémového účtu zpracovat "řízené odkazy" pro provádění operací se soubory.';
$string['systemaccountnotconnected'] = 'Systémový účet není připojen';
$string['systemauthstatus'] = 'Připojen systémový účet';
$string['usebasicauth'] = 'Autentizace tokenu vyžaduje záhlaví HTTP';
$string['usebasicauth_help'] = 'Při odesílání ID klienta a hesla pomocí požadavku na obnovení tokenu použijte schéma ověřování HTTP Basic . Je doporučeno standardem OAuth 2, ale u některých emitentů nemusí být k dispozici.';
$string['userfieldexternalfield'] = 'Jméno externího pole';
$string['userfieldexternalfield_error'] = 'Toto pole nemůže obsahovat kód HTML.';
$string['userfieldexternalfield_help'] = 'Název příslušného pole externího OAuth systému.';
$string['userfieldinternalfield'] = 'Jméno interního pole';
$string['userfieldinternalfield_help'] = 'Název uživatelského pole Moodle, který by měl být mapován z externího pole.';
$string['userfieldmappingdeleted'] = 'Mapování uživatelského pole odstraněno';
$string['userfieldmappingsforissuer'] = 'Mapování uživatelského pole poskytovatele: {$a}';
