<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'hub', language 'cs', branch 'MOODLE_36_STABLE'
 *
 * @package   hub
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addscreenshots'] = 'Přidat snímky obrazovky';
$string['advertise'] = 'Sdílet tento kurz, aby se lidé mohli připojit';
$string['advertised'] = 'Pro připojené';
$string['advertiseon'] = 'Sdílet tento kurz na {$a}';
$string['advertiseonhub'] = 'Sdílet tento kurz, aby se lidé mohli připojit';
$string['advertiseonmoodleorg'] = 'Inzerujte tento kurz na moodle.org';
$string['advertisepublication_help'] = 'Tento kurz bude uveden na Moodle.net jako kurz, který si lidé mohou zapsat a zúčastnit se. Na webu by mělo být povoleno přihlašování na základě e-mailu a povolen zápis do tohoto kurzu.';
$string['all'] = 'Vše';
$string['allowglobalsearch'] = 'Zveřejněním tohoto úložiště umožníte globální vyhledání vašich kurzů';
$string['allowpublicsearch'] = 'Zveřejněte toto úložiště a ostatní se k němu budou moci připojit';
$string['audience'] = 'Cílová skupina';
$string['audienceadmins'] = 'Správci Moodle';
$string['audienceeducators'] = 'Učitelé';
$string['audience_help'] = 'Pro koho je tento kurz primárně určen.';
$string['audiencestudents'] = 'Studenti';
$string['badgesnumber'] = 'Počet odznaků  ({$a})';
$string['badurlformat'] = 'Neplatný formát URL';
$string['cannotsearchcommunity'] = 'Na zobrazení této stránky nemáte potřebná oprávnění';
$string['community'] = 'Komunita';
$string['communityremoved'] = 'Tento odkaz na kurz byl odstraněn z vašeho seznamu';
$string['completeregistration'] = 'Dokončení registrace na Moodle.net';
$string['confirmregistration'] = 'Potvrdit registraci';
$string['contactable'] = 'Zveřejnit kontaktní údaje';
$string['contactable_help'] = 'Nastavíte-li ano, server zobrazí vaši emailovou adresu.';
$string['contactemail'] = 'E-mail';
$string['contactname'] = 'Jméno';
$string['contactphone'] = 'Telefon';
$string['contactphone_help'] = 'Telefonní čísla se zobrazují pouze správcům komunitních úložišť, nejsou dostupná široké veřejnosti.';
$string['continue'] = 'Pokračovat';
$string['contributornames'] = 'Další přispěvovatelé';
$string['contributornames_help'] = 'Toto pole můžete použít pro zobrazení jmen všech ostatních, kteří přispěli tomuto kurzu.';
$string['coursemap'] = 'Mapa kurzu';
$string['coursename'] = 'Název';
$string['courseprivate'] = 'Soukromé';
$string['coursepublic'] = 'Veřejné';
$string['coursepublished'] = 'Tento kurz byl úspěšně sdílen na "{$a}".';
$string['courseshortname'] = 'Krátký název';
$string['courseshortname_help'] = 'Zadejte krátký název vašeho kurzu. Není nutné aby byl jedinečný.';
$string['coursesnumber'] = 'Počet kurzů ({$a})';
$string['courseunpublished'] = 'Kurz {$a->courseshortname} již není na {$a->hubname} sdílen.';
$string['courseurl'] = 'URL kurzu';
$string['courseurl_help'] = 'Toto je URL vašeho kurzu. URL se zobrazuje v podobě odkazu ve výsledcích hledání.';
$string['creatorname'] = 'Tvůrce';
$string['creatorname_help'] = 'Tvůrcem je ten kdo vytvořil tento kurz.';
$string['creatornotes'] = 'Metodické poznámky';
$string['creatornotes_help'] = 'Metodické poznámky slouží jako návod pro učitele o tom, jak používat tento kurz.';
$string['deletescreenshots'] = 'Odstranit tyto snímky obrazovky';
$string['deletescreenshots_help'] = 'Smazat všechny nahrané snímky obrazovek.';
$string['demourl'] = 'URL dema';
$string['demourl_help'] = 'Zadejte URL dema tohoto kurzu. Standardně je jím URL tohoto kurzu. URL dema se zobrazuje jako odkaz ve výsledcích hledání.';
$string['description'] = 'Popis ';
$string['description_help'] = 'Popisný text se bude zobrazovat v seznamu kurzů na Moodle.net.';
$string['detectednotexistingpublication'] = '{$a->hubname} zobrazuje kurzy, které již více neexistují. Upozorněte správce tohoto úložiště {$a->hubname}, že mohou odstranit publikační číslo {$a->id}.';
$string['downloadable'] = 'Ke stažení';
$string['educationallevel'] = 'Úroveň vzdělávání';
$string['educationallevel_help'] = 'Vyberte odpovídající úroveň vzdělávání, které odpovídá obsah kurzu.';
$string['edulevelassociation'] = 'Sdružení';
$string['edulevelcorporate'] = 'Korporační';
$string['edulevelgovernment'] = 'Vládní';
$string['edulevelother'] = 'Jiná';
$string['edulevelprimary'] = 'Primární';
$string['edulevelsecondary'] = 'Sekundární';
$string['eduleveltertiary'] = 'Terciální';
$string['emailalert'] = 'Upozornění emailem';
$string['emailalert_help'] = 'Jakmile toto povolíte, budou vás správci komunitních úložišť upozorňovat emailem o bezpečnostních chybách a jiných důležitých novinkách.';
$string['enrollable'] = 'Lze se zapsat';
$string['errorbadimageheightwidth'] = 'Obrázek by měl mít rozměry maximálně {$a->width} x {$a->height}';
$string['errorcourseinfo'] = 'Došlo k chybě při získávání metadat z ({$a}). Zkuste to prosím znovu obnovením této stránky. Také můžete pokračovat v procesu registrace s následujícími výchozími metadaty.';
$string['errorcoursepublish'] = 'Při zveřejnění kurzu ({$a}) došlo k chybě. Zkuste to prosím později znovu.';
$string['errorcoursewronglypublished'] = 'Moodle.net vrátil chybu publikace kurzu. Zkuste to prosím později.';
$string['errorcron'] = 'Při aktualizaci registrace na "{$a->hubname}" došlo k následující chybě: {$a->errormessage}';
$string['errorcronnoxmlrpc'] = 'Pro aktualizaci registrace musí být povoleno XML-RPC.';
$string['errorhublisting'] = 'Došlo k chybě při získávání seznamu úložišť ze serveru Moodle, zkuste to prosím později. ({$a})';
$string['errorlangnotrecognized'] = 'Kód jazyka není znám v Moodle. Kontaktujte prosím {$a}';
$string['errorotherhubsnotsupported'] = 'Tuto stránku již nelze použít pro registraci do adresářů vlastních stránek.';
$string['errorregistration'] = 'Došlo k nějaké chybě při registraci, zkuste to prosím později. ({$a})';
$string['errorregistrationupdate'] = 'Během aktualizace registrace došlo k chybě ({$a})';
$string['errorunpublishcourses'] = 'Kvůli neočekávané chybě nemohl být kurz odstraněn z Moodle.net. Zkuste to prosím později (doporučuje se), nebo kontaktujte správce serveru.';
$string['errorws'] = '{$a}';
$string['errorwstokenreset'] = '{$a}. Registrační token na tomto webu byl resetován. Nyní můžete znovu zaregistrovat své stránky.';
$string['existingscreenshotnumber'] = 'Počet snímků: {$a}. Tyto snímky obrazovky se zde budou zobrazovat jakmile správce Moodle.net schválí váš kurz.';
$string['existingscreenshots'] = 'Existující snímky obrazovky';
$string['forceunregister'] = 'Ano, smazat registrační údaje';
$string['forceunregisterconfirmation'] = 'Váš web nemůže přejít na {$a}. Tento server může být dočasně mimo provoz. Pokud si nejste jistí, že chcete pokračovat a odstranit registraci lokálně, prosím zrušte tento proces a zkuste to později znovu.';
$string['geolocation'] = 'Geolokace';
$string['geolocation_help'] = 'V dalších verzích bude možné vyhledávat kurzy podle umístění. Zde můžete určit vaši zeměpisnou šířku a výšku (např. -31.947884,115.871285). Tuto informaci zjistíte např. na mapách Google.';
$string['hub'] = 'Komunitní úložiště';
$string['imageurl'] = 'URL obrázku';
$string['imageurl_help'] = 'Tento obrázek se bude zobrazovat na serveru. Obrázek musí být kdykoliv k dispozici serveru. Maximální velikost obrázku je {$a->width} X {$a->height}';
$string['information'] = 'Informace';
$string['issuedbadgesnumber'] = 'Počet vydaných odznaků ({$a})';
$string['language'] = 'Jazyk';
$string['language_help'] = 'Hlavní jazyk tohoto kurzu.';
$string['lasttimechecked'] = 'Datum poslední kontroly';
$string['licence'] = 'Licence';
$string['licence_help'] = 'Vyberte licenci, pod kterou se bude váš kurz distribuovat.';
$string['logourl'] = 'URL loga';
$string['mobilenotificationsenabled'] = 'Povoleny oznámení na mobilním zařízení ({$a})';
$string['mobileservicesenabled'] = 'Povoleny mobilní služby  ({$a})';
$string['modulenumberaverage'] = 'Průměrný počet modulů kurzu ({$a})';
$string['moodleorg'] = 'Moodle';
$string['mustselectsubject'] = 'Musíte zvolit téma';
$string['name'] = 'Název';
$string['name_help'] = 'Tento název se bude zobrazovat v seznamu kurzů.';
$string['neverchecked'] = 'Nikdy nekontrolováno';
$string['next'] = 'Další';
$string['no'] = 'Ne';
$string['nocheckstatusfromunreghub'] = 'Stránky nejsou registrovány na úložišti, jejich stav nemohl být zkontrolován.';
$string['nohubselected'] = 'Není vybráno žádné komunitní úložiště';
$string['none'] = 'Žádný';
$string['nosearch'] = 'Nepublikovat úložiště ani kurzy';
$string['notregisteredonhub'] = 'Před sdílením nějakého kurzu musí váš správce registrovat váš server na Moodle.net.';
$string['notregisteredonmoodleorg'] = 'Správce musí zaregistrovat tento web na moodle.org';
$string['operation'] = 'Akce';
$string['orenterprivatehub'] = 'Případně zadejte URL nějakého soukromého úložiště:';
$string['participantnumberaverage'] = 'Průměrný počet přispívajících ({$a})';
$string['policyagreed'] = 'Oznámení o ochraně osobních údajů a souhlas se zpracováním dat';
$string['policyagreeddesc'] = 'Souhlasím s  <a href="{$a}" target="_blank" oznámením o ochraně osobních údajů a smlouvou o zpracování dat </a>';
$string['postaladdress'] = 'Poštovní adresa';
$string['postaladdress_help'] = 'Poštovní adresa tohoto webu nebo organizace těchto stránek.';
$string['postsnumber'] = 'Počet příspěvků ({$a})';
$string['previousregistrationdeleted'] = 'Předchozí registrace byla smazána z {$a}. Registrační proces můžete spustit znovu. Děkujeme vám.';
$string['prioritise'] = 'Upřednostnit';
$string['privacy'] = 'Soukromí';
$string['privacy_help'] = 'Úložiště může zobrazovat seznam registrovaných serverů. Zde můžete nastavit, zda chcete na tomto seznamu zobrazovat i váš server.';
$string['private'] = 'Soukromý';
$string['privatehuburl'] = 'URL soukromého úložiště';
$string['publicationinfo'] = 'Informace o vydání kurzu';
$string['publichub'] = 'Veřejné úložiště';
$string['publish'] = 'Sdílet';
$string['publishcourse'] = 'Sdílet {$a}';
$string['publishcourseon'] = 'Sdílet na {$a}';
$string['publishedon'] = 'Sdílení kurzů';
$string['publisheremail'] = 'E-mail vydavatele';
$string['publisheremail_help'] = 'E-mailová adrese vydavatele umožňuje správcům uzlu upozornit vydavatele na změny stavu publikovaného kurzu.';
$string['publishername'] = 'Vydavatel';
$string['publishername_help'] = 'Vydavatelem je osoba nebo organizace, která je oficiálním vydavatelem kurzu. Pokud nepublikujete kurz někoho jiného, uveďte ze sebe.';
$string['publishon'] = 'Sdílet na';
$string['publishonspecifichub'] = 'Publikovat na jiné úložiště';
$string['questionsnumber'] = 'Počet úloh ({$a})';
$string['readvertiseon'] = 'Aktualizovat zveřejňované informace na {$a}';
$string['registeredactiveuserdevices'] = 'Počet aktivních uživatelů s registrovanými mobilními zařízeními, které dostávají oznámení ({$a})';
$string['registeredcourses'] = 'Registrované kurzy';
$string['registeredmoodleorg'] = 'Moodle ({$a})';
$string['registeredon'] = 'Seznam úložišť, na nichž jste registrováni';
$string['registeredsites'] = 'Registrované stránky';
$string['registereduserdevices'] = 'Počet uživatelů s registrovanými mobilními zařízeními ({$a})';
$string['registermoochtips'] = 'Registrací obdržíte bezpečnostní upozornění, můžete aktivovat aplikaci mobilních oznámení ze svého webu a přispíváte do našich statistik Moodle celosvětové komunity.';
$string['registersite'] = 'Registrovat na {$a}';
$string['registerwith'] = 'Registrovat na úložišti';
$string['registerwithmoodleorg'] = 'Zaregistrujte své stránky';
$string['registerwithmoodleorgcomplete'] = 'Dokončete registraci svých stránek';
$string['registerwithmoodleorginfo'] = 'Rádi bychom zůstali v kontaktu a poskytli vám důležité věci pro vaše stránky Moodle! Registrací:

* Můžete se přihlásit k odběru oznámení o nových verzí Moodle, bezpečnostní oznámení a další důležité zprávy.
* Prostřednictvím naší bezplatné aplikace Moodle můžete přistupovat a aktivovat mobilní push upozornění ze svých stránek Moodle.
* Přispíváte do našich statistik Moodle celosvětové komunity, které nám pomáhají vylepšovat Moodle a naše komunitní stránky.
* Pokud si přejete, může být váš web zařazen do seznamu registrovaných stránek Moodle ve vaší zemi.';
$string['registerwithmoodleorginfoapp'] = 'O aplikaci Moodle';
$string['registerwithmoodleorginfosites'] = 'Další stránky v mé zemi';
$string['registerwithmoodleorginfostats'] = 'Statistiky Moodle';
$string['registerwithmoodleorgremove'] = 'Zrušit registraci vašich stránek';
$string['registerwithmoodleorgupdate'] = 'Aktualizovat registraci vašich stránek';
$string['registrationconfirmed'] = 'Registrace stránek potvrzena';
$string['registrationconfirmedon'] = 'Děkujeme vám za registraci vašich stránek. Registrační údaje budou udržovány v aktuálním stavu pomocí naplánované úlohy cronu "Site registration".';
$string['registrationinfo'] = 'Registrační informace';
$string['registrationupdated'] = 'Registrace byla aktualizována.';
$string['registrationupdatedfailed'] = 'Aktualizace registrace selhala.';
$string['removefromhub'] = 'Odstranit z Moodle.net';
$string['renewregistration'] = 'Obnovit registraci';
$string['resourcesnumber'] = 'Počet studijních materiálů ({$a})';
$string['restartregistration'] = 'Restartovat registraci';
$string['roleassignmentsnumber'] = 'Počet přiřazených rolí ({$a})';
$string['screenshots'] = 'Snímky obrazovky';
$string['screenshots_help'] = 'Všechny snímky kurzu se budou zobrazovat ve výsledcích hledání.';
$string['search'] = 'Hledat';
$string['selecthub'] = 'Vyberte úložiště';
$string['selecthubforadvertise'] = 'Vybrat úložiště pro reklamu';
$string['selecthubforsharing'] = 'Vybrat úložiště pro nahrání';
$string['selecthubinfo'] = 'Komunitní úložiště je server zobrazující seznam kurzů. Vaše kurzy můžete snadno sdílet na úložištích, na kterých registrován váš Moodle web. Pokud se požadované úložiště nezobrazuje, kontaktujte správce webu.';
$string['sendfollowinginfo'] = 'Více informací';
$string['sendfollowinginfo_help'] = 'Následující informace budou odeslány ke statistickému zpracování. Tyto informace nebudou veřejně dostupné.';
$string['sendingcourse'] = 'Posílám kurz';
$string['sendingsize'] = 'Počkejte, prosím, než se soubor s kurzem nahraje ({$a->total} Mb) ...';
$string['sent'] = '... hotovo';
$string['settings'] = 'Nastavení';
$string['settingsupdated'] = 'Nastavení byla aktualizována.';
$string['share'] = 'Sdílet tento kurz s ostatními ke stažení';
$string['shared'] = 'Pro stažení';
$string['shareon'] = 'Nahrát kurz na {$a}';
$string['shareonhub'] = 'Nahrát kurz na úložiště';
$string['sharepublication_help'] = 'Záloha tohoto kurzu bude k dispozici na stránkách Moodle.net, aby si kurz mohli lidé obnovit a používat na svých stránkách.';
$string['siteadmin'] = 'Správce';
$string['siteadmin_help'] = 'Celé jméno správce tohoto webu.';
$string['sitecommnews'] = 'Zpravodaj Moodle';
$string['sitecommnews_help'] = 'Máte možnost přihlásit se k odběru našeho Moodle zpravodaje. Odběr můžete kdykoli zrušit.';
$string['sitecommnewsno'] = 'Ne, nechci  dostávat žádné e-maily';
$string['sitecommnewsyes'] = 'Ano, rád bych dostával newsletter Moodle';
$string['sitecountry'] = 'Země';
$string['sitecountry_help'] = 'Země, ve které se nachází vaše organizace nebo instituce.';
$string['sitecreated'] = 'Web vytvořen';
$string['sitedesc'] = 'Popis ';
$string['sitedesc_help'] = 'Uveďte některé informace o tom, jak používáte Moodle.';
$string['siteemail'] = 'Emailová adresa správce';
$string['siteemail_help'] = 'Je potřeba zadat kontaktní e-mail, aby vás Moodle HQ mohl v případě potřeby kontaktovat. Může být také použit pro další účely, které povolíte níže.  Doporučuje se uvést adresu vázanou na konkrétní pozici (např. webmaster@nase.skola.cz) a nikoliv na jméno.';
$string['sitegeolocation'] = 'Geolokace';
$string['sitegeolocation_help'] = 'V budoucnu bude možné hledat stránky podle geografického umístění. Chcete-li, vložte umístění vašich stránek ve formátu zeměpisná šířka/zeměpisná délka (např. 50.0797228/ 14.4203381). Tento údaj lze zjistit např. na Mapy.cz nebo Google Maps.';
$string['sitelang'] = 'Jazyk';
$string['sitelang_help'] = 'Jaký je hlavní jazyk používaný na vašem webu Moodle?';
$string['sitename'] = 'Jméno';
$string['sitename_help'] = 'Název stránek, který bude zobrazen v seznamu registrovaných serverů.';
$string['sitephone'] = 'Telefon';
$string['sitephone_help'] = 'Kontaktní telefonní spojení, určeno výhradně pro správce příslušného úložiště.';
$string['siteprivacy'] = 'Seznam stránek';
$string['siteprivacy_help'] = 'Můžete se rozhodnout, že vaše stránky budou zveřejněny v seznamu registrovaných webů, ať již s odkazem na vaše stránky nebo bez něj.';
$string['siteprivacylinked'] = 'Zobrazit tento web s odkazem';
$string['siteprivacynotpublished'] = 'Nezobrazovat tento web';
$string['siteprivacypublished'] = 'Zobrazit jen jméno webu';
$string['siteregconfcomment'] = 'Vaše stránky čekají na finální potvrzení od {$a}';
$string['siteregistrationcontact'] = 'Zobrazit kontaktní formulář';
$string['siteregistrationcontact_help'] = 'Pokud to dovolíte, ostatní lidé v naší komunitě Moodle (kteří potřebují přihlašovací účet) vás budou moci kontaktovat prostřednictvím formuláře na webu komunity Moodle.  Nikdy však nevidí vaši e-mailovou adresu.';
$string['siteregistrationemail'] = 'Oznámení o nových verzích Moodle, bezpečnostní upozornění a další důležité zprávy';
$string['siteregistrationemail_help'] = 'Máte možnost odebírat náš nízkoobjemový e-mail s důležitými zprávami o nových verzích Moodle, bezpečnostních výstrahách a dalších důležitých zprávách. Odběr můžete kdykoli zrušit.';
$string['siteregistrationupdated'] = 'Registrace stránek aktualizována';
$string['siterelease'] = 'Verze Moodle';
$string['siterelease_help'] = 'Označení vydání Moodle na tomto webu.';
$string['sitereleasenum'] = 'Verze Moodle ({$a})';
$string['siteupdatedcron'] = 'Aktualizace registrace webu na "{$a}"';
$string['siteupdatesend'] = 'Ukončení aktualizace registrace úložiště.';
$string['siteupdatesstart'] = 'Zahájení aktualizace registrace na úložiště.';
$string['siteurl'] = 'URL webu';
$string['siteurl_help'] = 'URL je adresa tohoto webu. Pokud nastavení ochrany osobních údajů, aby lidé viděli adresu webu, pak bude použita tato adresa URL.';
$string['siteversion'] = 'Verze Moodle';
$string['siteversion_help'] = 'Verze Moodle na tomto webu.';
$string['skipregistration'] = 'Přeskočit';
$string['specifichubregistrationdetail'] = 'Můžete se také zaregistrovat své stránky s dalšími uzly.';
$string['statistics'] = 'Soukromé statistiky';
$string['status'] = 'Stav seznamu';
$string['statuspublished'] = 'Zobrazeno';
$string['statusunpublished'] = 'Nezobrazeno';
$string['subject'] = 'Téma';
$string['subject_help'] = 'Vyberte hlavní tematickou oblast, kterou tento kurz pokrývá.';
$string['tags'] = 'Štítky';
$string['tags_help'] = 'Štítky pomáhají kategorizovat váš kurz a pomoci mu k nalezení. Použijte jednoduchá a jednoznačná slova a oddělte je čárkou. Příklad: matematika, algebra, geometrie';
$string['trustme'] = 'Důvěryhodné';
$string['type'] = 'Sdílený';
$string['unknownstatus'] = 'Neznámý';
$string['unlistedurl'] = 'Nezobrazené URL úložiště';
$string['unprioritise'] = 'Zrušit priority';
$string['unpublish'] = 'Ukončit sdílení';
$string['unpublishalladvertisedcourses'] = 'Odstranit všechny kurzy aktuálně sdílené na Moodle.net';
$string['unpublishalluploadedcourses'] = 'Odstraněny všechny kurzy, které byly nahrány na Moodle.net pro stahování';
$string['unpublishconfirmation'] = 'Opravdu chcete odstranit kurz "{$a->courseshortname}"z "{$a->hubname}"';
$string['unpublishcourse'] = 'Ukončit sdílení {$a}';
$string['unregister'] = 'Zrušit registraci';
$string['unregisterconfirmation'] = 'Chystáte se zrušit registraci tohoto Moodle z úložiště {$a}. Poté, co se z úložiště odpojíte, nebude moci spravovat veškeré tam umístěné kurzy. Jste si jisti, že chcete zrušit registraci?';
$string['unregisterexplained'] = 'Pokud je zaregistrován web s adresou URL {$a}, jeho registrace bude odebrána.';
$string['unregisterfrom'] = 'Zrušit registraci na {$a}';
$string['unregistrationerror'] = 'Při pokusu zrušit registraci na Moodle.net se objevila chyba: {$a}';
$string['untrustme'] = 'Není důvěryhodný';
$string['update'] = 'Aktualizovat';
$string['updatesite'] = 'Aktualizovat registraci na {$a}';
$string['updatesiteregistration'] = 'Aktualizovat registraci';
$string['updatestatus'] = 'Zkontrolujte.';
$string['uploaded'] = 'Nahráno';
$string['url'] = 'URL úložiště';
$string['urlalreadyregistered'] = 'Zdá se, že vaše stránky jsou  již zaregistrovány, což znamená, že se něco pokazilo. Obraťte se na správce úložiště pro resetování registrace, abyste mohli pokus opakovat.';
$string['usedifferentemail'] = 'Použít jiný e-mail';
$string['usersnumber'] = 'Počet uživatelů  ({$a})';
$string['warning'] = 'VAROVÁNÍ';
$string['wrongtoken'] = 'Registrace se nezdařila z nějakého neznámého důvodu (síť?). Prosím zkuste to znovu.';
$string['wrongurlformat'] = 'Chybný formát URL';
$string['xmlrpcdisabledcommunity'] = 'Rozšíření XML-RPC není na serveru povoleno. Nelze vyhledávat a stahovat kurzy.';
$string['xmlrpcdisabledpublish'] = 'Rozšíření XML-RPC není na serveru povoleno, takže nemůžete publikovat nebo spravovat zveřejněné kurzy.';
$string['xmlrpcdisabledregistration'] = 'Rozšíření XML-RPC není na serveru povoleno. Nemůžete zrušit registraci nebo aktualizovat svou registraci, pokud je povolena.';
