<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'admin', language 'cs', branch 'MOODLE_36_STABLE'
 *
 * @package   admin
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessdenied'] = 'Přístup zamítnut';
$string['accounts'] = 'Účty';
$string['addcategory'] = 'Přidat kategorii';
$string['additionalhtml'] = 'Další HTML';
$string['additionalhtml_desc'] = 'Toto nastavení vám umožňuje definovat vlastní HTML kód, který bude přidán na každou stránku. Vlastní kód je možno přidat buď do hlavičky stránky (HEAD), na začátek těla (BODY) stránky nebo těsně před konec těla stránky.<br/>Tímto způsobem lze snadno přidat vlastní záhlaví či zápatí, popřípadě vložit kód potřebný pro služby jako je Google Analytics. Takto vložený kód není závislý na použitém grafickém motivu.';
$string['additionalhtmlfooter'] = 'Před koncem značky BODY';
$string['additionalhtmlfooter_desc'] = 'Tento obsah bude přidán ke každé stránce předtím, než bude uzavřen tag BODY.';
$string['additionalhtmlhead'] = 'Uvnitř značky HEAD';
$string['additionalhtmlhead_desc'] = 'Tento obsah bude přidán ke každé stránce předtím, než bude pro každou stránku uzavřen tag HEAD.';
$string['additionalhtml_heading'] = 'HTML kód bude přidán ke každé stránce.';
$string['additionalhtmltopofbody'] = 'Po začátku značky BODY';
$string['additionalhtmltopofbody_desc'] = 'Tento obsah bude přidán ke každé stránce po tom, než bude otevřen tag BODY.';
$string['admincategory'] = 'Kategorie: {$a}';
$string['adminseesall'] = 'Správci vidí vše';
$string['adminseesallevents'] = 'Správci vidí všechny události';
$string['adminseesownevents'] = 'Správci jsou jako obyčejní uživatelé';
$string['advancedfeatures'] = 'Pokročilé funkce';
$string['agedigitalconsentverification'] = 'Ověření věkové hranice pro digitální souhlas';
$string['agedigitalconsentverification_desc'] = 'Povoluje ověření věku pro vyjádření digitálního souhlasu, před zobrazením stránky registrace s vlastní registrací uživatele. To chrání vaše stránky před nezletilými, kteří se přihlásí bez souhlasu rodiče / zákonného zástupce.  vykonavatele rodičovské zodpovědnosti . <a target="_blank" href="{$a}"> Kontakt s podporou </a> je poskytována nezletilým osobám za účelem další pomoci.';
$string['ageofdigitalconsentmap'] = 'Věková hranice pro digitální souhlas';
$string['ageofdigitalconsentmap_desc'] = 'Výchozí věk  pro digitální souhlas a věk v jakékoliv zemi, kde se liší od výchozího nastavení, lze uvést zde. Zadejte každý věkový limit na nový řádek s formátem: kód země, věk (oddělené čárkou). Výchozí věk je označen * místo kódu země. Kódy zemí jsou uvedeny v normě ISO 3166-2.';
$string['allcountrycodes'] = 'Všechny kódy zemí';
$string['allowattachments'] = 'Povolit přílohy';
$string['allowbeforeblock'] = 'Nejprve porovnávat seznam povolených';
$string['allowbeforeblockdesc'] = 'Ve výchozím nastavení je nejprve porovnáván seznam blokovaných IP adres. Je-li tato volba povolena, jsou položky v seznamu povolených adres zpracovány před seznamem blokovaných.';
$string['allowblockstodock'] = 'Povolit zasouvání bloků';
$string['allowcategorythemes'] = 'Povolit motivy kategorií';
$string['allowcohortthemes'] = 'Povolit motiv pro globální skupinu';
$string['allowcoursethemes'] = 'Povolit změnu motivu v kurzech';
$string['allowedemaildomains'] = 'Povolené e-mailové domény';
$string['allowediplist'] = 'Seznam povolených IP adres';
$string['allowemailaddresses'] = 'Povolené emailové domény';
$string['allowframembedding'] = 'Povolit vkládání do rámce';
$string['allowframembedding_help'] = 'Povolit zobrazení vašeho Moodle v HTML rámci (frame) na jiných stránkách, jak je doporučeno při použití "Publikovat jako externí nástroje" zápisu. Z bezpečnostních důvodů se jinak nedoporučuje.';
$string['allowguestmymoodle'] = 'Povolit hostům přístup na Nástěnku';
$string['allowindexing'] = 'Povolit indexování vyhledávači';
$string['allowindexing_desc'] = 'To určuje, zda povolit vyhledávačům indexovat vaše stránky. "Všude" umožní vyhledávačům vyhledávat všude, včetně přihlašovacích a registračních stránek, což znamená, že weby s aktivovaným vnuceným přihlášením jsou stále indexovány. Chcete-li zabránit riziku spamu, který je spojen s prohledávanou registrační stránkou, použijte "všude kromě přihlašovacích a registračních stránek". "Nikde" řekne vyhledávačům, aby neindexovali žádnou stránku. Všimněte si, že toto je pouze štítek (tag) v záhlaví webu. Je na vyhledávači, aby tag respektoval.';
$string['allowindexingeverywhere'] = 'Všude';
$string['allowindexingexceptlogin'] = 'Všude kromě přihlašovacích a registračních stránek';
$string['allowindexingnowhere'] = 'Nikde';
$string['allowobjectembed'] = 'Povolit značky EMBED a OBJECT';
$string['allowthemechangeonurl'] = 'Povolit změnu motivu přes URL';
$string['allowuserblockhiding'] = 'Povolit uživatelům skrývat bloky';
$string['allowusermailcharset'] = 'Povolit uživatelům výběr znakové sady';
$string['allowuserswitchrolestheycantassign'] = 'Uživatelům bez oprávnění přiřazovat role povolit role přepínat';
$string['allowuserthemes'] = 'Povolit uživatelům změnu motivu';
$string['alternativefullnameformat'] = 'Formát alternativního jména';
$string['alternativefullnameformat_desc'] = 'Definuje, jak jsou názvy zobrazeny uživatelům s možností viewfullnames (ve výchozím nastavení uživatele s rolí manažera, učitel nebo učitel bez práva editace). Zástupné symboly  mohou být použity pro nastavení "Celé jméno".';
$string['always'] = 'Vždy';
$string['appearance'] = 'Vzhled';
$string['aspellpath'] = 'Cesta k programu "aspell"';
$string['authentication'] = 'Ověřování uživatelů';
$string['authpreventaccountcreation'] = 'Zabránit vytváření nových účtů při ověřování uživatelů';
$string['authpreventaccountcreation_help'] = 'Je-li identita uživatele úspěšně ověřena, je mu automaticky založen účet na těchto stránkách. Pokud je pro ověřování uživatelů použit externí zdroj (např. LDAP), ale přístup do Moodle by měl být omezen pouze na uživatele, kteří zde již mají účet, aktivujte tuto možnost. Nové účty pak bude potřeba zakládat ručně nebo pomocí funkce importu uživatelských účtů. Toto nastavení se nevztahuje na ověřování přes MNet.';
$string['authsettings'] = 'Správa modulů pro ověřování uživatelů';
$string['autolang'] = 'Autodetekce jazyka';
$string['autologinguests'] = 'Automaticky přihlašovat hosty';
$string['availablelicenses'] = 'Dostupné licence';
$string['availableto'] = 'Dostupné do';
$string['backgroundcolour'] = 'Průhledná barva';
$string['backups'] = 'Zálohy';
$string['backup_shortname'] = 'Používat název kurzu ve jméně souboru zálohy';
$string['backup_shortnamehelp'] = 'Použít název kurzu v názvu souboru zálohy.';
$string['badwordsconfig'] = 'Zadejte seznam zakázaných slov, jednotlivá slova oddělujte čárkou.';
$string['badwordsdefault'] = 'Pokud je seznam prázdný, použije se výchozí seznam uvedený v jazykovém balíčku.';
$string['badwordslist'] = 'Seznam zakázaných slov';
$string['blockediplist'] = 'Seznam blokovaných IP adres';
$string['blockinstances'] = 'Instance';
$string['blockmultiple'] = 'Povolit více instancí';
$string['blockprotect'] = 'Uzamknout';
$string['blockprotect_help'] = 'Pokud uzamknete některé typy bloků, nikdo nebude moci přidávat nebo odebírat jejich instance. V případě potřeby můžete tuto ochranu opět odemknout.

Této funkce lze využít zejména k ochraně bloků Navigace a Nastavení, které může být obtížné vrátit zpět, pokud jsou omylem odstraněny.';
$string['blocksettings'] = 'Nastavení bloků';
$string['blockunprotect'] = 'Nechránit';
$string['bloglevel'] = 'Viditelnost blogu';
$string['bookmarkadded'] = 'Záložka přidána';
$string['bookmarkalreadyexists'] = 'Tato stránka již obsahuje vaši záložku';
$string['bookmarkdeleted'] = 'Záložka odstraněna';
$string['bookmarkthispage'] = 'Přidat záložku';
$string['cacheapplication'] = 'Aplikační vyrovnávací paměť';
$string['cacheapplicationhelp'] = 'Položky v aplikační vyrovnávací paměti jsou sdíleny všemi uživateli a jejich platnost vyprší po nastavené životnosti.';
$string['cachejs'] = 'Vyrovnávací paměť Javascriptu';
$string['cachejs_help'] = 'Vyrovnávací paměť a komprese Javascriptu výrazně zrychluje načítání stránek. Pro stránky v ostrém produkčním režimu je silně doporučována. Naopak vývojáři pravděpodobně tuto možnost budou chtít zakázat.';
$string['cacherequest'] = 'Požadavek na  vyrovnávací paměť';
$string['cacherequesthelp'] = 'Slouží pro dočasné ukládání dat v rámci vyřizování jednoho HTTP požadavku. Platnost dat vyprší v okamžiku vyřízení požadavku, tedy po načtení stránky.';
$string['cachesession'] = 'Relační vyrovnávací paměť';
$string['cachesessionhelp'] = 'Slouží pro sdílení dočasných dat napříč všemi HTTP požadavky v rámci jedné uživatelské relace (session). Je navržena pro zmírnění narůstání velikosti PHP session.';
$string['cachesettings'] = 'Nastavení vyrovnávací paměti';
$string['caching'] = 'Vyrovnávací paměti';
$string['calendarexportsalt'] = 'Náhodný řetězec (salt) pro export kalendáře';
$string['calendarsettings'] = 'Kalendář';
$string['calendartype'] = 'Typ kalendáře';
$string['calendartype_desc'] = 'Zvolte výchozí typ kalendáře pro tyto stránky. Toto globální nastavení je možné změnit v nastavení kurzu nebo jednotlivými uživateli v jejich profilu.';
$string['calendar_weekend'] = 'Víkend';
$string['cannotdeletemodfilter'] = 'Nemůžete odinstalovat filtr "{$a->filter}", protože je součástí modulu "{$a->module}".';
$string['cannotuninstall'] = 'Nelze odinstalovat {$a}.';
$string['categoryemail'] = 'Email';
$string['cfgwwwrootslashwarning'] = 'Máte špatně nastavenu hodnotu proměnné $CFG->wwwroot ve vašem souboru config.php. Na konci obsahuje znak „/“, který musí být odstraněn.';
$string['cfgwwwrootwarning'] = 'Máte špatně nastavenou hodnotu proměnné $CFG->wwwroot ve vašem souboru config.php. Měla by odpovídat adrese URL, kterou používáte pro přístup na tuto stránku.';
$string['change'] = 'změnit';
$string['checkboxno'] = 'Ne';
$string['checkboxyes'] = 'Ano';
$string['choosefiletoedit'] = 'Vyberte soubor k editaci';
$string['cleanup'] = 'Úklid';
$string['clianswerno'] = 'n';
$string['cliansweryes'] = 'a';
$string['cliincorrectvalueerror'] = 'Chyba, nesprávná hodnota "{$a->value}" volby "{$a->option}"';
$string['cliincorrectvalueretry'] = 'Nesprávná hodnota, prosím zadejte znovu';
$string['clistatusdisabled'] = 'Stav: zakázáno';
$string['clistatusenabled'] = 'Stav: povoleno';
$string['clistatusenabledlater'] = 'stav: režim údržby z příkazové řádky bude povolen {$a}';
$string['clitypevalue'] = 'zadejte hodnotu';
$string['clitypevaluedefault'] = 'zadejte hodnotu nebo stiskněte Enter pro použití výchozí hodnoty ({$a})';
$string['cliunknowoption'] = 'Neznámé volby:
 {$a}
Použijte volbu --help pro získání nápovědy';
$string['cliupgradedefault'] = 'Nové nastavení: {$a}';
$string['cliupgradedefaultheading'] = 'Nastavení nových výchozích hodnot';
$string['cliupgradedefaultverbose'] = 'Nové nastavení: {$a->name}, Výchozí hodnota: {$a->defaultsetting}';
$string['cliupgradefinished'] = 'Aktualizace v příkazovém řádku z {$a->oldversion} na {$a->newversion} úspěšně dokončena.';
$string['cliupgradenoneed'] = 'Pro tuto verzi {$a} není aktualizace potřeba. Přesto díky, že jste se stavili!';
$string['cliyesnoprompt'] = 'zadejte a (pro "ano") nebo n (pro "ne")';
$string['commentsperpage'] = 'Počet komentářů na stránku';
$string['commonactivitysettings'] = 'Společná nastavení';
$string['commonfiltersettings'] = 'Společné nastavení filtrů';
$string['commonsettings'] = 'Společná nastavení';
$string['componentinstalled'] = 'Komponenta nainstalována';
$string['computedfromlogs'] = 'Vypočteno z protokolů od {$a}.';
$string['condifmodeditdefaults'] = 'Výchozí hodnoty  použité ve formulářích při vytváření nové činnosti nebo materiálu.';
$string['confeditorhidebuttons'] = 'Vyberte tlačítka, která mají být v HTML editoru skryta.';
$string['configallcountrycodes'] = 'Seznam zemí, z něhož je možno vybírat v různých formulářích, např. v uživatelském profilu. Ponecháte-li pole prázdné, bude použit seznam všech zemí dle ISO 3166-1 definovaný souboru countries.php. V případě, že chcete tento seznam omezit, vložte do tohoto pole čárkami oddělený seznam kódů zemí, které se mají nabízet, např. "CZ,SK". Pokud používáte vlastní nestandardizované kódy zemí, musíte příslušné definice přidat do souboru countries.php v anglickém jazykovém balíčku.';
$string['configallowassign'] = 'Uživatelé, jímž je přiřazena role uvedená vlevo (v prvním sloupci), budou moci dalším uživatelům přiřazovat role zaškrtnuté v jednotlivých sloupcích.';
$string['configallowattachments'] = 'Je-li povoleno, e-maily odeslané z webu mohou mít přílohy jako jsou odznaky.';
$string['configallowblockstodock'] = 'Zda se má povolit funkce zasouvání postranních bloků do lišty. Tuto funkci musí rovněž podporovat váš motiv stránek.';
$string['configallowcategorythemes'] = 'Tímto lze povolit nastavování různých motivů v kategoriích kurzů. Motiv nastavený pro kategorii ovlivňuje všechny kurzy v této kategorii i ve všech jejích podkategoriích, dokud není řečeno jinak. POZOR: Toto nastavení může negativně ovlivnit výkon Moodlu.';
$string['configallowcohortthemes'] = 'Pokud to povolíte, lze nastavit motivy na úrovni globální skupiny. To bude mít vliv na všechny uživatele, kteří mají pouze jednu nebo více než jednu globální skupinu, ale se stejným motivem.';
$string['configallowcoursethemes'] = 'Povolit vlastní motivy v kurzech. Motivy kurzů mají přednost před všemi ostatními motivy (tj. před motivem stránek, uživatele či sezení).';
$string['configallowedemaildomains'] = 'Seznam e-mailových domén, které jsou povoleny, které mají být zveřejněny v položce "Od" odchozích zpráv. Ve všech odchozích e-mailech se výchozí hodnota "Empty" použije pro adresu Neodpovídat. Je povoleno použit zástupné znaky  např. *.example.com, které povolí odeslat e-maily z libovolné subdoménu tohoto webu, ale ne Example.com samotné. To vyžaduje samostatný záznam.';
$string['configallowemailaddresses'] = 'Chcete-li omezit nové e-mailové adresy pouze z určitých domén, uveďte je zde. Jednotlivé domény oddělte mezerou. Všechny ostatní adresy budou odmítnuty. Chcete-li povolit všechny subdomény, přidejte doménu předcházející tečkou ".". Chcete-li povolit kořenovou doménu spolu s jejími subdoménami, přidejte doménu dvakrát - jednou uvedenou "." a podruhé bez tečky např.: .ourcollege.edu.au ourcollege.edu.au.';
$string['configallowguestmymoodle'] = 'Je-li povoleno, mohou mít hosté přístup na Nástěnku. Jinak jsou hosté přesměrováni na titulní stránku.';
$string['configallowobjectembed'] = 'Výchozí bezpečnostní nastavení nedovoluje normálním uživatelům vkládat přímo do HTML textu multimediální objekty (např. Flash) pomocí značek EMBED a OBJECT. (Bezpečné vkládání multimediálních objektů zajišťuje jeden z tzv. filtrů.) Chcete-li přesto použití uvedených značek povolit, aktivujte tuto volbu.';
$string['configallowoverride'] = 'Role uvedená vlevo (v prvním sloupci) bude moci přenastavovat oprávnění rolí zaškrtnutých v jednotlivých sloupcích.';
$string['configallowoverride2'] = 'Role uvedená vlevo (v prvním sloupci) bude moci přenastavovat oprávnění rolí zaškrtnutých v jednotlivých sloupcích.<br />Důležité upozornění: toto nastavení se bere v potaz pouze u těch uživatelů, kteří mají nastavenu pravomoc moodle/role:override nebo moodle/role:safeoverride';
$string['configallowswitch'] = 'Vyberte role, na které se budou moci uživatelé přepnout v závislosti na rolích, které již mají. Kromě nastavení v této tabulce musí uživatel rovněž disponovat pravomocí "Přepínat na jiné role" (moodle/role:switchroles).<br />Přepnout se je možno pouze na role, které dávají oprávnění "Vidět kurzy" (moodle/course:view) a zároveň nedávají "Možnost dělat cokoli" (moodle/site:doanything). Proto nemusejí být některé sloupce v této tabulce k dispozici.';
$string['configallowthemechangeonurl'] = 'Pokud je povoleno, můžete přidáním parametru theme=jméno_motivu k jakémukoliv URL v rámci Moodlu změnit motiv stránky.

Například http://nase.skola.cz/moodle/?theme=afterburner nebo http://nase.skola.cz/moodle/course/view.php?id=1&theme=afterburner';
$string['configallowuserblockhiding'] = 'Povolit uživatelům zasouvání/vysouvání postranních bloků? Tato funkce používá Javascript a soubory cookie. Nastavení se aplikuje vždy pouze na pohled příslušného uživatele.';
$string['configallowusermailcharset'] = 'Povolit všem uživatelům nastavení vlastní znakové sady pro e-maily v jejich předvolbách.';
$string['configallowuserswitchrolestheycantassign'] = 'Při výchozím nastavení potřebují uživatelé oprávnění přiřazovat role (moodle/role:assign) i k tomu, aby si mohli role přepínat. Pokud povolíte toto nastavení, bude tato podmínka zrušena a uživatelům bude přístupná rozbalovací nabídka "Přepnout roli na..." pouze na základě nastavení matice "Povolit přidělování rolí". Doporučuje se, aby nastavení tabulky "Povolit přidělování rolí" nedovolovalo přepnout se uživatelům do role, která má větší pravomoce než jejich stávající role.';
$string['configallowuserthemes'] = 'Umožnit uživatelům vlastní výběr motivu stránek. Uživatelské nastavaní má přednost před globálním motivem, nikoliv však před nastavením kurzu.';
$string['configallowview'] = 'Vyberte, které role uživatele uvidí, zda je možné filtrovat atd. podle toho, jaké role již mají.';
$string['configallusersaresitestudents'] = 'Považovat pro činnosti na hlavní stránce VŠECHNY uživatele za studenty? Pokud ANO, bude se moci činností na hlavní stránce účastnit jako student každý uživatel přihlášený k potvrzenému uživatelskému účtu. Pokud NE, budou mít tuto možnost pouze uživatelé zapsaní alespoň v jednom kurzu. Pouze administrátoři a zvlášť určení učitelé mohou na hlavní stránce vystupovat v roli učitele.';
$string['configauthenticationplugins'] = 'Aktivujte autentizační metody a pořadí, v jakém budou použity.';
$string['configautolang'] = 'Zjistí preferovaný jazyk z prohlížeče. Jestliže je tato volba vypnutá, použije se výchozí jazyk.';
$string['configautologinguests'] = 'Mají být návštěvníci vašich stránek automaticky přihlášeni jako hosté, jestliže vstupují do kurzů, které vstup hostů umožňují?';
$string['configbloglevel'] = 'Touto volbou nastavujete úroveň přístupu k blogům na vašich stránkách. Nastavení se týká ČTENÁŘŮ, nikoliv autorů či typů blogů. Pokud blogy nechcete používat, můžete je vypnout úplně.';
$string['configcalendarcustomexport'] = 'Povolit vlastní časové období exportu kalendáře';
$string['configcalendarexportsalt'] = 'Tento náhodný řetězec zvyšuje zabezpečení autentizačních zámků, které se používání při exportu kalendářů. Při změně této hodnoty se všechny stávající autentizační zámky zneplatní.';
$string['configcookiehttponly'] = 'Zapíná novou funkci z PHP 5.2.0, která nařizuje prohlížeči posílat cookies pouze s HTTP požadavkem, takže cookies nebudou přístupná skriptovacím jazykům. Tato funkce napomáhá předcházet XSS útokům. Tuto funkci podporují všechny moderní prohlížeče.';
$string['configcookiesecure'] = 'Jestliže server přijímá pouze šifrované HTTPS připojení, pak se doporučuje zapnout zasílání zabezpečených cookies. Jestliže je zapnuto, ujistěte se prosím, že webový server neakceptuje i http://, nebo nastavte permanentní přesměrování na https:// a v ideálním případě pošle HSTS hlavičku . Jestliže nebude hodnota <em>wwwroot</em> začínat na https://, pak se toto nastavené automaticky vypne.';
$string['configcountry'] = 'Výchozí nastavení země při vytváření nových uživatelů. Nezadáte-li nic, budou uživatelé nuceni vybrat si zemi sami.';
$string['configcoursegraceperiodafter'] = 'Klasifikace minulých kurzů probíhá mnoho dnů po ukončení kurzu.';
$string['configcoursegraceperiodbefore'] = 'Klasifikace budoucích kurzů probíhá mnoho dní před datem zahájení kurzu.';
$string['configcourseoverviewfilesext'] = 'Seznam povolených přípon souborů obrázků oddělených čárkami.';
$string['configcourseoverviewfileslimit'] = 'Maximální počet souborů, které lze zobrazit na stránce s kurzy vedle souhrnu kurzu. První přidaný soubor s obrázkem se používá jako obrázek kurzu v přehledu kurzů na nástěnce uživatelů; všechny další soubory jsou zobrazeny pouze v seznamu stránek kurzů.';
$string['configcourserequestnotify'] = 'Zadejte uživatelské jméno uživatele, kterému bude zasíláno upozornění na novou žádost o založení kurzu.';
$string['configcourserequestnotify2'] = 'Kteří uživatelé budou upozorněni na novou žádost o založení kurzu. Zobrazují se pouze uživatelé, kteří mají oprávnění schvalovat žádosti o založení kurzu.';
$string['configcoursesperpage'] = 'Zadejte počet kurzů na stránce při zobrazování seznamu kurzů.';
$string['configcourseswithsummarieslimit'] = 'Pokud počet kurzů na stránce zobrazující seznam kurzů včetně jejich popisu překročí nastavený počet, zobrazí se seznam ve zkrácené podobě bez popisu kurzů.';
$string['configcronclionly'] = 'Spuštění cronu přes webové rozhraní může anonymním uživatelům odhalit privilegované informace. Proto se doporučuje, spouštět cron pouze z příkazové řádky nebo nastavit  pro vzdálený přístup ke cronu heslo.';
$string['configcronremotepassword'] = 'Použijete-li toto nastavení, bude pro volání skriptu cron.php přes webové rozhraní nutné použít heslo předávané jako parametr podle vzoru: <pre>
        https://moodle.naseskola.cz/admin/cron.php?password=sezameotevrise</pre> Pokud necháte pole prázdné, bude možno volat skript cron.php i bez hesla.';
$string['configcurlcache'] = 'Hodnota doby životnosti cURL vyrovnávací paměti v sekundách.';
$string['configcustommenuitems'] = 'Zde můžete nadefinovat vlastní nabídku odkazů, kterou má vámi zvolený motiv zobrazit. Každý řádek sestává z textu nabídky, URL odkazu (volitelně) a textu titulku (volitelně). Položky na řádce oddělte svislítkem a kód jazyka nebo čárkami oddělený seznam kódů (volitelně, pro zobrazení linku pro uživatele v určeném jazyce). Strukturu nabídky definujete pomocí pomlček na začátku řádky nebo znaky # , kde to žádoucí. Příklad:
<pre>
Hlavní stránka školy|https://nase.skola.cz
-Kontakty|https://nase.skola.cz/kontakty
-Předměty|https://nase.skola.cz/predmety
--Kabinet informatiky|https://nase.skola.cz/predmety/informatika
-###
Další studijní materiály
-Wikimedia
--Wikipedia|https://www.wikipedia.org
--Wikimedia Commons|https://commons.wikimedia.org
Dokumentace
-Moodle Docs|https://docs.moodle.org|Moodle Docs
-German Moodle Docs|https://docs.moodle.org/de|Documentation in German|de
</pre>';
$string['configcustomusermenuitems'] = 'Zde lze nastavit obsah uživatelské nabídky - kromě odkazu pro odhlášení, který je přidán automaticky. Řádky jsou odděleny znakem | a skládají se ze tří částí: (1) řetězce ve formě "langstringname, componentname", nebo ve formě běžného textu, (2) URL adresy a (3) ikonu buď jako pix  ikonu(ve složce pix se strukturou [subfoldername]/[iconname], např.  i/publish) nebo jako adresa URL. Oddělovače lze na žádaném místě použít přidáním řádku s jedním nebo více znaky #.';
$string['configdbsessions'] = 'Je-li povoleno, bude se pro ukládání informací o stávajících sezeních (sessions) používat databáze. Upozornění: změna tohoto nastavení způsobí odhlášení všech momentálně přihlášených uživatelů (včetně vás). Pokud používáte MySQL, ujistěte se, že máte konfigurační proměnnou "max_allowed_packet" (v my.cnf nebo my.ini) nastavenu alespoň na hodnotu 4M. Další ovladače sezení mohou být konfigurovány přímo v config.php,  více informací viz config-dist.php. Pokud zadáte ovladač sezení v souboru config.php, tato volba zmizí.';
$string['configdebug'] = 'Zapnout vypisování varování a ladicích informací pomocí zvýšení úrovně PHP error_reporting. Užitečné hlavně pro vývojáře.';
$string['configdebugdisplay'] = 'Je-li zapnuto, zobrazují se chybová hlášení jako součást HTML stránky. To je sice praktické, ale obecně mohou chybová hlášení nabourávat XHTML, JavaScript, cookies a HTTP hlavičky. Při vypnutí budou chybová hlášení ukládána v protokolu webového serveru. Nastavení PHP proměnné error_log v souboru php.ini ovlivňuje, jaké informace jsou protokolovány.';
$string['configdebugpageinfo'] = 'Povolte, pokud chcete mít v zápatí vytištěné informace o stránce.';
$string['configdebugsmtp'] = 'Povoluje podrobné informace o ladění během odesílání e-mailových zpráv na server SMTP. Aby se toto nastavení projevilo, musí být nastavení „Debug messages“ nastaveno na „Developer“.';
$string['configdebugvalidators'] = 'Povolte, pokud chcete v zápatí stránky zobrazovat odkazy na externí validátory. Možná budete muset vytvořit nového uživatele s uživatelským jménem <em>w3cvalidator</em> a povolit na vaše stránky vstup pro hosty. Tyto změny umožní neautorizovaný přístup na vaše stránky, nepoužívejte v produkčním prostředí.';
$string['configdefaulthomepage'] = 'Určuje první odkaz v navigaci pro přihlášené uživatele.';
$string['configdefaultrequestcategory'] = 'Požadované kurzy budou automaticky umístěny v této kategorii.';
$string['configdefaultrequestedcategory'] = 'Do jaké kategorie zařadit požadované kurzy, pokud jsou schváleny?';
$string['configdefaultuserroleid'] = 'Přihlášení uživatelé získají na úrovni celého serveru všechna oprávnění vyplývající z uvedené role. Tato oprávnění budou přidána k ostatním oprávněním získaných z dalších rolí (a mohou je přebít pouze pomocí možnosti "Zakázat"). Vybraná role by měla zajišťovat, aby uživatelé disponovali pravomocemi, které nemohou získat na úrovni kurzů - např. publikovat příspěvky blogů, spravovat vlastní kalendář apod.).';
$string['configdeleteincompleteusers'] = 'Po uplynutí této lhůty dojde k odstranění účtů bez vyplněného pole jméno, příjmení nebo e-mail.';
$string['configdeleteunconfirmed'] = 'Pro určité ověřovací metody, jako je například registrace prostřednictvím e-mailu, musí uživatel svůj účet do určité doby potvrdit. Po uplynutí této doby jsou nepotvrzené účty automaticky odstraněny.';
$string['configdenyemailaddresses'] = 'Chcete-li z některých domén e-mailové adresy zakázat, zadejte je stejným způsobem. Adresy ze všech ostatních domén budou povoleny. Začíná-li hodnota tečkou, je tento filtr aplikován na všechny subdomény. Příklady: <b>hotmail.com yahoo.co.uk .live.com</b>';
$string['configdisableuserimages'] = 'Zakázat uživatelům možnost měnit si svou fotografii v profilu.';
$string['configdisplayloginfailures'] = 'Zvoleným uživatelům se budou zobrazovat informace o neúspěšných pokusech o přihlášení do systému.';
$string['configdndallowtextandlinks'] = 'Zda se má vedle přetahování souborů povolit též přetahování textů a odkazů do stránky kurzu. V některých prohlížečích (např. Firefox) nebo mezi různými prohlížeči není tato funkce příliš spolehlivá a může vést ke vložení poškozeného obsahu nebo nemusí fungovat vůbec.';
$string['configdoclang'] = 'Tento jazyk bude použit v odkazech na stránkách dokumentace.';
$string['configdocroot'] = 'Cesta k dokumentaci Moodlu. Upravte toto nastavení, pokud si přejete mít vlastní online dokumentaci. Ujistětě se, že vaše dokumentace zachovává stejný formát jako http://docs.moodle.org. Pokud je pole prázdné, nebudou zobrazeny odkazy.';
$string['configdoctonewwindow'] = 'Otevírat stránky dokumentace v novém okně.';
$string['configeditordictionary'] = 'Tato hodnota je použita, pokud nemá aspell k dispozici slovník pro jazyk uživatele.';
$string['configeditorfontlist'] = 'Seznam fontů, které budou zobrazovány v nabídce HTML editoru.';
$string['configemailchangeconfirmation'] = 'Znovu vyžadovat potvrzení nové emailové adresy, pokud si ji uživatelé změní ve svém profilu.';
$string['configemailfromvia'] = 'Přidat pomocí informace v položce "Od" odchozích e-mailech. To informuje příjemce, odkud tento e-mail přišel a také pomáhá příjemci bojovat proti náhodné odpovědi na e-mailové adresy s hodnotou Neodpovídat.';
$string['configenableactivitychooser'] = 'Průvodce přidáním obsahu je dialogové okno se stručným popisem jednotlivých činností a zdrojů. Pokud jsou zakázán, zobrazí se samostatně rozevírací nabídka zdrojů a aktivit.';
$string['configenableblogs'] = 'Zda mají mít uživatelé k dispozici svůj vlastní blog.';
$string['configenablecalendarexport'] = 'Povolit export kalendářů nebo odebírání jejich položek';
$string['configenablecomments'] = 'Povolit komentáře';
$string['configenablecourserequests'] = 'Povolit uživatelům žádat o založení kurzu?';
$string['configenabledevicedetection'] = 'Povoluje detekování typu zařízení (tablet, smartphone, notebook apod.) za účelem aplikace přizpůsobeného vzhledu a dalších funkcí.';
$string['configenablemobilewebservice'] = 'Povoluje mobilní služby pro podporu oficiální aplikace Moodle pro mobilní zařízení, případně další aplikace, které tyto služby využívají. Pro více informací vize {$a}';
$string['configenablerssfeeds'] = 'Je-li povoleno, jsou generovány RSS kanály různými funkcemi po celém webu, jako jsou blogy, diskusní fóra, činnosti databanka a slovníky. Všimněte si, že RSS kanály také nutné, aby je bylo možno použít pro jednotlivé moduly činnosti.';
$string['configenablerssfeedsdisabled'] = 'Tato volba není dostupná, protože RSS kanály jsou na těchto stránkách zakázány. Kanály povolíte v \'Správa -> Nastavení -> Obecné parametry\'.';
$string['configenablerssfeedsdisabled2'] = 'RSS kanály jsou zakázané na úrovni serveru. Mohou být povoleny v nabídce správy webu Rozšířené funkce.';
$string['configenablesafebrowserintegration'] = 'Tím se do pole „Zabezpečení prohlížeče“ ve formuláři nastavení testu přidá volba „Vyžadovat prohlížeč Safe Exam“. Další informace naleznete na adrese https://www.safeexambrowser.org/.';
$string['configenablestats'] = 'Při volbě "Ano" zpracuje cron protokoly o činnosti uživatelů a vytvoří z nich grafy a statistiky pro jednotlivé kurzy i celý server. Toto zpracování může nějakou dobu trvat, v závislosti na návštěvnosti vašeho serveru.';
$string['configenabletrusttext'] = 'Moodle standardně pročišťuje jakýkoliv text přicházející od uživatelů a snaží se odstranit potenciální bezpečnostní rizika, mezi něž patří i skripty, média apod. Pomocí funkce "Důvěryhodný obsah" můžete vybraným uživatelům dát privilegium používat i tyto pokročilé prvky bez dalších zásahů. Nejprve je potřeba povolit toto nastavení a poté udělit oprávnění "Důvěřovat uloženému obsahu" (moodle/site:trustcontent). vybraným rolím. Text, který byl vytvořen nebo nahrán uživatelem s takovou rolí, je pak označen jako důvěryhodný a není před zobrazením pročišťován.';
$string['configenablewebservices'] = 'Webové služby umožňují přístup externích aplikací k provádění různých operací s touto instalací Moodle. Pokud webové služby nepoužíváte, nechejte je vypnuté.';
$string['configenablewsdocumentation'] = 'Povolit auto-dokumentační funkce webových služeb. Uživatel má přístup k dokumentaci na své stránce s bezpečnostními klíči {$a}. Dokumentovány budou pouze povolené protokoly.';
$string['configerrorlevel'] = 'Vyberte rozsah zobrazovaných varování PHP. Většinou je nejlepší volbou \'Normální\'.';
$string['configexportlookahead'] = 'Dnů prohledání dopředu během exportu';
$string['configexportlookback'] = 'Dnů prohledání zpětně během exportu';
$string['configextendedusernamechars'] = 'Povolit uživatelům používat libovolné znaky v uživatelských jménech (volba nemá vliv na znaky ve jméně a příjmení). Výchozí hodnota \'Ne\' povoluje v uživatelských jménech pouze alfanumerické znaky, podtržítko (_), pomlčku (-), tečku (.) a zavináč (@).';
$string['configextramemorylimit'] = 'Některé skripty (např. vyhledávání, záloha/obnova nebo cron) potřebují více paměti. U velkých instalací nastavte větší hodnotu.';
$string['configfilterall'] = 'Zpracovávat pomocí filtrů všechny řetězce včetně nadpisů, titulků, navigační lišty apod. To se hodí zejména při používání filtru vícejazyčné podpory (multilang), jinak tato volba představuje pouze zvýšenou zátěž pro váš server bez výrazného zisku.';
$string['configfiltermatchoneperpage'] = 'Filtry, které automaticky propojují obsah kurzů, vytvoří odkaz pouze u první nalezené shody na celé stránce. Ostatní výskyty jsou ignorovány.';
$string['configfiltermatchonepertext'] = 'Filry, které automaticky propojují obsah kurzů, vytvoří odkaz pouze u první nalezené shody v každém úseku textu (např. studijní materiál, blok apod.). Ostatní výskyty jsou ignorovány. Toto nastavení se nauplatní, pokud je proměnná \'Jedna shoda na stránku\' nastavena na \'Ano\'.';
$string['configfilteruploadedfiles'] = 'Filtrovat vložené textové a HTML soubory. (Při zapnutí této volby mohou nastat problémy s kódováním češtiny v textových souborech.)';
$string['configforcelogin'] = 'Vyžadovat přihlášení uživatele před zobrazením úvodní stránky nebo před jakoukoliv jinou činností na stránkách. V opačném případě je vyžadováno přihlášení až před vstupem do kurzu.';
$string['configforceloginforprofiles'] = 'Vynucovat přihlášení před zobrazením profilů ostatních uživatelů. Pokud zvolíte \'Ne\', můžete se dostat do situace, kdy někteří uživatelé publikují ve svém profilu nevhodný obsah (reklamu, spam), který je poté veřejně dostupný. Zejména pokud se na vašem serveru mohou libovolní návštěvníci registrovat sami, měli byste zvolit \'Ano\'.';
$string['configfrontpage'] = 'Položky vybrané výše budou zobrazeny na titulní stránce serveru.';
$string['configfrontpagecourselimit'] = 'Maximální počet kurzů';
$string['configfrontpagecourselimithelp'] = 'Maximální počet kurzů, které mají být zobrazeny v seznamu kurzů na titulní stránce.';
$string['configfrontpageloggedin'] = 'Přihlášeným uživatelům budou na titulní stránce serveru zobrazeny položky vybrané výše.';
$string['configfullnamedisplay'] = 'Vyberte způsob zobrazování jmen uživatelů. Nejvýhodnější je obvykle výchozí volba "fullnamedisplay" (Křestní jméno + Příjmení), můžete ale zobrazování příjmení zcela vypnout, nebo ponechat rozhodnutí na nastavení příslušného jazyka (různé jazyky mají různé konvence).';
$string['configgeoipfile'] = 'Cesta k binárkám GeoLite2 City. Tento soubor není součástí distribuce moodle a musí být získán samostatně z <a href="https://www.maxmind.com/">MaxMind</a>. Můžete si zakoupit komerční verzi, nebo použít volně dostupnou verzi. Budete si muset zaregistrovat a stáhnout soubor databáze City, který můžete udělat na <a href="https://geolite.maxmind.com/download/geoip/database/GeoLite2-City.mmdb.gz" >https://geolite.maxmind.com/download/geoip/database/GeoLite2-City.mmdb.gz</a>.  Po zaregistrování a stažení souboru jej rozbalte do adresáře <b>{$a}</b> na vašem serveru.';
$string['configgetremoteaddrconf'] = 'Pokud je váš Moodle umístěný za reverzním proxy serverem, můžete zde určit, které HTTP hlavičky obsahují IP adresu koncového klienta. Hlavičky jsou hledány v uvedeném pořadí a použije se první nalezená.';
$string['configgradebookroles'] = 'Které uživatele zobrazovat u výpisu klasifikace. Uživatelé potřebují alespoň jednu z těchto rolí v daném kurzu, aby byli zobrazeni u jeho popisu.';
$string['configgradeexport'] = 'Které z formátů pro export klasifikace chcete používat jako primární. Zvolené moduly nastaví a budou používat pole "naposledy exportováno" u každé známky. Toto může mj. vést k tomu, že exportované záznamy budou identifikovány jako "nové" nebo "aktualizované". Pokud si nejste jisti, nevolte žádnou z nabídek.';
$string['confighiddenuserfields'] = 'Která pole v profilech uživatelů mají být skryta před jinými uživateli, než jsou vyučující a správci? Pro označení více položek podržte klávesu CTRL.';
$string['configidnumber'] = 'Tato volba určuje, zda (a) uživatelé nejsou vůbec požádáni o ID číslo (např. rodné číslo, číslo občanského průkazu či jiný identifikátor); (b) uživatelé jsou požádáni o vyplnění ID čísla, ale nemusí jej zadávat; (c) uživatelé jsou požádáni o ID číslo a musejí je zadat. Je-li číslo zadáno, zobrazuje se v uživatelském profilu.';
$string['configintro'] = 'Na této stránce můžete určit hodnoty několika nastavitelných proměnných, díky nimž poběží Moodle na vašem serveru bez problémů. Nemějte obavy -- přednastavené hodnoty většinou postačují, a navíc se můžete na tuto stránku kdykoliv vrátit a nastavení změnit.';
$string['configintroadmin'] = 'Na této stránce byste měli nastavit váš hlavní administrátorský účet. Administrátor (správce) spravuje celou instalaci Moodlu. Ujistěte se, že zadáváte bezpečné uživatelské jméno a heslo, stejně jako platnou e-mailovou adresu. Později můžete vytvořit více administrátorských účtů.';
$string['configintrosite'] = 'Zde můžete nastavit vzhled titulní stránky a název stránek. Můžete se sem kdykoliv později vrátit a změnit toto nastavení ve Správě stránek.';
$string['configiplookup'] = 'Při kliknutí na IP adresu (jako např 86.49.131.129, typicky jsou zobrazovány v protokolech) se otevře mapa s vyznačením odhadované lokace daného počítače. Tuto funkci zajišťují různé zásuvné moduly, z nichž každý má své přednosti i nevýhody.';
$string['configkeeptagnamecase'] = 'Zaškrtněte, pokud si přejete, aby si štítky zachovávaly takovou velikost písmen, jakou použil uživatel, který je vložil.';
$string['configlang'] = 'Zvolte výchozí jazyk pro tyto stránky. Uživatelé si mohou nastavit svůj preferovaný jazyk ve svém profilu nebo vybrat jazyk pro aktuální sezení v nabídce na titulní stránce.';
$string['configlanglist'] = 'Seznam povolených jazyků. Jednotlivé kódy jazyků oddělte čárkami (např. "cs,en,es_es,fr,sk,it").

Ponecháte-li toto pole prázdné, budou si uživatelé moci vybrat libovolný nainstalovaný jazyk.';
$string['configlangmenu'] = 'Zobrazovat nabídku volby jazyka na titulní stránce, přihlašovací stránce apod. Tato volba neovlivňuje možnost nastavení jazyka v uživatelském profilu.';
$string['configlangstringcache'] = 'Zahrne do zkompilovaných souborů v datovém adresáři všechny jazykové řetězce. Pokud překládáte Moodle nebo měníte řetězce ve zdrojovém kódu Moodlu, budete tuto volbu pravděpodobně chtít vypnout. V ostatních případech ji nechte zapnutou, zlepší se tím výkon stránek.';
$string['configlatinexcelexport'] = 'Zvolte kódování pro exporty do MS Excel.';
$string['configlocale'] = 'Zde můžete přenastavit použitou sadu lokalizačních pravidel (locale) pro všechny jazykové balíčky. Příslušné locale musí být nainstalované na serveru. Ponecháte-li pole prázdné, bude pro češtinu použito locale "cs_CZ.utf8". V naprosté většině případů by toto pole mělo zůstat prázdné.';
$string['configloginhttps'] = 'Zapnout šifrovanou komunikaci HTTPS pouze pro přihlašovací stránku a poté přejít zpět na nezabezpečenou komunikaci HTTP. POZOR: HTTPS musí být plně funkční ještě před zapnutím této volby, v opačném případě se nebude moci nikdo přihlásit, ani vy!';
$string['configloglifetime'] = 'Doba, po kterou jsou uchovávány protokoly o činnosti uživatelů. Protokoly staršího data budou automaticky odstraňovány. Doporučujeme udržovat protokoly co nejdéle, mohou se vám hodit. Pokud však provozujete hodně využívaný server a máte problémy s jeho výkonem, zkraťte tuto dobu. Nedoporučuje se volit hodnoty nižší než 30, neboť poté může dojít k problémům při generování statistik.';
$string['configlookahead'] = 'Výhled';
$string['configmailnewline'] = 'Označení nového řádku v e-mailech. Podle RFC 822bis je předepsané označení konce řádku CRLF. Některé e-mailové servery automaticky převádějí znaky LF na CRLF, jiné zase chybně opravují CRLF na CRCRLF, nebo dokonce, jak například qmail, odmítají zprávy s prostým koncem řádku LF. Zkuste změnit toto nastavení, pokud máte problém s nedoručenou poštou, nebo s dvojitými mezerami mezi řádky.';
$string['configmaxbytes'] = 'Parametr určuje maximální velikost souborů nahraných na web. Tato hodnota je omezena parametry PHP post_max_size and a upload_max_filesize  stejně jako nastavení  Apache LimitRequestBody. U každého kurzu lze v rámci zde nastaveného rozmezí definovat vlastní maximální velikost nahrávaných souborů. Při hodnotě "Limit serveru" bude použita maximální velikost povolená serverem.';
$string['configmaxconsecutiveidentchars'] = 'Heslo nesmí obsahovat více než tento počet za sebou následujících shodných znaků. Pokud chcete kontrolu vypnout, zadejte 0.';
$string['configmaxeditingtime'] = 'Kolik času mají uživatelé na úpravu odeslaných diskusních příspěvků, komentářů k heslům ve slovníku apod. Doporučujeme nastavit 30 minut.';
$string['configmaxevents'] = 'Počet událostí';
$string['configmaxusersperpage'] = 'Maximální počet uživatelů zobrazených v poli pro výběr uživatelů v kurzu, skupině, globální skupině, webové službě atd.';
$string['configmessaging'] = 'Pokud je povoleno, mohou uživatelé odesílat zprávy dalším uživatelům na webu.';
$string['configmessagingallowemailoverride'] = 'Povolit uživatelům odesílání emailových zpráv na jinou adresu než je emailová adresa v jejich profilu';
$string['configmessagingallusers'] = 'Je-li tato volba povolena, mohou si uživatelé zobrazit seznam všech uživatelů na webu, když vyberou někoho, k zasílání zpráv, a jejich předvolby obsahují možnost přijmout zprávy od kohokoliv na webu.
Pokud je tato volba zakázána, uživatelé mohou zobrazit pouze seznam uživatelů ve svých kurzech a mají jen dvě možnosti v předvolbách zpráv - přijímat zprávy pouze od svých kontaktů nebo jejich kontaktů a kohokoli v kurzech.';
$string['configmessagingdeleteallnotificationsdelay'] = 'Přečtená a nepřečtená oznámení lze odstranit, aby se ušetřilo místo. Jak stará oznámení mohou být smazána?';
$string['configmessagingdeletereadnotificationsdelay'] = 'Přečtená upozornění mohou být odstraňována kvůli úspoře místa. Za jak dlouho poté, co je upozornění přečteno, může být odstraněno?';
$string['configminpassworddigits'] = 'Minimální počet číslic v heslech.';
$string['configminpasswordlength'] = 'Minimální počet znaků v heslech.';
$string['configminpasswordlower'] = 'Minimální počet malých písmen v heslech.';
$string['configminpasswordnonalphanum'] = 'Minimální počet nealfanumerických znaků v heslech.';
$string['configminpasswordupper'] = 'Minimální počet velkých písmen v heslech.';
$string['configmodchooserdefault'] = 'Zda se má ve výchozím stavu používat při úpravě kurzu průvodce přidáním obsahu.';
$string['configmycoursesperpage'] = 'Maximální počet kurzů, které se zobrazí na jakémkoliv výpisu kurzů uživatele';
$string['configmymoodleredirect'] = 'Používat stránku "Můj Moodle" namísto běžné úvodní stránky po přihlášení uživatelů?';
$string['configmypagelocked'] = 'Touto volbou je možno zamezit úpravám výchozí stránky samotnými uživateli. Správci mohou výchozí stránku upravovat vždy.';
$string['confignavcourselimit'] = 'Počet kurzů, které budou uživateli zobrazeny v navigaci.';
$string['confignavshowallcourses'] = 'Zda se mají uživatelům v navigaci zobrazovat jejich kurzy v položce Moje kurzy a Kurzy (seznam všech kurzů). Je-li vypnuto, pak uživatelé uvidí v navigaci pouze položku Moje kurzy (seznam kurzů, v nichž jsou zapsáni).';
$string['confignavshowcategories'] = 'Zda se mají v navigační liště a navigačním bloku zobrazovat i kategorie kurzů. V případě kurzů, do nichž je uživatel zapsán, se kategorie nezobrazuje a kurzy jsou uvedeny v části "Mé kurzy".';
$string['confignoreplyaddress'] = 'Z Moodlu jsou v některých případech odesílány jménem uživatele e-maily (např. příspěvky ve fórech). Jestliže si uživatel nepřeje zveřejnit svou adresu, bude použita tato náhradní adresa.';
$string['confignotifyloginfailures'] = 'Jestliže jsou zaznamenávány neúspěšné pokusy o přihlášení, vyberte, komu mají být zasílána hlášení. To vyžaduje povolit vnitřní logstore (např standardní Logstore).';
$string['confignotifyloginthreshold'] = 'Je-li aktivní upozorňování na neúspěšná přihlášení, po kolika neúspěšných pokusech na jednoho uživatele nebo jednu IP adresu se má upozornění rozeslat?';
$string['confignotloggedinroleid'] = 'Nepřihlášení návštěvníci vašich stránek budou považováni za uživatele, jimž je na globální úrovni celého serveru udělena tato role. Většinou je zde vhodné mít nastavenu roli Host, ale možná si budete chtít vytvořit vlastní roli s většími či menšími právy. Věci jako přidávání příspěvků apod. stále vyžadují platné přihlášení.';
$string['configopentogoogle'] = 'Dovolit vyhledávači Google indexovat obsah kurzů, které jsou přístupné pro hosty. Lidé, kteří se k vám dostanou pomocí vyhledávání v Googlu, budou automaticky přihlášeni jako host.';
$string['configoverride'] = 'Definováno v config.php';
$string['configpasswordpolicy'] = 'Pokud je povoleno, budou hesla uživatelů kontrolována podle zásad bezpečných hesel, jak je uvedeno v níže uvedených nastaveních. Povolení kontroly zásad hesla neovlivní stávající uživatele, dokud se nerozhodnou nebo nebudou muset změnit své heslo.';
$string['configpasswordresettime'] = 'Kolik času budou mít uživatelé na potvrzení žádosti o reset hesla. Doporučuje se něco kolem 30 minut.';
$string['configpathtodu'] = 'Cesta k programu "du" (disk usage). Pravděpodobně něco jako /usr/bin/du. Zadáním této cesty se urychlí generování stránek, které zobrazují obsah adresáře s mnoha soubory.';
$string['configpathtophp'] = 'Cesta do PHP CLI. Pravděpodobně něco jako /usr/bin/php. Pokud to zadáte, cron skripty mohou být spuštěny z webového rozhraní správce.';
$string['configperfdebug'] = 'Vypisování údajů o výkonu vašeho serveru v zápatí standardního motivu stránek.';
$string['configprofileroles'] = 'Seznam rolí, jejichž přidělení je viditelné v uživatelských profilech a na stránce se seznamem účastníků v kurzu.';
$string['configprofilesforenrolledusersonly'] = 'Aby se zabránilo zneužití vašich stránek, je automaticky skrýváno pole s popisem v profilu uživatelů, kteří nejsou zapsáni v žádném kurzu. Noví uživatelé se proto musejí zapsat alespoň do jednoho kurzu předtím, než si mohou upravit svůj popis v uživatelském profilu.';
$string['configprotectusernames'] = 'Je-li povoleno, formulář zapomenuté heslo nezobrazuje žádný tip, který by usnadnil uhodnutí uživatelských jmen nebo adres.';
$string['configproxybypass'] = 'Čárkami oddělený seznam doménových jmen nebo IP adres (i částečných), které nemají používat proxy server (např.: 192.168., .mojedomena.cz) ';
$string['configproxyhost'] = 'Nastavení proxy serveru - jestliže váš Moodle server nemá přímý přístup do Internetu, zadejte adresu a port proxy serveru. Jinak ponechejte prázdné.';
$string['configproxypassword'] = 'Pokud je pro přístup na internet přes proxy vyžadováno heslo, napište ho sem. V opačném případě nevyplňujte (je vyžadováno PHP cURL).';
$string['configproxyport'] = 'Pokud se váš server potřebuje připojovat pomocí proxy, uveďte zde proxy port.';
$string['configproxytype'] = 'Typ proxy serveru (je vyžadováno PHP5 a cURL pro podporu SOCKS5)';
$string['configproxyuser'] = 'Pokud je pro přístup na internet přes proxy vyžadováno uživatelské jméno, napište ho sem. V opačném případě nevyplňujte (je vyžadováno PHP cURL).';
$string['configrecaptchaprivatekey'] = 'Řetězec znaků (soukromý klíč) používaný ke komunikaci mezi vaším Moodlem a serverem recaptcha.net. Získáte ho na stránce  <a target="_blank" href="https://www.google.com/recaptcha">Google reCAPTCHA</a>.';
$string['configrecaptchapublickey'] = 'Řetězec znaků používaný při zobrazování prvku reCAPTCHA přihlašovacího formuláře. Řetězec ReCAPTCHA lze získat od <a target="_blank" href="https://www.google.com/recaptcha">Google reCAPTCHA</a>.';
$string['configrequestcategoryselection'] = 'Zda se má při vyplňování žádosti o založení kurzu povolit též výběr kategorie.';
$string['configrequestedstudentname'] = 'Slovo označující jednoho studenta v požadovaných kurzech';
$string['configrequestedstudentsname'] = 'Slovo označující více studentů v požadovaných kurzech';
$string['configrequestedteachername'] = 'Slovo označující jednoho učitele v požadovaných kurzech';
$string['configrequestedteachersname'] = 'Slovo označující více učitelů v požadovaných kurzech';
$string['configreverseproxyignore'] = 'Pokud váš server stojí za více reverzními proxy, které se připojují k záhlaví X-Forwarded-For, budete muset zadat seznam IP adres nebo podsítí reverzních proxy, které mají být ignorovány, aby bylo možné najít správnou IP adresu uživatelů.';
$string['configsectioninterface'] = 'Rozhraní';
$string['configsectionmail'] = 'Pošta';
$string['configsectionmaintenance'] = 'Údržba';
$string['configsectionmisc'] = 'Různé';
$string['configsectionoperatingsystem'] = 'Operační systém';
$string['configsectionpermissions'] = 'Oprávnění';
$string['configsectionrequestedcourse'] = 'Žádosti o založení kurzů';
$string['configsectionsecurity'] = 'Zabezpečení';
$string['configsectionstats'] = 'Statistiky';
$string['configsectionuser'] = 'Uživatel';
$string['configsecureforms'] = 'Používat vyšší úroveň zabezpečení při přijímání údajů z webových formulářů? Je-li tato volba povolena, pak je proměnná prohlížeče HTTP_REFERER ověřována proti aktuální adrese formuláře. V ojedinělých případech může toto nastavení způsobovat problémy, zejména používá-li uživatel firewall (např. Zonealarm nebo Kerio Personal Firewall) nastavený tak, aby hodnotu proměnné HTTP_REFERER blokoval. K příznakům patří problémy s formuláři, například na přihlašovací stránce. Jste-li na pochybách, ponechejte zde hodnotu \'Ano\'.';
$string['configsessioncookie'] = 'Název souboru cookie používaného těmito stránkami. Jde o volitelné nastavení, které je užitečné pouze  v případě, že provozujete více instalací Moodlu na jednom serveru.';
$string['configsessioncookiedomain'] = 'Zde můžete změnit doménu, ze které jsou dostupné Moodlovské cookies. To se vám může hodit, pokud např. používáte vlastní autentizační moduly a/nebo potřebujete sdílet informace o aktuální session s jinou webovou aplikací na jiné subdoméně. <strong>UPOZORNĚNÍ: silně doporučujeme ponechat výchozí (tj. prázdnou) hodnotu. Chybné nastavení může způsobit, že se na vaše stránky nebude možno vůbec přihlásit.</strong>';
$string['configsessioncookiepath'] = 'Podadresář vašich webových stránek, kam prohlížeče odesílají soubory cookie vaší instalace Moodlu. Pravděpodobně vám bude vyhovovat výchozí \'/\'.';
$string['configsessiontimeout'] = 'Délka nečinnosti, po níž jsou uživatelé automaticky odhlášeni.';
$string['configshowcommentscount'] = 'Zobrazovat počet komentářů za cenu jednoho extra databázového dotazu při zobrazování odkazu na komentáře.';
$string['configshowicalsource'] = 'Zobrazovat zdrojové informace pro události iCal';
$string['configshowsiteparticipantslist'] = 'Kdo má mít přístup k seznamu uživatelů stránek, který obsahuje všechny studenty a učitele?';
$string['configsitedefaultlicense'] = 'Výchozí licence';
$string['configsitedefaultlicensehelp'] = 'Výchozí licence pro publikování obsahu na vašich stránkách';
$string['configsitemailcharset'] = 'Toto nastavení určuje výchozí znakovou sadu pro všechny e-maily odeslané z webu.';
$string['configsitemaxcategorydepth'] = 'Maximální počet podkategorií';
$string['configsitemaxcategorydepthhelp'] = 'Do jaké hloubky se má zobrazovat hierarchie kategorií nebo rozbalovací seznam. Další úrovně kategorií se zobrazí jako odkazy, a uživatel může rozšířit žádostí AJAX.';
$string['configslasharguments'] = '"URL s názvem souboru za lomítkem" (pomocí <em>PATH_INFO</em>) je ke správnému zobrazení vyžadován pro SCORM balíčky a zdroje s více soubory. Když váš web tuto možnost nepodporuje, a nelze je nakonfigurovat, toto nastavení lze vypnout, i když to bude mít za následek nefungování.<br/> Poznámka: Používání "URL s názvem souboru za lomítkem" bude zapotřebí v budoucích verzích Moodlu.';
$string['configsmartpix'] = 'Je-li zapnuto, vyhledávají se ikony pomocí PHP skriptu nejprve v daném motivu, pak ve všech nadřazených motivech a nakonec ve složce /pix. Tím odpadá potřeba kopií obrázků napříč tématy, ale mírně se zvyšuje zátěž.';
$string['configsmtpauthtype'] = 'Tím se nastaví typ ověřování pro použití na SMTP server.';
$string['configsmtphosts'] = 'Zadejte adresu jednoho nebo více serverů SMTP, které bude Moodle používat k odesílání pošty (např. "smtp.naseskola.cz" nebo "192.168.0.100;mail2.naseskola.cz"). Pokud SMTP server používá jiný než standardní port 25, uveďte jej za dvojtečkou (např. "mail.naseskola.cz:587"). Pro šifrovaná spojení přes SSL se většinou používá port 465, přes TLS většinou port 587. Pokud ponecháte toto pole prázdné, bude Moodle používat standardní PHP způsob pro odesílání pošty.';
$string['configsmtpmaxbulk'] = 'Maximální počet e-mailů odeslaných během jedné relace se SMTP serverem. Seskupování e-mailů může odesílání zrychlit. Hodnoty nižší jak 2 vynutí vytvoření jedné relace pro každý odeslaný e-mail.';
$string['configsmtpsecure'] = 'Pokud SMTP server vyžaduje zabezpečené připojení, zadejte správný typ protokolu.';
$string['configsmtpuser'] = 'Jestliže server SMTP vyžaduje ověření, zadejte uživatelské jméno a heslo.';
$string['configstartwday'] = 'Začátek týdne';
$string['configstatsfirstrun'] = 'Jak daleko do minulosti se mají zpracovat statistiky <b>při prvním spuštění</b> této naplánované úlohy. Toto první zpracování může trvat dlouhou dobu a je docela náročné na systémové prostředky serveru. Jestliže je tedy na vašich stránkách velký provoz a navíc máte Moodle nainstalován na sdíleném hostingovém serveru, nedoporučujeme nastavovat příliš velkou hodnotu. Pro účely tohoto nastavení se jedním měsícem rozumí 28 dní. V generovaných grafech a statistikách odpovídá jeden měsíc jednomu kalendářnímu měsíci.';
$string['configstatsmaxruntime'] = 'Zpracování statistik může poměrně náročné. Využijte proto tohoto a následujícího pole a nastavte, kdy bude tato úloha spuštěna a jak dlouho poběží.';
$string['configstatsmaxruntime2'] = 'Zpracování může být poměrně náročné, proto určete maximální povolený čas na shromáždění statistik z jednoho dne. Maximální počet dní, které budou zpracovány při jednom spuštění cronu, je 31.';
$string['configstatsmaxruntime3'] = 'Kolik času dáte Moodlu na zpracování statistik za jeden den. Mějte na paměti, že zpracování statistik výrazně zatěžuje server. Počet dnů, které budou zpracovány v rámci jednoho spuštění služby cron, lze nastavit níže.';
$string['configstatsruntimedays'] = 'Kolik dnů může být zpracováno v rámci jednoho sběru statistik. Jsou-li vaše statistiky aktuální, bude zpracován pouze jeden (právě uplynulý) den. Upravte toto nastavení v závislosti na zatížení vašeho serveru. Snižte tuto hodnotu, pokud potřebujete kratší dobu provádění sběru statistik.';
$string['configstatsruntimestart'] = 'Kdy se má spustit úloha (cron) zpracovávající statistiky? Pokud na jednom stroji provozujete několik Moodle serverů, nastavte pro každý z nich jiný čas.';
$string['configstatsuserthreshold'] = 'Při vyhodnocování kurzů budou ignorovány kurzy, v nichž je zapsáno méně uživatelů (počítají se všechny role) než uvedená nenulová hodnota.';
$string['configstrictformsrequired'] = 'Je-li povoleno, nebudou uživatelé moci v určitých položkách formuláře zadávat mezery nebo konce řádků.';
$string['configstripalltitletags'] = 'Zda se mají odstranit HTML značky z názvů studijních materiálů a modulů činností. Používáte-li HTML v názvech modulů, nezaškrtávejte.';
$string['configsupportemail'] = 'Tato emailová adresa bude zveřejněna uživatelům pro případ obecné podpory na vašich stránkách (např. když si uživatel zakládá nový účet). Ponecháte-li prázdné, nebude tento kontakt na uživatelskou podporu uváděn.';
$string['configsupportname'] = 'Jméno osoby nebo instituce zodpovědné za uživatelskou podporu na vašich stránkách prostřednictvím emailu nebo webové stránky.';
$string['configsupportpage'] = 'Tato webová adresa bude zveřejněna uživatelům pro případ obecné podpory na vašich stránkách (např. když si uživatel zakládá nový účet). Ponecháte-li prázdné, nebude tento kontakt na uživatelskou podporu uváděn.';
$string['configtempdatafoldercleanup'] = 'Odstranit z datového adresáře soubory s dočasnými daty, které jsou jsou starší zvolený čas.';
$string['configthemedesignermode'] = 'Soubory s obrázky a s definicí kaskádových stylů (CSS) vašich grafických motivů jsou z důvodu výkonnosti ukládány ve vyrovnávací paměti serveru i prohlížečů. Pokud vyvíjíte vlastní grafický motiv nebo upravujete kód Moodle, můžete chtít zapnout tento speciální režim, při němž není vyrovnávací paměť používána a s každým požadavkem si prohlížeč stahuje celý motiv. Pozor, to samozřejmě způsobí zpomalení načítání vašich stránek pro všechny uživatele. Jako alternativní řešení můžete proto zvolit jednorázový ruční reset vyrovnávacích pamětí na stránce s výběrem motivu.';
$string['configthemelist'] = 'Ponecháte-li toto pole prázdné, budou si uživatelé moci vybrat libovolný dostupný motiv vašich stránek. Jinak zde uveďte seznam povolených motivů. Jednotlivé názvy oddělte čárkou (např. \'standard,metal,garden\'). Pozor - nepoužívejte v seznamu mezery!';
$string['configtimezone'] = 'Vyberte časové pásmo, v němž se nachází váš server. Uživatelé si mohou toto nastavení změnit v uživatelském profilu. Úlohy spouštěné cronem se řídí zde nastaveným časovým pásmem. Nastavení byste měli  změnit , pokud se ukáže "Neplatné časové pásmo"';
$string['configuseblogassociations'] = 'Mají mít uživatelé možnost nastavit příspěvky v jejich blogu jako související s konkrétními kurzy a moduly činností v těchto kurzech?';
$string['configuseexternalyui'] = 'Zda se mají namísto lokální kopie v Moodle používat YUI knihovny dostupné online přímo na serverech Yahoo. Pokud nebudou mít k dispozici připojení k Internetu, nebude AJAX fungovat uživatelům vůbec.

Toto nastavení není kompatibilní se stránkami zobrazovanými přes protokol https://.';
$string['configuserquota'] = 'Kolik maximálně celkem mohou zabírat soubory, které si uživatelé uložili do svých soukromých souborových oblastí. {$a->bytes} bajtů == {$a->displaysize}';
$string['configusesitenameforsitepages'] = 'Zda se má v navigaci používat krátký název stránek namísto textu "Hlavní nabídka".';
$string['configusetags'] = 'Povolit na těchto stránkách funkci štítků?';
$string['configvariables'] = 'Obecné parametry';
$string['configverifychangedemail'] = 'Povolit kontrolu změněných emailových adres oproti seznamu povolených a zakázaných emailových domén. Pokud toto nastavení není povoleno, pak se emailové adresy kontrolují pouze při zakládání účtu.';
$string['configvisiblecourses'] = 'Zobrazovat kurzy ve skrytých kategoriích normálně';
$string['configwarning'] = 'Následující hodnoty upravujte velmi opatrně -- nestandardní hodnoty mohou způsobovat problémy.';
$string['configyuicomboloading'] = 'Zda povolit optimalizaci nahrávání YUI knihoven. Z důvodu výkonnosti by mělo být vždy povoleno na produkčních serverech.';
$string['confirmation'] = 'Potvrzení';
$string['confirmcontextlock'] = '{$a->contextname} je v současné době nezmrazen. Zmrazením se zpřístupní pouze pro čtení a uživatelům zabrání, aby provedli změny. Opravdu chcete pokračovat?';
$string['confirmcontextunlock'] = '{$a->contextname} je v současné době zmrazen. Rozmrazení umožní uživatelům provádět změny. Opravdu chcete pokračovat?';
$string['confirmdeletecomments'] = 'Opravdu odstranit komentáře?';
$string['confirmed'] = 'Potvrzeno';
$string['contextlockappliestoadmin'] = 'Zmrazení kontextu platí pro správce';
$string['contextlockappliestoadmin_desc'] = 'Je-li zakázáno, administrátoři mají přístup k zápisu do libovolného zmrazeného kontextu.';
$string['contextlocking'] = 'Zmrazení kontextu';
$string['contextlocking_desc'] = 'Toto nastavení umožňuje nastavit pro vybrané kategorie, kurzy, aktivity nebo bloky přístup jen pro čtení.';
$string['cookiehttponly'] = 'Pouze HTTP cookies';
$string['cookiesecure'] = 'Pouze zabezbečená cookies';
$string['country'] = 'Výchozí země';
$string['coursecontact'] = 'Vedoucí kurzů';
$string['coursecontact_desc'] = 'Které uživatele zobrazovat u popisu kurzu. Uživatelé potřebují alespoň jednu z těchto rolí v daném kurzu, aby byli zobrazeni u jeho popisu.';
$string['coursecontactduplicates'] = 'Zobrazit kontaktní role všech kurzů';
$string['coursecontactduplicates_desc'] = 'Pokud je povoleno, uživatelé s více než jednou z vybraných rolí kontaktů kurzu se v popisu kurzu zobrazí s každou z jejich rolí. V opačném případě budou zobrazeny pouze s jednou rolí (podle toho, co je uvedeno nejvyšší v části "Definovat role" ve Správě stránek).';
$string['coursegraceperiodafter'] = 'Doba odkladu pro minulé kurzy';
$string['coursegraceperiodbefore'] = 'Doba odkladu pro budoucí kurzy';
$string['courselistshortnames'] = 'Zobrazovat celé názvy kurzů';
$string['courselistshortnames_desc'] = 'Je-li povoleno, budou v seznamu kurzů kurzy uvedeny včetně svého krátkého názvu. V případě potřeby může být celé jméno kurzu přizpůsobeno úpravou  jazykového řetězce "courseextendednamedisplay" pomocí funkce úprava jazyka.';
$string['coursemgmt'] = 'Správa kurzů a kategorií';
$string['courseoverview'] = 'Přehled kurzů';
$string['courserequestnotify'] = 'Upozornění na žádost o kurz';
$string['courserequestnotifyemail'] = '{$a->user} žádá o založení nového kurzu na {$a->link}';
$string['courserequests'] = 'Požadované kurzy';
$string['courserequestspending'] = 'Čekající žádosti o nový kurz';
$string['courses'] = 'Kurzy';
$string['coursesperpage'] = 'Počet kurzů na stránku';
$string['courseswithsummarieslimit'] = 'Počet kurzů se souhrny';
$string['creatornewroleid'] = 'Role tvůrců v nových kurzech';
$string['creatornewroleid_help'] = 'Pokud uživatel ještě nemá oprávnění spravovat nový kurz, je automaticky zapsán pomocí této role.';
$string['cron'] = 'Cron';
$string['cronclionly'] = 'Spouštění cronu pouze z příkazové řádky';
$string['cronerrorclionly'] = 'Je mi líto. Přístup na tuto stránku z webového rozhraní byl správcem zakázán.';
$string['cronerrorpassword'] = 'Je mi líto. Pro přístup na tuto stránku musíte použít platné heslo.';
$string['cron_help'] = 'Skript cron.php spouští řadu úloh v různých naplánovaných intervalech, jako je posílání e-mailů s příspěvky fóra. Skript by měl běžet pravidelně - v ideálním případě každou minutu.';
$string['cronremotepassword'] = 'Heslo pro spuštění cronu';
$string['cronwarning'] = 'Skript <a href="{$a}"> cron.php</a>, který má na starosti běžnou údržbu serveru, nebyl během posledních 24 hodin spuštěn.';
$string['cronwarningcli'] = 'Skript cli/cron.php nebyl během posledních 24 hodin spuštěn.';
$string['ctyperequired'] = 'Rozšíření PHP ctype je Moodlem vyžadováno z důvodů výkonu a vícejazyčné podpory.';
$string['curlcache'] = 'TTL vyrovnávací paměti cURL';
$string['curlrequired'] = 'Instalace knihovny cURL je nutná pro komunikaci s externími repozitáři obsahu.';
$string['curlsecurityallowedport'] = 'cURL seznam povolených portů';
$string['curlsecurityallowedportsyntax'] = 'Seznam čísel portů, přes  které se cURL může připojit. Platné hodnoty jsou pouze celá čísla. Zadejte každý záznam na nový řádek. Pokud je ponechán prázdný, pak jsou povoleny všechny porty. Je-li nastaveno, téměř ve všech případech, a mělo by být nastaveno jak 443 a 80 pro připojení cURL k standardním portům HTTPS a HTTP.';
$string['curlsecurityblockedhosts'] = 'cURL seznam blokovaných hostitelů';
$string['curlsecurityblockedhostssyntax'] = 'Vložte každý záznam na samostatný řádek. Platné hodnoty jsou buď celá IPv4 nebo IPv6 adresa (např. 192.168.10.1, 0:0:0:0:0:0:0:1, ::1, fe80::), které odpovídají jeden hostitelský systém; nebo CIDR notace (např. 231.54.211.0/20 or fe80::/64); nebo rozsah IP adres (např. 231.3.56.10-20 or fe80::1111-bbbb), kde rozsah platí pro poslední skupiny adresy; nebo názvy domén (např. localhost or example.com); nebo zástupná doménová jména (např. *.example.com nebo *.sub.example.com). Prázdné řádky nejsou povoleny.';
$string['curlsecurityurlblocked'] = 'Adresa URL je blokována.';
$string['curltimeoutkbitrate'] = 'Nejnižší předpokládaná rychlost stahování přes cURL (kb/s)';
$string['curltimeoutkbitrate_help'] = 'Když váš server stahuje obsah z internetu (např. ze vzdáleného repozitáře), může vždy předpokládat stahování alespoň touto nastavenou rychlostí. Podle toho si přepočítá potřebný čas pro vypršení spojení (timeout). Pro získání velikosti stahovaného souboru se použije HTTP požadavek typu HEAD.

Při vložení hodnoty 0 nebude odesílán žádný HEAD požadavek a čas pro vypršení spojení bude nastaven na fixní hodnotu definovanou v kódu.';
$string['currenttheme'] = 'Aktuální motiv';
$string['customcheck'] = 'Další kontroly';
$string['custommenu'] = 'Vlastní nabídka';
$string['custommenuitems'] = 'Položky vlastní nabídky';
$string['customusermenuitems'] = 'Položky uživatelské nabídky';
$string['datarootsecurityerror'] = '<p><strong>BEZPEČNOSTNÍ VAROVÁNÍ!</strong></p><p>Váš datový adresář (dataroot) je chybně umístěn a je přímo dostupný přes WWW. Všechny privátní soubory Moodlu jsou dostupné komukoliv na Internetu. Některé z nich mohou posloužit útočníkům k získání neoprávněného přístupu na úrovni správce vašeho serveru!</p>
<p><em>Musíte</em> přesunout váš datový adresář ({$a}) tak, aby nebyl ve veřejném webovém adresáři a adekvátně tomu upravit nastavení <code>$CFG->dataroot</code> v souboru config.php.</p>';
$string['datarootsecuritywarning'] = 'Bezpečnostní varování - zkontrolujte si, že datový adresář ({$a}) není přímo dostupný přes webové rozhraní.';
$string['dbsessions'] = 'Informace o session ukládat v databázi';
$string['debug'] = 'Ladící informace';
$string['debugall'] = 'ALL: Zobrazovat všechny smysluplné ladící informace z PHP';
$string['debugdeveloper'] = 'DEVELOPER: extra informace pro vývojáře Moodlu';
$string['debugdisplay'] = 'Zobrazení ladících informací';
$string['debugging'] = 'Ladění';
$string['debugminimal'] = 'MINIMAL: Zobrazovat pouze fatální chyby';
$string['debugnone'] = 'NONE: Nezobrazuj žádné zprávy ani varování';
$string['debugnormal'] = 'NORMAL: Zobrazuj chyby, varování a upozornění';
$string['debugpageinfo'] = 'Zobrazovat ladící informace';
$string['debugsmtp'] = 'Ladit odesílání emailů';
$string['debugstringids'] = 'Zobrazovat identifikátory řetězců';
$string['debugstringids_desc'] = 'Je-li povoleno, zobrazí se komponenty jazykových řetězců a identifikátory, když k adresám URL stránky jsou připojeny řetězce ?strings=1 nebo &strings=1.';
$string['debugvalidators'] = 'Zobrazovat odkazy na validátory obsahu';
$string['defaultcity'] = 'Výchozí město';
$string['defaultcity_help'] = 'Město, které zde zadáte, bude výchozím městem při vytváření nových uživatelských účtů.';
$string['defaultformatnotset'] = 'Chyba při nastavení výchozího formátu kurzu. Zkontrolujte nastavení stránek.';
$string['defaulthomepage'] = 'Domovská stránka uživatelů';
$string['defaultrequestcategory'] = 'Výchozí kategorie pro požadované kurzy';
$string['defaultsettinginfo'] = 'Výchozí: <b>{$a}</b>';
$string['defaultuserroleid'] = 'Výchozí role pro všechny uživatele';
$string['deleteincompleteusers'] = 'Odstranit účty bez dokončené registrace po';
$string['deleteunconfirmed'] = 'Odstranit nepotvrzené a neúplné účty po';
$string['deleteuser'] = 'Odstranit uživatele';
$string['density'] = 'Hustota';
$string['denyemailaddresses'] = 'Zakázané emailové domény';
$string['development'] = 'Vývoj';
$string['devicedetectregex'] = 'Regulární výrazy pro detekci zařízení';
$string['devicedetectregex_desc'] = 'Ve výchozím nastavení umí Moodle detekovat tzv. běžná zařízení ("default" - stolní počítače, notebooky), mobilní zařízení ("mobile" - mobilní telefony, hand held zařízení), tablety ("tablet" - iPad, Android tablet) a některé zastaralé prohlížeče ("legacy" - např. Internet Explorer 6). Nástroj pro volbu grafického motivu pak dovoluje vybrat různé motivy pro tyto jednotlivé typy zařízení. Pomocí tohoto nastavení je možno nadefinovat ještě jemnější rozlišování typu zařízení, které má pak přednost před uvedenými typy.

Například můžete zadat regulární výraz \'/(MIDP-1.0|Maemo|Windows CE)/\' a pojmenovat takto identifikovatelná zařízení vlastním označením, např. "featurephone". Na stránce s výběrem motivu pak můžete pro tato zařízení vybrat specificky upravený motiv, máte-li jej k dispozici. Všechny ostatní telefony by pak používaly motiv vybraný pro obecný typ zařízení "mobile".';
$string['devicedetectregexexpression'] = 'Regulární výraz';
$string['devicedetectregexvalue'] = 'Označení typu zařízení';
$string['devicetype'] = 'Typ zařízení';
$string['devlibdirpresent'] = 'Adresáře s vývojovými knihovnami, zejména <em> vendor</em> nebo <em> node_modules </em>, by se neměly nacházet na veřejných serverech. Další podrobnosti naleznete v přehledu přehledů zabezpečení <a href="{$a->moreinfourl}"> Přehled zabezpečení </a>.';
$string['disableuserimages'] = 'Zakázat profilové fotografie uživatelů';
$string['displayerrorswarning'] = 'Povolené nastavení PHP <em>display_errors</em> není doporučováno v ostrém provozu, protože některá chybová hlášení mohou případným útočníkům prozradit citlivé informace o vaší instalaci.';
$string['displayloginfailures'] = 'Zobrazovat neúspěšná přihlášení';
$string['dndallowtextandlinks'] = 'Pro nahrání přetáhněte text/odkaz';
$string['doclang'] = 'Jazyk dokumentace';
$string['docroot'] = 'Umístění dokumentace';
$string['doctonewwindow'] = 'Otevírat v novém okně';
$string['doesnotfit'] = 'Nastavení zobrazení e-mailu';
$string['doesnotfitdetail'] = 'Nastavení zobrazení pro e-mail odeslaný z Moodle.';
$string['download'] = 'Stáhnout';
$string['durationunits'] = 'jednotky trvání';
$string['edithelpdocs'] = 'Upravit nápovědu';
$string['editlang'] = '<b>Úpravy</b>';
$string['editorbackgroundcolor'] = 'Barva pozadí';
$string['editordictionary'] = 'Slovník editoru';
$string['editorfontfamily'] = 'Rodina fontů';
$string['editorfontlist'] = 'Seznam fontů';
$string['editorfontsize'] = 'Velikost fontu';
$string['editorhidebuttons'] = 'Skrytá tlačítka';
$string['editorkillword'] = 'Čištění formátu z MS Word';
$string['editorspelling'] = 'Pravopis editoru';
$string['editorspellinghelp'] = 'Povolit nebo zakázat kontrolu pravopisu. Pokud je povoleno, musí být na serveru nainstalován <strong>aspell</strong>.';
$string['editstrings'] = 'Upravit textové řetězce';
$string['emailchangeconfirmation'] = 'Potvrzovat změnu emailu';
$string['emailfromvia'] = 'E-mail pomocí informace';
$string['emoticonalt'] = 'Alternativní text';
$string['emoticoncomponent'] = 'Komponenta obrázku';
$string['emoticonimagename'] = 'Jméno souboru';
$string['emoticons'] = 'Emotikony';
$string['emoticons_desc'] = 'Tento formulář definuje emotikony (smajlíky) používané na vašich stránkách. Chcete-li odstranit některý řádek, uložte formulář s prázdnou hodnotou v některém z povinných polí. K zaregistrování nové emotikony vyplňte řádek na konci formuláře. Pro návrat k výchozím hodnotám použijte odkaz níže.

* Text (povinný) - Tento text bude nahrazen nastaveným obrázkem. Musí obsahovat alespoň dva znaky.
* Jméno souboru (povinné) - Jméno souboru s emotikonou bez přípony, relativně k adresáři "pix" v dané komponentě
* Komponenta obrázku (povinná) - Komponenta obsahující obrázek s emotikonou
* Alternativní text (volitelný) - Identifikátor řetězce pro alternativní text obrázku a komponenta, jejíž jazykový balíček tento řetězec definuje.';
$string['emoticonsreset'] = 'Resetovat emotikony na výchozí hodnoty';
$string['emoticontext'] = 'Text';
$string['emptysettingvalue'] = 'Prázdný';
$string['enableactivitychooser'] = 'Povolit průvodce přidání obsahu';
$string['enableblogs'] = 'Povolit blogy';
$string['enablecalendarexport'] = 'Povolit export kalendáře';
$string['enablecomments'] = 'Povolit komentáře';
$string['enablecourserequests'] = 'Povolit požadování kurzů';
$string['enabled'] = 'Povoleno';
$string['enabledevicedetection'] = 'Povolit detekci zařízení';
$string['enableglobalsearch'] = 'Povolit globální vyhledávání';
$string['enableglobalsearch_desc'] = 'Je-li povoleno, budou data indexována a synchronizována pomocí naplánované úlohy.';
$string['enablegravatar'] = 'Povolit Gravatar';
$string['enablegravatar_help'] = 'Pokud si uživatel nenahraje svůj profilový obrázek, má se jej Moodle pokusit získat ze stránek Gravatar?';
$string['enablemobilewebservice'] = 'Povolit webové služby pro mobilní zařízení';
$string['enablerecordcache'] = 'Povolit vyrovnávací paměť záznamů';
$string['enablerssfeeds'] = 'Povolit RSS zdroje';
$string['enablesafebrowserintegration'] = 'Povolit prohlížeč Safe exam';
$string['enablesearchareas'] = 'Povolit vyhledávání oblastí';
$string['enablestats'] = 'Povolit statistiky';
$string['enabletrusttext'] = 'Povolit funkci důvěryhodného obsahu';
$string['enablewebservices'] = 'Povolit webové služby';
$string['enablewsdocumentation'] = 'Povolit automatické dokumentování webových služeb';
$string['enrolinstancedefaults'] = 'Výchozí nastavení zápisů do kurzu';
$string['enrolinstancedefaults_desc'] = 'Definuje výchozí hodnoty nastavení pro řízení zápisů v nových kurzech.';
$string['enrolmultipleusers'] = 'Zapsat tyto uživatele';
$string['environment'] = 'Programové prostředí';
$string['environmenterrortodo'] = 'Pro pokračování v instalaci této verze Moodlu je nutné nejdříve vyřešit problémy v programovém prostředí (chyby) serveru uvedené výše!';
$string['environmenterrorupgrade'] = 'Výstraha: předtím, než budete pokračovat s upgradem na tuto verzi Moodle, vyřešte prosím všechny problémy s prostředím, uvedené výše. Provedení upgrade před vyřešením těchto problémů by mohlo vést k problémům, až ke ztrátě dat. Chcete pokračovat?';
$string['environmentmariadbwrongdbtype'] = 'Chybný <code>$CFG->dbtype</code>: musíte jej změnit v souboru o change it in your <code>config.php</code>, od  "<code>mysql</code>" do "<code>mariadb</code>".';
$string['environmentmustfixsetting'] = 'Je vyžadována změna nastavení PHP';
$string['environmentok'] = 'Prostředí Vašeho serveru plní všechny minimální požadavky.';
$string['environmentrecommendcustomcheck'] = 'Pokud tento test selhal, znamená to možné problémy';
$string['environmentrecommendinstall'] = 'mělo by být nainstalováno a povoleno';
$string['environmentrecommendversion'] = 'doporučena je verze {$a->needed}, nyní používáte verzi {$a->current}';
$string['environmentrequirecustomcheck'] = 'Tento test musí projít';
$string['environmentrequireinstall'] = 'musí být nainstalováno a povoleno';
$string['environmentrequireversion'] = 'vyžadována je verze {$a->needed}, nyní používáte verzi {$a->current}';
$string['environmentsettingok'] = 'detekováno doporučené nastavení';
$string['environmentshouldfixsetting'] = 'Je doporučená změna nastavení PHP';
$string['environmentxmlerror'] = 'Chyba při zjišťování údajů o programovém prostředí ({$a->error_code})';
$string['errordeletingconfig'] = 'Při odstraňování konfiguračních záznamů pro modul "{$a}" došlo k chybě.';
$string['errorsetting'] = 'Nelze uložit nastavení:';
$string['errorwithsettings'] = 'Některá nastavení nebyla změněna kvůli chybě.';
$string['eventshandlersinuse'] = 'Následující zásuvné moduly ve vašem systému používají zastaralé ovladače z Events 1 API: "{$a}". Aktualizujte je prosím na použití Events 2 API. Více na https://docs.moodle.org/dev/Event_2#Event_dispatching_and_observers.';
$string['everyonewhocan'] = 'Každý kdo může "{$a}"';
$string['exceptions'] = 'výjimky';
$string['execpathnotallowed'] = 'Nastavení spustitelných a lokálních cest bylo zakázáno v souboru config.php';
$string['experimental'] = 'Experimentální';
$string['experimentalsettings'] = 'Experimentální funkce';
$string['extendedusernamechars'] = 'Povolit nestandardní znaky v uživatelských jménech';
$string['extramemorylimit'] = 'Extra navýšení paměťového limitu PHP';
$string['fatalsessionautostart'] = '<p>Byla nalezena vážná chyba nastavení, prosím kontaktujte správce serveru.</p><p>Pro správnou funkci Moodle je nutné změnit nastavení PHP.</p><p><code>session.auto_start</code> musí být nastaven na <code>off</code>.</p><p>Toto nastavení se provádí úpravou souboru <code>php.ini</code>, změnou nastavení Apache/IIS <br /> nebo úpravou souboru <code>.htaccess</code> na serveru.</p>';
$string['fileconversioncleanuptask'] = 'Vyčistit dočasné záznamy pro konverzi souborů.';
$string['filecreated'] = 'Vytvořen nový soubor';
$string['filestoredin'] = 'Ukládat soubor do složky:';
$string['filestoredinhelp'] = 'Kde budou ukládány soubory';
$string['filterall'] = 'Použít filtry na všechny řetězce';
$string['filtermatchoneperpage'] = 'Jedna shoda na stránku';
$string['filtermatchonepertext'] = 'Jedna shoda na úsek textu';
$string['filters'] = 'Filtry';
$string['filtersettings'] = 'Správa filtrů';
$string['filtersettingsgeneral'] = 'Obecná nastavení filtru';
$string['filteruploadedfiles'] = 'Použít filtry na uploadované soubory';
$string['forceclean'] = 'Čištění obsahu všude';
$string['forceclean_desc'] = 'Obsah přidaný k webu je obvykle před jeho zobrazením vyčištěn a odstraněno vše, co by mohlo představovat bezpečnostní hrozbu. Obsah však na určitých místech není vyčištěn, jako jsou popisy činnosti, zdroje stránek nebo bloky HTML, které umožňují přidávat skripty, média, rámce inline atd. Je-li toto nastavení zapnuto, bude vyčištěn veškerý obsah. To může mít za následek, že se již nebude zobrazovat správně již existující obsah.';
$string['forcelogin'] = 'Vnutit přihlášení';
$string['forceloginforprofileimage'] = 'Pro zobrazení uživatelských fotografií vnutit přihlášení';
$string['forceloginforprofileimage_help'] = 'Zda se má zakázat zobrazení fotografií uživatelů anonymním návštěvníkům vašich stránek. Zároveň zajistí, že fotografie uživatelů odesílané jako součást e-mailu budou nahrazeny výchozím univerzálním obrázkem.';
$string['forceloginforprofiles'] = 'Pro  zobrazování profilů vnutit přihlášení';
$string['forcetimezone'] = 'Vnutit časové pásmo';
$string['formatuninstallwithcourses'] = 'K dispozici jsou {$a->count} kurzy používající formát {$a->format}. Jejich formát se změní na {$a->defaultformat} (výchozí formát pro tyto stránky). Některé specifické údaje pro původní formát mohou být ztraceny. Jste si jisti, že chcete pokračovat?';
$string['frontpage'] = 'Titulní stránka';
$string['frontpagebackup'] = 'Záloha titulní stránky';
$string['frontpagedefaultrole'] = 'Výchozí role na titulní stránce';
$string['frontpagefilters'] = 'Filtry na titulní stránce';
$string['frontpageloggedin'] = 'Položky na titulní stránce po přihlášení';
$string['frontpageoverrides'] = 'Přenastavení oprávnění na titulní stránce';
$string['frontpagequestions'] = 'Úlohy na titulní straně';
$string['frontpagerestore'] = 'Obnova titulní stránky';
$string['frontpageroles'] = 'Role na titulní stránce';
$string['frontpagesettings'] = 'Nastavení titulní stránky';
$string['fullnamedisplay'] = 'Formát celého jména';
$string['fullnamedisplayprivate'] = 'Formát celého jména - soukromé';
$string['gdrequired'] = 'Pro konverzi obrazu je nyní Moodlem vyžadováno rozšíření GD.';
$string['generalsettings'] = 'Obecná nastavení';
$string['geoipfile'] = 'GeoLite2 City MaxMind DB';
$string['getremoteaddrconf'] = 'Zdroj IP adresy klienta';
$string['globalsearch'] = 'Globální vyhledávání';
$string['globalsearchmanage'] = 'Spravovat globální vyhledávání';
$string['googlemapkey3'] = 'Klíč Google Maps API V3';
$string['googlemapkey3_help'] = 'Musíte zadat speciální klíč k použití Google Maps pro IP adresy vyhledávání vizualizace. Můžete získat bezplatný klíč na <a href="https://developers.google.com/maps/documentation/javascript/tutorial#api_key" target="_blank">https://developers.google.com/maps/documentation/javascript/tutorial#api_key</a>';
$string['gotofirst'] = 'První chybějící řetězec';
$string['gradebook'] = 'Klasifikace';
$string['gradebookroles'] = 'Klasifikovaní uživatelé';
$string['gradeexport'] = 'Primární způsoby exportu známek';
$string['gravatardefaulturl'] = 'Výchozí URL adresa obrázku Gravatar';
$string['gravatardefaulturl_help'] = 'Gravatar potřebuje k zobrazení výchozí obrázek, jestliže pro daného uživatele nemůže najít obrázek. Pro obrázek zadejte úplnou URL adresu. Moodle se pokusí použít nejvhodnější výchozí obrázek pro danou stránku, pokud toto nastavení necháte prázdné. Všimněte si také, že Gravatar má řadu kódů, které mohou být použity ke <a href="https://en.gravatar.com/site/implement/images/#default-image">generování výchozího obrázku</a>.';
$string['groupenrolmentkeypolicy'] = 'Použít bezpečnostní zásady na klíč pro zápis do skupiny.';
$string['groupenrolmentkeypolicy_desc'] = 'Pokud je povoleno, budou nadefinované zásady bezpečného hesla aplikovány též na klíče pro zápis do skupiny podle zásad, jak je uvedeno v nastavení výše.';
$string['guestroleid'] = 'Role hosta';
$string['guestroleid_help'] = 'Tato role je automaticky přiřazována anonymním uživatelům, kteří na stránky přistupují pomocí tlačítka "Přihlásit se jako host". Role je rovněž dočasně přidělena přihlášeným uživatelům, kteří vstupují do kurzu, do něhož nejsou zapsaní a který povoluje vstup pro hosty.';
$string['helpadminseesall'] = 'V kalendáři webových stránek vidí a filtrují správci události ze všech kalendářů kurzů nebo pouze z kurzů, ve kterých jsou zapsáni? Bez ohledu na zvolenou možnost budou správci vždy moci spravovat události pro každý kalendář kurzů tím, že budou navigovat nejprve do kurzu a poté přistupovat přímo do kalendáře kurzu.';
$string['helpcalendarcustomexport'] = 'Povolit volbu vlastního časové období v exportech kalendáře. Exporty kalendáře musí být povoleny, dříve než je to účinné.';
$string['helpexportlookahead'] = 'Kolik dní v budoucnu bude kalendář prohledáván během exportu událostí pro volbu vlastního exportu?';
$string['helpexportlookback'] = 'Kolik dní v minulosti bude kalendář prohledáván během exportu událostí pro volbu vlastního exportu?';
$string['helpforcetimezone'] = 'Zvolte, zda chcete umožnit uživatelům změnu časového pásma, nebo vyberte jedno pásmo společné pro všechny.';
$string['helpshowicalsource'] = 'Pokud je povoleno, bude název předplatného a odkaz zobrazen pro importované události iCal.';
$string['helpsitemaintenance'] = 'Pro případ upgradů a jiné údržby';
$string['helpstartofweek'] = 'Kterým dnem u vás začíná týden. Jestli nevíte, zvolte pondělí ;-)';
$string['helpupcominglookahead'] = 'V kolika následujících dnech se mají implicitně vyhledávat tzv. nadcházející události?';
$string['helpupcomingmaxevents'] = 'Kolik nadcházející událostí se má maximálně zobrazovat?';
$string['helpweekenddays'] = 'Které z dnů v týdnu se mají považovat za \'víkend\' a zobrazovat se v kalendáři odlišnou barvou?';
$string['hiddenuserfields'] = 'Skrýt uživatelská pole';
$string['hidefromall'] = 'Skrýt před všemi uživateli';
$string['hidefromnone'] = 'Neskrývat před nikým';
$string['hidefromstudents'] = 'Skrývat před studenty';
$string['htmleditor'] = 'Editor HTML';
$string['htmleditorsettings'] = 'Nastavení HTML editoru';
$string['htmlsettings'] = 'Nastavení HTML';
$string['http'] = 'HTTP';
$string['httpsecurity'] = 'Zabezpečení HTTP';
$string['hubs'] = 'Komunitní úložiště';
$string['iconvrequired'] = 'Je vyžadováno rozšíření ICONV';
$string['ignore'] = 'Ignorovat';
$string['includemoduleuserdata'] = 'Zahrnout uživatelská data modulu';
$string['incompatibleblocks'] = 'Nekompatibilní bloky';
$string['incompleteunicodesupport'] = 'Aktuální nastavení MySQL nebo MariaDB používá "utf8". Tato znaková sada nepodporuje čtyři bytové znaky, které obsahují některé Emoji (ideogramy) . Snaha používat tyto znaky bude mít za následek chyby při aktualizaci záznamu, a veškeré informace  odesláné do databáze budou ztraceny. Prosím, zvažte změnu nastavení na "utf8mb4". V dokumentaci naleznete detailní podrobnosti.';
$string['indexdata'] = 'Indexovat data';
$string['indexinginfo'] = 'Doporučený způsob indexovat obsah vašeho webu je pomocí naplánované úlohy "Indexování Globálního vyhledávání".';
$string['installhijacked'] = 'Instalace musí být dokončena ze stejné IP adresy, ze které byla odstartována.';
$string['installsessionerror'] = 'Nelze inicializovat PHP session. Ujistěte sem, že váš prohlížeč podporuje cookies.';
$string['intlrecommended'] = 'Rozšíření intl umožňuje lepší podporu lokalizace Moodle, např. při abecedním řazení dle jazykových pravidel';
$string['intlrequired'] = 'Rozšíření Intl je vyžadováno pro zlepšení mezinárodní podpory, jako je lokální řazení a mezinárodní názvy domén.';
$string['invalidagedigitalconsent'] = 'Věk pro udělení digitálního souhlasu není platný: {$a}';
$string['invalidforgottenpasswordurl'] = 'URL zapomenutého hesla není platná adresa URL.';
$string['invalidsection'] = 'Neplatná sekce';
$string['invaliduserchangeme'] = 'Uživatelské jméno \'changeme\' je rezervováno -- nelze je použít pro vytvoření účtu.';
$string['ipblocked'] = 'Tyto stránky nejsou momentálně k dispozici.';
$string['ipblocker'] = 'Blokování IP adres';
$string['ipblockersyntax'] = 'Vložte každý záznam na samostatný řádek. Platným záznamem je celá IP adresa (např. <b>192.168.10.1</b>), které odpovídají jeden host; nebo částečná adresa (např. <b> 192.168 </b>), který se shoduje s libovolnou adresou začínající těmito čísly; nebo CIDR notace (např. <b>231.54.211.0/20 </b>); nebo rozsah IP adres (např. <b>231.3.56.10-20</b>), kde rozsah platí pro poslední skupiny adresy. Názvy doménových jmen (např. "example.com") nejsou podporovány. Prázdné řádky a text za znakem "#" jsou ignorovány.';
$string['iplookup'] = 'Umístění IP adresy';
$string['iplookupgeoplugin'] = 'Momentálně se pro získání geografického umístění používá služba <a href="https://www.geoplugin.com">geoPlugin</a>. Pro přesnější výsledky se doporučuje nainstalovat kopii databáze MaxMind GeoLite na váš server.';
$string['iplookupinfo'] = 'Ve výchozím nastavení Moodle používá volně dostupnou službu NatGeo (The Internet Geograpic Database) k vyhledávání IP adres. Bohužel tato databáze již není udržována a může poskytovat<em> velmi nepřesné</em> údaje. Doporučujeme nainstalovat lokální kopii zdarma dostupné databáze GeoLite2 City od MaxMind. <br />
Umístění IP adresy se zobrazí na jednoduché mapě nebo na Google Maps. Pamatujte, že budete potřebovat účet u Googlu, abyste získali API klíč k spuštění interaktivních map.';
$string['iplookupmaxmindnote'] = 'Tento produkt využívá databázi GeoLite2 vytvořenou společností MaxMind, dostupné na <a href="https://www.maxmind.com">https://www.maxmind.com</a>.';
$string['ishttpswarning'] = 'Bylo zjištěno, že váš web není zabezpečen prostřednictvím protokolu HTTPS. Pro zvýšení zabezpečení a lepší integraci s jinými systémy se důrazně doporučuje migrovat váš web na HTTPS.';
$string['keeptagnamecase'] = 'Zachovat velikost písmen v názvech štítků';
$string['lang'] = 'Výchozí jazyk';
$string['langcache'] = 'Seznam jazyků ve vyrovnávací paměti';
$string['langcache_desc'] = 'Zda se má používat vyrovnávací paměť pro nabídku dostupných jazyků. Vyrovnávací paměť je automaticky aktualizována, pokud instalujete nebo odstraňujete jazykový balíček přes vestavěný nástroj pro jejich správu. Pokud kopírujete jazykový balíček na server ručně, musíte rovněž ručně vymazat všechny vyrovnávací paměti.';
$string['langlist'] = 'Které jazyky zobrazovat v nabídce';
$string['langmenu'] = 'zobrazovat nabídku jazyků';
$string['langpackwillbeupdated'] = 'Během přechodu na vyšší verzi se Moodle pokusí automaticky aktualizovat i váš český jazykový balíček.';
$string['langstringcache'] = 'Pro textové řetězce používat vyrovnávací paměť';
$string['languagesettings'] = 'Jazyková nastavení';
$string['latinexcelexport'] = 'Kódování Excel-u';
$string['legacyfilesaddallowed'] = 'Povolit přidávání do zastaralého systému souborů kurzu';
$string['legacyfilesaddallowed_help'] = 'Zda se má povolit přidávání nových souborů a složek do kurzů, které mají stále aktivní zastaralý systém hromadné správy souborů na úrovni kurzu.';
$string['legacyfilesinnewcourses'] = 'Povolit starý způsob ukládání souborů v nových kurzech';
$string['legacyfilesinnewcourses_help'] = 'Starý způsob ukládání souborů je standardně dostupný v kurzech, které pocházejí z verze 1.9. Některé nové funkce (jako např. zálohování jednoho modulu) nejsou s tímto nastavením kompatibilní.';
$string['libcurlwarning'] = 'Nebyl zjištěn libcurl s podporou CURLOPT_PROTOCOL. Z bezpečnostních důvodů doporučujeme instalaci aktuálního libcurl.';
$string['licensesettings'] = 'Nastavení licencí';
$string['linkadmincategories'] = 'Správa stránek v navigaci';
$string['linkadmincategories_help'] = 'Zda se mají jednotlivé kategorie správy stránek zobrazovat jako odkazy v navigaci.';
$string['linkcoursesections'] = 'Vždy odkazovat na sekce kurzu';
$string['linkcoursesections_help'] = 'Zda se mají vždy zobrazit odkazy na sekce kurzu. Normálně se tyto odkazy zobrazují pouze tehdy, pokud formát kurz zobrazuje jednu sekci na stránku. Při zapnutí této volby budou odkazy zobrazeny vždy.';
$string['loading'] = 'Nahrávám';
$string['localetext'] = 'Proměnná locale';
$string['localstringcustomization'] = 'Lokální úprava překladu';
$string['location'] = 'Umístění';
$string['locationsettings'] = 'Nastavení umístění';
$string['locked'] = 'Zamknuto';
$string['lockoutduration'] = 'Doba uzamčení účtu';
$string['lockoutduration_desc'] = 'Uzamčený účet je automaticky odemčen po uplynutí této doby.';
$string['lockoutemailbody'] = 'Váš uživatelský účet „{$a->username}“ na serveru „{$a->sitename}“ byl uzamčen po několikanásobném zadání chybného hesla.

Účet bude odemčen automaticky po uplynutí určité doby nastavené správcem serveru. Pro okamžité odemknutí účtu navštivte následující adresu:

{$a->link}

Ve většině poštovních programů bude výše uvedený odkaz aktivní a stačí, když na něj kliknete. V opačném případě odkaz zkopírujte a vložte do prohlížeče ručně.

Potřebujete-li další pomoc, kontaktujte správce vašeho serveru:

{$a->admin}';
$string['lockoutemailsubject'] = 'Váš účet na serveru „{$a}“ byl uzamčen';
$string['lockouterrorunlock'] = 'Poskytnuty neplatné údaje pro odemčení účtu.';
$string['lockoutthreshold'] = 'Hranice uzamčení účtu';
$string['lockoutthreshold_desc'] = 'Zvolte počet neúspěšných pokusů o přihlášení, které povedou k uzamčení účtu. Pozor, toto nastavení může umožnit útoky typu <a href="https://cs.wikipedia.org/wiki/Denial_of_service">denial of service</a>.';
$string['lockoutwindow'] = 'Doba sledování neúspěšných přihlášení';
$string['lockoutwindow_desc'] = 'Pokud v daném intervalu není zaznamenán žádný neúspěšný pokus o přihlášení, je počítadlo používané pro hranici uzamčení účtu vynulováno.';
$string['log'] = 'Protokoly';
$string['logguests'] = 'Protokolovat přístupy hostů';
$string['logguests_help'] = 'Zda se mají do protokolů zaznamenávat i činnosti návštěvníků, kteří se přihlásili jako host, nebo se nepřihlásili vůbec. Velké instalace s masivním přístupem anonymních návštěvníků mohou mít problémy s výkonností, ale jinak se v produkčním prostředí doporučuje ponechat volbu zapnutou.';
$string['loginhttps'] = 'Při přihlášení používat HTTPS';
$string['loginpageautofocus'] = 'Automaticky umístit kurzor do přihlašovacího formuláře';
$string['loginpageautofocus_help'] = 'Povolením této možnosti zjednodušíte přihlašování, v některých případech (např. pokud vaši uživatelé používají čtečky obrazovky) to ovšem může být považováno za chybu přístupnosti.';
$string['loginpasswordautocomplete'] = 'Zabránit ukládání hesel v prohlížeči';
$string['loginpasswordautocomplete_help'] = 'Je-li  povoleno, nemají uživatelé povoleno ukládat své heslo účtu ve svém prohlížeči.';
$string['loglifetime'] = 'Udržovat protokoly po dobu';
$string['logo'] = 'Logo';
$string['logocompact'] = 'Kompaktní logo';
$string['logocompact_desc'] = 'Kompaktní verze stejného loga jak je uvedeno výše, jako je například symbol, štít nebo ikona. Obrázek by měl být čitelný i v malých velikostech. Formát obrázku musí být ve formátu PNG nebo JPEG.';
$string['logo_desc'] = 'Úplné logo, které má být použito jako ornament některými motivy (jako základní motiv). Tento obrázek může být ve vysokém rozlišení, protože bude při použití zmenšen (a uložen do mezipaměti). Širší loga obvykle dávají lepší výsledky. Formát obrázku musí být ve formátu PNG nebo JPEG.';
$string['logossettings'] = 'Loga';
$string['logstorenotrequired'] = 'Není požadováno úložiště protokolů';
$string['logstoressupported'] = 'Úložiště protokolů podporující tuto sestavu';
$string['longtimewarning'] = '<b>Prosím pozor, tento proces může trvat dlouho.</b>';
$string['mailnewline'] = 'Formát nového řádku v emailech';
$string['maintenancemode'] = 'V režimu údržby';
$string['maintenancemodeisscheduled'] = 'Stránky budou přepnuty do režimu údržby za {$a->min} minut {$a->sec} sekund';
$string['maintenancemodeisscheduledlong'] = 'Tento server bude přepnut do režimu údržby za {$a->hour} hodin {$a->min} minut {$a->sec} vteřin';
$string['maintfileopenerror'] = 'Chyba při otevírání souborů údržby!';
$string['maintinprogress'] = 'Probíhá údržba serveru...';
$string['managecontextlock'] = 'Zmrazit tento kontext';
$string['managecontextlocklocked'] = '{$a->contextname} a všechny vnořené kontexty jsou nyní zmrazeny.';
$string['managecontextlockunlocked'] = '{$a->contextname} a všechny vnořené kontexty jsou nyní rozmrazeny.';
$string['managecontextunlock'] = 'Rozmrazit tento kontext';
$string['manageformats'] = 'Správa formátů kurzu';
$string['manageformatsgotosettings'] = 'Výchozí formát lze změnit v {$a}';
$string['managelang'] = 'Správa';
$string['managelicenses'] = 'Správa licencí';
$string['manageqbehaviours'] = 'Správa chování testových úloh';
$string['manageqtypes'] = 'Správa typů testových úloh';
$string['maturity100'] = 'Beta';
$string['maturity150'] = 'Release candidate';
$string['maturity200'] = 'Stabilní verze';
$string['maturity50'] = 'Alfa';
$string['maturityallowunstable'] = 'Tip: Můžete chtít tento skript spouštět s volbou --allow-unstable';
$string['maturitycoreinfo'] = 'Váš server běží na verzi označené jako "{$a}", která není určena pro produkční nasazení.';
$string['maturitycorewarning'] = 'Chystáte se se instalovat nebo aktualizovat Moodle na verzi označenou jako "{$a}"
která není určena pro produkční nasazení. Ujistěte se, že se jedná o váš záměr
a že máte správnou verzi
zdrojových kódů Moodle.';
$string['maxbytes'] = 'Maximální velikost nahrávaných souborů';
$string['maxconsecutiveidentchars'] = 'Počet stejných po sobě jdoucích znaků';
$string['maxeditingtime'] = 'Časový limit pro úpravu vložených příspěvků';
$string['maxtimelimit'] = 'Maximální lhůta';
$string['maxtimelimit_desc'] = 'Chcete-li omezit maximum PHP doby provádění, Moodle umožní zobrazení bez jakéhokoli výstupu, zde zadejte hodnotu v sekundách. 0 znamená, že jsou používány výchozí omezení Moodle. Máte-li front-end server s vlastním časovým limitem, nastavte tuto hodnotu na nižší, aby byly chyby PHP zaznamenány v protokolech. Netýká se skriptů CLI.';
$string['maxusersperpage'] = 'Maximální počet uživatelů na stránku';
$string['mbstringrecommended'] = 'Instalace volitelné knihovny MBSTRING je silně doporučena, neboť zvyšuje výkon stránek, zejména pokud používáte jazyky nezaložené na latince.';
$string['mbstringrequired'] = 'Instalace knihovny MBSTRING je nutná pro zlepšení výkonu webu, zejména pokud váš web podporuje jiné než latinské jazyky (písmo).';
$string['mediapluginavi'] = 'Aktivovat filtr .avi';
$string['mediapluginflv'] = 'Aktivovat filtr .flv';
$string['mediapluginimg'] = 'Automaticky vkládat odkazované obrázky';
$string['mediapluginmov'] = 'Aktivovat filtr .mov';
$string['mediapluginmp3'] = 'Aktivovat filtr .mp3';
$string['mediapluginmpg'] = 'Aktivovat filtr .mpg';
$string['mediapluginogg'] = 'Aktivovat filtr .ogg';
$string['mediapluginogv'] = 'Aktivovat filtr .ogv';
$string['mediapluginram'] = 'Aktivovat filtr .ram';
$string['mediapluginrm'] = 'Aktivovat filtr .rm';
$string['mediapluginrpm'] = 'Aktivovat filtr .rpm';
$string['mediapluginswf'] = 'Aktivovat filtr .swf';
$string['mediapluginswfnote'] = 'Výchozí bezpečnostní nastavení nedovoluje řadovým uživatelům vkládat přímo do HTML textu soubory swf.';
$string['mediapluginwmv'] = 'Aktivovat filtr .wmv';
$string['mediapluginyoutube'] = 'Povolit filtr Odkaz na YouTube';
$string['messaging'] = 'Povolit systém zasílání zpráv';
$string['messagingallowemailoverride'] = 'Přenastavení oznamovacího e-mailu';
$string['messagingallusers'] = 'Povolení zasílání zpráv na celou instanci Moodle';
$string['messagingdeleteallnotificationsdelay'] = 'Smazat všechna oznámení';
$string['messagingdeletereadnotificationsdelay'] = 'Odstranit přečtená upozornění';
$string['minpassworddigits'] = 'Číslic';
$string['minpasswordlength'] = 'Délka hesla';
$string['minpasswordlower'] = 'Malých písmen';
$string['minpasswordnonalphanum'] = 'Nealfanumerických znaků';
$string['minpasswordupper'] = 'Velkých písmen';
$string['misc'] = 'Různé';
$string['mnetrestore_extusers'] = '<strong>Poznámka:</strong> Tato záloha obsahuje vzdálené uživatele sítě Moodle Network. Vzdálené účty budou v průběhu tohoto procesu obnoveny.';
$string['mnetrestore_extusers_admin'] = '<strong>Poznámka:</strong> Tato záloha pravděpodobně pochází z jiné instalace Moodlu a obsahuje vzdálené uživatelské účty ze serverů sítě MNet. Moodle se v průběhu obnovy pokusí vytvořit vzdálené uživatelské účty odpovídající vašim hostitelům sítě MNet. Uživatelské účty, pro které nebude nalezen vzdálený MNet hostitel, budou převedeny do režimu interní autentizace (namísto mnet). Bližší informace naleznete v protokolu.';
$string['mnetrestore_extusers_mismatch'] = '<strong>Poznámka:</strong> Tato záloha evidentně pochází z odlišné instalace Moodlu a obsahuje vzdálené uživatelské účty ze serverů sítě MNet. Obnova těchto účtů může selhat, tato operace není podporovaná. Pokud jste si jistí, že záloha pochází z této instalace, nebo můžete zajistit, že jsou správně nastaveny všechny hostitelské počítače v síti MNet, můžete se přesto pokusit o obnovu.';
$string['mnetrestore_extusers_noadmin'] = '<strong>Poznámka:</strong> Tato záloha pravděpodobně pochází z jiné instalace Moodlu a obsahuje vzdálené uživatelské účty ze serverů sítě MNet. Nemáte oprávnění provést tento typ obnovy. Spojte se se správcem vašeho serveru, případně tento kurz obnovte bez jakýchkoliv uživatelských dat.';
$string['mnetrestore_extusers_switchuserauth'] = 'Vzdálený uživatel {$a->username} (pocházející z {$a->mnethosturl}) obnoven jako místní uživatel ověřován pomocí {$a->auth}';
$string['mobilenotconfiguredwarning'] = 'Aplikace Moodle Mobile není povolena.';
$string['modchooserdefault'] = 'Výchozí průvodce přidáním obsahu';
$string['modeditdefaults'] = 'Výchozí hodnoty pro nastavení modulů činností';
$string['modsettings'] = 'Správa činností';
$string['modulesecurity'] = 'Zabezpečení modulů';
$string['moodleapp'] = 'Aplikace Moodle';
$string['moodleapp_help'] = '<p>Máte-li účet na webu Moodle, můžete získat přístup ke všem kurzům v mobilních zařízeních pomocí bezplatné mobilní aplikace pro Moodle.</p>
<a href="https://moodle.com/mobile-app">Stáhněte si mobilní aplikaci</a>';
$string['moodlebrandedapp'] = 'Značková aplikace Moodle';
$string['moodlebrandedapp_help'] = '<p>Značková aplikace Moodle má všechny funkce naší bezplatné mobilní aplikace pro Moodle v kombinaci s vaší vlastní značkou.</p>
<a href="https://moodle.com/branded-app">O Značkové aplikaci Moodle</a>';
$string['moodlebrandedappreference'] = 'Případně můžete získat <a href="https://moodle.com/branded-app/"> značkovou aplikaci Moodle </a> s vaší vlastní značkou.';
$string['moodleorghubname'] = 'Moodle';
$string['moodlepartners'] = 'Partneři Moodle';
$string['moodlepartners_help'] = '<p>Partneři Moodle jsou poskytovatelé služeb, kteří jsou certifikováni společností Moodle HQ, aby poskytli vysoce kvalitní služby Moodle pro online vzdělávací prostředí vaší organizace.</p>
<a href="https://moodle.com/about-partners/">O našich Partnerech</a><br />
<a href="https://moodle.com/partners">Hledat Partnera</a>';
$string['moodleservices'] = 'Moodle služby';
$string['moodleservices_help'] = 'Ujistěte se, že využíváte tyto Moodle služby z vašeho vzdělávacího prostředí Moodle:';
$string['multilangforceold'] = 'Vnutit starou syntaxi vícejazyčného obsahu: značka &lt;lang&gt; a značka &lt;span&gt; bez parametru class="multilang"';
$string['mustenablestats'] = 'Na těchto stránkách nejsou statistiky povoleny';
$string['mycoursesperpage'] = 'Maximální počet kurzů';
$string['mydashboard'] = 'Systémová výchozí Nástěnka';
$string['mymoodle'] = 'Nástěnka';
$string['mymoodleredirect'] = 'Vnutit uživatelům použití stránky Můj Moodle';
$string['mypage'] = 'Výchozí Nástěnka';
$string['mypagelocked'] = 'Zamknout výchozí stránku';
$string['myprofile'] = 'Výchozí profilová stránka';
$string['navadduserpostslinks'] = 'Odkazy na příspěvky uživatele';
$string['navadduserpostslinks_help'] = 'Zda se mají v navigaci zobrazovat u každého uživatele odkazy na seznam všech odstartovaných diskusí a všech vložených příspěvků na stránkách nebo v daném kurzu.';
$string['navcourselimit'] = 'Limit počtu kurzů';
$string['navigationupgrade'] = 'V průběhu upgrade budou vytvořeny dva nové bloky, které nahrazují původní bloky Správa stránek, Kurzy, Činnosti a Osoby. Pokud jste upravovali přístupová práva k těmto původním blokům, ujistěte se, že se po upgrade chovají nové bloky Navigace a Správa dle vašich potřeb.';
$string['navshowallcourses'] = 'Zobrazit všechny kurzy';
$string['navshowcategories'] = 'Zobrazit kategorie kurzů';
$string['navshowfrontpagemods'] = 'Zobrazit činnosti z titulní stránky v navigaci';
$string['navshowfrontpagemods_help'] = 'Zda se mají činnosti na titulní stránce zobrazovat v navigaci Hlavní nabídka.';
$string['navshowfullcoursenames'] = 'Zobrazit celé názvy kurzů';
$string['navshowfullcoursenames_help'] = 'Je-li povoleno, budou v navigaci požity dlouhé názvy kurzů namísto krátkých.';
$string['navshowmycoursecategories'] = 'Zobrazit kategorie mých kurzů';
$string['navshowmycoursecategories_help'] = 'Zda se mají kurzy v navigaci Moje kurzy zobrazovat podle kategorií.';
$string['navsortmycoursessort'] = 'Řadit moje kurzy';
$string['navsortmycoursessort_help'] = 'To určuje, zda kurzy jsou uvedeny v bloku Moje kurzy podle pořadí řazení (tj. pořadí nastavené v Správa stránek> Kurzy> Správa kurzů a kategorií), nebo v abecedním pořadí kurzů.';
$string['never'] = 'Nikdy';
$string['neverdeleteruns'] = 'Nikdy neodstraňovat proběhnutá měření';
$string['newestdocindexed'] = 'Nejnovější dokument indexovány';
$string['nobookmarksforuser'] = 'Nemáte žádné záložky';
$string['nodatabase'] = 'Žádná databáze';
$string['nohttpsformobilewarning'] = 'Doporučuje se povolit šifrované spojení přes HTTPS s platným certifikátem. Moodle app se vždy nejprve pokusí používat zabezpečené spojení.';
$string['nomissingstrings'] = 'Žádné chybějící řetězce';
$string['none'] = 'Žádný';
$string['nonewsettings'] = 'V průběhu aktualizace nebylo přidáno žádné nové nastavení.';
$string['nonexistentbookmark'] = 'Požadovaná záložka neexistuje';
$string['noreplyaddress'] = 'Adresa odesílatele automaticky generovaných zpráv';
$string['noreplydomain'] = 'Neodpovídat a doména';
$string['noreplydomaindetail'] = 'Nastavení pro Neodpovídat a konfigurování domén';
$string['noresults'] = 'Bez výsledků';
$string['noroles'] = 'Žádné role';
$string['nosupportedlogstore'] = 'Nebylo nalezeno podporováné úložiště protokolů';
$string['notifications'] = 'Upozornění';
$string['notifyloginfailures'] = 'Posílat neúspěšná přihlášení emailem';
$string['notifyloginthreshold'] = 'Práh pro upozornění emailem';
$string['notloggedinroleid'] = 'Role návštěvníků';
$string['numberofmissingstrings'] = 'Chybějících řetězců: {$a}';
$string['numberofstrings'] = 'Celkový počet řetězců: {$a->strings}<br />Chybí: {$a->missing} ({$a->missingpercent}&nbsp;%)';
$string['oauthrefreshtokenexpired'] = 'Platnost tokenu jedné z OAuth služby pro {$a->issuer} na vašem webu {$a->siteurl} vypršela. Tím se omezí funkčnost veškerých doplňků, které používají tuto službu. Chcete-li tento problém vyřešit, navštivte konfigurační stránku OAuth 2 Services a klikněte na ikonu „Připojit systémový účet“ v řádku tabulky pro tuto službu. Přesvědčte se, že se pokaždé přihlášujete pomocí stejného účtu služby pro OAuth systém.';
$string['oauthrefreshtokenexpiredshort'] = 'Na vašem webu {$a->siteurl} vypršela platnost OAuth tokenu pro {$a->issuer}.';
$string['onlynoreply'] = 'Pouze tehdy, když je adresou Neodpovídat';
$string['opcacherecommended'] = 'PHP opcode cache zvyšuje výkon a snižuje požadavky na paměť, Rozšíření OPcache je doporučeno a plně podporováno.';
$string['opensslrecommended'] = 'Pro běh síťových funkcionalit ("Moodle Networking") je potřeba nainstalovat volitelnou knihovnu OpenSSL.';
$string['opensslrequired'] = 'Rozšíření OpenSSL PHP nyní vyžaduje od  Moodle poskytování silnějších kryptografických služeb.';
$string['opentogoogle'] = 'Povolit prohledávání Googlem';
$string['optionalmaintenancemessage'] = 'Volitelná zpráva pro uživatele po dobu údržby';
$string['order1'] = 'První';
$string['order2'] = 'Druhý';
$string['order3'] = 'Třetí';
$string['order4'] = 'Čtvrtý';
$string['outgoingmailconfig'] = 'Konfigurace odchozí  pošty';
$string['overridetossl'] = 'HTTPS pro přihlašování je nyní zastaralé. Tato instance je nyní nucena k SSL. Chcete-li odstranit toto varování, změňte svůj wwwroot v config.php na https://';
$string['pageinfodebugsummary'] = 'Tato stránka je: {$a}';
$string['passwordchangelogout'] = 'Odhlásit po změně hesla';
$string['passwordchangelogout_desc'] = 'Je-li povoleno, dojde-li ke změně hesla, jsou ukončeny všechny relace prohlížeče, vyjma té, v níž je nastaveno nové heslo. (Toto nastavení nemá vliv na změny hesla prostřednictvím hromadném nahrání uživatele.)';
$string['passwordchangetokendeletion'] = 'Odstranit přístupové tokeny webové služby po změně hesla';
$string['passwordchangetokendeletion_desc'] = 'Je-li povoleno, při změně hesla  jsou odstraněny všechny přístupové tokeny uživatele webové služby.';
$string['passwordpolicy'] = 'Zásady bezpečného hesla';
$string['passwordresettime'] = 'Maximální doba pro ověření požadavku resetování hesla';
$string['passwordreuselimit'] = 'Omezení opakování hesla';
$string['passwordreuselimit_desc'] = 'Počet opakování, kolikrát musí uživatel změnit své heslo před tím, než je povoleno opět použít konkrétní heslo. Kontrolní kódy dříve použitých hesel jsou ukládány do lokální databázové tabulky. Tato funkce nemusí být kompatibilní s některými externími pluginy ověřování.';
$string['pathtodot'] = 'Cesta k programu "dot"';
$string['pathtodot_help'] = 'Úplná cesta k programu "dot". Na Linuxu to je něco jako /usr/bin/dot. Na Windows je to něco jako C:\\Program Files (x86)\\Graphviz2.38\\bin\\dot.exe.Na Macu je to něco /opt/local/bin/dot.  Abyste mohli generovat grafiku ze souborů DOT, musíte mít nainstalovaný bodový spustitelný soubor a zde odkazovat.';
$string['pathtodu'] = 'Cesta k programu "du"';
$string['pathtogs'] = 'Cesta ke ghostscript';
$string['pathtogs_help'] = 'Na většině linuxových instalací můžete ponechat \'/usr/bin/gs\'. Ve Windows to bude něco jako \'c:\\gs\\bin\\gswin32c.exe\'. Ujistěte se, že cesta neobsahuje žádné mezery. Pokud bude potřeba, zkopírujte soubory \'gswin32c.exe\' a \'gsdll32.dll\' do nové složky bez mezer v názvu.';
$string['pathtopgdump'] = 'Cesta k pg_dump';
$string['pathtopgdumpdesc'] = 'Tento údaj je nutné zadat pouze v případě, že provozujete více než jednu verzi pg_dump (např. pokud je na serveru instalována více než jedna verze postgresql).';
$string['pathtopgdumpinvalid'] = 'Neplatná cesta k pg_dump -- buď je zadána chybná cesta, nebo nelze odkazovaný soubor spustit.';
$string['pathtophp'] = 'Cesta do PHP CLI';
$string['pathtopsql'] = 'Cesta k psql';
$string['pathtopsqldesc'] = 'Tento údaj je nutné zadat pouze v případě, že provozujete více než jednu verzi psql (např. pokud je na serveru instalována více než jedna verze postgresql).';
$string['pathtopsqlinvalid'] = 'Neplatná cesta k psql -- buď je zadána chybná cesta, nebo nelze odkazovaný soubor spustit.';
$string['pathtopython'] = 'Cesta k Python';
$string['pathtopythondesc'] = 'Cesta k spustitelnému souboru Python (akceptovatelné jsou Python 2 a Python 3).';
$string['pathtosassc'] = 'Cesta k SassC';
$string['pathtosassc_help'] = 'Určení umístění binárního kódu SassC přepne překladač SASS z implementace PHP do aplikace SassC. Více informací naleznete na stránce https://github.com/sass/sassc.';
$string['pcreunicodewarning'] = 'Důrazně  doporučujeme používat rozšíření PCRE PHP, které je kompatibilní se sadou znaků Unicode.';
$string['perfdebug'] = 'Informace o výkonnosti';
$string['performance'] = 'Výkonnost';
$string['pgcluster'] = 'PostgreSQL cluster';
$string['pgclusterdescription'] = 'Parametry PostgreSQL version/cluster pro operace prováděné z příkazové řádky. Pokud provozujete pouze jednu instanci PostgreSQL, nebo pokud si nejste jisti, ponechte pole prázdné.';
$string['phpfloatproblem'] = 'Byl zjištěn neočekávaný problém ve způsobu zpracování čísel s plovoucí desetinnou čárkou ve vašem PHP - {$a}';
$string['pleaserefreshregistration'] = 'Vaše stránka byla zaregistrována na moodle.org. Vaše registrace byla naposledy aktualizována: {$a}<br />
"Registrační web" udržuje pomocí naplánované úlohy vaši registraci aktuální. Svou registraci můžete také  kdykoliv ručně aktualizovat.';
$string['pleaserefreshregistrationnewdata'] = 'Informace o registraci byly změněny. Potvrďte je pomocí tlačítka "Aktualizace registrace".';
$string['pleaserefreshregistrationunknown'] = 'Vaše stránka byla zaregistrována, ale datum registrace je neznámé. Aktualizujte prosím svou registraci pomocí tlačítka "Registrovat" nebo se ujistěte, že je v naplánovaných úlohách cronu povoleno "Místo registrace"  tak, aby vaše registrace je automaticky aktualizována.';
$string['plugin'] = 'Modul';
$string['plugins'] = 'Moduly';
$string['pluginscheck'] = 'Kontrola závislostí modulů';
$string['pluginscheckfailed'] = 'Kontrola závislostí selhala pro moduly {$a->pluginslist}';
$string['pluginschecktodo'] = 'Před zahájením instalace této verze Moodle musíte vyřešit všechny požadavky modulů!';
$string['pluginsoverview'] = 'Přehled modulů';
$string['pluginsoverviewsee'] = 'Další informace najdete v <a href="{$a->url}">přehledu rozšíření</a>.';
$string['policysettings'] = 'Nastavení zásad';
$string['privacyandpolicies'] = 'Soukromí a zásady';
$string['privacy:metadata'] = 'Modul Správa stránek neukládá žádné osobní údaje.';
$string['privacysettings'] = 'Nastavení soukromí';
$string['profilecategory'] = 'Kategorie';
$string['profilecategoryname'] = 'Název kategorie (musí být jedinečný)';
$string['profilecategorynamenotunique'] = 'Tento název kategorie je již používán';
$string['profilecommonsettings'] = 'Společná nastavení';
$string['profileconfirmcategorydeletion'] = 'Bylo nalezeno {$a} polí, která budou přesunuta do vyšší kategorie (nebo nižší, pokud se jedná o nejvyšší kategorii).<br />Stále si přejete tuto kategorii odstranit?';
$string['profileconfirmfielddeletion'] = 'Bylo nalezeno {$a} záznamů, které používají toto pole. Informace uložená v poli bude nenávratně ztracena. Stále si přejete pole odstranit?';
$string['profilecreatecategory'] = 'Vytvořit novou kategorii profilů';
$string['profilecreatefield'] = 'Vytvořit nové pole profilu:';
$string['profilecreatenewcategory'] = 'Vytvářím novou kategorii';
$string['profilecreatenewfield'] = 'Vytvářím nové pole "{$a}"';
$string['profiledefaultcategory'] = 'Další pole';
$string['profiledefaultchecked'] = 'Ve výchozím nastavení zaškrtnuto';
$string['profiledefaultdata'] = 'Výchozí hodnota';
$string['profiledeletecategory'] = 'Odstraňuji kategorii';
$string['profiledeletefield'] = 'Odstraňuji pole "{$a}"';
$string['profiledescription'] = 'Popis pole';
$string['profiledscript'] = 'Tento skript byl profilován';
$string['profiledscriptview'] = 'Zobrazit informace o profilování tohoto skriptu';
$string['profileeditcategory'] = 'Úprava kategorie: {$a}';
$string['profileeditfield'] = 'Úprava pole profilu: {$a}';
$string['profilefield'] = 'Pole profilu';
$string['profilefieldcolumns'] = 'Sloupce';
$string['profilefieldispassword'] = 'Je toto políčko pro heslo?';
$string['profilefieldlink'] = 'Odkaz';
$string['profilefieldlink_help'] = 'Má-li se vložený text převádět automaticky na odkaz, vložte zde adresu URL obsahující řetězec $$. Tato dvojice znaků dolaru bude nahrazena hodnotou, kterou zadal uživatel. Například: https://twitter.com/$$';
$string['profilefieldlinktarget'] = 'Cíl odkazu';
$string['profilefieldmaxlength'] = 'Maximální délka';
$string['profilefieldrows'] = 'Řádky';
$string['profilefields'] = 'Vlastní pole profilu';
$string['profilefieldsize'] = 'Velikost zobrazení';
$string['profileforceunique'] = 'Měly by být údaje jedinečné?';
$string['profileinvaliddata'] = 'Neplatná hodnota';
$string['profilelocked'] = 'Je pole zamknuto?';
$string['profilemenudefaultnotinoptions'] = 'Výchozí hodnota není jedna z nabízených možností';
$string['profilemenunooptions'] = 'Nebyly dodány žádné možnosti';
$string['profilemenuoptions'] = 'Možnosti (každá na jeden řádek)';
$string['profilemenutoofewoptions'] = 'je potřeba vložit alespoň dvě možnosti';
$string['profilename'] = 'Název';
$string['profilenofieldsdefined'] = 'Nebyla definována žádná pole';
$string['profilerequired'] = 'Je vyplnění pole povinné?';
$string['profileroles'] = 'Role viditelné v profilu';
$string['profilesforenrolledusersonly'] = 'Profily pouze pro zapsané uživatele';
$string['profileshortname'] = 'Krátký název (jedinečný)';
$string['profileshortnameinvalid'] = 'Tento krátký název může obsahovat pouze alfanumerické znaky (písmena a čísla) nebo podtržítko (_).';
$string['profileshortnamenotunique'] = 'Tento krátký název je již používán';
$string['profilesignup'] = 'Zobrazit v registračním formuláři?';
$string['profilespecificsettings'] = 'Specifická nastavení';
$string['profilevisible'] = 'Kdo může vidět obsah pole?';
$string['profilevisibleall'] = 'Veřejné pole - viditelné pro všechny';
$string['profilevisible_help'] = '<p>Každému uživatelskému poli lze přiřadit tři úrovně viditelnosti:
   skryté, soukromé a veřejné. Skryté pole je typicky vytvořeno správcem,
   který jeho pomocí udržuje o uživatelích zcela neveřejné informace.
   Soukromé pole je určeno pro citlivé údaje, veřejné pole lze použít
   pro ukládání informací libovolného typu.</p>';
$string['profilevisiblenone'] = 'Skryté pole - neviditelné';
$string['profilevisibleprivate'] = 'Soukromé pole - viditelné pouze pro daného uživatele';
$string['profiling'] = 'Profilování';
$string['profilingallowall'] = 'Souvislé profilování';
$string['profilingallowall_help'] = 'Je-li toto nastavení povoleno, můžete v kterémkoliv okamžiku zapnout profilování pomocí parametru PROFILEALL (funguje post, get i cookie). Od té chvíle budou profilovány všechny skripty v dané session. Analogicky lze použít parametr PROFILEALLSTOP k zastavení profilování.';
$string['profilingallowme'] = 'Výběrové profilování';
$string['profilingallowme_help'] = 'Je-li toto nastavení povoleno, můžete si vybrat konkrétní skripty, jejichž provádění chcete profilovat pomocí parametru PROFILEME (funguje post, get i cookie). Analogicky lze použít parametr DONTPROFILEME pro zabránění profilování konkrétního skriptu.';
$string['profilingautofrec'] = 'Automatické profilování';
$string['profilingautofrec_help'] = 'Pomocí tohoto nastavení lze automaticky profilovat náhodně zvolené požadavky. Četnost zapnutí profilování lze měnit nastavenou hodnotou od jedné do N. Výsledky automatického profilování jsou ukládány pro pozdější analýzu. Při automatickém profilování se uplatňuje nastavení "Vyloučit z profilování" a "Zahrnout do profilování". Nulová hodnota vypíná automatické profilování.';
$string['profilingenabled'] = 'Povolit profilování';
$string['profilingenabled_help'] = 'Profilování je vyhledávání míst v programu, které jsou vhodné pro optimalizaci. Pokud povolíte tuto funkci, budete moci pomocí dalších parametrů konfigurovat průběh profilování.';
$string['profilingexcluded'] = 'Vyloučit z profilování';
$string['profilingexcluded_help'] = 'Čárkami oddělený seznam adres, které budou vyloučeny z profilování. Adresy se uvádí relativně ke kořenovému adresáři Moodle s lomítkem na začátku.

Příklad: /admin/index.php,/course/index.php';
$string['profilingimportprefix'] = 'Předpona profilujícího importu';
$string['profilingimportprefix_desc'] = 'Pro snazší rozpoznání budou mít všechny importované profilující běhy předponu s hodnotou určenou na tomto místě.';
$string['profilingincluded'] = 'Zahrnout do profilování';
$string['profilingincluded_help'] = 'Čárkami oddělený seznam adres, které budou vždy při volání profilovány. Adresy se uvádí relativně ke kořenovému adresáři Moodle s lomítkem na začátku a lze použít hvězdičkovou konvenci.

Příklad: /index.php,/course/view.php,/mod/forum/*,/mod/*/view.php';
$string['profilinglifetime'] = 'Uchovat záznam o proběhnutém profilování';
$string['profilinglifetime_help'] = 'Po jak dlouho dobu budou uchováván záznam o proběhnutém profilování. Starší záznamy budou pravidelně odstraňovány. Toto se netýká referenčních záznamů.';
$string['protectusernames'] = 'Chránit uživatelská jména';
$string['proxybypass'] = 'Nepoužívat proxy server';
$string['proxyhost'] = 'Proxy server';
$string['proxypassword'] = 'Heslo k proxy';
$string['proxyport'] = 'Proxy port';
$string['proxytype'] = 'Typ proxy';
$string['proxyuser'] = 'Uživatelské jméno k proxy';
$string['purgecaches'] = 'Vymazat všechny dočasné paměti';
$string['purgecachesconfirm'] = 'Z důvodů vyšší výkonnosti Moodle ukládá CSS styly, Javascript, jazykové řetězce, filtrovaný text, RSS zdroje a další vypočítávaná data do dočasné paměti na serveru. Po vymazání se tato paměť znovu začne naplňovat aktuálními údaji tak, jak budou postupně používány. Vymazání dočasné paměti je bezpečné, může ovšem dojít ke chvilkovému snížení rychlosti načítání stránek z důvodu nutného znovunačtení dat do prohlížečů.';
$string['purgecachesfinished'] = 'Dočasná paměť byla vymazána.';
$string['purgecachesnoneselected'] = 'Vyberte jednu nebo více vyrovnávacích pamětí, která chcete vyčistit';
$string['purgecachespage'] = 'Čistění vyrovnávací paměti';
$string['purgefiltercache'] = 'Textový filtr';
$string['purgejscache'] = 'JavaScript';
$string['purgelangcache'] = 'Textový řetězec';
$string['purgemuc'] = 'Vyrovnávací paměti All MUC';
$string['purgeothercaches'] = 'Všechny soubory a různé mezipaměti';
$string['purgeselectedcaches'] = 'Vyčistit vybrané mezipaměti';
$string['purgeselectedcachesfinished'] = 'Vybrané mezipaměti byly vyčištěny.';
$string['purgethemecache'] = 'Motiv';
$string['query'] = 'Dotaz';
$string['question'] = 'Úloha';
$string['questionbehaviours'] = 'Chování testových úloh';
$string['questioncwqpfscheck'] = 'Jedna nebo více náhodně vybíraných úloh se losuje ze směsice sdílených a nesdílených  kategorií. Prosím, seznamte se se zprávou publikovanou <a href="{$a->reporturl}">zde</a> a pročtěte si dokumentaci <a href="{$a->docsurl}">zde</a>.';
$string['questioncwqpfsok'] = 'Dobrá zpráva - nebyly nalezeny žádné úlohy, které by byly losovány ze směsice sdílených a nesdílených kategorií.';
$string['questiontype'] = 'Typ testové úlohy';
$string['questiontypes'] = 'Typy testových úloh';
$string['quizattemptsupgradedmessage'] = 'V Moodle 2.1 tam byl významný upgrade úloh. Aktualizaci bylo možné odložit. Před upgradem na Moodle 2.7, musí být tato aktualizace dokončena.';
$string['recaptchaprivatekey'] = 'ReCAPTCHA soukromý klíč';
$string['recaptchapublickey'] = 'ReCAPTCHA veřejný klíč';
$string['register'] = 'Zaregistrujte své stránky';
$string['registermoodlenet'] = '<p>Rádi bychom zůstali v kontaktu  poskytli vám důležité informace pro vaše stránky Moodle!</p><p>Registrací:</p><ul><li>Budete jeden z prvních, kdo se dozví o důležitých upozorněních, jako jsou bezpečnostní upozornění a nové verze Moodle.</li><li>Můžete získat přístup a aktivovat mobilní push upozornění z vašeho webu Moodle prostřednictvím našich bezplatných <a href="https://download.moodle.org/mobile/">Moodle aplikace</a>.</li>
<li> Přispíváte k našim <a href="https://moodle.net/stats/"> statistikám Moodle </a> které nám pomohou zlepšit Moodle a naše stránky komunity. </ li> <li> Pokud chcete, mohou být vaše stránky zahrnuty do
<a href="https://moodle.net/sites/">seznamu registovaných webů</a> ve vaší zemi..</li></ul>';
$string['registermoodleorg'] = 'Když zaregistrujete své stránky';
$string['registermoodleorgli1'] = 'Budete přidáni do seznamu adres pro důležitá, ale neobjemná oznámení, jako jsou bezpečnostní upozornění a oznámení o nových verzích Moodle';
$string['registermoodleorgli2'] = 'Statistiky o vaší stránce budou přidány do databáze celosvětové komunity Moodle - {$a}.';
$string['registerwithmoodleorg'] = 'Zaregistrujte své stránky';
$string['registration'] = 'Registrace';
$string['registration_help'] = 'Registrací:

* Obdržíte bezpečnostní upozornění
* Můžete aktivovat aplikaci mobilních oznámení ze svého webu
* Přispíváte do našich statistik Moodle celosvětové komunity';
$string['registrationwarning'] = 'Vaše stránky nejsou ještě registrovány';
$string['registrationwarningcontactadmin'] = 'Vaše stránky nejsou ještě registrovány. Informujte prosím svého správce.';
$string['releasenoteslink'] = 'Informace o této verzi Moodlu najdete v <a target="_new" href="{$a}">Poznámkách k verzi</a>';
$string['rememberusername'] = 'Zapamatovat jméno uživatele';
$string['rememberusername_desc'] = 'Aktivujte tuto možnost, chcete-li uchovat trvalé cookies s uživatelskými jmény během přihlašování uživatele. Trvalé cookies lze považovat za soukromou záležitost, jsou-li používány bez souhlasu.';
$string['reportsmanage'] = 'Správa sestav';
$string['requestcategoryselection'] = 'Povolit výběr kategorie';
$string['requiredentrieschanged'] = 'Poznámka: Po upgradu je nyní v následujících databázových činnostech vynuceno nastavení „Povinné položky před prohlížením“: <br/> {$ a-> text} <br/>';
$string['requiremodintro'] = 'Vyžadovat popis činnosti';
$string['requiremodintro_desc'] = 'Je-li povoleno, budou uživatelé nuceni pro každou činnost zadat popis.';
$string['requires'] = 'Vyžaduje';
$string['restorecourse'] = 'Obnovit kurz';
$string['restorernewroleid'] = 'Obnovené role v kurzu';
$string['restorernewroleid_help'] = 'Nemá-li uživatel ještě povolení spravovat nově obnovený kurz, uživateli je automaticky přiřazena tato uživatelská role a je přihlášen, je-li to potřebné. Zvolte "Žádná", když nechcete, aby obnovovatelé mohli spravovat každý obnovený kurz.';
$string['reverseproxy'] = 'Reverzní proxy server';
$string['reverseproxyignore'] = 'Ignorovat reverzní proxy';
$string['riskconfig'] = 'Uživatelé mohou měnit nastavení a chování stránek (serveru)';
$string['riskconfigshort'] = 'Riziko zásahu do konfigurace';
$string['riskdataloss'] = 'Uživatelé mohou zničit velké množství obsahu nebo informací';
$string['riskdatalossshort'] = 'Riziko ztráty dat';
$string['riskmanagetrust'] = 'Uživatelé mohou měnit úroveň důvěryhodnosti jiných uživatelů';
$string['riskmanagetrustshort'] = 'Správa důvěryhodnosti';
$string['riskpersonal'] = 'Uživatelé mohou získat přístup k soukromým informacím jiných uživatelů';
$string['riskpersonalshort'] = 'Riziko zásahu do soukromí';
$string['riskspam'] = 'Uživatelé mohou zasílat nevyžádnou korespondenci (spam) dalším uživatelům';
$string['riskspamshort'] = 'Riziko spamu';
$string['riskxss'] = 'Uživatelé mohou přidávat soubory či texty umožňující Cross-Site Scripting (XSS).';
$string['riskxssshort'] = 'Riziko XSS';
$string['roleswithexceptions'] = '{$a->roles}, s {$a->exceptions}';
$string['rssglobaldisabled'] = 'Zakázáno na úrovni webu';
$string['save'] = 'Uložit';
$string['savechanges'] = 'Uložit změny';
$string['scssinvalid'] = 'SCSS kód není platný, selže s: {$a}';
$string['search'] = 'Hledej';
$string['searchallavailablecourses'] = 'Kurzy pro vyhledávání';
$string['searchallavailablecourses_desc'] = 'V některých situacích nemusí při prohledávání na velkém počtu kurzů vyhledávač fungovat.  Pokud potřebujete omezit počet vyhledaných kurzů, nastavte na prohledávání pouze zapsaných kurzů.';
$string['searchallavailablecourses_off'] = 'Vyhledávat pouze v zapsaných kurzech';
$string['searchallavailablecourses_on'] = 'Vyhledávání v rámci všech kurzů, které má uživatel k dispozici';
$string['searchalldeleted'] = 'Celý indexovaný obsah byl odstraněn';
$string['searchareadisabled'] = 'Oblast hledání zakázána';
$string['searchareaenabled'] = 'Oblast hledání povolena';
$string['searchareas'] = 'Oblasti hledání';
$string['searchdeleteindex'] = 'Odstranit celý indexovány obsah';
$string['searchengine'] = 'Vyhledávač';
$string['searchindexactions'] = 'Akce indexování';
$string['searchindexdeleted'] = 'Index odstraněn';
$string['searchindextime'] = 'Časový limit indexování';
$string['searchindextime_desc'] = 'Při indexování velkého množství nového obsahu se plánovaná úloha zastaví po dosažení tohoto časového limitu. Bude pokračovat při příštím spuštění úlohy.';
$string['searchindexupdated'] = 'Obsah vyhledávače byl aktualizován';
$string['searchindexwhendisabled'] = 'Indexovat, pokud je zakázáno';
$string['searchindexwhendisabled_desc'] = 'Umožňuje plánované úloze sestavit index hledání, i když je vyhledávání zakázáno. To je užitečné, pokud chcete vytvořit index předtím, než se studentům objeví vyhledávací zařízení.';
$string['searchinsettings'] = 'Hledej v nastavení';
$string['searchlastrun'] = 'Poslední spuštění (čas, # dokumentů, # záznamů, # ignorovaných)';
$string['searchnotavailable'] = 'Vyhledávání není povoleno';
$string['searchoptions'] = 'Možnosti hledání';
$string['searchpartial'] = '(ještě není plně indexováno)';
$string['searchreindexed'] = 'Celý obsah webu byl přeindexován.';
$string['searchreindexindex'] = 'Reindexovat celý obsah webu';
$string['searchresults'] = 'Výsledky hledání';
$string['searchsetupinfo'] = 'Nastavit vyhledávání';
$string['searchupdateindex'] = 'Aktualizace indexovaného obsahu';
$string['sectionerror'] = 'Chyba sekce!';
$string['secureforms'] = 'Použít přidané zabezpečení formuláře';
$string['security'] = 'Zabezpečení';
$string['selectdevice'] = 'Výběr zařízení';
$string['selectsearchengine'] = 'Vybrat vyhledávač';
$string['selecttheme'] = 'Výběr motivu pro zařízení {$a}';
$string['server'] = 'Server';
$string['serverchecks'] = 'Kontroly serveru';
$string['serverlimit'] = 'Omezení na straně serveru';
$string['sessionautostartwarning'] = '<p>Byla detekována závažná chyba v konfiguraci serveru. Prosím, upozorněte jeho správce: Moodle vyžaduje změny v nastavení PHP.</p><p>Konfigurační parametr <code>session.auto_start</code> musí být nastaven na hodnotu <code>off</code>.</p><p>Toto nastavení lze například změnit v souboru <code>php.ini</code>, v konfiguraci Apache/IIS nebo pomocí souboru <code>.htaccess</code>.</p>';
$string['sessioncookie'] = 'Předpona názvu cookie';
$string['sessioncookiedomain'] = 'Doména platnosti cookie';
$string['sessioncookiepath'] = 'Cesta platnosti cookie';
$string['sessionhandling'] = 'Session';
$string['sessiontimeout'] = 'Časový limit';
$string['settingfileuploads'] = 'Moodle používá funkci nahrávání souborů. Je třeba ji povolit v nastavení vašeho PHP.';
$string['settingmemorylimit'] = 'Bylo zjištěno nedostatečné množství dostupné paměti. Je třeba navýšit memory_limit v nastavení PHP.';
$string['settingsafemode'] = 'PHP je momentálně provozováno v omezeném režimu, známém jako "safe mode". Moodle není s tímto režimem kompatibilní. Budete-li provozovat Moodle v safe mode, můžete čelit různým problémům s funkcionalitou stránek. Požádejte správce serveru o vypnutí tohoto režimu.';
$string['setupsearchengine'] = 'Nastavit vyhledávač';
$string['showcommentscount'] = 'Zobrazit počet komentářů';
$string['showdetails'] = 'Zobrazit details';
$string['showuseridentity'] = 'identity Zobrazovat identitu uživatele';
$string['showuseridentity_desc'] = 'Při výběru nebo hledání uživatelů  a při zobrazování seznamů uživatelů mohou být tato pole zobrazovány vedle jejich celých jmen. Tato pole se zobrazují pouze uživatelům, kteří mají oprávnění moodle/site:viewuseridentity; standardně jsou to lektoři a manažeři. (Použití této možnosti dáva smysl zejména když vyberete jedno nebo dvě pole, která jsou ve vaší instituci povinná.)';
$string['simplexmlrequired'] = 'PHP rozšíření SimpleXML je vyžadováno';
$string['sitemailcharset'] = 'Znaková sada';
$string['sitemaintenance'] = 'Momentálně pracujeme na údržbě těchto stránek, proto nejsou dočasně k dispozici.';
$string['sitemaintenancemode'] = 'Režim údržby';
$string['sitemaintenanceoff'] = 'Režim údržby byl ukončen a stránky zase běží v normálním režimu.';
$string['sitemaintenanceon'] = 'Momentálně probíhá údržba stránek, přihlásit se mohou pouze správci.';
$string['sitemaintenanceoncli'] = 'Probíhá režim údržby z příkazového řádku, webový přístup je dočasně zablokován.';
$string['sitemaintenancewarning'] = 'Momentálně probíhá údržba stránek, přihlásit se mohou pouze správci. Režim údržby můžete ukončit <a href="maintenance.php">zde</a>.';
$string['sitemaintenancewarning2'] = 'Momentálně probíhá údržba stránek, přihlásit se mohou pouze správci. Pro návrat k normálnímu režimu <a href="{$a}">vypněte režim údržby</a>.';
$string['sitemenubar'] = 'Navigace stránek';
$string['sitepolicies'] = 'Nastavení zabezpečení stránek';
$string['sitepolicy'] = 'URL k pravidlům provozu stránek';
$string['sitepolicyguest'] = 'URL pravidel používání stránek pro hosty';
$string['sitepolicyguest_help'] = 'Pokud máte někde publikovaná pravidla provozu (zásady) vašich stránek, s nimiž musejí všichni hosté souhlasit, uveďte sem jejich URL adresu.
Všimněte si, že toto nastavení bude mít vliv pouze v případě, že je obslužný program zásad stránek nastaven na výchozí (jádro).';
$string['sitepolicyhandler'] = 'Správce zásad stránek';
$string['sitepolicyhandlercore'] = 'Výchozí (základní)';
$string['sitepolicyhandler_desc'] = 'To určuje způsob spravování zásad a souhlasů uživatelů. Výchozí (jádro) obslužný program umožňuje zadat adresu URL zásady a adresu URL stránky pro hosty. Správa zásad umožňuje nastavit zásady, zásady ochrany osobních údajů a další zásady. Umožňuje také prohlížení uživatelských souhlasů a případně souhlas jménem nezletilých.';
$string['sitepolicyhandlerplugin'] = '{$a->name} ({$a->component})';
$string['sitepolicy_help'] = 'Máte-li vytvořen text pravidel pro používání stránek, s nímž musejí všichni uživatelé souhlasit, uveďte zde jeho URL. Všimněte si, že toto nastavení bude mít vliv pouze v případě, že je obslužný program zásad stránek nastaven na výchozí (jádro).';
$string['sitesectionhelp'] = 'Je-li vybráno, zobrazuje se na hlavní stránce serveru tématická sekce.';
$string['sixtyfourbitswarning'] = 'Bylo zjištěno, že váš web nepoužívá 64bitovou verzi PHP. Doporučuje se, abyste svůj web upgradovali, abyste zajistili budoucí kompatibilitu.';
$string['slasharguments'] = 'Předávání argumentů za lomítkem';
$string['slashargumentswarning'] = 'Doporučuje se, aby bylo používání argumentů za lomítkem aktivováno. V budoucnosti bude toto nastavení povinné. Další podrobnosti naleznete v dokumentaci na <a href="https://docs.moodle.org/en/admin/environment/slasharguments">Using slash arguments</a>.';
$string['smartpix'] = 'Vylepšené vyhledávání ikon';
$string['smtp'] = 'SMTP';
$string['smtpauthtype'] = 'SMTP Auth Type';
$string['smtpdetail'] = 'Simple Mail Transfer Protocol (SMTP) nastavení pro odesílání e-mailu.';
$string['smtphosts'] = 'SMTP hostitelé';
$string['smtpmaxbulk'] = 'Limit SMTP relace';
$string['smtppass'] = 'SMTP heslo';
$string['smtpsecure'] = 'SMTP bezpečnost';
$string['smtpuser'] = 'SMTP uživatelské jméno';
$string['soaprecommended'] = 'Instalace rozšíření SOAP je užitečné pro podporu webových služeb (web services) a pro některé doplňky.';
$string['sort_fullname'] = 'Celý název kurzu';
$string['sort_idnumber'] = 'Identifikátor kurzu';
$string['sort_shortname'] = 'Krátký název kurzu';
$string['sort_sortorder'] = 'Řazení';
$string['spellengine'] = 'Kontrola pravopisu';
$string['spelllanguagelist'] = 'Seznam jazyků pro kontrolu pravopisu';
$string['splrequired'] = 'Rozšíření PHP SPL je povinné.';
$string['stats'] = 'Statistiky';
$string['statsfirstrun'] = 'Maximální interval zpracování';
$string['statsmaxruntime'] = 'Maximální runtime';
$string['statsmoodleorg'] = 'statistiky';
$string['statsruntimedays'] = 'Počet dnů ke zpracování';
$string['statsruntimestart'] = 'Spouštět v';
$string['statsuserthreshold'] = 'Uživatelský práh';
$string['stickyblocks'] = 'Povinné bloky';
$string['stickyblockscourseview'] = 'Stránka kurzu';
$string['stickyblocksduplicatenotice'] = 'Pokud se vybraný blok na zvolené stránce již vyskytuje, bude se na ní zobrazovat dvakrát.<br />Povinný blok nebude možné upravovat, duplicitní (nepovinný) blok ano.';
$string['stickyblocksmymoodle'] = 'Můj Moodle';
$string['stickyblockspagetype'] = 'Typ stránky';
$string['strictformsrequired'] = 'Přísné ověřování požadovaných polí';
$string['stripalltitletags'] = 'Odstranit HTML z názvů modulů';
$string['supportcontact'] = 'Kontakt na uživatelskou podporu';
$string['supportemail'] = 'Emailová podpora';
$string['supportname'] = 'Uživatelskou podporu zajišťuje';
$string['supportpage'] = 'Webová podpora';
$string['suspenduser'] = 'Suspendovat účet uživatele';
$string['switchlang'] = 'Přepnout umístění jazyka';
$string['systempaths'] = 'Cesty k souborům';
$string['tablenosave'] = 'Změny v této tabulce jsou ukládány automaticky';
$string['tablesnosave'] = 'Změny v tabulkách jsou ukládány automaticky.';
$string['tabselectedtofront'] = 'Má se v tabulkách, které používají navigaci pomocí záložek, přesunout řádek s právě vybranou záložkou do popředí?';
$string['tabselectedtofronttext'] = 'Přinést vybranou kartu do popředí';
$string['taskanalyticscleanup'] = 'Vyčištění analýzy';
$string['taskautomatedbackup'] = 'Automatické zálohování';
$string['taskbackupcleanup'] = 'Vyčistit tabulky záloh a protokolů';
$string['taskbadgescron'] = 'Udělit odznaky';
$string['taskblogcron'] = 'Synchronizace externích blogů';
$string['taskcachecleanup'] = 'Odstranit prošlé položky mezipaměti';
$string['taskcachecron'] = 'Zpracování mezipaměti na pozadí';
$string['taskcalendarcron'] = 'Poslat upozornění z kalendáře';
$string['taskcheckforupdates'] = 'Zkontrolovat aktualizace';
$string['taskcompletiondaily'] = 'Zahájeno označení splnění';
$string['taskcompletionregular'] = 'Vypočítejte pravidelná data dokončení';
$string['taskcontextcleanup'] = 'Vyčistit kontexty';
$string['taskcreatecontexts'] = 'Vytvořit chybějící kontexty';
$string['taskdeletecachetext'] = 'Odstranit staré záznamy mezipaměti textu';
$string['taskdeleteincompleteusers'] = 'Odstranit nedokončené registrace uživatelů';
$string['taskdeleteunconfirmedusers'] = 'Odstranit nepotvrzené registrace uživatelů';
$string['taskeventscron'] = 'Zpracování událostí na pozadí';
$string['taskfiletrashcleanup'] = 'Vyčištění souborů v koši';
$string['taskglobalsearchindex'] = 'Indexování pro globální vyhledávání';
$string['taskglobalsearchoptimize'] = 'Optimalizace indexu pro globální vyhledávání';
$string['taskgradecron'] = 'Zpracování známek na pozadí';
$string['tasklegacycron'] = 'Zastaralé zpracování cronu pro doplňky';
$string['taskmessagingcleanup'] = 'Zpracování zpráv na pozadí';
$string['taskpasswordresetcleanup'] = 'Smazání pokusů o reset hesla';
$string['taskplagiarismcron'] = 'Zpracování původního cronu modulů plagiátorství na pozadí';
$string['taskportfoliocron'] = 'Zpracování modulů portfolia na pozadí';
$string['taskquestioncron'] = 'Zpracování nástroje testování na pozadí';
$string['taskrefreshsystemtokens'] = 'Obnovovit OAuth tokeny pro účty služeb';
$string['taskregistrationcron'] = 'Registrace stránek';
$string['tasksendfailedloginnotifications'] = 'Poslat upozornění na neúspěšná přihlášení';
$string['tasksendnewuserpasswords'] = 'Odeslat nová uživatelská hesla';
$string['tasksessioncleanup'] = 'Vyčištění starých sezení';
$string['taskstatscron'] = 'Zpracování statistik na pozadí';
$string['tasktagcron'] = 'Zpracování štítků na pozadí';
$string['tasktempfilecleanup'] = 'Odstrant zastaralé dočasné soubory';
$string['tempdatafoldercleanup'] = 'Odstranit dočasné datové soubory starší než';
$string['testsiteupgradewarning'] = 'Aktuálně používáte {$ a} testovací web, aktualizujte jej z rozhraní příkazové řádky na správnou verzi';
$string['themedesignermode'] = 'Režim úprav grafického motivu';
$string['themedesignermodewarning'] = 'Je povolen režim úprav grafického motivu. To by nemělo být povoleno na produkčních webech, to může výrazně snížit výkon.';
$string['themelist'] = 'Seznam motivů';
$string['themenoselected'] = 'Není zvolen žádný motiv';
$string['themeresetcaches'] = 'Vymazat dočasné paměti motivů';
$string['themeselect'] = 'Změnit motiv';
$string['themeselector'] = 'Volba motivu';
$string['themesettings'] = 'Nastavení motivu';
$string['therewereerrors'] = 'Data obsahují chyby.';
$string['thirdpartylibrary'] = 'Knihovna';
$string['thirdpartylibrarylocation'] = 'Umístění';
$string['thirdpartylibs'] = 'Knihovny třetích stran';
$string['timezone'] = 'Výchozí časové pásmo';
$string['timezoneforced'] = 'Správce nepovolil změny';
$string['timezoneinvalid'] = 'Neplatné časové pásmo "{$a}"';
$string['timezoneisforcedto'] = 'Vnutit nastavení všem uživatelům';
$string['timezonenotforced'] = 'Uživatelé si mohou vybrat časové pásmo';
$string['timezonephpdefault'] = 'Výchozí časové pásmo PHP ({$a})';
$string['timezoneserver'] = 'Časové pásmo serveru ({$a})';
$string['tlswarning'] = 'Byla zjištěna neexistence rozšíření PHP/cURL s podporou TLSv1.2. Některé služby nemusí fungovat. Důrazně se doporučuje provést upgrade vaší knihovny TLS.';
$string['tokenduration'] = 'Uživatel vytvořil token trvání';
$string['tokenduration_desc'] = 'Doba, po kterou je token  webových služeb vytvořený uživatelem platný (například prostřednictvím mobilní aplikace).';
$string['tokenizerrecommended'] = 'Instalace volitelného rozšíření PHP Tokenizer je doporučována - zlepšuje možnosti Moodle Networking.';
$string['tools'] = 'Nástroje správce';
$string['toolsmanage'] = 'Správa nástrojů správce';
$string['unattendedoperation'] = 'Bez obsluhy';
$string['unbookmarkthispage'] = 'Odstranit záložku na tuto stránku';
$string['unicoderequired'] = 'Je nezbytné ukládání dat v kódování Unicode (UTF-8). Nové instalace musí být založeny nad databází s výchozím kódováním Unicode. Pokud přecházíte z nižších verzí, měli byste podstoupit proces migrace na UTF-8 (viz stránku Správa).';
$string['uninstallplugin'] = 'Odinstalovat';
$string['unlockaccount'] = 'Odemknutí účtu';
$string['unoconvwarning'] = 'Verze unoconv, kterou jste nainstalovali, není podporována.';
$string['unsettheme'] = 'Zrušit nastavení motivu';
$string['unsupported'] = 'Nepodporováno';
$string['unsupporteddbfileformat'] = 'Databáze obsahuje tabulky používající jako formát souboru Antelope. Plná podpora UTF-8 v MySQL a MariaDB vyžaduje formát souborů Barracuda. Přepněte tabulky do formátu Barracuda. Podrobné informace naleznete v dokumentaci <a href="https://docs.moodle.org/en/cli">MySQL plná podpora unicode </a>.';
$string['unsupporteddbfilepertable'] = 'Pro plnou podporou UTF-8 i MySQL a MariaDB je vyžadováno, abyste změnili váš nastavení MySQL "innodb_file_per_table" na "ON". V dokumentaci naleznete další podrobnosti.';
$string['unsupporteddblargeprefix'] = 'Pro plnou podporou UTF-8 i MySQL a MariaDB je vyžadováno, abyste změnili váš nastavení MySQL "innodb_large_prefix" na "ON". V dokumentaci naleznete další podrobnosti.';
$string['unsupporteddbstorageengine'] = 'Úložný prostor databáze není již podporován.';
$string['unsupporteddbtablerowformat'] = 'Vaše databáze má tabulky pomocí Antelope jako formát souboru. Doporučujeme převést tabulky do formátu souboru Barracuda. Naleznete v dokumentaci <a href="https://docs.moodle.org/en/cli"> Správa pomocí příkazového řádku </a> pro detaily nástroje pro konverzi InnoDB tabulek na Barracuda.';
$string['unsupportedphpversion7'] = 'PHP verze 7 není podporována.';
$string['unsupportedphpversion71'] = 'PHP verze 7.1 není podporována.';
$string['unsupportedphpversion72'] = 'PHP verze 7.2 není podporována.';
$string['unsupportedphpversion73'] = 'PHP verze 7.3 není podporována.';
$string['unsupportedphpversion74'] = 'PHP verze 7.4 není podporována.';
$string['unsuspenduser'] = 'Aktivovat účet uživatele';
$string['updateaccounts'] = 'Aktualizovat stávající účty';
$string['updateautocheck'] = 'Automaticky kontrolovat dostupné aktualizace';
$string['updateautocheck_desc'] = 'Zda se mají automaticky kontrolovat dostupné aktualizace kódu Moodle a všech dalších modulů. Správci stránek jsou upozorňováni na nové aktualizace.';
$string['updateavailable'] = 'Je dostupná novější verze Moodle!';
$string['updateavailabledetailslink'] = 'Více informací na {$a->url}';
$string['updateavailableforplugin'] = 'Pro některé z vašich modulů jsou dostupné novější verze.';
$string['updateavailableinstall'] = 'Instalovat aktualizaci';
$string['updateavailableinstallall'] = 'Instalace dostupné aktualizace ({$a})';
$string['updateavailableinstallallhead'] = 'Instalace dostupné aktualizace';
$string['updateavailable_moreinfo'] = 'Více informací ...';
$string['updateavailablenot'] = 'Váš Moodle běží na aktuální verzi';
$string['updateavailablerecommendation'] = 'Důrazně se doporučuje, abyste své stránky aktualizovali na nejnovější verzi, abyste získali všechna nejnovějších zabezpečení a opravy chyb.';
$string['updateavailable_release'] = 'Moodle {$a}';
$string['updateavailable_version'] = 'Verze {$a}';
$string['updatecomponent'] = 'Aktualizovat komponentu';
$string['updateminmaturity'] = 'Požadovaný stupeň zralosti kódu';
$string['updateminmaturity_desc'] = 'Informovat o dostupné aktualizaci pouze tehdy, jestliže je nová verze alespoň na vybraném stupni zralosti kódu. Aktualizace pro moduly, které nedeklarují svůj stupeň zralosti, jsou hlášeny vždy bez ohledu na toto nastavení.';
$string['updatenotificationfooter'] = 'Na vašich Moodle stránkách {$a->siteurl} je nastavena automatická kontrola dostupných aktualizací. Tuto zprávu dostáváte jako správce uvedených stránek. Automatickou kontrolu dostupných aktualizací můžete vypnout v sekci Správa stránek / Server / Dostupné aktualizace  nebo upravit zobrazení této zprávy na stránce předvoleb.';
$string['updatenotifications'] = 'Dostupné aktualizace';
$string['updatenotificationsubject'] = '[{$a->siteurl}] Dostupné aktualizace pro Moodle';
$string['updatenotifybuilds'] = 'Upozorňovat na aktualizace stávající verze';
$string['updatenotifybuilds_desc'] = 'Zda chcete být rovněž informování o aktualizacích stávající verze (tzv. "build" nebo "plus verze"). Aktualizace pro stávající verze jsou většinou vydávány každý týden a obsahují nejnovější opravy zdrojového kódu. Je-li toto zakázáno, budete informováni pouze o vydání vyšších verzí Moodle (tj. pokud bude dostupná verze s vyšším číslem). Toto nastavení neovlivňuje kontrolu dostupných aktualizací rozšiřujících modulů.';
$string['upgradeerror'] = 'Neznámá chyba při aktualizaci modulu {$a->plugin} na verzi {$a->version}, nelze pokračovat';
$string['upgradeforumread'] = 'Do Moodlu 1.5 byla přidána nová funkce, která umožňuje sledovat a označovat stav diskusních příspěvků \'přečteno/nepřečteno\'.<br />Chcete-li tuto funkci používat, musíte <a href="{$a}">aktualizovat tabulky v databázi</a>.';
$string['upgradeforumreadinfo'] = 'Do Moodlu 1.5 byla přidána nová funkce, která umožňuje u každého uživatele zaznamenávat stav příspěvků \'přečteno/nepřečteno\'. Chcete-li tuto funkci používat, je třeba doplnit ke stávajícím příspěvkům potřebné informace. Tento proces může v závislosti na rozsahu vašich stránek trvat až několik hodin a na vašem databázovém serveru bude celkem rušno, takže doporučujeme provést tuto činnost ve vhodném čase (např. o víkendu v noci). Vaše stránky budou nicméně stále v provozu a práce uživatelů by neměla být výrazněji ovlivněna. Jakmile proces spustíte, měli byste jej nechat dokončit (tj. nechat otevřené příslušné okno prohlížeče). Ale nemějte obavy, pokud okno zavřete a proces ukončíte, můžete kdykoliv začít znovu.<br /><br />Chcete nyní spustit aktualizaci databáze?';
$string['upgradekeyreq'] = 'Vyžadován klíč pro aktualizaci';
$string['upgradekeyset'] = 'Klíč pro upgrade (ponechte prázdné, nechcete-li nenastavil)';
$string['upgradelogs'] = 'Pro plnou funkčnost je nutné vaše staré protokoly aktualizovat. <a href="{$a}">Více informací</a>';
$string['upgradelogsinfo'] = 'Ve způsobu uchovávání protokolů došlo ke změnám. Chcete-li zobrazovat vaše dosavadní protokoly podle činností, je nutné všechny uložené protokoly aktualizovat. V závislosti na jejich množství to může trvat delší dobu (i několik hodin), na rozsáhlejších stránkách tento proces výrazně zatíží databázi. Jakmile jednou proces spustíte, měli byste jej nechat dokončit (tj. nechte okno prohlížeče otevřené). Nemusíte mít obavy -- vaše stránky budou v průběhu aktualizace pro uživatele stále dostupné.<br /><br />Chcete nyní aktualizovat protokoly?';
$string['upgradepluginsfirst'] = 'Je doporučeno nejprve instalovat všechny dostupné aktualizace';
$string['upgradepluginsinfo'] = 'Aktualizace modulů';
$string['upgradepluginsinfo_help'] = 'Pro některé ze vašich pluginů jsou k dispozici aktualizace. Před upgradem Moodle databáze byste je všechny měli instalovat . Pokud vaše stránky nepodporují automatické aktualizace, budete muset stáhnout a instalovat novou verzi pluginu na vašem serveru ručně.';
$string['upgradesettings'] = 'Nová nastavení';
$string['upgradesettingsintro'] = 'V průběhu poslední aktualizace Moodle přibyla následující nová nastavení. Proveďte nezbytné úpravy oproti výchozím hodnotám a stiskněte tlačítko "Uložit změny" na konci této stránky.';
$string['upgradestalefiles'] = 'Byly zjištěny různé verze Moodle, aktualizace nemůže pokračovat';
$string['upgradestalefilesinfo'] = 'Moodle aktualizace byla pozastavena, protože byly zjištěny PHP skripty alespoň ze dvou hlavních verzí Moodlu v adresáři Moodle.

To může později způsobit značné problémy, Pro pokračování musíte zajistit, aby adresář Moodle obsahoval pouze soubory pro jednu verzi Moodle.

Doporučený způsob, jak vyčistit adresář Moodle je následující:

* Přejmenovat aktuální adresář Moodle "moodle_old"
* Vytvořit nový Moodle adresář obsahující pouze soubory buď standardního staženého Moodle balíčku, nebo z repozitáře Git Moodle
* Přesunout původní soubor config.php a všechny nestandardní pluginy z "moodle_old" adresáře do nového adresáře Moodle

Když máte čistý Moodle adresář, obnovte tuto stránku Moodle aktualizací.

Toto varování je často způsobeno tím, že je rozbalován standardní balíček Moodle na obsah předchozí verze Moodle. I když je to v pořádku pro menší aktualizace, tento postup se důrazně nedoporučuje pro hlavní upgrade Moodle.

Toto upozornění může být také způsobeno neúplnou kontrolou nebo operací aktualizace z úložiště Git, v takovém případě můžete jen čekat na dokončení operace, nebo spusťte příslušný příkaz čištění a opakujte operaci znovu.

Více informací naleznete v dokumentaci aktualizace na <a href="{$a}">{$a}</a>.';
$string['upgradestart'] = 'Aktualizovat databázi Moodle';
$string['upgradesure'] = '<p>Soubory Moodlu byly změněny a chystáte se upgradovat server na verzi: </p>
<p><strong>{$a}</strong></p>
<p>Jakmile tak učiníte, není cesty zpět. Ujistěte se, že máte k dispozici potřebné zálohy.</p>
<p>Upgrade může v závislosti na okolnostech trvat i velmi dlouhou dobu.</p>
<p>Jste si jisti, že chcete upgradovat server na tuto verzi?</p>';
$string['upgradetimedout'] = 'Vypršel časový limit. Restartujte aktualizaci.';
$string['upgradingdata'] = 'Aktualizace dat';
$string['upgradinglogs'] = 'Aktualizace protokolů';
$string['upgradingversion'] = 'Upgraduji na novou verzi';
$string['upwards'] = 'a vyšší';
$string['useblogassociations'] = 'Povolit asociování';
$string['useexternalyui'] = 'Používat online verzi YUI knihoven';
$string['user'] = 'Uživatel';
$string['userbulk'] = 'Hromadné operace';
$string['userbulkdownload'] = 'Export uživatelů jako';
$string['userdefaultpreferences'] = 'Výchozí uživatelské předvolby';
$string['userimagesdisabled'] = 'Obrázky uživatelského profilu jsou zakázány';
$string['userlist'] = 'Seznam uživatelů';
$string['userpolicies'] = 'Zásady správy uživatelů';
$string['userpreference'] = 'Uživatelské předvolby';
$string['userquota'] = 'Uživatelská kvóta';
$string['users'] = 'Uživatelé';
$string['usesitenameforsitepages'] = 'Pro tyto stránky použijte jméno webu';
$string['usetags'] = 'Povolit štítky';
$string['validateemptylineerror'] = 'Prázdné řádky jsou neplatné';
$string['validateerror'] = 'Tato hodnota není validní';
$string['validateerrorlist'] = 'Tyto položky jsou neplatné: {$a}';
$string['validateiperror'] = 'Tyto IP adresy jsou neplatné: {$a}';
$string['verifychangedemail'] = 'Omezit domény při změně emailu';
$string['warningcurrentsetting'] = 'Neplatná současná hodnota:<b>{$a}</b>';
$string['warningiconvbuggy'] = 'Vaše verze knihovny iconv nepodporuje // IGNORE modifier. Měli byste nainstalovat rozšíření mbstring, které může být použito místo čištění řetězců obsahující neplatné UTF-8 znaky.';
$string['webproxy'] = 'Proxy server';
$string['webproxyinfo'] = 'Vyplňte následující informace, jestliže tento Moodle nemá přístup k internetu. Přístup k internetu je třeba ke stahování jazykových balíčků, RSS kanálům, časových zón, atd.<br/><em>Velmi doporučená je instalace PHP cURL.</em>';
$string['xmlrpcrecommended'] = 'Rozšíření XMLRPC je užitečné pro webové služby a pro síťové funkce Moodlu';
$string['yuicomboloading'] = 'Kombinované nahrávání YUI knihoven';
$string['ziprequired'] = 'PHP rozšíření ZIP je povinné. Nelze již používat binárky info-ZIP nebo knihovnu PclZip.';
