<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'studentquiz', language 'pt', branch 'MOODLE_36_STABLE'
 *
 * @package   studentquiz
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abort_button'] = 'Cancelar';
$string['add_comment'] = 'Adicionar comentário';
$string['add_reply'] = 'Adicionar resposta';
$string['after_answering_end_date'] = 'Este Auto-Teste fechou as respostas a perguntas em {$a}.';
$string['after_submission_end_date'] = 'Este Auto-Teste fechou o envio de perguntas em {$a}.';
$string['anonymous_user_name'] = 'Utilizador anónimo #{$a}';
$string['answeringndbeforestart'] = 'O data limite de resposta não pode ser anterior à data de abertura para resposta';
$string['api_state_change_success_content'] = 'O estado da pergunta/visibilidade foi alterado com sucesso';
$string['api_state_change_success_title'] = 'Sucesso';
$string['approve'] = 'Executar';
$string['approved'] = '✓';
$string['approved_column_name'] = 'Aprovada';
$string['approved_veryshort'] = 'A';
$string['approveselectedscheck'] = 'Tem a certeza de que pretende aprovar/não aprovar as seguintes perguntas?<br /><br />{$a}';
$string['approve_toggle'] = 'Aprovar/Não aprovar';
$string['average_column_name'] = 'Média';
$string['before_answering_end_date'] = 'Este Auto-Teste fechará as respostas a perguntas em {$a}.';
$string['before_answering_start_date'] = 'Abre para responder em {$a}.';
$string['before_submission_end_date'] = 'Este Auto-Teste fechará o envio de perguntas em {$a}.';
$string['before_submission_start_date'] = 'Abre para envio de perguntas em {$a}.';
$string['changeselectedsstate'] = 'Alterar o estado das seguintes perguntas:<br /><br />{$a}';
$string['collapseall'] = 'Contrair todos os comentários';
$string['collapsecomment'] = 'Contrair comentário';
$string['comment_cannot_update'] = 'Não é possível atualizar o comentário';
$string['comment_column_name'] = 'Comentários';
$string['comment_error'] = 'Adicione um comentário';
$string['comment_error_unsaved'] = 'Pretende guardar este comentário?';
$string['comment_help'] = 'Adicionar um comentário';
$string['comment_help_help'] = 'Adicionar um comentário à pergunta';
$string['comment_veryshort'] = 'C';
$string['confirmdeletecomment'] = 'Tem a certeza de que pretende apagar este comentário?';
$string['createnewquestion'] = 'Criar nova pergunta';
$string['createnewquestionfirst'] = 'Criar a primeira pergunta';
$string['creator_anonym_fullname'] = 'Aluno anónimo';
$string['current_of_total'] = '{$a->current} de {$a->total}';
$string['delete'] = 'Apagar';
$string['deletecomment'] = 'Apagar comentário';
$string['deletedbyauthor'] = 'Este comentário foi apagado em {$a}.';
$string['deletedbyuser'] = 'Este comentário foi apagado por {$a->user} em {$a->date}.';
$string['deletedcomment'] = 'Comentário apagado.';
$string['describe_already_deleted'] = 'Este comentário já está apagado.';
$string['describe_not_creator'] = 'Este comentário não é seu.';
$string['describe_out_of_time_delete'] = 'Já foi ultrapassado o prazo para apagar este comentário';
$string['describe_out_of_time_edit'] = 'Já passou o prazo para poder editar este comentário';
$string['difficulty_all_column_name'] = 'Dificuldade da comunidade';
$string['difficulty_level_column_name'] = 'Dificuldade';
$string['difficulty_title'] = 'Barra de dificuldade';
$string['editcomment'] = 'Editar comentário';
$string['editorplaceholder'] = 'Digite seu comentário aqui...';
$string['emailapprovedbody'] = 'Caro/a {$a->recepientname},

A sua pergunta \'{$a->questionname}\' na atividade Auto-Teste \'{$a->modulename}\' da disciplina \'{$a->coursename}\' foi aprovada por {$a->actorname} em {$a->timestamp}.

Pode rever a pergunta aqui: {$a->questionurl}.';
$string['emailapprovedsmall'] = 'A sua pergunta \'{$a->questionname}\' foi aprovada por {$a->actorname}.';
$string['emailapprovedsubject'] = 'Pergunta aprovada: {$a->questionname}';
$string['emailchangedbody'] = 'Caro/a {$a->recepientname},

A sua pergunta \'{$a->questionname}\' na atividade Auto-Teste \'{$a->modulename}\' da disciplina \'{$a->coursename}\' foi alterada por {$a->actorname} em {$a->timestamp}.

Pode rever a pergunta aqui: {$a->questionurl}.';
$string['emailchangedsmall'] = 'A sua pergunta \'{$a->questionname}\' foi modificada por {$a->actorname}';
$string['emailchangedsubject'] = 'Pergunta modificada: {$a->questionname}';
$string['emailcommentaddedbody'] = 'Caro/a {$a->recepientname},

A sua pergunta \'{$a->questionname}\' na atividade Auto-Teste \'{$a->modulename}\' da disciplina \'{$a->coursename}\' foi comentada por {$a->actorname} em {$a->timestamp}.

Comentário adicionado: \'{$a->commenttext}\'

Pode rever a pergunta aqui: {$a->questionurl}.';
$string['emailcommentaddedsmall'] = 'A sua pergunta \'{$a->questionname}\' foi comentada por {$a->actorname}.';
$string['emailcommentaddedsubject'] = 'Pergunta comentada: {$a->questionname}';
$string['emailcommentdeletedbody'] = 'Caro/a {$a->recepientname},

O comentário efetuado em \'{$a->commenttime}\' à sua pergunta \'{$a->questionname}\' na atividade Auto-Teste \'{$a->modulename}\' da disciplina \'{$a->coursename}\' foi apagado por {$a->actorname} em {$a->timestamp}.

Comentário apagado: \'{$a->commenttext}\'

Pode rever a pergunta aqui: {$a->questionurl}.';
$string['emailcommentdeletedsmall'] = 'O comentário à sua pergunta foi apagado por {$a->actorname}.';
$string['emailcommentdeletedsubject'] = 'Comentário apagado da pergunta: {$a->questionname}';
$string['emaildeletedbody'] = 'Caro/a {$a->recepientname},

A sua pergunta \'{$a->questionname}\' na atividade Auto-Teste \'{$a->modulename}\' da disciplina \'{$a->coursename}\' foi apagada por {$a->actorname} em {$a->timestamp}.';
$string['emaildeletedsmall'] = 'A sua pergunta \'{$a->questionname}\' foi apagada por {$a->actorname}.';
$string['emaildeletedsubject'] = 'Pergunta apagada: {$a->questionname}';
$string['emaildisapprovedbody'] = 'Caro/a {$a->recepientname},

A sua pergunta \'{$a->questionname}\' na atividade Auto-Teste \'{$a->modulename}\' da disciplina \'{$a->coursename}\' foi reprovada por \'{$a->actorname}\' (\'{$a->timestamp}\').

Pode rever a pergunta aqui: {$a->questionurl}.';
$string['emaildisapprovedsmall'] = 'A sua pergunta \'{$a->questionname}\' foi desaprovada por {$a->actorname}.';
$string['emaildisapprovedsubject'] = 'A pergunta foi desaprovada: {$a->questionname}';
$string['emailhiddenbody'] = 'Caro/a {$a->recepientname},

A sua pergunta \'{$a->questionname}\' na atividade Auto-Teste \'{$a->modulename}\' da disciplina \'{$a->coursename}\' foi ocultada por \'{$a->actorname}\' em \'{$a->timestamp}\'.

Pode rever a pergunta aqui: {$a->questionurl}.';
$string['emailhiddensmall'] = 'A sua pergunta \'{$a->questionname}\' foi ocultada por {$a->actorname}.';
$string['emailhiddensubject'] = 'Pergunta foi ocultada: {$a->questionname}';
$string['emailminecommentdeletedbody'] = 'Caro/a {$a->recepientname},

O seu comentário efetuado em \'{$a->commenttime}\' à pergunta \'{$a->questionname}\' na atividade Auto-Teste \'{$a->modulename}\' da disciplina \'{$a->coursename}\' foi apagado por {$a->actorname} em {$a->timestamp}.

Comentário apagado: \'{$a->commenttext}\'

Pode rever a pergunta aqui: {$a->questionurl}.';
$string['emailminecommentdeletedsmall'] = 'O seu comentário à pergunta \'{$a->questionname}\' foi apagado por {$a->actorname}.';
$string['emailminecommentdeletedsubject'] = 'Comentário apagado da pergunta: {$a->questionname}';
$string['emailunhiddenbody'] = 'Caro/a {$a->recepientname},

A sua pergunta \'{$a->questionname}\' na atividade Auto-Teste \'{$a->modulename}\' da disciplina \'{$a->coursename}\' foi alterado o estado para visível por \'{$a->actorname}\' (\'{$a->timestamp}\').

Pode rever a pergunta aqui: {$a->questionurl}.';
$string['emailunhiddensmall'] = 'A sua pergunta \'{$a->questionname}\' foi alterada para visível por {$a->actorname}.';
$string['emailunhiddensubject'] = 'A pergunta foi alterada para visível: {$a->questionname}';
$string['error_form_validation'] = '{$a}';
$string['error_sendalert'] = 'Ocorreu um erro ao enviar a sua denúncia para {$a}.
Não foi possível enviar o relatório.';
$string['expandall'] = 'Expandir todos os comentários';
$string['expandcomment'] = 'Expandir comentário';
$string['filter'] = 'Filtro';
$string['filter_advanced_element'] = '{$a} (elemento avançado)';
$string['filter_comment_label_date'] = 'Data';
$string['filter_comment_label_forename'] = 'Nome';
$string['filter_comment_label_sort_by'] = 'Ordenar por:';
$string['filter_comment_label_sort_toggle'] = 'Ordenar por {$a->field} {$a->type}';
$string['filter_comment_label_surname'] = 'Apelido';
$string['filter_ishigher'] = 'É maior';
$string['filter_islower'] = 'É menor';
$string['filter_label_approved'] = 'Perguntas aprovadas';
$string['filter_label_comment'] = 'Comentários';
$string['filter_label_createdate'] = 'Data de criação';
$string['filter_label_difficulty_level'] = 'Dificuldade';
$string['filter_label_fast_filters'] = 'Filtro rápido das perguntas';
$string['filter_label_firstname'] = 'Nome';
$string['filter_label_myattempts'] = 'Minhas tentativa';
$string['filter_label_mydifficulty'] = 'Minha dificuldade';
$string['filter_label_mylastattempt'] = 'Minha última tentativa';
$string['filter_label_myrate'] = 'Minha classificação';
$string['filter_label_onlyapproved'] = 'Aprovada';
$string['filter_label_onlyapproved_help'] = 'Perguntas aprovadas pelo teu professor';
$string['filter_label_onlydifficult'] = 'Difícil para todos';
$string['filter_label_onlydifficultforme'] = 'Difícil para mim';
$string['filter_label_onlydifficultforme_help'] = 'Pergunta com a minha dificuldade maior que {$a}%';
$string['filter_label_onlydifficult_help'] = 'Pergunta com a dificuldade média maior que {$a}%';
$string['filter_label_onlygood'] = 'Útil';
$string['filter_label_onlygood_help'] = 'Pergunta com classificação média de pelo menos {$a} estrelas';
$string['filter_label_onlymine'] = 'Minha';
$string['filter_label_onlymine_help'] = 'Perguntas criadas por ti';
$string['filter_label_onlynew'] = 'Não respondida';
$string['filter_label_onlynew_help'] = 'Perguntas que nunca respondeu';
$string['filter_label_question'] = 'Título da pergunta';
$string['filter_label_question_creation_item'] = '{$a->creationtext} {$a->rowtext} {$a->inputtext}';
$string['filter_label_question_creation_item_inputtext'] = '{$a->inputtext} {$a->inputtype}';
$string['filter_label_questiontext'] = 'Conteúdo da pergunta';
$string['filter_label_rates'] = 'Classificação';
$string['filter_label_show_mine'] = 'Minhas perguntas';
$string['filter_label_surname'] = 'Apelido';
$string['filter_label_tags'] = 'Etiqueta';
$string['finish_button'] = 'Terminar';
$string['image_placeholder'] = '[Imagem]';
$string['invalidcomment'] = 'comentarioinválido';
$string['invalidemail'] = 'Este endereço de e-mail não é válido. Digite um endereço de e-mail único.';
$string['lastattempt_right'] = '✓';
$string['lastattempt_right_label'] = 'Última tentativa correta';
$string['lastattempt_wrong'] = '✗';
$string['lastattempt_wrong_label'] = 'Última tentativa incorreta';
$string['latest_column_name'] = 'Última';
$string['manager_anonym_fullname'] = 'Gestor anónimo';
$string['message'] = 'Mensagem';
$string['messageprovider:approved'] = 'Notificação de pergunta aprovada';
$string['messageprovider:changed'] = 'Notificação de pergunta alterada';
$string['messageprovider:commentadded'] = 'Notificação de comentário adicionado';
$string['messageprovider:commentdeleted'] = 'Notificação de comentário apagado';
$string['messageprovider:deleted'] = 'Notificação de pergunta apagada';
$string['messageprovider:disapproved'] = 'Notificação de pergunta desaprovada';
$string['messageprovider:hidden'] = 'Notificação de pergunta ocultada';
$string['messageprovider:minecommentdeleted'] = 'Notificação de meu comentário apagado';
$string['messageprovider:unhidden'] = 'Notificação de pergunta tornada visível';
$string['migrate_already_done'] = 'Nada foi alterado porque esta atividade já estava migrada!';
$string['migrate_ask'] = 'A velocidade do Auto-Teste melhorou com a versão 3.2.1, mas este conjunto de perguntas ainda está baseado numa versão anterior.
As perguntas e testes serão carregados mais rapidamente se executar essa migração de aceleração. Irá ocorrer um um carregamento mais rápido; nada mais irá ser alterado.';
$string['migrated_successful'] = 'A migração da atividade foi realizada com sucesso!';
$string['migrate_studentquiz'] = 'Faça a migração das perguntas do Auto-Teste anteriores à versão 3.2.1 para a versão mais rápida com valores agregados';
$string['migrate_studentquiz_short'] = 'Acelerar este conjunto de perguntas';
$string['mine_column_name'] = 'Minha';
$string['missingparam'] = 'Um parâmetro obrigatório está incorreto ou está em falta';
$string['moderator'] = 'Moderador';
$string['modulename'] = 'Auto-Teste';
$string['modulename_help'] = 'A atividade **Auto-Teste** permite que os alunos adicionem perguntas para a comunidade. Na vista geral do Auto-Teste, os estudantes podem filtrar as perguntas. Também podem usar as perguntas filtradas na comunidade para praticar. O professor tem a opção de tornar "não visível" a coluna do criador da pergunta.<br><br>A atividade Auto-Teste premeia os alunos com pontos para motivá-los a adicionar perguntas e a praticar. Os pontos são listados numa tabela de classificação.';
$string['modulenameplural'] = 'Auto-Testes';
$string['more'] = 'Mais';
$string['myattempts_column_name'] = 'Minhas tentativas';
$string['mydifficulty_column_name'] = 'Minha dificuldade';
$string['mylastattempt_column_name'] = 'Minha última tentativa';
$string['myrate_column_name'] = 'Minha classificação';
$string['nav_export'] = 'Exportar';
$string['nav_import'] = 'Importar';
$string['needtoallowatleastoneqtype'] = 'Tem de permitir pelo menos um tipo de pergunta';
$string['next_button'] = 'Seguinte';
$string['no_comment'] = 'n.d.';
$string['no_comments'] = 'Sem comentários';
$string['no_difficulty_level'] = 'n.d.';
$string['no_myattempts'] = 'n.d.';
$string['no_mylastattempt'] = 'n.d.';
$string['no_mylastattempt_label'] = 'Nenhuma tentativa à pergunta';
$string['no_questions_add'] = 'Ainda não existem perguntas neste Auto-Teste. Não hesite em adicionar algumas perguntas.';
$string['no_questions_filter'] = 'Nenhuma das perguntas corresponde aos critérios de filtro. Limpe o filtro para ver tudo.';
$string['no_questions_selected_message'] = 'Tem de selecionar pelo menos uma pergunta para iniciar o teste.';
$string['no_rates'] = 'n.d.';
$string['no_tags'] = 'n.d.';
$string['not_approved'] = '✗';
$string['number_column_name'] = 'Número';
$string['numberreply'] = 'Respostas: {$a}';
$string['num_questions'] = '{$a} perguntas';
$string['onlyrootcommentcanreply'] = 'Apenas o primeiro nível de comentário pode ser respondido';
$string['pagesize'] = 'Tamanho da página:';
$string['please_enrole_message'] = 'Inscreva-se nesta disciplina para ver o seu progresso pessoal';
$string['pluginadministration'] = 'Administração do Auto-Teste';
$string['pluginname'] = 'Auto-Teste';
$string['previous_button'] = 'Anterior';
$string['privacy:metadata:mod_studentquiz_comment_sort'] = 'A preferência do utilizador para o tipo de filtro de comentário.';
$string['privacy:metadata:studentquiz_attempt'] = 'Representa uma tentativa de responder do utilizador a um conjunto de perguntas.';
$string['privacy:metadata:studentquiz_attempt:categoryid'] = 'ID da categoria';
$string['privacy:metadata:studentquiz_attempt:questionusageid'] = 'ID do uso da pergunta.';
$string['privacy:metadata:studentquiz_attempt:studentquizid'] = 'ID do Auto-Teste.';
$string['privacy:metadata:studentquiz_attempt:userid'] = 'ID do utilizador.';
$string['privacy:metadata:studentquiz_comment'] = 'Armazena comentários das perguntas.';
$string['privacy:metadata:studentquiz_comment:comment'] = 'Comentário da pergunta.';
$string['privacy:metadata:studentquiz_comment:created'] = 'Data/hora da criação do documentário';
$string['privacy:metadata:studentquiz_comment:questionid'] = 'ID da pergunta.';
$string['privacy:metadata:studentquiz_comment:userid'] = 'ID do utilizador.';
$string['privacy:metadata:studentquiz_progress'] = 'Armazena informação do progresso do aluno nesta pergunta.';
$string['privacy:metadata:studentquiz_progress:attempts'] = 'Número de tentativas para responder a esta pergunta.';
$string['privacy:metadata:studentquiz_progress:correctattempts'] = 'Número de respostas corretas.';
$string['privacy:metadata:studentquiz_progress:lastanswercorrect'] = '0: a última resposta estava errada ou indefinida, 1: a última resposta estava correta.';
$string['privacy:metadata:studentquiz_progress:questionid'] = 'ID da pergunta.';
$string['privacy:metadata:studentquiz_progress:studentquizid'] = 'ID do Auto-Teste.';
$string['privacy:metadata:studentquiz_progress:userid'] = 'ID do utilizador.';
$string['privacy:metadata:studentquiz_rate'] = 'Armazena as avaliações das perguntas.';
$string['privacy:metadata:studentquiz_rate:questionid'] = 'ID da pergunta.';
$string['privacy:metadata:studentquiz_rate:rate'] = 'Avaliação da pergunta.';
$string['privacy:metadata:studentquiz_rate:userid'] = 'ID do utilizador.';
$string['progress_bar_caption'] = 'O seu progresso nesta atividade Auto-Teste';
$string['questionsinuse'] = '(* Perguntas marcadas com um asterisco já estão em uso em alguns testes.)';
$string['ranking_block_title'] = 'Classificação';
$string['ranking_block_title_anonymised'] = 'Classificação (Sem nomes)';
$string['rate_all_column_name'] = 'Avaliação da comunidade';
$string['rate_column_name'] = 'Avaliação';
$string['rate_error'] = 'Por favor, avalie a pergunta.';
$string['rate_help'] = 'Avaliar esta pergunta';
$string['rate_help_help'] = 'Avaliar esta pergunta:<br />1 estrela é muito má, 5 estrelas é muito boa';
$string['rate_multi_stars_desc'] = '{$a} estrelas selecionadas';
$string['rate_one_star_desc'] = '1 estrela selecionada';
$string['rate_points'] = 'Pontos';
$string['rate_title'] = 'Avaliar';
$string['ratingbar_title'] = 'Barra da classificação';
$string['remove_comment'] = 'Remover';
$string['remove_comment_label'] = 'Remover comentário';
$string['replies'] = 'Respostas';
$string['reply'] = 'Resposta';
$string['replycomment'] = 'Responder';
$string['reportcomment'] = 'Denunciar';
$string['report_comment_condition1'] = 'É abusivo';
$string['report_comment_condition2'] = 'É assédio';
$string['report_comment_condition3'] = 'Tem conteúdo obsceno, como por exemplo, pornografia';
$string['report_comment_condition4'] = 'É injurioso ou difamatório';
$string['report_comment_condition5'] = 'Não respeita direitos de autor';
$string['report_comment_condition6'] = 'É contra as regras por algum outro motivo';
$string['report_comment_condition_more'] = 'Outras informações (opcional)';
$string['report_comment_emailappendix'] = 'Está a receber esta mensagem porque o seu endereço de e-mail foi
usado no Auto-Teste para denunciar comentários inaceitáveis.';
$string['report_comment_emailpreface'] = 'Um comentário foi denunciado por {$a->fullname} ({$a->username},
{$a->email}).';
$string['report_comment_emailsubject'] = 'Denunciar o comentário {$a->commentid}: {$a->coursename} {$a->studentquizname}';
$string['report_comment_feedback'] = 'A sua denúncia foi enviada com sucesso. Um responsável irá verificar a situação.';
$string['report_comment_info'] = 'A funcionalidade \'Denunciar\' pode enviar este comentário para um responsável que irá verificar a situação. <strong>Use esta funcionalidade apenas se achar que o comentário não cumpre as regras</strong>.';
$string['report_comment_invalid'] = 'Tem de especificar o motivo da denúncia deste comentário.';
$string['report_comment_invalid_checkbox'] = 'Tem de marcar pelo menos uma das caixas.';
$string['report_comment_link_text'] = 'Pré-visualizar aqui';
$string['report_comment_not_available'] = 'A funcionalidade denunciar comentário não está disponível.';
$string['report_comment_pagename'] = 'Denunciar um comentário como inaceitável';
$string['report_comment_reasons'] = 'Razões para denunciar o comentário:';
$string['report_comment_reporter_detail'] = '{$a->fullname} ({$a->username}; {$a->email}; {$a->ip})';
$string['report_comment_reporter_info'] = '<strong>Detalhes do denunciante</strong>:';
$string['report_comment_submit'] = 'Enviar denúncia';
$string['reportcomment_title'] = 'Denunciar comentários como inaceitáveis';
$string['reportquiz_admin_title'] = 'Estatísticas do aluno';
$string['reportquiz_stats_all_last_attempt_correct'] = 'Média das últimas respostas corretas da comunidade';
$string['reportquiz_stats_all_last_attempt_incorrect'] = 'Média das últimas respostas incorretas da comunidade';
$string['reportquiz_stats_all_percentage_correct_answers'] = 'Percentagem de respostas corretas da comunidade';
$string['reportquiz_stats_all_percentage_correct_answers_help'] = 'Soma das respostas corretas / soma de todas as respostas.';
$string['reportquiz_stats_all_progress'] = 'Progresso médio da comunidade';
$string['reportquiz_stats_all_progress_help'] = 'Progresso médio da comunidade com base em todos os membros da comunidade.';
$string['reportquiz_stats_all_question_attempts_correct'] = 'Média de respostas corretas da comunidade';
$string['reportquiz_stats_all_question_attempts_incorrect'] = 'Média de respostas incorretas da comunidade';
$string['reportquiz_stats_all_questions_answered'] = 'Média de todas as respostas da comunidade';
$string['reportquiz_stats_all_questions_answered_help'] = 'Número médio de respostas dadas por todos os membros da comunidade.';
$string['reportquiz_stats_all_questions_approved'] = 'Número de perguntas aprovadas';
$string['reportquiz_stats_all_questions_approved_help'] = 'Os professores podem aprovar perguntas para verificar a correção. Este número corresponde a todas as perguntas aprovadas neste Auto-Teste.';
$string['reportquiz_stats_all_questions_created'] = 'Número de perguntas neste Auto-Teste';
$string['reportquiz_stats_all_questions_created_help'] = 'Número de perguntas criadas pela comunidade';
$string['reportquiz_stats_all_rates_average'] = 'Cassificação média de todas as perguntas';
$string['reportquiz_stats_all_rates_average_help'] = 'A classificação de cada pergunta é a média das estrelas que recebeu da comunidade. Exemplo: a comunidade criou 4 perguntas. Se a pergunta A tiver sido classificada como 3 estrelas pela comunidade, a pergunta B = 4 estrelas,  pergunta C = 2 estrelas e A pergunta D = 5 estrelas, então a classificação média  de todas as perguntas é de 3,5.';
$string['reportquiz_stats_own_last_attempt_correct'] = 'Número das suas últimas respostas corretas';
$string['reportquiz_stats_own_last_attempt_incorrect'] = 'Número das suas últimas respostas incorretas';
$string['reportquiz_stats_own_percentage_correct_answers'] = 'Percentagem das suas respostas corretas';
$string['reportquiz_stats_own_percentage_correct_answers_help'] = 'Percentagem do total das suas respostas corretas em relação ao conjunto de todas as perguntas deste Auto-Teste. As respostas parcialmente corretas contam como respostas incorretas.';
$string['reportquiz_stats_own_progress'] = 'Progresso pessoal';
$string['reportquiz_stats_own_progress_help'] = 'Percentagem das suas últimas respostas corretas em relação ao conjunto de todas as perguntas neste Auto-Teste. As respostas parcialmente corretas contam como respostas incorretas.';
$string['reportquiz_stats_own_question_attempts_correct'] = 'Total das suas respostas corretas';
$string['reportquiz_stats_own_question_attempts_incorrect'] = 'Total das suas respostas incorretas';
$string['reportquiz_stats_own_questions_answered'] = 'Total de todas as suas respostas';
$string['reportquiz_stats_own_questions_answered_help'] = 'Número de todas as suas respostas dadas neste Auto-Teste.';
$string['reportquiz_stats_own_questions_approved'] = 'Número de perguntas suas aprovadas';
$string['reportquiz_stats_own_questions_approved_help'] = 'Os professores podem aprovar perguntas para verificar a correção. Este é o número de perguntas suas aprovadas neste Auto-Teste.';
$string['reportquiz_stats_own_questions_created'] = 'Número de perguntas que já contribuiu';
$string['reportquiz_stats_own_questions_created_help'] = 'Número de perguntas que já contribuiu neste Auto-Teste';
$string['reportquiz_stats_own_rates_average'] = 'A sua classificação média obtida';
$string['reportquiz_stats_own_rates_average_help'] = 'A classificação de cada pergunta é a média das estrelas que recebeu da comunidade. Exemplo: criou as perguntas A e B. Se a sua pergunta A foi classificada como 3 estrelas pela comunidade e a sua pergunta B foi classificada como 4 estrelas, a sua classificação média recebida é de 3,5.';
$string['reportquiz_stats_title'] = 'Estatísticas';
$string['reportquiz_total_attempt'] = 'Número de vezes que tentou o teste';
$string['reportquiz_total_obtained_marks'] = 'Nota total';
$string['reportquiz_total_questions_answered'] = 'Total de respostas';
$string['reportquiz_total_questions_right'] = 'Total de perguntas corretas';
$string['reportquiz_total_questions_wrong'] = 'Respostas incorretas';
$string['reportquiz_total_users'] = 'Número de participantes';
$string['reportrank_table_column_approvedquestions'] = 'Pontos para perguntas aprovadas';
$string['reportrank_table_column_communitystatus'] = 'Estatísticas da comunidade';
$string['reportrank_table_column_correctanswers'] = 'Respostas corretas';
$string['reportrank_table_column_countquestions'] = 'Pontos para perguntas criadas';
$string['reportrank_table_column_description'] = 'Descrição';
$string['reportrank_table_column_factor'] = 'Fator';
$string['reportrank_table_column_fullname'] = 'Nome completo';
$string['reportrank_table_column_incorrectanswers'] = 'Respostas incorretas';
$string['reportrank_table_column_lastcorrectanswers'] = 'Pontos para as últimas tentativas corretas';
$string['reportrank_table_column_lastincorrectanswers'] = 'Pontos para as últimas tentativas incorretas';
$string['reportrank_table_column_points'] = 'Pontos';
$string['reportrank_table_column_progress'] = 'Progresso pessoal';
$string['reportrank_table_column_quantifier_name'] = 'Nome';
$string['reportrank_table_column_rank'] = 'Posição';
$string['reportrank_table_column_summeanrates'] = 'Pontos para as estrelas recebidas';
$string['reportrank_table_column_total_points'] = 'Total de pontos';
$string['reportrank_table_column_value'] = 'Valor';
$string['reportrank_table_column_yourstatus'] = 'Estatísticas pessoais';
$string['reportrank_table_quantifier_caption'] = 'Cálculo da pontuação';
$string['reportrank_table_title'] = 'Pontuação do aluno - Top 10';
$string['reportrank_table_title_for_manager'] = 'Pontuação do aluno';
$string['reportrank_title'] = 'Pontuação';
$string['review_button'] = 'Rever';
$string['savechanges'] = 'Guardar alterações';
$string['setting_question_publishing'] = 'Publicação de perguntas';
$string['setting_question_publishing_automatic'] = 'Publicar automaticamente as novas perguntas';
$string['setting_question_publishing_help'] = 'As perguntas publicadas são exibidas no conjunto de perguntas para que outros alunos as possam usar. Permita que todas as perguntas sejam publicadas automaticamente ou exija aprovação antes de poderem ser publicadas.<br>Tenha em atenção que esta configuração não pode ser alterada após a criação de uma pergunta no Auto-Teste.';
$string['setting_question_publishing_require_approval'] = 'Exigir aprovação antes da publicação';
$string['settings_allowallqtypes'] = 'Permitir todos os tipos de pergunta';
$string['settings_allowedqtypes'] = 'Tipos de pergunta permitidos';
$string['settings_allowedqtypes_help'] = 'Limitar os tipos de pergunta permitidos às entradas selecionadas';
$string['settings_anonymous'] = 'Anonimizar os alunos';
$string['settings_anonymous_help'] = 'Os alunos não podem ver os nomes uns dos outros.';
$string['settings_anonymous_label'] = 'Tornar os alunos anónimos';
$string['settings_approvedquantifier'] = 'Fator para pergunta aprovada';
$string['settings_approvedquantifier_help'] = 'Pontos atribuídos a cada pergunta aprovada';
$string['settings_approvedquantifier_label'] = 'Pontos para cada pergunta aprovada';
$string['settings_availability_close_answering_from'] = 'Fechada a resposta em';
$string['settings_availability_close_submission_from'] = 'Fecha a submissão de perguntas em';
$string['settings_availability_open_answering_from'] = 'Abre para resposta em';
$string['settings_availability_open_submission_from'] = 'Abre para submissão de perguntas em';
$string['settings_commentdeletionperiod'] = 'Prazo para editar/apagar comentários (minutos)';
$string['settings_commentdeletionperiod_help'] = 'Defina o intervalo de tempo (em minutos) durante o qual o botão Editar/Apagar estará disponível para os alunos editarem/apagarem o seu próprio comentário (ou resposta a um comentário) após a publicação. São permitidos valores entre 0 e 60 minutos. Se o intervalo de tempo for definido como 0, os alunos não poderão editar/apagar os seus próprios comentários. Tenha em atenção que os professores e administradores poderão, a qualquer instante, editar/apagar os comentários dos alunos assim como ver o conteúdo de qualquer comentário apagado.';
$string['settings_excluderoles'] = 'Papéis a excluir na classificação';
$string['settings_excluderoles_help'] = 'Os papéis selecionados estarão ocultos nas classificações. Os utilizadores inscritos com estes papéis podem participar normalmente na atividade';
$string['settings_excluderoles_label'] = 'Papéis a excluir na classificação';
$string['settings_forcecommenting'] = 'Forçar adicão de comentários';
$string['settings_forcecommenting_help'] = 'Forçar comentários na tentativa de pergunta';
$string['settings_forcerating'] = 'Forçar classificação';
$string['settings_forcerating_help'] = 'Forçar classificação na tentativa da pergunta';
$string['settings_lastcorrectanswerquantifier'] = 'Fator para resposta correta';
$string['settings_lastcorrectanswerquantifier_help'] = 'Pontos para cada resposta correta na última tentativa';
$string['settings_lastcorrectanswerquantifier_label'] = 'Pontos para as últimas respostas corretas';
$string['settings_lastincorrectanswerquantifier'] = 'Fator para resposta incorreta';
$string['settings_lastincorrectanswerquantifier_help'] = 'Pontos para cada resposta incorreta, ou parcialmente incorreta, na última tentativa';
$string['settings_lastincorrectanswerquantifier_label'] = 'Pontos para as últimas respostas incorretas';
$string['settings_publish_new_questions'] = 'Publicar novas perguntas';
$string['settings_publish_new_questions_help'] = 'Publicar automaticamente as novas perguntas criadas';
$string['settings_questionquantifier'] = 'Fator para pergunta criada';
$string['settings_questionquantifier_help'] = 'Pontos atribuídos a cada pergunta criada';
$string['settings_questionquantifier_label'] = 'Pontos para cada pergunta criada';
$string['settings_ratequantifier'] = 'Fator de avaliação';
$string['settings_ratequantifier_help'] = 'Pontos por cada estrela recebida';
$string['settings_ratequantifier_label'] = 'Multiplicador para a média de estrelas recebidas por pergunta';
$string['settings_removeqbehavior'] = 'Desinstalar o módulo de comportamento de perguntas Auto-Teste';
$string['settings_removeqbehavior_help'] = 'Esta informação deve aparecer apenas uma vez durante a atualização. Foi detetado que o módulo de comportamento de perguntas Auto-Teste está instalado. Este módulo já não é necessário e, portanto, tentamos desinstalar automaticamente. Se ainda vê esta configuração, desinstale o módulo de comportamento de perguntas StudentQuiz manualmente <a href="{$a}">aqui</a>.';
$string['settings_removeqbehavior_label'] = 'Desinstalar o módulo de comportamento de perguntas Auto-Teste';
$string['settings_reportingemail'] = 'E-mail para reportar comentários ofensivos';
$string['settings_reportingemail_help'] = 'Se for indicado o endereço de e-mail, ao lado de cada comentário será exibida uma hiperligação para denunciar. Os utilizadores podem clicar na hiperligação para reportar comentários ofensivos. As informações serão enviadas para este endereço.

Se este endereço de e-mail for deixado em branco, o recurso Denunciar não será exibido (a menos que tenha sido fornecido um endereço de denúncia ao nível do site).

É possível adicionar mais do que um endereço de e-mail, desde que separados por ponto e vírgula.';
$string['settings_section_description_default'] = 'Valores predefinidos para quando criar uma nova atividade de Auto-Teste';
$string['settings_section_header_comment_rating'] = 'Configurações do comentário e da pontuação';
$string['settings_section_header_question'] = 'Configurações da pergunta';
$string['settings_section_header_ranking'] = 'Configurações da classificação';
$string['show_less'] = 'Mostrar menos';
$string['show_more'] = 'Mostrar mais';
$string['slot_of_slot'] = 'Pergunta {$a->slot} de {$a->slots} deste conjunto';
$string['start_quiz_button'] = 'Iniciar teste';
$string['state_approved'] = 'Aprovada';
$string['state_changed'] = 'Alterada';
$string['state_change_tooltip'] = 'Estado da pergunta: {$a}. Clique aqui para alterar o estado da pergunta';
$string['state_change_tooltip_approved'] = 'A pergunta foi aprovada. Clique aqui para alterar o estado desta pergunta';
$string['state_change_tooltip_changed'] = 'A pergunta foi alterada. Clique aqui para alterar o estado desta pergunta';
$string['state_change_tooltip_disapproved'] = 'A pergunta não foi aprovada. Clique aqui para alterar o estado desta pergunta';
$string['state_change_tooltip_new'] = 'A pergunta é nova. Clique aqui para alterar o estado desta pergunta';
$string['state_column_name'] = 'Estado';
$string['state_column_name_veryshort'] = 'E';
$string['state_disapproved'] = 'Desaprovada';
$string['state_new'] = 'Nova';
$string['state_toggle'] = 'Alterar estado';
$string['statistic_block_approvals'] = 'Perguntas aprovadas';
$string['statistic_block_created'] = 'Perguntas criadas';
$string['statistic_block_disapprovals'] = 'Perguntas desaprovadas';
$string['statistic_block_new_changed'] = 'Perguntas novas/alteradas';
$string['statistic_block_progress_available'] = 'Perguntas disponíveis';
$string['statistic_block_progress_last_attempt_correct'] = 'Última tentativa correta';
$string['statistic_block_progress_last_attempt_incorrect'] = 'Última tentativa incorreta';
$string['statistic_block_progress_never'] = 'Perguntas nunca respondidas';
$string['statistic_block_title'] = 'Meu progresso';
$string['studentquiz'] = 'studentquiz';
$string['studentquiz:addinstance'] = 'Adicionar nova instância de Auto-Teste';
$string['studentquiz:emailnotifyapproved'] = 'Notificação de pergunta criada';
$string['studentquiz:emailnotifychanged'] = 'Notificação de pergunta alterada';
$string['studentquiz:emailnotifycommentadded'] = 'Notificação de comentário adicionado';
$string['studentquiz:emailnotifycommentdeleted'] = 'Notificação de comentário apagado';
$string['studentquiz:emailnotifydeleted'] = 'Notificação de pergunta apagada';
$string['studentquiz:manage'] = 'Moderar perguntas no Auto-Teste';
$string['studentquizname'] = 'Nome do Auto-Teste';
$string['studentquizname_help'] = 'Nome desta atividade de Auto-Teste';
$string['studentquiz:previewothers'] = 'Pré-visualizar perguntas de outros no Auto-Teste';
$string['studentquiz:submit'] = 'Submeter perguntas no Auto-Teste';
$string['studentquiz:unhideanonymous'] = 'Pode ver os nomes reais mesmo quando o anonimato está ativo';
$string['studentquiz:view'] = 'Ver perguntas no Auto-Teste';
$string['submissionendbeforestart'] = 'A data limite para submeter não pode ser anterior à data de abertura para submissões';
$string['tags'] = 'Etiquetas';
$string['unapprove'] = 'Não aprovar';
