<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'reservation', language 'pt', branch 'MOODLE_36_STABLE'
 *
 * @package   reservation
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addparticipant'] = 'Adicionar pedido';
$string['after10min'] = '10 minutos depois do início do evento';
$string['after12h'] = '12 horas depois do início do evento';
$string['after1d'] = '1 dia depois do início do evento';
$string['after1h'] = '1 hora depois do início do evento';
$string['after1w'] = '1 semana depois do início do evento';
$string['after2d'] = '2 dias depois do início do evento';
$string['after2h'] = '2 horas depois do início do evento';
$string['after2w'] = '2 semanas depois do início do evento';
$string['after30min'] = '30 minutos depois do início do evento';
$string['after3w'] = '3 semanas depois do início do evento';
$string['after4h'] = '4 horas depois do início do evento';
$string['after4w'] = '4 semanas depois do início do evento';
$string['after5min'] = '5 minutos depois do início do evento';
$string['after6h'] = '6 horas depois do início do evento';
$string['alreadybooked'] = 'Já está reservado';
$string['alreadyoverbooked'] = 'Já está na lista de espera';
$string['atstart'] = 'No início do evento';
$string['autohide'] = 'Ocultar automaticamente a lista de reserva';
$string['availablerequests'] = 'Lugares disponíveis';
$string['badcourse'] = 'Disciplina não existe';
$string['badparent'] = 'Esta reserva estava ligada a outra reserva que não foi restaurada. A ligação foi apagada. Se necessário, ligue-as manualmente';
$string['badsection'] = 'A secção não existe na disciplina "{$a}"';
$string['badteachers'] = 'O e-mail do professor especificado ({$a}) não foi encontrado';
$string['badteachersmail'] = 'O e-mail do professor especificado ({$a}) está incorreto';
$string['badtimeclose'] = 'Data de encerramento incorreta';
$string['badtimeend'] = 'Data de fim incorreta';
$string['badtimeopen'] = 'Data de abertura incorreta';
$string['badtimestart'] = 'Data de início incorreta';
$string['by'] = 'por';
$string['bydate'] = 'Data do evento';
$string['byname'] = 'Nome';
$string['bysection'] = 'Tópico/Semana';
$string['cancelledon'] = 'Cancelado em';
$string['checkclashes'] = 'Verificar sobreposição';
$string['clashesfound'] = 'Existe sobreposição de hora e/ou local';
$string['clashesreport'] = 'Relatório de sobreposições';
$string['cleanview'] = 'Ver apenas os atualmente reservados';
$string['close'] = 'fechar';
$string['closed'] = 'Encerrado';
$string['completionreserved'] = 'O aluno tem de efetuar reserva para concluir a atividade';
$string['config'] = 'Configurações da marcação';
$string['configautohide'] = 'Define quanto tempo depois as reservas devem ser ocultadas da lista de reservas (mod/reservation/index.php). Pode ser útil quando se usam listas públicas, de modo a mostrar sempre uma lista limpa.';
$string['configcheckclashes'] = 'Ativar o botão "Verificar sobreposição de hora e/ou local" na página de edição da reserva';
$string['configconnectto'] = 'Define onde o módulo procura reservas para se ligar';
$string['configdownload'] = 'Define o formato predefinido do ficheiro de descarga para todas as listas de pedidos e reserva.';
$string['configevents'] = 'Define que eventos serão criados para cada reserva';
$string['configfields'] = 'Define que campos serão mostrados na tabela de reservas';
$string['configlocations'] = 'Gestão dos locais padrão para as Marcações neste site Moodle';
$string['configmanualusers'] = 'Define qual lista de utilizadores é mostrada na lista pendente quando efetua a reserva manual dos utilizadores.';
$string['configmaxoverbook'] = 'Define a percentagem máxima de sobrelotação nas marcações';
$string['configmaxrequests'] = 'Define o limite da lista pendente na página de edição da reserva';
$string['configminduration'] = 'Define a duração mínima do evento. Será usada em eventos não terminados para verificar a disponibilidade de hora e local';
$string['confignotifies'] = 'Define que notificações devem ser enviadas';
$string['configoverbookstep'] = 'Define o tamanho (em percentagem) das subdivisões da sobrelotação. Tamanho mais pequeno, maior a precisão';
$string['configpubliclists'] = 'Define se as listas de reservas são públicas (visualizadas sem autenticação) ou não.';
$string['configsortby'] = 'Define como são ordenadas as lista de reservas.';
$string['configsublimits'] = 'Define o número de linhas de sublimites na página de edição das reservas';
$string['configupload'] = 'Criar várias reservas carregando-as através de um ficheiro de texto';
$string['confirmdelete'] = 'Tem a certeza de que pretende apagar os pedidos de reserva selecionados?';
$string['connectedto'] = 'Reserva ligada a';
$string['connectto'] = 'Reserva ligada a partir de';
$string['description'] = 'Descrição';
$string['downloadas'] = 'Formato predefinido da descarga';
$string['duration10h'] = '10 horas';
$string['duration10min'] = '10 minutos';
$string['duration11h'] = '11 horas';
$string['duration12h'] = '12 horas';
$string['duration15min'] = '15 minutos';
$string['duration20min'] = '20 minutos';
$string['duration2h'] = '2 horas';
$string['duration30min'] = '20 minutos';
$string['duration3h'] = '3 horas';
$string['duration45min'] = '45 minutos';
$string['duration4h'] = '4 horas';
$string['duration5h'] = '5 horas';
$string['duration5min'] = '5 minutos';
$string['duration60min'] = '60 minutos';
$string['duration6h'] = '6 horas';
$string['duration7h'] = '7 horas';
$string['duration8h'] = '8 horas';
$string['duration90min'] = '90 minutos';
$string['duration9h'] = '9 horas';
$string['enablenote'] = 'Utilizadores podem anotar';
$string['equal'] = 'igual a';
$string['err_sublimitsgreater'] = 'Soma dos sublimites é maior do que o máximo de pedidos permitido';
$string['err_timeendlower'] = 'A data de fim do evento é anterior à data de início';
$string['err_timeopengreater'] = 'A data de abertura das reserva é posterior a data de fim';
$string['eventevent'] = 'Criar um evento da disciplina desde a data de início à data de fim (o evento)';
$string['eventreminder'] = '{$a} (reservado)';
$string['eventrequestadded'] = 'Pedido de reserva adicionado';
$string['eventrequestcancelled'] = 'Pedido de reserva cancelado';
$string['eventrequestdeleted'] = 'Pedido de reserva apagado';
$string['events'] = 'Eventos no calendário';
$string['eventsettings'] = 'Configurações do evento';
$string['explainconfig'] = 'Os administradores podem definir aqui as configurações globais do módulo Marcações';
$string['fields'] = 'Mostrar os campos';
$string['fullview'] = 'Visualizar reservas apagadas';
$string['getreservation'] = 'Ver reserva';
$string['gradedmail'] = '{$a->teacher} publicou comentários na sua reserva \'{$a->reservation}\'

Pode visualizar aqui:

     {$a->url}';
$string['gradedmailhtml'] = '{$a->teacher} publicou alguns comentários na sua reserva \'<i>{$a->reservation}</i>\'<br /><br />
Pode visualizar <a href=\\"{$a->url}\\">aqui</a>.';
$string['importreservations'] = 'Importar reservas';
$string['invalidreservationid'] = 'ID de reserva inválido';
$string['justbooked'] = 'Está reservado como: {$a}';
$string['justoverbooked'] = 'Está em sobrelotação como: {$a}';
$string['linenumber'] = '#';
$string['listafterclose'] = 'lista de pedidos de reserva depois de estar fechada';
$string['listalways'] = 'lista de pedidos de reserva a qualquer momento';
$string['location'] = 'Local';
$string['locations'] = 'Gerir locais';
$string['locationslist'] = 'Lista de locais';
$string['mail'] = 'A reserva \'{$a->reservation}\' foi encerrada.

Pode descarregar a lista de reservas em:

{$ a-> url}';
$string['mailhtml'] = 'A reserva \'<em>{$a->reservation}</em>\' foi encerrada.<br /><br />
Pode descarregar <a href="{$a->url}">aqui</a> a lista de reservas.';
$string['mailrequest'] = 'A reserva \'{$a->reservation}\' foi encerrada.

Pode obter o código da reserva em:

{$ a-> url}';
$string['mailrequesthtml'] = 'A reserva \'<em>{$a->reservation}</em>\' foi encerrada.<br /><br />
Pode obter <a href="{$a->url}">aqui</a> o código da reserva.';
$string['manage'] = 'Gestão';
$string['manualusers'] = 'Na reserva manual mostrar lista de utilizadores de';
$string['maxoverbook'] = 'Percentagem Max de sobrelotação';
$string['maxrequest'] = 'Máximo de reservas';
$string['message'] = 'Mensagem aos participantes';
$string['minduration'] = 'Duração mínima do evento';
$string['modulename'] = 'Marcações';
$string['modulename_help'] = '<p>O objetivo principal desta atividade é programar sessões e teste mas pode agendar tudo o que pretender.</p><p>O professor pode definir o número de lugares disponíveis para o evento, a data do evento, a data de abertura e a data de encerramento das reservas.<br />Uma reserva pode ter uma nota ou uma escala.<br />Os alunos podem reservar, desmarcar um lugar ou adicionar observações/comentários à reserva.</p><p>Após o início do evento, o professor pode avaliar o evento. Os alunos serão notificados por correio eletrónico.</p><p>Pode descarregar a lista de reservas em vários formatos.</p>';
$string['modulenameplural'] = 'Marcações';
$string['newlocation'] = 'Novo local';
$string['noclashcheck'] = 'A verificação de sobreposições não está ativada. Por favor, contacte o administrador do site.';
$string['noclashes'] = 'Não existe sobreposição de hora e/ou local';
$string['nocourseswithnsections'] = 'Nenhuma disciplina encontrada com {$a} secções';
$string['nolimit'] = 'Sem limite de reservas';
$string['nomorerequest'] = 'Não existem mais lugares disponíveis';
$string['none'] = 'nenhuma informação acerca da reserva';
$string['nooverbook'] = 'Sem sobrelotação';
$string['noparent'] = 'Nenhum';
$string['noreservations'] = 'Não existem reservas a mostrar';
$string['note'] = 'Observações';
$string['noteachers'] = 'Nenhum professor disponível';
$string['notequal'] = 'não igual a';
$string['notifies'] = 'Notificações a enviar';
$string['notifygrades'] = 'Notificar os alunos acerca das reserva avaliadas';
$string['notifystudents'] = 'Notificar os alunos acerca das reservas encerradas';
$string['notifyteachers'] = 'Notificar os professores acerca das reservas encerradas';
$string['notopened'] = 'Não aberta';
$string['novalues'] = 'Sem valores disponíveis para este campo';
$string['number'] = 'Código da reserva';
$string['numberafterclose'] = 'o número do pedido de reserva após a reserva estar fechada';
$string['numberalways'] = 'o número do pedido de reserva a qualquer instante';
$string['optional'] = 'Opcional';
$string['otherlocation'] = 'Especificar outra localização';
$string['overbook'] = 'Sobrelotação';
$string['overbookonly'] = 'Apenas lugares sobrelotados disponíveis';
$string['overbookstep'] = 'Tamanho da sobrelotação';
$string['overview'] = 'Visão global';
$string['parent'] = 'Ligar esta reserva a';
$string['pluginadministration'] = 'Administração de Marcações';
$string['pluginname'] = 'Marcações';
$string['privacy:metadata:reservation_note'] = 'Armazena a nota do utilizador de um pedido de reserva';
$string['privacy:metadata:reservation_note:note'] = 'Nota do utilizador de um pedido de reserva';
$string['privacy:metadata:reservation_request'] = 'Armazena os dados do utilizador de um pedido de reserva';
$string['privacy:metadata:reservation_request:grade'] = 'Nota do pedido de reserva do utilizador';
$string['privacy:metadata:reservation_request:grader'] = 'ID do avaliador';
$string['privacy:metadata:reservation_request:mailed'] = 'O estado de notificação enviada com a nota';
$string['privacy:metadata:reservation_request:reservationid'] = 'ID da reserva';
$string['privacy:metadata:reservation_request:timecancelled'] = 'Data e hora do cancelamento do pedido';
$string['privacy:metadata:reservation_request:timecreated'] = 'Data e hora da criação do pedido';
$string['privacy:metadata:reservation_request:timegraded'] = 'Data e hora da avaliação do pedido';
$string['privacy:metadata:reservation_request:userid'] = 'ID do utilizador';
$string['publiclists'] = 'Lista pública de marcações';
$string['requestoverview'] = 'Visão global dos pedidos';
$string['requests'] = 'Pedidos';
$string['required'] = 'Obrigatório';
$string['reservation:addinstance'] = 'Adicionar nova instância de Marcações';
$string['reservationcancelled'] = 'Reserva cancelada';
$string['reservationclosed'] = 'Reservas encerradas';
$string['reservationdenied'] = 'Não são permitidas Marcações';
$string['reservation:downloadrequests'] = 'Pode descarregar a lista de pedidos';
$string['reservationevent'] = 'Criar um evento da disciplina desde a abertura até ao encerramento (tempo de reserva)';
$string['reservation:grade'] = 'Pode avaliar';
$string['reservation_listing'] = 'Configurações da página de índice';
$string['reservation:manualdelete'] = 'Pode apagar pedidos de outros utilizadores';
$string['reservation:manualreserve'] = 'Pode submeter pedidos para outros utilizadores';
$string['reservationnotopened'] = 'Reservas ainda não abriram';
$string['reservation_other'] = 'Outras configurações';
$string['reservation:reserve'] = 'Pode submeter os própios pedidos';
$string['reservations'] = 'Reservas';
$string['reservationsettings'] = 'Configurações das marcações';
$string['reservation_settings'] = 'Configurações da edição';
$string['reservation:uploadreservations'] = 'Pode carregar reservas';
$string['reservation_view'] = 'Configurações de visualização da página';
$string['reservation:viewnote'] = 'Pode ver as anotações dos pedidos';
$string['reservation:viewrequest'] = 'Pode ver a lista dos pedidos';
$string['reserve'] = 'Reservar';
$string['reservecancel'] = 'Cancelar reserva';
$string['reserved'] = 'Reserva efetuada';
$string['reservedon'] = 'Reservado em';
$string['reservedonconnected'] = 'Já tem marcação numa reserva ligada: {$a}';
$string['resetreservation'] = 'Apagar todas as reservas';
$string['save'] = 'Guardar a avaliação';
$string['search:activity'] = 'Marcações - informação da atividade';
$string['selectvalue'] = 'Selecione um dos valores disponíveis';
$string['showrequest'] = 'Utilizadores podem ver a lista dos pedidos';
$string['showuserrequest'] = 'Utilizadores podem visualizar';
$string['sortby'] = 'Lista de marcações ordenada por';
$string['sublimit'] = 'Sublimite {$a}';
$string['sublimitrules'] = 'Regras dos sublimites';
$string['sublimits'] = 'Sublimites das reservas';
$string['timeclose'] = 'Reservas fecham';
$string['timeend'] = 'Data de fim';
$string['timeopen'] = 'Reservas abrem';
$string['timestart'] = 'Data de início';
$string['tools'] = 'Ferramentas das marcações';
$string['upload'] = 'Carregamento de marcações';
$string['upload_help'] = '<p>As reservas podem ser carregadas através de um ficheiro de texto. O ficheiro deve ter o seguinte formato:</p><ul><li>Cada linha do ficheiro contém um registo</li><li>Cada registo é uma série de dados separados por vírgulas (ou outros delimitadores)</li><li>O primeiro registo contém uma lista de nomes de campos que definem o formato do resto do ficheiro</li><li>Os campos obrigatórios são section, name e timestart (secção, nome e data/hora de início)</li><li>Os nomes de campos opcionais são: course, intro, teachers, timeend, grade, timeopen, timeclose, maxrequest (disciplina, introdução/descrição, professores, data/hora de fim, avaliação, data/hora de abertura, data/hora encerramento, máximo de pedidos</li><li>Se a disciplina não for especificada, tem de ser escolhida após a visualização</li></ul>';
$string['uploadreservations'] = 'Carregar marcações';
$string['uploadreservationspreview'] = 'Pré-visualização do carregamento das marcações';
$string['uploadreservationsresult'] = 'Resultado do carregamento das marcações';
$string['useralreadybooked'] = 'Utilizador já reservado';
$string['userevent'] = 'Criar um evento do utilizador desde a data de início à data de fim quando faz uma reserva numa marcação';
$string['with'] = 'com';
$string['withselected'] = 'Com os selecionados...';
$string['yourgrade'] = 'A sua nota desta reserva: {$ a-> grade} / {$ a-> maxgrade}';
$string['yournote'] = 'A sua observação:';
$string['yourscale'] = 'A sua nota desta reserva: {$a}';
