<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'flashcard', language 'pt', branch 'MOODLE_36_STABLE'
 *
 * @package   flashcard
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addone'] = 'Adicionar uma nova pergunta';
$string['addthree'] = 'Adicionar três novas perguntas';
$string['answer'] = 'Respostas';
$string['answersmediatype'] = 'Tipo de media para respostas';
$string['audiostart'] = 'Iniciar sons automaticamente';
$string['autodowngrade'] = 'Ativar baixar nota automático';
$string['autodowngrade_help'] = 'Esta opção permite baixar a nota das cartas de modo automático. Um jogo é prejudicado se o aluno já não revê o jogo há algum tempo (veja as vezes abaixo). As cartas mais velhas nos conjuntos são mais difíceis de voltar ao primeiro conjunto. A taxa de desgaste depende da configuração dos vários atrasos para cada conjunto (baralho).';
$string['avgaccess'] = 'Média de toques por carta';
$string['backside'] = 'Verso';
$string['backtocourse'] = 'Voltar à disciplina';
$string['backtodecks'] = 'Voltar para a mesa de jogo';
$string['badcards'] = 'Carta(s) rejeitada(s):';
$string['bothmodels'] = 'Leitner e treino livre';
$string['bycards'] = 'Por cartas';
$string['byusers'] = 'Por utilizadores';
$string['card'] = 'Carta';
$string['cardback'] = 'Imagem do verso da carta';
$string['cardfront'] = 'Imagem da frente da carta';
$string['cardsep'] = 'Separador de cartas na importação de texto:';
$string['cardsindeck'] = 'Restante: {$a} carta(s)';
$string['cardsread'] = 'Carta(s) lida:';
$string['cardsremaining'] = 'Cartas restantes';
$string['completionallgoodenabled'] = 'O aluno deve colocar todas as cartas no último baralho para completar';
$string['completionallgoodgroup'] = 'Obrigatório conhecer todas as cartas';
$string['completionallgoodhelp'] = 'todas as cartas têm de estar no último baralho para concluir';
$string['completionallviewed'] = 'O aluno deve visualizar todas as cartas uma vez ou pelo menos alguma quantidade delas (cartas):';
$string['completionallviewedgroup'] = 'Necessário visualizar todas as cartas';
$string['completiondiscussionshelp'] = 'todas as cartas têm de ser vistas pelo menos uma vez';
$string['confirm'] = 'Confirmar:';
$string['counters'] = 'Contadores';
$string['crontask'] = 'Tarefa cron do Flashcard';
$string['customisationfiles'] = 'Ficheiros de personalização da carta';
$string['deck'] = 'Baralho';
$string['deck1_delay'] = 'Atraso no arranque da revisão (baralho 1)';
$string['deck2_delay'] = 'Atraso no arranque da revisão (baralho 2)';
$string['deck2_release'] = 'Tempo extra (baralho 2)';
$string['deck3_delay'] = 'Atraso no arranque da revisão (baralho 3)';
$string['deck3_release'] = 'Tempo extra (baralho 3';
$string['deck4_delay'] = 'Atraso no arranque da revisão (baralho 4)';
$string['deck4_release'] = 'Tempo extra (baralho 4)';
$string['deck_delay'] = 'Arranque da revisão';
$string['deck_delay_help'] = 'Tempo ajustável, em horas, para que o conjunto fique marcado para ser revisto.';
$string['deck_release'] = 'Baixar automaticamente';
$string['deck_release_help'] = 'Tempo em horas após o qual as cartas voltam para o baralho superior. Cada baralho pode ser configurado de forma diferente.';
$string['decks'] = 'Baralhos';
$string['decks_help'] = 'Permite escolher 2, 3 ou 4 baralhos.

Normalmente, o sistema Leitner usa 3 baralhos. O uso de 4 baralhos amplia o ciclo de memorização para que cartas mais difíceis ou conjuntos maiores de cartas possam ser aprendidas. O uso de 2 baralhos será conveniente para conjuntos fáceis ou conjuntos de tamanho pequeno.';
$string['deckstates'] = 'Estado do baralho';
$string['deleteselected'] = 'Apagar cartas selecionadas';
$string['deleteselection'] = 'Apagar seleção';
$string['difficultcards'] = 'Difícil';
$string['easycards'] = 'Fácil';
$string['edit'] = 'Editar cartas';
$string['editingcards1'] = 'Editar Flashcard';
$string['editingcards2'] = 'Editar Flashcard';
$string['emptydeck'] = 'Imagem de baralho vazio';
$string['emptyset'] = 'Conjunto de cartas está vazio';
$string['endtime'] = 'Fim do tempo';
$string['erroraddcard'] = 'Não foi possível adicionar uma carta ao baralho';
$string['errorbindcard'] = 'Não foi possível vincular a carta ao baralho do utilizador {$a}';
$string['errordeletecard'] = 'Não foi possível apagar uma carta do baralho';
$string['errorupdatecard'] = 'Não foi possível atualizar uma carta do baralho';
$string['extracss'] = 'CSS extra';
$string['fieldsep'] = 'Separador dos campos:';
$string['flashcard:addinstance'] = 'Adicionar um Flascard';
$string['flashcard:canplayfree'] = 'Jogar gratuitamente';
$string['flashcard:manage'] = 'Gerir as cartas';
$string['flashcardneedsreview'] = 'Flashcard precisa de revisão';
$string['flipdeck'] = 'Inverter respostas e perguntas';
$string['flipdeck_help'] = 'Esta opção permite inverter as cartas. Se ativar esta opção, as perguntas serão escritas na parte traseira das cartas como se fossem respostas e vice-versa.';
$string['forcereload'] = 'Forçar recarregamento a partir da pergunta';
$string['forcereload_help'] = 'Forçar recarregamento das cartas

Ao assinalar esta caixa de seleção forçará o conjunto de cartas a ser recarregado com os dados da pergunta correspondente escolhida.

Todos os dados de utilizador gravados anteriormente serão excluídos e todas as contas serão redefinidas.';
$string['freegame'] = 'Jogo gratuito';
$string['freeplayinstructions'] = 'Considere cada carta no baralho. Se acha que sabe o significado do termo apresentado, clique nele para virar o carta e verifique a sua resposta. Se compreendeu, clique em "Remover carta" para retirá-la do baralho. Se não sabe a resposta ou está incorreta, vá para a próxima carta. Quando passar por todas as cartas, reveja o material de estudo da disciplina para obter informações sobre os termos que não conhece e experimente estas cartas novamente.';
$string['freeuse'] = 'Treino livre';
$string['frontside'] = 'Frente';
$string['goodcards'] = 'Cartas válidas:';
$string['havetologin'] = 'Precisa de estar autenticado antes de poder enviar a sua escolha';
$string['ifailed'] = 'Falhei!';
$string['igotit'] = 'Acertei!';
$string['image'] = 'imagem';
$string['imageplussound'] = 'imagem + som';
$string['import'] = 'Importar';
$string['importadvice'] = 'Ao importar um novo conjunto de cartas, removerá todas as cartas antigas, juntamente com as informações sobre as jogadas do utilizador';
$string['imported'] = 'Importar:';
$string['import_help'] = 'Pode importar vários pares de perguntas/respostas num Flashcard usando o recurso de importação em massa de cartas. (A importação só pode ser usada para os Flashcards de Texto/Texto.)

Só precisa de um ficheiro com uma lista de pares perguntas/respostas e colar o conteúdo deste ficheiro na área de texto do importador.
Pode decidir codificar este ficheiro com alguns tipos de separadores comuns, em Linux ou Sistemas Windows. O mais comum pode ser "um par por linha", usando \':\' ou vírgula para separar as perguntas das respostas.

As perguntas serão as primeiras e DEVEM ter sempre a respetiva resposta. Linhas vazias ou linhas pretas serão ignoradas, assim como todas as que começam por um # ou uma barra (/).

O importador fará uma verificação rápida do texto que deseja importar. Rejeitará a importação se a sequência de texto não estiver bem formatada e irá dizer-lhe quantos pares estão errados no ficheiro.

Como o resultado de uma importação bem sucedida irá apagar todos os dados dos baralhos assim como a informação referente aos participantes, uma caixa de verificação precisa de ser assinalada para confirmar e forçar a execução da importação.';
$string['importingcards'] = 'Importar cartas';
$string['importreport'] = '<b>Flashcard importou novas cartas:</b>';
$string['instructions'] = 'Clique no baralho para virar e ver o outro lado';
$string['lastaccessed'] = 'Último acesso';
$string['leitner'] = 'Treino Leitner';
$string['leitnergame'] = 'Jogo Leitner';
$string['matchingquestion'] = 'Pergunta correspondente da base de dados de perguntas';
$string['maxaccess'] = 'Mais vistos';
$string['mediatypes'] = 'Tipo de media';
$string['mediatypes_help'] = 'Esta lista define o tipo de media usado para perguntas.

* Texto: O texto inserido está literalmente impresso nos cartões
* Imagem: O texto inserido é a localização de um ficheiro de imagem no servidor, retirado dos ficheiros da disciplina.
* Som: O texto inserido é o local de um ficheiro de som no servidor, retirado dos ficheiros da disciplina.';
$string['mediumeffortcards'] = 'Esforço médio';
$string['minaccess'] = 'Menos vistos';
$string['missingimage'] = '{ficheiro de imagem em falta}';
$string['missingsound'] = '{ficheiro de som em falta}';
$string['missingvid'] = '{ficheiro de vídeo em falta}';
$string['models'] = 'Jogabilidade';
$string['models_help'] = 'Ativar ou desativar modelos de jogabilidade';
$string['modulename'] = 'Flashcard';
$string['modulename_help'] = '<p>
Este módulo fornece aos alunos uma maneira fácil e rápida de memorizar uma lista de "coisas". É um exercício típico de indexação, onde muitas coisas acopladas têm de ser aprendidas e retidas. Dizemos "coisas" porque qualquer chave ou valor pode ser um texto, imagem ou som relacionado.
</p>
<p>
Este módulo implementa um completo sistema Leitner para suportar "mecanicamente" o processo de memorização dos relacionados. Os conjuntos a serem aprendidos são primeiro anexados a um baralho de cartas. Inicialmente são considerados como difícil de aprender. O professor pode escolher uma curva de aprendizagem usando 2, 3 ou 4 baralhos.
Devem ser usados 4 baralhos para conjuntos com grande número de definições.
Quando o aluno falha ao responder a uma carta, será informado e deixará a carta permanecer no mesmo baralho. Se indicar a resposta correta, ele pedirá para passar a carta para o segundo baralho, considerado como menos difícil de aprender. O processo é repetido para todos os baralhos até ao último onde a carta permanecerá. Os baralhos são desencadeadas para que o aluno saiba qual deve ser reavaliado. Cartas difíceis irão desencadear mais vezes as cartas triviais. Os atrasos do arranque são ajustáveis.
</p>
<p>
Quando um aluno não se inscreve para rever os baralhos, as cartas podem baixar automaticamente para um baralho de maior dificuldade.
</p>
<p>
O módulo permite também o uso gratuito das cartas, ativado pela configuração do módulo. O módulo é personalizável graficamente usando um CSS definido pelo professor e um conjunto de imagens.
</p>';
$string['modulenameplural'] = 'Flashcards';
$string['next'] = 'Próxima carta';
$string['nocards'] = 'Sem cartas definidas.';
$string['noflashcards'] = 'Não existem flashcards nesta disciplina.';
$string['nomorecards'] = 'Não existem mais cartas.';
$string['nosubquestions'] = 'Erro: Faltam sub-perguntas para esta pergunta!';
$string['notifications'] = 'Notificações';
$string['notify_review_html_tpl'] = '<p>Olá <%%FULLNAME%%></p>

<p>Uma atividade Flashcard requer a sua atenção. Existem algumas cartas para rever na disciplina<%%COURSE%%>:</b> : </p>

<a href="<%%URL%%>"><%%URL%%></a>';
$string['notify_review_tpl'] = 'Olá <%%FULLNAME%%>

Uma atividade Flashcard requer a sua atenção. Tem algumas cartas para rever na disciplina<%%COURSE%%>:

<%%URL%%>';
$string['notinitialized'] = 'O aluno nunca usou este Flashcard';
$string['nousers'] = 'Não existem alunos na disciplina.';
$string['num'] = 'N°';
$string['numericrequired'] = 'É obrigatório ser um número.';
$string['outoftimerange'] = 'Este módulo está fechado por um período de tempo. De momento, não pode usá-lo.';
$string['playwithme'] = 'Aprender com este baralho';
$string['pluginadministration'] = 'Administração de Flashcard';
$string['pluginname'] = 'Flashcard';
$string['previous'] = 'Carta anterior';
$string['privacy:metadata:flashcard_card'] = 'Guarda o conteúdo do baralho do utilizador';
$string['privacy:metadata:flashcard_card:entryid'] = 'O ID da carta no baralho';
$string['privacy:metadata:flashcard_card:flashcardid'] = 'O ID do Flashcard';
$string['privacy:metadata:flashcard_card:lastaccessed'] = 'a data/hora em que a entrada da carta foi acedida pela última vez por este utilizador';
$string['privacy:metadata:flashcard_card:userid'] = 'O ID do utilizador que utiliza as cartas';
$string['privacy:metadata:flashcard_userdeck_state'] = 'Guarda os estados do baralho relativamente ao requerimento do utilizador';
$string['privacy:metadata:flashcard_userdeck_state:deck'] = 'O estado do baralho é para';
$string['privacy:metadata:flashcard_userdeck_state:flashcardid'] = 'O ID do Flashcard';
$string['privacy:metadata:flashcard_userdeck_state:state'] = 'O estado do baralho';
$string['privacy:metadata:flashcard_userdeck_state:userid'] = 'O ID do utilizador que utiliza as cartas';
$string['question'] = 'Perguntas';
$string['questionid'] = 'Pergunta a importar';
$string['questionsmediatype'] = 'Tipo de media para perguntas';
$string['reinforce'] = 'Rever este baralho';
$string['remindusers'] = 'Lembrar utilizadores';
$string['removecard'] = 'Remover carta';
$string['reset'] = 'Repor conjunto de cartas';
$string['resetflashcardstates'] = 'Repor todos os estados do Flashcard';
$string['reviewback'] = 'Imagem do baralho das cartas a rever';
$string['reviewedback'] = 'Imagem do baralho das cartas revistas';
$string['reviewedempty'] = 'Imagem do baralho vazio das cartas revistas';
$string['sound'] = 'som';
$string['sourcequestion'] = 'Pergunta a importar';
$string['sourcequestion_help'] = 'Escolha uma questão como fonte.

Pode configurar rapidamente um baralho a partir de uma pergunta correspondente da base de dados de perguntas. Para prosseguir, escolha uma pergunta da lista e marque a caixa de seleção "Forçar atualização". Todas as cartas anteriores serão apagados e o Fashcard será recarregado com os dados da pergunta.

Aviso: alterar cartas usando o editor de cartões NÃO alterará o conteúdo da pergunta na base de dados de perguntas.';
$string['starttime'] = 'Hora de início';
$string['stylesheet'] = 'Obter a folha de estilos';
$string['styling'] = 'Personalização';
$string['sumaccess'] = 'Total de cartas vistas';
$string['summary'] = 'Resumo do Flashcard';
$string['teachersummary'] = 'Sumário';
$string['text'] = 'texto';
$string['timetoreview'] = '{$a} dia(s) para a revisão';
$string['trivialcards'] = 'Cartas triviais';
$string['undefinedquestionset'] = 'Nenhuma pergunta correspondente foi eleita em testes para este conjunto de Flashcard';
$string['userdecks'] = 'Baralhos do utilizador';
$string['userdecksummary'] = 'Baralho {$a->deckid}: {$a->count} cartas ({$a->cardcount} acertos no total do baralho)';
$string['video'] = 'Vídeo';
$string['viewed'] = 'Visualizações';
