<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'block_course_checker', language 'pt', branch 'MOODLE_36_STABLE'
 *
 * @package   block_course_checker
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['admin_domain_list_notvalid'] = 'A lista não é uma lista de domínios válida';
$string['admin_domain_name_default_missing'] = 'Nome do domínio em falta: {$a}';
$string['admin_domain_name_notvalid'] = 'Nome de domínio inválido: {$a}. Adicione apenas um nome de domínio por linha';
$string['admin_restrictedint_max'] = 'O valor máximo é {$a}';
$string['admin_restrictedint_min'] = 'O valor mínimo é {$a}';
$string['attendance_missingattendanceactivity'] = 'Falha na verificação da assiduidade - não existe a atividade Assiduidade nesta disciplina';
$string['attendance_missingplugin'] = 'Ignorar esta verificação porque \'mod_attendance\' não está instalado';
$string['attendance_onlyoneattendenceactivityallowed'] = 'Falha na verificação da assiduidade - apenas é permitida uma atividade Assiduidade';
$string['attendance_sessionsnotemty'] = 'Falha na verificação da assiduidade - não é permitido ter assiduidade das sessões';
$string['attendance_success'] = 'A atividade Assiduidade está configurada corretamente';
$string['automaticcheck'] = 'Última verificação automática';
$string['automaticcheckempty'] = 'Nunca foram efetuadas verificações nesta disciplina';
$string['backtocourse'] = 'Voltar à disciplina';
$string['checker_attendance'] = 'Verificação da assiduidade das sessões';
$string['checker_attendance_display'] = 'Assiduidade das sessões';
$string['checker_col_block_header'] = 'Verificação';
$string['checker_groups'] = 'Verificação da submissão em grupo';
$string['checker_groups_display'] = 'Submissão de trabalhos em grupo';
$string['checker_last_run'] = 'Última execução: {$a}';
$string['checker_last_run_global'] = 'Data desconhecida para este verificador. A verificação global da disciplina foi em {$a}';
$string['checker_link_activity'] = 'Atividade: {$a->name}  ({$a->modname})';
$string['checker_link_display'] = 'Hiperligações na descrição da disciplina e atividades URL';
$string['checker_link_error_code'] = 'Erro HTTP: \'{$a->http_code}\' em {$a->url}';
$string['checker_link_error_curl'] = 'Erro cURL: \'{$a->curl_errno} {$a->curl_error}\' em {$a->url}';
$string['checker_link_error_skipped'] = 'O domínio {$a->host} está na lista branca de {$a->url}';
$string['checker_link_error_undefined'] = 'Ocorreu um erro indefinido com a hiperligação';
$string['checker_link_ok'] = '{$a->url} é válido (Código {$a->http_code})';
$string['checker_link_setting_connect_timeout'] = 'Tempo limite da ligação cURL';
$string['checker_link_setting_timeout'] = 'Tempo limite cURL';
$string['checker_link_setting_whitelist'] = 'Lista branca do verificador de hiperligações';
$string['checker_link_summary'] = 'Descrição da disciplina';
$string['checker_referencesettings'] = 'Verificação das configurações de referência';
$string['checker_referencesettings_checklist'] = 'Lista de configurações para verificação com a disciplina de referência';
$string['checker_referencesettings_checklist_help'] = 'Selecione uma ou várias configurações para verificar com a disciplina de referência.';
$string['checker_referencesettings_comparison'] = ' (Disciplina de referência: "{$a->settingvaluereference}" | Disciplina atual: "{$a->settingvaluecurrent}")';
$string['checker_referencesettings_display'] = 'Configurações comparadas com disciplina de referência';
$string['checker_referencesettings_failing'] = 'A configuração "{$a->setting}" não está correta';
$string['checker_referencesettings_settingismissing'] = 'A configuração "{$a->setting}" não é uma configuração da disciplina';
$string['checker_referencesettings_success'] = 'A configuração "{$a->setting}" está correta';
$string['checker_subheadings'] = 'Verificação dos subtítulos dos separadores';
$string['checker_subheadings_display'] = 'Subtítulos dos separadores';
$string['checker_subheadings_setting_whitelist'] = 'Lista branca de strings na verificação de subtítulos';
$string['checker_subheadings_setting_whitelist_help'] = 'Adicione uma string por linha. Por exemplo: "Liebe (r) Module developer".';
$string['check_failed'] = 'Erro';
$string['check_successful'] = 'Sucesso';
$string['course_checker:addinstance'] = 'Adicionar um novo o bloco Verificações da disciplina';
$string['course_checker:view'] = 'Ver o bloco Verificações da disciplina';
$string['course_checker:view_notification'] = 'Ver notificações do bloco Verificações da disciplina';
$string['course_checker:view_report'] = 'Mostrar a página dos resultados da verificação';
$string['group_activities'] = 'Configurações da atividade';
$string['group_course_settings'] = 'Configurações da disciplina';
$string['group_links'] = 'Validação de hiperligações';
$string['groups_activity'] = 'Atividade: "{$a->name}"';
$string['groups_deactivated'] = 'A configuração da submissão em grupo está desativada';
$string['groups_idmissing'] = 'A submissão em grupo está ativa, mas não está definido qualquer agrupamento';
$string['groups_lessthantwogroups'] = 'Foram definidos menos de 2 grupos para o agrupamento ativo';
$string['groups_missing'] = 'O agrupamento não foi configurado corretamente';
$string['groups_success'] = 'A configuração de submissão em grupo está bem definida';
$string['humancheck'] = 'Última verificação manual:';
$string['humancheck_comment_placeholder'] = 'Observação';
$string['humancheckempty'] = 'Esta disciplica nunca foi verificada manualmente';
$string['humancheck_reason'] = 'Razão:';
$string['humancheck_title'] = 'Defina a data da verificação manual:';
$string['humancheck_update'] = 'Atualizar revisão humana';
$string['invalidtoken'] = 'O token é inválido';
$string['lastactivityedition'] = 'Última alteração da atividade';
$string['link'] = 'Hiperligação';
$string['link_col_page_header'] = 'Hiperligação para resolução';
$string['message'] = 'Mensagem';
$string['message_col_page_header'] = 'Mensagem';
$string['messageprovider_allchecks_completed'] = 'As verificações estão concluídas.';
$string['messageprovider_allchecks_subject'] = 'As verificações na disciplina \'{$a->coursename}\' estão concluídas';
$string['messageprovider:checker_completed'] = 'A verificação da disciplina está concluída';
$string['messageprovider_result_html'] = 'Pode ver o resultado na {$a->urlhtml}';
$string['messageprovider_result_html_label'] = 'página de resultados dedicada';
$string['messageprovider_result_plain'] = 'Pode ver o resultado na {$a->url}';
$string['messageprovider_singlechecks_completed'] = 'A verificação \'{$a->checkername}\' está concluída.';
$string['messageprovider_singlechecks_subject'] = 'O verificador {$a->checkername} está concluído na disciplina {$a->coursename}';
$string['nogroupresults'] = 'Nada para verificar. Tudo está bem!';
$string['noresults'] = 'Esta disciplina nunca foi verificada automaticamente';
$string['pluginname'] = 'Verificações da disciplina';
$string['privacy:metadata'] = 'O bloco Verificações da disciplina contém apenas dados anónimos.';
$string['rerun_col_block_header'] = 'Executar novamente';
$string['rerun_disabled_col_block_header'] = 'Esta verificação já está programada para ser executada novamente';
$string['resolutionlink'] = 'Resolução:';
$string['result'] = 'Resultado';
$string['result_checker_disabled'] = 'Este verificador foi desativado pelo administrador.';
$string['result_col_block_header'] = 'Resultado';
$string['result_col_page_header'] = 'Resultado';
$string['result_last_activity_empty'] = 'Nenhuma atividade modificada desde {$a}';
$string['result_last_activity_header'] = 'Últimas atividades modificadas';
$string['result_last_activity_header_date'] = 'Últimas atividades modificadas desde {$a}';
$string['resultpagegoto'] = 'Visualizar os resultados detalhados';
$string['resultpageheader'] = 'Visualizar os resultados detalhados';
$string['resultpagetitle'] = 'Visualizar os resultados detalhados da disciplina \'{$a->name}\'';
$string['resultpermissiondenied'] = 'Não tem permissão para aceder a esta página';
$string['runcheckbtn'] = 'Verificar esta disciplina';
$string['runcheckbtn_already'] = 'Esta disciplina já está programada para ser verificada automaticamente.';
$string['runcheckbtn_nocheckers'] = 'Não existem verificadores ativos.';
$string['settings_checker_dependency'] = '<div class="alert alert-warning">Ocorreu um erro na verificação da dependência. Verifique se o módulo \'<a href="/admin/modules.php" target="_blank">{$a}</a>\' está instalado e ativo.</div>';
$string['settings_checker_header'] = 'Configurações de \'{$a}\'';
$string['settings_checker_hide'] = '{$a} (oculto)';
$string['settings_checker_toggle'] = '{$a}';
$string['settings_general'] = '<p>Se o verificador estiver desativado (após guardar as alterações), será mostrada abaixo uma nova configuração para ocultar e mostrar os resultados de cada verificador.</p>';
$string['settings_referencecourseid'] = 'ID da disciplina de referência';
$string['subheadings_generalerror'] = 'Ocorreu um erro ao executar esta verificação';
$string['subheadings_iconmissing'] = 'Está em falta o ícone na primeira tag html';
$string['subheadings_labelignored'] = 'Este separador é ignorado devido à lista branca na configuração do módulo.';
$string['subheadings_success'] = 'Este separador tem um subtítulo e um ícone corretos';
$string['subheadings_wrongfirsthtmltag'] = 'A primeira tag html não é um {$a->htmltag}';
