<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'atto_styles', language 'pt', branch 'MOODLE_36_STABLE'
 *
 * @package   atto_styles
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['config'] = 'Configuração de Estilos';
$string['config_desc'] = 'Configuração da ferramenta Estilos para Atto no formato JSON.
<hr />
Por exemplo:<br />
{<br />
    "title": "Caixa azul",<br />
    "type": "block",<br />
    "classes": "red"<br />
    "preview": true<br />
},{<br />
    "title": "Texto a vermelho",<br />
    "type": "inline",<br />
    "classes": "red"<br />
    "preview": true<br />
}<br />
<hr />
O atributo <em>title</em> (título) define o nome do estilo na ferramenta Estilos para Atto.<br />
<br />
O título também pode suportar o filtro \'Conteúdos multilingue\' do Moodle (se ativado), mas as aspas duplas adicionais precisam de ser acompanhadas com uma barra invertida.<br />
Consulte o ficheiro README do módulo para ver um exemplo.<br />
<hr />
O atributo <em>type</em> (tipo) pode ser um dos dois valores: "block" (bloco) ou "inline".<br />
<br />
"block" criará uma tag div com as classes fornecidas e atuará como um elemento de nível de bloco. Assumirá o elemento de nível de bloco atual e poderá ser aplicado em mais elementos do que o texto atualmente selecionado.<br />
<br />
"inline" criará uma tag span com as classes fornecidas e atuará como um elemento inline. Só é aplicado ao texto atualmente selecionado.
<hr />
O atributo <em>classes</em> usa o nome da classe CSS que será aplicada ao texto inline/bloco.<br />
<br />
Podem ser definidas várias classes para cada item, separadas por um espaço. Serão todas aplicadas ao texto inline/bloco.<br />
<br />
As definições da classe CSS não podem ser feitas dentro do módulo. Terá que adicionar as suas definições da classe CSS ao tema ou nas configurações HTML adicionais do Moodle.
<hr />
O atributo <em>preview</em> (pré-visualização) aceita os valores booleanos true ou false (predefinido). Se for definido como true, o item de estilo mostrará uma visualização real do estilo. Caso contrário, o item de estilo mostrará apenas o título em texto simples.<br />
<br />
Tenha em atenção que, se optar por mostrar a visualização de um item de estilo, esta classe precisa de ser definida no CSS para que possa ser aplicada a tags span, mesmo que o próprio item de estilo seja um elemento de nível de bloco.
<hr />
Em instalações Moodle com temas baseados em bootstrap (especialmente <em>Boost</em>, <em>More</em> e <em>Clean</em>, também é possível criar estilos com classes CSS do bootstrap em vez de definir as suas próprias classes.
<br /><br />
Por exemplo:<br />
{<br />
    "title": "Felicitação de êxito",<br />
    "type": "block",<br />
    "classes": "alert alert-success"<br />
},{<br />
    "title": "Informação do emblema",<br />
    "type": "inline",<br />
    "classes": "badge badge-info"<br />
},{<br />
    "title": "Sinal de aviso",<br />
    "type": "inline",<br />
    "classes": "badge badge-warning"<br />
}<br /><br />
Para mais informações sobre classes do bootstrap, visite os seguintes links na documentação do Bootstrap 2.3 (para <em>Clean</em> e <em>More</em>):
<ul>
<li><a href="http://getbootstrap.com/2.3.2/components.html#labels-badges">Etiquetas e Emblemas</a></li>
<li><a href="http://getbootstrap.com/2.3.2/components.html#alerts">Mensagens Bootstrap</a></li>
<li><a href="http://getbootstrap.com/2.3.2/components.html#misc">Classes de ajuda Bootstrap</a></li>
</ul>
ou na documentação do Bootstrap 4 (para <em>Boost</em>):
<ul>
<li><a href="http://v4-alpha.getbootstrap.com/components/badge/">Emblemas Bootstrap</a></li>
<li><a href="http://v4-alpha.getbootstrap.com/components/alerts/">Mensagens Bootstrap</a></li>
<li><a href="http://v4-alpha.getbootstrap.com/utilities/">Bootstrap utilities</a></li>
</ul>';
$string['inlinehint'] = 'Tem de selecionar texto para aplicar este estilo';
$string['nostyle'] = 'Sem estilo';
$string['pluginname'] = 'Estilos';
$string['privacy:metadata'] = 'O módulo Estilos para Atto não armazena quaisquer dados pessoais.';
$string['settings'] = 'Definições de Estilos';
