<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'forum', language 'it', branch 'MOODLE_36_STABLE'
 *
 * @package   forum
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityoverview'] = 'Ci sono nuovi interventi nei forum';
$string['addanewdiscussion'] = 'Aggiungi un argomento di discussione';
$string['addanewquestion'] = 'Aggiungi nuova domanda';
$string['addanewtopic'] = 'Aggiungi nuovo argomento';
$string['advancedsearch'] = 'Ricerca avanzata';
$string['allforums'] = 'Tutti i forum';
$string['allowdiscussions'] = 'Ad un {$a} è consentito di intervenire in questo forum?';
$string['allowsallsubscribe'] = 'Questo forum è a sottoscrizione facoltativa';
$string['allowsdiscussions'] = 'Il forum consente a tutti i partecipati di iniziare una nuova discussione.';
$string['allsubscribe'] = 'Sottoscrivi tutti i forum';
$string['allunsubscribe'] = 'Revoca la sottoscrizione da tutti i forum';
$string['alreadyfirstpost'] = 'Questo è già il primo intervento della discussione';
$string['anyfile'] = 'Qualsiasi file';
$string['areaattachment'] = 'Allegati';
$string['areapost'] = 'Messaggi';
$string['attachment'] = 'Allegato';
$string['attachment_help'] = 'Ad ogni intervento nel forum possono essere allegati uno o più file. Se l\'allegato è una immagine, verrà visualizzata di seguito al testo dell\'intervento. ';
$string['attachmentnopost'] = 'Non puoi esportare allegati senza specificare l\'id dell\'intervento';
$string['attachments'] = 'Allegati';
$string['attachmentswordcount'] = 'Allegati e conteggio parole';
$string['blockafter'] = 'Soglia massima interventi';
$string['blockafter_help'] = 'Il numero massimo di interventi che uno studente può effettuare in un dato intervallo di tempo. Gli utenti con il privilegio mod/forum:postwithoutthrottling non sono influenzati da questa impostazione.';
$string['blockperiod'] = 'Intervallo di controllo';
$string['blockperioddisabled'] = 'Nessun intervallo di controllo';
$string['blockperiod_help'] = 'Nell\'intervallo di tempo stabilito gli utenti non potranno oltrepassare un dato numero di interventi. Gli utenti con il privilegio mod/forum:postwithoutthrottling non sono influenzati da questa impostazione.';
$string['blogforum'] = 'Forum standard visualizzato in stile blog';
$string['bynameondate'] = 'di {$a->name} - {$a->date}';
$string['cannotadd'] = 'La discussione non può essere aggiunta in questo forum';
$string['cannotadddiscussion'] = 'Per aggiungere discussioni in questo forum è necessario appartenere ad un gruppo.';
$string['cannotadddiscussionall'] = 'Non hai il permesso per aggiungere un argomento di discussione per tutti i partecipanti.';
$string['cannotadddiscussiongroup'] = 'Non puoi creare discussioni perché non sei membro di nessun gruppo.';
$string['cannotaddsubscriber'] = 'Non è stato attivare la sottoscrizione al forum per l\'utente con id {$a}!';
$string['cannotaddteacherforumto'] = 'Non è stato possibile aggiungere il forum teacher con il tipo già cambiato nella sezione 0 del corso';
$string['cannotcreatediscussion'] = 'Non è stato possibile creare una nuova discussione';
$string['cannotcreateinstanceforteacher'] = 'Non è stato possibile creare una nuova istanza del forum docenti';
$string['cannotdeletepost'] = 'Questo intervento non può essere eliminato!';
$string['cannoteditposts'] = 'Interventi di altri non possono essere modificati!';
$string['cannotfinddiscussion'] = 'Non è stato possibile trovare la discussione in questo forum';
$string['cannotfindfirstpost'] = 'Non è stato possibile trovare il primo intervento di questo forum';
$string['cannotfindorcreateforum'] = 'Non è stato possibile trovare o creare un forum annunci per il sito';
$string['cannotfindparentpost'] = 'Non è stato possibile trovare l\'intervento iniziale associato all\'intervento {$a}';
$string['cannotmovefromsingleforum'] = 'Una discussione non può essere spostata da un forum monotematico';
$string['cannotmovenotvisible'] = 'Forum non visibile';
$string['cannotmovetonotexist'] = 'Non possono essere effettuati spostamenti verso questo forum - non esiste!';
$string['cannotmovetonotfound'] = 'Il forum di destinazione non è stato trovato in questo corso.';
$string['cannotmovetosingleforum'] = 'Non è possibile spostare la discussione in un forum monotematico';
$string['cannotpurgecachedrss'] = 'Non è stato possibile ripulire i feed RSS presenti in cache per i forum sorgente e/o destinazione - verificate i vostri permessi sui file';
$string['cannotremovesubscriber'] = 'Non è stato possibile rimuovere da questo forum l\'utente con id {$a} !';
$string['cannotreply'] = 'Non puoi rispondere a questo intervento';
$string['cannotsplit'] = 'Le discussioni non possono essere spostate da questo forum';
$string['cannotsubscribe'] = 'Spiacente, devi appartenere ad un gruppo per sottoscrivere.';
$string['cannottrack'] = 'Non è stato possibile interrompere la visualizzazione dei messaggi non letti';
$string['cannotunsubscribe'] = 'Non è stato possibile revocare la sottoscrizione dal  forum';
$string['cannotupdatepost'] = 'Non puoi modificare questo intervento';
$string['cannotviewpostyet'] = 'Non puoi leggere le domande degli altri studenti in questa discussione perché non hai ancora effettuato interventi';
$string['cannotviewusersposts'] = 'Non ci sono interventi di questo utente che tu possa visualizzare.';
$string['cleanreadtime'] = 'Ora per spuntare come letti i messaggi vecchi';
$string['clicktosubscribe'] = 'Non hai sottoscritto questa discussione, Click per sottoscriverla.';
$string['clicktounsubscribe'] = 'Hai sottoscritto la discussione. Click per revocare la sottoscrizione.';
$string['completiondiscussions'] = 'Lo studente deve avviare il seguente numero di discussioni:';
$string['completiondiscussionsdesc'] = 'Lo studente deve avviare almeno il seguente numero di discussioni: {$a}';
$string['completiondiscussionsgroup'] = 'Numero minimo discussioni';
$string['completiondiscussionshelp'] = 'è necessario un numero minimo di discussioni';
$string['completionposts'] = 'Lo studente deve effettuare il seguente numero di discussioni o interventi:';
$string['completionpostsdesc'] = 'Lo studente deve effettuare almeno {$a} discussioni o interventi';
$string['completionpostsgroup'] = 'Numero minimo interventi';
$string['completionpostshelp'] = 'è necessario un numero minimo di discussioni o di interventi';
$string['completionreplies'] = 'Lo studente deve effettuare il seguente numero di interventi:';
$string['completionrepliesdesc'] = 'Lo studente deve effettuare almeno {$a} interventi';
$string['completionrepliesgroup'] = 'Numero minimo risposte';
$string['completionreplieshelp'] = 'è necessario un numero minimo di interventi';
$string['configcleanreadtime'] = 'L\'ora del giorno in cui la tabella \'lettura\' vien ripulita dai messaggi vecchi.';
$string['configdigestmailtime'] = 'Agli utenti che hanno scelto di ricevere gli interventi dei forum tramite raccolta, verrà inviata giornalmente un\'email contenente tutti i nuovi messaggi. L\'impostazione regola l\'ora di invio della raccolta, che sarà spedita con il cron successivo all\'ora impostata.';
$string['configdisplaymode'] = 'La modalità di default per  visualizzare le discussioni.';
$string['configenablerssfeeds'] = 'Questa opzione abilita l\'utilizzo dei feed RSS per tutti i forum. I singoli feed devono comunque essere attivati manualmente, nelle impostazioni di ogni forum.';
$string['configenabletimedposts'] = 'Imposta a \'Si\' per consentire l\'impostazione del tempo di visualizzazione quando si inserisce una nuova discussione in un forum.';
$string['configlongpost'] = 'Gli interventi che superano il numero di caratteri specificato (escludendo i tag HTML) saranno considerati "lunghi".';
$string['configmanydiscussions'] = 'Numero massimo di discussioni visualizzabili nella stessa pagina';
$string['configmaxattachments'] = 'Valore di default del numero massimo di allegati consentiti per ogni intervento.';
$string['configmaxbytes'] = 'Dimensione massima degli allegati per tutti i forum del sito (il valore è anche soggetto a limitazioni imposte a livello di corso e ad altre impostazioni locali)';
$string['configoldpostdays'] = 'Numero di giorni trascorsi i quali tutti i messaggi vecchi verranno considerati come letti.';
$string['configreplytouser'] = 'Nelle email inviate dai forum, di default compare in chiaro l\'email del mittente. In questo modo sarà possibile rispondere direttamente anche senza intervenire nel forum. Indipendentemente da questa impostazione un utente può comunque mantenere riservato il proprio indirizzo email usando l\'apposita impostazione presente nel profilo utente.';
$string['configrssarticlesdefault'] = 'Imposta il numero di default di articoli (interventi o discussioni) quando i feed RSS sono abilitati.';
$string['configrsstypedefault'] = 'Imposta il tipo di attività di default quando i feed RSS sono abilitati.';
$string['configshortpost'] = 'Gli interventi al di sotto del numero di caratteri specificato (escludendo i tag HTML) saranno considerati "brevi".';
$string['configsubscriptiontype'] = 'Impostazioni di default della sottoscrizione';
$string['configtrackingtype'] = 'Il tipo di evidenziamento dei messaggi di default.';
$string['configtrackreadposts'] = 'Impostare a \'Si\' se si desidera tracciare lo stato "letto/non letto" per ciascun utente.';
$string['configusermarksread'] = 'Con "Si", l\'utente deve spuntare manualmente un intervento come "letto". Con "No", l\'intervento viene automaticamente considerato "letto" all\'atto della visualizzazione.';
$string['confirmsubscribe'] = 'Vuoi sottoscrivere il forum \'{$a}\'?';
$string['confirmsubscribediscussion'] = 'Sei sicuro di sottoscrivere la discussione \'{$a->discussion}\' del forum  \'{$a->forum}\'?';
$string['confirmunsubscribe'] = 'Vuoi revocare la sottoscrizione del forum \'{$a}\'?';
$string['confirmunsubscribediscussion'] = 'Sei sicuro di revocare la sottoscrizione della discussione \'{$a->discussion}\' del forum  \'{$a->forum}\'?';
$string['couldnotadd'] = 'Non è possibile aggiungere l\'intervento a causa di un errore sconosciuto.';
$string['couldnotdeletereplies'] = 'Spiacente, l\'intervento non può essere eliminato in quanto altri utenti hanno già risposto ad esso.';
$string['couldnotupdate'] = 'Non è possibile aggiornare l\'intervento a causa di un errore sconosciuto.';
$string['crontask'] = 'Invio mail dai forum e operazioni di manutenzione';
$string['delete'] = 'Elimina';
$string['deleteddiscussion'] = 'L\'argomento di discussione è stato eliminato.';
$string['deletedpost'] = 'L\'intervento è stato eliminato.';
$string['deletedposts'] = 'Quegli interventi sono stati eliminati';
$string['deletesure'] = 'Sei sicuro di voler eliminare questo intervento?';
$string['deletesureplural'] = 'Sei sicuro di voler eliminare questo intervento e tutte le risposte collegate? ({$a} interventi)';
$string['digestmailheader'] = 'Questa è la tua raccolta giornaliera dei nuovi interventi effettuati nei forum di {$a->sitename}. Se vuoi cambiare il default delle preferenze per l\'invio di e-mail dai forum, recati su {$a->userprefs}.';
$string['digestmailpost'] = 'Modifica preferenze email di raccolta';
$string['digestmailpostlink'] = 'Modifica le preferenze della raccolta giornaliera dai forum: {$a}';
$string['digestmailprefs'] = 'Il tuo profilo utente';
$string['digestmailsubject'] = '{$a}: raccolta giornaliera dai forum';
$string['digestmailtime'] = 'Ora di invio email di raccolta';
$string['digestsentusers'] = 'Sono state inviate con successo {$a} email di raccolta.';
$string['disallowsubscribe'] = 'Sottoscrizione non consentita';
$string['disallowsubscribeteacher'] = 'Sottoscrizioni non consentita (tranne che per i docenti)';
$string['disallowsubscription'] = 'Sottoscrizione';
$string['disallowsubscription_help'] = 'La configurazione di questo forum non consente la sottoscrizione delle discussioni.';
$string['discussion'] = 'Discussione';
$string['discussionlocked'] = 'La discussione è stata bloccata e non è più possibile intervenire.';
$string['discussionlockingdisabled'] = 'Non bloccare discussioni';
$string['discussionlockingheader'] = 'Blocco discussioni';
$string['discussionmoved'] = 'La discussione è stata spostata in \'{$a}\'';
$string['discussionmovedpost'] = 'La discussione è stata spostata in <a href="{$a->discusshref}">here</a> nel forum <a href="{$a->forumhref}">{$a->forumname}</a>';
$string['discussionname'] = 'Nome della discussione';
$string['discussionnownotsubscribed'] = '{$a->name} NON riceverà notifiche di nuovi interventi relativa a \'{$a->discussion}\' in \'{$a->forum}\'';
$string['discussionnowsubscribed'] = '{$a->name} riceverà notifiche di nuovi interventi relativi a \'{$a->discussion}\' in \'{$a->forum}\'';
$string['discussionpin'] = 'Metti in evidenza';
$string['discussionpinned'] = 'In evidenza';
$string['discussionpinned_help'] = 'Le discussioni in evidenza saranno visualizzate all\'inizio';
$string['discussions'] = 'Discussioni';
$string['discussionsplit'] = 'La discussione è stata divisa';
$string['discussionsstartedby'] = 'Discussione iniziata da {$a}';
$string['discussionsstartedbyrecent'] = 'Discussione iniziata recentemente da {$a}';
$string['discussionsstartedbyuserincourse'] = 'Discussioni avviate da {$a->fullname} nel corso {$a->coursename}';
$string['discussionsubscribestart'] = 'Sottoscrivo la discussione per ricevere notifiche di nuovi interventi';
$string['discussionsubscribestop'] = 'Non sottoscrivo la discussione, non riceverò notifiche di nuovi interventi';
$string['discussionsubscription'] = 'Sottoscrizione della discussione';
$string['discussionsubscription_help'] = 'Sottoscrivere una discussione consente di ricevere notifiche sui nuovi interventi relativi alla discussione.';
$string['discussionunpin'] = 'Rimuovi dall\'evidenza';
$string['discussthistopic'] = 'Discuti questo argomento';
$string['displayend'] = 'Fine visualizzazione';
$string['displayend_help'] = 'L\'impostazione consente di nascondere un post dopo la data stabilita. Notare che gli amministratori potranno comunque visualizzare gli interventi.';
$string['displaymode'] = 'Modalità visualizzazione';
$string['displayperiod'] = 'Periodo di visualizzazione';
$string['displaystart'] = 'Inizio visualizzazione';
$string['displaystart_help'] = 'L\'impostazione consente di visualizzare un post a partire dalla data stabilita. Notare che gli amministratori potranno comunque visualizzare sempre i post.';
$string['displaywordcount'] = 'Visualizza conteggio parole';
$string['displaywordcount_help'] = 'L\'impostazione consente di scegliere se visualizzare o meno il conteggio delle parole per ciascun intervento.';
$string['eachuserforum'] = 'Ciascun utente avvia una sola discussione';
$string['edit'] = 'Modifica';
$string['editedby'] = 'Modificato da {$a->name} - intervento originale effettuato il {$a->date}';
$string['editedpostupdated'] = 'Il post di {$a} è stato aggiornato';
$string['editing'] = 'Modifica';
$string['emaildigestcompleteshort'] = 'Messaggi per intero';
$string['emaildigestdefault'] = 'Default ({$a})';
$string['emaildigestoffshort'] = 'Nessuna raccolta';
$string['emaildigestsubjectsshort'] = 'Solo oggetto';
$string['emaildigesttype'] = 'Opzioni email di raccolta';
$string['emaildigesttype_help'] = 'Il tipo di notifiche che riceverai dai forum.

* Default - saranno usate le impostazioni presenti nel profilo utente, eventuali modifiche nel profilo si rifletteranno anche in questo foum;
* Nessuna raccolta - riceverai una email per ciascun messaggio nei forum
* Raccolta - messaggi per intero - riceverai una email al giorno contenente la raccolta dei messaggi  di ciascun messaggio nei forum.
* Raccolta - solo oggetto - Riceverai una email al giorno contenente la raccolta del solo oggetto di ciascun messaggio nei forum.';
$string['emptymessage'] = 'Il tuo intervento contiene qualche errore. Forse lo hai lasciato in bianco, oppure l\'allegato era troppo grande. Le tue modifiche NON sono state salvate.';
$string['erroremptymessage'] = 'Il corpo del messaggio non può essere vuoto';
$string['erroremptysubject'] = 'L\'oggetto non può essere vuoto';
$string['errorenrolmentrequired'] = 'Devi essere iscritto al corso per accedere a questo contenuto';
$string['errorwhiledelete'] = 'Si è verificato un errore durante l\'eliminazione del record.';
$string['eventassessableuploaded'] = 'Inserito intervento nel forum';
$string['eventcoursesearched'] = 'Effettuata ricerca nel corso';
$string['eventdiscussioncreated'] = 'Creata discussione';
$string['eventdiscussiondeleted'] = 'Eliminata discussione';
$string['eventdiscussionmoved'] = 'Spostata discussione';
$string['eventdiscussionpinned'] = 'La discussione è stata messa evidenza';
$string['eventdiscussionsubscriptioncreated'] = 'Creata  sottoscrizione della discussione';
$string['eventdiscussionsubscriptiondeleted'] = 'Eliminata sottoscrizione della discussione';
$string['eventdiscussionunpinned'] = 'La discussione è stata rimossa dall\'evidenza';
$string['eventdiscussionupdated'] = 'Aggiornata discussione';
$string['eventdiscussionviewed'] = 'Visualizzata discussione';
$string['eventpostcreated'] = 'Creato intervento';
$string['eventpostdeleted'] = 'Eliminato intervento';
$string['eventpostupdated'] = 'Aggiornato intervento';
$string['eventreadtrackingdisabled'] = 'Disabilitato evidenziamento messaggi';
$string['eventreadtrackingenabled'] = 'Abilitato evidenziamento messaggi';
$string['eventsubscribersviewed'] = 'Visualizzati sottoscrittori';
$string['eventsubscriptioncreated'] = 'Creata sottoscrizione';
$string['eventsubscriptiondeleted'] = 'Eliminata sottoscrizione';
$string['eventuserreportviewed'] = 'Visualizzato report utente';
$string['everyonecanchoose'] = 'Ciascun partecpante può decidere se sottoscrivere il forum';
$string['everyonecannowchoose'] = 'La sottoscrizione del forum è ora facoltativa per tutti';
$string['everyoneisnowsubscribed'] = 'La sottoscrizione del forum è ora obbligatoria per tutti';
$string['everyoneissubscribed'] = 'Forum a sottoscrizione obbligatoria';
$string['existingsubscribers'] = 'Utenti che hanno sottoscritto il forum';
$string['exportdiscussion'] = 'Esporta l\'intera discussione nel portfolio';
$string['forcedreadtracking'] = 'Consenti evidenziamento messaggi forzato';
$string['forcedreadtracking_desc'] = 'I forum potranno essere impostati per forzare l\'evidenziamento dei messaggi non letti. Può avere un impatto sulle prestazioni, in modo particolare in corsi con molti forum particolarmente attivi. Se l\'impostazione non è attiva, i forum già impostati con l\'evidenziamento dei messaggi forzato saranno impostati con l\'evidenziamento a scelta.';
$string['forcesubscribed'] = 'Questo forum è a sottoscrizione obbligatoria';
$string['forcesubscribed_help'] = 'La configurazione di questo forum non consente la revoca  delle sottoscrizioni delle discussioni.';
$string['forum'] = 'Forum';
$string['forum:addinstance'] = 'Aggiungere forum';
$string['forum:addnews'] = 'Aggiungere annunci';
$string['forum:addquestion'] = 'Aggiungere domanda';
$string['forum:allowforcesubscribe'] = 'Consentire sottoscrizione obbligatoria';
$string['forumauthorhidden'] = 'Autore (nascosto)';
$string['forumblockingalmosttoomanyposts'] = 'Stai per raggiungere il limite degli interventi permessi. Hai inviato {$a->numposts} interventi negli ultimi {$a->blockperiod} giorni. Il limite è di {$a->blockafter} interventi.';
$string['forumbodydeleted'] = 'Il contenuto di questo forum è stato rimosso e non può più essere visualizzato.';
$string['forumbodyhidden'] = 'Non puoi visualizzare questo intervento, probabilmente perché non hai ancora effettuato interventi nella discussione, non è ancora trascorso il tempo massimo per l\'editing dei messaggi,  la discussione non è ancora cominciata oppure è terminata.';
$string['forum:canoverridediscussionlock'] = 'Intervenire in discussioni bloccate';
$string['forum:canposttomygroups'] = 'Inserire interventi in tutti i gruppi dove si ha accesso';
$string['forum:createattachment'] = 'Creare allegati';
$string['forum:deleteanypost'] = 'Eliminare tutti gli interventi (sempre)';
$string['forum:deleteownpost'] = 'Eliminare i propri interventi (entro il limite temporale)';
$string['forum:editanypost'] = 'Modificare gli interventi';
$string['forum:exportdiscussion'] = 'Esportare intera discussione';
$string['forum:exportownpost'] = 'Esportare propri interventi';
$string['forum:exportpost'] = 'Esportare intervento';
$string['forumintro'] = 'Descrizione';
$string['forum:managesubscriptions'] = 'Gestire sottoscrittori';
$string['forum:movediscussions'] = 'Spostare le discussioni';
$string['forumname'] = 'Nome del forum';
$string['forum:pindiscussions'] = 'Mettere in evidenza discussioni';
$string['forumposts'] = 'Interventi nei Forum';
$string['forum:postwithoutthrottling'] = 'Intervenire nei forum senza soglia interventi';
$string['forum:rate'] = 'Valutare gli interventi';
$string['forum:replynews'] = 'Rispondere agli annunci';
$string['forum:replypost'] = 'Rispondere agli interventi';
$string['forums'] = 'Forum';
$string['forum:splitdiscussions'] = 'Dividere discussioni';
$string['forum:startdiscussion'] = 'Iniziare una nuova discussione';
$string['forumsubjectdeleted'] = 'L\'intervento è stato rimosso';
$string['forumsubjecthidden'] = 'Oggetto (nascosto)';
$string['forumtracked'] = 'Gli interventi non letti sono tracciati';
$string['forumtrackednot'] = 'Gli interventi non letti non sono tracciati';
$string['forumtype'] = 'Tipo di forum';
$string['forumtype_help'] = 'Sono disponibili 5 tipi di forum:

* Forum monotematico - Forum costituito da un solo argomento di discussione, tutti i partecipanti possono intervenire.
* Ciascun utente avvia una sola discussione - Ogni partecipante può avviare un\'unica discussione su un argomento e gli altri partecipanti possono intervenire.
* Domande e Risposte - Il forum Domande e Risposte obbliga i partecipanti ad intervenire prima di poter visualizzare gli interventi degli altri.
* Forum standard visualizzato in stile blog - Un forum aperto dove chiunque può avviare discussioni in qualsiasi momento e nel quale gli argomenti di discussione sono visualizzati su una pagina con link "Discuti questo argomento".
* Forum standard per uso generale - Forum aperto dove tutti i partecipanti in qualsiasi momento possono avviare discussioni';
$string['forum:viewallratings'] = 'Visualizzare voti grezzi dati da ciascuno';
$string['forum:viewanyrating'] = 'Visualizzare voti totali ricevuti da ciascuno';
$string['forum:viewdiscussion'] = 'Visualizzare discussioni';
$string['forum:viewhiddentimedposts'] = 'Visualizzare gli interventi a tempo nascosti';
$string['forum:viewqandawithoutposting'] = 'Visualizzare sempre gli interventi di tipo "Domande e Risposte"';
$string['forum:viewrating'] = 'Visualizzare voti totali ricevuti';
$string['forum:viewsubscribers'] = 'Visualizzare i sottoscrittori';
$string['generalforum'] = 'Forum standard per uso generale';
$string['generalforums'] = 'Forum per uso generale';
$string['hiddenforumpost'] = 'Intervento nascosto';
$string['indicator:cognitivedepth'] = 'Forum cognitivo';
$string['indicator:cognitivedepth_help'] = 'L\'indicatore è basato sulla profondità cognitiva toccata dallo studente svolgendo attività Forum.';
$string['indicator:socialbreadth'] = 'Forum sociale';
$string['indicator:socialbreadth_help'] = 'L\'indicatore è basato sulla dimensione sociale raggiunta dallo studente svolgendo attività Forum.';
$string['inforum'] = 'in {$a}';
$string['introblog'] = 'I post di questo forum sono stati copiati automaticamente dai blog degli utenti iscritti al corso poiché tali interventi blog non sono più disponibili';
$string['intronews'] = 'Annunci e news di carattere generale';
$string['introsocial'] = 'Un forum aperto per dialogare su qualsiasi argomento di tuo interesse.';
$string['introteacher'] = 'Un forum riservato agli insegnanti per annotazioni e discussioni.';
$string['invalidaccess'] = 'Questa pagina non è stata acceduta correttamente.';
$string['invaliddigestsetting'] = 'Sono state inserire impostazioni non valide per l\'email di raccolta';
$string['invaliddiscussionid'] = 'L\'ID della discussione è errata oppure non esiste più';
$string['invalidforcesubscribe'] = 'Modalità sottoscrizione obbligatoria non valida';
$string['invalidforumid'] = 'L\'ID del forum è errata';
$string['invalidparentpostid'] = 'L\'ID dell\'intervento superiore è errato';
$string['invalidpostid'] = 'ID dell\'intervento non valida - {$a}';
$string['lastpost'] = 'Ultimo intervento';
$string['learningforums'] = 'Forum per apprendimento';
$string['lockdiscussionafter'] = 'Blocca discussioni dopo un periodo di inattività';
$string['lockdiscussionafter_help'] = 'Le discussioni possono essere bloccate automaticamente allo scadere di un determinato tempo dopo l\'ultimo intervento.

Gli utenti con il privilegio di intervenire in discussioni bloccate potranno sbloccare la discussione semplicemente inviando una risposta.';
$string['longpost'] = 'Intervento lungo';
$string['mailnow'] = 'Invia l\'intervento immediatamente senza attendere il tempo per la modifica.';
$string['managesubscriptionsoff'] = 'Termina gestione sottoscrizioni';
$string['managesubscriptionson'] = 'Gestione sottoscrittori';
$string['manydiscussions'] = 'Discussioni per pagina';
$string['markalldread'] = 'Segna come letti tutti gli interventi in questa discussione.';
$string['markallread'] = 'Segna come letti tutti gli interventi in questo forum.';
$string['markasreadonnotification'] = 'All\'invio delle notifiche di interventi nel forum';
$string['markasreadonnotification_help'] = 'E\' possibile scegliere se le notifiche degli interventi nel forum possono contrassegnare o non contrassegnare gli interventi come letti.';
$string['markasreadonnotificationno'] = 'Non contrassegnare l\'intervento come letto';
$string['markasreadonnotificationyes'] = 'Contrassegna l\'intervento come letto';
$string['markread'] = 'Segna come letto';
$string['markreadbutton'] = 'Segna come <br/> letto';
$string['markunread'] = 'Segna come non letto';
$string['markunreadbutton'] = 'Segna come <br/> non letto';
$string['maxattachments'] = 'Numero massimo allegati';
$string['maxattachments_help'] = 'L\'impostazione consente di definire il numero massimo di file allegabili in ciascun intervento nel forum.';
$string['maxattachmentsize'] = 'Dimensione massima allegati';
$string['maxattachmentsize_help'] = 'L\'impostazione  limita la dimensione massima dei file  allegabili ai messaggi del forum.';
$string['maxtimehaspassed'] = 'Spiacente, il tempo massimo concesso per modificare questo intervento ({$a}) è trascorso!';
$string['message'] = 'Messaggio';
$string['messageinboundattachmentdisallowed'] = 'Non è stato possibile inserire la tua risposta nel forum poiché hai allegato un file ma il forum non consente gli allegati.';
$string['messageinboundfilecountexceeded'] = 'Non è stato possibile inserire la tua risposta nel forum poiché hai allegato più file di quanti ne consenta il forum ({$a->forum->maxattachments}).';
$string['messageinboundfilesizeexceeded'] = 'Non è stato possibile inserire la risposta nel forum poiché la dimensione totale degli allegati ({$a->filesize}) è superiore alla dimensione massima consentita nel forum ({$a->maxbytes}).';
$string['messageinboundforumhidden'] = 'Non è stato possibile inserire la tua risposta nel forum poiché il forum non è al momento disponibile.';
$string['messageinboundnopostforum'] = 'Non è stato possibile inserire la tua risposta nel forum poiché non sei autorizzato ad intervenire nel forum {$a->forum->name}.';
$string['messageinboundthresholdhit'] = 'Non è stato possibile inserire la tua risposta nel forum poiché hai superato la soglia massima interventi impostata nel forum.';
$string['messageprovider:digests'] = 'Sottoscrizioni email di raccolta forum';
$string['messageprovider:posts'] = 'Interventi forum sottoscritti';
$string['missingsearchterms'] = 'I seguenti termini di ricerca si presentano soltanto nel codice HTML di questo messaggio:';
$string['modeflatnewestfirst'] = 'Visualizza le repliche in formato lineare, con le più recenti all\'inizio';
$string['modeflatoldestfirst'] = 'Visualizza le repliche in formato lineare, con le più vecchie all\'inizio';
$string['modenested'] = 'Visualizza le repliche in formato nidificato';
$string['modethreaded'] = 'Visualizza le repliche in formato per oggetto';
$string['modulename'] = 'Forum';
$string['modulename_help'] = 'Il modulo attività Forum consente di tenere discussioni asincrone tra i partecipanti, la cui durata è prolungata nel tempo.

Sono disponibili diversi tipi di forum tra cui scegliere,  forum standard dove chiunque può avviare una discussione, forum dove ciascuno studente può avviare una sola discussioni, forum domande e risposte, dove lo studente deve intervenire prima di poter visualizzare gli interventi degli altri. E\' possibile consentire file allegati. Se gli allegati sono immagini saranno visualizzate direttamente nel corpo dell\'intervento.

I partecipanti possono sottoscrivere il forum per ricevere notifiche di nuovi interventi. Il docente può impostare la sottoscrizione al forum come facoltativa, obbligatoria, automatica, oppure può non consentirne la sottoscrizione. In caso di necessità è anche possibile bloccare studenti che abbiano postato più di un certo numero di interventi in un dato intervallo di tempo, riducendo il rischio che qualcuno domini la discussione.

Gli interventi nei forum possono essere valutati dal docente o dagli stessi studenti (valutazione tra pari). I punteggi ottenuti vengono aggregati e memorizzati nel registro valutatore.

E\' possibile usare il forum per:

* uno spazio sociale per consentire ai partecipanti di conoscersi
* annunci del corso (usando il forum news a sottoscrizione obbligatoria)
* discutere sui contenuti o dispense del corso
* dare continuità ad un problema riscontrato durante sessioni in presenza
* svolgere discussioni tra docenti (usando un forum nascosto)
* area di supporto generale online tra docenti e studenti
* area di supporto individuale per colloqui privati tra docenti e studenti (usando un forum a gruppi separati con gruppi composti da un solo utente)
* estendere attività ad esempio proponendo problemi che gli studenti possono valutare per suggerire soluzioni';
$string['modulenameplural'] = 'Forum';
$string['more'] = 'leggi';
$string['movedmarker'] = 'Spostato';
$string['movethisdiscussionto'] = 'Sposta la discussione in...';
$string['mustprovidediscussionorpost'] = 'Per esportare un argomento di discussione devi indicare l\'id della discussione o dell\'intervento.';
$string['myprofileotherdis'] = 'Discussioni nei forum';
$string['myprofileowndis'] = 'Le mie discussioni sui fourm';
$string['myprofileownpost'] = 'I miei interventi sui forum';
$string['namenews'] = 'Annunci';
$string['namenews_help'] = 'Il forum Annunci è un forum speciale creato automaticamente in ogni corso. Un corso può avere un solo forum annunci. Solo i docenti e gli amministratori possono creare interventi nel forum annunci. Il blocco \'Annunci recenti\' visualizzerà le discussioni più recenti provenienti da questo forum.';
$string['namesocial'] = 'Forum Relazionale';
$string['nameteacher'] = 'Forum docenti';
$string['newforumposts'] = 'Nuovi interventi nel forum';
$string['nextdiscussiona'] = 'Discussione successiva: {$a}';
$string['noattachments'] = 'L\'intervento non ha allegati';
$string['nodiscussions'] = 'Al momento in questo forum non sono presenti argomenti di discussione';
$string['nodiscussionsstartedby'] = '{$a} non ha avviato nessuna discussione';
$string['nodiscussionsstartedbyyou'] = 'Non hai avviato nessuna discussione';
$string['noguestpost'] = 'Spiacente, gli ospiti non possono effettuare interventi.';
$string['noguestsubscribe'] = 'Spiacente, gli ospiti non possono effettuare sottoscrizioni';
$string['noguesttracking'] = 'Spiacente, agli ospiti non è consentito di impostare le opzioni di evidenziamento dei messaggi non letti.';
$string['nomorepostscontaining'] = 'Non sono stati trovati altri interventi contenenti \'{$a}\'';
$string['nonews'] = 'Non ci sono annunci.';
$string['noonecansubscribenow'] = 'Le sottoscrizioni non sono più consentite';
$string['nopermissiontosubscribe'] = 'Non hai il privilegio per visualizzare i sottoscrittori';
$string['nopermissiontoview'] = 'Non hai il privilegio per visualizzare questo intervento';
$string['nopostforum'] = 'Spiacente, non puoi visualizzare questo forum';
$string['noposts'] = 'Nessun intervento';
$string['nopostsmadebyuser'] = '{$a} non ha effettuato nessun intervento';
$string['nopostsmadebyyou'] = 'Non ha effettuato nessun intervento';
$string['noquestions'] = 'Al momento il forum non ha sottoscrittori';
$string['nosubscribers'] = 'Al momento il forum non ha sottoscrittori';
$string['notexists'] = 'La discussione non esiste più';
$string['nothingnew'] = 'Niente di nuovo per {$a}';
$string['notingroup'] = 'Spiacente, devi appartenere ad un gruppo per poter visualizzare questo forum.';
$string['notinstalled'] = 'Il modulo forum non è installato';
$string['notpartofdiscussion'] = 'Questo intervento non appartiene a nessuna discussione!';
$string['notrackforum'] = 'Non evidenziare messaggi non letti';
$string['notsubscribed'] = 'Sottoscrivi';
$string['noviewdiscussionspermission'] = 'Non sei autorizzato a visualizzare le discussioni di questo forum';
$string['nowallsubscribed'] = 'Hai sottoscritto tutti i forum presenti in {$a}.';
$string['nowallunsubscribed'] = 'Sei stato rimosso da tutti i forum presenti in {$a}.';
$string['nownotsubscribed'] = 'L\'utente  {$a->name} NON riceverà più notifiche di nuovi interventi dal forum \'{$a->forum}\'.';
$string['nownottracking'] = '{$a->name} non sta più evidenziando i messaggi in \'{$a->forum}\'.';
$string['nowsubscribed'] = 'L\'utente {$a->name} riceverà notifiche di nuovi interventi dal forum \'{$a->forum}\'.';
$string['nowtracking'] = '{$a->name} sta evidenziando i messaggi in \'{$a->forum}\'.';
$string['numposts'] = '{$a} interventi';
$string['olderdiscussions'] = 'Discussioni precedenti';
$string['oldertopics'] = 'Argomenti precedenti';
$string['oldpostdays'] = 'Ritieni letti i messaggi dopo giorni';
$string['overviewnumpostssince'] = '{$a} interventi dall\'ultimo accesso';
$string['overviewnumunread'] = '{$a} non letti';
$string['page-mod-forum-discuss'] = 'Pagina degli argomenti di discussione del modulo forum';
$string['page-mod-forum-view'] = 'Pagina principale del modulo forum';
$string['page-mod-forum-x'] = 'Qualsiasi pagina con modulo forum';
$string['parent'] = 'Visualizza intervento genitore';
$string['parentofthispost'] = 'Padre di questo intervento';
$string['permalink'] = 'Permalink';
$string['pluginadministration'] = 'Gestione Forum';
$string['pluginname'] = 'Forum';
$string['postadded'] = '<p>Il tuo intervento è stato aggiunto con successo.</p><p>Hai {$a} a disposizione se desideri apportare delle modifiche.</p>';
$string['postaddedsuccess'] = 'Il tuo intervento è stato aggiunto con successo.';
$string['postaddedtimeleft'] = 'Hai {$a} a disposizione se desideri apportare delle modifiche.';
$string['postbymailsuccess'] = 'Congratulazioni, il tuo intervento su "{$a->subject}" è stato inserito correttamente nel forum. Per visualizzarlo: {$a->discussionurl}.';
$string['postbymailsuccess_html'] = 'Congratulazioni, il tuo intervento su "{$a->subject}" è stato inserito correttamente nel forum. <a href="{$a->discussionurl}">Fai click qui per visualizzarlo.</a>';
$string['postbyuser'] = '{$a->post} di {$a->user}';
$string['postincontext'] = 'Visualizza questo intervento nel contesto';
$string['postmailinfolink'] = 'Questa è una copia del messaggio inserito nei forum del del corso {$a->coursename}.

Per rispondere, utilizza il link seguente: {$a->replylink}';
$string['postmailnow'] = '<p>L\' intervento sarà inviato immediatamente nelle email dei sottoscrittori.</p>';
$string['postmailsubject'] = '{$a->courseshortname}: {$a->subject}';
$string['postrating1'] = 'Apprendimento prevalentemente separato';
$string['postrating2'] = 'Apprendimento sia separato sia collegato';
$string['postrating3'] = 'Apprendimento prevalentemente collegato';
$string['posts'] = 'Interventi';
$string['postsmadebyuser'] = 'Interventi di {$a}';
$string['postsmadebyuserincourse'] = 'Intervento di {$a->fullname} in {$a->coursename}';
$string['posttoforum'] = 'Invia al forum';
$string['posttomygroups'] = 'Intervento in tutti i gruppi';
$string['posttomygroups_help'] = 'L\'intervento sarà copiato in tutti i gruppi ai quali hai accesso. I membri dei gruppi ai quali non hai accesso non potranno visualizzare l\'intervento.';
$string['postupdated'] = 'Il tuo intervento è stato aggiornato';
$string['potentialsubscribers'] = 'Utenti che non hanno sottoscritto il forum';
$string['prevdiscussiona'] = 'Discussione precedente: {$a}';
$string['privacy:digesttypenone'] = 'In questo forum non vengono memorizzate informazioni relative alla al tipo preferito di raccolta email.';
$string['privacy:digesttypepreference'] = 'Hai scelto di ricevere il seguente tipo di raccolta email: "{$a->type}".';
$string['privacy:discussionsubscriptionpreference'] = 'Hai scelto le seguenti preferenze di sottoscrizione alla discussione per questo forum: "{$a->preference}"';
$string['privacy:metadata:core_rating'] = 'Il forum utilizza il sottosistema di valutazione per supportare la valutazione degli interventi.';
$string['privacy:metadata:core_tag'] = 'Il forum utilizza il sottosistema tag per supportare i tag negli interventi.';
$string['privacy:metadata:forum_digests'] = 'Informazioni sulle preferenze per la raccolta emaild ei forum.';
$string['privacy:metadata:forum_digests:forum'] = 'Sottoscrizioni ai forum.';
$string['privacy:metadata:forum_digests:maildigest'] = 'Preferenza raccolta email.';
$string['privacy:metadata:forum_digests:userid'] = 'ID dell\'utente con preferenza raccolta email.';
$string['privacy:metadata:forum_discussions'] = 'Informazioni sulle singole discussioni create dall\'utente sul forum.';
$string['privacy:metadata:forum_discussions:assessed'] = 'TODOD - cosa memorizza questo campo';
$string['privacy:metadata:forum_discussions:name'] = 'Titolo della discussione scelto dall\'autore.';
$string['privacy:metadata:forum_discussions:timemodified'] = 'Data e ora di ultima modifica della discussione.';
$string['privacy:metadata:forum_discussion_subs'] = 'Informazioni sulle sottoscrizioni alle singole discussioni sul forum.';
$string['privacy:metadata:forum_discussion_subs:discussionid'] = 'ID della discussione sottoscritta.';
$string['privacy:metadata:forum_discussion_subs:preference'] = 'Data e ora di inizio della sottoscrizione.';
$string['privacy:metadata:forum_discussion_subs:userid'] = 'ID dell\'utente che ha sottoscritto la discussione.';
$string['privacy:metadata:forum_discussions:userid'] = 'ID dell\'utente che ha creato la discussione.';
$string['privacy:metadata:forum_discussions:usermodified'] = 'ID dell\'utente che ha apportato le ultime modifiche alla discussione.';
$string['privacy:metadata:forum_posts'] = 'Informazioni sulle preferenze per raccolta email di ogni forum.';
$string['privacy:metadata:forum_posts:created'] = 'Orario di creazione dell\'intervento sul forum.';
$string['privacy:metadata:forum_posts:discussion'] = 'Discussione di appartenenza dell\'intervento.';
$string['privacy:metadata:forum_posts:message'] = 'Messaggio dell\'intervento sul forum.';
$string['privacy:metadata:forum_posts:modified'] = 'Orario di modifica più recente dell\'intervento sul forum.';
$string['privacy:metadata:forum_posts:parent'] = 'Intervento genitore che ha ricevuto una risposta.';
$string['privacy:metadata:forum_posts:subject'] = 'Oggetto dell\'intervento sul forum.';
$string['privacy:metadata:forum_posts:totalscore'] = 'Messaggio dell\'intervento sul forum.';
$string['privacy:metadata:forum_posts:userid'] = 'ID dell\'utente che ha scritto l\'intervento.';
$string['privacy:metadata:forum_queue'] = 'Log temporaneo degli interventi che saranno inviati come raccolta';
$string['privacy:metadata:forum_queue:discussionid'] = 'ID della discussione sul forum';
$string['privacy:metadata:forum_queue:postid'] = 'ID dell\'intervento sul forum';
$string['privacy:metadata:forum_queue:timemodified'] = 'Orario di modifica dell\'intervento originale';
$string['privacy:metadata:forum_queue:userid'] = 'Utente che deve essere avvertito sull\'intervento';
$string['privacy:metadata:forum_read'] = 'Informazioni sugli interventi letti dall\'utente.';
$string['privacy:metadata:forum_read:discussionid'] = 'Discussione di appartenenza dell\'intervento.';
$string['privacy:metadata:forum_read:firstread'] = 'Orario in cui l\'intervento è stato letto per la prima volta.';
$string['privacy:metadata:forum_read:lastread'] = 'Orario in cui l\'intervento è stato letto più recentemente.';
$string['privacy:metadata:forum_read:postid'] = 'Intervento che è stato letto.';
$string['privacy:metadata:forum_read:userid'] = 'ID dell\'utente a cui fa riferimento il record.';
$string['privacy:metadata:forum_subscriptions'] = 'Informazioni su quali forum sono stati sottoscritti dall\'utente.';
$string['privacy:metadata:forum_subscriptions:forum'] = 'Forum che sono stati sottoscritti.';
$string['privacy:metadata:forum_subscriptions:userid'] = 'ID dell\'utente a cui fa riferimento la sottoscrizione al forum.';
$string['privacy:metadata:forum_track_prefs'] = 'Informazioni sui forum dovel\'utente ha scelto di tracciare la lettura degli interventi.';
$string['privacy:metadata:forum_track_prefs:forumid'] = 'Forum dove il tracciamento della lettura è abilitato.';
$string['privacy:metadata:forum_track_prefs:userid'] = 'ID dell\'utente a cui fa riferimento la preferenza sul tracciamento del forum.';
$string['privacy:metadata:preference:autosubscribe'] = 'Scelta di sottoscrivere le discussioni quando si risponde gli interventi.';
$string['privacy:metadata:preference:maildigest'] = 'Preferenza raccolta email per l\'intero il sito.';
$string['privacy:metadata:preference:markasreadonnotification'] = 'Scelta di contrassegnare i post sul forum come letti quando si ricevono come messaggi.';
$string['privacy:metadata:preference:trackforums'] = 'Scelta di abilitare il tracciamento della lettura.';
$string['privacy:postwasread'] = 'Questo intervento è stato letto la prima volta il {$a->firstread} e la lettura più recente è del {$a->lastread}';
$string['privacy:readtrackingdisabled'] = 'Hai scelto di non monitorare gli interventi che hai scritto in questo forum.';
$string['privacy:request:delete:discussion:name'] = 'Elimina su richiesta dell\'autore';
$string['privacy:request:delete:post:message'] = 'Il contenuto di questo intervento è stato eliminato su richiesta dell\'autore.';
$string['privacy:request:delete:post:subject'] = 'Elimina su richiesta dell\'autore';
$string['privacy:subscribedtoforum'] = 'Hai sottoscritto il forum.';
$string['processingdigest'] = 'Elaborazione email di raccolta per l\'utente {$a}';
$string['processingpost'] = 'Elaborazione intervento {$a}';
$string['prune'] = 'Sposta altrove';
$string['prunedpost'] = 'Una nuova discussione è stata creata a partire da quell\'intervento';
$string['pruneheading'] = 'Spezza la discussione e sposta questo intervento ad una nuova discussione';
$string['qandaforum'] = 'Forum Domande e Risposte';
$string['qandanotify'] = 'Questo è un forum Domande e Risposte. Per poter vedere le risposte date dagli altri partecipanti  devi prima rispondere a tua volta..';
$string['re'] = 'Ri:';
$string['readtherest'] = 'Leggi il resto dell\'argomento';
$string['removeallforumtags'] = 'Rimuovi tutti i tag del forum';
$string['replies'] = 'Repliche';
$string['repliesmany'] = '{$a} risposte finora';
$string['repliesone'] = '{$a} risposta finora';
$string['reply'] = 'Rispondi';
$string['replyforum'] = 'Replica al forum';
$string['reply_handler'] = 'Risposte per email agli interventi nel forum';
$string['reply_handler_name'] = 'Risposte agli interventi sui forum';
$string['replytopostbyemail'] = 'Puoi rispondere all\'intervento per email';
$string['replytouser'] = 'Usa indirizzo email nei messaggi';
$string['resetdigests'] = 'Elimina tutte le preferenze utente per l\'email di raccolta';
$string['resetforums'] = 'Rimuovi tutti gli interventi da questi tipi di forum';
$string['resetforumsall'] = 'Rimuovi tutti gli interventi';
$string['resetsubscriptions'] = 'Rimuovi tutte le sottoscrizioni al forum';
$string['resettrackprefs'] = 'Elimina tutte le impostazioni di tracciamento del forum';
$string['rssarticles'] = 'Numero di articoli RSS';
$string['rssarticles_help'] = 'L\'impostazione consente di definire il numero di articoli (discussioni p interventi) da includere nel feed RSS. Un buon valore è in genere compreso tra 5 e 20.';
$string['rsssubscriberssdiscussions'] = 'RSS feed delle discussioni';
$string['rsssubscriberssposts'] = 'RSS feed degli interventi';
$string['rsstype'] = 'Feed RSS per questa attività';
$string['rsstypedefault'] = 'Tipo di feed RSS';
$string['rsstype_help'] = 'Per abilitare i feed RSS, devi scegliere se includere discussioni o interventi';
$string['search'] = 'Cerca';
$string['search:activity'] = 'Forum - Informazioni sull\'attività';
$string['searchdatefrom'] = 'Gli interventi devono essere più recenti di';
$string['searchdateto'] = 'Gli interventi devono essere più vecchi di';
$string['searchforumintro'] = 'Si prega di inserire i termini di ricerca in uno o più dei seguenti campi:';
$string['searchforums'] = 'Cerca nei forum';
$string['searchfullwords'] = 'Queste parole devono apparire come parole intere';
$string['searchnotwords'] = 'Queste parole non devono essere incluse';
$string['searcholderposts'] = 'Cerca interventi più vecchi...';
$string['searchphrase'] = 'Nell\'intervento deve apparire esattamente questa frase';
$string['search:post'] = 'Forum - Interventi';
$string['searchresults'] = 'Risultati delle ricerche';
$string['searchsubject'] = 'Queste parole devono apparire nell\'oggetto';
$string['searchtags'] = 'E\' taggato con';
$string['searchuser'] = 'Questo nome deve corrispondere all\'autore';
$string['searchuserid'] = 'Il Moodle ID dell\'autore';
$string['searchwhichforums'] = 'Scegliere in quali forum cercare';
$string['searchwords'] = 'Queste parole possono apparire in qualunque punto dell\'intervento';
$string['seeallposts'] = 'Visualizzare tutti gli interventi di questo utente';
$string['shortpost'] = 'Intervento breve';
$string['showsubscribers'] = 'Visualizza e modifica le sottoscrizioni al forum';
$string['singleforum'] = 'Forum monotematico';
$string['smallmessage'] = '{$a->user} ha inserito un messaggio in {$a->forumname}';
$string['smallmessagedigest'] = 'Raccolta forum con {$a} messaggi';
$string['startedby'] = 'Iniziato da';
$string['subject'] = 'Oggetto';
$string['subscribe'] = 'Sottoscrivi questo forum';
$string['subscribeall'] = 'Sottoscrivi tutti a questo forum';
$string['subscribed'] = 'Sottoscritto';
$string['subscribediscussion'] = 'Sottoscrivi questa discussione';
$string['subscribeenrolledonly'] = 'Spiacente, solo gli utenti iscritti possono sottoscrivere i forum e ricevere notifiche di nuovi interventi.';
$string['subscribenone'] = 'Revoca tutte le sottoscrizioni di questo forum';
$string['subscribers'] = 'Sottoscrittori';
$string['subscriberstowithcount'] = '({$a->count}) sottoscrittori di "{$a->name}"';
$string['subscribestart'] = 'Desidero ricevere notifiche sui nuovi interventi di questo forum';
$string['subscribestop'] = 'Non desidero ricevere notifiche sui nuovi interventi di questo forum';
$string['subscription'] = 'Sottoscrizione';
$string['subscriptionandtracking'] = 'Sottoscrizione ed evidenziazione';
$string['subscriptionauto'] = 'Automatica';
$string['subscriptiondisabled'] = 'Disabilitata';
$string['subscriptionforced'] = 'Obbligatoria';
$string['subscription_help'] = 'Sottoscrivendo un forum riceverai notifiche di nuovi interventi. In genere è possibile scegliere se sottoscrivere oppure no, in alcuni casi tuttavia la sottoscrizione è obbligatoria e tutti riceveranno le notifiche.';
$string['subscriptionmode'] = 'Modalità sottoscrizione';
$string['subscriptionmode_help'] = 'La sottoscrizione di un forum consente di ricevere copie degli interventi via email. Sono disponibili 4 modalità di sottoscrizione:

* Facoltativa - I partecipanti possono scegliere se sottoscrivere il forum o meno
* Obbligatoria - La sottoscrizione è attiva per tutti i partecipanti sottoscrivono il forum e non è possibile revocarla.
* Automatica - La sottoscrizione è attiva per tutti i partecipanti ma ciascuno può revocare la propria sottoscrizione se lo desidera
* Disabilitata - Non è possibile sottoscrivere il forum';
$string['subscriptionoptional'] = 'Facoltativa';
$string['subscriptions'] = 'Sottoscrizioni';
$string['tagarea_forum_posts'] = 'Interventi forum';
$string['tagsdeleted'] = 'I tag del forum sono stati eliminati';
$string['thisforumisthrottled'] = 'Il forum ha una soglia massima di interventi che è possibile effettuare in un dato intervallo di tempo - la soglia al momento è impostata a {$a->blockafter} interventi in {$a->blockperiod}';
$string['timedhidden'] = 'Stato Intervento a tempo: non visibile agli studenti';
$string['timedposts'] = 'Interventi a tempo';
$string['timedvisible'] = 'Stato Intervento a tempo: visibile a tutti gli utenti';
$string['timestartenderror'] = 'La data di fine visualizzazione non può essere precedente alla data di inizio';
$string['trackforum'] = 'Evidenzia messaggi non letti';
$string['tracking'] = 'Evidenzia';
$string['trackingoff'] = 'Disabilitato';
$string['trackingon'] = 'Forzato';
$string['trackingoptional'] = 'A scelta';
$string['trackingtype'] = 'Tipo di evidenziamento messaggi';
$string['trackingtype_help'] = 'L\'evidenziamento dei messaggi non letti facilita l\'individuazione degli interventi e delel discussioni non lette.

Impostando l\'evidenziamento opzionale, i partecipanti potranno attivarlo tramite il link nel blocco amministrazione. (L\'evidenziamento deve essere attivo anche nelle preferenze forum dell\'utente).

Nel caso in cu l\'amministratore del sito abbiamo Impostato l\'evidenziamento obbligatorio, sarà disponibile una terza opzione, \'Forzato\'. In questo caso l\'evidenziamento sarà sempre attivo indipendentemente dalle preferenze dell\'utente.';
$string['trackreadposts_header'] = 'Evidenziamento messaggi forum';
$string['unread'] = 'Non letto';
$string['unreadposts'] = 'Interventi non letti';
$string['unreadpostsnumber'] = '{$a} interventi non letti';
$string['unreadpostsone'] = '1 intervento non letto';
$string['unsubscribe'] = 'Revoca la sottoscrizione del forum';
$string['unsubscribeall'] = 'Revoca la sottoscrizione di tutti i forum';
$string['unsubscribeallconfirm'] = 'Al momento hai sottoscritto {$a} forum. Confermi la revoca della sottoscrizione da tutti i forum e la disabilitazione della sottoscrizione automatica dei forum?';
$string['unsubscribeallconfirmdiscussions'] = 'Al momento hai sottoscritto {$a->discussions} discussioni. Confermi la revoca della sottoscrizione da tutte le discussioni e la disabilitazione della sottoscrizione automatica delle discussioni?';
$string['unsubscribeallconfirmforums'] = 'Al momento hai sottoscritto {$a} forum. Confermi la revoca della sottoscrizione da tutti i forum e la disabilitazione della sottoscrizione automatica delle discussioni?';
$string['unsubscribealldone'] = 'Tutte le tue sottoscrizioni facoltative ai forum sono state rimosse. Continuerai comunque a ricevere le notifiche dai forum a sottoscrizione obbligatoria. Se desideri gestire le notifiche dai forum, vai nella sezione Messaging del tuo profilo.';
$string['unsubscribeallempty'] = 'Spiacente, non hai sottoscritto nessun forum. Nel caso tu non voglia più ricevere notifiche da questo server,  ai nella sezione Messaging del tuo profilo.';
$string['unsubscribed'] = 'Non sottoscritto';
$string['unsubscribediscussion'] = 'Revoca la sottoscrizione della discussione';
$string['unsubscribediscussionlink'] = 'Revoca la sottoscrizione della discussione: {$a}';
$string['unsubscribelink'] = 'Revoca la sottoscrizione del forum: {$a}';
$string['unsubscribeshort'] = 'Revoca sottoscrizione';
$string['usermarksread'] = 'Spunta manualmente gli interventi non letti';
$string['viewalldiscussions'] = 'Visualizza tutti gli argomenti';
$string['viewthediscussion'] = 'Visualizza discussione';
$string['warnafter'] = 'Soglia per l\'avviso';
$string['warnafter_help'] = 'I partecipanti possono essere informati se si stanno avvicinando alla soglia massima degli interventi. L\'impostazione stabilisce dopo quanti post informare i partecipanti. Coloro che hanno il privilegio mod/forum:postwithoutthrottling non sono influenzati da questa impostazione.';
$string['warnformorepost'] = 'Attenzione! Questo forum ha più discussioni, verrà utilizzata la più recente';
$string['yournewquestion'] = 'La tua nuova domanda';
$string['yournewtopic'] = 'Il tuo nuovo argomento di discussione';
$string['yourreply'] = 'La tua replica';
