<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'forum', language 'sr_lt', branch 'MOODLE_36_STABLE'
 *
 * @package   forum
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityoverview'] = 'Ima novih poruka na forumu';
$string['addanewdiscussion'] = 'Dodaj novu temu za diskusiju';
$string['addanewquestion'] = 'Dodaj novo pitanje';
$string['addanewtopic'] = 'Dodaj novu temu';
$string['advancedsearch'] = 'Napredno pretraživanje';
$string['allforums'] = 'Svi forumi';
$string['allowdiscussions'] = 'Da li {$a} može slati poruke na ovaj forum?';
$string['allowsallsubscribe'] = 'Ovaj forum dozvoljava svima da odaberu da li će se pretplatiti ili ne.';
$string['allowsdiscussions'] = 'Ovaj forum dozvoljava svakoj osobi da započne jednu diskusiju';
$string['allsubscribe'] = 'Pretplatite se na sve forume';
$string['allunsubscribe'] = 'Odjavite se sa svih foruma.';
$string['alreadyfirstpost'] = 'Ovo je već prva poruka u diskusiji';
$string['anyfile'] = 'Bilo koja datoteka';
$string['areaattachment'] = 'Prilozi';
$string['areapost'] = 'Poruke';
$string['attachment'] = 'Prilog';
$string['attachment_help'] = 'Poruci možete da priložite jednu ili više datoteka. Ako priložite sliku, ona će biti prikazana na kraju poruke.';
$string['attachmentnopost'] = 'Ne možete da izvezete priloge bez identifikatora poruke';
$string['attachments'] = 'Prilozi';
$string['attachmentswordcount'] = 'Prilozi i broj reči';
$string['blockafter'] = 'Granična vrednost broja poruka koja dovodi do blokiranja';
$string['blockafter_help'] = 'Ovo podešavanje određuje najveći broj poruka koje korisnik može da pošalje na forum u datom vremenskom periodu. Ovo ograničenje ne važi za korisnike koji imaju sposobnost mod/forum:postwithoutthrottling.';
$string['blockperiod'] = 'Vremenski period nakon kog se vrši blokiranje';
$string['blockperioddisabled'] = 'Ne blokirati';
$string['blockperiod_help'] = 'Moguće je ograničiti broj poruka koje polaznici mogu poslati unutar datog vremenskog perioda. Ovo ograničenje ne važi za korisnike koji imaju ovlašćenja mod/forum:postwithoutthrottling.';
$string['blogforum'] = 'Standardni forum u obliku bloga';
$string['bynameondate'] = 'napisao/la {$a->name} - {$a->date}';
$string['cannotadd'] = 'Nije moguće dodati diskusiju na ovom forumu';
$string['cannotadddiscussion'] = 'Dodavanje diskusije u okviru ovog foruma zahteva grupno članstvo.';
$string['cannotadddiscussionall'] = 'Nemate dozvolu da dodajete novu temu za diskusiju za sve učesnike.';
$string['cannotadddiscussiongroup'] = 'Niste u mogućnosti da kreirate diskusiju zato što niste član nijedne grupe.';
$string['cannotaddsubscriber'] = 'Nije bilo moguće dodati pretplatnika sa identifikatorom {$a} na ovaj forum!';
$string['cannotaddteacherforumto'] = 'Nije bilo moguće dodati instancu izmenjenog foruma predavača u sekciju 0 ovoga kursa';
$string['cannotcreatediscussion'] = 'Nije bilo moguće otvoriti novu diskusiju';
$string['cannotcreateinstanceforteacher'] = 'Nije bilo moguće krerati novu instancu modula za predavački forum';
$string['cannotdeletepost'] = 'Ne možete da obrišete ovu poruku!';
$string['cannoteditposts'] = 'Ne možete da uređujete poruke drugih korisnika!';
$string['cannotfinddiscussion'] = 'Nije bilo moguće naći diskusiju na ovom forumu';
$string['cannotfindfirstpost'] = 'Nije bilo moguće naći prvu poruku na ovom forumu';
$string['cannotfindorcreateforum'] = 'Nije bilo moguće naći ili kreirati glavni forum za obaveštenja na ovom sajtu';
$string['cannotfindparentpost'] = 'Nije bilo moguće naći nadređenu poruku za poruku {$a}';
$string['cannotmovefromsingleforum'] = 'Nije moguće premestiti diskusiju iz foruma tipa \'jedna obična diskusija\'';
$string['cannotmovenotvisible'] = 'Forum nije vidljiv';
$string['cannotmovetonotexist'] = 'Ne možete da premestite u taj forum jer on ne postoji!';
$string['cannotmovetonotfound'] = 'Ciljni forum nije pronađen na ovom kursu.';
$string['cannotmovetosingleforum'] = 'Nije moguće premestiti diskusiju u forum tipa jedna obična diskusija';
$string['cannotpurgecachedrss'] = 'Nije bilo moguće očistiti RSS dovode iz keša za izvorni i/ili odredišni(e) forum(e) - proverite Vašu datoteku za dozvole foruma';
$string['cannotremovesubscriber'] = 'Nije bilo moguće ukloniti pretplatnika sa identifikatorom {$a} sa ovog foruma!';
$string['cannotreply'] = 'Ne možete da odgovorite na ovu poruku';
$string['cannotsplit'] = 'Diskusije sa ovog foruma ne mogu biti razdvojene';
$string['cannotsubscribe'] = 'Oprostite, ali morate biti član grupe da biste se pretplatili.';
$string['cannottrack'] = 'Nije moguće prestati s praćenjem ovog foruma';
$string['cannotunsubscribe'] = 'Nije moguće odjaviti se sa tog foruma';
$string['cannotupdatepost'] = 'Ne možete da ažurirate ovu poruku';
$string['cannotviewpostyet'] = 'Još uvek ne možete da čitate pitanja drugih polaznika u ovoj diskusiji jer niste poslali nijednu poruku';
$string['cannotviewusersposts'] = 'Ne postoje poruke ovog korisnika koje možete da vidite';
$string['cleanreadtime'] = 'Vreme kada se stare poruke obeležavaju kao pročitane';
$string['clicktosubscribe'] = 'Niste pretplaćeni na ovu diskusiju. Kliknite kako biste se pretplatili.';
$string['clicktounsubscribe'] = 'Pretplaćeni ste na ovu diskusiju. Kliknite da se odjavite.';
$string['completiondiscussions'] = 'Polaznik mora da kreira diskusiju:';
$string['completiondiscussionsdesc'] = 'Najmanji broj diskusija koje polaznik mora da kreira: {$a}';
$string['completiondiscussionsgroup'] = 'Zahtevaj diskusiju';
$string['completiondiscussionshelp'] = 'neophodno je kreiranje diskusije za završetak aktivnosti';
$string['completionposts'] = 'Polaznik mora da pošalje poruku ili odgovor:';
$string['completionpostsdesc'] = 'Najmanji broj diskusija ili odgovora koje polaznik mora da postuje: {$a}';
$string['completionpostsgroup'] = 'Obavezno slanje poruke';
$string['completionpostshelp'] = 'neophodno je slanje poruke ili odgovora za završetak aktivnosti';
$string['completionreplies'] = 'Polaznik mora da pošalje odgovor:';
$string['completionrepliesdesc'] = 'Najmanji broj odgovora koje polaznik mora da postuje: {$a}';
$string['completionrepliesgroup'] = 'Neophodan je odgovor na poruku';
$string['completionreplieshelp'] = 'neophodan je odgovor na poruku za završetak aktivnosti';
$string['configcleanreadtime'] = 'Vreme u toku dana kada se brišu stare poruke iz tabele "pročitano".';
$string['configdigestmailtime'] = 'Korisnici koji izaberu da im se poruke sa foruma šalju elektronskom poštom u skraćenom obliku, dobijaće jednu poruku dnevno. Ovo podešavanje zadaje vreme u toku dana kada će navedena poruka biti poslata (prvi sledeći kron koji se pokrene nakon zadatog vremena će ih poslati).';
$string['configdisplaymode'] = 'Podrazumevani način prikazivanja stranice sa diskusijama ukoliko isti nije podešen.';
$string['configenablerssfeeds'] = 'Ovaj prekidač će omogućiti korišćenja RSS servisa za sve forume. Ipak, moraćete ručno da uključite RSS podršku u podešavanjima za svaki forum posebno.';
$string['configenabletimedposts'] = 'Izaberite "da" ako želite da dozvolite podešavanje perioda prikazivanja poruke prilikom otvaranja nove diskusije na forumu.';
$string['configlongpost'] = 'Bilo koja poruka duža od ove vrednosti (izražene u broju znakova, ne računajući HTML oznake) smatra se predugom. Poruke prikazane na početnoj stranici sajta, stranice kurseva u društvenom formatu, ili korisnički profili se skraćuju prirodno na dužinu koja se kreće između vrednosti za forum_shortpost i forum_longpost.';
$string['configmanydiscussions'] = 'Maksimalan broj diskusija prikazanih na forumu po stranici';
$string['configmaxattachments'] = 'Podrazumevani maksimalni broj priloga dozvoljen po jednoj poruci.';
$string['configmaxbytes'] = 'Podrazumevana maksimalna veličina priloga za sve forume na sajtu (zavisno od ograničenja kurseva i ostalih lokalnih podešavanja)';
$string['configoldpostdays'] = 'Broj dana nakon kojeg se sve stare poruke smatraju pročitanim.';
$string['configreplytouser'] = 'Kada se poruka sa foruma šalje elektronskom poštom, hoće li ona sadržati elektronsku adresu autora poruke, tako da primalac poruke može na nju da odgovori lično a ne preko foruma? Čak i kada je ova opcija podešena na "Da", korisnici mogu da, u okviru svog korisničkog profila, odaberu da njihova elektronska adresa bude sakrivena od ostalih korisnika.';
$string['configrssarticlesdefault'] = 'Ako je RSS servis omogućen, podešava podrazumevani broj članaka (bilo diskusija ili postova).';
$string['configrsstypedefault'] = 'Ako su RSS izvori vesti omogućeni, podešava podrazumevani tip aktivnosti.';
$string['configshortpost'] = 'Svaka poruka kraća od ove vrednosti (izražene u broju znakova, ne računajući HTML oznake) smatra se kratkom (vidi ispod).';
$string['configsubscriptiontype'] = 'Podrazumevano podešavanje za režim pretplate.';
$string['configtrackingtype'] = 'Podrazumevano podešavanje za praćenje pročitanih/nepročitanih poruka.';
$string['configtrackreadposts'] = 'Podesite na "Da" ako želite da pratite pročitane/nepročitane poruke za svakog korisnika.';
$string['configusermarksread'] = 'Ako je izabrana opcija "da" korisnik mora ručno da obeleži poruku kao pročitanu, u suprotnom (opcija "ne") onog trenutka kada je korisnik video poruku ona će biti obeležena kao pročitana.';
$string['confirmsubscribe'] = 'Da li stvarno želite da se pretplatite na forum \'{$a}\'?';
$string['confirmsubscribediscussion'] = 'Da li stvarno želite da se pretplatite na diskusiju \'{$a->discussion}\' u okviru foruma \'{$a->forum}\'?';
$string['confirmunsubscribe'] = 'Da li zaista želite da se odjavite sa foruma \'{$a}\'?';
$string['confirmunsubscribediscussion'] = 'Da li stvarno želite da se odjavite sa diskusije \'{$a->discussion}\' u okviru foruma \'{$a->forum}\'?';
$string['couldnotadd'] = 'Nažalost, nije moguće dodati Vašu poruku zbog nepoznate greške';
$string['couldnotdeletereplies'] = 'Žao nam je, ova poruka se ne može obrisati pošto su drugi korisnici odgovorili na nju';
$string['couldnotupdate'] = 'Vaša poruka ne može biti ažurirana zbog nepoznate greške';
$string['crontask'] = 'Slanje pošte sa foruma i redovno održavanje platforme';
$string['delete'] = 'Obriši';
$string['deleteddiscussion'] = 'Ova tema je obrisana';
$string['deletedpost'] = 'Poruka je obrisana';
$string['deletedposts'] = 'Te poruke su obrisane';
$string['deletesure'] = 'Jeste li sigurni da želite da obrišete ovu poruku?';
$string['deletesureplural'] = 'Jeste li sigurni da želite da obrišete ovu poruku i SVE odgovore na nju? ({$a} poruka)';
$string['digestmailheader'] = 'Ovo je Vaš dnevni skraćeni prikaz novih poruka sa {$a->sitename} foruma. Da bi ste promenili način na koji će Vam biti slate poruke sa foruma idite na {$a->userprefs}.';
$string['digestmailpost'] = 'Promenite svoje preferencije vezane za rezime poruka sa foruma';
$string['digestmailpostlink'] = 'Promenite svoje preferencije vezane za rezime poruka sa foruma: {$a}';
$string['digestmailprefs'] = 'Vaš korisnički profil';
$string['digestmailsubject'] = '{$a}: skraćen prikaz poruka sa foruma';
$string['digestmailtime'] = 'Vreme za slanje e-pošte sa skraćenim izveštajima';
$string['digestsentusers'] = 'Skraćen prikaz poruka sa foruma uspešno je poslat na elektronske adrese {$a} korisnika';
$string['disallowsubscribe'] = 'Pretplate nisu dozvoljene';
$string['disallowsubscribeteacher'] = 'Pretplate nisu dozvoljene (osim predavačima)';
$string['disallowsubscription'] = 'Pretplata';
$string['disallowsubscription_help'] = 'Ovaj forum je tako podešen da ne možete da se pretplatite na diskusije.';
$string['discussion'] = 'Diskusija';
$string['discussionlocked'] = 'Ova diskusija je zaključana tako da više ne možete odgovarati na njoj.';
$string['discussionlockingdisabled'] = 'Ne zaključavaj diskusije';
$string['discussionlockingheader'] = 'Zaključavanje diskusija';
$string['discussionmoved'] = 'Ova diskusija je premeštena na \'{$a}\'.';
$string['discussionmovedpost'] = 'Ova diskusija je premeštena <a href="{$a->discusshref}">ovde</a> u forumu <a href="{$a->forumhref}">{$a->forumname}</a>';
$string['discussionname'] = 'Naziv diskusije';
$string['discussionnownotsubscribed'] = '{$a->name} NEĆE dobijati obaveštenja o novim porukama na diskusiji \'{$a->discussion}\' unutar foruma \'{$a->forum}\'';
$string['discussionnowsubscribed'] = '{$a->name} će dobijati obaveštenja o novim porukama na diskusiji \'{$a->discussion}\' unutar foruma \'{$a->forum}\'';
$string['discussionpin'] = 'Fiksiraj';
$string['discussionpinned'] = 'Fiksirana';
$string['discussionpinned_help'] = 'Fiksirane diskusije će se pojaviti na vrhu foruma.';
$string['discussions'] = 'Diskusije';
$string['discussionsplit'] = 'Diskusija je razdvojena';
$string['discussionsstartedby'] = 'Diskusiju započeo/la {$a}';
$string['discussionsstartedbyrecent'] = 'Diskusije koje je korisnik {$a} započeo u skorije vreme';
$string['discussionsstartedbyuserincourse'] = 'Diskusija koju je započeo/la {$a->fullname} na kursu {$a->coursename}';
$string['discussionsubscribestart'] = 'Šalji mi obaveštenja o novim porukama u ovoj diskusiji.';
$string['discussionsubscribestop'] = 'Ne želim da dobijam obaveštenja o novim porukama u ovoj diskusiji';
$string['discussionsubscription'] = 'Pretplata na diskusiju';
$string['discussionsubscription_help'] = 'Pretplaćivanje na diskusiju znači da ćete primiti obaveštenja o novim postovima u toj diskusiji.';
$string['discussionunpin'] = 'Ukloni fiksiranje';
$string['discussthistopic'] = 'Diskusija o ovoj temi';
$string['displayend'] = 'Kraj prikazivanja';
$string['displayend_help'] = 'Ovo podešavanje određuje da li će poruka na forumu biti sakrivene nakon određenog datuma. Napomena: administratori uvek mogu da vide poruke na forumu.';
$string['displaymode'] = 'Način prikazivanja';
$string['displayperiod'] = 'Period prikazivanja';
$string['displaystart'] = 'Početak prikazivanja';
$string['displaystart_help'] = 'Ovo podešavanje određuje da li će poruka na forumu biti prikazana od određenog datuma. Napomena: administratori uvek mogu da vide poruke na forumu.';
$string['displaywordcount'] = 'Prikaži broj reči';
$string['displaywordcount_help'] = 'Ovo podešavanje određuje da li treba prikazati broj reči svake poruke.';
$string['eachuserforum'] = 'Svaka osoba može započeti jednu diskusiju';
$string['edit'] = 'Uredi';
$string['editedby'] = 'Uredio/la  {$a->name} - izvorno objavljeno {$a->date}';
$string['editedpostupdated'] = 'Poruka koju je postovao/la {$a} je ažurirana';
$string['editing'] = 'Uređivanje';
$string['emaildigestcompleteshort'] = 'Kompletne poruke';
$string['emaildigestdefault'] = 'Podrazumevano ({$a})';
$string['emaildigestoffshort'] = 'Bez rezimea';
$string['emaildigestsubjectsshort'] = 'Samo naslovi';
$string['emaildigesttype'] = 'Opcije vezane za rezime koji se šalje elektronskom poštom';
$string['emaildigesttype_help'] = 'Tip obaveštenja koji ćete dobijati sa svakog foruma.

* Podrazumevani - pratiće se preferencije postavljene u Vašem korisničkom profilu. Ako ažurirate svoj profil promene će se odraziti i na ovo podešavanje;
* Bez rezimea - dobijaćete jednu elektronsku poruku po objavi na forumu;
* Rezime - kompletne objave - dobijaćete jednu elektronsku poruku na dan koja će sadržati kompletan sadržaj svih objava na forumu;
* Rezime - samo teme - dobijaćete jednu elektronsku poruku na dan koja će sadržati samo teme svih objava na forumu.';
$string['emptymessage'] = 'Nešto nije u redu sa vašom porukom. Možda ste ostavili prazna polja, ili je prilog bio prevelik. Vaše promene NISU sačuvane.';
$string['erroremptymessage'] = 'Telo poruke ne može biti prazno';
$string['erroremptysubject'] = 'Tema (naslov) poruke ne može biti prazna';
$string['errorenrolmentrequired'] = 'Da biste pristupili ovom sadržaju morate biti upisani na ovaj kurs';
$string['errorwhiledelete'] = 'Došlo je do greške u toku brisanja zapisa';
$string['eventassessableuploaded'] = 'Objavljen je neki sadržaj.';
$string['eventcoursesearched'] = 'Kurs pretražen';
$string['eventdiscussioncreated'] = 'Diskusija kreirana';
$string['eventdiscussiondeleted'] = 'Diskusija obrisana';
$string['eventdiscussionmoved'] = 'Diskusija premeštena';
$string['eventdiscussionpinned'] = 'Diskusija je fiksirana';
$string['eventdiscussionsubscriptioncreated'] = 'Pretplata na diskusiju kreirana';
$string['eventdiscussionsubscriptiondeleted'] = 'Pretplata na diskusiju obrisana';
$string['eventdiscussionunpinned'] = 'Diskusiji je uklonjeno fiksiranje';
$string['eventdiscussionupdated'] = 'Diskusija ažurirana';
$string['eventdiscussionviewed'] = 'Diskusija prikazana';
$string['eventpostcreated'] = 'Poruka kreirana';
$string['eventpostdeleted'] = 'Poruka na forumu obrisana';
$string['eventpostupdated'] = 'Poruka ažurirana';
$string['eventreadtrackingdisabled'] = 'Praćenje pročitanih/nepročitanih poruka onemogućeno';
$string['eventreadtrackingenabled'] = 'Praćenje pročitanih/nepročitanih poruka omogućeno';
$string['eventsubscribersviewed'] = 'Pretplatnici foruma prikazani';
$string['eventsubscriptioncreated'] = 'Pretplata kreirana';
$string['eventsubscriptiondeleted'] = 'Pretplata obrisana';
$string['eventuserreportviewed'] = 'Izveštaj o korisniku prikazan';
$string['everyonecanchoose'] = 'Svako može izabrati da bude pretplaćen';
$string['everyonecannowchoose'] = 'Svako može sada da izabere da li će biti pretplaćen na ovaj forum';
$string['everyoneisnowsubscribed'] = 'Svi su sada pretplaćeni na ovaj forum';
$string['everyoneissubscribed'] = 'Svi su pretplaćeni na ovaj forum';
$string['existingsubscribers'] = 'Postojeći pretplatnici';
$string['exportdiscussion'] = 'Izvezi celu diskusiju u portfolio';
$string['forcedreadtracking'] = 'Dozvoli obavezno praćenje pročitanih/nepročitanih poruka';
$string['forcedreadtracking_desc'] = 'Ova opcija dozvoljava da forumi budu podešeni tako da se obavezno prate pročitane/nepročitane poruke. Ovo će dovesti do smanjenja performansi sistema za neke korisnike, naročito na kursevima sa velikim brojem foruma i poruka. Kada se isključi, svi forumi, prethodno podešeni na "obavezno", biće prebačeni na opciono praćenje pročitanih/nepročitanih poruka.';
$string['forcesubscribed'] = 'Pretplata na ovaj forum je obavezno za sve';
$string['forcesubscribed_help'] = 'Ovaj forum je tako podešen da ne možete da se odjavite sa diskusija.';
$string['forum'] = 'Forum';
$string['forum:addinstance'] = 'Dodaj novi forum';
$string['forum:addnews'] = 'Dodaj obaveštenja';
$string['forum:addquestion'] = 'Dodaj pitanje';
$string['forum:allowforcesubscribe'] = 'Dozvoljava prinudnu pretplatu na forum';
$string['forumauthorhidden'] = 'Autor (skriveno)';
$string['forumblockingalmosttoomanyposts'] = 'Približavate se maksimalnom mogućem broju poruka na ovom forumu. Objavili ste {$a->numposts} poruka u poslednjih {$a->blockperiod} a limit je {$a->blockafter} poruka.';
$string['forumbodydeleted'] = 'Sadržaj ove poruke na forumu je uklonjen i više mu se ne može pristupiti.';
$string['forumbodyhidden'] = 'Ovu poruku ne možete da vidite, verovatno zato što: još niste učestvovali u diskusiji, još nije isteklo maksimalno dozvoljeno vreme za uređivanje poruke, diskusija još nije započeta ili zato što je diskusija istekla.';
$string['forum:canoverridediscussionlock'] = 'Odgovaranje na zaključanim diskusijama';
$string['forum:canposttomygroups'] = 'Slanje poruka svim grupama kojima imate pristup';
$string['forum:createattachment'] = 'Kreiraj priloge';
$string['forum:deleteanypost'] = 'Obriši sve poruke (u bilo koje vreme)';
$string['forum:deleteownpost'] = 'Obriši svoje poruke (u zadatom roku)';
$string['forum:editanypost'] = 'Uredi bilo koju poruku';
$string['forum:exportdiscussion'] = 'Izvezi kompletnu diskusiju';
$string['forum:exportownpost'] = 'Izvezi svoju poruku';
$string['forum:exportpost'] = 'Izvezi poruku';
$string['forumintro'] = 'Opis';
$string['forum:managesubscriptions'] = 'Upravljanje pretplatnicima';
$string['forum:movediscussions'] = 'Premesti diskusije';
$string['forumname'] = 'Naziv foruma';
$string['forum:pindiscussions'] = 'Fiksiraj diskusije';
$string['forumposts'] = 'Poruke na forumu';
$string['forum:postwithoutthrottling'] = 'Izuzet od ograničenja broja poruka';
$string['forum:rate'] = 'Oceni poruke';
$string['forum:replynews'] = 'Odgovori na obaveštenja';
$string['forum:replypost'] = 'Odgovori na poruke';
$string['forums'] = 'Forumi';
$string['forum:splitdiscussions'] = 'Podeli diskusije';
$string['forum:startdiscussion'] = 'Započni nove diskusije';
$string['forumsubjectdeleted'] = 'Ova poruka na forumu je uklonjena';
$string['forumsubjecthidden'] = 'Tema (skriveno)';
$string['forumtracked'] = 'Nepročitane poruke se prate';
$string['forumtrackednot'] = 'Nepročitane poruke se ne prate';
$string['forumtype'] = 'Tip foruma';
$string['forumtype_help'] = 'Postoji 5 tipova foruma:

* Jedna obična diskusija - forum u obliku samo jedne teme o kojoj svi mogu diskutovati i slati svoje odgovore (ne može se koristiti sa odvojenim grupama)
* Svaki učesnik pokreće jednu diskusiju - svaki polaznik može pokrenuti samo jednu novu temu za diskusiju, na koju svi mogu da odgovaraju
* Forum pitanja i odgovora - polaznici moraju prvo da pošalju svoj odgovor pre nego što vide odgovore drugih
* Standarni forum u obliku bloga - otvoreni forum u kojem svako u bilo kom trenutku može započeti novu diskusiju, i u kom su teme za diskusiju prikazane na jednoj stranici sa linkom "Diskutuj o ovoj temi"
* Standardni forum za opštu upotrebu - otvoreni forum u kojem svako može započeti novu diskusiju u bilo kom trenutku';
$string['forum:viewallratings'] = 'Pogledaj sve neobrađene ocene koje su dali pojedinci';
$string['forum:viewanyrating'] = 'Pogledaj sve ocene koje je dobio bilo ko';
$string['forum:viewdiscussion'] = 'Pregled diskusija';
$string['forum:viewhiddentimedposts'] = 'Pogledaj skrivene, vremenski ograničene poruke';
$string['forum:viewqandawithoutposting'] = 'Uvek vidi poruke na forumu "Pitanja i odgovori"';
$string['forum:viewrating'] = 'Pogledajte sve ocene koje ste dobili';
$string['forum:viewsubscribers'] = 'Pregled pretplatnika';
$string['generalforum'] = 'Standardni forum za opštu upotrebu';
$string['generalforums'] = 'Opšti forumi';
$string['hiddenforumpost'] = 'Skrivena poruka na forumu';
$string['indicator:cognitivedepth'] = 'Forum - kognitivni aspekt';
$string['indicator:cognitivedepth_help'] = 'Ovaj indikator se zasniva na kognitivnoj dubini koju je polaznik postigao u okviru aktivnosti \'Forum\'.';
$string['indicator:socialbreadth'] = 'Forum - socijalni aspekt';
$string['indicator:socialbreadth_help'] = 'Ovaj indikator se zasniva na obimu socijalnih interakcija koji je polaznik postigao u okviru aktivnosti \'Forum\'.';
$string['inforum'] = 'u {$a}';
$string['introblog'] = 'Poruke u ovom forumu su automatski ovde kopirane iz bloga korisnika na ovom kursu zato što ti članci bloga nisu više dostupni';
$string['intronews'] = 'Opšte novosti i obaveštenja';
$string['introsocial'] = 'Otvoreni forum za razgovor o bilo kojoj temi';
$string['introteacher'] = 'Forum rezervisan za beleške i duskusije predavača';
$string['invalidaccess'] = 'Ovoj strani nije ispravno pristupljeno';
$string['invaliddigestsetting'] = 'Podešavanje rezimea objava koje se šalju elektronskom poštom koje je dato nije validno';
$string['invaliddiscussionid'] = 'Identifikator diskusije nije bio ispravan ili više ne postoji';
$string['invalidforcesubscribe'] = 'Neispravan način obavezne pretplate';
$string['invalidforumid'] = 'ID foruma nije bio tačan';
$string['invalidparentpostid'] = 'ID nadređene poruke je neispravan';
$string['invalidpostid'] = 'Neispravan ID poruke - {$a}';
$string['lastpost'] = 'Poslednja poruka';
$string['learningforums'] = 'Forumi za učenje';
$string['lockdiscussionafter'] = 'Zaključaj diskusije nakon perioda neaktivnosti';
$string['lockdiscussionafter_help'] = 'Diskusije mogu biti automatski zaključane nakon što prođe specificirano vreme od poslednjeg odgovora na njima.

Korisnici sa sposobnošću da daju odgovore na zaključanim diskusijama mogu otključati bilo koju diskusiju jednim svojim odgovorom na njoj.';
$string['longpost'] = 'Dugačka poruka';
$string['mailnow'] = 'Pošalji obaveštenje o poruci na forumu odmah, ne čekajući vreme dozvoljeno za uređivanje poruke';
$string['managesubscriptionsoff'] = 'Završi upravljanje pretplatama';
$string['managesubscriptionson'] = 'Upravljanje pretplatnicima';
$string['manydiscussions'] = 'Broj diskusija po stranici';
$string['markalldread'] = 'Označi sve poruke ove diskusije kao pročitane.';
$string['markallread'] = 'Označi sve poruke na ovom forumu kao pročitane.';
$string['markasreadonnotification'] = 'Pri slanju obaveštenja sa objavama sa foruma';
$string['markasreadonnotification_help'] = 'Kada ste obavešteni o objavi na forumu, možete odabrati da li će to označiti objavu pročitanom u svrhu praćenja foruma.';
$string['markasreadonnotificationno'] = 'Nemoj označiti objavu pročitanom';
$string['markasreadonnotificationyes'] = 'Označi objavu pročitanom';
$string['markread'] = 'Označi kao pročitano';
$string['markreadbutton'] = 'Označi kao<br /> pročitano';
$string['markunread'] = 'Označi kao nepročitano';
$string['markunreadbutton'] = 'Označi kao<br /> nepročitano';
$string['maxattachments'] = 'Maksimalan broj priloga';
$string['maxattachments_help'] = 'Ovo podešavanje određuje maksimalan broj datoteka koje mogu biti priložene uz poruku.';
$string['maxattachmentsize'] = 'Maksimalna veličina priloga';
$string['maxattachmentsize_help'] = 'Ovo podešavanje određuje maksimalnu veličinu datoteke koja može biti priložena uz poruku.';
$string['maxtimehaspassed'] = 'Nažalost, maksimalno vreme za uređivanje ove poruke ({$a}) je isteklo!';
$string['message'] = 'Poruka';
$string['messageinboundattachmentdisallowed'] = 'Nije moguće poslati vaš odgovor, zato što sadrži prilog, a forum ne dozvoljava priloge.';
$string['messageinboundfilecountexceeded'] = 'Nije moguće poslati vaš odgovor, zato što sadrži više od maksimalnog broja priloga koji forum dozvoljava ({$a->forum->maxattachments}).';
$string['messageinboundfilesizeexceeded'] = 'Nije moguće poslati vaš odgovor, zato što je ukupna veličina priloga ({$a->filesize}) veća od maksimalne veličine koju forum dozvoljava ({$a->maxbytes})..';
$string['messageinboundforumhidden'] = 'Nije moguće poslati vaš odgovor, zato što je forum trenutno nedostupan.';
$string['messageinboundnopostforum'] = 'Nije moguće poslati vaš odgovor, zato što nemate ovlašćenja da postujete poruke na forumu {$a->forum->name}.';
$string['messageinboundthresholdhit'] = 'Nije moguće poslati vaš odgovor. Premašili ste dozvoljeni broj poruka  za ovaj forum.';
$string['messageprovider:digests'] = 'Izvodi poruka sa foruma sa pretplatom';
$string['messageprovider:posts'] = 'Poruke sa foruma sa pretplatom';
$string['missingsearchterms'] = 'Sledeći traženi termini se javljaju isključivo unutar HTML oznaka ove poruke:';
$string['modeflatnewestfirst'] = 'Prikaz odgovora, počevši prvo s najnovijim';
$string['modeflatoldestfirst'] = 'Prikaz odgovora, počevši prvo s najstarijim';
$string['modenested'] = 'Prikaz odgovora u ugnežđenoj formi';
$string['modethreaded'] = 'Prikaz odgovora u nizu';
$string['modulename'] = 'Forum';
$string['modulename_help'] = 'Modul aktivnosti \'Forum\' omogućava učesnicima da vode asinhrone diskusije tj, da diskutuju na različite teme u dužem vremenskom periodu.
 
Postoji nekoliko tipova foruma koji se mogu izabrati, kao što su standardni forumu gde svako može da započne novu diskusiju u bilo kom trenutku; forum gde svaki polaznik može da pokrene samo jednu diskusiju, ili forum \'Pitanje i odgovor\' gde polaznici moraju prvo da postuju svoj odgovor pre nego što bude u mogućnosti da vide odgovore drugih polaznika. Predavač može da dozvoli polaznicima da uz svoje poruke na forumima prilažu datoteke. Priložene slike se prikazuju unutar same poruke.
 
Učesnici mogu da se pretplate (prijave) na forum kako bi redovno primali obaveštenja o novim porukama. Predavač može da podesi režim pretplate na opcioni, obavezni ili automatski, ili da potpuno spreči mogućnost pretplate na forum. Ako je potrebno, moguće je, takođe, sprečiti da polaznici šalju više od određenog broja poruka, u datom vremenskom periodu; na ovaj način može se sprečiti da pojedinci dominiraju diskusijama.
 
Poruke na forumima mogu biti ocenjivane kako od strane predavača, tako i od strane polaznika (vršnjačka evaluacija). Ocene mogu da se sabiraju kako bi se formirala finalna ocena koja se beleži u knjigu ocena.
 
Forumi mogu da se koriste na vrlo različite načine, kao na primer:
 
* društveni prostor za međusobno upoznavanje i druženje polaznika
* za objavljivanje važnih obaveštenja na kursu (koristeći forum \'Vesti\' na koji su, standardno, svi polaznici pretplaćeni)
* za diskutovanje o sadržaju odnosno temama koje kurs pokriva
* za nastavak diskusije u onlajn okruženju, o temama koje se prethodno započete u učionici
* za diskusije namenjene samo predavačima (koristeći opciju za sakrivanje foruma od polaznika)
* kao centar za pomoć, gde polaznici mogu da dobiju pomoć i savet od strane predavača i iskusnijih polaznika
* za dodatne aktivnosti, na primer \'mozgalice\' za polaznike o kojima oni treba da razmisle i ponude rešenja';
$string['modulenameplural'] = 'Forumi';
$string['more'] = 'još';
$string['movedmarker'] = '(Premešteno)';
$string['movethisdiscussionto'] = 'Premesti ovu diskusiju u ...';
$string['mustprovidediscussionorpost'] = 'Morate navesti identifikator diskusije ili poruke da biste ih izvezli';
$string['myprofileotherdis'] = 'Diskusije na forumima';
$string['myprofileowndis'] = 'Moje diskusije na forumima';
$string['myprofileownpost'] = 'Moje poruke na forumima';
$string['namenews'] = 'Obaveštenja';
$string['namenews_help'] = 'Forum \'Obaveštenja\' je specijalni forum za obaveštenja koji se automatski kreira kada se otvara novi kurs. Kurs možete imati samo jedan ovakav forum na koji obaveštenja mogu da postavljaju samo predavači i administratori. Blok "Najnovija obaveštenja" će prikazivati najnovija obaveštenja.';
$string['namesocial'] = 'Društveni forum';
$string['nameteacher'] = 'Forum predavača';
$string['newforumposts'] = 'Nove poruke na forumu';
$string['nextdiscussiona'] = 'Sledeća diskusija: {$a}';
$string['noattachments'] = 'Ova poruka nema priloga';
$string['nodiscussions'] = 'Još nema tema za diskusiju na ovom forumu';
$string['nodiscussionsstartedby'] = '{$a} nije započeo/la nijednu diskusiju';
$string['nodiscussionsstartedbyyou'] = 'Još niste započeli nijednu diksusiju';
$string['noguestpost'] = 'Nažalost, gostima nije dozvoljeno slanje poruka.';
$string['noguestsubscribe'] = 'Nažalost, gostima nije dozvoljeno da se pretplate na forume.';
$string['noguesttracking'] = 'Nažalost, gostima nije dozvoljeno da podešavaju opcije za praćenje poruka.';
$string['nomorepostscontaining'] = 'Nema više poruka koje sadrže \'{$a}\'';
$string['nonews'] = 'Nije objavljeno još nije jedno obaveštenje.';
$string['noonecansubscribenow'] = 'Pretplate trenutno nisu dozvoljene';
$string['nopermissiontosubscribe'] = 'Nemate dozvolu da vidite ko se pretplatio na forum';
$string['nopermissiontoview'] = 'Nemate dozvolu da vidite ovu poruku';
$string['nopostforum'] = 'Oprostite, ali nije vam dozvoljeno slanje poruka na ovaj forum';
$string['noposts'] = 'Nema poruka';
$string['nopostsmadebyuser'] = '{$a} nije poslao/la nijednu poruku';
$string['nopostsmadebyyou'] = 'Niste napisali nijednu poruku';
$string['noquestions'] = 'Još nema pitanja na ovom forumu';
$string['nosubscribers'] = 'Još uvek nema pretplatnika za ovaj forum';
$string['notexists'] = 'Diskusija više ne postoji';
$string['nothingnew'] = 'Ništa novo za {$a}';
$string['notingroup'] = 'Nažalost, morate biti deo grupe da biste videli ovaj forum.';
$string['notinstalled'] = 'Modul Forum nije instaliran';
$string['notpartofdiscussion'] = 'Ova poruka nije deo diskusije';
$string['notrackforum'] = 'Ne prati nepročitane poruke';
$string['notsubscribed'] = 'Pretplati se';
$string['noviewdiscussionspermission'] = 'Nemate dozvolu da vidite diskusije na ovom forumu';
$string['nowallsubscribed'] = 'Sada ste pretplaćeni na sve forume na {$a}.';
$string['nowallunsubscribed'] = 'Sada ste odjavljeni sa svih foruma na {$a}.';
$string['nownotsubscribed'] = '{$a->name} NEĆE primati e-poruke sa kopijama poruka s foruma \'{$a->forum}\'.';
$string['nownottracking'] = '{$a->name} više ne prati poruke na forumu \'{$a->forum}\'.';
$string['nowsubscribed'] = '{$a->name} će primati e-poruke sa kopijama poruka s foruma \'{$a->forum}\'.';
$string['nowtracking'] = '{$a->name} prati poruke na forumu \'{$a->forum}\'.';
$string['numposts'] = 'Broj poruka: {$a}';
$string['olderdiscussions'] = 'Starije diskusije';
$string['oldertopics'] = 'Starije teme';
$string['oldpostdays'] = 'Broj dana nakon kojih se stare poruke smatraju pročitanim';
$string['overviewnumpostssince'] = '{$a} poruka/e od poslednje prijave na sistem';
$string['overviewnumunread'] = 'ukupno nepročitanih: {$a}';
$string['page-mod-forum-discuss'] = 'Stranica sa diskusijom modula \'Forum\'';
$string['page-mod-forum-view'] = 'Glavna stranica foruma';
$string['page-mod-forum-x'] = 'Bilo koja stranica foruma';
$string['parent'] = 'Prikaži nadređenu poruku';
$string['parentofthispost'] = 'Poruka nadređena ovoj poruci';
$string['permalink'] = 'Stalni link';
$string['pluginadministration'] = 'Administracija foruma';
$string['pluginname'] = 'Forum';
$string['postadded'] = '<p>Vaša poruka je uspešno dodata.</p> <p>Imate {$a} za promenu sadržaja iste, ukoliko to želite.</p>';
$string['postaddedsuccess'] = 'Vaša poruka je uspešno dodata.';
$string['postaddedtimeleft'] = 'Imate {$a} minuta da uredite poruku ako želite da napravite bilo kakve izmene.';
$string['postbymailsuccess'] = 'Čestitamo, vaša poruka sa temom "{$a->subject}" uspešno je dodata. Možete je pogledati na sledećoj adresi {$a->discussionurl}.';
$string['postbymailsuccess_html'] = 'Čestitamo, vaša <a href="{$a->discussionurl}">poruka</a> sa temom "{$a->subject}" uspešno je dodata.';
$string['postbyuser'] = '{$a->post} napisao/la {$a->user}';
$string['postincontext'] = 'Pogledaj poruku u kontekstu';
$string['postmailinfolink'] = 'Ovo je kopija poruke sa foruma na kursu {$a->coursename}.
 
Da biste odgovorili poruku kliknite na ovaj link: {$a->replylink}';
$string['postmailnow'] = '<p>Ova poruka će biti odmah poslata svima koji su pretplaćeni na ovaj forum.</p>';
$string['postmailsubject'] = '{$a->courseshortname}: {$a->subject}';
$string['postrating1'] = 'Uglavnom odvojeno znanje';
$string['postrating2'] = 'Odvojeno i povezano';
$string['postrating3'] = 'Uglavnom povezano znanje';
$string['posts'] = 'Poruke';
$string['postsmadebyuser'] = 'Poruka koju je poslao/la {$a}';
$string['postsmadebyuserincourse'] = 'Poruka koju je poslao/la {$a->fullname} na kursu {$a->coursename}';
$string['posttoforum'] = 'Pošalji poruku na forum';
$string['posttomygroups'] = 'Pošaljij kopiju poruke svim grupama';
$string['posttomygroups_help'] = 'Šalje kopiju ove poruke svim grupama kojima imate pristup. Učesnici u grupama kojima nemate pristup neće videti ovu poruku.';
$string['postupdated'] = 'Vaša poruka je ažurirana';
$string['potentialsubscribers'] = 'Potencijalni pretplatnici';
$string['prevdiscussiona'] = 'Prethodna diskusija: {$a}';
$string['privacy:digesttypenone'] = 'Ne čuvamo nikakve podatke koji se tiču preferiranog tipa sažetka poruka za ovaj forum.';
$string['privacy:digesttypepreference'] = 'Izabrali ste da primate sledeći tip sažetka poruka sa foruma: "{$a->type}".';
$string['privacy:discussionsubscriptionpreference'] = 'Izabrali ste sledeće parametre za pretplatu na diskusije za ovaj forum: "{$a->preference}"';
$string['privacy:metadata:core_rating'] = 'Forum koristi podsistem za ocenjivanje kako bi podržao ocenjivanje postova.';
$string['privacy:metadata:core_tag'] = 'Forum koristi podsistem za oznake kako bi podržao označavanje postova.';
$string['privacy:metadata:forum_digests'] = 'Forum koristi podsistem za oznake kako bi podržao označavanje postova.';
$string['privacy:metadata:forum_digests:forum'] = 'Forum na koji se korisnik pretplatio.';
$string['privacy:metadata:forum_digests:maildigest'] = 'Parametri za sažetak poruka.';
$string['privacy:metadata:forum_digests:userid'] = 'ID oznaka korisnika sa parametrima za skraćeni prikaz poruka.';
$string['privacy:metadata:forum_discussions'] = 'Informacije o pojedinačnim diskusijama na forumu koje je korisnik kreirao';
$string['privacy:metadata:forum_discussions:assessed'] = 'TODOD - šta ovo polje čuva';
$string['privacy:metadata:forum_discussions:name'] = 'Naziv diskusije, po izboru autora.';
$string['privacy:metadata:forum_discussions:timemodified'] = 'Vreme kada je diskusija poslednji put izmenjena.';
$string['privacy:metadata:forum_discussion_subs'] = 'Informacije o pretplatama na pojedinačne diskusije na forumu.';
$string['privacy:metadata:forum_discussion_subs:discussionid'] = 'ID oznaka diskusije na koju postoji pretplata.';
$string['privacy:metadata:forum_discussion_subs:preference'] = 'Vreme početka pretplate.';
$string['privacy:metadata:forum_discussion_subs:userid'] = 'ID oznaka korisnika sa pretplatom na diskusiju.';
$string['privacy:metadata:forum_discussions:userid'] = 'ID oznaka korisnika koji je kreirao diskusiju';
$string['privacy:metadata:forum_discussions:usermodified'] = 'ID oznaka korisnika koji je na neki način poslednji izmenio diskusiju.';
$string['privacy:metadata:forum_posts'] = 'Informacije o parametrima za rezime poruka za svaki forum.';
$string['privacy:metadata:forum_posts:created'] = 'Vreme kada je post kreiran.';
$string['privacy:metadata:forum_posts:discussion'] = 'Diskusija u kojoj je post.';
$string['privacy:metadata:forum_posts:message'] = 'Poruka posta na forumu.';
$string['privacy:metadata:forum_posts:modified'] = 'Vreme kada je post poslednji put izmenjen.';
$string['privacy:metadata:forum_posts:parent'] = 'Nadređeni post na koji je poslat odgovor.';
$string['privacy:metadata:forum_posts:subject'] = 'Tema posta na forumu.';
$string['privacy:metadata:forum_posts:totalscore'] = 'Poruka posta na forumu.';
$string['privacy:metadata:forum_posts:userid'] = 'ID oznaka korisnika koji je autor posta na forumu.';
$string['privacy:metadata:forum_queue'] = 'Privremeni zapis poruka sa foruma koji će biti poslati u sažetom obliku';
$string['privacy:metadata:forum_queue:discussionid'] = 'ID oznaka diskusije na forumu';
$string['privacy:metadata:forum_queue:postid'] = 'ID oznaka posta na forumu';
$string['privacy:metadata:forum_queue:timemodified'] = 'Vreme izmene originalne objave';
$string['privacy:metadata:forum_queue:userid'] = 'Korisnik kog je potrebno obavestiti o objavi';
$string['privacy:metadata:forum_read'] = 'Informacije o tome koje objave je korisnik pročitao.';
$string['privacy:metadata:forum_read:discussionid'] = 'Diskusija u kojoj je objava.';
$string['privacy:metadata:forum_read:firstread'] = 'Vreme kada je objava prvi put pročitana.';
$string['privacy:metadata:forum_read:lastread'] = 'Najskorije vreme kada je objava pročitana.';
$string['privacy:metadata:forum_read:postid'] = 'Objava je pročitana.';
$string['privacy:metadata:forum_read:userid'] = 'Identifikator korisnika na kog se odnosi ovaj zapis.';
$string['privacy:metadata:forum_subscriptions'] = 'Informacije o tome na koje forume je korisnik pretplaćen.';
$string['privacy:metadata:forum_subscriptions:forum'] = 'Forum na koji je korisnik pretplaćen.';
$string['privacy:metadata:forum_subscriptions:userid'] = 'Identifikator korisnika na kog se odnosi pretplata na ovaj forum.';
$string['privacy:metadata:forum_track_prefs'] = 'Informacije o tome na kojim forumima je korisnik odabrao da prati pročitanost poruka.';
$string['privacy:metadata:forum_track_prefs:forumid'] = 'Forum na kom je omogućeno praćenje pročitanosti poruka.';
$string['privacy:metadata:forum_track_prefs:userid'] = 'Identifikator korisnika na kog se odnosi preferencija o praćenju ovog foruma.';
$string['privacy:metadata:preference:autosubscribe'] = 'Da li da se uradi pretplata na diskusije kada se odgovara na objave unutar njih.';
$string['privacy:metadata:preference:maildigest'] = 'Parametri za slanje skraćenog prikaza poruka e-poštom na nivou sajta';
$string['privacy:metadata:preference:markasreadonnotification'] = 'Da li da se objave na forumu označe pročitanim kada se primaju njihove kopije elektronskom poštom.';
$string['privacy:metadata:preference:trackforums'] = 'Da li da se omogući praćenje pročitanosti.';
$string['privacy:postwasread'] = 'Ova objava je prvi put pročitana dana {$a->firstread} a poslednji put dana {$a->lastread}';
$string['privacy:readtrackingdisabled'] = 'Izabrali ste da ne pratite poruke koje ste pročitali u ovom forumu.';
$string['privacy:request:delete:discussion:name'] = 'Brisanje na zahtev autora';
$string['privacy:request:delete:post:message'] = 'Sadržaj ove objave je obrisan na zahtev njegovog autora.';
$string['privacy:request:delete:post:subject'] = 'Obriši na zahtev autora';
$string['privacy:subscribedtoforum'] = 'Pretplaćeni ste na ovaj forum.';
$string['processingdigest'] = 'Slanje izvoda putem e-pošte korisniku {$a}';
$string['processingpost'] = 'Obrađuje se poruka {$a}';
$string['prune'] = 'Razdvoj';
$string['prunedpost'] = 'Od ove poruke kreirana je nova diskusija';
$string['pruneheading'] = 'Razdvoj diskusiju i premesti ovu poruku u novu diskusiju';
$string['qandaforum'] = 'Forum pitanja i odgovora';
$string['qandanotify'] = 'Ovo je forum pitanja i odgovora. Da biste videli odgovore drugih na ova pitanja, morate prvo poslati svoj odgovor';
$string['re'] = 'Odgovor:';
$string['readtherest'] = 'Pročitajte ostatak ove teme';
$string['removeallforumtags'] = 'Ukloni sve oznake foruma';
$string['replies'] = 'Odgovori';
$string['repliesmany'] = '{$a} odgovora do sada';
$string['repliesone'] = '{$a} odgovor do sada';
$string['reply'] = 'Odgovori';
$string['replyforum'] = 'Odgovori na forumu';
$string['reply_handler'] = 'Odgovori na poruke sa foruma putem e-pošte.';
$string['reply_handler_name'] = 'Odgovori na poruke sa foruma';
$string['replytopostbyemail'] = 'Možete odgovoriti na ovu poruku elektronskom poštom.';
$string['replytouser'] = 'Koristi adresu e-pošte u odgovoru';
$string['resetdigests'] = 'Obriši sve preferencije korisnika vezane za rezime poruka sa foruma';
$string['resetforums'] = 'Obriši poruke sa';
$string['resetforumsall'] = 'Obriši sve poruke';
$string['resetsubscriptions'] = 'Obriši sve pretplate na forum';
$string['resettrackprefs'] = 'Obriši sva podešavanja za praćenje foruma';
$string['rssarticles'] = 'Broj skorašnjih RSS članaka';
$string['rssarticles_help'] = 'Ovo podešavanje određuje broj članaka (diskusija ili poruka) koji će biti uključeni u RSS izvor vesti. Za većinu foruma je prihvatljivo da to bude između 5 i 20 članaka.';
$string['rsssubscriberssdiscussions'] = 'RSS izvor diskusija';
$string['rsssubscriberssposts'] = 'RSS izvor poruka';
$string['rsstype'] = 'RSS izvor za ovu aktivnost';
$string['rsstypedefault'] = 'Tip RSS izvora vesti';
$string['rsstype_help'] = 'Da biste uključili RSS izvor vesti za ovu aktivnost odaberite diskusije ili poruke koje će biti uključen u ovaj izvor.';
$string['search'] = 'Pretraživanje';
$string['search:activity'] = 'Forum - informacije o aktivnosti';
$string['searchdatefrom'] = 'Poruke moraju biti svežije od';
$string['searchdateto'] = 'Poruke moraju biti starije od';
$string['searchforumintro'] = 'Molimo da unesete termine pretraživanja u jedno ili više od sledećih polja:';
$string['searchforums'] = 'Pretraži forume';
$string['searchfullwords'] = 'Ove reči treba da se pojave kao cele reči';
$string['searchnotwords'] = 'Ove reči NE treba da budu uključene';
$string['searcholderposts'] = 'Pretraži starije poruke...';
$string['searchphrase'] = 'Ova konkretna fraza se mora naći u poruci';
$string['search:post'] = 'Forum - postovi';
$string['searchresults'] = 'Rezultati pretrage';
$string['searchsubject'] = 'Ove reči treba da budu u temi poruke';
$string['searchtags'] = 'Označen je sa';
$string['searchuser'] = 'Ovo ime treba da odgovara imenu autora poruke';
$string['searchuserid'] = 'Moodle identifikator autora poruke';
$string['searchwhichforums'] = 'Izaberite koje forume treba pretražiti';
$string['searchwords'] = 'Ove reči se mogu pojaviti bilo gde u poruci';
$string['seeallposts'] = 'Pogledaj sve poruke ovog korisnika';
$string['shortpost'] = 'Kratka poruka';
$string['showsubscribers'] = 'Prikaži/uredi spisak trenutnih pretplatnika';
$string['singleforum'] = 'Jedna obična diskusija';
$string['smallmessage'] = '{$a->user} je poslao/la poruku na {$a->forumname}';
$string['smallmessagedigest'] = 'Broj poruka  sa foruma koji sadrži sažeti prikaz: {$a}';
$string['startedby'] = 'Započeo/la';
$string['subject'] = 'Tema';
$string['subscribe'] = 'Pretplatite se na ovaj forum';
$string['subscribeall'] = 'Prijavi sve korisnike na ovaj forum';
$string['subscribed'] = 'Pretplaćeni';
$string['subscribediscussion'] = 'Prijavi se za ovu diskusiju';
$string['subscribeenrolledonly'] = 'Nažalost, samo korisnici upisani na neki od kurseva mogu da se pretplate da primaju obaveštenja sa foruma e-poštom.';
$string['subscribenone'] = 'Odjavi sve korisnike sa ovog foruma';
$string['subscribers'] = 'Pretplatnici';
$string['subscriberstowithcount'] = 'Prijavljeni na "{$a->name}" ({$a->count})';
$string['subscribestart'] = 'Pošaljite mi obaveštenja o novim porukama na ovom forumu';
$string['subscribestop'] = 'Ne želim da dobijam obaveštenja o novim porukama na ovom forumu';
$string['subscription'] = 'Pretplata';
$string['subscriptionandtracking'] = 'Pretplata i praćenje';
$string['subscriptionauto'] = 'Automatska pretplata';
$string['subscriptiondisabled'] = 'Pretplata je onemogućena';
$string['subscriptionforced'] = 'Obavezna pretplata';
$string['subscription_help'] = 'Ako ste pretplaćeni na forum, to znači da ćete primati obaveštenja o novim porukama na forumu. Obično možete da izaberete da li želite da se pretplatite na forum. Međutim, ponekad predavač može podesiti da pretplata bude obavezna. U tom slučaju svi korisnici će primati obaveštenja.';
$string['subscriptionmode'] = 'Režim pretplate';
$string['subscriptionmode_help'] = 'Kada je korisnik pretplaćen na forum, to znači da će dobijati obaveštenja o porukama na forumu.
Postoje 4 moguća načina za pretplatu:
 
* Opciona pretplata - korisnici mogu da izaberu da li žele da budu pretplaćeni na forum ili ne
* Obavezna pretplata - svi korisnici su pretplaćeni i ne mogu se odjaviti
* Automatska pretplata - svi korisnici su inicijalno pretplaćeni ali, ukoliko žele, mogu da izaberu da se odjave u bilo kom trenutku
* Pretplata onemogućena - pretplata na forum nije dozvoljena';
$string['subscriptionoptional'] = 'Opciona pretplata';
$string['subscriptions'] = 'Pretplate';
$string['tagarea_forum_posts'] = 'Postovi na forumu';
$string['tagsdeleted'] = 'Oznake foruma su obrisane';
$string['thisforumisthrottled'] = 'Ovaj forum ima ograničenje u broju poruka koje možete poslati u datom vremenskom periodu - trenutno je ovo ograničenje podešeno na {$a->blockafter} poruka unutar {$a->blockperiod}';
$string['timedhidden'] = 'Vremenski status: sakriveno od studenata';
$string['timedposts'] = 'Vremenski određeni postovi';
$string['timedvisible'] = 'Vremenski status: vidljivo svim korisnicima';
$string['timestartenderror'] = 'Kraj prikaza ne može biti podešen na datum raniji od početka prikaza';
$string['trackforum'] = 'Prati nepročitane poruke';
$string['tracking'] = 'Prati';
$string['trackingoff'] = 'Isključeno';
$string['trackingon'] = 'Обавезно';
$string['trackingoptional'] = 'Opciono';
$string['trackingtype'] = 'Praćenje pročitanih/nepročitanih porukana';
$string['trackingtype_help'] = 'Praćenje pročitanih/nepročitanih poruka na forumima i unutar diskusija, omogućava učesnicima da lako provere koje poruke nisu još videli, tako što će nove poruke biti istaknute.

Ako je podešeno  na opciono praćenje, učesnici mogu da izaberu da li će uključiti ili isključiti praćenje pročitanih/nepročitanih poruka putem linka u meniju akcija ili u bloku za administraciju, zavisno od grafičke teme (korisnici moraju, takođe, da omoguće praćenje pročitanih poruka u svojim parametrima foruma).

Ako je na nivou administracije sajta uključena opcija \'Dozvoli obavezno praćenje pročitanih/nepročitanih poruka\', onda je još jedna opcija dostupna - obavezno praćenje. To znači da je praćenje uvek uključeno, bez obzira na podešavanja korisnika.';
$string['trackreadposts_header'] = 'Praćenje foruma';
$string['unread'] = 'Nepročitano';
$string['unreadposts'] = 'Nepročitane poruke';
$string['unreadpostsnumber'] = 'Broj nepročitanih poruka: {$a}';
$string['unreadpostsone'] = '1 nepročitana poruka';
$string['unsubscribe'] = 'Odjavite se sa ovog foruma';
$string['unsubscribeall'] = 'Odjavite se sa svih foruma';
$string['unsubscribeallconfirm'] = 'Trenutno ste pretplaćeni na {$a->forums} forum/a i {$a->discussions} diskusiju/e/a. Da li zaista želite da se odjavite sa svih foruma i diskusija, i da isključite automatsku pretplatu na diskusije?';
$string['unsubscribeallconfirmdiscussions'] = 'Trenutno ste pretplaćeni na {$a->discussions} diskusiju/e/a. Da li zaista želite da se odjavite sa svih diskusija, i da isključite automatsku pretplatu na diskusije?';
$string['unsubscribeallconfirmforums'] = 'Trenutno ste pretplaćeni na {$a->forums} forum/a. Da li zaista želite da se odjavite sa svih foruma, i da isključite automatsku pretplatu na diskusije?';
$string['unsubscribealldone'] = 'Sve opcione pretplate na forume su poništene. I dalje ćete primati obaveštenja sa foruma na kojima je pretplata obavezna. Ako želite da podesite opcije vezane za obaveštenja sa foruma u korisničkom meniju izaberite opciju Parametri a zatim Parametri obaveštenja.';
$string['unsubscribeallempty'] = 'Niste pretplaćeni ni na jedan forum. Ako želite da onemogućite sva obaveštenja sa ovog servera u korisničkom meniju izaberite opciju Parametri a zatim Parametri obaveštenja.';
$string['unsubscribed'] = 'Odjavljeni ste sa ovog foruma';
$string['unsubscribediscussion'] = 'Odjavi se sa ove diskusije';
$string['unsubscribediscussionlink'] = 'Odjavite se sa ove diskusije: {$a}';
$string['unsubscribelink'] = 'Odjavite se sa ovog foruma: {$a}';
$string['unsubscribeshort'] = 'Odjavi se';
$string['usermarksread'] = 'Ručno obeležavanje pročitanih poruka';
$string['viewalldiscussions'] = 'Pogledaj sve diskusije';
$string['viewthediscussion'] = 'Pogledaj diskusiju';
$string['warnafter'] = 'Granična vrednost broja poruka za slanje upozorenja';
$string['warnafter_help'] = '<p>Polaznici mogu biti upozoreni kada se približe maksimalnom broju poruka dozvonjenih u datom vremenskom periodu. Ovo podešavanje određuje nakon koliko poruka će biti upozoreni.</p>

<p>Korisnici sa ovlašćenjem mod/forum:postwithoutthrottling su izuzeti od ovog ograničenja.</p>';
$string['warnformorepost'] = 'Upozorenje! Postoji više od jedne diskusije na ovom forumu - koristite najnoviju';
$string['yournewquestion'] = 'Vaše novo pitanje';
$string['yournewtopic'] = 'Vaša nova tema za diskusiju';
$string['yourreply'] = 'Vaš odgovor';
